/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.management.mbeans.bundles.internal;

import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.karaf.management.mbeans.bundles.internal.BlueprintListener;
import org.apache.karaf.management.mbeans.bundles.internal.BundleStateListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextEvent;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextListener;
import org.springframework.osgi.context.event.OsgiBundleContextFailedEvent;
import org.springframework.osgi.context.event.OsgiBundleContextRefreshedEvent;
import org.springframework.osgi.extender.event.BootstrappingDependencyEvent;
import org.springframework.osgi.service.importer.event.OsgiServiceDependencyEvent;
import org.springframework.osgi.service.importer.event.OsgiServiceDependencyWaitStartingEvent;

public class SpringStateListenerFactory
implements BundleStateListener.Factory {
    private BundleContext bundleContext;
    private BundleStateListener listener;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void init() {
        this.getListener();
    }

    public void destroy() throws Exception {
        if (this.listener instanceof Destroyable) {
            ((Destroyable)((Object)this.listener)).destroy();
        }
    }

    public synchronized BundleStateListener getListener() {
        if (this.listener == null) {
            this.listener = this.createListener();
        }
        return this.listener;
    }

    private BundleStateListener createListener() {
        try {
            Class<?> cl = this.getClass().getClassLoader().loadClass("org.apache.karaf.shell.osgi.SpringStateListenerFactory$SpringApplicationListener");
            return (BundleStateListener)cl.getConstructor(BundleContext.class).newInstance(this.bundleContext);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static class SpringApplicationListener
    implements OsgiBundleApplicationContextListener,
    BundleListener,
    Destroyable,
    BundleStateListener {
        private static final Logger LOG = LoggerFactory.getLogger(BlueprintListener.class);
        private final Map<Long, SpringState> states = new ConcurrentHashMap<Long, SpringState>();
        private BundleContext bundleContext;
        private ServiceRegistration registration;

        public SpringApplicationListener(BundleContext bundleContext) {
            this.bundleContext = bundleContext;
            this.bundleContext.addBundleListener((BundleListener)this);
            this.registration = this.bundleContext.registerService(OsgiBundleApplicationContextListener.class.getName(), (Object)this, new Hashtable());
        }

        public void destroy() throws Exception {
            this.bundleContext.removeBundleListener((BundleListener)this);
            this.registration.unregister();
        }

        public String getName() {
            return "Spring";
        }

        public String getDescription() {
            return "Current state of the Spring context in the Bundle";
        }

        public String getState(Bundle bundle) {
            SpringState state = this.states.get(bundle.getBundleId());
            if (state == null || bundle.getState() != 32 || state == SpringState.Unknown) {
                return null;
            }
            return state.toString();
        }

        public SpringState getSpringState(Bundle bundle) {
            SpringState state = this.states.get(bundle.getBundleId());
            if (state == null || bundle.getState() != 32) {
                state = SpringState.Unknown;
            }
            return state;
        }

        public void onOsgiApplicationEvent(OsgiBundleApplicationContextEvent event) {
            SpringState state = null;
            if (event instanceof BootstrappingDependencyEvent) {
                OsgiServiceDependencyEvent de = ((BootstrappingDependencyEvent)event).getDependencyEvent();
                if (de instanceof OsgiServiceDependencyWaitStartingEvent) {
                    state = SpringState.Waiting;
                }
            } else if (event instanceof OsgiBundleContextFailedEvent) {
                state = SpringState.Failed;
            } else if (event instanceof OsgiBundleContextRefreshedEvent) {
                state = SpringState.Started;
            }
            if (state != null) {
                LOG.debug("Spring app state changed to " + (Object)((Object)state) + " for bundle " + event.getBundle().getBundleId());
                this.states.put(event.getBundle().getBundleId(), state);
            }
        }

        public void bundleChanged(BundleEvent event) {
            if (event.getType() == 16) {
                this.states.remove(event.getBundle().getBundleId());
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum SpringState {
            Unknown,
            Waiting,
            Started,
            Failed;

        }
    }

    public static interface Destroyable {
        public void destroy() throws Exception;
    }
}

