/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.runtime;

import java.util.Collections;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.felix.http.base.internal.dispatch.MultipartConfig;
import org.apache.felix.http.base.internal.runtime.ResourceInfo;
import org.apache.felix.http.base.internal.runtime.WhiteboardServiceInfo;
import org.apache.felix.http.base.internal.util.PatternUtil;
import org.osgi.framework.ServiceReference;

public class ServletInfo
extends WhiteboardServiceInfo<Servlet> {
    private final String name;
    private final String[] patterns;
    private final String[] errorPage;
    private final boolean asyncSupported;
    private final boolean isResource;
    private final MultipartConfig multipartConfig;
    private final Map<String, String> initParams;
    private final String prefix;

    public ServletInfo(ServiceReference<Servlet> ref) {
        super(ref);
        this.name = this.getStringProperty(ref, "osgi.http.whiteboard.servlet.name");
        this.errorPage = this.getStringArrayProperty(ref, "osgi.http.whiteboard.servlet.errorPage");
        this.patterns = this.getStringArrayProperty(ref, "osgi.http.whiteboard.servlet.pattern");
        this.asyncSupported = this.getBooleanProperty(ref, "osgi.http.whiteboard.servlet.asyncSupported");
        if (this.getBooleanProperty(ref, "osgi.http.whiteboard.servlet.multipart.enabled")) {
            MultipartConfig cfg = null;
            try {
                cfg = new MultipartConfig(this.getIntProperty(ref, "osgi.http.whiteboard.servlet.multipart.fileSizeThreshold"), this.getStringProperty(ref, "osgi.http.whiteboard.servlet.multipart.location"), this.getLongProperty(ref, "osgi.http.whiteboard.servlet.multipart.maxFileSize"), this.getLongProperty(ref, "osgi.http.whiteboard.servlet.multipart.maxRequestSize"));
            }
            catch (IllegalArgumentException iae) {
                cfg = MultipartConfig.INVALID_CONFIG;
            }
            this.multipartConfig = cfg;
        } else {
            this.multipartConfig = null;
        }
        this.initParams = this.getInitParams(ref, "servlet.init.");
        this.isResource = false;
        this.prefix = null;
    }

    public ServletInfo(ResourceInfo resource) {
        super(ServletInfo.getRef(resource.getServiceReference()));
        this.name = null;
        this.patterns = resource.getPatterns();
        this.errorPage = null;
        this.asyncSupported = false;
        this.multipartConfig = null;
        this.initParams = Collections.emptyMap();
        this.isResource = true;
        this.prefix = resource.getPrefix();
    }

    private Integer getIntProperty(ServiceReference<Servlet> ref, String key) {
        Object value = ref.getProperty(key);
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value != null) {
            throw new IllegalArgumentException();
        }
        return null;
    }

    private long getLongProperty(ServiceReference<Servlet> ref, String key) {
        Object value = ref.getProperty(key);
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value != null) {
            throw new IllegalArgumentException();
        }
        return -1L;
    }

    private static ServiceReference getRef(ServiceReference ref) {
        return ref;
    }

    public ServletInfo(String name, String pattern, Map<String, String> initParams) {
        super(Integer.MAX_VALUE);
        this.name = name;
        this.patterns = new String[]{pattern};
        this.initParams = Collections.unmodifiableMap(initParams);
        this.asyncSupported = true;
        this.multipartConfig = MultipartConfig.DEFAULT_CONFIG;
        this.errorPage = null;
        this.isResource = false;
        this.prefix = null;
    }

    @Override
    public boolean isValid() {
        boolean valid;
        boolean bl = valid = super.isValid() && (!this.isEmpty(this.patterns) || !this.isEmpty(this.errorPage) || !this.isEmpty(this.name)) && this.multipartConfig != MultipartConfig.INVALID_CONFIG;
        if (valid && this.patterns != null) {
            for (String p : this.patterns) {
                if (PatternUtil.isValidPattern(p)) continue;
                valid = false;
                break;
            }
        }
        return valid;
    }

    public String getName() {
        return this.name;
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    public String[] getErrorPage() {
        return this.errorPage;
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public Map<String, String> getInitParameters() {
        return this.initParams;
    }

    public boolean isResource() {
        return this.isResource;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public MultipartConfig getMultipartConfig() {
        return this.multipartConfig;
    }
}

