/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.runtime.dto;

import java.util.Collection;
import java.util.HashMap;
import org.apache.felix.http.base.internal.runtime.dto.RegistryRuntime;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.service.http.runtime.HttpServiceRuntime;
import org.osgi.service.http.runtime.dto.FailedErrorPageDTO;
import org.osgi.service.http.runtime.dto.FailedFilterDTO;
import org.osgi.service.http.runtime.dto.FailedListenerDTO;
import org.osgi.service.http.runtime.dto.FailedPreprocessorDTO;
import org.osgi.service.http.runtime.dto.FailedResourceDTO;
import org.osgi.service.http.runtime.dto.FailedServletContextDTO;
import org.osgi.service.http.runtime.dto.FailedServletDTO;
import org.osgi.service.http.runtime.dto.PreprocessorDTO;
import org.osgi.service.http.runtime.dto.RuntimeDTO;
import org.osgi.service.http.runtime.dto.ServletContextDTO;

public final class RuntimeDTOBuilder {
    private final RegistryRuntime registry;
    private final ServiceReference<HttpServiceRuntime> serviceReference;

    public RuntimeDTOBuilder(RegistryRuntime registry, ServiceReference<HttpServiceRuntime> ref) {
        this.registry = registry;
        this.serviceReference = ref;
    }

    public RuntimeDTO build() {
        RuntimeDTO runtimeDTO = new RuntimeDTO();
        runtimeDTO.serviceDTO = this.createServiceDTO();
        runtimeDTO.servletContextDTOs = this.createContextDTOs();
        runtimeDTO.preprocessorDTOs = this.createPreprocessorDTOs();
        runtimeDTO.failedErrorPageDTOs = this.registry.getFailedDTOHolder().failedErrorPageDTOs.toArray(new FailedErrorPageDTO[this.registry.getFailedDTOHolder().failedErrorPageDTOs.size()]);
        runtimeDTO.failedFilterDTOs = this.registry.getFailedDTOHolder().failedFilterDTOs.toArray(new FailedFilterDTO[this.registry.getFailedDTOHolder().failedFilterDTOs.size()]);
        runtimeDTO.failedListenerDTOs = this.registry.getFailedDTOHolder().failedListenerDTOs.toArray(new FailedListenerDTO[this.registry.getFailedDTOHolder().failedListenerDTOs.size()]);
        runtimeDTO.failedResourceDTOs = this.registry.getFailedDTOHolder().failedResourceDTOs.toArray(new FailedResourceDTO[this.registry.getFailedDTOHolder().failedResourceDTOs.size()]);
        runtimeDTO.failedServletContextDTOs = this.registry.getFailedDTOHolder().failedServletContextDTOs.toArray(new FailedServletContextDTO[this.registry.getFailedDTOHolder().failedServletContextDTOs.size()]);
        runtimeDTO.failedServletDTOs = this.registry.getFailedDTOHolder().failedServletDTOs.toArray(new FailedServletDTO[this.registry.getFailedDTOHolder().failedServletDTOs.size()]);
        runtimeDTO.failedPreprocessorDTOs = this.registry.getFailedDTOHolder().failedPreprocessorDTOs.toArray(new FailedPreprocessorDTO[this.registry.getFailedDTOHolder().failedPreprocessorDTOs.size()]);
        return runtimeDTO;
    }

    private ServiceReferenceDTO createServiceDTO() {
        ServiceReferenceDTO dto = new ServiceReferenceDTO();
        dto.bundle = this.serviceReference.getBundle().getBundleId();
        dto.id = (Long)this.serviceReference.getProperty("service.id");
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (String key : this.serviceReference.getPropertyKeys()) {
            props.put(key, this.serviceReference.getProperty(key));
        }
        dto.properties = props;
        Bundle[] ubs = this.serviceReference.getUsingBundles();
        if (ubs == null) {
            dto.usingBundles = new long[0];
        } else {
            dto.usingBundles = new long[ubs.length];
            for (int j = 0; j < ubs.length; ++j) {
                dto.usingBundles[j] = ubs[j].getBundleId();
            }
        }
        return dto;
    }

    private ServletContextDTO[] createContextDTOs() {
        Collection<ServletContextDTO> contexts = this.registry.getServletContextDTOs();
        return contexts.toArray(new ServletContextDTO[contexts.size()]);
    }

    private PreprocessorDTO[] createPreprocessorDTOs() {
        Collection<PreprocessorDTO> dtos = this.registry.getPreprocessorDTOs();
        return dtos.toArray(new PreprocessorDTO[dtos.size()]);
    }
}

