/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.publickey;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.jaas.boot.principal.GroupPrincipal;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.AbstractKarafLoginModule;
import org.apache.karaf.jaas.modules.encryption.BasicEncryption;
import org.apache.karaf.jaas.modules.publickey.PublickeyCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublickeyLoginModule
extends AbstractKarafLoginModule {
    private final Logger LOG = LoggerFactory.getLogger(PublickeyLoginModule.class);
    private static final String USERS_FILE = "users";
    private String usersFile;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, options);
        this.usersFile = options.get(USERS_FILE) + "";
        if (this.debug) {
            this.LOG.debug("Initialized debug=" + this.debug + " usersFile=" + this.usersFile);
        }
    }

    @Override
    public boolean login() throws LoginException {
        Properties users;
        File f = new File(this.usersFile);
        try {
            users = new Properties(f);
        }
        catch (IOException ioe) {
            throw new LoginException("Unable to load user properties file " + f);
        }
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PublickeyCallback()};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to obtain information from user");
        }
        String user = ((NameCallback)callbacks[0]).getName();
        if (user == null) {
            throw new FailedLoginException("Unable to retrieve user name");
        }
        PublicKey key = ((PublickeyCallback)callbacks[1]).getPublicKey();
        if (key == null) {
            throw new FailedLoginException("Unable to retrieve public key");
        }
        String userInfos = null;
        try {
            userInfos = (String)users.get(user);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (userInfos == null) {
            if (!this.detailedLoginExcepion) {
                throw new FailedLoginException("login failed");
            }
            throw new FailedLoginException("User " + user + " does not exist");
        }
        String[] infos = userInfos.split(",");
        String storedKey = infos[0];
        if (!PublickeyLoginModule.getString(key).equals(storedKey)) {
            if (!this.detailedLoginExcepion) {
                throw new FailedLoginException("login failed");
            }
            throw new FailedLoginException("Public key for " + user + " does not match");
        }
        this.principals = new HashSet();
        this.principals.add(new UserPrincipal(user));
        for (int i = 1; i < infos.length; ++i) {
            if (infos[i].trim().startsWith("_g_:")) {
                this.principals.add(new GroupPrincipal(infos[i].trim().substring("_g_:".length())));
                String groupInfo = (String)users.get(infos[i].trim());
                if (groupInfo == null) continue;
                String[] roles = groupInfo.split(",");
                for (int j = 1; j < roles.length; ++j) {
                    this.principals.add(new RolePrincipal(roles[j].trim()));
                }
                continue;
            }
            this.principals.add(new RolePrincipal(infos[i].trim()));
        }
        users.clear();
        if (this.debug) {
            this.LOG.debug("Successfully logged in " + user);
        }
        this.succeeded = true;
        return true;
    }

    public static String getString(PublicKey key) throws FailedLoginException {
        try {
            if (key instanceof DSAPublicKey) {
                DSAPublicKey dsa = (DSAPublicKey)key;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                PublickeyLoginModule.write(dos, "ssh-dss");
                PublickeyLoginModule.write(dos, dsa.getParams().getP());
                PublickeyLoginModule.write(dos, dsa.getParams().getQ());
                PublickeyLoginModule.write(dos, dsa.getParams().getG());
                PublickeyLoginModule.write(dos, dsa.getY());
                dos.close();
                return BasicEncryption.base64Encode(baos.toByteArray());
            }
            if (key instanceof RSAKey) {
                RSAPublicKey rsa = (RSAPublicKey)key;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                PublickeyLoginModule.write(dos, "ssh-rsa");
                PublickeyLoginModule.write(dos, rsa.getPublicExponent());
                PublickeyLoginModule.write(dos, rsa.getModulus());
                dos.close();
                return BasicEncryption.base64Encode(baos.toByteArray());
            }
            throw new FailedLoginException("Unsupported key type " + key.getClass().toString());
        }
        catch (IOException e) {
            throw new FailedLoginException("Unable to check public key");
        }
    }

    private static void write(DataOutputStream dos, BigInteger integer) throws IOException {
        byte[] data = integer.toByteArray();
        dos.writeInt(data.length);
        dos.write(data, 0, data.length);
    }

    private static void write(DataOutputStream dos, String str) throws IOException {
        byte[] data = str.getBytes();
        dos.writeInt(data.length);
        dos.write(data);
    }
}

