/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.commons.handler;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import org.ops4j.pax.url.commons.handler.ConnectionFactory;
import org.ops4j.pax.url.commons.handler.OptionalConfigAdminHelper;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.ops4j.lang.NullArgumentException;
import shaded.org.ops4j.pax.swissbox.property.BundleContextPropertyResolver;
import shaded.org.ops4j.util.property.PropertyResolver;

public class HandlerActivator<T>
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(HandlerActivator.class);
    private final String[] m_protocols;
    private final String m_pid;
    private final ConnectionFactory<T> m_connectionFactory;
    private BundleContext m_bundleContext;
    private PropertyResolver m_propertyResolver;
    private T m_configuration;
    private ServiceRegistration m_handlerReg;
    private ServiceRegistration m_managedServiceReg;

    public HandlerActivator(String[] protocols, String pid, ConnectionFactory<T> connectionFactory) {
        NullArgumentException.validateNotNull(protocols, "Protocols");
        NullArgumentException.validateNotNull(pid, "PID");
        NullArgumentException.validateNotNull(connectionFactory, "Connection factory");
        this.m_protocols = protocols;
        this.m_pid = pid;
        this.m_connectionFactory = connectionFactory;
    }

    public void start(BundleContext bundleContext) {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        this.m_bundleContext = bundleContext;
        this.m_propertyResolver = new BundleContextPropertyResolver(bundleContext);
        this.m_configuration = this.m_connectionFactory.createConfiguration(this.m_propertyResolver);
        this.registerHandler();
        this.registerManagedService();
        LOG.debug("Handler for protocols " + Arrays.deepToString(this.m_protocols) + " started");
    }

    public void stop(BundleContext bundleContext) {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        if (this.m_handlerReg != null) {
            this.m_handlerReg.unregister();
            this.m_handlerReg = null;
        }
        if (this.m_managedServiceReg != null) {
            this.m_managedServiceReg.unregister();
            this.m_managedServiceReg = null;
        }
        this.m_bundleContext = null;
        LOG.debug("Handler for protocols " + Arrays.deepToString(this.m_protocols) + " stopped");
    }

    private void registerHandler() {
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        ((Dictionary)props).put("url.handler.protocol", this.m_protocols);
        this.m_handlerReg = this.m_bundleContext.registerService(URLStreamHandlerService.class.getName(), (Object)new Handler(), props);
    }

    private void registerManagedService() {
        try {
            this.m_managedServiceReg = OptionalConfigAdminHelper.registerManagedService(this.m_pid, this.m_bundleContext, this);
        }
        catch (Throwable ignore) {
            this.setResolver(new BundleContextPropertyResolver(this.m_bundleContext));
            this.m_managedServiceReg = null;
        }
    }

    synchronized PropertyResolver getResolver() {
        return this.m_propertyResolver;
    }

    synchronized void setResolver(PropertyResolver propertyResolver) {
        this.m_propertyResolver = propertyResolver;
        this.m_configuration = this.m_connectionFactory.createConfiguration(propertyResolver);
    }

    private class Handler
    extends AbstractURLStreamHandlerService {
        private Handler() {
        }

        public URLConnection openConnection(URL url) throws IOException {
            return HandlerActivator.this.m_connectionFactory.createConection(HandlerActivator.this.m_bundleContext, url, HandlerActivator.this.m_configuration);
        }
    }
}

