/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.osgi;

import java.util.GregorianCalendar;
import jline.console.ConsoleReader;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;

@Command(scope="osgi", name="shutdown", description="Shutdown the Karaf container.")
public class Shutdown
extends OsgiCommandSupport {
    @Option(name="-f", aliases={"--force"}, description="Force the shutdown without confirmation message.", required=false, multiValued=false)
    boolean force = false;
    @Argument(name="time", index=0, description="Shutdown after a specified delay. The time argument can have different formats. First, it can be an abolute time in the format hh:mm, in which hh is the hour (1 or 2 digits) and mm is the minute of the hour (in two digits). Second, it can be in the format m (or +m), in which m is the number of minutes to wait. The word now is an alias for 0.", required=false, multiValued=false)
    String time;

    protected Object doExecute() throws Exception {
        long sleep = 0L;
        if (this.time != null && !this.time.equals("now")) {
            if (this.time.contains(":")) {
                String[] strings = this.time.split(":");
                if (strings.length != 2) {
                    System.err.println("Time " + this.time + " is not valid (not in hh:mm format)");
                    return null;
                }
                int hour = Integer.parseInt(strings[0]);
                int minute = Integer.parseInt(strings[1]);
                if (hour < 0 || hour > 23) {
                    System.err.println("Time " + this.time + " is not valid (hour " + hour + " is not between 0 and 23)");
                    return null;
                }
                if (minute < 0 || minute > 59) {
                    System.err.println("Time " + this.time + " is not valid (minute " + minute + " is not between 0 and 59)");
                    return null;
                }
                GregorianCalendar currentDate = new GregorianCalendar();
                GregorianCalendar shutdownDate = new GregorianCalendar(currentDate.get(1), currentDate.get(2), currentDate.get(5), hour, minute);
                if (shutdownDate.before(currentDate)) {
                    shutdownDate.set(5, shutdownDate.get(5) + 1);
                }
                sleep = shutdownDate.getTimeInMillis() - currentDate.getTimeInMillis();
            } else {
                if (this.time.startsWith("+")) {
                    this.time = this.time.substring(1);
                }
                try {
                    sleep = Long.parseLong(this.time) * 60L * 1000L;
                }
                catch (Exception e) {
                    System.err.println("Time " + this.time + " is not valid");
                    return null;
                }
            }
        }
        if (this.force) {
            this.shutdown(sleep);
            return null;
        }
        String karafName = System.getProperty("karaf.name");
        String msg = String.format("Confirm: shutdown instance %s (yes/no): ", karafName);
        ConsoleReader reader = (ConsoleReader)this.session.get(".jline.reader");
        String str = reader.readLine(msg);
        if (str.equalsIgnoreCase("yes")) {
            this.shutdown(sleep);
        }
        return null;
    }

    private void shutdown(final long sleep) {
        new Thread(){

            public void run() {
                try {
                    if (sleep > 0L) {
                        System.err.println("Shutdown in " + sleep / 1000L / 60L + " minute(s)");
                    }
                    Thread.sleep(sleep);
                    Shutdown.this.getBundleContext().getBundle(0L).stop();
                }
                catch (Exception e) {
                    Shutdown.this.log.error("Error when shutting down", (Throwable)e);
                }
            }
        }.start();
    }
}

