/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectLauncher;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectTester {
    final Project project;
    final Collection<Container> testbundles;
    final ProjectLauncher launcher;
    final List<String> tests = new ArrayList<String>();
    File reportDir;
    boolean continuous = true;
    File cwd;

    public ProjectTester(Project project) throws Exception {
        this.project = project;
        this.launcher = project.getProjectLauncher();
        this.testbundles = project.getTestpath();
        for (Container c : this.testbundles) {
            this.launcher.addClasspath(c);
        }
        this.reportDir = new File(project.getTarget(), project.getProperty("test-reports", "test-reports"));
    }

    public ProjectLauncher getProjectLauncher() {
        return this.launcher;
    }

    public void addTest(String test) {
        this.tests.add(test);
    }

    public Collection<String> getTests() {
        return this.tests;
    }

    public Collection<File> getReports() {
        ArrayList<File> reports = new ArrayList<File>();
        for (File report : this.reportDir.listFiles()) {
            if (!report.isFile()) continue;
            reports.add(report);
        }
        return reports;
    }

    public File getReportDir() {
        return this.reportDir;
    }

    public void setReportDir(File reportDir) {
        this.reportDir = reportDir;
    }

    public Project getProject() {
        return this.project;
    }

    public boolean getContinuous() {
        return this.continuous;
    }

    public void setContinuous(boolean b) {
        this.continuous = b;
    }

    public File getCwd() {
        return this.cwd;
    }

    public void setCwd(File dir) {
        this.cwd = dir;
    }

    public boolean prepare() throws Exception {
        if (!this.reportDir.exists() && !this.reportDir.mkdirs()) {
            throw new IOException("Could not create directory " + this.reportDir);
        }
        for (File file : this.reportDir.listFiles()) {
            file.delete();
        }
        return true;
    }

    public abstract int test() throws Exception;
}

