/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.diagnostic.core.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.karaf.diagnostic.core.DumpDestination;

public class DirectoryDumpDestination
implements DumpDestination {
    private File directory;

    public DirectoryDumpDestination(File file) {
        this.directory = file;
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public OutputStream add(String name) throws Exception {
        File destination = new File(this.directory, name);
        if (name.contains("/") || name.contains("\\")) {
            destination.getParentFile().mkdirs();
        }
        return new FileOutputStream(destination);
    }

    public void save() throws Exception {
    }

    public String toString() {
        return "directory: " + this.directory;
    }
}

