/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.command;

import java.util.List;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.jaas.command.JaasCommandSupport;
import org.apache.karaf.jaas.config.JaasRealm;
import org.apache.karaf.jaas.modules.BackingEngine;

@Command(scope="jaas", name="realms", description="List JAAS Realms")
public class ListRealmsCommand
extends JaasCommandSupport {
    private static final String REALM_LIST_FORMAT = "%5s %-20s %-80s";
    @Option(name="-h", aliases={"--hidden"}, description="Show hidden realms", required=false, multiValued=false)
    boolean hidden;

    protected Object doExecute(BackingEngine engine) throws Exception {
        return null;
    }

    protected Object doExecute() throws Exception {
        List<JaasRealm> realms = this.getRealms(this.hidden);
        if (realms != null && realms.size() > 0) {
            System.out.println(String.format(REALM_LIST_FORMAT, "Index", "Realm", "Module Class"));
            int index = 1;
            for (JaasRealm realm : realms) {
                String realmName = realm.getName();
                AppConfigurationEntry[] entries = realm.getEntries();
                if (entries != null && entries.length > 0) {
                    for (int i = 0; i < entries.length; ++i) {
                        String moduleClass = (String)entries[i].getOptions().get("org.apache.karaf.jaas.module");
                        System.out.println(String.format(REALM_LIST_FORMAT, index++, realmName, moduleClass));
                    }
                    continue;
                }
                System.out.println(String.format(REALM_LIST_FORMAT, realmName, "No JAAS Login Module found for JAAS Realm"));
            }
        } else {
            System.err.println("No realm found");
        }
        return null;
    }
}

