/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.config;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.TreeMap;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.config.ConfigCommandSupport;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="config", name="list", description="Lists existing configurations.")
public class ListCommand
extends ConfigCommandSupport {
    @Argument(index=0, name="query", description="Query in LDAP syntax. Example: \"(service.pid=org.apache.karaf.log)\"", required=false, multiValued=false)
    String query;

    protected void doExecute(ConfigurationAdmin admin) throws Exception {
        Configuration[] configs = admin.listConfigurations(this.query);
        if (configs != null) {
            TreeMap<String, Configuration> sortedConfigs = new TreeMap<String, Configuration>();
            for (Configuration config : configs) {
                sortedConfigs.put(config.getPid(), config);
            }
            for (String pid : sortedConfigs.keySet()) {
                Configuration config = (Configuration)sortedConfigs.get(pid);
                System.out.println("----------------------------------------------------------------");
                System.out.println("Pid:            " + config.getPid());
                if (config.getFactoryPid() != null) {
                    System.out.println("FactoryPid:     " + config.getFactoryPid());
                }
                System.out.println("BundleLocation: " + config.getBundleLocation());
                if (config.getProperties() == null) continue;
                System.out.println("Properties:");
                Dictionary props = config.getProperties();
                TreeMap sortedProps = new TreeMap();
                Enumeration e = props.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    sortedProps.put(key.toString(), props.get(key));
                }
                for (Object key : sortedProps.keySet()) {
                    System.out.println("   " + key + " = " + sortedProps.get(key));
                }
            }
        }
    }
}

