/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.converter.DefaultConverter;
import org.apache.felix.gogo.commands.converter.GenericType;
import org.apache.felix.gogo.commands.converter.ReifiedType;
import org.apache.karaf.shell.console.AbstractAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Command(scope="shell", name="new", description="Creates a new java object.")
public class NewAction
extends AbstractAction {
    @Argument(name="class", index=0, multiValued=false, required=true, description="The object class")
    Class clazz;
    @Argument(name="args", index=1, multiValued=true, required=false, description="Constructor arguments")
    List<Object> args;
    boolean reorderArguments;
    protected DefaultConverter converter = new DefaultConverter((Object)((Object)((Object)this)).getClass().getClassLoader());
    private static final Map<Class, Class> primitives = new HashMap<Class, Class>();
    private static Object UNMATCHED;

    protected Object doExecute() throws Exception {
        if (this.args == null) {
            this.args = Collections.emptyList();
        }
        if (this.clazz.isArray()) {
            Object obj = Array.newInstance(this.clazz.getComponentType(), this.args.size());
            for (int i = 0; i < this.args.size(); ++i) {
                Array.set(obj, i, this.convert(this.args.get(i), this.clazz.getComponentType()));
            }
            return obj;
        }
        Map<Constructor, List<Object>> matches = this.findMatchingConstructors(this.clazz, this.args, Arrays.asList(new ReifiedType[this.args.size()]));
        if (matches.size() == 1) {
            try {
                Map.Entry<Constructor, List<Object>> match = matches.entrySet().iterator().next();
                return this.newInstance(match.getKey(), match.getValue().toArray());
            }
            catch (Throwable e) {
                throw new Exception("Error when instantiating object of class " + this.clazz.getName(), NewAction.getRealCause(e));
            }
        }
        if (matches.size() == 0) {
            throw new Exception("Unable to find a matching constructor on class " + this.clazz.getName() + " for arguments " + this.args + " when instantiating object.");
        }
        throw new Exception("Multiple matching constructors found on class " + this.clazz.getName() + " for arguments " + this.args + " when instantiating object: " + matches.keySet());
    }

    private Object newInstance(Constructor constructor, Object ... args) throws Exception {
        return constructor.newInstance(args);
    }

    private Map<Constructor, List<Object>> findMatchingConstructors(Class type, List<Object> args, List<ReifiedType> types) {
        GenericType argType;
        int i;
        List<Object> match;
        boolean found;
        HashMap<Constructor, List<Object>> nmatches;
        HashMap<Constructor, List<Object>> matches = new HashMap<Constructor, List<Object>>();
        ArrayList constructors = new ArrayList(Arrays.asList(type.getConstructors()));
        Iterator it = constructors.iterator();
        while (it.hasNext()) {
            if (((Constructor)it.next()).getParameterTypes().length == args.size()) continue;
            it.remove();
        }
        if (matches.size() != 1) {
            nmatches = new HashMap<Constructor, List<Object>>();
            for (Constructor constructor : constructors) {
                found = true;
                match = new ArrayList();
                for (i = 0; i < args.size(); ++i) {
                    argType = new GenericType(constructor.getGenericParameterTypes()[i]);
                    if (types.get(i) != null && !argType.getRawClass().equals(types.get(i).getRawClass())) {
                        found = false;
                        break;
                    }
                    if (!NewAction.isAssignable(args.get(i), (ReifiedType)argType)) {
                        found = false;
                        break;
                    }
                    try {
                        match.add(this.convert(args.get(i), constructor.getGenericParameterTypes()[i]));
                        continue;
                    }
                    catch (Throwable t) {
                        found = false;
                        break;
                    }
                }
                if (!found) continue;
                nmatches.put(constructor, match);
            }
            if (nmatches.size() > 0) {
                matches = nmatches;
            }
        }
        if (matches.size() != 1) {
            nmatches = new HashMap();
            for (Constructor constructor : constructors) {
                found = true;
                match = new ArrayList();
                for (i = 0; i < args.size(); ++i) {
                    argType = new GenericType(constructor.getGenericParameterTypes()[i]);
                    if (types.get(i) != null && !argType.getRawClass().equals(types.get(i).getRawClass())) {
                        found = false;
                        break;
                    }
                    try {
                        Object val = this.convert(args.get(i), (ReifiedType)argType);
                        match.add(val);
                        continue;
                    }
                    catch (Throwable t) {
                        found = false;
                        break;
                    }
                }
                if (!found) continue;
                nmatches.put(constructor, match);
            }
            if (nmatches.size() > 0) {
                matches = nmatches;
            }
        }
        if (matches.size() != 1 && this.reorderArguments && args.size() > 1) {
            nmatches = new HashMap();
            for (Constructor constructor : constructors) {
                ArgumentMatcher matcher = new ArgumentMatcher(constructor.getGenericParameterTypes(), false);
                match = matcher.match(args, types);
                if (match == null) continue;
                nmatches.put(constructor, match);
            }
            if (nmatches.size() > 0) {
                matches = nmatches;
            }
        }
        if (matches.size() != 1 && this.reorderArguments && args.size() > 1) {
            nmatches = new HashMap();
            for (Constructor constructor : constructors) {
                ArgumentMatcher matcher = new ArgumentMatcher(constructor.getGenericParameterTypes(), true);
                match = matcher.match(args, types);
                if (match == null) continue;
                nmatches.put(constructor, match);
            }
            if (nmatches.size() > 0) {
                matches = nmatches;
            }
        }
        return matches;
    }

    protected Object convert(Object obj, Type type) throws Exception {
        return this.converter.convert(obj, (ReifiedType)new GenericType(type));
    }

    protected Object convert(Object obj, ReifiedType type) throws Exception {
        return this.converter.convert(obj, type);
    }

    public static boolean isAssignable(Object source, ReifiedType target) {
        return source == null || target.size() == 0 && NewAction.unwrap(target.getRawClass()).isAssignableFrom(NewAction.unwrap(source.getClass()));
    }

    private static Class unwrap(Class c) {
        Class u = primitives.get(c);
        return u != null ? u : c;
    }

    public static Throwable getRealCause(Throwable t) {
        if (t instanceof InvocationTargetException && t.getCause() != null) {
            return t.getCause();
        }
        return t;
    }

    static {
        primitives.put(Byte.TYPE, Byte.class);
        primitives.put(Short.TYPE, Short.class);
        primitives.put(Character.TYPE, Character.class);
        primitives.put(Integer.TYPE, Integer.class);
        primitives.put(Long.TYPE, Long.class);
        primitives.put(Float.TYPE, Float.class);
        primitives.put(Double.TYPE, Double.class);
        primitives.put(Boolean.TYPE, Boolean.class);
        UNMATCHED = new Object();
    }

    private static class TypeEntry {
        private final ReifiedType type;
        private Object argument;

        public TypeEntry(ReifiedType type) {
            this.type = type;
            this.argument = UNMATCHED;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArgumentMatcher {
        private List<TypeEntry> entries = new ArrayList<TypeEntry>();
        private boolean convert;

        public ArgumentMatcher(Type[] types, boolean convert) {
            for (Type type : types) {
                this.entries.add(new TypeEntry((ReifiedType)new GenericType(type)));
            }
            this.convert = convert;
        }

        public List<Object> match(List<Object> arguments, List<ReifiedType> forcedTypes) {
            if (this.find(arguments, forcedTypes)) {
                return this.getArguments();
            }
            return null;
        }

        private List<Object> getArguments() {
            ArrayList<Object> list = new ArrayList<Object>();
            for (TypeEntry entry : this.entries) {
                if (entry.argument == UNMATCHED) {
                    throw new RuntimeException("There are unmatched types");
                }
                list.add(entry.argument);
            }
            return list;
        }

        private boolean find(List<Object> arguments, List<ReifiedType> forcedTypes) {
            if (this.entries.size() == arguments.size()) {
                boolean matched = true;
                for (int i = 0; i < arguments.size() && matched; ++i) {
                    matched = this.find(arguments.get(i), forcedTypes.get(i));
                }
                return matched;
            }
            return false;
        }

        private boolean find(Object arg, ReifiedType forcedType) {
            for (TypeEntry entry : this.entries) {
                Object val;
                block8: {
                    val = arg;
                    if (entry.argument != UNMATCHED) continue;
                    if (forcedType != null) {
                        if (!forcedType.equals(entry.type)) {
                            continue;
                        }
                    } else if (arg != null) {
                        if (this.convert) {
                            try {
                                val = NewAction.this.convert(arg, entry.type);
                                break block8;
                            }
                            catch (Throwable t) {
                                continue;
                            }
                        }
                        if (!NewAction.isAssignable(arg, entry.type)) continue;
                    }
                }
                entry.argument = val;
                return true;
            }
            return false;
        }
    }
}

