/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.WriteResource;
import aQute.libg.command.Command;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class CommandResource
extends WriteResource {
    final long lastModified;
    final Builder domain;
    final String command;
    final File wd;

    public CommandResource(String command, Builder domain, long lastModified, File wd) {
        this.lastModified = lastModified;
        this.domain = domain;
        this.command = command;
        this.wd = wd;
    }

    public void write(OutputStream out) throws IOException, Exception {
        StringBuilder errors = new StringBuilder();
        StringBuilder stdout = new StringBuilder();
        this.domain.trace("executing command %s", this.command);
        Command cmd = new Command("sh");
        cmd.setCwd(this.wd);
        cmd.inherit();
        String oldpath = cmd.var("PATH");
        String path = this.domain.getProperty("-PATH");
        if (path != null) {
            path = path.replaceAll("\\s*,\\s*", File.pathSeparator);
            path = path.replaceAll("\\$\\{@\\}", oldpath);
            cmd.var("PATH", path);
            this.domain.trace("PATH: %s", path);
        }
        OutputStreamWriter osw = new OutputStreamWriter(out, "UTF-8");
        int result = cmd.execute(this.command, (Appendable)stdout, (Appendable)errors);
        osw.append(stdout);
        osw.flush();
        if (result != 0) {
            throw new Exception("executing command failed" + this.command + "\n" + stdout + "\n" + errors);
        }
    }

    public long lastModified() {
        return this.lastModified;
    }
}

