/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.bnd.differ.Baseline;
import aQute.bnd.differ.DiffPluginImpl;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Jar;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.Strategy;
import aQute.bnd.version.Version;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectBuilder
extends Builder {
    private final DiffPluginImpl differ = new DiffPluginImpl();
    Project project;
    boolean initialized;

    public ProjectBuilder(Project project) {
        super(project);
        this.project = project;
    }

    public ProjectBuilder(ProjectBuilder builder) {
        super(builder);
        this.project = builder.project;
    }

    @Override
    public long lastModified() {
        return Math.max(this.project.lastModified(), super.lastModified());
    }

    @Override
    protected Object[] getMacroDomains() {
        return new Object[]{this.project, this.project.getWorkspace()};
    }

    @Override
    public Builder getSubBuilder() throws Exception {
        return this.project.getBuilder(this);
    }

    public Project getProject() {
        return this.project;
    }

    @Override
    public void init() {
        try {
            if (!this.initialized) {
                this.initialized = true;
                for (Container container : this.project.getClasspath()) {
                    this.addClasspath(container.getFile());
                }
                for (Container container : this.project.getBuildpath()) {
                    this.addClasspath(container.getFile());
                }
                for (Container container : this.project.getBootclasspath()) {
                    this.addClasspath(container.getFile());
                }
                for (File file : this.project.getAllsourcepath()) {
                    this.addSourcepath(file);
                }
            }
        }
        catch (Exception e) {
            this.msgs.Unexpected_Error_("ProjectBuilder init", e);
        }
    }

    @Override
    public List<Jar> getClasspath() {
        this.init();
        return super.getClasspath();
    }

    @Override
    protected void changedFile(File f) {
        this.project.getWorkspace().changedFile(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doBaseline(Jar dot) throws Exception {
        Jar jar = this.getBaselineJar(false);
        if (jar == null) {
            return;
        }
        try {
            Baseline baseline = new Baseline(this, this.differ);
            Set<Baseline.Info> infos = baseline.baseline(dot, jar, null);
            for (Baseline.Info info : infos) {
                if (!info.mismatch) continue;
                this.error("%s %-50s %-10s %-10s %-10s %-10s %-10s\n", new Object[]{Character.valueOf(info.mismatch ? (char)'*' : ' '), info.packageName, info.packageDiff.getDelta(), info.newerVersion, info.olderVersion, info.suggestedVersion, info.suggestedIfProviders == null ? "-" : info.suggestedIfProviders});
            }
        }
        finally {
            jar.close();
        }
    }

    public Jar getBaselineJar(boolean fallback) throws Exception {
        File baselineFile;
        block5: {
            String baseline;
            block4: {
                baseline = this.getProperty("-baseline");
                String baselineRepo = this.getProperty("-baselinerepo");
                if (!(baseline != null && baseline.trim().length() != 0 || baselineRepo != null && baselineRepo.trim().length() != 0 || fallback)) {
                    return null;
                }
                baselineFile = null;
                if (baseline != null && baseline.trim().length() != 0) break block4;
                baselineFile = this.getBaselineFromRepo(fallback);
                if (baselineFile == null) break block5;
                this.trace("baseline %s", baselineFile.getName());
                break block5;
            }
            this.trace("baseline %s", baseline);
            Collection<Container> bundles = this.project.getBundles(Strategy.LOWEST, baseline);
            for (Container c : bundles) {
                if (c.getError() != null || c.getFile() == null) {
                    this.error("Erroneous baseline bundle %s", c);
                    continue;
                }
                baselineFile = c.getFile();
                break;
            }
        }
        if (fallback && baselineFile == null) {
            return new Jar(".");
        }
        return new Jar(baselineFile);
    }

    private File getBaselineFromRepo(boolean fallback) throws Exception {
        String repoName = this.getProperty("-baselinerepo");
        if (repoName == null && !fallback) {
            return null;
        }
        if (repoName == null && (repoName = this.getProperty("-releaserepo")) == null) {
            return null;
        }
        List<RepositoryPlugin> repos = this.getPlugins(RepositoryPlugin.class);
        for (RepositoryPlugin repo : repos) {
            if (!repoName.equals(repo.getName())) continue;
            SortedSet<Version> versions = repo.versions(this.getBsn());
            if (versions.isEmpty()) break;
            return repo.get(this.getBsn(), versions.last(), null, new RepositoryPlugin.DownloadListener[0]);
        }
        return null;
    }

    public Jar getBaselineJar() throws Exception {
        return this.getBaselineJar(true);
    }
}

