/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.ext;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.blueprint.ComponentDefinitionRegistryProcessor;
import org.apache.aries.blueprint.PassThroughMetadata;
import org.apache.aries.blueprint.mutable.MutableBeanArgument;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableBeanProperty;
import org.apache.aries.blueprint.mutable.MutableCollectionMetadata;
import org.apache.aries.blueprint.mutable.MutableMapEntry;
import org.apache.aries.blueprint.mutable.MutableMapMetadata;
import org.apache.aries.blueprint.mutable.MutablePropsMetadata;
import org.apache.aries.blueprint.mutable.MutableReferenceListener;
import org.apache.aries.blueprint.mutable.MutableRegistrationListener;
import org.apache.aries.blueprint.mutable.MutableServiceMetadata;
import org.apache.aries.blueprint.mutable.MutableServiceReferenceMetadata;
import org.osgi.framework.Bundle;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.BeanArgument;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.CollectionMetadata;
import org.osgi.service.blueprint.reflect.MapEntry;
import org.osgi.service.blueprint.reflect.MapMetadata;
import org.osgi.service.blueprint.reflect.Metadata;
import org.osgi.service.blueprint.reflect.NonNullMetadata;
import org.osgi.service.blueprint.reflect.PropsMetadata;
import org.osgi.service.blueprint.reflect.ReferenceListMetadata;
import org.osgi.service.blueprint.reflect.ReferenceListener;
import org.osgi.service.blueprint.reflect.ReferenceMetadata;
import org.osgi.service.blueprint.reflect.RegistrationListener;
import org.osgi.service.blueprint.reflect.ServiceMetadata;
import org.osgi.service.blueprint.reflect.ServiceReferenceMetadata;
import org.osgi.service.blueprint.reflect.Target;
import org.osgi.service.blueprint.reflect.ValueMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertyPlaceholder
implements ComponentDefinitionRegistryProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPropertyPlaceholder.class);
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private Pattern pattern;
    private LinkedList<String> processingStack = new LinkedList();
    private Bundle blueprintBundle;

    public String getPlaceholderPrefix() {
        return this.placeholderPrefix;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    public String getPlaceholderSuffix() {
        return this.placeholderSuffix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComponentDefinitionRegistry registry) throws ComponentDefinitionException {
        try {
            this.blueprintBundle = (Bundle)((PassThroughMetadata)registry.getComponentDefinition("blueprintBundle")).getObject();
            for (String name : registry.getComponentDefinitionNames()) {
                this.processMetadata((Metadata)registry.getComponentDefinition(name));
            }
        }
        finally {
            this.processingStack.clear();
            this.blueprintBundle = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Metadata processMetadata(Metadata metadata) {
        try {
            if (metadata instanceof BeanMetadata) {
                BeanMetadata bmd = (BeanMetadata)metadata;
                this.processingStack.add("Bean named " + bmd.getId() + "->");
                Metadata metadata2 = this.processBeanMetadata(bmd);
                return metadata2;
            }
            if (metadata instanceof ReferenceListMetadata) {
                ReferenceListMetadata rlmd = (ReferenceListMetadata)metadata;
                this.processingStack.add("Reference List named " + rlmd.getId() + "->");
                Metadata metadata3 = this.processRefCollectionMetadata(rlmd);
                return metadata3;
            }
            if (metadata instanceof ReferenceMetadata) {
                ReferenceMetadata rmd = (ReferenceMetadata)metadata;
                this.processingStack.add("Reference named " + rmd.getId() + "->");
                Metadata metadata4 = this.processReferenceMetadata(rmd);
                return metadata4;
            }
            if (metadata instanceof ServiceMetadata) {
                ServiceMetadata smd = (ServiceMetadata)metadata;
                this.processingStack.add("Service named " + smd.getId() + "->");
                Metadata metadata5 = this.processServiceMetadata(smd);
                return metadata5;
            }
            if (metadata instanceof CollectionMetadata) {
                CollectionMetadata cmd = (CollectionMetadata)metadata;
                this.processingStack.add("Collection of type " + cmd.getCollectionClass() + "->");
                Metadata metadata6 = this.processCollectionMetadata(cmd);
                return metadata6;
            }
            if (metadata instanceof MapMetadata) {
                this.processingStack.add("Map->");
                Metadata metadata7 = this.processMapMetadata((MapMetadata)metadata);
                return metadata7;
            }
            if (metadata instanceof PropsMetadata) {
                this.processingStack.add("Properties->");
                Metadata metadata8 = this.processPropsMetadata((PropsMetadata)metadata);
                return metadata8;
            }
            if (metadata instanceof ValueMetadata) {
                this.processingStack.add("Value->");
                Metadata metadata9 = this.processValueMetadata((ValueMetadata)metadata);
                return metadata9;
            }
            this.processingStack.add("Unknown Metadata " + metadata + "->");
            Metadata metadata10 = metadata;
            return metadata10;
        }
        finally {
            this.processingStack.removeLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Metadata processBeanMetadata(BeanMetadata component) {
        for (BeanArgument arg : component.getArguments()) {
            try {
                this.processingStack.add("Argument index " + arg.getIndex() + " and value type " + arg.getValueType() + "->");
                if (arg instanceof MutableBeanArgument) {
                    ((MutableBeanArgument)arg).setValue(this.processMetadata(arg.getValue()));
                    continue;
                }
                this.printWarning(arg, "Constructor Argument");
                this.processMetadata(arg.getValue());
            }
            finally {
                this.processingStack.removeLast();
            }
        }
        for (BeanProperty prop : component.getProperties()) {
            try {
                this.processingStack.add("Property named " + prop.getName() + "->");
                if (prop instanceof MutableBeanProperty) {
                    ((MutableBeanProperty)prop).setValue(this.processMetadata(prop.getValue()));
                    continue;
                }
                this.printWarning(prop, "Injection Property");
                this.processMetadata(prop.getValue());
            }
            finally {
                this.processingStack.removeLast();
            }
        }
        Target factoryComponent = component.getFactoryComponent();
        if (factoryComponent != null) {
            try {
                if (component instanceof MutableBeanMetadata) {
                    this.processingStack.add("Factory Component->");
                    ((MutableBeanMetadata)component).setFactoryComponent((Target)this.processMetadata((Metadata)factoryComponent));
                } else {
                    this.printWarning(component, "Factory Component");
                    this.processingStack.add("Factory Component->");
                    this.processMetadata((Metadata)factoryComponent);
                }
            }
            finally {
                this.processingStack.removeLast();
            }
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Metadata processServiceMetadata(ServiceMetadata component) {
        try {
            if (component instanceof MutableServiceMetadata) {
                this.processingStack.add("Service Component->");
                ((MutableServiceMetadata)component).setServiceComponent((Target)this.processMetadata((Metadata)component.getServiceComponent()));
            } else {
                this.printWarning(component, "Service Component");
                this.processingStack.add("Service Component->");
                this.processMetadata((Metadata)component.getServiceComponent());
            }
        }
        finally {
            this.processingStack.removeLast();
        }
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>(component.getServiceProperties());
        if (!entries.isEmpty()) {
            try {
                if (component instanceof MutableServiceMetadata) {
                    this.processingStack.add("Service Properties->");
                    MutableServiceMetadata msm = (MutableServiceMetadata)component;
                    for (MapEntry entry : entries) {
                        msm.removeServiceProperty(entry);
                    }
                    for (MapEntry entry : this.processMapEntries(entries)) {
                        msm.addServiceProperty(entry);
                    }
                } else {
                    this.printWarning(component, "Service Properties");
                    this.processingStack.add("Service Properties->");
                    this.processMapEntries(entries);
                }
            }
            finally {
                this.processingStack.removeLast();
            }
        }
        for (RegistrationListener listener : component.getRegistrationListeners()) {
            Target listenerComponent = listener.getListenerComponent();
            try {
                this.processingStack.add("Registration Listener " + listenerComponent + "->");
                if (listener instanceof MutableRegistrationListener) {
                    ((MutableRegistrationListener)listener).setListenerComponent((Target)this.processMetadata((Metadata)listenerComponent));
                    continue;
                }
                this.printWarning(listener, "Service Registration Listener");
                this.processMetadata((Metadata)listenerComponent);
            }
            finally {
                this.processingStack.removeLast();
            }
        }
        return component;
    }

    protected Metadata processReferenceMetadata(ReferenceMetadata component) {
        return this.processServiceReferenceMetadata((ServiceReferenceMetadata)component);
    }

    protected Metadata processRefCollectionMetadata(ReferenceListMetadata component) {
        return this.processServiceReferenceMetadata((ServiceReferenceMetadata)component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Metadata processServiceReferenceMetadata(ServiceReferenceMetadata component) {
        ValueMetadata valueMetadata;
        if (component instanceof MutableServiceReferenceMetadata && (valueMetadata = ((MutableServiceReferenceMetadata)component).getExtendedFilter()) != null) {
            ((MutableServiceReferenceMetadata)component).setExtendedFilter(this.doProcessValueMetadata(valueMetadata));
        }
        for (ReferenceListener listener : component.getReferenceListeners()) {
            Target listenerComponent = listener.getListenerComponent();
            try {
                this.processingStack.add("Reference Listener " + listenerComponent + "->");
                if (listener instanceof MutableReferenceListener) {
                    ((MutableReferenceListener)listener).setListenerComponent((Target)this.processMetadata((Metadata)listenerComponent));
                    continue;
                }
                this.printWarning(listener, "Reference Binding Listener");
                this.processMetadata((Metadata)listenerComponent);
            }
            finally {
                this.processingStack.removeLast();
            }
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Metadata processPropsMetadata(PropsMetadata metadata) {
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>(metadata.getEntries());
        if (!entries.isEmpty()) {
            try {
                if (metadata instanceof MutablePropsMetadata) {
                    this.processingStack.add("Properties->");
                    MutablePropsMetadata mpm = (MutablePropsMetadata)metadata;
                    for (MapEntry entry : entries) {
                        mpm.removeEntry(entry);
                    }
                    for (MapEntry entry : this.processMapEntries(entries)) {
                        mpm.addEntry(entry);
                    }
                } else {
                    this.printWarning(metadata, "Properties");
                    this.processingStack.add("Properties->");
                    this.processMapEntries(entries);
                }
            }
            finally {
                this.processingStack.removeLast();
            }
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Metadata processMapMetadata(MapMetadata metadata) {
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>(metadata.getEntries());
        if (!entries.isEmpty()) {
            try {
                if (metadata instanceof MutableMapMetadata) {
                    this.processingStack.add("Map->");
                    MutableMapMetadata mmm = (MutableMapMetadata)metadata;
                    for (MapEntry entry : entries) {
                        mmm.removeEntry(entry);
                    }
                    for (MapEntry entry : this.processMapEntries(entries)) {
                        mmm.addEntry(entry);
                    }
                } else {
                    this.printWarning(metadata, "Map");
                    this.processingStack.add("Map->");
                    this.processMapEntries(entries);
                }
            }
            finally {
                this.processingStack.removeLast();
            }
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<MapEntry> processMapEntries(List<MapEntry> entries) {
        for (MapEntry entry : entries) {
            try {
                this.processingStack.add("Map Entry Key: " + entry.getKey() + " Value: " + entry.getValue() + "->");
                if (entry instanceof MutableMapEntry) {
                    ((MutableMapEntry)entry).setKey((NonNullMetadata)this.processMetadata((Metadata)entry.getKey()));
                    ((MutableMapEntry)entry).setValue(this.processMetadata(entry.getValue()));
                    continue;
                }
                this.printWarning(entry, "Map Entry");
                this.processMetadata((Metadata)entry.getKey());
                this.processMetadata(entry.getValue());
            }
            finally {
                this.processingStack.removeLast();
            }
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Metadata processCollectionMetadata(CollectionMetadata metadata) {
        ArrayList values = new ArrayList(metadata.getValues());
        if (!values.isEmpty()) {
            try {
                if (metadata instanceof MutableCollectionMetadata) {
                    this.processingStack.add("Collection type: " + metadata.getValueType() + "->");
                    MutableCollectionMetadata mcm = (MutableCollectionMetadata)metadata;
                    for (Metadata value : values) {
                        mcm.removeValue(value);
                    }
                    for (Metadata value : values) {
                        mcm.addValue(this.processMetadata(value));
                    }
                } else {
                    this.printWarning(metadata, "Collection type: " + metadata.getValueType());
                    this.processingStack.add("Collection type: " + metadata.getValueType() + "->");
                    for (Metadata value : values) {
                        this.processMetadata(value);
                    }
                }
            }
            finally {
                this.processingStack.removeLast();
            }
        }
        return metadata;
    }

    protected Metadata processValueMetadata(ValueMetadata metadata) {
        return this.doProcessValueMetadata(metadata);
    }

    protected ValueMetadata doProcessValueMetadata(ValueMetadata metadata) {
        return new LateBindingValueMetadata(metadata);
    }

    private void printWarning(Object immutable, String processingType) {
        StringBuilder sb = new StringBuilder("The property placeholder processor for ");
        sb.append(this.placeholderPrefix).append(',').append(" ").append(this.placeholderSuffix).append(" in bundle ").append(this.blueprintBundle.getSymbolicName()).append("_").append(this.blueprintBundle.getVersion()).append(" found an immutable ").append(processingType).append(" at location ");
        for (String s : this.processingStack) {
            sb.append(s);
        }
        sb.append(". This may prevent properties, beans, or other items referenced by this component from being properly processed.");
        LOGGER.info(sb.toString());
    }

    protected String retrieveValue(String expression) {
        return this.getProperty(expression);
    }

    protected String processString(String str) {
        Matcher matcher = this.getPattern().matcher(str);
        while (matcher.find()) {
            String rep = this.retrieveValue(matcher.group(1));
            if (rep == null) continue;
            str = str.replace(matcher.group(0), rep);
            matcher.reset(str);
        }
        return str;
    }

    protected String getProperty(String val) {
        return null;
    }

    protected Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = Pattern.compile("\\Q" + this.placeholderPrefix + "\\E(.+?)\\Q" + this.placeholderSuffix + "\\E");
        }
        return this.pattern;
    }

    public class LateBindingValueMetadata
    implements ValueMetadata {
        private final ValueMetadata metadata;
        private boolean retrieved;
        private String retrievedValue;

        public LateBindingValueMetadata(ValueMetadata metadata) {
            this.metadata = metadata;
        }

        public String getStringValue() {
            if (!this.retrieved) {
                String v = this.metadata.getStringValue();
                LOGGER.debug("Before process: {}", (Object)v);
                this.retrievedValue = AbstractPropertyPlaceholder.this.processString(v);
                LOGGER.debug("After process: {}", (Object)this.retrievedValue);
                this.retrieved = true;
            }
            return this.retrievedValue;
        }

        public String getType() {
            return this.metadata.getType();
        }
    }
}

