/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.proxy.impl.weaving;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.aries.proxy.UnableToProxyException;
import org.apache.aries.proxy.impl.NLS;
import org.apache.aries.proxy.impl.weaving.WovenProxyGenerator;
import org.apache.aries.proxy.weaving.WovenProxy;
import org.apache.aries.proxy.weavinghook.ProxyWeavingController;
import org.apache.aries.proxy.weavinghook.WeavingHelper;
import org.objectweb.asm.ClassReader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.hooks.weaving.WeavingException;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProxyWeavingHook
implements WeavingHook,
WeavingHelper {
    public static final String WEAVING_ENABLED_CLASSES = "org.apache.aries.proxy.weaving.enabled";
    public static final String WEAVING_DISABLED_CLASSES = "org.apache.aries.proxy.weaving.disabled";
    public static final String WEAVING_ENABLED_CLASSES_DEFAULT = "*";
    public static final String WEAVING_DISABLED_CLASSES_DEFAULT = "org.objectweb.asm.*,org.slf4j.*,org.apache.log4j.*,javax.*,ch.qos.logback.*";
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyWeavingHook.class);
    private static final String IMPORT_A = "org.apache.aries.proxy.weaving";
    private static final String IMPORT_B = "org.apache.aries.proxy";
    private final List<Pattern> enabled;
    private final List<Pattern> disabled;
    private final ServiceTracker controllers;

    public ProxyWeavingHook(BundleContext context) {
        String enabledProp = context != null ? context.getProperty(WEAVING_ENABLED_CLASSES) : null;
        this.enabled = this.parseMatchers(enabledProp, WEAVING_ENABLED_CLASSES_DEFAULT);
        this.disabled = this.parseMatchers(context != null ? context.getProperty(WEAVING_DISABLED_CLASSES) : null, WEAVING_DISABLED_CLASSES_DEFAULT);
        this.controllers = new ServiceTracker(context, ProxyWeavingController.class.getName(), null);
        this.controllers.open();
        if (!"none".equals(enabledProp)) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("osgi.woven.packages", "org.apache.aries.proxy.weaving,org.apache.aries.proxy");
            context.registerService("org.osgi.framework.hooks.weaving.WeavingHook", (Object)this, props);
        }
    }

    public final void weave(WovenClass wovenClass) {
        Bundle b;
        BundleWiring bw = wovenClass.getBundleWiring();
        if (bw != null && ((b = bw.getBundle()).getBundleId() == 0L || b.getSymbolicName().startsWith(IMPORT_B) || b.getSymbolicName().startsWith("org.apache.aries.util"))) {
            return;
        }
        if (!this.isEnabled(wovenClass.getClassName()) || this.isDisabled(wovenClass.getClassName())) {
            return;
        }
        if (this.shouldWeave(wovenClass)) {
            byte[] bytes = null;
            try {
                bytes = WovenProxyGenerator.getWovenProxy(wovenClass.getBytes(), wovenClass.getBundleWiring().getClassLoader());
            }
            catch (Exception e) {
                if (e instanceof RuntimeException && e.getCause() instanceof UnableToProxyException) {
                    LOGGER.trace(NLS.MESSAGES.getMessage("cannot.weave", new Object[]{wovenClass.getClassName()}), (Throwable)e);
                }
                String failureMessage = NLS.MESSAGES.getMessage("fatal.weaving.failure", new Object[]{wovenClass.getClassName()});
                LOGGER.error(failureMessage, (Throwable)e);
                throw new WeavingException(failureMessage, (Throwable)e);
            }
            if (bytes != null && bytes.length != 0) {
                wovenClass.setBytes(bytes);
                List imports = wovenClass.getDynamicImports();
                imports.add(IMPORT_A);
                imports.add(IMPORT_B);
            }
        }
    }

    private List<Pattern> parseMatchers(String matchers, String def) {
        String[] strings = (matchers != null ? matchers : def).split(",");
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String str : strings) {
            if ((str = str.trim()).length() == 0) continue;
            str = str.replaceAll("\\.", "\\\\.");
            str = str.replaceAll("\\*", ".*");
            Pattern p = Pattern.compile(str);
            patterns.add(p);
        }
        return patterns;
    }

    boolean isEnabled(String className) {
        return this.matches(this.enabled, className);
    }

    boolean isDisabled(String className) {
        return this.matches(this.disabled, className);
    }

    private boolean matches(List<Pattern> patterns, String className) {
        for (Pattern p : patterns) {
            if (!p.matcher(className).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean isWoven(Class<?> clazz) {
        return WovenProxy.class.isAssignableFrom(clazz);
    }

    public boolean isSuperClassWoven(WovenClass wovenClass) {
        ClassReader cReader = new ClassReader(wovenClass.getBytes());
        try {
            Class<?> superClass = Class.forName(cReader.getSuperName().replace('/', '.'), false, wovenClass.getBundleWiring().getClassLoader());
            return WovenProxy.class.isAssignableFrom(superClass);
        }
        catch (ClassNotFoundException e) {
            String failureMessage = NLS.MESSAGES.getMessage("fatal.weaving.failure", new Object[]{wovenClass.getClassName()});
            LOGGER.error(failureMessage, (Throwable)e);
            throw new WeavingException(failureMessage, (Throwable)e);
        }
    }

    private boolean shouldWeave(WovenClass wovenClass) {
        boolean result = true;
        Object[] cs = this.controllers.getServices();
        if (cs != null && cs.length > 0) {
            result = false;
            for (Object obj : cs) {
                ProxyWeavingController c = (ProxyWeavingController)obj;
                if (!c.shouldWeave(wovenClass, (WeavingHelper)this)) continue;
                return true;
            }
        }
        return result;
    }
}

