/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.AssignableFromInteger;
import org.snmp4j.smi.AssignableFromString;
import org.snmp4j.smi.OID;

public class Integer32
extends AbstractVariable
implements AssignableFromInteger,
AssignableFromString {
    private static final long serialVersionUID = 5046132399890132416L;
    private int value = 0;

    public Integer32() {
    }

    public Integer32(int value) {
        this.setValue(value);
    }

    public void encodeBER(OutputStream outputStream) throws IOException {
        BER.encodeInteger(outputStream, (byte)2, this.value);
    }

    public void decodeBER(BERInputStream inputStream) throws IOException {
        BER.MutableByte type = new BER.MutableByte();
        int newValue = BER.decodeInteger(inputStream, type);
        if (type.getValue() != 2) {
            throw new IOException("Wrong type encountered when decoding Counter: " + type.getValue());
        }
        this.setValue(newValue);
    }

    public int getSyntax() {
        return 2;
    }

    public int hashCode() {
        return this.value;
    }

    public int getBERLength() {
        if (this.value < 128 && this.value >= -128) {
            return 3;
        }
        if (this.value < 32768 && this.value >= Short.MIN_VALUE) {
            return 4;
        }
        if (this.value < 0x800000 && this.value >= -8388608) {
            return 5;
        }
        return 6;
    }

    public boolean equals(Object o) {
        if (o instanceof Integer32) {
            return ((Integer32)o).value == this.value;
        }
        return false;
    }

    public int compareTo(Object o) {
        return this.value - ((Integer32)o).value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public final void setValue(String value) {
        this.value = Integer.parseInt(value);
    }

    public final void setValue(int value) {
        this.value = value;
    }

    public final int getValue() {
        return this.value;
    }

    public Object clone() {
        return new Integer32(this.value);
    }

    public final int toInt() {
        return this.getValue();
    }

    public final long toLong() {
        return this.getValue();
    }

    public OID toSubIndex(boolean impliedLength) {
        return new OID(new int[]{this.value});
    }

    public void fromSubIndex(OID subIndex, boolean impliedLength) {
        this.setValue(subIndex.get(0));
    }
}

