/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.net.Inet4Address;
import java.net.Inet6Address;
import org.snmp4j.agent.mo.snmp.TDomainAddressFactory;
import org.snmp4j.agent.mo.snmp.TransportDomains;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TransportIpAddress;
import org.snmp4j.smi.UdpAddress;

public class TDomainAddressFactoryImpl
implements TDomainAddressFactory {
    private static final LogAdapter logger = LogFactory.getLogger((Class)TDomainAddressFactoryImpl.class);

    public Address createAddress(OID transportDomain, OctetString address) {
        if (TransportDomains.snmpUDPDomain.equals((Object)transportDomain) || TransportDomains.transportDomainUdpIpv4.equals((Object)transportDomain) || TransportDomains.transportDomainTcpIpv4.equals((Object)transportDomain) || TransportDomains.transportDomainUdpIpv6.equals((Object)transportDomain) || TransportDomains.transportDomainTcpIpv6.equals((Object)transportDomain)) {
            Object transportIpAddress = TransportDomains.transportDomainTcpIpv4.equals((Object)transportDomain) || TransportDomains.transportDomainTcpIpv6.equals((Object)transportDomain) ? new TcpAddress() : new UdpAddress();
            try {
                transportIpAddress.setTransportAddress(address);
            }
            catch (Exception ex) {
                logger.debug((Object)("Invalid TransportAddress format '" + address + "' for domain " + transportDomain));
                return null;
            }
            return transportIpAddress;
        }
        return null;
    }

    public boolean isValidAddress(OID transportDomain, OctetString address) {
        try {
            Address addr = this.createAddress(transportDomain, address);
            if (addr != null) {
                return true;
            }
        }
        catch (Exception ex) {
            logger.debug((Object)("Address is not valid TDomain address: " + address + "; details: " + ex.getMessage()));
        }
        return false;
    }

    public OID getTransportDomain(Address address) {
        if (address instanceof TransportIpAddress) {
            TransportIpAddress tipaddr = (TransportIpAddress)address;
            if (tipaddr.getInetAddress() instanceof Inet4Address) {
                if (address instanceof UdpAddress) {
                    return TransportDomains.transportDomainUdpIpv4;
                }
                if (address instanceof TcpAddress) {
                    return TransportDomains.transportDomainTcpIpv4;
                }
            } else if (tipaddr.getInetAddress() instanceof Inet6Address) {
                if (address instanceof UdpAddress) {
                    return TransportDomains.transportDomainUdpIpv6;
                }
                if (address instanceof TcpAddress) {
                    return TransportDomains.transportDomainTcpIpv6;
                }
            }
        }
        return null;
    }

    public OctetString getAddress(Address address) {
        if (address instanceof TransportIpAddress) {
            TransportIpAddress tipaddr = (TransportIpAddress)address;
            byte[] addrBytes = tipaddr.getInetAddress().getAddress();
            OctetString addr = new OctetString(addrBytes);
            addr.append((byte)(tipaddr.getPort() >> 8));
            addr.append((byte)(tipaddr.getPort() & 0xFF));
            return addr;
        }
        return null;
    }
}

