/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.snmp4j;

import java.io.IOException;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.AssignableFromInteger;
import org.snmp4j.smi.AssignableFromString;
import org.snmp4j.smi.Integer32;

public class Integer32IgnoreTooManyBytes
extends Integer32
implements AssignableFromInteger,
AssignableFromString {
    private static final transient Logger LOG = LoggerFactory.getLogger(Integer32IgnoreTooManyBytes.class);
    private static final long serialVersionUID = 5046132399890132416L;

    public Integer32IgnoreTooManyBytes() {
    }

    public Integer32IgnoreTooManyBytes(int value) {
        this.setValue(value);
    }

    @Override
    public void decodeBER(BERInputStream inputStream) throws IOException {
        int newValue;
        int b;
        BER.MutableByte type = new BER.MutableByte();
        BigInteger value = BigInteger.ZERO;
        type.setValue((byte)inputStream.read());
        if (type.getValue() != 2 && type.getValue() != 67 && type.getValue() != 65) {
            throw new IOException("Wrong ASN.1 type. Not an integer: " + type.getValue() + " at position " + inputStream.getPosition());
        }
        int length = BER.decodeLength(inputStream);
        if (length > 4) {
            LOG.debug("Working around invalid Integer32 likely dealing with a permissive Net-SNMP agent");
        }
        if (((b = inputStream.read() & 0xFF) & 0x80) > 0) {
            value = BigInteger.ONE.negate();
        }
        while (length-- > 0) {
            value = value.shiftLeft(8).or(BigInteger.valueOf(b));
            if (length <= 0) continue;
            b = inputStream.read();
        }
        int n = newValue = value.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0 ? 0 : value.intValue();
        if (type.getValue() != 2) {
            throw new IOException("Wrong type encountered when decoding Counter: " + type.getValue());
        }
        this.setValue(newValue);
    }

    @Override
    public Object clone() {
        return new Integer32IgnoreTooManyBytes(this.getValue());
    }
}

