/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.adapter.netflow5.proto;

import java.nio.ByteBuffer;
import org.opennms.netmgt.telemetry.protocols.netflow.adapter.netflow5.proto.Utils;

public class NetflowRecord {
    private final String srcAddr;
    private final String dstAddr;
    private final String nextHop;
    private final int input;
    private final int output;
    private final long dPkts;
    private final long dOctets;
    private final long first;
    private final long last;
    private final int srcPort;
    private final int dstPort;
    private final short tcpFlags;
    private final short prot;
    private final int srcAs;
    private final int dstAs;
    private final short toS;
    private final short srcMask;
    private final short dstMask;
    private final boolean egress;

    public NetflowRecord(ByteBuffer data, int offset) {
        this.srcAddr = Utils.getInetAddress(0, 3, data, offset);
        this.dstAddr = Utils.getInetAddress(4, 7, data, offset);
        this.nextHop = Utils.getInetAddress(8, 11, data, offset);
        this.input = Utils.getInt(12, 13, data, offset);
        this.output = Utils.getInt(14, 15, data, offset);
        this.dPkts = Utils.getLong(16, 19, data, offset);
        this.dOctets = Utils.getLong(20, 23, data, offset);
        this.first = Utils.getLong(24, 27, data, offset);
        this.last = Utils.getLong(28, 31, data, offset);
        this.srcPort = Utils.getInt(32, 33, data, offset);
        this.dstPort = Utils.getInt(34, 35, data, offset);
        this.tcpFlags = Utils.getShort(37, 37, data, offset);
        this.prot = Utils.getShort(38, 38, data, offset);
        this.toS = Utils.getShort(39, 39, data, offset);
        this.srcAs = Utils.getInt(40, 41, data, offset);
        this.dstAs = Utils.getInt(42, 43, data, offset);
        this.srcMask = Utils.getShort(44, 44, data, offset);
        this.dstMask = Utils.getShort(45, 45, data, offset);
        this.egress = Utils.getShort(47, 47, data, offset) == 8;
    }

    public String getSrcAddr() {
        return this.srcAddr;
    }

    public String getDstAddr() {
        return this.dstAddr;
    }

    public String getNextHop() {
        return this.nextHop;
    }

    public int getInput() {
        return this.input;
    }

    public int getOutput() {
        return this.output;
    }

    public long getDPkts() {
        return this.dPkts;
    }

    public long getDOctets() {
        return this.dOctets;
    }

    public long getFirst() {
        return this.first;
    }

    public long getLast() {
        return this.last;
    }

    public int getSrcPort() {
        return this.srcPort;
    }

    public int getDstPort() {
        return this.dstPort;
    }

    public int getTcpFlags() {
        return this.tcpFlags;
    }

    public int getProt() {
        return this.prot;
    }

    public int getSrcAs() {
        return this.srcAs;
    }

    public int getDstAs() {
        return this.dstAs;
    }

    public int getToS() {
        return this.toS;
    }

    public int getSrcMask() {
        return this.srcMask;
    }

    public int getDstMask() {
        return this.dstMask;
    }

    public boolean isEgress() {
        return this.egress;
    }
}

