/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.config.requisition.immutables;

import java.util.Objects;
import org.opennms.integration.api.v1.config.requisition.RequisitionMetaData;

public final class ImmutableRequisitionMetaData
implements RequisitionMetaData {
    private final String context;
    private final String key;
    private final String value;

    private ImmutableRequisitionMetaData(Builder builder) {
        this.context = builder.context;
        this.key = builder.key;
        this.value = builder.value;
    }

    private ImmutableRequisitionMetaData(String context, String key, String value) {
        this.context = context;
        this.key = key;
        this.value = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(RequisitionMetaData requisitionMetaData) {
        return new Builder(requisitionMetaData);
    }

    public static RequisitionMetaData immutableCopy(RequisitionMetaData requisitionMetaData) {
        if (requisitionMetaData == null || requisitionMetaData instanceof ImmutableRequisitionMetaData) {
            return requisitionMetaData;
        }
        return ImmutableRequisitionMetaData.newBuilderFrom(requisitionMetaData).build();
    }

    public static ImmutableRequisitionMetaData newInstance(String context, String key, String value) {
        return new ImmutableRequisitionMetaData(Objects.requireNonNull(context), Objects.requireNonNull(key), Objects.requireNonNull(value));
    }

    public String getContext() {
        return this.context;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableRequisitionMetaData that = (ImmutableRequisitionMetaData)o;
        return Objects.equals(this.context, that.context) && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.context, this.key, this.value);
    }

    public String toString() {
        return "ImmutableRequisitionMetaData{context='" + this.context + '\'' + ", key='" + this.key + '\'' + ", value='" + this.value + '\'' + '}';
    }

    public static final class Builder {
        private String context;
        private String key;
        private String value;

        private Builder() {
        }

        private Builder(RequisitionMetaData requisitionMetaData) {
            this.context = requisitionMetaData.getContext();
            this.key = requisitionMetaData.getKey();
            this.value = requisitionMetaData.getValue();
        }

        public Builder setContext(String context) {
            this.context = context;
            return this;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setValue(String value) {
            this.value = value;
            return this;
        }

        public ImmutableRequisitionMetaData build() {
            Objects.requireNonNull(this.context, "context is required");
            Objects.requireNonNull(this.key, "key is required");
            Objects.requireNonNull(this.value, "value is required");
            return new ImmutableRequisitionMetaData(this);
        }
    }
}

