/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.cloud;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.cloud.ServiceChooser;
import org.apache.camel.cloud.ServiceDiscovery;
import org.apache.camel.cloud.ServiceFilter;
import org.apache.camel.cloud.ServiceLoadBalancer;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.model.cloud.AggregatingServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.BlacklistServiceCallServiceFilterConfiguration;
import org.apache.camel.model.cloud.CachingServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.ChainedServiceCallServiceFilterConfiguration;
import org.apache.camel.model.cloud.ConsulServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.CustomServiceCallServiceFilterConfiguration;
import org.apache.camel.model.cloud.DefaultServiceCallServiceLoadBalancerConfiguration;
import org.apache.camel.model.cloud.DnsServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.EtcdServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.HealthyServiceCallServiceFilterConfiguration;
import org.apache.camel.model.cloud.KubernetesServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.PassThroughServiceCallServiceFilterConfiguration;
import org.apache.camel.model.cloud.RibbonServiceCallServiceLoadBalancerConfiguration;
import org.apache.camel.model.cloud.ServiceCallExpressionConfiguration;
import org.apache.camel.model.cloud.ServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.ServiceCallServiceFilterConfiguration;
import org.apache.camel.model.cloud.ServiceCallServiceLoadBalancerConfiguration;
import org.apache.camel.model.cloud.StaticServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.spi.Metadata;

@Metadata(label="routing,cloud")
@XmlRootElement(name="serviceCallConfiguration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ServiceCallConfigurationDefinition
extends IdentifiedType {
    @XmlAttribute
    private String uri;
    @XmlAttribute
    @Metadata(defaultValue="http4")
    private String component;
    @XmlAttribute
    private ExchangePattern pattern;
    @XmlAttribute
    private String serviceDiscoveryRef;
    @XmlTransient
    private ServiceDiscovery serviceDiscovery;
    @XmlAttribute
    private String serviceFilterRef;
    @XmlTransient
    private ServiceFilter serviceFilter;
    @XmlAttribute
    private String serviceChooserRef;
    @XmlTransient
    private ServiceChooser serviceChooser;
    @XmlAttribute
    private String loadBalancerRef;
    @XmlTransient
    private ServiceLoadBalancer loadBalancer;
    @XmlAttribute
    private String expressionRef;
    @XmlTransient
    private Expression expression;
    @XmlElements(value={@XmlElement(name="cachingServiceDiscovery", type=CachingServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="aggregatingServiceDiscovery", type=AggregatingServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="consulServiceDiscovery", type=ConsulServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="dnsServiceDiscovery", type=DnsServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="etcdServiceDiscovery", type=EtcdServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="kubernetesServiceDiscovery", type=KubernetesServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="staticServiceDiscovery", type=StaticServiceCallServiceDiscoveryConfiguration.class)})
    private ServiceCallServiceDiscoveryConfiguration serviceDiscoveryConfiguration;
    @XmlElements(value={@XmlElement(name="blacklistServiceFilter", type=BlacklistServiceCallServiceFilterConfiguration.class), @XmlElement(name="chainedServiceFilter", type=ChainedServiceCallServiceFilterConfiguration.class), @XmlElement(name="customServiceFilter", type=CustomServiceCallServiceFilterConfiguration.class), @XmlElement(name="healthyServiceFilter", type=HealthyServiceCallServiceFilterConfiguration.class), @XmlElement(name="passThroughServiceFilter", type=PassThroughServiceCallServiceFilterConfiguration.class)})
    private ServiceCallServiceFilterConfiguration serviceFilterConfiguration;
    @XmlElements(value={@XmlElement(name="ribbonLoadBalancer", type=RibbonServiceCallServiceLoadBalancerConfiguration.class), @XmlElement(name="defaultLoadBalancer", type=DefaultServiceCallServiceLoadBalancerConfiguration.class)})
    private ServiceCallServiceLoadBalancerConfiguration loadBalancerConfiguration;
    @XmlElements(value={@XmlElement(name="expression", type=ServiceCallExpressionConfiguration.class)})
    private ServiceCallExpressionConfiguration expressionConfiguration;

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    public void setPattern(ExchangePattern pattern) {
        this.pattern = pattern;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getServiceDiscoveryRef() {
        return this.serviceDiscoveryRef;
    }

    public void setServiceDiscoveryRef(String serviceDiscoveryRef) {
        this.serviceDiscoveryRef = serviceDiscoveryRef;
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    public void setServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
    }

    public String getServiceFilterRef() {
        return this.serviceFilterRef;
    }

    public void setServiceFilterRef(String serviceFilterRef) {
        this.serviceFilterRef = serviceFilterRef;
    }

    public ServiceFilter getServiceFilter() {
        return this.serviceFilter;
    }

    public void setServiceFilter(ServiceFilter serviceFilter) {
        this.serviceFilter = serviceFilter;
    }

    public String getServiceChooserRef() {
        return this.serviceChooserRef;
    }

    public void setServiceChooserRef(String serviceChooserRef) {
        this.serviceChooserRef = serviceChooserRef;
    }

    public ServiceChooser getServiceChooser() {
        return this.serviceChooser;
    }

    public void setServiceChooser(ServiceChooser serviceChooser) {
        this.serviceChooser = serviceChooser;
    }

    public String getLoadBalancerRef() {
        return this.loadBalancerRef;
    }

    public void setLoadBalancerRef(String loadBalancerRef) {
        this.loadBalancerRef = loadBalancerRef;
    }

    public ServiceLoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public void setLoadBalancer(ServiceLoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public String getExpressionRef() {
        return this.expressionRef;
    }

    public void setExpressionRef(String expressionRef) {
        this.expressionRef = expressionRef;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public ServiceCallServiceDiscoveryConfiguration getServiceDiscoveryConfiguration() {
        return this.serviceDiscoveryConfiguration;
    }

    public void setServiceDiscoveryConfiguration(ServiceCallServiceDiscoveryConfiguration serviceDiscoveryConfiguration) {
        this.serviceDiscoveryConfiguration = serviceDiscoveryConfiguration;
    }

    public ServiceCallServiceFilterConfiguration getServiceFilterConfiguration() {
        return this.serviceFilterConfiguration;
    }

    public void setServiceFilterConfiguration(ServiceCallServiceFilterConfiguration serviceFilterConfiguration) {
        this.serviceFilterConfiguration = serviceFilterConfiguration;
    }

    public ServiceCallServiceLoadBalancerConfiguration getLoadBalancerConfiguration() {
        return this.loadBalancerConfiguration;
    }

    public void setLoadBalancerConfiguration(ServiceCallServiceLoadBalancerConfiguration loadBalancerConfiguration) {
        this.loadBalancerConfiguration = loadBalancerConfiguration;
    }

    public ServiceCallExpressionConfiguration getExpressionConfiguration() {
        return this.expressionConfiguration;
    }

    public void setExpressionConfiguration(ServiceCallExpressionConfiguration expressionConfiguration) {
        this.expressionConfiguration = expressionConfiguration;
    }

    public ServiceCallConfigurationDefinition component(String component) {
        this.setComponent(component);
        return this;
    }

    public ServiceCallConfigurationDefinition uri(String uri) {
        this.setUri(uri);
        return this;
    }

    public ServiceCallConfigurationDefinition pattern(ExchangePattern pattern) {
        this.setPattern(pattern);
        return this;
    }

    public ServiceCallConfigurationDefinition serviceDiscovery(String serviceDiscoveryRef) {
        this.setServiceDiscoveryRef(serviceDiscoveryRef);
        return this;
    }

    public ServiceCallConfigurationDefinition serviceDiscovery(ServiceDiscovery serviceDiscovery) {
        this.setServiceDiscovery(serviceDiscovery);
        return this;
    }

    public ServiceCallConfigurationDefinition serviceFilter(String serviceFilterRef) {
        this.setServiceDiscoveryRef(this.serviceDiscoveryRef);
        return this;
    }

    public ServiceCallConfigurationDefinition serviceFilter(ServiceFilter serviceFilter) {
        this.setServiceFilter(serviceFilter);
        return this;
    }

    public ServiceCallConfigurationDefinition serviceChooser(String serviceChooserRef) {
        this.setServiceChooserRef(serviceChooserRef);
        return this;
    }

    public ServiceCallConfigurationDefinition serviceChooser(ServiceChooser serviceChooser) {
        this.setServiceChooser(serviceChooser);
        return this;
    }

    public ServiceCallConfigurationDefinition loadBalancer(String loadBalancerRef) {
        this.setLoadBalancerRef(loadBalancerRef);
        return this;
    }

    public ServiceCallConfigurationDefinition loadBalancer(ServiceLoadBalancer loadBalancer) {
        this.setLoadBalancer(loadBalancer);
        return this;
    }

    public ServiceCallConfigurationDefinition expression(String expressionRef) {
        this.setExpressionRef(this.loadBalancerRef);
        return this;
    }

    public ServiceCallConfigurationDefinition expression(Expression expression) {
        this.setExpression(expression);
        return this;
    }

    public ExpressionClause<ServiceCallConfigurationDefinition> expression() {
        ExpressionClause<ServiceCallConfigurationDefinition> clause = new ExpressionClause<ServiceCallConfigurationDefinition>(this);
        this.setExpression(clause);
        return clause;
    }

    public ServiceCallConfigurationDefinition serviceDiscoveryConfiguration(ServiceCallServiceDiscoveryConfiguration serviceDiscoveryConfiguration) {
        this.setServiceDiscoveryConfiguration(serviceDiscoveryConfiguration);
        return this;
    }

    public ServiceCallConfigurationDefinition serviceFilterConfiguration(ServiceCallServiceFilterConfiguration serviceFilterConfiguration) {
        this.setServiceFilterConfiguration(serviceFilterConfiguration);
        return this;
    }

    public ServiceCallConfigurationDefinition loadBalancerConfiguration(ServiceCallServiceLoadBalancerConfiguration loadBalancerConfiguration) {
        this.setLoadBalancerConfiguration(loadBalancerConfiguration);
        return this;
    }

    public ServiceCallConfigurationDefinition expressionConfiguration(ServiceCallExpressionConfiguration expressionConfiguration) {
        this.setExpressionConfiguration(expressionConfiguration);
        return this;
    }

    public CachingServiceCallServiceDiscoveryConfiguration cachingServiceDiscovery() {
        CachingServiceCallServiceDiscoveryConfiguration conf = new CachingServiceCallServiceDiscoveryConfiguration();
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public ConsulServiceCallServiceDiscoveryConfiguration consulServiceDiscovery() {
        ConsulServiceCallServiceDiscoveryConfiguration conf = new ConsulServiceCallServiceDiscoveryConfiguration();
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public DnsServiceCallServiceDiscoveryConfiguration dnsServiceDiscovery() {
        DnsServiceCallServiceDiscoveryConfiguration conf = new DnsServiceCallServiceDiscoveryConfiguration();
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public ServiceCallConfigurationDefinition dnsServiceDiscovery(String domain) {
        DnsServiceCallServiceDiscoveryConfiguration conf = new DnsServiceCallServiceDiscoveryConfiguration();
        conf.setDomain(domain);
        this.setServiceDiscoveryConfiguration(conf);
        return this;
    }

    public ServiceCallConfigurationDefinition dnsServiceDiscovery(String domain, String protocol) {
        DnsServiceCallServiceDiscoveryConfiguration conf = new DnsServiceCallServiceDiscoveryConfiguration();
        conf.setDomain(domain);
        conf.setProto(protocol);
        this.setServiceDiscoveryConfiguration(conf);
        return this;
    }

    public EtcdServiceCallServiceDiscoveryConfiguration etcdServiceDiscovery() {
        EtcdServiceCallServiceDiscoveryConfiguration conf = new EtcdServiceCallServiceDiscoveryConfiguration();
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public KubernetesServiceCallServiceDiscoveryConfiguration kubernetesServiceDiscovery() {
        KubernetesServiceCallServiceDiscoveryConfiguration conf = new KubernetesServiceCallServiceDiscoveryConfiguration();
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public KubernetesServiceCallServiceDiscoveryConfiguration kubernetesClientServiceDiscovery() {
        KubernetesServiceCallServiceDiscoveryConfiguration conf = new KubernetesServiceCallServiceDiscoveryConfiguration();
        conf.setLookup("client");
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public ServiceCallConfigurationDefinition kubernetesEnvServiceDiscovery() {
        KubernetesServiceCallServiceDiscoveryConfiguration conf = new KubernetesServiceCallServiceDiscoveryConfiguration();
        conf.setLookup("environment");
        this.setServiceDiscoveryConfiguration(conf);
        return this;
    }

    public ServiceCallConfigurationDefinition kubernetesDnsServiceDiscovery(String namespace, String domain) {
        KubernetesServiceCallServiceDiscoveryConfiguration conf = new KubernetesServiceCallServiceDiscoveryConfiguration();
        conf.setNamespace(namespace);
        conf.setDnsDomain(domain);
        this.setServiceDiscoveryConfiguration(conf);
        return this;
    }

    public AggregatingServiceCallServiceDiscoveryConfiguration multiServiceDiscovery() {
        AggregatingServiceCallServiceDiscoveryConfiguration conf = new AggregatingServiceCallServiceDiscoveryConfiguration();
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public ServiceCallConfigurationDefinition multiServiceDiscovery(AggregatingServiceCallServiceDiscoveryConfiguration conf) {
        this.setServiceDiscoveryConfiguration(conf);
        return this;
    }

    public StaticServiceCallServiceDiscoveryConfiguration staticServiceDiscovery() {
        StaticServiceCallServiceDiscoveryConfiguration conf = new StaticServiceCallServiceDiscoveryConfiguration();
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public ServiceCallConfigurationDefinition staticServiceDiscovery(StaticServiceCallServiceDiscoveryConfiguration conf) {
        this.setServiceDiscoveryConfiguration(conf);
        return this;
    }

    public ServiceCallConfigurationDefinition healthyFilter() {
        HealthyServiceCallServiceFilterConfiguration conf = new HealthyServiceCallServiceFilterConfiguration();
        this.setServiceFilterConfiguration(conf);
        return this;
    }

    public ServiceCallConfigurationDefinition passThroughFilter() {
        PassThroughServiceCallServiceFilterConfiguration conf = new PassThroughServiceCallServiceFilterConfiguration();
        this.setServiceFilterConfiguration(conf);
        return this;
    }

    public ChainedServiceCallServiceFilterConfiguration multiFilter() {
        ChainedServiceCallServiceFilterConfiguration conf = new ChainedServiceCallServiceFilterConfiguration();
        this.setServiceFilterConfiguration(conf);
        return conf;
    }

    public BlacklistServiceCallServiceFilterConfiguration blacklistFilter() {
        BlacklistServiceCallServiceFilterConfiguration conf = new BlacklistServiceCallServiceFilterConfiguration();
        this.setServiceFilterConfiguration(conf);
        return conf;
    }

    public ServiceCallConfigurationDefinition customFilter(String serviceFilter) {
        CustomServiceCallServiceFilterConfiguration conf = new CustomServiceCallServiceFilterConfiguration();
        conf.setServiceFilterRef(serviceFilter);
        this.setServiceFilterConfiguration(conf);
        return this;
    }

    public ServiceCallConfigurationDefinition customFilter(ServiceFilter serviceFilter) {
        CustomServiceCallServiceFilterConfiguration conf = new CustomServiceCallServiceFilterConfiguration();
        conf.setServiceFilter(serviceFilter);
        this.setServiceFilterConfiguration(conf);
        return this;
    }

    public ServiceCallConfigurationDefinition defaultLoadBalancer() {
        DefaultServiceCallServiceLoadBalancerConfiguration conf = new DefaultServiceCallServiceLoadBalancerConfiguration();
        this.setLoadBalancerConfiguration(conf);
        return this;
    }

    public ServiceCallConfigurationDefinition ribbonLoadBalancer() {
        RibbonServiceCallServiceLoadBalancerConfiguration conf = new RibbonServiceCallServiceLoadBalancerConfiguration();
        this.setLoadBalancerConfiguration(conf);
        return this;
    }

    public ServiceCallConfigurationDefinition ribbonLoadBalancer(String clientName) {
        RibbonServiceCallServiceLoadBalancerConfiguration conf = new RibbonServiceCallServiceLoadBalancerConfiguration();
        conf.setClientName(clientName);
        this.setLoadBalancerConfiguration(conf);
        return this;
    }
}

