/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.persistence.api;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.opennms.netmgt.flows.classification.persistence.api.Group;
import org.opennms.netmgt.flows.classification.persistence.api.Rule;

public class GroupBuilder {
    private final Group group = new Group();

    public GroupBuilder withName(String name) {
        this.group.setName(name);
        return this;
    }

    public GroupBuilder withRule(Rule rule) {
        this.group.addRule(rule);
        return this;
    }

    public GroupBuilder withDescription(String description) {
        this.group.setDescription(description);
        return this;
    }

    public GroupBuilder withPriority(int priority) {
        this.group.setPriority(priority);
        return this;
    }

    public GroupBuilder withEnabled(boolean enabled) {
        this.group.setEnabled(enabled);
        return this;
    }

    public GroupBuilder withReadOnly(boolean readOnly) {
        this.group.setReadOnly(readOnly);
        return this;
    }

    public GroupBuilder withRules(Supplier<List<Rule>> rulesSupplier) {
        Objects.requireNonNull(rulesSupplier);
        for (Rule rule : rulesSupplier.get()) {
            this.group.addRule(rule);
        }
        return this;
    }

    public Group build() {
        if (Strings.isNullOrEmpty((String)this.group.getName())) {
            throw new IllegalStateException("Cannot build rule, because required field 'name' is null or empty");
        }
        return this.group;
    }
}

