/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.enlinkd.model.OspfElement;
import org.opennms.netmgt.enlinkd.model.OspfLink;
import org.opennms.netmgt.enlinkd.model.OspfLinkTopologyEntity;
import org.opennms.netmgt.enlinkd.persistence.api.OspfElementDao;
import org.opennms.netmgt.enlinkd.persistence.api.OspfLinkDao;
import org.opennms.netmgt.enlinkd.service.api.CompositeKey;
import org.opennms.netmgt.enlinkd.service.api.OspfTopologyService;
import org.opennms.netmgt.enlinkd.service.api.TopologyConnection;
import org.opennms.netmgt.enlinkd.service.impl.TopologyServiceImpl;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class OspfTopologyServiceImpl
extends TopologyServiceImpl
implements OspfTopologyService {
    private static final Logger LOG = LoggerFactory.getLogger(OspfTopologyServiceImpl.class);
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    private OspfLinkDao m_ospfLinkDao;
    private OspfElementDao m_ospfElementDao;

    @Override
    public void delete(int nodeid) {
        this.m_ospfElementDao.deleteByNodeId(nodeid);
        this.m_ospfLinkDao.deleteByNodeId(nodeid);
        this.m_ospfElementDao.flush();
        this.m_ospfLinkDao.flush();
    }

    @Override
    public void reconcile(int nodeId, Date now) {
        OspfElement element = this.m_ospfElementDao.findByNodeId(nodeId);
        if (element != null && element.getOspfNodeLastPollTime().getTime() < now.getTime()) {
            this.m_ospfElementDao.delete(element);
            this.m_ospfElementDao.flush();
        }
        this.m_ospfLinkDao.deleteByNodeIdOlderThen(nodeId, now);
        this.m_ospfLinkDao.flush();
    }

    @Override
    @Transactional
    public void store(int nodeId, OspfElement element) {
        if (element == null) {
            return;
        }
        OspfElement dbelement = this.m_ospfElementDao.findByNodeId(nodeId);
        if (dbelement != null) {
            dbelement.merge(element);
            this.m_ospfElementDao.saveOrUpdate(dbelement);
            this.m_ospfElementDao.flush();
            return;
        }
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(nodeId));
        element.setNode(node);
        element.setOspfNodeLastPollTime(element.getOspfNodeCreateTime());
        this.m_ospfElementDao.saveOrUpdate(element);
        this.m_ospfElementDao.flush();
        this.updatesAvailable();
    }

    @Override
    public void store(int nodeId, OspfLink link) {
        if (link == null) {
            return;
        }
        this.saveOspfLink(nodeId, link);
        this.updatesAvailable();
    }

    private void saveOspfLink(final int nodeId, final OspfLink saveMe) {
        new UpsertTemplate<OspfLink, OspfLinkDao>(this.m_transactionManager, this.m_ospfLinkDao){

            @Override
            protected OspfLink query() {
                return ((OspfLinkDao)this.m_dao).get(nodeId, saveMe.getOspfRemRouterId(), saveMe.getOspfRemIpAddr(), saveMe.getOspfRemAddressLessIndex());
            }

            @Override
            protected OspfLink doUpdate(OspfLink dbOspfLink) {
                dbOspfLink.merge(saveMe);
                ((OspfLinkDao)this.m_dao).update(dbOspfLink);
                ((OspfLinkDao)this.m_dao).flush();
                return dbOspfLink;
            }

            @Override
            protected OspfLink doInsert() {
                OnmsNode node = new OnmsNode();
                node.setId(Integer.valueOf(nodeId));
                saveMe.setNode(node);
                saveMe.setOspfLinkLastPollTime(saveMe.getOspfLinkCreateTime());
                ((OspfLinkDao)this.m_dao).saveOrUpdate(saveMe);
                ((OspfLinkDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    public OspfLinkDao getOspfLinkDao() {
        return this.m_ospfLinkDao;
    }

    public void setOspfLinkDao(OspfLinkDao ospfLinkDao) {
        this.m_ospfLinkDao = ospfLinkDao;
    }

    public OspfElementDao getOspfElementDao() {
        return this.m_ospfElementDao;
    }

    public void setOspfElementDao(OspfElementDao ospfElementDao) {
        this.m_ospfElementDao = ospfElementDao;
    }

    @Override
    public List<OspfElement> findAllOspfElements() {
        return this.m_ospfElementDao.findAll();
    }

    @Override
    public List<TopologyConnection<OspfLinkTopologyEntity, OspfLinkTopologyEntity>> match() {
        List<OspfLinkTopologyEntity> allLinks = this.getTopologyEntityCache().getOspfLinkTopologyEntities();
        ArrayList<TopologyConnection<OspfLinkTopologyEntity, OspfLinkTopologyEntity>> results = new ArrayList<TopologyConnection<OspfLinkTopologyEntity, OspfLinkTopologyEntity>>();
        HashSet<Integer> parsed = new HashSet<Integer>();
        HashMap<CompositeKey, OspfLinkTopologyEntity> targetLinks = new HashMap<CompositeKey, OspfLinkTopologyEntity>();
        for (OspfLinkTopologyEntity targetLink : allLinks) {
            targetLinks.put(new CompositeKey(targetLink.getOspfIpAddr(), targetLink.getOspfRemIpAddr()), targetLink);
        }
        for (OspfLinkTopologyEntity sourceLink : allLinks) {
            OspfLinkTopologyEntity targetLink;
            if (parsed.contains(sourceLink.getId())) continue;
            parsed.add(sourceLink.getId());
            if (LOG.isDebugEnabled()) {
                LOG.debug("getOspfLinks: source: {}", (Object)sourceLink);
            }
            if ((targetLink = (OspfLinkTopologyEntity)targetLinks.get(new CompositeKey(sourceLink.getOspfRemIpAddr(), sourceLink.getOspfIpAddr()))) == null) {
                LOG.debug("getOspfLinks: cannot find target for source: '{}'", (Object)sourceLink.getId());
                continue;
            }
            if (sourceLink.getId().equals(targetLink.getId()) || parsed.contains(targetLink.getId())) continue;
            LOG.debug("getOspfLinks: target: {}", (Object)targetLink);
            parsed.add(targetLink.getId());
            results.add(TopologyConnection.of(sourceLink, targetLink));
        }
        return results;
    }
}

