/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.xml.schema.datacollection;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.opennms.integration.api.xml.schema.datacollection.Parameter;

@XmlRootElement(name="property", namespace="http://xmlns.opennms.org/xsd/config/datacollection")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MibObjProperty {
    @XmlAttribute(name="instance", required=true)
    private String instance;
    @XmlAttribute(name="alias", required=false)
    private String alias;
    @XmlAttribute(name="class-name", required=false)
    private String className;
    @XmlElement(name="parameter", required=false)
    private List<Parameter> parameters;
    @XmlTransient
    private String groupName;

    public String getInstance() {
        return this.instance;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getClassName() {
        return this.className;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public String getParameterValue(String key) {
        return this.getParameterValue(key, null);
    }

    public String getParameterValue(String key, String defaultValue) {
        for (Parameter p : this.parameters) {
            if (!p.getKey().equals(key)) continue;
            return p.getValue();
        }
        return defaultValue;
    }

    public void addParameter(String key, String value) {
        this.parameters.add(new Parameter(key, value));
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.instance == null ? 0 : this.instance.hashCode());
        result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MibObjProperty)) {
            return false;
        }
        MibObjProperty other = (MibObjProperty)obj;
        if (this.instance == null ? other.instance != null : !this.instance.equals(other.instance)) {
            return false;
        }
        if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
            return false;
        }
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
    }

    public String toString() {
        return "MibObjProperty [instance=" + this.instance + ", alias=" + this.alias + ", className=" + this.className + ", parameters=" + this.parameters + ", groupName=" + this.groupName + "]";
    }
}

