/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.xml;

import java.util.List;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.config.events.AlarmType;
import org.opennms.integration.api.v1.config.events.EventDefinition;
import org.opennms.integration.api.v1.config.events.LogMessage;
import org.opennms.integration.api.v1.config.events.LogMsgDestType;
import org.opennms.integration.api.v1.config.events.MaskElement;
import org.opennms.integration.api.v1.model.Severity;
import org.opennms.integration.api.xml.ClasspathXmlLoader;
import org.opennms.integration.api.xml.schema.eventconf.AlarmData;
import org.opennms.integration.api.xml.schema.eventconf.Event;
import org.opennms.integration.api.xml.schema.eventconf.Events;
import org.opennms.integration.api.xml.schema.eventconf.LogDestType;
import org.opennms.integration.api.xml.schema.eventconf.Logmsg;
import org.opennms.integration.api.xml.schema.eventconf.ManagedObject;
import org.opennms.integration.api.xml.schema.eventconf.Mask;
import org.opennms.integration.api.xml.schema.eventconf.Maskelement;
import org.opennms.integration.api.xml.schema.eventconf.Parameter;
import org.opennms.integration.api.xml.schema.eventconf.UpdateField;
import org.opennms.integration.api.xml.schema.eventconf.Varbind;

public class ClasspathEventDefinitionLoader
extends ClasspathXmlLoader<Events> {
    public ClasspathEventDefinitionLoader(Class<?> clazz, String ... fileNames) {
        super(clazz, Events.class, "events", fileNames);
    }

    public List<EventDefinition> getEventDefinitions() {
        return this.getObjects().stream().flatMap(e -> ClasspathEventDefinitionLoader.toEventDefinitions(e).stream()).collect(Collectors.toList());
    }

    private static List<EventDefinition> toEventDefinitions(Events events) {
        return events.getEvents().stream().map(ClasspathEventDefinitionLoader::toEventDefinition).collect(Collectors.toList());
    }

    private static EventDefinition toEventDefinition(final Event e) {
        final Severity severity = Severity.get((String)e.getSeverity());
        final LogMessage logMessage = ClasspathEventDefinitionLoader.toLogMessage(e.getLogmsg());
        final org.opennms.integration.api.v1.config.events.AlarmData alarmData = ClasspathEventDefinitionLoader.toAlarmData(e.getAlarmData());
        final org.opennms.integration.api.v1.config.events.Mask mask = ClasspathEventDefinitionLoader.toMask(e.getMask());
        final List parameters = e.getParameters().stream().map(ClasspathEventDefinitionLoader::toParameter).collect(Collectors.toList());
        EventDefinition def = new EventDefinition(){

            public int getPriority() {
                return e.getPriority();
            }

            public String getUei() {
                return e.getUei();
            }

            public String getLabel() {
                return e.getEventLabel();
            }

            public Severity getSeverity() {
                return severity;
            }

            public String getDescription() {
                return e.getDescr();
            }

            public String getOperatorInstructions() {
                return e.getOperinstruct();
            }

            public LogMessage getLogMessage() {
                return logMessage;
            }

            public org.opennms.integration.api.v1.config.events.AlarmData getAlarmData() {
                return alarmData;
            }

            public org.opennms.integration.api.v1.config.events.Mask getMask() {
                return mask;
            }

            public List<org.opennms.integration.api.v1.config.events.Parameter> getParameters() {
                return parameters;
            }
        };
        return def;
    }

    private static org.opennms.integration.api.v1.config.events.Parameter toParameter(final Parameter p) {
        org.opennms.integration.api.v1.config.events.Parameter parm = new org.opennms.integration.api.v1.config.events.Parameter(){

            public String getName() {
                return p.getName();
            }

            public String getValue() {
                return p.getValue();
            }

            public boolean shouldExpand() {
                return p.getExpand();
            }
        };
        return parm;
    }

    private static org.opennms.integration.api.v1.config.events.Mask toMask(Mask eMask) {
        if (eMask == null) {
            return null;
        }
        final List maskElements = eMask.getMaskelements().stream().map(ClasspathEventDefinitionLoader::toMaskElemement).collect(Collectors.toList());
        final List varbinds = eMask.getVarbinds().stream().map(ClasspathEventDefinitionLoader::toVarbind).collect(Collectors.toList());
        org.opennms.integration.api.v1.config.events.Mask mask = new org.opennms.integration.api.v1.config.events.Mask(){

            public List<MaskElement> getMaskElements() {
                return maskElements;
            }

            public List<org.opennms.integration.api.v1.config.events.Varbind> getVarbinds() {
                return varbinds;
            }
        };
        return mask;
    }

    private static MaskElement toMaskElemement(final Maskelement el) {
        MaskElement maskElement = new MaskElement(){

            public String getName() {
                return el.getMename();
            }

            public List<String> getValues() {
                return el.getMevalues();
            }
        };
        return maskElement;
    }

    private static org.opennms.integration.api.v1.config.events.Varbind toVarbind(final Varbind vb) {
        org.opennms.integration.api.v1.config.events.Varbind varbind = new org.opennms.integration.api.v1.config.events.Varbind(){

            public String getTextualConvention() {
                return vb.getTextualConvention();
            }

            public Integer getNumber() {
                return vb.getVbnumber();
            }

            public List<String> getValues() {
                return vb.getVbvalues();
            }
        };
        return varbind;
    }

    private static LogMessage toLogMessage(final Logmsg log) {
        final LogMsgDestType dest = ClasspathEventDefinitionLoader.toLogMsgDestType(log.getDest());
        LogMessage logMsg = new LogMessage(){

            public String getContent() {
                return log.getContent();
            }

            public LogMsgDestType getDestination() {
                return dest;
            }
        };
        return logMsg;
    }

    private static LogMsgDestType toLogMsgDestType(LogDestType dest) {
        if (dest != null) {
            switch (dest) {
                case LOGNDISPLAY: {
                    return LogMsgDestType.LOGNDISPLAY;
                }
                case DISPLAYONLY: {
                    return LogMsgDestType.DISPLAYONLY;
                }
                case LOGONLY: {
                    return LogMsgDestType.LOGONLY;
                }
                case SUPPRESS: {
                    return LogMsgDestType.SUPPRESS;
                }
                case DONOTPERSIST: {
                    return LogMsgDestType.DONOTPERSIST;
                }
                case DISCARDTRAPS: {
                    return LogMsgDestType.DISCARDTRAPS;
                }
            }
        }
        return LogMsgDestType.LOGNDISPLAY;
    }

    private static org.opennms.integration.api.v1.config.events.AlarmData toAlarmData(final AlarmData alarm) {
        if (alarm == null) {
            return null;
        }
        final List updateFields = alarm.getUpdateFields().stream().map(ClasspathEventDefinitionLoader::toUpdateField).collect(Collectors.toList());
        final AlarmType type = AlarmType.fromId((Integer)alarm.getAlarmType());
        final org.opennms.integration.api.v1.config.events.ManagedObject managedObject = ClasspathEventDefinitionLoader.toManagedObject(alarm.getManagedObject());
        org.opennms.integration.api.v1.config.events.AlarmData alarmData = new org.opennms.integration.api.v1.config.events.AlarmData(){

            public String getReductionKey() {
                return alarm.getReductionKey();
            }

            public AlarmType getType() {
                return type;
            }

            public String getClearKey() {
                return alarm.getClearKey();
            }

            public boolean isAutoClean() {
                return alarm.getAutoClean();
            }

            public List<org.opennms.integration.api.v1.config.events.UpdateField> getUpdateFields() {
                return updateFields;
            }

            public org.opennms.integration.api.v1.config.events.ManagedObject getManagedObject() {
                return managedObject;
            }
        };
        return alarmData;
    }

    private static org.opennms.integration.api.v1.config.events.ManagedObject toManagedObject(final ManagedObject mo) {
        if (mo == null) {
            return null;
        }
        org.opennms.integration.api.v1.config.events.ManagedObject managedObject = new org.opennms.integration.api.v1.config.events.ManagedObject(){

            public String getType() {
                return mo.getType();
            }
        };
        return managedObject;
    }

    private static org.opennms.integration.api.v1.config.events.UpdateField toUpdateField(final UpdateField field) {
        org.opennms.integration.api.v1.config.events.UpdateField updateField = new org.opennms.integration.api.v1.config.events.UpdateField(){

            public String getName() {
                return field.getFieldName();
            }

            public boolean isUpdatedOnReduction() {
                return field.getUpdateOnReduction();
            }
        };
        return updateField;
    }
}

