/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2017-2017 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2017 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/

package org.opennms.web.rest.v1;

import javax.xml.bind.annotation.XmlRootElement;

import org.opennms.web.rest.v1.config.TicketerConfig;
import org.opennms.web.rest.v1.config.DatetimeformatConfig;


@XmlRootElement(name="info")
public class InfoDTO {
    private String displayVersion;
    private String version;
    private String packageName;
    private String packageDescription;
    private TicketerConfig ticketerConfig;
    private DatetimeformatConfig datetimeformatConfig;

    public DatetimeformatConfig getDatetimeformatConfig() {
        return datetimeformatConfig;
    }

    public void setDatetimeformatConfig(DatetimeformatConfig datetimeformatConfig) {
        this.datetimeformatConfig = datetimeformatConfig;
    }

    public void setDisplayVersion(String displayVersion) {
        this.displayVersion = displayVersion;
    }

    public String getDisplayVersion() {
        return displayVersion;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return version;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageDescription(String packageDescription) {
        this.packageDescription = packageDescription;
    }

    public String getPackageDescription() {
        return packageDescription;
    }

    public void setTicketerConfig(TicketerConfig ticketerConfig) {
        this.ticketerConfig = ticketerConfig;
    }

    public TicketerConfig getTicketerConfig() {
        return ticketerConfig;
    }
}
