/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2018-2018 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2018 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/

package org.opennms.netmgt.config.api;

import java.net.InetAddress;

public interface PathOutageConfig {
    /**
     * Returns true if the path outage feature is enabled. If enabled, the code
     * looks for a critical path specification when processing nodeDown events.
     * If a critical path exists for the node, it will be tested. If the
     * critical path fails to respond, the eventReason parameter on the
     * nodeDown event is set to "pathOutage". This parameter will be used by
     * notifd to suppress nodeDown notification.
     *
     * @return a boolean.
     */
    boolean isPathOutageEnabled();

    int getDefaultCriticalPathTimeout();

    int getDefaultCriticalPathRetries();

    InetAddress getDefaultCriticalPathIp();
}
