/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2013-2014 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2014 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/

package org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui;

import org.discotools.gwt.leaflet.client.jsobject.JSObject;

//this class wraps javascript helper methods and also return JSObject objects for state data
//US state data from United States Census Cartographic Boundary Files
class StatesData{

    protected StatesData(){}

    public static native JSObject getInstance()
    /*-{
    	 return {
					"type": "FeatureCollection",
					"features": [
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US04", "STATE": 0, "name": "Arizona", "LSAD": "", "CENSUSAREA": 113594.084000 }, "geometry": { "type": "Polygon", "coordinates": [ [ [ -112.538593, 37.000674 ], [ -112.534545, 37.000684 ], [ -112.368946, 37.001125 ], [ -112.357690, 37.001025 ], [ -111.412784, 37.001478 ], [ -111.405869, 37.001481 ], [ -111.405517, 37.001497 ], [ -111.189888, 37.000959 ], [ -110.750690, 37.003197 ], [ -110.495259, 37.003875 ], [ -110.331050, 36.998216 ], [ -110.000677, 36.997968 ], [ -109.381226, 36.999148 ], [ -109.378039, 36.999135 ], [ -109.270097, 36.999266 ], [ -109.268213, 36.999242 ], [ -109.263390, 36.999263 ], [ -109.246917, 36.999346 ], [ -109.233848, 36.999266 ], [ -109.181196, 36.999271 ], [ -109.045223, 36.999084 ], [ -109.045244, 36.969489 ], [ -109.045272, 36.968871 ], [ -109.045407, 36.874998 ], [ -109.045433, 36.874589 ], [ -109.045973, 36.002338 ], [ -109.046011, 35.925896 ], [ -109.046054, 35.925860 ], [ -109.046055, 35.888721 ], [ -109.046024, 35.879800 ], [ -109.046295, 35.616517 ], [ -109.046296, 35.614251 ], [ -109.046509, 35.546440 ], [ -109.046481, 35.546326 ], [ -109.046082, 35.174665 ], [ -109.045851, 34.959718 ], [ -109.046156, 34.579291 ], [ -109.046182, 34.522553 ], [ -109.046182, 34.522393 ], [ -109.046627, 33.778233 ], [ -109.046870, 33.372654 ], [ -109.047045, 33.369280 ], [ -109.046909, 33.365570 ], [ -109.046827, 33.365272 ], [ -109.047237, 33.208965 ], [ -109.047116, 33.137995 ], [ -109.047117, 33.137559 ], [ -109.047013, 33.092917 ], [ -109.046905, 33.091931 ], [ -109.047453, 33.069427 ], [ -109.047480, 33.068420 ], [ -109.047117, 32.777570 ], [ -109.047117, 32.777569 ], [ -109.047638, 32.693439 ], [ -109.047645, 32.689988 ], [ -109.047653, 32.686327 ], [ -109.047653, 32.681379 ], [ -109.047926, 32.426376 ], [ -109.048286, 32.089114 ], [ -109.048296, 32.084093 ], [ -109.048731, 32.028174 ], [ -109.048599, 32.013651 ], [ -109.048590, 31.870791 ], [ -109.048769, 31.861383 ], [ -109.048763, 31.810776 ], [ -109.049195, 31.796551 ], [ -109.049813, 31.499528 ], [ -109.049843, 31.499515 ], [ -109.050044, 31.332502 ], [ -109.426931, 31.334033 ], [ -110.460172, 31.333051 ], [ -110.760997, 31.332765 ], [ -110.976828, 31.332560 ], [ -111.098097, 31.339836 ], [ -111.366635, 31.425880 ], [ -111.579530, 31.494095 ], [ -112.246102, 31.704195 ], [ -112.867074, 31.895488 ], [ -113.125961, 31.972780 ], [ -113.333794, 32.038521 ], [ -113.493196, 32.088943 ], [ -114.250775, 32.323910 ], [ -114.813613, 32.494277 ], [ -114.809393, 32.617119 ], [ -114.807390, 32.621332 ], [ -114.799302, 32.625115 ], [ -114.781872, 32.625050 ], [ -114.753111, 32.658304 ], [ -114.748000, 32.664184 ], [ -114.719633, 32.718763 ], [ -114.678632, 32.736614 ], [ -114.677091, 32.736218 ], [ -114.658840, 32.733830 ], [ -114.658260, 32.733799 ], [ -114.615585, 32.728446 ], [ -114.615733, 32.729427 ], [ -114.496827, 32.822119 ], [ -114.496284, 32.822326 ], [ -114.465715, 32.879191 ], [ -114.465715, 32.879420 ], [ -114.462890, 32.905797 ], [ -114.468605, 32.971649 ], [ -114.511343, 33.023455 ], [ -114.516912, 33.026871 ], [ -114.523578, 33.030961 ], [ -114.571653, 33.036624 ], [ -114.578287, 33.035375 ], [ -114.584765, 33.028231 ], [ -114.589778, 33.026228 ], [ -114.606282, 33.025703 ], [ -114.623870, 33.028720 ], [ -114.675104, 33.047532 ], [ -114.707819, 33.091102 ], [ -114.706175, 33.105335 ], [ -114.696829, 33.131209 ], [ -114.687074, 33.142196 ], [ -114.679359, 33.159519 ], [ -114.675360, 33.185489 ], [ -114.672088, 33.258499 ], [ -114.700103, 33.341045 ], [ -114.721233, 33.396912 ], [ -114.665278, 33.415358 ], [ -114.627125, 33.433554 ], [ -114.622918, 33.456561 ], [ -114.594534, 33.495059 ], [ -114.558898, 33.531819 ], [ -114.535664, 33.568788 ], [ -114.535965, 33.569154 ], [ -114.540300, 33.580615 ], [ -114.540617, 33.591412 ], [ -114.530348, 33.679245 ], [ -114.523959, 33.685879 ], [ -114.519113, 33.688473 ], [ -114.496489, 33.696901 ], [ -114.494197, 33.707922 ], [ -114.504340, 33.756381 ], [ -114.523365, 33.806120 ], [ -114.525539, 33.838614 ], [ -114.518434, 33.917518 ], [ -114.499883, 33.961789 ], [ -114.463610, 33.993431 ], [ -114.438266, 34.022609 ], [ -114.434949, 34.037784 ], [ -114.435429, 34.079727 ], [ -114.433380, 34.088413 ], [ -114.420499, 34.103466 ], [ -114.411681, 34.110031 ], [ -114.401352, 34.111652 ], [ -114.390565, 34.110084 ], [ -114.366521, 34.118575 ], [ -114.321618, 34.138093 ], [ -114.312592, 34.144453 ], [ -114.244191, 34.179625 ], [ -114.225861, 34.201774 ], [ -114.164476, 34.251667 ], [ -114.133264, 34.258462 ], [ -114.131489, 34.260387 ], [ -114.138282, 34.303230 ], [ -114.176909, 34.349306 ], [ -114.199482, 34.361373 ], [ -114.264317, 34.401329 ], [ -114.339627, 34.451435 ], [ -114.452547, 34.653494 ], [ -114.465607, 34.692260 ], [ -114.552682, 34.766871 ], [ -114.633051, 34.869971 ], [ -114.635176, 34.875003 ], [ -114.636725, 34.889107 ], [ -114.630877, 34.907263 ], [ -114.629015, 34.986148 ], [ -114.629190, 34.991887 ], [ -114.633013, 35.002085 ], [ -114.633544, 35.015644 ], [ -114.635469, 35.028266 ], [ -114.621956, 35.094678 ], [ -114.599120, 35.121050 ], [ -114.584300, 35.124999 ], [ -114.578524, 35.128750 ], [ -114.572747, 35.138725 ], [ -114.569569, 35.163053 ], [ -114.569238, 35.183480 ], [ -114.595931, 35.325234 ], [ -114.604314, 35.353584 ], [ -114.627137, 35.409504 ], [ -114.652005, 35.429165 ], [ -114.662125, 35.444241 ], [ -114.677643, 35.489742 ], [ -114.676733, 35.499063 ], [ -114.674981, 35.510564 ], [ -114.671147, 35.520641 ], [ -114.653806, 35.599490 ], [ -114.653406, 35.610789 ], [ -114.657506, 35.618289 ], [ -114.676707, 35.640989 ], [ -114.689407, 35.651412 ], [ -114.700308, 35.700387 ], [ -114.707710, 35.811885 ], [ -114.705611, 35.848884 ], [ -114.704211, 35.851984 ], [ -114.706130, 35.878712 ], [ -114.731296, 35.945157 ], [ -114.743576, 35.983721 ], [ -114.755618, 36.087166 ], [ -114.744857, 36.098693 ], [ -114.736165, 36.104367 ], [ -114.631716, 36.142306 ], [ -114.572031, 36.151610 ], [ -114.513256, 36.151217 ], [ -114.381446, 36.141665 ], [ -114.365835, 36.133722 ], [ -114.328777, 36.105501 ], [ -114.310857, 36.083787 ], [ -114.307235, 36.076544 ], [ -114.303614, 36.066456 ], [ -114.292663, 36.051118 ], [ -114.263146, 36.025937 ], [ -114.252651, 36.020193 ], [ -114.238799, 36.014561 ], [ -114.233289, 36.014289 ], [ -114.213690, 36.015613 ], [ -114.154130, 36.023862 ], [ -114.148774, 36.027310 ], [ -114.138202, 36.041284 ], [ -114.125796, 36.077531 ], [ -114.120193, 36.102228 ], [ -114.063021, 36.186942 ], [ -114.060302, 36.189363 ], [ -114.046838, 36.194069 ], [ -114.047106, 36.250591 ], [ -114.048515, 36.289598 ], [ -114.046403, 36.371873 ], [ -114.046488, 36.473449 ], [ -114.050562, 36.656259 ], [ -114.050578, 36.800173 ], [ -114.050583, 36.843141 ], [ -114.050600, 37.000396 ], [ -113.965907, 37.000025 ], [ -113.965907, 36.999976 ], [ -112.966471, 37.000219 ], [ -112.899366, 37.000319 ], [ -112.609787, 37.000753 ], [ -112.558974, 37.000692 ], [ -112.545094, 37.000734 ], [ -112.540368, 37.000669 ], [ -112.538593, 37.000674 ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US05", "STATE": 1, "name": "Arkansas", "LSAD": "", "CENSUSAREA": 52035.477000 }, "geometry": { "type": "Polygon", "coordinates": [ [ [ -94.042964, 33.019219 ], [ -94.043036, 33.079485 ], [ -94.042870, 33.092727 ], [ -94.043007, 33.133890 ], [ -94.043077, 33.138162 ], [ -94.043185, 33.143476 ], [ -94.042875, 33.199785 ], [ -94.042892, 33.202666 ], [ -94.042876, 33.215219 ], [ -94.042730, 33.241823 ], [ -94.043004, 33.250128 ], [ -94.043050, 33.260904 ], [ -94.042990, 33.271227 ], [ -94.042990, 33.271243 ], [ -94.043067, 33.330498 ], [ -94.043067, 33.347351 ], [ -94.043067, 33.352097 ], [ -94.043128, 33.358757 ], [ -94.042869, 33.371170 ], [ -94.043053, 33.377716 ], [ -94.042887, 33.420225 ], [ -94.042988, 33.431024 ], [ -94.042988, 33.435824 ], [ -94.043188, 33.470324 ], [ -94.043279, 33.491030 ], [ -94.043009, 33.493039 ], [ -94.043375, 33.542315 ], [ -94.043428, 33.551425 ], [ -94.043450, 33.552253 ], [ -94.066846, 33.568909 ], [ -94.085243, 33.575546 ], [ -94.181805, 33.593217 ], [ -94.252656, 33.586144 ], [ -94.257801, 33.582508 ], [ -94.355945, 33.543180 ], [ -94.409329, 33.568265 ], [ -94.464336, 33.598819 ], [ -94.470963, 33.605940 ], [ -94.478366, 33.620847 ], [ -94.485875, 33.637867 ], [ -94.485577, 33.653310 ], [ -94.485528, 33.663388 ], [ -94.484520, 33.687909 ], [ -94.484616, 33.691592 ], [ -94.483840, 33.711332 ], [ -94.483874, 33.716733 ], [ -94.482870, 33.750564 ], [ -94.482862, 33.750780 ], [ -94.482777, 33.753638 ], [ -94.482682, 33.756286 ], [ -94.481842, 33.789008 ], [ -94.481543, 33.795719 ], [ -94.481361, 33.802649 ], [ -94.481355, 33.802887 ], [ -94.480574, 33.830166 ], [ -94.479954, 33.851330 ], [ -94.478994, 33.881197 ], [ -94.478842, 33.881485 ], [ -94.477387, 33.937759 ], [ -94.477318, 33.940932 ], [ -94.477038, 33.953838 ], [ -94.476957, 33.957365 ], [ -94.474895, 34.019655 ], [ -94.474896, 34.021838 ], [ -94.474896, 34.021877 ], [ -94.470292, 34.189864 ], [ -94.465847, 34.352073 ], [ -94.465425, 34.359548 ], [ -94.464176, 34.402713 ], [ -94.463816, 34.414465 ], [ -94.463671, 34.419585 ], [ -94.461149, 34.507457 ], [ -94.460058, 34.545264 ], [ -94.460052, 34.547869 ], [ -94.457500, 34.634945 ], [ -94.457530, 34.642961 ], [ -94.454576, 34.728962 ], [ -94.450233, 34.855413 ], [ -94.450140, 34.858694 ], [ -94.450065, 34.861335 ], [ -94.449630, 34.875253 ], [ -94.449058, 34.890556 ], [ -94.449086, 34.894152 ], [ -94.449253, 34.895869 ], [ -94.447889, 34.933941 ], [ -94.441232, 35.119724 ], [ -94.440754, 35.128806 ], [ -94.439550, 35.169037 ], [ -94.439509, 35.171807 ], [ -94.439056, 35.193588 ], [ -94.439084, 35.197298 ], [ -94.438470, 35.208587 ], [ -94.438247, 35.210992 ], [ -94.437774, 35.239271 ], [ -94.437578, 35.242202 ], [ -94.435812, 35.271300 ], [ -94.435706, 35.274267 ], [ -94.435316, 35.275893 ], [ -94.435280, 35.287485 ], [ -94.435170, 35.291494 ], [ -94.434115, 35.306493 ], [ -94.431815, 35.362891 ], [ -94.432685, 35.380806 ], [ -94.433742, 35.386467 ], [ -94.433915, 35.387391 ], [ -94.431215, 35.394290 ], [ -94.431789, 35.397659 ], [ -94.463318, 35.582660 ], [ -94.464097, 35.587265 ], [ -94.464457, 35.588909 ], [ -94.465272, 35.594037 ], [ -94.472647, 35.638556 ], [ -94.487585, 35.726147 ], [ -94.488210, 35.729240 ], [ -94.492932, 35.759166 ], [ -94.493362, 35.761892 ], [ -94.494549, 35.768303 ], [ -94.499045, 35.793460 ], [ -94.499647, 35.796910 ], [ -94.500526, 35.802642 ], [ -94.500764, 35.803820 ], [ -94.501162, 35.806430 ], [ -94.503011, 35.817210 ], [ -94.504438, 35.826369 ], [ -94.505642, 35.833628 ], [ -94.507631, 35.845901 ], [ -94.522658, 35.934250 ], [ -94.522658, 35.934799 ], [ -94.522634, 35.934892 ], [ -94.522910, 35.936127 ], [ -94.524344, 35.944050 ], [ -94.524640, 35.945727 ], [ -94.528162, 35.965665 ], [ -94.528305, 35.966054 ], [ -94.532071, 35.987852 ], [ -94.533646, 35.996804 ], [ -94.534852, 36.002678 ], [ -94.535724, 36.007807 ], [ -94.547715, 36.077271 ], [ -94.547871, 36.078281 ], [ -94.552184, 36.102235 ], [ -94.561165, 36.152110 ], [ -94.562803, 36.161749 ], [ -94.562828, 36.161895 ], [ -94.565655, 36.178439 ], [ -94.566588, 36.183774 ], [ -94.571253, 36.210901 ], [ -94.571806, 36.213748 ], [ -94.574395, 36.229996 ], [ -94.574880, 36.232741 ], [ -94.575071, 36.233682 ], [ -94.576003, 36.240070 ], [ -94.577899, 36.249548 ], [ -94.577883, 36.250080 ], [ -94.586200, 36.299969 ], [ -94.593397, 36.345742 ], [ -94.599723, 36.387587 ], [ -94.601984, 36.402120 ], [ -94.602623, 36.405283 ], [ -94.605408, 36.421949 ], [ -94.611609, 36.461528 ], [ -94.613830, 36.476248 ], [ -94.615311, 36.484992 ], [ -94.617919, 36.499414 ], [ -94.559290, 36.499496 ], [ -94.519478, 36.499214 ], [ -94.111473, 36.498597 ], [ -94.110673, 36.498587 ], [ -94.100252, 36.498670 ], [ -94.098588, 36.498676 ], [ -94.077089, 36.498730 ], [ -93.963920, 36.498717 ], [ -93.959190, 36.498717 ], [ -93.921840, 36.498718 ], [ -93.906128, 36.498718 ], [ -93.866758, 36.498789 ], [ -93.728022, 36.499037 ], [ -93.727552, 36.499055 ], [ -93.718893, 36.499178 ], [ -93.709956, 36.499179 ], [ -93.700171, 36.499135 ], [ -93.584282, 36.498896 ], [ -93.584281, 36.498896 ], [ -93.514512, 36.498881 ], [ -93.507408, 36.498911 ], [ -93.426989, 36.498585 ], [ -93.396079, 36.498669 ], [ -93.394718, 36.498519 ], [ -93.315337, 36.498408 ], [ -93.315324, 36.498408 ], [ -93.296117, 36.498389 ], [ -93.088988, 36.498184 ], [ -93.087635, 36.498239 ], [ -93.069512, 36.498242 ], [ -93.068455, 36.498250 ], [ -93.013742, 36.498130 ], [ -92.894336, 36.497867 ], [ -92.894001, 36.497850 ], [ -92.854049, 36.497983 ], [ -92.838876, 36.498033 ], [ -92.838621, 36.498079 ], [ -92.772341, 36.497772 ], [ -92.772333, 36.497772 ], [ -92.529145, 36.497739 ], [ -92.318415, 36.497711 ], [ -92.309424, 36.497894 ], [ -92.216412, 36.498417 ], [ -92.214143, 36.498372 ], [ -92.211449, 36.498395 ], [ -92.199396, 36.498351 ], [ -92.150295, 36.498634 ], [ -92.137741, 36.498706 ], [ -92.120415, 36.498863 ], [ -92.120306, 36.498864 ], [ -92.098356, 36.498803 ], [ -92.074934, 36.498761 ], [ -92.057178, 36.498670 ], [ -92.055789, 36.498670 ], [ -92.028847, 36.498642 ], [ -92.019375, 36.498524 ], [ -91.988751, 36.498498 ], [ -91.985802, 36.498431 ], [ -91.865995, 36.498783 ], [ -91.864385, 36.498789 ], [ -91.805981, 36.498987 ], [ -91.802040, 36.498963 ], [ -91.799500, 36.498952 ], [ -91.784713, 36.499074 ], [ -91.766111, 36.499114 ], [ -91.726663, 36.499209 ], [ -91.687615, 36.499397 ], [ -91.686026, 36.499374 ], [ -91.672343, 36.499463 ], [ -91.642590, 36.499335 ], [ -91.631439, 36.499198 ], [ -91.601317, 36.499343 ], [ -91.596213, 36.499162 ], [ -91.549163, 36.499161 ], [ -91.539359, 36.499116 ], [ -91.536870, 36.499156 ], [ -91.529774, 36.499022 ], [ -91.450005, 36.497538 ], [ -91.446284, 36.497469 ], [ -91.436502, 36.497377 ], [ -91.433298, 36.497262 ], [ -91.407261, 36.497123 ], [ -91.407137, 36.497112 ], [ -91.405141, 36.497165 ], [ -91.404915, 36.497120 ], [ -91.227398, 36.497617 ], [ -91.218645, 36.497564 ], [ -91.217360, 36.497511 ], [ -91.126529, 36.497712 ], [ -91.096277, 36.497893 ], [ -91.095880, 36.497870 ], [ -91.017974, 36.498062 ], [ -91.008558, 36.498270 ], [ -90.963063, 36.498418 ], [ -90.960648, 36.498426 ], [ -90.879220, 36.498378 ], [ -90.876867, 36.498423 ], [ -90.876567, 36.498313 ], [ -90.873775, 36.498074 ], [ -90.850434, 36.498548 ], [ -90.784398, 36.498524 ], [ -90.782454, 36.498523 ], [ -90.765672, 36.498494 ], [ -90.711226, 36.498318 ], [ -90.693005, 36.498510 ], [ -90.653246, 36.498488 ], [ -90.648494, 36.498447 ], [ -90.612554, 36.498559 ], [ -90.605450, 36.498459 ], [ -90.594300, 36.498459 ], [ -90.585342, 36.498497 ], [ -90.576180, 36.498446 ], [ -90.576112, 36.498446 ], [ -90.500160, 36.498399 ], [ -90.495027, 36.498371 ], [ -90.494575, 36.498368 ], [ -90.339892, 36.498213 ], [ -90.228943, 36.497771 ], [ -90.220732, 36.497858 ], [ -90.220702, 36.497858 ], [ -90.217323, 36.497797 ], [ -90.193943, 36.497823 ], [ -90.152481, 36.497952 ], [ -90.154409, 36.496832 ], [ -90.156369, 36.487748 ], [ -90.133993, 36.437906 ], [ -90.072897, 36.393007 ], [ -90.064514, 36.382085 ], [ -90.063980, 36.303038 ], [ -90.076301, 36.280708 ], [ -90.083731, 36.272332 ], [ -90.114922, 36.265595 ], [ -90.198735, 36.201382 ], [ -90.220425, 36.184764 ], [ -90.319168, 36.089976 ], [ -90.364430, 36.013625 ], [ -90.368718, 35.995812 ], [ -90.342616, 35.995895 ], [ -90.339434, 35.996033 ], [ -90.292376, 35.996397 ], [ -90.288947, 35.996418 ], [ -90.288800, 35.996419 ], [ -90.158812, 35.997375 ], [ -90.127331, 35.997635 ], [ -90.126350, 35.997596 ], [ -89.972563, 35.998994 ], [ -89.965327, 35.998813 ], [ -89.961075, 35.999135 ], [ -89.959893, 35.999020 ], [ -89.959377, 35.999020 ], [ -89.959375, 35.999020 ], [ -89.901183, 35.999365 ], [ -89.896508, 35.999432 ], [ -89.875586, 35.999562 ], [ -89.875085, 35.999578 ], [ -89.874590, 35.999575 ], [ -89.869010, 35.999640 ], [ -89.770255, 36.000524 ], [ -89.769973, 36.000536 ], [ -89.737648, 36.000567 ], [ -89.737564, 36.000522 ], [ -89.733095, 36.000608 ], [ -89.719970, 35.974620 ], [ -89.686924, 35.947716 ], [ -89.687939, 35.905384 ], [ -89.688141, 35.896946 ], [ -89.714934, 35.906247 ], [ -89.733610, 35.904699 ], [ -89.756036, 35.896817 ], [ -89.765689, 35.891299 ], [ -89.771726, 35.879724 ], [ -89.773564, 35.871697 ], [ -89.772467, 35.865098 ], [ -89.769413, 35.861558 ], [ -89.749424, 35.852955 ], [ -89.729517, 35.847632 ], [ -89.709261, 35.838911 ], [ -89.702883, 35.834153 ], [ -89.701045, 35.828227 ], [ -89.703875, 35.820281 ], [ -89.821216, 35.756716 ], [ -89.865631, 35.746577 ], [ -89.889023, 35.750558 ], [ -89.905538, 35.759063 ], [ -89.909996, 35.759396 ], [ -89.950278, 35.738493 ], [ -89.956254, 35.733386 ], [ -89.958882, 35.723834 ], [ -89.955753, 35.690621 ], [ -89.937383, 35.665711 ], [ -89.922749, 35.655293 ], [ -89.906147, 35.651145 ], [ -89.890510, 35.652408 ], [ -89.884932, 35.655107 ], [ -89.909797, 35.537914 ], [ -89.933572, 35.533299 ], [ -89.957347, 35.528683 ], [ -90.017312, 35.555996 ], [ -90.028620, 35.555249 ], [ -90.032938, 35.553440 ], [ -90.039744, 35.548041 ], [ -90.034976, 35.480705 ], [ -90.034014, 35.468821 ], [ -90.047680, 35.459255 ], [ -90.059068, 35.457889 ], [ -90.067798, 35.466224 ], [ -90.072154, 35.470752 ], [ -90.074420, 35.472518 ], [ -90.107723, 35.476935 ], [ -90.152386, 35.436789 ], [ -90.169002, 35.421853 ], [ -90.179265, 35.385194 ], [ -90.178341, 35.382092 ], [ -90.166246, 35.374745 ], [ -90.143633, 35.374745 ], [ -90.135510, 35.376668 ], [ -90.093589, 35.393333 ], [ -90.089612, 35.379842 ], [ -90.086691, 35.369935 ], [ -90.114893, 35.303887 ], [ -90.153394, 35.302588 ], [ -90.158913, 35.300637 ], [ -90.163812, 35.296115 ], [ -90.168871, 35.281997 ], [ -90.166594, 35.274588 ], [ -90.158865, 35.262577 ], [ -90.152094, 35.255989 ], [ -90.140394, 35.252289 ], [ -90.116493, 35.255788 ], [ -90.105093, 35.254288 ], [ -90.097947, 35.249983 ], [ -90.077410, 35.225479 ], [ -90.074262, 35.218316 ], [ -90.073354, 35.211004 ], [ -90.064612, 35.140621 ], [ -90.065392, 35.137691 ], [ -90.083420, 35.121670 ], [ -90.090610, 35.118287 ], [ -90.100593, 35.116691 ], [ -90.109393, 35.118891 ], [ -90.142794, 35.135091 ], [ -90.160058, 35.128830 ], [ -90.174594, 35.116682 ], [ -90.193859, 35.061646 ], [ -90.295596, 35.040093 ], [ -90.309877, 35.009750 ], [ -90.309297, 34.995694 ], [ -90.253969, 34.954988 ], [ -90.244476, 34.937596 ], [ -90.250095, 34.907320 ], [ -90.293918, 34.860563 ], [ -90.307384, 34.846195 ], [ -90.407964, 34.832767 ], [ -90.414864, 34.831846 ], [ -90.423879, 34.834606 ], [ -90.436431, 34.855060 ], [ -90.461451, 34.856728 ], [ -90.473961, 34.852558 ], [ -90.478131, 34.832542 ], [ -90.467289, 34.782502 ], [ -90.479799, 34.769158 ], [ -90.494811, 34.767490 ], [ -90.501325, 34.769931 ], [ -90.519831, 34.782502 ], [ -90.537345, 34.784170 ], [ -90.549855, 34.763320 ], [ -90.554859, 34.727458 ], [ -90.533175, 34.707442 ], [ -90.509823, 34.689928 ], [ -90.508989, 34.679086 ], [ -90.521499, 34.663240 ], [ -90.539013, 34.659070 ], [ -90.549855, 34.662406 ], [ -90.564033, 34.665742 ], [ -90.576543, 34.657402 ], [ -90.575786, 34.641749 ], [ -90.570133, 34.524829 ], [ -90.565809, 34.435400 ], [ -90.575336, 34.415152 ], [ -90.613944, 34.390723 ], [ -90.658542, 34.375705 ], [ -90.764143, 34.363396 ], [ -90.856367, 34.238928 ], [ -90.868775, 34.228245 ], [ -90.894744, 34.229977 ], [ -90.911480, 34.223051 ], [ -90.913212, 34.210355 ], [ -90.895898, 34.191888 ], [ -90.880894, 34.180346 ], [ -90.880317, 34.169381 ], [ -90.893013, 34.155531 ], [ -90.918405, 34.154376 ], [ -90.934564, 34.130138 ], [ -90.933116, 34.124488 ], [ -90.931969, 34.120017 ], [ -90.928793, 34.107631 ], [ -90.912057, 34.095512 ], [ -90.888396, 34.087433 ], [ -90.879163, 34.065503 ], [ -90.887413, 34.032505 ], [ -90.964708, 34.007952 ], [ -91.018890, 34.003151 ], [ -91.089119, 33.972653 ], [ -91.088164, 33.960078 ], [ -91.036821, 33.914656 ], [ -91.067511, 33.840443 ], [ -91.139869, 33.777117 ], [ -91.144682, 33.750108 ], [ -91.136118, 33.728632 ], [ -91.126805, 33.707814 ], [ -91.127900, 33.695762 ], [ -91.132831, 33.688092 ], [ -91.139953, 33.683709 ], [ -91.148170, 33.679327 ], [ -91.176110, 33.684257 ], [ -91.185971, 33.679327 ], [ -91.188710, 33.669466 ], [ -91.193093, 33.656866 ], [ -91.186519, 33.645909 ], [ -91.157484, 33.626187 ], [ -91.130445, 33.606034 ], [ -91.134043, 33.594489 ], [ -91.152148, 33.582721 ], [ -91.224121, 33.567369 ], [ -91.228287, 33.559937 ], [ -91.232295, 33.552788 ], [ -91.215671, 33.529423 ], [ -91.125109, 33.472842 ], [ -91.118495, 33.449116 ], [ -91.131885, 33.430063 ], [ -91.184427, 33.419576 ], [ -91.141216, 33.298397 ], [ -91.110561, 33.245930 ], [ -91.085984, 33.221644 ], [ -91.087589, 33.145177 ], [ -91.125656, 33.038276 ], [ -91.157662, 33.011217 ], [ -91.166073, 33.004106 ], [ -91.265018, 33.005084 ], [ -91.284398, 33.005007 ], [ -91.312016, 33.005262 ], [ -91.322506, 33.005341 ], [ -91.325037, 33.005364 ], [ -91.326396, 33.005376 ], [ -91.329767, 33.005421 ], [ -91.333011, 33.005529 ], [ -91.376016, 33.005794 ], [ -91.425466, 33.006016 ], [ -91.435782, 33.006099 ], [ -91.460370, 33.006246 ], [ -91.559494, 33.006840 ], [ -91.572326, 33.006908 ], [ -91.579639, 33.006472 ], [ -91.579802, 33.006518 ], [ -91.609001, 33.006556 ], [ -91.617615, 33.006717 ], [ -91.626670, 33.006639 ], [ -91.950001, 33.007520 ], [ -91.951958, 33.007428 ], [ -92.069105, 33.008163 ], [ -92.222825, 33.009080 ], [ -92.292664, 33.010103 ], [ -92.335893, 33.010349 ], [ -92.362865, 33.010628 ], [ -92.370290, 33.010717 ], [ -92.469762, 33.012010 ], [ -92.501383, 33.012160 ], [ -92.503776, 33.012161 ], [ -92.711289, 33.014307 ], [ -92.715884, 33.014398 ], [ -92.723553, 33.014328 ], [ -92.724743, 33.014347 ], [ -92.724994, 33.014351 ], [ -92.733197, 33.014347 ], [ -92.830798, 33.015661 ], [ -92.844073, 33.016034 ], [ -92.844286, 33.016070 ], [ -92.854167, 33.016132 ], [ -92.867510, 33.016062 ], [ -92.946553, 33.016807 ], [ -92.971137, 33.017192 ], [ -92.988708, 33.017298 ], [ -93.070686, 33.017792 ], [ -93.073167, 33.017898 ], [ -93.081428, 33.017928 ], [ -93.100981, 33.017786 ], [ -93.101443, 33.017740 ], [ -93.154351, 33.017856 ], [ -93.197402, 33.017951 ], [ -93.238607, 33.017992 ], [ -93.308181, 33.018156 ], [ -93.308398, 33.018179 ], [ -93.340353, 33.018337 ], [ -93.377134, 33.018234 ], [ -93.467042, 33.018611 ], [ -93.489506, 33.018443 ], [ -93.490520, 33.018442 ], [ -93.490893, 33.018442 ], [ -93.520971, 33.018616 ], [ -93.520994, 33.018616 ], [ -93.524916, 33.018637 ], [ -93.531499, 33.018643 ], [ -93.804930, 33.019347 ], [ -93.814553, 33.019372 ], [ -94.024475, 33.019207 ], [ -94.027983, 33.019139 ], [ -94.035839, 33.019145 ], [ -94.041444, 33.019188 ], [ -94.042964, 33.019219 ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US06", "STATE": 2, "name": "California", "LSAD": "", "CENSUSAREA": 155779.220000 }, "geometry": { "type": "MultiPolygon", "coordinates": [ [ [ [ -120.248484, 33.999329 ], [ -120.247393, 34.001911 ], [ -120.238657, 34.007592 ], [ -120.230001, 34.010136 ], [ -120.221287, 34.010367 ], [ -120.208478, 34.005655 ], [ -120.195780, 34.004284 ], [ -120.167306, 34.008219 ], [ -120.151663, 34.018126 ], [ -120.147647, 34.024831 ], [ -120.140362, 34.025974 ], [ -120.135853, 34.026087 ], [ -120.115058, 34.019866 ], [ -120.090182, 34.019806 ], [ -120.073609, 34.024477 ], [ -120.062778, 34.031161 ], [ -120.061953, 34.033976 ], [ -120.057637, 34.037340 ], [ -120.055107, 34.037729 ], [ -120.043259, 34.035806 ], [ -120.044004, 34.024820 ], [ -120.047798, 34.021227 ], [ -120.050382, 34.013331 ], [ -120.048926, 34.009898 ], [ -120.046575, 34.000002 ], [ -120.041311, 33.994507 ], [ -120.025653, 33.985553 ], [ -120.011123, 33.979894 ], [ -120.003815, 33.979547 ], [ -119.984316, 33.983948 ], [ -119.978876, 33.983081 ], [ -119.979913, 33.969623 ], [ -119.976857, 33.956693 ], [ -119.971141, 33.950401 ], [ -119.970260, 33.944359 ], [ -119.973691, 33.942481 ], [ -120.000960, 33.941554 ], [ -120.017715, 33.936366 ], [ -120.046881, 33.919597 ], [ -120.048315, 33.917625 ], [ -120.048611, 33.915775 ], [ -120.049682, 33.914563 ], [ -120.077793, 33.908886 ], [ -120.098601, 33.907853 ], [ -120.105489, 33.904280 ], [ -120.109137, 33.899129 ], [ -120.121817, 33.895712 ], [ -120.168974, 33.919090 ], [ -120.179049, 33.927994 ], [ -120.189840, 33.947703 ], [ -120.192339, 33.950266 ], [ -120.198602, 33.952211 ], [ -120.200085, 33.956904 ], [ -120.209372, 33.972376 ], [ -120.224461, 33.989059 ], [ -120.248484, 33.999329 ] ] ], [ [ [ -119.789798, 34.057260 ], [ -119.770729, 34.055051 ], [ -119.766081, 34.055370 ], [ -119.763688, 34.057155 ], [ -119.755521, 34.056716 ], [ -119.739472, 34.049299 ], [ -119.726437, 34.047908 ], [ -119.712576, 34.043265 ], [ -119.704628, 34.037681 ], [ -119.686507, 34.019805 ], [ -119.637742, 34.013178 ], [ -119.619343, 34.016468 ], [ -119.612226, 34.021256 ], [ -119.604287, 34.031561 ], [ -119.608798, 34.035245 ], [ -119.609239, 34.037350 ], [ -119.593240, 34.049625 ], [ -119.573410, 34.050110 ], [ -119.566700, 34.053452 ], [ -119.529603, 34.041155 ], [ -119.520640, 34.034262 ], [ -119.521770, 34.032247 ], [ -119.532413, 34.024949 ], [ -119.538847, 34.023988 ], [ -119.542449, 34.021082 ], [ -119.548280, 34.009819 ], [ -119.547072, 34.005469 ], [ -119.554472, 33.997820 ], [ -119.560464, 33.995530 ], [ -119.575636, 33.996009 ], [ -119.590200, 33.989712 ], [ -119.596877, 33.988611 ], [ -119.619082, 33.987228 ], [ -119.621117, 33.988990 ], [ -119.647710, 33.987786 ], [ -119.662825, 33.985889 ], [ -119.690110, 33.972225 ], [ -119.706952, 33.969178 ], [ -119.712363, 33.965422 ], [ -119.714696, 33.961439 ], [ -119.721206, 33.959583 ], [ -119.742966, 33.963877 ], [ -119.750438, 33.963759 ], [ -119.758141, 33.959212 ], [ -119.795938, 33.962929 ], [ -119.842748, 33.970340 ], [ -119.873358, 33.980375 ], [ -119.877057, 33.985757 ], [ -119.883033, 34.000802 ], [ -119.884896, 34.008814 ], [ -119.882531, 34.011674 ], [ -119.876916, 34.023527 ], [ -119.876329, 34.032087 ], [ -119.892821, 34.045529 ], [ -119.916216, 34.058351 ], [ -119.923337, 34.069361 ], [ -119.919155, 34.077280 ], [ -119.912857, 34.077508 ], [ -119.891130, 34.072856 ], [ -119.857304, 34.071298 ], [ -119.825865, 34.059794 ], [ -119.818742, 34.052997 ], [ -119.807825, 34.052127 ], [ -119.789798, 34.057260 ] ] ], [ [ [ -120.462580, 34.042627 ], [ -120.440248, 34.036918 ], [ -120.418768, 34.052093 ], [ -120.415287, 34.054960 ], [ -120.411314, 34.052869 ], [ -120.403613, 34.050442 ], [ -120.396188, 34.050187 ], [ -120.390906, 34.051994 ], [ -120.374211, 34.062658 ], [ -120.368813, 34.067780 ], [ -120.368584, 34.071214 ], [ -120.370176, 34.074907 ], [ -120.368278, 34.076465 ], [ -120.362251, 34.073056 ], [ -120.354982, 34.059256 ], [ -120.360290, 34.055820 ], [ -120.358608, 34.050235 ], [ -120.346946, 34.046576 ], [ -120.331161, 34.049097 ], [ -120.319032, 34.041979 ], [ -120.313175, 34.036576 ], [ -120.302122, 34.023574 ], [ -120.304543, 34.021171 ], [ -120.317052, 34.018837 ], [ -120.347706, 34.020114 ], [ -120.355320, 34.017914 ], [ -120.357930, 34.015029 ], [ -120.375143, 34.018775 ], [ -120.409368, 34.032198 ], [ -120.415225, 34.032245 ], [ -120.419021, 34.028949 ], [ -120.427408, 34.025425 ], [ -120.454134, 34.028081 ], [ -120.459635, 34.031537 ], [ -120.465329, 34.038448 ], [ -120.462580, 34.042627 ] ] ], [ [ [ -119.543842, 33.280329 ], [ -119.532941, 33.284728 ], [ -119.528141, 33.284929 ], [ -119.505040, 33.272829 ], [ -119.482780, 33.263973 ], [ -119.465717, 33.259239 ], [ -119.458466, 33.254661 ], [ -119.429559, 33.228167 ], [ -119.444269, 33.219190 ], [ -119.464725, 33.215432 ], [ -119.476029, 33.215520 ], [ -119.500684, 33.220569 ], [ -119.511659, 33.223027 ], [ -119.517514, 33.226737 ], [ -119.545872, 33.233406 ], [ -119.564971, 33.247440 ], [ -119.565641, 33.250029 ], [ -119.566014, 33.252639 ], [ -119.570642, 33.257729 ], [ -119.578942, 33.278628 ], [ -119.562042, 33.271129 ], [ -119.555242, 33.273429 ], [ -119.547642, 33.280328 ], [ -119.543842, 33.280329 ] ] ], [ [ [ -119.422972, 34.004368 ], [ -119.427589, 34.006445 ], [ -119.437734, 34.010000 ], [ -119.441116, 34.012426 ], [ -119.441226, 34.014075 ], [ -119.433912, 34.015975 ], [ -119.421376, 34.015012 ], [ -119.411317, 34.008005 ], [ -119.396251, 34.005918 ], [ -119.389983, 34.006099 ], [ -119.366591, 34.016785 ], [ -119.357462, 34.015919 ], [ -119.376396, 34.010551 ], [ -119.391551, 34.002505 ], [ -119.414528, 34.004994 ], [ -119.422972, 34.004368 ] ] ], [ [ [ -118.524531, 32.895488 ], [ -118.535823, 32.906280 ], [ -118.551134, 32.945155 ], [ -118.560887, 32.957891 ], [ -118.573522, 32.969183 ], [ -118.586928, 33.008281 ], [ -118.596037, 33.015357 ], [ -118.606559, 33.014690 ], [ -118.605534, 33.030999 ], [ -118.594033, 33.035951 ], [ -118.575160, 33.033961 ], [ -118.569013, 33.029151 ], [ -118.564445, 33.024914 ], [ -118.564527, 33.018637 ], [ -118.559171, 33.006291 ], [ -118.540069, 32.980933 ], [ -118.529228, 32.970921 ], [ -118.496811, 32.933847 ], [ -118.485288, 32.923545 ], [ -118.479039, 32.920363 ], [ -118.460623, 32.909510 ], [ -118.446771, 32.895424 ], [ -118.369984, 32.839273 ], [ -118.353504, 32.821962 ], [ -118.356541, 32.817311 ], [ -118.360530, 32.819921 ], [ -118.379968, 32.824545 ], [ -118.387375, 32.825327 ], [ -118.394565, 32.823978 ], [ -118.401268, 32.820338 ], [ -118.425634, 32.800595 ], [ -118.429430, 32.805429 ], [ -118.428372, 32.806872 ], [ -118.444920, 32.820593 ], [ -118.476074, 32.841754 ], [ -118.487908, 32.844590 ], [ -118.496298, 32.851572 ], [ -118.506902, 32.868503 ], [ -118.508095, 32.871321 ], [ -118.507193, 32.876264 ], [ -118.524641, 32.893175 ], [ -118.524531, 32.895488 ] ] ], [ [ [ -118.500212, 33.449592 ], [ -118.499669, 33.447879 ], [ -118.485570, 33.446213 ], [ -118.477646, 33.448392 ], [ -118.445812, 33.428907 ], [ -118.423576, 33.427258 ], [ -118.382037, 33.409883 ], [ -118.370323, 33.409285 ], [ -118.368301, 33.407110 ], [ -118.365094, 33.388374 ], [ -118.324460, 33.348782 ], [ -118.316083, 33.342928 ], [ -118.310213, 33.335795 ], [ -118.303174, 33.320264 ], [ -118.305084, 33.310323 ], [ -118.316787, 33.301137 ], [ -118.325244, 33.299075 ], [ -118.343249, 33.305234 ], [ -118.360332, 33.315330 ], [ -118.374768, 33.320065 ], [ -118.402941, 33.320901 ], [ -118.440047, 33.318638 ], [ -118.456309, 33.321820 ], [ -118.465368, 33.326056 ], [ -118.481886, 33.344123 ], [ -118.488770, 33.356649 ], [ -118.482609, 33.369914 ], [ -118.478465, 33.386320 ], [ -118.484949, 33.412131 ], [ -118.488750, 33.419826 ], [ -118.503952, 33.424234 ], [ -118.515914, 33.422417 ], [ -118.516267, 33.425075 ], [ -118.523230, 33.430733 ], [ -118.537380, 33.434608 ], [ -118.558715, 33.433419 ], [ -118.563442, 33.434381 ], [ -118.570927, 33.439351 ], [ -118.575901, 33.448261 ], [ -118.593969, 33.467198 ], [ -118.601185, 33.469853 ], [ -118.604030, 33.476540 ], [ -118.603375, 33.478098 ], [ -118.598783, 33.477939 ], [ -118.585936, 33.473819 ], [ -118.544530, 33.474119 ], [ -118.530702, 33.468071 ], [ -118.500212, 33.449592 ] ] ], [ [ [ -122.418698, 37.852717 ], [ -122.434403, 37.852434 ], [ -122.443302, 37.855448 ], [ -122.446316, 37.861046 ], [ -122.438565, 37.868367 ], [ -122.430958, 37.872242 ], [ -122.421439, 37.869969 ], [ -122.421341, 37.869946 ], [ -122.418470, 37.861764 ], [ -122.418470, 37.852721 ], [ -122.418698, 37.852717 ] ] ], [ [ [ -123.013916, 37.700355 ], [ -123.013897, 37.704478 ], [ -123.012194, 37.706749 ], [ -123.004489, 37.706262 ], [ -123.000190, 37.702937 ], [ -122.997189, 37.697909 ], [ -123.000677, 37.690203 ], [ -123.005543, 37.689392 ], [ -123.011464, 37.691907 ], [ -123.014303, 37.696205 ], [ -123.013916, 37.700355 ] ] ], [ [ [ -122.378500, 37.826505 ], [ -122.377879, 37.830648 ], [ -122.369941, 37.832137 ], [ -122.363244, 37.823951 ], [ -122.358779, 37.814278 ], [ -122.362661, 37.807577 ], [ -122.372422, 37.811301 ], [ -122.372670, 37.816510 ], [ -122.378500, 37.826505 ] ] ], [ [ [ -124.065521, 41.464739 ], [ -124.066057, 41.470258 ], [ -124.075917, 41.501757 ], [ -124.081427, 41.511228 ], [ -124.081987, 41.547761 ], [ -124.092404, 41.553615 ], [ -124.101123, 41.569192 ], [ -124.101403, 41.578524 ], [ -124.097385, 41.585251 ], [ -124.100961, 41.602499 ], [ -124.114413, 41.616768 ], [ -124.116037, 41.628849 ], [ -124.120225, 41.640354 ], [ -124.135552, 41.657307 ], [ -124.139354, 41.671652 ], [ -124.138373, 41.678881 ], [ -124.143479, 41.709284 ], [ -124.147412, 41.717955 ], [ -124.154246, 41.728801 ], [ -124.164716, 41.740126 ], [ -124.177390, 41.745756 ], [ -124.185363, 41.739351 ], [ -124.191040, 41.736079 ], [ -124.194953, 41.736778 ], [ -124.203843, 41.747035 ], [ -124.239720, 41.770800 ], [ -124.242288, 41.772034 ], [ -124.248704, 41.771459 ], [ -124.255994, 41.783014 ], [ -124.245027, 41.792300 ], [ -124.230678, 41.818681 ], [ -124.219592, 41.846432 ], [ -124.208439, 41.888192 ], [ -124.203402, 41.940964 ], [ -124.204948, 41.983441 ], [ -124.211605, 41.998460 ], [ -124.100921, 41.996956 ], [ -124.100216, 41.996842 ], [ -124.087827, 41.996891 ], [ -124.086661, 41.996869 ], [ -123.821472, 41.995473 ], [ -123.624554, 41.999837 ], [ -123.518075, 42.000436 ], [ -123.501997, 42.000527 ], [ -123.498896, 42.000474 ], [ -123.498830, 42.000525 ], [ -123.347562, 41.999108 ], [ -123.230764, 42.003845 ], [ -123.230762, 42.003845 ], [ -123.154908, 42.008036 ], [ -123.045254, 42.003049 ], [ -123.001152, 42.003000 ], [ -122.634739, 42.004858 ], [ -122.501135, 42.008460 ], [ -122.378193, 42.009518 ], [ -122.289533, 42.007764 ], [ -122.289527, 42.007764 ], [ -122.161328, 42.007637 ], [ -122.160438, 42.007637 ], [ -122.156666, 42.007384 ], [ -122.155408, 42.007429 ], [ -122.001119, 42.004017 ], [ -121.708199, 42.000815 ], [ -121.705045, 42.000766 ], [ -121.689159, 42.000584 ], [ -121.675348, 42.000351 ], [ -121.580865, 41.998668 ], [ -121.520250, 41.997983 ], [ -121.447540, 41.997169 ], [ -121.439610, 41.997080 ], [ -121.434977, 41.997022 ], [ -121.376101, 41.997026 ], [ -121.360253, 41.996680 ], [ -121.340517, 41.996220 ], [ -121.335734, 41.996518 ], [ -121.334385, 41.996655 ], [ -121.154347, 41.996352 ], [ -121.035195, 41.993323 ], [ -120.879481, 41.993781 ], [ -120.693941, 41.993676 ], [ -120.692219, 41.993677 ], [ -120.326005, 41.993122 ], [ -120.286424, 41.993058 ], [ -119.999168, 41.994540 ], [ -119.999866, 41.183974 ], [ -119.999358, 40.873101 ], [ -119.999232, 40.867454 ], [ -119.999231, 40.865899 ], [ -119.995926, 40.499901 ], [ -119.996155, 40.321838 ], [ -119.996155, 40.321250 ], [ -119.996182, 40.263532 ], [ -119.996183, 40.262461 ], [ -119.997124, 40.126363 ], [ -119.997234, 40.091591 ], [ -119.997175, 40.077245 ], [ -119.997291, 40.071803 ], [ -120.000607, 39.780779 ], [ -120.000502, 39.779956 ], [ -120.001319, 39.722420 ], [ -120.001319, 39.722416 ], [ -120.003116, 39.445113 ], [ -120.003117, 39.445045 ], [ -120.005318, 39.316479 ], [ -120.005320, 39.316350 ], [ -120.005413, 39.313848 ], [ -120.005414, 39.313345 ], [ -120.005743, 39.228664 ], [ -120.005746, 39.225210 ], [ -120.004504, 39.165599 ], [ -120.003402, 39.112687 ], [ -120.002461, 39.067489 ], [ -120.001014, 38.999574 ], [ -119.904315, 38.933324 ], [ -119.587679, 38.714734 ], [ -119.587066, 38.714345 ], [ -119.585437, 38.713212 ], [ -119.494183, 38.649852 ], [ -119.494022, 38.649734 ], [ -119.450612, 38.619964 ], [ -119.450623, 38.619965 ], [ -119.328498, 38.534648 ], [ -119.156863, 38.414743 ], [ -119.125982, 38.393170 ], [ -118.746598, 38.124926 ], [ -118.428581, 37.895613 ], [ -118.039798, 37.615273 ], [ -118.039849, 37.615245 ], [ -117.832726, 37.464929 ], [ -117.500909, 37.220282 ], [ -117.166187, 36.970862 ], [ -117.000895, 36.847694 ], [ -116.488233, 36.459097 ], [ -116.097216, 36.158346 ], [ -116.093601, 36.155805 ], [ -115.912858, 36.015359 ], [ -115.892975, 35.999967 ], [ -115.846080, 35.963596 ], [ -115.689302, 35.842003 ], [ -115.648029, 35.809629 ], [ -115.647683, 35.809358 ], [ -115.647202, 35.808995 ], [ -115.406079, 35.618613 ], [ -115.404537, 35.617605 ], [ -115.393996, 35.609344 ], [ -115.391535, 35.607271 ], [ -115.388866, 35.605171 ], [ -115.303743, 35.538207 ], [ -115.271342, 35.512660 ], [ -115.225273, 35.475907 ], [ -115.160599, 35.424313 ], [ -115.160068, 35.424129 ], [ -115.146788, 35.413662 ], [ -115.145813, 35.413182 ], [ -114.925480, 35.237054 ], [ -114.925381, 35.237039 ], [ -114.805030, 35.140284 ], [ -114.804249, 35.139689 ], [ -114.633013, 35.002085 ], [ -114.629190, 34.991887 ], [ -114.629015, 34.986148 ], [ -114.630877, 34.907263 ], [ -114.636725, 34.889107 ], [ -114.635176, 34.875003 ], [ -114.633051, 34.869971 ], [ -114.552682, 34.766871 ], [ -114.465607, 34.692260 ], [ -114.452547, 34.653494 ], [ -114.339627, 34.451435 ], [ -114.264317, 34.401329 ], [ -114.199482, 34.361373 ], [ -114.176909, 34.349306 ], [ -114.138282, 34.303230 ], [ -114.131489, 34.260387 ], [ -114.133264, 34.258462 ], [ -114.164476, 34.251667 ], [ -114.225861, 34.201774 ], [ -114.244191, 34.179625 ], [ -114.312592, 34.144453 ], [ -114.321618, 34.138093 ], [ -114.366521, 34.118575 ], [ -114.390565, 34.110084 ], [ -114.401352, 34.111652 ], [ -114.411681, 34.110031 ], [ -114.420499, 34.103466 ], [ -114.433380, 34.088413 ], [ -114.435429, 34.079727 ], [ -114.434949, 34.037784 ], [ -114.438266, 34.022609 ], [ -114.463610, 33.993431 ], [ -114.499883, 33.961789 ], [ -114.518434, 33.917518 ], [ -114.525539, 33.838614 ], [ -114.523365, 33.806120 ], [ -114.504340, 33.756381 ], [ -114.494197, 33.707922 ], [ -114.496489, 33.696901 ], [ -114.519113, 33.688473 ], [ -114.523959, 33.685879 ], [ -114.530348, 33.679245 ], [ -114.540617, 33.591412 ], [ -114.540300, 33.580615 ], [ -114.535965, 33.569154 ], [ -114.535664, 33.568788 ], [ -114.558898, 33.531819 ], [ -114.594534, 33.495059 ], [ -114.622918, 33.456561 ], [ -114.627125, 33.433554 ], [ -114.665278, 33.415358 ], [ -114.721233, 33.396912 ], [ -114.700103, 33.341045 ], [ -114.672088, 33.258499 ], [ -114.675360, 33.185489 ], [ -114.679359, 33.159519 ], [ -114.687074, 33.142196 ], [ -114.696829, 33.131209 ], [ -114.706175, 33.105335 ], [ -114.707819, 33.091102 ], [ -114.675104, 33.047532 ], [ -114.623870, 33.028720 ], [ -114.606282, 33.025703 ], [ -114.589778, 33.026228 ], [ -114.584765, 33.028231 ], [ -114.578287, 33.035375 ], [ -114.571653, 33.036624 ], [ -114.523578, 33.030961 ], [ -114.516912, 33.026871 ], [ -114.511343, 33.023455 ], [ -114.468605, 32.971649 ], [ -114.462890, 32.905797 ], [ -114.465715, 32.879420 ], [ -114.465715, 32.879191 ], [ -114.496284, 32.822326 ], [ -114.496827, 32.822119 ], [ -114.615733, 32.729427 ], [ -114.615585, 32.728446 ], [ -114.658260, 32.733799 ], [ -114.658840, 32.733830 ], [ -114.677091, 32.736218 ], [ -114.678632, 32.736614 ], [ -114.719633, 32.718763 ], [ -115.465164, 32.667100 ], [ -115.875842, 32.636424 ], [ -116.106159, 32.618328 ], [ -116.390091, 32.596020 ], [ -117.118865, 32.534661 ], [ -117.124862, 32.534156 ], [ -117.133363, 32.575625 ], [ -117.132963, 32.597054 ], [ -117.136664, 32.618754 ], [ -117.139464, 32.627054 ], [ -117.159865, 32.660652 ], [ -117.168866, 32.671952 ], [ -117.180366, 32.681652 ], [ -117.192967, 32.687751 ], [ -117.196767, 32.688851 ], [ -117.213068, 32.687751 ], [ -117.223868, 32.683051 ], [ -117.236239, 32.671353 ], [ -117.246069, 32.669352 ], [ -117.255169, 32.700051 ], [ -117.257570, 32.726050 ], [ -117.255370, 32.745449 ], [ -117.252570, 32.752949 ], [ -117.254970, 32.786948 ], [ -117.261070, 32.803148 ], [ -117.280971, 32.822247 ], [ -117.282170, 32.839547 ], [ -117.281170, 32.843047 ], [ -117.273870, 32.851447 ], [ -117.264970, 32.848947 ], [ -117.260670, 32.852647 ], [ -117.256170, 32.859447 ], [ -117.251670, 32.874346 ], [ -117.254470, 32.900146 ], [ -117.260470, 32.931245 ], [ -117.262547, 32.939542 ], [ -117.280770, 33.012343 ], [ -117.293370, 33.034642 ], [ -117.309771, 33.074540 ], [ -117.315278, 33.093504 ], [ -117.328359, 33.121842 ], [ -117.359484, 33.164231 ], [ -117.362572, 33.168437 ], [ -117.391480, 33.202762 ], [ -117.401926, 33.213598 ], [ -117.445583, 33.268517 ], [ -117.469794, 33.296417 ], [ -117.505650, 33.334063 ], [ -117.547693, 33.365491 ], [ -117.571722, 33.378988 ], [ -117.595880, 33.386629 ], [ -117.607905, 33.406317 ], [ -117.631682, 33.430528 ], [ -117.645582, 33.440728 ], [ -117.645592, 33.440733 ], [ -117.684584, 33.461927 ], [ -117.689284, 33.460155 ], [ -117.691984, 33.456627 ], [ -117.691384, 33.454028 ], [ -117.715349, 33.460556 ], [ -117.726486, 33.483427 ], [ -117.761387, 33.516326 ], [ -117.784888, 33.541525 ], [ -117.801288, 33.546324 ], [ -117.814188, 33.552224 ], [ -117.840289, 33.573523 ], [ -117.876790, 33.592322 ], [ -117.899790, 33.599622 ], [ -117.927091, 33.605521 ], [ -117.940591, 33.620021 ], [ -117.957114, 33.629466 ], [ -118.000593, 33.654319 ], [ -118.029694, 33.676418 ], [ -118.064895, 33.711018 ], [ -118.088896, 33.729817 ], [ -118.101097, 33.734117 ], [ -118.116703, 33.743549 ], [ -118.132698, 33.753217 ], [ -118.156900, 33.760317 ], [ -118.175500, 33.763617 ], [ -118.180831, 33.763072 ], [ -118.187701, 33.749218 ], [ -118.183700, 33.736118 ], [ -118.181367, 33.717367 ], [ -118.207476, 33.716905 ], [ -118.258687, 33.703741 ], [ -118.277208, 33.707091 ], [ -118.297104, 33.708319 ], [ -118.317205, 33.712818 ], [ -118.354705, 33.732317 ], [ -118.360505, 33.736817 ], [ -118.385006, 33.741417 ], [ -118.396606, 33.735917 ], [ -118.411211, 33.741985 ], [ -118.428407, 33.774715 ], [ -118.423407, 33.782015 ], [ -118.405007, 33.800215 ], [ -118.394376, 33.804289 ], [ -118.394307, 33.804315 ], [ -118.391507, 33.815415 ], [ -118.392107, 33.840915 ], [ -118.412708, 33.883913 ], [ -118.442410, 33.940312 ], [ -118.460611, 33.969111 ], [ -118.482729, 33.995912 ], [ -118.484212, 33.997710 ], [ -118.502813, 34.015509 ], [ -118.519514, 34.027509 ], [ -118.543115, 34.038508 ], [ -118.569235, 34.041640 ], [ -118.603572, 34.039048 ], [ -118.609652, 34.036424 ], [ -118.668358, 34.038887 ], [ -118.675430, 34.037479 ], [ -118.679366, 34.033255 ], [ -118.706215, 34.029383 ], [ -118.732391, 34.032743 ], [ -118.744952, 34.032103 ], [ -118.783433, 34.021543 ], [ -118.787094, 34.019545 ], [ -118.805114, 34.001239 ], [ -118.821579, 34.013959 ], [ -118.840380, 34.027527 ], [ -118.854653, 34.034215 ], [ -118.896159, 34.039207 ], [ -118.928048, 34.045847 ], [ -118.938081, 34.043383 ], [ -118.944887, 34.045340 ], [ -118.954722, 34.048167 ], [ -118.977751, 34.059822 ], [ -118.996980, 34.065943 ], [ -119.004644, 34.066231 ], [ -119.037494, 34.083111 ], [ -119.069959, 34.090470 ], [ -119.088536, 34.098310 ], [ -119.098216, 34.099334 ], [ -119.109784, 34.094566 ], [ -119.130169, 34.100102 ], [ -119.159554, 34.119653 ], [ -119.188640, 34.139005 ], [ -119.203140, 34.144505 ], [ -119.211241, 34.144905 ], [ -119.216441, 34.146105 ], [ -119.227743, 34.161728 ], [ -119.237142, 34.175804 ], [ -119.257043, 34.213304 ], [ -119.265927, 34.234609 ], [ -119.270144, 34.252903 ], [ -119.278644, 34.266902 ], [ -119.290945, 34.274902 ], [ -119.302131, 34.272761 ], [ -119.313034, 34.275689 ], [ -119.337475, 34.290576 ], [ -119.349187, 34.304383 ], [ -119.370356, 34.319486 ], [ -119.375780, 34.321118 ], [ -119.388249, 34.317398 ], [ -119.390449, 34.318198 ], [ -119.427770, 34.353016 ], [ -119.431066, 34.355297 ], [ -119.435888, 34.355839 ], [ -119.461036, 34.374064 ], [ -119.472678, 34.375628 ], [ -119.478265, 34.377197 ], [ -119.510655, 34.386295 ], [ -119.536957, 34.395495 ], [ -119.559459, 34.413395 ], [ -119.616862, 34.420995 ], [ -119.638864, 34.415696 ], [ -119.648664, 34.417396 ], [ -119.671866, 34.416096 ], [ -119.688167, 34.412497 ], [ -119.684666, 34.408297 ], [ -119.691749, 34.403154 ], [ -119.709067, 34.395397 ], [ -119.729369, 34.395897 ], [ -119.745470, 34.402898 ], [ -119.785871, 34.415997 ], [ -119.794771, 34.417597 ], [ -119.835771, 34.415796 ], [ -119.853771, 34.407996 ], [ -119.873971, 34.408795 ], [ -119.925227, 34.433931 ], [ -119.956433, 34.435288 ], [ -119.971951, 34.444641 ], [ -120.008077, 34.460447 ], [ -120.038828, 34.463434 ], [ -120.050682, 34.461651 ], [ -120.088591, 34.460208 ], [ -120.097212, 34.461809 ], [ -120.118411, 34.469927 ], [ -120.141165, 34.473405 ], [ -120.183505, 34.470372 ], [ -120.225498, 34.470587 ], [ -120.238002, 34.468098 ], [ -120.257770, 34.467451 ], [ -120.283001, 34.468354 ], [ -120.295051, 34.470623 ], [ -120.299169, 34.469731 ], [ -120.301822, 34.467077 ], [ -120.341369, 34.458789 ], [ -120.441975, 34.451512 ], [ -120.451425, 34.447094 ], [ -120.471376, 34.447846 ], [ -120.476610, 34.475131 ], [ -120.480372, 34.481059 ], [ -120.490523, 34.490075 ], [ -120.511421, 34.522953 ], [ -120.524776, 34.531291 ], [ -120.581293, 34.556959 ], [ -120.608355, 34.556656 ], [ -120.612005, 34.553564 ], [ -120.622575, 34.554017 ], [ -120.637805, 34.566220 ], [ -120.645739, 34.581035 ], [ -120.640244, 34.604406 ], [ -120.625127, 34.634489 ], [ -120.601970, 34.692095 ], [ -120.600450, 34.704640 ], [ -120.601672, 34.709721 ], [ -120.614852, 34.730709 ], [ -120.626320, 34.738072 ], [ -120.637415, 34.755895 ], [ -120.622970, 34.793300 ], [ -120.616296, 34.816308 ], [ -120.609898, 34.842751 ], [ -120.610266, 34.858180 ], [ -120.616325, 34.866739 ], [ -120.639283, 34.880413 ], [ -120.642212, 34.894145 ], [ -120.647328, 34.901133 ], [ -120.662889, 34.901183 ], [ -120.670835, 34.904115 ], [ -120.648905, 34.974393 ], [ -120.639990, 35.002963 ], [ -120.633570, 35.033085 ], [ -120.629931, 35.061515 ], [ -120.629583, 35.078362 ], [ -120.630957, 35.101941 ], [ -120.635787, 35.123805 ], [ -120.644311, 35.139616 ], [ -120.651134, 35.147768 ], [ -120.662475, 35.153357 ], [ -120.667994, 35.152030 ], [ -120.675074, 35.153061 ], [ -120.686974, 35.160708 ], [ -120.698906, 35.171192 ], [ -120.704203, 35.173206 ], [ -120.714185, 35.175998 ], [ -120.734231, 35.178472 ], [ -120.748870, 35.177795 ], [ -120.754823, 35.174701 ], [ -120.756862, 35.169208 ], [ -120.756086, 35.160459 ], [ -120.760492, 35.159710 ], [ -120.778998, 35.168897 ], [ -120.786076, 35.177666 ], [ -120.805258, 35.184973 ], [ -120.846674, 35.204429 ], [ -120.856047, 35.206487 ], [ -120.873046, 35.225688 ], [ -120.896790, 35.247877 ], [ -120.896876, 35.253990 ], [ -120.889354, 35.277819 ], [ -120.879570, 35.294184 ], [ -120.867200, 35.327154 ], [ -120.862684, 35.346776 ], [ -120.862133, 35.360763 ], [ -120.866099, 35.393045 ], [ -120.869209, 35.403276 ], [ -120.884757, 35.430196 ], [ -120.896862, 35.442243 ], [ -120.907937, 35.449069 ], [ -120.946546, 35.446715 ], [ -120.950742, 35.448020 ], [ -120.955863, 35.453743 ], [ -120.969436, 35.460197 ], [ -120.976122, 35.459028 ], [ -121.003359, 35.460710 ], [ -121.025621, 35.484598 ], [ -121.053080, 35.507530 ], [ -121.059913, 35.509671 ], [ -121.101595, 35.548814 ], [ -121.126027, 35.593058 ], [ -121.133556, 35.600455 ], [ -121.143561, 35.606046 ], [ -121.166712, 35.635399 ], [ -121.188897, 35.643138 ], [ -121.195291, 35.640734 ], [ -121.251034, 35.656641 ], [ -121.272322, 35.666711 ], [ -121.284973, 35.674109 ], [ -121.289794, 35.689428 ], [ -121.296473, 35.696824 ], [ -121.304583, 35.701794 ], [ -121.314632, 35.713310 ], [ -121.315786, 35.752520 ], [ -121.324918, 35.769347 ], [ -121.332449, 35.783106 ], [ -121.346363, 35.795183 ], [ -121.356737, 35.804187 ], [ -121.388053, 35.823483 ], [ -121.406823, 35.844623 ], [ -121.413146, 35.855316 ], [ -121.426955, 35.860103 ], [ -121.439584, 35.866950 ], [ -121.462264, 35.885618 ], [ -121.461227, 35.896906 ], [ -121.463452, 35.904416 ], [ -121.472435, 35.919890 ], [ -121.486200, 35.970348 ], [ -121.503112, 36.000299 ], [ -121.511590, 36.006598 ], [ -121.531876, 36.014368 ], [ -121.553716, 36.019798 ], [ -121.569612, 36.021539 ], [ -121.574602, 36.025156 ], [ -121.590395, 36.050363 ], [ -121.589183, 36.053775 ], [ -121.592853, 36.065062 ], [ -121.606845, 36.072065 ], [ -121.618672, 36.087767 ], [ -121.622009, 36.099695 ], [ -121.629634, 36.114452 ], [ -121.680145, 36.165818 ], [ -121.717176, 36.195146 ], [ -121.779851, 36.227407 ], [ -121.797059, 36.234211 ], [ -121.806979, 36.232907 ], [ -121.813734, 36.234235 ], [ -121.826425, 36.241860 ], [ -121.835785, 36.250748 ], [ -121.839350, 36.260478 ], [ -121.851967, 36.277831 ], [ -121.874797, 36.289064 ], [ -121.888491, 36.302810 ], [ -121.894714, 36.317806 ], [ -121.892917, 36.340428 ], [ -121.905446, 36.358269 ], [ -121.902669, 36.363901 ], [ -121.901813, 36.381879 ], [ -121.903195, 36.393603 ], [ -121.905657, 36.398206 ], [ -121.914378, 36.404344 ], [ -121.917463, 36.414809 ], [ -121.914740, 36.425890 ], [ -121.925500, 36.453918 ], [ -121.937205, 36.472488 ], [ -121.941600, 36.485602 ], [ -121.939216, 36.496896 ], [ -121.938763, 36.506423 ], [ -121.943678, 36.511802 ], [ -121.944666, 36.521861 ], [ -121.928769, 36.523147 ], [ -121.925937, 36.525173 ], [ -121.932508, 36.559935 ], [ -121.942533, 36.566435 ], [ -121.949659, 36.567602 ], [ -121.951460, 36.564009 ], [ -121.957335, 36.564482 ], [ -121.972594, 36.573370 ], [ -121.978592, 36.580488 ], [ -121.970427, 36.582754 ], [ -121.941666, 36.618059 ], [ -121.938551, 36.633908 ], [ -121.936430, 36.636746 ], [ -121.929666, 36.636959 ], [ -121.923866, 36.634559 ], [ -121.890164, 36.609259 ], [ -121.889064, 36.601759 ], [ -121.886764, 36.601459 ], [ -121.871364, 36.604559 ], [ -121.860604, 36.611136 ], [ -121.842263, 36.630059 ], [ -121.831995, 36.644856 ], [ -121.825052, 36.657207 ], [ -121.814462, 36.682858 ], [ -121.807062, 36.714157 ], [ -121.805643, 36.750239 ], [ -121.788278, 36.803994 ], [ -121.791544, 36.815186 ], [ -121.809363, 36.848654 ], [ -121.810552, 36.850648 ], [ -121.827664, 36.879353 ], [ -121.862266, 36.931552 ], [ -121.880167, 36.950151 ], [ -121.894667, 36.961851 ], [ -121.906468, 36.968950 ], [ -121.930069, 36.978150 ], [ -121.939470, 36.978050 ], [ -121.951670, 36.971450 ], [ -121.972771, 36.954151 ], [ -121.975871, 36.954051 ], [ -121.983896, 36.958727 ], [ -122.012373, 36.964550 ], [ -122.023373, 36.962150 ], [ -122.027174, 36.951150 ], [ -122.050122, 36.948523 ], [ -122.066421, 36.948271 ], [ -122.079356, 36.950783 ], [ -122.105976, 36.955951 ], [ -122.140578, 36.974950 ], [ -122.155078, 36.980850 ], [ -122.186879, 37.003450 ], [ -122.206180, 37.013949 ], [ -122.252181, 37.059448 ], [ -122.260481, 37.072548 ], [ -122.284882, 37.101747 ], [ -122.292974, 37.107318 ], [ -122.306139, 37.116383 ], [ -122.313907, 37.118161 ], [ -122.322971, 37.115460 ], [ -122.330463, 37.115338 ], [ -122.337071, 37.117382 ], [ -122.338856, 37.120854 ], [ -122.337085, 37.130795 ], [ -122.337833, 37.135936 ], [ -122.344029, 37.144099 ], [ -122.359791, 37.155574 ], [ -122.361790, 37.163593 ], [ -122.367085, 37.172817 ], [ -122.379270, 37.181128 ], [ -122.390599, 37.182988 ], [ -122.397065, 37.187249 ], [ -122.405073, 37.195791 ], [ -122.407181, 37.219465 ], [ -122.408982, 37.225258 ], [ -122.415822, 37.232839 ], [ -122.419113, 37.241470 ], [ -122.418452, 37.248521 ], [ -122.411686, 37.265844 ], [ -122.401323, 37.337009 ], [ -122.400850, 37.359225 ], [ -122.409258, 37.374805 ], [ -122.423286, 37.392542 ], [ -122.443687, 37.435941 ], [ -122.445987, 37.461541 ], [ -122.452087, 37.480540 ], [ -122.467888, 37.498140 ], [ -122.472388, 37.500540 ], [ -122.476443, 37.498768 ], [ -122.482351, 37.496187 ], [ -122.485888, 37.494641 ], [ -122.486749, 37.494390 ], [ -122.487139, 37.494277 ], [ -122.493789, 37.492341 ], [ -122.494429, 37.492690 ], [ -122.499289, 37.495341 ], [ -122.516689, 37.521340 ], [ -122.519533, 37.537302 ], [ -122.516589, 37.544939 ], [ -122.514789, 37.546139 ], [ -122.513688, 37.552239 ], [ -122.518088, 37.576138 ], [ -122.517187, 37.590637 ], [ -122.501386, 37.599637 ], [ -122.496786, 37.612136 ], [ -122.494085, 37.644035 ], [ -122.496784, 37.686433 ], [ -122.502427, 37.708133 ], [ -122.506483, 37.723731 ], [ -122.509397, 37.748841 ], [ -122.511983, 37.771130 ], [ -122.514483, 37.780829 ], [ -122.505310, 37.788312 ], [ -122.492883, 37.787929 ], [ -122.485783, 37.790629 ], [ -122.478083, 37.810828 ], [ -122.470336, 37.808671 ], [ -122.463793, 37.804653 ], [ -122.425942, 37.810979 ], [ -122.407452, 37.811441 ], [ -122.398139, 37.805630 ], [ -122.385323, 37.790724 ], [ -122.375854, 37.734979 ], [ -122.370094, 37.732331 ], [ -122.367697, 37.734943 ], [ -122.365478, 37.734621 ], [ -122.356784, 37.729505 ], [ -122.361749, 37.715010 ], [ -122.370411, 37.717572 ], [ -122.391374, 37.708331 ], [ -122.393190, 37.707531 ], [ -122.387626, 37.679060 ], [ -122.374291, 37.662206 ], [ -122.375600, 37.652389 ], [ -122.377890, 37.650425 ], [ -122.387381, 37.648462 ], [ -122.386072, 37.637662 ], [ -122.365455, 37.626208 ], [ -122.355310, 37.615736 ], [ -122.358583, 37.611155 ], [ -122.370364, 37.614427 ], [ -122.373309, 37.613773 ], [ -122.378545, 37.605592 ], [ -122.360219, 37.592501 ], [ -122.317676, 37.590865 ], [ -122.315385, 37.587265 ], [ -122.315713, 37.583666 ], [ -122.305895, 37.575484 ], [ -122.262698, 37.572866 ], [ -122.251898, 37.566321 ], [ -122.244372, 37.558140 ], [ -122.242832, 37.557136 ], [ -122.236323, 37.552891 ], [ -122.225135, 37.545594 ], [ -122.214264, 37.538505 ], [ -122.196593, 37.537196 ], [ -122.194957, 37.522469 ], [ -122.168449, 37.504143 ], [ -122.155686, 37.501198 ], [ -122.149632, 37.502671 ], [ -122.140142, 37.507907 ], [ -122.130979, 37.503652 ], [ -122.127706, 37.500053 ], [ -122.116112, 37.505386 ], [ -122.111344, 37.507580 ], [ -122.111998, 37.528851 ], [ -122.128688, 37.560594 ], [ -122.133924, 37.562885 ], [ -122.137524, 37.567467 ], [ -122.144396, 37.581866 ], [ -122.147014, 37.588411 ], [ -122.145378, 37.600846 ], [ -122.146360, 37.607391 ], [ -122.152905, 37.640771 ], [ -122.163049, 37.667933 ], [ -122.170904, 37.676114 ], [ -122.179085, 37.680041 ], [ -122.197411, 37.692804 ], [ -122.203971, 37.697769 ], [ -122.213774, 37.698695 ], [ -122.221628, 37.705567 ], [ -122.246826, 37.721930 ], [ -122.255989, 37.735674 ], [ -122.257953, 37.739601 ], [ -122.257134, 37.745001 ], [ -122.252226, 37.747619 ], [ -122.244938, 37.750294 ], [ -122.242638, 37.753744 ], [ -122.253753, 37.761218 ], [ -122.264101, 37.764667 ], [ -122.275408, 37.767350 ], [ -122.286139, 37.769458 ], [ -122.293996, 37.770416 ], [ -122.304345, 37.774632 ], [ -122.318909, 37.779040 ], [ -122.329159, 37.783173 ], [ -122.330790, 37.783830 ], [ -122.330963, 37.786035 ], [ -122.331748, 37.796052 ], [ -122.335550, 37.799538 ], [ -122.335675, 37.799652 ], [ -122.333711, 37.809797 ], [ -122.323567, 37.823214 ], [ -122.317676, 37.826814 ], [ -122.306222, 37.827469 ], [ -122.303931, 37.830087 ], [ -122.301313, 37.847758 ], [ -122.310477, 37.873938 ], [ -122.309986, 37.892755 ], [ -122.313258, 37.897010 ], [ -122.313496, 37.897211 ], [ -122.323730, 37.905845 ], [ -122.334530, 37.908791 ], [ -122.357110, 37.908791 ], [ -122.362346, 37.904209 ], [ -122.367582, 37.903882 ], [ -122.378709, 37.905191 ], [ -122.385908, 37.908136 ], [ -122.389181, 37.910100 ], [ -122.390490, 37.922535 ], [ -122.395071, 37.927117 ], [ -122.401289, 37.928426 ], [ -122.413725, 37.937262 ], [ -122.417371, 37.943513 ], [ -122.430087, 37.963115 ], [ -122.429760, 37.965405 ], [ -122.415361, 37.963115 ], [ -122.411761, 37.960497 ], [ -122.408383, 37.957544 ], [ -122.399832, 37.956009 ], [ -122.367582, 37.978168 ], [ -122.361905, 37.989991 ], [ -122.363001, 37.994375 ], [ -122.366928, 37.998458 ], [ -122.368891, 38.007948 ], [ -122.367909, 38.012530 ], [ -122.363655, 38.014166 ], [ -122.359493, 38.009941 ], [ -122.340093, 38.003694 ], [ -122.331912, 38.005330 ], [ -122.321112, 38.012857 ], [ -122.315549, 38.013511 ], [ -122.300823, 38.010893 ], [ -122.283478, 38.022674 ], [ -122.262861, 38.044600 ], [ -122.262861, 38.051473 ], [ -122.266669, 38.060070 ], [ -122.273006, 38.074380 ], [ -122.282824, 38.082889 ], [ -122.301804, 38.105142 ], [ -122.314567, 38.115287 ], [ -122.366273, 38.141467 ], [ -122.396380, 38.149976 ], [ -122.403514, 38.150624 ], [ -122.403580, 38.150630 ], [ -122.409798, 38.136231 ], [ -122.439577, 38.116923 ], [ -122.450377, 38.116269 ], [ -122.454958, 38.118887 ], [ -122.484411, 38.114960 ], [ -122.489974, 38.112014 ], [ -122.490727, 38.109755 ], [ -122.491283, 38.108087 ], [ -122.489974, 38.096961 ], [ -122.486702, 38.090088 ], [ -122.483757, 38.071762 ], [ -122.492265, 38.056381 ], [ -122.499465, 38.032165 ], [ -122.497828, 38.019402 ], [ -122.494556, 38.015148 ], [ -122.481466, 38.007621 ], [ -122.462812, 38.003367 ], [ -122.452995, 37.996167 ], [ -122.448413, 37.988313 ], [ -122.448413, 37.984713 ], [ -122.456595, 37.978823 ], [ -122.462485, 37.981441 ], [ -122.471975, 37.981768 ], [ -122.488665, 37.966714 ], [ -122.490302, 37.964751 ], [ -122.490302, 37.959188 ], [ -122.487684, 37.948716 ], [ -122.480484, 37.945443 ], [ -122.479175, 37.941516 ], [ -122.485720, 37.937589 ], [ -122.499465, 37.939225 ], [ -122.503064, 37.936607 ], [ -122.503064, 37.928753 ], [ -122.493574, 37.921881 ], [ -122.486375, 37.921881 ], [ -122.478193, 37.918608 ], [ -122.471975, 37.910427 ], [ -122.472303, 37.902573 ], [ -122.458558, 37.894064 ], [ -122.448413, 37.893410 ], [ -122.439250, 37.883920 ], [ -122.438268, 37.880974 ], [ -122.450050, 37.871157 ], [ -122.462158, 37.868866 ], [ -122.474266, 37.874429 ], [ -122.480811, 37.873448 ], [ -122.483429, 37.868866 ], [ -122.483102, 37.863957 ], [ -122.476536, 37.832812 ], [ -122.476473, 37.832513 ], [ -122.479151, 37.825428 ], [ -122.479860, 37.825641 ], [ -122.483483, 37.826728 ], [ -122.492474, 37.824840 ], [ -122.505383, 37.822128 ], [ -122.522836, 37.824717 ], [ -122.523585, 37.824828 ], [ -122.537285, 37.830328 ], [ -122.548986, 37.836227 ], [ -122.561487, 37.851827 ], [ -122.584289, 37.859227 ], [ -122.601290, 37.875126 ], [ -122.627113, 37.886080 ], [ -122.639977, 37.897349 ], [ -122.656519, 37.904519 ], [ -122.678474, 37.906604 ], [ -122.682171, 37.906450 ], [ -122.693569, 37.901171 ], [ -122.702640, 37.893820 ], [ -122.727297, 37.904626 ], [ -122.732898, 37.920225 ], [ -122.736898, 37.925825 ], [ -122.754606, 37.935527 ], [ -122.766138, 37.938004 ], [ -122.783244, 37.951334 ], [ -122.791739, 37.969422 ], [ -122.797405, 37.976657 ], [ -122.821383, 37.996735 ], [ -122.856573, 38.016717 ], [ -122.882114, 38.025273 ], [ -122.939711, 38.031908 ], [ -122.956811, 38.028720 ], [ -122.972378, 38.020247 ], [ -122.981776, 38.009119 ], [ -122.982386, 38.004274 ], [ -122.980147, 38.000831 ], [ -122.976764, 37.995680 ], [ -122.974390, 37.992429 ], [ -123.024066, 37.994878 ], [ -123.020562, 37.999544 ], [ -123.016303, 38.001691 ], [ -123.011533, 38.003438 ], [ -122.992420, 38.041758 ], [ -122.960889, 38.112962 ], [ -122.952086, 38.138562 ], [ -122.949074, 38.154060 ], [ -122.949626, 38.164041 ], [ -122.953629, 38.175670 ], [ -122.965408, 38.187113 ], [ -122.966370, 38.198514 ], [ -122.968112, 38.202428 ], [ -122.991953, 38.233185 ], [ -122.993959, 38.237602 ], [ -122.993235, 38.239686 ], [ -122.987149, 38.237538 ], [ -122.968569, 38.242879 ], [ -122.967203, 38.250691 ], [ -122.977082, 38.267902 ], [ -122.986319, 38.273164 ], [ -122.994603, 38.283096 ], [ -122.997106, 38.289458 ], [ -123.002911, 38.295708 ], [ -123.004122, 38.297012 ], [ -123.024333, 38.310573 ], [ -123.038742, 38.313576 ], [ -123.051061, 38.310693 ], [ -123.053476, 38.305722 ], [ -123.052021, 38.302246 ], [ -123.053504, 38.299385 ], [ -123.058239, 38.298355 ], [ -123.063671, 38.302178 ], [ -123.074684, 38.322574 ], [ -123.068437, 38.335210 ], [ -123.068265, 38.359865 ], [ -123.085572, 38.390525 ], [ -123.103706, 38.415541 ], [ -123.122379, 38.437314 ], [ -123.128825, 38.450418 ], [ -123.145325, 38.459422 ], [ -123.166428, 38.474947 ], [ -123.202277, 38.494314 ], [ -123.249797, 38.511045 ], [ -123.287156, 38.540223 ], [ -123.297151, 38.543452 ], [ -123.331899, 38.565542 ], [ -123.343338, 38.590008 ], [ -123.349612, 38.596805 ], [ -123.371876, 38.607235 ], [ -123.379303, 38.621953 ], [ -123.398166, 38.647044 ], [ -123.403010, 38.649449 ], [ -123.405663, 38.656729 ], [ -123.432720, 38.687131 ], [ -123.441774, 38.699744 ], [ -123.461291, 38.717001 ], [ -123.490021, 38.732213 ], [ -123.514784, 38.741966 ], [ -123.525152, 38.753801 ], [ -123.533535, 38.768408 ], [ -123.541837, 38.776764 ], [ -123.571987, 38.798189 ], [ -123.579856, 38.802835 ], [ -123.586380, 38.802857 ], [ -123.600221, 38.814115 ], [ -123.601569, 38.818990 ], [ -123.605317, 38.822765 ], [ -123.638637, 38.843865 ], [ -123.642676, 38.844005 ], [ -123.647387, 38.845472 ], [ -123.652212, 38.854582 ], [ -123.654696, 38.865638 ], [ -123.659846, 38.872529 ], [ -123.688099, 38.893594 ], [ -123.710540, 38.913230 ], [ -123.725367, 38.917438 ], [ -123.727630, 38.929500 ], [ -123.726315, 38.936367 ], [ -123.738886, 38.954120 ], [ -123.732892, 38.954994 ], [ -123.729053, 38.956667 ], [ -123.721347, 38.963879 ], [ -123.711149, 38.977316 ], [ -123.696900, 39.004401 ], [ -123.690740, 39.021293 ], [ -123.690095, 39.031157 ], [ -123.693969, 39.057363 ], [ -123.713392, 39.108422 ], [ -123.721505, 39.125327 ], [ -123.735936, 39.139644 ], [ -123.737913, 39.143442 ], [ -123.742221, 39.164885 ], [ -123.761010, 39.191595 ], [ -123.765891, 39.193657 ], [ -123.774998, 39.212083 ], [ -123.777368, 39.237214 ], [ -123.787893, 39.264327 ], [ -123.798991, 39.271355 ], [ -123.803848, 39.278771 ], [ -123.801757, 39.283530 ], [ -123.803081, 39.291747 ], [ -123.811387, 39.312825 ], [ -123.808772, 39.324368 ], [ -123.817369, 39.338800 ], [ -123.822085, 39.343857 ], [ -123.825331, 39.360814 ], [ -123.826306, 39.368710 ], [ -123.822325, 39.379987 ], [ -123.821887, 39.406809 ], [ -123.814690, 39.446538 ], [ -123.795639, 39.492215 ], [ -123.784170, 39.509419 ], [ -123.778521, 39.521478 ], [ -123.766475, 39.552803 ], [ -123.767210, 39.559852 ], [ -123.787417, 39.604552 ], [ -123.783540, 39.609517 ], [ -123.782322, 39.621486 ], [ -123.786360, 39.659932 ], [ -123.792659, 39.684122 ], [ -123.808208, 39.710715 ], [ -123.824744, 39.718128 ], [ -123.829545, 39.723071 ], [ -123.831599, 39.730629 ], [ -123.835092, 39.738768 ], [ -123.838089, 39.752409 ], [ -123.837150, 39.776232 ], [ -123.839797, 39.795637 ], [ -123.851714, 39.832041 ], [ -123.853764, 39.834100 ], [ -123.881458, 39.845422 ], [ -123.907664, 39.863028 ], [ -123.915142, 39.875313 ], [ -123.915853, 39.881114 ], [ -123.930047, 39.909697 ], [ -123.954952, 39.922373 ], [ -123.962655, 39.937635 ], [ -123.980031, 39.962458 ], [ -123.995860, 39.973045 ], [ -124.023938, 40.001284 ], [ -124.035904, 40.013319 ], [ -124.056408, 40.024305 ], [ -124.065069, 40.024785 ], [ -124.068908, 40.021307 ], [ -124.072509, 40.022657 ], [ -124.079983, 40.029773 ], [ -124.080709, 40.066110 ], [ -124.087086, 40.078442 ], [ -124.110549, 40.103765 ], [ -124.139952, 40.116350 ], [ -124.170767, 40.124207 ], [ -124.187874, 40.130542 ], [ -124.214895, 40.160902 ], [ -124.231095, 40.171581 ], [ -124.258405, 40.184277 ], [ -124.296497, 40.208816 ], [ -124.320912, 40.226617 ], [ -124.327691, 40.237370 ], [ -124.343070, 40.243979 ], [ -124.352715, 40.250453 ], [ -124.363414, 40.260974 ], [ -124.363634, 40.276212 ], [ -124.347853, 40.314634 ], [ -124.353124, 40.331425 ], [ -124.356595, 40.335016 ], [ -124.362796, 40.350046 ], [ -124.365357, 40.374855 ], [ -124.373599, 40.392923 ], [ -124.379082, 40.398828 ], [ -124.391496, 40.407047 ], [ -124.402623, 40.422105 ], [ -124.409591, 40.438076 ], [ -124.408601, 40.443201 ], [ -124.396642, 40.462119 ], [ -124.384940, 40.489820 ], [ -124.383224, 40.499852 ], [ -124.387023, 40.504954 ], [ -124.382816, 40.519000 ], [ -124.379096, 40.522865 ], [ -124.363545, 40.548698 ], [ -124.329404, 40.616430 ], [ -124.315141, 40.639526 ], [ -124.312558, 40.641333 ], [ -124.289119, 40.679630 ], [ -124.248406, 40.735166 ], [ -124.228244, 40.769390 ], [ -124.201921, 40.805111 ], [ -124.176715, 40.843618 ], [ -124.158322, 40.876069 ], [ -124.137066, 40.925732 ], [ -124.118147, 40.989263 ], [ -124.112165, 41.028173 ], [ -124.125448, 41.048504 ], [ -124.132946, 41.052482 ], [ -124.138217, 41.054342 ], [ -124.142867, 41.054032 ], [ -124.147216, 41.052884 ], [ -124.148939, 41.051467 ], [ -124.151266, 41.051101 ], [ -124.153622, 41.053550 ], [ -124.154028, 41.059923 ], [ -124.154513, 41.087159 ], [ -124.160556, 41.099011 ], [ -124.159065, 41.121957 ], [ -124.165414, 41.129822 ], [ -124.163988, 41.138675 ], [ -124.158539, 41.143021 ], [ -124.149674, 41.140845 ], [ -124.143800, 41.144686 ], [ -124.122677, 41.189726 ], [ -124.106986, 41.229678 ], [ -124.106389, 41.240682 ], [ -124.092284, 41.287695 ], [ -124.079015, 41.347135 ], [ -124.072294, 41.374844 ], [ -124.063076, 41.439579 ], [ -124.065521, 41.464739 ] ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US08", "STATE": 3, "name": "Colorado", "LSAD": "", "CENSUSAREA": 103641.888000 }, "geometry": { "type": "Polygon", "coordinates": [ [ [ -107.317794, 41.002957 ], [ -107.000606, 41.003444 ], [ -106.857772, 41.003082 ], [ -106.453859, 41.002057 ], [ -106.439563, 41.001978 ], [ -106.437419, 41.001795 ], [ -106.430950, 41.001752 ], [ -106.391852, 41.001176 ], [ -106.386356, 41.001144 ], [ -106.321165, 40.999123 ], [ -106.190550, 40.998056 ], [ -106.061181, 40.996999 ], [ -105.730421, 40.996886 ], [ -105.724804, 40.996910 ], [ -105.277138, 40.998173 ], [ -105.276860, 40.998173 ], [ -105.256527, 40.998191 ], [ -105.254779, 40.998210 ], [ -104.943371, 40.998190 ], [ -104.882452, 40.998186 ], [ -104.497149, 41.001828 ], [ -104.497058, 41.001805 ], [ -104.214692, 41.001657 ], [ -104.214191, 41.001568 ], [ -104.211473, 41.001591 ], [ -104.123586, 41.001626 ], [ -104.104590, 41.001543 ], [ -104.086068, 41.001563 ], [ -104.066961, 41.001504 ], [ -104.053249, 41.001406 ], [ -104.039238, 41.001502 ], [ -104.023383, 41.001887 ], [ -104.018223, 41.001617 ], [ -103.972642, 41.001615 ], [ -103.971373, 41.001524 ], [ -103.953525, 41.001596 ], [ -103.896207, 41.001750 ], [ -103.877967, 41.001673 ], [ -103.858449, 41.001681 ], [ -103.574522, 41.001721 ], [ -103.497447, 41.001635 ], [ -103.486697, 41.001914 ], [ -103.421975, 41.002007 ], [ -103.421925, 41.001969 ], [ -103.382493, 41.001883 ], [ -103.365314, 41.001846 ], [ -103.362979, 41.001844 ], [ -103.077804, 41.002298 ], [ -103.076536, 41.002253 ], [ -103.059538, 41.002368 ], [ -103.057998, 41.002368 ], [ -103.043444, 41.002344 ], [ -103.038704, 41.002251 ], [ -103.002026, 41.002486 ], [ -103.000102, 41.002400 ], [ -102.982690, 41.002157 ], [ -102.981483, 41.002112 ], [ -102.963669, 41.002186 ], [ -102.962522, 41.002072 ], [ -102.960706, 41.002059 ], [ -102.959624, 41.002095 ], [ -102.944830, 41.002303 ], [ -102.943109, 41.002051 ], [ -102.925568, 41.002280 ], [ -102.924029, 41.002142 ], [ -102.906547, 41.002276 ], [ -102.904796, 41.002207 ], [ -102.887407, 41.002178 ], [ -102.885746, 41.002131 ], [ -102.867822, 41.002183 ], [ -102.865784, 41.001988 ], [ -102.849263, 41.002301 ], [ -102.846455, 41.002256 ], [ -102.830303, 41.002351 ], [ -102.827280, 41.002143 ], [ -102.773546, 41.002414 ], [ -102.766723, 41.002275 ], [ -102.754617, 41.002361 ], [ -102.739624, 41.002230 ], [ -102.653463, 41.002332 ], [ -102.621033, 41.002597 ], [ -102.578696, 41.002291 ], [ -102.575738, 41.002268 ], [ -102.575496, 41.002200 ], [ -102.566048, 41.002200 ], [ -102.556789, 41.002219 ], [ -102.487955, 41.002445 ], [ -102.470537, 41.002382 ], [ -102.469223, 41.002424 ], [ -102.379593, 41.002301 ], [ -102.364066, 41.002174 ], [ -102.292833, 41.002207 ], [ -102.292622, 41.002230 ], [ -102.292553, 41.002207 ], [ -102.291354, 41.002207 ], [ -102.272100, 41.002245 ], [ -102.267812, 41.002383 ], [ -102.231931, 41.002327 ], [ -102.212200, 41.002462 ], [ -102.209361, 41.002442 ], [ -102.191210, 41.002326 ], [ -102.124972, 41.002338 ], [ -102.070598, 41.002423 ], [ -102.051718, 41.002377 ], [ -102.051614, 41.002377 ], [ -102.051292, 40.749591 ], [ -102.051292, 40.749586 ], [ -102.051398, 40.697542 ], [ -102.051725, 40.537839 ], [ -102.051519, 40.520094 ], [ -102.051465, 40.440008 ], [ -102.051840, 40.396396 ], [ -102.051572, 40.393080 ], [ -102.051669, 40.349213 ], [ -102.051922, 40.235344 ], [ -102.051894, 40.229193 ], [ -102.051909, 40.162674 ], [ -102.052001, 40.148359 ], [ -102.051744, 40.003078 ], [ -102.051569, 39.849805 ], [ -102.051363, 39.843471 ], [ -102.051318, 39.833311 ], [ -102.051254, 39.818992 ], [ -102.050594, 39.675594 ], [ -102.049954, 39.592331 ], [ -102.049806, 39.574058 ], [ -102.049764, 39.568180 ], [ -102.049554, 39.538932 ], [ -102.049673, 39.536691 ], [ -102.049679, 39.506183 ], [ -102.049369, 39.423333 ], [ -102.049370, 39.418210 ], [ -102.049167, 39.403597 ], [ -102.048960, 39.373712 ], [ -102.048449, 39.303138 ], [ -102.047250, 39.137020 ], [ -102.047189, 39.133147 ], [ -102.047134, 39.129701 ], [ -102.046571, 39.047038 ], [ -102.045388, 38.813392 ], [ -102.045334, 38.799463 ], [ -102.045448, 38.783453 ], [ -102.045371, 38.770064 ], [ -102.045287, 38.755528 ], [ -102.045375, 38.754339 ], [ -102.045212, 38.697567 ], [ -102.045156, 38.688555 ], [ -102.045127, 38.686725 ], [ -102.045160, 38.675221 ], [ -102.045102, 38.674946 ], [ -102.045074, 38.669617 ], [ -102.045288, 38.615249 ], [ -102.045288, 38.615168 ], [ -102.045211, 38.581609 ], [ -102.045189, 38.558732 ], [ -102.045223, 38.543797 ], [ -102.045112, 38.523784 ], [ -102.045262, 38.505532 ], [ -102.045263, 38.505395 ], [ -102.044944, 38.384419 ], [ -102.044613, 38.312324 ], [ -102.044568, 38.268819 ], [ -102.044567, 38.268749 ], [ -102.044510, 38.262412 ], [ -102.044398, 38.250015 ], [ -102.043844, 37.928102 ], [ -102.043845, 37.926135 ], [ -102.043219, 37.867929 ], [ -102.043033, 37.824146 ], [ -102.042953, 37.803535 ], [ -102.042668, 37.788758 ], [ -102.042158, 37.760164 ], [ -102.041990, 37.738541 ], [ -102.041876, 37.723875 ], [ -102.041574, 37.680436 ], [ -102.041694, 37.665681 ], [ -102.041582, 37.654495 ], [ -102.041585, 37.644282 ], [ -102.041618, 37.607868 ], [ -102.041894, 37.557977 ], [ -102.041899, 37.541186 ], [ -102.042016, 37.535261 ], [ -102.041786, 37.506066 ], [ -102.041801, 37.469488 ], [ -102.041755, 37.434855 ], [ -102.041669, 37.434740 ], [ -102.041676, 37.409898 ], [ -102.041826, 37.389191 ], [ -102.042089, 37.352819 ], [ -102.041974, 37.352613 ], [ -102.041817, 37.309490 ], [ -102.041664, 37.297650 ], [ -102.041963, 37.258164 ], [ -102.042002, 37.141744 ], [ -102.042135, 37.125021 ], [ -102.042092, 37.125021 ], [ -102.041809, 37.111973 ], [ -102.041983, 37.106551 ], [ -102.041920, 37.035083 ], [ -102.041749, 37.034397 ], [ -102.041921, 37.032178 ], [ -102.041950, 37.030805 ], [ -102.041952, 37.024742 ], [ -102.042240, 36.993083 ], [ -102.054503, 36.993109 ], [ -102.184271, 36.993593 ], [ -102.208316, 36.993730 ], [ -102.355288, 36.994506 ], [ -102.355367, 36.994575 ], [ -102.570896, 36.995136 ], [ -102.875481, 36.999628 ], [ -102.979613, 36.998549 ], [ -102.985807, 36.998571 ], [ -102.986976, 36.998524 ], [ -103.002199, 37.000104 ], [ -103.086105, 36.999864 ], [ -103.733247, 36.998016 ], [ -103.734364, 36.998041 ], [ -104.007855, 36.996239 ], [ -104.732031, 36.993447 ], [ -104.732120, 36.993484 ], [ -105.000554, 36.993264 ], [ -105.120800, 36.995428 ], [ -105.155042, 36.995339 ], [ -105.220613, 36.995169 ], [ -105.419310, 36.995856 ], [ -105.442459, 36.995994 ], [ -105.447255, 36.996017 ], [ -105.465182, 36.995991 ], [ -105.508836, 36.995895 ], [ -105.512485, 36.995777 ], [ -105.533922, 36.995875 ], [ -105.627470, 36.995679 ], [ -105.664720, 36.995874 ], [ -105.716471, 36.995849 ], [ -105.718470, 36.995846 ], [ -105.996159, 36.995418 ], [ -105.997472, 36.995417 ], [ -106.006634, 36.995343 ], [ -106.247705, 36.994266 ], [ -106.248675, 36.994288 ], [ -106.476228, 36.993472 ], [ -106.617159, 36.992967 ], [ -106.617125, 36.993004 ], [ -106.628652, 36.993175 ], [ -106.628733, 36.993161 ], [ -106.661344, 36.993243 ], [ -106.675626, 36.993123 ], [ -106.869796, 36.992426 ], [ -107.000592, 37.000009 ], [ -107.420913, 37.000005 ], [ -107.420915, 37.000005 ], [ -107.481737, 36.999973 ], [ -108.288086, 36.999555 ], [ -108.288400, 36.999520 ], [ -108.320464, 36.999499 ], [ -108.320721, 36.999510 ], [ -108.379203, 36.999459 ], [ -108.619689, 36.999249 ], [ -108.620309, 36.999287 ], [ -108.954404, 36.998906 ], [ -108.958868, 36.998913 ], [ -109.045223, 36.999084 ], [ -109.045166, 37.072742 ], [ -109.045058, 37.074661 ], [ -109.044995, 37.086429 ], [ -109.045189, 37.096271 ], [ -109.045173, 37.109464 ], [ -109.045203, 37.111958 ], [ -109.045156, 37.112064 ], [ -109.045810, 37.374993 ], [ -109.043053, 37.485161 ], [ -109.041915, 37.530653 ], [ -109.041865, 37.530726 ], [ -109.041806, 37.604171 ], [ -109.042131, 37.617662 ], [ -109.042089, 37.623795 ], [ -109.041732, 37.711214 ], [ -109.041760, 37.713182 ], [ -109.041754, 37.835826 ], [ -109.041723, 37.842051 ], [ -109.042137, 37.881160 ], [ -109.043121, 37.974260 ], [ -109.042819, 37.997068 ], [ -109.042820, 37.999301 ], [ -109.042074, 38.153023 ], [ -109.042062, 38.155490 ], [ -109.060062, 38.275489 ], [ -109.059962, 38.499987 ], [ -109.059541, 38.719888 ], [ -109.053943, 38.904414 ], [ -109.053797, 38.905284 ], [ -109.053233, 38.942467 ], [ -109.053292, 38.942878 ], [ -109.051516, 39.124982 ], [ -109.051417, 39.366677 ], [ -109.051363, 39.497674 ], [ -109.051221, 39.660472 ], [ -109.050873, 40.058915 ], [ -109.050813, 40.059579 ], [ -109.050944, 40.180712 ], [ -109.050973, 40.180849 ], [ -109.050854, 40.222662 ], [ -109.049955, 40.539901 ], [ -109.050074, 40.540358 ], [ -109.048249, 40.653601 ], [ -109.048296, 40.662602 ], [ -109.050076, 41.000659 ], [ -108.250649, 41.000114 ], [ -107.918421, 41.002036 ], [ -107.317794, 41.002957 ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US09", "STATE": 4, "name": "Connecticut", "LSAD": "", "CENSUSAREA": 4842.355000 }, "geometry": { "type": "Polygon", "coordinates": [ [ [ -72.397428, 42.033302 ], [ -72.198828, 42.030982 ], [ -72.135715, 42.030245 ], [ -72.135687, 42.030245 ], [ -72.102160, 42.028962 ], [ -72.059752, 42.027339 ], [ -71.800650, 42.023569 ], [ -71.799242, 42.008065 ], [ -71.796822, 41.928552 ], [ -71.796089, 41.904468 ], [ -71.794161, 41.841101 ], [ -71.794161, 41.840141 ], [ -71.792786, 41.808670 ], [ -71.792767, 41.807001 ], [ -71.789678, 41.724734 ], [ -71.789678, 41.724568 ], [ -71.789465, 41.640017 ], [ -71.789356, 41.596910 ], [ -71.789359, 41.596852 ], [ -71.797674, 41.416910 ], [ -71.797683, 41.416709 ], [ -71.818390, 41.419599 ], [ -71.839649, 41.412119 ], [ -71.842563, 41.409855 ], [ -71.843472, 41.405830 ], [ -71.842131, 41.395359 ], [ -71.833443, 41.384524 ], [ -71.831613, 41.370899 ], [ -71.831240, 41.344645 ], [ -71.832530, 41.341204 ], [ -71.839782, 41.334690 ], [ -71.859570, 41.322399 ], [ -71.868235, 41.330941 ], [ -71.886302, 41.336410 ], [ -71.916710, 41.332217 ], [ -71.922092, 41.334518 ], [ -71.923282, 41.335113 ], [ -71.936284, 41.337959 ], [ -71.945652, 41.337799 ], [ -71.956747, 41.329871 ], [ -71.970955, 41.324526 ], [ -71.979447, 41.329987 ], [ -71.982194, 41.329861 ], [ -71.988153, 41.320577 ], [ -72.021898, 41.316838 ], [ -72.084487, 41.319634 ], [ -72.094443, 41.314164 ], [ -72.099820, 41.306998 ], [ -72.111820, 41.299098 ], [ -72.134221, 41.299398 ], [ -72.161580, 41.310262 ], [ -72.173922, 41.317597 ], [ -72.177622, 41.322497 ], [ -72.184122, 41.323997 ], [ -72.191022, 41.323197 ], [ -72.201422, 41.315697 ], [ -72.203022, 41.313197 ], [ -72.204022, 41.299097 ], [ -72.212924, 41.291365 ], [ -72.225276, 41.299047 ], [ -72.235531, 41.300413 ], [ -72.248161, 41.299488 ], [ -72.251895, 41.298620 ], [ -72.250515, 41.294386 ], [ -72.251323, 41.289997 ], [ -72.261487, 41.282926 ], [ -72.317760, 41.277782 ], [ -72.327595, 41.278460 ], [ -72.333894, 41.282916 ], [ -72.341460, 41.280110 ], [ -72.348643, 41.277446 ], [ -72.348068, 41.269698 ], [ -72.386629, 41.261798 ], [ -72.398688, 41.278172 ], [ -72.405930, 41.278398 ], [ -72.451925, 41.278885 ], [ -72.472539, 41.270103 ], [ -72.485693, 41.270881 ], [ -72.499534, 41.265866 ], [ -72.506634, 41.260099 ], [ -72.518660, 41.261253 ], [ -72.521312, 41.265600 ], [ -72.529416, 41.264421 ], [ -72.533247, 41.262690 ], [ -72.536746, 41.256207 ], [ -72.537776, 41.255646 ], [ -72.546833, 41.250718 ], [ -72.547235, 41.250499 ], [ -72.570655, 41.267744 ], [ -72.571076, 41.268054 ], [ -72.571136, 41.268098 ], [ -72.583336, 41.271698 ], [ -72.585181, 41.271321 ], [ -72.585934, 41.271168 ], [ -72.586674, 41.271017 ], [ -72.587926, 41.270761 ], [ -72.589818, 41.270375 ], [ -72.590967, 41.270141 ], [ -72.598036, 41.268698 ], [ -72.607863, 41.270387 ], [ -72.610236, 41.270795 ], [ -72.617237, 41.271998 ], [ -72.617521, 41.271940 ], [ -72.617983, 41.271845 ], [ -72.631363, 41.269092 ], [ -72.641001, 41.267108 ], [ -72.641538, 41.266998 ], [ -72.642811, 41.266884 ], [ -72.650697, 41.266178 ], [ -72.653838, 41.265897 ], [ -72.653931, 41.265931 ], [ -72.654715, 41.266219 ], [ -72.662203, 41.268964 ], [ -72.662838, 41.269197 ], [ -72.667176, 41.268192 ], [ -72.671673, 41.267151 ], [ -72.672339, 41.266997 ], [ -72.674319, 41.265520 ], [ -72.684939, 41.257597 ], [ -72.685414, 41.252607 ], [ -72.685539, 41.251297 ], [ -72.689446, 41.247629 ], [ -72.690237, 41.246887 ], [ -72.690439, 41.246697 ], [ -72.693441, 41.245493 ], [ -72.694744, 41.244970 ], [ -72.695470, 41.244948 ], [ -72.701806, 41.244752 ], [ -72.706236, 41.244615 ], [ -72.707212, 41.244585 ], [ -72.708658, 41.244540 ], [ -72.708963, 41.244530 ], [ -72.709193, 41.244523 ], [ -72.710595, 41.244480 ], [ -72.710821, 41.244812 ], [ -72.713674, 41.249007 ], [ -72.711208, 41.251018 ], [ -72.712460, 41.254167 ], [ -72.722439, 41.259138 ], [ -72.732813, 41.254727 ], [ -72.754444, 41.266913 ], [ -72.757477, 41.266913 ], [ -72.786142, 41.264796 ], [ -72.818737, 41.252244 ], [ -72.819372, 41.254061 ], [ -72.826883, 41.256755 ], [ -72.847767, 41.256690 ], [ -72.850210, 41.255544 ], [ -72.854055, 41.247740 ], [ -72.861344, 41.245297 ], [ -72.881445, 41.242597 ], [ -72.895445, 41.243697 ], [ -72.900803, 41.245864 ], [ -72.904345, 41.247297 ], [ -72.905245, 41.248297 ], [ -72.903045, 41.252797 ], [ -72.902808, 41.252894 ], [ -72.894745, 41.256197 ], [ -72.894730, 41.256260 ], [ -72.893845, 41.259897 ], [ -72.896370, 41.263949 ], [ -72.903129, 41.274794 ], [ -72.907962, 41.282549 ], [ -72.908200, 41.282932 ], [ -72.916827, 41.282033 ], [ -72.917037, 41.281905 ], [ -72.920062, 41.280056 ], [ -72.920658, 41.271574 ], [ -72.920714, 41.270780 ], [ -72.920846, 41.268897 ], [ -72.931887, 41.261139 ], [ -72.933472, 41.260024 ], [ -72.935646, 41.258497 ], [ -72.956984, 41.252920 ], [ -72.959633, 41.252228 ], [ -72.961345, 41.251780 ], [ -72.962047, 41.251597 ], [ -72.983751, 41.235364 ], [ -72.985095, 41.234358 ], [ -72.986247, 41.233497 ], [ -72.997948, 41.222697 ], [ -73.003639, 41.215287 ], [ -73.007548, 41.210197 ], [ -73.013465, 41.205479 ], [ -73.013988, 41.205062 ], [ -73.014948, 41.204297 ], [ -73.020149, 41.204097 ], [ -73.020167, 41.204237 ], [ -73.020195, 41.204446 ], [ -73.020210, 41.204568 ], [ -73.020254, 41.204906 ], [ -73.020449, 41.206397 ], [ -73.022549, 41.207197 ], [ -73.024783, 41.207435 ], [ -73.045602, 41.209658 ], [ -73.050650, 41.210197 ], [ -73.054947, 41.208468 ], [ -73.059350, 41.206697 ], [ -73.077610, 41.195176 ], [ -73.079450, 41.194015 ], [ -73.091220, 41.184153 ], [ -73.092000, 41.183500 ], [ -73.092147, 41.183377 ], [ -73.104328, 41.173170 ], [ -73.105483, 41.172203 ], [ -73.105493, 41.172194 ], [ -73.107987, 41.168738 ], [ -73.110352, 41.159697 ], [ -73.109952, 41.156997 ], [ -73.108352, 41.153718 ], [ -73.111052, 41.150797 ], [ -73.130253, 41.146797 ], [ -73.164370, 41.158565 ], [ -73.170074, 41.160532 ], [ -73.170701, 41.164945 ], [ -73.177774, 41.166697 ], [ -73.202656, 41.158096 ], [ -73.228295, 41.142602 ], [ -73.235058, 41.143996 ], [ -73.247958, 41.126396 ], [ -73.262358, 41.117496 ], [ -73.286759, 41.127896 ], [ -73.296359, 41.125696 ], [ -73.311860, 41.116296 ], [ -73.330660, 41.109996 ], [ -73.372296, 41.104020 ], [ -73.392162, 41.087696 ], [ -73.400154, 41.086299 ], [ -73.413670, 41.073258 ], [ -73.435063, 41.056696 ], [ -73.450364, 41.057096 ], [ -73.468239, 41.051347 ], [ -73.477364, 41.035997 ], [ -73.493327, 41.048173 ], [ -73.516903, 41.038738 ], [ -73.516766, 41.029497 ], [ -73.522666, 41.019297 ], [ -73.528866, 41.016397 ], [ -73.531169, 41.021919 ], [ -73.530189, 41.028776 ], [ -73.532786, 41.031670 ], [ -73.535338, 41.031920 ], [ -73.551494, 41.024336 ], [ -73.561968, 41.016797 ], [ -73.567668, 41.010897 ], [ -73.570068, 41.001597 ], [ -73.583968, 41.000897 ], [ -73.584988, 41.010537 ], [ -73.595699, 41.015995 ], [ -73.603952, 41.015054 ], [ -73.643478, 41.002171 ], [ -73.651175, 40.995229 ], [ -73.657336, 40.985171 ], [ -73.654671, 41.011697 ], [ -73.655371, 41.012797 ], [ -73.670472, 41.030097 ], [ -73.679973, 41.041797 ], [ -73.687173, 41.050697 ], [ -73.694273, 41.059296 ], [ -73.727775, 41.100696 ], [ -73.639672, 41.141495 ], [ -73.632153, 41.144921 ], [ -73.614407, 41.153001 ], [ -73.514617, 41.198434 ], [ -73.509487, 41.200814 ], [ -73.482709, 41.212760 ], [ -73.550961, 41.295422 ], [ -73.544728, 41.366375 ], [ -73.543641, 41.376778 ], [ -73.537673, 41.433905 ], [ -73.537469, 41.435890 ], [ -73.536969, 41.441094 ], [ -73.536067, 41.451331 ], [ -73.535986, 41.453060 ], [ -73.535885, 41.455236 ], [ -73.535857, 41.455709 ], [ -73.535769, 41.457159 ], [ -73.534369, 41.475894 ], [ -73.534269, 41.476394 ], [ -73.534269, 41.476911 ], [ -73.534150, 41.478060 ], [ -73.534055, 41.478968 ], [ -73.533969, 41.479693 ], [ -73.530067, 41.527194 ], [ -73.521457, 41.616429 ], [ -73.517473, 41.666646 ], [ -73.510171, 41.758686 ], [ -73.505008, 41.823773 ], [ -73.504944, 41.824285 ], [ -73.487314, 42.049638 ], [ -73.294420, 42.046984 ], [ -73.293097, 42.046940 ], [ -73.231056, 42.044945 ], [ -73.229798, 42.044877 ], [ -73.127276, 42.041964 ], [ -73.053254, 42.039861 ], [ -73.008739, 42.039356 ], [ -72.863733, 42.037710 ], [ -72.863619, 42.037709 ], [ -72.813541, 42.036494 ], [ -72.816741, 41.997595 ], [ -72.774757, 42.002129 ], [ -72.766739, 42.002995 ], [ -72.766139, 42.007695 ], [ -72.758151, 42.020865 ], [ -72.757467, 42.020947 ], [ -72.755838, 42.036195 ], [ -72.714134, 42.036608 ], [ -72.695927, 42.036788 ], [ -72.509187, 42.034607 ], [ -72.397428, 42.033302 ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US11", "STATE": 5, "name": "District of Columbia", "LSAD": "", "CENSUSAREA": 61.048000 }, "geometry": { "type": "Polygon", "coordinates": [ [ [ -77.032986, 38.839500 ], [ -77.031698, 38.850512 ], [ -77.040599, 38.871212 ], [ -77.068199, 38.899811 ], [ -77.090200, 38.904211 ], [ -77.101200, 38.911111 ], [ -77.119863, 38.934265 ], [ -77.119900, 38.934311 ], [ -77.100700, 38.948910 ], [ -77.054299, 38.985110 ], [ -77.040999, 38.995110 ], [ -77.036299, 38.991710 ], [ -77.015598, 38.975910 ], [ -77.013798, 38.974410 ], [ -77.008298, 38.970110 ], [ -77.002636, 38.965521 ], [ -77.002498, 38.965410 ], [ -76.941722, 38.918019 ], [ -76.909395, 38.892812 ], [ -76.910795, 38.891712 ], [ -76.919295, 38.885112 ], [ -76.920195, 38.884412 ], [ -76.949696, 38.861312 ], [ -76.953696, 38.858512 ], [ -77.001397, 38.821513 ], [ -77.024392, 38.802970 ], [ -77.038598, 38.791513 ], [ -77.032986, 38.839500 ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US13", "STATE": 6, "name": "Georgia", "LSAD": "", "CENSUSAREA": 57513.485000 }, "geometry": { "type": "Polygon", "coordinates": [ [ [ -84.810477, 34.987607 ], [ -84.809184, 34.987569 ], [ -84.808127, 34.987592 ], [ -84.775852, 34.987800 ], [ -84.731022, 34.988088 ], [ -84.727434, 34.988020 ], [ -84.621483, 34.988329 ], [ -84.509886, 34.988010 ], [ -84.509052, 34.988033 ], [ -84.394903, 34.988030 ], [ -84.393935, 34.988068 ], [ -84.321869, 34.988408 ], [ -84.129555, 34.987504 ], [ -84.129455, 34.987504 ], [ -84.029954, 34.987321 ], [ -84.021357, 34.987430 ], [ -84.005457, 34.987440 ], [ -83.936646, 34.987485 ], [ -83.936413, 34.987485 ], [ -83.673621, 34.987111 ], [ -83.620185, 34.992091 ], [ -83.549381, 34.992492 ], [ -83.483064, 34.993737 ], [ -83.108714, 35.000768 ], [ -83.108535, 35.000771 ], [ -83.143261, 34.924756 ], [ -83.242962, 34.877749 ], [ -83.267293, 34.832748 ], [ -83.283151, 34.821328 ], [ -83.324060, 34.788691 ], [ -83.339129, 34.741266 ], [ -83.352422, 34.716111 ], [ -83.352485, 34.715993 ], [ -83.351392, 34.714456 ], [ -83.350976, 34.713243 ], [ -83.351293, 34.701703 ], [ -83.338194, 34.687924 ], [ -83.337867, 34.687681 ], [ -83.291683, 34.653396 ], [ -83.240669, 34.624507 ], [ -83.240676, 34.624307 ], [ -83.167523, 34.600424 ], [ -83.170978, 34.598798 ], [ -83.170278, 34.592398 ], [ -83.106874, 34.534053 ], [ -83.087189, 34.515939 ], [ -83.072746, 34.504349 ], [ -83.052161, 34.493062 ], [ -83.034712, 34.483495 ], [ -83.006848, 34.474376 ], [ -82.995284, 34.474549 ], [ -82.992671, 34.479072 ], [ -82.992215, 34.479198 ], [ -82.979568, 34.482702 ], [ -82.939067, 34.486202 ], [ -82.902665, 34.485902 ], [ -82.882864, 34.479003 ], [ -82.873831, 34.471508 ], [ -82.874864, 34.468891 ], [ -82.848651, 34.423844 ], [ -82.766078, 34.293509 ], [ -82.755028, 34.276067 ], [ -82.741980, 34.230196 ], [ -82.743461, 34.227343 ], [ -82.744415, 34.224913 ], [ -82.741920, 34.210063 ], [ -82.741491, 34.208709 ], [ -82.731881, 34.178363 ], [ -82.717507, 34.150504 ], [ -82.704140, 34.141007 ], [ -82.677320, 34.131657 ], [ -82.668113, 34.120160 ], [ -82.659077, 34.103544 ], [ -82.658561, 34.103118 ], [ -82.654019, 34.100346 ], [ -82.652175, 34.099704 ], [ -82.641252, 34.088914 ], [ -82.640701, 34.088341 ], [ -82.597079, 34.012390 ], [ -82.564582, 33.955810 ], [ -82.564483, 33.955744 ], [ -82.429164, 33.865844 ], [ -82.422803, 33.863754 ], [ -82.408354, 33.866320 ], [ -82.403881, 33.865477 ], [ -82.324480, 33.820033 ], [ -82.301457, 33.801864 ], [ -82.247472, 33.752591 ], [ -82.218649, 33.686299 ], [ -82.196583, 33.630582 ], [ -82.179854, 33.615945 ], [ -82.135046, 33.591044 ], [ -82.129080, 33.589925 ], [ -82.124841, 33.591274 ], [ -82.116630, 33.589723 ], [ -82.098816, 33.586358 ], [ -82.069039, 33.575382 ], [ -82.046335, 33.563830 ], [ -82.028238, 33.544934 ], [ -82.014293, 33.530313 ], [ -82.007638, 33.523335 ], [ -82.007138, 33.522835 ], [ -81.967037, 33.480636 ], [ -81.957934, 33.468632 ], [ -81.912572, 33.408811 ], [ -81.902737, 33.331242 ], [ -81.852136, 33.247544 ], [ -81.851975, 33.247408 ], [ -81.772251, 33.180120 ], [ -81.696934, 33.116551 ], [ -81.620287, 33.095408 ], [ -81.615756, 33.092534 ], [ -81.541831, 33.045654 ], [ -81.511690, 33.024506 ], [ -81.496637, 33.010224 ], [ -81.491495, 32.998572 ], [ -81.494736, 32.978998 ], [ -81.499830, 32.963816 ], [ -81.423772, 32.810514 ], [ -81.404949, 32.747027 ], [ -81.405134, 32.744964 ], [ -81.414761, 32.637440 ], [ -81.418431, 32.634704 ], [ -81.418660, 32.629392 ], [ -81.411906, 32.618410 ], [ -81.389338, 32.595436 ], [ -81.389258, 32.595385 ], [ -81.348155, 32.569294 ], [ -81.328753, 32.561228 ], [ -81.318255, 32.559722 ], [ -81.286776, 32.544831 ], [ -81.275415, 32.539457 ], [ -81.199029, 32.467286 ], [ -81.168032, 32.368391 ], [ -81.140932, 32.349393 ], [ -81.134332, 32.341693 ], [ -81.122333, 32.305395 ], [ -81.120333, 32.285796 ], [ -81.128034, 32.276297 ], [ -81.125457, 32.227130 ], [ -81.122034, 32.161803 ], [ -81.117234, 32.117605 ], [ -81.113334, 32.113205 ], [ -81.061850, 32.087935 ], [ -81.042833, 32.084508 ], [ -81.004115, 32.072225 ], [ -80.885517, 32.034600 ], [ -80.859111, 32.023693 ], [ -80.852276, 32.026676 ], [ -80.843130, 32.024226 ], [ -80.840549, 32.011306 ], [ -80.841913, 32.002643 ], [ -80.848441, 31.988279 ], [ -80.862814, 31.969346 ], [ -80.882814, 31.959075 ], [ -80.897687, 31.949065 ], [ -80.911207, 31.943769 ], [ -80.929101, 31.944964 ], [ -80.930279, 31.956705 ], [ -80.948491, 31.957230 ], [ -80.972392, 31.941270 ], [ -80.975714, 31.923602 ], [ -80.968494, 31.915822 ], [ -80.954469, 31.911768 ], [ -80.941359, 31.912984 ], [ -80.934508, 31.909180 ], [ -80.947294, 31.896210 ], [ -80.971434, 31.877941 ], [ -80.992690, 31.857641 ], [ -81.000317, 31.856744 ], [ -81.014478, 31.867474 ], [ -81.041548, 31.876198 ], [ -81.065255, 31.877095 ], [ -81.058596, 31.857811 ], [ -81.059070, 31.850106 ], [ -81.062790, 31.844740 ], [ -81.076178, 31.836132 ], [ -81.075812, 31.829031 ], [ -81.057181, 31.822687 ], [ -81.050946, 31.822383 ], [ -81.047940, 31.824881 ], [ -81.039808, 31.823000 ], [ -81.036958, 31.819558 ], [ -81.036873, 31.812721 ], [ -81.047345, 31.802865 ], [ -81.068116, 31.768735 ], [ -81.077057, 31.761256 ], [ -81.097402, 31.753126 ], [ -81.130634, 31.722692 ], [ -81.138448, 31.720934 ], [ -81.154686, 31.726203 ], [ -81.160670, 31.728144 ], [ -81.192784, 31.733245 ], [ -81.198394, 31.726070 ], [ -81.203572, 31.719448 ], [ -81.186303, 31.701509 ], [ -81.161084, 31.691401 ], [ -81.154624, 31.693874 ], [ -81.151888, 31.698411 ], [ -81.149369, 31.699304 ], [ -81.139394, 31.699917 ], [ -81.131137, 31.695774 ], [ -81.135608, 31.683491 ], [ -81.136408, 31.674832 ], [ -81.131728, 31.654484 ], [ -81.133493, 31.623348 ], [ -81.149970, 31.593476 ], [ -81.160364, 31.570436 ], [ -81.173079, 31.555908 ], [ -81.178822, 31.555530 ], [ -81.183252, 31.560058 ], [ -81.186114, 31.568032 ], [ -81.194380, 31.568101 ], [ -81.204315, 31.568183 ], [ -81.214536, 31.557601 ], [ -81.240699, 31.552313 ], [ -81.254218, 31.555940 ], [ -81.260076, 31.548280 ], [ -81.263905, 31.532579 ], [ -81.263437, 31.530932 ], [ -81.258809, 31.529060 ], [ -81.217948, 31.527284 ], [ -81.213519, 31.528152 ], [ -81.199518, 31.537596 ], [ -81.193016, 31.535833 ], [ -81.181592, 31.527697 ], [ -81.178310, 31.522410 ], [ -81.177254, 31.517074 ], [ -81.189643, 31.503588 ], [ -81.204883, 31.473124 ], [ -81.246911, 31.422784 ], [ -81.258616, 31.404425 ], [ -81.278798, 31.367214 ], [ -81.279338, 31.351127 ], [ -81.282923, 31.326491 ], [ -81.274513, 31.326237 ], [ -81.268027, 31.324218 ], [ -81.254820, 31.315452 ], [ -81.260958, 31.303910 ], [ -81.269906, 31.294489 ], [ -81.274688, 31.289454 ], [ -81.276862, 31.254734 ], [ -81.282842, 31.244330 ], [ -81.289136, 31.225487 ], [ -81.288403, 31.211065 ], [ -81.293359, 31.206332 ], [ -81.304957, 31.206173 ], [ -81.314183, 31.207938 ], [ -81.339028, 31.186918 ], [ -81.354880, 31.167204 ], [ -81.360791, 31.155903 ], [ -81.359349, 31.149166 ], [ -81.368241, 31.136534 ], [ -81.386830, 31.133214 ], [ -81.399677, 31.134113 ], [ -81.402096, 31.125383 ], [ -81.403732, 31.107115 ], [ -81.401209, 31.086143 ], [ -81.401267, 31.072781 ], [ -81.415123, 31.026718 ], [ -81.420474, 31.016703 ], [ -81.424732, 31.013678 ], [ -81.432475, 31.012991 ], [ -81.434710, 31.014641 ], [ -81.434923, 31.017804 ], [ -81.443170, 31.016661 ], [ -81.451444, 31.015515 ], [ -81.457795, 31.010259 ], [ -81.459240, 31.005692 ], [ -81.469298, 30.996028 ], [ -81.490586, 30.984952 ], [ -81.493651, 30.977528 ], [ -81.486966, 30.969602 ], [ -81.475789, 30.965976 ], [ -81.472321, 30.969899 ], [ -81.466814, 30.970910 ], [ -81.453568, 30.965573 ], [ -81.447388, 30.956732 ], [ -81.426929, 30.956615 ], [ -81.420108, 30.974076 ], [ -81.415825, 30.977192 ], [ -81.408484, 30.977718 ], [ -81.403409, 30.957914 ], [ -81.405153, 30.908203 ], [ -81.428577, 30.836336 ], [ -81.430835, 30.831156 ], [ -81.440130, 30.821369 ], [ -81.446927, 30.810390 ], [ -81.455287, 30.790930 ], [ -81.460061, 30.769912 ], [ -81.461065, 30.753684 ], [ -81.459470, 30.741979 ], [ -81.449375, 30.715601 ], [ -81.444124, 30.709714 ], [ -81.544618, 30.712636 ], [ -81.606221, 30.718135 ], [ -81.624298, 30.736194 ], [ -81.637222, 30.733835 ], [ -81.719927, 30.744634 ], [ -81.732627, 30.749934 ], [ -81.741278, 30.762681 ], [ -81.759338, 30.771377 ], [ -81.806652, 30.789683 ], [ -81.827014, 30.788933 ], [ -81.840375, 30.786384 ], [ -81.868608, 30.792754 ], [ -81.906014, 30.822176 ], [ -81.999836, 30.788348 ], [ -82.023213, 30.781987 ], [ -82.050432, 30.676266 ], [ -82.049401, 30.655296 ], [ -82.037609, 30.633271 ], [ -82.013290, 30.595665 ], [ -82.005477, 30.563495 ], [ -82.016990, 30.519358 ], [ -82.016103, 30.497355 ], [ -82.050031, 30.362490 ], [ -82.050069, 30.362338 ], [ -82.124835, 30.366564 ], [ -82.165192, 30.358035 ], [ -82.171508, 30.359869 ], [ -82.189583, 30.376213 ], [ -82.204151, 30.401330 ], [ -82.210291, 30.424590 ], [ -82.206040, 30.455507 ], [ -82.212330, 30.499558 ], [ -82.214385, 30.566958 ], [ -82.214847, 30.567009 ], [ -82.249841, 30.570863 ], [ -82.258100, 30.571559 ], [ -82.287343, 30.573458 ], [ -82.374844, 30.579004 ], [ -82.418915, 30.581745 ], [ -82.459544, 30.584272 ], [ -82.459792, 30.584287 ], [ -82.524899, 30.588189 ], [ -82.536233, 30.588885 ], [ -82.545055, 30.589361 ], [ -82.553159, 30.589934 ], [ -82.565476, 30.590622 ], [ -82.569237, 30.590965 ], [ -82.584002, 30.591796 ], [ -82.689271, 30.597719 ], [ -82.689539, 30.597734 ], [ -82.698618, 30.598232 ], [ -82.698902, 30.598271 ], [ -82.877259, 30.609024 ], [ -82.878779, 30.609082 ], [ -83.136616, 30.624346 ], [ -83.156170, 30.625504 ], [ -83.163309, 30.625895 ], [ -83.174411, 30.626444 ], [ -83.187391, 30.627223 ], [ -83.256218, 30.631279 ], [ -83.309249, 30.634405 ], [ -83.309250, 30.634405 ], [ -83.309455, 30.634417 ], [ -83.311647, 30.634577 ], [ -83.340852, 30.636336 ], [ -83.341011, 30.636346 ], [ -83.357703, 30.637359 ], [ -83.379460, 30.638680 ], [ -83.390062, 30.639333 ], [ -83.429477, 30.641519 ], [ -83.429584, 30.641496 ], [ -83.440021, 30.642023 ], [ -83.448895, 30.642410 ], [ -83.611667, 30.651255 ], [ -83.611720, 30.651258 ], [ -83.674058, 30.654747 ], [ -83.676773, 30.654905 ], [ -83.743729, 30.658396 ], [ -83.810536, 30.661880 ], [ -83.820886, 30.662612 ], [ -83.855216, 30.664412 ], [ -83.880220, 30.665832 ], [ -83.880317, 30.665807 ], [ -84.007391, 30.672097 ], [ -84.007454, 30.672100 ], [ -84.039707, 30.673819 ], [ -84.041810, 30.673878 ], [ -84.046605, 30.674200 ], [ -84.057228, 30.674705 ], [ -84.083753, 30.675954 ], [ -84.281210, 30.685256 ], [ -84.282562, 30.685316 ], [ -84.380719, 30.689673 ], [ -84.535042, 30.696523 ], [ -84.539370, 30.696775 ], [ -84.606249, 30.699872 ], [ -84.606386, 30.699865 ], [ -84.863465, 30.711487 ], [ -84.864693, 30.711542 ], [ -84.896122, 30.750591 ], [ -84.941925, 30.887988 ], [ -84.959626, 30.910587 ], [ -84.983527, 30.935486 ], [ -84.998628, 30.971386 ], [ -85.002368, 31.000682 ], [ -84.999428, 31.013843 ], [ -85.022121, 31.075480 ], [ -85.029736, 31.096163 ], [ -85.035615, 31.108192 ], [ -85.076628, 31.156927 ], [ -85.083582, 31.159630 ], [ -85.092106, 31.160293 ], [ -85.100207, 31.165490 ], [ -85.107516, 31.186451 ], [ -85.111871, 31.258388 ], [ -85.101561, 31.283362 ], [ -85.087651, 31.308677 ], [ -85.068065, 31.427586 ], [ -85.046859, 31.517451 ], [ -85.041305, 31.540987 ], [ -85.057473, 31.618624 ], [ -85.059534, 31.621717 ], [ -85.065236, 31.624351 ], [ -85.087029, 31.640966 ], [ -85.125530, 31.694965 ], [ -85.126530, 31.716764 ], [ -85.122230, 31.722764 ], [ -85.118930, 31.732664 ], [ -85.124501, 31.763081 ], [ -85.125230, 31.767063 ], [ -85.130731, 31.772263 ], [ -85.138668, 31.780425 ], [ -85.141331, 31.783163 ], [ -85.141831, 31.839861 ], [ -85.132931, 31.888260 ], [ -85.106630, 31.915159 ], [ -85.082130, 31.944658 ], [ -85.072330, 31.964758 ], [ -85.062246, 31.991857 ], [ -85.050212, 32.024196 ], [ -85.056029, 32.063055 ], [ -85.047865, 32.142033 ], [ -84.995929, 32.184852 ], [ -84.964828, 32.194952 ], [ -84.923638, 32.231539 ], [ -84.921650, 32.233306 ], [ -84.909052, 32.263540 ], [ -84.916611, 32.281177 ], [ -84.938680, 32.300708 ], [ -85.001874, 32.322015 ], [ -85.007103, 32.328362 ], [ -85.008096, 32.336677 ], [ -84.987386, 32.381201 ], [ -84.987278, 32.381623 ], [ -84.979431, 32.412244 ], [ -84.983831, 32.445643 ], [ -84.998231, 32.469842 ], [ -85.000779, 32.506548 ], [ -85.001030, 32.510157 ], [ -85.001052, 32.510477 ], [ -85.001324, 32.512973 ], [ -85.007100, 32.523868 ], [ -85.022509, 32.542923 ], [ -85.044606, 32.559499 ], [ -85.069583, 32.583930 ], [ -85.079935, 32.602889 ], [ -85.080288, 32.603577 ], [ -85.082454, 32.607022 ], [ -85.104790, 32.642542 ], [ -85.114737, 32.685634 ], [ -85.137136, 32.745168 ], [ -85.136776, 32.746512 ], [ -85.132040, 32.764211 ], [ -85.123421, 32.772248 ], [ -85.184131, 32.870525 ], [ -85.221868, 33.055538 ], [ -85.223261, 33.062580 ], [ -85.232378, 33.108077 ], [ -85.236509, 33.129562 ], [ -85.293902, 33.428079 ], [ -85.304439, 33.482884 ], [ -85.313999, 33.529807 ], [ -85.314091, 33.530218 ], [ -85.314994, 33.535898 ], [ -85.322497, 33.574167 ], [ -85.337974, 33.653111 ], [ -85.360491, 33.767958 ], [ -85.361844, 33.773951 ], [ -85.386693, 33.901697 ], [ -85.398837, 33.964129 ], [ -85.421731, 34.080821 ], [ -85.455057, 34.250689 ], [ -85.455371, 34.252854 ], [ -85.458071, 34.265736 ], [ -85.458693, 34.269437 ], [ -85.462304, 34.286365 ], [ -85.502316, 34.473954 ], [ -85.502454, 34.474527 ], [ -85.508384, 34.501212 ], [ -85.512108, 34.518252 ], [ -85.513699, 34.524133 ], [ -85.513709, 34.524170 ], [ -85.513930, 34.525192 ], [ -85.527127, 34.588684 ], [ -85.534423, 34.623789 ], [ -85.541264, 34.656701 ], [ -85.541267, 34.656783 ], [ -85.552454, 34.708138 ], [ -85.552482, 34.708321 ], [ -85.583145, 34.860371 ], [ -85.595163, 34.924171 ], [ -85.595191, 34.924331 ], [ -85.605165, 34.984678 ], [ -85.474472, 34.983972 ], [ -85.363919, 34.983375 ], [ -85.308257, 34.984375 ], [ -85.305457, 34.984475 ], [ -85.301488, 34.984475 ], [ -85.294500, 34.984651 ], [ -85.277556, 34.984975 ], [ -85.275856, 34.984975 ], [ -85.265055, 34.985075 ], [ -85.254955, 34.985175 ], [ -85.235555, 34.985475 ], [ -85.230354, 34.985475 ], [ -85.221854, 34.985475 ], [ -85.220554, 34.985575 ], [ -85.217854, 34.985675 ], [ -85.216554, 34.985675 ], [ -85.185905, 34.985995 ], [ -85.180553, 34.986075 ], [ -85.045183, 34.986883 ], [ -85.045052, 34.986859 ], [ -84.979860, 34.987647 ], [ -84.976973, 34.987669 ], [ -84.955623, 34.987830 ], [ -84.944420, 34.987864 ], [ -84.939306, 34.987916 ], [ -84.861314, 34.987791 ], [ -84.858032, 34.987746 ], [ -84.831799, 34.988004 ], [ -84.824010, 34.987707 ], [ -84.820478, 34.987913 ], [ -84.817279, 34.987753 ], [ -84.810742, 34.987615 ], [ -84.810477, 34.987607 ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US15", "STATE": 7, "name": "Hawaii", "LSAD": "", "CENSUSAREA": 6422.628000 }, "geometry": { "type": "MultiPolygon", "coordinates": [ [ [ [ -155.778234, 20.245743 ], [ -155.772734, 20.245409 ], [ -155.746893, 20.232325 ], [ -155.737004, 20.222773 ], [ -155.735822, 20.212417 ], [ -155.732704, 20.205392 ], [ -155.653966, 20.167360 ], [ -155.630382, 20.146916 ], [ -155.624565, 20.145911 ], [ -155.607797, 20.137987 ], [ -155.600909, 20.126573 ], [ -155.598033, 20.124539 ], [ -155.590923, 20.122497 ], [ -155.581680, 20.123617 ], [ -155.568368, 20.130545 ], [ -155.558933, 20.131570 ], [ -155.523661, 20.120028 ], [ -155.516795, 20.115230 ], [ -155.502561, 20.114155 ], [ -155.468211, 20.104296 ], [ -155.443957, 20.095318 ], [ -155.405459, 20.078772 ], [ -155.402400, 20.075541 ], [ -155.387578, 20.067119 ], [ -155.330210, 20.038517 ], [ -155.295480, 20.024438 ], [ -155.282629, 20.021969 ], [ -155.270316, 20.014525 ], [ -155.240933, 19.990173 ], [ -155.204486, 19.969438 ], [ -155.194593, 19.958368 ], [ -155.179939, 19.949372 ], [ -155.149215, 19.922872 ], [ -155.144394, 19.920523 ], [ -155.131235, 19.906801 ], [ -155.124618, 19.897288 ], [ -155.121750, 19.886099 ], [ -155.107541, 19.872467 ], [ -155.098716, 19.867811 ], [ -155.095032, 19.867882 ], [ -155.086341, 19.855399 ], [ -155.084357, 19.849736 ], [ -155.085674, 19.838584 ], [ -155.088979, 19.826656 ], [ -155.094414, 19.814910 ], [ -155.092070, 19.799409 ], [ -155.091216, 19.776368 ], [ -155.093517, 19.771832 ], [ -155.093387, 19.737751 ], [ -155.087118, 19.728013 ], [ -155.079426, 19.726193 ], [ -155.063972, 19.728917 ], [ -155.045382, 19.739824 ], [ -155.006423, 19.739286 ], [ -154.997278, 19.728580 ], [ -154.987168, 19.708524 ], [ -154.981102, 19.690687 ], [ -154.984718, 19.672161 ], [ -154.983778, 19.641647 ], [ -154.974342, 19.633201 ], [ -154.963933, 19.627605 ], [ -154.950359, 19.626461 ], [ -154.947874, 19.624250 ], [ -154.947718, 19.621947 ], [ -154.951014, 19.613614 ], [ -154.947106, 19.604856 ], [ -154.933940, 19.597505 ], [ -154.928205, 19.592702 ], [ -154.924422, 19.586553 ], [ -154.903542, 19.570622 ], [ -154.875000, 19.556797 ], [ -154.852618, 19.549172 ], [ -154.837384, 19.538354 ], [ -154.826732, 19.537626 ], [ -154.814417, 19.530090 ], [ -154.809561, 19.522377 ], [ -154.809379, 19.519086 ], [ -154.822968, 19.481290 ], [ -154.838545, 19.463642 ], [ -154.868540, 19.438126 ], [ -154.887817, 19.426425 ], [ -154.928772, 19.397646 ], [ -154.944185, 19.381852 ], [ -154.964619, 19.365646 ], [ -154.980861, 19.349291 ], [ -155.020537, 19.331317 ], [ -155.061729, 19.316636 ], [ -155.113272, 19.290613 ], [ -155.133700, 19.276099 ], [ -155.159635, 19.268375 ], [ -155.172413, 19.269060 ], [ -155.187427, 19.266156 ], [ -155.196260, 19.261295 ], [ -155.205892, 19.260907 ], [ -155.243961, 19.271313 ], [ -155.264619, 19.274213 ], [ -155.296761, 19.266289 ], [ -155.303808, 19.261835 ], [ -155.313370, 19.250698 ], [ -155.341268, 19.234039 ], [ -155.349148, 19.217756 ], [ -155.360631, 19.208930 ], [ -155.378638, 19.202435 ], [ -155.390701, 19.201171 ], [ -155.417369, 19.187858 ], [ -155.427093, 19.179546 ], [ -155.432519, 19.170623 ], [ -155.453516, 19.151952 ], [ -155.465663, 19.146964 ], [ -155.505281, 19.137908 ], [ -155.514740, 19.132501 ], [ -155.512140, 19.128174 ], [ -155.512137, 19.124296 ], [ -155.519652, 19.117025 ], [ -155.526136, 19.115889 ], [ -155.528902, 19.113710 ], [ -155.544806, 19.091059 ], [ -155.551129, 19.088780 ], [ -155.557817, 19.082130 ], [ -155.555326, 19.069377 ], [ -155.555177, 19.053932 ], [ -155.557371, 19.046565 ], [ -155.566446, 19.032531 ], [ -155.576599, 19.027412 ], [ -155.581903, 19.022240 ], [ -155.596032, 18.998833 ], [ -155.596521, 18.980654 ], [ -155.601866, 18.971572 ], [ -155.613966, 18.970399 ], [ -155.625256, 18.961951 ], [ -155.625000, 18.959934 ], [ -155.638054, 18.941723 ], [ -155.658486, 18.924835 ], [ -155.672005, 18.917466 ], [ -155.681825, 18.918694 ], [ -155.687716, 18.923358 ], [ -155.690171, 18.932195 ], [ -155.693117, 18.940542 ], [ -155.726043, 18.969437 ], [ -155.763598, 18.981837 ], [ -155.806109, 19.013967 ], [ -155.853943, 19.023762 ], [ -155.881550, 19.036644 ], [ -155.884077, 19.039266 ], [ -155.886278, 19.055760 ], [ -155.903693, 19.080777 ], [ -155.908355, 19.081138 ], [ -155.921389, 19.121183 ], [ -155.917292, 19.155963 ], [ -155.903339, 19.217792 ], [ -155.904910, 19.230147 ], [ -155.902565, 19.258427 ], [ -155.895435, 19.274639 ], [ -155.890842, 19.298905 ], [ -155.887356, 19.337101 ], [ -155.888701, 19.348031 ], [ -155.898792, 19.377984 ], [ -155.913849, 19.401107 ], [ -155.909087, 19.415455 ], [ -155.921707, 19.430550 ], [ -155.924269, 19.438794 ], [ -155.925166, 19.468081 ], [ -155.922609, 19.478611 ], [ -155.924124, 19.481406 ], [ -155.930523, 19.484921 ], [ -155.935641, 19.485628 ], [ -155.936403, 19.481905 ], [ -155.939145, 19.481577 ], [ -155.951490, 19.486649 ], [ -155.952897, 19.488805 ], [ -155.953663, 19.510003 ], [ -155.960457, 19.546612 ], [ -155.962264, 19.551779 ], [ -155.965211, 19.554745 ], [ -155.969350, 19.555963 ], [ -155.970969, 19.586328 ], [ -155.978206, 19.608159 ], [ -155.997728, 19.642816 ], [ -156.028982, 19.650098 ], [ -156.032928, 19.653905 ], [ -156.034994, 19.659360 ], [ -156.033326, 19.669230 ], [ -156.027427, 19.672154 ], [ -156.029281, 19.678908 ], [ -156.036079, 19.690252 ], [ -156.047960, 19.698938 ], [ -156.051652, 19.703649 ], [ -156.052485, 19.718667 ], [ -156.064364, 19.730766 ], [ -156.057220, 19.742536 ], [ -156.052315, 19.756836 ], [ -156.049651, 19.780452 ], [ -156.021732, 19.802200 ], [ -156.006267, 19.817580 ], [ -155.982821, 19.845651 ], [ -155.976651, 19.850530 ], [ -155.964817, 19.855183 ], [ -155.949251, 19.857034 ], [ -155.945297, 19.853443 ], [ -155.940311, 19.852305 ], [ -155.925843, 19.858928 ], [ -155.926938, 19.870221 ], [ -155.925490, 19.875000 ], [ -155.915662, 19.887126 ], [ -155.901987, 19.912081 ], [ -155.894099, 19.923135 ], [ -155.894474, 19.926927 ], [ -155.892533, 19.932162 ], [ -155.866919, 19.954172 ], [ -155.856588, 19.968885 ], [ -155.840708, 19.976952 ], [ -155.838692, 19.975527 ], [ -155.835312, 19.976078 ], [ -155.831948, 19.982775 ], [ -155.828965, 19.995542 ], [ -155.825473, 20.025944 ], [ -155.828182, 20.035424 ], [ -155.850385, 20.062506 ], [ -155.866931, 20.078652 ], [ -155.884190, 20.106750 ], [ -155.899149, 20.145728 ], [ -155.906035, 20.205157 ], [ -155.901452, 20.235787 ], [ -155.890663, 20.255240 ], [ -155.882631, 20.263026 ], [ -155.873921, 20.267744 ], [ -155.853293, 20.271548 ], [ -155.811459, 20.260320 ], [ -155.783242, 20.246395 ], [ -155.778234, 20.245743 ] ] ], [ [ [ -160.555771, 21.668287 ], [ -160.551041, 21.670101 ], [ -160.543320, 21.667128 ], [ -160.542404, 21.648081 ], [ -160.549316, 21.645353 ], [ -160.554123, 21.649546 ], [ -160.555771, 21.668287 ] ] ], [ [ [ -160.125000, 21.959090 ], [ -160.122262, 21.962881 ], [ -160.112746, 21.995245 ], [ -160.096450, 22.001489 ], [ -160.072123, 22.003334 ], [ -160.058543, 21.996380 ], [ -160.051992, 21.983681 ], [ -160.052729, 21.980321 ], [ -160.056336, 21.977939 ], [ -160.060549, 21.976729 ], [ -160.063349, 21.978354 ], [ -160.065811, 21.976562 ], [ -160.078393, 21.955153 ], [ -160.085787, 21.927295 ], [ -160.080012, 21.910808 ], [ -160.079065, 21.896080 ], [ -160.098897, 21.884711 ], [ -160.124283, 21.876789 ], [ -160.147609, 21.872814 ], [ -160.161620, 21.864746 ], [ -160.174796, 21.846923 ], [ -160.189782, 21.822450 ], [ -160.205211, 21.789053 ], [ -160.200427, 21.786479 ], [ -160.205851, 21.779518 ], [ -160.218044, 21.783755 ], [ -160.234780, 21.795418 ], [ -160.249610, 21.815145 ], [ -160.244943, 21.848943 ], [ -160.231028, 21.886263 ], [ -160.228965, 21.889117 ], [ -160.213830, 21.899193 ], [ -160.205528, 21.907507 ], [ -160.202716, 21.912422 ], [ -160.190158, 21.923592 ], [ -160.167471, 21.932863 ], [ -160.137050, 21.948632 ], [ -160.127302, 21.955508 ], [ -160.125000, 21.959090 ] ] ], [ [ [ -159.431707, 22.220015 ], [ -159.407320, 22.230555 ], [ -159.388119, 22.223252 ], [ -159.385977, 22.220009 ], [ -159.367563, 22.214906 ], [ -159.359842, 22.214831 ], [ -159.357227, 22.217744 ], [ -159.353795, 22.217669 ], [ -159.339964, 22.208519 ], [ -159.315613, 22.186817 ], [ -159.308855, 22.155555 ], [ -159.297808, 22.149748 ], [ -159.295875, 22.144547 ], [ -159.295271, 22.130390 ], [ -159.297143, 22.113815 ], [ -159.317451, 22.080944 ], [ -159.321667, 22.063411 ], [ -159.324775, 22.058670 ], [ -159.333267, 22.054639 ], [ -159.337996, 22.046575 ], [ -159.341401, 22.028978 ], [ -159.333224, 21.973005 ], [ -159.333109, 21.964176 ], [ -159.334714, 21.961099 ], [ -159.350828, 21.950817 ], [ -159.356613, 21.939546 ], [ -159.382349, 21.924479 ], [ -159.408284, 21.897781 ], [ -159.425862, 21.884527 ], [ -159.446599, 21.871647 ], [ -159.471962, 21.882920 ], [ -159.490914, 21.888898 ], [ -159.517973, 21.890996 ], [ -159.555415, 21.891355 ], [ -159.574991, 21.896585 ], [ -159.577784, 21.900486 ], [ -159.584272, 21.899038 ], [ -159.610241, 21.898356 ], [ -159.637849, 21.917166 ], [ -159.648132, 21.932970 ], [ -159.671872, 21.957038 ], [ -159.681493, 21.960054 ], [ -159.705255, 21.963427 ], [ -159.720140, 21.970789 ], [ -159.758218, 21.980694 ], [ -159.765735, 21.986593 ], [ -159.788139, 22.018411 ], [ -159.790932, 22.031177 ], [ -159.786543, 22.063690 ], [ -159.780096, 22.072567 ], [ -159.748159, 22.100388 ], [ -159.741223, 22.115666 ], [ -159.733457, 22.142756 ], [ -159.726043, 22.152171 ], [ -159.699978, 22.165252 ], [ -159.669840, 22.170782 ], [ -159.608794, 22.207878 ], [ -159.591596, 22.219456 ], [ -159.583965, 22.226680 ], [ -159.559643, 22.229185 ], [ -159.554166, 22.228212 ], [ -159.548594, 22.226263 ], [ -159.541150, 22.216764 ], [ -159.534594, 22.219403 ], [ -159.523769, 22.217602 ], [ -159.519410, 22.215646 ], [ -159.518348, 22.211182 ], [ -159.515574, 22.208008 ], [ -159.507811, 22.205987 ], [ -159.501055, 22.211064 ], [ -159.500821, 22.225538 ], [ -159.488558, 22.233170 ], [ -159.480158, 22.232715 ], [ -159.467007, 22.226529 ], [ -159.456190, 22.228811 ], [ -159.441809, 22.226321 ], [ -159.431707, 22.220015 ] ] ], [ [ [ -157.014553, 21.185503 ], [ -156.999108, 21.182221 ], [ -156.991318, 21.185510 ], [ -156.987768, 21.189350 ], [ -156.982343, 21.207798 ], [ -156.984464, 21.210063 ], [ -156.984032, 21.212198 ], [ -156.974002, 21.218503 ], [ -156.969064, 21.217018 ], [ -156.962847, 21.212131 ], [ -156.951654, 21.191662 ], [ -156.950808, 21.182636 ], [ -156.946159, 21.175963 ], [ -156.918248, 21.168279 ], [ -156.903466, 21.164210 ], [ -156.898174, 21.165940 ], [ -156.896130, 21.169561 ], [ -156.896537, 21.172208 ], [ -156.867944, 21.164520 ], [ -156.841592, 21.167926 ], [ -156.821944, 21.174693 ], [ -156.771495, 21.180053 ], [ -156.742231, 21.176214 ], [ -156.738341, 21.172020 ], [ -156.736648, 21.161880 ], [ -156.719386, 21.163911 ], [ -156.712696, 21.161547 ], [ -156.714158, 21.152238 ], [ -156.726033, 21.132360 ], [ -156.748932, 21.108600 ], [ -156.775995, 21.089751 ], [ -156.790815, 21.081686 ], [ -156.794136, 21.075796 ], [ -156.835351, 21.063360 ], [ -156.865795, 21.057801 ], [ -156.877137, 21.049300 ], [ -156.891946, 21.051831 ], [ -156.895170, 21.055771 ], [ -156.953719, 21.067761 ], [ -157.002950, 21.083282 ], [ -157.026170, 21.089015 ], [ -157.032045, 21.091094 ], [ -157.037667, 21.097864 ], [ -157.079696, 21.105835 ], [ -157.095373, 21.106360 ], [ -157.125000, 21.102600 ], [ -157.143483, 21.096632 ], [ -157.254061, 21.090601 ], [ -157.298054, 21.096917 ], [ -157.313343, 21.105755 ], [ -157.299187, 21.132488 ], [ -157.299471, 21.135972 ], [ -157.293774, 21.146127 ], [ -157.284346, 21.157755 ], [ -157.276474, 21.163175 ], [ -157.274504, 21.162762 ], [ -157.259911, 21.174875 ], [ -157.254709, 21.181376 ], [ -157.251007, 21.190952 ], [ -157.250260, 21.207739 ], [ -157.256935, 21.215665 ], [ -157.261457, 21.217661 ], [ -157.263163, 21.220873 ], [ -157.260690, 21.225684 ], [ -157.257085, 21.227268 ], [ -157.241534, 21.220969 ], [ -157.226445, 21.220185 ], [ -157.212082, 21.221848 ], [ -157.202125, 21.219298 ], [ -157.192439, 21.207644 ], [ -157.185553, 21.205602 ], [ -157.157103, 21.200706 ], [ -157.148125, 21.200745 ], [ -157.144627, 21.202555 ], [ -157.128207, 21.201488 ], [ -157.113438, 21.197375 ], [ -157.097971, 21.198012 ], [ -157.064264, 21.189076 ], [ -157.053053, 21.188754 ], [ -157.047757, 21.190739 ], [ -157.039987, 21.190909 ], [ -157.014553, 21.185503 ] ] ], [ [ [ -156.544169, 20.522802 ], [ -156.550016, 20.520273 ], [ -156.559994, 20.521892 ], [ -156.586238, 20.511711 ], [ -156.603844, 20.524372 ], [ -156.631143, 20.514943 ], [ -156.642347, 20.508285 ], [ -156.647464, 20.512017 ], [ -156.668809, 20.504738 ], [ -156.682939, 20.506775 ], [ -156.703673, 20.527237 ], [ -156.702265, 20.532451 ], [ -156.696662, 20.541646 ], [ -156.680100, 20.557021 ], [ -156.651567, 20.565574 ], [ -156.614598, 20.587109 ], [ -156.610734, 20.593770 ], [ -156.576871, 20.606570 ], [ -156.567140, 20.604895 ], [ -156.553604, 20.594729 ], [ -156.543034, 20.580115 ], [ -156.542808, 20.573674 ], [ -156.548909, 20.568590 ], [ -156.556021, 20.542657 ], [ -156.553018, 20.539382 ], [ -156.540189, 20.534741 ], [ -156.539643, 20.527644 ], [ -156.544169, 20.522802 ] ] ], [ [ [ -156.612012, 21.024770 ], [ -156.612065, 21.027273 ], [ -156.606238, 21.034371 ], [ -156.592256, 21.032880 ], [ -156.580448, 21.020172 ], [ -156.562773, 21.016167 ], [ -156.549813, 21.004939 ], [ -156.546291, 21.005082 ], [ -156.528246, 20.967757 ], [ -156.518707, 20.954662 ], [ -156.512226, 20.951280 ], [ -156.510391, 20.940358 ], [ -156.507913, 20.937886 ], [ -156.499480, 20.934577 ], [ -156.495883, 20.928005 ], [ -156.493263, 20.916011 ], [ -156.481055, 20.898199 ], [ -156.474796, 20.894546 ], [ -156.422668, 20.911631 ], [ -156.386045, 20.919563 ], [ -156.374297, 20.927616 ], [ -156.370729, 20.932669 ], [ -156.352649, 20.941414 ], [ -156.345655, 20.941596 ], [ -156.342365, 20.938737 ], [ -156.332817, 20.946450 ], [ -156.324578, 20.950184 ], [ -156.307198, 20.942739 ], [ -156.286332, 20.947701 ], [ -156.275116, 20.937361 ], [ -156.263107, 20.940888 ], [ -156.242555, 20.937838 ], [ -156.230159, 20.931936 ], [ -156.230089, 20.917864 ], [ -156.226757, 20.916677 ], [ -156.222062, 20.918309 ], [ -156.217953, 20.916573 ], [ -156.216341, 20.907035 ], [ -156.173103, 20.876926 ], [ -156.170458, 20.874605 ], [ -156.166746, 20.865646 ], [ -156.132669, 20.861369 ], [ -156.129381, 20.847513 ], [ -156.115735, 20.827301 ], [ -156.100123, 20.828502 ], [ -156.090291, 20.831872 ], [ -156.059788, 20.810540 ], [ -156.033287, 20.808246 ], [ -156.003532, 20.795545 ], [ -156.002947, 20.789418 ], [ -155.987944, 20.776552 ], [ -155.984587, 20.767496 ], [ -155.986851, 20.758577 ], [ -155.985413, 20.744245 ], [ -155.987216, 20.722717 ], [ -155.991534, 20.713654 ], [ -156.001870, 20.698064 ], [ -156.014150, 20.685681 ], [ -156.020044, 20.686857 ], [ -156.030702, 20.682452 ], [ -156.040341, 20.672719 ], [ -156.043786, 20.664902 ], [ -156.053385, 20.654320 ], [ -156.059753, 20.652044 ], [ -156.081472, 20.654387 ], [ -156.089365, 20.648519 ], [ -156.120985, 20.633685 ], [ -156.129898, 20.627523 ], [ -156.142665, 20.623605 ], [ -156.144588, 20.624032 ], [ -156.148085, 20.629067 ], [ -156.156772, 20.629639 ], [ -156.169732, 20.627358 ], [ -156.173393, 20.624100 ], [ -156.184556, 20.629719 ], [ -156.192938, 20.631769 ], [ -156.210258, 20.628518 ], [ -156.225338, 20.622940 ], [ -156.236145, 20.615950 ], [ -156.265921, 20.601629 ], [ -156.284391, 20.596488 ], [ -156.288037, 20.592030 ], [ -156.293454, 20.588783 ], [ -156.302692, 20.586199 ], [ -156.322944, 20.588273 ], [ -156.351716, 20.586970 ], [ -156.359634, 20.581977 ], [ -156.370725, 20.578760 ], [ -156.377633, 20.578427 ], [ -156.415313, 20.586099 ], [ -156.417523, 20.589728 ], [ -156.415746, 20.594044 ], [ -156.417799, 20.598682 ], [ -156.423141, 20.602079 ], [ -156.427708, 20.598873 ], [ -156.431872, 20.598143 ], [ -156.438385, 20.601337 ], [ -156.444242, 20.607941 ], [ -156.442884, 20.613842 ], [ -156.450651, 20.642212 ], [ -156.445894, 20.649270 ], [ -156.443673, 20.656018 ], [ -156.448656, 20.704739 ], [ -156.451038, 20.725469 ], [ -156.452895, 20.731287 ], [ -156.458438, 20.736676 ], [ -156.462242, 20.753952 ], [ -156.462058, 20.772571 ], [ -156.464043, 20.781667 ], [ -156.473562, 20.790756 ], [ -156.489496, 20.798339 ], [ -156.501688, 20.799933 ], [ -156.506026, 20.799463 ], [ -156.515994, 20.794234 ], [ -156.525215, 20.780821 ], [ -156.537752, 20.778408 ], [ -156.631794, 20.821240 ], [ -156.678634, 20.870541 ], [ -156.688969, 20.888673 ], [ -156.687804, 20.890720 ], [ -156.688132, 20.906325 ], [ -156.691334, 20.912440 ], [ -156.697418, 20.916368 ], [ -156.699890, 20.920629 ], [ -156.694110, 20.952708 ], [ -156.680905, 20.980262 ], [ -156.665514, 21.007054 ], [ -156.652419, 21.008994 ], [ -156.645966, 21.014416 ], [ -156.642592, 21.019936 ], [ -156.644167, 21.022312 ], [ -156.642809, 21.027583 ], [ -156.619581, 21.027793 ], [ -156.612012, 21.024770 ] ] ], [ [ [ -157.010001, 20.929757 ], [ -156.989813, 20.932127 ], [ -156.971604, 20.926254 ], [ -156.937529, 20.925274 ], [ -156.918450, 20.922546 ], [ -156.897169, 20.915395 ], [ -156.837047, 20.863575 ], [ -156.825237, 20.850731 ], [ -156.809576, 20.826036 ], [ -156.808469, 20.820396 ], [ -156.809463, 20.809169 ], [ -156.817427, 20.794606 ], [ -156.838321, 20.764575 ], [ -156.846413, 20.760201 ], [ -156.851481, 20.760069 ], [ -156.869753, 20.754701 ], [ -156.890295, 20.744855 ], [ -156.909081, 20.739533 ], [ -156.949009, 20.738997 ], [ -156.967890, 20.735080 ], [ -156.984747, 20.756677 ], [ -156.994001, 20.786671 ], [ -156.988933, 20.815496 ], [ -156.991834, 20.826603 ], [ -157.006243, 20.849603 ], [ -157.010911, 20.854476 ], [ -157.054552, 20.877219 ], [ -157.059663, 20.884634 ], [ -157.061128, 20.890635 ], [ -157.062511, 20.904385 ], [ -157.059130, 20.913407 ], [ -157.035789, 20.927078 ], [ -157.025626, 20.929528 ], [ -157.010001, 20.929757 ] ] ], [ [ [ -158.044485, 21.306011 ], [ -158.088300, 21.298800 ], [ -158.103300, 21.297900 ], [ -158.112700, 21.301900 ], [ -158.121100, 21.316900 ], [ -158.122500, 21.322400 ], [ -158.111949, 21.326622 ], [ -158.114196, 21.331123 ], [ -158.119427, 21.334594 ], [ -158.125459, 21.330264 ], [ -158.133240, 21.359207 ], [ -158.140300, 21.373800 ], [ -158.149719, 21.385208 ], [ -158.161743, 21.396282 ], [ -158.179200, 21.404300 ], [ -158.181274, 21.409626 ], [ -158.181000, 21.420868 ], [ -158.182648, 21.430073 ], [ -158.192352, 21.448040 ], [ -158.205383, 21.459793 ], [ -158.219446, 21.469780 ], [ -158.233000, 21.487600 ], [ -158.231171, 21.523857 ], [ -158.231750, 21.533035 ], [ -158.234314, 21.540058 ], [ -158.250671, 21.557373 ], [ -158.279510, 21.575794 ], [ -158.277679, 21.578789 ], [ -158.254425, 21.582684 ], [ -158.190704, 21.585892 ], [ -158.170000, 21.582300 ], [ -158.125610, 21.586739 ], [ -158.106720, 21.596577 ], [ -158.106689, 21.603024 ], [ -158.109500, 21.605700 ], [ -158.108185, 21.607487 ], [ -158.079895, 21.628101 ], [ -158.066800, 21.643700 ], [ -158.066711, 21.652340 ], [ -158.063900, 21.658400 ], [ -158.037200, 21.684300 ], [ -158.018127, 21.699955 ], [ -157.992300, 21.708000 ], [ -157.987030, 21.712494 ], [ -157.968628, 21.712704 ], [ -157.947174, 21.689568 ], [ -157.939000, 21.669000 ], [ -157.930100, 21.655200 ], [ -157.924591, 21.651183 ], [ -157.922800, 21.636100 ], [ -157.923800, 21.629300 ], [ -157.910797, 21.611183 ], [ -157.900574, 21.605885 ], [ -157.877350, 21.575277 ], [ -157.878601, 21.560181 ], [ -157.872528, 21.557568 ], [ -157.866900, 21.563700 ], [ -157.856140, 21.560661 ], [ -157.852570, 21.557514 ], [ -157.836945, 21.529945 ], [ -157.837372, 21.512085 ], [ -157.849579, 21.509598 ], [ -157.852625, 21.499971 ], [ -157.845490, 21.466747 ], [ -157.840990, 21.459483 ], [ -157.824890, 21.455379 ], [ -157.816300, 21.450200 ], [ -157.813900, 21.440300 ], [ -157.805900, 21.430100 ], [ -157.786513, 21.415633 ], [ -157.779846, 21.417309 ], [ -157.774455, 21.421352 ], [ -157.772209, 21.431236 ], [ -157.774905, 21.453698 ], [ -157.772209, 21.457741 ], [ -157.764572, 21.461335 ], [ -157.754239, 21.461335 ], [ -157.737617, 21.459089 ], [ -157.731777, 21.455944 ], [ -157.731328, 21.444713 ], [ -157.735820, 21.438424 ], [ -157.740762, 21.424048 ], [ -157.741211, 21.414614 ], [ -157.738600, 21.404300 ], [ -157.730191, 21.401871 ], [ -157.728221, 21.402104 ], [ -157.726421, 21.402845 ], [ -157.724324, 21.403311 ], [ -157.723794, 21.403290 ], [ -157.723286, 21.403227 ], [ -157.722735, 21.403121 ], [ -157.722544, 21.403036 ], [ -157.721845, 21.401596 ], [ -157.721083, 21.399541 ], [ -157.718900, 21.396100 ], [ -157.708900, 21.383300 ], [ -157.708700, 21.379300 ], [ -157.712600, 21.368900 ], [ -157.710600, 21.358500 ], [ -157.708800, 21.353400 ], [ -157.697100, 21.336400 ], [ -157.693800, 21.332900 ], [ -157.661900, 21.313100 ], [ -157.651800, 21.313900 ], [ -157.652629, 21.308709 ], [ -157.653700, 21.302000 ], [ -157.694600, 21.273900 ], [ -157.694400, 21.266500 ], [ -157.700100, 21.264000 ], [ -157.709700, 21.262100 ], [ -157.713900, 21.263800 ], [ -157.714200, 21.266500 ], [ -157.711400, 21.272000 ], [ -157.712200, 21.281400 ], [ -157.714300, 21.284500 ], [ -157.721300, 21.286900 ], [ -157.757200, 21.278000 ], [ -157.765000, 21.278900 ], [ -157.778200, 21.273500 ], [ -157.793100, 21.260400 ], [ -157.809600, 21.257700 ], [ -157.821100, 21.260600 ], [ -157.824100, 21.264600 ], [ -157.825300, 21.271400 ], [ -157.831900, 21.279500 ], [ -157.845700, 21.290000 ], [ -157.890000, 21.306500 ], [ -157.894518, 21.319632 ], [ -157.898969, 21.327391 ], [ -157.904820, 21.329172 ], [ -157.918939, 21.318615 ], [ -157.917921, 21.313781 ], [ -157.913469, 21.310983 ], [ -157.910925, 21.305768 ], [ -157.952263, 21.306531 ], [ -157.950736, 21.312509 ], [ -157.951881, 21.318742 ], [ -157.967971, 21.327986 ], [ -157.973334, 21.327426 ], [ -157.989424, 21.317984 ], [ -158.024500, 21.309300 ], [ -158.044485, 21.306011 ] ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US17", "STATE": 8, "name": "Illinois", "LSAD": "", "CENSUSAREA": 55518.930000 }, "geometry": { "type": "Polygon", "coordinates": [ [ [ -89.366031, 42.500274 ], [ -89.361561, 42.500012 ], [ -89.290896, 42.498853 ], [ -89.250759, 42.497994 ], [ -89.246972, 42.498130 ], [ -89.228279, 42.498047 ], [ -89.226270, 42.497957 ], [ -89.166728, 42.497256 ], [ -89.164905, 42.497347 ], [ -89.125111, 42.496957 ], [ -89.120365, 42.496992 ], [ -89.116949, 42.496910 ], [ -89.099012, 42.496499 ], [ -89.071141, 42.496208 ], [ -89.042898, 42.496255 ], [ -89.013804, 42.496097 ], [ -89.013667, 42.496087 ], [ -88.992977, 42.496026 ], [ -88.992659, 42.496025 ], [ -88.943264, 42.495114 ], [ -88.940391, 42.495046 ], [ -88.940388, 42.495046 ], [ -88.776496, 42.494020 ], [ -88.707380, 42.493587 ], [ -88.707378, 42.493587 ], [ -88.506912, 42.494883 ], [ -88.470597, 42.494672 ], [ -88.461397, 42.494618 ], [ -88.417396, 42.494618 ], [ -88.304692, 42.494773 ], [ -88.271691, 42.494818 ], [ -88.216900, 42.495923 ], [ -88.200172, 42.496016 ], [ -88.199521, 42.496013 ], [ -88.049782, 42.495319 ], [ -87.990180, 42.494519 ], [ -87.971279, 42.494019 ], [ -87.900242, 42.493020 ], [ -87.843594, 42.492307 ], [ -87.815872, 42.491920 ], [ -87.800561, 42.491920 ], [ -87.800477, 42.491920 ], [ -87.800317, 42.490578 ], [ -87.798971, 42.479278 ], [ -87.798230, 42.473054 ], [ -87.798071, 42.471721 ], [ -87.800752, 42.445867 ], [ -87.803370, 42.420621 ], [ -87.803529, 42.417759 ], [ -87.803750, 42.413793 ], [ -87.805370, 42.384721 ], [ -87.806130, 42.383357 ], [ -87.815570, 42.366416 ], [ -87.816570, 42.364621 ], [ -87.820858, 42.361584 ], [ -87.820871, 42.361544 ], [ -87.826717, 42.343497 ], [ -87.830646, 42.331368 ], [ -87.830986, 42.330317 ], [ -87.831221, 42.328530 ], [ -87.834769, 42.301522 ], [ -87.833468, 42.294892 ], [ -87.832738, 42.291173 ], [ -87.832530, 42.290109 ], [ -87.831286, 42.283772 ], [ -87.828569, 42.269922 ], [ -87.828034, 42.268673 ], [ -87.827720, 42.267937 ], [ -87.826944, 42.266125 ], [ -87.825313, 42.262313 ], [ -87.812461, 42.232278 ], [ -87.812422, 42.232185 ], [ -87.812315, 42.231935 ], [ -87.812267, 42.231823 ], [ -87.808395, 42.224271 ], [ -87.803873, 42.215449 ], [ -87.800066, 42.208024 ], [ -87.798589, 42.206007 ], [ -87.798300, 42.205611 ], [ -87.797497, 42.204514 ], [ -87.797444, 42.204442 ], [ -87.796937, 42.203748 ], [ -87.796779, 42.203533 ], [ -87.788313, 42.191966 ], [ -87.787241, 42.190501 ], [ -87.775295, 42.174179 ], [ -87.759327, 42.152362 ], [ -87.756390, 42.148350 ], [ -87.755826, 42.147579 ], [ -87.754767, 42.146132 ], [ -87.754444, 42.145691 ], [ -87.754358, 42.145573 ], [ -87.750396, 42.140160 ], [ -87.748486, 42.137550 ], [ -87.746421, 42.134729 ], [ -87.741662, 42.128227 ], [ -87.741318, 42.127812 ], [ -87.740787, 42.127172 ], [ -87.740718, 42.127089 ], [ -87.739735, 42.125903 ], [ -87.739529, 42.125655 ], [ -87.733929, 42.118903 ], [ -87.730463, 42.114723 ], [ -87.729387, 42.113426 ], [ -87.729378, 42.113414 ], [ -87.728335, 42.112157 ], [ -87.728191, 42.111984 ], [ -87.727248, 42.110847 ], [ -87.727005, 42.110554 ], [ -87.725196, 42.108373 ], [ -87.724661, 42.107727 ], [ -87.724603, 42.107674 ], [ -87.723723, 42.106879 ], [ -87.722306, 42.105596 ], [ -87.722220, 42.105518 ], [ -87.721500, 42.104866 ], [ -87.720407, 42.103878 ], [ -87.720303, 42.103783 ], [ -87.718065, 42.101758 ], [ -87.717504, 42.101250 ], [ -87.717276, 42.101044 ], [ -87.717169, 42.100947 ], [ -87.712206, 42.096455 ], [ -87.710960, 42.095328 ], [ -87.706415, 42.092213 ], [ -87.704594, 42.090966 ], [ -87.703882, 42.090478 ], [ -87.702370, 42.089442 ], [ -87.682359, 42.075729 ], [ -87.682179, 42.075441 ], [ -87.680750, 42.073160 ], [ -87.679843, 42.071713 ], [ -87.671462, 42.058334 ], [ -87.670512, 42.052980 ], [ -87.670699, 42.052305 ], [ -87.671119, 42.050781 ], [ -87.671184, 42.050548 ], [ -87.671894, 42.047972 ], [ -87.671094, 42.042802 ], [ -87.668982, 42.029142 ], [ -87.630953, 41.933132 ], [ -87.630870, 41.932784 ], [ -87.627038, 41.916738 ], [ -87.624763, 41.907209 ], [ -87.624134, 41.904574 ], [ -87.624052, 41.904232 ], [ -87.622944, 41.902020 ], [ -87.619852, 41.901392 ], [ -87.617433, 41.898032 ], [ -87.614163, 41.893418 ], [ -87.612291, 41.893335 ], [ -87.611659, 41.892216 ], [ -87.611659, 41.890708 ], [ -87.612680, 41.889248 ], [ -87.614188, 41.888421 ], [ -87.613556, 41.884480 ], [ -87.613654, 41.884412 ], [ -87.615734, 41.882958 ], [ -87.616537, 41.882396 ], [ -87.616251, 41.868933 ], [ -87.609450, 41.845233 ], [ -87.600549, 41.826833 ], [ -87.587123, 41.811422 ], [ -87.587054, 41.811342 ], [ -87.580948, 41.804334 ], [ -87.580920, 41.804225 ], [ -87.580550, 41.802750 ], [ -87.576347, 41.786034 ], [ -87.560646, 41.766034 ], [ -87.542845, 41.752135 ], [ -87.530745, 41.748235 ], [ -87.524141, 41.723990 ], [ -87.524044, 41.708335 ], [ -87.524944, 41.702635 ], [ -87.524844, 41.691635 ], [ -87.524642, 41.634935 ], [ -87.524742, 41.632435 ], [ -87.524642, 41.622535 ], [ -87.524641, 41.563335 ], [ -87.525669, 41.470283 ], [ -87.525671, 41.470115 ], [ -87.525623, 41.453619 ], [ -87.526768, 41.298177 ], [ -87.526768, 41.298052 ], [ -87.526570, 41.166097 ], [ -87.526567, 41.163865 ], [ -87.526660, 41.160090 ], [ -87.526719, 41.159448 ], [ -87.526693, 41.153958 ], [ -87.526696, 41.149222 ], [ -87.526700, 41.139658 ], [ -87.526711, 41.121485 ], [ -87.526520, 41.024837 ], [ -87.526346, 41.010583 ], [ -87.526307, 41.010355 ], [ -87.526305, 41.010346 ], [ -87.526084, 40.911914 ], [ -87.526437, 40.894209 ], [ -87.525962, 40.880618 ], [ -87.526113, 40.879703 ], [ -87.525783, 40.854357 ], [ -87.526129, 40.736950 ], [ -87.526129, 40.736885 ], [ -87.526292, 40.535409 ], [ -87.526352, 40.535111 ], [ -87.526376, 40.491574 ], [ -87.526379, 40.491237 ], [ -87.526502, 40.477158 ], [ -87.526511, 40.476879 ], [ -87.526549, 40.475659 ], [ -87.526809, 40.462170 ], [ -87.530054, 40.250671 ], [ -87.529992, 40.250036 ], [ -87.530828, 40.191812 ], [ -87.531133, 40.170030 ], [ -87.531438, 40.148123 ], [ -87.531439, 40.148027 ], [ -87.531759, 40.144273 ], [ -87.531561, 40.133005 ], [ -87.532308, 40.011587 ], [ -87.532308, 40.011492 ], [ -87.532287, 40.000037 ], [ -87.532331, 39.997776 ], [ -87.532542, 39.987462 ], [ -87.532683, 39.977691 ], [ -87.532790, 39.975010 ], [ -87.532776, 39.971077 ], [ -87.533227, 39.883127 ], [ -87.533227, 39.883000 ], [ -87.533142, 39.810947 ], [ -87.533056, 39.803922 ], [ -87.533058, 39.796243 ], [ -87.533066, 39.781743 ], [ -87.532703, 39.664868 ], [ -87.532444, 39.646102 ], [ -87.532365, 39.646126 ], [ -87.532196, 39.607306 ], [ -87.532008, 39.564013 ], [ -87.531939, 39.545853 ], [ -87.531965, 39.526937 ], [ -87.531692, 39.495516 ], [ -87.531627, 39.491698 ], [ -87.531663, 39.477120 ], [ -87.531663, 39.477110 ], [ -87.531624, 39.469378 ], [ -87.531608, 39.466225 ], [ -87.531489, 39.449474 ], [ -87.531355, 39.437732 ], [ -87.531355, 39.436656 ], [ -87.531646, 39.347888 ], [ -87.537271, 39.352089 ], [ -87.544013, 39.352907 ], [ -87.584852, 39.337329 ], [ -87.589084, 39.333831 ], [ -87.604043, 39.313526 ], [ -87.610050, 39.282232 ], [ -87.605543, 39.261122 ], [ -87.604076, 39.259459 ], [ -87.593486, 39.247452 ], [ -87.587507, 39.249282 ], [ -87.605173, 39.185897 ], [ -87.628727, 39.157427 ], [ -87.642174, 39.157097 ], [ -87.651719, 39.150602 ], [ -87.658746, 39.135997 ], [ -87.614881, 39.102655 ], [ -87.572588, 39.057286 ], [ -87.512187, 38.954417 ], [ -87.518826, 38.923205 ], [ -87.527910, 38.908209 ], [ -87.528108, 38.908027 ], [ -87.540804, 38.896385 ], [ -87.553384, 38.863344 ], [ -87.550515, 38.859560 ], [ -87.537248, 38.853592 ], [ -87.532064, 38.852503 ], [ -87.528194, 38.851691 ], [ -87.525893, 38.848795 ], [ -87.495211, 38.783060 ], [ -87.498515, 38.758983 ], [ -87.519609, 38.697198 ], [ -87.531231, 38.684036 ], [ -87.540052, 38.679143 ], [ -87.579397, 38.672475 ], [ -87.593678, 38.667402 ], [ -87.600180, 38.662462 ], [ -87.620120, 38.639489 ], [ -87.627345, 38.607237 ], [ -87.651529, 38.568166 ], [ -87.670071, 38.545237 ], [ -87.669232, 38.541742 ], [ -87.656144, 38.521668 ], [ -87.740001, 38.415698 ], [ -87.750028, 38.403027 ], [ -87.863032, 38.280172 ], [ -87.923958, 38.258409 ], [ -87.951715, 38.239632 ], [ -87.955344, 38.230008 ], [ -87.961103, 38.214733 ], [ -87.959062, 38.203712 ], [ -87.951307, 38.193099 ], [ -87.940694, 38.181261 ], [ -87.928856, 38.176771 ], [ -87.915666, 38.173322 ], [ -87.910792, 38.167666 ], [ -87.911034, 38.162194 ], [ -87.927830, 38.141545 ], [ -87.942176, 38.131759 ], [ -87.974272, 38.121981 ], [ -88.013118, 38.103527 ], [ -88.042132, 38.046345 ], [ -88.041532, 38.037345 ], [ -88.012574, 37.977062 ], [ -88.013451, 37.893951 ], [ -88.017073, 37.889222 ], [ -88.021117, 37.888057 ], [ -88.055373, 37.891238 ], [ -88.071449, 37.895813 ], [ -88.049453, 37.845187 ], [ -88.027789, 37.828298 ], [ -88.028030, 37.799224 ], [ -88.039000, 37.775454 ], [ -88.045008, 37.762436 ], [ -88.050969, 37.752599 ], [ -88.059588, 37.742608 ], [ -88.072538, 37.733286 ], [ -88.122412, 37.709685 ], [ -88.151646, 37.675098 ], [ -88.158207, 37.664542 ], [ -88.160187, 37.657592 ], [ -88.156827, 37.632801 ], [ -88.139973, 37.586451 ], [ -88.133416, 37.574277 ], [ -88.133393, 37.574235 ], [ -88.133306, 37.574191 ], [ -88.133235, 37.574154 ], [ -88.121517, 37.568166 ], [ -88.072242, 37.528826 ], [ -88.063311, 37.515755 ], [ -88.061311, 37.505332 ], [ -88.061292, 37.505232 ], [ -88.062562, 37.489385 ], [ -88.083395, 37.473683 ], [ -88.255193, 37.456748 ], [ -88.281667, 37.452596 ], [ -88.312585, 37.440591 ], [ -88.330622, 37.429316 ], [ -88.358436, 37.404860 ], [ -88.408808, 37.425216 ], [ -88.414895, 37.423461 ], [ -88.439333, 37.416416 ], [ -88.456000, 37.408482 ], [ -88.470224, 37.396255 ], [ -88.476592, 37.386875 ], [ -88.514661, 37.290948 ], [ -88.515939, 37.284043 ], [ -88.509328, 37.262130 ], [ -88.471753, 37.220155 ], [ -88.458763, 37.213536 ], [ -88.447764, 37.203527 ], [ -88.424403, 37.152428 ], [ -88.444605, 37.098601 ], [ -88.458948, 37.073796 ], [ -88.482856, 37.067114 ], [ -88.490297, 37.066669 ], [ -88.514356, 37.065231 ], [ -88.531576, 37.067192 ], [ -88.545403, 37.070003 ], [ -88.560032, 37.076010 ], [ -88.564152, 37.078440 ], [ -88.576718, 37.085852 ], [ -88.589207, 37.099655 ], [ -88.625889, 37.119458 ], [ -88.809206, 37.189235 ], [ -88.916934, 37.224291 ], [ -88.928021, 37.226281 ], [ -88.942111, 37.228811 ], [ -88.933385, 37.225005 ], [ -88.933399, 37.225007 ], [ -88.966831, 37.229891 ], [ -88.983260, 37.228685 ], [ -89.000968, 37.224401 ], [ -89.041263, 37.202881 ], [ -89.086526, 37.165602 ], [ -89.168087, 37.074218 ], [ -89.171881, 37.068184 ], [ -89.175725, 37.062069 ], [ -89.181369, 37.046305 ], [ -89.182509, 37.037275 ], [ -89.178975, 37.020928 ], [ -89.173595, 37.011409 ], [ -89.166447, 37.003337 ], [ -89.132685, 36.982200 ], [ -89.170008, 36.970298 ], [ -89.185491, 36.973518 ], [ -89.207013, 36.982437 ], [ -89.226247, 36.985287 ], [ -89.245481, 36.983150 ], [ -89.261154, 36.982437 ], [ -89.271127, 36.985287 ], [ -89.278628, 36.988670 ], [ -89.292130, 36.992189 ], [ -89.322733, 37.009033 ], [ -89.378277, 37.039605 ], [ -89.383937, 37.046441 ], [ -89.385434, 37.055130 ], [ -89.414471, 37.125050 ], [ -89.467631, 37.218200 ], [ -89.491222, 37.248629 ], [ -89.517032, 37.281920 ], [ -89.518393, 37.289354 ], [ -89.511842, 37.310825 ], [ -89.489005, 37.333368 ], [ -89.484598, 37.334832 ], [ -89.474569, 37.338165 ], [ -89.447556, 37.340475 ], [ -89.436040, 37.344441 ], [ -89.432836, 37.347056 ], [ -89.428185, 37.356158 ], [ -89.421054, 37.387668 ], [ -89.425940, 37.407471 ], [ -89.439769, 37.437200 ], [ -89.450969, 37.450069 ], [ -89.475525, 37.471388 ], [ -89.492051, 37.494008 ], [ -89.517051, 37.537278 ], [ -89.521697, 37.557325 ], [ -89.521523, 37.566208 ], [ -89.521407, 37.572143 ], [ -89.521274, 37.578971 ], [ -89.518007, 37.583962 ], [ -89.511936, 37.584564 ], [ -89.506563, 37.625050 ], [ -89.515436, 37.671370 ], [ -89.671255, 37.801144 ], [ -89.674304, 37.803179 ], [ -89.739873, 37.846930 ], [ -89.844786, 37.905572 ], [ -89.851048, 37.903980 ], [ -89.862949, 37.896906 ], [ -89.881475, 37.879591 ], [ -89.901832, 37.869822 ], [ -89.923185, 37.870672 ], [ -89.937383, 37.874693 ], [ -89.938191, 37.875111 ], [ -89.950594, 37.881526 ], [ -89.973642, 37.917661 ], [ -89.974918, 37.926719 ], [ -89.997103, 37.963225 ], [ -90.072283, 38.017001 ], [ -90.126532, 38.041666 ], [ -90.203847, 38.088753 ], [ -90.243116, 38.112669 ], [ -90.254112, 38.121990 ], [ -90.334258, 38.189932 ], [ -90.353902, 38.213855 ], [ -90.363926, 38.236355 ], [ -90.373929, 38.281853 ], [ -90.372519, 38.323354 ], [ -90.370819, 38.333554 ], [ -90.350918, 38.375053 ], [ -90.346118, 38.381853 ], [ -90.340297, 38.386998 ], [ -90.295316, 38.426753 ], [ -90.285215, 38.443453 ], [ -90.279215, 38.472453 ], [ -90.263064, 38.520220 ], [ -90.260314, 38.528352 ], [ -90.257773, 38.532008 ], [ -90.248913, 38.544752 ], [ -90.224512, 38.574651 ], [ -90.202511, 38.588651 ], [ -90.196011, 38.594451 ], [ -90.184510, 38.611551 ], [ -90.182625, 38.617989 ], [ -90.178010, 38.633750 ], [ -90.177710, 38.642750 ], [ -90.181110, 38.659550 ], [ -90.181399, 38.660378 ], [ -90.186410, 38.674750 ], [ -90.195210, 38.687550 ], [ -90.202210, 38.693450 ], [ -90.209210, 38.702750 ], [ -90.212010, 38.711750 ], [ -90.209910, 38.726050 ], [ -90.171309, 38.766549 ], [ -90.165082, 38.770618 ], [ -90.123107, 38.798048 ], [ -90.117707, 38.805748 ], [ -90.114707, 38.815048 ], [ -90.109107, 38.837448 ], [ -90.109407, 38.843548 ], [ -90.113327, 38.849306 ], [ -90.207035, 38.898954 ], [ -90.225850, 38.908923 ], [ -90.250248, 38.919344 ], [ -90.275932, 38.926453 ], [ -90.385751, 38.956848 ], [ -90.406367, 38.962554 ], [ -90.450792, 38.967764 ], [ -90.450809, 38.967758 ], [ -90.467784, 38.961809 ], [ -90.472122, 38.958838 ], [ -90.482419, 38.944460 ], [ -90.482725, 38.934712 ], [ -90.486974, 38.925982 ], [ -90.507451, 38.902767 ], [ -90.544030, 38.875050 ], [ -90.555693, 38.870785 ], [ -90.566557, 38.868847 ], [ -90.583388, 38.869030 ], [ -90.625122, 38.888654 ], [ -90.657254, 38.920270 ], [ -90.663372, 38.928042 ], [ -90.665870, 38.934195 ], [ -90.711580, 39.046798 ], [ -90.713629, 39.053977 ], [ -90.712541, 39.057064 ], [ -90.682744, 39.088348 ], [ -90.681086, 39.100590 ], [ -90.718996, 39.224973 ], [ -90.726981, 39.251173 ], [ -90.729960, 39.255894 ], [ -90.799346, 39.313087 ], [ -90.842175, 39.341932 ], [ -90.882706, 39.362254 ], [ -90.939983, 39.393555 ], [ -90.993789, 39.422959 ], [ -91.042351, 39.452062 ], [ -91.158606, 39.553048 ], [ -91.168419, 39.564928 ], [ -91.178012, 39.598196 ], [ -91.229317, 39.620853 ], [ -91.313162, 39.684907 ], [ -91.349039, 39.712316 ], [ -91.367753, 39.729029 ], [ -91.370009, 39.732524 ], [ -91.369953, 39.745042 ], [ -91.367962, 39.759124 ], [ -91.365396, 39.777266 ], [ -91.432919, 39.840554 ], [ -91.446385, 39.870394 ], [ -91.455887, 39.945538 ], [ -91.460287, 39.980333 ], [ -91.494865, 40.037421 ], [ -91.510322, 40.127994 ], [ -91.512974, 40.181062 ], [ -91.510332, 40.201142 ], [ -91.505968, 40.234305 ], [ -91.501435, 40.248874 ], [ -91.489868, 40.286048 ], [ -91.462140, 40.342414 ], [ -91.444833, 40.363170 ], [ -91.419422, 40.378264 ], [ -91.388360, 40.384929 ], [ -91.375746, 40.391879 ], [ -91.372554, 40.401200 ], [ -91.363910, 40.490122 ], [ -91.364211, 40.500043 ], [ -91.369059, 40.512532 ], [ -91.384531, 40.530948 ], [ -91.404125, 40.539127 ], [ -91.406851, 40.547557 ], [ -91.405241, 40.554641 ], [ -91.359873, 40.601805 ], [ -91.348733, 40.609695 ], [ -91.339719, 40.613488 ], [ -91.306524, 40.626231 ], [ -91.253074, 40.637962 ], [ -91.218437, 40.638437 ], [ -91.197906, 40.636107 ], [ -91.186980, 40.637297 ], [ -91.185415, 40.638052 ], [ -91.138055, 40.660893 ], [ -91.122421, 40.670675 ], [ -91.112258, 40.696218 ], [ -91.111940, 40.697018 ], [ -91.094728, 40.797833 ], [ -91.097031, 40.802471 ], [ -91.097553, 40.808433 ], [ -91.092993, 40.821079 ], [ -91.009536, 40.900565 ], [ -90.998500, 40.908120 ], [ -90.968995, 40.919127 ], [ -90.962916, 40.924957 ], [ -90.952233, 40.954047 ], [ -90.942253, 41.034702 ], [ -90.945549, 41.061730 ], [ -90.948523, 41.070248 ], [ -90.949383, 41.072710 ], [ -90.949383, 41.072711 ], [ -90.946627, 41.096632 ], [ -90.989663, 41.155716 ], [ -90.997906, 41.162564 ], [ -91.005503, 41.165622 ], [ -91.019036, 41.164910 ], [ -91.049808, 41.178033 ], [ -91.113648, 41.241401 ], [ -91.114186, 41.250029 ], [ -91.079657, 41.333727 ], [ -91.078682, 41.336089 ], [ -91.047819, 41.410900 ], [ -91.039872, 41.418523 ], [ -91.027787, 41.423603 ], [ -90.989976, 41.431962 ], [ -90.847458, 41.455019 ], [ -90.786282, 41.452888 ], [ -90.771672, 41.450761 ], [ -90.737537, 41.450127 ], [ -90.655839, 41.462132 ], [ -90.605937, 41.494232 ], [ -90.499475, 41.518055 ], [ -90.474332, 41.519733 ], [ -90.461432, 41.523533 ], [ -90.397930, 41.572233 ], [ -90.341650, 41.621484 ], [ -90.343162, 41.648141 ], [ -90.334525, 41.679559 ], [ -90.317041, 41.729104 ], [ -90.315220, 41.734264 ], [ -90.309826, 41.743321 ], [ -90.302782, 41.750031 ], [ -90.278633, 41.767358 ], [ -90.242747, 41.783767 ], [ -90.222263, 41.793133 ], [ -90.208440, 41.797176 ], [ -90.187969, 41.803163 ], [ -90.181973, 41.807070 ], [ -90.152104, 41.928947 ], [ -90.151600, 41.931002 ], [ -90.140613, 41.995999 ], [ -90.141167, 42.008931 ], [ -90.150916, 42.029440 ], [ -90.154221, 42.033073 ], [ -90.164537, 42.045007 ], [ -90.166495, 42.054543 ], [ -90.168358, 42.075779 ], [ -90.163405, 42.087613 ], [ -90.161119, 42.104404 ], [ -90.162225, 42.114880 ], [ -90.167533, 42.122475 ], [ -90.211328, 42.154010 ], [ -90.234919, 42.165431 ], [ -90.306531, 42.190439 ], [ -90.316269, 42.193600 ], [ -90.349162, 42.204277 ], [ -90.356964, 42.205445 ], [ -90.375129, 42.214811 ], [ -90.391108, 42.225473 ], [ -90.419326, 42.254467 ], [ -90.430884, 42.278230 ], [ -90.430735, 42.284211 ], [ -90.424326, 42.293326 ], [ -90.416200, 42.321314 ], [ -90.416535, 42.325109 ], [ -90.419027, 42.328505 ], [ -90.474834, 42.381473 ], [ -90.477279, 42.383794 ], [ -90.559451, 42.430695 ], [ -90.624328, 42.458904 ], [ -90.646727, 42.471904 ], [ -90.654027, 42.478503 ], [ -90.656327, 42.483603 ], [ -90.656527, 42.489203 ], [ -90.655927, 42.491703 ], [ -90.640927, 42.508302 ], [ -90.617731, 42.508077 ], [ -90.614589, 42.508053 ], [ -90.565441, 42.507600 ], [ -90.555862, 42.507509 ], [ -90.551165, 42.507691 ], [ -90.544799, 42.507713 ], [ -90.544347, 42.507707 ], [ -90.532254, 42.507573 ], [ -90.491716, 42.507624 ], [ -90.479446, 42.507416 ], [ -90.474955, 42.507484 ], [ -90.437011, 42.507147 ], [ -90.426378, 42.507059 ], [ -90.405927, 42.506891 ], [ -90.370673, 42.507111 ], [ -90.367874, 42.507114 ], [ -90.362652, 42.507048 ], [ -90.303823, 42.507469 ], [ -90.272864, 42.507531 ], [ -90.269335, 42.507726 ], [ -90.267143, 42.507642 ], [ -90.253121, 42.507340 ], [ -90.250622, 42.507521 ], [ -90.223190, 42.507765 ], [ -90.206073, 42.507747 ], [ -90.181572, 42.508068 ], [ -90.164363, 42.508272 ], [ -90.142922, 42.508151 ], [ -90.095004, 42.507885 ], [ -90.093026, 42.508160 ], [ -90.018665, 42.507288 ], [ -90.017028, 42.507127 ], [ -89.999314, 42.506914 ], [ -89.997213, 42.506755 ], [ -89.985645, 42.506431 ], [ -89.985072, 42.506464 ], [ -89.926484, 42.505787 ], [ -89.926374, 42.505788 ], [ -89.926224, 42.505788 ], [ -89.837587, 42.505543 ], [ -89.801897, 42.505444 ], [ -89.799704, 42.505421 ], [ -89.793957, 42.505466 ], [ -89.780302, 42.505349 ], [ -89.769643, 42.505322 ], [ -89.742395, 42.505382 ], [ -89.693487, 42.505099 ], [ -89.690088, 42.505191 ], [ -89.667596, 42.504960 ], [ -89.650324, 42.504613 ], [ -89.644176, 42.504520 ], [ -89.613410, 42.503942 ], [ -89.603523, 42.503557 ], [ -89.600001, 42.503672 ], [ -89.594779, 42.503468 ], [ -89.564407, 42.502628 ], [ -89.522542, 42.501889 ], [ -89.493216, 42.501514 ], [ -89.492612, 42.501514 ], [ -89.484300, 42.501426 ], [ -89.425162, 42.500726 ], [ -89.423926, 42.500818 ], [ -89.422567, 42.500680 ], [ -89.420991, 42.500589 ], [ -89.401432, 42.500433 ], [ -89.401416, 42.500433 ], [ -89.366031, 42.500274 ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US18", "STATE": 9, "name": "Indiana", "LSAD": "", "CENSUSAREA": 35826.109000 }, "geometry": { "type": "Polygon", "coordinates": [ [ [ -84.804119, 40.352757 ], [ -84.803917, 40.310115 ], [ -84.803918, 40.310094 ], [ -84.804098, 40.302498 ], [ -84.805627, 40.223659 ], [ -84.806175, 40.197995 ], [ -84.806340, 40.192327 ], [ -84.806347, 40.192252 ], [ -84.806766, 40.180128 ], [ -84.808291, 40.129027 ], [ -84.808305, 40.127018 ], [ -84.808706, 40.107216 ], [ -84.809737, 40.048929 ], [ -84.810099, 40.034214 ], [ -84.810670, 40.005074 ], [ -84.812193, 39.927340 ], [ -84.812357, 39.921764 ], [ -84.812411, 39.916916 ], [ -84.812411, 39.916915 ], [ -84.812698, 39.891585 ], [ -84.812787, 39.890830 ], [ -84.813050, 39.872958 ], [ -84.813464, 39.853261 ], [ -84.813549, 39.850773 ], [ -84.813674, 39.843173 ], [ -84.813703, 39.843059 ], [ -84.813793, 39.826771 ], [ -84.813852, 39.824621 ], [ -84.814179, 39.814212 ], [ -84.814120, 39.811398 ], [ -84.814209, 39.799755 ], [ -84.814179, 39.786853 ], [ -84.814189, 39.785569 ], [ -84.814129, 39.726620 ], [ -84.814129, 39.726556 ], [ -84.814530, 39.680429 ], [ -84.814619, 39.669174 ], [ -84.814705, 39.628854 ], [ -84.815156, 39.568351 ], [ -84.815036, 39.567695 ], [ -84.814955, 39.567251 ], [ -84.814955, 39.566251 ], [ -84.815155, 39.548051 ], [ -84.815355, 39.521951 ], [ -84.815355, 39.521950 ], [ -84.815555, 39.511052 ], [ -84.815555, 39.510952 ], [ -84.815754, 39.477358 ], [ -84.815754, 39.477352 ], [ -84.817453, 39.391753 ], [ -84.819352, 39.309454 ], [ -84.819451, 39.305153 ], [ -84.819451, 39.305152 ], [ -84.819622, 39.271590 ], [ -84.819633, 39.261855 ], [ -84.819859, 39.251018 ], [ -84.819801, 39.247806 ], [ -84.819813, 39.244334 ], [ -84.819802, 39.157613 ], [ -84.819826, 39.156504 ], [ -84.819985, 39.149081 ], [ -84.820157, 39.105480 ], [ -84.831197, 39.101920 ], [ -84.888873, 39.066376 ], [ -84.897364, 39.057378 ], [ -84.897171, 39.052407 ], [ -84.889065, 39.040820 ], [ -84.878614, 39.030296 ], [ -84.849445, 39.000923 ], [ -84.813182, 38.930583 ], [ -84.789521, 38.884687 ], [ -84.785111, 38.879988 ], [ -84.785799, 38.869496 ], [ -84.791078, 38.855859 ], [ -84.813350, 38.798330 ], [ -84.844412, 38.787078 ], [ -84.944296, 38.775184 ], [ -84.973432, 38.778847 ], [ -84.984627, 38.779072 ], [ -84.995939, 38.776756 ], [ -85.024205, 38.763311 ], [ -85.100963, 38.726800 ], [ -85.106902, 38.720789 ], [ -85.138680, 38.699168 ], [ -85.156158, 38.692251 ], [ -85.172528, 38.688082 ], [ -85.189362, 38.687579 ], [ -85.201498, 38.691575 ], [ -85.213257, 38.695446 ], [ -85.226062, 38.705456 ], [ -85.246505, 38.731821 ], [ -85.258846, 38.737754 ], [ -85.275454, 38.741172 ], [ -85.289226, 38.742410 ], [ -85.333285, 38.740480 ], [ -85.410925, 38.737080 ], [ -85.422021, 38.734834 ], [ -85.434065, 38.729455 ], [ -85.452114, 38.709348 ], [ -85.456978, 38.689135 ], [ -85.439351, 38.610388 ], [ -85.427467, 38.586735 ], [ -85.415821, 38.563558 ], [ -85.415600, 38.546341 ], [ -85.417322, 38.540763 ], [ -85.423077, 38.531581 ], [ -85.432928, 38.524072 ], [ -85.433136, 38.523914 ], [ -85.462518, 38.512602 ], [ -85.607629, 38.439295 ], [ -85.620521, 38.423105 ], [ -85.632937, 38.395666 ], [ -85.638041, 38.380338 ], [ -85.638044, 38.380270 ], [ -85.638777, 38.361443 ], [ -85.653641, 38.327108 ], [ -85.675017, 38.301317 ], [ -85.683561, 38.295469 ], [ -85.744862, 38.267170 ], [ -85.750962, 38.267870 ], [ -85.761062, 38.272570 ], [ -85.766563, 38.277670 ], [ -85.765963, 38.280469 ], [ -85.773363, 38.286169 ], [ -85.780963, 38.288469 ], [ -85.791563, 38.288569 ], [ -85.791575, 38.288566 ], [ -85.816164, 38.282969 ], [ -85.823764, 38.280569 ], [ -85.829364, 38.276769 ], [ -85.897664, 38.184269 ], [ -85.899550, 38.180343 ], [ -85.908764, 38.161169 ], [ -85.909464, 38.140070 ], [ -85.905164, 38.111070 ], [ -85.904564, 38.100270 ], [ -85.906163, 38.086170 ], [ -85.911607, 38.066890 ], [ -85.922395, 38.028679 ], [ -85.930235, 38.018311 ], [ -85.941403, 38.009831 ], [ -85.947952, 38.007083 ], [ -85.951467, 38.005608 ], [ -85.998609, 37.997775 ], [ -86.029509, 37.992640 ], [ -86.172186, 38.009920 ], [ -86.178983, 38.011308 ], [ -86.220371, 38.027922 ], [ -86.266891, 38.057125 ], [ -86.273584, 38.067443 ], [ -86.278720, 38.089303 ], [ -86.278034, 38.102426 ], [ -86.271223, 38.130112 ], [ -86.283964, 38.143185 ], [ -86.309727, 38.144393 ], [ -86.314292, 38.142610 ], [ -86.323453, 38.139032 ], [ -86.326788, 38.134604 ], [ -86.332567, 38.130131 ], [ -86.398661, 38.106238 ], [ -86.426508, 38.081784 ], [ -86.430091, 38.078638 ], [ -86.432789, 38.067171 ], [ -86.438236, 38.060426 ], [ -86.452192, 38.050490 ], [ -86.466876, 38.046597 ], [ -86.490853, 38.045796 ], [ -86.490858, 38.045796 ], [ -86.511760, 38.044448 ], [ -86.517289, 38.042634 ], [ -86.521825, 38.038327 ], [ -86.524969, 38.027879 ], [ -86.525174, 37.968228 ], [ -86.604624, 37.858272 ], [ -86.634271, 37.843845 ], [ -86.648028, 37.841425 ], [ -86.655285, 37.842506 ], [ -86.655296, 37.842508 ], [ -86.660293, 37.865057 ], [ -86.709164, 37.897640 ], [ -86.718462, 37.893123 ], [ -86.723510, 37.892831 ], [ -86.731460, 37.894340 ], [ -86.740877, 37.902568 ], [ -86.750990, 37.912893 ], [ -86.770179, 37.940264 ], [ -86.787695, 37.971449 ], [ -86.794985, 37.988982 ], [ -86.814776, 37.998638 ], [ -86.815267, 37.998877 ], [ -86.823491, 37.998939 ], [ -86.855950, 37.987292 ], [ -86.884961, 37.964373 ], [ -86.902413, 37.946161 ], [ -86.919329, 37.936664 ], [ -86.978830, 37.930214 ], [ -86.978957, 37.930200 ], [ -87.010315, 37.919668 ], [ -87.033444, 37.906593 ], [ -87.042249, 37.898291 ], [ -87.046237, 37.889866 ], [ -87.043407, 37.879940 ], [ -87.043854, 37.870796 ], [ -87.057836, 37.827457 ], [ -87.067836, 37.806065 ], [ -87.077404, 37.796209 ], [ -87.090636, 37.787808 ], [ -87.111133, 37.782512 ], [ -87.119229, 37.782848 ], [ -87.128749, 37.785728 ], [ -87.132621, 37.791008 ], [ -87.202240, 37.843791 ], [ -87.262930, 37.872846 ], [ -87.269561, 37.877155 ], [ -87.302324, 37.898445 ], [ -87.380247, 37.935596 ], [ -87.402632, 37.942267 ], [ -87.418585, 37.944763 ], [ -87.436859, 37.944192 ], [ -87.450458, 37.941451 ], [ -87.451185, 37.941034 ], [ -87.511499, 37.906426 ], [ -87.550333, 37.924890 ], [ -87.559342, 37.931146 ], [ -87.572030, 37.947466 ], [ -87.574287, 37.954842 ], [ -87.573415, 37.962642 ], [ -87.574715, 37.967742 ], [ -87.581115, 37.973442 ], [ -87.585916, 37.975442 ], [ -87.592916, 37.975842 ], [ -87.601416, 37.972542 ], [ -87.628960, 37.926714 ], [ -87.626256, 37.916138 ], [ -87.620272, 37.906922 ], [ -87.597118, 37.892394 ], [ -87.591582, 37.887194 ], [ -87.588426, 37.868791 ], [ -87.588729, 37.860984 ], [ -87.591504, 37.856642 ], [ -87.606599, 37.838669 ], [ -87.615399, 37.831974 ], [ -87.645858, 37.825899 ], [ -87.670889, 37.828429 ], [ -87.679188, 37.836321 ], [ -87.681900, 37.846410 ], [ -87.681633, 37.855917 ], [ -87.662865, 37.885578 ], [ -87.666481, 37.895786 ], [ -87.675730, 37.901930 ], [ -87.684018, 37.903498 ], [ -87.700421, 37.900858 ], [ -87.762260, 37.890906 ], [ -87.783643, 37.877759 ], [ -87.790900, 37.875714 ], [ -87.830578, 37.876516 ], [ -87.841193, 37.882325 ], [ -87.857243, 37.900649 ], [ -87.865558, 37.915056 ], [ -87.872540, 37.920999 ], [ -87.883321, 37.926238 ], [ -87.898062, 37.927514 ], [ -87.904789, 37.924892 ], [ -87.927424, 37.902038 ], [ -87.936784, 37.892587 ], [ -87.940069, 37.887670 ], [ -87.940839, 37.883338 ], [ -87.940005, 37.875044 ], [ -87.936228, 37.867937 ], [ -87.927303, 37.858709 ], [ -87.914892, 37.849618 ], [ -87.910276, 37.843416 ], [ -87.907773, 37.837611 ], [ -87.903804, 37.817762 ], [ -87.906810, 37.807624 ], [ -87.943756, 37.776843 ], [ -87.970869, 37.783456 ], [ -87.976389, 37.788004 ], [ -88.004706, 37.800145 ], [ -88.017314, 37.801911 ], [ -88.028030, 37.799224 ], [ -88.027789, 37.828298 ], [ -88.049453, 37.845187 ], [ -88.071449, 37.895813 ], [ -88.055373, 37.891238 ], [ -88.021117, 37.888057 ], [ -88.017073, 37.889222 ], [ -88.013451, 37.893951 ], [ -88.012574, 37.977062 ], [ -88.041532, 38.037345 ], [ -88.042132, 38.046345 ], [ -88.013118, 38.103527 ], [ -87.974272, 38.121981 ], [ -87.942176, 38.131759 ], [ -87.927830, 38.141545 ], [ -87.911034, 38.162194 ], [ -87.910792, 38.167666 ], [ -87.915666, 38.173322 ], [ -87.928856, 38.176771 ], [ -87.940694, 38.181261 ], [ -87.951307, 38.193099 ], [ -87.959062, 38.203712 ], [ -87.961103, 38.214733 ], [ -87.955344, 38.230008 ], [ -87.951715, 38.239632 ], [ -87.923958, 38.258409 ], [ -87.863032, 38.280172 ], [ -87.750028, 38.403027 ], [ -87.740001, 38.415698 ], [ -87.656144, 38.521668 ], [ -87.669232, 38.541742 ], [ -87.670071, 38.545237 ], [ -87.651529, 38.568166 ], [ -87.627345, 38.607237 ], [ -87.620120, 38.639489 ], [ -87.600180, 38.662462 ], [ -87.593678, 38.667402 ], [ -87.579397, 38.672475 ], [ -87.540052, 38.679143 ], [ -87.531231, 38.684036 ], [ -87.519609, 38.697198 ], [ -87.498515, 38.758983 ], [ -87.495211, 38.783060 ], [ -87.525893, 38.848795 ], [ -87.528194, 38.851691 ], [ -87.532064, 38.852503 ], [ -87.537248, 38.853592 ], [ -87.550515, 38.859560 ], [ -87.553384, 38.863344 ], [ -87.540804, 38.896385 ], [ -87.528108, 38.908027 ], [ -87.527910, 38.908209 ], [ -87.518826, 38.923205 ], [ -87.512187, 38.954417 ], [ -87.572588, 39.057286 ], [ -87.614881, 39.102655 ], [ -87.658746, 39.135997 ], [ -87.651719, 39.150602 ], [ -87.642174, 39.157097 ], [ -87.628727, 39.157427 ], [ -87.605173, 39.185897 ], [ -87.587507, 39.249282 ], [ -87.593486, 39.247452 ], [ -87.604076, 39.259459 ], [ -87.605543, 39.261122 ], [ -87.610050, 39.282232 ], [ -87.604043, 39.313526 ], [ -87.589084, 39.333831 ], [ -87.584852, 39.337329 ], [ -87.544013, 39.352907 ], [ -87.537271, 39.352089 ], [ -87.531646, 39.347888 ], [ -87.531355, 39.436656 ], [ -87.531355, 39.437732 ], [ -87.531489, 39.449474 ], [ -87.531608, 39.466225 ], [ -87.531624, 39.469378 ], [ -87.531663, 39.477110 ], [ -87.531663, 39.477120 ], [ -87.531627, 39.491698 ], [ -87.531692, 39.495516 ], [ -87.531965, 39.526937 ], [ -87.531939, 39.545853 ], [ -87.532008, 39.564013 ], [ -87.532196, 39.607306 ], [ -87.532365, 39.646126 ], [ -87.532444, 39.646102 ], [ -87.532703, 39.664868 ], [ -87.533066, 39.781743 ], [ -87.533058, 39.796243 ], [ -87.533056, 39.803922 ], [ -87.533142, 39.810947 ], [ -87.533227, 39.883000 ], [ -87.533227, 39.883127 ], [ -87.532776, 39.971077 ], [ -87.532790, 39.975010 ], [ -87.532683, 39.977691 ], [ -87.532542, 39.987462 ], [ -87.532331, 39.997776 ], [ -87.532287, 40.000037 ], [ -87.532308, 40.011492 ], [ -87.532308, 40.011587 ], [ -87.531561, 40.133005 ], [ -87.531759, 40.144273 ], [ -87.531439, 40.148027 ], [ -87.531438, 40.148123 ], [ -87.531133, 40.170030 ], [ -87.530828, 40.191812 ], [ -87.529992, 40.250036 ], [ -87.530054, 40.250671 ], [ -87.526809, 40.462170 ], [ -87.526549, 40.475659 ], [ -87.526511, 40.476879 ], [ -87.526502, 40.477158 ], [ -87.526379, 40.491237 ], [ -87.526376, 40.491574 ], [ -87.526352, 40.535111 ], [ -87.526292, 40.535409 ], [ -87.526129, 40.736885 ], [ -87.526129, 40.736950 ], [ -87.525783, 40.854357 ], [ -87.526113, 40.879703 ], [ -87.525962, 40.880618 ], [ -87.526437, 40.894209 ], [ -87.526084, 40.911914 ], [ -87.526305, 41.010346 ], [ -87.526307, 41.010355 ], [ -87.526346, 41.010583 ], [ -87.526520, 41.024837 ], [ -87.526711, 41.121485 ], [ -87.526700, 41.139658 ], [ -87.526696, 41.149222 ], [ -87.526693, 41.153958 ], [ -87.526719, 41.159448 ], [ -87.526660, 41.160090 ], [ -87.526567, 41.163865 ], [ -87.526570, 41.166097 ], [ -87.526768, 41.298052 ], [ -87.526768, 41.298177 ], [ -87.525623, 41.453619 ], [ -87.525671, 41.470115 ], [ -87.525669, 41.470283 ], [ -87.524641, 41.563335 ], [ -87.524642, 41.622535 ], [ -87.524742, 41.632435 ], [ -87.524642, 41.634935 ], [ -87.524844, 41.691635 ], [ -87.524944, 41.702635 ], [ -87.524044, 41.708335 ], [ -87.520544, 41.709935 ], [ -87.515243, 41.704235 ], [ -87.511043, 41.696535 ], [ -87.505343, 41.691535 ], [ -87.470742, 41.672835 ], [ -87.463142, 41.675535 ], [ -87.453041, 41.673035 ], [ -87.446113, 41.669340 ], [ -87.441987, 41.671905 ], [ -87.438530, 41.670679 ], [ -87.437191, 41.669006 ], [ -87.434849, 41.666887 ], [ -87.432953, 41.665102 ], [ -87.432396, 41.660530 ], [ -87.438941, 41.654335 ], [ -87.429840, 41.646035 ], [ -87.423440, 41.642835 ], [ -87.394539, 41.637235 ], [ -87.365439, 41.629536 ], [ -87.324338, 41.623036 ], [ -87.287637, 41.622236 ], [ -87.278437, 41.619736 ], [ -87.261536, 41.620336 ], [ -87.222644, 41.624161 ], [ -87.220660, 41.624356 ], [ -87.187651, 41.629653 ], [ -87.160625, 41.637266 ], [ -87.160784, 41.645385 ], [ -87.125835, 41.650302 ], [ -87.120322, 41.645701 ], [ -87.066033, 41.661845 ], [ -87.027888, 41.674661 ], [ -87.009640, 41.681520 ], [ -86.934830, 41.709638 ], [ -86.932747, 41.711040 ], [ -86.909130, 41.726938 ], [ -86.875429, 41.737939 ], [ -86.824828, 41.760240 ], [ -86.823628, 41.760240 ], [ -86.804427, 41.760240 ], [ -86.801578, 41.760240 ], [ -86.800707, 41.760240 ], [ -86.800611, 41.760251 ], [ -86.748096, 41.759967 ], [ -86.746521, 41.759982 ], [ -86.641186, 41.759633 ], [ -86.640044, 41.759671 ], [ -86.524223, 41.759456 ], [ -86.519318, 41.759447 ], [ -86.501773, 41.759553 ], [ -86.265496, 41.760207 ], [ -86.226097, 41.760016 ], [ -86.226070, 41.760016 ], [ -86.217590, 41.760016 ], [ -86.127844, 41.760592 ], [ -86.125460, 41.760560 ], [ -86.125060, 41.760576 ], [ -86.062572, 41.760283 ], [ -86.003683, 41.760007 ], [ -85.991302, 41.759949 ], [ -85.974980, 41.759849 ], [ -85.974901, 41.759849 ], [ -85.888825, 41.759422 ], [ -85.874997, 41.759341 ], [ -85.872041, 41.759365 ], [ -85.791363, 41.759051 ], [ -85.791335, 41.759051 ], [ -85.775039, 41.759147 ], [ -85.750469, 41.759090 ], [ -85.749992, 41.759091 ], [ -85.724534, 41.759085 ], [ -85.659750, 41.759101 ], [ -85.650738, 41.759103 ], [ -85.647683, 41.759125 ], [ -85.632714, 41.759164 ], [ -85.624987, 41.759093 ], [ -85.622608, 41.759049 ], [ -85.608312, 41.759193 ], [ -85.607548, 41.759079 ], [ -85.518251, 41.759513 ], [ -85.515959, 41.759352 ], [ -85.432471, 41.759684 ], [ -85.427553, 41.759706 ], [ -85.379133, 41.759875 ], [ -85.350174, 41.759908 ], [ -85.330623, 41.759982 ], [ -85.318129, 41.759983 ], [ -85.308140, 41.760097 ], [ -85.298365, 41.760028 ], [ -85.292178, 41.759963 ], [ -85.292099, 41.759962 ], [ -85.273713, 41.759770 ], [ -85.272951, 41.759911 ], [ -85.272216, 41.759999 ], [ -85.232835, 41.759839 ], [ -85.196774, 41.759735 ], [ -85.196637, 41.759735 ], [ -85.172230, 41.759618 ], [ -85.123102, 41.759743 ], [ -85.117267, 41.759700 ], [ -85.039436, 41.759985 ], [ -85.037817, 41.759801 ], [ -84.972803, 41.759366 ], [ -84.971551, 41.759527 ], [ -84.961562, 41.759552 ], [ -84.960860, 41.759438 ], [ -84.932484, 41.759691 ], [ -84.825196, 41.759990 ], [ -84.825130, 41.759991 ], [ -84.818873, 41.760059 ], [ -84.806134, 41.743115 ], [ -84.806074, 41.737603 ], [ -84.806065, 41.732909 ], [ -84.806042, 41.720544 ], [ -84.806018, 41.707485 ], [ -84.806082, 41.696089 ], [ -84.806210, 41.674550 ], [ -84.805673, 41.632342 ], [ -84.805696, 41.631398 ], [ -84.805812, 41.613040 ], [ -84.804729, 41.530231 ], [ -84.804729, 41.530135 ], [ -84.804729, 41.530092 ], [ -84.804551, 41.500364 ], [ -84.804457, 41.488224 ], [ -84.803919, 41.435531 ], [ -84.803956, 41.426128 ], [ -84.803956, 41.426044 ], [ -84.804015, 41.411655 ], [ -84.804046, 41.408361 ], [ -84.804133, 41.408292 ], [ -84.803926, 41.367959 ], [ -84.803582, 41.271273 ], [ -84.803581, 41.271079 ], [ -84.803580, 41.270942 ], [ -84.803492, 41.252562 ], [ -84.803492, 41.252531 ], [ -84.803472, 41.173889 ], [ -84.803594, 41.173203 ], [ -84.803413, 41.164649 ], [ -84.803378, 41.096867 ], [ -84.803374, 41.089302 ], [ -84.803313, 40.989394 ], [ -84.803313, 40.989209 ], [ -84.802936, 40.922568 ], [ -84.802935, 40.922377 ], [ -84.802538, 40.765515 ], [ -84.802266, 40.742298 ], [ -84.802119, 40.728163 ], [ -84.802119, 40.728146 ], [ -84.802181, 40.718602 ], [ -84.802094, 40.702476 ], [ -84.802127, 40.691405 ], [ -84.802157, 40.689324 ], [ -84.802220, 40.674776 ], [ -84.802193, 40.660298 ], [ -84.802135, 40.644859 ], [ -84.802265, 40.572215 ], [ -84.802265, 40.572212 ], [ -84.802483, 40.528046 ], [ -84.803068, 40.465388 ], [ -84.804119, 40.352844 ], [ -84.804119, 40.352757 ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US22", "STATE": 10, "name": "Louisiana", "LSAD": "", "CENSUSAREA": 43203.905000 }, "geometry": { "type": "MultiPolygon", "coordinates": [ [ [ [ -88.865067, 29.752714 ], [ -88.889755, 29.718204 ], [ -88.940346, 29.657234 ], [ -88.944435, 29.658806 ], [ -88.946320, 29.662579 ], [ -88.941605, 29.674833 ], [ -88.920235, 29.694319 ], [ -88.911751, 29.699348 ], [ -88.890060, 29.729202 ], [ -88.873611, 29.758043 ], [ -88.867973, 29.772272 ], [ -88.867973, 29.791330 ], [ -88.861267, 29.805826 ], [ -88.846497, 29.817101 ], [ -88.843010, 29.825960 ], [ -88.836296, 29.855221 ], [ -88.836830, 29.858978 ], [ -88.843277, 29.863810 ], [ -88.831200, 29.878839 ], [ -88.828247, 29.920717 ], [ -88.837379, 29.944878 ], [ -88.838715, 29.962326 ], [ -88.835495, 29.967695 ], [ -88.835495, 29.974138 ], [ -88.839790, 29.983803 ], [ -88.840866, 29.995613 ], [ -88.848373, 30.013330 ], [ -88.857368, 30.027826 ], [ -88.869720, 30.043798 ], [ -88.881454, 30.053202 ], [ -88.870476, 30.049212 ], [ -88.855583, 30.034414 ], [ -88.841225, 30.012789 ], [ -88.833725, 29.998821 ], [ -88.824158, 29.970461 ], [ -88.817017, 29.934250 ], [ -88.818146, 29.889109 ], [ -88.826538, 29.847092 ], [ -88.832710, 29.824062 ], [ -88.844078, 29.795713 ], [ -88.865067, 29.752714 ] ] ], [ [ [ -94.043147, 32.693030 ], [ -94.043147, 32.693031 ], [ -94.042947, 32.767991 ], [ -94.043027, 32.776863 ], [ -94.042938, 32.780558 ], [ -94.042829, 32.785277 ], [ -94.042747, 32.786973 ], [ -94.043026, 32.797476 ], [ -94.042785, 32.871486 ], [ -94.043025, 32.880446 ], [ -94.042886, 32.880965 ], [ -94.042886, 32.881089 ], [ -94.042859, 32.892771 ], [ -94.042885, 32.898911 ], [ -94.043092, 32.910021 ], [ -94.043067, 32.937903 ], [ -94.043088, 32.955592 ], [ -94.042964, 33.019219 ], [ -94.041444, 33.019188 ], [ -94.035839, 33.019145 ], [ -94.027983, 33.019139 ], [ -94.024475, 33.019207 ], [ -93.814553, 33.019372 ], [ -93.804930, 33.019347 ], [ -93.531499, 33.018643 ], [ -93.524916, 33.018637 ], [ -93.520994, 33.018616 ], [ -93.520971, 33.018616 ], [ -93.490893, 33.018442 ], [ -93.490520, 33.018442 ], [ -93.489506, 33.018443 ], [ -93.467042, 33.018611 ], [ -93.377134, 33.018234 ], [ -93.340353, 33.018337 ], [ -93.308398, 33.018179 ], [ -93.308181, 33.018156 ], [ -93.238607, 33.017992 ], [ -93.197402, 33.017951 ], [ -93.154351, 33.017856 ], [ -93.101443, 33.017740 ], [ -93.100981, 33.017786 ], [ -93.081428, 33.017928 ], [ -93.073167, 33.017898 ], [ -93.070686, 33.017792 ], [ -92.988708, 33.017298 ], [ -92.971137, 33.017192 ], [ -92.946553, 33.016807 ], [ -92.867510, 33.016062 ], [ -92.854167, 33.016132 ], [ -92.844286, 33.016070 ], [ -92.844073, 33.016034 ], [ -92.830798, 33.015661 ], [ -92.733197, 33.014347 ], [ -92.724994, 33.014351 ], [ -92.724743, 33.014347 ], [ -92.723553, 33.014328 ], [ -92.715884, 33.014398 ], [ -92.711289, 33.014307 ], [ -92.503776, 33.012161 ], [ -92.501383, 33.012160 ], [ -92.469762, 33.012010 ], [ -92.370290, 33.010717 ], [ -92.362865, 33.010628 ], [ -92.335893, 33.010349 ], [ -92.292664, 33.010103 ], [ -92.222825, 33.009080 ], [ -92.069105, 33.008163 ], [ -91.951958, 33.007428 ], [ -91.950001, 33.007520 ], [ -91.626670, 33.006639 ], [ -91.617615, 33.006717 ], [ -91.609001, 33.006556 ], [ -91.579802, 33.006518 ], [ -91.579639, 33.006472 ], [ -91.572326, 33.006908 ], [ -91.559494, 33.006840 ], [ -91.460370, 33.006246 ], [ -91.435782, 33.006099 ], [ -91.425466, 33.006016 ], [ -91.376016, 33.005794 ], [ -91.333011, 33.005529 ], [ -91.329767, 33.005421 ], [ -91.326396, 33.005376 ], [ -91.325037, 33.005364 ], [ -91.322506, 33.005341 ], [ -91.312016, 33.005262 ], [ -91.284398, 33.005007 ], [ -91.265018, 33.005084 ], [ -91.166073, 33.004106 ], [ -91.201842, 32.961212 ], [ -91.214027, 32.930320 ], [ -91.212837, 32.922104 ], [ -91.208263, 32.915354 ], [ -91.196785, 32.906784 ], [ -91.175405, 32.899998 ], [ -91.159975, 32.899879 ], [ -91.145076, 32.905494 ], [ -91.134041, 32.917676 ], [ -91.132115, 32.923122 ], [ -91.130947, 32.963815 ], [ -91.138585, 32.971352 ], [ -91.134414, 32.980533 ], [ -91.125107, 32.984669 ], [ -91.106581, 32.988938 ], [ -91.094265, 32.984371 ], [ -91.086802, 32.976266 ], [ -91.063974, 32.924113 ], [ -91.063809, 32.903709 ], [ -91.070602, 32.888659 ], [ -91.086683, 32.873392 ], [ -91.105631, 32.858396 ], [ -91.116091, 32.855641 ], [ -91.127886, 32.855059 ], [ -91.145002, 32.842870 ], [ -91.158336, 32.822304 ], [ -91.161669, 32.812465 ], [ -91.164397, 32.785821 ], [ -91.165328, 32.751301 ], [ -91.163389, 32.747009 ], [ -91.154461, 32.742339 ], [ -91.123152, 32.742798 ], [ -91.077176, 32.732534 ], [ -91.060766, 32.727494 ], [ -91.054481, 32.722259 ], [ -91.057043, 32.712576 ], [ -91.063946, 32.702926 ], [ -91.076061, 32.693751 ], [ -91.098762, 32.685291 ], [ -91.118258, 32.674075 ], [ -91.152081, 32.641508 ], [ -91.153821, 32.631282 ], [ -91.151318, 32.615919 ], [ -91.146204, 32.604144 ], [ -91.141148, 32.597209 ], [ -91.127912, 32.586493 ], [ -91.119854, 32.584795 ], [ -91.104111, 32.584657 ], [ -91.096774, 32.576652 ], [ -91.090771, 32.563978 ], [ -91.090611, 32.562705 ], [ -91.089436, 32.553306 ], [ -91.093741, 32.549128 ], [ -91.097878, 32.544752 ], [ -91.116708, 32.500139 ], [ -91.116008, 32.483140 ], [ -91.108808, 32.472040 ], [ -91.095308, 32.458741 ], [ -91.070207, 32.445141 ], [ -91.052907, 32.438442 ], [ -91.029606, 32.433542 ], [ -90.994080, 32.403862 ], [ -91.004506, 32.368144 ], [ -91.003506, 32.362145 ], [ -91.000106, 32.357695 ], [ -90.986672, 32.351760 ], [ -90.912363, 32.339454 ], [ -90.901511, 32.337864 ], [ -90.898588, 32.329094 ], [ -90.905173, 32.315497 ], [ -91.004557, 32.215381 ], [ -91.006306, 32.224150 ], [ -91.021507, 32.236149 ], [ -91.039007, 32.242349 ], [ -91.046507, 32.241149 ], [ -91.122602, 32.216929 ], [ -91.133587, 32.213432 ], [ -91.158026, 32.201956 ], [ -91.164171, 32.196888 ], [ -91.171046, 32.176526 ], [ -91.174552, 32.154978 ], [ -91.171702, 32.144250 ], [ -91.165452, 32.134290 ], [ -91.162822, 32.132694 ], [ -91.131403, 32.126213 ], [ -91.067004, 32.132144 ], [ -91.057487, 32.135515 ], [ -91.052342, 32.137337 ], [ -91.046615, 32.138768 ], [ -91.040531, 32.137337 ], [ -91.034447, 32.134832 ], [ -91.030152, 32.129821 ], [ -91.026931, 32.123737 ], [ -91.027125, 32.120434 ], [ -91.027535, 32.113431 ], [ -91.027946, 32.112722 ], [ -91.034707, 32.101053 ], [ -91.128009, 31.985857 ], [ -91.248144, 31.869848 ], [ -91.293413, 31.860160 ], [ -91.326914, 31.854961 ], [ -91.338414, 31.851261 ], [ -91.345714, 31.842861 ], [ -91.359514, 31.799362 ], [ -91.363714, 31.780363 ], [ -91.365614, 31.760763 ], [ -91.365084, 31.752743 ], [ -91.369375, 31.746903 ], [ -91.379935, 31.733013 ], [ -91.397915, 31.709364 ], [ -91.400115, 31.688164 ], [ -91.398059, 31.655922 ], [ -91.404668, 31.637898 ], [ -91.422090, 31.631290 ], [ -91.441315, 31.631290 ], [ -91.452730, 31.631290 ], [ -91.464746, 31.628886 ], [ -91.474959, 31.621677 ], [ -91.477963, 31.610863 ], [ -91.477963, 31.604855 ], [ -91.477963, 31.598247 ], [ -91.477362, 31.592239 ], [ -91.470754, 31.585630 ], [ -91.458679, 31.583226 ], [ -91.448620, 31.583032 ], [ -91.437711, 31.580824 ], [ -91.425094, 31.577820 ], [ -91.415482, 31.567006 ], [ -91.416683, 31.561599 ], [ -91.422691, 31.554390 ], [ -91.437616, 31.546166 ], [ -91.450017, 31.539666 ], [ -91.479718, 31.530366 ], [ -91.511217, 31.532612 ], [ -91.515810, 31.530894 ], [ -91.522920, 31.519841 ], [ -91.515130, 31.449206 ], [ -91.510356, 31.438928 ], [ -91.505301, 31.432945 ], [ -91.500406, 31.419008 ], [ -91.505093, 31.400933 ], [ -91.513795, 31.386875 ], [ -91.525386, 31.378904 ], [ -91.541242, 31.356750 ], [ -91.539904, 31.337336 ], [ -91.531201, 31.326625 ], [ -91.519820, 31.311228 ], [ -91.508858, 31.291644 ], [ -91.515614, 31.278210 ], [ -91.522397, 31.273423 ], [ -91.547588, 31.264444 ], [ -91.574493, 31.261289 ], [ -91.598490, 31.205485 ], [ -91.599965, 31.192318 ], [ -91.604197, 31.154545 ], [ -91.577373, 31.078179 ], [ -91.564150, 31.066830 ], [ -91.561283, 31.060906 ], [ -91.559907, 31.054119 ], [ -91.562468, 31.043213 ], [ -91.571695, 31.029782 ], [ -91.584670, 31.020185 ], [ -91.636942, 30.999416 ], [ -91.625118, 30.999167 ], [ -91.538727, 30.999388 ], [ -91.425749, 30.999007 ], [ -91.423621, 30.998984 ], [ -91.224839, 30.999183 ], [ -91.224068, 30.999183 ], [ -91.176209, 30.999144 ], [ -91.176140, 30.999144 ], [ -91.108291, 30.998880 ], [ -91.108114, 30.998857 ], [ -91.080814, 30.998909 ], [ -91.068270, 30.998920 ], [ -91.060217, 30.998935 ], [ -90.826027, 30.999360 ], [ -90.825829, 30.999360 ], [ -90.783745, 30.999447 ], [ -90.779858, 30.999457 ], [ -90.775981, 30.999491 ], [ -90.769333, 30.999374 ], [ -90.758775, 30.999583 ], [ -90.734552, 30.999222 ], [ -90.734473, 30.999214 ], [ -90.651193, 30.999510 ], [ -90.648721, 30.999486 ], [ -90.588676, 30.999650 ], [ -90.587373, 30.999604 ], [ -90.584448, 30.999698 ], [ -90.583518, 30.999698 ], [ -90.567195, 30.999733 ], [ -90.547615, 30.999723 ], [ -90.486749, 30.999693 ], [ -90.485876, 30.999740 ], [ -90.477284, 30.999717 ], [ -90.475928, 30.999740 ], [ -90.474094, 30.999798 ], [ -90.442479, 30.999722 ], [ -90.441725, 30.999729 ], [ -90.437351, 30.999730 ], [ -90.426849, 30.999776 ], [ -90.422117, 30.999810 ], [ -90.369371, 31.000335 ], [ -90.347241, 31.000359 ], [ -90.347230, 31.000359 ], [ -90.346007, 31.000363 ], [ -90.259555, 31.000657 ], [ -90.164676, 31.000980 ], [ -90.164278, 31.001025 ], [ -90.131395, 31.000924 ], [ -90.128406, 31.001047 ], [ -90.050706, 31.001215 ], [ -90.029574, 31.001190 ], [ -90.022185, 31.001302 ], [ -90.005332, 31.001364 ], [ -89.975430, 31.001692 ], [ -89.972802, 31.001392 ], [ -89.927161, 31.001437 ], [ -89.923119, 31.001446 ], [ -89.897516, 31.001913 ], [ -89.892708, 31.001759 ], [ -89.856862, 31.002075 ], [ -89.835908, 31.002059 ], [ -89.835542, 31.002059 ], [ -89.824617, 31.002060 ], [ -89.816429, 31.002084 ], [ -89.752642, 31.001853 ], [ -89.732504, 31.004831 ], [ -89.728147, 31.002431 ], [ -89.728148, 31.002300 ], [ -89.728382, 30.971141 ], [ -89.744789, 30.918933 ], [ -89.756543, 30.900431 ], [ -89.770931, 30.899432 ], [ -89.773410, 30.897693 ], [ -89.789863, 30.851527 ], [ -89.826175, 30.736594 ], [ -89.842596, 30.666038 ], [ -89.842585, 30.666005 ], [ -89.823384, 30.608535 ], [ -89.806843, 30.572039 ], [ -89.760570, 30.515761 ], [ -89.732577, 30.492502 ], [ -89.724614, 30.491902 ], [ -89.690580, 30.458773 ], [ -89.683410, 30.451793 ], [ -89.629941, 30.339449 ], [ -89.629877, 30.321017 ], [ -89.640694, 30.301313 ], [ -89.643575, 30.293099 ], [ -89.643440, 30.287682 ], [ -89.607655, 30.217096 ], [ -89.580754, 30.186197 ], [ -89.572654, 30.180897 ], [ -89.524504, 30.180753 ], [ -89.531213, 30.177099 ], [ -89.537493, 30.171745 ], [ -89.555013, 30.170798 ], [ -89.562825, 30.168667 ], [ -89.568270, 30.163932 ], [ -89.572093, 30.160362 ], [ -89.587062, 30.150648 ], [ -89.595021, 30.149891 ], [ -89.598027, 30.152409 ], [ -89.617542, 30.156422 ], [ -89.622880, 30.152368 ], [ -89.625053, 30.150717 ], [ -89.640989, 30.138612 ], [ -89.644550, 30.134108 ], [ -89.650467, 30.126625 ], [ -89.656986, 30.118381 ], [ -89.658594, 30.117364 ], [ -89.668164, 30.111311 ], [ -89.668638, 30.111011 ], [ -89.669157, 30.110683 ], [ -89.669182, 30.110667 ], [ -89.672881, 30.110490 ], [ -89.674124, 30.110430 ], [ -89.674633, 30.110406 ], [ -89.674956, 30.110212 ], [ -89.675762, 30.109728 ], [ -89.676117, 30.109515 ], [ -89.678156, 30.108290 ], [ -89.678163, 30.108286 ], [ -89.678293, 30.107746 ], [ -89.678457, 30.107059 ], [ -89.678499, 30.106886 ], [ -89.679655, 30.102067 ], [ -89.679823, 30.101367 ], [ -89.679838, 30.101304 ], [ -89.680042, 30.100452 ], [ -89.680350, 30.099171 ], [ -89.680485, 30.098605 ], [ -89.681265, 30.095355 ], [ -89.681906, 30.092682 ], [ -89.682057, 30.092052 ], [ -89.682181, 30.091536 ], [ -89.682181, 30.091531 ], [ -89.682277, 30.090565 ], [ -89.682280, 30.090531 ], [ -89.682331, 30.090015 ], [ -89.682371, 30.089607 ], [ -89.682393, 30.089391 ], [ -89.682409, 30.089225 ], [ -89.682691, 30.086365 ], [ -89.683051, 30.082718 ], [ -89.683168, 30.081530 ], [ -89.683712, 30.076018 ], [ -89.697556, 30.070842 ], [ -89.698461, 30.070504 ], [ -89.698496, 30.070491 ], [ -89.698909, 30.070451 ], [ -89.699144, 30.070428 ], [ -89.699629, 30.070381 ], [ -89.711848, 30.069194 ], [ -89.712942, 30.069088 ], [ -89.713003, 30.069061 ], [ -89.714085, 30.068582 ], [ -89.714827, 30.068253 ], [ -89.715494, 30.067958 ], [ -89.715884, 30.067785 ], [ -89.716237, 30.067628 ], [ -89.716425, 30.067545 ], [ -89.716750, 30.067402 ], [ -89.716887, 30.067341 ], [ -89.721992, 30.065080 ], [ -89.724433, 30.063999 ], [ -89.726330, 30.063158 ], [ -89.727453, 30.062661 ], [ -89.728026, 30.061841 ], [ -89.729570, 30.059628 ], [ -89.729680, 30.059470 ], [ -89.729790, 30.059314 ], [ -89.729911, 30.059139 ], [ -89.730990, 30.057594 ], [ -89.730999, 30.057581 ], [ -89.731208, 30.054558 ], [ -89.731428, 30.051377 ], [ -89.731452, 30.051040 ], [ -89.731545, 30.049694 ], [ -89.731545, 30.049691 ], [ -89.731544, 30.049690 ], [ -89.716300, 30.028110 ], [ -89.716300, 30.028106 ], [ -89.716301, 30.028088 ], [ -89.716328, 30.027415 ], [ -89.716336, 30.027230 ], [ -89.716358, 30.026686 ], [ -89.716377, 30.026222 ], [ -89.724649, 30.022454 ], [ -89.724669, 30.022453 ], [ -89.725760, 30.022403 ], [ -89.733323, 30.022054 ], [ -89.734361, 30.022884 ], [ -89.739028, 30.026618 ], [ -89.739574, 30.027055 ], [ -89.740886, 30.028104 ], [ -89.745827, 30.032056 ], [ -89.746313, 30.032445 ], [ -89.746505, 30.032599 ], [ -89.746506, 30.032600 ], [ -89.757138, 30.038650 ], [ -89.763216, 30.042108 ], [ -89.782534, 30.045372 ], [ -89.784630, 30.045253 ], [ -89.813684, 30.043605 ], [ -89.818561, 30.043328 ], [ -89.829762, 30.033275 ], [ -89.830442, 30.032664 ], [ -89.832213, 30.031075 ], [ -89.832965, 30.030400 ], [ -89.833794, 30.029656 ], [ -89.834644, 30.028893 ], [ -89.835202, 30.028393 ], [ -89.839926, 30.024153 ], [ -89.839933, 30.024146 ], [ -89.840963, 30.022995 ], [ -89.841739, 30.022127 ], [ -89.854533, 30.007821 ], [ -89.857558, 30.004439 ], [ -89.852312, 29.977650 ], [ -89.844202, 29.955645 ], [ -89.838500, 29.945816 ], [ -89.829023, 29.939228 ], [ -89.818030, 29.934145 ], [ -89.804463, 29.932588 ], [ -89.775459, 29.937416 ], [ -89.748492, 29.945831 ], [ -89.727933, 29.958780 ], [ -89.719067, 29.953699 ], [ -89.712910, 29.946349 ], [ -89.736311, 29.936263 ], [ -89.742727, 29.935894 ], [ -89.746273, 29.928221 ], [ -89.742479, 29.908170 ], [ -89.711158, 29.879287 ], [ -89.692004, 29.868722 ], [ -89.671555, 29.867535 ], [ -89.660568, 29.862909 ], [ -89.638016, 29.864065 ], [ -89.613159, 29.872160 ], [ -89.598129, 29.881409 ], [ -89.591194, 29.897018 ], [ -89.592346, 29.917253 ], [ -89.583099, 29.931705 ], [ -89.583099, 29.945581 ], [ -89.574997, 29.959455 ], [ -89.574425, 29.983738 ], [ -89.581360, 29.994722 ], [ -89.571533, 29.999926 ], [ -89.551292, 30.005709 ], [ -89.501587, 30.034037 ], [ -89.494064, 30.040972 ], [ -89.494637, 30.050800 ], [ -89.499275, 30.058893 ], [ -89.493484, 30.072191 ], [ -89.481926, 30.079128 ], [ -89.458946, 30.063450 ], [ -89.444618, 30.060959 ], [ -89.429047, 30.052240 ], [ -89.418465, 30.049747 ], [ -89.372375, 30.054729 ], [ -89.368637, 30.047256 ], [ -89.372375, 30.036671 ], [ -89.381096, 30.030441 ], [ -89.393555, 30.029818 ], [ -89.415970, 30.020477 ], [ -89.422813, 30.015495 ], [ -89.432785, 30.008022 ], [ -89.433411, 29.991205 ], [ -89.432785, 29.978752 ], [ -89.405380, 29.965672 ], [ -89.393555, 29.966295 ], [ -89.379227, 29.963804 ], [ -89.378601, 29.919588 ], [ -89.368019, 29.911491 ], [ -89.331894, 29.915850 ], [ -89.315453, 29.923208 ], [ -89.283562, 29.973320 ], [ -89.273315, 29.993820 ], [ -89.250534, 30.002361 ], [ -89.243706, 29.997236 ], [ -89.249969, 29.975597 ], [ -89.218071, 29.972750 ], [ -89.223770, 29.961929 ], [ -89.231178, 29.925484 ], [ -89.244843, 29.930040 ], [ -89.263062, 29.929472 ], [ -89.280144, 29.924915 ], [ -89.318306, 29.898149 ], [ -89.322289, 29.887333 ], [ -89.311462, 29.881636 ], [ -89.289253, 29.880499 ], [ -89.272179, 29.886763 ], [ -89.241425, 29.889610 ], [ -89.236298, 29.886763 ], [ -89.236298, 29.877081 ], [ -89.254517, 29.864552 ], [ -89.269897, 29.859997 ], [ -89.294952, 29.857149 ], [ -89.317726, 29.850885 ], [ -89.363289, 29.845760 ], [ -89.383789, 29.838928 ], [ -89.383217, 29.830385 ], [ -89.372971, 29.825260 ], [ -89.345634, 29.820135 ], [ -89.342781, 29.798496 ], [ -89.331970, 29.790524 ], [ -89.318306, 29.788815 ], [ -89.293251, 29.803053 ], [ -89.277298, 29.807608 ], [ -89.277298, 29.799635 ], [ -89.284134, 29.795649 ], [ -89.284706, 29.770021 ], [ -89.269325, 29.760912 ], [ -89.271034, 29.756355 ], [ -89.305199, 29.756926 ], [ -89.316025, 29.760912 ], [ -89.325134, 29.772301 ], [ -89.337662, 29.779135 ], [ -89.354179, 29.781412 ], [ -89.367271, 29.775148 ], [ -89.386063, 29.788815 ], [ -89.394608, 29.784828 ], [ -89.399162, 29.770592 ], [ -89.414536, 29.752371 ], [ -89.428207, 29.741550 ], [ -89.424210, 29.697638 ], [ -89.448120, 29.703316 ], [ -89.471992, 29.718597 ], [ -89.486961, 29.725920 ], [ -89.506065, 29.731651 ], [ -89.530258, 29.743750 ], [ -89.540131, 29.743750 ], [ -89.560181, 29.735472 ], [ -89.572922, 29.746616 ], [ -89.598068, 29.747570 ], [ -89.634048, 29.752981 ], [ -89.651237, 29.749479 ], [ -89.649651, 29.719872 ], [ -89.644562, 29.710957 ], [ -89.618446, 29.700768 ], [ -89.599030, 29.704908 ], [ -89.592979, 29.702042 ], [ -89.599663, 29.690262 ], [ -89.596802, 29.684212 ], [ -89.573883, 29.674025 ], [ -89.557320, 29.670204 ], [ -89.533760, 29.670204 ], [ -89.487915, 29.630405 ], [ -89.485367, 29.624357 ], [ -89.486709, 29.621003 ], [ -89.486931, 29.620447 ], [ -89.504738, 29.631508 ], [ -89.523018, 29.639427 ], [ -89.535202, 29.648567 ], [ -89.583336, 29.652834 ], [ -89.608925, 29.657707 ], [ -89.621109, 29.657101 ], [ -89.623550, 29.662584 ], [ -89.632698, 29.671724 ], [ -89.644272, 29.675381 ], [ -89.649750, 29.672941 ], [ -89.641228, 29.647961 ], [ -89.641228, 29.635773 ], [ -89.647324, 29.625414 ], [ -89.657677, 29.624195 ], [ -89.674736, 29.626633 ], [ -89.684486, 29.624804 ], [ -89.688141, 29.615055 ], [ -89.684486, 29.602867 ], [ -89.671082, 29.588243 ], [ -89.668648, 29.580322 ], [ -89.684486, 29.563263 ], [ -89.684486, 29.551073 ], [ -89.681092, 29.534487 ], [ -89.696230, 29.525004 ], [ -89.699698, 29.523423 ], [ -89.700845, 29.520785 ], [ -89.700501, 29.515967 ], [ -89.693877, 29.508559 ], [ -89.665813, 29.490020 ], [ -89.644039, 29.492343 ], [ -89.635330, 29.489294 ], [ -89.617558, 29.468298 ], [ -89.596533, 29.456303 ], [ -89.592474, 29.449822 ], [ -89.589536, 29.437662 ], [ -89.577096, 29.433692 ], [ -89.574635, 29.435734 ], [ -89.574653, 29.441100 ], [ -89.548686, 29.465723 ], [ -89.528429, 29.454702 ], [ -89.532150, 29.434567 ], [ -89.531943, 29.425679 ], [ -89.518368, 29.400230 ], [ -89.508551, 29.386168 ], [ -89.505038, 29.386040 ], [ -89.487308, 29.393346 ], [ -89.484354, 29.397471 ], [ -89.482318, 29.406222 ], [ -89.477140, 29.411241 ], [ -89.470142, 29.401471 ], [ -89.457303, 29.393148 ], [ -89.422380, 29.390628 ], [ -89.380001, 29.391785 ], [ -89.373109, 29.387175 ], [ -89.355528, 29.381569 ], [ -89.340304, 29.381412 ], [ -89.336589, 29.378228 ], [ -89.347615, 29.365000 ], [ -89.350694, 29.349544 ], [ -89.323170, 29.343982 ], [ -89.303766, 29.357455 ], [ -89.283028, 29.356467 ], [ -89.272543, 29.351195 ], [ -89.265300, 29.345352 ], [ -89.257852, 29.336872 ], [ -89.253545, 29.322802 ], [ -89.240870, 29.310081 ], [ -89.224192, 29.313792 ], [ -89.223444, 29.318066 ], [ -89.219734, 29.324412 ], [ -89.204703, 29.338674 ], [ -89.200389, 29.344418 ], [ -89.200599, 29.347672 ], [ -89.189354, 29.345061 ], [ -89.179547, 29.339608 ], [ -89.177351, 29.335210 ], [ -89.178221, 29.326970 ], [ -89.165015, 29.303039 ], [ -89.157593, 29.296691 ], [ -89.140275, 29.291085 ], [ -89.134337, 29.279340 ], [ -89.136979, 29.275239 ], [ -89.129688, 29.265632 ], [ -89.100106, 29.250220 ], [ -89.096173, 29.242930 ], [ -89.095544, 29.238028 ], [ -89.098389, 29.232963 ], [ -89.105833, 29.231608 ], [ -89.106244, 29.215912 ], [ -89.100650, 29.206314 ], [ -89.090724, 29.199992 ], [ -89.068265, 29.204166 ], [ -89.067371, 29.208636 ], [ -89.029103, 29.220956 ], [ -89.021850, 29.218162 ], [ -89.015192, 29.211561 ], [ -89.000674, 29.180091 ], [ -89.005290, 29.164949 ], [ -89.013254, 29.163280 ], [ -89.018344, 29.165046 ], [ -89.024269, 29.170043 ], [ -89.043919, 29.162528 ], [ -89.047233, 29.157833 ], [ -89.038730, 29.142380 ], [ -89.032004, 29.144747 ], [ -89.024149, 29.137298 ], [ -89.023942, 29.133700 ], [ -89.026031, 29.130126 ], [ -89.051953, 29.106554 ], [ -89.055475, 29.084167 ], [ -89.062335, 29.070234 ], [ -89.091260, 29.066931 ], [ -89.098068, 29.067984 ], [ -89.105009, 29.073641 ], [ -89.121542, 29.069074 ], [ -89.143453, 29.047591 ], [ -89.156339, 29.028782 ], [ -89.162000, 29.015860 ], [ -89.162326, 29.011713 ], [ -89.164788, 29.008703 ], [ -89.169850, 29.008703 ], [ -89.175732, 29.012123 ], [ -89.186061, 29.017993 ], [ -89.182150, 29.025486 ], [ -89.189893, 29.032635 ], [ -89.197871, 29.029701 ], [ -89.202563, 29.031603 ], [ -89.211144, 29.040813 ], [ -89.216101, 29.056371 ], [ -89.215531, 29.061410 ], [ -89.217201, 29.067275 ], [ -89.225865, 29.078660 ], [ -89.236310, 29.084605 ], [ -89.254726, 29.083261 ], [ -89.257283, 29.081086 ], [ -89.256869, 29.073800 ], [ -89.253640, 29.064954 ], [ -89.259354, 29.058358 ], [ -89.283215, 29.053325 ], [ -89.291090, 29.053097 ], [ -89.304888, 29.046379 ], [ -89.315389, 29.039081 ], [ -89.318102, 29.035342 ], [ -89.315182, 29.032662 ], [ -89.324850, 29.013805 ], [ -89.335228, 29.015003 ], [ -89.338249, 29.012935 ], [ -89.383814, 28.947434 ], [ -89.411480, 28.925011 ], [ -89.419865, 28.929709 ], [ -89.412388, 28.957504 ], [ -89.408157, 28.965341 ], [ -89.398104, 28.977016 ], [ -89.382106, 28.981525 ], [ -89.375049, 28.985368 ], [ -89.334735, 29.040335 ], [ -89.339828, 29.052221 ], [ -89.354798, 29.072543 ], [ -89.374522, 29.084174 ], [ -89.405654, 29.086936 ], [ -89.411154, 29.105838 ], [ -89.409371, 29.127855 ], [ -89.417718, 29.138690 ], [ -89.428965, 29.144510 ], [ -89.432932, 29.149023 ], [ -89.447472, 29.178576 ], [ -89.455829, 29.190991 ], [ -89.472310, 29.207550 ], [ -89.482844, 29.215053 ], [ -89.536600, 29.236212 ], [ -89.606651, 29.252023 ], [ -89.671781, 29.289028 ], [ -89.697258, 29.296679 ], [ -89.726162, 29.304026 ], [ -89.782149, 29.311132 ], [ -89.819859, 29.310241 ], [ -89.850305, 29.311768 ], [ -89.855109, 29.334997 ], [ -89.853699, 29.340640 ], [ -89.847124, 29.349186 ], [ -89.835000, 29.359043 ], [ -89.820824, 29.377486 ], [ -89.816916, 29.384385 ], [ -89.816155, 29.393518 ], [ -89.816916, 29.398845 ], [ -89.819199, 29.404173 ], [ -89.822243, 29.409500 ], [ -89.826049, 29.415589 ], [ -89.835392, 29.418538 ], [ -89.843553, 29.421677 ], [ -89.845075, 29.434615 ], [ -89.836773, 29.454040 ], [ -89.833659, 29.456686 ], [ -89.833659, 29.459731 ], [ -89.832898, 29.463536 ], [ -89.833659, 29.467341 ], [ -89.834420, 29.470386 ], [ -89.840509, 29.473430 ], [ -89.849642, 29.477996 ], [ -89.862580, 29.476474 ], [ -89.876224, 29.472168 ], [ -89.902179, 29.460011 ], [ -89.918999, 29.444254 ], [ -89.932598, 29.429288 ], [ -89.955430, 29.428527 ], [ -89.961950, 29.432874 ], [ -89.964563, 29.434615 ], [ -89.972934, 29.443748 ], [ -89.991961, 29.463536 ], [ -90.012510, 29.462775 ], [ -90.018598, 29.452120 ], [ -90.022404, 29.444509 ], [ -90.029466, 29.432015 ], [ -90.032298, 29.427005 ], [ -90.031536, 29.412545 ], [ -90.033295, 29.393274 ], [ -90.029468, 29.388136 ], [ -90.029614, 29.386658 ], [ -90.029967, 29.383087 ], [ -90.030761, 29.375043 ], [ -90.030764, 29.375008 ], [ -90.030855, 29.374876 ], [ -90.033604, 29.370851 ], [ -90.035415, 29.368201 ], [ -90.036374, 29.363661 ], [ -90.032842, 29.348624 ], [ -90.031815, 29.344251 ], [ -90.034275, 29.322661 ], [ -90.028536, 29.307083 ], [ -90.013778, 29.302710 ], [ -90.009678, 29.294785 ], [ -90.016288, 29.284257 ], [ -90.019517, 29.282213 ], [ -90.032088, 29.280027 ], [ -90.043293, 29.282487 ], [ -90.057094, 29.281331 ], [ -90.061057, 29.276748 ], [ -90.059691, 29.272648 ], [ -90.060511, 29.267729 ], [ -90.070622, 29.262537 ], [ -90.086747, 29.259257 ], [ -90.091119, 29.261443 ], [ -90.097678, 29.261990 ], [ -90.101231, 29.259804 ], [ -90.096038, 29.240673 ], [ -90.073355, 29.227282 ], [ -90.073355, 29.210611 ], [ -90.070622, 29.208698 ], [ -90.063610, 29.209474 ], [ -90.042910, 29.211765 ], [ -90.019772, 29.231903 ], [ -90.005718, 29.240627 ], [ -89.969981, 29.255753 ], [ -89.965667, 29.259126 ], [ -89.959509, 29.267677 ], [ -89.951175, 29.266124 ], [ -89.949925, 29.263154 ], [ -89.950756, 29.260801 ], [ -89.956460, 29.253744 ], [ -90.022029, 29.216065 ], [ -90.058512, 29.183687 ], [ -90.079276, 29.169970 ], [ -90.088684, 29.162574 ], [ -90.104162, 29.150407 ], [ -90.174273, 29.105301 ], [ -90.223587, 29.085075 ], [ -90.231984, 29.087730 ], [ -90.245283, 29.085824 ], [ -90.343293, 29.057062 ], [ -90.348768, 29.057817 ], [ -90.349891, 29.063681 ], [ -90.325514, 29.075138 ], [ -90.304129, 29.077332 ], [ -90.292930, 29.078761 ], [ -90.282983, 29.082326 ], [ -90.266290, 29.089421 ], [ -90.258145, 29.091627 ], [ -90.253141, 29.093772 ], [ -90.249806, 29.100919 ], [ -90.250044, 29.108067 ], [ -90.243849, 29.110450 ], [ -90.234235, 29.110268 ], [ -90.234405, 29.128824 ], [ -90.243435, 29.136311 ], [ -90.248629, 29.138370 ], [ -90.269010, 29.139242 ], [ -90.280516, 29.142521 ], [ -90.278320, 29.150691 ], [ -90.297000, 29.171317 ], [ -90.302846, 29.175098 ], [ -90.302948, 29.187948 ], [ -90.300885, 29.196171 ], [ -90.293183, 29.199789 ], [ -90.282800, 29.192545 ], [ -90.275851, 29.193668 ], [ -90.271251, 29.204639 ], [ -90.286621, 29.225694 ], [ -90.300304, 29.231241 ], [ -90.311663, 29.237954 ], [ -90.311523, 29.256374 ], [ -90.316093, 29.264777 ], [ -90.332796, 29.276956 ], [ -90.367166, 29.274128 ], [ -90.368154, 29.270736 ], [ -90.367012, 29.264956 ], [ -90.372565, 29.258923 ], [ -90.387924, 29.252786 ], [ -90.383857, 29.235606 ], [ -90.399465, 29.201046 ], [ -90.408578, 29.196421 ], [ -90.409416, 29.196135 ], [ -90.432912, 29.188132 ], [ -90.435907, 29.188449 ], [ -90.443954, 29.195830 ], [ -90.472489, 29.192688 ], [ -90.473273, 29.195224 ], [ -90.468773, 29.198469 ], [ -90.467233, 29.202549 ], [ -90.485786, 29.209843 ], [ -90.494928, 29.216713 ], [ -90.490987, 29.220883 ], [ -90.468320, 29.227532 ], [ -90.465764, 29.242951 ], [ -90.462866, 29.249809 ], [ -90.450674, 29.263739 ], [ -90.452186, 29.266250 ], [ -90.472779, 29.272556 ], [ -90.495299, 29.287277 ], [ -90.510555, 29.290925 ], [ -90.517277, 29.282719 ], [ -90.526216, 29.276492 ], [ -90.552005, 29.278512 ], [ -90.565436, 29.285111 ], [ -90.582525, 29.276037 ], [ -90.589724, 29.248521 ], [ -90.588470, 29.245863 ], [ -90.583924, 29.242886 ], [ -90.576506, 29.243986 ], [ -90.565378, 29.242475 ], [ -90.544547, 29.230683 ], [ -90.543245, 29.227843 ], [ -90.544311, 29.224292 ], [ -90.556501, 29.219913 ], [ -90.557390, 29.207881 ], [ -90.560889, 29.204261 ], [ -90.575277, 29.206827 ], [ -90.618413, 29.203290 ], [ -90.624161, 29.210366 ], [ -90.627420, 29.211004 ], [ -90.633819, 29.209128 ], [ -90.640223, 29.196554 ], [ -90.645612, 29.175867 ], [ -90.645169, 29.172958 ], [ -90.640863, 29.171261 ], [ -90.636973, 29.164572 ], [ -90.647042, 29.128580 ], [ -90.677724, 29.118742 ], [ -90.691109, 29.121722 ], [ -90.700893, 29.121470 ], [ -90.718035, 29.116611 ], [ -90.731239, 29.122886 ], [ -90.764189, 29.113374 ], [ -90.773458, 29.100133 ], [ -90.799444, 29.087377 ], [ -90.802053, 29.083322 ], [ -90.803699, 29.063709 ], [ -90.798720, 29.054841 ], [ -90.781981, 29.049431 ], [ -90.765188, 29.049403 ], [ -90.750092, 29.053247 ], [ -90.725300, 29.066616 ], [ -90.709105, 29.064305 ], [ -90.705350, 29.062679 ], [ -90.702102, 29.060275 ], [ -90.692205, 29.059607 ], [ -90.683645, 29.060944 ], [ -90.676958, 29.063619 ], [ -90.665589, 29.067230 ], [ -90.652348, 29.069237 ], [ -90.644189, 29.071510 ], [ -90.641247, 29.072313 ], [ -90.639240, 29.072848 ], [ -90.637623, 29.072084 ], [ -90.636033, 29.069792 ], [ -90.637495, 29.066608 ], [ -90.648058, 29.062649 ], [ -90.730899, 29.042259 ], [ -90.755677, 29.038997 ], [ -90.797680, 29.039741 ], [ -90.811473, 29.036580 ], [ -90.839345, 29.039167 ], [ -90.842762, 29.042947 ], [ -90.844849, 29.048721 ], [ -90.841226, 29.054266 ], [ -90.844593, 29.067280 ], [ -90.862757, 29.094863 ], [ -90.867766, 29.095434 ], [ -90.877583, 29.104891 ], [ -90.885351, 29.117016 ], [ -90.898215, 29.131342 ], [ -90.925797, 29.153116 ], [ -90.941877, 29.162373 ], [ -90.948091, 29.174104 ], [ -90.961278, 29.180817 ], [ -90.981458, 29.171211 ], [ -91.000096, 29.169481 ], [ -91.023955, 29.174784 ], [ -91.031786, 29.182188 ], [ -91.058630, 29.181734 ], [ -91.094015, 29.187711 ], [ -91.114760, 29.207918 ], [ -91.129141, 29.215863 ], [ -91.199647, 29.221287 ], [ -91.219032, 29.226051 ], [ -91.278792, 29.247776 ], [ -91.302677, 29.265958 ], [ -91.334885, 29.298775 ], [ -91.332750, 29.305816 ], [ -91.309314, 29.305698 ], [ -91.299054, 29.309017 ], [ -91.291821, 29.311357 ], [ -91.290420, 29.313062 ], [ -91.279742, 29.326058 ], [ -91.276647, 29.329825 ], [ -91.276187, 29.332783 ], [ -91.274308, 29.344878 ], [ -91.270582, 29.355415 ], [ -91.270053, 29.356912 ], [ -91.269940, 29.357231 ], [ -91.266589, 29.361218 ], [ -91.265479, 29.361767 ], [ -91.251546, 29.368659 ], [ -91.251232, 29.368814 ], [ -91.249517, 29.369662 ], [ -91.249109, 29.369864 ], [ -91.245558, 29.370580 ], [ -91.238515, 29.371999 ], [ -91.235348, 29.370638 ], [ -91.222377, 29.360703 ], [ -91.207299, 29.360703 ], [ -91.197465, 29.369882 ], [ -91.200087, 29.389550 ], [ -91.218463, 29.407235 ], [ -91.215976, 29.412505 ], [ -91.214284, 29.416089 ], [ -91.211999, 29.420931 ], [ -91.215100, 29.427542 ], [ -91.217448, 29.432549 ], [ -91.218067, 29.433193 ], [ -91.219242, 29.434418 ], [ -91.221166, 29.436421 ], [ -91.241640, 29.441021 ], [ -91.251319, 29.444483 ], [ -91.258226, 29.446954 ], [ -91.259537, 29.458001 ], [ -91.259844, 29.460582 ], [ -91.259988, 29.461803 ], [ -91.260024, 29.462102 ], [ -91.261588, 29.464954 ], [ -91.265649, 29.472362 ], [ -91.281300, 29.481547 ], [ -91.294325, 29.476894 ], [ -91.335742, 29.485886 ], [ -91.343567, 29.492593 ], [ -91.345880, 29.504538 ], [ -91.356625, 29.515191 ], [ -91.402214, 29.511914 ], [ -91.420449, 29.515745 ], [ -91.427130, 29.520215 ], [ -91.432337, 29.532830 ], [ -91.439941, 29.540434 ], [ -91.447345, 29.544749 ], [ -91.468748, 29.544299 ], [ -91.517274, 29.529740 ], [ -91.531021, 29.531543 ], [ -91.531471, 29.535374 ], [ -91.525840, 29.545946 ], [ -91.525523, 29.551904 ], [ -91.529217, 29.558598 ], [ -91.537445, 29.565888 ], [ -91.541974, 29.594353 ], [ -91.553537, 29.632766 ], [ -91.560908, 29.637350 ], [ -91.570589, 29.638312 ], [ -91.581843, 29.637165 ], [ -91.600179, 29.631156 ], [ -91.625114, 29.626195 ], [ -91.643832, 29.630625 ], [ -91.648941, 29.633635 ], [ -91.648657, 29.636713 ], [ -91.646478, 29.639427 ], [ -91.643198, 29.640274 ], [ -91.637344, 29.647217 ], [ -91.627286, 29.662132 ], [ -91.625114, 29.671679 ], [ -91.626826, 29.684753 ], [ -91.623829, 29.699240 ], [ -91.618479, 29.710816 ], [ -91.618090, 29.720694 ], [ -91.621512, 29.735429 ], [ -91.632829, 29.742576 ], [ -91.667128, 29.745822 ], [ -91.710935, 29.738993 ], [ -91.737253, 29.749370 ], [ -91.752259, 29.748264 ], [ -91.783674, 29.740689 ], [ -91.830499, 29.718918 ], [ -91.845962, 29.708763 ], [ -91.858640, 29.703121 ], [ -91.866516, 29.707150 ], [ -91.880750, 29.710839 ], [ -91.880999, 29.713338 ], [ -91.878331, 29.716087 ], [ -91.875637, 29.722316 ], [ -91.875570, 29.722471 ], [ -91.875570, 29.728043 ], [ -91.878355, 29.735007 ], [ -91.879748, 29.742668 ], [ -91.878355, 29.751025 ], [ -91.874761, 29.760083 ], [ -91.859151, 29.783331 ], [ -91.854677, 29.807436 ], [ -91.869998, 29.828328 ], [ -91.889118, 29.836023 ], [ -91.906890, 29.830940 ], [ -91.915989, 29.815654 ], [ -91.919143, 29.815379 ], [ -91.940723, 29.817008 ], [ -91.961230, 29.810221 ], [ -91.970443, 29.804310 ], [ -91.978381, 29.799217 ], [ -91.983871, 29.794516 ], [ -92.035666, 29.781662 ], [ -92.056398, 29.772313 ], [ -92.107486, 29.744429 ], [ -92.144431, 29.716418 ], [ -92.149349, 29.697052 ], [ -92.134347, 29.669516 ], [ -92.132804, 29.660462 ], [ -92.111787, 29.621770 ], [ -92.093419, 29.618694 ], [ -92.065640, 29.619967 ], [ -92.047670, 29.624527 ], [ -92.025320, 29.625647 ], [ -92.016270, 29.618741 ], [ -92.000371, 29.613143 ], [ -92.000003, 29.613013 ], [ -91.965031, 29.608019 ], [ -91.939903, 29.610291 ], [ -91.935024, 29.612239 ], [ -91.929567, 29.618840 ], [ -91.922825, 29.633173 ], [ -91.898996, 29.637010 ], [ -91.896763, 29.634618 ], [ -91.882318, 29.629770 ], [ -91.866113, 29.631583 ], [ -91.863018, 29.633739 ], [ -91.841294, 29.629620 ], [ -91.838981, 29.624475 ], [ -91.840921, 29.619913 ], [ -91.838297, 29.616041 ], [ -91.821693, 29.606049 ], [ -91.803831, 29.599562 ], [ -91.784976, 29.595204 ], [ -91.778500, 29.589220 ], [ -91.774805, 29.582113 ], [ -91.774686, 29.576387 ], [ -91.746320, 29.574337 ], [ -91.719102, 29.565568 ], [ -91.715642, 29.565844 ], [ -91.712002, 29.564740 ], [ -91.709205, 29.561012 ], [ -91.711654, 29.554270 ], [ -91.733956, 29.539504 ], [ -91.747058, 29.535144 ], [ -91.765448, 29.520844 ], [ -91.771927, 29.504871 ], [ -91.772529, 29.499016 ], [ -91.770069, 29.493812 ], [ -91.770516, 29.488953 ], [ -91.782387, 29.482882 ], [ -91.789119, 29.482081 ], [ -91.800121, 29.486828 ], [ -91.803448, 29.486851 ], [ -91.814609, 29.482061 ], [ -91.821576, 29.473925 ], [ -91.838500, 29.478874 ], [ -91.848665, 29.484144 ], [ -91.852598, 29.494984 ], [ -91.862324, 29.502393 ], [ -91.878746, 29.502937 ], [ -91.886815, 29.505577 ], [ -91.906175, 29.518052 ], [ -91.915322, 29.518513 ], [ -91.947007, 29.533160 ], [ -91.969312, 29.536893 ], [ -91.985726, 29.547708 ], [ -92.026810, 29.566805 ], [ -92.035462, 29.578640 ], [ -92.041168, 29.581648 ], [ -92.046316, 29.584362 ], [ -92.066533, 29.583842 ], [ -92.105923, 29.586335 ], [ -92.158624, 29.581616 ], [ -92.212590, 29.562479 ], [ -92.251860, 29.539354 ], [ -92.280392, 29.533434 ], [ -92.309357, 29.533026 ], [ -92.347236, 29.539394 ], [ -92.402165, 29.551269 ], [ -92.473585, 29.561081 ], [ -92.558602, 29.569935 ], [ -92.616270, 29.578729 ], [ -92.617725, 29.579092 ], [ -92.653651, 29.588065 ], [ -92.744126, 29.617608 ], [ -92.871232, 29.670028 ], [ -92.940455, 29.701033 ], [ -92.974305, 29.713980 ], [ -93.065354, 29.740966 ], [ -93.088182, 29.749125 ], [ -93.176930, 29.770487 ], [ -93.226934, 29.777519 ], [ -93.267456, 29.778113 ], [ -93.295573, 29.775071 ], [ -93.342104, 29.763402 ], [ -93.344993, 29.759618 ], [ -93.347331, 29.759046 ], [ -93.372029, 29.763049 ], [ -93.438973, 29.768949 ], [ -93.475252, 29.769242 ], [ -93.538462, 29.763299 ], [ -93.590786, 29.755649 ], [ -93.635304, 29.752806 ], [ -93.683640, 29.747153 ], [ -93.741948, 29.736343 ], [ -93.766048, 29.729500 ], [ -93.799250, 29.715260 ], [ -93.818995, 29.704076 ], [ -93.837971, 29.690619 ], [ -93.892246, 29.765241 ], [ -93.898470, 29.771577 ], [ -93.890679, 29.843159 ], [ -93.840799, 29.914423 ], [ -93.789431, 29.987812 ], [ -93.756630, 30.014163 ], [ -93.752038, 30.016403 ], [ -93.722481, 30.050898 ], [ -93.721589, 30.051939 ], [ -93.712101, 30.067346 ], [ -93.695684, 30.135729 ], [ -93.695252, 30.147600 ], [ -93.712008, 30.194304 ], [ -93.716223, 30.244318 ], [ -93.720575, 30.295961 ], [ -93.723586, 30.294951 ], [ -93.735896, 30.299440 ], [ -93.765822, 30.333318 ], [ -93.757654, 30.390423 ], [ -93.751437, 30.396288 ], [ -93.741701, 30.403007 ], [ -93.702665, 30.429947 ], [ -93.698302, 30.438657 ], [ -93.697828, 30.443838 ], [ -93.710117, 30.506400 ], [ -93.740045, 30.538765 ], [ -93.727844, 30.574070 ], [ -93.578395, 30.802047 ], [ -93.563292, 30.818503 ], [ -93.558672, 30.868829 ], [ -93.558617, 30.869424 ], [ -93.554970, 30.876685 ], [ -93.554576, 30.877470 ], [ -93.530936, 30.924534 ], [ -93.540354, 31.008135 ], [ -93.527644, 31.074509 ], [ -93.531744, 31.180817 ], [ -93.535097, 31.185614 ], [ -93.548931, 31.186601 ], [ -93.552540, 31.185605 ], [ -93.552649, 31.185575 ], [ -93.579215, 31.167422 ], [ -93.588503, 31.165581 ], [ -93.598828, 31.174679 ], [ -93.599705, 31.176456 ], [ -93.602315, 31.181742 ], [ -93.607243, 31.204806 ], [ -93.608158, 31.227835 ], [ -93.614402, 31.260869 ], [ -93.620829, 31.271299 ], [ -93.644407, 31.277110 ], [ -93.671676, 31.299586 ], [ -93.640805, 31.372546 ], [ -93.670182, 31.387184 ], [ -93.695866, 31.409392 ], [ -93.729613, 31.487922 ], [ -93.798087, 31.534044 ], [ -93.818582, 31.554826 ], [ -93.834923, 31.586210 ], [ -93.834924, 31.586211 ], [ -93.826290, 31.614903 ], [ -93.817059, 31.671694 ], [ -93.812477, 31.715246 ], [ -93.840029, 31.800596 ], [ -93.878225, 31.844276 ], [ -93.889193, 31.856819 ], [ -93.920290, 31.888651 ], [ -93.932135, 31.893672 ], [ -93.975377, 31.923660 ], [ -94.015630, 31.979856 ], [ -94.042720, 31.999265 ], [ -94.042700, 32.056012 ], [ -94.042337, 32.119914 ], [ -94.042681, 32.137956 ], [ -94.042591, 32.158097 ], [ -94.042539, 32.166826 ], [ -94.042566, 32.166894 ], [ -94.042621, 32.196005 ], [ -94.042662, 32.218146 ], [ -94.042732, 32.269620 ], [ -94.042733, 32.269696 ], [ -94.042739, 32.363559 ], [ -94.042763, 32.373332 ], [ -94.042901, 32.392283 ], [ -94.042923, 32.399918 ], [ -94.042899, 32.400659 ], [ -94.042986, 32.435507 ], [ -94.042908, 32.439891 ], [ -94.042903, 32.470386 ], [ -94.042875, 32.471348 ], [ -94.042902, 32.472906 ], [ -94.042995, 32.478004 ], [ -94.042955, 32.480261 ], [ -94.043072, 32.484300 ], [ -94.043089, 32.486561 ], [ -94.042911, 32.492852 ], [ -94.042885, 32.505145 ], [ -94.043081, 32.513613 ], [ -94.043142, 32.559502 ], [ -94.043083, 32.564261 ], [ -94.042919, 32.610142 ], [ -94.042929, 32.618260 ], [ -94.042926, 32.622015 ], [ -94.042824, 32.640305 ], [ -94.042780, 32.643466 ], [ -94.042913, 32.655127 ], [ -94.043147, 32.693030 ] ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US27", "STATE": 11, "name": "Minnesota", "LSAD": "", "CENSUSAREA": 79626.743000 }, "geometry": { "type": "Polygon", "coordinates": [ [ [ -92.191501, 46.672586 ], [ -92.197145, 46.663408 ], [ -92.202292, 46.655041 ], [ -92.207092, 46.651941 ], [ -92.212392, 46.649941 ], [ -92.221731, 46.649724 ], [ -92.222338, 46.649710 ], [ -92.228155, 46.649574 ], [ -92.231944, 46.649486 ], [ -92.232647, 46.649470 ], [ -92.234815, 46.649420 ], [ -92.242493, 46.649241 ], [ -92.250861, 46.650061 ], [ -92.254379, 46.650405 ], [ -92.256654, 46.650628 ], [ -92.262503, 46.651201 ], [ -92.264462, 46.651393 ], [ -92.269948, 46.651930 ], [ -92.274465, 46.654227 ], [ -92.276373, 46.655198 ], [ -92.277155, 46.655596 ], [ -92.292192, 46.663242 ], [ -92.291597, 46.624941 ], [ -92.291647, 46.604649 ], [ -92.292371, 46.495585 ], [ -92.292510, 46.478761 ], [ -92.292727, 46.431993 ], [ -92.292847, 46.420876 ], [ -92.292860, 46.417220 ], [ -92.292999, 46.321894 ], [ -92.292782, 46.319312 ], [ -92.292803, 46.314628 ], [ -92.292880, 46.313752 ], [ -92.292839, 46.307107 ], [ -92.292840, 46.304319 ], [ -92.293007, 46.297987 ], [ -92.293074, 46.295129 ], [ -92.293619, 46.244043 ], [ -92.293558, 46.224578 ], [ -92.293857, 46.180073 ], [ -92.293744, 46.166838 ], [ -92.293706, 46.157321 ], [ -92.293530, 46.113824 ], [ -92.294069, 46.078346 ], [ -92.294033, 46.074377 ], [ -92.306756, 46.072410 ], [ -92.326877, 46.066618 ], [ -92.443285, 46.014648 ], [ -92.656125, 45.924442 ], [ -92.707702, 45.894901 ], [ -92.721128, 45.883805 ], [ -92.734039, 45.868108 ], [ -92.762490, 45.819239 ], [ -92.768430, 45.798010 ], [ -92.784621, 45.764196 ], [ -92.803971, 45.749805 ], [ -92.841051, 45.730024 ], [ -92.863703, 45.721820 ], [ -92.869193, 45.717568 ], [ -92.883987, 45.654870 ], [ -92.885661, 45.644126 ], [ -92.888114, 45.628377 ], [ -92.886421, 45.594881 ], [ -92.883749, 45.575483 ], [ -92.871082, 45.567581 ], [ -92.823309, 45.560934 ], [ -92.803432, 45.562500 ], [ -92.726230, 45.531085 ], [ -92.680234, 45.464344 ], [ -92.664102, 45.393309 ], [ -92.704794, 45.326526 ], [ -92.732594, 45.304224 ], [ -92.746139, 45.296046 ], [ -92.751735, 45.292667 ], [ -92.760615, 45.278827 ], [ -92.765898, 45.210173 ], [ -92.767130, 45.194165 ], [ -92.792875, 45.078489 ], [ -92.791206, 45.045698 ], [ -92.768606, 45.008016 ], [ -92.750645, 44.937299 ], [ -92.761677, 44.862022 ], [ -92.761845, 44.860879 ], [ -92.765461, 44.836202 ], [ -92.784443, 44.793958 ], [ -92.802201, 44.745714 ], [ -92.802402, 44.745167 ], [ -92.737259, 44.717155 ], [ -92.732042, 44.713775 ], [ -92.632105, 44.649027 ], [ -92.621733, 44.638983 ], [ -92.619774, 44.629214 ], [ -92.549685, 44.576000 ], [ -92.534186, 44.570375 ], [ -92.491773, 44.566003 ], [ -92.357313, 44.558480 ], [ -92.340058, 44.555273 ], [ -92.329013, 44.550895 ], [ -92.319938, 44.544940 ], [ -92.316425, 44.540792 ], [ -92.314071, 44.538014 ], [ -92.303046, 44.518646 ], [ -92.302215, 44.500298 ], [ -92.291005, 44.485464 ], [ -92.276784, 44.473649 ], [ -92.242010, 44.454254 ], [ -92.233897, 44.446334 ], [ -92.221083, 44.440386 ], [ -92.115296, 44.416056 ], [ -92.083925, 44.406211 ], [ -92.046285, 44.394398 ], [ -91.972493, 44.366760 ], [ -91.963600, 44.362112 ], [ -91.925590, 44.333548 ], [ -91.918625, 44.322671 ], [ -91.887189, 44.252513 ], [ -91.887905, 44.246398 ], [ -91.892963, 44.235149 ], [ -91.892698, 44.231105 ], [ -91.875158, 44.200575 ], [ -91.862858, 44.193001 ], [ -91.808064, 44.159262 ], [ -91.740871, 44.133918 ], [ -91.721552, 44.130342 ], [ -91.672520, 44.091286 ], [ -91.592070, 44.031372 ], [ -91.580019, 44.026925 ], [ -91.559197, 44.023959 ], [ -91.547028, 44.022226 ], [ -91.505918, 44.018651 ], [ -91.463515, 44.009041 ], [ -91.437380, 43.999962 ], [ -91.432522, 43.996827 ], [ -91.420114, 43.984243 ], [ -91.363242, 43.926563 ], [ -91.310991, 43.867381 ], [ -91.298815, 43.856555 ], [ -91.284138, 43.847065 ], [ -91.262436, 43.792166 ], [ -91.268198, 43.726571 ], [ -91.273316, 43.668307 ], [ -91.268748, 43.615348 ], [ -91.265091, 43.609977 ], [ -91.217706, 43.500550 ], [ -91.369325, 43.500827 ], [ -91.371608, 43.500945 ], [ -91.376950, 43.500482 ], [ -91.441786, 43.500438 ], [ -91.445932, 43.500588 ], [ -91.461403, 43.500642 ], [ -91.465063, 43.500608 ], [ -91.491042, 43.500690 ], [ -91.533806, 43.500560 ], [ -91.541220, 43.500515 ], [ -91.551021, 43.500539 ], [ -91.591073, 43.500536 ], [ -91.610832, 43.500530 ], [ -91.610895, 43.500530 ], [ -91.615293, 43.500550 ], [ -91.616895, 43.500663 ], [ -91.617407, 43.500687 ], [ -91.620785, 43.500677 ], [ -91.625611, 43.500727 ], [ -91.634244, 43.500479 ], [ -91.634495, 43.500439 ], [ -91.635626, 43.500463 ], [ -91.639772, 43.500573 ], [ -91.644924, 43.500529 ], [ -91.651396, 43.500454 ], [ -91.658401, 43.500533 ], [ -91.670872, 43.500513 ], [ -91.700749, 43.500581 ], [ -91.730217, 43.500680 ], [ -91.730359, 43.500680 ], [ -91.733330, 43.500623 ], [ -91.736558, 43.500561 ], [ -91.738446, 43.500525 ], [ -91.761414, 43.500637 ], [ -91.777688, 43.500711 ], [ -91.779290, 43.500803 ], [ -91.804925, 43.500716 ], [ -91.807156, 43.500648 ], [ -91.824848, 43.500684 ], [ -91.941837, 43.500554 ], [ -91.949879, 43.500485 ], [ -92.079802, 43.500647 ], [ -92.079954, 43.500647 ], [ -92.089970, 43.500684 ], [ -92.103886, 43.500735 ], [ -92.178863, 43.500713 ], [ -92.198788, 43.500527 ], [ -92.277425, 43.500466 ], [ -92.279084, 43.500436 ], [ -92.368908, 43.500454 ], [ -92.388298, 43.500483 ], [ -92.406130, 43.500476 ], [ -92.408832, 43.500614 ], [ -92.448948, 43.500420 ], [ -92.464505, 43.500345 ], [ -92.553128, 43.500300 ], [ -92.553161, 43.500300 ], [ -92.649194, 43.500049 ], [ -92.653318, 43.500050 ], [ -92.672580, 43.500055 ], [ -92.689033, 43.500062 ], [ -92.692786, 43.500063 ], [ -92.707312, 43.500069 ], [ -92.752088, 43.500084 ], [ -92.790317, 43.499567 ], [ -92.870277, 43.499548 ], [ -93.007871, 43.499604 ], [ -93.024348, 43.499572 ], [ -93.024429, 43.499572 ], [ -93.049192, 43.499571 ], [ -93.228861, 43.499567 ], [ -93.271800, 43.499356 ], [ -93.399035, 43.499485 ], [ -93.428509, 43.499478 ], [ -93.468563, 43.499473 ], [ -93.472804, 43.499400 ], [ -93.482009, 43.499482 ], [ -93.488261, 43.499417 ], [ -93.497350, 43.499456 ], [ -93.497405, 43.499456 ], [ -93.528482, 43.499471 ], [ -93.532178, 43.499472 ], [ -93.558631, 43.499521 ], [ -93.576728, 43.499520 ], [ -93.617131, 43.499548 ], [ -93.648533, 43.499559 ], [ -93.699345, 43.499576 ], [ -93.704916, 43.499568 ], [ -93.708771, 43.499564 ], [ -93.716217, 43.499563 ], [ -93.794285, 43.499542 ], [ -93.795793, 43.499520 ], [ -93.970760, 43.499605 ], [ -93.970762, 43.499605 ], [ -94.092894, 43.500302 ], [ -94.094339, 43.500302 ], [ -94.108068, 43.500300 ], [ -94.109880, 43.500283 ], [ -94.247965, 43.500333 ], [ -94.377466, 43.500379 ], [ -94.390597, 43.500469 ], [ -94.442835, 43.500583 ], [ -94.442848, 43.500583 ], [ -94.447048, 43.500639 ], [ -94.470420, 43.500340 ], [ -94.560838, 43.500377 ], [ -94.565665, 43.500330 ], [ -94.615916, 43.500544 ], [ -94.854555, 43.500614 ], [ -94.857867, 43.500615 ], [ -94.860192, 43.500546 ], [ -94.872725, 43.500564 ], [ -94.874235, 43.500557 ], [ -94.887291, 43.500502 ], [ -94.914523, 43.500450 ], [ -94.914634, 43.500450 ], [ -94.914905, 43.500450 ], [ -94.914955, 43.500450 ], [ -94.934625, 43.500490 ], [ -94.954477, 43.500467 ], [ -94.974359, 43.500508 ], [ -94.994460, 43.500523 ], [ -95.014245, 43.500872 ], [ -95.034000, 43.500811 ], [ -95.053504, 43.500769 ], [ -95.054289, 43.500860 ], [ -95.114874, 43.500667 ], [ -95.122633, 43.500755 ], [ -95.167294, 43.500771 ], [ -95.167891, 43.500885 ], [ -95.180423, 43.500774 ], [ -95.214938, 43.500885 ], [ -95.250762, 43.500406 ], [ -95.250969, 43.500464 ], [ -95.374737, 43.500314 ], [ -95.375269, 43.500322 ], [ -95.387787, 43.500240 ], [ -95.387812, 43.500240 ], [ -95.387851, 43.500240 ], [ -95.434199, 43.500314 ], [ -95.434293, 43.500360 ], [ -95.454433, 43.500644 ], [ -95.454706, 43.500648 ], [ -95.454706, 43.500563 ], [ -95.475065, 43.500335 ], [ -95.486737, 43.500274 ], [ -95.486803, 43.500246 ], [ -95.514774, 43.499865 ], [ -95.740813, 43.499894 ], [ -95.741569, 43.499891 ], [ -95.821277, 43.499965 ], [ -95.834421, 43.499966 ], [ -95.860946, 43.499966 ], [ -95.861152, 43.499966 ], [ -96.053163, 43.500176 ], [ -96.198484, 43.500335 ], [ -96.198766, 43.500312 ], [ -96.208814, 43.500391 ], [ -96.332062, 43.500415 ], [ -96.351059, 43.500333 ], [ -96.453049, 43.500415 ], [ -96.453352, 43.587040 ], [ -96.453383, 43.588183 ], [ -96.453356, 43.607544 ], [ -96.453387, 43.609944 ], [ -96.453408, 43.675008 ], [ -96.453380, 43.689637 ], [ -96.453281, 43.791435 ], [ -96.453088, 43.805123 ], [ -96.453264, 43.849501 ], [ -96.453264, 43.849506 ], [ -96.453264, 43.849604 ], [ -96.453335, 43.877029 ], [ -96.453304, 43.878583 ], [ -96.453183, 43.878650 ], [ -96.453352, 43.949122 ], [ -96.453289, 43.950814 ], [ -96.453165, 43.966540 ], [ -96.453292, 43.967180 ], [ -96.453389, 43.978060 ], [ -96.453263, 43.980277 ], [ -96.453328, 43.992871 ], [ -96.453297, 43.994723 ], [ -96.453116, 44.006876 ], [ -96.453053, 44.008887 ], [ -96.453373, 44.023744 ], [ -96.453405, 44.025413 ], [ -96.453313, 44.036430 ], [ -96.453187, 44.038350 ], [ -96.452774, 44.196780 ], [ -96.452774, 44.196895 ], [ -96.452673, 44.254588 ], [ -96.452419, 44.255274 ], [ -96.452369, 44.268967 ], [ -96.452365, 44.271972 ], [ -96.452617, 44.282702 ], [ -96.452500, 44.285687 ], [ -96.452334, 44.297009 ], [ -96.452239, 44.298655 ], [ -96.452369, 44.312071 ], [ -96.452248, 44.313362 ], [ -96.452372, 44.325991 ], [ -96.452309, 44.328094 ], [ -96.452248, 44.340642 ], [ -96.452152, 44.342219 ], [ -96.452305, 44.345332 ], [ -96.452282, 44.354857 ], [ -96.452213, 44.360149 ], [ -96.452134, 44.383679 ], [ -96.452073, 44.389690 ], [ -96.451924, 44.441549 ], [ -96.451816, 44.460402 ], [ -96.452218, 44.470873 ], [ -96.452122, 44.473043 ], [ -96.451974, 44.506849 ], [ -96.452010, 44.516929 ], [ -96.452236, 44.526871 ], [ -96.452016, 44.543533 ], [ -96.451990, 44.543639 ], [ -96.451888, 44.544058 ], [ -96.451720, 44.630708 ], [ -96.451761, 44.631194 ], [ -96.451761, 44.631350 ], [ -96.451543, 44.703135 ], [ -96.451573, 44.760510 ], [ -96.451380, 44.761788 ], [ -96.451620, 44.776191 ], [ -96.451823, 44.790471 ], [ -96.451888, 44.792299 ], [ -96.451829, 44.797691 ], [ -96.451559, 44.805468 ], [ -96.451560, 44.805569 ], [ -96.452009, 44.890080 ], [ -96.451853, 44.906672 ], [ -96.452047, 44.910695 ], [ -96.452347, 44.962734 ], [ -96.452092, 44.977475 ], [ -96.452092, 44.977494 ], [ -96.452240, 45.042347 ], [ -96.452177, 45.050185 ], [ -96.452210, 45.051602 ], [ -96.452219, 45.093836 ], [ -96.452026, 45.095138 ], [ -96.452418, 45.122677 ], [ -96.452353, 45.124071 ], [ -96.452304, 45.178563 ], [ -96.452162, 45.203109 ], [ -96.452152, 45.204849 ], [ -96.452315, 45.208986 ], [ -96.452948, 45.268925 ], [ -96.452949, 45.269059 ], [ -96.452791, 45.284280 ], [ -96.453067, 45.298115 ], [ -96.454094, 45.301546 ], [ -96.470020, 45.326832 ], [ -96.489065, 45.357071 ], [ -96.521787, 45.375645 ], [ -96.617726, 45.408092 ], [ -96.680454, 45.410499 ], [ -96.692541, 45.417338 ], [ -96.732739, 45.458737 ], [ -96.742509, 45.478723 ], [ -96.745487, 45.488712 ], [ -96.765280, 45.521414 ], [ -96.784863, 45.541300 ], [ -96.835451, 45.586129 ], [ -96.843957, 45.594003 ], [ -96.844334, 45.594375 ], [ -96.849444, 45.598944 ], [ -96.853646, 45.602307 ], [ -96.857751, 45.605962 ], [ -96.844211, 45.639583 ], [ -96.840746, 45.645294 ], [ -96.835769, 45.649648 ], [ -96.745086, 45.701576 ], [ -96.711157, 45.717561 ], [ -96.672665, 45.732336 ], [ -96.652226, 45.746809 ], [ -96.583085, 45.820024 ], [ -96.579740, 45.825820 ], [ -96.576544, 45.839945 ], [ -96.572984, 45.861602 ], [ -96.568772, 45.888072 ], [ -96.568281, 45.891203 ], [ -96.568053, 45.898697 ], [ -96.568315, 45.902902 ], [ -96.568918, 45.911426 ], [ -96.569265, 45.911471 ], [ -96.569401, 45.913946 ], [ -96.569069, 45.914785 ], [ -96.564317, 45.921074 ], [ -96.564518, 45.926256 ], [ -96.563280, 45.935238 ], [ -96.570350, 45.963595 ], [ -96.577326, 46.021757 ], [ -96.577940, 46.026874 ], [ -96.566295, 46.051416 ], [ -96.559271, 46.058272 ], [ -96.556940, 46.064601 ], [ -96.554835, 46.084824 ], [ -96.557952, 46.102442 ], [ -96.578362, 46.170112 ], [ -96.585647, 46.177309 ], [ -96.599087, 46.263701 ], [ -96.598233, 46.312563 ], [ -96.631586, 46.353752 ], [ -96.669794, 46.384644 ], [ -96.721999, 46.439986 ], [ -96.716438, 46.444567 ], [ -96.739054, 46.543708 ], [ -96.783003, 46.630405 ], [ -96.783009, 46.630418 ], [ -96.783014, 46.630647 ], [ -96.784205, 46.686768 ], [ -96.802013, 46.812464 ], [ -96.767458, 46.905163 ], [ -96.780258, 46.928263 ], [ -96.791558, 46.934264 ], [ -96.823222, 46.970861 ], [ -96.824598, 46.993309 ], [ -96.823180, 46.999965 ], [ -96.824807, 47.124968 ], [ -96.826655, 47.150539 ], [ -96.832946, 47.237588 ], [ -96.833019, 47.238095 ], [ -96.852676, 47.374973 ], [ -96.862312, 47.422333 ], [ -96.853768, 47.499527 ], [ -96.853286, 47.503881 ], [ -96.842430, 47.508225 ], [ -96.850955, 47.598287 ], [ -96.885740, 47.664266 ], [ -96.890671, 47.672153 ], [ -96.980391, 47.815662 ], [ -97.000356, 47.860915 ], [ -97.023156, 47.873978 ], [ -97.088158, 48.059515 ], [ -97.098275, 48.071310 ], [ -97.123135, 48.109497 ], [ -97.147510, 48.170572 ], [ -97.147498, 48.173227 ], [ -97.147401, 48.193779 ], [ -97.147170, 48.242966 ], [ -97.143148, 48.246708 ], [ -97.134534, 48.249737 ], [ -97.129930, 48.249731 ], [ -97.116570, 48.279661 ], [ -97.115581, 48.323928 ], [ -97.126745, 48.342140 ], [ -97.136373, 48.352393 ], [ -97.145693, 48.397431 ], [ -97.131479, 48.406586 ], [ -97.123399, 48.421201 ], [ -97.126770, 48.520191 ], [ -97.150541, 48.539449 ], [ -97.161110, 48.543155 ], [ -97.163105, 48.543855 ], [ -97.163050, 48.543963 ], [ -97.092606, 48.682033 ], [ -97.137571, 48.749191 ], [ -97.157797, 48.787680 ], [ -97.199549, 48.881183 ], [ -97.232610, 48.946561 ], [ -97.239155, 48.967596 ], [ -97.238387, 48.982631 ], [ -97.234005, 48.997470 ], [ -97.229039, 49.000687 ], [ -96.405412, 48.999820 ], [ -95.368698, 48.998729 ], [ -95.355819, 48.998735 ], [ -95.340962, 48.998740 ], [ -95.322946, 48.998767 ], [ -95.319895, 48.998769 ], [ -95.153711, 48.998903 ], [ -95.153309, 49.184880 ], [ -95.153424, 49.249995 ], [ -95.153333, 49.305655 ], [ -95.153319, 49.307720 ], [ -95.153331, 49.308442 ], [ -95.153330, 49.309287 ], [ -95.153284, 49.343409 ], [ -95.153344, 49.343662 ], [ -95.153407, 49.354397 ], [ -95.153330, 49.365886 ], [ -95.153259, 49.367691 ], [ -95.153293, 49.369107 ], [ -95.153350, 49.383079 ], [ -95.153314, 49.384358 ], [ -95.126467, 49.369439 ], [ -95.058404, 49.353170 ], [ -95.014415, 49.356405 ], [ -94.988908, 49.368897 ], [ -94.957465, 49.370186 ], [ -94.909273, 49.350176 ], [ -94.824291, 49.308834 ], [ -94.797527, 49.197791 ], [ -94.773223, 49.120733 ], [ -94.750221, 49.099763 ], [ -94.750218, 48.999992 ], [ -94.718932, 48.999991 ], [ -94.683069, 48.883929 ], [ -94.683127, 48.883376 ], [ -94.690302, 48.863711 ], [ -94.690246, 48.863363 ], [ -94.690889, 48.778066 ], [ -94.690863, 48.778047 ], [ -94.646256, 48.749975 ], [ -94.645150, 48.748991 ], [ -94.628854, 48.738789 ], [ -94.533057, 48.701262 ], [ -94.468728, 48.696324 ], [ -94.431854, 48.706588 ], [ -94.416191, 48.710948 ], [ -94.388848, 48.711945 ], [ -94.308446, 48.710239 ], [ -94.290737, 48.707747 ], [ -94.260541, 48.696381 ], [ -94.251169, 48.683514 ], [ -94.250497, 48.656654 ], [ -94.250191, 48.656323 ], [ -94.244394, 48.653442 ], [ -94.224276, 48.649527 ], [ -94.126336, 48.644447 ], [ -94.052452, 48.644020 ], [ -93.840754, 48.628548 ], [ -93.834323, 48.624954 ], [ -93.822644, 48.609067 ], [ -93.806763, 48.577616 ], [ -93.805369, 48.568393 ], [ -93.811201, 48.542385 ], [ -93.818375, 48.534442 ], [ -93.818253, 48.530046 ], [ -93.815178, 48.526508 ], [ -93.794454, 48.516021 ], [ -93.771741, 48.515825 ], [ -93.756483, 48.515366 ], [ -93.662337, 48.515708 ], [ -93.544361, 48.529109 ], [ -93.467504, 48.545664 ], [ -93.460798, 48.550552 ], [ -93.456675, 48.561834 ], [ -93.457046, 48.567199 ], [ -93.461731, 48.574030 ], [ -93.466007, 48.587291 ], [ -93.464308, 48.591792 ], [ -93.403660, 48.607593 ], [ -93.367025, 48.608283 ], [ -93.347528, 48.626620 ], [ -93.254854, 48.642784 ], [ -93.207398, 48.642474 ], [ -93.179990, 48.624926 ], [ -93.142420, 48.624924 ], [ -93.088438, 48.627597 ], [ -92.980484, 48.624915 ], [ -92.728046, 48.539290 ], [ -92.657881, 48.546263 ], [ -92.634931, 48.542873 ], [ -92.625739, 48.518189 ], [ -92.625151, 48.513048 ], [ -92.625374, 48.512916 ], [ -92.631117, 48.508252 ], [ -92.631137, 48.508077 ], [ -92.627237, 48.503383 ], [ -92.636696, 48.499428 ], [ -92.661418, 48.496557 ], [ -92.684866, 48.497611 ], [ -92.698824, 48.494892 ], [ -92.712562, 48.463013 ], [ -92.687998, 48.443889 ], [ -92.656027, 48.436709 ], [ -92.575636, 48.440827 ], [ -92.537202, 48.447703 ], [ -92.507285, 48.447875 ], [ -92.456325, 48.414204 ], [ -92.415121, 48.293841 ], [ -92.384387, 48.242914 ], [ -92.325304, 48.237030 ], [ -92.295053, 48.276587 ], [ -92.295668, 48.278118 ], [ -92.301451, 48.288608 ], [ -92.306309, 48.316442 ], [ -92.304561, 48.322977 ], [ -92.288994, 48.342991 ], [ -92.262280, 48.354933 ], [ -92.055228, 48.359213 ], [ -92.030872, 48.325824 ], [ -91.989545, 48.260214 ], [ -91.977555, 48.247140 ], [ -91.977486, 48.246340 ], [ -91.954432, 48.251678 ], [ -91.954397, 48.251199 ], [ -91.907597, 48.238183 ], [ -91.906967, 48.237770 ], [ -91.867641, 48.218341 ], [ -91.798268, 48.200086 ], [ -91.789693, 48.197829 ], [ -91.742313, 48.204491 ], [ -91.714931, 48.199130 ], [ -91.710519, 48.193898 ], [ -91.699336, 48.144728 ], [ -91.708099, 48.122985 ], [ -91.712226, 48.116883 ], [ -91.711850, 48.114598 ], [ -91.641062, 48.097703 ], [ -91.569746, 48.093348 ], [ -91.488067, 48.068111 ], [ -91.340159, 48.073236 ], [ -91.328738, 48.070588 ], [ -91.290215, 48.073945 ], [ -91.266380, 48.078713 ], [ -91.250112, 48.084087 ], [ -91.176181, 48.125811 ], [ -91.140773, 48.147689 ], [ -91.138311, 48.151024 ], [ -91.138482, 48.151458 ], [ -91.035858, 48.189436 ], [ -91.035550, 48.189459 ], [ -91.032942, 48.190794 ], [ -90.976955, 48.219452 ], [ -90.885480, 48.245784 ], [ -90.847352, 48.244443 ], [ -90.843624, 48.243576 ], [ -90.839176, 48.239511 ], [ -90.804207, 48.177833 ], [ -90.789776, 48.143472 ], [ -90.795308, 48.135523 ], [ -90.793841, 48.135569 ], [ -90.776133, 48.122481 ], [ -90.775962, 48.122229 ], [ -90.774225, 48.118894 ], [ -90.774191, 48.118575 ], [ -90.761625, 48.098283 ], [ -90.751608, 48.090968 ], [ -90.569763, 48.106951 ], [ -90.495637, 48.099444 ], [ -90.495398, 48.099787 ], [ -90.452022, 48.105006 ], [ -90.403219, 48.105114 ], [ -90.344234, 48.094447 ], [ -90.343484, 48.095064 ], [ -90.337177, 48.099771 ], [ -90.330052, 48.102399 ], [ -90.312386, 48.105300 ], [ -90.176605, 48.112445 ], [ -90.136191, 48.112136 ], [ -90.125090, 48.107702 ], [ -90.123900, 48.107131 ], [ -90.091639, 48.104630 ], [ -90.073873, 48.101138 ], [ -90.023595, 48.084708 ], [ -89.997852, 48.057567 ], [ -89.993822, 48.049027 ], [ -89.996702, 48.035391 ], [ -89.993050, 48.028404 ], [ -89.968255, 48.014482 ], [ -89.897414, 47.987599 ], [ -89.873286, 47.985419 ], [ -89.847571, 47.992442 ], [ -89.819802, 48.015099 ], [ -89.763967, 48.022969 ], [ -89.749314, 48.023325 ], [ -89.724184, 48.019818 ], [ -89.687891, 48.010826 ], [ -89.655793, 48.007532 ], [ -89.564288, 48.002930 ], [ -89.489226, 48.014528 ], [ -89.491739, 48.005212 ], [ -89.495344, 48.002356 ], [ -89.541521, 47.992841 ], [ -89.551555, 47.987305 ], [ -89.552939, 47.980731 ], [ -89.555015, 47.974849 ], [ -89.572315, 47.967238 ], [ -89.588230, 47.966200 ], [ -89.595890, 47.971046 ], [ -89.611412, 47.980731 ], [ -89.624559, 47.983153 ], [ -89.631825, 47.980039 ], [ -89.637015, 47.973465 ], [ -89.640129, 47.967930 ], [ -89.639844, 47.959826 ], [ -89.638285, 47.954275 ], [ -89.639545, 47.953590 ], [ -89.660616, 47.951216 ], [ -89.697619, 47.941288 ], [ -89.729730, 47.925245 ], [ -89.737539, 47.918183 ], [ -89.758714, 47.906993 ], [ -89.793539, 47.891358 ], [ -89.853960, 47.873997 ], [ -89.871580, 47.874194 ], [ -89.923649, 47.862062 ], [ -89.930844, 47.857723 ], [ -89.927520, 47.850825 ], [ -89.933899, 47.846760 ], [ -89.974296, 47.830514 ], [ -90.013730, 47.821373 ], [ -90.042761, 47.817568 ], [ -90.072025, 47.811105 ], [ -90.072241, 47.807727 ], [ -90.075559, 47.803303 ], [ -90.082354, 47.803619 ], [ -90.088160, 47.803041 ], [ -90.116800, 47.795380 ], [ -90.132078, 47.795720 ], [ -90.160790, 47.792807 ], [ -90.178755, 47.786414 ], [ -90.187636, 47.778130 ], [ -90.229145, 47.776198 ], [ -90.248794, 47.772763 ], [ -90.295952, 47.759054 ], [ -90.306340, 47.756627 ], [ -90.313958, 47.756681 ], [ -90.323446, 47.753771 ], [ -90.330254, 47.750892 ], [ -90.332686, 47.746387 ], [ -90.386234, 47.741100 ], [ -90.393823, 47.738271 ], [ -90.421390, 47.735150 ], [ -90.437712, 47.731612 ], [ -90.441912, 47.726404 ], [ -90.458365, 47.721400 ], [ -90.537105, 47.703055 ], [ -90.551291, 47.690266 ], [ -90.584954, 47.680740 ], [ -90.647837, 47.656176 ], [ -90.686382, 47.643594 ], [ -90.735927, 47.624343 ], [ -90.868270, 47.556900 ], [ -90.907494, 47.532873 ], [ -90.910127, 47.530178 ], [ -90.909801, 47.526215 ], [ -90.914247, 47.522639 ], [ -90.919375, 47.519784 ], [ -90.927975, 47.519008 ], [ -90.939072, 47.514532 ], [ -91.023124, 47.464964 ], [ -91.023125, 47.464964 ], [ -91.032945, 47.458236 ], [ -91.045646, 47.456525 ], [ -91.077712, 47.428767 ], [ -91.097569, 47.413888 ], [ -91.106218, 47.411806 ], [ -91.128131, 47.399619 ], [ -91.131268, 47.393567 ], [ -91.146958, 47.381464 ], [ -91.156513, 47.378816 ], [ -91.170037, 47.366266 ], [ -91.188772, 47.340082 ], [ -91.206248, 47.329182 ], [ -91.238658, 47.304976 ], [ -91.250163, 47.290490 ], [ -91.262512, 47.279290 ], [ -91.265950, 47.279479 ], [ -91.270697, 47.277134 ], [ -91.288478, 47.265960 ], [ -91.326019, 47.238993 ], [ -91.353850, 47.212686 ], [ -91.357803, 47.206743 ], [ -91.374191, 47.197800 ], [ -91.387021, 47.187293 ], [ -91.398455, 47.183916 ], [ -91.418805, 47.172152 ], [ -91.452031, 47.145158 ], [ -91.456965, 47.139156 ], [ -91.477351, 47.125667 ], [ -91.497902, 47.122579 ], [ -91.506998, 47.118489 ], [ -91.518793, 47.108121 ], [ -91.573817, 47.089917 ], [ -91.591508, 47.068684 ], [ -91.600969, 47.063425 ], [ -91.604949, 47.063309 ], [ -91.613173, 47.059192 ], [ -91.626824, 47.049953 ], [ -91.637164, 47.040429 ], [ -91.644564, 47.026491 ], [ -91.660248, 47.019288 ], [ -91.666477, 47.014297 ], [ -91.704649, 47.005246 ], [ -91.737098, 46.982853 ], [ -91.777300, 46.951799 ], [ -91.780675, 46.945881 ], [ -91.794039, 46.939676 ], [ -91.806851, 46.933727 ], [ -91.826068, 46.927199 ], [ -91.834852, 46.927135 ], [ -91.841349, 46.925215 ], [ -91.871286, 46.908352 ], [ -91.883238, 46.905728 ], [ -91.906483, 46.891236 ], [ -91.914984, 46.883836 ], [ -91.952985, 46.867037 ], [ -91.985086, 46.849637 ], [ -91.997987, 46.838737 ], [ -92.013405, 46.833727 ], [ -92.058888, 46.809938 ], [ -92.062088, 46.804038 ], [ -92.086089, 46.794339 ], [ -92.094089, 46.787839 ], [ -92.088289, 46.773639 ], [ -92.064490, 46.745439 ], [ -92.025789, 46.710839 ], [ -92.015290, 46.706469 ], [ -92.020289, 46.704039 ], [ -92.024720, 46.705624 ], [ -92.033990, 46.708939 ], [ -92.089490, 46.749240 ], [ -92.116590, 46.748640 ], [ -92.170413, 46.725553 ], [ -92.172997, 46.724444 ], [ -92.189091, 46.717541 ], [ -92.195321, 46.709626 ], [ -92.196264, 46.703966 ], [ -92.196435, 46.702938 ], [ -92.196575, 46.702100 ], [ -92.194562, 46.697672 ], [ -92.194087, 46.696626 ], [ -92.193439, 46.695202 ], [ -92.187795, 46.690185 ], [ -92.187592, 46.678941 ], [ -92.191075, 46.673278 ], [ -92.191501, 46.672586 ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US28", "STATE": 12, "name": "Mississippi", "LSAD": "", "CENSUSAREA": 46923.274000 }, "geometry": { "type": "MultiPolygon", "coordinates": [ [ [ [ -89.095623, 30.231767 ], [ -89.077259, 30.231680 ], [ -89.067128, 30.250199 ], [ -89.063989, 30.246299 ], [ -89.065097, 30.239929 ], [ -89.073538, 30.223318 ], [ -89.091469, 30.202305 ], [ -89.118222, 30.223343 ], [ -89.156738, 30.230699 ], [ -89.095623, 30.231767 ] ] ], [ [ [ -88.900370, 30.224576 ], [ -88.909752, 30.220405 ], [ -88.945498, 30.209646 ], [ -88.974672, 30.207391 ], [ -88.980239, 30.207962 ], [ -88.984249, 30.210320 ], [ -88.982219, 30.211627 ], [ -88.976811, 30.210987 ], [ -88.947872, 30.214179 ], [ -88.920511, 30.220578 ], [ -88.908885, 30.225437 ], [ -88.889797, 30.239665 ], [ -88.877824, 30.242442 ], [ -88.873660, 30.241748 ], [ -88.900370, 30.224576 ] ] ], [ [ [ -88.506999, 30.214348 ], [ -88.500011, 30.214044 ], [ -88.465713, 30.202540 ], [ -88.453444, 30.201236 ], [ -88.442654, 30.202314 ], [ -88.430332, 30.208548 ], [ -88.401466, 30.210172 ], [ -88.404581, 30.206162 ], [ -88.428301, 30.198511 ], [ -88.453654, 30.196584 ], [ -88.493523, 30.205945 ], [ -88.502752, 30.210506 ], [ -88.506999, 30.214348 ] ] ], [ [ [ -88.710719, 30.250799 ], [ -88.656804, 30.233956 ], [ -88.573044, 30.222640 ], [ -88.568056, 30.222732 ], [ -88.562067, 30.227476 ], [ -88.565576, 30.222847 ], [ -88.569138, 30.221357 ], [ -88.587424, 30.219154 ], [ -88.633743, 30.226342 ], [ -88.665857, 30.228847 ], [ -88.711830, 30.242662 ], [ -88.740647, 30.238665 ], [ -88.752782, 30.238803 ], [ -88.764022, 30.241488 ], [ -88.771991, 30.245523 ], [ -88.732550, 30.246322 ], [ -88.718104, 30.252931 ], [ -88.710719, 30.250799 ] ] ], [ [ [ -89.198288, 34.994484 ], [ -89.139136, 34.994307 ], [ -89.138997, 34.994330 ], [ -89.017128, 34.994649 ], [ -88.823049, 34.995157 ], [ -88.786612, 34.995252 ], [ -88.469877, 34.996033 ], [ -88.469801, 34.996052 ], [ -88.380508, 34.995610 ], [ -88.363531, 34.995590 ], [ -88.258111, 34.995463 ], [ -88.253825, 34.995553 ], [ -88.200064, 34.995634 ], [ -88.125038, 34.902227 ], [ -88.097888, 34.892202 ], [ -88.118407, 34.724292 ], [ -88.138719, 34.589215 ], [ -88.139246, 34.587795 ], [ -88.139988, 34.581703 ], [ -88.155305, 34.463087 ], [ -88.165634, 34.383102 ], [ -88.165910, 34.380926 ], [ -88.173632, 34.321054 ], [ -88.175867, 34.302171 ], [ -88.176889, 34.293858 ], [ -88.203597, 34.086530 ], [ -88.207229, 34.058333 ], [ -88.226428, 33.912875 ], [ -88.226517, 33.911665 ], [ -88.226517, 33.911551 ], [ -88.248390, 33.744908 ], [ -88.254445, 33.698779 ], [ -88.254622, 33.695780 ], [ -88.256131, 33.682860 ], [ -88.256343, 33.682053 ], [ -88.267005, 33.594229 ], [ -88.267148, 33.591989 ], [ -88.268160, 33.585040 ], [ -88.269076, 33.576929 ], [ -88.269532, 33.572894 ], [ -88.270050, 33.570819 ], [ -88.274619, 33.534008 ], [ -88.276805, 33.516463 ], [ -88.277421, 33.512436 ], [ -88.291127, 33.399061 ], [ -88.304514, 33.288320 ], [ -88.340432, 32.991199 ], [ -88.347692, 32.929059 ], [ -88.382985, 32.626954 ], [ -88.383039, 32.626679 ], [ -88.388739, 32.578116 ], [ -88.403789, 32.449885 ], [ -88.403789, 32.449770 ], [ -88.421453, 32.308680 ], [ -88.431707, 32.227662 ], [ -88.438650, 32.172806 ], [ -88.438710, 32.172078 ], [ -88.454959, 32.040576 ], [ -88.455039, 32.039719 ], [ -88.468660, 31.933173 ], [ -88.468879, 31.930262 ], [ -88.469960, 31.893759 ], [ -88.471214, 31.851385 ], [ -88.471106, 31.850949 ], [ -88.464428, 31.697952 ], [ -88.464425, 31.697881 ], [ -88.459722, 31.624002 ], [ -88.459478, 31.621652 ], [ -88.449446, 31.435837 ], [ -88.448660, 31.421277 ], [ -88.448686, 31.420888 ], [ -88.445209, 31.355969 ], [ -88.445182, 31.355855 ], [ -88.438211, 31.231252 ], [ -88.438104, 31.230060 ], [ -88.432007, 31.114298 ], [ -88.425807, 31.001123 ], [ -88.425729, 31.000183 ], [ -88.425635, 30.998301 ], [ -88.412462, 30.735598 ], [ -88.412270, 30.731771 ], [ -88.412209, 30.730395 ], [ -88.411550, 30.712956 ], [ -88.411339, 30.706334 ], [ -88.409571, 30.668731 ], [ -88.408070, 30.636970 ], [ -88.407462, 30.631653 ], [ -88.407484, 30.622736 ], [ -88.404013, 30.545060 ], [ -88.403931, 30.543359 ], [ -88.403547, 30.533100 ], [ -88.402283, 30.510852 ], [ -88.395023, 30.369425 ], [ -88.397236, 30.367689 ], [ -88.399062, 30.360744 ], [ -88.397082, 30.354785 ], [ -88.394150, 30.352493 ], [ -88.393980, 30.349307 ], [ -88.401181, 30.344382 ], [ -88.409927, 30.342115 ], [ -88.418811, 30.353911 ], [ -88.433891, 30.354652 ], [ -88.446495, 30.347753 ], [ -88.446625, 30.337671 ], [ -88.453810, 30.329626 ], [ -88.471875, 30.320020 ], [ -88.480117, 30.318345 ], [ -88.504802, 30.321472 ], [ -88.506226, 30.322393 ], [ -88.506334, 30.327398 ], [ -88.522494, 30.340092 ], [ -88.536214, 30.343299 ], [ -88.579483, 30.344190 ], [ -88.596349, 30.358365 ], [ -88.599249, 30.358933 ], [ -88.601762, 30.355876 ], [ -88.613745, 30.353108 ], [ -88.624523, 30.358713 ], [ -88.663820, 30.362099 ], [ -88.679575, 30.355710 ], [ -88.692164, 30.347302 ], [ -88.700587, 30.343689 ], [ -88.714077, 30.342186 ], [ -88.728893, 30.342671 ], [ -88.746945, 30.347622 ], [ -88.771742, 30.365403 ], [ -88.811615, 30.384907 ], [ -88.812576, 30.387680 ], [ -88.810127, 30.391298 ], [ -88.810227, 30.394698 ], [ -88.823724, 30.402376 ], [ -88.841328, 30.409598 ], [ -88.845609, 30.405266 ], [ -88.857828, 30.392898 ], [ -88.851442, 30.375355 ], [ -88.880526, 30.386600 ], [ -88.883789, 30.389172 ], [ -88.884829, 30.391998 ], [ -88.893930, 30.393398 ], [ -88.922031, 30.393798 ], [ -88.971233, 30.390798 ], [ -89.016334, 30.383898 ], [ -89.083237, 30.368097 ], [ -89.186840, 30.331197 ], [ -89.220442, 30.322497 ], [ -89.271833, 30.305491 ], [ -89.285744, 30.303097 ], [ -89.291444, 30.303296 ], [ -89.294444, 30.307596 ], [ -89.291844, 30.328096 ], [ -89.287844, 30.333196 ], [ -89.281564, 30.331980 ], [ -89.279818, 30.349790 ], [ -89.292499, 30.365635 ], [ -89.315067, 30.375408 ], [ -89.335942, 30.374016 ], [ -89.340947, 30.372896 ], [ -89.349447, 30.370995 ], [ -89.353248, 30.368795 ], [ -89.363848, 30.357395 ], [ -89.366116, 30.352169 ], [ -89.345934, 30.343573 ], [ -89.338847, 30.342995 ], [ -89.332546, 30.337895 ], [ -89.322345, 30.319296 ], [ -89.322545, 30.314896 ], [ -89.329946, 30.302896 ], [ -89.344746, 30.293196 ], [ -89.358546, 30.288896 ], [ -89.365747, 30.284896 ], [ -89.379547, 30.270396 ], [ -89.383747, 30.267796 ], [ -89.419348, 30.254320 ], [ -89.424624, 30.245391 ], [ -89.424493, 30.239092 ], [ -89.430428, 30.223218 ], [ -89.447465, 30.205098 ], [ -89.447910, 30.185352 ], [ -89.461275, 30.174745 ], [ -89.463595, 30.173943 ], [ -89.469792, 30.176278 ], [ -89.475824, 30.191561 ], [ -89.480214, 30.193751 ], [ -89.490099, 30.187677 ], [ -89.503231, 30.183051 ], [ -89.522814, 30.183076 ], [ -89.524504, 30.180753 ], [ -89.572654, 30.180897 ], [ -89.580754, 30.186197 ], [ -89.607655, 30.217096 ], [ -89.643440, 30.287682 ], [ -89.643575, 30.293099 ], [ -89.640694, 30.301313 ], [ -89.629877, 30.321017 ], [ -89.629941, 30.339449 ], [ -89.683410, 30.451793 ], [ -89.690580, 30.458773 ], [ -89.724614, 30.491902 ], [ -89.732577, 30.492502 ], [ -89.760570, 30.515761 ], [ -89.806843, 30.572039 ], [ -89.823384, 30.608535 ], [ -89.842585, 30.666005 ], [ -89.842596, 30.666038 ], [ -89.826175, 30.736594 ], [ -89.789863, 30.851527 ], [ -89.773410, 30.897693 ], [ -89.770931, 30.899432 ], [ -89.756543, 30.900431 ], [ -89.744789, 30.918933 ], [ -89.728382, 30.971141 ], [ -89.728148, 31.002300 ], [ -89.728147, 31.002431 ], [ -89.732504, 31.004831 ], [ -89.752642, 31.001853 ], [ -89.816429, 31.002084 ], [ -89.824617, 31.002060 ], [ -89.835542, 31.002059 ], [ -89.835908, 31.002059 ], [ -89.856862, 31.002075 ], [ -89.892708, 31.001759 ], [ -89.897516, 31.001913 ], [ -89.923119, 31.001446 ], [ -89.927161, 31.001437 ], [ -89.972802, 31.001392 ], [ -89.975430, 31.001692 ], [ -90.005332, 31.001364 ], [ -90.022185, 31.001302 ], [ -90.029574, 31.001190 ], [ -90.050706, 31.001215 ], [ -90.128406, 31.001047 ], [ -90.131395, 31.000924 ], [ -90.164278, 31.001025 ], [ -90.164676, 31.000980 ], [ -90.259555, 31.000657 ], [ -90.346007, 31.000363 ], [ -90.347230, 31.000359 ], [ -90.347241, 31.000359 ], [ -90.369371, 31.000335 ], [ -90.422117, 30.999810 ], [ -90.426849, 30.999776 ], [ -90.437351, 30.999730 ], [ -90.441725, 30.999729 ], [ -90.442479, 30.999722 ], [ -90.474094, 30.999798 ], [ -90.475928, 30.999740 ], [ -90.477284, 30.999717 ], [ -90.485876, 30.999740 ], [ -90.486749, 30.999693 ], [ -90.547615, 30.999723 ], [ -90.567195, 30.999733 ], [ -90.583518, 30.999698 ], [ -90.584448, 30.999698 ], [ -90.587373, 30.999604 ], [ -90.588676, 30.999650 ], [ -90.648721, 30.999486 ], [ -90.651193, 30.999510 ], [ -90.734473, 30.999214 ], [ -90.734552, 30.999222 ], [ -90.758775, 30.999583 ], [ -90.769333, 30.999374 ], [ -90.775981, 30.999491 ], [ -90.779858, 30.999457 ], [ -90.783745, 30.999447 ], [ -90.825829, 30.999360 ], [ -90.826027, 30.999360 ], [ -91.060217, 30.998935 ], [ -91.068270, 30.998920 ], [ -91.080814, 30.998909 ], [ -91.108114, 30.998857 ], [ -91.108291, 30.998880 ], [ -91.176140, 30.999144 ], [ -91.176209, 30.999144 ], [ -91.224068, 30.999183 ], [ -91.224839, 30.999183 ], [ -91.423621, 30.998984 ], [ -91.425749, 30.999007 ], [ -91.538727, 30.999388 ], [ -91.625118, 30.999167 ], [ -91.636942, 30.999416 ], [ -91.584670, 31.020185 ], [ -91.571695, 31.029782 ], [ -91.562468, 31.043213 ], [ -91.559907, 31.054119 ], [ -91.561283, 31.060906 ], [ -91.564150, 31.066830 ], [ -91.577373, 31.078179 ], [ -91.604197, 31.154545 ], [ -91.599965, 31.192318 ], [ -91.598490, 31.205485 ], [ -91.574493, 31.261289 ], [ -91.547588, 31.264444 ], [ -91.522397, 31.273423 ], [ -91.515614, 31.278210 ], [ -91.508858, 31.291644 ], [ -91.519820, 31.311228 ], [ -91.531201, 31.326625 ], [ -91.539904, 31.337336 ], [ -91.541242, 31.356750 ], [ -91.525386, 31.378904 ], [ -91.513795, 31.386875 ], [ -91.505093, 31.400933 ], [ -91.500406, 31.419008 ], [ -91.505301, 31.432945 ], [ -91.510356, 31.438928 ], [ -91.515130, 31.449206 ], [ -91.522920, 31.519841 ], [ -91.515810, 31.530894 ], [ -91.511217, 31.532612 ], [ -91.479718, 31.530366 ], [ -91.450017, 31.539666 ], [ -91.437616, 31.546166 ], [ -91.422691, 31.554390 ], [ -91.416683, 31.561599 ], [ -91.415482, 31.567006 ], [ -91.425094, 31.577820 ], [ -91.437711, 31.580824 ], [ -91.448620, 31.583032 ], [ -91.458679, 31.583226 ], [ -91.470754, 31.585630 ], [ -91.477362, 31.592239 ], [ -91.477963, 31.598247 ], [ -91.477963, 31.604855 ], [ -91.477963, 31.610863 ], [ -91.474959, 31.621677 ], [ -91.464746, 31.628886 ], [ -91.452730, 31.631290 ], [ -91.441315, 31.631290 ], [ -91.422090, 31.631290 ], [ -91.404668, 31.637898 ], [ -91.398059, 31.655922 ], [ -91.400115, 31.688164 ], [ -91.397915, 31.709364 ], [ -91.379935, 31.733013 ], [ -91.369375, 31.746903 ], [ -91.365084, 31.752743 ], [ -91.365614, 31.760763 ], [ -91.363714, 31.780363 ], [ -91.359514, 31.799362 ], [ -91.345714, 31.842861 ], [ -91.338414, 31.851261 ], [ -91.326914, 31.854961 ], [ -91.293413, 31.860160 ], [ -91.248144, 31.869848 ], [ -91.128009, 31.985857 ], [ -91.034707, 32.101053 ], [ -91.027946, 32.112722 ], [ -91.027535, 32.113431 ], [ -91.027125, 32.120434 ], [ -91.026931, 32.123737 ], [ -91.030152, 32.129821 ], [ -91.034447, 32.134832 ], [ -91.040531, 32.137337 ], [ -91.046615, 32.138768 ], [ -91.052342, 32.137337 ], [ -91.057487, 32.135515 ], [ -91.067004, 32.132144 ], [ -91.131403, 32.126213 ], [ -91.162822, 32.132694 ], [ -91.165452, 32.134290 ], [ -91.171702, 32.144250 ], [ -91.174552, 32.154978 ], [ -91.171046, 32.176526 ], [ -91.164171, 32.196888 ], [ -91.158026, 32.201956 ], [ -91.133587, 32.213432 ], [ -91.122602, 32.216929 ], [ -91.046507, 32.241149 ], [ -91.039007, 32.242349 ], [ -91.021507, 32.236149 ], [ -91.006306, 32.224150 ], [ -91.004557, 32.215381 ], [ -90.905173, 32.315497 ], [ -90.898588, 32.329094 ], [ -90.901511, 32.337864 ], [ -90.912363, 32.339454 ], [ -90.986672, 32.351760 ], [ -91.000106, 32.357695 ], [ -91.003506, 32.362145 ], [ -91.004506, 32.368144 ], [ -90.994080, 32.403862 ], [ -91.029606, 32.433542 ], [ -91.052907, 32.438442 ], [ -91.070207, 32.445141 ], [ -91.095308, 32.458741 ], [ -91.108808, 32.472040 ], [ -91.116008, 32.483140 ], [ -91.116708, 32.500139 ], [ -91.097878, 32.544752 ], [ -91.093741, 32.549128 ], [ -91.089436, 32.553306 ], [ -91.090611, 32.562705 ], [ -91.090771, 32.563978 ], [ -91.096774, 32.576652 ], [ -91.104111, 32.584657 ], [ -91.119854, 32.584795 ], [ -91.127912, 32.586493 ], [ -91.141148, 32.597209 ], [ -91.146204, 32.604144 ], [ -91.151318, 32.615919 ], [ -91.153821, 32.631282 ], [ -91.152081, 32.641508 ], [ -91.118258, 32.674075 ], [ -91.098762, 32.685291 ], [ -91.076061, 32.693751 ], [ -91.063946, 32.702926 ], [ -91.057043, 32.712576 ], [ -91.054481, 32.722259 ], [ -91.060766, 32.727494 ], [ -91.077176, 32.732534 ], [ -91.123152, 32.742798 ], [ -91.154461, 32.742339 ], [ -91.163389, 32.747009 ], [ -91.165328, 32.751301 ], [ -91.164397, 32.785821 ], [ -91.161669, 32.812465 ], [ -91.158336, 32.822304 ], [ -91.145002, 32.842870 ], [ -91.127886, 32.855059 ], [ -91.116091, 32.855641 ], [ -91.105631, 32.858396 ], [ -91.086683, 32.873392 ], [ -91.070602, 32.888659 ], [ -91.063809, 32.903709 ], [ -91.063974, 32.924113 ], [ -91.086802, 32.976266 ], [ -91.094265, 32.984371 ], [ -91.106581, 32.988938 ], [ -91.125107, 32.984669 ], [ -91.134414, 32.980533 ], [ -91.138585, 32.971352 ], [ -91.130947, 32.963815 ], [ -91.132115, 32.923122 ], [ -91.134041, 32.917676 ], [ -91.145076, 32.905494 ], [ -91.159975, 32.899879 ], [ -91.175405, 32.899998 ], [ -91.196785, 32.906784 ], [ -91.208263, 32.915354 ], [ -91.212837, 32.922104 ], [ -91.214027, 32.930320 ], [ -91.201842, 32.961212 ], [ -91.166073, 33.004106 ], [ -91.157662, 33.011217 ], [ -91.125656, 33.038276 ], [ -91.087589, 33.145177 ], [ -91.085984, 33.221644 ], [ -91.110561, 33.245930 ], [ -91.141216, 33.298397 ], [ -91.184427, 33.419576 ], [ -91.131885, 33.430063 ], [ -91.118495, 33.449116 ], [ -91.125109, 33.472842 ], [ -91.215671, 33.529423 ], [ -91.232295, 33.552788 ], [ -91.228287, 33.559937 ], [ -91.224121, 33.567369 ], [ -91.152148, 33.582721 ], [ -91.134043, 33.594489 ], [ -91.130445, 33.606034 ], [ -91.157484, 33.626187 ], [ -91.186519, 33.645909 ], [ -91.193093, 33.656866 ], [ -91.188710, 33.669466 ], [ -91.185971, 33.679327 ], [ -91.176110, 33.684257 ], [ -91.148170, 33.679327 ], [ -91.139953, 33.683709 ], [ -91.132831, 33.688092 ], [ -91.127900, 33.695762 ], [ -91.126805, 33.707814 ], [ -91.136118, 33.728632 ], [ -91.144682, 33.750108 ], [ -91.139869, 33.777117 ], [ -91.067511, 33.840443 ], [ -91.036821, 33.914656 ], [ -91.088164, 33.960078 ], [ -91.089119, 33.972653 ], [ -91.018890, 34.003151 ], [ -90.964708, 34.007952 ], [ -90.887413, 34.032505 ], [ -90.879163, 34.065503 ], [ -90.888396, 34.087433 ], [ -90.912057, 34.095512 ], [ -90.928793, 34.107631 ], [ -90.931969, 34.120017 ], [ -90.933116, 34.124488 ], [ -90.934564, 34.130138 ], [ -90.918405, 34.154376 ], [ -90.893013, 34.155531 ], [ -90.880317, 34.169381 ], [ -90.880894, 34.180346 ], [ -90.895898, 34.191888 ], [ -90.913212, 34.210355 ], [ -90.911480, 34.223051 ], [ -90.894744, 34.229977 ], [ -90.868775, 34.228245 ], [ -90.856367, 34.238928 ], [ -90.764143, 34.363396 ], [ -90.658542, 34.375705 ], [ -90.613944, 34.390723 ], [ -90.575336, 34.415152 ], [ -90.565809, 34.435400 ], [ -90.570133, 34.524829 ], [ -90.575786, 34.641749 ], [ -90.576543, 34.657402 ], [ -90.564033, 34.665742 ], [ -90.549855, 34.662406 ], [ -90.539013, 34.659070 ], [ -90.521499, 34.663240 ], [ -90.508989, 34.679086 ], [ -90.509823, 34.689928 ], [ -90.533175, 34.707442 ], [ -90.554859, 34.727458 ], [ -90.549855, 34.763320 ], [ -90.537345, 34.784170 ], [ -90.519831, 34.782502 ], [ -90.501325, 34.769931 ], [ -90.494811, 34.767490 ], [ -90.479799, 34.769158 ], [ -90.467289, 34.782502 ], [ -90.478131, 34.832542 ], [ -90.473961, 34.852558 ], [ -90.461451, 34.856728 ], [ -90.436431, 34.855060 ], [ -90.423879, 34.834606 ], [ -90.414864, 34.831846 ], [ -90.407964, 34.832767 ], [ -90.307384, 34.846195 ], [ -90.293918, 34.860563 ], [ -90.250095, 34.907320 ], [ -90.244476, 34.937596 ], [ -90.253969, 34.954988 ], [ -90.309297, 34.995694 ], [ -89.893402, 34.994356 ], [ -89.883365, 34.994261 ], [ -89.848488, 34.994193 ], [ -89.795187, 34.994293 ], [ -89.724324, 34.994763 ], [ -89.644282, 34.995293 ], [ -89.511153, 34.994755 ], [ -89.493739, 34.994361 ], [ -89.352679, 34.994420 ], [ -89.198288, 34.994484 ] ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US30", "STATE": 13, "name": "Montana", "LSAD": "", "CENSUSAREA": 145545.801000 }, "geometry": { "type": "Polygon", "coordinates": [ [ [ -111.044275, 45.001345 ], [ -111.056207, 44.935901 ], [ -111.055629, 44.933578 ], [ -111.056888, 44.866658 ], [ -111.055495, 44.666262 ], [ -111.055208, 44.624927 ], [ -111.048974, 44.474072 ], [ -111.106574, 44.486330 ], [ -111.122654, 44.493659 ], [ -111.131379, 44.499925 ], [ -111.139455, 44.517112 ], [ -111.219236, 44.622616 ], [ -111.323669, 44.724474 ], [ -111.377682, 44.751744 ], [ -111.394815, 44.751351 ], [ -111.481536, 44.709186 ], [ -111.489008, 44.705553 ], [ -111.516588, 44.643707 ], [ -111.525764, 44.604883 ], [ -111.601249, 44.554210 ], [ -111.617502, 44.553035 ], [ -111.631505, 44.552022 ], [ -111.704218, 44.560205 ], [ -111.737191, 44.543060 ], [ -111.806528, 44.515459 ], [ -111.843295, 44.528225 ], [ -111.849293, 44.539837 ], [ -111.870504, 44.564033 ], [ -111.947941, 44.556776 ], [ -112.078471, 44.533551 ], [ -112.187115, 44.534452 ], [ -112.221698, 44.543519 ], [ -112.229477, 44.549494 ], [ -112.235864, 44.555194 ], [ -112.246665, 44.561010 ], [ -112.258297, 44.564334 ], [ -112.274083, 44.564334 ], [ -112.299009, 44.559348 ], [ -112.339721, 44.538577 ], [ -112.347199, 44.520298 ], [ -112.356600, 44.493127 ], [ -112.358926, 44.486280 ], [ -112.371294, 44.472108 ], [ -112.387080, 44.460476 ], [ -112.410345, 44.462968 ], [ -112.473207, 44.480027 ], [ -112.544224, 44.483763 ], [ -112.688160, 44.498850 ], [ -112.719110, 44.504344 ], [ -112.781294, 44.484888 ], [ -112.812087, 44.451370 ], [ -112.822046, 44.434109 ], [ -112.822046, 44.420831 ], [ -112.823373, 44.406225 ], [ -112.824701, 44.393611 ], [ -112.829247, 44.385427 ], [ -112.831340, 44.381660 ], [ -112.849266, 44.371038 ], [ -112.875822, 44.374357 ], [ -112.970300, 44.426933 ], [ -113.003544, 44.450814 ], [ -113.027147, 44.495915 ], [ -113.056770, 44.618657 ], [ -113.053529, 44.621187 ], [ -113.049349, 44.629380 ], [ -113.051504, 44.636950 ], [ -113.101082, 44.718832 ], [ -113.134617, 44.763149 ], [ -113.158206, 44.780847 ], [ -113.207878, 44.808040 ], [ -113.247166, 44.822950 ], [ -113.278382, 44.812706 ], [ -113.329491, 44.788645 ], [ -113.341704, 44.784853 ], [ -113.353631, 44.791395 ], [ -113.455071, 44.865424 ], [ -113.475838, 44.894648 ], [ -113.498745, 44.942314 ], [ -113.494446, 44.948597 ], [ -113.480836, 44.950310 ], [ -113.472715, 44.948123 ], [ -113.447199, 44.971924 ], [ -113.445915, 44.979918 ], [ -113.445751, 45.018351 ], [ -113.449349, 45.045745 ], [ -113.463961, 45.063194 ], [ -113.473770, 45.061700 ], [ -113.485278, 45.063519 ], [ -113.576453, 45.130311 ], [ -113.576360, 45.133771 ], [ -113.566179, 45.143120 ], [ -113.565979, 45.149335 ], [ -113.599506, 45.191114 ], [ -113.650064, 45.234710 ], [ -113.674409, 45.249411 ], [ -113.738729, 45.329741 ], [ -113.760924, 45.406501 ], [ -113.774156, 45.465372 ], [ -113.765760, 45.483228 ], [ -113.772915, 45.512322 ], [ -113.786269, 45.521385 ], [ -113.810117, 45.530924 ], [ -113.813456, 45.550002 ], [ -113.802009, 45.579096 ], [ -113.804871, 45.589112 ], [ -113.813933, 45.600559 ], [ -113.835396, 45.612960 ], [ -113.896681, 45.641451 ], [ -113.934220, 45.682232 ], [ -113.942600, 45.686362 ], [ -113.971565, 45.700636 ], [ -113.987759, 45.705247 ], [ -114.015633, 45.696127 ], [ -114.019315, 45.692937 ], [ -114.022534, 45.679620 ], [ -114.034930, 45.647967 ], [ -114.135249, 45.557465 ], [ -114.187852, 45.542151 ], [ -114.247828, 45.545489 ], [ -114.309613, 45.469432 ], [ -114.350819, 45.468542 ], [ -114.366620, 45.491616 ], [ -114.460542, 45.561283 ], [ -114.473759, 45.563278 ], [ -114.514196, 45.564734 ], [ -114.551286, 45.559007 ], [ -114.560855, 45.564575 ], [ -114.561773, 45.565109 ], [ -114.563652, 45.637412 ], [ -114.561046, 45.639906 ], [ -114.550834, 45.642600 ], [ -114.545574, 45.642928 ], [ -114.541820, 45.641305 ], [ -114.515411, 45.652842 ], [ -114.500925, 45.666715 ], [ -114.495421, 45.703321 ], [ -114.497553, 45.710677 ], [ -114.504869, 45.722176 ], [ -114.528667, 45.731636 ], [ -114.547763, 45.743309 ], [ -114.566172, 45.773864 ], [ -114.514596, 45.840785 ], [ -114.509303, 45.845531 ], [ -114.498809, 45.850676 ], [ -114.448680, 45.858891 ], [ -114.393760, 45.894020 ], [ -114.401552, 45.963195 ], [ -114.412007, 45.978057 ], [ -114.429638, 45.986638 ], [ -114.465376, 45.996077 ], [ -114.483379, 46.008047 ], [ -114.490578, 46.022872 ], [ -114.491200, 46.034059 ], [ -114.491200, 46.044003 ], [ -114.476284, 46.062026 ], [ -114.467583, 46.081914 ], [ -114.468205, 46.099937 ], [ -114.476284, 46.112988 ], [ -114.483120, 46.129147 ], [ -114.472643, 46.162202 ], [ -114.426885, 46.289671 ], [ -114.378000, 46.435371 ], [ -114.385297, 46.467162 ], [ -114.346528, 46.535789 ], [ -114.331093, 46.607649 ], [ -114.331093, 46.630248 ], [ -114.337942, 46.641205 ], [ -114.341336, 46.642803 ], [ -114.349584, 46.646684 ], [ -114.370129, 46.654217 ], [ -114.422176, 46.652163 ], [ -114.446830, 46.645314 ], [ -114.461211, 46.639151 ], [ -114.481943, 46.631993 ], [ -114.592264, 46.632861 ], [ -114.594707, 46.633558 ], [ -114.614423, 46.639188 ], [ -114.635868, 46.659510 ], [ -114.642713, 46.673145 ], [ -114.641745, 46.679286 ], [ -114.641322, 46.686404 ], [ -114.642692, 46.694622 ], [ -114.644747, 46.702155 ], [ -114.655704, 46.711743 ], [ -114.667346, 46.719276 ], [ -114.675505, 46.719516 ], [ -114.690630, 46.719961 ], [ -114.717645, 46.713994 ], [ -114.739253, 46.715167 ], [ -114.767180, 46.738828 ], [ -114.825923, 46.781949 ], [ -114.853279, 46.799794 ], [ -114.888146, 46.808573 ], [ -114.920459, 46.827697 ], [ -114.927837, 46.835990 ], [ -114.938713, 46.869021 ], [ -114.936015, 46.899761 ], [ -114.975789, 46.932865 ], [ -115.072985, 47.013760 ], [ -115.099178, 47.048129 ], [ -115.193221, 47.133026 ], [ -115.200547, 47.139154 ], [ -115.266723, 47.181101 ], [ -115.292110, 47.209861 ], [ -115.294785, 47.220914 ], [ -115.320184, 47.255717 ], [ -115.339201, 47.261623 ], [ -115.421645, 47.271736 ], [ -115.479255, 47.282089 ], [ -115.523690, 47.298919 ], [ -115.551309, 47.333856 ], [ -115.561439, 47.351887 ], [ -115.576836, 47.366825 ], [ -115.661341, 47.402663 ], [ -115.690570, 47.415059 ], [ -115.721084, 47.422350 ], [ -115.729861, 47.447287 ], [ -115.725931, 47.466934 ], [ -115.712178, 47.488546 ], [ -115.729861, 47.518016 ], [ -115.739684, 47.537663 ], [ -115.735755, 47.555346 ], [ -115.721207, 47.576323 ], [ -115.718072, 47.592675 ], [ -115.706284, 47.637864 ], [ -115.723770, 47.696671 ], [ -115.729123, 47.703102 ], [ -115.919291, 47.857406 ], [ -116.007254, 47.944968 ], [ -116.048421, 47.976820 ], [ -116.048424, 47.977126 ], [ -116.049320, 48.066644 ], [ -116.049368, 48.072134 ], [ -116.049398, 48.075395 ], [ -116.049415, 48.077220 ], [ -116.049353, 48.215460 ], [ -116.049226, 48.502058 ], [ -116.049023, 48.957947 ], [ -116.049025, 48.958351 ], [ -116.049193, 49.000912 ], [ -115.251126, 48.999557 ], [ -114.728125, 49.000623 ], [ -114.678217, 49.000725 ], [ -114.674398, 49.000679 ], [ -114.438830, 49.001076 ], [ -114.068151, 48.999364 ], [ -113.692982, 48.997632 ], [ -113.116356, 48.998462 ], [ -113.110155, 48.998550 ], [ -113.106891, 48.998501 ], [ -113.103212, 48.998530 ], [ -113.098147, 48.998494 ], [ -113.095436, 48.998533 ], [ -113.092055, 48.998543 ], [ -113.087863, 48.998557 ], [ -113.085576, 48.998581 ], [ -113.011041, 48.998643 ], [ -113.009895, 48.998619 ], [ -112.193588, 48.998229 ], [ -111.854088, 48.998067 ], [ -111.854090, 48.998039 ], [ -111.761679, 48.997614 ], [ -111.761613, 48.997650 ], [ -111.270702, 48.997895 ], [ -110.887459, 48.998087 ], [ -110.886706, 48.998124 ], [ -110.743209, 48.998363 ], [ -110.216135, 48.999239 ], [ -110.215516, 48.999197 ], [ -110.171595, 48.999262 ], [ -109.995618, 48.999642 ], [ -109.489686, 49.000267 ], [ -109.384762, 49.000397 ], [ -109.384068, 49.000374 ], [ -109.060570, 48.999666 ], [ -109.060292, 48.999621 ], [ -109.000708, 48.999234 ], [ -108.994722, 48.999237 ], [ -108.543194, 48.999377 ], [ -108.488063, 48.999368 ], [ -108.236495, 48.999405 ], [ -107.179865, 48.999559 ], [ -106.625597, 48.999640 ], [ -106.617539, 48.999583 ], [ -106.518201, 48.999564 ], [ -106.500592, 48.999756 ], [ -106.374616, 48.999617 ], [ -106.368151, 48.999503 ], [ -106.274267, 48.999312 ], [ -106.246210, 48.999258 ], [ -106.243154, 48.999373 ], [ -106.233987, 48.999423 ], [ -106.112108, 48.999279 ], [ -106.050543, 48.999207 ], [ -105.966197, 48.999445 ], [ -105.834181, 48.999707 ], [ -105.775808, 48.999637 ], [ -105.650270, 48.999444 ], [ -105.612577, 48.999703 ], [ -105.607542, 48.999624 ], [ -105.578616, 48.999673 ], [ -105.522636, 48.999591 ], [ -105.411972, 48.999582 ], [ -105.407909, 48.999480 ], [ -105.391379, 48.999475 ], [ -105.387490, 48.999382 ], [ -105.355888, 48.999357 ], [ -105.277521, 48.999457 ], [ -105.265192, 48.999500 ], [ -105.057514, 48.999448 ], [ -104.647389, 48.999344 ], [ -104.543636, 48.999541 ], [ -104.048736, 48.999877 ], [ -104.048478, 48.987007 ], [ -104.048616, 48.966736 ], [ -104.048555, 48.963772 ], [ -104.048800, 48.958997 ], [ -104.048627, 48.957124 ], [ -104.048698, 48.951823 ], [ -104.048872, 48.949630 ], [ -104.048770, 48.943301 ], [ -104.048701, 48.940331 ], [ -104.048807, 48.933636 ], [ -104.048744, 48.912113 ], [ -104.048746, 48.906858 ], [ -104.048643, 48.902609 ], [ -104.048719, 48.879921 ], [ -104.048893, 48.875739 ], [ -104.048883, 48.874008 ], [ -104.048824, 48.867539 ], [ -104.048652, 48.865734 ], [ -104.048900, 48.847387 ], [ -104.048569, 48.797052 ], [ -104.048537, 48.788552 ], [ -104.048548, 48.751356 ], [ -104.048340, 48.747133 ], [ -104.047883, 48.664191 ], [ -104.047849, 48.663163 ], [ -104.047861, 48.658856 ], [ -104.047865, 48.657450 ], [ -104.047887, 48.649911 ], [ -104.047819, 48.648631 ], [ -104.047582, 48.633984 ], [ -104.047582, 48.633976 ], [ -104.047620, 48.627015 ], [ -104.047586, 48.625644 ], [ -104.047930, 48.620190 ], [ -104.048212, 48.599055 ], [ -104.047974, 48.591606 ], [ -104.047811, 48.562770 ], [ -104.047783, 48.539737 ], [ -104.047648, 48.531489 ], [ -104.047876, 48.530798 ], [ -104.047513, 48.525913 ], [ -104.047675, 48.517852 ], [ -104.047555, 48.494140 ], [ -104.047392, 48.467086 ], [ -104.047259, 48.452941 ], [ -104.047294, 48.452529 ], [ -104.047192, 48.447251 ], [ -104.047090, 48.445903 ], [ -104.046960, 48.421065 ], [ -104.047134, 48.411057 ], [ -104.046969, 48.390675 ], [ -104.046913, 48.389433 ], [ -104.046913, 48.389429 ], [ -104.046654, 48.374773 ], [ -104.046371, 48.374154 ], [ -104.046332, 48.342290 ], [ -104.046039, 48.256761 ], [ -104.045861, 48.255097 ], [ -104.045645, 48.246179 ], [ -104.045729, 48.244586 ], [ -104.045692, 48.241415 ], [ -104.045560, 48.193913 ], [ -104.045424, 48.192473 ], [ -104.045498, 48.176249 ], [ -104.045399, 48.164390 ], [ -104.044120, 47.996107 ], [ -104.044162, 47.992836 ], [ -104.043933, 47.971515 ], [ -104.043497, 47.954490 ], [ -104.043329, 47.949554 ], [ -104.042230, 47.891031 ], [ -104.041662, 47.862282 ], [ -104.041869, 47.841699 ], [ -104.042567, 47.808237 ], [ -104.042432, 47.805358 ], [ -104.042384, 47.803256 ], [ -104.043199, 47.747292 ], [ -104.043242, 47.747106 ], [ -104.044621, 47.459380 ], [ -104.044797, 47.438445 ], [ -104.045069, 47.397461 ], [ -104.045333, 47.343452 ], [ -104.045313, 47.331955 ], [ -104.045307, 47.330128 ], [ -104.045121, 47.276969 ], [ -104.045155, 47.273930 ], [ -104.045088, 47.271406 ], [ -104.045057, 47.266868 ], [ -104.045091, 47.265953 ], [ -104.045159, 47.263874 ], [ -104.045081, 47.092813 ], [ -104.045018, 47.081202 ], [ -104.045354, 47.078574 ], [ -104.045259, 47.063901 ], [ -104.045227, 47.057502 ], [ -104.045195, 47.053639 ], [ -104.045052, 47.040863 ], [ -104.045076, 47.037589 ], [ -104.045566, 46.941231 ], [ -104.045535, 46.934009 ], [ -104.045542, 46.933887 ], [ -104.045402, 46.725423 ], [ -104.045403, 46.722177 ], [ -104.045370, 46.721332 ], [ -104.045572, 46.713881 ], [ -104.045474, 46.708738 ], [ -104.045271, 46.641449 ], [ -104.045271, 46.641443 ], [ -104.045335, 46.540929 ], [ -104.045462, 46.341895 ], [ -104.045469, 46.324545 ], [ -104.045633, 46.280188 ], [ -104.046670, 46.000001 ], [ -104.045443, 45.945310 ], [ -104.044030, 45.881975 ], [ -104.044030, 45.881971 ], [ -104.044009, 45.871974 ], [ -104.043814, 45.868385 ], [ -104.041937, 45.557915 ], [ -104.041647, 45.550691 ], [ -104.041717, 45.539122 ], [ -104.041145, 45.503367 ], [ -104.041274, 45.499994 ], [ -104.041764, 45.490789 ], [ -104.040410, 45.393474 ], [ -104.040114, 45.374214 ], [ -104.040265, 45.345356 ], [ -104.040358, 45.335946 ], [ -104.040274, 45.212891 ], [ -104.040128, 44.999987 ], [ -104.057698, 44.997431 ], [ -104.470117, 44.998453 ], [ -104.470422, 44.998453 ], [ -104.663882, 44.998869 ], [ -104.665171, 44.998618 ], [ -104.759855, 44.999066 ], [ -104.765063, 44.999183 ], [ -105.018240, 45.000437 ], [ -105.019284, 45.000329 ], [ -105.025266, 45.000290 ], [ -105.038405, 45.000345 ], [ -105.076607, 45.000347 ], [ -105.848065, 45.000396 ], [ -105.918995, 44.997771 ], [ -105.928184, 44.993647 ], [ -106.024814, 44.993688 ], [ -106.263586, 44.993788 ], [ -106.888773, 44.995885 ], [ -106.892875, 44.995947 ], [ -107.080624, 44.996791 ], [ -107.134180, 45.000109 ], [ -107.607824, 45.000929 ], [ -107.608854, 45.000860 ], [ -107.911495, 45.000948 ], [ -108.125666, 45.001011 ], [ -108.249345, 44.999458 ], [ -108.565921, 45.000578 ], [ -108.578484, 45.000484 ], [ -108.621313, 45.000408 ], [ -109.062262, 44.999623 ], [ -109.083010, 44.999610 ], [ -109.103445, 45.005904 ], [ -109.263431, 45.005345 ], [ -109.269294, 45.005283 ], [ -109.798687, 45.002188 ], [ -110.025544, 45.003602 ], [ -110.026347, 45.003665 ], [ -110.110103, 45.003905 ], [ -110.221343, 44.996176 ], [ -110.547165, 44.992459 ], [ -110.552433, 44.992237 ], [ -110.705272, 44.992324 ], [ -110.750767, 44.997948 ], [ -110.875772, 45.002101 ], [ -111.044275, 45.001345 ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US35", "STATE": 14, "name": "New Mexico", "LSAD": "", "CENSUSAREA": 121298.148000 }, "geometry": { "type": "Polygon", "coordinates": [ [ [ -105.998003, 32.002328 ], [ -106.099760, 32.002174 ], [ -106.181840, 32.002050 ], [ -106.200699, 32.001785 ], [ -106.205915, 32.001762 ], [ -106.313307, 32.001512 ], [ -106.377174, 32.001490 ], [ -106.394298, 32.001484 ], [ -106.411075, 32.001334 ], [ -106.565142, 32.000736 ], [ -106.566056, 32.000759 ], [ -106.587972, 32.000749 ], [ -106.595333, 32.000778 ], [ -106.598639, 32.000754 ], [ -106.599096, 32.000731 ], [ -106.614702, 31.956000 ], [ -106.616136, 31.948439 ], [ -106.627808, 31.860593 ], [ -106.625763, 31.856276 ], [ -106.621857, 31.852854 ], [ -106.614637, 31.846490 ], [ -106.605845, 31.846305 ], [ -106.605245, 31.845905 ], [ -106.566844, 31.813306 ], [ -106.563444, 31.812606 ], [ -106.545344, 31.805007 ], [ -106.544714, 31.804287 ], [ -106.542144, 31.802107 ], [ -106.542097, 31.802146 ], [ -106.535843, 31.798607 ], [ -106.535343, 31.797507 ], [ -106.535154, 31.797089 ], [ -106.534743, 31.796107 ], [ -106.533043, 31.791907 ], [ -106.533000, 31.791829 ], [ -106.532480, 31.791914 ], [ -106.530515, 31.792103 ], [ -106.527943, 31.790507 ], [ -106.527738, 31.789761 ], [ -106.527623, 31.789119 ], [ -106.527997, 31.786945 ], [ -106.528543, 31.784407 ], [ -106.528543, 31.783907 ], [ -106.750547, 31.783706 ], [ -106.750547, 31.783898 ], [ -106.993544, 31.783689 ], [ -106.998235, 31.783671 ], [ -107.000560, 31.783679 ], [ -107.000560, 31.783513 ], [ -107.296824, 31.783762 ], [ -107.422246, 31.783599 ], [ -107.422495, 31.783599 ], [ -108.208394, 31.783599 ], [ -108.208521, 31.499798 ], [ -108.208572, 31.499742 ], [ -108.208573, 31.333395 ], [ -108.851105, 31.332301 ], [ -108.861028, 31.332315 ], [ -109.050044, 31.332502 ], [ -109.049843, 31.499515 ], [ -109.049813, 31.499528 ], [ -109.049195, 31.796551 ], [ -109.048763, 31.810776 ], [ -109.048769, 31.861383 ], [ -109.048590, 31.870791 ], [ -109.048599, 32.013651 ], [ -109.048731, 32.028174 ], [ -109.048296, 32.084093 ], [ -109.048286, 32.089114 ], [ -109.047926, 32.426376 ], [ -109.047653, 32.681379 ], [ -109.047653, 32.686327 ], [ -109.047645, 32.689988 ], [ -109.047638, 32.693439 ], [ -109.047117, 32.777569 ], [ -109.047117, 32.777570 ], [ -109.047480, 33.068420 ], [ -109.047453, 33.069427 ], [ -109.046905, 33.091931 ], [ -109.047013, 33.092917 ], [ -109.047117, 33.137559 ], [ -109.047116, 33.137995 ], [ -109.047237, 33.208965 ], [ -109.046827, 33.365272 ], [ -109.046909, 33.365570 ], [ -109.047045, 33.369280 ], [ -109.046870, 33.372654 ], [ -109.046627, 33.778233 ], [ -109.046182, 34.522393 ], [ -109.046182, 34.522553 ], [ -109.046156, 34.579291 ], [ -109.045851, 34.959718 ], [ -109.046082, 35.174665 ], [ -109.046481, 35.546326 ], [ -109.046509, 35.546440 ], [ -109.046296, 35.614251 ], [ -109.046295, 35.616517 ], [ -109.046024, 35.879800 ], [ -109.046055, 35.888721 ], [ -109.046054, 35.925860 ], [ -109.046011, 35.925896 ], [ -109.045973, 36.002338 ], [ -109.045433, 36.874589 ], [ -109.045407, 36.874998 ], [ -109.045272, 36.968871 ], [ -109.045244, 36.969489 ], [ -109.045223, 36.999084 ], [ -108.958868, 36.998913 ], [ -108.954404, 36.998906 ], [ -108.620309, 36.999287 ], [ -108.619689, 36.999249 ], [ -108.379203, 36.999459 ], [ -108.320721, 36.999510 ], [ -108.320464, 36.999499 ], [ -108.288400, 36.999520 ], [ -108.288086, 36.999555 ], [ -107.481737, 36.999973 ], [ -107.420915, 37.000005 ], [ -107.420913, 37.000005 ], [ -107.000592, 37.000009 ], [ -106.869796, 36.992426 ], [ -106.675626, 36.993123 ], [ -106.661344, 36.993243 ], [ -106.628733, 36.993161 ], [ -106.628652, 36.993175 ], [ -106.617125, 36.993004 ], [ -106.617159, 36.992967 ], [ -106.476228, 36.993472 ], [ -106.248675, 36.994288 ], [ -106.247705, 36.994266 ], [ -106.006634, 36.995343 ], [ -105.997472, 36.995417 ], [ -105.996159, 36.995418 ], [ -105.718470, 36.995846 ], [ -105.716471, 36.995849 ], [ -105.664720, 36.995874 ], [ -105.627470, 36.995679 ], [ -105.533922, 36.995875 ], [ -105.512485, 36.995777 ], [ -105.508836, 36.995895 ], [ -105.465182, 36.995991 ], [ -105.447255, 36.996017 ], [ -105.442459, 36.995994 ], [ -105.419310, 36.995856 ], [ -105.220613, 36.995169 ], [ -105.155042, 36.995339 ], [ -105.120800, 36.995428 ], [ -105.000554, 36.993264 ], [ -104.732120, 36.993484 ], [ -104.732031, 36.993447 ], [ -104.007855, 36.996239 ], [ -103.734364, 36.998041 ], [ -103.733247, 36.998016 ], [ -103.086105, 36.999864 ], [ -103.002199, 37.000104 ], [ -103.002247, 36.911587 ], [ -103.001964, 36.909573 ], [ -103.002198, 36.719427 ], [ -103.002518, 36.675186 ], [ -103.002252, 36.617180 ], [ -103.002188, 36.602716 ], [ -103.002565, 36.526588 ], [ -103.002434, 36.500397 ], [ -103.041669, 36.478514 ], [ -103.041745, 36.318267 ], [ -103.041674, 36.317534 ], [ -103.040824, 36.055231 ], [ -103.041357, 35.739274 ], [ -103.041554, 35.622487 ], [ -103.042497, 35.211862 ], [ -103.042377, 35.183156 ], [ -103.042377, 35.183149 ], [ -103.042366, 35.182786 ], [ -103.042339, 35.181922 ], [ -103.042395, 35.178573 ], [ -103.042568, 35.159318 ], [ -103.042711, 35.144735 ], [ -103.042600, 35.142766 ], [ -103.042520, 35.135596 ], [ -103.042521, 34.954101 ], [ -103.042521, 34.899546 ], [ -103.042781, 34.850243 ], [ -103.042770, 34.792224 ], [ -103.042769, 34.747361 ], [ -103.042827, 34.671188 ], [ -103.043072, 34.619782 ], [ -103.043594, 34.462660 ], [ -103.043589, 34.459774 ], [ -103.043588, 34.459662 ], [ -103.043582, 34.455657 ], [ -103.043538, 34.405463 ], [ -103.043583, 34.400678 ], [ -103.043611, 34.397105 ], [ -103.043585, 34.393716 ], [ -103.043613, 34.390442 ], [ -103.043613, 34.388679 ], [ -103.043614, 34.384969 ], [ -103.043630, 34.384690 ], [ -103.043693, 34.383578 ], [ -103.043919, 34.380916 ], [ -103.043944, 34.379660 ], [ -103.043946, 34.379555 ], [ -103.043979, 34.312764 ], [ -103.043979, 34.312749 ], [ -103.043936, 34.302585 ], [ -103.043719, 34.289441 ], [ -103.043644, 34.256903 ], [ -103.043569, 34.087947 ], [ -103.043516, 34.079382 ], [ -103.043686, 34.063078 ], [ -103.043744, 34.049986 ], [ -103.043767, 34.043545 ], [ -103.043721, 34.042320 ], [ -103.043771, 34.041538 ], [ -103.043746, 34.037294 ], [ -103.043555, 34.032714 ], [ -103.043531, 34.018014 ], [ -103.043617, 34.003633 ], [ -103.043950, 33.974629 ], [ -103.044893, 33.945617 ], [ -103.045698, 33.906299 ], [ -103.045644, 33.901537 ], [ -103.046907, 33.850300 ], [ -103.047346, 33.824675 ], [ -103.049096, 33.746270 ], [ -103.050148, 33.701971 ], [ -103.050532, 33.672408 ], [ -103.051087, 33.658186 ], [ -103.051535, 33.650487 ], [ -103.051363, 33.641950 ], [ -103.051664, 33.629489 ], [ -103.052610, 33.570599 ], [ -103.056655, 33.388438 ], [ -103.056655, 33.388416 ], [ -103.057487, 33.329477 ], [ -103.057856, 33.315234 ], [ -103.060103, 33.219225 ], [ -103.063905, 33.042055 ], [ -103.063980, 33.038693 ], [ -103.064452, 33.010290 ], [ -103.064625, 32.999899 ], [ -103.064679, 32.964373 ], [ -103.064657, 32.959097 ], [ -103.064569, 32.900014 ], [ -103.064701, 32.879355 ], [ -103.064862, 32.868346 ], [ -103.064807, 32.857696 ], [ -103.064916, 32.857260 ], [ -103.064889, 32.849359 ], [ -103.064672, 32.828470 ], [ -103.064699, 32.827531 ], [ -103.064711, 32.784593 ], [ -103.064698, 32.783602 ], [ -103.064807, 32.777303 ], [ -103.064827, 32.726628 ], [ -103.064799, 32.708694 ], [ -103.064798, 32.690761 ], [ -103.064864, 32.682647 ], [ -103.064633, 32.646420 ], [ -103.064815, 32.624537 ], [ -103.064761, 32.601863 ], [ -103.064788, 32.600397 ], [ -103.064761, 32.587983 ], [ -103.064696, 32.522193 ], [ -103.064422, 32.145006 ], [ -103.064348, 32.123041 ], [ -103.064344, 32.087051 ], [ -103.064423, 32.000518 ], [ -103.085876, 32.000465 ], [ -103.088698, 32.000453 ], [ -103.215641, 32.000513 ], [ -103.267633, 32.000475 ], [ -103.267708, 32.000324 ], [ -103.270383, 32.000326 ], [ -103.278521, 32.000419 ], [ -103.326501, 32.000370 ], [ -103.722853, 32.000221 ], [ -103.980179, 32.000125 ], [ -104.024521, 32.000010 ], [ -104.531756, 32.000117 ], [ -104.531937, 32.000311 ], [ -104.640918, 32.000396 ], [ -104.643526, 32.000443 ], [ -104.847757, 32.000482 ], [ -104.918272, 32.000496 ], [ -105.077046, 32.000579 ], [ -105.078605, 32.000533 ], [ -105.118040, 32.000485 ], [ -105.131377, 32.000524 ], [ -105.132916, 32.000518 ], [ -105.148240, 32.000485 ], [ -105.150310, 32.000497 ], [ -105.153994, 32.000497 ], [ -105.390396, 32.000607 ], [ -105.427049, 32.000638 ], [ -105.428582, 32.000600 ], [ -105.429281, 32.000577 ], [ -105.886159, 32.001970 ], [ -105.900600, 32.002100 ], [ -105.998003, 32.002328 ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US38", "STATE": 15, "name": "North Dakota", "LSAD": "", "CENSUSAREA": 69000.798000 }, "geometry": { "type": "Polygon", "coordinates": [ [ [ -100.511949, 45.943654 ], [ -100.627681, 45.943642 ], [ -100.650820, 45.943680 ], [ -100.720865, 45.944024 ], [ -100.750407, 45.943649 ], [ -100.762072, 45.943803 ], [ -100.762110, 45.943767 ], [ -100.769751, 45.943766 ], [ -100.890176, 45.943861 ], [ -100.935582, 45.943757 ], [ -100.938989, 45.943848 ], [ -100.964411, 45.943822 ], [ -100.976565, 45.943864 ], [ -100.980693, 45.944068 ], [ -101.101334, 45.943841 ], [ -101.106826, 45.943984 ], [ -101.142571, 45.943841 ], [ -101.146076, 45.943842 ], [ -101.163241, 45.943915 ], [ -101.171074, 45.943959 ], [ -101.175693, 45.943983 ], [ -101.179103, 45.943896 ], [ -101.203787, 45.943895 ], [ -101.224006, 45.944025 ], [ -101.271524, 45.944209 ], [ -101.287223, 45.944107 ], [ -101.313272, 45.944164 ], [ -101.333871, 45.944166 ], [ -101.365283, 45.944092 ], [ -101.370690, 45.944198 ], [ -101.373769, 45.944265 ], [ -101.557276, 45.944100 ], [ -101.562156, 45.944237 ], [ -101.628597, 45.944293 ], [ -101.657631, 45.944387 ], [ -101.680574, 45.944329 ], [ -101.681819, 45.944444 ], [ -101.708785, 45.944348 ], [ -101.723380, 45.944187 ], [ -101.730069, 45.944356 ], [ -101.758611, 45.944478 ], [ -101.764277, 45.944412 ], [ -101.765293, 45.944367 ], [ -101.766177, 45.944322 ], [ -101.790054, 45.944442 ], [ -101.794606, 45.944397 ], [ -101.832991, 45.944464 ], [ -101.852642, 45.944457 ], [ -101.886838, 45.944559 ], [ -101.957439, 45.944484 ], [ -101.973749, 45.944456 ], [ -101.989501, 45.944472 ], [ -101.992187, 45.944471 ], [ -101.998618, 45.944556 ], [ -101.998703, 45.944557 ], [ -102.000425, 45.944581 ], [ -102.000656, 45.944515 ], [ -102.000679, 45.944515 ], [ -102.060930, 45.944622 ], [ -102.085122, 45.944642 ], [ -102.087555, 45.944598 ], [ -102.124628, 45.944813 ], [ -102.125429, 45.944652 ], [ -102.135269, 45.944586 ], [ -102.145356, 45.944659 ], [ -102.156393, 45.944663 ], [ -102.157965, 45.944641 ], [ -102.159439, 45.944641 ], [ -102.176698, 45.944622 ], [ -102.176993, 45.944622 ], [ -102.217867, 45.944711 ], [ -102.328230, 45.944806 ], [ -102.353384, 45.944984 ], [ -102.354283, 45.944901 ], [ -102.392696, 45.944951 ], [ -102.392767, 45.944979 ], [ -102.396359, 45.944916 ], [ -102.398575, 45.944868 ], [ -102.406176, 45.944997 ], [ -102.410346, 45.945079 ], [ -102.420173, 45.945070 ], [ -102.425358, 45.944990 ], [ -102.425397, 45.945041 ], [ -102.446419, 45.945083 ], [ -102.459586, 45.945081 ], [ -102.467563, 45.945159 ], [ -102.476024, 45.945183 ], [ -102.550947, 45.945015 ], [ -102.558579, 45.945129 ], [ -102.642555, 45.945404 ], [ -102.651620, 45.945450 ], [ -102.666684, 45.945307 ], [ -102.672474, 45.945244 ], [ -102.674077, 45.945274 ], [ -102.704871, 45.945072 ], [ -102.880252, 45.945069 ], [ -102.920482, 45.945038 ], [ -102.942070, 45.945092 ], [ -102.989902, 45.945211 ], [ -102.995345, 45.945166 ], [ -102.995668, 45.945167 ], [ -103.026058, 45.945307 ], [ -103.047779, 45.945335 ], [ -103.078477, 45.945289 ], [ -103.097872, 45.945262 ], [ -103.140939, 45.945257 ], [ -103.161251, 45.945309 ], [ -103.210634, 45.945222 ], [ -103.218396, 45.945208 ], [ -103.284092, 45.945149 ], [ -103.284109, 45.945152 ], [ -103.411325, 45.945264 ], [ -103.418040, 45.945186 ], [ -103.432393, 45.945313 ], [ -103.434851, 45.945291 ], [ -103.558710, 45.945131 ], [ -103.577083, 45.945283 ], [ -103.660779, 45.945231 ], [ -103.660779, 45.945241 ], [ -103.668479, 45.945242 ], [ -104.045443, 45.945310 ], [ -104.046670, 46.000001 ], [ -104.045633, 46.280188 ], [ -104.045469, 46.324545 ], [ -104.045462, 46.341895 ], [ -104.045335, 46.540929 ], [ -104.045271, 46.641443 ], [ -104.045271, 46.641449 ], [ -104.045474, 46.708738 ], [ -104.045572, 46.713881 ], [ -104.045370, 46.721332 ], [ -104.045403, 46.722177 ], [ -104.045402, 46.725423 ], [ -104.045542, 46.933887 ], [ -104.045535, 46.934009 ], [ -104.045566, 46.941231 ], [ -104.045076, 47.037589 ], [ -104.045052, 47.040863 ], [ -104.045195, 47.053639 ], [ -104.045227, 47.057502 ], [ -104.045259, 47.063901 ], [ -104.045354, 47.078574 ], [ -104.045018, 47.081202 ], [ -104.045081, 47.092813 ], [ -104.045159, 47.263874 ], [ -104.045091, 47.265953 ], [ -104.045057, 47.266868 ], [ -104.045088, 47.271406 ], [ -104.045155, 47.273930 ], [ -104.045121, 47.276969 ], [ -104.045307, 47.330128 ], [ -104.045313, 47.331955 ], [ -104.045333, 47.343452 ], [ -104.045069, 47.397461 ], [ -104.044797, 47.438445 ], [ -104.044621, 47.459380 ], [ -104.043242, 47.747106 ], [ -104.043199, 47.747292 ], [ -104.042384, 47.803256 ], [ -104.042432, 47.805358 ], [ -104.042567, 47.808237 ], [ -104.041869, 47.841699 ], [ -104.041662, 47.862282 ], [ -104.042230, 47.891031 ], [ -104.043329, 47.949554 ], [ -104.043497, 47.954490 ], [ -104.043933, 47.971515 ], [ -104.044162, 47.992836 ], [ -104.044120, 47.996107 ], [ -104.045399, 48.164390 ], [ -104.045498, 48.176249 ], [ -104.045424, 48.192473 ], [ -104.045560, 48.193913 ], [ -104.045692, 48.241415 ], [ -104.045729, 48.244586 ], [ -104.045645, 48.246179 ], [ -104.045861, 48.255097 ], [ -104.046039, 48.256761 ], [ -104.046332, 48.342290 ], [ -104.046371, 48.374154 ], [ -104.046654, 48.374773 ], [ -104.046913, 48.389429 ], [ -104.046913, 48.389433 ], [ -104.046969, 48.390675 ], [ -104.047134, 48.411057 ], [ -104.046960, 48.421065 ], [ -104.047090, 48.445903 ], [ -104.047192, 48.447251 ], [ -104.047294, 48.452529 ], [ -104.047259, 48.452941 ], [ -104.047392, 48.467086 ], [ -104.047555, 48.494140 ], [ -104.047675, 48.517852 ], [ -104.047513, 48.525913 ], [ -104.047876, 48.530798 ], [ -104.047648, 48.531489 ], [ -104.047783, 48.539737 ], [ -104.047811, 48.562770 ], [ -104.047974, 48.591606 ], [ -104.048212, 48.599055 ], [ -104.047930, 48.620190 ], [ -104.047586, 48.625644 ], [ -104.047620, 48.627015 ], [ -104.047582, 48.633976 ], [ -104.047582, 48.633984 ], [ -104.047819, 48.648631 ], [ -104.047887, 48.649911 ], [ -104.047865, 48.657450 ], [ -104.047861, 48.658856 ], [ -104.047849, 48.663163 ], [ -104.047883, 48.664191 ], [ -104.048340, 48.747133 ], [ -104.048548, 48.751356 ], [ -104.048537, 48.788552 ], [ -104.048569, 48.797052 ], [ -104.048900, 48.847387 ], [ -104.048652, 48.865734 ], [ -104.048824, 48.867539 ], [ -104.048883, 48.874008 ], [ -104.048893, 48.875739 ], [ -104.048719, 48.879921 ], [ -104.048643, 48.902609 ], [ -104.048746, 48.906858 ], [ -104.048744, 48.912113 ], [ -104.048807, 48.933636 ], [ -104.048701, 48.940331 ], [ -104.048770, 48.943301 ], [ -104.048872, 48.949630 ], [ -104.048698, 48.951823 ], [ -104.048627, 48.957124 ], [ -104.048800, 48.958997 ], [ -104.048555, 48.963772 ], [ -104.048616, 48.966736 ], [ -104.048478, 48.987007 ], [ -104.048736, 48.999877 ], [ -103.992467, 48.999567 ], [ -103.988925, 48.999580 ], [ -103.983786, 48.999604 ], [ -103.982361, 48.999615 ], [ -103.980868, 48.999581 ], [ -103.976459, 48.999605 ], [ -103.969479, 48.999525 ], [ -103.968611, 48.999525 ], [ -103.923261, 48.999562 ], [ -103.921976, 48.999551 ], [ -103.918921, 48.999551 ], [ -103.917428, 48.999585 ], [ -103.876905, 48.999544 ], [ -103.865336, 48.999591 ], [ -103.862738, 48.999639 ], [ -103.858363, 48.999606 ], [ -103.856072, 48.999572 ], [ -103.852287, 48.999561 ], [ -102.938793, 48.998998 ], [ -102.216993, 48.998553 ], [ -102.211301, 48.998554 ], [ -102.151847, 48.998798 ], [ -102.131614, 48.998842 ], [ -102.021144, 48.999015 ], [ -101.496737, 48.999355 ], [ -101.225915, 48.999531 ], [ -101.225187, 48.999566 ], [ -101.220754, 48.999455 ], [ -101.216182, 48.999469 ], [ -100.920577, 48.999560 ], [ -100.917939, 48.999571 ], [ -100.913634, 48.999662 ], [ -100.907107, 48.999593 ], [ -100.433981, 48.999410 ], [ -100.434351, 48.999570 ], [ -100.431642, 48.999604 ], [ -100.431676, 48.999398 ], [ -100.182707, 48.999230 ], [ -99.913780, 48.999049 ], [ -99.913705, 48.999049 ], [ -99.861488, 48.999156 ], [ -99.861454, 48.999202 ], [ -99.525700, 48.999423 ], [ -98.999819, 48.999769 ], [ -97.950205, 49.000459 ], [ -97.775750, 49.000574 ], [ -97.411216, 49.000510 ], [ -97.229039, 49.000687 ], [ -97.234005, 48.997470 ], [ -97.238387, 48.982631 ], [ -97.239155, 48.967596 ], [ -97.232610, 48.946561 ], [ -97.199549, 48.881183 ], [ -97.157797, 48.787680 ], [ -97.137571, 48.749191 ], [ -97.092606, 48.682033 ], [ -97.163050, 48.543963 ], [ -97.163105, 48.543855 ], [ -97.161110, 48.543155 ], [ -97.150541, 48.539449 ], [ -97.126770, 48.520191 ], [ -97.123399, 48.421201 ], [ -97.131479, 48.406586 ], [ -97.145693, 48.397431 ], [ -97.136373, 48.352393 ], [ -97.126745, 48.342140 ], [ -97.115581, 48.323928 ], [ -97.116570, 48.279661 ], [ -97.129930, 48.249731 ], [ -97.134534, 48.249737 ], [ -97.143148, 48.246708 ], [ -97.147170, 48.242966 ], [ -97.147401, 48.193779 ], [ -97.147498, 48.173227 ], [ -97.147510, 48.170572 ], [ -97.123135, 48.109497 ], [ -97.098275, 48.071310 ], [ -97.088158, 48.059515 ], [ -97.023156, 47.873978 ], [ -97.000356, 47.860915 ], [ -96.980391, 47.815662 ], [ -96.890671, 47.672153 ], [ -96.885740, 47.664266 ], [ -96.850955, 47.598287 ], [ -96.842430, 47.508225 ], [ -96.853286, 47.503881 ], [ -96.853768, 47.499527 ], [ -96.862312, 47.422333 ], [ -96.852676, 47.374973 ], [ -96.833019, 47.238095 ], [ -96.832946, 47.237588 ], [ -96.826655, 47.150539 ], [ -96.824807, 47.124968 ], [ -96.823180, 46.999965 ], [ -96.824598, 46.993309 ], [ -96.823222, 46.970861 ], [ -96.791558, 46.934264 ], [ -96.780258, 46.928263 ], [ -96.767458, 46.905163 ], [ -96.802013, 46.812464 ], [ -96.784205, 46.686768 ], [ -96.783014, 46.630647 ], [ -96.783009, 46.630418 ], [ -96.783003, 46.630405 ], [ -96.739054, 46.543708 ], [ -96.716438, 46.444567 ], [ -96.721999, 46.439986 ], [ -96.669794, 46.384644 ], [ -96.631586, 46.353752 ], [ -96.598233, 46.312563 ], [ -96.599087, 46.263701 ], [ -96.585647, 46.177309 ], [ -96.578362, 46.170112 ], [ -96.557952, 46.102442 ], [ -96.554835, 46.084824 ], [ -96.556940, 46.064601 ], [ -96.559271, 46.058272 ], [ -96.566295, 46.051416 ], [ -96.577940, 46.026874 ], [ -96.577326, 46.021757 ], [ -96.570350, 45.963595 ], [ -96.563280, 45.935238 ], [ -96.576897, 45.935259 ], [ -96.597432, 45.935209 ], [ -96.607142, 45.935301 ], [ -96.618295, 45.935407 ], [ -96.639066, 45.935318 ], [ -96.659895, 45.935560 ], [ -96.680646, 45.935716 ], [ -96.701313, 45.935807 ], [ -96.791505, 45.935857 ], [ -96.998652, 45.935700 ], [ -97.019596, 45.935382 ], [ -97.118053, 45.935485 ], [ -97.144987, 45.935278 ], [ -97.228291, 45.935141 ], [ -97.228304, 45.935141 ], [ -97.228323, 45.935141 ], [ -97.312184, 45.935077 ], [ -97.318899, 45.935054 ], [ -97.481967, 45.935138 ], [ -97.491892, 45.935111 ], [ -97.518944, 45.935304 ], [ -97.519035, 45.935304 ], [ -97.542598, 45.935258 ], [ -97.696691, 45.935352 ], [ -97.777040, 45.935393 ], [ -97.784575, 45.935327 ], [ -97.958718, 45.935878 ], [ -97.978778, 45.935937 ], [ -97.986893, 45.935961 ], [ -98.008102, 45.936095 ], [ -98.008202, 45.936096 ], [ -98.070515, 45.936180 ], [ -98.184637, 45.936183 ], [ -98.185630, 45.936185 ], [ -98.724375, 45.938685 ], [ -98.904429, 45.939520 ], [ -98.905477, 45.939520 ], [ -99.005642, 45.939944 ], [ -99.005754, 45.939944 ], [ -99.092868, 45.940184 ], [ -99.102372, 45.940158 ], [ -99.212571, 45.940108 ], [ -99.213644, 45.940116 ], [ -99.221672, 45.940069 ], [ -99.222269, 45.940071 ], [ -99.257745, 45.940060 ], [ -99.276266, 45.940188 ], [ -99.283968, 45.940195 ], [ -99.297272, 45.940165 ], [ -99.317875, 45.940263 ], [ -99.344774, 45.940299 ], [ -99.344960, 45.940299 ], [ -99.378486, 45.940403 ], [ -99.385565, 45.940407 ], [ -99.401260, 45.940367 ], [ -99.490254, 45.940362 ], [ -99.493140, 45.940383 ], [ -99.588780, 45.941104 ], [ -99.611160, 45.941098 ], [ -99.671938, 45.941062 ], [ -99.692975, 45.940949 ], [ -99.718071, 45.940907 ], [ -99.718073, 45.940907 ], [ -99.747870, 45.940933 ], [ -99.749325, 45.940935 ], [ -99.749494, 45.940956 ], [ -99.750396, 45.940935 ], [ -99.838680, 45.941293 ], [ -99.880062, 45.941670 ], [ -99.880292, 45.941672 ], [ -99.965775, 45.941822 ], [ -100.005486, 45.941950 ], [ -100.069020, 45.942170 ], [ -100.084163, 45.942301 ], [ -100.108471, 45.942391 ], [ -100.110339, 45.942367 ], [ -100.141730, 45.942506 ], [ -100.152084, 45.942486 ], [ -100.170826, 45.942514 ], [ -100.274762, 45.942945 ], [ -100.275614, 45.942922 ], [ -100.284134, 45.942951 ], [ -100.285345, 45.943130 ], [ -100.294126, 45.943269 ], [ -100.410386, 45.943453 ], [ -100.420162, 45.943533 ], [ -100.424438, 45.943569 ], [ -100.430597, 45.943638 ], [ -100.462838, 45.943566 ], [ -100.499354, 45.943632 ], [ -100.511793, 45.943654 ], [ -100.511949, 45.943654 ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US40", "STATE": 16, "name": "Oklahoma", "LSAD": "", "CENSUSAREA": 68594.921000 }, "geometry": { "type": "Polygon", "coordinates": [ [ [ -100.000381, 34.746358 ], [ -100.000381, 34.746461 ], [ -100.000384, 35.030385 ], [ -100.000385, 35.182702 ], [ -100.000389, 35.422364 ], [ -100.000392, 35.619115 ], [ -100.000396, 35.880948 ], [ -100.000399, 36.055677 ], [ -100.000406, 36.499702 ], [ -100.003762, 36.499699 ], [ -100.090021, 36.499634 ], [ -100.181221, 36.499633 ], [ -100.310643, 36.499642 ], [ -100.311018, 36.499688 ], [ -100.311245, 36.499631 ], [ -100.324150, 36.499679 ], [ -100.334441, 36.499440 ], [ -100.334464, 36.499420 ], [ -100.351842, 36.499473 ], [ -100.351852, 36.499487 ], [ -100.378592, 36.499445 ], [ -100.378634, 36.499517 ], [ -100.413550, 36.499469 ], [ -100.413634, 36.499444 ], [ -100.421301, 36.499488 ], [ -100.421328, 36.499447 ], [ -100.433959, 36.499456 ], [ -100.441064, 36.499462 ], [ -100.441065, 36.499490 ], [ -100.522227, 36.499291 ], [ -100.530314, 36.499357 ], [ -100.530478, 36.499240 ], [ -100.531215, 36.499290 ], [ -100.531215, 36.499341 ], [ -100.546145, 36.499343 ], [ -100.578114, 36.499439 ], [ -100.578114, 36.499463 ], [ -100.583379, 36.499443 ], [ -100.583539, 36.499483 ], [ -100.592551, 36.499429 ], [ -100.592556, 36.499469 ], [ -100.592614, 36.499469 ], [ -100.648344, 36.499463 ], [ -100.648343, 36.499495 ], [ -100.657763, 36.499500 ], [ -100.657763, 36.499483 ], [ -100.708628, 36.499521 ], [ -100.708626, 36.499553 ], [ -100.724361, 36.499558 ], [ -100.724362, 36.499580 ], [ -100.761811, 36.499580 ], [ -100.761811, 36.499618 ], [ -100.802886, 36.499621 ], [ -100.802909, 36.499621 ], [ -100.806172, 36.499634 ], [ -100.806190, 36.499674 ], [ -100.824218, 36.499618 ], [ -100.824236, 36.499618 ], [ -100.850840, 36.499700 ], [ -100.859657, 36.499687 ], [ -100.884080, 36.499682 ], [ -100.884174, 36.499682 ], [ -100.918513, 36.499621 ], [ -100.936058, 36.499602 ], [ -100.954153, 36.499599 ], [ -100.977088, 36.499595 ], [ -101.045331, 36.499540 ], [ -101.052418, 36.499563 ], [ -101.085156, 36.499244 ], [ -101.623915, 36.499528 ], [ -101.649966, 36.499573 ], [ -101.653708, 36.499573 ], [ -101.698685, 36.499508 ], [ -101.709314, 36.499722 ], [ -101.779435, 36.499734 ], [ -101.780610, 36.499727 ], [ -101.781987, 36.499718 ], [ -101.783359, 36.499709 ], [ -101.788110, 36.499678 ], [ -101.826498, 36.499535 ], [ -101.826565, 36.499654 ], [ -102.032339, 36.500066 ], [ -102.162463, 36.500326 ], [ -103.002434, 36.500397 ], [ -103.002565, 36.526588 ], [ -103.002188, 36.602716 ], [ -103.002252, 36.617180 ], [ -103.002518, 36.675186 ], [ -103.002198, 36.719427 ], [ -103.001964, 36.909573 ], [ -103.002247, 36.911587 ], [ -103.002199, 37.000104 ], [ -102.986976, 36.998524 ], [ -102.985807, 36.998571 ], [ -102.979613, 36.998549 ], [ -102.875481, 36.999628 ], [ -102.570896, 36.995136 ], [ -102.355367, 36.994575 ], [ -102.355288, 36.994506 ], [ -102.208316, 36.993730 ], [ -102.184271, 36.993593 ], [ -102.054503, 36.993109 ], [ -102.042240, 36.993083 ], [ -102.028207, 36.993125 ], [ -102.028204, 36.993125 ], [ -102.000447, 36.993272 ], [ -102.000447, 36.993249 ], [ -101.902440, 36.993702 ], [ -101.601593, 36.995095 ], [ -101.600396, 36.995153 ], [ -101.555260, 36.995414 ], [ -101.555239, 36.995414 ], [ -101.519066, 36.995546 ], [ -101.485326, 36.995611 ], [ -101.415005, 36.995966 ], [ -101.413868, 36.996008 ], [ -101.378180, 36.996164 ], [ -101.359674, 36.996232 ], [ -101.357797, 36.996271 ], [ -101.212909, 36.997044 ], [ -101.211486, 36.997124 ], [ -101.066742, 36.997921 ], [ -101.053589, 36.997967 ], [ -101.012641, 36.998176 ], [ -100.996502, 36.998044 ], [ -100.945566, 36.998152 ], [ -100.945469, 36.998153 ], [ -100.904588, 36.998561 ], [ -100.904274, 36.998745 ], [ -100.891660, 36.998604 ], [ -100.855634, 36.998626 ], [ -100.814277, 36.999085 ], [ -100.806116, 36.999091 ], [ -100.765484, 36.999177 ], [ -100.756894, 36.999357 ], [ -100.675552, 36.999688 ], [ -100.633327, 36.999936 ], [ -100.633323, 36.999936 ], [ -100.629770, 37.000025 ], [ -100.591413, 37.000399 ], [ -100.591328, 37.000376 ], [ -100.552683, 37.000735 ], [ -100.551598, 37.000620 ], [ -100.201676, 37.002081 ], [ -100.193754, 37.002133 ], [ -100.192371, 37.002036 ], [ -100.187547, 37.002082 ], [ -100.115722, 37.002206 ], [ -100.089484, 37.002092 ], [ -100.005706, 37.001726 ], [ -100.002563, 37.001706 ], [ -100.001286, 37.001699 ], [ -99.995201, 37.001631 ], [ -99.786016, 37.000931 ], [ -99.774816, 37.000841 ], [ -99.774255, 37.000837 ], [ -99.657658, 37.000197 ], [ -99.625399, 36.999671 ], [ -99.558068, 36.999528 ], [ -99.541116, 36.999573 ], [ -99.508574, 36.999658 ], [ -99.504093, 36.999648 ], [ -99.502665, 36.999645 ], [ -99.500395, 36.999637 ], [ -99.500395, 36.999576 ], [ -99.484333, 36.999626 ], [ -99.456203, 36.999471 ], [ -99.277506, 36.999579 ], [ -99.248120, 36.999565 ], [ -99.129449, 36.999422 ], [ -99.124883, 36.999420 ], [ -99.029337, 36.999595 ], [ -99.000303, 36.999510 ], [ -98.994371, 36.999493 ], [ -98.880580, 36.999309 ], [ -98.880009, 36.999263 ], [ -98.869449, 36.999286 ], [ -98.797452, 36.999229 ], [ -98.793711, 36.999227 ], [ -98.791936, 36.999255 ], [ -98.761597, 36.999425 ], [ -98.718465, 36.999180 ], [ -98.714512, 36.999060 ], [ -98.544872, 36.998997 ], [ -98.544660, 36.998996 ], [ -98.420209, 36.998516 ], [ -98.418268, 36.998538 ], [ -98.408991, 36.998513 ], [ -98.354073, 36.997961 ], [ -98.347149, 36.997962 ], [ -98.346188, 36.997962 ], [ -98.237712, 36.997972 ], [ -98.219499, 36.997824 ], [ -98.208218, 36.997997 ], [ -98.177596, 36.998009 ], [ -98.147452, 36.998162 ], [ -98.111985, 36.998133 ], [ -98.045342, 36.998327 ], [ -98.039890, 36.998349 ], [ -98.033955, 36.998366 ], [ -97.802313, 36.998713 ], [ -97.802298, 36.998713 ], [ -97.783489, 36.998847 ], [ -97.783432, 36.998961 ], [ -97.768704, 36.998750 ], [ -97.697104, 36.998826 ], [ -97.650466, 36.999004 ], [ -97.637137, 36.999090 ], [ -97.606549, 36.998682 ], [ -97.564536, 36.998711 ], [ -97.546498, 36.998747 ], [ -97.545900, 36.998709 ], [ -97.527292, 36.998750 ], [ -97.472861, 36.998721 ], [ -97.462346, 36.998685 ], [ -97.462280, 36.998685 ], [ -97.384925, 36.998843 ], [ -97.372421, 36.998861 ], [ -97.147721, 36.999111 ], [ -97.122597, 36.999036 ], [ -97.120285, 36.999014 ], [ -97.104276, 36.999020 ], [ -97.100652, 36.998998 ], [ -97.039784, 36.999000 ], [ -97.030082, 36.998929 ], [ -96.975562, 36.999019 ], [ -96.967371, 36.999067 ], [ -96.934642, 36.999070 ], [ -96.921915, 36.999151 ], [ -96.917093, 36.999182 ], [ -96.903510, 36.999132 ], [ -96.902083, 36.999155 ], [ -96.876290, 36.999233 ], [ -96.867517, 36.999217 ], [ -96.822791, 36.999182 ], [ -96.795199, 36.998860 ], [ -96.792060, 36.999180 ], [ -96.749838, 36.998988 ], [ -96.741270, 36.999239 ], [ -96.736590, 36.999286 ], [ -96.710482, 36.999271 ], [ -96.705431, 36.999203 ], [ -96.525493, 36.999147 ], [ -96.415412, 36.999113 ], [ -96.394272, 36.999221 ], [ -96.279079, 36.999272 ], [ -96.276368, 36.999271 ], [ -96.217571, 36.999070 ], [ -96.200028, 36.999028 ], [ -96.184768, 36.999211 ], [ -96.154017, 36.999161 ], [ -96.152384, 36.999051 ], [ -96.149709, 36.999040 ], [ -96.147143, 36.999022 ], [ -96.143207, 36.999134 ], [ -96.141210, 36.998973 ], [ -96.000810, 36.998860 ], [ -95.964270, 36.999094 ], [ -95.936992, 36.999268 ], [ -95.928122, 36.999245 ], [ -95.910180, 36.999336 ], [ -95.877151, 36.999304 ], [ -95.875257, 36.999302 ], [ -95.873944, 36.999300 ], [ -95.866899, 36.999261 ], [ -95.807980, 36.999124 ], [ -95.786762, 36.999310 ], [ -95.768719, 36.999205 ], [ -95.759905, 36.999271 ], [ -95.741908, 36.999244 ], [ -95.718054, 36.999255 ], [ -95.714887, 36.999279 ], [ -95.710380, 36.999371 ], [ -95.696659, 36.999215 ], [ -95.686452, 36.999349 ], [ -95.664301, 36.999322 ], [ -95.630079, 36.999320 ], [ -95.624350, 36.999360 ], [ -95.615934, 36.999365 ], [ -95.612140, 36.999321 ], [ -95.573598, 36.999310 ], [ -95.534401, 36.999332 ], [ -95.522415, 36.999281 ], [ -95.511578, 36.999235 ], [ -95.407683, 36.999241 ], [ -95.407572, 36.999241 ], [ -95.331210, 36.999380 ], [ -95.328327, 36.999366 ], [ -95.328058, 36.999365 ], [ -95.322565, 36.999358 ], [ -95.195307, 36.999565 ], [ -95.177301, 36.999520 ], [ -95.155372, 36.999540 ], [ -95.155187, 36.999539 ], [ -95.073509, 36.999509 ], [ -95.073504, 36.999509 ], [ -95.049499, 36.999580 ], [ -95.037857, 36.999497 ], [ -95.030324, 36.999517 ], [ -95.011433, 36.999535 ], [ -95.007620, 36.999514 ], [ -94.995293, 36.999529 ], [ -94.853197, 36.998874 ], [ -94.849801, 36.998876 ], [ -94.840926, 36.998833 ], [ -94.831280, 36.998812 ], [ -94.777257, 36.998764 ], [ -94.739324, 36.998687 ], [ -94.737183, 36.998665 ], [ -94.712770, 36.998794 ], [ -94.701797, 36.998814 ], [ -94.699735, 36.998805 ], [ -94.618080, 36.998135 ], [ -94.618049, 36.996208 ], [ -94.618031, 36.994704 ], [ -94.618026, 36.950158 ], [ -94.618109, 36.946564 ], [ -94.618166, 36.937584 ], [ -94.618295, 36.929647 ], [ -94.618207, 36.926236 ], [ -94.618282, 36.911472 ], [ -94.618243, 36.897027 ], [ -94.618658, 36.880064 ], [ -94.618380, 36.847320 ], [ -94.618307, 36.766560 ], [ -94.618130, 36.701423 ], [ -94.618025, 36.669430 ], [ -94.618019, 36.667921 ], [ -94.617815, 36.612604 ], [ -94.617865, 36.606851 ], [ -94.617853, 36.599120 ], [ -94.617814, 36.577732 ], [ -94.617897, 36.536983 ], [ -94.617868, 36.536090 ], [ -94.617997, 36.534280 ], [ -94.617883, 36.517799 ], [ -94.617877, 36.514999 ], [ -94.617919, 36.499414 ], [ -94.615311, 36.484992 ], [ -94.613830, 36.476248 ], [ -94.611609, 36.461528 ], [ -94.605408, 36.421949 ], [ -94.602623, 36.405283 ], [ -94.601984, 36.402120 ], [ -94.599723, 36.387587 ], [ -94.593397, 36.345742 ], [ -94.586200, 36.299969 ], [ -94.577883, 36.250080 ], [ -94.577899, 36.249548 ], [ -94.576003, 36.240070 ], [ -94.575071, 36.233682 ], [ -94.574880, 36.232741 ], [ -94.574395, 36.229996 ], [ -94.571806, 36.213748 ], [ -94.571253, 36.210901 ], [ -94.566588, 36.183774 ], [ -94.565655, 36.178439 ], [ -94.562828, 36.161895 ], [ -94.562803, 36.161749 ], [ -94.561165, 36.152110 ], [ -94.552184, 36.102235 ], [ -94.547871, 36.078281 ], [ -94.547715, 36.077271 ], [ -94.535724, 36.007807 ], [ -94.534852, 36.002678 ], [ -94.533646, 35.996804 ], [ -94.532071, 35.987852 ], [ -94.528305, 35.966054 ], [ -94.528162, 35.965665 ], [ -94.524640, 35.945727 ], [ -94.524344, 35.944050 ], [ -94.522910, 35.936127 ], [ -94.522634, 35.934892 ], [ -94.522658, 35.934799 ], [ -94.522658, 35.934250 ], [ -94.507631, 35.845901 ], [ -94.505642, 35.833628 ], [ -94.504438, 35.826369 ], [ -94.503011, 35.817210 ], [ -94.501162, 35.806430 ], [ -94.500764, 35.803820 ], [ -94.500526, 35.802642 ], [ -94.499647, 35.796910 ], [ -94.499045, 35.793460 ], [ -94.494549, 35.768303 ], [ -94.493362, 35.761892 ], [ -94.492932, 35.759166 ], [ -94.488210, 35.729240 ], [ -94.487585, 35.726147 ], [ -94.472647, 35.638556 ], [ -94.465272, 35.594037 ], [ -94.464457, 35.588909 ], [ -94.464097, 35.587265 ], [ -94.463318, 35.582660 ], [ -94.431789, 35.397659 ], [ -94.431215, 35.394290 ], [ -94.433915, 35.387391 ], [ -94.433742, 35.386467 ], [ -94.432685, 35.380806 ], [ -94.431815, 35.362891 ], [ -94.434115, 35.306493 ], [ -94.435170, 35.291494 ], [ -94.435280, 35.287485 ], [ -94.435316, 35.275893 ], [ -94.435706, 35.274267 ], [ -94.435812, 35.271300 ], [ -94.437578, 35.242202 ], [ -94.437774, 35.239271 ], [ -94.438247, 35.210992 ], [ -94.438470, 35.208587 ], [ -94.439084, 35.197298 ], [ -94.439056, 35.193588 ], [ -94.439509, 35.171807 ], [ -94.439550, 35.169037 ], [ -94.440754, 35.128806 ], [ -94.441232, 35.119724 ], [ -94.447889, 34.933941 ], [ -94.449253, 34.895869 ], [ -94.449086, 34.894152 ], [ -94.449058, 34.890556 ], [ -94.449630, 34.875253 ], [ -94.450065, 34.861335 ], [ -94.450140, 34.858694 ], [ -94.450233, 34.855413 ], [ -94.454576, 34.728962 ], [ -94.457530, 34.642961 ], [ -94.457500, 34.634945 ], [ -94.460052, 34.547869 ], [ -94.460058, 34.545264 ], [ -94.461149, 34.507457 ], [ -94.463671, 34.419585 ], [ -94.463816, 34.414465 ], [ -94.464176, 34.402713 ], [ -94.465425, 34.359548 ], [ -94.465847, 34.352073 ], [ -94.470292, 34.189864 ], [ -94.474896, 34.021877 ], [ -94.474896, 34.021838 ], [ -94.474895, 34.019655 ], [ -94.476957, 33.957365 ], [ -94.477038, 33.953838 ], [ -94.477318, 33.940932 ], [ -94.477387, 33.937759 ], [ -94.478842, 33.881485 ], [ -94.478994, 33.881197 ], [ -94.479954, 33.851330 ], [ -94.480574, 33.830166 ], [ -94.481355, 33.802887 ], [ -94.481361, 33.802649 ], [ -94.481543, 33.795719 ], [ -94.481842, 33.789008 ], [ -94.482682, 33.756286 ], [ -94.482777, 33.753638 ], [ -94.482862, 33.750780 ], [ -94.482870, 33.750564 ], [ -94.483874, 33.716733 ], [ -94.483840, 33.711332 ], [ -94.484616, 33.691592 ], [ -94.484520, 33.687909 ], [ -94.485528, 33.663388 ], [ -94.485577, 33.653310 ], [ -94.485875, 33.637867 ], [ -94.487611, 33.628544 ], [ -94.490684, 33.625586 ], [ -94.524055, 33.615765 ], [ -94.528380, 33.615995 ], [ -94.660964, 33.660322 ], [ -94.735128, 33.691267 ], [ -94.746096, 33.703016 ], [ -94.760604, 33.727054 ], [ -94.822473, 33.732716 ], [ -94.869300, 33.745871 ], [ -95.039452, 33.860621 ], [ -95.062284, 33.903618 ], [ -95.063459, 33.914040 ], [ -95.067253, 33.917351 ], [ -95.129572, 33.936718 ], [ -95.155981, 33.944027 ], [ -95.219358, 33.961567 ], [ -95.226393, 33.961954 ], [ -95.231113, 33.960361 ], [ -95.252906, 33.933648 ], [ -95.253623, 33.929710 ], [ -95.249807, 33.922241 ], [ -95.248200, 33.912327 ], [ -95.249922, 33.902024 ], [ -95.255541, 33.892047 ], [ -95.260815, 33.887653 ], [ -95.287565, 33.873617 ], [ -95.310475, 33.871481 ], [ -95.339758, 33.868752 ], [ -95.407795, 33.866308 ], [ -95.445751, 33.868850 ], [ -95.544346, 33.880111 ], [ -95.548325, 33.882744 ], [ -95.552085, 33.888422 ], [ -95.552331, 33.894420 ], [ -95.549475, 33.901311 ], [ -95.549145, 33.907950 ], [ -95.559414, 33.930179 ], [ -95.567022, 33.932697 ], [ -95.599678, 33.934247 ], [ -95.757156, 33.867293 ], [ -95.763622, 33.847954 ], [ -95.824680, 33.837726 ], [ -95.846334, 33.841136 ], [ -95.949935, 33.857452 ], [ -96.097526, 33.847544 ], [ -96.148070, 33.837799 ], [ -96.156717, 33.813324 ], [ -96.164100, 33.784261 ], [ -96.170055, 33.769170 ], [ -96.181704, 33.758504 ], [ -96.199900, 33.752117 ], [ -96.220521, 33.747390 ], [ -96.229859, 33.748320 ], [ -96.304675, 33.745901 ], [ -96.369590, 33.716809 ], [ -96.378473, 33.726648 ], [ -96.423362, 33.776365 ], [ -96.436455, 33.780050 ], [ -96.448045, 33.781031 ], [ -96.500268, 33.772583 ], [ -96.612925, 33.833939 ], [ -96.614870, 33.841234 ], [ -96.615843, 33.853393 ], [ -96.612963, 33.867651 ], [ -96.611466, 33.875278 ], [ -96.613494, 33.878321 ], [ -96.615356, 33.881114 ], [ -96.622165, 33.885977 ], [ -96.633351, 33.889382 ], [ -96.646968, 33.895218 ], [ -96.658640, 33.900081 ], [ -96.672258, 33.899595 ], [ -96.678580, 33.892786 ], [ -96.682471, 33.883059 ], [ -96.685389, 33.872846 ], [ -96.689280, 33.861660 ], [ -96.694629, 33.849988 ], [ -96.700952, 33.840748 ], [ -96.707274, 33.835398 ], [ -96.712422, 33.831633 ], [ -96.761588, 33.824406 ], [ -96.856090, 33.847490 ], [ -96.866438, 33.853149 ], [ -96.883010, 33.868019 ], [ -96.895728, 33.896414 ], [ -96.899442, 33.933728 ], [ -96.907387, 33.950025 ], [ -96.916300, 33.957798 ], [ -96.922114, 33.959579 ], [ -96.934508, 33.953748 ], [ -96.944611, 33.948994 ], [ -96.972870, 33.935698 ], [ -96.985567, 33.886522 ], [ -97.006130, 33.861884 ], [ -97.047972, 33.817931 ], [ -97.092414, 33.733214 ], [ -97.097154, 33.727809 ], [ -97.107183, 33.721119 ], [ -97.121102, 33.717174 ], [ -97.137530, 33.718664 ], [ -97.151257, 33.722608 ], [ -97.162803, 33.729127 ], [ -97.163149, 33.729322 ], [ -97.172192, 33.737545 ], [ -97.204827, 33.799908 ], [ -97.204995, 33.818870 ], [ -97.199700, 33.827322 ], [ -97.194678, 33.831192 ], [ -97.181370, 33.831375 ], [ -97.171627, 33.835335 ], [ -97.166824, 33.840395 ], [ -97.166629, 33.847311 ], [ -97.180845, 33.895204 ], [ -97.185458, 33.900700 ], [ -97.210921, 33.916064 ], [ -97.226522, 33.914642 ], [ -97.310843, 33.872461 ], [ -97.372941, 33.819454 ], [ -97.426493, 33.819398 ], [ -97.444193, 33.823773 ], [ -97.453057, 33.828536 ], [ -97.459068, 33.834581 ], [ -97.462857, 33.841772 ], [ -97.461486, 33.849560 ], [ -97.457617, 33.855126 ], [ -97.451469, 33.870930 ], [ -97.450954, 33.891398 ], [ -97.458069, 33.901635 ], [ -97.484071, 33.915680 ], [ -97.486505, 33.916994 ], [ -97.500960, 33.919643 ], [ -97.519171, 33.913638 ], [ -97.545526, 33.900396 ], [ -97.555002, 33.897282 ], [ -97.561054, 33.898006 ], [ -97.581041, 33.900396 ], [ -97.587441, 33.902479 ], [ -97.596289, 33.913769 ], [ -97.597115, 33.917868 ], [ -97.588828, 33.951882 ], [ -97.589598, 33.953554 ], [ -97.609091, 33.968093 ], [ -97.656210, 33.989488 ], [ -97.671772, 33.991370 ], [ -97.688023, 33.986607 ], [ -97.693110, 33.983699 ], [ -97.700477, 33.972246 ], [ -97.733723, 33.936392 ], [ -97.785317, 33.890701 ], [ -97.834333, 33.857671 ], [ -97.865765, 33.849393 ], [ -97.877387, 33.850236 ], [ -97.966706, 33.881949 ], [ -97.977810, 33.889894 ], [ -97.977859, 33.889929 ], [ -97.953395, 33.936445 ], [ -97.945730, 33.989839 ], [ -97.983521, 34.001559 ], [ -98.019485, 33.993804 ], [ -98.041117, 33.993456 ], [ -98.085260, 34.003259 ], [ -98.088203, 34.005481 ], [ -98.106261, 34.033696 ], [ -98.169120, 34.114171 ], [ -98.200075, 34.116783 ], [ -98.293901, 34.133020 ], [ -98.300209, 34.134579 ], [ -98.325445, 34.151025 ], [ -98.364023, 34.157109 ], [ -98.383222, 34.147806 ], [ -98.398441, 34.128456 ], [ -98.400494, 34.121778 ], [ -98.433769, 34.096116 ], [ -98.475066, 34.064269 ], [ -98.504182, 34.072371 ], [ -98.553717, 34.133660 ], [ -98.577356, 34.149100 ], [ -98.599789, 34.160571 ], [ -98.610112, 34.161039 ], [ -98.637575, 34.162284 ], [ -98.652347, 34.161029 ], [ -98.665824, 34.151617 ], [ -98.700182, 34.135995 ], [ -98.765570, 34.136376 ], [ -98.858419, 34.152732 ], [ -98.920042, 34.182908 ], [ -98.952527, 34.195621 ], [ -98.966743, 34.201185 ], [ -99.060344, 34.204761 ], [ -99.119204, 34.201747 ], [ -99.157114, 34.207414 ], [ -99.190890, 34.215251 ], [ -99.211648, 34.292232 ], [ -99.211600, 34.313970 ], [ -99.209724, 34.324935 ], [ -99.211396, 34.337688 ], [ -99.211423, 34.337897 ], [ -99.261321, 34.403499 ], [ -99.356713, 34.442144 ], [ -99.398635, 34.375832 ], [ -99.407168, 34.372605 ], [ -99.440760, 34.374123 ], [ -99.453477, 34.388756 ], [ -99.474161, 34.398052 ], [ -99.499875, 34.409608 ], [ -99.515385, 34.414333 ], [ -99.574367, 34.418281 ], [ -99.580060, 34.416653 ], [ -99.616793, 34.375391 ], [ -99.663948, 34.373680 ], [ -99.694970, 34.378333 ], [ -99.767234, 34.430502 ], [ -99.793684, 34.453894 ], [ -99.846399, 34.505045 ], [ -99.864922, 34.523018 ], [ -99.872357, 34.532096 ], [ -99.874403, 34.537095 ], [ -99.884842, 34.546953 ], [ -99.923211, 34.574552 ], [ -99.945720, 34.579273 ], [ -99.954567, 34.578195 ], [ -99.997853, 34.561485 ], [ -100.000381, 34.560509 ], [ -100.000381, 34.746358 ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US42", "STATE": 17, "name": "Pennsylvania", "LSAD": "", "CENSUSAREA": 44742.703000 }, "geometry": { "type": "Polygon", "coordinates": [ [ [ -79.476662, 39.721078 ], [ -79.608223, 39.721154 ], [ -79.610623, 39.721245 ], [ -79.763774, 39.720776 ], [ -79.852904, 39.720713 ], [ -79.853131, 39.720713 ], [ -79.916266, 39.720792 ], [ -80.308651, 39.721283 ], [ -80.309457, 39.721264 ], [ -80.421388, 39.721189 ], [ -80.519342, 39.721403 ], [ -80.519248, 39.936967 ], [ -80.519115, 39.939188 ], [ -80.519175, 39.956648 ], [ -80.519203, 39.959394 ], [ -80.519217, 39.962199 ], [ -80.519218, 39.962424 ], [ -80.519207, 39.963381 ], [ -80.519120, 40.016410 ], [ -80.519008, 40.077001 ], [ -80.518960, 40.078089 ], [ -80.519104, 40.159672 ], [ -80.519056, 40.172744 ], [ -80.519056, 40.172771 ], [ -80.517991, 40.398868 ], [ -80.517998, 40.399644 ], [ -80.518692, 40.477365 ], [ -80.519054, 40.517922 ], [ -80.519057, 40.517922 ], [ -80.519055, 40.590173 ], [ -80.519086, 40.590161 ], [ -80.519086, 40.616385 ], [ -80.519039, 40.616391 ], [ -80.518991, 40.638801 ], [ -80.519058, 40.792298 ], [ -80.518992, 40.801221 ], [ -80.519081, 40.849157 ], [ -80.519020, 40.850073 ], [ -80.519039, 40.851339 ], [ -80.519764, 40.899858 ], [ -80.519790, 40.900761 ], [ -80.519091, 40.921061 ], [ -80.519000, 40.987380 ], [ -80.518989, 40.995445 ], [ -80.518927, 41.015387 ], [ -80.518960, 41.061546 ], [ -80.518928, 41.070954 ], [ -80.518960, 41.071866 ], [ -80.518999, 41.075014 ], [ -80.519088, 41.082074 ], [ -80.519092, 41.090658 ], [ -80.519125, 41.100819 ], [ -80.519192, 41.105358 ], [ -80.518992, 41.115958 ], [ -80.519056, 41.125057 ], [ -80.519012, 41.125057 ], [ -80.519012, 41.125093 ], [ -80.519012, 41.125116 ], [ -80.519167, 41.133343 ], [ -80.519167, 41.133388 ], [ -80.519115, 41.145520 ], [ -80.519144, 41.171203 ], [ -80.518830, 41.209213 ], [ -80.518893, 41.219356 ], [ -80.518893, 41.219357 ], [ -80.518893, 41.232556 ], [ -80.518693, 41.248855 ], [ -80.518893, 41.265155 ], [ -80.518993, 41.268155 ], [ -80.518996, 41.268300 ], [ -80.518794, 41.305509 ], [ -80.519129, 41.312408 ], [ -80.519265, 41.333495 ], [ -80.519281, 41.335958 ], [ -80.519281, 41.337145 ], [ -80.519281, 41.337174 ], [ -80.519311, 41.339052 ], [ -80.519293, 41.339054 ], [ -80.519293, 41.339654 ], [ -80.519345, 41.340145 ], [ -80.519345, 41.340740 ], [ -80.519297, 41.350833 ], [ -80.519249, 41.361030 ], [ -80.519217, 41.372006 ], [ -80.519249, 41.378918 ], [ -80.519025, 41.416438 ], [ -80.518993, 41.416437 ], [ -80.518993, 41.435454 ], [ -80.519169, 41.462581 ], [ -80.519209, 41.489013 ], [ -80.519225, 41.499924 ], [ -80.519157, 41.528769 ], [ -80.519339, 41.539297 ], [ -80.519357, 41.669767 ], [ -80.519424, 41.671228 ], [ -80.519373, 41.701473 ], [ -80.519408, 41.739359 ], [ -80.519369, 41.752487 ], [ -80.519239, 41.765138 ], [ -80.519294, 41.849563 ], [ -80.519345, 41.929168 ], [ -80.519304, 41.943992 ], [ -80.519405, 41.976158 ], [ -80.519425, 41.977522 ], [ -80.519425, 41.977523 ], [ -80.435451, 42.005611 ], [ -80.409776, 42.011578 ], [ -80.373066, 42.024102 ], [ -80.371869, 42.023966 ], [ -80.363251, 42.027973 ], [ -80.349169, 42.030243 ], [ -80.329976, 42.036168 ], [ -80.296758, 42.049076 ], [ -80.230486, 42.077957 ], [ -80.188085, 42.094257 ], [ -80.165884, 42.105857 ], [ -80.154084, 42.114757 ], [ -80.136213, 42.149937 ], [ -80.130430, 42.156331 ], [ -80.117368, 42.166341 ], [ -80.088512, 42.173184 ], [ -80.077388, 42.171262 ], [ -80.073381, 42.168658 ], [ -80.080028, 42.163625 ], [ -80.071981, 42.155357 ], [ -80.078781, 42.151457 ], [ -80.076281, 42.147857 ], [ -80.071980, 42.146057 ], [ -80.061080, 42.144857 ], [ -79.989186, 42.177051 ], [ -79.931324, 42.206737 ], [ -79.923924, 42.207546 ], [ -79.901050, 42.216701 ], [ -79.886187, 42.224933 ], [ -79.867979, 42.230999 ], [ -79.844661, 42.235486 ], [ -79.798447, 42.255939 ], [ -79.761951, 42.269860 ], [ -79.761964, 42.251354 ], [ -79.762152, 42.243054 ], [ -79.761833, 42.183627 ], [ -79.761929, 42.179693 ], [ -79.761921, 42.173319 ], [ -79.761759, 42.162675 ], [ -79.761861, 42.150712 ], [ -79.762122, 42.131246 ], [ -79.761374, 41.999067 ], [ -79.625287, 41.999003 ], [ -79.625301, 41.999068 ], [ -79.610839, 41.998989 ], [ -79.551385, 41.998666 ], [ -79.538445, 41.998527 ], [ -79.061265, 41.999259 ], [ -79.052473, 41.999179 ], [ -78.918854, 41.997961 ], [ -78.874759, 41.997559 ], [ -78.596650, 41.999877 ], [ -78.308128, 41.999415 ], [ -78.206606, 41.999989 ], [ -78.124730, 42.000452 ], [ -78.031177, 41.999415 ], [ -78.030963, 41.999392 ], [ -77.832030, 41.998524 ], [ -77.822799, 41.998547 ], [ -77.749931, 41.998782 ], [ -77.610028, 41.999519 ], [ -77.505308, 42.000070 ], [ -77.124693, 41.999395 ], [ -77.007635, 42.000848 ], [ -77.007536, 42.000819 ], [ -76.965728, 42.001274 ], [ -76.965686, 42.001274 ], [ -76.942585, 42.001574 ], [ -76.937084, 42.001674 ], [ -76.927084, 42.001674 ], [ -76.921884, 42.001674 ], [ -76.920784, 42.001774 ], [ -76.835079, 42.001773 ], [ -76.815878, 42.001673 ], [ -76.558118, 42.000155 ], [ -76.557624, 42.000149 ], [ -76.466540, 41.999025 ], [ -76.462155, 41.998934 ], [ -76.349898, 41.998410 ], [ -76.343722, 41.998346 ], [ -76.145519, 41.998913 ], [ -76.131201, 41.998954 ], [ -76.123696, 41.998954 ], [ -76.105840, 41.998858 ], [ -75.983082, 41.999035 ], [ -75.980250, 41.999035 ], [ -75.483738, 41.999244 ], [ -75.483150, 41.999259 ], [ -75.477144, 41.999407 ], [ -75.436216, 41.999353 ], [ -75.431961, 41.999363 ], [ -75.359579, 41.999445 ], [ -75.341868, 41.993262 ], [ -75.292589, 41.953897 ], [ -75.279094, 41.938917 ], [ -75.263005, 41.885109 ], [ -75.146446, 41.850899 ], [ -75.140241, 41.852078 ], [ -75.114399, 41.843583 ], [ -75.090799, 41.811991 ], [ -75.053431, 41.752538 ], [ -75.048199, 41.632011 ], [ -75.053077, 41.618552 ], [ -75.050074, 41.606893 ], [ -75.040490, 41.569688 ], [ -74.984226, 41.506299 ], [ -74.939760, 41.483371 ], [ -74.912517, 41.475605 ], [ -74.891948, 41.448853 ], [ -74.876721, 41.440338 ], [ -74.799165, 41.430451 ], [ -74.755950, 41.426804 ], [ -74.752562, 41.426518 ], [ -74.691129, 41.367324 ], [ -74.689767, 41.361558 ], [ -74.694914, 41.357423 ], [ -74.761730, 41.336398 ], [ -74.795847, 41.318951 ], [ -74.830057, 41.287200 ], [ -74.838366, 41.277286 ], [ -74.861678, 41.241575 ], [ -74.867267, 41.228861 ], [ -74.864356, 41.224854 ], [ -74.867287, 41.208754 ], [ -74.882139, 41.180836 ], [ -74.923169, 41.138146 ], [ -74.974338, 41.103912 ], [ -74.969434, 41.096074 ], [ -74.967389, 41.094049 ], [ -74.966759, 41.093425 ], [ -74.968389, 41.087797 ], [ -74.980674, 41.078178 ], [ -75.026003, 41.042687 ], [ -75.036982, 41.034702 ], [ -75.051794, 41.027142 ], [ -75.069277, 41.019348 ], [ -75.091377, 41.012283 ], [ -75.109114, 41.004102 ], [ -75.130575, 40.991093 ], [ -75.135526, 40.973807 ], [ -75.131364, 40.969277 ], [ -75.120564, 40.968313 ], [ -75.120435, 40.968302 ], [ -75.120316, 40.962630 ], [ -75.119893, 40.961646 ], [ -75.117764, 40.953023 ], [ -75.052538, 40.872051 ], [ -75.051029, 40.865662 ], [ -75.053294, 40.859900 ], [ -75.108505, 40.791094 ], [ -75.134400, 40.773765 ], [ -75.149378, 40.774786 ], [ -75.163650, 40.778386 ], [ -75.171587, 40.777745 ], [ -75.196533, 40.751631 ], [ -75.203920, 40.691498 ], [ -75.200708, 40.618356 ], [ -75.196803, 40.608580 ], [ -75.190858, 40.591342 ], [ -75.190161, 40.589321 ], [ -75.147368, 40.573152 ], [ -75.135389, 40.575624 ], [ -75.117292, 40.573211 ], [ -75.100325, 40.567811 ], [ -75.068615, 40.542223 ], [ -75.067344, 40.536428 ], [ -75.065090, 40.526148 ], [ -75.065853, 40.519495 ], [ -75.070568, 40.455165 ], [ -75.061489, 40.422848 ], [ -75.058848, 40.418065 ], [ -75.035548, 40.406309 ], [ -75.024775, 40.403455 ], [ -74.937954, 40.340634 ], [ -74.860492, 40.284584 ], [ -74.770706, 40.214908 ], [ -74.758613, 40.201342 ], [ -74.722304, 40.160609 ], [ -74.721604, 40.153810 ], [ -74.724179, 40.147324 ], [ -74.724304, 40.147010 ], [ -74.740605, 40.135210 ], [ -74.838008, 40.100910 ], [ -74.900236, 40.077149 ], [ -74.974290, 40.048872 ], [ -74.974713, 40.048711 ], [ -75.014343, 40.020976 ], [ -75.056039, 39.991795 ], [ -75.072017, 39.980612 ], [ -75.085754, 39.967572 ], [ -75.133220, 39.922512 ], [ -75.153925, 39.906144 ], [ -75.184952, 39.881615 ], [ -75.210425, 39.865913 ], [ -75.210972, 39.865706 ], [ -75.235026, 39.856613 ], [ -75.271159, 39.849440 ], [ -75.306500, 39.849812 ], [ -75.374635, 39.825770 ], [ -75.390169, 39.816549 ], [ -75.415041, 39.801786 ], [ -75.428038, 39.809212 ], [ -75.453740, 39.820312 ], [ -75.498843, 39.833312 ], [ -75.539346, 39.838211 ], [ -75.579849, 39.838526 ], [ -75.579900, 39.838522 ], [ -75.593082, 39.837500 ], [ -75.593666, 39.837455 ], [ -75.594846, 39.837286 ], [ -75.595756, 39.837156 ], [ -75.634706, 39.830164 ], [ -75.641518, 39.828363 ], [ -75.662822, 39.821150 ], [ -75.685991, 39.811054 ], [ -75.716969, 39.791998 ], [ -75.739705, 39.772623 ], [ -75.788359, 39.721811 ], [ -75.799563, 39.721882 ], [ -75.810068, 39.721906 ], [ -76.013067, 39.721920 ], [ -76.027618, 39.721833 ], [ -76.135584, 39.721556 ], [ -76.224191, 39.721328 ], [ -76.233259, 39.721305 ], [ -76.233277, 39.721305 ], [ -76.239805, 39.721305 ], [ -76.380083, 39.721304 ], [ -76.380583, 39.721304 ], [ -76.395583, 39.721204 ], [ -76.418684, 39.721304 ], [ -76.418784, 39.721204 ], [ -76.491887, 39.721304 ], [ -76.517087, 39.721304 ], [ -76.569389, 39.721203 ], [ -76.569475, 39.721203 ], [ -76.711894, 39.721103 ], [ -76.715594, 39.721103 ], [ -76.787096, 39.720802 ], [ -76.787097, 39.720802 ], [ -76.806397, 39.720602 ], [ -76.809197, 39.720702 ], [ -76.890100, 39.720401 ], [ -76.897566, 39.720401 ], [ -76.999465, 39.720128 ], [ -77.047104, 39.720000 ], [ -77.058204, 39.720200 ], [ -77.058904, 39.720100 ], [ -77.216806, 39.719998 ], [ -77.217024, 39.719998 ], [ -77.239807, 39.719998 ], [ -77.243307, 39.719998 ], [ -77.459427, 39.720017 ], [ -77.469145, 39.720018 ], [ -77.533371, 39.720165 ], [ -77.534758, 39.720134 ], [ -77.672249, 39.720778 ], [ -77.674522, 39.720847 ], [ -77.724115, 39.720894 ], [ -77.732615, 39.721094 ], [ -77.743204, 39.721205 ], [ -77.768534, 39.721358 ], [ -78.073736, 39.722314 ], [ -78.075771, 39.722301 ], [ -78.099140, 39.722322 ], [ -78.202895, 39.722416 ], [ -78.204450, 39.722520 ], [ -78.240334, 39.722498 ], [ -78.243103, 39.722481 ], [ -78.268948, 39.722590 ], [ -78.269020, 39.722613 ], [ -78.330715, 39.722689 ], [ -78.337111, 39.722461 ], [ -78.339539, 39.722552 ], [ -78.340498, 39.722514 ], [ -78.342520, 39.722539 ], [ -78.342834, 39.722539 ], [ -78.380599, 39.722554 ], [ -78.808387, 39.722726 ], [ -78.931175, 39.722775 ], [ -78.931176, 39.722775 ], [ -79.392458, 39.721340 ], [ -79.476662, 39.721078 ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US47", "STATE": 18, "name": "Tennessee", "LSAD": "", "CENSUSAREA": 41234.896000 }, "geometry": { "type": "Polygon", "coordinates": [ [ [ -83.472108, 36.597284 ], [ -83.276300, 36.598187 ], [ -83.250304, 36.593935 ], [ -83.249899, 36.593898 ], [ -83.248933, 36.593827 ], [ -83.028357, 36.593893 ], [ -83.027250, 36.593847 ], [ -82.985087, 36.593829 ], [ -82.830433, 36.593761 ], [ -82.695780, 36.593698 ], [ -82.679879, 36.593698 ], [ -82.609176, 36.594099 ], [ -82.561074, 36.594800 ], [ -82.559774, 36.594800 ], [ -82.554294, 36.594876 ], [ -82.293814, 36.595565 ], [ -82.243274, 36.595699 ], [ -82.226653, 36.595743 ], [ -82.225716, 36.595744 ], [ -82.223445, 36.595721 ], [ -82.221713, 36.595814 ], [ -82.211005, 36.595860 ], [ -82.210497, 36.595772 ], [ -82.188491, 36.595179 ], [ -82.180740, 36.594928 ], [ -82.177247, 36.594768 ], [ -82.173982, 36.594607 ], [ -82.150727, 36.594673 ], [ -82.148569, 36.594718 ], [ -82.146070, 36.594712 ], [ -81.934144, 36.594213 ], [ -81.922644, 36.616213 ], [ -81.826742, 36.614215 ], [ -81.646900, 36.611918 ], [ -81.677535, 36.588117 ], [ -81.699962, 36.539714 ], [ -81.707963, 36.536209 ], [ -81.700553, 36.515190 ], [ -81.700093, 36.514158 ], [ -81.699601, 36.512883 ], [ -81.699446, 36.511504 ], [ -81.697744, 36.508448 ], [ -81.697829, 36.507544 ], [ -81.697290, 36.504887 ], [ -81.697970, 36.504063 ], [ -81.699923, 36.500865 ], [ -81.700238, 36.500475 ], [ -81.699928, 36.498018 ], [ -81.698265, 36.497221 ], [ -81.697261, 36.496141 ], [ -81.696835, 36.493393 ], [ -81.695907, 36.491580 ], [ -81.697287, 36.484738 ], [ -81.715082, 36.453365 ], [ -81.714277, 36.450978 ], [ -81.720969, 36.387500 ], [ -81.725938, 36.340364 ], [ -81.730976, 36.341187 ], [ -81.747842, 36.337356 ], [ -81.764927, 36.338672 ], [ -81.789712, 36.348324 ], [ -81.793688, 36.360428 ], [ -81.800812, 36.358073 ], [ -81.855005, 36.337259 ], [ -81.908137, 36.302013 ], [ -81.918113, 36.287110 ], [ -81.932994, 36.264881 ], [ -81.960101, 36.228131 ], [ -82.026640, 36.130222 ], [ -82.080143, 36.105720 ], [ -82.080518, 36.105710 ], [ -82.127146, 36.104417 ], [ -82.130646, 36.106417 ], [ -82.137974, 36.119576 ], [ -82.136547, 36.128817 ], [ -82.147948, 36.149516 ], [ -82.211251, 36.159012 ], [ -82.222052, 36.156911 ], [ -82.234807, 36.141720 ], [ -82.235479, 36.140748 ], [ -82.236415, 36.139926 ], [ -82.237737, 36.139189 ], [ -82.325169, 36.119363 ], [ -82.329177, 36.117427 ], [ -82.348422, 36.115929 ], [ -82.360919, 36.110614 ], [ -82.366566, 36.107650 ], [ -82.371383, 36.106388 ], [ -82.375558, 36.105609 ], [ -82.409458, 36.083409 ], [ -82.416857, 36.072885 ], [ -82.462958, 36.007309 ], [ -82.487411, 35.991634 ], [ -82.487451, 35.991557 ], [ -82.505860, 35.978342 ], [ -82.507068, 35.977475 ], [ -82.512598, 35.975664 ], [ -82.557529, 35.954671 ], [ -82.596774, 35.964987 ], [ -82.611262, 35.973155 ], [ -82.615062, 36.000306 ], [ -82.602877, 36.039833 ], [ -82.619205, 36.056556 ], [ -82.632265, 36.065705 ], [ -82.637165, 36.065805 ], [ -82.683565, 36.046104 ], [ -82.715365, 36.024253 ], [ -82.754465, 36.004304 ], [ -82.778625, 35.974792 ], [ -82.830112, 35.932972 ], [ -82.852554, 35.949089 ], [ -82.874159, 35.952698 ], [ -82.898505, 35.945101 ], [ -82.898506, 35.945100 ], [ -82.913338, 35.924113 ], [ -82.897980, 35.881278 ], [ -82.918356, 35.845467 ], [ -82.962842, 35.795126 ], [ -82.964108, 35.794100 ], [ -82.983970, 35.778010 ], [ -82.995803, 35.773128 ], [ -83.100225, 35.774765 ], [ -83.100329, 35.774804 ], [ -83.100233, 35.774745 ], [ -83.164909, 35.759965 ], [ -83.240669, 35.726760 ], [ -83.251247, 35.719916 ], [ -83.255489, 35.714974 ], [ -83.250695, 35.709349 ], [ -83.254231, 35.695807 ], [ -83.297154, 35.657750 ], [ -83.366941, 35.638728 ], [ -83.445802, 35.611803 ], [ -83.479082, 35.583316 ], [ -83.478523, 35.579202 ], [ -83.480617, 35.576633 ], [ -83.485527, 35.568204 ], [ -83.498335, 35.562981 ], [ -83.640498, 35.566075 ], [ -83.662957, 35.569138 ], [ -83.676268, 35.570289 ], [ -83.756917, 35.563604 ], [ -83.880074, 35.518745 ], [ -83.933876, 35.472438 ], [ -83.952676, 35.460763 ], [ -83.952882, 35.460635 ], [ -83.961053, 35.464143 ], [ -83.961056, 35.463738 ], [ -83.961054, 35.462838 ], [ -83.961400, 35.459496 ], [ -83.999906, 35.425201 ], [ -84.002250, 35.422548 ], [ -84.024756, 35.353896 ], [ -84.035343, 35.350833 ], [ -84.037494, 35.349850 ], [ -84.038081, 35.348363 ], [ -84.032450, 35.326530 ], [ -84.032479, 35.325318 ], [ -84.021410, 35.301383 ], [ -84.023510, 35.295783 ], [ -84.029033, 35.291049 ], [ -84.055712, 35.268182 ], [ -84.097508, 35.247382 ], [ -84.115048, 35.249765 ], [ -84.115279, 35.250438 ], [ -84.121150, 35.250644 ], [ -84.124915, 35.249830 ], [ -84.202879, 35.255772 ], [ -84.211818, 35.266078 ], [ -84.223718, 35.269078 ], [ -84.227818, 35.267878 ], [ -84.290240, 35.225572 ], [ -84.292321, 35.206677 ], [ -84.308437, 35.093173 ], [ -84.308576, 35.092761 ], [ -84.321869, 34.988408 ], [ -84.393935, 34.988068 ], [ -84.394903, 34.988030 ], [ -84.509052, 34.988033 ], [ -84.509886, 34.988010 ], [ -84.621483, 34.988329 ], [ -84.727434, 34.988020 ], [ -84.731022, 34.988088 ], [ -84.775852, 34.987800 ], [ -84.808127, 34.987592 ], [ -84.809184, 34.987569 ], [ -84.810477, 34.987607 ], [ -84.810742, 34.987615 ], [ -84.817279, 34.987753 ], [ -84.820478, 34.987913 ], [ -84.824010, 34.987707 ], [ -84.831799, 34.988004 ], [ -84.858032, 34.987746 ], [ -84.861314, 34.987791 ], [ -84.939306, 34.987916 ], [ -84.944420, 34.987864 ], [ -84.955623, 34.987830 ], [ -84.976973, 34.987669 ], [ -84.979860, 34.987647 ], [ -85.045052, 34.986859 ], [ -85.045183, 34.986883 ], [ -85.180553, 34.986075 ], [ -85.185905, 34.985995 ], [ -85.216554, 34.985675 ], [ -85.217854, 34.985675 ], [ -85.220554, 34.985575 ], [ -85.221854, 34.985475 ], [ -85.230354, 34.985475 ], [ -85.235555, 34.985475 ], [ -85.254955, 34.985175 ], [ -85.265055, 34.985075 ], [ -85.275856, 34.984975 ], [ -85.277556, 34.984975 ], [ -85.294500, 34.984651 ], [ -85.301488, 34.984475 ], [ -85.305457, 34.984475 ], [ -85.308257, 34.984375 ], [ -85.363919, 34.983375 ], [ -85.474472, 34.983972 ], [ -85.605165, 34.984678 ], [ -85.824411, 34.988142 ], [ -85.828724, 34.988165 ], [ -85.863935, 34.988379 ], [ -86.311274, 34.991098 ], [ -86.318761, 34.991147 ], [ -86.397203, 34.991660 ], [ -86.433927, 34.991085 ], [ -86.467798, 34.990692 ], [ -86.528485, 34.990677 ], [ -86.555864, 34.990971 ], [ -86.571217, 34.991011 ], [ -86.588962, 34.991197 ], [ -86.600039, 34.991240 ], [ -86.641212, 34.991740 ], [ -86.659610, 34.991792 ], [ -86.670853, 34.992000 ], [ -86.674360, 34.992001 ], [ -86.676726, 34.992070 ], [ -86.677616, 34.992070 ], [ -86.783628, 34.991925 ], [ -86.783648, 34.991925 ], [ -86.820657, 34.991764 ], [ -86.836306, 34.991764 ], [ -86.836370, 34.991764 ], [ -86.846466, 34.991860 ], [ -86.849794, 34.991924 ], [ -86.862147, 34.991956 ], [ -86.967120, 34.994400 ], [ -86.970236, 34.994546 ], [ -86.972613, 34.994610 ], [ -86.974412, 34.994513 ], [ -87.000007, 34.995121 ], [ -87.011174, 34.995162 ], [ -87.210759, 34.999024 ], [ -87.216683, 34.999148 ], [ -87.224053, 34.999327 ], [ -87.230544, 34.999484 ], [ -87.270014, 35.000390 ], [ -87.299185, 35.000915 ], [ -87.349251, 35.001662 ], [ -87.359281, 35.001823 ], [ -87.381071, 35.002118 ], [ -87.391314, 35.002374 ], [ -87.417400, 35.002669 ], [ -87.421543, 35.002679 ], [ -87.428613, 35.002795 ], [ -87.606031, 35.003343 ], [ -87.664123, 35.003523 ], [ -87.671405, 35.003537 ], [ -87.696834, 35.003852 ], [ -87.700543, 35.003988 ], [ -87.702321, 35.003945 ], [ -87.709491, 35.004089 ], [ -87.758890, 35.004711 ], [ -87.767602, 35.004783 ], [ -87.773586, 35.004946 ], [ -87.851886, 35.005656 ], [ -87.853411, 35.005576 ], [ -87.853528, 35.005541 ], [ -87.872626, 35.005571 ], [ -87.877742, 35.005512 ], [ -87.877969, 35.005468 ], [ -87.984916, 35.006256 ], [ -88.182450, 35.007712 ], [ -88.200064, 34.995634 ], [ -88.253825, 34.995553 ], [ -88.258111, 34.995463 ], [ -88.363531, 34.995590 ], [ -88.380508, 34.995610 ], [ -88.469801, 34.996052 ], [ -88.469877, 34.996033 ], [ -88.786612, 34.995252 ], [ -88.823049, 34.995157 ], [ -89.017128, 34.994649 ], [ -89.138997, 34.994330 ], [ -89.139136, 34.994307 ], [ -89.198288, 34.994484 ], [ -89.352679, 34.994420 ], [ -89.493739, 34.994361 ], [ -89.511153, 34.994755 ], [ -89.644282, 34.995293 ], [ -89.724324, 34.994763 ], [ -89.795187, 34.994293 ], [ -89.848488, 34.994193 ], [ -89.883365, 34.994261 ], [ -89.893402, 34.994356 ], [ -90.309297, 34.995694 ], [ -90.309877, 35.009750 ], [ -90.295596, 35.040093 ], [ -90.193859, 35.061646 ], [ -90.174594, 35.116682 ], [ -90.160058, 35.128830 ], [ -90.142794, 35.135091 ], [ -90.109393, 35.118891 ], [ -90.100593, 35.116691 ], [ -90.090610, 35.118287 ], [ -90.083420, 35.121670 ], [ -90.065392, 35.137691 ], [ -90.064612, 35.140621 ], [ -90.073354, 35.211004 ], [ -90.074262, 35.218316 ], [ -90.077410, 35.225479 ], [ -90.097947, 35.249983 ], [ -90.105093, 35.254288 ], [ -90.116493, 35.255788 ], [ -90.140394, 35.252289 ], [ -90.152094, 35.255989 ], [ -90.158865, 35.262577 ], [ -90.166594, 35.274588 ], [ -90.168871, 35.281997 ], [ -90.163812, 35.296115 ], [ -90.158913, 35.300637 ], [ -90.153394, 35.302588 ], [ -90.114893, 35.303887 ], [ -90.086691, 35.369935 ], [ -90.089612, 35.379842 ], [ -90.093589, 35.393333 ], [ -90.135510, 35.376668 ], [ -90.143633, 35.374745 ], [ -90.166246, 35.374745 ], [ -90.178341, 35.382092 ], [ -90.179265, 35.385194 ], [ -90.169002, 35.421853 ], [ -90.152386, 35.436789 ], [ -90.107723, 35.476935 ], [ -90.074420, 35.472518 ], [ -90.072154, 35.470752 ], [ -90.067798, 35.466224 ], [ -90.059068, 35.457889 ], [ -90.047680, 35.459255 ], [ -90.034014, 35.468821 ], [ -90.034976, 35.480705 ], [ -90.039744, 35.548041 ], [ -90.032938, 35.553440 ], [ -90.028620, 35.555249 ], [ -90.017312, 35.555996 ], [ -89.957347, 35.528683 ], [ -89.933572, 35.533299 ], [ -89.909797, 35.537914 ], [ -89.884932, 35.655107 ], [ -89.890510, 35.652408 ], [ -89.906147, 35.651145 ], [ -89.922749, 35.655293 ], [ -89.937383, 35.665711 ], [ -89.955753, 35.690621 ], [ -89.958882, 35.723834 ], [ -89.956254, 35.733386 ], [ -89.950278, 35.738493 ], [ -89.909996, 35.759396 ], [ -89.905538, 35.759063 ], [ -89.889023, 35.750558 ], [ -89.865631, 35.746577 ], [ -89.821216, 35.756716 ], [ -89.703875, 35.820281 ], [ -89.701045, 35.828227 ], [ -89.702883, 35.834153 ], [ -89.709261, 35.838911 ], [ -89.729517, 35.847632 ], [ -89.749424, 35.852955 ], [ -89.769413, 35.861558 ], [ -89.772467, 35.865098 ], [ -89.773564, 35.871697 ], [ -89.771726, 35.879724 ], [ -89.765689, 35.891299 ], [ -89.756036, 35.896817 ], [ -89.733610, 35.904699 ], [ -89.714934, 35.906247 ], [ -89.688141, 35.896946 ], [ -89.687939, 35.905384 ], [ -89.686924, 35.947716 ], [ -89.719970, 35.974620 ], [ -89.733095, 36.000608 ], [ -89.706932, 36.000981 ], [ -89.690306, 36.024835 ], [ -89.687254, 36.034048 ], [ -89.684439, 36.051719 ], [ -89.624235, 36.108626 ], [ -89.601936, 36.119470 ], [ -89.594000, 36.127190 ], [ -89.591605, 36.144096 ], [ -89.594397, 36.155457 ], [ -89.607004, 36.171179 ], [ -89.618228, 36.179966 ], [ -89.629452, 36.185382 ], [ -89.699817, 36.248384 ], [ -89.691308, 36.252079 ], [ -89.678046, 36.248284 ], [ -89.602374, 36.238106 ], [ -89.589561, 36.239116 ], [ -89.541621, 36.247891 ], [ -89.534745, 36.252576 ], [ -89.535529, 36.270541 ], [ -89.539487, 36.277368 ], [ -89.544797, 36.280458 ], [ -89.554289, 36.277751 ], [ -89.578492, 36.288317 ], [ -89.611819, 36.309088 ], [ -89.620255, 36.323006 ], [ -89.619800, 36.329546 ], [ -89.615841, 36.336085 ], [ -89.610689, 36.340442 ], [ -89.605668, 36.342234 ], [ -89.581636, 36.342357 ], [ -89.560439, 36.337746 ], [ -89.545006, 36.336809 ], [ -89.531822, 36.339246 ], [ -89.519000, 36.348600 ], [ -89.513178, 36.359897 ], [ -89.509558, 36.375065 ], [ -89.519501, 36.475419 ], [ -89.522674, 36.481305 ], [ -89.539100, 36.498201 ], [ -89.498036, 36.497887 ], [ -89.492537, 36.497775 ], [ -89.485106, 36.497692 ], [ -89.493495, 36.478700 ], [ -89.493198, 36.470124 ], [ -89.486215, 36.461620 ], [ -89.471718, 36.457001 ], [ -89.460436, 36.458140 ], [ -89.448468, 36.464420 ], [ -89.429311, 36.481875 ], [ -89.417293, 36.499033 ], [ -89.403913, 36.499141 ], [ -89.381792, 36.500062 ], [ -89.380085, 36.500416 ], [ -89.356593, 36.502195 ], [ -89.346056, 36.503210 ], [ -89.346053, 36.503210 ], [ -89.282298, 36.506782 ], [ -89.279091, 36.506511 ], [ -89.211409, 36.505630 ], [ -89.163429, 36.504526 ], [ -89.163224, 36.504522 ], [ -89.119805, 36.503647 ], [ -89.117537, 36.503603 ], [ -89.090146, 36.503392 ], [ -89.072118, 36.503249 ], [ -89.058871, 36.503157 ], [ -89.034649, 36.502964 ], [ -89.010439, 36.502710 ], [ -89.006825, 36.502684 ], [ -89.000063, 36.502633 ], [ -88.964471, 36.502191 ], [ -88.874725, 36.502446 ], [ -88.834866, 36.502911 ], [ -88.834626, 36.502914 ], [ -88.827301, 36.502852 ], [ -88.827012, 36.502850 ], [ -88.816765, 36.502815 ], [ -88.799594, 36.502757 ], [ -88.747523, 36.502834 ], [ -88.715255, 36.502662 ], [ -88.661133, 36.502243 ], [ -88.577283, 36.501940 ], [ -88.545192, 36.501814 ], [ -88.516427, 36.501430 ], [ -88.516346, 36.501431 ], [ -88.512270, 36.501506 ], [ -88.511920, 36.501457 ], [ -88.489210, 36.501068 ], [ -88.489075, 36.501068 ], [ -88.472564, 36.501028 ], [ -88.452543, 36.500872 ], [ -88.450161, 36.501101 ], [ -88.416360, 36.500756 ], [ -88.330799, 36.500531 ], [ -88.325895, 36.500483 ], [ -88.320794, 36.500432 ], [ -88.053292, 36.497130 ], [ -88.053205, 36.497129 ], [ -88.039481, 36.510408 ], [ -88.037822, 36.513850 ], [ -88.032489, 36.540662 ], [ -88.035625, 36.561736 ], [ -88.045127, 36.602939 ], [ -88.055604, 36.635710 ], [ -88.068208, 36.659747 ], [ -88.070532, 36.678118 ], [ -88.011792, 36.677025 ], [ -87.849567, 36.663701 ], [ -87.853204, 36.633247 ], [ -87.694186, 36.636838 ], [ -87.641150, 36.638036 ], [ -87.641146, 36.638036 ], [ -87.564928, 36.639113 ], [ -87.563052, 36.639113 ], [ -87.436509, 36.640747 ], [ -87.425009, 36.641047 ], [ -87.414309, 36.641047 ], [ -87.347796, 36.641440 ], [ -87.344131, 36.641510 ], [ -87.335980, 36.641543 ], [ -87.281506, 36.641761 ], [ -87.278398, 36.641718 ], [ -87.247655, 36.641841 ], [ -87.231037, 36.641888 ], [ -87.230530, 36.641895 ], [ -87.114983, 36.642414 ], [ -87.114976, 36.642414 ], [ -87.060843, 36.643412 ], [ -86.906583, 36.646255 ], [ -86.906023, 36.646302 ], [ -86.854268, 36.646884 ], [ -86.833155, 36.647210 ], [ -86.818405, 36.647639 ], [ -86.816186, 36.647722 ], [ -86.813037, 36.647647 ], [ -86.763295, 36.648907 ], [ -86.758920, 36.649018 ], [ -86.606394, 36.652107 ], [ -86.605042, 36.652125 ], [ -86.564252, 36.633522 ], [ -86.564143, 36.633472 ], [ -86.473497, 36.651671 ], [ -86.473413, 36.651676 ], [ -86.472190, 36.651763 ], [ -86.468497, 36.651841 ], [ -86.411387, 36.650550 ], [ -86.333051, 36.648778 ], [ -86.222151, 36.640891 ], [ -86.219081, 36.640824 ], [ -86.216410, 36.640595 ], [ -86.216183, 36.640527 ], [ -86.205468, 36.639783 ], [ -86.204859, 36.639741 ], [ -86.197573, 36.639363 ], [ -86.081944, 36.633848 ], [ -86.080666, 36.633940 ], [ -86.038366, 36.630804 ], [ -86.033139, 36.630413 ], [ -86.032770, 36.630367 ], [ -85.976421, 36.628400 ], [ -85.788645, 36.621846 ], [ -85.788613, 36.621845 ], [ -85.552017, 36.615782 ], [ -85.551483, 36.615727 ], [ -85.508605, 36.615020 ], [ -85.471338, 36.616380 ], [ -85.436418, 36.618194 ], [ -85.295990, 36.625488 ], [ -85.276289, 36.626511 ], [ -85.276284, 36.626511 ], [ -85.096128, 36.622483 ], [ -85.086415, 36.621913 ], [ -84.974888, 36.614327 ], [ -84.859738, 36.606495 ], [ -84.859759, 36.606428 ], [ -84.785399, 36.603374 ], [ -84.785341, 36.603372 ], [ -84.778455, 36.603222 ], [ -84.261333, 36.591981 ], [ -84.227295, 36.591685 ], [ -83.987842, 36.589600 ], [ -83.987612, 36.589595 ], [ -83.930669, 36.588249 ], [ -83.690714, 36.582581 ], [ -83.677114, 36.596582 ], [ -83.675413, 36.600814 ], [ -83.670141, 36.600797 ], [ -83.670128, 36.600764 ], [ -83.472108, 36.597284 ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US51", "STATE": 19, "name": "Virginia", "LSAD": "", "CENSUSAREA": 39490.086000 }, "geometry": { "type": "MultiPolygon", "coordinates": [ [ [ [ -75.242266, 38.027209 ], [ -75.296871, 37.959043 ], [ -75.319335, 37.922484 ], [ -75.334296, 37.893477 ], [ -75.349338, 37.873143 ], [ -75.359036, 37.864143 ], [ -75.366830, 37.859446 ], [ -75.374642, 37.859454 ], [ -75.392008, 37.867738 ], [ -75.400540, 37.874865 ], [ -75.428956, 37.875305 ], [ -75.437868, 37.872324 ], [ -75.452681, 37.863510 ], [ -75.467951, 37.851328 ], [ -75.487485, 37.832136 ], [ -75.514921, 37.799149 ], [ -75.548082, 37.742383 ], [ -75.556868, 37.724410 ], [ -75.572464, 37.701565 ], [ -75.581333, 37.683593 ], [ -75.586136, 37.660653 ], [ -75.603220, 37.620243 ], [ -75.610808, 37.605909 ], [ -75.612237, 37.585602 ], [ -75.608123, 37.578018 ], [ -75.595716, 37.576657 ], [ -75.594044, 37.569698 ], [ -75.606720, 37.557170 ], [ -75.633370, 37.522140 ], [ -75.666178, 37.472124 ], [ -75.665500, 37.467319 ], [ -75.664311, 37.458901 ], [ -75.661790, 37.455028 ], [ -75.665957, 37.439209 ], [ -75.672648, 37.429915 ], [ -75.697914, 37.405301 ], [ -75.720739, 37.373129 ], [ -75.727335, 37.360346 ], [ -75.725634, 37.358416 ], [ -75.726691, 37.350127 ], [ -75.735829, 37.335426 ], [ -75.765401, 37.305596 ], [ -75.778817, 37.297176 ], [ -75.780766, 37.297222 ], [ -75.784634, 37.300976 ], [ -75.791913, 37.300589 ], [ -75.798448, 37.296285 ], [ -75.790830, 37.276207 ], [ -75.799343, 37.251779 ], [ -75.795881, 37.236922 ], [ -75.790386, 37.231225 ], [ -75.789929, 37.228134 ], [ -75.790903, 37.225066 ], [ -75.804446, 37.208011 ], [ -75.800468, 37.201029 ], [ -75.800755, 37.197297 ], [ -75.830341, 37.170600 ], [ -75.877670, 37.135604 ], [ -75.886369, 37.126085 ], [ -75.897298, 37.118037 ], [ -75.906734, 37.114193 ], [ -75.912308, 37.115154 ], [ -75.913222, 37.119849 ], [ -75.925520, 37.133601 ], [ -75.942539, 37.125142 ], [ -75.945872, 37.120514 ], [ -75.962596, 37.117535 ], [ -75.970430, 37.118608 ], [ -75.970004, 37.128861 ], [ -75.978083, 37.157338 ], [ -75.998647, 37.188739 ], [ -76.006094, 37.194810 ], [ -76.013071, 37.205366 ], [ -76.013778, 37.219263 ], [ -76.010535, 37.231579 ], [ -76.014026, 37.235381 ], [ -76.025753, 37.257407 ], [ -76.023664, 37.268971 ], [ -76.015507, 37.280874 ], [ -76.023475, 37.289067 ], [ -76.018645, 37.317820 ], [ -76.014251, 37.331943 ], [ -75.997778, 37.351739 ], [ -75.987122, 37.368548 ], [ -75.979970, 37.404608 ], [ -75.983105, 37.415802 ], [ -75.981624, 37.434116 ], [ -75.976491, 37.444878 ], [ -75.960877, 37.467562 ], [ -75.963496, 37.475352 ], [ -75.963326, 37.481785 ], [ -75.958966, 37.500133 ], [ -75.949974, 37.521876 ], [ -75.940318, 37.534582 ], [ -75.937665, 37.549652 ], [ -75.937299, 37.551729 ], [ -75.941153, 37.558436 ], [ -75.941182, 37.563839 ], [ -75.924756, 37.600215 ], [ -75.909586, 37.622671 ], [ -75.877059, 37.660641 ], [ -75.868481, 37.668224 ], [ -75.869523, 37.674356 ], [ -75.868355, 37.687609 ], [ -75.859262, 37.703111 ], [ -75.845579, 37.707993 ], [ -75.837685, 37.712985 ], [ -75.830773, 37.725486 ], [ -75.831438, 37.731690 ], [ -75.827922, 37.737986 ], [ -75.824810, 37.741671 ], [ -75.812155, 37.749502 ], [ -75.803041, 37.762464 ], [ -75.812125, 37.776589 ], [ -75.818125, 37.791698 ], [ -75.793399, 37.804493 ], [ -75.784599, 37.806826 ], [ -75.770607, 37.804602 ], [ -75.743097, 37.806656 ], [ -75.735880, 37.816561 ], [ -75.723224, 37.820124 ], [ -75.716590, 37.826696 ], [ -75.714487, 37.837777 ], [ -75.709114, 37.847700 ], [ -75.702914, 37.849659 ], [ -75.689837, 37.861817 ], [ -75.685293, 37.873341 ], [ -75.687584, 37.886340 ], [ -75.709626, 37.900622 ], [ -75.720490, 37.901926 ], [ -75.724505, 37.900184 ], [ -75.726699, 37.897299 ], [ -75.753048, 37.896605 ], [ -75.758796, 37.897615 ], [ -75.759835, 37.899333 ], [ -75.757694, 37.903912 ], [ -75.712065, 37.936082 ], [ -75.704318, 37.929010 ], [ -75.693942, 37.930362 ], [ -75.669711, 37.950796 ], [ -75.660956, 37.959174 ], [ -75.646507, 37.973000 ], [ -75.646289, 37.973209 ], [ -75.645251, 37.974202 ], [ -75.645096, 37.974350 ], [ -75.644665, 37.974763 ], [ -75.644591, 37.974833 ], [ -75.644545, 37.974877 ], [ -75.639786, 37.979432 ], [ -75.635502, 37.983531 ], [ -75.630222, 37.988584 ], [ -75.626129, 37.992500 ], [ -75.624341, 37.994211 ], [ -75.435956, 38.010282 ], [ -75.428810, 38.010854 ], [ -75.398839, 38.013277 ], [ -75.377851, 38.015145 ], [ -75.263779, 38.025295 ], [ -75.262088, 38.025445 ], [ -75.260635, 38.025574 ], [ -75.256076, 38.025980 ], [ -75.250358, 38.026489 ], [ -75.242296, 38.027206 ], [ -75.242266, 38.027209 ] ] ], [ [ [ -75.973607, 37.835817 ], [ -75.971705, 37.830928 ], [ -75.977301, 37.825821 ], [ -75.982158, 37.806226 ], [ -75.987301, 37.804917 ], [ -75.998300, 37.812626 ], [ -76.001116, 37.834947 ], [ -75.999658, 37.848198 ], [ -75.996859, 37.850420 ], [ -75.992556, 37.848889 ], [ -75.988018, 37.841085 ], [ -75.982098, 37.837253 ], [ -75.973607, 37.835817 ] ] ], [ [ [ -75.994739, 37.953501 ], [ -75.993905, 37.953489 ], [ -76.003130, 37.947997 ], [ -76.017592, 37.935161 ], [ -76.032491, 37.915008 ], [ -76.035802, 37.929008 ], [ -76.046530, 37.953586 ], [ -76.045561, 37.953669 ], [ -76.041691, 37.954000 ], [ -76.041402, 37.954006 ], [ -76.038026, 37.953901 ], [ -76.030122, 37.953655 ], [ -76.029463, 37.953775 ], [ -76.029405, 37.953776 ], [ -76.022325, 37.953878 ], [ -76.021714, 37.953887 ], [ -76.020932, 37.953879 ], [ -76.020796, 37.953877 ], [ -76.017686, 37.953832 ], [ -76.005888, 37.953662 ], [ -75.994739, 37.953501 ] ] ], [ [ [ -78.869276, 38.762991 ], [ -78.835191, 38.811499 ], [ -78.808181, 38.856175 ], [ -78.788031, 38.885123 ], [ -78.779198, 38.892298 ], [ -78.757278, 38.903203 ], [ -78.719806, 38.922638 ], [ -78.719755, 38.922135 ], [ -78.716956, 38.916273 ], [ -78.714135, 38.911176 ], [ -78.710949, 38.910175 ], [ -78.601655, 38.964603 ], [ -78.557647, 39.013189 ], [ -78.554222, 39.019672 ], [ -78.565837, 39.026303 ], [ -78.571901, 39.031995 ], [ -78.544111, 39.056676 ], [ -78.508132, 39.088630 ], [ -78.459869, 39.113351 ], [ -78.439429, 39.132146 ], [ -78.418377, 39.156656 ], [ -78.410740, 39.171983 ], [ -78.426722, 39.188903 ], [ -78.438651, 39.198049 ], [ -78.437053, 39.199766 ], [ -78.432130, 39.204717 ], [ -78.431167, 39.205744 ], [ -78.429803, 39.207014 ], [ -78.427911, 39.208611 ], [ -78.423968, 39.212049 ], [ -78.399669, 39.243874 ], [ -78.399785, 39.244129 ], [ -78.360035, 39.317771 ], [ -78.358940, 39.319484 ], [ -78.340480, 39.353492 ], [ -78.362267, 39.357784 ], [ -78.347087, 39.466012 ], [ -78.228766, 39.391233 ], [ -78.033185, 39.264626 ], [ -78.033183, 39.264624 ], [ -78.032841, 39.264403 ], [ -77.828157, 39.132329 ], [ -77.822182, 39.139985 ], [ -77.771415, 39.236776 ], [ -77.767277, 39.249380 ], [ -77.768992, 39.256417 ], [ -77.768000, 39.257657 ], [ -77.761768, 39.263031 ], [ -77.761217, 39.263721 ], [ -77.758733, 39.268114 ], [ -77.758412, 39.269197 ], [ -77.755698, 39.274575 ], [ -77.755193, 39.275191 ], [ -77.753105, 39.277340 ], [ -77.753060, 39.277971 ], [ -77.753357, 39.280331 ], [ -77.750267, 39.289284 ], [ -77.719029, 39.321125 ], [ -77.677505, 39.318699 ], [ -77.667749, 39.318129 ], [ -77.592739, 39.301290 ], [ -77.560854, 39.286152 ], [ -77.545846, 39.271535 ], [ -77.543228, 39.266937 ], [ -77.534461, 39.262361 ], [ -77.511222, 39.253500 ], [ -77.484605, 39.245941 ], [ -77.460210, 39.228359 ], [ -77.457680, 39.225020 ], [ -77.458779, 39.220280 ], [ -77.458884, 39.219826 ], [ -77.478596, 39.189168 ], [ -77.485971, 39.185665 ], [ -77.505162, 39.182050 ], [ -77.510631, 39.178484 ], [ -77.516426, 39.170891 ], [ -77.527282, 39.146236 ], [ -77.524559, 39.127821 ], [ -77.519929, 39.120925 ], [ -77.458202, 39.073723 ], [ -77.423180, 39.066878 ], [ -77.375079, 39.061297 ], [ -77.340287, 39.062991 ], [ -77.328002, 39.058554 ], [ -77.291605, 39.045408 ], [ -77.261403, 39.031009 ], [ -77.251803, 39.011409 ], [ -77.255703, 39.002409 ], [ -77.249803, 38.985909 ], [ -77.235403, 38.976610 ], [ -77.221502, 38.971310 ], [ -77.197502, 38.966810 ], [ -77.166901, 38.968110 ], [ -77.148179, 38.965002 ], [ -77.137701, 38.955310 ], [ -77.119900, 38.934311 ], [ -77.119863, 38.934265 ], [ -77.101200, 38.911111 ], [ -77.090200, 38.904211 ], [ -77.068199, 38.899811 ], [ -77.040599, 38.871212 ], [ -77.031698, 38.850512 ], [ -77.032986, 38.839500 ], [ -77.038598, 38.791513 ], [ -77.039239, 38.785200 ], [ -77.041398, 38.763914 ], [ -77.059910, 38.734419 ], [ -77.074599, 38.711015 ], [ -77.086113, 38.705792 ], [ -77.105900, 38.696815 ], [ -77.121101, 38.686616 ], [ -77.132501, 38.673816 ], [ -77.135901, 38.649817 ], [ -77.130200, 38.635017 ], [ -77.157501, 38.636417 ], [ -77.174902, 38.624217 ], [ -77.202002, 38.617217 ], [ -77.204302, 38.617817 ], [ -77.205103, 38.623917 ], [ -77.216303, 38.637817 ], [ -77.222350, 38.638091 ], [ -77.240604, 38.638917 ], [ -77.246704, 38.635217 ], [ -77.248904, 38.628617 ], [ -77.245104, 38.620717 ], [ -77.246441, 38.599532 ], [ -77.247003, 38.590618 ], [ -77.264430, 38.582845 ], [ -77.265304, 38.580319 ], [ -77.260830, 38.565330 ], [ -77.276603, 38.547120 ], [ -77.276303, 38.539620 ], [ -77.283503, 38.525221 ], [ -77.291103, 38.515721 ], [ -77.295820, 38.511457 ], [ -77.298844, 38.508724 ], [ -77.300776, 38.506978 ], [ -77.302457, 38.504683 ], [ -77.310334, 38.493926 ], [ -77.322622, 38.467131 ], [ -77.325440, 38.448850 ], [ -77.319036, 38.417803 ], [ -77.310719, 38.397669 ], [ -77.312201, 38.390958 ], [ -77.314848, 38.389579 ], [ -77.317288, 38.383576 ], [ -77.296077, 38.369797 ], [ -77.288145, 38.359477 ], [ -77.288350, 38.351286 ], [ -77.286202, 38.347025 ], [ -77.286202, 38.347024 ], [ -77.279633, 38.339444 ], [ -77.265295, 38.333165 ], [ -77.240072, 38.331598 ], [ -77.199433, 38.340890 ], [ -77.179340, 38.341915 ], [ -77.162692, 38.345994 ], [ -77.155191, 38.351047 ], [ -77.138224, 38.367917 ], [ -77.104717, 38.369655 ], [ -77.094665, 38.367715 ], [ -77.084810, 38.368297 ], [ -77.069956, 38.377895 ], [ -77.056032, 38.396200 ], [ -77.051437, 38.399083 ], [ -77.043526, 38.400548 ], [ -77.024866, 38.386791 ], [ -77.011827, 38.374554 ], [ -77.016932, 38.341697 ], [ -77.020947, 38.329273 ], [ -77.030683, 38.311623 ], [ -77.026304, 38.302685 ], [ -76.997670, 38.278047 ], [ -76.990255, 38.273935 ], [ -76.981372, 38.274214 ], [ -76.962150, 38.256486 ], [ -76.957796, 38.243183 ], [ -76.957417, 38.236341 ], [ -76.962375, 38.230093 ], [ -76.966553, 38.229542 ], [ -76.967335, 38.227185 ], [ -76.962311, 38.214075 ], [ -76.937134, 38.202384 ], [ -76.916922, 38.199751 ], [ -76.910832, 38.197073 ], [ -76.875272, 38.172207 ], [ -76.838795, 38.163476 ], [ -76.824274, 38.163639 ], [ -76.802968, 38.167988 ], [ -76.788445, 38.169199 ], [ -76.760241, 38.166581 ], [ -76.749685, 38.162114 ], [ -76.743064, 38.156988 ], [ -76.740278, 38.152824 ], [ -76.738938, 38.146510 ], [ -76.721722, 38.137635 ], [ -76.704048, 38.149264 ], [ -76.701297, 38.155718 ], [ -76.684892, 38.156497 ], [ -76.665127, 38.147638 ], [ -76.643448, 38.148250 ], [ -76.638983, 38.151476 ], [ -76.629476, 38.153050 ], [ -76.613939, 38.148587 ], [ -76.604131, 38.128771 ], [ -76.600937, 38.110084 ], [ -76.579497, 38.094870 ], [ -76.543155, 38.076971 ], [ -76.535919, 38.069532 ], [ -76.522354, 38.042590 ], [ -76.519536, 38.034814 ], [ -76.516547, 38.026566 ], [ -76.491998, 38.017222 ], [ -76.469343, 38.013544 ], [ -76.465291, 38.010226 ], [ -76.462542, 37.998572 ], [ -76.427487, 37.977038 ], [ -76.416299, 37.966828 ], [ -76.391439, 37.958742 ], [ -76.360211, 37.952329 ], [ -76.343848, 37.947345 ], [ -76.265998, 37.911380 ], [ -76.236725, 37.889174 ], [ -76.245072, 37.861918 ], [ -76.251358, 37.833072 ], [ -76.266057, 37.817400 ], [ -76.275178, 37.812664 ], [ -76.280544, 37.812597 ], [ -76.282592, 37.814109 ], [ -76.281985, 37.818068 ], [ -76.284904, 37.822308 ], [ -76.293525, 37.822717 ], [ -76.307482, 37.812350 ], [ -76.310307, 37.794849 ], [ -76.306489, 37.788646 ], [ -76.312108, 37.750522 ], [ -76.304917, 37.729913 ], [ -76.312858, 37.720338 ], [ -76.302803, 37.704474 ], [ -76.300067, 37.695364 ], [ -76.302545, 37.689000 ], [ -76.312079, 37.684651 ], [ -76.315161, 37.684720 ], [ -76.320216, 37.680666 ], [ -76.324808, 37.676983 ], [ -76.339892, 37.655966 ], [ -76.332562, 37.645817 ], [ -76.306464, 37.642005 ], [ -76.292534, 37.636098 ], [ -76.287959, 37.631771 ], [ -76.279447, 37.618225 ], [ -76.280370, 37.613715 ], [ -76.309174, 37.621892 ], [ -76.362320, 37.610368 ], [ -76.381106, 37.627003 ], [ -76.390054, 37.630326 ], [ -76.399236, 37.628636 ], [ -76.443254, 37.652347 ], [ -76.472392, 37.665772 ], [ -76.489576, 37.666201 ], [ -76.491799, 37.663614 ], [ -76.497564, 37.647056 ], [ -76.501522, 37.643762 ], [ -76.510187, 37.642324 ], [ -76.536548, 37.663574 ], [ -76.537698, 37.668930 ], [ -76.535302, 37.687516 ], [ -76.537228, 37.698892 ], [ -76.540050, 37.704432 ], [ -76.560476, 37.727827 ], [ -76.576387, 37.757493 ], [ -76.584289, 37.768890 ], [ -76.593835, 37.772848 ], [ -76.595939, 37.771680 ], [ -76.602024, 37.772731 ], [ -76.615351, 37.780759 ], [ -76.642276, 37.792317 ], [ -76.651413, 37.796239 ], [ -76.658302, 37.806815 ], [ -76.680197, 37.825654 ], [ -76.692747, 37.822770 ], [ -76.701606, 37.822677 ], [ -76.722156, 37.836680 ], [ -76.727180, 37.842263 ], [ -76.733046, 37.852009 ], [ -76.738395, 37.865373 ], [ -76.747552, 37.875864 ], [ -76.765711, 37.879274 ], [ -76.775390, 37.874306 ], [ -76.784618, 37.869569 ], [ -76.782826, 37.863184 ], [ -76.766328, 37.840437 ], [ -76.751200, 37.824141 ], [ -76.734309, 37.798660 ], [ -76.723863, 37.788503 ], [ -76.715498, 37.785873 ], [ -76.689773, 37.785190 ], [ -76.683775, 37.781391 ], [ -76.681901, 37.778118 ], [ -76.683343, 37.775783 ], [ -76.683359, 37.770258 ], [ -76.683372, 37.765507 ], [ -76.680922, 37.759647 ], [ -76.677002, 37.756100 ], [ -76.663887, 37.751887 ], [ -76.639962, 37.750941 ], [ -76.619710, 37.744795 ], [ -76.617373, 37.742347 ], [ -76.621433, 37.737973 ], [ -76.619970, 37.731271 ], [ -76.606466, 37.724819 ], [ -76.597213, 37.717269 ], [ -76.595943, 37.712989 ], [ -76.598073, 37.709120 ], [ -76.597868, 37.702918 ], [ -76.579591, 37.671508 ], [ -76.583143, 37.661986 ], [ -76.574049, 37.646781 ], [ -76.542666, 37.616857 ], [ -76.533777, 37.612530 ], [ -76.527188, 37.611315 ], [ -76.435474, 37.612807 ], [ -76.420252, 37.598686 ], [ -76.410781, 37.581815 ], [ -76.383188, 37.573056 ], [ -76.357835, 37.573699 ], [ -76.332641, 37.570042 ], [ -76.300144, 37.561734 ], [ -76.297960, 37.557636 ], [ -76.302762, 37.551295 ], [ -76.330598, 37.536391 ], [ -76.339989, 37.538330 ], [ -76.348992, 37.536548 ], [ -76.355084, 37.527364 ], [ -76.360474, 37.519240 ], [ -76.359378, 37.513426 ], [ -76.352678, 37.504913 ], [ -76.329470, 37.494920 ], [ -76.306952, 37.497488 ], [ -76.297739, 37.506863 ], [ -76.296445, 37.511235 ], [ -76.298456, 37.512677 ], [ -76.297651, 37.515424 ], [ -76.293599, 37.516499 ], [ -76.288167, 37.514118 ], [ -76.281043, 37.507821 ], [ -76.265056, 37.481365 ], [ -76.252415, 37.447274 ], [ -76.250454, 37.421886 ], [ -76.246617, 37.404122 ], [ -76.245283, 37.386839 ], [ -76.248460, 37.375135 ], [ -76.258277, 37.362020 ], [ -76.262407, 37.360786 ], [ -76.264847, 37.357399 ], [ -76.272888, 37.335174 ], [ -76.272005, 37.322194 ], [ -76.275552, 37.309964 ], [ -76.282555, 37.319107 ], [ -76.291324, 37.324145 ], [ -76.308581, 37.329366 ], [ -76.312050, 37.338088 ], [ -76.337476, 37.364014 ], [ -76.366751, 37.374495 ], [ -76.387112, 37.385061 ], [ -76.391437, 37.390284 ], [ -76.393958, 37.395940 ], [ -76.393125, 37.398068 ], [ -76.404756, 37.400213 ], [ -76.415167, 37.402133 ], [ -76.418719, 37.397800 ], [ -76.418176, 37.385064 ], [ -76.422503, 37.381355 ], [ -76.437525, 37.379750 ], [ -76.445333, 37.366460 ], [ -76.434965, 37.354524 ], [ -76.406388, 37.332924 ], [ -76.387770, 37.307670 ], [ -76.385603, 37.294108 ], [ -76.381075, 37.285340 ], [ -76.369029, 37.279311 ], [ -76.352556, 37.278334 ], [ -76.349489, 37.273963 ], [ -76.362290, 37.270226 ], [ -76.392788, 37.264973 ], [ -76.417173, 37.263950 ], [ -76.421765, 37.255198 ], [ -76.429141, 37.253310 ], [ -76.475927, 37.250543 ], [ -76.482840, 37.254831 ], [ -76.493302, 37.249470 ], [ -76.498900, 37.241015 ], [ -76.503640, 37.233856 ], [ -76.494008, 37.225408 ], [ -76.471799, 37.216016 ], [ -76.394132, 37.225150 ], [ -76.389793, 37.222981 ], [ -76.393600, 37.214049 ], [ -76.396052, 37.201087 ], [ -76.389284, 37.193503 ], [ -76.391252, 37.179887 ], [ -76.397883, 37.164415 ], [ -76.399659, 37.160272 ], [ -76.394756, 37.157568 ], [ -76.381379, 37.155711 ], [ -76.375255, 37.160840 ], [ -76.359690, 37.168580 ], [ -76.348658, 37.170655 ], [ -76.343234, 37.166207 ], [ -76.344898, 37.164479 ], [ -76.344050, 37.160367 ], [ -76.340129, 37.151823 ], [ -76.334017, 37.144223 ], [ -76.330481, 37.141727 ], [ -76.324353, 37.142895 ], [ -76.311088, 37.138495 ], [ -76.292344, 37.126615 ], [ -76.287236, 37.117453 ], [ -76.274463, 37.094544 ], [ -76.271262, 37.084544 ], [ -76.292863, 37.035145 ], [ -76.300352, 37.008850 ], [ -76.304272, 37.001378 ], [ -76.312048, 37.000371 ], [ -76.315008, 37.001683 ], [ -76.314624, 37.009330 ], [ -76.318065, 37.013846 ], [ -76.329531, 37.014556 ], [ -76.340110, 37.015212 ], [ -76.340666, 37.015246 ], [ -76.348066, 37.006747 ], [ -76.356366, 37.002947 ], [ -76.373567, 36.998347 ], [ -76.383367, 36.993347 ], [ -76.387711, 36.989671 ], [ -76.396368, 36.982347 ], [ -76.408568, 36.969147 ], [ -76.411768, 36.962847 ], [ -76.418969, 36.964047 ], [ -76.428869, 36.969947 ], [ -76.452118, 36.998163 ], [ -76.452461, 37.004603 ], [ -76.449891, 37.004868 ], [ -76.448231, 37.007705 ], [ -76.464471, 37.027547 ], [ -76.469490, 37.030414 ], [ -76.507614, 37.052188 ], [ -76.509339, 37.053173 ], [ -76.512289, 37.054858 ], [ -76.518242, 37.055351 ], [ -76.526273, 37.062947 ], [ -76.527973, 37.068247 ], [ -76.526573, 37.070047 ], [ -76.526203, 37.077773 ], [ -76.528997, 37.079388 ], [ -76.536875, 37.083942 ], [ -76.555066, 37.075859 ], [ -76.564219, 37.077507 ], [ -76.567931, 37.080467 ], [ -76.579499, 37.096627 ], [ -76.618252, 37.119347 ], [ -76.624780, 37.127091 ], [ -76.622252, 37.142146 ], [ -76.617084, 37.144498 ], [ -76.604476, 37.160034 ], [ -76.606684, 37.166674 ], [ -76.610972, 37.166994 ], [ -76.611018, 37.167097 ], [ -76.612517, 37.170486 ], [ -76.613599, 37.172931 ], [ -76.614221, 37.174335 ], [ -76.616268, 37.178962 ], [ -76.616804, 37.181260 ], [ -76.617537, 37.184409 ], [ -76.618008, 37.186429 ], [ -76.619340, 37.192146 ], [ -76.619962, 37.193184 ], [ -76.621113, 37.195103 ], [ -76.623292, 37.198738 ], [ -76.629868, 37.206738 ], [ -76.639608, 37.214783 ], [ -76.641085, 37.216002 ], [ -76.649869, 37.220914 ], [ -76.689166, 37.222866 ], [ -76.693373, 37.221228 ], [ -76.698943, 37.219059 ], [ -76.730951, 37.213813 ], [ -76.734320, 37.204211 ], [ -76.740000, 37.195379 ], [ -76.743040, 37.192611 ], [ -76.750470, 37.190098 ], [ -76.757765, 37.191658 ], [ -76.773752, 37.206061 ], [ -76.780532, 37.209336 ], [ -76.791555, 37.207564 ], [ -76.801023, 37.206043 ], [ -76.803198, 37.201513 ], [ -76.802511, 37.198308 ], [ -76.796905, 37.189404 ], [ -76.756899, 37.161582 ], [ -76.747632, 37.150548 ], [ -76.737280, 37.146164 ], [ -76.730320, 37.145395 ], [ -76.715295, 37.148035 ], [ -76.696735, 37.174403 ], [ -76.692926, 37.186147 ], [ -76.691918, 37.195731 ], [ -76.685614, 37.198851 ], [ -76.669886, 37.183571 ], [ -76.663774, 37.173875 ], [ -76.664270, 37.171027 ], [ -76.668670, 37.166771 ], [ -76.671470, 37.158739 ], [ -76.671588, 37.142060 ], [ -76.669604, 37.140534 ], [ -76.666542, 37.138179 ], [ -76.665833, 37.136098 ], [ -76.665641, 37.135534 ], [ -76.663750, 37.129979 ], [ -76.656894, 37.109843 ], [ -76.657101, 37.107617 ], [ -76.657703, 37.101161 ], [ -76.658110, 37.096787 ], [ -76.659394, 37.094019 ], [ -76.665550, 37.080746 ], [ -76.666526, 37.078643 ], [ -76.667219, 37.077149 ], [ -76.667646, 37.076228 ], [ -76.668295, 37.072656 ], [ -76.669118, 37.068132 ], [ -76.669822, 37.064260 ], [ -76.668350, 37.055060 ], [ -76.662558, 37.045748 ], [ -76.653998, 37.039172 ], [ -76.646013, 37.036228 ], [ -76.612124, 37.035604 ], [ -76.586491, 37.028740 ], [ -76.584478, 37.027349 ], [ -76.579393, 37.023835 ], [ -76.579236, 37.023726 ], [ -76.578160, 37.022982 ], [ -76.577531, 37.022548 ], [ -76.576617, 37.021374 ], [ -76.565803, 37.007493 ], [ -76.562923, 37.003796 ], [ -76.551246, 36.998946 ], [ -76.524853, 36.983833 ], [ -76.522971, 36.981085 ], [ -76.524142, 36.978316 ], [ -76.521006, 36.973187 ], [ -76.513363, 36.968057 ], [ -76.500355, 36.965212 ], [ -76.487559, 36.952372 ], [ -76.484107, 36.928916 ], [ -76.482407, 36.917364 ], [ -76.482135, 36.901108 ], [ -76.483369, 36.896239 ], [ -76.469914, 36.882898 ], [ -76.454692, 36.884077 ], [ -76.453290, 36.887031 ], [ -76.453941, 36.892740 ], [ -76.447413, 36.903220 ], [ -76.441605, 36.906116 ], [ -76.431220, 36.904532 ], [ -76.407507, 36.897444 ], [ -76.406908, 36.897507 ], [ -76.387567, 36.899547 ], [ -76.385867, 36.923247 ], [ -76.353765, 36.922747 ], [ -76.345569, 36.924531 ], [ -76.344663, 36.919313 ], [ -76.333158, 36.917293 ], [ -76.328864, 36.918447 ], [ -76.330765, 36.938647 ], [ -76.327365, 36.959447 ], [ -76.322764, 36.959147 ], [ -76.315867, 36.955351 ], [ -76.299364, 36.965547 ], [ -76.297663, 36.968147 ], [ -76.285063, 36.968747 ], [ -76.267962, 36.964547 ], [ -76.234961, 36.945147 ], [ -76.221660, 36.939547 ], [ -76.189959, 36.931447 ], [ -76.177019, 36.929290 ], [ -76.139557, 36.923047 ], [ -76.095508, 36.908817 ], [ -76.087955, 36.908647 ], [ -76.058154, 36.916947 ], [ -76.043054, 36.927547 ], [ -76.033454, 36.931946 ], [ -76.013753, 36.930746 ], [ -76.007553, 36.929047 ], [ -75.996252, 36.922047 ], [ -75.991552, 36.910847 ], [ -75.972151, 36.842268 ], [ -75.965451, 36.812449 ], [ -75.949550, 36.761150 ], [ -75.921748, 36.692051 ], [ -75.890946, 36.630753 ], [ -75.874145, 36.583853 ], [ -75.867044, 36.550754 ], [ -75.879744, 36.550754 ], [ -75.880644, 36.550754 ], [ -75.885945, 36.550754 ], [ -75.886545, 36.550754 ], [ -75.891945, 36.550754 ], [ -75.893245, 36.550654 ], [ -75.894145, 36.550754 ], [ -75.903445, 36.550654 ], [ -75.904745, 36.550654 ], [ -75.909046, 36.550654 ], [ -75.911446, 36.550654 ], [ -75.922046, 36.550654 ], [ -75.952847, 36.550553 ], [ -75.953447, 36.550553 ], [ -75.955748, 36.550553 ], [ -75.957648, 36.550553 ], [ -76.026750, 36.550553 ], [ -76.034751, 36.550653 ], [ -76.122360, 36.550621 ], [ -76.313196, 36.550551 ], [ -76.313215, 36.550551 ], [ -76.491497, 36.550365 ], [ -76.541391, 36.550312 ], [ -76.541687, 36.550312 ], [ -76.781296, 36.550659 ], [ -76.807078, 36.550606 ], [ -76.915384, 36.543856 ], [ -76.916001, 36.543818 ], [ -76.916048, 36.543815 ], [ -77.164500, 36.546330 ], [ -77.249690, 36.544745 ], [ -77.296875, 36.544746 ], [ -77.767117, 36.544752 ], [ -77.875280, 36.544754 ], [ -77.882357, 36.544737 ], [ -77.899771, 36.544663 ], [ -78.038938, 36.544173 ], [ -78.039420, 36.544196 ], [ -78.046202, 36.544168 ], [ -78.132911, 36.543811 ], [ -78.133323, 36.543847 ], [ -78.245462, 36.544411 ], [ -78.246681, 36.544341 ], [ -78.323912, 36.543809 ], [ -78.436333, 36.542666 ], [ -78.441199, 36.542687 ], [ -78.456970, 36.542474 ], [ -78.470792, 36.542316 ], [ -78.471022, 36.542307 ], [ -78.529722, 36.540981 ], [ -78.533013, 36.541004 ], [ -78.663317, 36.542011 ], [ -78.670051, 36.542035 ], [ -78.734122, 36.541902 ], [ -78.758392, 36.541852 ], [ -78.765430, 36.541727 ], [ -78.796300, 36.541713 ], [ -78.914543, 36.541972 ], [ -78.915420, 36.541974 ], [ -78.942009, 36.542113 ], [ -78.942254, 36.542079 ], [ -78.970577, 36.542154 ], [ -78.971814, 36.542123 ], [ -79.124736, 36.541568 ], [ -79.126078, 36.541533 ], [ -79.137936, 36.541739 ], [ -79.208686, 36.541571 ], [ -79.209480, 36.541594 ], [ -79.218638, 36.541579 ], [ -79.342696, 36.541382 ], [ -79.445687, 36.541218 ], [ -79.445961, 36.541195 ], [ -79.470047, 36.541025 ], [ -79.510647, 36.540738 ], [ -79.510961, 36.540740 ], [ -79.666827, 36.541772 ], [ -79.667309, 36.541772 ], [ -79.714855, 36.541884 ], [ -79.920239, 36.542365 ], [ -79.966979, 36.542475 ], [ -79.967511, 36.542502 ], [ -80.027269, 36.542495 ], [ -80.053455, 36.542623 ], [ -80.169535, 36.543190 ], [ -80.171636, 36.543219 ], [ -80.225408, 36.543748 ], [ -80.228263, 36.543867 ], [ -80.431605, 36.550219 ], [ -80.432628, 36.550302 ], [ -80.440100, 36.550630 ], [ -80.612158, 36.558127 ], [ -80.687539, 36.561411 ], [ -80.744101, 36.561686 ], [ -80.837089, 36.559154 ], [ -80.837641, 36.559118 ], [ -80.837954, 36.559131 ], [ -80.901726, 36.561751 ], [ -80.901836, 36.561754 ], [ -80.944338, 36.563058 ], [ -80.945988, 36.563196 ], [ -81.058844, 36.566976 ], [ -81.061866, 36.567020 ], [ -81.307511, 36.575024 ], [ -81.353169, 36.574724 ], [ -81.353322, 36.574723 ], [ -81.521032, 36.580520 ], [ -81.606970, 36.587094 ], [ -81.677535, 36.588117 ], [ -81.646900, 36.611918 ], [ -81.826742, 36.614215 ], [ -81.922644, 36.616213 ], [ -81.934144, 36.594213 ], [ -82.146070, 36.594712 ], [ -82.148569, 36.594718 ], [ -82.150727, 36.594673 ], [ -82.173982, 36.594607 ], [ -82.177247, 36.594768 ], [ -82.180740, 36.594928 ], [ -82.188491, 36.595179 ], [ -82.210497, 36.595772 ], [ -82.211005, 36.595860 ], [ -82.221713, 36.595814 ], [ -82.223445, 36.595721 ], [ -82.225716, 36.595744 ], [ -82.226653, 36.595743 ], [ -82.243274, 36.595699 ], [ -82.293814, 36.595565 ], [ -82.554294, 36.594876 ], [ -82.559774, 36.594800 ], [ -82.561074, 36.594800 ], [ -82.609176, 36.594099 ], [ -82.679879, 36.593698 ], [ -82.695780, 36.593698 ], [ -82.830433, 36.593761 ], [ -82.985087, 36.593829 ], [ -83.027250, 36.593847 ], [ -83.028357, 36.593893 ], [ -83.248933, 36.593827 ], [ -83.249899, 36.593898 ], [ -83.250304, 36.593935 ], [ -83.276300, 36.598187 ], [ -83.472108, 36.597284 ], [ -83.670128, 36.600764 ], [ -83.670141, 36.600797 ], [ -83.675413, 36.600814 ], [ -83.649513, 36.616683 ], [ -83.527212, 36.665984 ], [ -83.498011, 36.670485 ], [ -83.461013, 36.664916 ], [ -83.460808, 36.664885 ], [ -83.354606, 36.696153 ], [ -83.353613, 36.696699 ], [ -83.342804, 36.701286 ], [ -83.199698, 36.737487 ], [ -83.167396, 36.739187 ], [ -83.136395, 36.743088 ], [ -83.127833, 36.750828 ], [ -83.125728, 36.761276 ], [ -83.125655, 36.761407 ], [ -83.131245, 36.767105 ], [ -83.131694, 36.781488 ], [ -83.099792, 36.824889 ], [ -83.072590, 36.854589 ], [ -82.973395, 36.859097 ], [ -82.911824, 36.874243 ], [ -82.911690, 36.874248 ], [ -82.885618, 36.900415 ], [ -82.873777, 36.912299 ], [ -82.872136, 36.913456 ], [ -82.863468, 36.922308 ], [ -82.861943, 36.924236 ], [ -82.858461, 36.932717 ], [ -82.858784, 36.933065 ], [ -82.860537, 36.937439 ], [ -82.861684, 36.939316 ], [ -82.861282, 36.944848 ], [ -82.860633, 36.945840 ], [ -82.856099, 36.952471 ], [ -82.855705, 36.953808 ], [ -82.858443, 36.954036 ], [ -82.860534, 36.956015 ], [ -82.862866, 36.957765 ], [ -82.864211, 36.957983 ], [ -82.865404, 36.958084 ], [ -82.867358, 36.963182 ], [ -82.870230, 36.965498 ], [ -82.870274, 36.965993 ], [ -82.869183, 36.974182 ], [ -82.869183, 36.974183 ], [ -82.868455, 36.976481 ], [ -82.867535, 36.977518 ], [ -82.866689, 36.978052 ], [ -82.866019, 36.978272 ], [ -82.864909, 36.979010 ], [ -82.862926, 36.979975 ], [ -82.852614, 36.984963 ], [ -82.851397, 36.984497 ], [ -82.840051, 36.987113 ], [ -82.838549, 36.987027 ], [ -82.836008, 36.988837 ], [ -82.833843, 36.991973 ], [ -82.830802, 36.993445 ], [ -82.829125, 36.997541 ], [ -82.830588, 37.000945 ], [ -82.818006, 37.006161 ], [ -82.815748, 37.007196 ], [ -82.800531, 37.007944 ], [ -82.790890, 37.006760 ], [ -82.790462, 37.007263 ], [ -82.789092, 37.007995 ], [ -82.788897, 37.008160 ], [ -82.777368, 37.015279 ], [ -82.771795, 37.015716 ], [ -82.722472, 37.045101 ], [ -82.720597, 37.081833 ], [ -82.721941, 37.105689 ], [ -82.624878, 37.162932 ], [ -82.565375, 37.196092 ], [ -82.565329, 37.196118 ], [ -82.553549, 37.200867 ], [ -82.510826, 37.218091 ], [ -82.350948, 37.267077 ], [ -82.310793, 37.297387 ], [ -82.305874, 37.301100 ], [ -82.291908, 37.311642 ], [ -81.968297, 37.537798 ], [ -81.927870, 37.512118 ], [ -81.942640, 37.508844 ], [ -81.992916, 37.482969 ], [ -81.996578, 37.476705 ], [ -81.992270, 37.460916 ], [ -81.987006, 37.454878 ], [ -81.968795, 37.451496 ], [ -81.949367, 37.445687 ], [ -81.935621, 37.438397 ], [ -81.927490, 37.413251 ], [ -81.933895, 37.372747 ], [ -81.930194, 37.366728 ], [ -81.929915, 37.366589 ], [ -81.926589, 37.358942 ], [ -81.925643, 37.357316 ], [ -81.921571, 37.356423 ], [ -81.920711, 37.355416 ], [ -81.911487, 37.348839 ], [ -81.910875, 37.348729 ], [ -81.907895, 37.343783 ], [ -81.907322, 37.343119 ], [ -81.906368, 37.342760 ], [ -81.905945, 37.342775 ], [ -81.903795, 37.343050 ], [ -81.902992, 37.342340 ], [ -81.899495, 37.341102 ], [ -81.899459, 37.340277 ], [ -81.896001, 37.331967 ], [ -81.895489, 37.332022 ], [ -81.894797, 37.332012 ], [ -81.894768, 37.331381 ], [ -81.893773, 37.330105 ], [ -81.892876, 37.330134 ], [ -81.887722, 37.331156 ], [ -81.886952, 37.330725 ], [ -81.885075, 37.330665 ], [ -81.880886, 37.331146 ], [ -81.879601, 37.332074 ], [ -81.878713, 37.331753 ], [ -81.878343, 37.328837 ], [ -81.873213, 37.325065 ], [ -81.865219, 37.308839 ], [ -81.864760, 37.308404 ], [ -81.853978, 37.300418 ], [ -81.854465, 37.299937 ], [ -81.853488, 37.294763 ], [ -81.854059, 37.291352 ], [ -81.843167, 37.285586 ], [ -81.842310, 37.285556 ], [ -81.810559, 37.282980 ], [ -81.809184, 37.283003 ], [ -81.793639, 37.282188 ], [ -81.793425, 37.281674 ], [ -81.774747, 37.274847 ], [ -81.774684, 37.274807 ], [ -81.767837, 37.274216 ], [ -81.765195, 37.275099 ], [ -81.763836, 37.275218 ], [ -81.762776, 37.275391 ], [ -81.761752, 37.275713 ], [ -81.760220, 37.275254 ], [ -81.757631, 37.274003 ], [ -81.757730, 37.271934 ], [ -81.757714, 37.271124 ], [ -81.757531, 37.270010 ], [ -81.755012, 37.267720 ], [ -81.752912, 37.266614 ], [ -81.752123, 37.265568 ], [ -81.751290, 37.265131 ], [ -81.747656, 37.264329 ], [ -81.743505, 37.247601 ], [ -81.743420, 37.245858 ], [ -81.744291, 37.244178 ], [ -81.738378, 37.240917 ], [ -81.733320, 37.238127 ], [ -81.728194, 37.239823 ], [ -81.683544, 37.211452 ], [ -81.678603, 37.202467 ], [ -81.560625, 37.206663 ], [ -81.558353, 37.208145 ], [ -81.557315, 37.207697 ], [ -81.507325, 37.233800 ], [ -81.504880, 37.247697 ], [ -81.504168, 37.250115 ], [ -81.409729, 37.284837 ], [ -81.409196, 37.286071 ], [ -81.388132, 37.319903 ], [ -81.386727, 37.320474 ], [ -81.385810, 37.320085 ], [ -81.384914, 37.318832 ], [ -81.384127, 37.318596 ], [ -81.380159, 37.317838 ], [ -81.377349, 37.318447 ], [ -81.371315, 37.324115 ], [ -81.367599, 37.327569 ], [ -81.369379, 37.331827 ], [ -81.368090, 37.332423 ], [ -81.367052, 37.334504 ], [ -81.366315, 37.335927 ], [ -81.362156, 37.337687 ], [ -81.320105, 37.299323 ], [ -81.225104, 37.234874 ], [ -81.204774, 37.243013 ], [ -81.167029, 37.262881 ], [ -81.112596, 37.278497 ], [ -81.084012, 37.284401 ], [ -81.034652, 37.290751 ], [ -80.981322, 37.293465 ], [ -80.980044, 37.293118 ], [ -80.973889, 37.291444 ], [ -80.966556, 37.292158 ], [ -80.947896, 37.295872 ], [ -80.919259, 37.306163 ], [ -80.900535, 37.315000 ], [ -80.849451, 37.346909 ], [ -80.872589, 37.372347 ], [ -80.862761, 37.411829 ], [ -80.859558, 37.429555 ], [ -80.859556, 37.429568 ], [ -80.858473, 37.428301 ], [ -80.858360, 37.428168 ], [ -80.811639, 37.407507 ], [ -80.798869, 37.395807 ], [ -80.776766, 37.384131 ], [ -80.776649, 37.383679 ], [ -80.770082, 37.372363 ], [ -80.622664, 37.433307 ], [ -80.511391, 37.481672 ], [ -80.494867, 37.435070 ], [ -80.475601, 37.422949 ], [ -80.464820, 37.426144 ], [ -80.443025, 37.438126 ], [ -80.425656, 37.449876 ], [ -80.320627, 37.498880 ], [ -80.314806, 37.500943 ], [ -80.330306, 37.536244 ], [ -80.312393, 37.546239 ], [ -80.288766, 37.581960 ], [ -80.240272, 37.606961 ], [ -80.223386, 37.623185 ], [ -80.220984, 37.627767 ], [ -80.239288, 37.637672 ], [ -80.254431, 37.642352 ], [ -80.254469, 37.642333 ], [ -80.263281, 37.645082 ], [ -80.263291, 37.645101 ], [ -80.264830, 37.645526 ], [ -80.264874, 37.645511 ], [ -80.267228, 37.646011 ], [ -80.267455, 37.646108 ], [ -80.270352, 37.648929 ], [ -80.270323, 37.648982 ], [ -80.292258, 37.683732 ], [ -80.292337, 37.683976 ], [ -80.296138, 37.691783 ], [ -80.287107, 37.696403 ], [ -80.263936, 37.719137 ], [ -80.259342, 37.731205 ], [ -80.260313, 37.733517 ], [ -80.262765, 37.738336 ], [ -80.257411, 37.756084 ], [ -80.231551, 37.792591 ], [ -80.227092, 37.798886 ], [ -80.162202, 37.875122 ], [ -80.148964, 37.886057 ], [ -80.147316, 37.885936 ], [ -80.146130, 37.884453 ], [ -80.130464, 37.893194 ], [ -80.055278, 37.951702 ], [ -80.002507, 37.992767 ], [ -79.978427, 38.029082 ], [ -79.959844, 38.063697 ], [ -79.933911, 38.099168 ], [ -79.931034, 38.101402 ], [ -79.938394, 38.130563 ], [ -79.933751, 38.135508 ], [ -79.928747, 38.144436 ], [ -79.928683, 38.144928 ], [ -79.925512, 38.150237 ], [ -79.925251, 38.150465 ], [ -79.921026, 38.179954 ], [ -79.921196, 38.180378 ], [ -79.917061, 38.183741 ], [ -79.916174, 38.184386 ], [ -79.892345, 38.202397 ], [ -79.891999, 38.203378 ], [ -79.794568, 38.264856 ], [ -79.790134, 38.267654 ], [ -79.788945, 38.268703 ], [ -79.810115, 38.305037 ], [ -79.808711, 38.309429 ], [ -79.731661, 38.374143 ], [ -79.691377, 38.439558 ], [ -79.689544, 38.442511 ], [ -79.688962, 38.449538 ], [ -79.688205, 38.450476 ], [ -79.699006, 38.475148 ], [ -79.695565, 38.477842 ], [ -79.669128, 38.510883 ], [ -79.669128, 38.510975 ], [ -79.649075, 38.591515 ], [ -79.597955, 38.572767 ], [ -79.555471, 38.560217 ], [ -79.536870, 38.550917 ], [ -79.521469, 38.533918 ], [ -79.476638, 38.457228 ], [ -79.312276, 38.411876 ], [ -79.297758, 38.416438 ], [ -79.295712, 38.418129 ], [ -79.291813, 38.419627 ], [ -79.290529, 38.420757 ], [ -79.280263, 38.425475 ], [ -79.282663, 38.431021 ], [ -79.267414, 38.438322 ], [ -79.265327, 38.441772 ], [ -79.263376, 38.443762 ], [ -79.262910, 38.444586 ], [ -79.242024, 38.464332 ], [ -79.240059, 38.469841 ], [ -79.234408, 38.473011 ], [ -79.231620, 38.474041 ], [ -79.225839, 38.479446 ], [ -79.210026, 38.494231 ], [ -79.210008, 38.494283 ], [ -79.209703, 38.495574 ], [ -79.207873, 38.500122 ], [ -79.207884, 38.500428 ], [ -79.174881, 38.566314 ], [ -79.174512, 38.566531 ], [ -79.146974, 38.625641 ], [ -79.146741, 38.625819 ], [ -79.137012, 38.640655 ], [ -79.136374, 38.642400 ], [ -79.135546, 38.643715 ], [ -79.135472, 38.644057 ], [ -79.092271, 38.699208 ], [ -79.092555, 38.700149 ], [ -79.057253, 38.761413 ], [ -79.055354, 38.782213 ], [ -78.999752, 38.846162 ], [ -78.993997, 38.850102 ], [ -78.869276, 38.762991 ] ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US72", "STATE": 20, "name": "Puerto Rico", "LSAD": "", "CENSUSAREA": 3423.775000 }, "geometry": { "type": "MultiPolygon", "coordinates": [ [ [ [ -65.280764, 18.288274 ], [ -65.283269, 18.280214 ], [ -65.287257, 18.277744 ], [ -65.300238, 18.294404 ], [ -65.301690, 18.300126 ], [ -65.299701, 18.302181 ], [ -65.296515, 18.302299 ], [ -65.288941, 18.299977 ], [ -65.280764, 18.288274 ] ] ], [ [ [ -65.316371, 18.309660 ], [ -65.316885, 18.314047 ], [ -65.322785, 18.321157 ], [ -65.327318, 18.323666 ], [ -65.342068, 18.345290 ], [ -65.335701, 18.349535 ], [ -65.329334, 18.341955 ], [ -65.321754, 18.338316 ], [ -65.309833, 18.337973 ], [ -65.304409, 18.332054 ], [ -65.298328, 18.330529 ], [ -65.281657, 18.329370 ], [ -65.277319, 18.332582 ], [ -65.253174, 18.318524 ], [ -65.245095, 18.309668 ], [ -65.244424, 18.303493 ], [ -65.249857, 18.296691 ], [ -65.260282, 18.290823 ], [ -65.263937, 18.290685 ], [ -65.276037, 18.296067 ], [ -65.277099, 18.298978 ], [ -65.276007, 18.302613 ], [ -65.280502, 18.306202 ], [ -65.302536, 18.310488 ], [ -65.302160, 18.305379 ], [ -65.302426, 18.303145 ], [ -65.307027, 18.301636 ], [ -65.316371, 18.309660 ] ] ], [ [ [ -65.327700, 18.295843 ], [ -65.331398, 18.296110 ], [ -65.337451, 18.308308 ], [ -65.330188, 18.315998 ], [ -65.327821, 18.308970 ], [ -65.327700, 18.295843 ] ] ], [ [ [ -65.228485, 18.323013 ], [ -65.221568, 18.320959 ], [ -65.221110, 18.311984 ], [ -65.222853, 18.310464 ], [ -65.230025, 18.311274 ], [ -65.231933, 18.320339 ], [ -65.228485, 18.323013 ] ] ], [ [ [ -65.266169, 18.341751 ], [ -65.255933, 18.342117 ], [ -65.245756, 18.334707 ], [ -65.247210, 18.333345 ], [ -65.259612, 18.334147 ], [ -65.265558, 18.339392 ], [ -65.266169, 18.341751 ] ] ], [ [ [ -65.582967, 18.246749 ], [ -65.591954, 18.248653 ], [ -65.594940, 18.248653 ], [ -65.595860, 18.247792 ], [ -65.598153, 18.247595 ], [ -65.599627, 18.255699 ], [ -65.584892, 18.256376 ], [ -65.582967, 18.246749 ] ] ], [ [ [ -65.571523, 18.351635 ], [ -65.569013, 18.352794 ], [ -65.565744, 18.349524 ], [ -65.565072, 18.347499 ], [ -65.567951, 18.343341 ], [ -65.571523, 18.351635 ] ] ], [ [ [ -65.572248, 18.381757 ], [ -65.568979, 18.382125 ], [ -65.566355, 18.378212 ], [ -65.571787, 18.376370 ], [ -65.572248, 18.381757 ] ] ], [ [ [ -65.587335, 18.381994 ], [ -65.591650, 18.386287 ], [ -65.592585, 18.390849 ], [ -65.589332, 18.390516 ], [ -65.584537, 18.386939 ], [ -65.583571, 18.383751 ], [ -65.587335, 18.381994 ] ] ], [ [ [ -67.891740, 18.113970 ], [ -67.887099, 18.112574 ], [ -67.876430, 18.114157 ], [ -67.869804, 18.118851 ], [ -67.861548, 18.122144 ], [ -67.848245, 18.108320 ], [ -67.843202, 18.094858 ], [ -67.843615, 18.085099 ], [ -67.845293, 18.081938 ], [ -67.853098, 18.078195 ], [ -67.865598, 18.065440 ], [ -67.871462, 18.057800 ], [ -67.895921, 18.052342 ], [ -67.904431, 18.059130 ], [ -67.918778, 18.063116 ], [ -67.927841, 18.068572 ], [ -67.940799, 18.079716 ], [ -67.934479, 18.111306 ], [ -67.932185, 18.113221 ], [ -67.910880, 18.119668 ], [ -67.891740, 18.113970 ] ] ], [ [ [ -67.950099, 18.154235 ], [ -67.954119, 18.154576 ], [ -67.952974, 18.157663 ], [ -67.949873, 18.157015 ], [ -67.950099, 18.154235 ] ] ], [ [ [ -67.477976, 18.378945 ], [ -67.485499, 18.382224 ], [ -67.489346, 18.387441 ], [ -67.482204, 18.391470 ], [ -67.477922, 18.390544 ], [ -67.472368, 18.382801 ], [ -67.477976, 18.378945 ] ] ], [ [ [ -66.523478, 17.896176 ], [ -66.513454, 17.902857 ], [ -66.509783, 17.900466 ], [ -66.509525, 17.898552 ], [ -66.515349, 17.892700 ], [ -66.528572, 17.884813 ], [ -66.526072, 17.892937 ], [ -66.523478, 17.896176 ] ] ], [ [ [ -66.349647, 18.486335 ], [ -66.337728, 18.485620 ], [ -66.315477, 18.474724 ], [ -66.315030, 18.474680 ], [ -66.291225, 18.472347 ], [ -66.283675, 18.472203 ], [ -66.276599, 18.478129 ], [ -66.269799, 18.480281 ], [ -66.258015, 18.476906 ], [ -66.251547, 18.472464 ], [ -66.241797, 18.468740 ], [ -66.220148, 18.466000 ], [ -66.199032, 18.466163 ], [ -66.192664, 18.466212 ], [ -66.183886, 18.460506 ], [ -66.179218, 18.455305 ], [ -66.172315, 18.451462 ], [ -66.159796, 18.451706 ], [ -66.153037, 18.454457 ], [ -66.143950, 18.459761 ], [ -66.139572, 18.462317 ], [ -66.139451, 18.462387 ], [ -66.139443, 18.462315 ], [ -66.138532, 18.453305 ], [ -66.133085, 18.445881 ], [ -66.127938, 18.444632 ], [ -66.125198, 18.451209 ], [ -66.124284, 18.456324 ], [ -66.123188, 18.459430 ], [ -66.123343, 18.460363 ], [ -66.125015, 18.470435 ], [ -66.118338, 18.469581 ], [ -66.092098, 18.466535 ], [ -66.083254, 18.462022 ], [ -66.073987, 18.458100 ], [ -66.043272, 18.453655 ], [ -66.039440, 18.454441 ], [ -66.036559, 18.450216 ], [ -66.036491, 18.450117 ], [ -66.023221, 18.443875 ], [ -66.006523, 18.444347 ], [ -65.997180, 18.449895 ], [ -65.992935, 18.457489 ], [ -65.992793, 18.458102 ], [ -65.992349, 18.460024 ], [ -65.990790, 18.460419 ], [ -65.958492, 18.451354 ], [ -65.925670, 18.444881 ], [ -65.916843, 18.444619 ], [ -65.907756, 18.446893 ], [ -65.904988, 18.450926 ], [ -65.878683, 18.438322 ], [ -65.838825, 18.431865 ], [ -65.831476, 18.426849 ], [ -65.828457, 18.423543 ], [ -65.816691, 18.410663 ], [ -65.794556, 18.402845 ], [ -65.787666, 18.402544 ], [ -65.774937, 18.413951 ], [ -65.770530, 18.412940 ], [ -65.769749, 18.409473 ], [ -65.771695, 18.406277 ], [ -65.750455, 18.385208 ], [ -65.750179, 18.385050 ], [ -65.742154, 18.380459 ], [ -65.733567, 18.382211 ], [ -65.699069, 18.368156 ], [ -65.669636, 18.362102 ], [ -65.668845, 18.361939 ], [ -65.634431, 18.369835 ], [ -65.627246, 18.376436 ], [ -65.626527, 18.381728 ], [ -65.624975, 18.386553 ], [ -65.622761, 18.387771 ], [ -65.618229, 18.386496 ], [ -65.614891, 18.382473 ], [ -65.619068, 18.367755 ], [ -65.628198, 18.353711 ], [ -65.634190, 18.338965 ], [ -65.628047, 18.328252 ], [ -65.626456, 18.298982 ], [ -65.634389, 18.292349 ], [ -65.635826, 18.288271 ], [ -65.634893, 18.283923 ], [ -65.630833, 18.264989 ], [ -65.623111, 18.248012 ], [ -65.597618, 18.234289 ], [ -65.589947, 18.228225 ], [ -65.593795, 18.224059 ], [ -65.615981, 18.227389 ], [ -65.626731, 18.235484 ], [ -65.638181, 18.229121 ], [ -65.637565, 18.224444 ], [ -65.628414, 18.205149 ], [ -65.635281, 18.199975 ], [ -65.639688, 18.205656 ], [ -65.662185, 18.207018 ], [ -65.664127, 18.207136 ], [ -65.690749, 18.194990 ], [ -65.694515, 18.187011 ], [ -65.691021, 18.178998 ], [ -65.695856, 18.179324 ], [ -65.710895, 18.186963 ], [ -65.712533, 18.189146 ], [ -65.717999, 18.190176 ], [ -65.728471, 18.185588 ], [ -65.734664, 18.180368 ], [ -65.738834, 18.174066 ], [ -65.739125, 18.173453 ], [ -65.743632, 18.163957 ], [ -65.758728, 18.156601 ], [ -65.766919, 18.148424 ], [ -65.777584, 18.129239 ], [ -65.796711, 18.083746 ], [ -65.796289, 18.079835 ], [ -65.794686, 18.078607 ], [ -65.795028, 18.073561 ], [ -65.796711, 18.069842 ], [ -65.801831, 18.058527 ], [ -65.809174, 18.056818 ], [ -65.817107, 18.063378 ], [ -65.825848, 18.057482 ], [ -65.831090, 18.050664 ], [ -65.834274, 18.038988 ], [ -65.832429, 18.014916 ], [ -65.839591, 18.015077 ], [ -65.850913, 18.011954 ], [ -65.870335, 18.006597 ], [ -65.875122, 18.002826 ], [ -65.884937, 17.988521 ], [ -65.896102, 17.990260 ], [ -65.905319, 17.983974 ], [ -65.910537, 17.981855 ], [ -65.924738, 17.976087 ], [ -65.976611, 17.967669 ], [ -65.984550, 17.969411 ], [ -65.985358, 17.971854 ], [ -65.995185, 17.978989 ], [ -66.007731, 17.980541 ], [ -66.017308, 17.979583 ], [ -66.019539, 17.978354 ], [ -66.024000, 17.975896 ], [ -66.046585, 17.954853 ], [ -66.049033, 17.954561 ], [ -66.058217, 17.959238 ], [ -66.068678, 17.966335 ], [ -66.069979, 17.966357 ], [ -66.081410, 17.966552 ], [ -66.116194, 17.949141 ], [ -66.127009, 17.946953 ], [ -66.140661, 17.941020 ], [ -66.147912, 17.933963 ], [ -66.155387, 17.929406 ], [ -66.159742, 17.928613 ], [ -66.161232, 17.931747 ], [ -66.175626, 17.933565 ], [ -66.186914, 17.935363 ], [ -66.189726, 17.933936 ], [ -66.200174, 17.929515 ], [ -66.206961, 17.932268 ], [ -66.213374, 17.944614 ], [ -66.202655, 17.944753 ], [ -66.185554, 17.940997 ], [ -66.179548, 17.943727 ], [ -66.174839, 17.948214 ], [ -66.176814, 17.950438 ], [ -66.206207, 17.963050 ], [ -66.206807, 17.963307 ], [ -66.215355, 17.959376 ], [ -66.218081, 17.957290 ], [ -66.231519, 17.943912 ], [ -66.229181, 17.934651 ], [ -66.232013, 17.931154 ], [ -66.252737, 17.934574 ], [ -66.260684, 17.936083 ], [ -66.270905, 17.947098 ], [ -66.275651, 17.948260 ], [ -66.290782, 17.946491 ], [ -66.297679, 17.959148 ], [ -66.316950, 17.976683 ], [ -66.323659, 17.978536 ], [ -66.338152, 17.976492 ], [ -66.338390, 17.976458 ], [ -66.362511, 17.968231 ], [ -66.365098, 17.964832 ], [ -66.368777, 17.957717 ], [ -66.371591, 17.951469 ], [ -66.385059, 17.939004 ], [ -66.391227, 17.945819 ], [ -66.398945, 17.950925 ], [ -66.412131, 17.957286 ], [ -66.445481, 17.979379 ], [ -66.450368, 17.983226 ], [ -66.454888, 17.986784 ], [ -66.461342, 17.990273 ], [ -66.491396, 17.990262 ], [ -66.510143, 17.985618 ], [ -66.540537, 17.975476 ], [ -66.583233, 17.961229 ], [ -66.589658, 17.969386 ], [ -66.594392, 17.970682 ], [ -66.605035, 17.969015 ], [ -66.623788, 17.981050 ], [ -66.631944, 17.982746 ], [ -66.645651, 17.980260 ], [ -66.657797, 17.974605 ], [ -66.664391, 17.968259 ], [ -66.672819, 17.966451 ], [ -66.699115, 17.977568 ], [ -66.709856, 17.982109 ], [ -66.713394, 17.987763 ], [ -66.716957, 17.990344 ], [ -66.731118, 17.991658 ], [ -66.746248, 17.990349 ], [ -66.750427, 17.995443 ], [ -66.753964, 17.999590 ], [ -66.755341, 18.001203 ], [ -66.764491, 18.006317 ], [ -66.770307, 18.005955 ], [ -66.799656, 17.992450 ], [ -66.806866, 17.983786 ], [ -66.807924, 17.979606 ], [ -66.806903, 17.976046 ], [ -66.805683, 17.975052 ], [ -66.795106, 17.977438 ], [ -66.789302, 17.980793 ], [ -66.784953, 17.978326 ], [ -66.787245, 17.972914 ], [ -66.808270, 17.965635 ], [ -66.822400, 17.954499 ], [ -66.838584, 17.949931 ], [ -66.852288, 17.955004 ], [ -66.856474, 17.956553 ], [ -66.859471, 17.954316 ], [ -66.862545, 17.952022 ], [ -66.871697, 17.952707 ], [ -66.883440, 17.952526 ], [ -66.899639, 17.948298 ], [ -66.904585, 17.950527 ], [ -66.906532, 17.955356 ], [ -66.906276, 17.963368 ], [ -66.924529, 17.972808 ], [ -66.928651, 17.970204 ], [ -66.930414, 17.963127 ], [ -66.916127, 17.959102 ], [ -66.909483, 17.952559 ], [ -66.909359, 17.949880 ], [ -66.912522, 17.947446 ], [ -66.930313, 17.943389 ], [ -66.932636, 17.939998 ], [ -66.931581, 17.936900 ], [ -66.919298, 17.932062 ], [ -66.923826, 17.926923 ], [ -66.927261, 17.926875 ], [ -66.959998, 17.940216 ], [ -66.980516, 17.951648 ], [ -66.981050, 17.952505 ], [ -66.982669, 17.955100 ], [ -66.982206, 17.961192 ], [ -66.987287, 17.970663 ], [ -66.996738, 17.972899 ], [ -67.003972, 17.970799 ], [ -67.014744, 17.968468 ], [ -67.024522, 17.970722 ], [ -67.062478, 17.973819 ], [ -67.076534, 17.967759 ], [ -67.089827, 17.951418 ], [ -67.101468, 17.946621 ], [ -67.109985, 17.945806 ], [ -67.109986, 17.945806 ], [ -67.128251, 17.948153 ], [ -67.133733, 17.951919 ], [ -67.167031, 17.963073 ], [ -67.178566, 17.964792 ], [ -67.183508, 17.962706 ], [ -67.188717, 17.950989 ], [ -67.187474, 17.946252 ], [ -67.183694, 17.937982 ], [ -67.183457, 17.931135 ], [ -67.194785, 17.932826 ], [ -67.196924, 17.935651 ], [ -67.197273, 17.937461 ], [ -67.197517, 17.941514 ], [ -67.197668, 17.943549 ], [ -67.198988, 17.947820 ], [ -67.200973, 17.949896 ], [ -67.210034, 17.953595 ], [ -67.212101, 17.956027 ], [ -67.214330, 17.962436 ], [ -67.215271, 17.983464 ], [ -67.211973, 17.992993 ], [ -67.207694, 17.998019 ], [ -67.177893, 18.008882 ], [ -67.174299, 18.011149 ], [ -67.172397, 18.014906 ], [ -67.172138, 18.021422 ], [ -67.173761, 18.024548 ], [ -67.193269, 18.031850 ], [ -67.209887, 18.035439 ], [ -67.196694, 18.066491 ], [ -67.190656, 18.064269 ], [ -67.184589, 18.067750 ], [ -67.183938, 18.069914 ], [ -67.186465, 18.074195 ], [ -67.192999, 18.076877 ], [ -67.198212, 18.076828 ], [ -67.199314, 18.091135 ], [ -67.195290, 18.096149 ], [ -67.183921, 18.103683 ], [ -67.182182, 18.108507 ], [ -67.176554, 18.151046 ], [ -67.178618, 18.159318 ], [ -67.180822, 18.168055 ], [ -67.180701, 18.168182 ], [ -67.155185, 18.195001 ], [ -67.152665, 18.203493 ], [ -67.158001, 18.216719 ], [ -67.173000, 18.230666 ], [ -67.175429, 18.248008 ], [ -67.187843, 18.266671 ], [ -67.187873, 18.266874 ], [ -67.189971, 18.281015 ], [ -67.196056, 18.290443 ], [ -67.209963, 18.294974 ], [ -67.225403, 18.296648 ], [ -67.226081, 18.296722 ], [ -67.235137, 18.299935 ], [ -67.267484, 18.353149 ], [ -67.271350, 18.362329 ], [ -67.268259, 18.366989 ], [ -67.260671, 18.370197 ], [ -67.239090, 18.375318 ], [ -67.226744, 18.378247 ], [ -67.216998, 18.382078 ], [ -67.202167, 18.389908 ], [ -67.160144, 18.415587 ], [ -67.159608, 18.415915 ], [ -67.156599, 18.418983 ], [ -67.155245, 18.424401 ], [ -67.156619, 18.439562 ], [ -67.161746, 18.453462 ], [ -67.169011, 18.466352 ], [ -67.169016, 18.478488 ], [ -67.164144, 18.487396 ], [ -67.142830, 18.505485 ], [ -67.138249, 18.507776 ], [ -67.125655, 18.511706 ], [ -67.103468, 18.514523 ], [ -67.093752, 18.515757 ], [ -67.079290, 18.513256 ], [ -67.020276, 18.510603 ], [ -66.988958, 18.497724 ], [ -66.959540, 18.489878 ], [ -66.957733, 18.489129 ], [ -66.957517, 18.489171 ], [ -66.944636, 18.491693 ], [ -66.906872, 18.483556 ], [ -66.901430, 18.484552 ], [ -66.867386, 18.490785 ], [ -66.849673, 18.490745 ], [ -66.836940, 18.487659 ], [ -66.836635, 18.487701 ], [ -66.799320, 18.492775 ], [ -66.780311, 18.491411 ], [ -66.764893, 18.484097 ], [ -66.749301, 18.476701 ], [ -66.742067, 18.474681 ], [ -66.733986, 18.473457 ], [ -66.710743, 18.472611 ], [ -66.683719, 18.481367 ], [ -66.679876, 18.484944 ], [ -66.664364, 18.487809 ], [ -66.645839, 18.488777 ], [ -66.624618, 18.494199 ], [ -66.586778, 18.484948 ], [ -66.584074, 18.484287 ], [ -66.565241, 18.485523 ], [ -66.562916, 18.488450 ], [ -66.563485, 18.490512 ], [ -66.558503, 18.489987 ], [ -66.534840, 18.481253 ], [ -66.533487, 18.481663 ], [ -66.529476, 18.482877 ], [ -66.511609, 18.476848 ], [ -66.470292, 18.469070 ], [ -66.456486, 18.468920 ], [ -66.449184, 18.470991 ], [ -66.441852, 18.479751 ], [ -66.439961, 18.485525 ], [ -66.438813, 18.485713 ], [ -66.420921, 18.488639 ], [ -66.410344, 18.489886 ], [ -66.394287, 18.489748 ], [ -66.377286, 18.488044 ], [ -66.372820, 18.487726 ], [ -66.349647, 18.486335 ] ] ], [ [ [ -65.308717, 18.145172 ], [ -65.302295, 18.141089 ], [ -65.294896, 18.142830 ], [ -65.287962, 18.148097 ], [ -65.275165, 18.134430 ], [ -65.276214, 18.131936 ], [ -65.283248, 18.132999 ], [ -65.296036, 18.127990 ], [ -65.322794, 18.126589 ], [ -65.327184, 18.124106 ], [ -65.338506, 18.112439 ], [ -65.342037, 18.111380 ], [ -65.350493, 18.111914 ], [ -65.364733, 18.120377 ], [ -65.397837, 18.110873 ], [ -65.399791, 18.108832 ], [ -65.411767, 18.106211 ], [ -65.423765, 18.097764 ], [ -65.426311, 18.093749 ], [ -65.451380, 18.086096 ], [ -65.456810, 18.087778 ], [ -65.465849, 18.087715 ], [ -65.468768, 18.092643 ], [ -65.479790, 18.096352 ], [ -65.507265, 18.091646 ], [ -65.524209, 18.081977 ], [ -65.542087, 18.081177 ], [ -65.558646, 18.085660 ], [ -65.569305, 18.091616 ], [ -65.570628, 18.097325 ], [ -65.576860, 18.103224 ], [ -65.575579, 18.115669 ], [ -65.546199, 18.119329 ], [ -65.511712, 18.132840 ], [ -65.489829, 18.135912 ], [ -65.467910, 18.143767 ], [ -65.437058, 18.157660 ], [ -65.399517, 18.161935 ], [ -65.371373, 18.157517 ], [ -65.334289, 18.147761 ], [ -65.313476, 18.144296 ], [ -65.308717, 18.145172 ] ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US10", "STATE": 21, "name": "Delaware", "LSAD": "", "CENSUSAREA": 1948.543000 }, "geometry": { "type": "MultiPolygon", "coordinates": [ [ [ [ -75.564927, 39.583248 ], [ -75.576271, 39.588144 ], [ -75.578719, 39.591504 ], [ -75.579615, 39.598656 ], [ -75.565823, 39.590608 ], [ -75.564927, 39.583248 ] ] ], [ [ [ -75.555870, 39.605824 ], [ -75.561934, 39.605216 ], [ -75.567694, 39.613744 ], [ -75.571759, 39.623584 ], [ -75.570798, 39.626768 ], [ -75.559446, 39.629812 ], [ -75.555870, 39.605824 ] ] ], [ [ [ -75.594846, 39.837286 ], [ -75.593666, 39.837455 ], [ -75.593082, 39.837500 ], [ -75.579900, 39.838522 ], [ -75.579849, 39.838526 ], [ -75.539346, 39.838211 ], [ -75.498843, 39.833312 ], [ -75.453740, 39.820312 ], [ -75.428038, 39.809212 ], [ -75.415041, 39.801786 ], [ -75.416095, 39.795830 ], [ -75.437938, 39.783413 ], [ -75.440623, 39.780926 ], [ -75.448135, 39.773969 ], [ -75.466249, 39.750769 ], [ -75.466263, 39.750737 ], [ -75.469239, 39.743613 ], [ -75.474168, 39.735473 ], [ -75.475384, 39.731057 ], [ -75.504042, 39.698313 ], [ -75.509742, 39.686113 ], [ -75.529744, 39.692613 ], [ -75.562246, 39.656712 ], [ -75.587147, 39.651012 ], [ -75.611969, 39.621968 ], [ -75.613153, 39.620960 ], [ -75.613377, 39.620288 ], [ -75.614065, 39.618320 ], [ -75.614929, 39.615952 ], [ -75.614273, 39.614640 ], [ -75.613345, 39.613056 ], [ -75.613665, 39.612560 ], [ -75.613233, 39.607408 ], [ -75.613477, 39.606861 ], [ -75.613473, 39.606832 ], [ -75.613793, 39.606192 ], [ -75.611905, 39.597568 ], [ -75.611873, 39.597408 ], [ -75.604640, 39.589920 ], [ -75.603584, 39.588960 ], [ -75.592224, 39.583568 ], [ -75.591984, 39.583248 ], [ -75.587744, 39.580672 ], [ -75.587200, 39.580256 ], [ -75.586608, 39.578880 ], [ -75.586016, 39.578448 ], [ -75.571599, 39.567728 ], [ -75.570783, 39.567280 ], [ -75.563034, 39.562240 ], [ -75.564649, 39.559922 ], [ -75.565636, 39.558509 ], [ -75.569359, 39.540589 ], [ -75.569418, 39.539124 ], [ -75.570362, 39.527223 ], [ -75.560728, 39.520472 ], [ -75.566933, 39.508273 ], [ -75.576436, 39.509195 ], [ -75.587729, 39.496353 ], [ -75.587729, 39.495369 ], [ -75.593068, 39.479186 ], [ -75.593068, 39.477996 ], [ -75.589901, 39.462022 ], [ -75.589439, 39.460812 ], [ -75.580185, 39.450786 ], [ -75.578914, 39.447880 ], [ -75.570985, 39.442486 ], [ -75.571830, 39.438897 ], [ -75.555890, 39.430351 ], [ -75.538512, 39.416502 ], [ -75.535977, 39.409384 ], [ -75.523583, 39.391583 ], [ -75.521682, 39.387871 ], [ -75.512996, 39.366153 ], [ -75.512372, 39.365656 ], [ -75.511788, 39.365191 ], [ -75.505276, 39.359169 ], [ -75.494158, 39.354613 ], [ -75.491797, 39.351845 ], [ -75.494122, 39.346580 ], [ -75.493148, 39.345527 ], [ -75.491688, 39.343963 ], [ -75.490377, 39.342818 ], [ -75.479845, 39.337472 ], [ -75.479963, 39.336577 ], [ -75.469324, 39.330820 ], [ -75.460423, 39.328236 ], [ -75.439027, 39.313384 ], [ -75.436936, 39.309379 ], [ -75.435551, 39.297546 ], [ -75.435374, 39.296676 ], [ -75.427953, 39.285049 ], [ -75.408376, 39.264698 ], [ -75.402964, 39.254626 ], [ -75.404823, 39.245898 ], [ -75.405927, 39.243631 ], [ -75.405716, 39.223834 ], [ -75.404745, 39.222666 ], [ -75.396892, 39.216141 ], [ -75.393015, 39.204512 ], [ -75.394790, 39.188354 ], [ -75.398584, 39.186616 ], [ -75.400144, 39.186456 ], [ -75.408266, 39.174625 ], [ -75.410625, 39.156246 ], [ -75.401193, 39.088762 ], [ -75.402035, 39.066885 ], [ -75.400294, 39.065645 ], [ -75.395806, 39.059211 ], [ -75.396277, 39.057884 ], [ -75.387914, 39.051174 ], [ -75.379873, 39.048790 ], [ -75.345763, 39.024857 ], [ -75.340890, 39.019960 ], [ -75.318354, 38.988191 ], [ -75.314951, 38.980775 ], [ -75.311607, 38.967637 ], [ -75.312546, 38.951065 ], [ -75.312546, 38.949280 ], [ -75.311923, 38.945917 ], [ -75.311882, 38.945698 ], [ -75.311542, 38.944633 ], [ -75.302552, 38.939002 ], [ -75.312282, 38.924594 ], [ -75.304078, 38.913160 ], [ -75.263115, 38.877351 ], [ -75.232029, 38.844254 ], [ -75.205329, 38.823386 ], [ -75.190552, 38.806861 ], [ -75.160748, 38.791224 ], [ -75.159022, 38.790193 ], [ -75.134022, 38.782242 ], [ -75.113331, 38.782998 ], [ -75.097103, 38.788703 ], [ -75.093654, 38.793992 ], [ -75.097197, 38.803101 ], [ -75.093805, 38.803812 ], [ -75.089473, 38.797198 ], [ -75.082153, 38.772157 ], [ -75.080217, 38.750112 ], [ -75.079221, 38.738238 ], [ -75.065510, 38.661030 ], [ -75.065217, 38.632394 ], [ -75.061920, 38.608869 ], [ -75.061259, 38.608602 ], [ -75.060478, 38.608012 ], [ -75.060032, 38.607709 ], [ -75.049748, 38.486387 ], [ -75.048939, 38.451263 ], [ -75.049268, 38.451264 ], [ -75.052510, 38.451273 ], [ -75.053483, 38.451274 ], [ -75.066327, 38.451291 ], [ -75.069909, 38.451276 ], [ -75.070356, 38.451276 ], [ -75.085814, 38.451258 ], [ -75.088281, 38.451256 ], [ -75.089649, 38.451254 ], [ -75.141894, 38.451196 ], [ -75.185413, 38.451013 ], [ -75.252723, 38.451397 ], [ -75.260350, 38.451492 ], [ -75.341247, 38.451970 ], [ -75.341250, 38.451970 ], [ -75.355797, 38.452008 ], [ -75.371054, 38.452107 ], [ -75.393563, 38.452114 ], [ -75.394786, 38.452160 ], [ -75.410884, 38.452400 ], [ -75.424831, 38.452610 ], [ -75.428728, 38.452671 ], [ -75.479150, 38.453699 ], [ -75.500142, 38.454144 ], [ -75.502961, 38.454220 ], [ -75.521304, 38.454657 ], [ -75.522730, 38.454657 ], [ -75.533763, 38.454958 ], [ -75.559212, 38.455563 ], [ -75.559934, 38.455579 ], [ -75.574110, 38.455991 ], [ -75.583601, 38.456424 ], [ -75.589307, 38.456286 ], [ -75.593082, 38.456404 ], [ -75.598069, 38.456855 ], [ -75.630457, 38.457904 ], [ -75.662843, 38.458759 ], [ -75.665585, 38.458900 ], [ -75.693521, 38.460128 ], [ -75.696369, 38.492373 ], [ -75.696688, 38.496467 ], [ -75.698777, 38.522001 ], [ -75.700179, 38.542717 ], [ -75.701465, 38.559433 ], [ -75.701565, 38.560736 ], [ -75.703445, 38.585120 ], [ -75.703981, 38.592066 ], [ -75.705774, 38.614740 ], [ -75.705860, 38.616268 ], [ -75.706235, 38.621296 ], [ -75.706585, 38.626125 ], [ -75.707346, 38.635280 ], [ -75.707352, 38.635359 ], [ -75.722028, 38.822078 ], [ -75.722599, 38.829859 ], [ -75.722610, 38.830008 ], [ -75.722882, 38.833156 ], [ -75.724002, 38.846682 ], [ -75.724061, 38.847781 ], [ -75.725565, 38.868152 ], [ -75.725829, 38.869296 ], [ -75.745793, 39.114935 ], [ -75.746121, 39.120318 ], [ -75.747668, 39.143306 ], [ -75.747671, 39.143345 ], [ -75.755953, 39.245958 ], [ -75.755962, 39.246069 ], [ -75.760104, 39.296817 ], [ -75.766667, 39.377216 ], [ -75.766693, 39.377537 ], [ -75.779240, 39.534737 ], [ -75.779383, 39.536522 ], [ -75.786890, 39.630575 ], [ -75.787450, 39.637455 ], [ -75.788616, 39.680742 ], [ -75.788658, 39.681911 ], [ -75.788395, 39.700031 ], [ -75.788395, 39.700287 ], [ -75.788359, 39.721811 ], [ -75.739705, 39.772623 ], [ -75.716969, 39.791998 ], [ -75.685991, 39.811054 ], [ -75.662822, 39.821150 ], [ -75.641518, 39.828363 ], [ -75.634706, 39.830164 ], [ -75.595756, 39.837156 ], [ -75.594846, 39.837286 ] ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US54", "STATE": 22, "name": "West Virginia", "LSAD": "", "CENSUSAREA": 24038.210000 }, "geometry": { "type": "Polygon", "coordinates": [ [ [ -78.571901, 39.031995 ], [ -78.565837, 39.026303 ], [ -78.554222, 39.019672 ], [ -78.557647, 39.013189 ], [ -78.601655, 38.964603 ], [ -78.710949, 38.910175 ], [ -78.714135, 38.911176 ], [ -78.716956, 38.916273 ], [ -78.719755, 38.922135 ], [ -78.719806, 38.922638 ], [ -78.757278, 38.903203 ], [ -78.779198, 38.892298 ], [ -78.788031, 38.885123 ], [ -78.808181, 38.856175 ], [ -78.835191, 38.811499 ], [ -78.869276, 38.762991 ], [ -78.993997, 38.850102 ], [ -78.999752, 38.846162 ], [ -79.055354, 38.782213 ], [ -79.057253, 38.761413 ], [ -79.092555, 38.700149 ], [ -79.092271, 38.699208 ], [ -79.135472, 38.644057 ], [ -79.135546, 38.643715 ], [ -79.136374, 38.642400 ], [ -79.137012, 38.640655 ], [ -79.146741, 38.625819 ], [ -79.146974, 38.625641 ], [ -79.174512, 38.566531 ], [ -79.174881, 38.566314 ], [ -79.207884, 38.500428 ], [ -79.207873, 38.500122 ], [ -79.209703, 38.495574 ], [ -79.210008, 38.494283 ], [ -79.210026, 38.494231 ], [ -79.225839, 38.479446 ], [ -79.231620, 38.474041 ], [ -79.234408, 38.473011 ], [ -79.240059, 38.469841 ], [ -79.242024, 38.464332 ], [ -79.262910, 38.444586 ], [ -79.263376, 38.443762 ], [ -79.265327, 38.441772 ], [ -79.267414, 38.438322 ], [ -79.282663, 38.431021 ], [ -79.280263, 38.425475 ], [ -79.290529, 38.420757 ], [ -79.291813, 38.419627 ], [ -79.295712, 38.418129 ], [ -79.297758, 38.416438 ], [ -79.312276, 38.411876 ], [ -79.476638, 38.457228 ], [ -79.521469, 38.533918 ], [ -79.536870, 38.550917 ], [ -79.555471, 38.560217 ], [ -79.597955, 38.572767 ], [ -79.649075, 38.591515 ], [ -79.669128, 38.510975 ], [ -79.669128, 38.510883 ], [ -79.695565, 38.477842 ], [ -79.699006, 38.475148 ], [ -79.688205, 38.450476 ], [ -79.688962, 38.449538 ], [ -79.689544, 38.442511 ], [ -79.691377, 38.439558 ], [ -79.731661, 38.374143 ], [ -79.808711, 38.309429 ], [ -79.810115, 38.305037 ], [ -79.788945, 38.268703 ], [ -79.790134, 38.267654 ], [ -79.794568, 38.264856 ], [ -79.891999, 38.203378 ], [ -79.892345, 38.202397 ], [ -79.916174, 38.184386 ], [ -79.917061, 38.183741 ], [ -79.921196, 38.180378 ], [ -79.921026, 38.179954 ], [ -79.925251, 38.150465 ], [ -79.925512, 38.150237 ], [ -79.928683, 38.144928 ], [ -79.928747, 38.144436 ], [ -79.933751, 38.135508 ], [ -79.938394, 38.130563 ], [ -79.931034, 38.101402 ], [ -79.933911, 38.099168 ], [ -79.959844, 38.063697 ], [ -79.978427, 38.029082 ], [ -80.002507, 37.992767 ], [ -80.055278, 37.951702 ], [ -80.130464, 37.893194 ], [ -80.146130, 37.884453 ], [ -80.147316, 37.885936 ], [ -80.148964, 37.886057 ], [ -80.162202, 37.875122 ], [ -80.227092, 37.798886 ], [ -80.231551, 37.792591 ], [ -80.257411, 37.756084 ], [ -80.262765, 37.738336 ], [ -80.260313, 37.733517 ], [ -80.259342, 37.731205 ], [ -80.263936, 37.719137 ], [ -80.287107, 37.696403 ], [ -80.296138, 37.691783 ], [ -80.292337, 37.683976 ], [ -80.292258, 37.683732 ], [ -80.270323, 37.648982 ], [ -80.270352, 37.648929 ], [ -80.267455, 37.646108 ], [ -80.267228, 37.646011 ], [ -80.264874, 37.645511 ], [ -80.264830, 37.645526 ], [ -80.263291, 37.645101 ], [ -80.263281, 37.645082 ], [ -80.254469, 37.642333 ], [ -80.254431, 37.642352 ], [ -80.239288, 37.637672 ], [ -80.220984, 37.627767 ], [ -80.223386, 37.623185 ], [ -80.240272, 37.606961 ], [ -80.288766, 37.581960 ], [ -80.312393, 37.546239 ], [ -80.330306, 37.536244 ], [ -80.314806, 37.500943 ], [ -80.320627, 37.498880 ], [ -80.425656, 37.449876 ], [ -80.443025, 37.438126 ], [ -80.464820, 37.426144 ], [ -80.475601, 37.422949 ], [ -80.494867, 37.435070 ], [ -80.511391, 37.481672 ], [ -80.622664, 37.433307 ], [ -80.770082, 37.372363 ], [ -80.776649, 37.383679 ], [ -80.776766, 37.384131 ], [ -80.798869, 37.395807 ], [ -80.811639, 37.407507 ], [ -80.858360, 37.428168 ], [ -80.858473, 37.428301 ], [ -80.859556, 37.429568 ], [ -80.859558, 37.429555 ], [ -80.862761, 37.411829 ], [ -80.872589, 37.372347 ], [ -80.849451, 37.346909 ], [ -80.900535, 37.315000 ], [ -80.919259, 37.306163 ], [ -80.947896, 37.295872 ], [ -80.966556, 37.292158 ], [ -80.973889, 37.291444 ], [ -80.980044, 37.293118 ], [ -80.981322, 37.293465 ], [ -81.034652, 37.290751 ], [ -81.084012, 37.284401 ], [ -81.112596, 37.278497 ], [ -81.167029, 37.262881 ], [ -81.204774, 37.243013 ], [ -81.225104, 37.234874 ], [ -81.320105, 37.299323 ], [ -81.362156, 37.337687 ], [ -81.366315, 37.335927 ], [ -81.367052, 37.334504 ], [ -81.368090, 37.332423 ], [ -81.369379, 37.331827 ], [ -81.367599, 37.327569 ], [ -81.371315, 37.324115 ], [ -81.377349, 37.318447 ], [ -81.380159, 37.317838 ], [ -81.384127, 37.318596 ], [ -81.384914, 37.318832 ], [ -81.385810, 37.320085 ], [ -81.386727, 37.320474 ], [ -81.388132, 37.319903 ], [ -81.409196, 37.286071 ], [ -81.409729, 37.284837 ], [ -81.504168, 37.250115 ], [ -81.504880, 37.247697 ], [ -81.507325, 37.233800 ], [ -81.557315, 37.207697 ], [ -81.558353, 37.208145 ], [ -81.560625, 37.206663 ], [ -81.678603, 37.202467 ], [ -81.683544, 37.211452 ], [ -81.728194, 37.239823 ], [ -81.733320, 37.238127 ], [ -81.738378, 37.240917 ], [ -81.744291, 37.244178 ], [ -81.743420, 37.245858 ], [ -81.743505, 37.247601 ], [ -81.747656, 37.264329 ], [ -81.751290, 37.265131 ], [ -81.752123, 37.265568 ], [ -81.752912, 37.266614 ], [ -81.755012, 37.267720 ], [ -81.757531, 37.270010 ], [ -81.757714, 37.271124 ], [ -81.757730, 37.271934 ], [ -81.757631, 37.274003 ], [ -81.760220, 37.275254 ], [ -81.761752, 37.275713 ], [ -81.762776, 37.275391 ], [ -81.763836, 37.275218 ], [ -81.765195, 37.275099 ], [ -81.767837, 37.274216 ], [ -81.774684, 37.274807 ], [ -81.774747, 37.274847 ], [ -81.793425, 37.281674 ], [ -81.793639, 37.282188 ], [ -81.809184, 37.283003 ], [ -81.810559, 37.282980 ], [ -81.842310, 37.285556 ], [ -81.843167, 37.285586 ], [ -81.854059, 37.291352 ], [ -81.853488, 37.294763 ], [ -81.854465, 37.299937 ], [ -81.853978, 37.300418 ], [ -81.864760, 37.308404 ], [ -81.865219, 37.308839 ], [ -81.873213, 37.325065 ], [ -81.878343, 37.328837 ], [ -81.878713, 37.331753 ], [ -81.879601, 37.332074 ], [ -81.880886, 37.331146 ], [ -81.885075, 37.330665 ], [ -81.886952, 37.330725 ], [ -81.887722, 37.331156 ], [ -81.892876, 37.330134 ], [ -81.893773, 37.330105 ], [ -81.894768, 37.331381 ], [ -81.894797, 37.332012 ], [ -81.895489, 37.332022 ], [ -81.896001, 37.331967 ], [ -81.899459, 37.340277 ], [ -81.899495, 37.341102 ], [ -81.902992, 37.342340 ], [ -81.903795, 37.343050 ], [ -81.905945, 37.342775 ], [ -81.906368, 37.342760 ], [ -81.907322, 37.343119 ], [ -81.907895, 37.343783 ], [ -81.910875, 37.348729 ], [ -81.911487, 37.348839 ], [ -81.920711, 37.355416 ], [ -81.921571, 37.356423 ], [ -81.925643, 37.357316 ], [ -81.926589, 37.358942 ], [ -81.929915, 37.366589 ], [ -81.930194, 37.366728 ], [ -81.933895, 37.372747 ], [ -81.927490, 37.413251 ], [ -81.935621, 37.438397 ], [ -81.949367, 37.445687 ], [ -81.968795, 37.451496 ], [ -81.987006, 37.454878 ], [ -81.992270, 37.460916 ], [ -81.996578, 37.476705 ], [ -81.992916, 37.482969 ], [ -81.942640, 37.508844 ], [ -81.927870, 37.512118 ], [ -81.968297, 37.537798 ], [ -81.998177, 37.543082 ], [ -81.999844, 37.542579 ], [ -82.008274, 37.533357 ], [ -82.048521, 37.531078 ], [ -82.116584, 37.559588 ], [ -82.125892, 37.574031 ], [ -82.125601, 37.579021 ], [ -82.141814, 37.595052 ], [ -82.219670, 37.643046 ], [ -82.250280, 37.657776 ], [ -82.297011, 37.687273 ], [ -82.307235, 37.707669 ], [ -82.325739, 37.735799 ], [ -82.326404, 37.740815 ], [ -82.319023, 37.758892 ], [ -82.329867, 37.775897 ], [ -82.400234, 37.851833 ], [ -82.417679, 37.870658 ], [ -82.474666, 37.910388 ], [ -82.500386, 37.936518 ], [ -82.497358, 37.945338 ], [ -82.497300, 37.945507 ], [ -82.464987, 37.976859 ], [ -82.464096, 37.982437 ], [ -82.465473, 37.984780 ], [ -82.487732, 37.998330 ], [ -82.509812, 38.001249 ], [ -82.519665, 38.008538 ], [ -82.539139, 38.039093 ], [ -82.547284, 38.061094 ], [ -82.600127, 38.117389 ], [ -82.602618, 38.118350 ], [ -82.621164, 38.123239 ], [ -82.636466, 38.137860 ], [ -82.644739, 38.165487 ], [ -82.604230, 38.247303 ], [ -82.594970, 38.245453 ], [ -82.584001, 38.246371 ], [ -82.578254, 38.254809 ], [ -82.574656, 38.263873 ], [ -82.571877, 38.315781 ], [ -82.593008, 38.375082 ], [ -82.595382, 38.382712 ], [ -82.595369, 38.382722 ], [ -82.597113, 38.412881 ], [ -82.596281, 38.417681 ], [ -82.593673, 38.421809 ], [ -82.560664, 38.404338 ], [ -82.520178, 38.407582 ], [ -82.506670, 38.410092 ], [ -82.340640, 38.440948 ], [ -82.330335, 38.444500 ], [ -82.323999, 38.449268 ], [ -82.320223, 38.454516 ], [ -82.313935, 38.468084 ], [ -82.295571, 38.539783 ], [ -82.293271, 38.560283 ], [ -82.293871, 38.572683 ], [ -82.291271, 38.578983 ], [ -82.287102, 38.582588 ], [ -82.274270, 38.593683 ], [ -82.262070, 38.598183 ], [ -82.245969, 38.598483 ], [ -82.218967, 38.591683 ], [ -82.193824, 38.593096 ], [ -82.181967, 38.599384 ], [ -82.177267, 38.603784 ], [ -82.175167, 38.608484 ], [ -82.172066, 38.619284 ], [ -82.172066, 38.625984 ], [ -82.182467, 38.708782 ], [ -82.188268, 38.734082 ], [ -82.198882, 38.757725 ], [ -82.220449, 38.773739 ], [ -82.221566, 38.787187 ], [ -82.215759, 38.797462 ], [ -82.191172, 38.815137 ], [ -82.184428, 38.816529 ], [ -82.139279, 38.866407 ], [ -82.098762, 38.958288 ], [ -82.093165, 38.970980 ], [ -82.051563, 38.994378 ], [ -82.045663, 39.003778 ], [ -82.041563, 39.017878 ], [ -82.035963, 39.025478 ], [ -82.017562, 39.030078 ], [ -82.002261, 39.027878 ], [ -81.935619, 38.989500 ], [ -81.919783, 38.968494 ], [ -81.900595, 38.937671 ], [ -81.898470, 38.929603 ], [ -81.900910, 38.924338 ], [ -81.926671, 38.901311 ], [ -81.928352, 38.895371 ], [ -81.926967, 38.891602 ], [ -81.908645, 38.878460 ], [ -81.874857, 38.881174 ], [ -81.759995, 38.925828 ], [ -81.756131, 38.933545 ], [ -81.764253, 39.015279 ], [ -81.772854, 39.026179 ], [ -81.793304, 39.040353 ], [ -81.803355, 39.047678 ], [ -81.811655, 39.059578 ], [ -81.814155, 39.073478 ], [ -81.812355, 39.082078 ], [ -81.747253, 39.095378 ], [ -81.747253, 39.095379 ], [ -81.749689, 39.180742 ], [ -81.749853, 39.186489 ], [ -81.740061, 39.190652 ], [ -81.721551, 39.212448 ], [ -81.695724, 39.242859 ], [ -81.605816, 39.275851 ], [ -81.542346, 39.352874 ], [ -81.467744, 39.403774 ], [ -81.456143, 39.409274 ], [ -81.446543, 39.410374 ], [ -81.435642, 39.408474 ], [ -81.412706, 39.394618 ], [ -81.406689, 39.388090 ], [ -81.393794, 39.351706 ], [ -81.384556, 39.343449 ], [ -81.375961, 39.341697 ], [ -81.371271, 39.342062 ], [ -81.356911, 39.343178 ], [ -81.347567, 39.345770 ], [ -81.295373, 39.375290 ], [ -81.270716, 39.385914 ], [ -81.249088, 39.389992 ], [ -81.223581, 39.386062 ], [ -81.215617, 39.388602 ], [ -81.127696, 39.464879 ], [ -81.063587, 39.520497 ], [ -81.038691, 39.540464 ], [ -81.020055, 39.555410 ], [ -80.943782, 39.606926 ], [ -80.892208, 39.616756 ], [ -80.880360, 39.620706 ], [ -80.831871, 39.705655 ], [ -80.829764, 39.711839 ], [ -80.828618, 39.720848 ], [ -80.812342, 39.848845 ], [ -80.806179, 39.897306 ], [ -80.809619, 39.905626 ], [ -80.808722, 39.912570 ], [ -80.806018, 39.917130 ], [ -80.759455, 39.958233 ], [ -80.743166, 39.969113 ], [ -80.740126, 39.970793 ], [ -80.732051, 40.033240 ], [ -80.731504, 40.037472 ], [ -80.730904, 40.049172 ], [ -80.733104, 40.058772 ], [ -80.726504, 40.089072 ], [ -80.705482, 40.153047 ], [ -80.703052, 40.157231 ], [ -80.685391, 40.187642 ], [ -80.652098, 40.244970 ], [ -80.644598, 40.251270 ], [ -80.637198, 40.255070 ], [ -80.616696, 40.280270 ], [ -80.602895, 40.307069 ], [ -80.599895, 40.317669 ], [ -80.609313, 40.360468 ], [ -80.619196, 40.381768 ], [ -80.617346, 40.396004 ], [ -80.612295, 40.434867 ], [ -80.599194, 40.482566 ], [ -80.610259, 40.490962 ], [ -80.666917, 40.573664 ], [ -80.667957, 40.582496 ], [ -80.665892, 40.587728 ], [ -80.634355, 40.616095 ], [ -80.627171, 40.619936 ], [ -80.601494, 40.625387 ], [ -80.594065, 40.623664 ], [ -80.589041, 40.620128 ], [ -80.560720, 40.623680 ], [ -80.518991, 40.638801 ], [ -80.519039, 40.616391 ], [ -80.519086, 40.616385 ], [ -80.519086, 40.590161 ], [ -80.519055, 40.590173 ], [ -80.519057, 40.517922 ], [ -80.519054, 40.517922 ], [ -80.518692, 40.477365 ], [ -80.517998, 40.399644 ], [ -80.517991, 40.398868 ], [ -80.519056, 40.172771 ], [ -80.519056, 40.172744 ], [ -80.519104, 40.159672 ], [ -80.518960, 40.078089 ], [ -80.519008, 40.077001 ], [ -80.519120, 40.016410 ], [ -80.519207, 39.963381 ], [ -80.519218, 39.962424 ], [ -80.519217, 39.962199 ], [ -80.519203, 39.959394 ], [ -80.519175, 39.956648 ], [ -80.519115, 39.939188 ], [ -80.519248, 39.936967 ], [ -80.519342, 39.721403 ], [ -80.421388, 39.721189 ], [ -80.309457, 39.721264 ], [ -80.308651, 39.721283 ], [ -79.916266, 39.720792 ], [ -79.853131, 39.720713 ], [ -79.852904, 39.720713 ], [ -79.763774, 39.720776 ], [ -79.610623, 39.721245 ], [ -79.608223, 39.721154 ], [ -79.476662, 39.721078 ], [ -79.478866, 39.531689 ], [ -79.482354, 39.524682 ], [ -79.482648, 39.521364 ], [ -79.487651, 39.279933 ], [ -79.486737, 39.278149 ], [ -79.486179, 39.264970 ], [ -79.485874, 39.264905 ], [ -79.486873, 39.205961 ], [ -79.402911, 39.250106 ], [ -79.378687, 39.271920 ], [ -79.280039, 39.340076 ], [ -79.256880, 39.356077 ], [ -79.213192, 39.367897 ], [ -79.201676, 39.379726 ], [ -79.084450, 39.471356 ], [ -79.067072, 39.474658 ], [ -79.042440, 39.479339 ], [ -79.025681, 39.465539 ], [ -78.968996, 39.441543 ], [ -78.874744, 39.522611 ], [ -78.824788, 39.590233 ], [ -78.787461, 39.627492 ], [ -78.760497, 39.609984 ], [ -78.769029, 39.599871 ], [ -78.772048, 39.593833 ], [ -78.767490, 39.587487 ], [ -78.760196, 39.582154 ], [ -78.689455, 39.545770 ], [ -78.676219, 39.540622 ], [ -78.657324, 39.535087 ], [ -78.655984, 39.534695 ], [ -78.565929, 39.519444 ], [ -78.468639, 39.516789 ], [ -78.436939, 39.538959 ], [ -78.432033, 39.561053 ], [ -78.450207, 39.570889 ], [ -78.454376, 39.574319 ], [ -78.458456, 39.581158 ], [ -78.457187, 39.587379 ], [ -78.430250, 39.623290 ], [ -78.355218, 39.640576 ], [ -78.334044, 39.635770 ], [ -78.313033, 39.631001 ], [ -78.283039, 39.620470 ], [ -78.271122, 39.619642 ], [ -78.224337, 39.663270 ], [ -78.191107, 39.690262 ], [ -78.182759, 39.695110 ], [ -78.176625, 39.695967 ], [ -78.143478, 39.690412 ], [ -78.107834, 39.682137 ], [ -78.074595, 39.666686 ], [ -78.035992, 39.635720 ], [ -78.023427, 39.619860 ], [ -78.009985, 39.602893 ], [ -77.946442, 39.584910 ], [ -77.902649, 39.587796 ], [ -77.884536, 39.568174 ], [ -77.886135, 39.560432 ], [ -77.888945, 39.555950 ], [ -77.865423, 39.516472 ], [ -77.845105, 39.498285 ], [ -77.825411, 39.494036 ], [ -77.807821, 39.490241 ], [ -77.765442, 39.428574 ], [ -77.739204, 39.385730 ], [ -77.760435, 39.344171 ], [ -77.760586, 39.338864 ], [ -77.755789, 39.333899 ], [ -77.727379, 39.321666 ], [ -77.719029, 39.321125 ], [ -77.750267, 39.289284 ], [ -77.753357, 39.280331 ], [ -77.753060, 39.277971 ], [ -77.753105, 39.277340 ], [ -77.755193, 39.275191 ], [ -77.755698, 39.274575 ], [ -77.758412, 39.269197 ], [ -77.758733, 39.268114 ], [ -77.761217, 39.263721 ], [ -77.761768, 39.263031 ], [ -77.768000, 39.257657 ], [ -77.768992, 39.256417 ], [ -77.767277, 39.249380 ], [ -77.771415, 39.236776 ], [ -77.822182, 39.139985 ], [ -77.828157, 39.132329 ], [ -78.032841, 39.264403 ], [ -78.033183, 39.264624 ], [ -78.033185, 39.264626 ], [ -78.228766, 39.391233 ], [ -78.347087, 39.466012 ], [ -78.362267, 39.357784 ], [ -78.340480, 39.353492 ], [ -78.358940, 39.319484 ], [ -78.360035, 39.317771 ], [ -78.399785, 39.244129 ], [ -78.399669, 39.243874 ], [ -78.423968, 39.212049 ], [ -78.427911, 39.208611 ], [ -78.429803, 39.207014 ], [ -78.431167, 39.205744 ], [ -78.432130, 39.204717 ], [ -78.437053, 39.199766 ], [ -78.438651, 39.198049 ], [ -78.426722, 39.188903 ], [ -78.410740, 39.171983 ], [ -78.418377, 39.156656 ], [ -78.439429, 39.132146 ], [ -78.459869, 39.113351 ], [ -78.508132, 39.088630 ], [ -78.544111, 39.056676 ], [ -78.571901, 39.031995 ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US55", "STATE": 23, "name": "Wisconsin", "LSAD": "", "CENSUSAREA": 54157.805000 }, "geometry": { "type": "MultiPolygon", "coordinates": [ [ [ [ -90.456677, 47.016737 ], [ -90.455300, 47.023750 ], [ -90.455251, 47.024000 ], [ -90.456008, 47.032085 ], [ -90.456380, 47.036062 ], [ -90.457076, 47.043506 ], [ -90.457128, 47.044058 ], [ -90.455502, 47.051331 ], [ -90.455113, 47.053071 ], [ -90.455024, 47.053470 ], [ -90.449572, 47.064965 ], [ -90.449083, 47.065995 ], [ -90.449075, 47.066013 ], [ -90.449024, 47.066045 ], [ -90.448439, 47.066415 ], [ -90.441968, 47.070511 ], [ -90.438734, 47.072557 ], [ -90.437271, 47.073483 ], [ -90.435387, 47.073868 ], [ -90.434762, 47.073996 ], [ -90.434543, 47.074040 ], [ -90.428370, 47.075302 ], [ -90.427087, 47.075564 ], [ -90.425277, 47.075934 ], [ -90.417272, 47.077570 ], [ -90.400234, 47.077263 ], [ -90.398913, 47.077239 ], [ -90.395367, 47.077175 ], [ -90.395170, 47.077017 ], [ -90.394950, 47.076841 ], [ -90.393848, 47.075956 ], [ -90.393830, 47.075941 ], [ -90.393723, 47.074859 ], [ -90.393115, 47.068687 ], [ -90.393111, 47.068644 ], [ -90.393077, 47.068304 ], [ -90.393035, 47.067877 ], [ -90.393241, 47.066753 ], [ -90.393277, 47.066557 ], [ -90.393342, 47.066204 ], [ -90.393351, 47.066153 ], [ -90.393507, 47.065302 ], [ -90.394212, 47.061452 ], [ -90.394312, 47.060909 ], [ -90.395988, 47.056972 ], [ -90.396177, 47.056528 ], [ -90.396275, 47.056299 ], [ -90.400067, 47.047391 ], [ -90.400219, 47.047034 ], [ -90.400365, 47.046691 ], [ -90.400409, 47.046588 ], [ -90.400427, 47.046463 ], [ -90.403306, 47.026693 ], [ -90.403321, 47.026590 ], [ -90.403499, 47.025366 ], [ -90.403908, 47.024864 ], [ -90.405033, 47.023482 ], [ -90.409437, 47.018072 ], [ -90.411972, 47.014958 ], [ -90.412886, 47.013836 ], [ -90.413133, 47.013533 ], [ -90.413428, 47.013170 ], [ -90.425351, 47.007526 ], [ -90.427320, 47.006593 ], [ -90.428273, 47.006142 ], [ -90.428438, 47.006064 ], [ -90.429397, 47.005610 ], [ -90.429539, 47.005565 ], [ -90.448857, 46.999452 ], [ -90.453619, 46.997946 ], [ -90.457445, 46.996735 ], [ -90.464079, 46.994636 ], [ -90.464087, 46.994681 ], [ -90.465465, 47.002593 ], [ -90.465321, 47.002777 ], [ -90.457688, 47.012484 ], [ -90.457453, 47.012783 ], [ -90.457315, 47.013488 ], [ -90.457272, 47.013707 ], [ -90.456677, 47.016737 ] ] ], [ [ [ -90.636718, 46.861323 ], [ -90.636386, 46.861705 ], [ -90.634048, 46.864396 ], [ -90.622048, 46.872872 ], [ -90.616452, 46.874466 ], [ -90.602619, 46.872715 ], [ -90.602552, 46.872706 ], [ -90.601924, 46.872099 ], [ -90.593899, 46.864344 ], [ -90.588190, 46.858827 ], [ -90.587392, 46.858056 ], [ -90.587306, 46.858015 ], [ -90.570006, 46.849696 ], [ -90.569868, 46.849398 ], [ -90.568938, 46.847391 ], [ -90.568874, 46.847252 ], [ -90.569108, 46.847112 ], [ -90.570652, 46.846192 ], [ -90.578263, 46.841653 ], [ -90.578390, 46.841616 ], [ -90.582347, 46.840454 ], [ -90.584489, 46.839825 ], [ -90.585050, 46.839789 ], [ -90.589921, 46.839476 ], [ -90.601288, 46.838747 ], [ -90.603290, 46.838618 ], [ -90.609501, 46.838219 ], [ -90.610306, 46.838168 ], [ -90.613569, 46.837958 ], [ -90.613822, 46.837942 ], [ -90.614240, 46.837815 ], [ -90.625480, 46.834395 ], [ -90.658031, 46.824493 ], [ -90.673838, 46.819684 ], [ -90.676133, 46.818986 ], [ -90.683356, 46.813275 ], [ -90.685753, 46.805003 ], [ -90.670438, 46.799633 ], [ -90.670049, 46.799496 ], [ -90.665389, 46.799394 ], [ -90.655310, 46.799173 ], [ -90.654861, 46.798907 ], [ -90.654550, 46.798723 ], [ -90.652916, 46.797755 ], [ -90.652906, 46.797707 ], [ -90.652343, 46.795088 ], [ -90.652236, 46.794589 ], [ -90.652219, 46.794511 ], [ -90.652591, 46.794083 ], [ -90.653417, 46.793131 ], [ -90.654103, 46.792342 ], [ -90.655339, 46.790919 ], [ -90.655375, 46.790877 ], [ -90.655483, 46.790753 ], [ -90.655611, 46.790606 ], [ -90.655682, 46.790524 ], [ -90.656358, 46.789745 ], [ -90.657179, 46.788800 ], [ -90.658920, 46.788500 ], [ -90.660541, 46.788221 ], [ -90.661154, 46.788116 ], [ -90.661517, 46.788054 ], [ -90.663260, 46.787754 ], [ -90.679469, 46.784964 ], [ -90.687630, 46.783560 ], [ -90.688602, 46.783393 ], [ -90.689259, 46.783280 ], [ -90.691473, 46.782899 ], [ -90.692974, 46.782641 ], [ -90.696465, 46.782040 ], [ -90.696934, 46.782119 ], [ -90.706594, 46.783752 ], [ -90.716456, 46.785418 ], [ -90.723938, 46.781737 ], [ -90.734915, 46.772015 ], [ -90.738840, 46.768539 ], [ -90.739425, 46.768021 ], [ -90.758019, 46.757969 ], [ -90.762500, 46.755547 ], [ -90.763647, 46.754927 ], [ -90.765221, 46.754534 ], [ -90.766611, 46.754187 ], [ -90.771228, 46.753034 ], [ -90.774436, 46.753086 ], [ -90.787751, 46.753301 ], [ -90.787810, 46.753302 ], [ -90.788304, 46.753310 ], [ -90.788515, 46.753313 ], [ -90.788430, 46.753619 ], [ -90.788285, 46.754145 ], [ -90.787554, 46.756786 ], [ -90.785415, 46.764520 ], [ -90.783086, 46.772939 ], [ -90.788926, 46.779191 ], [ -90.789243, 46.779529 ], [ -90.790965, 46.781373 ], [ -90.790992, 46.781534 ], [ -90.791085, 46.782097 ], [ -90.791358, 46.783752 ], [ -90.791392, 46.783955 ], [ -90.791517, 46.784713 ], [ -90.791562, 46.784983 ], [ -90.790231, 46.786103 ], [ -90.781682, 46.788835 ], [ -90.759119, 46.796044 ], [ -90.758586, 46.796214 ], [ -90.745720, 46.798228 ], [ -90.740603, 46.799029 ], [ -90.736609, 46.799654 ], [ -90.733231, 46.800183 ], [ -90.733001, 46.800219 ], [ -90.732823, 46.800385 ], [ -90.729581, 46.803395 ], [ -90.728546, 46.804356 ], [ -90.728384, 46.805707 ], [ -90.727952, 46.809319 ], [ -90.727818, 46.810434 ], [ -90.720932, 46.815897 ], [ -90.712381, 46.820743 ], [ -90.704619, 46.823508 ], [ -90.694496, 46.827114 ], [ -90.682954, 46.831225 ], [ -90.675364, 46.833929 ], [ -90.672908, 46.835202 ], [ -90.656946, 46.843476 ], [ -90.656109, 46.844108 ], [ -90.655873, 46.844286 ], [ -90.655691, 46.844424 ], [ -90.654497, 46.845325 ], [ -90.654472, 46.845344 ], [ -90.651804, 46.847359 ], [ -90.651231, 46.847792 ], [ -90.650914, 46.848031 ], [ -90.647486, 46.850620 ], [ -90.646982, 46.851001 ], [ -90.643218, 46.853844 ], [ -90.637885, 46.859981 ], [ -90.637091, 46.860895 ], [ -90.636718, 46.861323 ] ] ], [ [ [ -90.579568, 46.918230 ], [ -90.592933, 46.915558 ], [ -90.623547, 46.909438 ], [ -90.624635, 46.909221 ], [ -90.625685, 46.909011 ], [ -90.637124, 46.906724 ], [ -90.644120, 46.908373 ], [ -90.644144, 46.908379 ], [ -90.644218, 46.908455 ], [ -90.654796, 46.919249 ], [ -90.654805, 46.919259 ], [ -90.654797, 46.919276 ], [ -90.651834, 46.925267 ], [ -90.651043, 46.926074 ], [ -90.646351, 46.930860 ], [ -90.645340, 46.931893 ], [ -90.644790, 46.932453 ], [ -90.643966, 46.933294 ], [ -90.643328, 46.933944 ], [ -90.634507, 46.942944 ], [ -90.633915, 46.943113 ], [ -90.601876, 46.952251 ], [ -90.601153, 46.952457 ], [ -90.572383, 46.958835 ], [ -90.530597, 46.968099 ], [ -90.528804, 46.968497 ], [ -90.528182, 46.968396 ], [ -90.524874, 46.967860 ], [ -90.523298, 46.967604 ], [ -90.521791, 46.966804 ], [ -90.514782, 46.963084 ], [ -90.514616, 46.962996 ], [ -90.513328, 46.962312 ], [ -90.512884, 46.962076 ], [ -90.512211, 46.961719 ], [ -90.511623, 46.961407 ], [ -90.509880, 46.959108 ], [ -90.509372, 46.958438 ], [ -90.508157, 46.956836 ], [ -90.511124, 46.952885 ], [ -90.524018, 46.935714 ], [ -90.524056, 46.935664 ], [ -90.532652, 46.932489 ], [ -90.535368, 46.931486 ], [ -90.539947, 46.927850 ], [ -90.543583, 46.923002 ], [ -90.543852, 46.918289 ], [ -90.545105, 46.917287 ], [ -90.545872, 46.916673 ], [ -90.549104, 46.915461 ], [ -90.550371, 46.915829 ], [ -90.553280, 46.916674 ], [ -90.557319, 46.918693 ], [ -90.569169, 46.920309 ], [ -90.579568, 46.918230 ] ] ], [ [ [ -87.500105, 45.061117 ], [ -87.498964, 45.061231 ], [ -87.497254, 45.061278 ], [ -87.496415, 45.061072 ], [ -87.495479, 45.060661 ], [ -87.494543, 45.060044 ], [ -87.493381, 45.059107 ], [ -87.492864, 45.058376 ], [ -87.492850, 45.058325 ], [ -87.492702, 45.057805 ], [ -87.492691, 45.057799 ], [ -87.492573, 45.057736 ], [ -87.492563, 45.057653 ], [ -87.492540, 45.057462 ], [ -87.492516, 45.057419 ], [ -87.492411, 45.057233 ], [ -87.492314, 45.056936 ], [ -87.492023, 45.056502 ], [ -87.491765, 45.056273 ], [ -87.491636, 45.056227 ], [ -87.491507, 45.056090 ], [ -87.491345, 45.056022 ], [ -87.490216, 45.055222 ], [ -87.490151, 45.055039 ], [ -87.490189, 45.055017 ], [ -87.490312, 45.054948 ], [ -87.490925, 45.055039 ], [ -87.492668, 45.055792 ], [ -87.494475, 45.056523 ], [ -87.498379, 45.057733 ], [ -87.498670, 45.057779 ], [ -87.498863, 45.057847 ], [ -87.500105, 45.058167 ], [ -87.501572, 45.058602 ], [ -87.504281, 45.059198 ], [ -87.504967, 45.059287 ], [ -87.506055, 45.059428 ], [ -87.506086, 45.059461 ], [ -87.506184, 45.059565 ], [ -87.506109, 45.059644 ], [ -87.506054, 45.059702 ], [ -87.504488, 45.060024 ], [ -87.504280, 45.060067 ], [ -87.503602, 45.060272 ], [ -87.502440, 45.060706 ], [ -87.501802, 45.060841 ], [ -87.500603, 45.061094 ], [ -87.500105, 45.061117 ] ] ], [ [ [ -86.945964, 45.407673 ], [ -86.943041, 45.415250 ], [ -86.942901, 45.415392 ], [ -86.941237, 45.417075 ], [ -86.937393, 45.420966 ], [ -86.936224, 45.421035 ], [ -86.934724, 45.421123 ], [ -86.934276, 45.421149 ], [ -86.934091, 45.420972 ], [ -86.930511, 45.417536 ], [ -86.929028, 45.413770 ], [ -86.928246, 45.411784 ], [ -86.928045, 45.411273 ], [ -86.927768, 45.411183 ], [ -86.917686, 45.407890 ], [ -86.914004, 45.408052 ], [ -86.909743, 45.408239 ], [ -86.902739, 45.408547 ], [ -86.898049, 45.408753 ], [ -86.892893, 45.408980 ], [ -86.883364, 45.412076 ], [ -86.880629, 45.412965 ], [ -86.877502, 45.413981 ], [ -86.865002, 45.412489 ], [ -86.862174, 45.412151 ], [ -86.861472, 45.412067 ], [ -86.861317, 45.411946 ], [ -86.859922, 45.410853 ], [ -86.855993, 45.407777 ], [ -86.853145, 45.405547 ], [ -86.853082, 45.405562 ], [ -86.830353, 45.410852 ], [ -86.830331, 45.410955 ], [ -86.829741, 45.413705 ], [ -86.829352, 45.415516 ], [ -86.829143, 45.416490 ], [ -86.829905, 45.420623 ], [ -86.830123, 45.421805 ], [ -86.830175, 45.422092 ], [ -86.830900, 45.426023 ], [ -86.830755, 45.426186 ], [ -86.828731, 45.428461 ], [ -86.828661, 45.428539 ], [ -86.828071, 45.428459 ], [ -86.821770, 45.427602 ], [ -86.817069, 45.426963 ], [ -86.816741, 45.426760 ], [ -86.815510, 45.425998 ], [ -86.810055, 45.422619 ], [ -86.809910, 45.422283 ], [ -86.805978, 45.413159 ], [ -86.805868, 45.412903 ], [ -86.805843, 45.412592 ], [ -86.805767, 45.411661 ], [ -86.805652, 45.410247 ], [ -86.805415, 45.407324 ], [ -86.808303, 45.406067 ], [ -86.808658, 45.406143 ], [ -86.814956, 45.407483 ], [ -86.815881, 45.407680 ], [ -86.817148, 45.407950 ], [ -86.818073, 45.408147 ], [ -86.819540, 45.407679 ], [ -86.822083, 45.406868 ], [ -86.824383, 45.406135 ], [ -86.824730, 45.405798 ], [ -86.837482, 45.393432 ], [ -86.841432, 45.389601 ], [ -86.853103, 45.370861 ], [ -86.853182, 45.370816 ], [ -86.857308, 45.368460 ], [ -86.858384, 45.367846 ], [ -86.863367, 45.365000 ], [ -86.863563, 45.364888 ], [ -86.863600, 45.364783 ], [ -86.863694, 45.364518 ], [ -86.863719, 45.364446 ], [ -86.864314, 45.362764 ], [ -86.867743, 45.353065 ], [ -86.867710, 45.352890 ], [ -86.866244, 45.344992 ], [ -86.866126, 45.344356 ], [ -86.865528, 45.341136 ], [ -86.865499, 45.340981 ], [ -86.865634, 45.340686 ], [ -86.866054, 45.339765 ], [ -86.869031, 45.333244 ], [ -86.869041, 45.333223 ], [ -86.869510, 45.333041 ], [ -86.872296, 45.331962 ], [ -86.874685, 45.331037 ], [ -86.874761, 45.331008 ], [ -86.875117, 45.330870 ], [ -86.879361, 45.331335 ], [ -86.880572, 45.331467 ], [ -86.887802, 45.332259 ], [ -86.895055, 45.329035 ], [ -86.899488, 45.322588 ], [ -86.896667, 45.307275 ], [ -86.896922, 45.298521 ], [ -86.896928, 45.298300 ], [ -86.899891, 45.295185 ], [ -86.900636, 45.295431 ], [ -86.901602, 45.295750 ], [ -86.904362, 45.296662 ], [ -86.904898, 45.296839 ], [ -86.913995, 45.312110 ], [ -86.925681, 45.324200 ], [ -86.937368, 45.333065 ], [ -86.940715, 45.333762 ], [ -86.941070, 45.333836 ], [ -86.946796, 45.335027 ], [ -86.946943, 45.335058 ], [ -86.948087, 45.335296 ], [ -86.951550, 45.338298 ], [ -86.954990, 45.341280 ], [ -86.955456, 45.341684 ], [ -86.955577, 45.341788 ], [ -86.955691, 45.341888 ], [ -86.956054, 45.342202 ], [ -86.956129, 45.342267 ], [ -86.956140, 45.343785 ], [ -86.956192, 45.351179 ], [ -86.956198, 45.352006 ], [ -86.954435, 45.353706 ], [ -86.953389, 45.354715 ], [ -86.953360, 45.354720 ], [ -86.948272, 45.355682 ], [ -86.946297, 45.358690 ], [ -86.946475, 45.359826 ], [ -86.946503, 45.360004 ], [ -86.946791, 45.361845 ], [ -86.947142, 45.364085 ], [ -86.947510, 45.366434 ], [ -86.947604, 45.366645 ], [ -86.947684, 45.366825 ], [ -86.948731, 45.369178 ], [ -86.948743, 45.369205 ], [ -86.948803, 45.369338 ], [ -86.954970, 45.383194 ], [ -86.955204, 45.383721 ], [ -86.954329, 45.385989 ], [ -86.953773, 45.387430 ], [ -86.951866, 45.392373 ], [ -86.951176, 45.394162 ], [ -86.947346, 45.404090 ], [ -86.947074, 45.404796 ], [ -86.946837, 45.405410 ], [ -86.945964, 45.407673 ] ] ], [ [ [ -87.762620, 44.965796 ], [ -87.762700, 44.965786 ], [ -87.762846, 44.965768 ], [ -87.766115, 44.965351 ], [ -87.766872, 44.965254 ], [ -87.781298, 44.961738 ], [ -87.781464, 44.961697 ], [ -87.788987, 44.959863 ], [ -87.789934, 44.959633 ], [ -87.791372, 44.959282 ], [ -87.791987, 44.959132 ], [ -87.792325, 44.959050 ], [ -87.812594, 44.954109 ], [ -87.812989, 44.954013 ], [ -87.813276, 44.953885 ], [ -87.813866, 44.953623 ], [ -87.815134, 44.953060 ], [ -87.816151, 44.952608 ], [ -87.817285, 44.952104 ], [ -87.817551, 44.951986 ], [ -87.817713, 44.951914 ], [ -87.817912, 44.951826 ], [ -87.818113, 44.951736 ], [ -87.819313, 44.951203 ], [ -87.819369, 44.951178 ], [ -87.819525, 44.951109 ], [ -87.820281, 44.950358 ], [ -87.820848, 44.949793 ], [ -87.821050, 44.949593 ], [ -87.821485, 44.949161 ], [ -87.821983, 44.948665 ], [ -87.822192, 44.948457 ], [ -87.837647, 44.933091 ], [ -87.839028, 44.931718 ], [ -87.843433, 44.924355 ], [ -87.844299, 44.918524 ], [ -87.842844, 44.912586 ], [ -87.842719, 44.912077 ], [ -87.842640, 44.911916 ], [ -87.842375, 44.911371 ], [ -87.840382, 44.907289 ], [ -87.839561, 44.905607 ], [ -87.837017, 44.902509 ], [ -87.836743, 44.902177 ], [ -87.836082, 44.901371 ], [ -87.834275, 44.899172 ], [ -87.833731, 44.898510 ], [ -87.833521, 44.898254 ], [ -87.832137, 44.896569 ], [ -87.827751, 44.891229 ], [ -87.832764, 44.880939 ], [ -87.835497, 44.877544 ], [ -87.836916, 44.875780 ], [ -87.838359, 44.873987 ], [ -87.847616, 44.870692 ], [ -87.848324, 44.870440 ], [ -87.849140, 44.869420 ], [ -87.852789, 44.864860 ], [ -87.854184, 44.859633 ], [ -87.854681, 44.857771 ], [ -87.854938, 44.857386 ], [ -87.855962, 44.855854 ], [ -87.857121, 44.854120 ], [ -87.857469, 44.853599 ], [ -87.865898, 44.840988 ], [ -87.866237, 44.840481 ], [ -87.871679, 44.839816 ], [ -87.878218, 44.839016 ], [ -87.885709, 44.835208 ], [ -87.892570, 44.831720 ], [ -87.895812, 44.830072 ], [ -87.897931, 44.828995 ], [ -87.899787, 44.828051 ], [ -87.901137, 44.827365 ], [ -87.901814, 44.825616 ], [ -87.902166, 44.824708 ], [ -87.903395, 44.821534 ], [ -87.903844, 44.820376 ], [ -87.904281, 44.819246 ], [ -87.904484, 44.818723 ], [ -87.905444, 44.816997 ], [ -87.906582, 44.814949 ], [ -87.911366, 44.806345 ], [ -87.918874, 44.792840 ], [ -87.923588, 44.784361 ], [ -87.925845, 44.780301 ], [ -87.926816, 44.778555 ], [ -87.941453, 44.756080 ], [ -87.951560, 44.753107 ], [ -87.956849, 44.749272 ], [ -87.964714, 44.743570 ], [ -87.972654, 44.733687 ], [ -87.983065, 44.720730 ], [ -87.983494, 44.720196 ], [ -87.983941, 44.717781 ], [ -87.983950, 44.717735 ], [ -87.984094, 44.716955 ], [ -87.984247, 44.716129 ], [ -87.984401, 44.715298 ], [ -87.986055, 44.706360 ], [ -87.986134, 44.705936 ], [ -87.987296, 44.699657 ], [ -87.987417, 44.699005 ], [ -87.988667, 44.692255 ], [ -87.989250, 44.689107 ], [ -87.989344, 44.688598 ], [ -87.989376, 44.688424 ], [ -87.989470, 44.687918 ], [ -87.989717, 44.686582 ], [ -87.989912, 44.677587 ], [ -87.990081, 44.669791 ], [ -87.990110, 44.668455 ], [ -87.998964, 44.665187 ], [ -88.000321, 44.664686 ], [ -88.002085, 44.664035 ], [ -88.002254, 44.663442 ], [ -88.002677, 44.661956 ], [ -88.003340, 44.659630 ], [ -88.007287, 44.645779 ], [ -88.009766, 44.637081 ], [ -88.009523, 44.631711 ], [ -88.009486, 44.630897 ], [ -88.009472, 44.630594 ], [ -88.009463, 44.630398 ], [ -88.008717, 44.628932 ], [ -88.007489, 44.626521 ], [ -88.007158, 44.625871 ], [ -88.007013, 44.625586 ], [ -88.006871, 44.625306 ], [ -88.006409, 44.624399 ], [ -88.001172, 44.614112 ], [ -87.998836, 44.609523 ], [ -87.998716, 44.609288 ], [ -88.001943, 44.603909 ], [ -88.012395, 44.602438 ], [ -88.014735, 44.596400 ], [ -88.015092, 44.595478 ], [ -88.016373, 44.592172 ], [ -88.016404, 44.592092 ], [ -88.019465, 44.588344 ], [ -88.022853, 44.584196 ], [ -88.027103, 44.578992 ], [ -88.028148, 44.578736 ], [ -88.034535, 44.577175 ], [ -88.036103, 44.576792 ], [ -88.036104, 44.576791 ], [ -88.039092, 44.574324 ], [ -88.039489, 44.573995 ], [ -88.041162, 44.572614 ], [ -88.041202, 44.572581 ], [ -88.041358, 44.571809 ], [ -88.041485, 44.571183 ], [ -88.041561, 44.570804 ], [ -88.041659, 44.570320 ], [ -88.041775, 44.569746 ], [ -88.042261, 44.567344 ], [ -88.042414, 44.566589 ], [ -88.037178, 44.562705 ], [ -88.020707, 44.550484 ], [ -88.016709, 44.547518 ], [ -88.005518, 44.539216 ], [ -88.000099, 44.537827 ], [ -87.999002, 44.537546 ], [ -87.998536, 44.537426 ], [ -87.990985, 44.535491 ], [ -87.990468, 44.535358 ], [ -87.986059, 44.534228 ], [ -87.982821, 44.533398 ], [ -87.977901, 44.532137 ], [ -87.970702, 44.530292 ], [ -87.943801, 44.529693 ], [ -87.939972, 44.531323 ], [ -87.935707, 44.533138 ], [ -87.929001, 44.535993 ], [ -87.924044, 44.540991 ], [ -87.917467, 44.547622 ], [ -87.917000, 44.548093 ], [ -87.915846, 44.549612 ], [ -87.901206, 44.568887 ], [ -87.901178, 44.568924 ], [ -87.901177, 44.568925 ], [ -87.900668, 44.570084 ], [ -87.899368, 44.573043 ], [ -87.898907, 44.574091 ], [ -87.898888, 44.574135 ], [ -87.899183, 44.574576 ], [ -87.900198, 44.576095 ], [ -87.900634, 44.576747 ], [ -87.901061, 44.577386 ], [ -87.901236, 44.577648 ], [ -87.903689, 44.581317 ], [ -87.902319, 44.583079 ], [ -87.901179, 44.584545 ], [ -87.896412, 44.586780 ], [ -87.894356, 44.587745 ], [ -87.891727, 44.588977 ], [ -87.891717, 44.588982 ], [ -87.890868, 44.589647 ], [ -87.887410, 44.592356 ], [ -87.867941, 44.607606 ], [ -87.866884, 44.608434 ], [ -87.842164, 44.618826 ], [ -87.837416, 44.620822 ], [ -87.836101, 44.621375 ], [ -87.830848, 44.623583 ], [ -87.829229, 44.624521 ], [ -87.823444, 44.627870 ], [ -87.820083, 44.629816 ], [ -87.809076, 44.636189 ], [ -87.808819, 44.636338 ], [ -87.808366, 44.636378 ], [ -87.788240, 44.638137 ], [ -87.775160, 44.639281 ], [ -87.765774, 44.642023 ], [ -87.762912, 44.644110 ], [ -87.762376, 44.644501 ], [ -87.756048, 44.649117 ], [ -87.756031, 44.649129 ], [ -87.750899, 44.656192 ], [ -87.749090, 44.664131 ], [ -87.748409, 44.667122 ], [ -87.736058, 44.677025 ], [ -87.733701, 44.678916 ], [ -87.729836, 44.682015 ], [ -87.719780, 44.693246 ], [ -87.718413, 44.707765 ], [ -87.718409, 44.707811 ], [ -87.718427, 44.707870 ], [ -87.720248, 44.713833 ], [ -87.720599, 44.714984 ], [ -87.721816, 44.718969 ], [ -87.721252, 44.722361 ], [ -87.721059, 44.723522 ], [ -87.720889, 44.724548 ], [ -87.720312, 44.725073 ], [ -87.714401, 44.730449 ], [ -87.705852, 44.738225 ], [ -87.705733, 44.738364 ], [ -87.704653, 44.739630 ], [ -87.703557, 44.740914 ], [ -87.701022, 44.743882 ], [ -87.700778, 44.744169 ], [ -87.700539, 44.744448 ], [ -87.698653, 44.746657 ], [ -87.698584, 44.746738 ], [ -87.698246, 44.747133 ], [ -87.698167, 44.747226 ], [ -87.688207, 44.758892 ], [ -87.687497, 44.759567 ], [ -87.679709, 44.766973 ], [ -87.678368, 44.768247 ], [ -87.677995, 44.768602 ], [ -87.662056, 44.783758 ], [ -87.647764, 44.797347 ], [ -87.646300, 44.798739 ], [ -87.645229, 44.800466 ], [ -87.644646, 44.801407 ], [ -87.644637, 44.801423 ], [ -87.644545, 44.801571 ], [ -87.637104, 44.813575 ], [ -87.635416, 44.815124 ], [ -87.635265, 44.815263 ], [ -87.634476, 44.815986 ], [ -87.634390, 44.816065 ], [ -87.634381, 44.816073 ], [ -87.634059, 44.816369 ], [ -87.633418, 44.816956 ], [ -87.632977, 44.817361 ], [ -87.632892, 44.817439 ], [ -87.632699, 44.817616 ], [ -87.622014, 44.827419 ], [ -87.616384, 44.832585 ], [ -87.616242, 44.832715 ], [ -87.611852, 44.836743 ], [ -87.611118, 44.837416 ], [ -87.610245, 44.838217 ], [ -87.610063, 44.838384 ], [ -87.610018, 44.838405 ], [ -87.609784, 44.838514 ], [ -87.581635, 44.851638 ], [ -87.581306, 44.851791 ], [ -87.573175, 44.853118 ], [ -87.570851, 44.852932 ], [ -87.560183, 44.852080 ], [ -87.550288, 44.851290 ], [ -87.550003, 44.851381 ], [ -87.534723, 44.856250 ], [ -87.530999, 44.857437 ], [ -87.530794, 44.857594 ], [ -87.515142, 44.869596 ], [ -87.514590, 44.869380 ], [ -87.513775, 44.869061 ], [ -87.513413, 44.868919 ], [ -87.512129, 44.868416 ], [ -87.504868, 44.865573 ], [ -87.504405, 44.865392 ], [ -87.504303, 44.865352 ], [ -87.502431, 44.864619 ], [ -87.501578, 44.864285 ], [ -87.499063, 44.864207 ], [ -87.478489, 44.863572 ], [ -87.472639, 44.867690 ], [ -87.456688, 44.878918 ], [ -87.441339, 44.889723 ], [ -87.437084, 44.892718 ], [ -87.433128, 44.892741 ], [ -87.433005, 44.892691 ], [ -87.428144, 44.890738 ], [ -87.421007, 44.887869 ], [ -87.420327, 44.887596 ], [ -87.419106, 44.885378 ], [ -87.419114, 44.885285 ], [ -87.419135, 44.885052 ], [ -87.419951, 44.875940 ], [ -87.419253, 44.874960 ], [ -87.410919, 44.863259 ], [ -87.410015, 44.861990 ], [ -87.408779, 44.861453 ], [ -87.405658, 44.860098 ], [ -87.405541, 44.860047 ], [ -87.384821, 44.865532 ], [ -87.384593, 44.869277 ], [ -87.383874, 44.881116 ], [ -87.383839, 44.881685 ], [ -87.383833, 44.881788 ], [ -87.383670, 44.884475 ], [ -87.383655, 44.884723 ], [ -87.383631, 44.885115 ], [ -87.385396, 44.889964 ], [ -87.386111, 44.890699 ], [ -87.386375, 44.890972 ], [ -87.386396, 44.890993 ], [ -87.386490, 44.891090 ], [ -87.390604, 44.895323 ], [ -87.390651, 44.895372 ], [ -87.390800, 44.895524 ], [ -87.391070, 44.895803 ], [ -87.391980, 44.896739 ], [ -87.392270, 44.897037 ], [ -87.393399, 44.898199 ], [ -87.396972, 44.899955 ], [ -87.397184, 44.900059 ], [ -87.397359, 44.900145 ], [ -87.400488, 44.901683 ], [ -87.401947, 44.902400 ], [ -87.406199, 44.904490 ], [ -87.405361, 44.909626 ], [ -87.405005, 44.911806 ], [ -87.398368, 44.925226 ], [ -87.393752, 44.933751 ], [ -87.393672, 44.933899 ], [ -87.393405, 44.934393 ], [ -87.393058, 44.934677 ], [ -87.389006, 44.937988 ], [ -87.387253, 44.939421 ], [ -87.385066, 44.942445 ], [ -87.384669, 44.942993 ], [ -87.382436, 44.946080 ], [ -87.374805, 44.956631 ], [ -87.373046, 44.960388 ], [ -87.372599, 44.961343 ], [ -87.372568, 44.961410 ], [ -87.371854, 44.962935 ], [ -87.370075, 44.966736 ], [ -87.363492, 44.980798 ], [ -87.360288, 44.987643 ], [ -87.351487, 44.997203 ], [ -87.345091, 45.004151 ], [ -87.336548, 45.013431 ], [ -87.336457, 45.013530 ], [ -87.322117, 45.034201 ], [ -87.322022, 45.034290 ], [ -87.315879, 45.040103 ], [ -87.307394, 45.048130 ], [ -87.303475, 45.051838 ], [ -87.303420, 45.051890 ], [ -87.303149, 45.052146 ], [ -87.302831, 45.052447 ], [ -87.302470, 45.052666 ], [ -87.300887, 45.053625 ], [ -87.300724, 45.053724 ], [ -87.300146, 45.054075 ], [ -87.284280, 45.063694 ], [ -87.284208, 45.063760 ], [ -87.269231, 45.077396 ], [ -87.268737, 45.077847 ], [ -87.268695, 45.077884 ], [ -87.264877, 45.081361 ], [ -87.260631, 45.092355 ], [ -87.260542, 45.092585 ], [ -87.260595, 45.106007 ], [ -87.257449, 45.121644 ], [ -87.254072, 45.126323 ], [ -87.250487, 45.131289 ], [ -87.240813, 45.137559 ], [ -87.240308, 45.137886 ], [ -87.242331, 45.146773 ], [ -87.242924, 45.149377 ], [ -87.238426, 45.166492 ], [ -87.238229, 45.167238 ], [ -87.238224, 45.167259 ], [ -87.238220, 45.167262 ], [ -87.231925, 45.172316 ], [ -87.231214, 45.172887 ], [ -87.224065, 45.174551 ], [ -87.222316, 45.174959 ], [ -87.221971, 45.175039 ], [ -87.221707, 45.174716 ], [ -87.220937, 45.173773 ], [ -87.214370, 45.165735 ], [ -87.213483, 45.165614 ], [ -87.207963, 45.164857 ], [ -87.200385, 45.163819 ], [ -87.195876, 45.163201 ], [ -87.195213, 45.163110 ], [ -87.175170, 45.173000 ], [ -87.175068, 45.173050 ], [ -87.173722, 45.174850 ], [ -87.171272, 45.178123 ], [ -87.171233, 45.178175 ], [ -87.170266, 45.179468 ], [ -87.170062, 45.179741 ], [ -87.168298, 45.182099 ], [ -87.168252, 45.182160 ], [ -87.167179, 45.183594 ], [ -87.163169, 45.185331 ], [ -87.147709, 45.190711 ], [ -87.147657, 45.190719 ], [ -87.142708, 45.191437 ], [ -87.133030, 45.192843 ], [ -87.132874, 45.192794 ], [ -87.129810, 45.191825 ], [ -87.128597, 45.191441 ], [ -87.124549, 45.190162 ], [ -87.123689, 45.189890 ], [ -87.119972, 45.191103 ], [ -87.119971, 45.191125 ], [ -87.119968, 45.191198 ], [ -87.119925, 45.192280 ], [ -87.119921, 45.192386 ], [ -87.119894, 45.193071 ], [ -87.119887, 45.193242 ], [ -87.119876, 45.193527 ], [ -87.119874, 45.193581 ], [ -87.119868, 45.193724 ], [ -87.119864, 45.193843 ], [ -87.119825, 45.194814 ], [ -87.119822, 45.194908 ], [ -87.119784, 45.195866 ], [ -87.119780, 45.195965 ], [ -87.119768, 45.196271 ], [ -87.119534, 45.202184 ], [ -87.119522, 45.202488 ], [ -87.119511, 45.202754 ], [ -87.119413, 45.205237 ], [ -87.119405, 45.205440 ], [ -87.119450, 45.205529 ], [ -87.119654, 45.205930 ], [ -87.121541, 45.209649 ], [ -87.121566, 45.209698 ], [ -87.121609, 45.209783 ], [ -87.122098, 45.215121 ], [ -87.122194, 45.216168 ], [ -87.122226, 45.216519 ], [ -87.122248, 45.216764 ], [ -87.122364, 45.218023 ], [ -87.122708, 45.221786 ], [ -87.122819, 45.222997 ], [ -87.121667, 45.226337 ], [ -87.121288, 45.227438 ], [ -87.121266, 45.227500 ], [ -87.117391, 45.238740 ], [ -87.116456, 45.241450 ], [ -87.116432, 45.241520 ], [ -87.109541, 45.255397 ], [ -87.109014, 45.256458 ], [ -87.108743, 45.257003 ], [ -87.108430, 45.257093 ], [ -87.101681, 45.259027 ], [ -87.078316, 45.265723 ], [ -87.071035, 45.280355 ], [ -87.070845, 45.280532 ], [ -87.057627, 45.292838 ], [ -87.053417, 45.287901 ], [ -87.052927, 45.287326 ], [ -87.052872, 45.287262 ], [ -87.051979, 45.286215 ], [ -87.051700, 45.285888 ], [ -87.050796, 45.285758 ], [ -87.048745, 45.285464 ], [ -87.043895, 45.284767 ], [ -87.043724, 45.284820 ], [ -87.043497, 45.284890 ], [ -87.043130, 45.285003 ], [ -87.041463, 45.285518 ], [ -87.034206, 45.287758 ], [ -87.034077, 45.287844 ], [ -87.021088, 45.296541 ], [ -87.017036, 45.299254 ], [ -87.015797, 45.299190 ], [ -86.994112, 45.298061 ], [ -86.993528, 45.297915 ], [ -86.993201, 45.297833 ], [ -86.984223, 45.295585 ], [ -86.983880, 45.295499 ], [ -86.983355, 45.295368 ], [ -86.983227, 45.295260 ], [ -86.980058, 45.292598 ], [ -86.977780, 45.290684 ], [ -86.977714, 45.290575 ], [ -86.970355, 45.278455 ], [ -86.972786, 45.274591 ], [ -86.973227, 45.273890 ], [ -86.974346, 45.272113 ], [ -86.974528, 45.271823 ], [ -86.974622, 45.271752 ], [ -86.977355, 45.269687 ], [ -86.983597, 45.264971 ], [ -86.984398, 45.264366 ], [ -86.984495, 45.263409 ], [ -86.984938, 45.259036 ], [ -86.984975, 45.258674 ], [ -86.984172, 45.255346 ], [ -86.983066, 45.250764 ], [ -86.982669, 45.249117 ], [ -86.982393, 45.248980 ], [ -86.976711, 45.246146 ], [ -86.973287, 45.246381 ], [ -86.973022, 45.246399 ], [ -86.973453, 45.244966 ], [ -86.973460, 45.244944 ], [ -86.973483, 45.244867 ], [ -86.973651, 45.244308 ], [ -86.974086, 45.242864 ], [ -86.978697, 45.227538 ], [ -86.978759, 45.227333 ], [ -86.981080, 45.223646 ], [ -86.981956, 45.222254 ], [ -86.983001, 45.220593 ], [ -86.983708, 45.219470 ], [ -86.985973, 45.215872 ], [ -86.988075, 45.215360 ], [ -86.995804, 45.213478 ], [ -86.997316, 45.213110 ], [ -87.000112, 45.212429 ], [ -87.002806, 45.211773 ], [ -87.005243, 45.213607 ], [ -87.005359, 45.213694 ], [ -87.005468, 45.214114 ], [ -87.007540, 45.222127 ], [ -87.007583, 45.222127 ], [ -87.032521, 45.222274 ], [ -87.032546, 45.222274 ], [ -87.032576, 45.222235 ], [ -87.034524, 45.219734 ], [ -87.040909, 45.211535 ], [ -87.040924, 45.211421 ], [ -87.041063, 45.210375 ], [ -87.041075, 45.210283 ], [ -87.041106, 45.210052 ], [ -87.045899, 45.173902 ], [ -87.045883, 45.173543 ], [ -87.045701, 45.169351 ], [ -87.045687, 45.169016 ], [ -87.045681, 45.168889 ], [ -87.045660, 45.168403 ], [ -87.045480, 45.164271 ], [ -87.045242, 45.158798 ], [ -87.045225, 45.158401 ], [ -87.044176, 45.157630 ], [ -87.041145, 45.155404 ], [ -87.038479, 45.153445 ], [ -87.036716, 45.152150 ], [ -87.034083, 45.150216 ], [ -87.030225, 45.147382 ], [ -87.029164, 45.146603 ], [ -87.028980, 45.146467 ], [ -87.028847, 45.146370 ], [ -87.028957, 45.146250 ], [ -87.030105, 45.145009 ], [ -87.030126, 45.144986 ], [ -87.031167, 45.143860 ], [ -87.031307, 45.143709 ], [ -87.032194, 45.142748 ], [ -87.032344, 45.142586 ], [ -87.032461, 45.142460 ], [ -87.032920, 45.141963 ], [ -87.033114, 45.141753 ], [ -87.033117, 45.141752 ], [ -87.033546, 45.141522 ], [ -87.033550, 45.141519 ], [ -87.034621, 45.140946 ], [ -87.034667, 45.140921 ], [ -87.035465, 45.140494 ], [ -87.035838, 45.140294 ], [ -87.040175, 45.137972 ], [ -87.041564, 45.137228 ], [ -87.042114, 45.136933 ], [ -87.042286, 45.136841 ], [ -87.045748, 45.134987 ], [ -87.054282, 45.120074 ], [ -87.054342, 45.119968 ], [ -87.051049, 45.116172 ], [ -87.050750, 45.115111 ], [ -87.049346, 45.110122 ], [ -87.049268, 45.109845 ], [ -87.049231, 45.109712 ], [ -87.048951, 45.108718 ], [ -87.048911, 45.107665 ], [ -87.048406, 45.094259 ], [ -87.048346, 45.092647 ], [ -87.048213, 45.089124 ], [ -87.048359, 45.089098 ], [ -87.050780, 45.088663 ], [ -87.057415, 45.087472 ], [ -87.057444, 45.087467 ], [ -87.058259, 45.086304 ], [ -87.061966, 45.081015 ], [ -87.063129, 45.079356 ], [ -87.063157, 45.079316 ], [ -87.063376, 45.079202 ], [ -87.064864, 45.078427 ], [ -87.079552, 45.070783 ], [ -87.079555, 45.070770 ], [ -87.080271, 45.067154 ], [ -87.080755, 45.064710 ], [ -87.081866, 45.059103 ], [ -87.082419, 45.058879 ], [ -87.086351, 45.057287 ], [ -87.090849, 45.055465 ], [ -87.091639, 45.055145 ], [ -87.091761, 45.055158 ], [ -87.092177, 45.055203 ], [ -87.096387, 45.055654 ], [ -87.097479, 45.055771 ], [ -87.121156, 45.058311 ], [ -87.124701, 45.052936 ], [ -87.124722, 45.050833 ], [ -87.124727, 45.050344 ], [ -87.124737, 45.049268 ], [ -87.124744, 45.048608 ], [ -87.124788, 45.044141 ], [ -87.124797, 45.043262 ], [ -87.124808, 45.042167 ], [ -87.132344, 45.026862 ], [ -87.134354, 45.022780 ], [ -87.138024, 45.015327 ], [ -87.139384, 45.012565 ], [ -87.141048, 45.012175 ], [ -87.154084, 45.009117 ], [ -87.163477, 45.004913 ], [ -87.163529, 45.004890 ], [ -87.163561, 45.004848 ], [ -87.167474, 44.999736 ], [ -87.167970, 44.999088 ], [ -87.169494, 44.997096 ], [ -87.169676, 44.996860 ], [ -87.169694, 44.996836 ], [ -87.181428, 44.981505 ], [ -87.181901, 44.980887 ], [ -87.182922, 44.979221 ], [ -87.187585, 44.971606 ], [ -87.189134, 44.969078 ], [ -87.189407, 44.968632 ], [ -87.189402, 44.968524 ], [ -87.189383, 44.968164 ], [ -87.188582, 44.952193 ], [ -87.188399, 44.948560 ], [ -87.188375, 44.948077 ], [ -87.188074, 44.947886 ], [ -87.179974, 44.942753 ], [ -87.175240, 44.939753 ], [ -87.171700, 44.931476 ], [ -87.174920, 44.927749 ], [ -87.182421, 44.926297 ], [ -87.185858, 44.925632 ], [ -87.186732, 44.925463 ], [ -87.187984, 44.924845 ], [ -87.204238, 44.916819 ], [ -87.215808, 44.906744 ], [ -87.215977, 44.906597 ], [ -87.216059, 44.906009 ], [ -87.216074, 44.905900 ], [ -87.216146, 44.905379 ], [ -87.217171, 44.898013 ], [ -87.217195, 44.897839 ], [ -87.217149, 44.897789 ], [ -87.216710, 44.897309 ], [ -87.212587, 44.892809 ], [ -87.209265, 44.889182 ], [ -87.206285, 44.885928 ], [ -87.206184, 44.885329 ], [ -87.204815, 44.877199 ], [ -87.204809, 44.877159 ], [ -87.204545, 44.875593 ], [ -87.204904, 44.875429 ], [ -87.211398, 44.872461 ], [ -87.224891, 44.866295 ], [ -87.246171, 44.856571 ], [ -87.267061, 44.847025 ], [ -87.267441, 44.846851 ], [ -87.267564, 44.846655 ], [ -87.274769, 44.835187 ], [ -87.276030, 44.833180 ], [ -87.282561, 44.814729 ], [ -87.294869, 44.809131 ], [ -87.304824, 44.804603 ], [ -87.307482, 44.801377 ], [ -87.313363, 44.794237 ], [ -87.313692, 44.793838 ], [ -87.313751, 44.793766 ], [ -87.313880, 44.793595 ], [ -87.314247, 44.793109 ], [ -87.315813, 44.791034 ], [ -87.320397, 44.784963 ], [ -87.319796, 44.779170 ], [ -87.319169, 44.773135 ], [ -87.319030, 44.771794 ], [ -87.319013, 44.771632 ], [ -87.318982, 44.771335 ], [ -87.319903, 44.769672 ], [ -87.320855, 44.767953 ], [ -87.337584, 44.737751 ], [ -87.339155, 44.732839 ], [ -87.339904, 44.730498 ], [ -87.341226, 44.726364 ], [ -87.341491, 44.725535 ], [ -87.343508, 44.719228 ], [ -87.348082, 44.711526 ], [ -87.349559, 44.709039 ], [ -87.353789, 44.701915 ], [ -87.354172, 44.701445 ], [ -87.354249, 44.701350 ], [ -87.361150, 44.692876 ], [ -87.367992, 44.684474 ], [ -87.368263, 44.684141 ], [ -87.373228, 44.675593 ], [ -87.378490, 44.666534 ], [ -87.386840, 44.652157 ], [ -87.393521, 44.640655 ], [ -87.401629, 44.631191 ], [ -87.403724, 44.628974 ], [ -87.405410, 44.627191 ], [ -87.418028, 44.620870 ], [ -87.435766, 44.606472 ], [ -87.437493, 44.605071 ], [ -87.437751, 44.604559 ], [ -87.446963, 44.586274 ], [ -87.467089, 44.553557 ], [ -87.467214, 44.553355 ], [ -87.467398, 44.553055 ], [ -87.468093, 44.551925 ], [ -87.472934, 44.539338 ], [ -87.481884, 44.516065 ], [ -87.483696, 44.511354 ], [ -87.483873, 44.505742 ], [ -87.483914, 44.504425 ], [ -87.484042, 44.503856 ], [ -87.486822, 44.491477 ], [ -87.490024, 44.477224 ], [ -87.492333, 44.472804 ], [ -87.494678, 44.468314 ], [ -87.495176, 44.467360 ], [ -87.495252, 44.467215 ], [ -87.498662, 44.460686 ], [ -87.498860, 44.459737 ], [ -87.498872, 44.459680 ], [ -87.498934, 44.459384 ], [ -87.499349, 44.457395 ], [ -87.499674, 44.455837 ], [ -87.499719, 44.455625 ], [ -87.502309, 44.443219 ], [ -87.506362, 44.423804 ], [ -87.507651, 44.421418 ], [ -87.511387, 44.414502 ], [ -87.511635, 44.414043 ], [ -87.512311, 44.411941 ], [ -87.512886, 44.410153 ], [ -87.515482, 44.402077 ], [ -87.517965, 44.394356 ], [ -87.517881, 44.390082 ], [ -87.517597, 44.375696 ], [ -87.517740, 44.375357 ], [ -87.518094, 44.374519 ], [ -87.519106, 44.372122 ], [ -87.521047, 44.367526 ], [ -87.521663, 44.366719 ], [ -87.533583, 44.351111 ], [ -87.533606, 44.351052 ], [ -87.541517, 44.331123 ], [ -87.542950, 44.327513 ], [ -87.545382, 44.321385 ], [ -87.544725, 44.307068 ], [ -87.544716, 44.306864 ], [ -87.544675, 44.306707 ], [ -87.541382, 44.294018 ], [ -87.541265, 44.293567 ], [ -87.541156, 44.293147 ], [ -87.541155, 44.293143 ], [ -87.541053, 44.292968 ], [ -87.526466, 44.268016 ], [ -87.526391, 44.267888 ], [ -87.526226, 44.267605 ], [ -87.525824, 44.266918 ], [ -87.525797, 44.266871 ], [ -87.525703, 44.266711 ], [ -87.525643, 44.266609 ], [ -87.525485, 44.266338 ], [ -87.525455, 44.266285 ], [ -87.525294, 44.266010 ], [ -87.525211, 44.265869 ], [ -87.524691, 44.264979 ], [ -87.524459, 44.264583 ], [ -87.524193, 44.264128 ], [ -87.523179, 44.262393 ], [ -87.522840, 44.261813 ], [ -87.522557, 44.261329 ], [ -87.521862, 44.260140 ], [ -87.521755, 44.259957 ], [ -87.521330, 44.258993 ], [ -87.521318, 44.258965 ], [ -87.515406, 44.245537 ], [ -87.515399, 44.245522 ], [ -87.515314, 44.245328 ], [ -87.508457, 44.229755 ], [ -87.508419, 44.229669 ], [ -87.508412, 44.229546 ], [ -87.507419, 44.210803 ], [ -87.512903, 44.192808 ], [ -87.519660, 44.179870 ], [ -87.539940, 44.159690 ], [ -87.550076, 44.152933 ], [ -87.563181, 44.144195 ], [ -87.563551, 44.144072 ], [ -87.567045, 44.142914 ], [ -87.567817, 44.142658 ], [ -87.570533, 44.141757 ], [ -87.596680, 44.133088 ], [ -87.597910, 44.132680 ], [ -87.599055, 44.132301 ], [ -87.600882, 44.131695 ], [ -87.603572, 44.130390 ], [ -87.621082, 44.121895 ], [ -87.645800, 44.105222 ], [ -87.646583, 44.104694 ], [ -87.646719, 44.104335 ], [ -87.647551, 44.102128 ], [ -87.647603, 44.101991 ], [ -87.651507, 44.091639 ], [ -87.654935, 44.082552 ], [ -87.655183, 44.081894 ], [ -87.653483, 44.067194 ], [ -87.653691, 44.065961 ], [ -87.656062, 44.051919 ], [ -87.656083, 44.051794 ], [ -87.671316, 44.037350 ], [ -87.683361, 44.020139 ], [ -87.686389, 44.012520 ], [ -87.691479, 43.999710 ], [ -87.695053, 43.990715 ], [ -87.695503, 43.989582 ], [ -87.695511, 43.989524 ], [ -87.698920, 43.965936 ], [ -87.699029, 43.965734 ], [ -87.700125, 43.963712 ], [ -87.700321, 43.963351 ], [ -87.702707, 43.958946 ], [ -87.702719, 43.958926 ], [ -87.703951, 43.956651 ], [ -87.704679, 43.955872 ], [ -87.706656, 43.953753 ], [ -87.709463, 43.950747 ], [ -87.716037, 43.943705 ], [ -87.718170, 43.939498 ], [ -87.719041, 43.937781 ], [ -87.719041, 43.937780 ], [ -87.719194, 43.937100 ], [ -87.720121, 43.932958 ], [ -87.720382, 43.931794 ], [ -87.720734, 43.930224 ], [ -87.721268, 43.927840 ], [ -87.722100, 43.924128 ], [ -87.723716, 43.916915 ], [ -87.724244, 43.914557 ], [ -87.726766, 43.903297 ], [ -87.726803, 43.903133 ], [ -87.726841, 43.903040 ], [ -87.728542, 43.898920 ], [ -87.728885, 43.898090 ], [ -87.730630, 43.893862 ], [ -87.730645, 43.893825 ], [ -87.731322, 43.892184 ], [ -87.733735, 43.886340 ], [ -87.734457, 43.884590 ], [ -87.735436, 43.882219 ], [ -87.736178, 43.880421 ], [ -87.736017, 43.873721 ], [ -87.734881, 43.870430 ], [ -87.728698, 43.852524 ], [ -87.728728, 43.851833 ], [ -87.729217, 43.840582 ], [ -87.729600, 43.831782 ], [ -87.727686, 43.818989 ], [ -87.726772, 43.812885 ], [ -87.726408, 43.810454 ], [ -87.726407, 43.810445 ], [ -87.726405, 43.810442 ], [ -87.700251, 43.767350 ], [ -87.700245, 43.767129 ], [ -87.700090, 43.761590 ], [ -87.700085, 43.761395 ], [ -87.702985, 43.749695 ], [ -87.703047, 43.749565 ], [ -87.704630, 43.746256 ], [ -87.705185, 43.745095 ], [ -87.708167, 43.742979 ], [ -87.708285, 43.742895 ], [ -87.708321, 43.742737 ], [ -87.709885, 43.735795 ], [ -87.708185, 43.722895 ], [ -87.707923, 43.722064 ], [ -87.703144, 43.706901 ], [ -87.702985, 43.706395 ], [ -87.702685, 43.687596 ], [ -87.703671, 43.685339 ], [ -87.706204, 43.679542 ], [ -87.706242, 43.679488 ], [ -87.726460, 43.650462 ], [ -87.733622, 43.640181 ], [ -87.734312, 43.639190 ], [ -87.735065, 43.638217 ], [ -87.735489, 43.637668 ], [ -87.735972, 43.637044 ], [ -87.736146, 43.636819 ], [ -87.737859, 43.634604 ], [ -87.738638, 43.633597 ], [ -87.742485, 43.628622 ], [ -87.742522, 43.628574 ], [ -87.780175, 43.579889 ], [ -87.781255, 43.578493 ], [ -87.782271, 43.576726 ], [ -87.789105, 43.564844 ], [ -87.790135, 43.563054 ], [ -87.790277, 43.562376 ], [ -87.793075, 43.548990 ], [ -87.794321, 43.543034 ], [ -87.797608, 43.527310 ], [ -87.797336, 43.510623 ], [ -87.793239, 43.492783 ], [ -87.807799, 43.461136 ], [ -87.827319, 43.434849 ], [ -87.855608, 43.405441 ], [ -87.865048, 43.393570 ], [ -87.867504, 43.389158 ], [ -87.869099, 43.386295 ], [ -87.872504, 43.380178 ], [ -87.877448, 43.369235 ], [ -87.882392, 43.352099 ], [ -87.888122, 43.314731 ], [ -87.888312, 43.313489 ], [ -87.888314, 43.313476 ], [ -87.888328, 43.313388 ], [ -87.888335, 43.313342 ], [ -87.888342, 43.313294 ], [ -87.889207, 43.307652 ], [ -87.897813, 43.291628 ], [ -87.900255, 43.287081 ], [ -87.901847, 43.284117 ], [ -87.902967, 43.280319 ], [ -87.903094, 43.279887 ], [ -87.903141, 43.279728 ], [ -87.903451, 43.278676 ], [ -87.904251, 43.275962 ], [ -87.906465, 43.268454 ], [ -87.906483, 43.268393 ], [ -87.906502, 43.268330 ], [ -87.906565, 43.268115 ], [ -87.906583, 43.268055 ], [ -87.906599, 43.268002 ], [ -87.906605, 43.267980 ], [ -87.906611, 43.267960 ], [ -87.907289, 43.265661 ], [ -87.907291, 43.265653 ], [ -87.907306, 43.265604 ], [ -87.909053, 43.259678 ], [ -87.910345, 43.255296 ], [ -87.911787, 43.250406 ], [ -87.911512, 43.248064 ], [ -87.910172, 43.236634 ], [ -87.910087, 43.235907 ], [ -87.897331, 43.200046 ], [ -87.897326, 43.200031 ], [ -87.897316, 43.200003 ], [ -87.897125, 43.199468 ], [ -87.896286, 43.197108 ], [ -87.895554, 43.196225 ], [ -87.892090, 43.192044 ], [ -87.888570, 43.187795 ], [ -87.887586, 43.186608 ], [ -87.886266, 43.183359 ], [ -87.884878, 43.179944 ], [ -87.884872, 43.179929 ], [ -87.884769, 43.179674 ], [ -87.881085, 43.170609 ], [ -87.886380, 43.160255 ], [ -87.888849, 43.155429 ], [ -87.889327, 43.154493 ], [ -87.889375, 43.154400 ], [ -87.889634, 43.153894 ], [ -87.891059, 43.151108 ], [ -87.892285, 43.148710 ], [ -87.896008, 43.143405 ], [ -87.898105, 43.140417 ], [ -87.899020, 43.139112 ], [ -87.900285, 43.137310 ], [ -87.901345, 43.133357 ], [ -87.901385, 43.133210 ], [ -87.901359, 43.133002 ], [ -87.900496, 43.126000 ], [ -87.900485, 43.125910 ], [ -87.900463, 43.125874 ], [ -87.893185, 43.114011 ], [ -87.879169, 43.101717 ], [ -87.877915, 43.100617 ], [ -87.876084, 43.099011 ], [ -87.872493, 43.089810 ], [ -87.872362, 43.089474 ], [ -87.872352, 43.089449 ], [ -87.872255, 43.089199 ], [ -87.871928, 43.088363 ], [ -87.870459, 43.084598 ], [ -87.866487, 43.074419 ], [ -87.866484, 43.074412 ], [ -87.870184, 43.064412 ], [ -87.870217, 43.064376 ], [ -87.875460, 43.058516 ], [ -87.876343, 43.057529 ], [ -87.881930, 43.051285 ], [ -87.882069, 43.051130 ], [ -87.882084, 43.051113 ], [ -87.889883, 43.045834 ], [ -87.894813, 43.042497 ], [ -87.895028, 43.042351 ], [ -87.895084, 43.042313 ], [ -87.895127, 43.042152 ], [ -87.896227, 43.038028 ], [ -87.896598, 43.036637 ], [ -87.898184, 43.030689 ], [ -87.898684, 43.028813 ], [ -87.896836, 43.020530 ], [ -87.896647, 43.019680 ], [ -87.896398, 43.018565 ], [ -87.896157, 43.017486 ], [ -87.895784, 43.015814 ], [ -87.893511, 43.011521 ], [ -87.889342, 43.003647 ], [ -87.889095, 43.003181 ], [ -87.888804, 43.002631 ], [ -87.887789, 43.000715 ], [ -87.887703, 43.000552 ], [ -87.887683, 43.000514 ], [ -87.878683, 42.992415 ], [ -87.857182, 42.978015 ], [ -87.845181, 42.962015 ], [ -87.844739, 42.958848 ], [ -87.843835, 42.952375 ], [ -87.843575, 42.950519 ], [ -87.842786, 42.944865 ], [ -87.842760, 42.944679 ], [ -87.842681, 42.944116 ], [ -87.844578, 42.923688 ], [ -87.846708, 42.900756 ], [ -87.847745, 42.889595 ], [ -87.847780, 42.889216 ], [ -87.845811, 42.884256 ], [ -87.834879, 42.856717 ], [ -87.831176, 42.849886 ], [ -87.827021, 42.842222 ], [ -87.825352, 42.839144 ], [ -87.824000, 42.836649 ], [ -87.823278, 42.835318 ], [ -87.822324, 42.834371 ], [ -87.804033, 42.816205 ], [ -87.803773, 42.815948 ], [ -87.796201, 42.808428 ], [ -87.793976, 42.806218 ], [ -87.789953, 42.803691 ], [ -87.786291, 42.801391 ], [ -87.785936, 42.801168 ], [ -87.773699, 42.793481 ], [ -87.773623, 42.793388 ], [ -87.766675, 42.784896 ], [ -87.769774, 42.773719 ], [ -87.771340, 42.771687 ], [ -87.777432, 42.763781 ], [ -87.778174, 42.762819 ], [ -87.778774, 42.760556 ], [ -87.780782, 42.752973 ], [ -87.781016, 42.752090 ], [ -87.781949, 42.748570 ], [ -87.782174, 42.747719 ], [ -87.781849, 42.745847 ], [ -87.781655, 42.744733 ], [ -87.781642, 42.744656 ], [ -87.781333, 42.742879 ], [ -87.779527, 42.732482 ], [ -87.778824, 42.728432 ], [ -87.778627, 42.727299 ], [ -87.780320, 42.718679 ], [ -87.782023, 42.710008 ], [ -87.782374, 42.708219 ], [ -87.783489, 42.705164 ], [ -87.784015, 42.703720 ], [ -87.785074, 42.700819 ], [ -87.786774, 42.700719 ], [ -87.794874, 42.689919 ], [ -87.802377, 42.676651 ], [ -87.802876, 42.675768 ], [ -87.802989, 42.675569 ], [ -87.803028, 42.675501 ], [ -87.803074, 42.675419 ], [ -87.803127, 42.675276 ], [ -87.805421, 42.669067 ], [ -87.805768, 42.668128 ], [ -87.807082, 42.664571 ], [ -87.809880, 42.656997 ], [ -87.809885, 42.656982 ], [ -87.811371, 42.652959 ], [ -87.813445, 42.647345 ], [ -87.814674, 42.644020 ], [ -87.819407, 42.617327 ], [ -87.819674, 42.615820 ], [ -87.819374, 42.606620 ], [ -87.815736, 42.596045 ], [ -87.815074, 42.594120 ], [ -87.810873, 42.587320 ], [ -87.811617, 42.584809 ], [ -87.812871, 42.580576 ], [ -87.813273, 42.579220 ], [ -87.813223, 42.576759 ], [ -87.813142, 42.572768 ], [ -87.813135, 42.572424 ], [ -87.812851, 42.558352 ], [ -87.812724, 42.552104 ], [ -87.812632, 42.547562 ], [ -87.812273, 42.529820 ], [ -87.809672, 42.514820 ], [ -87.800477, 42.491920 ], [ -87.800561, 42.491920 ], [ -87.815872, 42.491920 ], [ -87.843594, 42.492307 ], [ -87.900242, 42.493020 ], [ -87.971279, 42.494019 ], [ -87.990180, 42.494519 ], [ -88.049782, 42.495319 ], [ -88.199521, 42.496013 ], [ -88.200172, 42.496016 ], [ -88.216900, 42.495923 ], [ -88.271691, 42.494818 ], [ -88.304692, 42.494773 ], [ -88.417396, 42.494618 ], [ -88.461397, 42.494618 ], [ -88.470597, 42.494672 ], [ -88.506912, 42.494883 ], [ -88.707378, 42.493587 ], [ -88.707380, 42.493587 ], [ -88.776496, 42.494020 ], [ -88.940388, 42.495046 ], [ -88.940391, 42.495046 ], [ -88.943264, 42.495114 ], [ -88.992659, 42.496025 ], [ -88.992977, 42.496026 ], [ -89.013667, 42.496087 ], [ -89.013804, 42.496097 ], [ -89.042898, 42.496255 ], [ -89.071141, 42.496208 ], [ -89.099012, 42.496499 ], [ -89.116949, 42.496910 ], [ -89.120365, 42.496992 ], [ -89.125111, 42.496957 ], [ -89.164905, 42.497347 ], [ -89.166728, 42.497256 ], [ -89.226270, 42.497957 ], [ -89.228279, 42.498047 ], [ -89.246972, 42.498130 ], [ -89.250759, 42.497994 ], [ -89.290896, 42.498853 ], [ -89.361561, 42.500012 ], [ -89.366031, 42.500274 ], [ -89.401416, 42.500433 ], [ -89.401432, 42.500433 ], [ -89.420991, 42.500589 ], [ -89.422567, 42.500680 ], [ -89.423926, 42.500818 ], [ -89.425162, 42.500726 ], [ -89.484300, 42.501426 ], [ -89.492612, 42.501514 ], [ -89.493216, 42.501514 ], [ -89.522542, 42.501889 ], [ -89.564407, 42.502628 ], [ -89.594779, 42.503468 ], [ -89.600001, 42.503672 ], [ -89.603523, 42.503557 ], [ -89.613410, 42.503942 ], [ -89.644176, 42.504520 ], [ -89.650324, 42.504613 ], [ -89.667596, 42.504960 ], [ -89.690088, 42.505191 ], [ -89.693487, 42.505099 ], [ -89.742395, 42.505382 ], [ -89.769643, 42.505322 ], [ -89.780302, 42.505349 ], [ -89.793957, 42.505466 ], [ -89.799704, 42.505421 ], [ -89.801897, 42.505444 ], [ -89.837587, 42.505543 ], [ -89.926224, 42.505788 ], [ -89.926374, 42.505788 ], [ -89.926484, 42.505787 ], [ -89.985072, 42.506464 ], [ -89.985645, 42.506431 ], [ -89.997213, 42.506755 ], [ -89.999314, 42.506914 ], [ -90.017028, 42.507127 ], [ -90.018665, 42.507288 ], [ -90.093026, 42.508160 ], [ -90.095004, 42.507885 ], [ -90.142922, 42.508151 ], [ -90.164363, 42.508272 ], [ -90.181572, 42.508068 ], [ -90.206073, 42.507747 ], [ -90.223190, 42.507765 ], [ -90.250622, 42.507521 ], [ -90.253121, 42.507340 ], [ -90.267143, 42.507642 ], [ -90.269335, 42.507726 ], [ -90.272864, 42.507531 ], [ -90.303823, 42.507469 ], [ -90.362652, 42.507048 ], [ -90.367874, 42.507114 ], [ -90.370673, 42.507111 ], [ -90.405927, 42.506891 ], [ -90.426378, 42.507059 ], [ -90.437011, 42.507147 ], [ -90.474955, 42.507484 ], [ -90.479446, 42.507416 ], [ -90.491716, 42.507624 ], [ -90.532254, 42.507573 ], [ -90.544347, 42.507707 ], [ -90.544799, 42.507713 ], [ -90.551165, 42.507691 ], [ -90.555862, 42.507509 ], [ -90.565441, 42.507600 ], [ -90.614589, 42.508053 ], [ -90.617731, 42.508077 ], [ -90.640927, 42.508302 ], [ -90.636927, 42.513202 ], [ -90.636727, 42.518702 ], [ -90.645627, 42.544100 ], [ -90.702671, 42.630756 ], [ -90.709204, 42.636078 ], [ -90.720209, 42.640758 ], [ -90.769495, 42.651443 ], [ -90.843910, 42.663071 ], [ -90.896961, 42.674407 ], [ -90.949213, 42.685573 ], [ -90.976314, 42.695996 ], [ -91.053733, 42.738238 ], [ -91.064896, 42.757272 ], [ -91.069549, 42.769628 ], [ -91.077643, 42.803798 ], [ -91.100565, 42.883078 ], [ -91.117411, 42.895837 ], [ -91.143375, 42.904670 ], [ -91.145560, 42.907980 ], [ -91.163064, 42.986781 ], [ -91.175167, 43.041267 ], [ -91.178087, 43.062044 ], [ -91.177222, 43.080247 ], [ -91.178251, 43.124982 ], [ -91.175253, 43.134665 ], [ -91.156200, 43.142945 ], [ -91.146200, 43.152405 ], [ -91.062562, 43.243165 ], [ -91.057918, 43.255366 ], [ -91.085652, 43.291870 ], [ -91.107237, 43.313645 ], [ -91.210233, 43.372064 ], [ -91.205550, 43.422949 ], [ -91.217706, 43.500550 ], [ -91.265091, 43.609977 ], [ -91.268748, 43.615348 ], [ -91.273316, 43.668307 ], [ -91.268198, 43.726571 ], [ -91.262436, 43.792166 ], [ -91.284138, 43.847065 ], [ -91.298815, 43.856555 ], [ -91.310991, 43.867381 ], [ -91.363242, 43.926563 ], [ -91.420114, 43.984243 ], [ -91.432522, 43.996827 ], [ -91.437380, 43.999962 ], [ -91.463515, 44.009041 ], [ -91.505918, 44.018651 ], [ -91.547028, 44.022226 ], [ -91.559197, 44.023959 ], [ -91.580019, 44.026925 ], [ -91.592070, 44.031372 ], [ -91.672520, 44.091286 ], [ -91.721552, 44.130342 ], [ -91.740871, 44.133918 ], [ -91.808064, 44.159262 ], [ -91.862858, 44.193001 ], [ -91.875158, 44.200575 ], [ -91.892698, 44.231105 ], [ -91.892963, 44.235149 ], [ -91.887905, 44.246398 ], [ -91.887189, 44.252513 ], [ -91.918625, 44.322671 ], [ -91.925590, 44.333548 ], [ -91.963600, 44.362112 ], [ -91.972493, 44.366760 ], [ -92.046285, 44.394398 ], [ -92.083925, 44.406211 ], [ -92.115296, 44.416056 ], [ -92.221083, 44.440386 ], [ -92.233897, 44.446334 ], [ -92.242010, 44.454254 ], [ -92.276784, 44.473649 ], [ -92.291005, 44.485464 ], [ -92.302215, 44.500298 ], [ -92.303046, 44.518646 ], [ -92.314071, 44.538014 ], [ -92.316425, 44.540792 ], [ -92.319938, 44.544940 ], [ -92.329013, 44.550895 ], [ -92.340058, 44.555273 ], [ -92.357313, 44.558480 ], [ -92.491773, 44.566003 ], [ -92.534186, 44.570375 ], [ -92.549685, 44.576000 ], [ -92.619774, 44.629214 ], [ -92.621733, 44.638983 ], [ -92.632105, 44.649027 ], [ -92.732042, 44.713775 ], [ -92.737259, 44.717155 ], [ -92.802402, 44.745167 ], [ -92.802201, 44.745714 ], [ -92.784443, 44.793958 ], [ -92.765461, 44.836202 ], [ -92.761845, 44.860879 ], [ -92.761677, 44.862022 ], [ -92.750645, 44.937299 ], [ -92.768606, 45.008016 ], [ -92.791206, 45.045698 ], [ -92.792875, 45.078489 ], [ -92.767130, 45.194165 ], [ -92.765898, 45.210173 ], [ -92.760615, 45.278827 ], [ -92.751735, 45.292667 ], [ -92.746139, 45.296046 ], [ -92.732594, 45.304224 ], [ -92.704794, 45.326526 ], [ -92.664102, 45.393309 ], [ -92.680234, 45.464344 ], [ -92.726230, 45.531085 ], [ -92.803432, 45.562500 ], [ -92.823309, 45.560934 ], [ -92.871082, 45.567581 ], [ -92.883749, 45.575483 ], [ -92.886421, 45.594881 ], [ -92.888114, 45.628377 ], [ -92.885661, 45.644126 ], [ -92.883987, 45.654870 ], [ -92.869193, 45.717568 ], [ -92.863703, 45.721820 ], [ -92.841051, 45.730024 ], [ -92.803971, 45.749805 ], [ -92.784621, 45.764196 ], [ -92.768430, 45.798010 ], [ -92.762490, 45.819239 ], [ -92.734039, 45.868108 ], [ -92.721128, 45.883805 ], [ -92.707702, 45.894901 ], [ -92.656125, 45.924442 ], [ -92.443285, 46.014648 ], [ -92.326877, 46.066618 ], [ -92.306756, 46.072410 ], [ -92.294033, 46.074377 ], [ -92.294069, 46.078346 ], [ -92.293530, 46.113824 ], [ -92.293706, 46.157321 ], [ -92.293744, 46.166838 ], [ -92.293857, 46.180073 ], [ -92.293558, 46.224578 ], [ -92.293619, 46.244043 ], [ -92.293074, 46.295129 ], [ -92.293007, 46.297987 ], [ -92.292840, 46.304319 ], [ -92.292839, 46.307107 ], [ -92.292880, 46.313752 ], [ -92.292803, 46.314628 ], [ -92.292782, 46.319312 ], [ -92.292999, 46.321894 ], [ -92.292860, 46.417220 ], [ -92.292847, 46.420876 ], [ -92.292727, 46.431993 ], [ -92.292510, 46.478761 ], [ -92.292371, 46.495585 ], [ -92.291647, 46.604649 ], [ -92.291597, 46.624941 ], [ -92.292192, 46.663242 ], [ -92.277155, 46.655596 ], [ -92.276373, 46.655198 ], [ -92.274465, 46.654227 ], [ -92.269948, 46.651930 ], [ -92.264462, 46.651393 ], [ -92.262503, 46.651201 ], [ -92.256654, 46.650628 ], [ -92.254379, 46.650405 ], [ -92.250861, 46.650061 ], [ -92.242493, 46.649241 ], [ -92.234815, 46.649420 ], [ -92.232647, 46.649470 ], [ -92.231944, 46.649486 ], [ -92.228155, 46.649574 ], [ -92.222338, 46.649710 ], [ -92.221731, 46.649724 ], [ -92.212392, 46.649941 ], [ -92.207092, 46.651941 ], [ -92.202292, 46.655041 ], [ -92.197145, 46.663408 ], [ -92.191501, 46.672586 ], [ -92.191075, 46.673278 ], [ -92.187592, 46.678941 ], [ -92.187795, 46.690185 ], [ -92.193439, 46.695202 ], [ -92.194087, 46.696626 ], [ -92.194562, 46.697672 ], [ -92.196575, 46.702100 ], [ -92.196435, 46.702938 ], [ -92.196264, 46.703966 ], [ -92.195321, 46.709626 ], [ -92.189091, 46.717541 ], [ -92.172997, 46.724444 ], [ -92.170413, 46.725553 ], [ -92.116590, 46.748640 ], [ -92.089490, 46.749240 ], [ -92.033990, 46.708939 ], [ -92.024720, 46.705624 ], [ -92.020289, 46.704039 ], [ -92.015290, 46.706469 ], [ -92.007989, 46.705039 ], [ -91.987889, 46.692739 ], [ -91.973389, 46.686439 ], [ -91.961889, 46.682539 ], [ -91.942988, 46.679939 ], [ -91.930261, 46.682273 ], [ -91.886963, 46.690211 ], [ -91.878730, 46.690811 ], [ -91.877371, 46.690910 ], [ -91.876183, 46.690997 ], [ -91.874840, 46.691095 ], [ -91.866583, 46.691697 ], [ -91.864491, 46.691850 ], [ -91.857462, 46.692362 ], [ -91.840288, 46.689693 ], [ -91.831355, 46.689906 ], [ -91.820027, 46.690176 ], [ -91.817185, 46.690604 ], [ -91.817099, 46.690617 ], [ -91.814669, 46.690982 ], [ -91.799987, 46.693192 ], [ -91.798455, 46.693422 ], [ -91.790473, 46.694624 ], [ -91.790132, 46.694675 ], [ -91.781928, 46.697604 ], [ -91.758619, 46.705927 ], [ -91.749650, 46.709129 ], [ -91.748787, 46.709341 ], [ -91.735632, 46.712575 ], [ -91.677021, 46.726984 ], [ -91.675621, 46.727329 ], [ -91.667534, 46.729317 ], [ -91.662426, 46.730572 ], [ -91.660670, 46.731004 ], [ -91.658739, 46.731479 ], [ -91.652915, 46.732911 ], [ -91.646146, 46.734575 ], [ -91.645502, 46.734733 ], [ -91.636919, 46.737802 ], [ -91.636040, 46.738116 ], [ -91.636005, 46.738128 ], [ -91.635161, 46.738430 ], [ -91.635107, 46.738449 ], [ -91.625387, 46.741924 ], [ -91.593442, 46.753345 ], [ -91.592742, 46.753595 ], [ -91.592203, 46.753788 ], [ -91.590684, 46.754331 ], [ -91.576632, 46.757037 ], [ -91.574291, 46.757488 ], [ -91.574019, 46.757466 ], [ -91.571423, 46.757260 ], [ -91.569075, 46.757074 ], [ -91.557503, 46.756155 ], [ -91.551445, 46.755674 ], [ -91.551408, 46.755666 ], [ -91.543057, 46.755153 ], [ -91.537583, 46.754817 ], [ -91.537115, 46.754788 ], [ -91.535764, 46.754926 ], [ -91.524766, 46.756052 ], [ -91.517712, 46.756774 ], [ -91.511077, 46.757453 ], [ -91.510595, 46.757614 ], [ -91.507819, 46.758538 ], [ -91.507586, 46.758615 ], [ -91.507160, 46.758757 ], [ -91.500042, 46.761128 ], [ -91.499696, 46.761243 ], [ -91.493643, 46.765757 ], [ -91.493037, 46.766210 ], [ -91.492493, 46.766615 ], [ -91.492429, 46.766663 ], [ -91.491744, 46.766732 ], [ -91.489125, 46.766997 ], [ -91.488247, 46.767086 ], [ -91.472097, 46.768717 ], [ -91.470181, 46.768911 ], [ -91.470124, 46.768923 ], [ -91.467168, 46.769546 ], [ -91.462774, 46.770471 ], [ -91.449570, 46.773252 ], [ -91.449327, 46.773303 ], [ -91.436955, 46.777586 ], [ -91.428526, 46.780504 ], [ -91.426491, 46.781208 ], [ -91.423713, 46.782170 ], [ -91.411799, 46.789640 ], [ -91.398256, 46.791213 ], [ -91.397140, 46.791047 ], [ -91.396959, 46.791020 ], [ -91.396261, 46.790917 ], [ -91.394764, 46.790694 ], [ -91.391469, 46.790205 ], [ -91.390774, 46.790316 ], [ -91.386155, 46.791057 ], [ -91.380577, 46.791951 ], [ -91.369387, 46.793745 ], [ -91.368819, 46.793836 ], [ -91.367498, 46.794545 ], [ -91.366888, 46.794872 ], [ -91.365974, 46.795362 ], [ -91.365536, 46.795597 ], [ -91.365277, 46.795736 ], [ -91.363644, 46.796612 ], [ -91.360804, 46.798136 ], [ -91.359434, 46.799612 ], [ -91.355330, 46.804035 ], [ -91.352191, 46.807417 ], [ -91.338250, 46.817704 ], [ -91.337570, 46.817969 ], [ -91.330463, 46.820735 ], [ -91.330433, 46.820746 ], [ -91.328848, 46.821363 ], [ -91.326045, 46.822454 ], [ -91.322202, 46.823950 ], [ -91.321010, 46.824414 ], [ -91.315061, 46.826729 ], [ -91.314815, 46.826825 ], [ -91.307050, 46.829007 ], [ -91.305487, 46.829446 ], [ -91.304512, 46.829720 ], [ -91.303594, 46.829978 ], [ -91.302295, 46.830343 ], [ -91.301879, 46.830384 ], [ -91.289541, 46.831604 ], [ -91.278558, 46.832689 ], [ -91.266404, 46.833891 ], [ -91.265866, 46.833944 ], [ -91.265816, 46.833960 ], [ -91.263725, 46.834632 ], [ -91.263445, 46.834722 ], [ -91.256873, 46.836833 ], [ -91.256705, 46.836887 ], [ -91.256563, 46.836989 ], [ -91.250806, 46.841135 ], [ -91.249471, 46.842531 ], [ -91.237730, 46.854809 ], [ -91.235283, 46.857368 ], [ -91.232733, 46.860035 ], [ -91.226796, 46.863610 ], [ -91.214886, 46.866137 ], [ -91.211647, 46.866824 ], [ -91.211113, 46.866696 ], [ -91.207524, 46.865835 ], [ -91.204839, 46.859727 ], [ -91.204439, 46.858816 ], [ -91.200107, 46.854017 ], [ -91.178292, 46.844259 ], [ -91.168297, 46.844727 ], [ -91.167601, 46.844760 ], [ -91.156108, 46.855414 ], [ -91.148026, 46.862906 ], [ -91.147837, 46.863082 ], [ -91.144266, 46.870301 ], [ -91.143877, 46.870576 ], [ -91.143850, 46.870595 ], [ -91.140301, 46.873105 ], [ -91.140165, 46.873201 ], [ -91.139758, 46.873148 ], [ -91.134668, 46.872490 ], [ -91.133772, 46.871043 ], [ -91.133337, 46.870341 ], [ -91.133674, 46.869348 ], [ -91.134184, 46.867843 ], [ -91.134724, 46.866250 ], [ -91.134882, 46.865784 ], [ -91.136512, 46.860975 ], [ -91.134977, 46.859023 ], [ -91.134948, 46.858986 ], [ -91.134732, 46.858935 ], [ -91.123530, 46.856273 ], [ -91.123109, 46.856173 ], [ -91.118540, 46.856548 ], [ -91.107323, 46.857469 ], [ -91.105490, 46.857620 ], [ -91.098780, 46.860560 ], [ -91.098346, 46.860750 ], [ -91.098125, 46.860847 ], [ -91.097550, 46.861098 ], [ -91.096565, 46.861530 ], [ -91.096342, 46.862965 ], [ -91.096028, 46.864987 ], [ -91.095058, 46.871234 ], [ -91.094828, 46.872714 ], [ -91.094724, 46.873383 ], [ -91.094620, 46.874050 ], [ -91.094498, 46.874837 ], [ -91.094096, 46.877423 ], [ -91.093714, 46.879882 ], [ -91.090916, 46.882670 ], [ -91.088721, 46.882877 ], [ -91.085077, 46.883220 ], [ -91.080951, 46.883609 ], [ -91.072584, 46.880126 ], [ -91.069331, 46.878772 ], [ -91.068220, 46.878309 ], [ -91.066193, 46.878710 ], [ -91.056258, 46.880678 ], [ -91.052991, 46.881325 ], [ -91.050153, 46.883037 ], [ -91.049232, 46.883593 ], [ -91.049220, 46.883600 ], [ -91.042992, 46.887358 ], [ -91.039890, 46.889230 ], [ -91.036622, 46.893594 ], [ -91.036193, 46.895523 ], [ -91.035936, 46.896679 ], [ -91.034518, 46.903053 ], [ -91.033447, 46.903642 ], [ -91.032508, 46.904158 ], [ -91.030583, 46.905215 ], [ -91.024009, 46.908827 ], [ -91.023976, 46.908845 ], [ -91.021538, 46.910185 ], [ -91.019670, 46.911211 ], [ -91.019141, 46.911502 ], [ -91.018045, 46.911872 ], [ -91.018024, 46.911879 ], [ -91.016237, 46.912481 ], [ -91.016184, 46.912499 ], [ -91.010689, 46.914352 ], [ -91.007997, 46.915259 ], [ -91.005872, 46.915976 ], [ -91.005199, 46.916203 ], [ -91.004892, 46.916192 ], [ -91.004752, 46.916187 ], [ -90.998848, 46.915975 ], [ -90.997943, 46.916367 ], [ -90.996825, 46.916851 ], [ -90.995149, 46.917577 ], [ -90.987013, 46.923776 ], [ -90.985815, 46.924689 ], [ -90.984617, 46.925602 ], [ -90.983192, 46.927662 ], [ -90.980235, 46.931937 ], [ -90.973755, 46.941304 ], [ -90.968419, 46.943910 ], [ -90.964865, 46.943780 ], [ -90.964072, 46.943369 ], [ -90.954612, 46.938468 ], [ -90.954537, 46.938429 ], [ -90.953865, 46.938283 ], [ -90.953685, 46.938244 ], [ -90.940560, 46.935394 ], [ -90.922040, 46.931372 ], [ -90.921811, 46.931322 ], [ -90.921382, 46.931434 ], [ -90.914044, 46.933346 ], [ -90.913838, 46.933400 ], [ -90.908654, 46.941221 ], [ -90.908598, 46.941305 ], [ -90.880358, 46.957661 ], [ -90.879621, 46.958088 ], [ -90.877324, 46.958910 ], [ -90.877165, 46.958967 ], [ -90.877092, 46.958993 ], [ -90.876778, 46.959106 ], [ -90.876544, 46.959189 ], [ -90.876213, 46.959308 ], [ -90.876211, 46.959309 ], [ -90.876006, 46.959382 ], [ -90.875995, 46.959386 ], [ -90.875635, 46.959515 ], [ -90.871126, 46.961129 ], [ -90.855874, 46.962232 ], [ -90.855165, 46.962045 ], [ -90.838814, 46.957728 ], [ -90.837973, 46.957506 ], [ -90.837716, 46.957438 ], [ -90.837617, 46.957379 ], [ -90.833091, 46.954686 ], [ -90.805028, 46.937987 ], [ -90.786595, 46.927019 ], [ -90.786502, 46.926964 ], [ -90.786010, 46.926672 ], [ -90.785606, 46.926431 ], [ -90.760095, 46.903296 ], [ -90.759364, 46.902634 ], [ -90.755630, 46.899247 ], [ -90.754552, 46.898270 ], [ -90.754388, 46.898037 ], [ -90.752725, 46.895680 ], [ -90.751329, 46.893702 ], [ -90.751048, 46.893305 ], [ -90.750858, 46.893035 ], [ -90.750871, 46.892643 ], [ -90.750889, 46.892136 ], [ -90.750952, 46.890293 ], [ -90.751031, 46.887963 ], [ -90.751151, 46.887863 ], [ -90.754692, 46.884915 ], [ -90.754734, 46.884880 ], [ -90.754753, 46.884875 ], [ -90.761295, 46.883238 ], [ -90.761567, 46.883170 ], [ -90.770170, 46.876296 ], [ -90.770240, 46.876184 ], [ -90.780972, 46.858989 ], [ -90.781011, 46.858911 ], [ -90.788040, 46.844886 ], [ -90.792034, 46.836916 ], [ -90.793713, 46.833566 ], [ -90.795693, 46.829614 ], [ -90.795957, 46.829087 ], [ -90.796437, 46.828129 ], [ -90.797404, 46.826200 ], [ -90.798545, 46.823922 ], [ -90.798936, 46.823143 ], [ -90.801041, 46.821626 ], [ -90.801370, 46.821389 ], [ -90.809270, 46.815695 ], [ -90.821967, 46.806545 ], [ -90.825696, 46.803858 ], [ -90.826337, 46.802110 ], [ -90.827350, 46.799345 ], [ -90.828057, 46.797415 ], [ -90.829048, 46.796410 ], [ -90.829933, 46.795513 ], [ -90.830094, 46.795349 ], [ -90.831645, 46.793777 ], [ -90.835008, 46.790366 ], [ -90.835028, 46.790346 ], [ -90.835319, 46.790051 ], [ -90.835607, 46.789759 ], [ -90.847214, 46.789274 ], [ -90.854916, 46.788952 ], [ -90.855472, 46.788929 ], [ -90.855746, 46.788918 ], [ -90.856317, 46.788894 ], [ -90.856531, 46.788885 ], [ -90.856677, 46.788712 ], [ -90.859999, 46.784769 ], [ -90.863542, 46.780565 ], [ -90.859724, 46.774433 ], [ -90.859445, 46.773985 ], [ -90.860880, 46.771079 ], [ -90.862333, 46.768135 ], [ -90.866337, 46.764626 ], [ -90.866586, 46.764408 ], [ -90.866694, 46.764361 ], [ -90.874598, 46.760902 ], [ -90.875925, 46.760321 ], [ -90.885021, 46.756341 ], [ -90.883443, 46.747255 ], [ -90.883396, 46.746987 ], [ -90.882099, 46.744622 ], [ -90.881622, 46.743753 ], [ -90.878810, 46.738629 ], [ -90.878343, 46.737777 ], [ -90.876538, 46.734487 ], [ -90.876426, 46.734284 ], [ -90.876334, 46.734115 ], [ -90.876039, 46.733577 ], [ -90.875829, 46.733195 ], [ -90.871612, 46.725509 ], [ -90.870577, 46.723623 ], [ -90.870396, 46.723293 ], [ -90.869461, 46.722039 ], [ -90.868607, 46.720896 ], [ -90.868531, 46.720794 ], [ -90.868273, 46.720448 ], [ -90.868024, 46.720115 ], [ -90.863864, 46.714539 ], [ -90.861353, 46.711173 ], [ -90.860897, 46.710562 ], [ -90.859797, 46.709088 ], [ -90.859601, 46.708826 ], [ -90.853225, 46.700280 ], [ -90.852916, 46.699866 ], [ -90.852704, 46.699582 ], [ -90.852731, 46.699437 ], [ -90.853644, 46.694464 ], [ -90.853807, 46.693579 ], [ -90.853829, 46.693457 ], [ -90.853927, 46.693369 ], [ -90.854539, 46.692822 ], [ -90.854692, 46.692686 ], [ -90.865494, 46.683033 ], [ -90.865745, 46.682808 ], [ -90.867423, 46.681309 ], [ -90.867823, 46.680952 ], [ -90.867981, 46.680810 ], [ -90.868376, 46.680457 ], [ -90.868468, 46.680375 ], [ -90.870079, 46.679449 ], [ -90.870532, 46.679189 ], [ -90.870739, 46.679070 ], [ -90.870956, 46.678945 ], [ -90.885869, 46.670374 ], [ -90.885943, 46.670353 ], [ -90.896529, 46.667315 ], [ -90.905273, 46.664807 ], [ -90.905567, 46.664722 ], [ -90.909176, 46.663687 ], [ -90.909688, 46.663540 ], [ -90.911281, 46.663083 ], [ -90.911353, 46.662996 ], [ -90.914619, 46.659054 ], [ -90.915152, 46.658410 ], [ -90.915367, 46.657615 ], [ -90.920813, 46.637432 ], [ -90.920835, 46.637351 ], [ -90.920850, 46.636492 ], [ -90.920867, 46.635515 ], [ -90.920936, 46.631606 ], [ -90.920936, 46.631584 ], [ -90.924487, 46.625417 ], [ -90.924489, 46.625415 ], [ -90.926745, 46.622698 ], [ -90.931623, 46.616822 ], [ -90.932120, 46.616223 ], [ -90.933208, 46.614913 ], [ -90.938310, 46.608768 ], [ -90.938617, 46.608398 ], [ -90.938680, 46.608322 ], [ -90.949532, 46.603019 ], [ -90.949621, 46.602975 ], [ -90.950215, 46.602248 ], [ -90.950544, 46.601845 ], [ -90.951418, 46.600774 ], [ -90.951543, 46.600621 ], [ -90.951528, 46.599827 ], [ -90.951476, 46.597033 ], [ -90.947572, 46.593510 ], [ -90.947287, 46.593253 ], [ -90.947159, 46.593138 ], [ -90.942101, 46.588573 ], [ -90.941930, 46.588419 ], [ -90.941374, 46.588293 ], [ -90.941102, 46.588232 ], [ -90.927387, 46.585132 ], [ -90.923560, 46.584267 ], [ -90.923438, 46.584239 ], [ -90.921483, 46.583797 ], [ -90.920411, 46.583555 ], [ -90.920132, 46.583492 ], [ -90.919920, 46.583444 ], [ -90.918414, 46.583103 ], [ -90.918352, 46.583089 ], [ -90.918266, 46.583070 ], [ -90.916982, 46.583014 ], [ -90.909815, 46.582703 ], [ -90.906058, 46.583430 ], [ -90.905572, 46.583524 ], [ -90.901918, 46.585519 ], [ -90.901725, 46.585624 ], [ -90.891944, 46.590964 ], [ -90.886197, 46.594102 ], [ -90.885103, 46.594700 ], [ -90.885007, 46.594752 ], [ -90.873154, 46.601223 ], [ -90.867120, 46.601911 ], [ -90.864284, 46.602965 ], [ -90.858725, 46.605031 ], [ -90.856811, 46.605742 ], [ -90.856244, 46.605953 ], [ -90.856090, 46.606010 ], [ -90.854575, 46.606573 ], [ -90.853380, 46.607017 ], [ -90.852153, 46.607473 ], [ -90.851889, 46.607571 ], [ -90.849684, 46.608391 ], [ -90.843225, 46.610791 ], [ -90.843189, 46.610805 ], [ -90.842058, 46.611225 ], [ -90.841708, 46.611355 ], [ -90.837306, 46.612991 ], [ -90.834259, 46.614123 ], [ -90.831868, 46.615012 ], [ -90.831226, 46.615250 ], [ -90.830011, 46.615702 ], [ -90.829070, 46.616051 ], [ -90.829031, 46.616066 ], [ -90.794775, 46.624941 ], [ -90.792583, 46.625938 ], [ -90.772455, 46.635097 ], [ -90.770192, 46.636127 ], [ -90.768381, 46.637362 ], [ -90.755381, 46.646225 ], [ -90.755287, 46.646289 ], [ -90.755289, 46.646323 ], [ -90.756312, 46.661820 ], [ -90.756495, 46.664591 ], [ -90.748090, 46.669817 ], [ -90.748026, 46.669968 ], [ -90.739565, 46.689943 ], [ -90.739549, 46.689981 ], [ -90.737260, 46.692267 ], [ -90.724924, 46.684186 ], [ -90.705375, 46.671381 ], [ -90.694721, 46.664402 ], [ -90.654497, 46.639990 ], [ -90.650949, 46.637837 ], [ -90.627885, 46.623839 ], [ -90.607649, 46.612186 ], [ -90.606720, 46.611651 ], [ -90.606177, 46.611339 ], [ -90.599602, 46.607552 ], [ -90.599375, 46.607422 ], [ -90.595850, 46.605392 ], [ -90.595583, 46.605238 ], [ -90.591894, 46.603114 ], [ -90.590811, 46.602490 ], [ -90.590712, 46.602433 ], [ -90.586249, 46.599863 ], [ -90.581408, 46.597541 ], [ -90.580191, 46.596958 ], [ -90.579422, 46.596589 ], [ -90.563668, 46.589034 ], [ -90.561966, 46.588218 ], [ -90.561126, 46.587816 ], [ -90.558141, 46.586384 ], [ -90.556224, 46.585880 ], [ -90.549596, 46.584138 ], [ -90.538346, 46.581182 ], [ -90.537962, 46.581081 ], [ -90.537829, 46.581143 ], [ -90.527776, 46.585858 ], [ -90.525788, 46.586790 ], [ -90.525498, 46.586926 ], [ -90.525334, 46.586949 ], [ -90.522674, 46.587313 ], [ -90.519105, 46.587803 ], [ -90.519002, 46.587817 ], [ -90.518510, 46.587885 ], [ -90.505909, 46.589614 ], [ -90.497359, 46.585509 ], [ -90.478826, 46.576610 ], [ -90.478469, 46.576439 ], [ -90.476480, 46.575484 ], [ -90.476315, 46.575405 ], [ -90.476046, 46.575276 ], [ -90.473760, 46.574178 ], [ -90.472483, 46.573730 ], [ -90.440085, 46.562365 ], [ -90.438174, 46.561695 ], [ -90.437596, 46.561492 ], [ -90.437532, 46.561507 ], [ -90.436512, 46.561748 ], [ -90.436314, 46.561795 ], [ -90.434812, 46.562150 ], [ -90.433367, 46.562492 ], [ -90.418136, 46.566094 ], [ -90.414596, 46.557320 ], [ -90.414464, 46.557320 ], [ -90.400429, 46.544384 ], [ -90.400041, 46.544384 ], [ -90.374461, 46.539212 ], [ -90.357676, 46.540271 ], [ -90.313894, 46.516199 ], [ -90.313839, 46.516199 ], [ -90.307716, 46.518392 ], [ -90.284545, 46.518714 ], [ -90.204572, 46.478998 ], [ -90.177860, 46.440548 ], [ -90.166919, 46.439851 ], [ -90.166909, 46.439311 ], [ -90.134656, 46.374979 ], [ -90.134663, 46.374947 ], [ -90.119757, 46.359748 ], [ -90.119691, 46.359755 ], [ -90.120489, 46.336852 ], [ -89.929093, 46.300087 ], [ -89.909910, 46.296402 ], [ -89.908196, 46.296037 ], [ -89.276883, 46.174116 ], [ -89.276489, 46.174047 ], [ -89.219964, 46.163319 ], [ -89.218156, 46.162988 ], [ -89.205657, 46.160408 ], [ -89.203289, 46.160020 ], [ -89.201283, 46.159426 ], [ -89.194508, 46.157942 ], [ -89.166887, 46.152868 ], [ -89.161757, 46.151816 ], [ -89.125136, 46.144531 ], [ -89.058745, 46.124952 ], [ -88.990885, 46.097330 ], [ -88.990807, 46.097298 ], [ -88.948698, 46.080205 ], [ -88.943279, 46.077943 ], [ -88.932558, 46.073601 ], [ -88.850270, 46.040274 ], [ -88.848464, 46.038858 ], [ -88.840584, 46.031112 ], [ -88.815629, 46.022320 ], [ -88.769712, 46.018968 ], [ -88.739994, 46.027308 ], [ -88.730675, 46.026535 ], [ -88.683198, 46.014563 ], [ -88.679132, 46.013538 ], [ -88.674606, 46.010567 ], [ -88.670115, 45.999957 ], [ -88.670939, 45.999957 ], [ -88.666056, 45.988191 ], [ -88.637500, 45.984960 ], [ -88.616405, 45.987700 ], [ -88.613063, 45.990627 ], [ -88.532414, 46.021212 ], [ -88.507188, 46.018300 ], [ -88.500133, 46.000457 ], [ -88.497417, 45.995149 ], [ -88.489608, 45.991381 ], [ -88.423437, 45.981930 ], [ -88.376447, 45.989458 ], [ -88.295559, 45.951459 ], [ -88.250133, 45.963147 ], [ -88.244452, 45.952142 ], [ -88.239672, 45.948982 ], [ -88.211158, 45.944531 ], [ -88.202247, 45.949584 ], [ -88.175532, 45.944897 ], [ -88.139372, 45.929932 ], [ -88.118516, 45.918562 ], [ -88.102603, 45.909888 ], [ -88.073944, 45.875593 ], [ -88.073134, 45.871952 ], [ -88.088825, 45.855860 ], [ -88.106622, 45.841072 ], [ -88.114267, 45.837891 ], [ -88.133640, 45.823128 ], [ -88.136110, 45.819029 ], [ -88.130434, 45.810020 ], [ -88.094047, 45.785658 ], [ -88.072091, 45.780261 ], [ -88.058256, 45.780719 ], [ -88.050634, 45.780972 ], [ -88.039729, 45.789626 ], [ -87.991447, 45.795393 ], [ -87.868111, 45.749477 ], [ -87.828827, 45.722760 ], [ -87.807144, 45.708014 ], [ -87.780808, 45.680349 ], [ -87.781623, 45.673280 ], [ -87.823672, 45.659817 ], [ -87.824102, 45.647138 ], [ -87.795880, 45.618846 ], [ -87.792016, 45.616756 ], [ -87.788798, 45.565947 ], [ -87.792769, 45.499967 ], [ -87.798960, 45.485147 ], [ -87.806347, 45.472262 ], [ -87.812976, 45.464159 ], [ -87.820348, 45.460284 ], [ -87.860432, 45.423504 ], [ -87.888052, 45.354697 ], [ -87.885170, 45.351736 ], [ -87.850133, 45.340435 ], [ -87.838141, 45.345101 ], [ -87.835303, 45.350980 ], [ -87.832612, 45.352249 ], [ -87.790324, 45.353444 ], [ -87.771384, 45.351210 ], [ -87.751452, 45.351755 ], [ -87.718891, 45.377462 ], [ -87.693956, 45.389893 ], [ -87.685934, 45.388711 ], [ -87.675017, 45.382454 ], [ -87.657349, 45.368752 ], [ -87.647729, 45.350721 ], [ -87.648126, 45.339396 ], [ -87.709137, 45.260341 ], [ -87.707779, 45.258343 ], [ -87.711722, 45.243481 ], [ -87.731710, 45.206792 ], [ -87.739492, 45.202126 ], [ -87.741732, 45.198201 ], [ -87.735282, 45.176565 ], [ -87.731389, 45.170989 ], [ -87.659952, 45.107512 ], [ -87.590208, 45.095264 ], [ -87.587147, 45.089495 ], [ -87.587992, 45.085271 ], [ -87.591583, 45.083792 ], [ -87.594718, 45.085134 ], [ -87.601849, 45.082297 ], [ -87.610395, 45.075617 ], [ -87.625748, 45.045157 ], [ -87.624693, 45.014176 ], [ -87.630298, 44.976865 ], [ -87.661964, 44.973035 ], [ -87.696492, 44.974233 ], [ -87.762620, 44.965796 ] ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US56", "STATE": 24, "name": "Wyoming", "LSAD": "", "CENSUSAREA": 97093.141000 }, "geometry": { "type": "Polygon", "coordinates": [ [ [ -104.055077, 43.936535 ], [ -104.055104, 43.853478 ], [ -104.055138, 43.750421 ], [ -104.055133, 43.747105 ], [ -104.054902, 43.583852 ], [ -104.054885, 43.583512 ], [ -104.054840, 43.579368 ], [ -104.055032, 43.558603 ], [ -104.054787, 43.503328 ], [ -104.054786, 43.503072 ], [ -104.054779, 43.477815 ], [ -104.054766, 43.428914 ], [ -104.054614, 43.390949 ], [ -104.054403, 43.325914 ], [ -104.054218, 43.304370 ], [ -104.053884, 43.297047 ], [ -104.053876, 43.289801 ], [ -104.053127, 43.000585 ], [ -104.052863, 42.754569 ], [ -104.052809, 42.749966 ], [ -104.052583, 42.650062 ], [ -104.052741, 42.633982 ], [ -104.052586, 42.630917 ], [ -104.052773, 42.611766 ], [ -104.052775, 42.611590 ], [ -104.052775, 42.610813 ], [ -104.052776, 42.258220 ], [ -104.052793, 42.249962 ], [ -104.052761, 42.170278 ], [ -104.052547, 42.166801 ], [ -104.053001, 42.137254 ], [ -104.052738, 42.133769 ], [ -104.052600, 42.124963 ], [ -104.052954, 42.089077 ], [ -104.052967, 42.075004 ], [ -104.052880, 42.021761 ], [ -104.052729, 42.016318 ], [ -104.052704, 42.001718 ], [ -104.052699, 41.998673 ], [ -104.052761, 41.994967 ], [ -104.052830, 41.994600 ], [ -104.052856, 41.975958 ], [ -104.052734, 41.973007 ], [ -104.052991, 41.914973 ], [ -104.052931, 41.906143 ], [ -104.053026, 41.885464 ], [ -104.052774, 41.733401 ], [ -104.052830, 41.697954 ], [ -104.052913, 41.645190 ], [ -104.052945, 41.638167 ], [ -104.052975, 41.622931 ], [ -104.052735, 41.613676 ], [ -104.052859, 41.592254 ], [ -104.052540, 41.564274 ], [ -104.052531, 41.552723 ], [ -104.052584, 41.552650 ], [ -104.052692, 41.541154 ], [ -104.052686, 41.539111 ], [ -104.052476, 41.522343 ], [ -104.052478, 41.515754 ], [ -104.052340, 41.417865 ], [ -104.052160, 41.407662 ], [ -104.052287, 41.393307 ], [ -104.052287, 41.393214 ], [ -104.052324, 41.321144 ], [ -104.052476, 41.320961 ], [ -104.052568, 41.316202 ], [ -104.052453, 41.278202 ], [ -104.052574, 41.278019 ], [ -104.052666, 41.275251 ], [ -104.053142, 41.114457 ], [ -104.053083, 41.104985 ], [ -104.053025, 41.090274 ], [ -104.053177, 41.089725 ], [ -104.053097, 41.018045 ], [ -104.053158, 41.016809 ], [ -104.053249, 41.001406 ], [ -104.066961, 41.001504 ], [ -104.086068, 41.001563 ], [ -104.104590, 41.001543 ], [ -104.123586, 41.001626 ], [ -104.211473, 41.001591 ], [ -104.214191, 41.001568 ], [ -104.214692, 41.001657 ], [ -104.497058, 41.001805 ], [ -104.497149, 41.001828 ], [ -104.882452, 40.998186 ], [ -104.943371, 40.998190 ], [ -105.254779, 40.998210 ], [ -105.256527, 40.998191 ], [ -105.276860, 40.998173 ], [ -105.277138, 40.998173 ], [ -105.724804, 40.996910 ], [ -105.730421, 40.996886 ], [ -106.061181, 40.996999 ], [ -106.190550, 40.998056 ], [ -106.321165, 40.999123 ], [ -106.386356, 41.001144 ], [ -106.391852, 41.001176 ], [ -106.430950, 41.001752 ], [ -106.437419, 41.001795 ], [ -106.439563, 41.001978 ], [ -106.453859, 41.002057 ], [ -106.857772, 41.003082 ], [ -107.000606, 41.003444 ], [ -107.317794, 41.002957 ], [ -107.918421, 41.002036 ], [ -108.250649, 41.000114 ], [ -109.050076, 41.000659 ], [ -109.207383, 41.001459 ], [ -109.676421, 40.998395 ], [ -109.713877, 40.998266 ], [ -109.715409, 40.998191 ], [ -109.854302, 40.997661 ], [ -109.855299, 40.997614 ], [ -109.999838, 40.997330 ], [ -110.000708, 40.997352 ], [ -110.048474, 40.997103 ], [ -110.500718, 40.994746 ], [ -111.046723, 40.997959 ], [ -111.046551, 41.251716 ], [ -111.046600, 41.360692 ], [ -111.046264, 41.377731 ], [ -111.046402, 41.579845 ], [ -111.046689, 42.001567 ], [ -111.047109, 42.142497 ], [ -111.047107, 42.148971 ], [ -111.047058, 42.182672 ], [ -111.047097, 42.194773 ], [ -111.047074, 42.280787 ], [ -111.047080, 42.349420 ], [ -111.046249, 42.513116 ], [ -111.043959, 42.964450 ], [ -111.043957, 42.969482 ], [ -111.043924, 42.975063 ], [ -111.044129, 43.018702 ], [ -111.044156, 43.020052 ], [ -111.044206, 43.022614 ], [ -111.044034, 43.024581 ], [ -111.044034, 43.024844 ], [ -111.044033, 43.026411 ], [ -111.044094, 43.029270 ], [ -111.043997, 43.041415 ], [ -111.044058, 43.044640 ], [ -111.044063, 43.046302 ], [ -111.044086, 43.054819 ], [ -111.044117, 43.060309 ], [ -111.044150, 43.066172 ], [ -111.044162, 43.068222 ], [ -111.044143, 43.072364 ], [ -111.044235, 43.177121 ], [ -111.044266, 43.177236 ], [ -111.044232, 43.184440 ], [ -111.044168, 43.189244 ], [ -111.044229, 43.195579 ], [ -111.044617, 43.315720 ], [ -111.045205, 43.501136 ], [ -111.045706, 43.659112 ], [ -111.045880, 43.681033 ], [ -111.046118, 43.684902 ], [ -111.046051, 43.685812 ], [ -111.046110, 43.687848 ], [ -111.046421, 43.722059 ], [ -111.046435, 43.726545 ], [ -111.046340, 43.726957 ], [ -111.046715, 43.815832 ], [ -111.048107, 43.983096 ], [ -111.048751, 44.060403 ], [ -111.048751, 44.060838 ], [ -111.048633, 44.062903 ], [ -111.049216, 44.435811 ], [ -111.049194, 44.438058 ], [ -111.048974, 44.474072 ], [ -111.055208, 44.624927 ], [ -111.055495, 44.666262 ], [ -111.056888, 44.866658 ], [ -111.055629, 44.933578 ], [ -111.056207, 44.935901 ], [ -111.044275, 45.001345 ], [ -110.875772, 45.002101 ], [ -110.750767, 44.997948 ], [ -110.705272, 44.992324 ], [ -110.552433, 44.992237 ], [ -110.547165, 44.992459 ], [ -110.221343, 44.996176 ], [ -110.110103, 45.003905 ], [ -110.026347, 45.003665 ], [ -110.025544, 45.003602 ], [ -109.798687, 45.002188 ], [ -109.269294, 45.005283 ], [ -109.263431, 45.005345 ], [ -109.103445, 45.005904 ], [ -109.083010, 44.999610 ], [ -109.062262, 44.999623 ], [ -108.621313, 45.000408 ], [ -108.578484, 45.000484 ], [ -108.565921, 45.000578 ], [ -108.249345, 44.999458 ], [ -108.125666, 45.001011 ], [ -107.911495, 45.000948 ], [ -107.608854, 45.000860 ], [ -107.607824, 45.000929 ], [ -107.134180, 45.000109 ], [ -107.080624, 44.996791 ], [ -106.892875, 44.995947 ], [ -106.888773, 44.995885 ], [ -106.263586, 44.993788 ], [ -106.024814, 44.993688 ], [ -105.928184, 44.993647 ], [ -105.918995, 44.997771 ], [ -105.848065, 45.000396 ], [ -105.076607, 45.000347 ], [ -105.038405, 45.000345 ], [ -105.025266, 45.000290 ], [ -105.019284, 45.000329 ], [ -105.018240, 45.000437 ], [ -104.765063, 44.999183 ], [ -104.759855, 44.999066 ], [ -104.665171, 44.998618 ], [ -104.663882, 44.998869 ], [ -104.470422, 44.998453 ], [ -104.470117, 44.998453 ], [ -104.057698, 44.997431 ], [ -104.055963, 44.768236 ], [ -104.055963, 44.767962 ], [ -104.055934, 44.723720 ], [ -104.055870, 44.723422 ], [ -104.055777, 44.700466 ], [ -104.055938, 44.693881 ], [ -104.055810, 44.691343 ], [ -104.055877, 44.571016 ], [ -104.055892, 44.543341 ], [ -104.055927, 44.517730 ], [ -104.054487, 44.180381 ], [ -104.054562, 44.141081 ], [ -104.054950, 43.938090 ], [ -104.055077, 43.936535 ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US01", "STATE": 25, "name": "Alabama", "LSAD": "", "CENSUSAREA": 50645.326000 }, "geometry": { "type": "MultiPolygon", "coordinates": [ [ [ [ -88.124658, 30.283640 ], [ -88.086812, 30.259864 ], [ -88.074854, 30.249119 ], [ -88.075856, 30.246139 ], [ -88.078786, 30.245039 ], [ -88.109432, 30.242097 ], [ -88.120151, 30.246149 ], [ -88.137083, 30.249179 ], [ -88.166569, 30.249255 ], [ -88.208540, 30.244807 ], [ -88.280571, 30.230274 ], [ -88.304773, 30.228031 ], [ -88.313323, 30.230024 ], [ -88.310025, 30.233233 ], [ -88.299705, 30.231812 ], [ -88.280781, 30.233781 ], [ -88.258370, 30.239595 ], [ -88.224615, 30.245559 ], [ -88.173350, 30.252418 ], [ -88.158303, 30.252393 ], [ -88.141143, 30.255024 ], [ -88.130631, 30.262125 ], [ -88.124722, 30.273541 ], [ -88.124658, 30.283640 ] ] ], [ [ [ -86.783628, 34.991925 ], [ -86.677616, 34.992070 ], [ -86.676726, 34.992070 ], [ -86.674360, 34.992001 ], [ -86.670853, 34.992000 ], [ -86.659610, 34.991792 ], [ -86.641212, 34.991740 ], [ -86.600039, 34.991240 ], [ -86.588962, 34.991197 ], [ -86.571217, 34.991011 ], [ -86.555864, 34.990971 ], [ -86.528485, 34.990677 ], [ -86.467798, 34.990692 ], [ -86.433927, 34.991085 ], [ -86.397203, 34.991660 ], [ -86.318761, 34.991147 ], [ -86.311274, 34.991098 ], [ -85.863935, 34.988379 ], [ -85.828724, 34.988165 ], [ -85.824411, 34.988142 ], [ -85.605165, 34.984678 ], [ -85.595191, 34.924331 ], [ -85.595163, 34.924171 ], [ -85.583145, 34.860371 ], [ -85.552482, 34.708321 ], [ -85.552454, 34.708138 ], [ -85.541267, 34.656783 ], [ -85.541264, 34.656701 ], [ -85.534423, 34.623789 ], [ -85.527127, 34.588684 ], [ -85.513930, 34.525192 ], [ -85.513709, 34.524170 ], [ -85.513699, 34.524133 ], [ -85.512108, 34.518252 ], [ -85.508384, 34.501212 ], [ -85.502454, 34.474527 ], [ -85.502316, 34.473954 ], [ -85.462304, 34.286365 ], [ -85.458693, 34.269437 ], [ -85.458071, 34.265736 ], [ -85.455371, 34.252854 ], [ -85.455057, 34.250689 ], [ -85.421731, 34.080821 ], [ -85.398837, 33.964129 ], [ -85.386693, 33.901697 ], [ -85.361844, 33.773951 ], [ -85.360491, 33.767958 ], [ -85.337974, 33.653111 ], [ -85.322497, 33.574167 ], [ -85.314994, 33.535898 ], [ -85.314091, 33.530218 ], [ -85.313999, 33.529807 ], [ -85.304439, 33.482884 ], [ -85.293902, 33.428079 ], [ -85.236509, 33.129562 ], [ -85.232378, 33.108077 ], [ -85.223261, 33.062580 ], [ -85.221868, 33.055538 ], [ -85.184131, 32.870525 ], [ -85.123421, 32.772248 ], [ -85.132040, 32.764211 ], [ -85.136776, 32.746512 ], [ -85.137136, 32.745168 ], [ -85.114737, 32.685634 ], [ -85.104790, 32.642542 ], [ -85.082454, 32.607022 ], [ -85.080288, 32.603577 ], [ -85.079935, 32.602889 ], [ -85.069583, 32.583930 ], [ -85.044606, 32.559499 ], [ -85.022509, 32.542923 ], [ -85.007100, 32.523868 ], [ -85.001324, 32.512973 ], [ -85.001052, 32.510477 ], [ -85.001030, 32.510157 ], [ -85.000779, 32.506548 ], [ -84.998231, 32.469842 ], [ -84.983831, 32.445643 ], [ -84.979431, 32.412244 ], [ -84.987278, 32.381623 ], [ -84.987386, 32.381201 ], [ -85.008096, 32.336677 ], [ -85.007103, 32.328362 ], [ -85.001874, 32.322015 ], [ -84.938680, 32.300708 ], [ -84.916611, 32.281177 ], [ -84.909052, 32.263540 ], [ -84.921650, 32.233306 ], [ -84.923638, 32.231539 ], [ -84.964828, 32.194952 ], [ -84.995929, 32.184852 ], [ -85.047865, 32.142033 ], [ -85.056029, 32.063055 ], [ -85.050212, 32.024196 ], [ -85.062246, 31.991857 ], [ -85.072330, 31.964758 ], [ -85.082130, 31.944658 ], [ -85.106630, 31.915159 ], [ -85.132931, 31.888260 ], [ -85.141831, 31.839861 ], [ -85.141331, 31.783163 ], [ -85.138668, 31.780425 ], [ -85.130731, 31.772263 ], [ -85.125230, 31.767063 ], [ -85.124501, 31.763081 ], [ -85.118930, 31.732664 ], [ -85.122230, 31.722764 ], [ -85.126530, 31.716764 ], [ -85.125530, 31.694965 ], [ -85.087029, 31.640966 ], [ -85.065236, 31.624351 ], [ -85.059534, 31.621717 ], [ -85.057473, 31.618624 ], [ -85.041305, 31.540987 ], [ -85.046859, 31.517451 ], [ -85.068065, 31.427586 ], [ -85.087651, 31.308677 ], [ -85.101561, 31.283362 ], [ -85.111871, 31.258388 ], [ -85.107516, 31.186451 ], [ -85.100207, 31.165490 ], [ -85.092106, 31.160293 ], [ -85.083582, 31.159630 ], [ -85.076628, 31.156927 ], [ -85.035615, 31.108192 ], [ -85.029736, 31.096163 ], [ -85.022121, 31.075480 ], [ -84.999428, 31.013843 ], [ -85.002368, 31.000682 ], [ -85.024108, 31.000681 ], [ -85.027512, 31.000670 ], [ -85.030107, 31.000653 ], [ -85.031155, 31.000647 ], [ -85.052088, 31.000585 ], [ -85.054802, 31.000585 ], [ -85.057534, 31.000585 ], [ -85.145835, 31.000695 ], [ -85.152085, 31.000888 ], [ -85.152218, 31.000834 ], [ -85.154452, 31.000835 ], [ -85.488298, 30.997041 ], [ -85.497992, 30.996931 ], [ -85.498272, 30.996928 ], [ -86.035039, 30.993320 ], [ -86.052462, 30.993247 ], [ -86.056213, 30.993133 ], [ -86.162886, 30.993682 ], [ -86.168979, 30.993706 ], [ -86.175204, 30.993798 ], [ -86.180232, 30.994005 ], [ -86.187246, 30.993992 ], [ -86.289247, 30.993798 ], [ -86.304596, 30.994029 ], [ -86.364907, 30.994455 ], [ -86.369270, 30.994477 ], [ -86.374545, 30.994474 ], [ -86.388646, 30.994181 ], [ -86.388647, 30.994181 ], [ -86.391937, 30.994172 ], [ -86.404912, 30.994049 ], [ -86.454704, 30.993791 ], [ -86.458319, 30.993998 ], [ -86.512834, 30.993700 ], [ -86.519938, 30.993245 ], [ -86.563436, 30.995223 ], [ -86.567586, 30.995109 ], [ -86.664681, 30.994534 ], [ -86.678383, 30.994537 ], [ -86.688294, 30.995029 ], [ -86.725379, 30.996872 ], [ -86.727293, 30.996882 ], [ -86.728392, 30.996739 ], [ -86.785692, 30.996977 ], [ -86.785918, 30.996978 ], [ -86.830497, 30.997401 ], [ -86.831934, 30.997378 ], [ -86.872989, 30.997631 ], [ -86.888135, 30.997577 ], [ -87.027107, 30.999255 ], [ -87.036366, 30.999348 ], [ -87.039989, 30.999594 ], [ -87.053737, 30.999131 ], [ -87.064063, 30.999191 ], [ -87.068633, 30.999143 ], [ -87.162614, 30.999055 ], [ -87.163084, 30.999051 ], [ -87.254980, 30.998285 ], [ -87.255592, 30.998216 ], [ -87.257002, 30.998194 ], [ -87.257960, 30.998263 ], [ -87.259689, 30.998172 ], [ -87.260540, 30.998195 ], [ -87.265564, 30.998267 ], [ -87.288905, 30.998345 ], [ -87.290995, 30.998352 ], [ -87.301567, 30.998434 ], [ -87.304030, 30.998191 ], [ -87.312183, 30.998435 ], [ -87.333973, 30.998272 ], [ -87.355656, 30.998244 ], [ -87.364011, 30.998218 ], [ -87.367842, 30.998292 ], [ -87.425774, 30.998090 ], [ -87.432292, 30.998205 ], [ -87.449811, 30.998272 ], [ -87.455705, 30.998318 ], [ -87.458658, 30.998386 ], [ -87.461638, 30.998202 ], [ -87.461783, 30.998201 ], [ -87.466827, 30.998178 ], [ -87.466879, 30.998178 ], [ -87.478706, 30.998213 ], [ -87.479703, 30.998197 ], [ -87.480243, 30.998202 ], [ -87.548543, 30.997927 ], [ -87.571281, 30.997870 ], [ -87.598928, 30.997457 ], [ -87.598927, 30.997454 ], [ -87.594111, 30.976335 ], [ -87.601355, 30.936294 ], [ -87.622203, 30.897508 ], [ -87.634938, 30.865886 ], [ -87.624137, 30.845713 ], [ -87.532607, 30.743489 ], [ -87.502926, 30.722369 ], [ -87.497515, 30.720123 ], [ -87.481225, 30.716508 ], [ -87.449362, 30.698913 ], [ -87.407118, 30.671796 ], [ -87.396997, 30.653640 ], [ -87.394219, 30.641699 ], [ -87.394479, 30.625192 ], [ -87.449921, 30.514690 ], [ -87.449841, 30.514369 ], [ -87.448332, 30.513063 ], [ -87.430578, 30.491096 ], [ -87.419177, 30.410198 ], [ -87.427478, 30.408398 ], [ -87.440678, 30.391498 ], [ -87.451378, 30.367199 ], [ -87.450962, 30.346262 ], [ -87.450078, 30.311100 ], [ -87.452378, 30.300201 ], [ -87.518324, 30.280435 ], [ -87.544533, 30.275659 ], [ -87.558097, 30.274437 ], [ -87.581362, 30.269257 ], [ -87.656888, 30.249709 ], [ -87.735530, 30.240679 ], [ -87.800560, 30.229365 ], [ -87.838462, 30.227185 ], [ -87.926119, 30.230373 ], [ -87.962253, 30.229522 ], [ -87.999996, 30.225753 ], [ -88.014572, 30.222366 ], [ -88.028401, 30.221132 ], [ -88.029272, 30.222714 ], [ -88.023991, 30.230390 ], [ -87.966847, 30.235618 ], [ -87.948979, 30.256564 ], [ -87.936041, 30.261469 ], [ -87.918247, 30.253308 ], [ -87.913762, 30.247837 ], [ -87.900460, 30.241531 ], [ -87.893201, 30.239237 ], [ -87.879343, 30.238590 ], [ -87.860085, 30.240289 ], [ -87.817743, 30.254292 ], [ -87.802087, 30.253054 ], [ -87.787750, 30.254244 ], [ -87.766626, 30.262353 ], [ -87.755263, 30.277292 ], [ -87.755516, 30.291217 ], [ -87.772758, 30.311701 ], [ -87.796717, 30.324198 ], [ -87.809266, 30.332702 ], [ -87.829880, 30.353809 ], [ -87.837239, 30.369324 ], [ -87.845132, 30.377446 ], [ -87.853806, 30.378481 ], [ -87.865017, 30.383450 ], [ -87.906343, 30.409380 ], [ -87.908908, 30.414240 ], [ -87.914136, 30.446144 ], [ -87.920031, 30.470645 ], [ -87.924211, 30.476100 ], [ -87.931902, 30.481100 ], [ -87.933355, 30.487357 ], [ -87.911141, 30.525848 ], [ -87.905343, 30.537566 ], [ -87.901711, 30.550879 ], [ -87.904168, 30.565985 ], [ -87.907891, 30.573114 ], [ -87.911431, 30.576261 ], [ -87.914956, 30.585893 ], [ -87.912530, 30.615795 ], [ -87.919346, 30.636060 ], [ -87.931070, 30.652694 ], [ -87.936717, 30.657432 ], [ -87.955989, 30.658862 ], [ -87.981196, 30.675090 ], [ -88.008396, 30.684956 ], [ -88.012444, 30.683190 ], [ -88.022076, 30.673873 ], [ -88.026706, 30.661490 ], [ -88.034588, 30.653715 ], [ -88.044339, 30.652568 ], [ -88.061998, 30.644891 ], [ -88.059598, 30.619091 ], [ -88.053998, 30.612491 ], [ -88.064898, 30.588292 ], [ -88.074898, 30.578892 ], [ -88.085493, 30.563258 ], [ -88.081617, 30.546317 ], [ -88.082792, 30.528713 ], [ -88.090734, 30.523570 ], [ -88.100874, 30.509750 ], [ -88.103768, 30.500903 ], [ -88.102988, 30.493029 ], [ -88.096867, 30.471053 ], [ -88.100646, 30.461220 ], [ -88.106437, 30.452738 ], [ -88.104070, 30.427300 ], [ -88.107274, 30.377246 ], [ -88.115432, 30.356570 ], [ -88.124611, 30.341623 ], [ -88.128052, 30.338509 ], [ -88.136173, 30.320729 ], [ -88.155775, 30.327184 ], [ -88.171967, 30.324679 ], [ -88.191542, 30.317002 ], [ -88.195664, 30.321242 ], [ -88.198361, 30.338819 ], [ -88.196353, 30.343586 ], [ -88.188532, 30.345053 ], [ -88.188527, 30.348124 ], [ -88.200065, 30.362378 ], [ -88.204495, 30.362102 ], [ -88.260695, 30.382381 ], [ -88.282635, 30.382876 ], [ -88.290649, 30.370741 ], [ -88.311608, 30.368908 ], [ -88.316525, 30.369985 ], [ -88.319599, 30.380334 ], [ -88.332277, 30.388440 ], [ -88.341345, 30.389470 ], [ -88.364022, 30.388006 ], [ -88.374671, 30.385608 ], [ -88.395023, 30.369425 ], [ -88.402283, 30.510852 ], [ -88.403547, 30.533100 ], [ -88.403931, 30.543359 ], [ -88.404013, 30.545060 ], [ -88.407484, 30.622736 ], [ -88.407462, 30.631653 ], [ -88.408070, 30.636970 ], [ -88.409571, 30.668731 ], [ -88.411339, 30.706334 ], [ -88.411550, 30.712956 ], [ -88.412209, 30.730395 ], [ -88.412270, 30.731771 ], [ -88.412462, 30.735598 ], [ -88.425635, 30.998301 ], [ -88.425729, 31.000183 ], [ -88.425807, 31.001123 ], [ -88.432007, 31.114298 ], [ -88.438104, 31.230060 ], [ -88.438211, 31.231252 ], [ -88.445182, 31.355855 ], [ -88.445209, 31.355969 ], [ -88.448686, 31.420888 ], [ -88.448660, 31.421277 ], [ -88.449446, 31.435837 ], [ -88.459478, 31.621652 ], [ -88.459722, 31.624002 ], [ -88.464425, 31.697881 ], [ -88.464428, 31.697952 ], [ -88.471106, 31.850949 ], [ -88.471214, 31.851385 ], [ -88.469960, 31.893759 ], [ -88.468879, 31.930262 ], [ -88.468660, 31.933173 ], [ -88.455039, 32.039719 ], [ -88.454959, 32.040576 ], [ -88.438710, 32.172078 ], [ -88.438650, 32.172806 ], [ -88.431707, 32.227662 ], [ -88.421453, 32.308680 ], [ -88.403789, 32.449770 ], [ -88.403789, 32.449885 ], [ -88.388739, 32.578116 ], [ -88.383039, 32.626679 ], [ -88.382985, 32.626954 ], [ -88.347692, 32.929059 ], [ -88.340432, 32.991199 ], [ -88.304514, 33.288320 ], [ -88.291127, 33.399061 ], [ -88.277421, 33.512436 ], [ -88.276805, 33.516463 ], [ -88.274619, 33.534008 ], [ -88.270050, 33.570819 ], [ -88.269532, 33.572894 ], [ -88.269076, 33.576929 ], [ -88.268160, 33.585040 ], [ -88.267148, 33.591989 ], [ -88.267005, 33.594229 ], [ -88.256343, 33.682053 ], [ -88.256131, 33.682860 ], [ -88.254622, 33.695780 ], [ -88.254445, 33.698779 ], [ -88.248390, 33.744908 ], [ -88.226517, 33.911551 ], [ -88.226517, 33.911665 ], [ -88.226428, 33.912875 ], [ -88.207229, 34.058333 ], [ -88.203597, 34.086530 ], [ -88.176889, 34.293858 ], [ -88.175867, 34.302171 ], [ -88.173632, 34.321054 ], [ -88.165910, 34.380926 ], [ -88.165634, 34.383102 ], [ -88.155305, 34.463087 ], [ -88.139988, 34.581703 ], [ -88.139246, 34.587795 ], [ -88.138719, 34.589215 ], [ -88.118407, 34.724292 ], [ -88.097888, 34.892202 ], [ -88.125038, 34.902227 ], [ -88.200064, 34.995634 ], [ -88.182450, 35.007712 ], [ -87.984916, 35.006256 ], [ -87.877969, 35.005468 ], [ -87.877742, 35.005512 ], [ -87.872626, 35.005571 ], [ -87.853528, 35.005541 ], [ -87.853411, 35.005576 ], [ -87.851886, 35.005656 ], [ -87.773586, 35.004946 ], [ -87.767602, 35.004783 ], [ -87.758890, 35.004711 ], [ -87.709491, 35.004089 ], [ -87.702321, 35.003945 ], [ -87.700543, 35.003988 ], [ -87.696834, 35.003852 ], [ -87.671405, 35.003537 ], [ -87.664123, 35.003523 ], [ -87.606031, 35.003343 ], [ -87.428613, 35.002795 ], [ -87.421543, 35.002679 ], [ -87.417400, 35.002669 ], [ -87.391314, 35.002374 ], [ -87.381071, 35.002118 ], [ -87.359281, 35.001823 ], [ -87.349251, 35.001662 ], [ -87.299185, 35.000915 ], [ -87.270014, 35.000390 ], [ -87.230544, 34.999484 ], [ -87.224053, 34.999327 ], [ -87.216683, 34.999148 ], [ -87.210759, 34.999024 ], [ -87.011174, 34.995162 ], [ -87.000007, 34.995121 ], [ -86.974412, 34.994513 ], [ -86.972613, 34.994610 ], [ -86.970236, 34.994546 ], [ -86.967120, 34.994400 ], [ -86.862147, 34.991956 ], [ -86.849794, 34.991924 ], [ -86.846466, 34.991860 ], [ -86.836370, 34.991764 ], [ -86.836306, 34.991764 ], [ -86.820657, 34.991764 ], [ -86.783648, 34.991925 ], [ -86.783628, 34.991925 ] ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US02", "STATE": 26, "name": "Alaska", "LSAD": "", "CENSUSAREA": 570640.950000 }, "geometry": { "type": "MultiPolygon", "coordinates": [ [ [ [ -162.255031, 54.978353 ], [ -162.249682, 54.975900 ], [ -162.235675, 54.962601 ], [ -162.232962, 54.890984 ], [ -162.236806, 54.881630 ], [ -162.275316, 54.845565 ], [ -162.282944, 54.841216 ], [ -162.300580, 54.832594 ], [ -162.321094, 54.827928 ], [ -162.349315, 54.836049 ], [ -162.417370, 54.877491 ], [ -162.425244, 54.885021 ], [ -162.437501, 54.927627 ], [ -162.435473, 54.929249 ], [ -162.337431, 54.981636 ], [ -162.326811, 54.985330 ], [ -162.266743, 54.982133 ], [ -162.255031, 54.978353 ] ] ], [ [ [ -159.324364, 54.928329 ], [ -159.317681, 54.933707 ], [ -159.278696, 54.948514 ], [ -159.205670, 54.927438 ], [ -159.202857, 54.925500 ], [ -159.203228, 54.914842 ], [ -159.212627, 54.896066 ], [ -159.236066, 54.876480 ], [ -159.272354, 54.864204 ], [ -159.305864, 54.863698 ], [ -159.309681, 54.865813 ], [ -159.327873, 54.884749 ], [ -159.320732, 54.897269 ], [ -159.313528, 54.903388 ], [ -159.312060, 54.909601 ], [ -159.312733, 54.918686 ], [ -159.324364, 54.928329 ] ] ], [ [ [ -160.017900, 55.156130 ], [ -160.047358, 55.180879 ], [ -160.061469, 55.200378 ], [ -160.052941, 55.203035 ], [ -160.025257, 55.203914 ], [ -160.002155, 55.194480 ], [ -159.994027, 55.185247 ], [ -159.983499, 55.180379 ], [ -159.954350, 55.189291 ], [ -159.931240, 55.220060 ], [ -159.889174, 55.287138 ], [ -159.879690, 55.290183 ], [ -159.870591, 55.284889 ], [ -159.848619, 55.267548 ], [ -159.843859, 55.249367 ], [ -159.844622, 55.243828 ], [ -159.855302, 55.230378 ], [ -159.860991, 55.227884 ], [ -159.866624, 55.231202 ], [ -159.886523, 55.229149 ], [ -159.895326, 55.217872 ], [ -159.905365, 55.164689 ], [ -159.901569, 55.156858 ], [ -159.884997, 55.145598 ], [ -159.860891, 55.149337 ], [ -159.859568, 55.164912 ], [ -159.861308, 55.171748 ], [ -159.860786, 55.177086 ], [ -159.846264, 55.180834 ], [ -159.816419, 55.178051 ], [ -159.823710, 55.144130 ], [ -159.830890, 55.126467 ], [ -159.855444, 55.100758 ], [ -159.868580, 55.094888 ], [ -159.886109, 55.102558 ], [ -159.886476, 55.107087 ], [ -159.906609, 55.112544 ], [ -159.947575, 55.105215 ], [ -159.951281, 55.100644 ], [ -159.945410, 55.087939 ], [ -159.951127, 55.066642 ], [ -160.052093, 55.005777 ], [ -160.080659, 54.994425 ], [ -160.115775, 54.985078 ], [ -160.183466, 54.915680 ], [ -160.181636, 54.902992 ], [ -160.200831, 54.875282 ], [ -160.226967, 54.864075 ], [ -160.254765, 54.895974 ], [ -160.250814, 54.929816 ], [ -160.244253, 54.933532 ], [ -160.223411, 54.939124 ], [ -160.177607, 54.981446 ], [ -160.132168, 55.013743 ], [ -160.106837, 55.027002 ], [ -160.082168, 55.033578 ], [ -160.077872, 55.037600 ], [ -160.087574, 55.049967 ], [ -160.094288, 55.052996 ], [ -160.133416, 55.043947 ], [ -160.174366, 55.052577 ], [ -160.191392, 55.108574 ], [ -160.187261, 55.118376 ], [ -160.109864, 55.160777 ], [ -160.077308, 55.146495 ], [ -160.059599, 55.133663 ], [ -160.052545, 55.121716 ], [ -160.052820, 55.119373 ], [ -160.057033, 55.118488 ], [ -160.057797, 55.115353 ], [ -160.055642, 55.111580 ], [ -160.030330, 55.116109 ], [ -160.012220, 55.122946 ], [ -160.005170, 55.129378 ], [ -160.004129, 55.134482 ], [ -160.017900, 55.156130 ] ] ], [ [ [ -159.455311, 55.061452 ], [ -159.448473, 55.064343 ], [ -159.381841, 55.064032 ], [ -159.345276, 55.059397 ], [ -159.338470, 55.046683 ], [ -159.328791, 54.980598 ], [ -159.330164, 54.976378 ], [ -159.331770, 54.974598 ], [ -159.426615, 54.942266 ], [ -159.447982, 54.941374 ], [ -159.457995, 54.945730 ], [ -159.459551, 54.948652 ], [ -159.451251, 54.975285 ], [ -159.440057, 54.988502 ], [ -159.416786, 55.000296 ], [ -159.417987, 55.022013 ], [ -159.455434, 55.035809 ], [ -159.455311, 55.061452 ] ] ], [ [ [ -159.533457, 55.184761 ], [ -159.504325, 55.176822 ], [ -159.499502, 55.173991 ], [ -159.493398, 55.155055 ], [ -159.494772, 55.136050 ], [ -159.503592, 55.131373 ], [ -159.509361, 55.130206 ], [ -159.530302, 55.106194 ], [ -159.533630, 55.083987 ], [ -159.524444, 55.077358 ], [ -159.484200, 55.057695 ], [ -159.484980, 55.054050 ], [ -159.489589, 55.049229 ], [ -159.509674, 55.041408 ], [ -159.517824, 55.044735 ], [ -159.535465, 55.058735 ], [ -159.572365, 55.060122 ], [ -159.597824, 55.047000 ], [ -159.635226, 55.037294 ], [ -159.638905, 55.038745 ], [ -159.644029, 55.042597 ], [ -159.649062, 55.049532 ], [ -159.650859, 55.065790 ], [ -159.635410, 55.116654 ], [ -159.616961, 55.127666 ], [ -159.586075, 55.157652 ], [ -159.573144, 55.187562 ], [ -159.521096, 55.253393 ], [ -159.519196, 55.253693 ], [ -159.503196, 55.234993 ], [ -159.505270, 55.222269 ], [ -159.512350, 55.208353 ], [ -159.533457, 55.184761 ] ] ], [ [ [ -161.718614, 55.154166 ], [ -161.697097, 55.137133 ], [ -161.678389, 55.131747 ], [ -161.663618, 55.130260 ], [ -161.651563, 55.130916 ], [ -161.608634, 55.116906 ], [ -161.576643, 55.103831 ], [ -161.570523, 55.100493 ], [ -161.549901, 55.082564 ], [ -161.548924, 55.080115 ], [ -161.550357, 55.065734 ], [ -161.557315, 55.061193 ], [ -161.565036, 55.058874 ], [ -161.582584, 55.058224 ], [ -161.591069, 55.060818 ], [ -161.606359, 55.070264 ], [ -161.606482, 55.074208 ], [ -161.598303, 55.081341 ], [ -161.596951, 55.086584 ], [ -161.602514, 55.098267 ], [ -161.615867, 55.104388 ], [ -161.632391, 55.104896 ], [ -161.654918, 55.103244 ], [ -161.674539, 55.095912 ], [ -161.678537, 55.092829 ], [ -161.678171, 55.087741 ], [ -161.690346, 55.078500 ], [ -161.737922, 55.054054 ], [ -161.764169, 55.059509 ], [ -161.791606, 55.077307 ], [ -161.814984, 55.098639 ], [ -161.816482, 55.111319 ], [ -161.819869, 55.113965 ], [ -161.851152, 55.126378 ], [ -161.862504, 55.127598 ], [ -161.886278, 55.126933 ], [ -161.897846, 55.135768 ], [ -161.900685, 55.142139 ], [ -161.888936, 55.160724 ], [ -161.850057, 55.175260 ], [ -161.827840, 55.178473 ], [ -161.737810, 55.161935 ], [ -161.718614, 55.154166 ] ] ], [ [ [ -160.506927, 55.327730 ], [ -160.528864, 55.343501 ], [ -160.534943, 55.343537 ], [ -160.564427, 55.332504 ], [ -160.579690, 55.314292 ], [ -160.580668, 55.307196 ], [ -160.580088, 55.302503 ], [ -160.565929, 55.273137 ], [ -160.550759, 55.264302 ], [ -160.527617, 55.256374 ], [ -160.486174, 55.193617 ], [ -160.486511, 55.181951 ], [ -160.496306, 55.166399 ], [ -160.525226, 55.129871 ], [ -160.655577, 55.160261 ], [ -160.675871, 55.173622 ], [ -160.688372, 55.195588 ], [ -160.690293, 55.210474 ], [ -160.756587, 55.195143 ], [ -160.767393, 55.185399 ], [ -160.765229, 55.176716 ], [ -160.794198, 55.134399 ], [ -160.806009, 55.125670 ], [ -160.821381, 55.117851 ], [ -160.824468, 55.120153 ], [ -160.815862, 55.141556 ], [ -160.807468, 55.155579 ], [ -160.807558, 55.168161 ], [ -160.819487, 55.187457 ], [ -160.841917, 55.204440 ], [ -160.841221, 55.293957 ], [ -160.856621, 55.318488 ], [ -160.840251, 55.339777 ], [ -160.797147, 55.381521 ], [ -160.777800, 55.388639 ], [ -160.710298, 55.403075 ], [ -160.687442, 55.402198 ], [ -160.665927, 55.399025 ], [ -160.649234, 55.388780 ], [ -160.646214, 55.383142 ], [ -160.646156, 55.357689 ], [ -160.651011, 55.343650 ], [ -160.614256, 55.348019 ], [ -160.572716, 55.388978 ], [ -160.567384, 55.390078 ], [ -160.545227, 55.387911 ], [ -160.517513, 55.379378 ], [ -160.522063, 55.374369 ], [ -160.522399, 55.370371 ], [ -160.522307, 55.364367 ], [ -160.518955, 55.361552 ], [ -160.425658, 55.338883 ], [ -160.408614, 55.341677 ], [ -160.403350, 55.346299 ], [ -160.361758, 55.363230 ], [ -160.344369, 55.362962 ], [ -160.333692, 55.360139 ], [ -160.326463, 55.353189 ], [ -160.317665, 55.338533 ], [ -160.306550, 55.303275 ], [ -160.330722, 55.261045 ], [ -160.341217, 55.251799 ], [ -160.372603, 55.259910 ], [ -160.378887, 55.266692 ], [ -160.380472, 55.272803 ], [ -160.390421, 55.286576 ], [ -160.441896, 55.298264 ], [ -160.449799, 55.297081 ], [ -160.457765, 55.291893 ], [ -160.468262, 55.288925 ], [ -160.475493, 55.289230 ], [ -160.481536, 55.291779 ], [ -160.518148, 55.309102 ], [ -160.526945, 55.319044 ], [ -160.506927, 55.327730 ] ] ], [ [ [ -160.211780, 55.455862 ], [ -160.137032, 55.450709 ], [ -160.141834, 55.387154 ], [ -160.142505, 55.383491 ], [ -160.147993, 55.377576 ], [ -160.154038, 55.377518 ], [ -160.203610, 55.391739 ], [ -160.279970, 55.395905 ], [ -160.308921, 55.393174 ], [ -160.321132, 55.393677 ], [ -160.339858, 55.409692 ], [ -160.349526, 55.420477 ], [ -160.347609, 55.426187 ], [ -160.323237, 55.444633 ], [ -160.266834, 55.462789 ], [ -160.260565, 55.463674 ], [ -160.227504, 55.460340 ], [ -160.211780, 55.455862 ] ] ], [ [ [ -165.790523, 54.171758 ], [ -165.747893, 54.161297 ], [ -165.742613, 54.158352 ], [ -165.732602, 54.148121 ], [ -165.714198, 54.120815 ], [ -165.667323, 54.132123 ], [ -165.661379, 54.130935 ], [ -165.655573, 54.119100 ], [ -165.671477, 54.096235 ], [ -165.767173, 54.065935 ], [ -165.810747, 54.074764 ], [ -165.875129, 54.036420 ], [ -165.896308, 54.055714 ], [ -165.897261, 54.060634 ], [ -165.901649, 54.062870 ], [ -165.916235, 54.065708 ], [ -165.930242, 54.066554 ], [ -165.984415, 54.061722 ], [ -166.019861, 54.051441 ], [ -166.027733, 54.045917 ], [ -166.046438, 54.044186 ], [ -166.098255, 54.103538 ], [ -166.112242, 54.122528 ], [ -166.101402, 54.144148 ], [ -166.082028, 54.175184 ], [ -166.002465, 54.213629 ], [ -165.983200, 54.221175 ], [ -165.944630, 54.220855 ], [ -165.873076, 54.216455 ], [ -165.868192, 54.214884 ], [ -165.865140, 54.212160 ], [ -165.865872, 54.200014 ], [ -165.871973, 54.189783 ], [ -165.880456, 54.183648 ], [ -165.868076, 54.168731 ], [ -165.863518, 54.166162 ], [ -165.837274, 54.161028 ], [ -165.832421, 54.161333 ], [ -165.825159, 54.164499 ], [ -165.797147, 54.183246 ], [ -165.793781, 54.183433 ], [ -165.792569, 54.181605 ], [ -165.790523, 54.171758 ] ] ], [ [ [ -165.271048, 54.095665 ], [ -165.267012, 54.095467 ], [ -165.234364, 54.065423 ], [ -165.235149, 54.062767 ], [ -165.245830, 54.056110 ], [ -165.324415, 54.063907 ], [ -165.336836, 54.070126 ], [ -165.365768, 54.073317 ], [ -165.458179, 54.066313 ], [ -165.482747, 54.072218 ], [ -165.483373, 54.075036 ], [ -165.468221, 54.079641 ], [ -165.438972, 54.084136 ], [ -165.322268, 54.094634 ], [ -165.271048, 54.095665 ] ] ], [ [ [ -164.976199, 54.134595 ], [ -164.937766, 54.136682 ], [ -164.921307, 54.128569 ], [ -164.919689, 54.116080 ], [ -164.921464, 54.111083 ], [ -164.953165, 54.078056 ], [ -164.960581, 54.076026 ], [ -165.044322, 54.066629 ], [ -165.203413, 54.087752 ], [ -165.212264, 54.090158 ], [ -165.220871, 54.101574 ], [ -165.198746, 54.116474 ], [ -165.140978, 54.131079 ], [ -165.088486, 54.128005 ], [ -165.067428, 54.123174 ], [ -165.050155, 54.121708 ], [ -165.023065, 54.121919 ], [ -165.007910, 54.134934 ], [ -164.976199, 54.134595 ] ] ], [ [ [ -165.523466, 54.299895 ], [ -165.502775, 54.299469 ], [ -165.478452, 54.295333 ], [ -165.477750, 54.283707 ], [ -165.479981, 54.281838 ], [ -165.513700, 54.274086 ], [ -165.557581, 54.254138 ], [ -165.558835, 54.250763 ], [ -165.557950, 54.246826 ], [ -165.553251, 54.239601 ], [ -165.512782, 54.212929 ], [ -165.496279, 54.210938 ], [ -165.478816, 54.213310 ], [ -165.405377, 54.212837 ], [ -165.391441, 54.204253 ], [ -165.383719, 54.196731 ], [ -165.399985, 54.177741 ], [ -165.412925, 54.179221 ], [ -165.422356, 54.182799 ], [ -165.476190, 54.182701 ], [ -165.481317, 54.179962 ], [ -165.536004, 54.129606 ], [ -165.549217, 54.112196 ], [ -165.565422, 54.108122 ], [ -165.575645, 54.108618 ], [ -165.613214, 54.120908 ], [ -165.629725, 54.132558 ], [ -165.637081, 54.199436 ], [ -165.621854, 54.208105 ], [ -165.593656, 54.218375 ], [ -165.585782, 54.223067 ], [ -165.579801, 54.229575 ], [ -165.587157, 54.238166 ], [ -165.595732, 54.242713 ], [ -165.612082, 54.246537 ], [ -165.615629, 54.244834 ], [ -165.625609, 54.233756 ], [ -165.640013, 54.229673 ], [ -165.669383, 54.229036 ], [ -165.681458, 54.236914 ], [ -165.685823, 54.243406 ], [ -165.684114, 54.249907 ], [ -165.675447, 54.264639 ], [ -165.636383, 54.297567 ], [ -165.625550, 54.298964 ], [ -165.615570, 54.297445 ], [ -165.605225, 54.294219 ], [ -165.586509, 54.284361 ], [ -165.523466, 54.299895 ] ] ], [ [ [ -162.801865, 54.489440 ], [ -162.796290, 54.492254 ], [ -162.728415, 54.475354 ], [ -162.588883, 54.450064 ], [ -162.556667, 54.424621 ], [ -162.552718, 54.416113 ], [ -162.551618, 54.392217 ], [ -162.562726, 54.382840 ], [ -162.611891, 54.368077 ], [ -162.722797, 54.400340 ], [ -162.760396, 54.373254 ], [ -162.759472, 54.371116 ], [ -162.781239, 54.375085 ], [ -162.860050, 54.425452 ], [ -162.827621, 54.490859 ], [ -162.801865, 54.489440 ] ] ], [ [ [ -173.116905, 60.516005 ], [ -173.098092, 60.533367 ], [ -173.098094, 60.573993 ], [ -173.041847, 60.611497 ], [ -172.999659, 60.611498 ], [ -172.971530, 60.605249 ], [ -172.915274, 60.527122 ], [ -172.915273, 60.514621 ], [ -172.895349, 60.499750 ], [ -172.715261, 60.429864 ], [ -172.706472, 60.425179 ], [ -172.480536, 60.400184 ], [ -172.352622, 60.381435 ], [ -172.341399, 60.373145 ], [ -172.333051, 60.364359 ], [ -172.269754, 60.333887 ], [ -172.254821, 60.334082 ], [ -172.254821, 60.326466 ], [ -172.291289, 60.321193 ], [ -172.435476, 60.332653 ], [ -172.491531, 60.334874 ], [ -172.505544, 60.330428 ], [ -172.519558, 60.323758 ], [ -172.547585, 60.317088 ], [ -172.589625, 60.314863 ], [ -172.612982, 60.319309 ], [ -172.622325, 60.330424 ], [ -172.757794, 60.374881 ], [ -172.811529, 60.406621 ], [ -172.951477, 60.478649 ], [ -172.959056, 60.479695 ], [ -172.966515, 60.478167 ], [ -172.990296, 60.478702 ], [ -173.119005, 60.500067 ], [ -173.120769, 60.513010 ], [ -173.116905, 60.516005 ] ] ], [ [ [ -165.721389, 60.169620 ], [ -165.723168, 60.156603 ], [ -165.719120, 60.153521 ], [ -165.702411, 60.151285 ], [ -165.697273, 60.153592 ], [ -165.683507, 60.154221 ], [ -165.675374, 60.149360 ], [ -165.667863, 60.114676 ], [ -165.671567, 60.096877 ], [ -165.680612, 60.089962 ], [ -165.684585, 60.055237 ], [ -165.649318, 59.991837 ], [ -165.588873, 59.966005 ], [ -165.539367, 59.965175 ], [ -165.534482, 59.951276 ], [ -165.543456, 59.930376 ], [ -165.550405, 59.920007 ], [ -165.575815, 59.904672 ], [ -165.695981, 59.893513 ], [ -165.712875, 59.895364 ], [ -165.717549, 59.899137 ], [ -165.722458, 59.899813 ], [ -165.751851, 59.899947 ], [ -165.905471, 59.871937 ], [ -166.010201, 59.847061 ], [ -166.060952, 59.820508 ], [ -166.072465, 59.805462 ], [ -166.058096, 59.787110 ], [ -166.042089, 59.776212 ], [ -166.032277, 59.773729 ], [ -166.030813, 59.770600 ], [ -166.036947, 59.757859 ], [ -166.062854, 59.748586 ], [ -166.157071, 59.748886 ], [ -166.180920, 59.763728 ], [ -166.176669, 59.766495 ], [ -166.174820, 59.770681 ], [ -166.184234, 59.779432 ], [ -166.203293, 59.791676 ], [ -166.251528, 59.809807 ], [ -166.381986, 59.849087 ], [ -166.407290, 59.854604 ], [ -166.439746, 59.857816 ], [ -166.512223, 59.849939 ], [ -166.583297, 59.848705 ], [ -166.616849, 59.850711 ], [ -166.621473, 59.856438 ], [ -166.648076, 59.871100 ], [ -166.678200, 59.881248 ], [ -166.716563, 59.889011 ], [ -166.764183, 59.892061 ], [ -166.801634, 59.916321 ], [ -166.866530, 59.949544 ], [ -166.892330, 59.960507 ], [ -166.995748, 59.993495 ], [ -167.067602, 59.992295 ], [ -167.111785, 59.989349 ], [ -167.124867, 59.991700 ], [ -167.133258, 59.994695 ], [ -167.220210, 60.040133 ], [ -167.247627, 60.058862 ], [ -167.281357, 60.063892 ], [ -167.310664, 60.064874 ], [ -167.339109, 60.070159 ], [ -167.342702, 60.072395 ], [ -167.342885, 60.074979 ], [ -167.334050, 60.088609 ], [ -167.333860, 60.094065 ], [ -167.343303, 60.123181 ], [ -167.347866, 60.131140 ], [ -167.362783, 60.147556 ], [ -167.423053, 60.195072 ], [ -167.421489, 60.205431 ], [ -167.369927, 60.225496 ], [ -167.312616, 60.238454 ], [ -167.201940, 60.237822 ], [ -167.105975, 60.232895 ], [ -167.081935, 60.225765 ], [ -167.045820, 60.219088 ], [ -166.937970, 60.205870 ], [ -166.909802, 60.206513 ], [ -166.847438, 60.213592 ], [ -166.812484, 60.227780 ], [ -166.803469, 60.242802 ], [ -166.809546, 60.259658 ], [ -166.826169, 60.268644 ], [ -166.834966, 60.271406 ], [ -166.832877, 60.275449 ], [ -166.814979, 60.286283 ], [ -166.762522, 60.309837 ], [ -166.738323, 60.314301 ], [ -166.662112, 60.322993 ], [ -166.608896, 60.321250 ], [ -166.578305, 60.321850 ], [ -166.569828, 60.325955 ], [ -166.562081, 60.359022 ], [ -166.493543, 60.392389 ], [ -166.414570, 60.371870 ], [ -166.408546, 60.365899 ], [ -166.387184, 60.359671 ], [ -166.366596, 60.358227 ], [ -166.310655, 60.377611 ], [ -166.200019, 60.393404 ], [ -166.174906, 60.401003 ], [ -166.171187, 60.428854 ], [ -166.163203, 60.432641 ], [ -166.135704, 60.424510 ], [ -166.124379, 60.414253 ], [ -166.124231, 60.409953 ], [ -166.134927, 60.400129 ], [ -166.123805, 60.378116 ], [ -166.084791, 60.325288 ], [ -166.012169, 60.317691 ], [ -165.987336, 60.317833 ], [ -165.927956, 60.321592 ], [ -165.924640, 60.325249 ], [ -165.923572, 60.330503 ], [ -165.920794, 60.335398 ], [ -165.916828, 60.338002 ], [ -165.883458, 60.343902 ], [ -165.786573, 60.326821 ], [ -165.714510, 60.310496 ], [ -165.697326, 60.297238 ], [ -165.685751, 60.277564 ], [ -165.686143, 60.267811 ], [ -165.698339, 60.210676 ], [ -165.708863, 60.189125 ], [ -165.721389, 60.169620 ] ] ], [ [ [ -134.713987, 58.220748 ], [ -134.712801, 58.215369 ], [ -134.710513, 58.192557 ], [ -134.703727, 58.166794 ], [ -134.699956, 58.161494 ], [ -134.689515, 58.158825 ], [ -134.682812, 58.158843 ], [ -134.631434, 58.162198 ], [ -134.608911, 58.171637 ], [ -134.608358, 58.173472 ], [ -134.594804, 58.183511 ], [ -134.559241, 58.195121 ], [ -134.541609, 58.184327 ], [ -134.519644, 58.175771 ], [ -134.500740, 58.172546 ], [ -134.479810, 58.171199 ], [ -134.462633, 58.173851 ], [ -134.446657, 58.173583 ], [ -134.413953, 58.167546 ], [ -134.401512, 58.163427 ], [ -134.371445, 58.148966 ], [ -134.327360, 58.143880 ], [ -134.317037, 58.145440 ], [ -134.306483, 58.152490 ], [ -134.259705, 58.157712 ], [ -134.215981, 58.162128 ], [ -134.177467, 58.159640 ], [ -134.166332, 58.132558 ], [ -134.167257, 58.128577 ], [ -134.174352, 58.125284 ], [ -134.192724, 58.107685 ], [ -134.189370, 58.083444 ], [ -134.183983, 58.077295 ], [ -134.169743, 58.066845 ], [ -134.138231, 58.047103 ], [ -134.098652, 58.018748 ], [ -134.091885, 58.010777 ], [ -134.087461, 58.001685 ], [ -134.087572, 57.996475 ], [ -134.101549, 57.988716 ], [ -134.101125, 57.984070 ], [ -134.089575, 57.974357 ], [ -134.068949, 57.961083 ], [ -134.016873, 57.930006 ], [ -133.999948, 57.914810 ], [ -133.996340, 57.904167 ], [ -133.995977, 57.895632 ], [ -133.963791, 57.854628 ], [ -133.934735, 57.837626 ], [ -133.904874, 57.807406 ], [ -133.902695, 57.797797 ], [ -133.903854, 57.794818 ], [ -133.908085, 57.791670 ], [ -133.909890, 57.780628 ], [ -133.896846, 57.685524 ], [ -133.868134, 57.660137 ], [ -133.837424, 57.638486 ], [ -133.832895, 57.635733 ], [ -133.821673, 57.633887 ], [ -133.817662, 57.629764 ], [ -133.808285, 57.609604 ], [ -133.806003, 57.583457 ], [ -133.807133, 57.578770 ], [ -133.811640, 57.572365 ], [ -133.817600, 57.568353 ], [ -133.840838, 57.576865 ], [ -133.859635, 57.605325 ], [ -133.858010, 57.616940 ], [ -133.863112, 57.623701 ], [ -133.911329, 57.663562 ], [ -133.962582, 57.689887 ], [ -133.970087, 57.695342 ], [ -133.994964, 57.719821 ], [ -134.010728, 57.759392 ], [ -134.013144, 57.789393 ], [ -134.030820, 57.818646 ], [ -134.061833, 57.829808 ], [ -134.098628, 57.850550 ], [ -134.121337, 57.871236 ], [ -134.119210, 57.872917 ], [ -134.121904, 57.882520 ], [ -134.126105, 57.890260 ], [ -134.132146, 57.896189 ], [ -134.151127, 57.903209 ], [ -134.176606, 57.909725 ], [ -134.202353, 57.906330 ], [ -134.206874, 57.895901 ], [ -134.163120, 57.848669 ], [ -134.112948, 57.809263 ], [ -134.105408, 57.795974 ], [ -134.099782, 57.780261 ], [ -134.100899, 57.776779 ], [ -134.146342, 57.760258 ], [ -134.127700, 57.739216 ], [ -134.116097, 57.727582 ], [ -134.020169, 57.656734 ], [ -134.013367, 57.655898 ], [ -133.993974, 57.649095 ], [ -133.958454, 57.629537 ], [ -133.935976, 57.614414 ], [ -133.934361, 57.601765 ], [ -133.945156, 57.569841 ], [ -133.943417, 57.561555 ], [ -133.933216, 57.544450 ], [ -133.920557, 57.530088 ], [ -133.901074, 57.517219 ], [ -133.886269, 57.504999 ], [ -133.857368, 57.463964 ], [ -133.927539, 57.469570 ], [ -133.925527, 57.456650 ], [ -133.870327, 57.381298 ], [ -133.866931, 57.367869 ], [ -133.867279, 57.362060 ], [ -133.870657, 57.358287 ], [ -133.962897, 57.305425 ], [ -133.968495, 57.303937 ], [ -133.983501, 57.302838 ], [ -134.008394, 57.317522 ], [ -134.034563, 57.327638 ], [ -134.055618, 57.330194 ], [ -134.094891, 57.326401 ], [ -134.100587, 57.321738 ], [ -134.084374, 57.303963 ], [ -134.080495, 57.297678 ], [ -134.110315, 57.249948 ], [ -134.155390, 57.208003 ], [ -134.193629, 57.184879 ], [ -134.292760, 57.137049 ], [ -134.302721, 57.136562 ], [ -134.349602, 57.124638 ], [ -134.378359, 57.115016 ], [ -134.370797, 57.099924 ], [ -134.386052, 57.087392 ], [ -134.481167, 57.046006 ], [ -134.484288, 57.036481 ], [ -134.497718, 57.031194 ], [ -134.565687, 57.023737 ], [ -134.601407, 57.033812 ], [ -134.634565, 57.109863 ], [ -134.646773, 57.226327 ], [ -134.640169, 57.239852 ], [ -134.605032, 57.273000 ], [ -134.570954, 57.294624 ], [ -134.517279, 57.314567 ], [ -134.543385, 57.337414 ], [ -134.559794, 57.336138 ], [ -134.574114, 57.341172 ], [ -134.575492, 57.343694 ], [ -134.578511, 57.400291 ], [ -134.555540, 57.407428 ], [ -134.527594, 57.405331 ], [ -134.525997, 57.397845 ], [ -134.527759, 57.393940 ], [ -134.527873, 57.389874 ], [ -134.486023, 57.372492 ], [ -134.477240, 57.374401 ], [ -134.464032, 57.392184 ], [ -134.544853, 57.457872 ], [ -134.607557, 57.513042 ], [ -134.598452, 57.522395 ], [ -134.595981, 57.534107 ], [ -134.611177, 57.563137 ], [ -134.665337, 57.605701 ], [ -134.674438, 57.614409 ], [ -134.695428, 57.685335 ], [ -134.700518, 57.695966 ], [ -134.704859, 57.701457 ], [ -134.720351, 57.707052 ], [ -134.731798, 57.721921 ], [ -134.728792, 57.756640 ], [ -134.709024, 57.780498 ], [ -134.705869, 57.828929 ], [ -134.727077, 57.877098 ], [ -134.737475, 57.890790 ], [ -134.746108, 57.898529 ], [ -134.758833, 57.980212 ], [ -134.765290, 57.993762 ], [ -134.777022, 58.004679 ], [ -134.796804, 58.058855 ], [ -134.783772, 58.082292 ], [ -134.784927, 58.096793 ], [ -134.820663, 58.141465 ], [ -134.857221, 58.176288 ], [ -134.864299, 58.180489 ], [ -134.877918, 58.181535 ], [ -134.885857, 58.184031 ], [ -134.899665, 58.194320 ], [ -134.914857, 58.214932 ], [ -134.948327, 58.281316 ], [ -134.969189, 58.367542 ], [ -134.960502, 58.403758 ], [ -134.955902, 58.410297 ], [ -134.897292, 58.376890 ], [ -134.806116, 58.321284 ], [ -134.803831, 58.316567 ], [ -134.802388, 58.301070 ], [ -134.779354, 58.281279 ], [ -134.760052, 58.275251 ], [ -134.729861, 58.273512 ], [ -134.724463, 58.268277 ], [ -134.713987, 58.220748 ] ] ], [ [ [ -131.246018, 54.989555 ], [ -131.257421, 54.979010 ], [ -131.242771, 54.929639 ], [ -131.233001, 54.926814 ], [ -131.217805, 54.927423 ], [ -131.197924, 54.921489 ], [ -131.195197, 54.919767 ], [ -131.195411, 54.918249 ], [ -131.200161, 54.910169 ], [ -131.253671, 54.866779 ], [ -131.266049, 54.859369 ], [ -131.353233, 54.859009 ], [ -131.469097, 54.913153 ], [ -131.491504, 54.930392 ], [ -131.486616, 54.950394 ], [ -131.482676, 54.952659 ], [ -131.409738, 54.971152 ], [ -131.266084, 54.998806 ], [ -131.248909, 54.997190 ], [ -131.246018, 54.989555 ] ] ], [ [ [ -131.759896, 55.381845 ], [ -131.716140, 55.349570 ], [ -131.685192, 55.333501 ], [ -131.666738, 55.327492 ], [ -131.647236, 55.306140 ], [ -131.658130, 55.292512 ], [ -131.688644, 55.282113 ], [ -131.694487, 55.223739 ], [ -131.718468, 55.200099 ], [ -131.748334, 55.128588 ], [ -131.798943, 55.162351 ], [ -131.829585, 55.191916 ], [ -131.830718, 55.194991 ], [ -131.828395, 55.198482 ], [ -131.850839, 55.274364 ], [ -131.862162, 55.289284 ], [ -131.870568, 55.364553 ], [ -131.854297, 55.421074 ], [ -131.852330, 55.423782 ], [ -131.833218, 55.422014 ], [ -131.811697, 55.414048 ], [ -131.809721, 55.412555 ], [ -131.806790, 55.405175 ], [ -131.798555, 55.399386 ], [ -131.759896, 55.381845 ] ] ], [ [ [ -157.026070, 56.559757 ], [ -156.990969, 56.547939 ], [ -156.975549, 56.540446 ], [ -156.972896, 56.536505 ], [ -156.986090, 56.532749 ], [ -157.003409, 56.535639 ], [ -157.006523, 56.538910 ], [ -157.017711, 56.543081 ], [ -157.053384, 56.550425 ], [ -157.113193, 56.552658 ], [ -157.121393, 56.551963 ], [ -157.142219, 56.542390 ], [ -157.150309, 56.533600 ], [ -157.168777, 56.530210 ], [ -157.326059, 56.525169 ], [ -157.328898, 56.528155 ], [ -157.326110, 56.540375 ], [ -157.298635, 56.560051 ], [ -157.288702, 56.566039 ], [ -157.250098, 56.582142 ], [ -157.146636, 56.583651 ], [ -157.091146, 56.581134 ], [ -157.077383, 56.579035 ], [ -157.026070, 56.559757 ] ] ], [ [ [ -169.267598, 63.343995 ], [ -169.101961, 63.338022 ], [ -169.087914, 63.340937 ], [ -169.051950, 63.343127 ], [ -168.999241, 63.341249 ], [ -168.937385, 63.333789 ], [ -168.936333, 63.330622 ], [ -168.932623, 63.329140 ], [ -168.796086, 63.308781 ], [ -168.692939, 63.302282 ], [ -168.685145, 63.296427 ], [ -168.686675, 63.293022 ], [ -168.716872, 63.256316 ], [ -168.751537, 63.217962 ], [ -168.783239, 63.184131 ], [ -168.789266, 63.179646 ], [ -168.818344, 63.163224 ], [ -168.858750, 63.146958 ], [ -168.871465, 63.146009 ], [ -168.889683, 63.147708 ], [ -168.950091, 63.160895 ], [ -168.963577, 63.167104 ], [ -168.983024, 63.169671 ], [ -169.042674, 63.176511 ], [ -169.105808, 63.178803 ], [ -169.198398, 63.176011 ], [ -169.262039, 63.169936 ], [ -169.303477, 63.164439 ], [ -169.375667, 63.151269 ], [ -169.396308, 63.136617 ], [ -169.436748, 63.113579 ], [ -169.471949, 63.098565 ], [ -169.513650, 63.084717 ], [ -169.534984, 63.074355 ], [ -169.561131, 63.055178 ], [ -169.575873, 63.036450 ], [ -169.576965, 63.027025 ], [ -169.572777, 63.022118 ], [ -169.568016, 62.976879 ], [ -169.638309, 62.937527 ], [ -169.746736, 62.955991 ], [ -169.757249, 62.960087 ], [ -169.757514, 62.963722 ], [ -169.734938, 62.974468 ], [ -169.734938, 62.976617 ], [ -169.788466, 63.043015 ], [ -169.829912, 63.078550 ], [ -169.838511, 63.084339 ], [ -169.881230, 63.105848 ], [ -169.944056, 63.132360 ], [ -169.987936, 63.142975 ], [ -170.006196, 63.144540 ], [ -170.021208, 63.149500 ], [ -170.049622, 63.163377 ], [ -170.051062, 63.167489 ], [ -170.053402, 63.168858 ], [ -170.101301, 63.179300 ], [ -170.124354, 63.183665 ], [ -170.154072, 63.186402 ], [ -170.174421, 63.185464 ], [ -170.186485, 63.181618 ], [ -170.181985, 63.178804 ], [ -170.193695, 63.177434 ], [ -170.263032, 63.179147 ], [ -170.281388, 63.186821 ], [ -170.285648, 63.194570 ], [ -170.279881, 63.197108 ], [ -170.277915, 63.200239 ], [ -170.277721, 63.208819 ], [ -170.303630, 63.238692 ], [ -170.337275, 63.266308 ], [ -170.364806, 63.285596 ], [ -170.430656, 63.314284 ], [ -170.512102, 63.341881 ], [ -170.558950, 63.354989 ], [ -170.712572, 63.385975 ], [ -170.865412, 63.414229 ], [ -170.923450, 63.420859 ], [ -170.967475, 63.423730 ], [ -171.067663, 63.424579 ], [ -171.100855, 63.423420 ], [ -171.269249, 63.385386 ], [ -171.280185, 63.381543 ], [ -171.287157, 63.376642 ], [ -171.288265, 63.374833 ], [ -171.285411, 63.366464 ], [ -171.290324, 63.355383 ], [ -171.333089, 63.335393 ], [ -171.433319, 63.307578 ], [ -171.464455, 63.306915 ], [ -171.562263, 63.334591 ], [ -171.667115, 63.356166 ], [ -171.739321, 63.366114 ], [ -171.795297, 63.407853 ], [ -171.818259, 63.429452 ], [ -171.824872, 63.437141 ], [ -171.849984, 63.485039 ], [ -171.840382, 63.547724 ], [ -171.833681, 63.580074 ], [ -171.791881, 63.620625 ], [ -171.757081, 63.640252 ], [ -171.743979, 63.654905 ], [ -171.742338, 63.665494 ], [ -171.755552, 63.701173 ], [ -171.754336, 63.718960 ], [ -171.739918, 63.717096 ], [ -171.733206, 63.720327 ], [ -171.727986, 63.726791 ], [ -171.725748, 63.734745 ], [ -171.727986, 63.744938 ], [ -171.737432, 63.760350 ], [ -171.743398, 63.782971 ], [ -171.738178, 63.784711 ], [ -171.699647, 63.781728 ], [ -171.692686, 63.782598 ], [ -171.682494, 63.787570 ], [ -171.673296, 63.788067 ], [ -171.667330, 63.785581 ], [ -171.659873, 63.775762 ], [ -171.643963, 63.770791 ], [ -171.638991, 63.759231 ], [ -171.638246, 63.749536 ], [ -171.641477, 63.745559 ], [ -171.652912, 63.739220 ], [ -171.652664, 63.736610 ], [ -171.648935, 63.734870 ], [ -171.646692, 63.729425 ], [ -171.652630, 63.708523 ], [ -171.649923, 63.702540 ], [ -171.640027, 63.693430 ], [ -171.632194, 63.688601 ], [ -171.609439, 63.679832 ], [ -171.521859, 63.658797 ], [ -171.381677, 63.630646 ], [ -171.202557, 63.606897 ], [ -171.103558, 63.589268 ], [ -171.044486, 63.580431 ], [ -170.950817, 63.570127 ], [ -170.907197, 63.572107 ], [ -170.897581, 63.574676 ], [ -170.859032, 63.587503 ], [ -170.816581, 63.606329 ], [ -170.698156, 63.646778 ], [ -170.606282, 63.672732 ], [ -170.488192, 63.696723 ], [ -170.472181, 63.698677 ], [ -170.462947, 63.698022 ], [ -170.441066, 63.691981 ], [ -170.373871, 63.687322 ], [ -170.359363, 63.687321 ], [ -170.354527, 63.691924 ], [ -170.344855, 63.694225 ], [ -170.315839, 63.691923 ], [ -170.281988, 63.685020 ], [ -170.267480, 63.675816 ], [ -170.257808, 63.666611 ], [ -170.176413, 63.625489 ], [ -170.154754, 63.619072 ], [ -170.140040, 63.616696 ], [ -170.113066, 63.616245 ], [ -170.095833, 63.612701 ], [ -170.076689, 63.587988 ], [ -170.040919, 63.523411 ], [ -170.047114, 63.490135 ], [ -170.026953, 63.480702 ], [ -170.007943, 63.475428 ], [ -169.974858, 63.470618 ], [ -169.906304, 63.457519 ], [ -169.857078, 63.441975 ], [ -169.747634, 63.432756 ], [ -169.656474, 63.429929 ], [ -169.643167, 63.427802 ], [ -169.579892, 63.402870 ], [ -169.566562, 63.388725 ], [ -169.565439, 63.385563 ], [ -169.554375, 63.377158 ], [ -169.546934, 63.372792 ], [ -169.520524, 63.365941 ], [ -169.415329, 63.355943 ], [ -169.384080, 63.356733 ], [ -169.312970, 63.353335 ], [ -169.281422, 63.348381 ], [ -169.267598, 63.343995 ] ] ], [ [ [ -162.614621, 63.621832 ], [ -162.587527, 63.625115 ], [ -162.558234, 63.634308 ], [ -162.541389, 63.635727 ], [ -162.512298, 63.629784 ], [ -162.498175, 63.622069 ], [ -162.451929, 63.621270 ], [ -162.440229, 63.622491 ], [ -162.430304, 63.625745 ], [ -162.425419, 63.629950 ], [ -162.425265, 63.631654 ], [ -162.427696, 63.633134 ], [ -162.424205, 63.636215 ], [ -162.401203, 63.634367 ], [ -162.374243, 63.626425 ], [ -162.341892, 63.594062 ], [ -162.345179, 63.551785 ], [ -162.377988, 63.543813 ], [ -162.416802, 63.547389 ], [ -162.470029, 63.547500 ], [ -162.552701, 63.540951 ], [ -162.562007, 63.537105 ], [ -162.614949, 63.540601 ], [ -162.676581, 63.555648 ], [ -162.680973, 63.556859 ], [ -162.707559, 63.577607 ], [ -162.682629, 63.584066 ], [ -162.644513, 63.602599 ], [ -162.614621, 63.621832 ] ] ], [ [ [ -168.210120, 64.998960 ], [ -168.207906, 65.003291 ], [ -168.169090, 65.024067 ], [ -168.156162, 65.029174 ], [ -168.129109, 65.034565 ], [ -168.076108, 65.043289 ], [ -168.004872, 65.038897 ], [ -167.972262, 65.030534 ], [ -167.953076, 65.023479 ], [ -167.924296, 65.002728 ], [ -167.916447, 64.988618 ], [ -167.913829, 64.969943 ], [ -167.919060, 64.960813 ], [ -167.953094, 64.932994 ], [ -167.976149, 64.922872 ], [ -168.037032, 64.909284 ], [ -168.090879, 64.911113 ], [ -168.137033, 64.918432 ], [ -168.187035, 64.934902 ], [ -168.210114, 64.951372 ], [ -168.213962, 64.967845 ], [ -168.213963, 64.984318 ], [ -168.210120, 64.998960 ] ] ], [ [ [ -168.952766, 65.758911 ], [ -168.947278, 65.763817 ], [ -168.937240, 65.767116 ], [ -168.915518, 65.770484 ], [ -168.902235, 65.769665 ], [ -168.893219, 65.744705 ], [ -168.898754, 65.739709 ], [ -168.903439, 65.738454 ], [ -168.931220, 65.738940 ], [ -168.940760, 65.742714 ], [ -168.951388, 65.749319 ], [ -168.954515, 65.757144 ], [ -168.952766, 65.758911 ] ] ], [ [ [ -166.031870, 66.264639 ], [ -166.031342, 66.264631 ], [ -166.019921, 66.252754 ], [ -166.066397, 66.246531 ], [ -166.096969, 66.237833 ], [ -166.121659, 66.214773 ], [ -166.138390, 66.210089 ], [ -166.153012, 66.212289 ], [ -166.170909, 66.218437 ], [ -166.172071, 66.219909 ], [ -166.178474, 66.228016 ], [ -166.177606, 66.234732 ], [ -166.165412, 66.239084 ], [ -166.152374, 66.246373 ], [ -166.129652, 66.252813 ], [ -166.101781, 66.258743 ], [ -166.066097, 66.263721 ], [ -166.053153, 66.264944 ], [ -166.031870, 66.264639 ] ] ], [ [ [ -134.283312, 55.925175 ], [ -134.265872, 55.917371 ], [ -134.230613, 55.905629 ], [ -134.173104, 55.918519 ], [ -134.152216, 55.920916 ], [ -134.122839, 55.918654 ], [ -134.118062, 55.914642 ], [ -134.125521, 55.902095 ], [ -134.130544, 55.897512 ], [ -134.136647, 55.895393 ], [ -134.145803, 55.896713 ], [ -134.168363, 55.892319 ], [ -134.208251, 55.876709 ], [ -134.231157, 55.864747 ], [ -134.240537, 55.853922 ], [ -134.273156, 55.833058 ], [ -134.282453, 55.828667 ], [ -134.327238, 55.836440 ], [ -134.344418, 55.843198 ], [ -134.348153, 55.892817 ], [ -134.336063, 55.926614 ], [ -134.315782, 55.923003 ], [ -134.283312, 55.925175 ] ] ], [ [ [ -134.121514, 56.069847 ], [ -134.107218, 56.048156 ], [ -134.118132, 56.016922 ], [ -134.126903, 56.003592 ], [ -134.130907, 56.000104 ], [ -134.134181, 56.000971 ], [ -134.156721, 56.021080 ], [ -134.171731, 56.040227 ], [ -134.190863, 56.056540 ], [ -134.224073, 56.065223 ], [ -134.230449, 56.068341 ], [ -134.259913, 56.121275 ], [ -134.262217, 56.133222 ], [ -134.238264, 56.140863 ], [ -134.227942, 56.162835 ], [ -134.257478, 56.221411 ], [ -134.246307, 56.267768 ], [ -134.281387, 56.286218 ], [ -134.295634, 56.289228 ], [ -134.298292, 56.291993 ], [ -134.292353, 56.352644 ], [ -134.238139, 56.382806 ], [ -134.193922, 56.409906 ], [ -134.190494, 56.429749 ], [ -134.196394, 56.439800 ], [ -134.210968, 56.450498 ], [ -134.236978, 56.452363 ], [ -134.246627, 56.457135 ], [ -134.246179, 56.463511 ], [ -134.244667, 56.465100 ], [ -134.222814, 56.475402 ], [ -134.200909, 56.463297 ], [ -134.186476, 56.450571 ], [ -134.179214, 56.440305 ], [ -134.146136, 56.411069 ], [ -134.067466, 56.390987 ], [ -134.046227, 56.402275 ], [ -134.042704, 56.407697 ], [ -134.040938, 56.421530 ], [ -134.089604, 56.472582 ], [ -134.133892, 56.487825 ], [ -134.252386, 56.560861 ], [ -134.281093, 56.585555 ], [ -134.276735, 56.620290 ], [ -134.309869, 56.650509 ], [ -134.369035, 56.678022 ], [ -134.401407, 56.725419 ], [ -134.419791, 56.838385 ], [ -134.418940, 56.846524 ], [ -134.411471, 56.855837 ], [ -134.376975, 56.880055 ], [ -134.339168, 56.901830 ], [ -134.316868, 56.909091 ], [ -134.294362, 56.908714 ], [ -134.286818, 56.906534 ], [ -134.190950, 56.861675 ], [ -134.187063, 56.856714 ], [ -134.171675, 56.851218 ], [ -134.147160, 56.859357 ], [ -134.141933, 56.874188 ], [ -134.150935, 56.884958 ], [ -134.181383, 56.892572 ], [ -134.220002, 56.905084 ], [ -134.273113, 56.933823 ], [ -134.271664, 56.935928 ], [ -134.249327, 56.937374 ], [ -134.223939, 56.932553 ], [ -134.178507, 56.914018 ], [ -134.158108, 56.915029 ], [ -134.136240, 56.928842 ], [ -134.141236, 56.942081 ], [ -134.141385, 56.950887 ], [ -134.126562, 56.947381 ], [ -134.083291, 56.931579 ], [ -134.035140, 56.894510 ], [ -133.972257, 56.826934 ], [ -133.946767, 56.798924 ], [ -133.925648, 56.758912 ], [ -133.944663, 56.736433 ], [ -133.941801, 56.733493 ], [ -133.907795, 56.721840 ], [ -133.880781, 56.721396 ], [ -133.869334, 56.734081 ], [ -133.862981, 56.755650 ], [ -133.865056, 56.773240 ], [ -133.867616, 56.782025 ], [ -133.872250, 56.786186 ], [ -133.877395, 56.789192 ], [ -133.884755, 56.788656 ], [ -133.890005, 56.792468 ], [ -133.893861, 56.802526 ], [ -133.890805, 56.807980 ], [ -133.861472, 56.808837 ], [ -133.837925, 56.801788 ], [ -133.818194, 56.791453 ], [ -133.767780, 56.780469 ], [ -133.748129, 56.773919 ], [ -133.743376, 56.762291 ], [ -133.744002, 56.749772 ], [ -133.766143, 56.728886 ], [ -133.766143, 56.718242 ], [ -133.762049, 56.696135 ], [ -133.762780, 56.687180 ], [ -133.759650, 56.675913 ], [ -133.745673, 56.674028 ], [ -133.728479, 56.642915 ], [ -133.727728, 56.630846 ], [ -133.713331, 56.598298 ], [ -133.713331, 56.592664 ], [ -133.723142, 56.583962 ], [ -133.731617, 56.572304 ], [ -133.848207, 56.573057 ], [ -133.895746, 56.511217 ], [ -133.898589, 56.489877 ], [ -133.881080, 56.480803 ], [ -133.868625, 56.470919 ], [ -133.839117, 56.434885 ], [ -133.839238, 56.432018 ], [ -133.859104, 56.430348 ], [ -133.869729, 56.431796 ], [ -133.893040, 56.427364 ], [ -133.933512, 56.375428 ], [ -133.894358, 56.360989 ], [ -133.850314, 56.347417 ], [ -133.839099, 56.335467 ], [ -133.834671, 56.322382 ], [ -133.890940, 56.234467 ], [ -133.912992, 56.208351 ], [ -133.923420, 56.211725 ], [ -133.942205, 56.209460 ], [ -133.953825, 56.206661 ], [ -133.957471, 56.202584 ], [ -133.957575, 56.199887 ], [ -133.937349, 56.166129 ], [ -133.956411, 56.095484 ], [ -133.971228, 56.083293 ], [ -133.989359, 56.081347 ], [ -134.013920, 56.085374 ], [ -134.021028, 56.088745 ], [ -134.038695, 56.105807 ], [ -134.041765, 56.116337 ], [ -134.029643, 56.134864 ], [ -134.024495, 56.148164 ], [ -134.024356, 56.160382 ], [ -134.030964, 56.193214 ], [ -134.054411, 56.224854 ], [ -134.058499, 56.227214 ], [ -134.087317, 56.225424 ], [ -134.095013, 56.214751 ], [ -134.105098, 56.180941 ], [ -134.153663, 56.169700 ], [ -134.161971, 56.170153 ], [ -134.180057, 56.161635 ], [ -134.190371, 56.152571 ], [ -134.166141, 56.144564 ], [ -134.125902, 56.139804 ], [ -134.110755, 56.141053 ], [ -134.109236, 56.078732 ], [ -134.121514, 56.069847 ] ] ], [ [ [ -132.546463, 56.606563 ], [ -132.539698, 56.593199 ], [ -132.541282, 56.584573 ], [ -132.610830, 56.556252 ], [ -132.627435, 56.552428 ], [ -132.628511, 56.553553 ], [ -132.650910, 56.552127 ], [ -132.701275, 56.529580 ], [ -132.724189, 56.515371 ], [ -132.796627, 56.496471 ], [ -132.818043, 56.494934 ], [ -132.874282, 56.509108 ], [ -132.984751, 56.512640 ], [ -132.986907, 56.510784 ], [ -133.041726, 56.518356 ], [ -133.071828, 56.553483 ], [ -133.075496, 56.578684 ], [ -133.025091, 56.605048 ], [ -133.110329, 56.669727 ], [ -133.143198, 56.682979 ], [ -133.184363, 56.706526 ], [ -133.212185, 56.736822 ], [ -133.225298, 56.755591 ], [ -133.233331, 56.771095 ], [ -133.235251, 56.775639 ], [ -133.233646, 56.779447 ], [ -133.244689, 56.792649 ], [ -133.264047, 56.814544 ], [ -133.277352, 56.816432 ], [ -133.325392, 56.791864 ], [ -133.334308, 56.773402 ], [ -133.332845, 56.761663 ], [ -133.319860, 56.737693 ], [ -133.303752, 56.729879 ], [ -133.272958, 56.733653 ], [ -133.266844, 56.734882 ], [ -133.265608, 56.738237 ], [ -133.266768, 56.741943 ], [ -133.261381, 56.747459 ], [ -133.250686, 56.751431 ], [ -133.219681, 56.706887 ], [ -133.221517, 56.697886 ], [ -133.232516, 56.681336 ], [ -133.233684, 56.649286 ], [ -133.214228, 56.649592 ], [ -133.151444, 56.637672 ], [ -133.106316, 56.618393 ], [ -133.103363, 56.614645 ], [ -133.089388, 56.535474 ], [ -133.089215, 56.523916 ], [ -133.112907, 56.529295 ], [ -133.138307, 56.532923 ], [ -133.142099, 56.528591 ], [ -133.142482, 56.519697 ], [ -133.139228, 56.515994 ], [ -133.124726, 56.511439 ], [ -133.122245, 56.492020 ], [ -133.148730, 56.467357 ], [ -133.160996, 56.460257 ], [ -133.203584, 56.447657 ], [ -133.348504, 56.469568 ], [ -133.356300, 56.471794 ], [ -133.361615, 56.486073 ], [ -133.371889, 56.493689 ], [ -133.376245, 56.495592 ], [ -133.401797, 56.496355 ], [ -133.417795, 56.494147 ], [ -133.428585, 56.479247 ], [ -133.460634, 56.454120 ], [ -133.512684, 56.437015 ], [ -133.532969, 56.434751 ], [ -133.603669, 56.435413 ], [ -133.638349, 56.438881 ], [ -133.655468, 56.442279 ], [ -133.663094, 56.448073 ], [ -133.671653, 56.487656 ], [ -133.675836, 56.522714 ], [ -133.675696, 56.538672 ], [ -133.672262, 56.544152 ], [ -133.664509, 56.550727 ], [ -133.662631, 56.555735 ], [ -133.663064, 56.562070 ], [ -133.667639, 56.576390 ], [ -133.662631, 56.598924 ], [ -133.667639, 56.607687 ], [ -133.673621, 56.611801 ], [ -133.679352, 56.633089 ], [ -133.689178, 56.643734 ], [ -133.698309, 56.649624 ], [ -133.705820, 56.658387 ], [ -133.709576, 56.683424 ], [ -133.706372, 56.696954 ], [ -133.699822, 56.710054 ], [ -133.696547, 56.744443 ], [ -133.689996, 56.761637 ], [ -133.686416, 56.779817 ], [ -133.680990, 56.795207 ], [ -133.679352, 56.810764 ], [ -133.689996, 56.839421 ], [ -133.699822, 56.839421 ], [ -133.712922, 56.827958 ], [ -133.741579, 56.813220 ], [ -133.765324, 56.807489 ], [ -133.772302, 56.809495 ], [ -133.787484, 56.821366 ], [ -133.795364, 56.824586 ], [ -133.869040, 56.845938 ], [ -133.887426, 56.868391 ], [ -133.916358, 56.914447 ], [ -133.903634, 56.927269 ], [ -133.921451, 56.961511 ], [ -133.967060, 56.988044 ], [ -134.049218, 57.029203 ], [ -134.033979, 57.063281 ], [ -134.008856, 57.074578 ], [ -133.887957, 57.097744 ], [ -133.773464, 57.078676 ], [ -133.702925, 57.065206 ], [ -133.613908, 57.057978 ], [ -133.536258, 57.038700 ], [ -133.446204, 57.020124 ], [ -133.362502, 57.007424 ], [ -133.346321, 57.004118 ], [ -133.344217, 57.001834 ], [ -133.334272, 57.002442 ], [ -133.325058, 57.011711 ], [ -133.308317, 57.014762 ], [ -133.104611, 57.005701 ], [ -132.997430, 56.942201 ], [ -132.981370, 56.927380 ], [ -132.947081, 56.870963 ], [ -132.935933, 56.839963 ], [ -132.935258, 56.822941 ], [ -132.903211, 56.803610 ], [ -132.872512, 56.798144 ], [ -132.853150, 56.797810 ], [ -132.820556, 56.793787 ], [ -132.762964, 56.753227 ], [ -132.741709, 56.724278 ], [ -132.743207, 56.713720 ], [ -132.665874, 56.680241 ], [ -132.628129, 56.668830 ], [ -132.622788, 56.668710 ], [ -132.619258, 56.660778 ], [ -132.625450, 56.653210 ], [ -132.628201, 56.645642 ], [ -132.625450, 56.642202 ], [ -132.616506, 56.639450 ], [ -132.605498, 56.623627 ], [ -132.595179, 56.613308 ], [ -132.574540, 56.612620 ], [ -132.560780, 56.607804 ], [ -132.553213, 56.608492 ], [ -132.546463, 56.606563 ] ] ], [ [ [ -131.569560, 55.284114 ], [ -131.562650, 55.284012 ], [ -131.550916, 55.280915 ], [ -131.516651, 55.261645 ], [ -131.492640, 55.257749 ], [ -131.482252, 55.254110 ], [ -131.481522, 55.244448 ], [ -131.462701, 55.223438 ], [ -131.445293, 55.216977 ], [ -131.430501, 55.218175 ], [ -131.416951, 55.217298 ], [ -131.397690, 55.210916 ], [ -131.355642, 55.182945 ], [ -131.341407, 55.165659 ], [ -131.352654, 55.164822 ], [ -131.362319, 55.155896 ], [ -131.350575, 55.067042 ], [ -131.356314, 55.041211 ], [ -131.378572, 55.017308 ], [ -131.388569, 55.012222 ], [ -131.484995, 55.010454 ], [ -131.498863, 55.016138 ], [ -131.507590, 55.025427 ], [ -131.508449, 55.029166 ], [ -131.532140, 55.037945 ], [ -131.579882, 55.017576 ], [ -131.590063, 55.007745 ], [ -131.605661, 55.004403 ], [ -131.615632, 55.006999 ], [ -131.641035, 55.026585 ], [ -131.646276, 55.035579 ], [ -131.620745, 55.049259 ], [ -131.589387, 55.088940 ], [ -131.605302, 55.107436 ], [ -131.594978, 55.125502 ], [ -131.577773, 55.131094 ], [ -131.558603, 55.125508 ], [ -131.548093, 55.143138 ], [ -131.565677, 55.155354 ], [ -131.588368, 55.169961 ], [ -131.598454, 55.179566 ], [ -131.607383, 55.240437 ], [ -131.589070, 55.273951 ], [ -131.569560, 55.284114 ] ] ], [ [ [ -133.344847, 55.569327 ], [ -133.307406, 55.542249 ], [ -133.292346, 55.539736 ], [ -133.285317, 55.535315 ], [ -133.281917, 55.524486 ], [ -133.289854, 55.501870 ], [ -133.305747, 55.484115 ], [ -133.358993, 55.453832 ], [ -133.373595, 55.460656 ], [ -133.391243, 55.471979 ], [ -133.396511, 55.473169 ], [ -133.426516, 55.466702 ], [ -133.474054, 55.437155 ], [ -133.465300, 55.423370 ], [ -133.425823, 55.425511 ], [ -133.416649, 55.422146 ], [ -133.412524, 55.417560 ], [ -133.411582, 55.406683 ], [ -133.419384, 55.386105 ], [ -133.427366, 55.381832 ], [ -133.446281, 55.382175 ], [ -133.497028, 55.368159 ], [ -133.576808, 55.324795 ], [ -133.595805, 55.293766 ], [ -133.603491, 55.271739 ], [ -133.609073, 55.241486 ], [ -133.612780, 55.239737 ], [ -133.623457, 55.242571 ], [ -133.634509, 55.250043 ], [ -133.690174, 55.304409 ], [ -133.690944, 55.308703 ], [ -133.689159, 55.320285 ], [ -133.672243, 55.326765 ], [ -133.647725, 55.345480 ], [ -133.633006, 55.361299 ], [ -133.622422, 55.396474 ], [ -133.636291, 55.428423 ], [ -133.739077, 55.472323 ], [ -133.749371, 55.471818 ], [ -133.764347, 55.468593 ], [ -133.789055, 55.457892 ], [ -133.759130, 55.537371 ], [ -133.752870, 55.544282 ], [ -133.733029, 55.558757 ], [ -133.615623, 55.550776 ], [ -133.584326, 55.539707 ], [ -133.582005, 55.537363 ], [ -133.590163, 55.507236 ], [ -133.595632, 55.501483 ], [ -133.611671, 55.495585 ], [ -133.624912, 55.494674 ], [ -133.632978, 55.491664 ], [ -133.644202, 55.470815 ], [ -133.644565, 55.464680 ], [ -133.638673, 55.458902 ], [ -133.618367, 55.457045 ], [ -133.573698, 55.472083 ], [ -133.544088, 55.491784 ], [ -133.542322, 55.507084 ], [ -133.529120, 55.527700 ], [ -133.525646, 55.529097 ], [ -133.480965, 55.512738 ], [ -133.443670, 55.518639 ], [ -133.454576, 55.532423 ], [ -133.442660, 55.553012 ], [ -133.436102, 55.560872 ], [ -133.413499, 55.570384 ], [ -133.344847, 55.569327 ] ] ], [ [ [ -133.624918, 56.343906 ], [ -133.593728, 56.352192 ], [ -133.582116, 56.352506 ], [ -133.418370, 56.332132 ], [ -133.328577, 56.332797 ], [ -133.284826, 56.327118 ], [ -133.235354, 56.324275 ], [ -133.197009, 56.333016 ], [ -133.163212, 56.317445 ], [ -133.094977, 56.250583 ], [ -133.078230, 56.246802 ], [ -133.071435, 56.238484 ], [ -133.040979, 56.184536 ], [ -133.052004, 56.155585 ], [ -133.059994, 56.150761 ], [ -133.062175, 56.141163 ], [ -133.061465, 56.135305 ], [ -133.055520, 56.125258 ], [ -132.927305, 56.034459 ], [ -132.897675, 56.020166 ], [ -132.837592, 56.024327 ], [ -132.635291, 55.921766 ], [ -132.618464, 55.911476 ], [ -132.615103, 55.908082 ], [ -132.614757, 55.899635 ], [ -132.592085, 55.877152 ], [ -132.543398, 55.845927 ], [ -132.504800, 55.815166 ], [ -132.470697, 55.782162 ], [ -132.461281, 55.683400 ], [ -132.462531, 55.673854 ], [ -132.448855, 55.667337 ], [ -132.415237, 55.667263 ], [ -132.394266, 55.669114 ], [ -132.382505, 55.665336 ], [ -132.358558, 55.648759 ], [ -132.332401, 55.595071 ], [ -132.329280, 55.578936 ], [ -132.301119, 55.550960 ], [ -132.240921, 55.526533 ], [ -132.198289, 55.513045 ], [ -132.188771, 55.508443 ], [ -132.146062, 55.470346 ], [ -132.142649, 55.460967 ], [ -132.142945, 55.457941 ], [ -132.164757, 55.451213 ], [ -132.178610, 55.452829 ], [ -132.219413, 55.472211 ], [ -132.230752, 55.479944 ], [ -132.231936, 55.483960 ], [ -132.247327, 55.492951 ], [ -132.315773, 55.514547 ], [ -132.325728, 55.515395 ], [ -132.342101, 55.504670 ], [ -132.318570, 55.469208 ], [ -132.288585, 55.451365 ], [ -132.281269, 55.444189 ], [ -132.284442, 55.442173 ], [ -132.303329, 55.438268 ], [ -132.419340, 55.432054 ], [ -132.470036, 55.427028 ], [ -132.479688, 55.420918 ], [ -132.475532, 55.418062 ], [ -132.454974, 55.413600 ], [ -132.390782, 55.401739 ], [ -132.273503, 55.419189 ], [ -132.258056, 55.416142 ], [ -132.225960, 55.374919 ], [ -132.166857, 55.363039 ], [ -132.149864, 55.328637 ], [ -132.126398, 55.288418 ], [ -132.115561, 55.281237 ], [ -132.098531, 55.280560 ], [ -132.102716, 55.268175 ], [ -132.109531, 55.260240 ], [ -132.142742, 55.238212 ], [ -132.164031, 55.237617 ], [ -132.214912, 55.245700 ], [ -132.229963, 55.238080 ], [ -132.214353, 55.222562 ], [ -132.207431, 55.218273 ], [ -132.127370, 55.199570 ], [ -132.104376, 55.200899 ], [ -132.088127, 55.206516 ], [ -132.075095, 55.222390 ], [ -132.072751, 55.233718 ], [ -132.078869, 55.240335 ], [ -132.075924, 55.246276 ], [ -132.061625, 55.260052 ], [ -132.037122, 55.275144 ], [ -132.028163, 55.276950 ], [ -132.003500, 55.265254 ], [ -131.995908, 55.259054 ], [ -131.979818, 55.211787 ], [ -131.977397, 55.180949 ], [ -131.988815, 55.165464 ], [ -132.031417, 55.151671 ], [ -132.039009, 55.144070 ], [ -132.040874, 55.127326 ], [ -132.038978, 55.125011 ], [ -132.016932, 55.120971 ], [ -132.039002, 55.086962 ], [ -132.094024, 55.039452 ], [ -132.154061, 55.018197 ], [ -132.168076, 55.015574 ], [ -132.180334, 55.015557 ], [ -132.196215, 55.008047 ], [ -132.197614, 55.005158 ], [ -132.192581, 54.989655 ], [ -132.143263, 54.984633 ], [ -132.135544, 54.985976 ], [ -132.072544, 55.016956 ], [ -132.039217, 55.036765 ], [ -132.028288, 55.038672 ], [ -132.000449, 55.035712 ], [ -131.984592, 55.027978 ], [ -131.982890, 54.853068 ], [ -131.976847, 54.848894 ], [ -131.965904, 54.835539 ], [ -131.957382, 54.804279 ], [ -131.957914, 54.791239 ], [ -131.999591, 54.731975 ], [ -132.018657, 54.710109 ], [ -132.029747, 54.701189 ], [ -132.142277, 54.691674 ], [ -132.165182, 54.694050 ], [ -132.179635, 54.705898 ], [ -132.199566, 54.715444 ], [ -132.256092, 54.734617 ], [ -132.263100, 54.734312 ], [ -132.279597, 54.728230 ], [ -132.280701, 54.726184 ], [ -132.280103, 54.715988 ], [ -132.281803, 54.715290 ], [ -132.307943, 54.718714 ], [ -132.351004, 54.818182 ], [ -132.350629, 54.821314 ], [ -132.341009, 54.826718 ], [ -132.332661, 54.826322 ], [ -132.314146, 54.835120 ], [ -132.309213, 54.847534 ], [ -132.387494, 54.913664 ], [ -132.484579, 54.899301 ], [ -132.558390, 54.932612 ], [ -132.581367, 54.946005 ], [ -132.609786, 54.965728 ], [ -132.612531, 54.969924 ], [ -132.614836, 54.980095 ], [ -132.609900, 54.991517 ], [ -132.598557, 54.990301 ], [ -132.577830, 54.994234 ], [ -132.575001, 54.998317 ], [ -132.541802, 55.097764 ], [ -132.548994, 55.113556 ], [ -132.550502, 55.114247 ], [ -132.561819, 55.114897 ], [ -132.594568, 55.105378 ], [ -132.619912, 55.069094 ], [ -132.624575, 55.061352 ], [ -132.624296, 55.056163 ], [ -132.626687, 55.053314 ], [ -132.630865, 55.052946 ], [ -132.633305, 55.054954 ], [ -132.637866, 55.073602 ], [ -132.624518, 55.114419 ], [ -132.606895, 55.141722 ], [ -132.598675, 55.150482 ], [ -132.591084, 55.155695 ], [ -132.587868, 55.155971 ], [ -132.581133, 55.166076 ], [ -132.605219, 55.194064 ], [ -132.620123, 55.199617 ], [ -132.637926, 55.186077 ], [ -132.630049, 55.177618 ], [ -132.629643, 55.174232 ], [ -132.635758, 55.152514 ], [ -132.663719, 55.143932 ], [ -132.695227, 55.137711 ], [ -132.735645, 55.134218 ], [ -132.712195, 55.098736 ], [ -132.684005, 55.045604 ], [ -132.689667, 55.027901 ], [ -132.692917, 55.025060 ], [ -132.748854, 54.996007 ], [ -132.813743, 55.010987 ], [ -132.864117, 55.024833 ], [ -132.916414, 55.044465 ], [ -132.926772, 55.055023 ], [ -132.932293, 55.070199 ], [ -132.931172, 55.074154 ], [ -132.909355, 55.081277 ], [ -132.881083, 55.110375 ], [ -132.869827, 55.124104 ], [ -132.873408, 55.134241 ], [ -132.894283, 55.169373 ], [ -132.935449, 55.209898 ], [ -132.939845, 55.211481 ], [ -132.982166, 55.215882 ], [ -133.008156, 55.205700 ], [ -133.040748, 55.232969 ], [ -133.043938, 55.248569 ], [ -133.104708, 55.263800 ], [ -133.119294, 55.251405 ], [ -133.073381, 55.184492 ], [ -133.012275, 55.128056 ], [ -132.990860, 55.079112 ], [ -132.990395, 55.066730 ], [ -133.011351, 55.056849 ], [ -133.019740, 55.048366 ], [ -133.014178, 55.035502 ], [ -132.959508, 55.021045 ], [ -132.909706, 54.923594 ], [ -132.914650, 54.914009 ], [ -132.889474, 54.896619 ], [ -132.828340, 54.868747 ], [ -132.804525, 54.870938 ], [ -132.803014, 54.873725 ], [ -132.803742, 54.897206 ], [ -132.807952, 54.904378 ], [ -132.814282, 54.909356 ], [ -132.817385, 54.923640 ], [ -132.800784, 54.933783 ], [ -132.730931, 54.939483 ], [ -132.650001, 54.904387 ], [ -132.628612, 54.883316 ], [ -132.625563, 54.807503 ], [ -132.614851, 54.777170 ], [ -132.619024, 54.766565 ], [ -132.639032, 54.753251 ], [ -132.667250, 54.763369 ], [ -132.681165, 54.773697 ], [ -132.701203, 54.798446 ], [ -132.701153, 54.811012 ], [ -132.709267, 54.817521 ], [ -132.723538, 54.825128 ], [ -132.729369, 54.826981 ], [ -132.754875, 54.821236 ], [ -132.759779, 54.816998 ], [ -132.759364, 54.808277 ], [ -132.747451, 54.800743 ], [ -132.722011, 54.763259 ], [ -132.676226, 54.680865 ], [ -132.674324, 54.674652 ], [ -132.675868, 54.672812 ], [ -132.693970, 54.669064 ], [ -132.775733, 54.674844 ], [ -132.866355, 54.700386 ], [ -132.869604, 54.702416 ], [ -132.864084, 54.716917 ], [ -132.865598, 54.728908 ], [ -132.877210, 54.753772 ], [ -132.891553, 54.768191 ], [ -132.909517, 54.780516 ], [ -132.918751, 54.783253 ], [ -132.940485, 54.783831 ], [ -132.950250, 54.788333 ], [ -133.032752, 54.855055 ], [ -133.099047, 54.919007 ], [ -133.123941, 54.940065 ], [ -133.159756, 54.958760 ], [ -133.164788, 54.976909 ], [ -133.157326, 55.000365 ], [ -133.168931, 55.030889 ], [ -133.172360, 55.032745 ], [ -133.197719, 55.033404 ], [ -133.210420, 55.040269 ], [ -133.239695, 55.092415 ], [ -133.223923, 55.099986 ], [ -133.218101, 55.101042 ], [ -133.144954, 55.099155 ], [ -133.134987, 55.099473 ], [ -133.128705, 55.101429 ], [ -133.154780, 55.128110 ], [ -133.186809, 55.136372 ], [ -133.193242, 55.134108 ], [ -133.201053, 55.134099 ], [ -133.207702, 55.134220 ], [ -133.215086, 55.136876 ], [ -133.236908, 55.183326 ], [ -133.187745, 55.193639 ], [ -133.182520, 55.201964 ], [ -133.223791, 55.229317 ], [ -133.254478, 55.231149 ], [ -133.281979, 55.217117 ], [ -133.323021, 55.207030 ], [ -133.341259, 55.205701 ], [ -133.353719, 55.221215 ], [ -133.361562, 55.225560 ], [ -133.376615, 55.228288 ], [ -133.404497, 55.214992 ], [ -133.415257, 55.212159 ], [ -133.422869, 55.210659 ], [ -133.441074, 55.211654 ], [ -133.453777, 55.218497 ], [ -133.471938, 55.247527 ], [ -133.473593, 55.255547 ], [ -133.472866, 55.267873 ], [ -133.459753, 55.306780 ], [ -133.452818, 55.319980 ], [ -133.436350, 55.330158 ], [ -133.395371, 55.341753 ], [ -133.352083, 55.347381 ], [ -133.332360, 55.345357 ], [ -133.313491, 55.331557 ], [ -133.310529, 55.320257 ], [ -133.311114, 55.317301 ], [ -133.292402, 55.291377 ], [ -133.268999, 55.286971 ], [ -133.244343, 55.291865 ], [ -133.235129, 55.304162 ], [ -133.233572, 55.308822 ], [ -133.254639, 55.318806 ], [ -133.279271, 55.333264 ], [ -133.280701, 55.341536 ], [ -133.278443, 55.349184 ], [ -133.269068, 55.359341 ], [ -133.257734, 55.367026 ], [ -133.226844, 55.381850 ], [ -133.208794, 55.384237 ], [ -133.183280, 55.379392 ], [ -133.121513, 55.414536 ], [ -133.104304, 55.426907 ], [ -133.138129, 55.458373 ], [ -133.157704, 55.497782 ], [ -133.133293, 55.502508 ], [ -133.132409, 55.513579 ], [ -133.156566, 55.563589 ], [ -133.176760, 55.586722 ], [ -133.263042, 55.568793 ], [ -133.275972, 55.580188 ], [ -133.294158, 55.588680 ], [ -133.386900, 55.619346 ], [ -133.438180, 55.643862 ], [ -133.438933, 55.645167 ], [ -133.408432, 55.667925 ], [ -133.399885, 55.665133 ], [ -133.394486, 55.666881 ], [ -133.386432, 55.693365 ], [ -133.416549, 55.739647 ], [ -133.438619, 55.748366 ], [ -133.491430, 55.764082 ], [ -133.512632, 55.755898 ], [ -133.509704, 55.744183 ], [ -133.496509, 55.733258 ], [ -133.494087, 55.733158 ], [ -133.490882, 55.726576 ], [ -133.489253, 55.713081 ], [ -133.492438, 55.706525 ], [ -133.527387, 55.695108 ], [ -133.554504, 55.698354 ], [ -133.583297, 55.705338 ], [ -133.625120, 55.719927 ], [ -133.643324, 55.729037 ], [ -133.694546, 55.780599 ], [ -133.695749, 55.783118 ], [ -133.646377, 55.823413 ], [ -133.627534, 55.831630 ], [ -133.561973, 55.835543 ], [ -133.550028, 55.832181 ], [ -133.447875, 55.791738 ], [ -133.422064, 55.788821 ], [ -133.347915, 55.803943 ], [ -133.342058, 55.805764 ], [ -133.323664, 55.818632 ], [ -133.335139, 55.866118 ], [ -133.346569, 55.875809 ], [ -133.379472, 55.880716 ], [ -133.391026, 55.878751 ], [ -133.418797, 55.883278 ], [ -133.471044, 55.947381 ], [ -133.495052, 56.017089 ], [ -133.541041, 55.977322 ], [ -133.638122, 55.920982 ], [ -133.699900, 55.912206 ], [ -133.799931, 55.925349 ], [ -133.826236, 55.948750 ], [ -133.834370, 55.963578 ], [ -133.812770, 55.974135 ], [ -133.798092, 55.975096 ], [ -133.777846, 55.982876 ], [ -133.748803, 56.009536 ], [ -133.693765, 56.070562 ], [ -133.684209, 56.075507 ], [ -133.659241, 56.083818 ], [ -133.548802, 56.142840 ], [ -133.542830, 56.160794 ], [ -133.553454, 56.169015 ], [ -133.601500, 56.191925 ], [ -133.639282, 56.198813 ], [ -133.664218, 56.310504 ], [ -133.656415, 56.326909 ], [ -133.649916, 56.326792 ], [ -133.643182, 56.324459 ], [ -133.624658, 56.337070 ], [ -133.625121, 56.339847 ], [ -133.624918, 56.343906 ] ] ], [ [ [ -133.846128, 55.904622 ], [ -133.840833, 55.892726 ], [ -133.840298, 55.886770 ], [ -133.847565, 55.869599 ], [ -133.861039, 55.848844 ], [ -133.866988, 55.845886 ], [ -133.894706, 55.845641 ], [ -133.903184, 55.848101 ], [ -133.920250, 55.860295 ], [ -133.929325, 55.869538 ], [ -133.945619, 55.896216 ], [ -133.943499, 55.912446 ], [ -133.940298, 55.917506 ], [ -133.935016, 55.920689 ], [ -133.891851, 55.936680 ], [ -133.876494, 55.937683 ], [ -133.864099, 55.936286 ], [ -133.854291, 55.931581 ], [ -133.846763, 55.911670 ], [ -133.846128, 55.904622 ] ] ], [ [ [ -135.587961, 57.897320 ], [ -135.596769, 57.889705 ], [ -135.589170, 57.886409 ], [ -135.575718, 57.883548 ], [ -135.518882, 57.857383 ], [ -135.503498, 57.840860 ], [ -135.469477, 57.834466 ], [ -135.377758, 57.802212 ], [ -135.376444, 57.792039 ], [ -135.364221, 57.775347 ], [ -135.328887, 57.748420 ], [ -135.291560, 57.737468 ], [ -135.201461, 57.728171 ], [ -135.151475, 57.738296 ], [ -135.098422, 57.754898 ], [ -135.063972, 57.750847 ], [ -135.024837, 57.742990 ], [ -135.012577, 57.746105 ], [ -134.978120, 57.763125 ], [ -134.939924, 57.763612 ], [ -134.929726, 57.759203 ], [ -134.921604, 57.742376 ], [ -134.914790, 57.705821 ], [ -134.918167, 57.682272 ], [ -134.867433, 57.623439 ], [ -134.856386, 57.598967 ], [ -134.824891, 57.500067 ], [ -134.837120, 57.482761 ], [ -134.874346, 57.464406 ], [ -134.902680, 57.459349 ], [ -135.025148, 57.454315 ], [ -135.084338, 57.464671 ], [ -135.091216, 57.466352 ], [ -135.096818, 57.469916 ], [ -135.134063, 57.497681 ], [ -135.242855, 57.546302 ], [ -135.325849, 57.577178 ], [ -135.392499, 57.599909 ], [ -135.474703, 57.631381 ], [ -135.514801, 57.650349 ], [ -135.571606, 57.674397 ], [ -135.593447, 57.663795 ], [ -135.650701, 57.652520 ], [ -135.684951, 57.677508 ], [ -135.712317, 57.672648 ], [ -135.704444, 57.658361 ], [ -135.697422, 57.649711 ], [ -135.660902, 57.629196 ], [ -135.592778, 57.602474 ], [ -135.571186, 57.605367 ], [ -135.546143, 57.613826 ], [ -135.526303, 57.606388 ], [ -135.511012, 57.595906 ], [ -135.519471, 57.588615 ], [ -135.527610, 57.589003 ], [ -135.557812, 57.583449 ], [ -135.570574, 57.579613 ], [ -135.587475, 57.568829 ], [ -135.588477, 57.552081 ], [ -135.575724, 57.522874 ], [ -135.577831, 57.520530 ], [ -135.578215, 57.516445 ], [ -135.565271, 57.510209 ], [ -135.549627, 57.482016 ], [ -135.550310, 57.470141 ], [ -135.553903, 57.454870 ], [ -135.557765, 57.451966 ], [ -135.610454, 57.442232 ], [ -135.613576, 57.438173 ], [ -135.611786, 57.431154 ], [ -135.612882, 57.424907 ], [ -135.621725, 57.419245 ], [ -135.626558, 57.409961 ], [ -135.647179, 57.406132 ], [ -135.664449, 57.407229 ], [ -135.667985, 57.405124 ], [ -135.669837, 57.400578 ], [ -135.670267, 57.396215 ], [ -135.668153, 57.392832 ], [ -135.669416, 57.389296 ], [ -135.691043, 57.383518 ], [ -135.692400, 57.375267 ], [ -135.711401, 57.367760 ], [ -135.720478, 57.373663 ], [ -135.768018, 57.383435 ], [ -135.843810, 57.390896 ], [ -135.892131, 57.408048 ], [ -135.900816, 57.418181 ], [ -135.896979, 57.440719 ], [ -135.943766, 57.458780 ], [ -135.966986, 57.472759 ], [ -136.014529, 57.506227 ], [ -136.030458, 57.521540 ], [ -136.021283, 57.531551 ], [ -136.001717, 57.544499 ], [ -136.061747, 57.592068 ], [ -136.106796, 57.616567 ], [ -136.130611, 57.624607 ], [ -136.187897, 57.625730 ], [ -136.207876, 57.638107 ], [ -136.280809, 57.717379 ], [ -136.314631, 57.758703 ], [ -136.304684, 57.771051 ], [ -136.309429, 57.779465 ], [ -136.365052, 57.828561 ], [ -136.370705, 57.831668 ], [ -136.372377, 57.832587 ], [ -136.391157, 57.832653 ], [ -136.458829, 57.853901 ], [ -136.474424, 57.871648 ], [ -136.484259, 57.896460 ], [ -136.534201, 57.913938 ], [ -136.557651, 57.912135 ], [ -136.572045, 57.918469 ], [ -136.573288, 57.926844 ], [ -136.563223, 58.035052 ], [ -136.559999, 58.063358 ], [ -136.556247, 58.077019 ], [ -136.538708, 58.093482 ], [ -136.500119, 58.104787 ], [ -136.475811, 58.101294 ], [ -136.469272, 58.096868 ], [ -136.420449, 58.131857 ], [ -136.375338, 58.208714 ], [ -136.387114, 58.252414 ], [ -136.377329, 58.268328 ], [ -136.311596, 58.270388 ], [ -136.287765, 58.267373 ], [ -136.286263, 58.259741 ], [ -136.289842, 58.249086 ], [ -136.283886, 58.223685 ], [ -136.277477, 58.208856 ], [ -136.235246, 58.154416 ], [ -136.190155, 58.161301 ], [ -136.190382, 58.164473 ], [ -136.194557, 58.171811 ], [ -136.199498, 58.172086 ], [ -136.203642, 58.174416 ], [ -136.199854, 58.180871 ], [ -136.162108, 58.218724 ], [ -136.139007, 58.224393 ], [ -136.036160, 58.219210 ], [ -136.033030, 58.205462 ], [ -135.976386, 58.202029 ], [ -135.966119, 58.211386 ], [ -135.914178, 58.244073 ], [ -135.823562, 58.282975 ], [ -135.801133, 58.287716 ], [ -135.783380, 58.286709 ], [ -135.764372, 58.266276 ], [ -135.735100, 58.240213 ], [ -135.712398, 58.231892 ], [ -135.630521, 58.222933 ], [ -135.589198, 58.213677 ], [ -135.522646, 58.185909 ], [ -135.504671, 58.174914 ], [ -135.497911, 58.168882 ], [ -135.524668, 58.120750 ], [ -135.540712, 58.101750 ], [ -135.586820, 58.081670 ], [ -135.651368, 58.036484 ], [ -135.638490, 57.994508 ], [ -135.621582, 57.984623 ], [ -135.593287, 57.989636 ], [ -135.581753, 57.997568 ], [ -135.564307, 58.015007 ], [ -135.567817, 58.023420 ], [ -135.565443, 58.041120 ], [ -135.563434, 58.043491 ], [ -135.544529, 58.060880 ], [ -135.496739, 58.086212 ], [ -135.451444, 58.134348 ], [ -135.420107, 58.144202 ], [ -135.411777, 58.145473 ], [ -135.397518, 58.144155 ], [ -135.275797, 58.097024 ], [ -135.260951, 58.097323 ], [ -135.108896, 58.088270 ], [ -135.084832, 58.080869 ], [ -135.082981, 58.074737 ], [ -135.070700, 58.061242 ], [ -134.977183, 58.049943 ], [ -134.967723, 58.047625 ], [ -134.950844, 58.036993 ], [ -134.935005, 58.021639 ], [ -134.912854, 57.979287 ], [ -134.921104, 57.935298 ], [ -134.926395, 57.921919 ], [ -135.004952, 57.884338 ], [ -135.140674, 57.926114 ], [ -135.173712, 57.919399 ], [ -135.165220, 57.901524 ], [ -135.146717, 57.891656 ], [ -135.131957, 57.885241 ], [ -135.065720, 57.869451 ], [ -134.991819, 57.835436 ], [ -134.954547, 57.815785 ], [ -134.949436, 57.805027 ], [ -135.023370, 57.780537 ], [ -135.198960, 57.775092 ], [ -135.225158, 57.777783 ], [ -135.313776, 57.805739 ], [ -135.343991, 57.821444 ], [ -135.389894, 57.850991 ], [ -135.418517, 57.860506 ], [ -135.514151, 57.885371 ], [ -135.552802, 57.902711 ], [ -135.581326, 57.903056 ], [ -135.587961, 57.897320 ] ] ], [ [ [ -134.666587, 56.169947 ], [ -134.668151, 56.167026 ], [ -134.674028, 56.166925 ], [ -134.705007, 56.175722 ], [ -134.806163, 56.235533 ], [ -134.824902, 56.279692 ], [ -134.839411, 56.309403 ], [ -134.915911, 56.360555 ], [ -134.945704, 56.389710 ], [ -134.990763, 56.457998 ], [ -135.023780, 56.499977 ], [ -135.054049, 56.527658 ], [ -135.058238, 56.529453 ], [ -135.060878, 56.541965 ], [ -135.056756, 56.570611 ], [ -135.045054, 56.583392 ], [ -135.026740, 56.594625 ], [ -135.005249, 56.602252 ], [ -134.997669, 56.597272 ], [ -134.985881, 56.595844 ], [ -134.967164, 56.603026 ], [ -134.969842, 56.615392 ], [ -134.979386, 56.627676 ], [ -134.998369, 56.630017 ], [ -135.029747, 56.628918 ], [ -135.036432, 56.619628 ], [ -135.065693, 56.607852 ], [ -135.091611, 56.600068 ], [ -135.103271, 56.597927 ], [ -135.118709, 56.597728 ], [ -135.123389, 56.602823 ], [ -135.148836, 56.648915 ], [ -135.147761, 56.651932 ], [ -135.175826, 56.677876 ], [ -135.224142, 56.687858 ], [ -135.274910, 56.701633 ], [ -135.305077, 56.726382 ], [ -135.317429, 56.743311 ], [ -135.318082, 56.748688 ], [ -135.296430, 56.756294 ], [ -135.281608, 56.758528 ], [ -135.280875, 56.768357 ], [ -135.310159, 56.778093 ], [ -135.352176, 56.771196 ], [ -135.398678, 56.779201 ], [ -135.412989, 56.810079 ], [ -135.408542, 56.826014 ], [ -135.368899, 56.892589 ], [ -135.347244, 56.899980 ], [ -135.332356, 56.913951 ], [ -135.354090, 56.936500 ], [ -135.379725, 56.953039 ], [ -135.383376, 56.981544 ], [ -135.360232, 57.002231 ], [ -135.342801, 57.001874 ], [ -135.329492, 57.004507 ], [ -135.325216, 57.010866 ], [ -135.312780, 57.044984 ], [ -135.333998, 57.050403 ], [ -135.349229, 57.041535 ], [ -135.374100, 57.045391 ], [ -135.377763, 57.052910 ], [ -135.369858, 57.057923 ], [ -135.365710, 57.066062 ], [ -135.378337, 57.081622 ], [ -135.384617, 57.087725 ], [ -135.388859, 57.089026 ], [ -135.401721, 57.098654 ], [ -135.404140, 57.109318 ], [ -135.405293, 57.114508 ], [ -135.406158, 57.119697 ], [ -135.405293, 57.138149 ], [ -135.409703, 57.148861 ], [ -135.422746, 57.167724 ], [ -135.399312, 57.185003 ], [ -135.372441, 57.198063 ], [ -135.377580, 57.206302 ], [ -135.372021, 57.228003 ], [ -135.361771, 57.233591 ], [ -135.358715, 57.243776 ], [ -135.366177, 57.248852 ], [ -135.406086, 57.251678 ], [ -135.414799, 57.251324 ], [ -135.429229, 57.247213 ], [ -135.449073, 57.248104 ], [ -135.470189, 57.255752 ], [ -135.477683, 57.256824 ], [ -135.503121, 57.253809 ], [ -135.511241, 57.247077 ], [ -135.552574, 57.233194 ], [ -135.561883, 57.241868 ], [ -135.561853, 57.244067 ], [ -135.568954, 57.255186 ], [ -135.602297, 57.285707 ], [ -135.604161, 57.290437 ], [ -135.600688, 57.294074 ], [ -135.601782, 57.300772 ], [ -135.631415, 57.311568 ], [ -135.637423, 57.315276 ], [ -135.638209, 57.320278 ], [ -135.674687, 57.336747 ], [ -135.684597, 57.350328 ], [ -135.695563, 57.357460 ], [ -135.695120, 57.363077 ], [ -135.687696, 57.367477 ], [ -135.659614, 57.373907 ], [ -135.639556, 57.371883 ], [ -135.630627, 57.379595 ], [ -135.628016, 57.383393 ], [ -135.627022, 57.388207 ], [ -135.633573, 57.394211 ], [ -135.633654, 57.399102 ], [ -135.626007, 57.399578 ], [ -135.604184, 57.409932 ], [ -135.585395, 57.416811 ], [ -135.570872, 57.417459 ], [ -135.554548, 57.426636 ], [ -135.555321, 57.436738 ], [ -135.557806, 57.438236 ], [ -135.560990, 57.437455 ], [ -135.561916, 57.438505 ], [ -135.562234, 57.440413 ], [ -135.562234, 57.442720 ], [ -135.558496, 57.444788 ], [ -135.556109, 57.446458 ], [ -135.540158, 57.446241 ], [ -135.534221, 57.450252 ], [ -135.532069, 57.481117 ], [ -135.548794, 57.508977 ], [ -135.526036, 57.509697 ], [ -135.491537, 57.531687 ], [ -135.443404, 57.556876 ], [ -135.419205, 57.564159 ], [ -135.355749, 57.553568 ], [ -135.347597, 57.550232 ], [ -135.322925, 57.533476 ], [ -135.294491, 57.510836 ], [ -135.294837, 57.508720 ], [ -135.308458, 57.495201 ], [ -135.297784, 57.483721 ], [ -135.265557, 57.480860 ], [ -135.246114, 57.483598 ], [ -135.227293, 57.489838 ], [ -135.209123, 57.488753 ], [ -135.161017, 57.460713 ], [ -135.168056, 57.454212 ], [ -135.159206, 57.445568 ], [ -135.145949, 57.439049 ], [ -135.065050, 57.418972 ], [ -135.039634, 57.418131 ], [ -135.026566, 57.420497 ], [ -134.926516, 57.422267 ], [ -134.893440, 57.420044 ], [ -134.849477, 57.409670 ], [ -134.806352, 57.341888 ], [ -134.812769, 57.299765 ], [ -134.829365, 57.294098 ], [ -134.835211, 57.300315 ], [ -134.884780, 57.330003 ], [ -134.921651, 57.330713 ], [ -134.951267, 57.328660 ], [ -134.953951, 57.323723 ], [ -134.955014, 57.309433 ], [ -134.953011, 57.306131 ], [ -134.946626, 57.303164 ], [ -134.922329, 57.303708 ], [ -134.879535, 57.288177 ], [ -134.854948, 57.264766 ], [ -134.841774, 57.248588 ], [ -134.755886, 57.058035 ], [ -134.737880, 57.009935 ], [ -134.738300, 56.968059 ], [ -134.740135, 56.948481 ], [ -134.719275, 56.929031 ], [ -134.695735, 56.900791 ], [ -134.699099, 56.850864 ], [ -134.674238, 56.825177 ], [ -134.663434, 56.804687 ], [ -134.633997, 56.728722 ], [ -134.619799, 56.665888 ], [ -134.615955, 56.637289 ], [ -134.626943, 56.553868 ], [ -134.634207, 56.540968 ], [ -134.639732, 56.538835 ], [ -134.671047, 56.541200 ], [ -134.669778, 56.524129 ], [ -134.663839, 56.503183 ], [ -134.658622, 56.494676 ], [ -134.655174, 56.492033 ], [ -134.645308, 56.472215 ], [ -134.636506, 56.405625 ], [ -134.634010, 56.315840 ], [ -134.634411, 56.285341 ], [ -134.634668, 56.265832 ], [ -134.653827, 56.198385 ], [ -134.659870, 56.182494 ], [ -134.666587, 56.169947 ] ] ], [ [ [ -135.703464, 57.322040 ], [ -135.702919, 57.315582 ], [ -135.705483, 57.308557 ], [ -135.688233, 57.276143 ], [ -135.657272, 57.262027 ], [ -135.655008, 57.258240 ], [ -135.654898, 57.254742 ], [ -135.658859, 57.247964 ], [ -135.658600, 57.245541 ], [ -135.656363, 57.243036 ], [ -135.637289, 57.236124 ], [ -135.621346, 57.223693 ], [ -135.620735, 57.217885 ], [ -135.604953, 57.184204 ], [ -135.596921, 57.161196 ], [ -135.602057, 57.149161 ], [ -135.598600, 57.145360 ], [ -135.592379, 57.142683 ], [ -135.581473, 57.150599 ], [ -135.575674, 57.150530 ], [ -135.565707, 57.147312 ], [ -135.565756, 57.137344 ], [ -135.575722, 57.104231 ], [ -135.574693, 57.094339 ], [ -135.635347, 57.022411 ], [ -135.650540, 57.015139 ], [ -135.680520, 57.017342 ], [ -135.753682, 57.008258 ], [ -135.764949, 57.006094 ], [ -135.767654, 57.000428 ], [ -135.772432, 56.997301 ], [ -135.821915, 56.988215 ], [ -135.854131, 56.995043 ], [ -135.857028, 56.997287 ], [ -135.852146, 57.029699 ], [ -135.841819, 57.070899 ], [ -135.834890, 57.091387 ], [ -135.805945, 57.106778 ], [ -135.776975, 57.112555 ], [ -135.755997, 57.121225 ], [ -135.735559, 57.151755 ], [ -135.735405, 57.155403 ], [ -135.752591, 57.168834 ], [ -135.762241, 57.173341 ], [ -135.785583, 57.177929 ], [ -135.800824, 57.173655 ], [ -135.824388, 57.192862 ], [ -135.833896, 57.254233 ], [ -135.828831, 57.301981 ], [ -135.840359, 57.314342 ], [ -135.855849, 57.319960 ], [ -135.859572, 57.323108 ], [ -135.860558, 57.330854 ], [ -135.851162, 57.336916 ], [ -135.838568, 57.338756 ], [ -135.761471, 57.342631 ], [ -135.730323, 57.337286 ], [ -135.715233, 57.330722 ], [ -135.703464, 57.322040 ] ] ], [ [ [ -147.562801, 60.579821 ], [ -147.555392, 60.574059 ], [ -147.551709, 60.559612 ], [ -147.565775, 60.534713 ], [ -147.607756, 60.506920 ], [ -147.623835, 60.465878 ], [ -147.619972, 60.436821 ], [ -147.674351, 60.414430 ], [ -147.690773, 60.405054 ], [ -147.681888, 60.388167 ], [ -147.630081, 60.389550 ], [ -147.622020, 60.383794 ], [ -147.618906, 60.368848 ], [ -147.639474, 60.340579 ], [ -147.671135, 60.308929 ], [ -147.703599, 60.285589 ], [ -147.698608, 60.245552 ], [ -147.704731, 60.227874 ], [ -147.720124, 60.202002 ], [ -147.760681, 60.156396 ], [ -147.766484, 60.154180 ], [ -147.783583, 60.161073 ], [ -147.820159, 60.179555 ], [ -147.845681, 60.195434 ], [ -147.832285, 60.197855 ], [ -147.827991, 60.200630 ], [ -147.828962, 60.207442 ], [ -147.855453, 60.216419 ], [ -147.908985, 60.224359 ], [ -147.945158, 60.222324 ], [ -147.956228, 60.228667 ], [ -147.950532, 60.243791 ], [ -147.933269, 60.273632 ], [ -147.837456, 60.414452 ], [ -147.792822, 60.476193 ], [ -147.782548, 60.483300 ], [ -147.778269, 60.484007 ], [ -147.765825, 60.476505 ], [ -147.779329, 60.457078 ], [ -147.750864, 60.440981 ], [ -147.738151, 60.441277 ], [ -147.715312, 60.447915 ], [ -147.709160, 60.451883 ], [ -147.717097, 60.467282 ], [ -147.726642, 60.472216 ], [ -147.726460, 60.502533 ], [ -147.721824, 60.508635 ], [ -147.613843, 60.565906 ], [ -147.566372, 60.580849 ], [ -147.562801, 60.579821 ] ] ], [ [ [ -147.444468, 60.699654 ], [ -147.384779, 60.710017 ], [ -147.308537, 60.666793 ], [ -147.302915, 60.660673 ], [ -147.337429, 60.632685 ], [ -147.344494, 60.628544 ], [ -147.457407, 60.619090 ], [ -147.486045, 60.619348 ], [ -147.501603, 60.654772 ], [ -147.486484, 60.686582 ], [ -147.479814, 60.693593 ], [ -147.449559, 60.700046 ], [ -147.444468, 60.699654 ] ] ], [ [ [ -147.952039, 60.741879 ], [ -147.906021, 60.735515 ], [ -147.848176, 60.698116 ], [ -147.846103, 60.694509 ], [ -147.860057, 60.677233 ], [ -147.868067, 60.670825 ], [ -147.932931, 60.655714 ], [ -147.970684, 60.673799 ], [ -148.020259, 60.724950 ], [ -147.965419, 60.751996 ], [ -147.957239, 60.747706 ], [ -147.952039, 60.741879 ] ] ], [ [ [ -147.131319, 60.912932 ], [ -147.115336, 60.911938 ], [ -147.077772, 60.899503 ], [ -147.071788, 60.893833 ], [ -147.089645, 60.874693 ], [ -147.126799, 60.858011 ], [ -147.141802, 60.853991 ], [ -147.192354, 60.861635 ], [ -147.217749, 60.869741 ], [ -147.253128, 60.872969 ], [ -147.309086, 60.873924 ], [ -147.325640, 60.877153 ], [ -147.321084, 60.880198 ], [ -147.226303, 60.910421 ], [ -147.210324, 60.908776 ], [ -147.193399, 60.902949 ], [ -147.178969, 60.903704 ], [ -147.131319, 60.912932 ] ] ], [ [ [ -147.217704, 60.293504 ], [ -147.194940, 60.304563 ], [ -147.183277, 60.320680 ], [ -147.185243, 60.323083 ], [ -147.195608, 60.326224 ], [ -147.211625, 60.324936 ], [ -147.215312, 60.327109 ], [ -147.218799, 60.334726 ], [ -147.214679, 60.343793 ], [ -147.211582, 60.346260 ], [ -147.147514, 60.372470 ], [ -147.112667, 60.380982 ], [ -147.098703, 60.378697 ], [ -147.091897, 60.374969 ], [ -147.089363, 60.369126 ], [ -147.092717, 60.363396 ], [ -147.104010, 60.356727 ], [ -147.095483, 60.341964 ], [ -147.073932, 60.338982 ], [ -147.013164, 60.343863 ], [ -147.006138, 60.343119 ], [ -147.003839, 60.340310 ], [ -147.004091, 60.334348 ], [ -147.015307, 60.322548 ], [ -147.089866, 60.292106 ], [ -147.103118, 60.280190 ], [ -147.104107, 60.277155 ], [ -147.080463, 60.265355 ], [ -147.064768, 60.270188 ], [ -146.962633, 60.311911 ], [ -146.944024, 60.316020 ], [ -146.916164, 60.314898 ], [ -146.911772, 60.309807 ], [ -146.911377, 60.297593 ], [ -146.948089, 60.269974 ], [ -147.002067, 60.232453 ], [ -147.139641, 60.179058 ], [ -147.202416, 60.151128 ], [ -147.253868, 60.113852 ], [ -147.365424, 60.042867 ], [ -147.388508, 60.011116 ], [ -147.388686, 60.004301 ], [ -147.438369, 59.974680 ], [ -147.493235, 59.955388 ], [ -147.499783, 59.951069 ], [ -147.505311, 59.937494 ], [ -147.499625, 59.926296 ], [ -147.494317, 59.922756 ], [ -147.483056, 59.920873 ], [ -147.476312, 59.921563 ], [ -147.448681, 59.915892 ], [ -147.443678, 59.913543 ], [ -147.452360, 59.880518 ], [ -147.466920, 59.870100 ], [ -147.533041, 59.852401 ], [ -147.541643, 59.853282 ], [ -147.540437, 59.857264 ], [ -147.542664, 59.861336 ], [ -147.571278, 59.868709 ], [ -147.596339, 59.868872 ], [ -147.621980, 59.866484 ], [ -147.651738, 59.851223 ], [ -147.657015, 59.844035 ], [ -147.657048, 59.839497 ], [ -147.660388, 59.832248 ], [ -147.677139, 59.821368 ], [ -147.693869, 59.819070 ], [ -147.727499, 59.819780 ], [ -147.738538, 59.822949 ], [ -147.745417, 59.821844 ], [ -147.810788, 59.802233 ], [ -147.831008, 59.790043 ], [ -147.874097, 59.783260 ], [ -147.912883, 59.792240 ], [ -147.924906, 59.799712 ], [ -147.928064, 59.803496 ], [ -147.908247, 59.852832 ], [ -147.895411, 59.869145 ], [ -147.877936, 59.879678 ], [ -147.856693, 59.886661 ], [ -147.808272, 59.888148 ], [ -147.797213, 59.909477 ], [ -147.809035, 59.923480 ], [ -147.804252, 59.936497 ], [ -147.739635, 59.968008 ], [ -147.728869, 59.969509 ], [ -147.707445, 59.964151 ], [ -147.690642, 59.963236 ], [ -147.686280, 59.964476 ], [ -147.659569, 59.980064 ], [ -147.662645, 59.986676 ], [ -147.647042, 60.005649 ], [ -147.555529, 60.051131 ], [ -147.479543, 60.076653 ], [ -147.451490, 60.087920 ], [ -147.433254, 60.096159 ], [ -147.406000, 60.112631 ], [ -147.388701, 60.126473 ], [ -147.319715, 60.190581 ], [ -147.315691, 60.202891 ], [ -147.322841, 60.214784 ], [ -147.312081, 60.222871 ], [ -147.281373, 60.226812 ], [ -147.249786, 60.228589 ], [ -147.244310, 60.231298 ], [ -147.219108, 60.253513 ], [ -147.206150, 60.269508 ], [ -147.217704, 60.293504 ] ] ], [ [ [ -179.069176, 51.262874 ], [ -179.072320, 51.250963 ], [ -179.097619, 51.226135 ], [ -179.126856, 51.219862 ], [ -179.136196, 51.229216 ], [ -179.147340, 51.276781 ], [ -179.137239, 51.286006 ], [ -179.113495, 51.300801 ], [ -179.094665, 51.301229 ], [ -179.075466, 51.284619 ], [ -179.069176, 51.262874 ] ] ], [ [ [ -178.954338, 51.339247 ], [ -178.954460, 51.332731 ], [ -178.965171, 51.322682 ], [ -178.979179, 51.314380 ], [ -178.987236, 51.311038 ], [ -178.990684, 51.311648 ], [ -178.992094, 51.381311 ], [ -178.977782, 51.398929 ], [ -178.964323, 51.402492 ], [ -178.926874, 51.383640 ], [ -178.914207, 51.363992 ], [ -178.908883, 51.340582 ], [ -178.954338, 51.339247 ] ] ], [ [ [ 178.785825, 51.633434 ], [ 178.804128, 51.635034 ], [ 178.864937, 51.623133 ], [ 178.903910, 51.614914 ], [ 178.919136, 51.605546 ], [ 178.917608, 51.594949 ], [ 178.918827, 51.588337 ], [ 178.920826, 51.586137 ], [ 179.002896, 51.552486 ], [ 179.076803, 51.498518 ], [ 179.101442, 51.485497 ], [ 179.143656, 51.469442 ], [ 179.164531, 51.464635 ], [ 179.178081, 51.464812 ], [ 179.191082, 51.462935 ], [ 179.218031, 51.438940 ], [ 179.226883, 51.423941 ], [ 179.230270, 51.413419 ], [ 179.236253, 51.409606 ], [ 179.263934, 51.405838 ], [ 179.334980, 51.404933 ], [ 179.386221, 51.404401 ], [ 179.400809, 51.400557 ], [ 179.462765, 51.376176 ], [ 179.467581, 51.371629 ], [ 179.450191, 51.365142 ], [ 179.399469, 51.359433 ], [ 179.389855, 51.361004 ], [ 179.384679, 51.364210 ], [ 179.366788, 51.371837 ], [ 179.261618, 51.357688 ], [ 179.220471, 51.376667 ], [ 179.218185, 51.387377 ], [ 179.206500, 51.393284 ], [ 179.097477, 51.440580 ], [ 179.060354, 51.454875 ], [ 179.034532, 51.478530 ], [ 179.013516, 51.497280 ], [ 178.969019, 51.531237 ], [ 178.951626, 51.541963 ], [ 178.843631, 51.578642 ], [ 178.831825, 51.580534 ], [ 178.795194, 51.575429 ], [ 178.785061, 51.571866 ], [ 178.767787, 51.576123 ], [ 178.706047, 51.593182 ], [ 178.634021, 51.623981 ], [ 178.631609, 51.625782 ], [ 178.625536, 51.637303 ], [ 178.645511, 51.657634 ], [ 178.664013, 51.661935 ], [ 178.675528, 51.659064 ], [ 178.681998, 51.649946 ], [ 178.689903, 51.644422 ], [ 178.738019, 51.632734 ], [ 178.785825, 51.633434 ] ] ], [ [ [ -176.762478, 51.867878 ], [ -176.797799, 51.908512 ], [ -176.810433, 51.927089 ], [ -176.789558, 51.957211 ], [ -176.774023, 51.965895 ], [ -176.736549, 51.969808 ], [ -176.720780, 51.969518 ], [ -176.698771, 51.964454 ], [ -176.630510, 51.970352 ], [ -176.627155, 51.978294 ], [ -176.603598, 51.997056 ], [ -176.589955, 52.002741 ], [ -176.579975, 52.003238 ], [ -176.560565, 51.996732 ], [ -176.554398, 51.990660 ], [ -176.544867, 51.927245 ], [ -176.554661, 51.909834 ], [ -176.558376, 51.908725 ], [ -176.566275, 51.914702 ], [ -176.568916, 51.921300 ], [ -176.565559, 51.925862 ], [ -176.569683, 51.951324 ], [ -176.575635, 51.952641 ], [ -176.578931, 51.951328 ], [ -176.582927, 51.947964 ], [ -176.616095, 51.903013 ], [ -176.620015, 51.895630 ], [ -176.623452, 51.883205 ], [ -176.625463, 51.859824 ], [ -176.576381, 51.842275 ], [ -176.543309, 51.838624 ], [ -176.517599, 51.839557 ], [ -176.507989, 51.845970 ], [ -176.398062, 51.867842 ], [ -176.311573, 51.872463 ], [ -176.290728, 51.872136 ], [ -176.287188, 51.870313 ], [ -176.281694, 51.863919 ], [ -176.266490, 51.817716 ], [ -176.268243, 51.785498 ], [ -176.273792, 51.772019 ], [ -176.289921, 51.741678 ], [ -176.343756, 51.731520 ], [ -176.474132, 51.747208 ], [ -176.497054, 51.761426 ], [ -176.509655, 51.763326 ], [ -176.519330, 51.758482 ], [ -176.582933, 51.691822 ], [ -176.608482, 51.693349 ], [ -176.702660, 51.685404 ], [ -176.713062, 51.683330 ], [ -176.735912, 51.662154 ], [ -176.751817, 51.635017 ], [ -176.801675, 51.613488 ], [ -176.809000, 51.616235 ], [ -176.823682, 51.634011 ], [ -176.826252, 51.640932 ], [ -176.814437, 51.660250 ], [ -176.837514, 51.682745 ], [ -176.863062, 51.684921 ], [ -176.903184, 51.635648 ], [ -176.930952, 51.592470 ], [ -176.938917, 51.590982 ], [ -176.954147, 51.592568 ], [ -176.984331, 51.602135 ], [ -176.987383, 51.606872 ], [ -176.991322, 51.629052 ], [ -176.984489, 51.657411 ], [ -176.976249, 51.666400 ], [ -176.950128, 51.686719 ], [ -176.930872, 51.697195 ], [ -176.906884, 51.696639 ], [ -176.896966, 51.700424 ], [ -176.873924, 51.724071 ], [ -176.870997, 51.729410 ], [ -176.870700, 51.731969 ], [ -176.882018, 51.766628 ], [ -176.905030, 51.771532 ], [ -176.918065, 51.788003 ], [ -176.917088, 51.797016 ], [ -176.911016, 51.807597 ], [ -176.904302, 51.811772 ], [ -176.856205, 51.818366 ], [ -176.790163, 51.817217 ], [ -176.762478, 51.867878 ] ] ], [ [ [ -177.800647, 51.778294 ], [ -177.796308, 51.770831 ], [ -177.813886, 51.754280 ], [ -177.842267, 51.732480 ], [ -177.842419, 51.722645 ], [ -177.838054, 51.717198 ], [ -177.827524, 51.712086 ], [ -177.826997, 51.705972 ], [ -177.841411, 51.689560 ], [ -177.856332, 51.681015 ], [ -177.867960, 51.679374 ], [ -177.876811, 51.681411 ], [ -177.887768, 51.689483 ], [ -177.899416, 51.692557 ], [ -177.902693, 51.691581 ], [ -177.918806, 51.674390 ], [ -177.928907, 51.655368 ], [ -177.929023, 51.650520 ], [ -177.925640, 51.642481 ], [ -177.915445, 51.630684 ], [ -177.903083, 51.606497 ], [ -177.906072, 51.597670 ], [ -177.909185, 51.596671 ], [ -177.930123, 51.601499 ], [ -177.944957, 51.611539 ], [ -177.950665, 51.620001 ], [ -177.953024, 51.638175 ], [ -177.957443, 51.647149 ], [ -177.963852, 51.650231 ], [ -178.069823, 51.670676 ], [ -178.086304, 51.663618 ], [ -178.109378, 51.670461 ], [ -178.117864, 51.677831 ], [ -178.104285, 51.701539 ], [ -178.021818, 51.706906 ], [ -177.962426, 51.719772 ], [ -177.956443, 51.722862 ], [ -177.947777, 51.740381 ], [ -177.946649, 51.752681 ], [ -177.950283, 51.765682 ], [ -177.956998, 51.772541 ], [ -177.965031, 51.778162 ], [ -177.995272, 51.781535 ], [ -178.039344, 51.778925 ], [ -178.059335, 51.786829 ], [ -178.080640, 51.798739 ], [ -178.086074, 51.808047 ], [ -178.172666, 51.839985 ], [ -178.215124, 51.857801 ], [ -178.224129, 51.864881 ], [ -178.227822, 51.873526 ], [ -178.224618, 51.880675 ], [ -178.220742, 51.884841 ], [ -178.197090, 51.905464 ], [ -178.175023, 51.911584 ], [ -178.145326, 51.917216 ], [ -178.124786, 51.920093 ], [ -178.090632, 51.919399 ], [ -178.070548, 51.917408 ], [ -178.061147, 51.912539 ], [ -178.002345, 51.909968 ], [ -177.963723, 51.917919 ], [ -177.952094, 51.915348 ], [ -177.913269, 51.879748 ], [ -177.924315, 51.857522 ], [ -177.921569, 51.853883 ], [ -177.859763, 51.826944 ], [ -177.852285, 51.826045 ], [ -177.759641, 51.831195 ], [ -177.691714, 51.843975 ], [ -177.615311, 51.855080 ], [ -177.614511, 51.853033 ], [ -177.625008, 51.837529 ], [ -177.649208, 51.820727 ], [ -177.685555, 51.812745 ], [ -177.692118, 51.813897 ], [ -177.735909, 51.807991 ], [ -177.797719, 51.793297 ], [ -177.800647, 51.778294 ] ] ], [ [ [ -177.360408, 51.727533 ], [ -177.390760, 51.733525 ], [ -177.417678, 51.730875 ], [ -177.444717, 51.725419 ], [ -177.463577, 51.713943 ], [ -177.490005, 51.705106 ], [ -177.540393, 51.698755 ], [ -177.570973, 51.698220 ], [ -177.608055, 51.705184 ], [ -177.616753, 51.703978 ], [ -177.631523, 51.696844 ], [ -177.640524, 51.672084 ], [ -177.635883, 51.659541 ], [ -177.651386, 51.653604 ], [ -177.670951, 51.663980 ], [ -177.707802, 51.703268 ], [ -177.705261, 51.707240 ], [ -177.697662, 51.713123 ], [ -177.639983, 51.736061 ], [ -177.597498, 51.726464 ], [ -177.555197, 51.721125 ], [ -177.536977, 51.721470 ], [ -177.515591, 51.724978 ], [ -177.497974, 51.738624 ], [ -177.461200, 51.750718 ], [ -177.281479, 51.784075 ], [ -177.238175, 51.798520 ], [ -177.211930, 51.812331 ], [ -177.205675, 51.820639 ], [ -177.200825, 51.844605 ], [ -177.199120, 51.883142 ], [ -177.199764, 51.924816 ], [ -177.197506, 51.931339 ], [ -177.191399, 51.938001 ], [ -177.181271, 51.943167 ], [ -177.154842, 51.944381 ], [ -177.099266, 51.936119 ], [ -177.054768, 51.908944 ], [ -177.045090, 51.898605 ], [ -177.081010, 51.855497 ], [ -177.120377, 51.839687 ], [ -177.128617, 51.833835 ], [ -177.136977, 51.814493 ], [ -177.130960, 51.762772 ], [ -177.120581, 51.739815 ], [ -177.122808, 51.729355 ], [ -177.145675, 51.707294 ], [ -177.261631, 51.680846 ], [ -177.275121, 51.680510 ], [ -177.296369, 51.684245 ], [ -177.316501, 51.690353 ], [ -177.317888, 51.693447 ], [ -177.317939, 51.696866 ], [ -177.316353, 51.700811 ], [ -177.322977, 51.711416 ], [ -177.342784, 51.721395 ], [ -177.360408, 51.727533 ] ] ], [ [ [ -178.792409, 51.746071 ], [ -178.808157, 51.747078 ], [ -178.815757, 51.749176 ], [ -178.873024, 51.782623 ], [ -178.870118, 51.795261 ], [ -178.858248, 51.820966 ], [ -178.828645, 51.836150 ], [ -178.819459, 51.839575 ], [ -178.811249, 51.839018 ], [ -178.788541, 51.832602 ], [ -178.767695, 51.823179 ], [ -178.748283, 51.809942 ], [ -178.733355, 51.783947 ], [ -178.750414, 51.757752 ], [ -178.776661, 51.748612 ], [ -178.792409, 51.746071 ] ] ], [ [ [ 178.380741, 51.763907 ], [ 178.367465, 51.772758 ], [ 178.363680, 51.773948 ], [ 178.339082, 51.771529 ], [ 178.335664, 51.769926 ], [ 178.318757, 51.772322 ], [ 178.308563, 51.775701 ], [ 178.304892, 51.777434 ], [ 178.246209, 51.817078 ], [ 178.236931, 51.828209 ], [ 178.305568, 51.821748 ], [ 178.310298, 51.819993 ], [ 178.319389, 51.815737 ], [ 178.332190, 51.809037 ], [ 178.335631, 51.807031 ], [ 178.372348, 51.774146 ], [ 178.380741, 51.763907 ] ] ], [ [ [ -175.971562, 51.888631 ], [ -175.957546, 51.893455 ], [ -175.953251, 51.881376 ], [ -175.954287, 51.868381 ], [ -175.963041, 51.846253 ], [ -175.983742, 51.852352 ], [ -176.047892, 51.846309 ], [ -176.101070, 51.810609 ], [ -176.123965, 51.802745 ], [ -176.139622, 51.802386 ], [ -176.183142, 51.807099 ], [ -176.216957, 51.812714 ], [ -176.235544, 51.823157 ], [ -176.236246, 51.825965 ], [ -176.217544, 51.874627 ], [ -176.206069, 51.883089 ], [ -176.173871, 51.882449 ], [ -176.169751, 51.880138 ], [ -176.168775, 51.877330 ], [ -176.161052, 51.869685 ], [ -176.140908, 51.859562 ], [ -176.099137, 51.855533 ], [ -176.080442, 51.858567 ], [ -176.072225, 51.867938 ], [ -176.073431, 51.870312 ], [ -176.078865, 51.874778 ], [ -176.115489, 51.887015 ], [ -176.111452, 51.889748 ], [ -176.065288, 51.902986 ], [ -176.020182, 51.911373 ], [ -175.992650, 51.912655 ], [ -175.984993, 51.908445 ], [ -175.971562, 51.888631 ] ] ], [ [ [ 177.601645, 52.016377 ], [ 177.577226, 52.004970 ], [ 177.572068, 52.001812 ], [ 177.538223, 51.978897 ], [ 177.532729, 51.970070 ], [ 177.539627, 51.959418 ], [ 177.543534, 51.956175 ], [ 177.571796, 51.951590 ], [ 177.579823, 51.950836 ], [ 177.607535, 51.954720 ], [ 177.611553, 51.950829 ], [ 177.610618, 51.936713 ], [ 177.606529, 51.925069 ], [ 177.601005, 51.922254 ], [ 177.560513, 51.916364 ], [ 177.484313, 51.923413 ], [ 177.409536, 51.930821 ], [ 177.373934, 51.919760 ], [ 177.348816, 51.904469 ], [ 177.326781, 51.873636 ], [ 177.327179, 51.871049 ], [ 177.334229, 51.866769 ], [ 177.334017, 51.844444 ], [ 177.321687, 51.828543 ], [ 177.311768, 51.825971 ], [ 177.303314, 51.829458 ], [ 177.294035, 51.837301 ], [ 177.296018, 51.839866 ], [ 177.293424, 51.845610 ], [ 177.273370, 51.857123 ], [ 177.235523, 51.873260 ], [ 177.212422, 51.876431 ], [ 177.203996, 51.880531 ], [ 177.200423, 51.894746 ], [ 177.203323, 51.896562 ], [ 177.233904, 51.909624 ], [ 177.272695, 51.920054 ], [ 177.291312, 51.919430 ], [ 177.341518, 51.955016 ], [ 177.345577, 51.963005 ], [ 177.413484, 51.979724 ], [ 177.483712, 51.984877 ], [ 177.497441, 51.993328 ], [ 177.503441, 52.008829 ], [ 177.505747, 52.016374 ], [ 177.505319, 52.038768 ], [ 177.545604, 52.101091 ], [ 177.563396, 52.121959 ], [ 177.602673, 52.137320 ], [ 177.661607, 52.112746 ], [ 177.675952, 52.092167 ], [ 177.667256, 52.076274 ], [ 177.659451, 52.069439 ], [ 177.653614, 52.070323 ], [ 177.641864, 52.068316 ], [ 177.632555, 52.064844 ], [ 177.609087, 52.028518 ], [ 177.601645, 52.016377 ] ] ], [ [ [ 179.758993, 51.946595 ], [ 179.751525, 51.923933 ], [ 179.743012, 51.911749 ], [ 179.734772, 51.907606 ], [ 179.649484, 51.873670 ], [ 179.639077, 51.871931 ], [ 179.614364, 51.871772 ], [ 179.521868, 51.896765 ], [ 179.484634, 51.921268 ], [ 179.475569, 51.937456 ], [ 179.482464, 51.982834 ], [ 179.486565, 51.983959 ], [ 179.515025, 51.983751 ], [ 179.526743, 51.981164 ], [ 179.539223, 51.985178 ], [ 179.571049, 52.011111 ], [ 179.582857, 52.016841 ], [ 179.622283, 52.024975 ], [ 179.647641, 52.026259 ], [ 179.663327, 52.022941 ], [ 179.704433, 52.004877 ], [ 179.773922, 51.970693 ], [ 179.778470, 51.962217 ], [ 179.777158, 51.958700 ], [ 179.767251, 51.947572 ], [ 179.758993, 51.946595 ] ] ], [ [ [ 178.446964, 51.978222 ], [ 178.463385, 51.987849 ], [ 178.478586, 51.987549 ], [ 178.552612, 51.973968 ], [ 178.570619, 51.968064 ], [ 178.591597, 51.952652 ], [ 178.590245, 51.945457 ], [ 178.567447, 51.925939 ], [ 178.539395, 51.903246 ], [ 178.518861, 51.899759 ], [ 178.502493, 51.899644 ], [ 178.484831, 51.909898 ], [ 178.468045, 51.931635 ], [ 178.454664, 51.960501 ], [ 178.446964, 51.978222 ] ] ], [ [ [ -175.680144, 51.968970 ], [ -175.672640, 51.972471 ], [ -175.669707, 51.972166 ], [ -175.655056, 51.966651 ], [ -175.652493, 51.964813 ], [ -175.653194, 51.961669 ], [ -175.717436, 51.933695 ], [ -175.730011, 51.933817 ], [ -175.747438, 51.946200 ], [ -175.747836, 51.950655 ], [ -175.742618, 51.966632 ], [ -175.735477, 51.973331 ], [ -175.726245, 51.975969 ], [ -175.680144, 51.968970 ] ] ], [ [ [ -176.018089, 52.020099 ], [ -176.044001, 52.009331 ], [ -176.032156, 51.993667 ], [ -176.027546, 51.991630 ], [ -176.021839, 51.984848 ], [ -176.022663, 51.980621 ], [ -176.027667, 51.975112 ], [ -176.057085, 51.967825 ], [ -176.079181, 51.968884 ], [ -176.180356, 52.000426 ], [ -176.185086, 52.005705 ], [ -176.201935, 52.040212 ], [ -176.211855, 52.065533 ], [ -176.205324, 52.076246 ], [ -176.173155, 52.102314 ], [ -176.143914, 52.116097 ], [ -176.058103, 52.106467 ], [ -175.988653, 52.035509 ], [ -175.999044, 52.025385 ], [ -176.018089, 52.020099 ] ] ], [ [ [ 178.117600, 52.048612 ], [ 178.119144, 52.051659 ], [ 178.141695, 52.051034 ], [ 178.175781, 52.036777 ], [ 178.179962, 52.033247 ], [ 178.190963, 52.003546 ], [ 178.174473, 51.991684 ], [ 178.132547, 51.986982 ], [ 178.105874, 51.998357 ], [ 178.102730, 52.003927 ], [ 178.094610, 52.033294 ], [ 178.107266, 52.045744 ], [ 178.117600, 52.048612 ] ] ], [ [ [ -174.301818, 52.278949 ], [ -174.323471, 52.283990 ], [ -174.346089, 52.285036 ], [ -174.349404, 52.281336 ], [ -174.368754, 52.280405 ], [ -174.408277, 52.289872 ], [ -174.451554, 52.305557 ], [ -174.455979, 52.313690 ], [ -174.453660, 52.319367 ], [ -174.443132, 52.325654 ], [ -174.432846, 52.328004 ], [ -174.384199, 52.321139 ], [ -174.367047, 52.314105 ], [ -174.358624, 52.314190 ], [ -174.340679, 52.322284 ], [ -174.331065, 52.328465 ], [ -174.317700, 52.344869 ], [ -174.320813, 52.355726 ], [ -174.330494, 52.366439 ], [ -174.329818, 52.373548 ], [ -174.324935, 52.378095 ], [ -174.185347, 52.417788 ], [ -174.155774, 52.416041 ], [ -174.068248, 52.390331 ], [ -174.016822, 52.348537 ], [ -173.989415, 52.325275 ], [ -173.985203, 52.317600 ], [ -173.986421, 52.298565 ], [ -173.987917, 52.295345 ], [ -174.036222, 52.245011 ], [ -174.060451, 52.225326 ], [ -174.084042, 52.223677 ], [ -174.106533, 52.228392 ], [ -174.177679, 52.233638 ], [ -174.182857, 52.232762 ], [ -174.198624, 52.219244 ], [ -174.200389, 52.211861 ], [ -174.196836, 52.195856 ], [ -174.190100, 52.190320 ], [ -174.175044, 52.181835 ], [ -174.135217, 52.168514 ], [ -174.090169, 52.139119 ], [ -174.082814, 52.132069 ], [ -174.080677, 52.128026 ], [ -174.089100, 52.107251 ], [ -174.094470, 52.104274 ], [ -174.102161, 52.104534 ], [ -174.109089, 52.113117 ], [ -174.114370, 52.117107 ], [ -174.142262, 52.125452 ], [ -174.206353, 52.116554 ], [ -174.218469, 52.104880 ], [ -174.302947, 52.111325 ], [ -174.334424, 52.115198 ], [ -174.348463, 52.109245 ], [ -174.365667, 52.097238 ], [ -174.382661, 52.081658 ], [ -174.411255, 52.048757 ], [ -174.452760, 52.061047 ], [ -174.507816, 52.054955 ], [ -174.508822, 52.048623 ], [ -174.556278, 52.036733 ], [ -174.580676, 52.040453 ], [ -174.593635, 52.045247 ], [ -174.615943, 52.032665 ], [ -174.714610, 52.009863 ], [ -174.736592, 52.007308 ], [ -174.783189, 52.032293 ], [ -174.885554, 52.043001 ], [ -174.967907, 52.037203 ], [ -175.000792, 52.028354 ], [ -175.014748, 52.020584 ], [ -175.014807, 52.007000 ], [ -175.095510, 52.000797 ], [ -175.104889, 52.003548 ], [ -175.155673, 52.011512 ], [ -175.274850, 52.018619 ], [ -175.292821, 52.018790 ], [ -175.300639, 52.014970 ], [ -175.302683, 52.011499 ], [ -175.323322, 52.007488 ], [ -175.341624, 52.021588 ], [ -175.327070, 52.027032 ], [ -175.195900, 52.051407 ], [ -175.156744, 52.057642 ], [ -175.132635, 52.059223 ], [ -175.117115, 52.054499 ], [ -175.117680, 52.053234 ], [ -175.113721, 52.046308 ], [ -175.092867, 52.034794 ], [ -175.044344, 52.057519 ], [ -174.995237, 52.061417 ], [ -174.992309, 52.058603 ], [ -174.980497, 52.061471 ], [ -174.937497, 52.078334 ], [ -174.922299, 52.091580 ], [ -174.927549, 52.101415 ], [ -174.920042, 52.109274 ], [ -174.905409, 52.116509 ], [ -174.866725, 52.103172 ], [ -174.839715, 52.091338 ], [ -174.786809, 52.091324 ], [ -174.656294, 52.107962 ], [ -174.604871, 52.122124 ], [ -174.568402, 52.138426 ], [ -174.557080, 52.153637 ], [ -174.554670, 52.160405 ], [ -174.527081, 52.174720 ], [ -174.496880, 52.179151 ], [ -174.465189, 52.180711 ], [ -174.455707, 52.176802 ], [ -174.424054, 52.169053 ], [ -174.415290, 52.169376 ], [ -174.404588, 52.181330 ], [ -174.405464, 52.183560 ], [ -174.457804, 52.202831 ], [ -174.462962, 52.213031 ], [ -174.453746, 52.218823 ], [ -174.400139, 52.219053 ], [ -174.360631, 52.212994 ], [ -174.328599, 52.211647 ], [ -174.299044, 52.214670 ], [ -174.249848, 52.243694 ], [ -174.255832, 52.274152 ], [ -174.301818, 52.278949 ] ] ], [ [ [ -173.602446, 52.153773 ], [ -173.590560, 52.145393 ], [ -173.514171, 52.108348 ], [ -173.497020, 52.103641 ], [ -173.467877, 52.116423 ], [ -173.375229, 52.108228 ], [ -173.375595, 52.106343 ], [ -173.372574, 52.102750 ], [ -173.357498, 52.096129 ], [ -173.238295, 52.100443 ], [ -173.173206, 52.109136 ], [ -173.124504, 52.109420 ], [ -173.119255, 52.107628 ], [ -173.107373, 52.099280 ], [ -173.066430, 52.096330 ], [ -173.019588, 52.097881 ], [ -172.958523, 52.093648 ], [ -172.960751, 52.087018 ], [ -173.033166, 52.074611 ], [ -173.047540, 52.073329 ], [ -173.107933, 52.078828 ], [ -173.206837, 52.063532 ], [ -173.313705, 52.058701 ], [ -173.424178, 52.046298 ], [ -173.511915, 52.031278 ], [ -173.548385, 52.029308 ], [ -173.612014, 52.051148 ], [ -173.718000, 52.063069 ], [ -173.799574, 52.053650 ], [ -173.816999, 52.048538 ], [ -173.820692, 52.043312 ], [ -173.831555, 52.040763 ], [ -173.901075, 52.049435 ], [ -173.937239, 52.057513 ], [ -173.935561, 52.064731 ], [ -173.971330, 52.099428 ], [ -173.992274, 52.100590 ], [ -174.001866, 52.097641 ], [ -174.011338, 52.098862 ], [ -174.035082, 52.112952 ], [ -174.046750, 52.122403 ], [ -174.052296, 52.130400 ], [ -174.048451, 52.132911 ], [ -174.036854, 52.135878 ], [ -173.984245, 52.127855 ], [ -173.890733, 52.125470 ], [ -173.830906, 52.110450 ], [ -173.824087, 52.105892 ], [ -173.818277, 52.105363 ], [ -173.802339, 52.106390 ], [ -173.721266, 52.130207 ], [ -173.654404, 52.146192 ], [ -173.624771, 52.152213 ], [ -173.602446, 52.153773 ] ] ], [ [ [ 177.355215, 52.071396 ], [ 177.332629, 52.075209 ], [ 177.321366, 52.080428 ], [ 177.305190, 52.090324 ], [ 177.290600, 52.102150 ], [ 177.283488, 52.114159 ], [ 177.280160, 52.127579 ], [ 177.281807, 52.135126 ], [ 177.288827, 52.144190 ], [ 177.306009, 52.156108 ], [ 177.329296, 52.166669 ], [ 177.340528, 52.170323 ], [ 177.367356, 52.175299 ], [ 177.383655, 52.174276 ], [ 177.408835, 52.167632 ], [ 177.425775, 52.157203 ], [ 177.437924, 52.146873 ], [ 177.445983, 52.135130 ], [ 177.446563, 52.114453 ], [ 177.443023, 52.105259 ], [ 177.435577, 52.097011 ], [ 177.428801, 52.091738 ], [ 177.402034, 52.079668 ], [ 177.386805, 52.075196 ], [ 177.355215, 52.071396 ] ] ], [ [ [ -172.633153, 52.266215 ], [ -172.620261, 52.298751 ], [ -172.574154, 52.345323 ], [ -172.568051, 52.349420 ], [ -172.474610, 52.383763 ], [ -172.448182, 52.391439 ], [ -172.405243, 52.389442 ], [ -172.326444, 52.366472 ], [ -172.311427, 52.356456 ], [ -172.302393, 52.342357 ], [ -172.301445, 52.329951 ], [ -172.313133, 52.320697 ], [ -172.414419, 52.276740 ], [ -172.528095, 52.254336 ], [ -172.608935, 52.253014 ], [ -172.616839, 52.255317 ], [ -172.633153, 52.266215 ] ] ], [ [ [ 175.911286, 52.334831 ], [ 175.902770, 52.336823 ], [ 175.890684, 52.344514 ], [ 175.873317, 52.361138 ], [ 175.874353, 52.371004 ], [ 175.906734, 52.375651 ], [ 175.950560, 52.368357 ], [ 175.966521, 52.359728 ], [ 175.944180, 52.336437 ], [ 175.911286, 52.334831 ] ] ], [ [ [ 173.587554, 52.476785 ], [ 173.623883, 52.506948 ], [ 173.680586, 52.512878 ], [ 173.736270, 52.512422 ], [ 173.769503, 52.512072 ], [ 173.772799, 52.509905 ], [ 173.772402, 52.506877 ], [ 173.754979, 52.496127 ], [ 173.739385, 52.493257 ], [ 173.707741, 52.477377 ], [ 173.695719, 52.458935 ], [ 173.691601, 52.445935 ], [ 173.693860, 52.438694 ], [ 173.702252, 52.434804 ], [ 173.704299, 52.432192 ], [ 173.712323, 52.421033 ], [ 173.719161, 52.397703 ], [ 173.725696, 52.356579 ], [ 173.651293, 52.356370 ], [ 173.644793, 52.357598 ], [ 173.640825, 52.359428 ], [ 173.606767, 52.378249 ], [ 173.595397, 52.391893 ], [ 173.588794, 52.400973 ], [ 173.559891, 52.401165 ], [ 173.543778, 52.392666 ], [ 173.512162, 52.385035 ], [ 173.483843, 52.383485 ], [ 173.465442, 52.384621 ], [ 173.455586, 52.389656 ], [ 173.395500, 52.402647 ], [ 173.385704, 52.404072 ], [ 173.356927, 52.403873 ], [ 173.356103, 52.405563 ], [ 173.380058, 52.431843 ], [ 173.440111, 52.453664 ], [ 173.445696, 52.455031 ], [ 173.467698, 52.444473 ], [ 173.476243, 52.441909 ], [ 173.501022, 52.440926 ], [ 173.525161, 52.448137 ], [ 173.530105, 52.449968 ], [ 173.550002, 52.467067 ], [ 173.549605, 52.469989 ], [ 173.545302, 52.476000 ], [ 173.555739, 52.479472 ], [ 173.587554, 52.476785 ] ] ], [ [ [ -171.294554, 52.451105 ], [ -171.299348, 52.448716 ], [ -171.304170, 52.449952 ], [ -171.313083, 52.472932 ], [ -171.312658, 52.493502 ], [ -171.307500, 52.501514 ], [ -171.291387, 52.514813 ], [ -171.277165, 52.522634 ], [ -171.252053, 52.529954 ], [ -171.196013, 52.500106 ], [ -171.194639, 52.498039 ], [ -171.208919, 52.469023 ], [ -171.214565, 52.463300 ], [ -171.236843, 52.450527 ], [ -171.252316, 52.449466 ], [ -171.294554, 52.451105 ] ] ], [ [ [ -170.841936, 52.558171 ], [ -170.833364, 52.599985 ], [ -170.820641, 52.633091 ], [ -170.817943, 52.636275 ], [ -170.727717, 52.679978 ], [ -170.671545, 52.698082 ], [ -170.633753, 52.697469 ], [ -170.579913, 52.682029 ], [ -170.562734, 52.674785 ], [ -170.559523, 52.667907 ], [ -170.557324, 52.652105 ], [ -170.563610, 52.640706 ], [ -170.603862, 52.601732 ], [ -170.635419, 52.595711 ], [ -170.659041, 52.593811 ], [ -170.665266, 52.595260 ], [ -170.668075, 52.600677 ], [ -170.674453, 52.603385 ], [ -170.683854, 52.602485 ], [ -170.696488, 52.598364 ], [ -170.735824, 52.580823 ], [ -170.767378, 52.558254 ], [ -170.777143, 52.546664 ], [ -170.788495, 52.540240 ], [ -170.841936, 52.558171 ] ] ], [ [ [ 174.069186, 52.734888 ], [ 174.092073, 52.742060 ], [ 174.096650, 52.743485 ], [ 174.133150, 52.733786 ], [ 174.145326, 52.728550 ], [ 174.155764, 52.715375 ], [ 174.159252, 52.707387 ], [ 174.158146, 52.706059 ], [ 174.109409, 52.708560 ], [ 174.071842, 52.718295 ], [ 174.066195, 52.731042 ], [ 174.069186, 52.734888 ] ] ], [ [ [ -170.170683, 52.784918 ], [ -170.128714, 52.787425 ], [ -170.061868, 52.773525 ], [ -170.053443, 52.769076 ], [ -170.052922, 52.758745 ], [ -170.055363, 52.745887 ], [ -170.070287, 52.724301 ], [ -170.077734, 52.720416 ], [ -170.114087, 52.716172 ], [ -170.170646, 52.717359 ], [ -170.184564, 52.721937 ], [ -170.185684, 52.723007 ], [ -170.170683, 52.784918 ] ] ], [ [ [ 174.004827, 52.719857 ], [ 173.972600, 52.729423 ], [ 173.960880, 52.738136 ], [ 173.952793, 52.747885 ], [ 173.954075, 52.751410 ], [ 173.983432, 52.749053 ], [ 174.003651, 52.744283 ], [ 174.021702, 52.730286 ], [ 174.004827, 52.719857 ] ] ], [ [ [ 173.932926, 52.746649 ], [ 173.930912, 52.750227 ], [ 173.925271, 52.752433 ], [ 173.894753, 52.750780 ], [ 173.875585, 52.761898 ], [ 173.861653, 52.773579 ], [ 173.867436, 52.775128 ], [ 173.881412, 52.775028 ], [ 173.897452, 52.771780 ], [ 173.931553, 52.758574 ], [ 173.940037, 52.751860 ], [ 173.932926, 52.746649 ] ] ], [ [ [ 172.763366, 52.823656 ], [ 172.767390, 52.848372 ], [ 172.766693, 52.862669 ], [ 172.754236, 52.877490 ], [ 172.640372, 52.925441 ], [ 172.585075, 52.921327 ], [ 172.548700, 52.914322 ], [ 172.512996, 52.905181 ], [ 172.469022, 52.911337 ], [ 172.461667, 52.927160 ], [ 172.629077, 53.001324 ], [ 172.643266, 53.004979 ], [ 172.746566, 53.010750 ], [ 173.107249, 52.993228 ], [ 173.121988, 52.990352 ], [ 173.131510, 52.987521 ], [ 173.159648, 52.974163 ], [ 173.172406, 52.960545 ], [ 173.211752, 52.939489 ], [ 173.235265, 52.943628 ], [ 173.251326, 52.944362 ], [ 173.295399, 52.926987 ], [ 173.421682, 52.845477 ], [ 173.427670, 52.830763 ], [ 173.423819, 52.828799 ], [ 173.413016, 52.827891 ], [ 173.302331, 52.823286 ], [ 173.284417, 52.827933 ], [ 173.229070, 52.856156 ], [ 173.224051, 52.856403 ], [ 173.204948, 52.848911 ], [ 173.187952, 52.831500 ], [ 173.173543, 52.804378 ], [ 173.166899, 52.795229 ], [ 173.142678, 52.786254 ], [ 173.134521, 52.784357 ], [ 173.118560, 52.784440 ], [ 172.998472, 52.796979 ], [ 172.903628, 52.761667 ], [ 172.809387, 52.789290 ], [ 172.763366, 52.823656 ] ] ], [ [ [ -169.943521, 52.861099 ], [ -169.905631, 52.853240 ], [ -169.860214, 52.858377 ], [ -169.818139, 52.878446 ], [ -169.773504, 52.894450 ], [ -169.749177, 52.893269 ], [ -169.704736, 52.886272 ], [ -169.666512, 52.864349 ], [ -169.683482, 52.826618 ], [ -169.704105, 52.793938 ], [ -169.750136, 52.790576 ], [ -169.838232, 52.817280 ], [ -169.879866, 52.816088 ], [ -169.886671, 52.808563 ], [ -169.897078, 52.802131 ], [ -169.927446, 52.792675 ], [ -169.951498, 52.788615 ], [ -169.962883, 52.789882 ], [ -169.995422, 52.804676 ], [ -170.012487, 52.831161 ], [ -170.004218, 52.846743 ], [ -169.990149, 52.856266 ], [ -169.975345, 52.858884 ], [ -169.943521, 52.861099 ] ] ], [ [ [ -168.211705, 53.256184 ], [ -168.226915, 53.254822 ], [ -168.270744, 53.242811 ], [ -168.296229, 53.227235 ], [ -168.312376, 53.215231 ], [ -168.341678, 53.185911 ], [ -168.344468, 53.155215 ], [ -168.373150, 53.128891 ], [ -168.392379, 53.123609 ], [ -168.412522, 53.110683 ], [ -168.433734, 53.093934 ], [ -168.442859, 53.085562 ], [ -168.451161, 53.075131 ], [ -168.457103, 53.055839 ], [ -168.497490, 53.035403 ], [ -168.527404, 53.028588 ], [ -168.546059, 53.029580 ], [ -168.553195, 53.033296 ], [ -168.578895, 53.029915 ], [ -168.587808, 53.027175 ], [ -168.613964, 53.008776 ], [ -168.625257, 52.998214 ], [ -168.688468, 52.966400 ], [ -168.741851, 52.951442 ], [ -168.808854, 52.926102 ], [ -168.907003, 52.884006 ], [ -169.041338, 52.839348 ], [ -169.102465, 52.824349 ], [ -169.054243, 52.863266 ], [ -169.038767, 52.869662 ], [ -168.992403, 52.873440 ], [ -168.971710, 52.878028 ], [ -168.958983, 52.886048 ], [ -168.861078, 52.968046 ], [ -168.785236, 53.045038 ], [ -168.763689, 53.070961 ], [ -168.759691, 53.081461 ], [ -168.768544, 53.093684 ], [ -168.776176, 53.097766 ], [ -168.789424, 53.100970 ], [ -168.802030, 53.108226 ], [ -168.804901, 53.120015 ], [ -168.799469, 53.143794 ], [ -168.792327, 53.155720 ], [ -168.788756, 53.160749 ], [ -168.763331, 53.182812 ], [ -168.617143, 53.260985 ], [ -168.539398, 53.251670 ], [ -168.524991, 53.252311 ], [ -168.501365, 53.257340 ], [ -168.490957, 53.264009 ], [ -168.445083, 53.265330 ], [ -168.412851, 53.257859 ], [ -168.366519, 53.252024 ], [ -168.361758, 53.252253 ], [ -168.343994, 53.262150 ], [ -168.365388, 53.309105 ], [ -168.371218, 53.316575 ], [ -168.375674, 53.318291 ], [ -168.406531, 53.346393 ], [ -168.386886, 53.431496 ], [ -168.342127, 53.475992 ], [ -168.315847, 53.481729 ], [ -168.295793, 53.489062 ], [ -168.239572, 53.518491 ], [ -168.238321, 53.521902 ], [ -168.200443, 53.534079 ], [ -168.144620, 53.545342 ], [ -168.004624, 53.566053 ], [ -167.981038, 53.561714 ], [ -167.962723, 53.554069 ], [ -167.960861, 53.552550 ], [ -167.965714, 53.543440 ], [ -167.965038, 53.538913 ], [ -167.938981, 53.526907 ], [ -167.901871, 53.520508 ], [ -167.888901, 53.519691 ], [ -167.816998, 53.517947 ], [ -167.796866, 53.521113 ], [ -167.791026, 53.521076 ], [ -167.789164, 53.519329 ], [ -167.786387, 53.513896 ], [ -167.784099, 53.501048 ], [ -167.788066, 53.492411 ], [ -167.808117, 53.473861 ], [ -167.843611, 53.453893 ], [ -167.853225, 53.445469 ], [ -167.858337, 53.437910 ], [ -167.856837, 53.428609 ], [ -167.851698, 53.421236 ], [ -167.844800, 53.417497 ], [ -167.839520, 53.410325 ], [ -167.839887, 53.394432 ], [ -167.842328, 53.386489 ], [ -167.852217, 53.378294 ], [ -167.872879, 53.367360 ], [ -167.878128, 53.366902 ], [ -167.959096, 53.341788 ], [ -167.988487, 53.329578 ], [ -168.009301, 53.317263 ], [ -168.039760, 53.304276 ], [ -168.158943, 53.267710 ], [ -168.211705, 53.256184 ] ] ], [ [ [ -169.996712, 52.891475 ], [ -169.999094, 52.884034 ], [ -170.002368, 52.880239 ], [ -170.015514, 52.870260 ], [ -170.050274, 52.857433 ], [ -170.095331, 52.870851 ], [ -170.113189, 52.891078 ], [ -170.112853, 52.902043 ], [ -170.092221, 52.919387 ], [ -170.083985, 52.923640 ], [ -170.046560, 52.923853 ], [ -170.020493, 52.917171 ], [ -170.002071, 52.910043 ], [ -169.995982, 52.902378 ], [ -169.996712, 52.891475 ] ] ], [ [ [ -169.721744, 52.947117 ], [ -169.741096, 52.951512 ], [ -169.758008, 52.967246 ], [ -169.760725, 52.971556 ], [ -169.762740, 52.978050 ], [ -169.745743, 53.021470 ], [ -169.742538, 53.024072 ], [ -169.698128, 53.033779 ], [ -169.680033, 53.035075 ], [ -169.664930, 53.023973 ], [ -169.663576, 53.021258 ], [ -169.666078, 52.997068 ], [ -169.698274, 52.958267 ], [ -169.721744, 52.947117 ] ] ], [ [ [ -166.728918, 54.003111 ], [ -166.676640, 54.017419 ], [ -166.644627, 54.014495 ], [ -166.636936, 54.012000 ], [ -166.619754, 54.001264 ], [ -166.599947, 53.983695 ], [ -166.587393, 53.959831 ], [ -166.605438, 53.955354 ], [ -166.621979, 53.953744 ], [ -166.646786, 53.923785 ], [ -166.640466, 53.912519 ], [ -166.619003, 53.893514 ], [ -166.597182, 53.883990 ], [ -166.575090, 53.879236 ], [ -166.560546, 53.878775 ], [ -166.487847, 53.895448 ], [ -166.443699, 53.909727 ], [ -166.436526, 53.916151 ], [ -166.435153, 53.920415 ], [ -166.437083, 53.955644 ], [ -166.373689, 54.010030 ], [ -166.367460, 54.008903 ], [ -166.357117, 54.002343 ], [ -166.354614, 53.999039 ], [ -166.354341, 53.995515 ], [ -166.359925, 53.977136 ], [ -166.319895, 53.960126 ], [ -166.279407, 53.982532 ], [ -166.264519, 53.977550 ], [ -166.210964, 53.933557 ], [ -166.208767, 53.929110 ], [ -166.211207, 53.912334 ], [ -166.236513, 53.881343 ], [ -166.250935, 53.876851 ], [ -166.320004, 53.869527 ], [ -166.351999, 53.858532 ], [ -166.389196, 53.832343 ], [ -166.404896, 53.809345 ], [ -166.434846, 53.798012 ], [ -166.547438, 53.749404 ], [ -166.552078, 53.728498 ], [ -166.540531, 53.715926 ], [ -166.469112, 53.735935 ], [ -166.460324, 53.745838 ], [ -166.420471, 53.762088 ], [ -166.336768, 53.787090 ], [ -166.303201, 53.791538 ], [ -166.212603, 53.817127 ], [ -166.214312, 53.820430 ], [ -166.212330, 53.827769 ], [ -166.198751, 53.836100 ], [ -166.119922, 53.855048 ], [ -166.113037, 53.853716 ], [ -166.097565, 53.843990 ], [ -166.094147, 53.839200 ], [ -166.111317, 53.776856 ], [ -166.166703, 53.733402 ], [ -166.199060, 53.727328 ], [ -166.262974, 53.703710 ], [ -166.265182, 53.698248 ], [ -166.274896, 53.687253 ], [ -166.283267, 53.684219 ], [ -166.444909, 53.640646 ], [ -166.467583, 53.646574 ], [ -166.532639, 53.630533 ], [ -166.553983, 53.623448 ], [ -166.581011, 53.530449 ], [ -166.656234, 53.487119 ], [ -166.662276, 53.485349 ], [ -166.667921, 53.486027 ], [ -166.712475, 53.498445 ], [ -166.735039, 53.506640 ], [ -166.743054, 53.514820 ], [ -166.772655, 53.496371 ], [ -166.789062, 53.453100 ], [ -166.863119, 53.443878 ], [ -166.878087, 53.429884 ], [ -166.922674, 53.441136 ], [ -166.959082, 53.455753 ], [ -166.994329, 53.429201 ], [ -167.036104, 53.449289 ], [ -167.048210, 53.448844 ], [ -167.050025, 53.433067 ], [ -167.075386, 53.424979 ], [ -167.112008, 53.416775 ], [ -167.124277, 53.425534 ], [ -167.134134, 53.426448 ], [ -167.201432, 53.397900 ], [ -167.291831, 53.364102 ], [ -167.302982, 53.336911 ], [ -167.308126, 53.334330 ], [ -167.348653, 53.333262 ], [ -167.386984, 53.340671 ], [ -167.442804, 53.321015 ], [ -167.466304, 53.295888 ], [ -167.488215, 53.269121 ], [ -167.515470, 53.267876 ], [ -167.530884, 53.275659 ], [ -167.539247, 53.277864 ], [ -167.589180, 53.288698 ], [ -167.598428, 53.288048 ], [ -167.609903, 53.285300 ], [ -167.622173, 53.250362 ], [ -167.644179, 53.250842 ], [ -167.798984, 53.284757 ], [ -167.835090, 53.299620 ], [ -167.851511, 53.308668 ], [ -167.852333, 53.315599 ], [ -167.790928, 53.335520 ], [ -167.710446, 53.381326 ], [ -167.694484, 53.388034 ], [ -167.653113, 53.392276 ], [ -167.622089, 53.385329 ], [ -167.488252, 53.420001 ], [ -167.474457, 53.431782 ], [ -167.473328, 53.438001 ], [ -167.457366, 53.442793 ], [ -167.393985, 53.439752 ], [ -167.373527, 53.432776 ], [ -167.355624, 53.424498 ], [ -167.332792, 53.433107 ], [ -167.319143, 53.451317 ], [ -167.301290, 53.466006 ], [ -167.278827, 53.478565 ], [ -167.267902, 53.478115 ], [ -167.226182, 53.468692 ], [ -167.217606, 53.465389 ], [ -167.199966, 53.463039 ], [ -167.193801, 53.467007 ], [ -167.158520, 53.503747 ], [ -167.102305, 53.515077 ], [ -167.105816, 53.540507 ], [ -167.131239, 53.547267 ], [ -167.135695, 53.551227 ], [ -167.161640, 53.605909 ], [ -167.163196, 53.613813 ], [ -167.159808, 53.617308 ], [ -167.140430, 53.626968 ], [ -167.107836, 53.633056 ], [ -167.091377, 53.633438 ], [ -167.084579, 53.626502 ], [ -167.070082, 53.619857 ], [ -167.062187, 53.620058 ], [ -167.009635, 53.635344 ], [ -167.008671, 53.642040 ], [ -167.017863, 53.648607 ], [ -167.030011, 53.653559 ], [ -167.071823, 53.665560 ], [ -167.067674, 53.687267 ], [ -167.057695, 53.698864 ], [ -167.041245, 53.707929 ], [ -167.022385, 53.715467 ], [ -166.999282, 53.718520 ], [ -166.923324, 53.719719 ], [ -166.894976, 53.717746 ], [ -166.859022, 53.674439 ], [ -166.861769, 53.659234 ], [ -166.832725, 53.657376 ], [ -166.805874, 53.665733 ], [ -166.779991, 53.719126 ], [ -166.787318, 53.734577 ], [ -166.856491, 53.747301 ], [ -166.942766, 53.769562 ], [ -166.960681, 53.776841 ], [ -166.975635, 53.775254 ], [ -166.983294, 53.771348 ], [ -166.992846, 53.762604 ], [ -167.005778, 53.755446 ], [ -167.016863, 53.754936 ], [ -167.024981, 53.757241 ], [ -167.075859, 53.786272 ], [ -167.141966, 53.826932 ], [ -167.140992, 53.866774 ], [ -167.058168, 53.929778 ], [ -167.031252, 53.945204 ], [ -166.930452, 53.976091 ], [ -166.879488, 53.988716 ], [ -166.818635, 53.993198 ], [ -166.751681, 54.016050 ], [ -166.746095, 54.016936 ], [ -166.742587, 54.015501 ], [ -166.728918, 54.003111 ] ] ], [ [ [ -169.553937, 56.608682 ], [ -169.528659, 56.612181 ], [ -169.507415, 56.610702 ], [ -169.473138, 56.601741 ], [ -169.471550, 56.598864 ], [ -169.490133, 56.583482 ], [ -169.568984, 56.540935 ], [ -169.582624, 56.536939 ], [ -169.640735, 56.542162 ], [ -169.650135, 56.544230 ], [ -169.657736, 56.547319 ], [ -169.667749, 56.554535 ], [ -169.672818, 56.560866 ], [ -169.671324, 56.567328 ], [ -169.675327, 56.578414 ], [ -169.683639, 56.583340 ], [ -169.755750, 56.591922 ], [ -169.785692, 56.613245 ], [ -169.789659, 56.618217 ], [ -169.763506, 56.620739 ], [ -169.679305, 56.611593 ], [ -169.611548, 56.606924 ], [ -169.553937, 56.608682 ] ] ], [ [ [ -170.286318, 57.128169 ], [ -170.290793, 57.145052 ], [ -170.303963, 57.154910 ], [ -170.324840, 57.156769 ], [ -170.359817, 57.156118 ], [ -170.421867, 57.161202 ], [ -170.423548, 57.169327 ], [ -170.420410, 57.191760 ], [ -170.418919, 57.192844 ], [ -170.402772, 57.201933 ], [ -170.390121, 57.206248 ], [ -170.331880, 57.217488 ], [ -170.311707, 57.219122 ], [ -170.291916, 57.212056 ], [ -170.267664, 57.210649 ], [ -170.239557, 57.214658 ], [ -170.161647, 57.229656 ], [ -170.150813, 57.223168 ], [ -170.170848, 57.181100 ], [ -170.286318, 57.128169 ] ] ], [ [ [ -155.620560, 55.907509 ], [ -155.568207, 55.907509 ], [ -155.560593, 55.897041 ], [ -155.559895, 55.882898 ], [ -155.584396, 55.848499 ], [ -155.564407, 55.809475 ], [ -155.566315, 55.789490 ], [ -155.589157, 55.761887 ], [ -155.611038, 55.759983 ], [ -155.649109, 55.776165 ], [ -155.718597, 55.772358 ], [ -155.728104, 55.779018 ], [ -155.750000, 55.821850 ], [ -155.743125, 55.831488 ], [ -155.663374, 55.860488 ], [ -155.637695, 55.894184 ], [ -155.620560, 55.907509 ] ] ], [ [ [ -154.404015, 56.572287 ], [ -154.393868, 56.562388 ], [ -154.391294, 56.557931 ], [ -154.392480, 56.554053 ], [ -154.436794, 56.534556 ], [ -154.529507, 56.502655 ], [ -154.571701, 56.494165 ], [ -154.633586, 56.471817 ], [ -154.668517, 56.452544 ], [ -154.691485, 56.436711 ], [ -154.704129, 56.424230 ], [ -154.736550, 56.403848 ], [ -154.742887, 56.401678 ], [ -154.765021, 56.401361 ], [ -154.775766, 56.404075 ], [ -154.789003, 56.411015 ], [ -154.799907, 56.419387 ], [ -154.805481, 56.427488 ], [ -154.806114, 56.434182 ], [ -154.777505, 56.462199 ], [ -154.739644, 56.496332 ], [ -154.706140, 56.521273 ], [ -154.534726, 56.600540 ], [ -154.524629, 56.603925 ], [ -154.514078, 56.604059 ], [ -154.449965, 56.600361 ], [ -154.413435, 56.586768 ], [ -154.402289, 56.580543 ], [ -154.399389, 56.576411 ], [ -154.404015, 56.572287 ] ] ], [ [ [ -153.940505, 56.558317 ], [ -153.915288, 56.564921 ], [ -153.878764, 56.565925 ], [ -153.870804, 56.558015 ], [ -153.868461, 56.551493 ], [ -153.887678, 56.533637 ], [ -153.952958, 56.507174 ], [ -153.993909, 56.501796 ], [ -154.120244, 56.501838 ], [ -154.143711, 56.506172 ], [ -154.163987, 56.507844 ], [ -154.197280, 56.502002 ], [ -154.232464, 56.491052 ], [ -154.304371, 56.502322 ], [ -154.343096, 56.510171 ], [ -154.347400, 56.512046 ], [ -154.361378, 56.525640 ], [ -154.362361, 56.542512 ], [ -154.341401, 56.563705 ], [ -154.310913, 56.585447 ], [ -154.290020, 56.595376 ], [ -154.244234, 56.609194 ], [ -154.223759, 56.612955 ], [ -154.210336, 56.609684 ], [ -154.206001, 56.606908 ], [ -154.184819, 56.603773 ], [ -154.136739, 56.609350 ], [ -154.113397, 56.616745 ], [ -154.103243, 56.617695 ], [ -154.095833, 56.617786 ], [ -154.090014, 56.614798 ], [ -154.081829, 56.603716 ], [ -154.079016, 56.589977 ], [ -154.075187, 56.583745 ], [ -154.041572, 56.556209 ], [ -154.025334, 56.551763 ], [ -154.009274, 56.551445 ], [ -153.940505, 56.558317 ] ] ], [ [ [ -152.417424, 57.815464 ], [ -152.364079, 57.829372 ], [ -152.351152, 57.834768 ], [ -152.324284, 57.824444 ], [ -152.310927, 57.783452 ], [ -152.317267, 57.771987 ], [ -152.322172, 57.768315 ], [ -152.342674, 57.762306 ], [ -152.348644, 57.764393 ], [ -152.349169, 57.768480 ], [ -152.357233, 57.773918 ], [ -152.381076, 57.776744 ], [ -152.443786, 57.776142 ], [ -152.465550, 57.767169 ], [ -152.471000, 57.763466 ], [ -152.497314, 57.738596 ], [ -152.497056, 57.734387 ], [ -152.467679, 57.681390 ], [ -152.443030, 57.668049 ], [ -152.401492, 57.686513 ], [ -152.398569, 57.687210 ], [ -152.394474, 57.684665 ], [ -152.428946, 57.642162 ], [ -152.461018, 57.606311 ], [ -152.468172, 57.600996 ], [ -152.467756, 57.598221 ], [ -152.459929, 57.594373 ], [ -152.439667, 57.590399 ], [ -152.426062, 57.593357 ], [ -152.402470, 57.607981 ], [ -152.387140, 57.612428 ], [ -152.361903, 57.618800 ], [ -152.322733, 57.623402 ], [ -152.265346, 57.626430 ], [ -152.179531, 57.624809 ], [ -152.161617, 57.623287 ], [ -152.152393, 57.619485 ], [ -152.159677, 57.593614 ], [ -152.163996, 57.584607 ], [ -152.259641, 57.527156 ], [ -152.291470, 57.517103 ], [ -152.314889, 57.486065 ], [ -152.323683, 57.467861 ], [ -152.326134, 57.441514 ], [ -152.361592, 57.427761 ], [ -152.416473, 57.435293 ], [ -152.495215, 57.452379 ], [ -152.517004, 57.432184 ], [ -152.570527, 57.448909 ], [ -152.600375, 57.468833 ], [ -152.646017, 57.466134 ], [ -152.662831, 57.463679 ], [ -152.684413, 57.466597 ], [ -152.716765, 57.478467 ], [ -152.720471, 57.481572 ], [ -152.719447, 57.488028 ], [ -152.722846, 57.494087 ], [ -152.743084, 57.505710 ], [ -152.770196, 57.504290 ], [ -152.798914, 57.494255 ], [ -152.809036, 57.494505 ], [ -152.825515, 57.497048 ], [ -152.838905, 57.502270 ], [ -152.886205, 57.510697 ], [ -152.939629, 57.520088 ], [ -152.954939, 57.520449 ], [ -152.966300, 57.512170 ], [ -152.967222, 57.509993 ], [ -152.949010, 57.498212 ], [ -152.939573, 57.497763 ], [ -152.921748, 57.501397 ], [ -152.890173, 57.486705 ], [ -152.762676, 57.457560 ], [ -152.742678, 57.447852 ], [ -152.722651, 57.433352 ], [ -152.673250, 57.413246 ], [ -152.630018, 57.405573 ], [ -152.620377, 57.401601 ], [ -152.601148, 57.382165 ], [ -152.606522, 57.363660 ], [ -152.630441, 57.322668 ], [ -152.657569, 57.303551 ], [ -152.695698, 57.281318 ], [ -152.707768, 57.276046 ], [ -152.712008, 57.278120 ], [ -152.774155, 57.290432 ], [ -152.787994, 57.279905 ], [ -152.818187, 57.265368 ], [ -152.886384, 57.291337 ], [ -152.900688, 57.302976 ], [ -152.909051, 57.324222 ], [ -152.984715, 57.339918 ], [ -153.008525, 57.339733 ], [ -153.056007, 57.329229 ], [ -153.079288, 57.321960 ], [ -153.099040, 57.310513 ], [ -153.116280, 57.297312 ], [ -153.101322, 57.286901 ], [ -153.096133, 57.286866 ], [ -153.039134, 57.293314 ], [ -153.017643, 57.297715 ], [ -153.015994, 57.300231 ], [ -153.012992, 57.299453 ], [ -152.970910, 57.282624 ], [ -152.944201, 57.259083 ], [ -152.943463, 57.256956 ], [ -152.950982, 57.248991 ], [ -152.997739, 57.231176 ], [ -153.056971, 57.214756 ], [ -153.077916, 57.211444 ], [ -153.125477, 57.211841 ], [ -153.163333, 57.216713 ], [ -153.169724, 57.220236 ], [ -153.201722, 57.221679 ], [ -153.209732, 57.218773 ], [ -153.215107, 57.213356 ], [ -153.215967, 57.209297 ], [ -153.213802, 57.205059 ], [ -153.166002, 57.180643 ], [ -153.123865, 57.175445 ], [ -153.097019, 57.183289 ], [ -153.073982, 57.187091 ], [ -152.949333, 57.187346 ], [ -152.880321, 57.164798 ], [ -152.874839, 57.160950 ], [ -152.869797, 57.150849 ], [ -152.900540, 57.132076 ], [ -152.911371, 57.126813 ], [ -152.950736, 57.119788 ], [ -152.997246, 57.119491 ], [ -153.118673, 57.091033 ], [ -153.128881, 57.092571 ], [ -153.132708, 57.094936 ], [ -153.133988, 57.099351 ], [ -153.146361, 57.100883 ], [ -153.180010, 57.094523 ], [ -153.215440, 57.075943 ], [ -153.220953, 57.068239 ], [ -153.222240, 57.061798 ], [ -153.221204, 57.060367 ], [ -153.213318, 57.055891 ], [ -153.205384, 57.056148 ], [ -153.200217, 57.042039 ], [ -153.204319, 57.033640 ], [ -153.235282, 57.007398 ], [ -153.301142, 56.991192 ], [ -153.312583, 56.991486 ], [ -153.348707, 57.008373 ], [ -153.349037, 57.011196 ], [ -153.320929, 57.036838 ], [ -153.324265, 57.043308 ], [ -153.365239, 57.072080 ], [ -153.396921, 57.060399 ], [ -153.402608, 57.070092 ], [ -153.404263, 57.080511 ], [ -153.384699, 57.115354 ], [ -153.380389, 57.120468 ], [ -153.345533, 57.139565 ], [ -153.328206, 57.141993 ], [ -153.284012, 57.173867 ], [ -153.282735, 57.175815 ], [ -153.286351, 57.184288 ], [ -153.310143, 57.194426 ], [ -153.350266, 57.192339 ], [ -153.368180, 57.185337 ], [ -153.368921, 57.180832 ], [ -153.366525, 57.176708 ], [ -153.486520, 57.085915 ], [ -153.489600, 57.074702 ], [ -153.498850, 57.065363 ], [ -153.535942, 57.077988 ], [ -153.563562, 57.089769 ], [ -153.577006, 57.093177 ], [ -153.654497, 57.084602 ], [ -153.675981, 57.069830 ], [ -153.675736, 57.054778 ], [ -153.663810, 57.053694 ], [ -153.601294, 57.056656 ], [ -153.595819, 57.056309 ], [ -153.580831, 57.049048 ], [ -153.543429, 56.995245 ], [ -153.556762, 56.968862 ], [ -153.600664, 56.942629 ], [ -153.627483, 56.937127 ], [ -153.671317, 56.932926 ], [ -153.701197, 56.926394 ], [ -153.730713, 56.893996 ], [ -153.715263, 56.878442 ], [ -153.704603, 56.878046 ], [ -153.695896, 56.881009 ], [ -153.688713, 56.871975 ], [ -153.696693, 56.861519 ], [ -153.714644, 56.852925 ], [ -153.778199, 56.834386 ], [ -153.796111, 56.842655 ], [ -153.800935, 56.846894 ], [ -153.807353, 56.848584 ], [ -153.817978, 56.848651 ], [ -153.849289, 56.838915 ], [ -153.854196, 56.836412 ], [ -153.903580, 56.793418 ], [ -153.924041, 56.767216 ], [ -153.963274, 56.747600 ], [ -153.971780, 56.744861 ], [ -153.990158, 56.743263 ], [ -154.016213, 56.743466 ], [ -154.022610, 56.755946 ], [ -154.037153, 56.763414 ], [ -154.050518, 56.763523 ], [ -154.064292, 56.760091 ], [ -154.085088, 56.751193 ], [ -154.106565, 56.745572 ], [ -154.129017, 56.742168 ], [ -154.136965, 56.742359 ], [ -154.148745, 56.745677 ], [ -154.125431, 56.783298 ], [ -154.072878, 56.841099 ], [ -154.067425, 56.845303 ], [ -154.055228, 56.850465 ], [ -154.040948, 56.854135 ], [ -154.030502, 56.855052 ], [ -153.984547, 56.889626 ], [ -153.935992, 56.915772 ], [ -153.894564, 56.926986 ], [ -153.862954, 56.944374 ], [ -153.850464, 56.957278 ], [ -153.873411, 56.963403 ], [ -153.902802, 56.968445 ], [ -153.913627, 56.965391 ], [ -153.917703, 56.962169 ], [ -153.934781, 56.958928 ], [ -153.976871, 56.955144 ], [ -153.979743, 56.962189 ], [ -153.976869, 56.996831 ], [ -153.932221, 57.062970 ], [ -153.887461, 57.086958 ], [ -153.875356, 57.089802 ], [ -153.858891, 57.088844 ], [ -153.804787, 57.113158 ], [ -153.783465, 57.131822 ], [ -153.776707, 57.142858 ], [ -153.779087, 57.158821 ], [ -153.788521, 57.161381 ], [ -153.806290, 57.157424 ], [ -153.822875, 57.142372 ], [ -153.823978, 57.139790 ], [ -153.861711, 57.119224 ], [ -153.982792, 57.066277 ], [ -153.993807, 57.050502 ], [ -154.024288, 57.016608 ], [ -154.055554, 56.987209 ], [ -154.076623, 56.970589 ], [ -154.123489, 56.956170 ], [ -154.145167, 56.945034 ], [ -154.159014, 56.945323 ], [ -154.165409, 56.943244 ], [ -154.212110, 56.909749 ], [ -154.223560, 56.896064 ], [ -154.227193, 56.883026 ], [ -154.226494, 56.876257 ], [ -154.231771, 56.872294 ], [ -154.276739, 56.853648 ], [ -154.298965, 56.846479 ], [ -154.305713, 56.846871 ], [ -154.300193, 56.852023 ], [ -154.298422, 56.863176 ], [ -154.300002, 56.892252 ], [ -154.306936, 56.911783 ], [ -154.312888, 56.918673 ], [ -154.385285, 56.959767 ], [ -154.407490, 56.968334 ], [ -154.476315, 56.984204 ], [ -154.511672, 56.988548 ], [ -154.524695, 56.991623 ], [ -154.528538, 57.001892 ], [ -154.516842, 57.030312 ], [ -154.515213, 57.077985 ], [ -154.529844, 57.168882 ], [ -154.533699, 57.183513 ], [ -154.539552, 57.196351 ], [ -154.574343, 57.239919 ], [ -154.594977, 57.257161 ], [ -154.613723, 57.267800 ], [ -154.691855, 57.284110 ], [ -154.698264, 57.284294 ], [ -154.740161, 57.276517 ], [ -154.777368, 57.280008 ], [ -154.792054, 57.286696 ], [ -154.793840, 57.288862 ], [ -154.751537, 57.307781 ], [ -154.743090, 57.314770 ], [ -154.700598, 57.401162 ], [ -154.699629, 57.412873 ], [ -154.702588, 57.420528 ], [ -154.693310, 57.446085 ], [ -154.629678, 57.510197 ], [ -154.618704, 57.514972 ], [ -154.602546, 57.518751 ], [ -154.591678, 57.518597 ], [ -154.540923, 57.539621 ], [ -154.522060, 57.577786 ], [ -154.511233, 57.578646 ], [ -154.500282, 57.574423 ], [ -154.468328, 57.570339 ], [ -154.431841, 57.584783 ], [ -154.411385, 57.598452 ], [ -154.344244, 57.630901 ], [ -154.225660, 57.661366 ], [ -154.196959, 57.664639 ], [ -154.186597, 57.658578 ], [ -154.086130, 57.649054 ], [ -154.056226, 57.652430 ], [ -154.031592, 57.660854 ], [ -153.994572, 57.656905 ], [ -153.983015, 57.649835 ], [ -153.982581, 57.648251 ], [ -153.984847, 57.604595 ], [ -153.982199, 57.553156 ], [ -153.971114, 57.539436 ], [ -153.947550, 57.540244 ], [ -153.939099, 57.538271 ], [ -153.929265, 57.533253 ], [ -153.925905, 57.529051 ], [ -153.922982, 57.520153 ], [ -153.922183, 57.499036 ], [ -153.919897, 57.485202 ], [ -153.909415, 57.442413 ], [ -153.895800, 57.422108 ], [ -153.802932, 57.350896 ], [ -153.795299, 57.349047 ], [ -153.774275, 57.360243 ], [ -153.773191, 57.372442 ], [ -153.811506, 57.412375 ], [ -153.872922, 57.445743 ], [ -153.874177, 57.447817 ], [ -153.888891, 57.504682 ], [ -153.875950, 57.542769 ], [ -153.869096, 57.551844 ], [ -153.848082, 57.560589 ], [ -153.824823, 57.577617 ], [ -153.813136, 57.588581 ], [ -153.823753, 57.597651 ], [ -153.846828, 57.612648 ], [ -153.852502, 57.613517 ], [ -153.877756, 57.629529 ], [ -153.879943, 57.634072 ], [ -153.874286, 57.646110 ], [ -153.868275, 57.649688 ], [ -153.858545, 57.651138 ], [ -153.749178, 57.646224 ], [ -153.705322, 57.640923 ], [ -153.667261, 57.639008 ], [ -153.663007, 57.639858 ], [ -153.648693, 57.654125 ], [ -153.658008, 57.661480 ], [ -153.676721, 57.669663 ], [ -153.797971, 57.696508 ], [ -153.862886, 57.706943 ], [ -153.888099, 57.705447 ], [ -153.918344, 57.695663 ], [ -153.930279, 57.696791 ], [ -153.932964, 57.703778 ], [ -153.935220, 57.813047 ], [ -153.823385, 57.865013 ], [ -153.755054, 57.883565 ], [ -153.721176, 57.890615 ], [ -153.648798, 57.880103 ], [ -153.571362, 57.832101 ], [ -153.550823, 57.786890 ], [ -153.551088, 57.763110 ], [ -153.553251, 57.759512 ], [ -153.557647, 57.734741 ], [ -153.554226, 57.722450 ], [ -153.549605, 57.717967 ], [ -153.515205, 57.716505 ], [ -153.493401, 57.728316 ], [ -153.469892, 57.766536 ], [ -153.462463, 57.795292 ], [ -153.480377, 57.814665 ], [ -153.487350, 57.834274 ], [ -153.479457, 57.842020 ], [ -153.451560, 57.839284 ], [ -153.406716, 57.828663 ], [ -153.353580, 57.809731 ], [ -153.343408, 57.810866 ], [ -153.324872, 57.831048 ], [ -153.322687, 57.836190 ], [ -153.324881, 57.848421 ], [ -153.328137, 57.849851 ], [ -153.395813, 57.858772 ], [ -153.446406, 57.875035 ], [ -153.462011, 57.880588 ], [ -153.512024, 57.909156 ], [ -153.528697, 57.921717 ], [ -153.536524, 57.930770 ], [ -153.533204, 57.941117 ], [ -153.520392, 57.963387 ], [ -153.513347, 57.968751 ], [ -153.484603, 57.976500 ], [ -153.469421, 57.977282 ], [ -153.461113, 57.972769 ], [ -153.452645, 57.963509 ], [ -153.273676, 57.890408 ], [ -153.268149, 57.888741 ], [ -153.236952, 57.891818 ], [ -153.127278, 57.856748 ], [ -153.122513, 57.856639 ], [ -153.093420, 57.861569 ], [ -153.089419, 57.865233 ], [ -153.198618, 57.929923 ], [ -153.233229, 57.940993 ], [ -153.270325, 57.958566 ], [ -153.299009, 57.985626 ], [ -153.302198, 57.991706 ], [ -153.297756, 57.996425 ], [ -153.276536, 57.998447 ], [ -153.234730, 57.996972 ], [ -153.221576, 57.989319 ], [ -153.217306, 57.983659 ], [ -153.129494, 57.946551 ], [ -153.069857, 57.934428 ], [ -153.052671, 57.936711 ], [ -153.050941, 57.939998 ], [ -153.024425, 57.956954 ], [ -152.876197, 57.932446 ], [ -152.871663, 57.933279 ], [ -152.856284, 57.947385 ], [ -152.852785, 57.974583 ], [ -152.855096, 57.994501 ], [ -152.840896, 57.996759 ], [ -152.723425, 57.991720 ], [ -152.722524, 57.987364 ], [ -152.739766, 57.944798 ], [ -152.751978, 57.933466 ], [ -152.804807, 57.899175 ], [ -152.823299, 57.890928 ], [ -152.892517, 57.842525 ], [ -152.902633, 57.830146 ], [ -152.909791, 57.810405 ], [ -152.916334, 57.771216 ], [ -152.904312, 57.750825 ], [ -152.892875, 57.742012 ], [ -152.881998, 57.738320 ], [ -152.874498, 57.737961 ], [ -152.850336, 57.740041 ], [ -152.847811, 57.746625 ], [ -152.852269, 57.752318 ], [ -152.854718, 57.770271 ], [ -152.849997, 57.821462 ], [ -152.841361, 57.830221 ], [ -152.822543, 57.843203 ], [ -152.790211, 57.858058 ], [ -152.758168, 57.840272 ], [ -152.753437, 57.834452 ], [ -152.725302, 57.835400 ], [ -152.650456, 57.863721 ], [ -152.625607, 57.881232 ], [ -152.626441, 57.890450 ], [ -152.639887, 57.899688 ], [ -152.641805, 57.902499 ], [ -152.639375, 57.914220 ], [ -152.635378, 57.918610 ], [ -152.587705, 57.926961 ], [ -152.585985, 57.908101 ], [ -152.567395, 57.900358 ], [ -152.549661, 57.900137 ], [ -152.526283, 57.913266 ], [ -152.487666, 57.941968 ], [ -152.470336, 57.962099 ], [ -152.432608, 57.976029 ], [ -152.421408, 57.975683 ], [ -152.415177, 57.973081 ], [ -152.411618, 57.969282 ], [ -152.422573, 57.948662 ], [ -152.437604, 57.939834 ], [ -152.437416, 57.936978 ], [ -152.426458, 57.930851 ], [ -152.388626, 57.924486 ], [ -152.362161, 57.926200 ], [ -152.324103, 57.916604 ], [ -152.333209, 57.902550 ], [ -152.364777, 57.883921 ], [ -152.377063, 57.886728 ], [ -152.386130, 57.890706 ], [ -152.394750, 57.894602 ], [ -152.403700, 57.901146 ], [ -152.414977, 57.902231 ], [ -152.448240, 57.902605 ], [ -152.468511, 57.888621 ], [ -152.433653, 57.824314 ], [ -152.429326, 57.820114 ], [ -152.417424, 57.815464 ] ] ], [ [ [ -152.242890, 58.241192 ], [ -152.280629, 58.242344 ], [ -152.311415, 58.221115 ], [ -152.265111, 58.135732 ], [ -152.273605, 58.125630 ], [ -152.343522, 58.119174 ], [ -152.401892, 58.120755 ], [ -152.425391, 58.127614 ], [ -152.482674, 58.129813 ], [ -152.514794, 58.114321 ], [ -152.529036, 58.093779 ], [ -152.530388, 58.087766 ], [ -152.541533, 58.083666 ], [ -152.554461, 58.084620 ], [ -152.557237, 58.086462 ], [ -152.569595, 58.114800 ], [ -152.557497, 58.160683 ], [ -152.559884, 58.170941 ], [ -152.562829, 58.177979 ], [ -152.584222, 58.187477 ], [ -152.597506, 58.179686 ], [ -152.615103, 58.116224 ], [ -152.631214, 58.081924 ], [ -152.656801, 58.061049 ], [ -152.706831, 58.050577 ], [ -152.771303, 58.046883 ], [ -152.777906, 58.050364 ], [ -152.779473, 58.065269 ], [ -152.792041, 58.072665 ], [ -152.809062, 58.078917 ], [ -152.882423, 58.096074 ], [ -152.958680, 58.116441 ], [ -152.973149, 58.125427 ], [ -152.983857, 58.134358 ], [ -152.997340, 58.134341 ], [ -153.075746, 58.099571 ], [ -153.076485, 58.096077 ], [ -153.057201, 58.073576 ], [ -153.036131, 58.055619 ], [ -153.020589, 58.045202 ], [ -152.964700, 58.034650 ], [ -152.876788, 58.002307 ], [ -152.871836, 57.999275 ], [ -152.871416, 57.997157 ], [ -152.947547, 57.983519 ], [ -152.982406, 57.984697 ], [ -153.097462, 58.004516 ], [ -153.202525, 58.030122 ], [ -153.209885, 58.034925 ], [ -153.214568, 58.042418 ], [ -153.218115, 58.043909 ], [ -153.289701, 58.050330 ], [ -153.344807, 58.040619 ], [ -153.365574, 58.039052 ], [ -153.419783, 58.059638 ], [ -153.418343, 58.064053 ], [ -153.412933, 58.069811 ], [ -153.316127, 58.140390 ], [ -153.281874, 58.147555 ], [ -153.274215, 58.148102 ], [ -153.262643, 58.145099 ], [ -153.227567, 58.123364 ], [ -153.199117, 58.102005 ], [ -153.168617, 58.088385 ], [ -153.156402, 58.090087 ], [ -153.148740, 58.106121 ], [ -153.167605, 58.127818 ], [ -153.209672, 58.150350 ], [ -153.223709, 58.162120 ], [ -153.202801, 58.208080 ], [ -153.170101, 58.216704 ], [ -153.073927, 58.195107 ], [ -153.060846, 58.194502 ], [ -153.036662, 58.199235 ], [ -153.000579, 58.211768 ], [ -152.998094, 58.214122 ], [ -153.006979, 58.221847 ], [ -153.061678, 58.235649 ], [ -153.082507, 58.244495 ], [ -153.101841, 58.257938 ], [ -153.102410, 58.260344 ], [ -153.099284, 58.264065 ], [ -153.044316, 58.306336 ], [ -153.004390, 58.300135 ], [ -152.993217, 58.296254 ], [ -152.982356, 58.287495 ], [ -152.941270, 58.279614 ], [ -152.888204, 58.283100 ], [ -152.878858, 58.288533 ], [ -152.869811, 58.304906 ], [ -152.884023, 58.307087 ], [ -152.912450, 58.307191 ], [ -152.921122, 58.313268 ], [ -152.936757, 58.330513 ], [ -152.936440, 58.334923 ], [ -152.925586, 58.339686 ], [ -152.895407, 58.345305 ], [ -152.870555, 58.335743 ], [ -152.821964, 58.328501 ], [ -152.804789, 58.339510 ], [ -152.774048, 58.366826 ], [ -152.787420, 58.369015 ], [ -152.839234, 58.372477 ], [ -152.883107, 58.400443 ], [ -152.888860, 58.409384 ], [ -152.886358, 58.410585 ], [ -152.864939, 58.404340 ], [ -152.844173, 58.402842 ], [ -152.812207, 58.403464 ], [ -152.787776, 58.411313 ], [ -152.774509, 58.419721 ], [ -152.771106, 58.429515 ], [ -152.733845, 58.460662 ], [ -152.723169, 58.462080 ], [ -152.689940, 58.459861 ], [ -152.610955, 58.475775 ], [ -152.601666, 58.490423 ], [ -152.600534, 58.494946 ], [ -152.609030, 58.496167 ], [ -152.619197, 58.493674 ], [ -152.622794, 58.494189 ], [ -152.653673, 58.506572 ], [ -152.666220, 58.544087 ], [ -152.665999, 58.564493 ], [ -152.638569, 58.587448 ], [ -152.616130, 58.601852 ], [ -152.567710, 58.621304 ], [ -152.560171, 58.619680 ], [ -152.550418, 58.610996 ], [ -152.549635, 58.601024 ], [ -152.545009, 58.594253 ], [ -152.502820, 58.593451 ], [ -152.453817, 58.618515 ], [ -152.354709, 58.638280 ], [ -152.337964, 58.637404 ], [ -152.329835, 58.632102 ], [ -152.337212, 58.589095 ], [ -152.372317, 58.531175 ], [ -152.387610, 58.522870 ], [ -152.418267, 58.515244 ], [ -152.467197, 58.476609 ], [ -152.498571, 58.449538 ], [ -152.505516, 58.441876 ], [ -152.512483, 58.427349 ], [ -152.493991, 58.354684 ], [ -152.476814, 58.350955 ], [ -152.387343, 58.359499 ], [ -152.364682, 58.364613 ], [ -152.344860, 58.391630 ], [ -152.348389, 58.401502 ], [ -152.355073, 58.413052 ], [ -152.358724, 58.415585 ], [ -152.356090, 58.423470 ], [ -152.328063, 58.434372 ], [ -152.320554, 58.433829 ], [ -152.301713, 58.428697 ], [ -152.279508, 58.415872 ], [ -152.227835, 58.376424 ], [ -152.234718, 58.362024 ], [ -152.224965, 58.357372 ], [ -152.200953, 58.355332 ], [ -152.129257, 58.396414 ], [ -152.125339, 58.396396 ], [ -152.090437, 58.372628 ], [ -152.089250, 58.367644 ], [ -152.119530, 58.329770 ], [ -152.138294, 58.295712 ], [ -152.147142, 58.266992 ], [ -152.146519, 58.249120 ], [ -152.116569, 58.248537 ], [ -152.107962, 58.260525 ], [ -152.107635, 58.280240 ], [ -152.082342, 58.309945 ], [ -151.986171, 58.350413 ], [ -151.981781, 58.347971 ], [ -151.966218, 58.332737 ], [ -151.963817, 58.328999 ], [ -151.964103, 58.269049 ], [ -151.972053, 58.230702 ], [ -151.986127, 58.213774 ], [ -152.081083, 58.154275 ], [ -152.112205, 58.148559 ], [ -152.194827, 58.174128 ], [ -152.223175, 58.194794 ], [ -152.224439, 58.202365 ], [ -152.219826, 58.206289 ], [ -152.207488, 58.206284 ], [ -152.203699, 58.212055 ], [ -152.233830, 58.243329 ], [ -152.242890, 58.241192 ] ] ], [ [ [ -132.977163, 56.439673 ], [ -132.957364, 56.448963 ], [ -132.927663, 56.456859 ], [ -132.896342, 56.457978 ], [ -132.871919, 56.457038 ], [ -132.843184, 56.444827 ], [ -132.819256, 56.439511 ], [ -132.808145, 56.440801 ], [ -132.791872, 56.449169 ], [ -132.782864, 56.451530 ], [ -132.734466, 56.458515 ], [ -132.716056, 56.454861 ], [ -132.668127, 56.440279 ], [ -132.634335, 56.422174 ], [ -132.628592, 56.416284 ], [ -132.620608, 56.391200 ], [ -132.652380, 56.375879 ], [ -132.662178, 56.369134 ], [ -132.679401, 56.354299 ], [ -132.684112, 56.345671 ], [ -132.676553, 56.333105 ], [ -132.662478, 56.320451 ], [ -132.655467, 56.303756 ], [ -132.655513, 56.295575 ], [ -132.662081, 56.274795 ], [ -132.721254, 56.258464 ], [ -132.776045, 56.254585 ], [ -132.843716, 56.238933 ], [ -132.877582, 56.240322 ], [ -133.010587, 56.309492 ], [ -133.045383, 56.320783 ], [ -133.067556, 56.333573 ], [ -133.070863, 56.354194 ], [ -133.069441, 56.356426 ], [ -133.060361, 56.358378 ], [ -133.045714, 56.371451 ], [ -133.006575, 56.415881 ], [ -133.006314, 56.417778 ], [ -133.010871, 56.421404 ], [ -133.010817, 56.424264 ], [ -133.002357, 56.430655 ], [ -132.977163, 56.439673 ] ] ], [ [ [ -135.447381, 58.399891 ], [ -135.461296, 58.399884 ], [ -135.466083, 58.394328 ], [ -135.512402, 58.385759 ], [ -135.521358, 58.391449 ], [ -135.556066, 58.407740 ], [ -135.622105, 58.428186 ], [ -135.630425, 58.428580 ], [ -135.728054, 58.397067 ], [ -135.826079, 58.390246 ], [ -135.907310, 58.380839 ], [ -135.917917, 58.381237 ], [ -135.921134, 58.385772 ], [ -135.920299, 58.389084 ], [ -135.897255, 58.416132 ], [ -135.897169, 58.450001 ], [ -135.916112, 58.463858 ], [ -135.923268, 58.462919 ], [ -135.934547, 58.451953 ], [ -135.939926, 58.451600 ], [ -135.987564, 58.464420 ], [ -135.997418, 58.470375 ], [ -135.999530, 58.480281 ], [ -135.990948, 58.487315 ], [ -135.968087, 58.494669 ], [ -135.955625, 58.492765 ], [ -135.945121, 58.494836 ], [ -135.906941, 58.505810 ], [ -135.893152, 58.513929 ], [ -135.895088, 58.534077 ], [ -135.914003, 58.540583 ], [ -135.928572, 58.572925 ], [ -135.912187, 58.618800 ], [ -136.012226, 58.712247 ], [ -136.015761, 58.722600 ], [ -136.008929, 58.731910 ], [ -136.011669, 58.743276 ], [ -136.046172, 58.781796 ], [ -136.082937, 58.808383 ], [ -136.089603, 58.815729 ], [ -136.077276, 58.824983 ], [ -136.045279, 58.836074 ], [ -136.050351, 58.913433 ], [ -136.060728, 58.927580 ], [ -136.120307, 58.968418 ], [ -136.145306, 58.976705 ], [ -136.162725, 58.977261 ], [ -136.163648, 58.973204 ], [ -136.160293, 58.961999 ], [ -136.150300, 58.947111 ], [ -136.124491, 58.924542 ], [ -136.106997, 58.864441 ], [ -136.150772, 58.757266 ], [ -136.161943, 58.752171 ], [ -136.213660, 58.751153 ], [ -136.247343, 58.752935 ], [ -136.397322, 58.813019 ], [ -136.431055, 58.818416 ], [ -136.474735, 58.830788 ], [ -136.493716, 58.838963 ], [ -136.528161, 58.928484 ], [ -136.526520, 58.954523 ], [ -136.544899, 58.967314 ], [ -136.559836, 58.963414 ], [ -136.572163, 58.957292 ], [ -136.575516, 58.946600 ], [ -136.575541, 58.928941 ], [ -136.586289, 58.909364 ], [ -136.630497, 58.890256 ], [ -136.670412, 58.893224 ], [ -136.676898, 58.894973 ], [ -136.694600, 58.904081 ], [ -136.704848, 58.914395 ], [ -136.724994, 58.923514 ], [ -136.750422, 58.930439 ], [ -136.782908, 58.936659 ], [ -136.788710, 58.936318 ], [ -136.802832, 58.923118 ], [ -136.840986, 58.919742 ], [ -136.860014, 58.931997 ], [ -136.857823, 58.942868 ], [ -136.877826, 58.962392 ], [ -136.918530, 58.947217 ], [ -136.915995, 58.938384 ], [ -136.932352, 58.916252 ], [ -136.934841, 58.916345 ], [ -136.933458, 58.908558 ], [ -136.928643, 58.900131 ], [ -136.868184, 58.885243 ], [ -136.767930, 58.870608 ], [ -136.744507, 58.876626 ], [ -136.676388, 58.856348 ], [ -136.612807, 58.846227 ], [ -136.583430, 58.838826 ], [ -136.538029, 58.819777 ], [ -136.463258, 58.781607 ], [ -136.356786, 58.692581 ], [ -136.354222, 58.684304 ], [ -136.372775, 58.667410 ], [ -136.396076, 58.654421 ], [ -136.409876, 58.649250 ], [ -136.422309, 58.647412 ], [ -136.449827, 58.637816 ], [ -136.482395, 58.616739 ], [ -136.459436, 58.607880 ], [ -136.383327, 58.629987 ], [ -136.342827, 58.645030 ], [ -136.331366, 58.663545 ], [ -136.317193, 58.671231 ], [ -136.246368, 58.663185 ], [ -136.232481, 58.677144 ], [ -136.223308, 58.675028 ], [ -136.213659, 58.665054 ], [ -136.194207, 58.581731 ], [ -136.181596, 58.535019 ], [ -136.170498, 58.527323 ], [ -136.100303, 58.500673 ], [ -136.103925, 58.478001 ], [ -136.083551, 58.447115 ], [ -136.062165, 58.435795 ], [ -136.053028, 58.417375 ], [ -136.041818, 58.380161 ], [ -136.092646, 58.348990 ], [ -136.111930, 58.342530 ], [ -136.265906, 58.314499 ], [ -136.276769, 58.313894 ], [ -136.288255, 58.316144 ], [ -136.296281, 58.318447 ], [ -136.304158, 58.323450 ], [ -136.305121, 58.328691 ], [ -136.303092, 58.336277 ], [ -136.298718, 58.342941 ], [ -136.290055, 58.351447 ], [ -136.281631, 58.353090 ], [ -136.273929, 58.363409 ], [ -136.282604, 58.367261 ], [ -136.288867, 58.369649 ], [ -136.336728, 58.377570 ], [ -136.382035, 58.362694 ], [ -136.365148, 58.346663 ], [ -136.360416, 58.344077 ], [ -136.357115, 58.328838 ], [ -136.370979, 58.301643 ], [ -136.376464, 58.298625 ], [ -136.389964, 58.297070 ], [ -136.472020, 58.306356 ], [ -136.532824, 58.334072 ], [ -136.550003, 58.340371 ], [ -136.593029, 58.349793 ], [ -136.613500, 58.347889 ], [ -136.630425, 58.340607 ], [ -136.638634, 58.328458 ], [ -136.626345, 58.320590 ], [ -136.576799, 58.277951 ], [ -136.569831, 58.268700 ], [ -136.567956, 58.245153 ], [ -136.591924, 58.217886 ], [ -136.597198, 58.215006 ], [ -136.619824, 58.209899 ], [ -136.658638, 58.207323 ], [ -136.701250, 58.219416 ], [ -136.723391, 58.244926 ], [ -136.730885, 58.256496 ], [ -136.717093, 58.273508 ], [ -136.730218, 58.286153 ], [ -136.762198, 58.286765 ], [ -136.784326, 58.290497 ], [ -136.857605, 58.316360 ], [ -136.848992, 58.328994 ], [ -136.946663, 58.393185 ], [ -136.986384, 58.404043 ], [ -137.009415, 58.408877 ], [ -137.018409, 58.409141 ], [ -137.078109, 58.397474 ], [ -137.111802, 58.392594 ], [ -137.134453, 58.406596 ], [ -137.180029, 58.429939 ], [ -137.239366, 58.453159 ], [ -137.252710, 58.456338 ], [ -137.278612, 58.459484 ], [ -137.295788, 58.466179 ], [ -137.408758, 58.515822 ], [ -137.497002, 58.557721 ], [ -137.568216, 58.587989 ], [ -137.608804, 58.601234 ], [ -137.632889, 58.599982 ], [ -137.671690, 58.615523 ], [ -137.680811, 58.621835 ], [ -137.676857, 58.646770 ], [ -137.683516, 58.660267 ], [ -137.687627, 58.664989 ], [ -137.795037, 58.724855 ], [ -137.875350, 58.757232 ], [ -137.901675, 58.765316 ], [ -137.928156, 58.780533 ], [ -137.941828, 58.794322 ], [ -137.944259, 58.802349 ], [ -137.944957, 58.804652 ], [ -137.939353, 58.813721 ], [ -137.931565, 58.819787 ], [ -137.927624, 58.827187 ], [ -137.924608, 58.843928 ], [ -137.932593, 58.868494 ], [ -137.951995, 58.886029 ], [ -137.985198, 58.909525 ], [ -138.066332, 58.957126 ], [ -138.136246, 58.989026 ], [ -138.131000, 59.002613 ], [ -138.117551, 59.012494 ], [ -138.118853, 59.021307 ], [ -138.144594, 59.028072 ], [ -138.250531, 59.047031 ], [ -138.636702, 59.130585 ], [ -138.705900, 59.162549 ], [ -138.763467, 59.191320 ], [ -138.847498, 59.224835 ], [ -138.919749, 59.248531 ], [ -139.044593, 59.280341 ], [ -139.271031, 59.337421 ], [ -139.343049, 59.356608 ], [ -139.420168, 59.379760 ], [ -139.541156, 59.423071 ], [ -139.595186, 59.445413 ], [ -139.746478, 59.503415 ], [ -139.855565, 59.536660 ], [ -139.862547, 59.544258 ], [ -139.861306, 59.546678 ], [ -139.847236, 59.557304 ], [ -139.837817, 59.561984 ], [ -139.807161, 59.554333 ], [ -139.785068, 59.564043 ], [ -139.768672, 59.597610 ], [ -139.737189, 59.632629 ], [ -139.732271, 59.636860 ], [ -139.718958, 59.641156 ], [ -139.708090, 59.642657 ], [ -139.667235, 59.638803 ], [ -139.655218, 59.633497 ], [ -139.656432, 59.621210 ], [ -139.671436, 59.615682 ], [ -139.676310, 59.611249 ], [ -139.672408, 59.602894 ], [ -139.654579, 59.598015 ], [ -139.623125, 59.595909 ], [ -139.614513, 59.597135 ], [ -139.587135, 59.605959 ], [ -139.581447, 59.609171 ], [ -139.582528, 59.613542 ], [ -139.589369, 59.618674 ], [ -139.593488, 59.624317 ], [ -139.585789, 59.642765 ], [ -139.518180, 59.687814 ], [ -139.524011, 59.712510 ], [ -139.552648, 59.706835 ], [ -139.579024, 59.712198 ], [ -139.587176, 59.715650 ], [ -139.593360, 59.721503 ], [ -139.591988, 59.725026 ], [ -139.581578, 59.735063 ], [ -139.576389, 59.738179 ], [ -139.559376, 59.742699 ], [ -139.546110, 59.752667 ], [ -139.562049, 59.774887 ], [ -139.577410, 59.789332 ], [ -139.590430, 59.810232 ], [ -139.617214, 59.863576 ], [ -139.624665, 59.884388 ], [ -139.621313, 59.906725 ], [ -139.616912, 59.911999 ], [ -139.610762, 59.913759 ], [ -139.597232, 59.913652 ], [ -139.577232, 59.918265 ], [ -139.535902, 59.935248 ], [ -139.527455, 59.940047 ], [ -139.488702, 59.995034 ], [ -139.486032, 60.012407 ], [ -139.505389, 60.039428 ], [ -139.555157, 60.039243 ], [ -139.576819, 60.015425 ], [ -139.601852, 59.959866 ], [ -139.605790, 59.955600 ], [ -139.657451, 59.944727 ], [ -139.682456, 59.943984 ], [ -139.693423, 59.940730 ], [ -139.705328, 59.934826 ], [ -139.769537, 59.878108 ], [ -139.768612, 59.851160 ], [ -139.775517, 59.845210 ], [ -139.801197, 59.832586 ], [ -139.811185, 59.829332 ], [ -139.909851, 59.806070 ], [ -140.102591, 59.754910 ], [ -140.141090, 59.747979 ], [ -140.164657, 59.741878 ], [ -140.178132, 59.735628 ], [ -140.188610, 59.725248 ], [ -140.210907, 59.715535 ], [ -140.256351, 59.703052 ], [ -140.272266, 59.700609 ], [ -140.285557, 59.698717 ], [ -140.314400, 59.698302 ], [ -140.385022, 59.699480 ], [ -140.601672, 59.712953 ], [ -140.636639, 59.711409 ], [ -140.721980, 59.718563 ], [ -140.883583, 59.737613 ], [ -140.927220, 59.745709 ], [ -141.013338, 59.773338 ], [ -141.156497, 59.813582 ], [ -141.216148, 59.827285 ], [ -141.423923, 59.867361 ], [ -141.442023, 59.873324 ], [ -141.450506, 59.890419 ], [ -141.467528, 59.971272 ], [ -141.530295, 59.977655 ], [ -141.631361, 59.962762 ], [ -141.709054, 59.948938 ], [ -141.869766, 59.998834 ], [ -141.912218, 60.009779 ], [ -141.966178, 60.019129 ], [ -141.998818, 60.022606 ], [ -142.062454, 60.023781 ], [ -142.100059, 60.026772 ], [ -142.130040, 60.030327 ], [ -142.245180, 60.049778 ], [ -142.537534, 60.083953 ], [ -142.589676, 60.088182 ], [ -142.698419, 60.093333 ], [ -142.809852, 60.095217 ], [ -142.875248, 60.092428 ], [ -142.908859, 60.090328 ], [ -143.068700, 60.068603 ], [ -143.135616, 60.062082 ], [ -143.194276, 60.061995 ], [ -143.413377, 60.051924 ], [ -143.624152, 60.037257 ], [ -143.698990, 60.027761 ], [ -143.885474, 59.996787 ], [ -143.891429, 59.995798 ], [ -143.931211, 59.998343 ], [ -143.978568, 60.006347 ], [ -143.989235, 60.008830 ], [ -143.988639, 60.013993 ], [ -143.991356, 60.017725 ], [ -144.001244, 60.020906 ], [ -144.013823, 60.024398 ], [ -144.043536, 60.025174 ], [ -144.055365, 60.037003 ], [ -144.052424, 60.047001 ], [ -144.033324, 60.059533 ], [ -144.140503, 60.114400 ], [ -144.204654, 60.137301 ], [ -144.229803, 60.142788 ], [ -144.253878, 60.165894 ], [ -144.253979, 60.182934 ], [ -144.318856, 60.189295 ], [ -144.358774, 60.188132 ], [ -144.369311, 60.185659 ], [ -144.379225, 60.169090 ], [ -144.441936, 60.163069 ], [ -144.453957, 60.166004 ], [ -144.478160, 60.181595 ], [ -144.501059, 60.189815 ], [ -144.534892, 60.189420 ], [ -144.545101, 60.186999 ], [ -144.553786, 60.181914 ], [ -144.555093, 60.178485 ], [ -144.558163, 60.177797 ], [ -144.596256, 60.181666 ], [ -144.654899, 60.204882 ], [ -144.666556, 60.222572 ], [ -144.662685, 60.229296 ], [ -144.662364, 60.239480 ], [ -144.666134, 60.243885 ], [ -144.715474, 60.271215 ], [ -144.753450, 60.283515 ], [ -144.782521, 60.291972 ], [ -144.892815, 60.292821 ], [ -144.914016, 60.280934 ], [ -144.942134, 60.289728 ], [ -144.912707, 60.363178 ], [ -144.871428, 60.407269 ], [ -144.855457, 60.416886 ], [ -144.834059, 60.443751 ], [ -144.848662, 60.455192 ], [ -144.874451, 60.457304 ], [ -144.887342, 60.456048 ], [ -144.903296, 60.442581 ], [ -144.964135, 60.444466 ], [ -144.983585, 60.446902 ], [ -145.012409, 60.447920 ], [ -145.125550, 60.429389 ], [ -145.152365, 60.421558 ], [ -145.181041, 60.407531 ], [ -145.191183, 60.395239 ], [ -145.202891, 60.374915 ], [ -145.169934, 60.329987 ], [ -145.112199, 60.296200 ], [ -145.122441, 60.289876 ], [ -145.222896, 60.297911 ], [ -145.364296, 60.335961 ], [ -145.503315, 60.387954 ], [ -145.510457, 60.408988 ], [ -145.503930, 60.410607 ], [ -145.501549, 60.416799 ], [ -145.502351, 60.420811 ], [ -145.536942, 60.430533 ], [ -145.561523, 60.443124 ], [ -145.594158, 60.451830 ], [ -145.668841, 60.465431 ], [ -145.735938, 60.474660 ], [ -145.799318, 60.462031 ], [ -145.853469, 60.445630 ], [ -145.882293, 60.444633 ], [ -145.946900, 60.455395 ], [ -145.957404, 60.461101 ], [ -145.961060, 60.465017 ], [ -145.960508, 60.467510 ], [ -145.914403, 60.492350 ], [ -145.863092, 60.501821 ], [ -145.802387, 60.520173 ], [ -145.712891, 60.583249 ], [ -145.736494, 60.595210 ], [ -145.764045, 60.591588 ], [ -145.780628, 60.579182 ], [ -145.798819, 60.561918 ], [ -145.820659, 60.550051 ], [ -145.828622, 60.549746 ], [ -145.964543, 60.513557 ], [ -146.039209, 60.492968 ], [ -146.074409, 60.480085 ], [ -146.109713, 60.470345 ], [ -146.216786, 60.450228 ], [ -146.247144, 60.451188 ], [ -146.312552, 60.457438 ], [ -146.317354, 60.460608 ], [ -146.351292, 60.454293 ], [ -146.355334, 60.449349 ], [ -146.356252, 60.425527 ], [ -146.350104, 60.407780 ], [ -146.330118, 60.407098 ], [ -146.308784, 60.414246 ], [ -146.284201, 60.417656 ], [ -146.133957, 60.431523 ], [ -146.127029, 60.430815 ], [ -146.123595, 60.428031 ], [ -146.126199, 60.424290 ], [ -146.094249, 60.410296 ], [ -146.133058, 60.383774 ], [ -146.198680, 60.359928 ], [ -146.268052, 60.347958 ], [ -146.302167, 60.349234 ], [ -146.392859, 60.327476 ], [ -146.458322, 60.307250 ], [ -146.490407, 60.294939 ], [ -146.539897, 60.270968 ], [ -146.607295, 60.241182 ], [ -146.627980, 60.239633 ], [ -146.641030, 60.240897 ], [ -146.650455, 60.242982 ], [ -146.689126, 60.271279 ], [ -146.693637, 60.279608 ], [ -146.693149, 60.284593 ], [ -146.681470, 60.292247 ], [ -146.649855, 60.305063 ], [ -146.594979, 60.321203 ], [ -146.571617, 60.321755 ], [ -146.540306, 60.338811 ], [ -146.524194, 60.350667 ], [ -146.542704, 60.357974 ], [ -146.575438, 60.357272 ], [ -146.607038, 60.351673 ], [ -146.624217, 60.341407 ], [ -146.655894, 60.340462 ], [ -146.717151, 60.349598 ], [ -146.725114, 60.359939 ], [ -146.723671, 60.387606 ], [ -146.721082, 60.396416 ], [ -146.637386, 60.467178 ], [ -146.610443, 60.485613 ], [ -146.590633, 60.491039 ], [ -146.528853, 60.492135 ], [ -146.523866, 60.487332 ], [ -146.505445, 60.476961 ], [ -146.455047, 60.465318 ], [ -146.368003, 60.480671 ], [ -146.316364, 60.497499 ], [ -146.289686, 60.515692 ], [ -146.155893, 60.526296 ], [ -146.079963, 60.543056 ], [ -145.951340, 60.576779 ], [ -145.886523, 60.585713 ], [ -145.872572, 60.584836 ], [ -145.844229, 60.586509 ], [ -145.800411, 60.593996 ], [ -145.794744, 60.601121 ], [ -145.795287, 60.603151 ], [ -145.815708, 60.612217 ], [ -145.832320, 60.614851 ], [ -145.856046, 60.610936 ], [ -145.888350, 60.610304 ], [ -145.896266, 60.611789 ], [ -145.897785, 60.613653 ], [ -145.896160, 60.628684 ], [ -145.895243, 60.629213 ], [ -145.897145, 60.651214 ], [ -145.883904, 60.658185 ], [ -145.867770, 60.666784 ], [ -145.841345, 60.685893 ], [ -145.841418, 60.689787 ], [ -145.844540, 60.690169 ], [ -145.851783, 60.689858 ], [ -145.858160, 60.688484 ], [ -145.875820, 60.683453 ], [ -145.894257, 60.674164 ], [ -145.899208, 60.671118 ], [ -145.922006, 60.651954 ], [ -145.924923, 60.648898 ], [ -145.936921, 60.632053 ], [ -145.937067, 60.630490 ], [ -145.965559, 60.622748 ], [ -146.002533, 60.615082 ], [ -146.004621, 60.616231 ], [ -146.005755, 60.616854 ], [ -146.007675, 60.619742 ], [ -146.007747, 60.625326 ], [ -145.999198, 60.640832 ], [ -145.968734, 60.668235 ], [ -145.937031, 60.682822 ], [ -145.931436, 60.685478 ], [ -145.911538, 60.696647 ], [ -145.899162, 60.705642 ], [ -145.901279, 60.715373 ], [ -145.905477, 60.715045 ], [ -145.978105, 60.684712 ], [ -146.016402, 60.667222 ], [ -146.025020, 60.665311 ], [ -146.055670, 60.658685 ], [ -146.086293, 60.652030 ], [ -146.116912, 60.643327 ], [ -146.130941, 60.639181 ], [ -146.143249, 60.633869 ], [ -146.147236, 60.631407 ], [ -146.187676, 60.624521 ], [ -146.253074, 60.622315 ], [ -146.258380, 60.626288 ], [ -146.263142, 60.631932 ], [ -146.268684, 60.641240 ], [ -146.270257, 60.644928 ], [ -146.270250, 60.648035 ], [ -146.262982, 60.651569 ], [ -146.188159, 60.687333 ], [ -146.178676, 60.691483 ], [ -146.140640, 60.707652 ], [ -146.124073, 60.712417 ], [ -146.101061, 60.719277 ], [ -146.043736, 60.743636 ], [ -146.045326, 60.754040 ], [ -146.048704, 60.763770 ], [ -146.064557, 60.776944 ], [ -146.067221, 60.773918 ], [ -146.070967, 60.770956 ], [ -146.085107, 60.761063 ], [ -146.089780, 60.758156 ], [ -146.120390, 60.741981 ], [ -146.160220, 60.726383 ], [ -146.168059, 60.725350 ], [ -146.191156, 60.731990 ], [ -146.199026, 60.734359 ], [ -146.201912, 60.735912 ], [ -146.200100, 60.743081 ], [ -146.208740, 60.744390 ], [ -146.216811, 60.741700 ], [ -146.228250, 60.735643 ], [ -146.230706, 60.722008 ], [ -146.239512, 60.716889 ], [ -146.257663, 60.713068 ], [ -146.303398, 60.713214 ], [ -146.313858, 60.717926 ], [ -146.317300, 60.721124 ], [ -146.317949, 60.723817 ], [ -146.312283, 60.734401 ], [ -146.346573, 60.735747 ], [ -146.386892, 60.714598 ], [ -146.402873, 60.693084 ], [ -146.412520, 60.690450 ], [ -146.474142, 60.681539 ], [ -146.499849, 60.680134 ], [ -146.517848, 60.688102 ], [ -146.532396, 60.689748 ], [ -146.578813, 60.690212 ], [ -146.607153, 60.686377 ], [ -146.623266, 60.680420 ], [ -146.649059, 60.683438 ], [ -146.667754, 60.692761 ], [ -146.699219, 60.732176 ], [ -146.703597, 60.741903 ], [ -146.605008, 60.758608 ], [ -146.566731, 60.751198 ], [ -146.500678, 60.772113 ], [ -146.464824, 60.770722 ], [ -146.358618, 60.786193 ], [ -146.304445, 60.798038 ], [ -146.255415, 60.809962 ], [ -146.183158, 60.846969 ], [ -146.171897, 60.862823 ], [ -146.173131, 60.866071 ], [ -146.188185, 60.869374 ], [ -146.262572, 60.867787 ], [ -146.268659, 60.863842 ], [ -146.290202, 60.842694 ], [ -146.313757, 60.827833 ], [ -146.333424, 60.821921 ], [ -146.394369, 60.812271 ], [ -146.550577, 60.809402 ], [ -146.555964, 60.810066 ], [ -146.620419, 60.869019 ], [ -146.664368, 60.870854 ], [ -146.700741, 60.848345 ], [ -146.718132, 60.835667 ], [ -146.719532, 60.830166 ], [ -146.714748, 60.820385 ], [ -146.719790, 60.814475 ], [ -146.724844, 60.812120 ], [ -146.754847, 60.807882 ], [ -146.800612, 60.805160 ], [ -146.819018, 60.816346 ], [ -146.819008, 60.841568 ], [ -146.816305, 60.855628 ], [ -146.787431, 60.865597 ], [ -146.774155, 60.876225 ], [ -146.757004, 60.878454 ], [ -146.727226, 60.866270 ], [ -146.697690, 60.872534 ], [ -146.711287, 60.896465 ], [ -146.736025, 60.910301 ], [ -146.746758, 60.935454 ], [ -146.745543, 60.957582 ], [ -146.701356, 60.987009 ], [ -146.653430, 61.047752 ], [ -146.661518, 61.060776 ], [ -146.690552, 61.064076 ], [ -146.783730, 61.042936 ], [ -146.848112, 61.000587 ], [ -146.862709, 60.982523 ], [ -146.861961, 60.976177 ], [ -146.868826, 60.971448 ], [ -146.879853, 60.965161 ], [ -146.929789, 60.944263 ], [ -146.973072, 60.934835 ], [ -147.038952, 60.942079 ], [ -147.055754, 60.945468 ], [ -147.070552, 60.963312 ], [ -147.063230, 60.974057 ], [ -147.047088, 60.991209 ], [ -147.062671, 61.004336 ], [ -147.094863, 61.010189 ], [ -147.112607, 61.002974 ], [ -147.136884, 60.980968 ], [ -147.144639, 60.963492 ], [ -147.135571, 60.946248 ], [ -147.143314, 60.939831 ], [ -147.171624, 60.932877 ], [ -147.181257, 60.933099 ], [ -147.204930, 60.942660 ], [ -147.215273, 60.948077 ], [ -147.220809, 60.953121 ], [ -147.226487, 60.962160 ], [ -147.219575, 60.969505 ], [ -147.220325, 60.981702 ], [ -147.221616, 60.983541 ], [ -147.252984, 60.979621 ], [ -147.273646, 60.974595 ], [ -147.278004, 60.961063 ], [ -147.280437, 60.916963 ], [ -147.378086, 60.877845 ], [ -147.451569, 60.894219 ], [ -147.452904, 60.897366 ], [ -147.451699, 60.925880 ], [ -147.453406, 60.941468 ], [ -147.473090, 60.957552 ], [ -147.491546, 60.957998 ], [ -147.507268, 60.927235 ], [ -147.506010, 60.921170 ], [ -147.502365, 60.920429 ], [ -147.493812, 60.912379 ], [ -147.517424, 60.894819 ], [ -147.525056, 60.896057 ], [ -147.543002, 60.903331 ], [ -147.549756, 60.908009 ], [ -147.536798, 61.019346 ], [ -147.534034, 61.031090 ], [ -147.515782, 61.061408 ], [ -147.502323, 61.072056 ], [ -147.513776, 61.096127 ], [ -147.525097, 61.101176 ], [ -147.558201, 61.099797 ], [ -147.554439, 61.091719 ], [ -147.557226, 61.081402 ], [ -147.591260, 61.016591 ], [ -147.618800, 60.970040 ], [ -147.613846, 60.951496 ], [ -147.597749, 60.913905 ], [ -147.587309, 60.874463 ], [ -147.602405, 60.849978 ], [ -147.626585, 60.845065 ], [ -147.668593, 60.841563 ], [ -147.671928, 60.845283 ], [ -147.677292, 60.869960 ], [ -147.662960, 60.874951 ], [ -147.665855, 60.883774 ], [ -147.730391, 60.911256 ], [ -147.760843, 60.913227 ], [ -147.787115, 60.873511 ], [ -147.779717, 60.863435 ], [ -147.766961, 60.853544 ], [ -147.750212, 60.852141 ], [ -147.732124, 60.824711 ], [ -147.729421, 60.818252 ], [ -147.733252, 60.816975 ], [ -147.743256, 60.813887 ], [ -147.777157, 60.811018 ], [ -147.828765, 60.815947 ], [ -147.855920, 60.820882 ], [ -147.913399, 60.825152 ], [ -147.915116, 60.818955 ], [ -147.920445, 60.812442 ], [ -148.033953, 60.783198 ], [ -148.098148, 60.786556 ], [ -148.133987, 60.791268 ], [ -148.144355, 60.797089 ], [ -148.151597, 60.818122 ], [ -148.148298, 60.828701 ], [ -148.101841, 60.899347 ], [ -148.085220, 60.918613 ], [ -148.065132, 60.937963 ], [ -148.017276, 60.971807 ], [ -147.950619, 61.029211 ], [ -147.947785, 61.040625 ], [ -147.961969, 61.059537 ], [ -147.973392, 61.067391 ], [ -147.982673, 61.070246 ], [ -147.991241, 61.069533 ], [ -148.001637, 61.060103 ], [ -148.003216, 61.053797 ], [ -148.065505, 61.003979 ], [ -148.090090, 61.005110 ], [ -148.095004, 61.011384 ], [ -148.105388, 61.035123 ], [ -148.125128, 61.070698 ], [ -148.149024, 61.076672 ], [ -148.165969, 61.069277 ], [ -148.164452, 61.042665 ], [ -148.177649, 60.999608 ], [ -148.198970, 60.971584 ], [ -148.218954, 60.953573 ], [ -148.241664, 60.937738 ], [ -148.265584, 60.936331 ], [ -148.281248, 60.917792 ], [ -148.294475, 60.862751 ], [ -148.309710, 60.837737 ], [ -148.340711, 60.809072 ], [ -148.350460, 60.803991 ], [ -148.375416, 60.803470 ], [ -148.389517, 60.805622 ], [ -148.396614, 60.813694 ], [ -148.426555, 60.827113 ], [ -148.446278, 60.808705 ], [ -148.450122, 60.796405 ], [ -148.450890, 60.789487 ], [ -148.441666, 60.777956 ], [ -148.431078, 60.771842 ], [ -148.405576, 60.780301 ], [ -148.395962, 60.779701 ], [ -148.381999, 60.775768 ], [ -148.366407, 60.765833 ], [ -148.365314, 60.740969 ], [ -148.384094, 60.687754 ], [ -148.374018, 60.672640 ], [ -148.347881, 60.680327 ], [ -148.326357, 60.709539 ], [ -148.280136, 60.753337 ], [ -148.269523, 60.757389 ], [ -148.229756, 60.764140 ], [ -148.147662, 60.758536 ], [ -148.120366, 60.748952 ], [ -148.106987, 60.739770 ], [ -148.091315, 60.676249 ], [ -148.093732, 60.661533 ], [ -148.142596, 60.622632 ], [ -148.229961, 60.595062 ], [ -148.237828, 60.600206 ], [ -148.254852, 60.595124 ], [ -148.292837, 60.565496 ], [ -148.306123, 60.550702 ], [ -148.328167, 60.531913 ], [ -148.333245, 60.530464 ], [ -148.345627, 60.502973 ], [ -148.346378, 60.488730 ], [ -148.328987, 60.476182 ], [ -148.293534, 60.483001 ], [ -148.255425, 60.493410 ], [ -148.247867, 60.500504 ], [ -148.250132, 60.507573 ], [ -148.238554, 60.521443 ], [ -148.192033, 60.557371 ], [ -148.114766, 60.596029 ], [ -148.102747, 60.598026 ], [ -148.086378, 60.595518 ], [ -147.979019, 60.519146 ], [ -147.963617, 60.502750 ], [ -147.971198, 60.486479 ], [ -147.977250, 60.480937 ], [ -147.941709, 60.444029 ], [ -147.992939, 60.352596 ], [ -148.025597, 60.279029 ], [ -148.064494, 60.276233 ], [ -148.115864, 60.279522 ], [ -148.150132, 60.296210 ], [ -148.153122, 60.303062 ], [ -148.153624, 60.311600 ], [ -148.150109, 60.320739 ], [ -148.150231, 60.324182 ], [ -148.170881, 60.335266 ], [ -148.192669, 60.339103 ], [ -148.216921, 60.331594 ], [ -148.215848, 60.318269 ], [ -148.211194, 60.306961 ], [ -148.215152, 60.301014 ], [ -148.284807, 60.270971 ], [ -148.312625, 60.263084 ], [ -148.325572, 60.261824 ], [ -148.362100, 60.221849 ], [ -148.339155, 60.213350 ], [ -148.332652, 60.214000 ], [ -148.321208, 60.218469 ], [ -148.275752, 60.249270 ], [ -148.216863, 60.260006 ], [ -148.208328, 60.259342 ], [ -148.192000, 60.252500 ], [ -148.188298, 60.248574 ], [ -148.192569, 60.241826 ], [ -148.200779, 60.236711 ], [ -148.228931, 60.235911 ], [ -148.234227, 60.223689 ], [ -148.190530, 60.206957 ], [ -148.165099, 60.206173 ], [ -148.158947, 60.211675 ], [ -148.153775, 60.226236 ], [ -148.153037, 60.235528 ], [ -148.139869, 60.241081 ], [ -148.090238, 60.215863 ], [ -148.117300, 60.191335 ], [ -148.133624, 60.188390 ], [ -148.134990, 60.184596 ], [ -148.130641, 60.169789 ], [ -148.126291, 60.167063 ], [ -148.090876, 60.168649 ], [ -148.080188, 60.171568 ], [ -148.079884, 60.184234 ], [ -148.085791, 60.190041 ], [ -148.082874, 60.192357 ], [ -148.061865, 60.200094 ], [ -148.051918, 60.202062 ], [ -148.003433, 60.176167 ], [ -148.006656, 60.168461 ], [ -148.018404, 60.157419 ], [ -148.028870, 60.150518 ], [ -148.032495, 60.148423 ], [ -148.064401, 60.148508 ], [ -148.097230, 60.120120 ], [ -148.121797, 60.073548 ], [ -148.095719, 60.065935 ], [ -148.079466, 60.073251 ], [ -148.053431, 60.090762 ], [ -148.040178, 60.112361 ], [ -148.012270, 60.124734 ], [ -147.961701, 60.140900 ], [ -147.912824, 60.132576 ], [ -147.892320, 60.119515 ], [ -147.887734, 60.109683 ], [ -147.892576, 60.101161 ], [ -147.973112, 60.064636 ], [ -147.998659, 60.062305 ], [ -148.013551, 60.038159 ], [ -148.023817, 60.007108 ], [ -148.016035, 59.999344 ], [ -147.986164, 59.999344 ], [ -147.924401, 60.036230 ], [ -147.892229, 60.063265 ], [ -147.879679, 60.069593 ], [ -147.860607, 60.076356 ], [ -147.848072, 60.078962 ], [ -147.822043, 60.066955 ], [ -147.816451, 60.061824 ], [ -147.815238, 60.058562 ], [ -147.823738, 60.045035 ], [ -147.863929, 60.006619 ], [ -147.917538, 59.985997 ], [ -148.005827, 59.961542 ], [ -148.031770, 59.955862 ], [ -148.036776, 59.956664 ], [ -148.050706, 59.968908 ], [ -148.050143, 59.976767 ], [ -148.056373, 59.990423 ], [ -148.069919, 59.989098 ], [ -148.085820, 59.977512 ], [ -148.104818, 59.969237 ], [ -148.135095, 59.959055 ], [ -148.153742, 59.954643 ], [ -148.224838, 59.950195 ], [ -148.251099, 59.952416 ], [ -148.252869, 59.955614 ], [ -148.213497, 59.994643 ], [ -148.193842, 59.998979 ], [ -148.179545, 59.996653 ], [ -148.147614, 59.994952 ], [ -148.132300, 59.997697 ], [ -148.128693, 60.003442 ], [ -148.138918, 60.012416 ], [ -148.175808, 60.026337 ], [ -148.212668, 60.018101 ], [ -148.273844, 60.013318 ], [ -148.317941, 60.028731 ], [ -148.305725, 60.054468 ], [ -148.290367, 60.059995 ], [ -148.292816, 60.151289 ], [ -148.305868, 60.161607 ], [ -148.316849, 60.165437 ], [ -148.346535, 60.162108 ], [ -148.358188, 60.156510 ], [ -148.369109, 60.120922 ], [ -148.382325, 60.063299 ], [ -148.401204, 59.997600 ], [ -148.429106, 59.969158 ], [ -148.445588, 59.963755 ], [ -148.470205, 59.973708 ], [ -148.480171, 59.979653 ], [ -148.482505, 59.983308 ], [ -148.476974, 59.989515 ], [ -148.480436, 59.999394 ], [ -148.508825, 60.002875 ], [ -148.544134, 60.002809 ], [ -148.556294, 59.984931 ], [ -148.555253, 59.980657 ], [ -148.599121, 59.950889 ], [ -148.635842, 59.939661 ], [ -148.673822, 59.944828 ], [ -148.676172, 59.947216 ], [ -148.675485, 59.952070 ], [ -148.664283, 59.965128 ], [ -148.661876, 59.967436 ], [ -148.660830, 59.969735 ], [ -148.662712, 59.971825 ], [ -148.668146, 59.973497 ], [ -148.674841, 59.972699 ], [ -148.688758, 59.968006 ], [ -148.715511, 59.962120 ], [ -148.725872, 59.963727 ], [ -148.727688, 59.965050 ], [ -148.729731, 59.972376 ], [ -148.737453, 59.980879 ], [ -148.743229, 59.985389 ], [ -148.749742, 59.988497 ], [ -148.755366, 59.989237 ], [ -148.759807, 59.988941 ], [ -148.763803, 59.987905 ], [ -148.766911, 59.986869 ], [ -148.769871, 59.983464 ], [ -148.797927, 59.977400 ], [ -148.801223, 59.975844 ], [ -148.810654, 59.963105 ], [ -148.838304, 59.949900 ], [ -148.872181, 59.950321 ], [ -148.884265, 59.955388 ], [ -148.888537, 59.966362 ], [ -148.901981, 59.973319 ], [ -148.913089, 59.983207 ], [ -148.914569, 59.986891 ], [ -148.912676, 59.992894 ], [ -148.917819, 59.995595 ], [ -148.938327, 59.999074 ], [ -148.957554, 59.998371 ], [ -148.977589, 59.989881 ], [ -148.990301, 59.981013 ], [ -149.016790, 59.976134 ], [ -149.028418, 59.978821 ], [ -149.029394, 59.984098 ], [ -149.027274, 59.991698 ], [ -149.031273, 59.998492 ], [ -149.043265, 59.999115 ], [ -149.067833, 59.982177 ], [ -149.095070, 59.983019 ], [ -149.100687, 59.985727 ], [ -149.101785, 59.990943 ], [ -149.102321, 59.993149 ], [ -149.101717, 59.994155 ], [ -149.098699, 59.996167 ], [ -149.095278, 59.997374 ], [ -149.090072, 59.999445 ], [ -149.089077, 60.004504 ], [ -149.072716, 60.019653 ], [ -149.041599, 60.030726 ], [ -149.037439, 60.040530 ], [ -149.040358, 60.048744 ], [ -149.049290, 60.058700 ], [ -149.058700, 60.061419 ], [ -149.096621, 60.044631 ], [ -149.133115, 60.044918 ], [ -149.204853, 60.009212 ], [ -149.223781, 59.982763 ], [ -149.235390, 59.938792 ], [ -149.287588, 59.906506 ], [ -149.327029, 59.987029 ], [ -149.325822, 60.001033 ], [ -149.341584, 60.076762 ], [ -149.360414, 60.101665 ], [ -149.393171, 60.099845 ], [ -149.416829, 60.088926 ], [ -149.416829, 59.997934 ], [ -149.427748, 59.996114 ], [ -149.435027, 59.990655 ], [ -149.462855, 59.950151 ], [ -149.475659, 59.952698 ], [ -149.507429, 59.964519 ], [ -149.549677, 59.919681 ], [ -149.584254, 59.866905 ], [ -149.542398, 59.823229 ], [ -149.511461, 59.806851 ], [ -149.527839, 59.750436 ], [ -149.598813, 59.755895 ], [ -149.640669, 59.799571 ], [ -149.666147, 59.850527 ], [ -149.706184, 59.910582 ], [ -149.753500, 59.861446 ], [ -149.738941, 59.732237 ], [ -149.751680, 59.717678 ], [ -149.759110, 59.697825 ], [ -149.778024, 59.685930 ], [ -149.798304, 59.677545 ], [ -149.842672, 59.701300 ], [ -149.839032, 59.752255 ], [ -149.889988, 59.785013 ], [ -149.977340, 59.801391 ], [ -150.028296, 59.788652 ], [ -150.042854, 59.772274 ], [ -150.015557, 59.754075 ], [ -149.979160, 59.744976 ], [ -149.948223, 59.717678 ], [ -149.962781, 59.697660 ], [ -150.002818, 59.683101 ], [ -150.022836, 59.655804 ], [ -150.031935, 59.613947 ], [ -150.068332, 59.637605 ], [ -150.095630, 59.648524 ], [ -150.108369, 59.603028 ], [ -150.168424, 59.561172 ], [ -150.223019, 59.539334 ], [ -150.253956, 59.521136 ], [ -150.310371, 59.508397 ], [ -150.343128, 59.512036 ], [ -150.334029, 59.541154 ], [ -150.315831, 59.562992 ], [ -150.317651, 59.599389 ], [ -150.347696, 59.600928 ], [ -150.355493, 59.598412 ], [ -150.412448, 59.554628 ], [ -150.431518, 59.514287 ], [ -150.478742, 59.458498 ], [ -150.498900, 59.456298 ], [ -150.516317, 59.462326 ], [ -150.521537, 59.467924 ], [ -150.521626, 59.474672 ], [ -150.518382, 59.477136 ], [ -150.515867, 59.482167 ], [ -150.516286, 59.486778 ], [ -150.522994, 59.494744 ], [ -150.536119, 59.498457 ], [ -150.543537, 59.510256 ], [ -150.550245, 59.527026 ], [ -150.549825, 59.538764 ], [ -150.533056, 59.563080 ], [ -150.537248, 59.581108 ], [ -150.541860, 59.586977 ], [ -150.547729, 59.590331 ], [ -150.556114, 59.590331 ], [ -150.575818, 59.579431 ], [ -150.589315, 59.565154 ], [ -150.594543, 59.553167 ], [ -150.602230, 59.545891 ], [ -150.614808, 59.545472 ], [ -150.631158, 59.549245 ], [ -150.639543, 59.547149 ], [ -150.638704, 59.532056 ], [ -150.631577, 59.521575 ], [ -150.615152, 59.510199 ], [ -150.595056, 59.499777 ], [ -150.589645, 59.500083 ], [ -150.584636, 59.494510 ], [ -150.579595, 59.479540 ], [ -150.579869, 59.475709 ], [ -150.584342, 59.467715 ], [ -150.585567, 59.450057 ], [ -150.581182, 59.445233 ], [ -150.601162, 59.425657 ], [ -150.650046, 59.420885 ], [ -150.651586, 59.421751 ], [ -150.654010, 59.445458 ], [ -150.656329, 59.454437 ], [ -150.667211, 59.457900 ], [ -150.683235, 59.458541 ], [ -150.716564, 59.450849 ], [ -150.729062, 59.442197 ], [ -150.739958, 59.425211 ], [ -150.745004, 59.400729 ], [ -150.769853, 59.372966 ], [ -150.795470, 59.362845 ], [ -150.819565, 59.357276 ], [ -150.834627, 59.351980 ], [ -150.877447, 59.318120 ], [ -150.911598, 59.311614 ], [ -150.912817, 59.305214 ], [ -150.895552, 59.286227 ], [ -150.887825, 59.273526 ], [ -150.887821, 59.267920 ], [ -150.897808, 59.255648 ], [ -150.942212, 59.233136 ], [ -150.959531, 59.232537 ], [ -150.975164, 59.236141 ], [ -150.988397, 59.230549 ], [ -150.995406, 59.224149 ], [ -151.001196, 59.224149 ], [ -151.006682, 59.233292 ], [ -151.008815, 59.245787 ], [ -151.007292, 59.251577 ], [ -150.996808, 59.257739 ], [ -150.999063, 59.271082 ], [ -151.023097, 59.269045 ], [ -151.032430, 59.275762 ], [ -151.044411, 59.293611 ], [ -151.046100, 59.299359 ], [ -151.057756, 59.301721 ], [ -151.070305, 59.287852 ], [ -151.068166, 59.284102 ], [ -151.071902, 59.281058 ], [ -151.087319, 59.268790 ], [ -151.091532, 59.269187 ], [ -151.105635, 59.263143 ], [ -151.101102, 59.240605 ], [ -151.102395, 59.228713 ], [ -151.107558, 59.217792 ], [ -151.126247, 59.209923 ], [ -151.163408, 59.202636 ], [ -151.186254, 59.202813 ], [ -151.190948, 59.206632 ], [ -151.192634, 59.211208 ], [ -151.206053, 59.219319 ], [ -151.223629, 59.224347 ], [ -151.261636, 59.220304 ], [ -151.273779, 59.229663 ], [ -151.280544, 59.230476 ], [ -151.284880, 59.227586 ], [ -151.287063, 59.224789 ], [ -151.287771, 59.219417 ], [ -151.292812, 59.214273 ], [ -151.305724, 59.209544 ], [ -151.341601, 59.222231 ], [ -151.379612, 59.242024 ], [ -151.387261, 59.250450 ], [ -151.390544, 59.264917 ], [ -151.399549, 59.276005 ], [ -151.407203, 59.279349 ], [ -151.429415, 59.268552 ], [ -151.437695, 59.253989 ], [ -151.449207, 59.248457 ], [ -151.488612, 59.237714 ], [ -151.509551, 59.234395 ], [ -151.518488, 59.230309 ], [ -151.525127, 59.224947 ], [ -151.520245, 59.216930 ], [ -151.504699, 59.212690 ], [ -151.499592, 59.207839 ], [ -151.497805, 59.204264 ], [ -151.498826, 59.200178 ], [ -151.502657, 59.195071 ], [ -151.521455, 59.195483 ], [ -151.558151, 59.200085 ], [ -151.574664, 59.195327 ], [ -151.579261, 59.187666 ], [ -151.576452, 59.172601 ], [ -151.580351, 59.165233 ], [ -151.590729, 59.161725 ], [ -151.698875, 59.163081 ], [ -151.710625, 59.158097 ], [ -151.720931, 59.156078 ], [ -151.739068, 59.156005 ], [ -151.748451, 59.158601 ], [ -151.764908, 59.175510 ], [ -151.761451, 59.205235 ], [ -151.758530, 59.215743 ], [ -151.761301, 59.221327 ], [ -151.838335, 59.209135 ], [ -151.874356, 59.211931 ], [ -151.915684, 59.227522 ], [ -151.917248, 59.231254 ], [ -151.910958, 59.236707 ], [ -151.906191, 59.237963 ], [ -151.905106, 59.247075 ], [ -151.925051, 59.254428 ], [ -151.952723, 59.250447 ], [ -151.959279, 59.247625 ], [ -151.978748, 59.253779 ], [ -151.991618, 59.313617 ], [ -151.963130, 59.344958 ], [ -151.952705, 59.349413 ], [ -151.924018, 59.354417 ], [ -151.903021, 59.360454 ], [ -151.890738, 59.373156 ], [ -151.887102, 59.382532 ], [ -151.908015, 59.395274 ], [ -151.905153, 59.401035 ], [ -151.886513, 59.421033 ], [ -151.826047, 59.439049 ], [ -151.770875, 59.447917 ], [ -151.751420, 59.446554 ], [ -151.740538, 59.438432 ], [ -151.728486, 59.439679 ], [ -151.720421, 59.443117 ], [ -151.706462, 59.462811 ], [ -151.694726, 59.468370 ], [ -151.634472, 59.482443 ], [ -151.570032, 59.468945 ], [ -151.542349, 59.467061 ], [ -151.528493, 59.472338 ], [ -151.505890, 59.477048 ], [ -151.485624, 59.475459 ], [ -151.470992, 59.472250 ], [ -151.466272, 59.484050 ], [ -151.469630, 59.502811 ], [ -151.436359, 59.530329 ], [ -151.420966, 59.537728 ], [ -151.365776, 59.541255 ], [ -151.323670, 59.550943 ], [ -151.272459, 59.555823 ], [ -151.266733, 59.562632 ], [ -151.264811, 59.568598 ], [ -151.271737, 59.576468 ], [ -151.278905, 59.589029 ], [ -151.278827, 59.592980 ], [ -151.274795, 59.596986 ], [ -151.201678, 59.591503 ], [ -151.203835, 59.577961 ], [ -151.209130, 59.573623 ], [ -151.208364, 59.562061 ], [ -151.192803, 59.562432 ], [ -151.164259, 59.587013 ], [ -151.158254, 59.594141 ], [ -151.165427, 59.601329 ], [ -151.188032, 59.608687 ], [ -151.205459, 59.630284 ], [ -151.207639, 59.640670 ], [ -151.203186, 59.645989 ], [ -151.173984, 59.651793 ], [ -151.126122, 59.668336 ], [ -151.121362, 59.674735 ], [ -151.122791, 59.677782 ], [ -151.116490, 59.696132 ], [ -151.098253, 59.709442 ], [ -151.018888, 59.756593 ], [ -150.927312, 59.793431 ], [ -150.948132, 59.792194 ], [ -150.982996, 59.783543 ], [ -151.001663, 59.788391 ], [ -151.006717, 59.792986 ], [ -151.027756, 59.796196 ], [ -151.063758, 59.793146 ], [ -151.113845, 59.777231 ], [ -151.172439, 59.751346 ], [ -151.214539, 59.729847 ], [ -151.329812, 59.683644 ], [ -151.377054, 59.681313 ], [ -151.424840, 59.670521 ], [ -151.436610, 59.666360 ], [ -151.439187, 59.663247 ], [ -151.441127, 59.653543 ], [ -151.448669, 59.648171 ], [ -151.461253, 59.643039 ], [ -151.503822, 59.633662 ], [ -151.643061, 59.646966 ], [ -151.686486, 59.660864 ], [ -151.746815, 59.686234 ], [ -151.796300, 59.704156 ], [ -151.829137, 59.720151 ], [ -151.850272, 59.739035 ], [ -151.859327, 59.749567 ], [ -151.869468, 59.769159 ], [ -151.867713, 59.778411 ], [ -151.857339, 59.791145 ], [ -151.833340, 59.814129 ], [ -151.813619, 59.844297 ], [ -151.803059, 59.878533 ], [ -151.792594, 59.888810 ], [ -151.777855, 59.897493 ], [ -151.757693, 59.917637 ], [ -151.742742, 59.944626 ], [ -151.718010, 60.009473 ], [ -151.702898, 60.032253 ], [ -151.661437, 60.057139 ], [ -151.623799, 60.088033 ], [ -151.606881, 60.099558 ], [ -151.545579, 60.128394 ], [ -151.517887, 60.145008 ], [ -151.488721, 60.167616 ], [ -151.421702, 60.212931 ], [ -151.406607, 60.228183 ], [ -151.387919, 60.267066 ], [ -151.381959, 60.296951 ], [ -151.383231, 60.326348 ], [ -151.381604, 60.358728 ], [ -151.377281, 60.365522 ], [ -151.366874, 60.372655 ], [ -151.306090, 60.387257 ], [ -151.301868, 60.384712 ], [ -151.299782, 60.385481 ], [ -151.293074, 60.416163 ], [ -151.286819, 60.434648 ], [ -151.283967, 60.452196 ], [ -151.280992, 60.512627 ], [ -151.278810, 60.520107 ], [ -151.264461, 60.543263 ], [ -151.268373, 60.548977 ], [ -151.303125, 60.561326 ], [ -151.323951, 60.574135 ], [ -151.330409, 60.580539 ], [ -151.339069, 60.594244 ], [ -151.344477, 60.613458 ], [ -151.345508, 60.622954 ], [ -151.350154, 60.634660 ], [ -151.362397, 60.653526 ], [ -151.387839, 60.674501 ], [ -151.404451, 60.695004 ], [ -151.410273, 60.711023 ], [ -151.409270, 60.720558 ], [ -151.384800, 60.729946 ], [ -151.370515, 60.733572 ], [ -151.309230, 60.740724 ], [ -151.279635, 60.747676 ], [ -151.270505, 60.751286 ], [ -151.261383, 60.757768 ], [ -151.259343, 60.762896 ], [ -151.261319, 60.769801 ], [ -151.252902, 60.773993 ], [ -151.212186, 60.780342 ], [ -151.106079, 60.783749 ], [ -151.062558, 60.787429 ], [ -151.037007, 60.793649 ], [ -151.025634, 60.797497 ], [ -151.024799, 60.801787 ], [ -151.012016, 60.809340 ], [ -150.895508, 60.853166 ], [ -150.886964, 60.858187 ], [ -150.883774, 60.861865 ], [ -150.845731, 60.877893 ], [ -150.808418, 60.891336 ], [ -150.770594, 60.911362 ], [ -150.705812, 60.937792 ], [ -150.678438, 60.958267 ], [ -150.603069, 60.974434 ], [ -150.582471, 60.982095 ], [ -150.515058, 60.999443 ], [ -150.511099, 61.005145 ], [ -150.501923, 61.007957 ], [ -150.454661, 61.016566 ], [ -150.431873, 61.023939 ], [ -150.401859, 61.036227 ], [ -150.377171, 61.039144 ], [ -150.353702, 61.031822 ], [ -150.341709, 61.024201 ], [ -150.310334, 60.989547 ], [ -150.286369, 60.966696 ], [ -150.262096, 60.947839 ], [ -150.244072, 60.938585 ], [ -150.217179, 60.930001 ], [ -150.187657, 60.924796 ], [ -150.085166, 60.914020 ], [ -150.070289, 60.913679 ], [ -150.045570, 60.910004 ], [ -150.049148, 60.915816 ], [ -150.047088, 60.918924 ], [ -150.039866, 60.920777 ], [ -149.952655, 60.930393 ], [ -149.912166, 60.937843 ], [ -149.875188, 60.960244 ], [ -149.853693, 60.967395 ], [ -149.835580, 60.968855 ], [ -149.816817, 60.966947 ], [ -149.770264, 60.967607 ], [ -149.764966, 60.963412 ], [ -149.753082, 60.962059 ], [ -149.735376, 60.987813 ], [ -149.736395, 60.994692 ], [ -149.739692, 61.016961 ], [ -149.751943, 61.024072 ], [ -149.784393, 61.038147 ], [ -149.785126, 61.040798 ], [ -149.805816, 61.058641 ], [ -149.831922, 61.076197 ], [ -149.857168, 61.079020 ], [ -149.915666, 61.101428 ], [ -149.960100, 61.115346 ], [ -150.039304, 61.144291 ], [ -150.065646, 61.151079 ], [ -150.075451, 61.156269 ], [ -150.068004, 61.166132 ], [ -150.009941, 61.203637 ], [ -149.987002, 61.222753 ], [ -149.986576, 61.228323 ], [ -149.985874, 61.237515 ], [ -150.074793, 61.253500 ], [ -150.132634, 61.257915 ], [ -150.204894, 61.259548 ], [ -150.254296, 61.254501 ], [ -150.266124, 61.251237 ], [ -150.273575, 61.251559 ], [ -150.286978, 61.257443 ], [ -150.303688, 61.257467 ], [ -150.303639, 61.255871 ], [ -150.312226, 61.254029 ], [ -150.334576, 61.251301 ], [ -150.394411, 61.249107 ], [ -150.425000, 61.245552 ], [ -150.468812, 61.244627 ], [ -150.484391, 61.247262 ], [ -150.495726, 61.251245 ], [ -150.561670, 61.281487 ], [ -150.590166, 61.281487 ], [ -150.591842, 61.279485 ], [ -150.606961, 61.277732 ], [ -150.628459, 61.284407 ], [ -150.646221, 61.296689 ], [ -150.655804, 61.298173 ], [ -150.662620, 61.295356 ], [ -150.671250, 61.273652 ], [ -150.679902, 61.265888 ], [ -150.690497, 61.259297 ], [ -150.711291, 61.251089 ], [ -150.827295, 61.228390 ], [ -150.842410, 61.224213 ], [ -150.848842, 61.220588 ], [ -150.895905, 61.208915 ], [ -150.926773, 61.206351 ], [ -150.939251, 61.210299 ], [ -150.941944, 61.209947 ], [ -150.946243, 61.208644 ], [ -150.947155, 61.206299 ], [ -150.947425, 61.203140 ], [ -150.951153, 61.198778 ], [ -150.960114, 61.194037 ], [ -150.971775, 61.192041 ], [ -150.990086, 61.188907 ], [ -151.012620, 61.183258 ], [ -151.024905, 61.178391 ], [ -151.072775, 61.141669 ], [ -151.078500, 61.133381 ], [ -151.119722, 61.091117 ], [ -151.121692, 61.083574 ], [ -151.127357, 61.076896 ], [ -151.142587, 61.062778 ], [ -151.166606, 61.046404 ], [ -151.190318, 61.042737 ], [ -151.252384, 61.039968 ], [ -151.293622, 61.035715 ], [ -151.307796, 61.031008 ], [ -151.312653, 61.026364 ], [ -151.330920, 61.015124 ], [ -151.349004, 61.010004 ], [ -151.362243, 61.009412 ], [ -151.425120, 61.013107 ], [ -151.467851, 61.012423 ], [ -151.480300, 61.010902 ], [ -151.538227, 60.991835 ], [ -151.573698, 60.975876 ], [ -151.621005, 60.957453 ], [ -151.637346, 60.946727 ], [ -151.641066, 60.942177 ], [ -151.679518, 60.922491 ], [ -151.692644, 60.917743 ], [ -151.713913, 60.916546 ], [ -151.720815, 60.904257 ], [ -151.736015, 60.891507 ], [ -151.783271, 60.868713 ], [ -151.791698, 60.863060 ], [ -151.800264, 60.853672 ], [ -151.796723, 60.838734 ], [ -151.787394, 60.822307 ], [ -151.777310, 60.810461 ], [ -151.751817, 60.788729 ], [ -151.703802, 60.732376 ], [ -151.702833, 60.727778 ], [ -151.705553, 60.718052 ], [ -151.710444, 60.712657 ], [ -151.716379, 60.710415 ], [ -151.744321, 60.712403 ], [ -151.749493, 60.714175 ], [ -151.760301, 60.721441 ], [ -151.784039, 60.726814 ], [ -151.803814, 60.729004 ], [ -151.811286, 60.732222 ], [ -151.822596, 60.742352 ], [ -151.831185, 60.747303 ], [ -151.851967, 60.754074 ], [ -151.860179, 60.753282 ], [ -151.864958, 60.750458 ], [ -151.849634, 60.738286 ], [ -151.847965, 60.735694 ], [ -151.848614, 60.733976 ], [ -151.870471, 60.727284 ], [ -151.916914, 60.717916 ], [ -151.917922, 60.722809 ], [ -151.915911, 60.730245 ], [ -151.918758, 60.732270 ], [ -151.923384, 60.733735 ], [ -151.944439, 60.733050 ], [ -151.944599, 60.728176 ], [ -151.948287, 60.722476 ], [ -151.961757, 60.721431 ], [ -151.968381, 60.728340 ], [ -152.079433, 60.692804 ], [ -152.114140, 60.634069 ], [ -152.136160, 60.578475 ], [ -152.148434, 60.575977 ], [ -152.163517, 60.576934 ], [ -152.195084, 60.569675 ], [ -152.261497, 60.538237 ], [ -152.309221, 60.506384 ], [ -152.315149, 60.499824 ], [ -152.331365, 60.473525 ], [ -152.333375, 60.460641 ], [ -152.330263, 60.443134 ], [ -152.325821, 60.434806 ], [ -152.312226, 60.420397 ], [ -152.301950, 60.414328 ], [ -152.234199, 60.393888 ], [ -152.300622, 60.369604 ], [ -152.307615, 60.366489 ], [ -152.315855, 60.359071 ], [ -152.352294, 60.356101 ], [ -152.366213, 60.353304 ], [ -152.371475, 60.350176 ], [ -152.376743, 60.345613 ], [ -152.386334, 60.327889 ], [ -152.385979, 60.315845 ], [ -152.392009, 60.302108 ], [ -152.411281, 60.287864 ], [ -152.421130, 60.285331 ], [ -152.444165, 60.285717 ], [ -152.456291, 60.284042 ], [ -152.481794, 60.274681 ], [ -152.528206, 60.251346 ], [ -152.539843, 60.241644 ], [ -152.549236, 60.227631 ], [ -152.556752, 60.224217 ], [ -152.624648, 60.218687 ], [ -152.626275, 60.220852 ], [ -152.626901, 60.222728 ], [ -152.627683, 60.225700 ], [ -152.642361, 60.228766 ], [ -152.660055, 60.242004 ], [ -152.670403, 60.244320 ], [ -152.698634, 60.240661 ], [ -152.715881, 60.241274 ], [ -152.747026, 60.233311 ], [ -152.743388, 60.224323 ], [ -152.754884, 60.210910 ], [ -152.754884, 60.202901 ], [ -152.749545, 60.189552 ], [ -152.734251, 60.174801 ], [ -152.699879, 60.165272 ], [ -152.688392, 60.165820 ], [ -152.678085, 60.163504 ], [ -152.674176, 60.151731 ], [ -152.687485, 60.140305 ], [ -152.686373, 60.137717 ], [ -152.658418, 60.121591 ], [ -152.634972, 60.115799 ], [ -152.596784, 60.101071 ], [ -152.575271, 60.082363 ], [ -152.569121, 60.071748 ], [ -152.575153, 60.048260 ], [ -152.590169, 60.035978 ], [ -152.608599, 60.025429 ], [ -152.612721, 60.015115 ], [ -152.611651, 60.008521 ], [ -152.649479, 59.988253 ], [ -152.679402, 59.968054 ], [ -152.693674, 59.932773 ], [ -152.700822, 59.920309 ], [ -152.706431, 59.915284 ], [ -152.745083, 59.904232 ], [ -152.793584, 59.896720 ], [ -152.806934, 59.888029 ], [ -152.810058, 59.878322 ], [ -152.860867, 59.875033 ], [ -152.875167, 59.877471 ], [ -152.882672, 59.881986 ], [ -152.900414, 59.881812 ], [ -152.920417, 59.877741 ], [ -152.950662, 59.876759 ], [ -152.967267, 59.881494 ], [ -153.002521, 59.886726 ], [ -153.019977, 59.886230 ], [ -153.046986, 59.882425 ], [ -153.079187, 59.871103 ], [ -153.144747, 59.859829 ], [ -153.212865, 59.862784 ], [ -153.225937, 59.858343 ], [ -153.228615, 59.853355 ], [ -153.256944, 59.836490 ], [ -153.278808, 59.828066 ], [ -153.285802, 59.820535 ], [ -153.285412, 59.816755 ], [ -153.278535, 59.810924 ], [ -153.257736, 59.810807 ], [ -153.236556, 59.821867 ], [ -153.217481, 59.824721 ], [ -153.197352, 59.824827 ], [ -153.182307, 59.822389 ], [ -153.144372, 59.807616 ], [ -153.113586, 59.815631 ], [ -153.088515, 59.833376 ], [ -153.021945, 59.834133 ], [ -153.009084, 59.830643 ], [ -153.003964, 59.826747 ], [ -152.992126, 59.810027 ], [ -152.994466, 59.791261 ], [ -153.031319, 59.723625 ], [ -153.051559, 59.691562 ], [ -153.108940, 59.678316 ], [ -153.121740, 59.678009 ], [ -153.155019, 59.654344 ], [ -153.214156, 59.634271 ], [ -153.240018, 59.632426 ], [ -153.253408, 59.638415 ], [ -153.262740, 59.643426 ], [ -153.275175, 59.667303 ], [ -153.286525, 59.670251 ], [ -153.301687, 59.668717 ], [ -153.314002, 59.666336 ], [ -153.315123, 59.664896 ], [ -153.315083, 59.662490 ], [ -153.307199, 59.653954 ], [ -153.298205, 59.636345 ], [ -153.298047, 59.632502 ], [ -153.302756, 59.627679 ], [ -153.308837, 59.625706 ], [ -153.342938, 59.621312 ], [ -153.366613, 59.633729 ], [ -153.381595, 59.638032 ], [ -153.392022, 59.638856 ], [ -153.409422, 59.636328 ], [ -153.414898, 59.638600 ], [ -153.418099, 59.642147 ], [ -153.415507, 59.650918 ], [ -153.393849, 59.658847 ], [ -153.384886, 59.667188 ], [ -153.378235, 59.688936 ], [ -153.374778, 59.731587 ], [ -153.439977, 59.784652 ], [ -153.454972, 59.792099 ], [ -153.458549, 59.764467 ], [ -153.449620, 59.743810 ], [ -153.445336, 59.728865 ], [ -153.442219, 59.717420 ], [ -153.441214, 59.701316 ], [ -153.444003, 59.689957 ], [ -153.464556, 59.651712 ], [ -153.476098, 59.642730 ], [ -153.542466, 59.630236 ], [ -153.563866, 59.638903 ], [ -153.586518, 59.651541 ], [ -153.604813, 59.638734 ], [ -153.610739, 59.628341 ], [ -153.609253, 59.621640 ], [ -153.592193, 59.610842 ], [ -153.558292, 59.605790 ], [ -153.553163, 59.597046 ], [ -153.555148, 59.587858 ], [ -153.577828, 59.555991 ], [ -153.585406, 59.551475 ], [ -153.618151, 59.552571 ], [ -153.635262, 59.555694 ], [ -153.650943, 59.555427 ], [ -153.719309, 59.550264 ], [ -153.761480, 59.543411 ], [ -153.766242, 59.522342 ], [ -153.733853, 59.505754 ], [ -153.706419, 59.477994 ], [ -153.699025, 59.463603 ], [ -153.727546, 59.435346 ], [ -153.747201, 59.429657 ], [ -153.807119, 59.419466 ], [ -153.823384, 59.418035 ], [ -153.862199, 59.424124 ], [ -153.896576, 59.418486 ], [ -153.911268, 59.413732 ], [ -153.925307, 59.405254 ], [ -153.945539, 59.386061 ], [ -153.951389, 59.387017 ], [ -153.954717, 59.392532 ], [ -153.959893, 59.396850 ], [ -153.990003, 59.396777 ], [ -153.993994, 59.394049 ], [ -153.996261, 59.390820 ], [ -153.998506, 59.384723 ], [ -154.007207, 59.382528 ], [ -154.025696, 59.381521 ], [ -154.035965, 59.386362 ], [ -154.044563, 59.388295 ], [ -154.052150, 59.387138 ], [ -154.062453, 59.382753 ], [ -154.087803, 59.367967 ], [ -154.100989, 59.366016 ], [ -154.117672, 59.365508 ], [ -154.121808, 59.360544 ], [ -154.121394, 59.353099 ], [ -154.103014, 59.342719 ], [ -154.033703, 59.343999 ], [ -154.028739, 59.337381 ], [ -154.030807, 59.327040 ], [ -154.077942, 59.313364 ], [ -154.113577, 59.299627 ], [ -154.122681, 59.287622 ], [ -154.136840, 59.262666 ], [ -154.141192, 59.216598 ], [ -154.130585, 59.210503 ], [ -154.172944, 59.172496 ], [ -154.214818, 59.151562 ], [ -154.244220, 59.144161 ], [ -154.260121, 59.143020 ], [ -154.263291, 59.138462 ], [ -154.256528, 59.118462 ], [ -154.251233, 59.111239 ], [ -154.243785, 59.114868 ], [ -154.239842, 59.119324 ], [ -154.227238, 59.125407 ], [ -154.180691, 59.123235 ], [ -154.173669, 59.120200 ], [ -154.166745, 59.100548 ], [ -154.166406, 59.090582 ], [ -154.171502, 59.083423 ], [ -154.195271, 59.069491 ], [ -154.197422, 59.061155 ], [ -154.189580, 59.044207 ], [ -154.171462, 59.021963 ], [ -154.159835, 59.010595 ], [ -154.158207, 59.017853 ], [ -154.132449, 59.024745 ], [ -154.108278, 59.036827 ], [ -154.063489, 59.072140 ], [ -154.031822, 59.073681 ], [ -154.008547, 59.072904 ], [ -153.949958, 59.066782 ], [ -153.932824, 59.062677 ], [ -153.850238, 59.052917 ], [ -153.838180, 59.055296 ], [ -153.815724, 59.064851 ], [ -153.809866, 59.070797 ], [ -153.802782, 59.072224 ], [ -153.793972, 59.071416 ], [ -153.750936, 59.052840 ], [ -153.748680, 59.058729 ], [ -153.746201, 59.065199 ], [ -153.704162, 59.075780 ], [ -153.695664, 59.073994 ], [ -153.648029, 59.028924 ], [ -153.616066, 59.006737 ], [ -153.547283, 58.983716 ], [ -153.523522, 58.979221 ], [ -153.505618, 58.981734 ], [ -153.479939, 58.995286 ], [ -153.463266, 58.986903 ], [ -153.450672, 58.976119 ], [ -153.438144, 58.969911 ], [ -153.422015, 58.970648 ], [ -153.398479, 58.966056 ], [ -153.393101, 58.951097 ], [ -153.388765, 58.945337 ], [ -153.365371, 58.927753 ], [ -153.352283, 58.921705 ], [ -153.334780, 58.920521 ], [ -153.322843, 58.907849 ], [ -153.304788, 58.878919 ], [ -153.305216, 58.874637 ], [ -153.302433, 58.871212 ], [ -153.294726, 58.865432 ], [ -153.286163, 58.863077 ], [ -153.267407, 58.867218 ], [ -153.254798, 58.861756 ], [ -153.252250, 58.855850 ], [ -153.252662, 58.855797 ], [ -153.317823, 58.847441 ], [ -153.326138, 58.849320 ], [ -153.336826, 58.848878 ], [ -153.344830, 58.846953 ], [ -153.350964, 58.843551 ], [ -153.358917, 58.836767 ], [ -153.369389, 58.821255 ], [ -153.370730, 58.799301 ], [ -153.385126, 58.766173 ], [ -153.402472, 58.742607 ], [ -153.426641, 58.721127 ], [ -153.445002, 58.709310 ], [ -153.458816, 58.708561 ], [ -153.468963, 58.712234 ], [ -153.477755, 58.712767 ], [ -153.552650, 58.687176 ], [ -153.577544, 58.670532 ], [ -153.587799, 58.651742 ], [ -153.591635, 58.640084 ], [ -153.601257, 58.634633 ], [ -153.677597, 58.611603 ], [ -153.771636, 58.605639 ], [ -153.806232, 58.606595 ], [ -153.832837, 58.611671 ], [ -153.851432, 58.611872 ], [ -153.897155, 58.606237 ], [ -153.902558, 58.597377 ], [ -153.919134, 58.516659 ], [ -153.909588, 58.514562 ], [ -153.930473, 58.497482 ], [ -153.934852, 58.494414 ], [ -153.960370, 58.487831 ], [ -153.974020, 58.488348 ], [ -153.977617, 58.491931 ], [ -154.001918, 58.492346 ], [ -154.056526, 58.489222 ], [ -154.065121, 58.486430 ], [ -154.073032, 58.478259 ], [ -154.075051, 58.472188 ], [ -154.075235, 58.458106 ], [ -154.073592, 58.446866 ], [ -154.070660, 58.440018 ], [ -154.055759, 58.418782 ], [ -154.040013, 58.404297 ], [ -154.034147, 58.402638 ], [ -154.023713, 58.403952 ], [ -154.007305, 58.402187 ], [ -153.985416, 58.390877 ], [ -153.999323, 58.376372 ], [ -154.097254, 58.345322 ], [ -154.133866, 58.350632 ], [ -154.139223, 58.354108 ], [ -154.150373, 58.357581 ], [ -154.167997, 58.358378 ], [ -154.175194, 58.344527 ], [ -154.177161, 58.321470 ], [ -154.174999, 58.320107 ], [ -154.166648, 58.320569 ], [ -154.149073, 58.314539 ], [ -154.103412, 58.280161 ], [ -154.145277, 58.210931 ], [ -154.177652, 58.189832 ], [ -154.219755, 58.184631 ], [ -154.241874, 58.156328 ], [ -154.216250, 58.142849 ], [ -154.210078, 58.136062 ], [ -154.222465, 58.132566 ], [ -154.269027, 58.128770 ], [ -154.291163, 58.135680 ], [ -154.340449, 58.090921 ], [ -154.384327, 58.120823 ], [ -154.426570, 58.144901 ], [ -154.436518, 58.148294 ], [ -154.460121, 58.146067 ], [ -154.466436, 58.142328 ], [ -154.459389, 58.129089 ], [ -154.452096, 58.121582 ], [ -154.449212, 58.093218 ], [ -154.462929, 58.058350 ], [ -154.477979, 58.052379 ], [ -154.501246, 58.050112 ], [ -154.539367, 58.055887 ], [ -154.568627, 58.025787 ], [ -154.581547, 58.019285 ], [ -154.643965, 58.033147 ], [ -154.650618, 58.045387 ], [ -154.644666, 58.056433 ], [ -154.646223, 58.060141 ], [ -154.653383, 58.064037 ], [ -154.668895, 58.065272 ], [ -154.676108, 58.065114 ], [ -154.716162, 58.055256 ], [ -154.721884, 58.050544 ], [ -154.728980, 58.038455 ], [ -154.731059, 58.028454 ], [ -154.730726, 58.021837 ], [ -154.745581, 58.012220 ], [ -154.765287, 58.003710 ], [ -154.774719, 58.002168 ], [ -154.807767, 58.000939 ], [ -154.819518, 58.003494 ], [ -154.823518, 58.009348 ], [ -154.825051, 58.016586 ], [ -154.828230, 58.018849 ], [ -154.876559, 58.027722 ], [ -154.891812, 58.027676 ], [ -154.990431, 58.013424 ], [ -155.026275, 57.999302 ], [ -155.118648, 57.953925 ], [ -155.094686, 57.929280 ], [ -155.072566, 57.911968 ], [ -155.064199, 57.909294 ], [ -155.061806, 57.904330 ], [ -155.068148, 57.883773 ], [ -155.082139, 57.872248 ], [ -155.097095, 57.865356 ], [ -155.152420, 57.855375 ], [ -155.237933, 57.827131 ], [ -155.272917, 57.823981 ], [ -155.298385, 57.826020 ], [ -155.303044, 57.828454 ], [ -155.326369, 57.830545 ], [ -155.338153, 57.825384 ], [ -155.341235, 57.819644 ], [ -155.334944, 57.780692 ], [ -155.310981, 57.764811 ], [ -155.302789, 57.761658 ], [ -155.285339, 57.758726 ], [ -155.284691, 57.757388 ], [ -155.291651, 57.735809 ], [ -155.305814, 57.724050 ], [ -155.378610, 57.710766 ], [ -155.468287, 57.744637 ], [ -155.506533, 57.760970 ], [ -155.533627, 57.776880 ], [ -155.539766, 57.783942 ], [ -155.545676, 57.786769 ], [ -155.568437, 57.789511 ], [ -155.585411, 57.786981 ], [ -155.596857, 57.783539 ], [ -155.609353, 57.777699 ], [ -155.617188, 57.769715 ], [ -155.635323, 57.715441 ], [ -155.634543, 57.704764 ], [ -155.626373, 57.693623 ], [ -155.615203, 57.688074 ], [ -155.629912, 57.656376 ], [ -155.699986, 57.642085 ], [ -155.724167, 57.633445 ], [ -155.735509, 57.594149 ], [ -155.730951, 57.588562 ], [ -155.731412, 57.555546 ], [ -155.732779, 57.549732 ], [ -155.786939, 57.547007 ], [ -155.877856, 57.547173 ], [ -155.915261, 57.535331 ], [ -155.945812, 57.539249 ], [ -155.967890, 57.544429 ], [ -155.985988, 57.553721 ], [ -155.988113, 57.558328 ], [ -156.010818, 57.571379 ], [ -156.033806, 57.569883 ], [ -156.044031, 57.564455 ], [ -156.048584, 57.500808 ], [ -156.045324, 57.487037 ], [ -156.036722, 57.470941 ], [ -156.014396, 57.455285 ], [ -156.012841, 57.451394 ], [ -156.021875, 57.439660 ], [ -156.091668, 57.439829 ], [ -156.099067, 57.443691 ], [ -156.137480, 57.471734 ], [ -156.183932, 57.482112 ], [ -156.195740, 57.480059 ], [ -156.210883, 57.474409 ], [ -156.211485, 57.459475 ], [ -156.220105, 57.445295 ], [ -156.226886, 57.440667 ], [ -156.254462, 57.438961 ], [ -156.339425, 57.417641 ], [ -156.362039, 57.400474 ], [ -156.377439, 57.390865 ], [ -156.481632, 57.338705 ], [ -156.511412, 57.335020 ], [ -156.533544, 57.328527 ], [ -156.539718, 57.320059 ], [ -156.551239, 57.290800 ], [ -156.538684, 57.283041 ], [ -156.507301, 57.281164 ], [ -156.420864, 57.311142 ], [ -156.336427, 57.336081 ], [ -156.321910, 57.293369 ], [ -156.332718, 57.265192 ], [ -156.342943, 57.248056 ], [ -156.358139, 57.252188 ], [ -156.376507, 57.252284 ], [ -156.399423, 57.241627 ], [ -156.401488, 57.233169 ], [ -156.398751, 57.214756 ], [ -156.388592, 57.206620 ], [ -156.355756, 57.192844 ], [ -156.341300, 57.191857 ], [ -156.338430, 57.190325 ], [ -156.334404, 57.182300 ], [ -156.355401, 57.159679 ], [ -156.357358, 57.157570 ], [ -156.368524, 57.149986 ], [ -156.435110, 57.127430 ], [ -156.456497, 57.106041 ], [ -156.444610, 57.100087 ], [ -156.441566, 57.094698 ], [ -156.441599, 57.085158 ], [ -156.509239, 57.054911 ], [ -156.535587, 57.047905 ], [ -156.562827, 57.020314 ], [ -156.547667, 57.004629 ], [ -156.547200, 56.986488 ], [ -156.550520, 56.984610 ], [ -156.555077, 56.983550 ], [ -156.637840, 56.993905 ], [ -156.753642, 56.991225 ], [ -156.762718, 56.986342 ], [ -156.781421, 56.971879 ], [ -156.786900, 56.965035 ], [ -156.788341, 56.960693 ], [ -156.786802, 56.941443 ], [ -156.797310, 56.911717 ], [ -156.804432, 56.905881 ], [ -156.825982, 56.897667 ], [ -156.839322, 56.901854 ], [ -156.876316, 56.942828 ], [ -156.885372, 56.953284 ], [ -156.885686, 56.957965 ], [ -156.882464, 56.960072 ], [ -156.882893, 56.962582 ], [ -156.886307, 56.964869 ], [ -156.893683, 56.965965 ], [ -156.909725, 56.965581 ], [ -156.918796, 56.963583 ], [ -156.935692, 56.954873 ], [ -156.935629, 56.920087 ], [ -156.986171, 56.911131 ], [ -157.005950, 56.904220 ], [ -157.015665, 56.898486 ], [ -157.034624, 56.884487 ], [ -157.073453, 56.838345 ], [ -157.159494, 56.833477 ], [ -157.163811, 56.826066 ], [ -157.163272, 56.823542 ], [ -157.140990, 56.802275 ], [ -157.140277, 56.790874 ], [ -157.161372, 56.774134 ], [ -157.183636, 56.769079 ], [ -157.201724, 56.767511 ], [ -157.283764, 56.800766 ], [ -157.290511, 56.804713 ], [ -157.291231, 56.811077 ], [ -157.298283, 56.818567 ], [ -157.332735, 56.838398 ], [ -157.378771, 56.861696 ], [ -157.394663, 56.864426 ], [ -157.405679, 56.864216 ], [ -157.436932, 56.858522 ], [ -157.457590, 56.848204 ], [ -157.472407, 56.833356 ], [ -157.469925, 56.824889 ], [ -157.462361, 56.809603 ], [ -157.457622, 56.804291 ], [ -157.447768, 56.801246 ], [ -157.436358, 56.803781 ], [ -157.421120, 56.801691 ], [ -157.418560, 56.799821 ], [ -157.411488, 56.778351 ], [ -157.413440, 56.769185 ], [ -157.517478, 56.760839 ], [ -157.530765, 56.753775 ], [ -157.544855, 56.738945 ], [ -157.551196, 56.730314 ], [ -157.563802, 56.703426 ], [ -157.550792, 56.681029 ], [ -157.542295, 56.675320 ], [ -157.507589, 56.667169 ], [ -157.498689, 56.667285 ], [ -157.480990, 56.671419 ], [ -157.479153, 56.670080 ], [ -157.452160, 56.643220 ], [ -157.452196, 56.638863 ], [ -157.454860, 56.634748 ], [ -157.462105, 56.625685 ], [ -157.466497, 56.623266 ], [ -157.496523, 56.616897 ], [ -157.536486, 56.615317 ], [ -157.546085, 56.619025 ], [ -157.589315, 56.622262 ], [ -157.605231, 56.621315 ], [ -157.615041, 56.620020 ], [ -157.636018, 56.612838 ], [ -157.674587, 56.609507 ], [ -157.705382, 56.628780 ], [ -157.714280, 56.640575 ], [ -157.715998, 56.648492 ], [ -157.719048, 56.653084 ], [ -157.736799, 56.675616 ], [ -157.754141, 56.679468 ], [ -157.763698, 56.679247 ], [ -157.920045, 56.658636 ], [ -157.933988, 56.654571 ], [ -158.042012, 56.596744 ], [ -158.042839, 56.581850 ], [ -158.039356, 56.574884 ], [ -158.001041, 56.572097 ], [ -157.975222, 56.585722 ], [ -157.958745, 56.588304 ], [ -157.906647, 56.590925 ], [ -157.838420, 56.560760 ], [ -157.828139, 56.546332 ], [ -157.817826, 56.514210 ], [ -157.823072, 56.501982 ], [ -157.859766, 56.483668 ], [ -157.865642, 56.483285 ], [ -157.886126, 56.487805 ], [ -157.954625, 56.515845 ], [ -158.027621, 56.511779 ], [ -158.112276, 56.521322 ], [ -158.119570, 56.518346 ], [ -158.131729, 56.501944 ], [ -158.123352, 56.496457 ], [ -158.113709, 56.493001 ], [ -158.111603, 56.490110 ], [ -158.118682, 56.466558 ], [ -158.127440, 56.460805 ], [ -158.246144, 56.466124 ], [ -158.284699, 56.481089 ], [ -158.328798, 56.484208 ], [ -158.402954, 56.455193 ], [ -158.498837, 56.380110 ], [ -158.501705, 56.375860 ], [ -158.502040, 56.365178 ], [ -158.489546, 56.341865 ], [ -158.432795, 56.343505 ], [ -158.397337, 56.328921 ], [ -158.338137, 56.323923 ], [ -158.329735, 56.326028 ], [ -158.322563, 56.325242 ], [ -158.207387, 56.294354 ], [ -158.203083, 56.283833 ], [ -158.216540, 56.269451 ], [ -158.253331, 56.253125 ], [ -158.276842, 56.248698 ], [ -158.334506, 56.232940 ], [ -158.339765, 56.217807 ], [ -158.331039, 56.213609 ], [ -158.264792, 56.209597 ], [ -158.190960, 56.226407 ], [ -158.174930, 56.236227 ], [ -158.119493, 56.241995 ], [ -158.115282, 56.242102 ], [ -158.112718, 56.240286 ], [ -158.117797, 56.230742 ], [ -158.237025, 56.187387 ], [ -158.314128, 56.163697 ], [ -158.374324, 56.134522 ], [ -158.395996, 56.109834 ], [ -158.394388, 56.091949 ], [ -158.394922, 56.064721 ], [ -158.398324, 56.062957 ], [ -158.424451, 56.068899 ], [ -158.438644, 56.093672 ], [ -158.438315, 56.095702 ], [ -158.431105, 56.100264 ], [ -158.432229, 56.102881 ], [ -158.439944, 56.107780 ], [ -158.455297, 56.108742 ], [ -158.461810, 56.106644 ], [ -158.475258, 56.093405 ], [ -158.472706, 56.087583 ], [ -158.448413, 56.055278 ], [ -158.417889, 56.036796 ], [ -158.407723, 56.014521 ], [ -158.413645, 56.004951 ], [ -158.431471, 55.994452 ], [ -158.439330, 55.993620 ], [ -158.445696, 55.997580 ], [ -158.467335, 56.027219 ], [ -158.475543, 56.028366 ], [ -158.501967, 56.025170 ], [ -158.504850, 56.015544 ], [ -158.496366, 56.010601 ], [ -158.494015, 56.007320 ], [ -158.495114, 55.989207 ], [ -158.499050, 55.981685 ], [ -158.509840, 55.979617 ], [ -158.595620, 56.045252 ], [ -158.598367, 56.048822 ], [ -158.594188, 56.110445 ], [ -158.584362, 56.115657 ], [ -158.574659, 56.118640 ], [ -158.575042, 56.121129 ], [ -158.600405, 56.130444 ], [ -158.628303, 56.120943 ], [ -158.640447, 56.114079 ], [ -158.659738, 56.098553 ], [ -158.666818, 56.078415 ], [ -158.660914, 56.034928 ], [ -158.651674, 56.031358 ], [ -158.643216, 56.023415 ], [ -158.638704, 56.015932 ], [ -158.636689, 56.005007 ], [ -158.639497, 55.986070 ], [ -158.653214, 55.958615 ], [ -158.673246, 55.951485 ], [ -158.737009, 55.953313 ], [ -158.748560, 55.959365 ], [ -158.751215, 55.963759 ], [ -158.735348, 55.996208 ], [ -158.729567, 56.002854 ], [ -158.747305, 56.009908 ], [ -158.854132, 56.003343 ], [ -158.898116, 55.951041 ], [ -158.909396, 55.934887 ], [ -158.999598, 55.927011 ], [ -159.138748, 55.909320 ], [ -159.271514, 55.890704 ], [ -159.347681, 55.877802 ], [ -159.374842, 55.871522 ], [ -159.396400, 55.856767 ], [ -159.400096, 55.852357 ], [ -159.406126, 55.831956 ], [ -159.409380, 55.810434 ], [ -159.404326, 55.796992 ], [ -159.411505, 55.788911 ], [ -159.423468, 55.789025 ], [ -159.434787, 55.792909 ], [ -159.470216, 55.828911 ], [ -159.472801, 55.839050 ], [ -159.471973, 55.843506 ], [ -159.465282, 55.852845 ], [ -159.453945, 55.896820 ], [ -159.482226, 55.901826 ], [ -159.493883, 55.900109 ], [ -159.528349, 55.888458 ], [ -159.534415, 55.881299 ], [ -159.498022, 55.855299 ], [ -159.494404, 55.765798 ], [ -159.503768, 55.747878 ], [ -159.521589, 55.736021 ], [ -159.537152, 55.728459 ], [ -159.551432, 55.711543 ], [ -159.552016, 55.704794 ], [ -159.535961, 55.689831 ], [ -159.530117, 55.665394 ], [ -159.545115, 55.646517 ], [ -159.564413, 55.633045 ], [ -159.617770, 55.595798 ], [ -159.696713, 55.573306 ], [ -159.729333, 55.569650 ], [ -159.733899, 55.569985 ], [ -159.744495, 55.600018 ], [ -159.743282, 55.603624 ], [ -159.735196, 55.610933 ], [ -159.724150, 55.614549 ], [ -159.673432, 55.617350 ], [ -159.667511, 55.614825 ], [ -159.639619, 55.617915 ], [ -159.626772, 55.629412 ], [ -159.635866, 55.644398 ], [ -159.644656, 55.652469 ], [ -159.679201, 55.655895 ], [ -159.680635, 55.681340 ], [ -159.676761, 55.737357 ], [ -159.673191, 55.750961 ], [ -159.627482, 55.803248 ], [ -159.624884, 55.804694 ], [ -159.602148, 55.805004 ], [ -159.607973, 55.812900 ], [ -159.643739, 55.830424 ], [ -159.712816, 55.846392 ], [ -159.811070, 55.856570 ], [ -159.838981, 55.852412 ], [ -159.853255, 55.847162 ], [ -159.858456, 55.841793 ], [ -159.850750, 55.824076 ], [ -159.847359, 55.802530 ], [ -159.862484, 55.787629 ], [ -159.875994, 55.784608 ], [ -159.892319, 55.785096 ], [ -159.937089, 55.803306 ], [ -160.010322, 55.797087 ], [ -160.026282, 55.792295 ], [ -160.048711, 55.772061 ], [ -160.052525, 55.766430 ], [ -160.051945, 55.760594 ], [ -160.049417, 55.757588 ], [ -160.058443, 55.721734 ], [ -160.130445, 55.681419 ], [ -160.185712, 55.658644 ], [ -160.279827, 55.641384 ], [ -160.325419, 55.644207 ], [ -160.353494, 55.649731 ], [ -160.410823, 55.665380 ], [ -160.416452, 55.665302 ], [ -160.421853, 55.662701 ], [ -160.429727, 55.658046 ], [ -160.433602, 55.648975 ], [ -160.433022, 55.639979 ], [ -160.392587, 55.602771 ], [ -160.435859, 55.573692 ], [ -160.448277, 55.559049 ], [ -160.464301, 55.533243 ], [ -160.465186, 55.527361 ], [ -160.459815, 55.514986 ], [ -160.462745, 55.506654 ], [ -160.481633, 55.489068 ], [ -160.501346, 55.478518 ], [ -160.521335, 55.474420 ], [ -160.536654, 55.474938 ], [ -160.544224, 55.502351 ], [ -160.554173, 55.522965 ], [ -160.580083, 55.564385 ], [ -160.595771, 55.575540 ], [ -160.615305, 55.575516 ], [ -160.638371, 55.557426 ], [ -160.652775, 55.548668 ], [ -160.666966, 55.544417 ], [ -160.706883, 55.556066 ], [ -160.737095, 55.555448 ], [ -160.751040, 55.552907 ], [ -160.766237, 55.547559 ], [ -160.772950, 55.538998 ], [ -160.771433, 55.529430 ], [ -160.732150, 55.523596 ], [ -160.660117, 55.518475 ], [ -160.654117, 55.512596 ], [ -160.647464, 55.500862 ], [ -160.646304, 55.492851 ], [ -160.651523, 55.474174 ], [ -160.666917, 55.459776 ], [ -160.781401, 55.451780 ], [ -160.795988, 55.454946 ], [ -160.836725, 55.473135 ], [ -160.843407, 55.489782 ], [ -160.836023, 55.497259 ], [ -160.821773, 55.506216 ], [ -160.820810, 55.507974 ], [ -160.828273, 55.516111 ], [ -160.849145, 55.523916 ], [ -160.865380, 55.526968 ], [ -160.909625, 55.524140 ], [ -160.922934, 55.519300 ], [ -160.944265, 55.507825 ], [ -160.976551, 55.472736 ], [ -160.979298, 55.466274 ], [ -160.977376, 55.461185 ], [ -160.982717, 55.454326 ], [ -160.997335, 55.440265 ], [ -161.013662, 55.431002 ], [ -161.231535, 55.357452 ], [ -161.280675, 55.354038 ], [ -161.325325, 55.359855 ], [ -161.317545, 55.362758 ], [ -161.311989, 55.372836 ], [ -161.314949, 55.379231 ], [ -161.346080, 55.385782 ], [ -161.364577, 55.384194 ], [ -161.445196, 55.368103 ], [ -161.460392, 55.359070 ], [ -161.486114, 55.359322 ], [ -161.507657, 55.362786 ], [ -161.514211, 55.385254 ], [ -161.509306, 55.390626 ], [ -161.496123, 55.396967 ], [ -161.484588, 55.417994 ], [ -161.478303, 55.440600 ], [ -161.471468, 55.478588 ], [ -161.477114, 55.485195 ], [ -161.469271, 55.496830 ], [ -161.376102, 55.569794 ], [ -161.367405, 55.579484 ], [ -161.355686, 55.606378 ], [ -161.357670, 55.612603 ], [ -161.363378, 55.618478 ], [ -161.392613, 55.628221 ], [ -161.416235, 55.632324 ], [ -161.482064, 55.633979 ], [ -161.526162, 55.630498 ], [ -161.587047, 55.620060 ], [ -161.602825, 55.613811 ], [ -161.612926, 55.606158 ], [ -161.698860, 55.519400 ], [ -161.700069, 55.514390 ], [ -161.696719, 55.423307 ], [ -161.688357, 55.416380 ], [ -161.686495, 55.408041 ], [ -161.720096, 55.376690 ], [ -161.827543, 55.287872 ], [ -161.833891, 55.284400 ], [ -161.845473, 55.281249 ], [ -161.853418, 55.277634 ], [ -161.863339, 55.266989 ], [ -161.875606, 55.249921 ], [ -161.879542, 55.240804 ], [ -161.875759, 55.232592 ], [ -161.875238, 55.227224 ], [ -161.878076, 55.223599 ], [ -161.903407, 55.204941 ], [ -161.919519, 55.208209 ], [ -161.957455, 55.227999 ], [ -161.978788, 55.236131 ], [ -162.029636, 55.239492 ], [ -162.041236, 55.236806 ], [ -162.045694, 55.232775 ], [ -162.046242, 55.225605 ], [ -162.001711, 55.169236 ], [ -161.966974, 55.154831 ], [ -161.949882, 55.126686 ], [ -161.956595, 55.112174 ], [ -161.960866, 55.106734 ], [ -162.053281, 55.074212 ], [ -162.118740, 55.102911 ], [ -162.131878, 55.122776 ], [ -162.119033, 55.141116 ], [ -162.126369, 55.153408 ], [ -162.141084, 55.157339 ], [ -162.177427, 55.154403 ], [ -162.218192, 55.118903 ], [ -162.224047, 55.108658 ], [ -162.223528, 55.102211 ], [ -162.206800, 55.082391 ], [ -162.190348, 55.066981 ], [ -162.189247, 55.060260 ], [ -162.219326, 55.028975 ], [ -162.247946, 55.020439 ], [ -162.253500, 55.020454 ], [ -162.267754, 55.021553 ], [ -162.280512, 55.026207 ], [ -162.292511, 55.033429 ], [ -162.299619, 55.040152 ], [ -162.300378, 55.042927 ], [ -162.361969, 55.042679 ], [ -162.413510, 55.036560 ], [ -162.471364, 55.051932 ], [ -162.489735, 55.064849 ], [ -162.512104, 55.086227 ], [ -162.521688, 55.104011 ], [ -162.520986, 55.115417 ], [ -162.506887, 55.118927 ], [ -162.460958, 55.125840 ], [ -162.453451, 55.123948 ], [ -162.442556, 55.118226 ], [ -162.437368, 55.112122 ], [ -162.424796, 55.104813 ], [ -162.416800, 55.104096 ], [ -162.410574, 55.105614 ], [ -162.406191, 55.120498 ], [ -162.445182, 55.151521 ], [ -162.480980, 55.161271 ], [ -162.494470, 55.183915 ], [ -162.497920, 55.199052 ], [ -162.499019, 55.213770 ], [ -162.510435, 55.250177 ], [ -162.513121, 55.252374 ], [ -162.584872, 55.298386 ], [ -162.626101, 55.304085 ], [ -162.649173, 55.299118 ], [ -162.661960, 55.294295 ], [ -162.682405, 55.276450 ], [ -162.702851, 55.252775 ], [ -162.714607, 55.231611 ], [ -162.718077, 55.219911 ], [ -162.711128, 55.211267 ], [ -162.692309, 55.197313 ], [ -162.668346, 55.193445 ], [ -162.644734, 55.197115 ], [ -162.638791, 55.194770 ], [ -162.614497, 55.174735 ], [ -162.579765, 55.136939 ], [ -162.582908, 55.130240 ], [ -162.585533, 55.128600 ], [ -162.595603, 55.124846 ], [ -162.604454, 55.126028 ], [ -162.618918, 55.097096 ], [ -162.599812, 55.054806 ], [ -162.569292, 55.015874 ], [ -162.569289, 54.971240 ], [ -162.587967, 54.972010 ], [ -162.615159, 54.987841 ], [ -162.646472, 54.997163 ], [ -162.688131, 54.996126 ], [ -162.707083, 54.991159 ], [ -162.716177, 54.986679 ], [ -162.720404, 54.980223 ], [ -162.707203, 54.972023 ], [ -162.705096, 54.966010 ], [ -162.708453, 54.958480 ], [ -162.770983, 54.932736 ], [ -162.834245, 54.926851 ], [ -162.845475, 54.926989 ], [ -162.881639, 54.934785 ], [ -162.913684, 54.950273 ], [ -162.970632, 55.001039 ], [ -162.965872, 55.017374 ], [ -162.958975, 55.020151 ], [ -162.957826, 55.031826 ], [ -162.964897, 55.042201 ], [ -163.001550, 55.080043 ], [ -163.051631, 55.103267 ], [ -163.071468, 55.110477 ], [ -163.079006, 55.111652 ], [ -163.111507, 55.109705 ], [ -163.165036, 55.099214 ], [ -163.188428, 55.090903 ], [ -163.213009, 55.066742 ], [ -163.225092, 55.049683 ], [ -163.226313, 55.042694 ], [ -163.219018, 55.030281 ], [ -163.213281, 55.026138 ], [ -163.189447, 55.016678 ], [ -163.174830, 55.013100 ], [ -163.148615, 55.014023 ], [ -163.067008, 54.979302 ], [ -163.050467, 54.969071 ], [ -163.036062, 54.942544 ], [ -163.065602, 54.926172 ], [ -163.149580, 54.885906 ], [ -163.214398, 54.847487 ], [ -163.299809, 54.829232 ], [ -163.352997, 54.810174 ], [ -163.373207, 54.800841 ], [ -163.372806, 54.790936 ], [ -163.342655, 54.765104 ], [ -163.322849, 54.750280 ], [ -163.228391, 54.753513 ], [ -163.219765, 54.755072 ], [ -163.188853, 54.773717 ], [ -163.184295, 54.774912 ], [ -163.144089, 54.761499 ], [ -163.107558, 54.732752 ], [ -163.057228, 54.688101 ], [ -163.050970, 54.672263 ], [ -163.059085, 54.661072 ], [ -163.096744, 54.661597 ], [ -163.125738, 54.668180 ], [ -163.140925, 54.694829 ], [ -163.185401, 54.700398 ], [ -163.194952, 54.699025 ], [ -163.208775, 54.693136 ], [ -163.280633, 54.695367 ], [ -163.317996, 54.719938 ], [ -163.327457, 54.743414 ], [ -163.331516, 54.747518 ], [ -163.344791, 54.751211 ], [ -163.364626, 54.749464 ], [ -163.380618, 54.746176 ], [ -163.391970, 54.741980 ], [ -163.423067, 54.720426 ], [ -163.428377, 54.714819 ], [ -163.425477, 54.710081 ], [ -163.439361, 54.655928 ], [ -163.472016, 54.656468 ], [ -163.488861, 54.655110 ], [ -163.572383, 54.623211 ], [ -163.581481, 54.616863 ], [ -163.585967, 54.611644 ], [ -163.670838, 54.627825 ], [ -163.747316, 54.635011 ], [ -163.803590, 54.636498 ], [ -163.861206, 54.632911 ], [ -163.952391, 54.630461 ], [ -163.966307, 54.631681 ], [ -164.084894, 54.620131 ], [ -164.179617, 54.599188 ], [ -164.232470, 54.585494 ], [ -164.257585, 54.572722 ], [ -164.331404, 54.530431 ], [ -164.337538, 54.524259 ], [ -164.341474, 54.495266 ], [ -164.336042, 54.484509 ], [ -164.336530, 54.480977 ], [ -164.352704, 54.465023 ], [ -164.416820, 54.431713 ], [ -164.456554, 54.419856 ], [ -164.499034, 54.414225 ], [ -164.519970, 54.414652 ], [ -164.582778, 54.405702 ], [ -164.601607, 54.402451 ], [ -164.640457, 54.391166 ], [ -164.743977, 54.394216 ], [ -164.789357, 54.402012 ], [ -164.844931, 54.417583 ], [ -164.876075, 54.443495 ], [ -164.877373, 54.449908 ], [ -164.904077, 54.499195 ], [ -164.910059, 54.507542 ], [ -164.936122, 54.521253 ], [ -164.944636, 54.532903 ], [ -164.949781, 54.575697 ], [ -164.948789, 54.579877 ], [ -164.932187, 54.598745 ], [ -164.918760, 54.605306 ], [ -164.831936, 54.629028 ], [ -164.761347, 54.640634 ], [ -164.741815, 54.645441 ], [ -164.727654, 54.650957 ], [ -164.709465, 54.661518 ], [ -164.629661, 54.756031 ], [ -164.576896, 54.824564 ], [ -164.561546, 54.850835 ], [ -164.564050, 54.875539 ], [ -164.550256, 54.888785 ], [ -164.486780, 54.922441 ], [ -164.435280, 54.933126 ], [ -164.427303, 54.932849 ], [ -164.373441, 54.915349 ], [ -164.361631, 54.907391 ], [ -164.353330, 54.898327 ], [ -164.343534, 54.894139 ], [ -164.295033, 54.902122 ], [ -164.207070, 54.927578 ], [ -164.204897, 54.931240 ], [ -164.164342, 54.953532 ], [ -164.119196, 54.969416 ], [ -164.109333, 54.963999 ], [ -164.086798, 54.963396 ], [ -164.061164, 54.964708 ], [ -164.030708, 54.969818 ], [ -163.994179, 54.983315 ], [ -163.964730, 54.997337 ], [ -163.930369, 55.017646 ], [ -163.909222, 55.032089 ], [ -163.894695, 55.039115 ], [ -163.884869, 55.039909 ], [ -163.872144, 55.037399 ], [ -163.854260, 55.037796 ], [ -163.815779, 55.044625 ], [ -163.790733, 55.052583 ], [ -163.774093, 55.055780 ], [ -163.740737, 55.048266 ], [ -163.646834, 55.044467 ], [ -163.568159, 55.049145 ], [ -163.532962, 55.048881 ], [ -163.527109, 55.040871 ], [ -163.534638, 55.025305 ], [ -163.530087, 55.016660 ], [ -163.461500, 54.982511 ], [ -163.442854, 54.969875 ], [ -163.429548, 54.954759 ], [ -163.418042, 54.938499 ], [ -163.398294, 54.902371 ], [ -163.399292, 54.894012 ], [ -163.408027, 54.884580 ], [ -163.415872, 54.859652 ], [ -163.414691, 54.856090 ], [ -163.410594, 54.854576 ], [ -163.391397, 54.855331 ], [ -163.334234, 54.872948 ], [ -163.318885, 54.880120 ], [ -163.319161, 54.899026 ], [ -163.319956, 54.903085 ], [ -163.336739, 54.917490 ], [ -163.344402, 54.919333 ], [ -163.347730, 54.925093 ], [ -163.343735, 54.950416 ], [ -163.338395, 54.956191 ], [ -163.323106, 54.959929 ], [ -163.314592, 54.958862 ], [ -163.290908, 54.945977 ], [ -163.279586, 54.944849 ], [ -163.239900, 54.954617 ], [ -163.237414, 54.959292 ], [ -163.240008, 54.962885 ], [ -163.293205, 55.006865 ], [ -163.297876, 55.057619 ], [ -163.310694, 55.105612 ], [ -163.314069, 55.105146 ], [ -163.318731, 55.110811 ], [ -163.319873, 55.119622 ], [ -163.314652, 55.126312 ], [ -163.268767, 55.145465 ], [ -163.200867, 55.166057 ], [ -163.157532, 55.175510 ], [ -163.105011, 55.183979 ], [ -163.081634, 55.180409 ], [ -163.080719, 55.176861 ], [ -163.070494, 55.174114 ], [ -163.032256, 55.172147 ], [ -162.957182, 55.171271 ], [ -162.882292, 55.183251 ], [ -162.861520, 55.198339 ], [ -162.840140, 55.224043 ], [ -162.843172, 55.242564 ], [ -162.851839, 55.247317 ], [ -162.856600, 55.248721 ], [ -162.869478, 55.248086 ], [ -162.880892, 55.239564 ], [ -162.894020, 55.243046 ], [ -162.900454, 55.246416 ], [ -162.901644, 55.247652 ], [ -162.900027, 55.252466 ], [ -162.888118, 55.270424 ], [ -162.881779, 55.273776 ], [ -162.750371, 55.307623 ], [ -162.731816, 55.307829 ], [ -162.704747, 55.320296 ], [ -162.680487, 55.337004 ], [ -162.649910, 55.364151 ], [ -162.619883, 55.408670 ], [ -162.580524, 55.446514 ], [ -162.575826, 55.446833 ], [ -162.533216, 55.467625 ], [ -162.504041, 55.482556 ], [ -162.483687, 55.495237 ], [ -162.403581, 55.557465 ], [ -162.326436, 55.613918 ], [ -162.286002, 55.649288 ], [ -162.246972, 55.680013 ], [ -162.193078, 55.702178 ], [ -162.147059, 55.718415 ], [ -162.090664, 55.753427 ], [ -162.079678, 55.763400 ], [ -161.972624, 55.800526 ], [ -161.898956, 55.833464 ], [ -161.858430, 55.865402 ], [ -161.816225, 55.888993 ], [ -161.807833, 55.891954 ], [ -161.773409, 55.897310 ], [ -161.712283, 55.904232 ], [ -161.640007, 55.919503 ], [ -161.585604, 55.937324 ], [ -161.450442, 55.954485 ], [ -161.380557, 55.965618 ], [ -161.290777, 55.983130 ], [ -161.280307, 55.979323 ], [ -161.278330, 55.974912 ], [ -161.262763, 55.958734 ], [ -161.230444, 55.947467 ], [ -161.211273, 55.951712 ], [ -161.096617, 55.954752 ], [ -161.076383, 55.942079 ], [ -161.049162, 55.945407 ], [ -161.027739, 55.954554 ], [ -161.023376, 55.959468 ], [ -160.898682, 55.999014 ], [ -160.873229, 56.001448 ], [ -160.863250, 55.996237 ], [ -160.814205, 55.953834 ], [ -160.812893, 55.950858 ], [ -160.814113, 55.930633 ], [ -160.818201, 55.910749 ], [ -160.835077, 55.915747 ], [ -160.849665, 55.916227 ], [ -160.923856, 55.900574 ], [ -160.951560, 55.852772 ], [ -160.946400, 55.834881 ], [ -160.940845, 55.822529 ], [ -160.930591, 55.814358 ], [ -160.806014, 55.738241 ], [ -160.765228, 55.757174 ], [ -160.730726, 55.747664 ], [ -160.668102, 55.723556 ], [ -160.661205, 55.723427 ], [ -160.655560, 55.730041 ], [ -160.655468, 55.739868 ], [ -160.663037, 55.745491 ], [ -160.675794, 55.751411 ], [ -160.695227, 55.755075 ], [ -160.751236, 55.779364 ], [ -160.757705, 55.785841 ], [ -160.769155, 55.858268 ], [ -160.734182, 55.870995 ], [ -160.697591, 55.862396 ], [ -160.639088, 55.858300 ], [ -160.564014, 55.863719 ], [ -160.550343, 55.867549 ], [ -160.532582, 55.869891 ], [ -160.508433, 55.869379 ], [ -160.494678, 55.864193 ], [ -160.477892, 55.841099 ], [ -160.479355, 55.822361 ], [ -160.438735, 55.789608 ], [ -160.385878, 55.796445 ], [ -160.342876, 55.778166 ], [ -160.293924, 55.765556 ], [ -160.277382, 55.765861 ], [ -160.264568, 55.775723 ], [ -160.268930, 55.784278 ], [ -160.293498, 55.801788 ], [ -160.315655, 55.814544 ], [ -160.317826, 55.818983 ], [ -160.272533, 55.831673 ], [ -160.273176, 55.856881 ], [ -160.325637, 55.867858 ], [ -160.380573, 55.889456 ], [ -160.420735, 55.908620 ], [ -160.486594, 55.924168 ], [ -160.535759, 55.939617 ], [ -160.533685, 55.959950 ], [ -160.527094, 55.973011 ], [ -160.526362, 55.982433 ], [ -160.529292, 55.986103 ], [ -160.534541, 55.989498 ], [ -160.559597, 55.996838 ], [ -160.567604, 55.991670 ], [ -160.570895, 55.988929 ], [ -160.574397, 55.986552 ], [ -160.576655, 55.985416 ], [ -160.580840, 55.984079 ], [ -160.583491, 55.986468 ], [ -160.568356, 56.004062 ], [ -160.488708, 56.077214 ], [ -160.482208, 56.085234 ], [ -160.451417, 56.125564 ], [ -160.411381, 56.194138 ], [ -160.396338, 56.231775 ], [ -160.383094, 56.251352 ], [ -160.357156, 56.279582 ], [ -160.340249, 56.291271 ], [ -160.315896, 56.302227 ], [ -160.274604, 56.317151 ], [ -160.222878, 56.346868 ], [ -160.208383, 56.358022 ], [ -160.196329, 56.372550 ], [ -160.146252, 56.400176 ], [ -160.082592, 56.411094 ], [ -160.001477, 56.442201 ], [ -159.976758, 56.453951 ], [ -159.938337, 56.474192 ], [ -159.828049, 56.543935 ], [ -159.815477, 56.548941 ], [ -159.636156, 56.597390 ], [ -159.534961, 56.626529 ], [ -159.439380, 56.641332 ], [ -159.369434, 56.657073 ], [ -159.324421, 56.670356 ], [ -159.264871, 56.703136 ], [ -159.279894, 56.715667 ], [ -159.263113, 56.723321 ], [ -159.156455, 56.763324 ], [ -159.106652, 56.781126 ], [ -159.093468, 56.783704 ], [ -159.038354, 56.806006 ], [ -159.018304, 56.815094 ], [ -158.957471, 56.851184 ], [ -158.955338, 56.849762 ], [ -158.953543, 56.843418 ], [ -158.933589, 56.827905 ], [ -158.910730, 56.814797 ], [ -158.893212, 56.805788 ], [ -158.893211, 56.805788 ], [ -158.868797, 56.796648 ], [ -158.853294, 56.792620 ], [ -158.783590, 56.780750 ], [ -158.660298, 56.789015 ], [ -158.642293, 56.812850 ], [ -158.642845, 56.836608 ], [ -158.646812, 56.846992 ], [ -158.663659, 56.857055 ], [ -158.699788, 56.927362 ], [ -158.679293, 56.988625 ], [ -158.659945, 57.034585 ], [ -158.637364, 57.061364 ], [ -158.518429, 57.160550 ], [ -158.453711, 57.211790 ], [ -158.376249, 57.265542 ], [ -158.355066, 57.274850 ], [ -158.229883, 57.321534 ], [ -158.149710, 57.344916 ], [ -158.067030, 57.382915 ], [ -158.060041, 57.387456 ], [ -158.049932, 57.390141 ], [ -158.034246, 57.390230 ], [ -158.010538, 57.401456 ], [ -157.994670, 57.414234 ], [ -157.956239, 57.449383 ], [ -157.937241, 57.472048 ], [ -157.931624, 57.476208 ], [ -157.786046, 57.542189 ], [ -157.772496, 57.547055 ], [ -157.703852, 57.563455 ], [ -157.678891, 57.563888 ], [ -157.684833, 57.557746 ], [ -157.680416, 57.537727 ], [ -157.649389, 57.500331 ], [ -157.615137, 57.488691 ], [ -157.586910, 57.487156 ], [ -157.573129, 57.514525 ], [ -157.573472, 57.522732 ], [ -157.588339, 57.582152 ], [ -157.599644, 57.607950 ], [ -157.607387, 57.612537 ], [ -157.652202, 57.614794 ], [ -157.684282, 57.609974 ], [ -157.691291, 57.611131 ], [ -157.710645, 57.639946 ], [ -157.703782, 57.721768 ], [ -157.671061, 57.772866 ], [ -157.642226, 57.868777 ], [ -157.623886, 57.960502 ], [ -157.611802, 58.034263 ], [ -157.596601, 58.088670 ], [ -157.583636, 58.124307 ], [ -157.580924, 58.128096 ], [ -157.556556, 58.148445 ], [ -157.533329, 58.160335 ], [ -157.514474, 58.162978 ], [ -157.493784, 58.162148 ], [ -157.397350, 58.173383 ], [ -157.383099, 58.184607 ], [ -157.352316, 58.219097 ], [ -157.366928, 58.232669 ], [ -157.374511, 58.232117 ], [ -157.389237, 58.228091 ], [ -157.407918, 58.211871 ], [ -157.423325, 58.211360 ], [ -157.442712, 58.218875 ], [ -157.515475, 58.255638 ], [ -157.541564, 58.271883 ], [ -157.547209, 58.277535 ], [ -157.556343, 58.303749 ], [ -157.556865, 58.330715 ], [ -157.536176, 58.391597 ], [ -157.524477, 58.414506 ], [ -157.488108, 58.471705 ], [ -157.481487, 58.480771 ], [ -157.460880, 58.499693 ], [ -157.451918, 58.505618 ], [ -157.397197, 58.527333 ], [ -157.380259, 58.524398 ], [ -157.358487, 58.533876 ], [ -157.330683, 58.551516 ], [ -157.313572, 58.565043 ], [ -157.281327, 58.600236 ], [ -157.267437, 58.609794 ], [ -157.251462, 58.620786 ], [ -157.178834, 58.660440 ], [ -157.077914, 58.708103 ], [ -157.061928, 58.726102 ], [ -157.008226, 58.817139 ], [ -157.003401, 58.836822 ], [ -157.003607, 58.839306 ], [ -157.010984, 58.848400 ], [ -157.016088, 58.863490 ], [ -157.012392, 58.875889 ], [ -156.985833, 58.888654 ], [ -156.980888, 58.891031 ], [ -156.966649, 58.904074 ], [ -156.975946, 58.940896 ], [ -157.029517, 58.956203 ], [ -157.039206, 58.945921 ], [ -157.040625, 58.913391 ], [ -157.070584, 58.887816 ], [ -157.070601, 58.887808 ], [ -157.116866, 58.867533 ], [ -157.189554, 58.847724 ], [ -157.200998, 58.845012 ], [ -157.215710, 58.841526 ], [ -157.241396, 58.837558 ], [ -157.259663, 58.835665 ], [ -157.275451, 58.836136 ], [ -157.353132, 58.817729 ], [ -157.429531, 58.791071 ], [ -157.484062, 58.785962 ], [ -157.532654, 58.772638 ], [ -157.537543, 58.768542 ], [ -157.542326, 58.760962 ], [ -157.550603, 58.754514 ], [ -157.696472, 58.729975 ], [ -157.721786, 58.723212 ], [ -157.753583, 58.711924 ], [ -157.799597, 58.695590 ], [ -157.855396, 58.678277 ], [ -158.001016, 58.642893 ], [ -158.036593, 58.634248 ], [ -158.101646, 58.621090 ], [ -158.140307, 58.615020 ], [ -158.190283, 58.613710 ], [ -158.213861, 58.615828 ], [ -158.232276, 58.619902 ], [ -158.273036, 58.633470 ], [ -158.297189, 58.643147 ], [ -158.327038, 58.659835 ], [ -158.332093, 58.665313 ], [ -158.332860, 58.669274 ], [ -158.330216, 58.675043 ], [ -158.332394, 58.686814 ], [ -158.343545, 58.713634 ], [ -158.351481, 58.727693 ], [ -158.376873, 58.748043 ], [ -158.400475, 58.761182 ], [ -158.423828, 58.769847 ], [ -158.455210, 58.776972 ], [ -158.512547, 58.783110 ], [ -158.538516, 58.788394 ], [ -158.550626, 58.792915 ], [ -158.564833, 58.802715 ], [ -158.566397, 58.807137 ], [ -158.565870, 58.815429 ], [ -158.559499, 58.841819 ], [ -158.559132, 58.860776 ], [ -158.565718, 58.875828 ], [ -158.598645, 58.901230 ], [ -158.619684, 58.911048 ], [ -158.717436, 58.872462 ], [ -158.729581, 58.871218 ], [ -158.745305, 58.874098 ], [ -158.767748, 58.864264 ], [ -158.789632, 58.814257 ], [ -158.790786, 58.808424 ], [ -158.790378, 58.804712 ], [ -158.782365, 58.791157 ], [ -158.774626, 58.778593 ], [ -158.769800, 58.774141 ], [ -158.771246, 58.765109 ], [ -158.784886, 58.747739 ], [ -158.800959, 58.732842 ], [ -158.812116, 58.727845 ], [ -158.827105, 58.724495 ], [ -158.848225, 58.722736 ], [ -158.861207, 58.695580 ], [ -158.827852, 58.626432 ], [ -158.769131, 58.548650 ], [ -158.721173, 58.497971 ], [ -158.704052, 58.482759 ], [ -158.795316, 58.408032 ], [ -158.830598, 58.397095 ], [ -158.880927, 58.390670 ], [ -158.896067, 58.390065 ], [ -158.944154, 58.396885 ], [ -159.046105, 58.417466 ], [ -159.063346, 58.423139 ], [ -159.080496, 58.444256 ], [ -159.187347, 58.555609 ], [ -159.242290, 58.619067 ], [ -159.357625, 58.734520 ], [ -159.390664, 58.762362 ], [ -159.450831, 58.797736 ], [ -159.501768, 58.824304 ], [ -159.532347, 58.833609 ], [ -159.556355, 58.837414 ], [ -159.580287, 58.840691 ], [ -159.643549, 58.845063 ], [ -159.601899, 58.884671 ], [ -159.589811, 58.890359 ], [ -159.586966, 58.900314 ], [ -159.594788, 58.912402 ], [ -159.602610, 58.920935 ], [ -159.616120, 58.931601 ], [ -159.642430, 58.938712 ], [ -159.657362, 58.938712 ], [ -159.691493, 58.931601 ], [ -159.712114, 58.929468 ], [ -159.723491, 58.932312 ], [ -159.732932, 58.930739 ], [ -159.753754, 58.855724 ], [ -159.808777, 58.861542 ], [ -159.792923, 58.823971 ], [ -159.806305, 58.805595 ], [ -159.908386, 58.779903 ], [ -159.995667, 58.848301 ], [ -159.985352, 58.870464 ], [ -160.054047, 58.887001 ], [ -160.093109, 58.860798 ], [ -160.150528, 58.866062 ], [ -160.154480, 58.916874 ], [ -160.232788, 58.901127 ], [ -160.286346, 58.945007 ], [ -160.322922, 58.953953 ], [ -160.256592, 58.994480 ], [ -160.317780, 59.070477 ], [ -160.476578, 59.026047 ], [ -160.641785, 58.964489 ], [ -160.753067, 58.910431 ], [ -160.835358, 58.823494 ], [ -160.855194, 58.882523 ], [ -160.999741, 58.856655 ], [ -161.034520, 58.843894 ], [ -161.094249, 58.821979 ], [ -161.183380, 58.789276 ], [ -161.337982, 58.742912 ], [ -161.345396, 58.735450 ], [ -161.372711, 58.707958 ], [ -161.372314, 58.666172 ], [ -161.521347, 58.633141 ], [ -161.550537, 58.611160 ], [ -161.626450, 58.602581 ], [ -161.682907, 58.564671 ], [ -161.751999, 58.551842 ], [ -161.766296, 58.599224 ], [ -161.871216, 58.637478 ], [ -162.066269, 58.620800 ], [ -162.171722, 58.648441 ], [ -161.994644, 58.688828 ], [ -161.939163, 58.655613 ], [ -161.877213, 58.666138 ], [ -161.859055, 58.708637 ], [ -161.769501, 58.774937 ], [ -161.756622, 58.826477 ], [ -161.783981, 58.969421 ], [ -161.828171, 59.062702 ], [ -161.981964, 59.150997 ], [ -162.048584, 59.254177 ], [ -162.018982, 59.292278 ], [ -161.942993, 59.263828 ], [ -161.956528, 59.361771 ], [ -161.904053, 59.387341 ], [ -161.837936, 59.423836 ], [ -161.828125, 59.428188 ], [ -161.790375, 59.468197 ], [ -161.738312, 59.467010 ], [ -161.702530, 59.490906 ], [ -161.757980, 59.557152 ], [ -161.854752, 59.646214 ], [ -161.911163, 59.741741 ], [ -162.017059, 59.829426 ], [ -162.092361, 59.881104 ], [ -162.100708, 59.944675 ], [ -162.108560, 59.953861 ], [ -162.121072, 59.965241 ], [ -162.143049, 59.967506 ], [ -162.171759, 59.984163 ], [ -162.190616, 60.002030 ], [ -162.207225, 60.021834 ], [ -162.228371, 60.056313 ], [ -162.234642, 60.077333 ], [ -162.234043, 60.091345 ], [ -162.231426, 60.095297 ], [ -162.220054, 60.101078 ], [ -162.202141, 60.116450 ], [ -162.186148, 60.149605 ], [ -162.188441, 60.156509 ], [ -162.216366, 60.174190 ], [ -162.239267, 60.180100 ], [ -162.252564, 60.178623 ], [ -162.258105, 60.172713 ], [ -162.257318, 60.163353 ], [ -162.258328, 60.157939 ], [ -162.287089, 60.122173 ], [ -162.293850, 60.116580 ], [ -162.301090, 60.112146 ], [ -162.316922, 60.107590 ], [ -162.321481, 60.107970 ], [ -162.360185, 60.147360 ], [ -162.371131, 60.169019 ], [ -162.371870, 60.173451 ], [ -162.371032, 60.178616 ], [ -162.402270, 60.186425 ], [ -162.426344, 60.185331 ], [ -162.445727, 60.176448 ], [ -162.447904, 60.170480 ], [ -162.463026, 60.153020 ], [ -162.476214, 60.145536 ], [ -162.484234, 60.137964 ], [ -162.492346, 60.121804 ], [ -162.494327, 60.110675 ], [ -162.481175, 60.087544 ], [ -162.476759, 60.047690 ], [ -162.503647, 59.999230 ], [ -162.530118, 59.990110 ], [ -162.585518, 59.977230 ], [ -162.622569, 59.971809 ], [ -162.644231, 59.972954 ], [ -162.682717, 59.979432 ], [ -162.738592, 59.976321 ], [ -162.740059, 59.968797 ], [ -162.748554, 59.962664 ], [ -162.760007, 59.958013 ], [ -162.828585, 59.939142 ], [ -162.907260, 59.923682 ], [ -162.974977, 59.906443 ], [ -163.033128, 59.884135 ], [ -163.109595, 59.861633 ], [ -163.172633, 59.845058 ], [ -163.349027, 59.819890 ], [ -163.387670, 59.815880 ], [ -163.559148, 59.801391 ], [ -163.662607, 59.795710 ], [ -163.704795, 59.794805 ], [ -163.772229, 59.795624 ], [ -163.930798, 59.803853 ], [ -164.079837, 59.828034 ], [ -164.115117, 59.836688 ], [ -164.133393, 59.845612 ], [ -164.160319, 59.864679 ], [ -164.201811, 59.916119 ], [ -164.208475, 59.934461 ], [ -164.209843, 59.942874 ], [ -164.208306, 59.949046 ], [ -164.198545, 59.955109 ], [ -164.178705, 59.961810 ], [ -164.161024, 59.964076 ], [ -164.125430, 59.964626 ], [ -164.115080, 59.973166 ], [ -164.131810, 59.991177 ], [ -164.191600, 60.024496 ], [ -164.302968, 60.054233 ], [ -164.336111, 60.055527 ], [ -164.385471, 60.077190 ], [ -164.461194, 60.137824 ], [ -164.498556, 60.170546 ], [ -164.493861, 60.177397 ], [ -164.494317, 60.184833 ], [ -164.505677, 60.194304 ], [ -164.517647, 60.199493 ], [ -164.541699, 60.205279 ], [ -164.558343, 60.207042 ], [ -164.596070, 60.222874 ], [ -164.619501, 60.234938 ], [ -164.634362, 60.242980 ], [ -164.646332, 60.253303 ], [ -164.651996, 60.262745 ], [ -164.653098, 60.267902 ], [ -164.698889, 60.296298 ], [ -164.726570, 60.291475 ], [ -164.777233, 60.293833 ], [ -164.850355, 60.303615 ], [ -164.899296, 60.316787 ], [ -164.962678, 60.339660 ], [ -165.005576, 60.359812 ], [ -165.057585, 60.386287 ], [ -165.129403, 60.433707 ], [ -165.132893, 60.438867 ], [ -165.124792, 60.449191 ], [ -165.120728, 60.451196 ], [ -165.069693, 60.460893 ], [ -165.049070, 60.461516 ], [ -165.015155, 60.471414 ], [ -164.997870, 60.480459 ], [ -164.961439, 60.508391 ], [ -164.956788, 60.527837 ], [ -164.960843, 60.533845 ], [ -164.965488, 60.536701 ], [ -164.971280, 60.539558 ], [ -164.986952, 60.542406 ], [ -165.057440, 60.544631 ], [ -165.190449, 60.498001 ], [ -165.244442, 60.496298 ], [ -165.362975, 60.506866 ], [ -165.377559, 60.513164 ], [ -165.405071, 60.534650 ], [ -165.420349, 60.550692 ], [ -165.419788, 60.552418 ], [ -165.415193, 60.558160 ], [ -165.381052, 60.577987 ], [ -165.367676, 60.581158 ], [ -165.346721, 60.580603 ], [ -165.312937, 60.576313 ], [ -165.289651, 60.575755 ], [ -165.268717, 60.579488 ], [ -165.178617, 60.623927 ], [ -165.170458, 60.629091 ], [ -165.147184, 60.651160 ], [ -165.063148, 60.688645 ], [ -165.052642, 60.690068 ], [ -165.043300, 60.687468 ], [ -165.027535, 60.686008 ], [ -164.991665, 60.698840 ], [ -164.971250, 60.711434 ], [ -164.966591, 60.717438 ], [ -164.965410, 60.724306 ], [ -164.971839, 60.729730 ], [ -165.010452, 60.744789 ], [ -165.023904, 60.753128 ], [ -165.032074, 60.760022 ], [ -165.040843, 60.772660 ], [ -165.042584, 60.784430 ], [ -165.037889, 60.789010 ], [ -165.032615, 60.786704 ], [ -165.020309, 60.785539 ], [ -164.977663, 60.790360 ], [ -164.944914, 60.800379 ], [ -164.924180, 60.809331 ], [ -164.939313, 60.823463 ], [ -165.009703, 60.815060 ], [ -165.021430, 60.815086 ], [ -165.029620, 60.826001 ], [ -165.030183, 60.838050 ], [ -165.003679, 60.875580 ], [ -164.945958, 60.921060 ], [ -164.939496, 60.924774 ], [ -164.925994, 60.925063 ], [ -164.917542, 60.928144 ], [ -164.903903, 60.942213 ], [ -164.921256, 60.946509 ], [ -164.940065, 60.945369 ], [ -165.007096, 60.922058 ], [ -165.032040, 60.903986 ], [ -165.016941, 60.891071 ], [ -165.080907, 60.860224 ], [ -165.132488, 60.850145 ], [ -165.176774, 60.847149 ], [ -165.177531, 60.858865 ], [ -165.223480, 60.896450 ], [ -165.216942, 60.914322 ], [ -165.157111, 60.917363 ], [ -165.155232, 60.929186 ], [ -165.172467, 60.940328 ], [ -165.194945, 60.973900 ], [ -165.194964, 60.979915 ], [ -165.190271, 60.983073 ], [ -165.133937, 61.011250 ], [ -165.115681, 61.016097 ], [ -165.097425, 61.016658 ], [ -165.096828, 61.014944 ], [ -165.083282, 61.012933 ], [ -165.020265, 61.011153 ], [ -164.998172, 61.013826 ], [ -164.961527, 61.024166 ], [ -164.951103, 61.031020 ], [ -164.950573, 61.048079 ], [ -164.927825, 61.084392 ], [ -164.902245, 61.077902 ], [ -164.870450, 61.079564 ], [ -164.868009, 61.096394 ], [ -164.883441, 61.105924 ], [ -164.891286, 61.108246 ], [ -164.941253, 61.110863 ], [ -164.981718, 61.109691 ], [ -164.991273, 61.107232 ], [ -164.997636, 61.104430 ], [ -164.998547, 61.079492 ], [ -164.993599, 61.076241 ], [ -164.991227, 61.072192 ], [ -164.995695, 61.058035 ], [ -165.011271, 61.051984 ], [ -165.029551, 61.054010 ], [ -165.057842, 61.059746 ], [ -165.119781, 61.078640 ], [ -165.167636, 61.113502 ], [ -165.175321, 61.120926 ], [ -165.177110, 61.125494 ], [ -165.167072, 61.133487 ], [ -165.165857, 61.136567 ], [ -165.168860, 61.144913 ], [ -165.172994, 61.146919 ], [ -165.203757, 61.150341 ], [ -165.289700, 61.181714 ], [ -165.307976, 61.181823 ], [ -165.325552, 61.169306 ], [ -165.344389, 61.123691 ], [ -165.350154, 61.104545 ], [ -165.350113, 61.097407 ], [ -165.347082, 61.084847 ], [ -165.342321, 61.079994 ], [ -165.336996, 61.077709 ], [ -165.338136, 61.073432 ], [ -165.343442, 61.070564 ], [ -165.370544, 61.066821 ], [ -165.403007, 61.067060 ], [ -165.498726, 61.079149 ], [ -165.549613, 61.088162 ], [ -165.578127, 61.100361 ], [ -165.590682, 61.111169 ], [ -165.631996, 61.220708 ], [ -165.634048, 61.237557 ], [ -165.627549, 61.258125 ], [ -165.620589, 61.268586 ], [ -165.623317, 61.278431 ], [ -165.635791, 61.285456 ], [ -165.662892, 61.294570 ], [ -165.787442, 61.310063 ], [ -165.809373, 61.306827 ], [ -165.816434, 61.303363 ], [ -165.831365, 61.306719 ], [ -165.858993, 61.318865 ], [ -165.879599, 61.335044 ], [ -165.915445, 61.387686 ], [ -165.921194, 61.403080 ], [ -165.921950, 61.409638 ], [ -165.918612, 61.419087 ], [ -165.844525, 61.440601 ], [ -165.800525, 61.449657 ], [ -165.791085, 61.449852 ], [ -165.767226, 61.456950 ], [ -165.748503, 61.476446 ], [ -165.746352, 61.489304 ], [ -165.754317, 61.498704 ], [ -165.807627, 61.529171 ], [ -165.912496, 61.556200 ], [ -165.964035, 61.555919 ], [ -165.981879, 61.551249 ], [ -165.985948, 61.546650 ], [ -165.999535, 61.539720 ], [ -166.034748, 61.535221 ], [ -166.075524, 61.532672 ], [ -166.088680, 61.522885 ], [ -166.079983, 61.513464 ], [ -166.058242, 61.500419 ], [ -166.075398, 61.492980 ], [ -166.108269, 61.492475 ], [ -166.124202, 61.504645 ], [ -166.158345, 61.541537 ], [ -166.165232, 61.550618 ], [ -166.178627, 61.574807 ], [ -166.181850, 61.581342 ], [ -166.182688, 61.588481 ], [ -166.158976, 61.700437 ], [ -166.153178, 61.714931 ], [ -166.143757, 61.724352 ], [ -166.134285, 61.723919 ], [ -166.133020, 61.721918 ], [ -166.134402, 61.709068 ], [ -166.138684, 61.667101 ], [ -166.140133, 61.639562 ], [ -166.139409, 61.632315 ], [ -166.132162, 61.631590 ], [ -166.053983, 61.638201 ], [ -166.031834, 61.641199 ], [ -166.015134, 61.645866 ], [ -165.967894, 61.654432 ], [ -165.903783, 61.663632 ], [ -165.822140, 61.670610 ], [ -165.809933, 61.673029 ], [ -165.810000, 61.689360 ], [ -165.856791, 61.690734 ], [ -165.934968, 61.706299 ], [ -165.993851, 61.723105 ], [ -166.006693, 61.729879 ], [ -166.092081, 61.800733 ], [ -166.094045, 61.805296 ], [ -166.094312, 61.813859 ], [ -166.085334, 61.816498 ], [ -165.955265, 61.832408 ], [ -165.870982, 61.826013 ], [ -165.758413, 61.825444 ], [ -165.747090, 61.827720 ], [ -165.736904, 61.832901 ], [ -165.736429, 61.839188 ], [ -165.730439, 61.842075 ], [ -165.696038, 61.847055 ], [ -165.640216, 61.848041 ], [ -165.608427, 61.855892 ], [ -165.600043, 61.859663 ], [ -165.612337, 61.871907 ], [ -165.667939, 61.900275 ], [ -165.703482, 61.921572 ], [ -165.725818, 61.947184 ], [ -165.741481, 61.971392 ], [ -165.756806, 62.006337 ], [ -165.756386, 62.014032 ], [ -165.748641, 62.047145 ], [ -165.743522, 62.062280 ], [ -165.734117, 62.076873 ], [ -165.706155, 62.108365 ], [ -165.672037, 62.139890 ], [ -165.620746, 62.172616 ], [ -165.500322, 62.255451 ], [ -165.373713, 62.338196 ], [ -165.337722, 62.359031 ], [ -165.311967, 62.378812 ], [ -165.294962, 62.403353 ], [ -165.269270, 62.427352 ], [ -165.199804, 62.469637 ], [ -165.096155, 62.522452 ], [ -165.046045, 62.540420 ], [ -164.868059, 62.571142 ], [ -164.770232, 62.592082 ], [ -164.777244, 62.609083 ], [ -164.796056, 62.611486 ], [ -164.842846, 62.604504 ], [ -164.893740, 62.599671 ], [ -164.914064, 62.602530 ], [ -164.928813, 62.608992 ], [ -164.935992, 62.613456 ], [ -164.940464, 62.618431 ], [ -164.942068, 62.624956 ], [ -164.932145, 62.651071 ], [ -164.912910, 62.657496 ], [ -164.865896, 62.645817 ], [ -164.857109, 62.635513 ], [ -164.837337, 62.631446 ], [ -164.817110, 62.636697 ], [ -164.857182, 62.768830 ], [ -164.863640, 62.772620 ], [ -164.870348, 62.774135 ], [ -164.877300, 62.784320 ], [ -164.877773, 62.797774 ], [ -164.875640, 62.806254 ], [ -164.850838, 62.839510 ], [ -164.836318, 62.852168 ], [ -164.795229, 62.858486 ], [ -164.768253, 62.871331 ], [ -164.751982, 62.893169 ], [ -164.742134, 62.920144 ], [ -164.745514, 62.944865 ], [ -164.765769, 62.954907 ], [ -164.766117, 62.958228 ], [ -164.716841, 63.006264 ], [ -164.685213, 63.022191 ], [ -164.583735, 63.058457 ], [ -164.580201, 63.070127 ], [ -164.611616, 63.077673 ], [ -164.641186, 63.072680 ], [ -164.643672, 63.074975 ], [ -164.644886, 63.079268 ], [ -164.640324, 63.091257 ], [ -164.633943, 63.097820 ], [ -164.493118, 63.177670 ], [ -164.423449, 63.211977 ], [ -164.363592, 63.226280 ], [ -164.209475, 63.251472 ], [ -164.140096, 63.259336 ], [ -164.066991, 63.262276 ], [ -164.036565, 63.261204 ], [ -163.970266, 63.248291 ], [ -163.909405, 63.232514 ], [ -163.885059, 63.222308 ], [ -163.788882, 63.217482 ], [ -163.755283, 63.217461 ], [ -163.732650, 63.213257 ], [ -163.725805, 63.210620 ], [ -163.724072, 63.206592 ], [ -163.703980, 63.188107 ], [ -163.650294, 63.157564 ], [ -163.616272, 63.141213 ], [ -163.590122, 63.146091 ], [ -163.529938, 63.135400 ], [ -163.520806, 63.123280 ], [ -163.507217, 63.113685 ], [ -163.474794, 63.099053 ], [ -163.433968, 63.089296 ], [ -163.417683, 63.083874 ], [ -163.364979, 63.055805 ], [ -163.316203, 63.037763 ], [ -163.130853, 63.049387 ], [ -163.053996, 63.058334 ], [ -163.040500, 63.062151 ], [ -162.998302, 63.089286 ], [ -162.919727, 63.120153 ], [ -162.901643, 63.125597 ], [ -162.844559, 63.154191 ], [ -162.837850, 63.159224 ], [ -162.834926, 63.164621 ], [ -162.840187, 63.187579 ], [ -162.839167, 63.193004 ], [ -162.834354, 63.198076 ], [ -162.821122, 63.205596 ], [ -162.769536, 63.217069 ], [ -162.758741, 63.217187 ], [ -162.747621, 63.213572 ], [ -162.724080, 63.214615 ], [ -162.688083, 63.220608 ], [ -162.662614, 63.229906 ], [ -162.587754, 63.275727 ], [ -162.571695, 63.285556 ], [ -162.437059, 63.377836 ], [ -162.432169, 63.382606 ], [ -162.426095, 63.393651 ], [ -162.428744, 63.401055 ], [ -162.421530, 63.409014 ], [ -162.384625, 63.435797 ], [ -162.352274, 63.454069 ], [ -162.301869, 63.473422 ], [ -162.271089, 63.487711 ], [ -162.268242, 63.490799 ], [ -162.267833, 63.495084 ], [ -162.288532, 63.526412 ], [ -162.301471, 63.537350 ], [ -162.296731, 63.540108 ], [ -162.252411, 63.541753 ], [ -162.190145, 63.529886 ], [ -162.151574, 63.517952 ], [ -162.123249, 63.512807 ], [ -162.108597, 63.511927 ], [ -162.073156, 63.513768 ], [ -162.041687, 63.489650 ], [ -162.045709, 63.475434 ], [ -162.050132, 63.472850 ], [ -162.050543, 63.470589 ], [ -162.039444, 63.458930 ], [ -162.025552, 63.447539 ], [ -161.930714, 63.444843 ], [ -161.839897, 63.447313 ], [ -161.765832, 63.453803 ], [ -161.705630, 63.464061 ], [ -161.676526, 63.465003 ], [ -161.591632, 63.454244 ], [ -161.583772, 63.447857 ], [ -161.553077, 63.449217 ], [ -161.450463, 63.457178 ], [ -161.310181, 63.471312 ], [ -161.191163, 63.490072 ], [ -161.136758, 63.504525 ], [ -161.134230, 63.506735 ], [ -161.119964, 63.532544 ], [ -161.102721, 63.547800 ], [ -161.036049, 63.579566 ], [ -160.924877, 63.644814 ], [ -160.904353, 63.658024 ], [ -160.809089, 63.731332 ], [ -160.783304, 63.752893 ], [ -160.765560, 63.773552 ], [ -160.761974, 63.793453 ], [ -160.766291, 63.835189 ], [ -160.787624, 63.869196 ], [ -160.810798, 63.904646 ], [ -160.851979, 63.954409 ], [ -160.877686, 63.977265 ], [ -160.892455, 63.985943 ], [ -160.933740, 64.049729 ], [ -160.951641, 64.090067 ], [ -160.955132, 64.138030 ], [ -160.956425, 64.191732 ], [ -160.953596, 64.197775 ], [ -160.946857, 64.204158 ], [ -160.976038, 64.235761 ], [ -161.228941, 64.370747 ], [ -161.263519, 64.398166 ], [ -161.313668, 64.400874 ], [ -161.410382, 64.422107 ], [ -161.463026, 64.420074 ], [ -161.470182, 64.418814 ], [ -161.492926, 64.407851 ], [ -161.504903, 64.423074 ], [ -161.479093, 64.486401 ], [ -161.469046, 64.506575 ], [ -161.388621, 64.532783 ], [ -161.373572, 64.535028 ], [ -161.362901, 64.526913 ], [ -161.351145, 64.521382 ], [ -161.321343, 64.513865 ], [ -161.234092, 64.500365 ], [ -161.198029, 64.496626 ], [ -161.155518, 64.494687 ], [ -161.078031, 64.494094 ], [ -161.024185, 64.499719 ], [ -161.015095, 64.502124 ], [ -161.013228, 64.507521 ], [ -161.017140, 64.517124 ], [ -161.037534, 64.522246 ], [ -161.045947, 64.524948 ], [ -161.053060, 64.528504 ], [ -161.055549, 64.532416 ], [ -161.052348, 64.537395 ], [ -161.049148, 64.540952 ], [ -160.992894, 64.541295 ], [ -160.970555, 64.543884 ], [ -160.940493, 64.550000 ], [ -160.802048, 64.610352 ], [ -160.793356, 64.619317 ], [ -160.791614, 64.623055 ], [ -160.783570, 64.680581 ], [ -160.783398, 64.717160 ], [ -160.869571, 64.783797 ], [ -160.935974, 64.822370 ], [ -160.986417, 64.833984 ], [ -161.079718, 64.869549 ], [ -161.102755, 64.880661 ], [ -161.133062, 64.898219 ], [ -161.149655, 64.911985 ], [ -161.149366, 64.916558 ], [ -161.145725, 64.920534 ], [ -161.176009, 64.927161 ], [ -161.192120, 64.921366 ], [ -161.195202, 64.918178 ], [ -161.200893, 64.905796 ], [ -161.200964, 64.898659 ], [ -161.198586, 64.894403 ], [ -161.213756, 64.883324 ], [ -161.264283, 64.861970 ], [ -161.293049, 64.853243 ], [ -161.327848, 64.829836 ], [ -161.357867, 64.805922 ], [ -161.366808, 64.793777 ], [ -161.364438, 64.782099 ], [ -161.367483, 64.778907 ], [ -161.376985, 64.773036 ], [ -161.413493, 64.762723 ], [ -161.429860, 64.759027 ], [ -161.518211, 64.753250 ], [ -161.595506, 64.764478 ], [ -161.630287, 64.771290 ], [ -161.645520, 64.776452 ], [ -161.667261, 64.788981 ], [ -161.878363, 64.709476 ], [ -161.902429, 64.703851 ], [ -161.939279, 64.699119 ], [ -162.096528, 64.690983 ], [ -162.138832, 64.685934 ], [ -162.168516, 64.680290 ], [ -162.188146, 64.672395 ], [ -162.216620, 64.656213 ], [ -162.219718, 64.644176 ], [ -162.234477, 64.619336 ], [ -162.270025, 64.608710 ], [ -162.290571, 64.605496 ], [ -162.342308, 64.592240 ], [ -162.539996, 64.530931 ], [ -162.554875, 64.520341 ], [ -162.614220, 64.470702 ], [ -162.615452, 64.467077 ], [ -162.602178, 64.456869 ], [ -162.603020, 64.448666 ], [ -162.632242, 64.385734 ], [ -162.645156, 64.379783 ], [ -162.667680, 64.375356 ], [ -162.719218, 64.359971 ], [ -162.768424, 64.333516 ], [ -162.790167, 64.325182 ], [ -162.795636, 64.327716 ], [ -162.805385, 64.336023 ], [ -162.810004, 64.352647 ], [ -162.807205, 64.364643 ], [ -162.800350, 64.374695 ], [ -162.802266, 64.395327 ], [ -162.806612, 64.405608 ], [ -162.836540, 64.436702 ], [ -162.858556, 64.474864 ], [ -162.857562, 64.499780 ], [ -162.940776, 64.542417 ], [ -162.969250, 64.546870 ], [ -163.030657, 64.542353 ], [ -163.042618, 64.540046 ], [ -163.032057, 64.525608 ], [ -163.028887, 64.511908 ], [ -163.027158, 64.477945 ], [ -163.091486, 64.437736 ], [ -163.107459, 64.409192 ], [ -163.119450, 64.403808 ], [ -163.150789, 64.397249 ], [ -163.175336, 64.399334 ], [ -163.229206, 64.430019 ], [ -163.249092, 64.456223 ], [ -163.253027, 64.469501 ], [ -163.350926, 64.505859 ], [ -163.412900, 64.524986 ], [ -163.451482, 64.534820 ], [ -163.597834, 64.563356 ], [ -163.651943, 64.567299 ], [ -163.829739, 64.574965 ], [ -163.875774, 64.572935 ], [ -163.896180, 64.564483 ], [ -163.974352, 64.551370 ], [ -163.994532, 64.551742 ], [ -164.044839, 64.559167 ], [ -164.071997, 64.561280 ], [ -164.147059, 64.564552 ], [ -164.260064, 64.564220 ], [ -164.307273, 64.561488 ], [ -164.421871, 64.545256 ], [ -164.491327, 64.529824 ], [ -164.548298, 64.516738 ], [ -164.807747, 64.449432 ], [ -164.835679, 64.444917 ], [ -164.874421, 64.441195 ], [ -165.001961, 64.433917 ], [ -165.016519, 64.434392 ], [ -165.214182, 64.469726 ], [ -165.413443, 64.497939 ], [ -165.550573, 64.512235 ], [ -165.751093, 64.536437 ], [ -165.819595, 64.540171 ], [ -165.919704, 64.548660 ], [ -166.189546, 64.575798 ], [ -166.236939, 64.583558 ], [ -166.392403, 64.638161 ], [ -166.413926, 64.651229 ], [ -166.451788, 64.691761 ], [ -166.474714, 64.719267 ], [ -166.483801, 64.733419 ], [ -166.481076, 64.786156 ], [ -166.478978, 64.797036 ], [ -166.430516, 64.807715 ], [ -166.417028, 64.818740 ], [ -166.410198, 64.827968 ], [ -166.407303, 64.834278 ], [ -166.407315, 64.852281 ], [ -166.409331, 64.859755 ], [ -166.415624, 64.871928 ], [ -166.432246, 64.883160 ], [ -166.530518, 64.937114 ], [ -166.586066, 64.955712 ], [ -166.615110, 64.964330 ], [ -166.636843, 64.968113 ], [ -166.690814, 64.985372 ], [ -166.704830, 64.997051 ], [ -166.705283, 64.999846 ], [ -166.695206, 65.005184 ], [ -166.688762, 65.018029 ], [ -166.692426, 65.029629 ], [ -166.696453, 65.035857 ], [ -166.732794, 65.053498 ], [ -166.820910, 65.077053 ], [ -166.860402, 65.090866 ], [ -166.885451, 65.105856 ], [ -166.911922, 65.125965 ], [ -166.910131, 65.134024 ], [ -166.906687, 65.136320 ], [ -166.897720, 65.139028 ], [ -166.886677, 65.138763 ], [ -166.872666, 65.136928 ], [ -166.837496, 65.128146 ], [ -166.826753, 65.119778 ], [ -166.816790, 65.117089 ], [ -166.755554, 65.110585 ], [ -166.670320, 65.109720 ], [ -166.638411, 65.113586 ], [ -166.634449, 65.125873 ], [ -166.606070, 65.135992 ], [ -166.521506, 65.149242 ], [ -166.509566, 65.152719 ], [ -166.479913, 65.167249 ], [ -166.464192, 65.177086 ], [ -166.459984, 65.183284 ], [ -166.460050, 65.189897 ], [ -166.465342, 65.194818 ], [ -166.474839, 65.217663 ], [ -166.475297, 65.224335 ], [ -166.451711, 65.236178 ], [ -166.386271, 65.254143 ], [ -166.347189, 65.276341 ], [ -166.360618, 65.288631 ], [ -166.377721, 65.297983 ], [ -166.439404, 65.319058 ], [ -166.485968, 65.330900 ], [ -166.518640, 65.335824 ], [ -166.551097, 65.338406 ], [ -166.572735, 65.338155 ], [ -166.596964, 65.336246 ], [ -166.625987, 65.325121 ], [ -166.655179, 65.324938 ], [ -166.679717, 65.326856 ], [ -166.796001, 65.337184 ], [ -166.851646, 65.348485 ], [ -166.899681, 65.360642 ], [ -167.026782, 65.381967 ], [ -167.101860, 65.387737 ], [ -167.170465, 65.389269 ], [ -167.398458, 65.400259 ], [ -167.474024, 65.412744 ], [ -167.574639, 65.444979 ], [ -167.620388, 65.463463 ], [ -167.621371, 65.466589 ], [ -167.710888, 65.498524 ], [ -167.841836, 65.530249 ], [ -167.851234, 65.538181 ], [ -167.909599, 65.550876 ], [ -167.967065, 65.558599 ], [ -167.997178, 65.559346 ], [ -168.047620, 65.569149 ], [ -168.075200, 65.576355 ], [ -168.099046, 65.592239 ], [ -168.099356, 65.599045 ], [ -168.096140, 65.600882 ], [ -168.100003, 65.610972 ], [ -168.127044, 65.626584 ], [ -168.134663, 65.640840 ], [ -168.128930, 65.655744 ], [ -168.103708, 65.685552 ], [ -167.979889, 65.727972 ], [ -167.857216, 65.754341 ], [ -167.735690, 65.776124 ], [ -167.539643, 65.820836 ], [ -167.314935, 65.885039 ], [ -167.246146, 65.911408 ], [ -167.139524, 65.948095 ], [ -166.977872, 65.996247 ], [ -166.956089, 66.007711 ], [ -166.827684, 66.051277 ], [ -166.597243, 66.118919 ], [ -166.526162, 66.141849 ], [ -166.330971, 66.189514 ], [ -166.308287, 66.180287 ], [ -166.282123, 66.177089 ], [ -166.245693, 66.169920 ], [ -166.223186, 66.171033 ], [ -166.190692, 66.167410 ], [ -166.181579, 66.164626 ], [ -166.143876, 66.159265 ], [ -166.127228, 66.155204 ], [ -166.122248, 66.152622 ], [ -166.122486, 66.149417 ], [ -166.139023, 66.146991 ], [ -166.149870, 66.141303 ], [ -166.148866, 66.137747 ], [ -166.138305, 66.131966 ], [ -166.101618, 66.125198 ], [ -166.087392, 66.119610 ], [ -166.085179, 66.115369 ], [ -166.080015, 66.112602 ], [ -166.046471, 66.107833 ], [ -166.009898, 66.110750 ], [ -165.959741, 66.109410 ], [ -165.925101, 66.111066 ], [ -165.892999, 66.115767 ], [ -165.876740, 66.114802 ], [ -165.845082, 66.107971 ], [ -165.799096, 66.100823 ], [ -165.763510, 66.098885 ], [ -165.758784, 66.092915 ], [ -165.733616, 66.096231 ], [ -165.697845, 66.104041 ], [ -165.693048, 66.103303 ], [ -165.661901, 66.117944 ], [ -165.649344, 66.119562 ], [ -165.646741, 66.118152 ], [ -165.650220, 66.114746 ], [ -165.647717, 66.113487 ], [ -165.630793, 66.117643 ], [ -165.607237, 66.119397 ], [ -165.599803, 66.117686 ], [ -165.588512, 66.119695 ], [ -165.584292, 66.129489 ], [ -165.544886, 66.142901 ], [ -165.544660, 66.151933 ], [ -165.551682, 66.161584 ], [ -165.578906, 66.163270 ], [ -165.594386, 66.168083 ], [ -165.620879, 66.180572 ], [ -165.653814, 66.192453 ], [ -165.690509, 66.202029 ], [ -165.760518, 66.209561 ], [ -165.813473, 66.207174 ], [ -165.848314, 66.211367 ], [ -165.853291, 66.212684 ], [ -165.867148, 66.220871 ], [ -165.874462, 66.227999 ], [ -165.877514, 66.240309 ], [ -165.866468, 66.247073 ], [ -165.853577, 66.263185 ], [ -165.859933, 66.274220 ], [ -165.872497, 66.284271 ], [ -165.880454, 66.295160 ], [ -165.882129, 66.299766 ], [ -165.882496, 66.311603 ], [ -165.869233, 66.316112 ], [ -165.805030, 66.333310 ], [ -165.668600, 66.361971 ], [ -165.407204, 66.420441 ], [ -165.187082, 66.465154 ], [ -165.124026, 66.473179 ], [ -164.711009, 66.542541 ], [ -164.400727, 66.581110 ], [ -164.400724, 66.581110 ], [ -164.345015, 66.580834 ], [ -164.094554, 66.592281 ], [ -163.979581, 66.593953 ], [ -163.978095, 66.592616 ], [ -163.978492, 66.591012 ], [ -163.985713, 66.576085 ], [ -163.908341, 66.555970 ], [ -163.875235, 66.558248 ], [ -163.850476, 66.563102 ], [ -163.754171, 66.551284 ], [ -163.727179, 66.516388 ], [ -163.728308, 66.498552 ], [ -163.730247, 66.491372 ], [ -163.761967, 66.454874 ], [ -163.798687, 66.436875 ], [ -163.844221, 66.418978 ], [ -163.856359, 66.409296 ], [ -163.873106, 66.389015 ], [ -163.873096, 66.328550 ], [ -163.849163, 66.307639 ], [ -163.839825, 66.304079 ], [ -163.829977, 66.280398 ], [ -163.830077, 66.272000 ], [ -163.843108, 66.259869 ], [ -163.904813, 66.230303 ], [ -163.955901, 66.217170 ], [ -164.046937, 66.209404 ], [ -164.078765, 66.201764 ], [ -164.092715, 66.184537 ], [ -164.089237, 66.182338 ], [ -164.078677, 66.181019 ], [ -164.007503, 66.179386 ], [ -163.916551, 66.190494 ], [ -163.878306, 66.160279 ], [ -163.861406, 66.136665 ], [ -163.847401, 66.122106 ], [ -163.803580, 66.100059 ], [ -163.772467, 66.081922 ], [ -163.768357, 66.073662 ], [ -163.767510, 66.060803 ], [ -163.623921, 66.058281 ], [ -163.540115, 66.069921 ], [ -163.502704, 66.081165 ], [ -163.495845, 66.085388 ], [ -163.344759, 66.084937 ], [ -163.313843, 66.075287 ], [ -163.287768, 66.069229 ], [ -163.168568, 66.059290 ], [ -163.146726, 66.059487 ], [ -163.093003, 66.062960 ], [ -163.047140, 66.068327 ], [ -162.997473, 66.076845 ], [ -162.876016, 66.082833 ], [ -162.791232, 66.089138 ], [ -162.750705, 66.090160 ], [ -162.681304, 66.061574 ], [ -162.680204, 66.058129 ], [ -162.673584, 66.053685 ], [ -162.635985, 66.040366 ], [ -162.622284, 66.039526 ], [ -162.530755, 66.045062 ], [ -162.457670, 66.058579 ], [ -162.423726, 66.048984 ], [ -162.413452, 66.035085 ], [ -162.391892, 66.028724 ], [ -162.372147, 66.027985 ], [ -162.331284, 66.031403 ], [ -162.269670, 66.042104 ], [ -162.205889, 66.056753 ], [ -162.139516, 66.078819 ], [ -162.137424, 66.078547 ], [ -162.129709, 66.069487 ], [ -162.121788, 66.067391 ], [ -162.025701, 66.062829 ], [ -161.950043, 66.040302 ], [ -161.838018, 66.022582 ], [ -161.817091, 66.033089 ], [ -161.812306, 66.041688 ], [ -161.798585, 66.055317 ], [ -161.775537, 66.073732 ], [ -161.680577, 66.111588 ], [ -161.665300, 66.122177 ], [ -161.627008, 66.153194 ], [ -161.623983, 66.162082 ], [ -161.613943, 66.176693 ], [ -161.548429, 66.239912 ], [ -161.484539, 66.262426 ], [ -161.367875, 66.258653 ], [ -161.341189, 66.255100 ], [ -161.337269, 66.243163 ], [ -161.332120, 66.236431 ], [ -161.320778, 66.223591 ], [ -161.313025, 66.221051 ], [ -161.263655, 66.214154 ], [ -161.198971, 66.210949 ], [ -161.145397, 66.220179 ], [ -161.087342, 66.234208 ], [ -161.067871, 66.235164 ], [ -161.052732, 66.231018 ], [ -161.035866, 66.229437 ], [ -161.000026, 66.233126 ], [ -160.993965, 66.234444 ], [ -160.991066, 66.236816 ], [ -160.990275, 66.239715 ], [ -160.995905, 66.251962 ], [ -160.998540, 66.254935 ], [ -161.061034, 66.283804 ], [ -161.079328, 66.307126 ], [ -161.089161, 66.315140 ], [ -161.107995, 66.328367 ], [ -161.129512, 66.336248 ], [ -161.163100, 66.342291 ], [ -161.219834, 66.348918 ], [ -161.360743, 66.375943 ], [ -161.525554, 66.397046 ], [ -161.694404, 66.396174 ], [ -161.817538, 66.360815 ], [ -161.912946, 66.344436 ], [ -161.916309, 66.349481 ], [ -161.880900, 66.398763 ], [ -161.872447, 66.414132 ], [ -161.863387, 66.440783 ], [ -161.864156, 66.488195 ], [ -161.874880, 66.511446 ], [ -162.029043, 66.586504 ], [ -162.091453, 66.605963 ], [ -162.097910, 66.609863 ], [ -162.105641, 66.622584 ], [ -162.113311, 66.639596 ], [ -162.124348, 66.651291 ], [ -162.140377, 66.664737 ], [ -162.175398, 66.687789 ], [ -162.228635, 66.709770 ], [ -162.268767, 66.717905 ], [ -162.349774, 66.726713 ], [ -162.422414, 66.731581 ], [ -162.501415, 66.742503 ], [ -162.500520, 66.749751 ], [ -162.502502, 66.758875 ], [ -162.512617, 66.777733 ], [ -162.544381, 66.804872 ], [ -162.572224, 66.825364 ], [ -162.594237, 66.837647 ], [ -162.614738, 66.846476 ], [ -162.621564, 66.850860 ], [ -162.624945, 66.855031 ], [ -162.626696, 66.859572 ], [ -162.623054, 66.874325 ], [ -162.614590, 66.885941 ], [ -162.601052, 66.898455 ], [ -162.582856, 66.904292 ], [ -162.497438, 66.919860 ], [ -162.346352, 66.934792 ], [ -162.281116, 66.915679 ], [ -162.271769, 66.904144 ], [ -162.228675, 66.866623 ], [ -162.117304, 66.798482 ], [ -162.096878, 66.788500 ], [ -162.073714, 66.783324 ], [ -162.049123, 66.780639 ], [ -162.013623, 66.779406 ], [ -162.011455, 66.759063 ], [ -162.029615, 66.734580 ], [ -162.041314, 66.723764 ], [ -162.058825, 66.716253 ], [ -162.068253, 66.709857 ], [ -162.074634, 66.703681 ], [ -162.081515, 66.693052 ], [ -162.078010, 66.664048 ], [ -162.073620, 66.651217 ], [ -162.069068, 66.645700 ], [ -162.033156, 66.631585 ], [ -161.968863, 66.602611 ], [ -161.953413, 66.592365 ], [ -161.932642, 66.572547 ], [ -161.925440, 66.561215 ], [ -161.915856, 66.551339 ], [ -161.877098, 66.536877 ], [ -161.765368, 66.496934 ], [ -161.624334, 66.450143 ], [ -161.574129, 66.438566 ], [ -161.516449, 66.441839 ], [ -161.435312, 66.454162 ], [ -161.326349, 66.478371 ], [ -161.279803, 66.505179 ], [ -161.293210, 66.520591 ], [ -161.399006, 66.523529 ], [ -161.454092, 66.522205 ], [ -161.469227, 66.522843 ], [ -161.483604, 66.525626 ], [ -161.493509, 66.530977 ], [ -161.494988, 66.534443 ], [ -161.486308, 66.538037 ], [ -161.482869, 66.543724 ], [ -161.490400, 66.560844 ], [ -161.541756, 66.581379 ], [ -161.598953, 66.593181 ], [ -161.665368, 66.610433 ], [ -161.693125, 66.620562 ], [ -161.866180, 66.704978 ], [ -161.881671, 66.716796 ], [ -161.861540, 66.797076 ], [ -161.846258, 66.813647 ], [ -161.824170, 66.817889 ], [ -161.796307, 66.833126 ], [ -161.785495, 66.846547 ], [ -161.782218, 66.859956 ], [ -161.719587, 66.916898 ], [ -161.692146, 66.945033 ], [ -161.685775, 66.955794 ], [ -161.688506, 66.959799 ], [ -161.686280, 66.961367 ], [ -161.674359, 66.961965 ], [ -161.566678, 66.934775 ], [ -161.489169, 66.936950 ], [ -161.485121, 66.945647 ], [ -161.485383, 66.960818 ], [ -161.505747, 66.974314 ], [ -161.530525, 66.984951 ], [ -161.622160, 67.008146 ], [ -161.697392, 67.010849 ], [ -161.711715, 67.001044 ], [ -161.759641, 67.030572 ], [ -161.799175, 67.047502 ], [ -161.810256, 67.050281 ], [ -161.836325, 67.051777 ], [ -161.850188, 67.052186 ], [ -161.893702, 67.049075 ], [ -162.123181, 67.025790 ], [ -162.211633, 67.006710 ], [ -162.233964, 66.999568 ], [ -162.234302, 66.994581 ], [ -162.239230, 66.993814 ], [ -162.353954, 66.995128 ], [ -162.385074, 66.991235 ], [ -162.415866, 66.984710 ], [ -162.432615, 66.985089 ], [ -162.449219, 66.988391 ], [ -162.462616, 66.994323 ], [ -162.466855, 66.999339 ], [ -162.461822, 67.004426 ], [ -162.465522, 67.026629 ], [ -162.472765, 67.038368 ], [ -162.481257, 67.043113 ], [ -162.490552, 67.043331 ], [ -162.504523, 67.039629 ], [ -162.514878, 67.031069 ], [ -162.519046, 67.016552 ], [ -162.603562, 67.010490 ], [ -162.640260, 67.010869 ], [ -162.654094, 67.013099 ], [ -162.661661, 67.018890 ], [ -162.660733, 67.026771 ], [ -162.658706, 67.030335 ], [ -162.660740, 67.033884 ], [ -162.676656, 67.046789 ], [ -162.699069, 67.055476 ], [ -162.782401, 67.044467 ], [ -162.830420, 67.036173 ], [ -162.839402, 67.032956 ], [ -162.850964, 67.017922 ], [ -162.865944, 67.012543 ], [ -162.901348, 67.006833 ], [ -163.097854, 67.041191 ], [ -163.299266, 67.060748 ], [ -163.399048, 67.074167 ], [ -163.441198, 67.081459 ], [ -163.495201, 67.087503 ], [ -163.577010, 67.092491 ], [ -163.624959, 67.099391 ], [ -163.698870, 67.114443 ], [ -163.730671, 67.123774 ], [ -163.741345, 67.129123 ], [ -163.737724, 67.136802 ], [ -163.736901, 67.163230 ], [ -163.737464, 67.184754 ], [ -163.740820, 67.209960 ], [ -163.758588, 67.256439 ], [ -163.822185, 67.349812 ], [ -163.853584, 67.388101 ], [ -163.878781, 67.416125 ], [ -164.007032, 67.535699 ], [ -164.079514, 67.585856 ], [ -164.108716, 67.601993 ], [ -164.144380, 67.617228 ], [ -164.209816, 67.639079 ], [ -164.533937, 67.725606 ], [ -164.778331, 67.820866 ], [ -164.907297, 67.867844 ], [ -165.057516, 67.921694 ], [ -165.129567, 67.941833 ], [ -165.190915, 67.966071 ], [ -165.227228, 67.985322 ], [ -165.231620, 67.994512 ], [ -165.240848, 67.998714 ], [ -165.359980, 68.028054 ], [ -165.430442, 68.045408 ], [ -165.493550, 68.059283 ], [ -165.661690, 68.075999 ], [ -165.749518, 68.077694 ], [ -165.792146, 68.080867 ], [ -165.863428, 68.093367 ], [ -165.965534, 68.121920 ], [ -165.973621, 68.125986 ], [ -165.987929, 68.142738 ], [ -165.994377, 68.147305 ], [ -166.245281, 68.245275 ], [ -166.307977, 68.264948 ], [ -166.368546, 68.281770 ], [ -166.474608, 68.305273 ], [ -166.567220, 68.323288 ], [ -166.680842, 68.340911 ], [ -166.784578, 68.340431 ], [ -166.829715, 68.336324 ], [ -166.846456, 68.332508 ], [ -166.850640, 68.333089 ], [ -166.838178, 68.339714 ], [ -166.811836, 68.348136 ], [ -166.706139, 68.371783 ], [ -166.377564, 68.422406 ], [ -166.362135, 68.426240 ], [ -166.342381, 68.433966 ], [ -166.328459, 68.442261 ], [ -166.305962, 68.461540 ], [ -166.303464, 68.464683 ], [ -166.302030, 68.470413 ], [ -166.295343, 68.510900 ], [ -166.244490, 68.553888 ], [ -166.233780, 68.564263 ], [ -166.226111, 68.576186 ], [ -166.225567, 68.579015 ], [ -166.231432, 68.587338 ], [ -166.229761, 68.613771 ], [ -166.213635, 68.664324 ], [ -166.199826, 68.678556 ], [ -166.197365, 68.690019 ], [ -166.187795, 68.778706 ], [ -166.190209, 68.790437 ], [ -166.195374, 68.803990 ], [ -166.203750, 68.818221 ], [ -166.222496, 68.860441 ], [ -166.224187, 68.873175 ], [ -166.214433, 68.879524 ], [ -165.814938, 68.864158 ], [ -165.666566, 68.855387 ], [ -165.572483, 68.852946 ], [ -165.522358, 68.855839 ], [ -165.327043, 68.858111 ], [ -164.967542, 68.883030 ], [ -164.883745, 68.891649 ], [ -164.812671, 68.893542 ], [ -164.655317, 68.909360 ], [ -164.526887, 68.917909 ], [ -164.299092, 68.927569 ], [ -164.253157, 68.930938 ], [ -164.161249, 68.944773 ], [ -164.130742, 68.951001 ], [ -164.069362, 68.969651 ], [ -163.973678, 68.985044 ], [ -163.893881, 69.011962 ], [ -163.858069, 69.028860 ], [ -163.827447, 69.040632 ], [ -163.724184, 69.066713 ], [ -163.655864, 69.090567 ], [ -163.574034, 69.124077 ], [ -163.535314, 69.141656 ], [ -163.452685, 69.194630 ], [ -163.297956, 69.274725 ], [ -163.236121, 69.282661 ], [ -163.230902, 69.284464 ], [ -163.137614, 69.352178 ], [ -163.110318, 69.375343 ], [ -163.103166, 69.392261 ], [ -163.104387, 69.401350 ], [ -163.100569, 69.414222 ], [ -163.070341, 69.459872 ], [ -163.052068, 69.481971 ], [ -163.046961, 69.482892 ], [ -163.036311, 69.489028 ], [ -163.026170, 69.506890 ], [ -163.016456, 69.538142 ], [ -163.020001, 69.545145 ], [ -163.030290, 69.556591 ], [ -163.074128, 69.570272 ], [ -163.118176, 69.589156 ], [ -163.116622, 69.593416 ], [ -163.111605, 69.596605 ], [ -163.024590, 69.608609 ], [ -162.916958, 69.692512 ], [ -162.922009, 69.700372 ], [ -162.961086, 69.717165 ], [ -163.010545, 69.728109 ], [ -163.018175, 69.729074 ], [ -163.035390, 69.727406 ], [ -163.012595, 69.757462 ], [ -162.960245, 69.783328 ], [ -162.911869, 69.799471 ], [ -162.877165, 69.804411 ], [ -162.840602, 69.811763 ], [ -162.767210, 69.852179 ], [ -162.709550, 69.879126 ], [ -162.616345, 69.916997 ], [ -162.606297, 69.918988 ], [ -162.601284, 69.914568 ], [ -162.593773, 69.914096 ], [ -162.587906, 69.915637 ], [ -162.481016, 69.975242 ], [ -162.471549, 69.983132 ], [ -162.462304, 70.002438 ], [ -162.468339, 70.015784 ], [ -162.462778, 70.042217 ], [ -162.454541, 70.043958 ], [ -162.394531, 70.044574 ], [ -162.350558, 70.058800 ], [ -162.354740, 70.065479 ], [ -162.356469, 70.076391 ], [ -162.312491, 70.109281 ], [ -162.158156, 70.161530 ], [ -162.098377, 70.187045 ], [ -162.019265, 70.224044 ], [ -161.984888, 70.247681 ], [ -161.959603, 70.268873 ], [ -161.922949, 70.291599 ], [ -161.859745, 70.308048 ], [ -161.849998, 70.309430 ], [ -161.844213, 70.308530 ], [ -161.842162, 70.304429 ], [ -161.844688, 70.300054 ], [ -161.847403, 70.295877 ], [ -161.848909, 70.282183 ], [ -161.834651, 70.272504 ], [ -161.801603, 70.260634 ], [ -161.779794, 70.255411 ], [ -161.769496, 70.262498 ], [ -161.767838, 70.268337 ], [ -161.759176, 70.272443 ], [ -161.692195, 70.267092 ], [ -161.676220, 70.258021 ], [ -161.663593, 70.246187 ], [ -161.633888, 70.240693 ], [ -161.522941, 70.236888 ], [ -161.396757, 70.240606 ], [ -161.309118, 70.248091 ], [ -161.254723, 70.256612 ], [ -161.080282, 70.306679 ], [ -161.016416, 70.327744 ], [ -160.992764, 70.316226 ], [ -160.979126, 70.317661 ], [ -160.839536, 70.344534 ], [ -160.732703, 70.374382 ], [ -160.530362, 70.440751 ], [ -160.489778, 70.454463 ], [ -160.485530, 70.457121 ], [ -160.480062, 70.465971 ], [ -160.214828, 70.559087 ], [ -160.056727, 70.632834 ], [ -159.913805, 70.690673 ], [ -159.798514, 70.731226 ], [ -159.648383, 70.794368 ], [ -159.585714, 70.809475 ], [ -159.528682, 70.820849 ], [ -159.209082, 70.870067 ], [ -159.171810, 70.875103 ], [ -159.147634, 70.876653 ], [ -159.156511, 70.859221 ], [ -159.152026, 70.849543 ], [ -159.132483, 70.828359 ], [ -159.160836, 70.817960 ], [ -159.290577, 70.811262 ], [ -159.331021, 70.807394 ], [ -159.335837, 70.800079 ], [ -159.343075, 70.783115 ], [ -159.299304, 70.760012 ], [ -159.275634, 70.759531 ], [ -159.137790, 70.758609 ], [ -159.000676, 70.764336 ], [ -158.976647, 70.766973 ], [ -158.954571, 70.772712 ], [ -158.965600, 70.786852 ], [ -158.976456, 70.789864 ], [ -158.976615, 70.796377 ], [ -158.656101, 70.787955 ], [ -158.607320, 70.789099 ], [ -158.389500, 70.799729 ], [ -158.385792, 70.811468 ], [ -158.389269, 70.822048 ], [ -158.385816, 70.825704 ], [ -158.250320, 70.817734 ], [ -158.157725, 70.820806 ], [ -158.032397, 70.832263 ], [ -157.884086, 70.853468 ], [ -157.840997, 70.861025 ], [ -157.768452, 70.875842 ], [ -157.708782, 70.891390 ], [ -157.502459, 70.948659 ], [ -157.421001, 70.976805 ], [ -157.392802, 70.987908 ], [ -157.249083, 71.052537 ], [ -157.119621, 71.128682 ], [ -157.072487, 71.154521 ], [ -156.962555, 71.211885 ], [ -156.809653, 71.286886 ], [ -156.773937, 71.299506 ], [ -156.645615, 71.338012 ], [ -156.620140, 71.344209 ], [ -156.568650, 71.352561 ], [ -156.566383, 71.334016 ], [ -156.561512, 71.316809 ], [ -156.556496, 71.311795 ], [ -156.531124, 71.296338 ], [ -156.524499, 71.294469 ], [ -156.402659, 71.267945 ], [ -156.356736, 71.261273 ], [ -156.320702, 71.258952 ], [ -156.301938, 71.260566 ], [ -156.214200, 71.259392 ], [ -156.074411, 71.242489 ], [ -156.029205, 71.203209 ], [ -156.038116, 71.196506 ], [ -156.044754, 71.186770 ], [ -156.044615, 71.184701 ], [ -156.018574, 71.172041 ], [ -155.957961, 71.186211 ], [ -155.920202, 71.207157 ], [ -155.895105, 71.193899 ], [ -155.884180, 71.190057 ], [ -155.829034, 71.192088 ], [ -155.803853, 71.196420 ], [ -155.760802, 71.194662 ], [ -155.657178, 71.182471 ], [ -155.587702, 71.172560 ], [ -155.566925, 71.165139 ], [ -155.567765, 71.141130 ], [ -155.561772, 71.128458 ], [ -155.520737, 71.102476 ], [ -155.513987, 71.096794 ], [ -155.511125, 71.090348 ], [ -155.510637, 71.081152 ], [ -155.533347, 71.067683 ], [ -155.548283, 71.060685 ], [ -155.638994, 71.042360 ], [ -155.705487, 71.020153 ], [ -155.711852, 71.012473 ], [ -155.762068, 70.985644 ], [ -155.830881, 70.965584 ], [ -155.878946, 70.967684 ], [ -155.952050, 70.964831 ], [ -155.978405, 70.962197 ], [ -155.995681, 70.947796 ], [ -156.014769, 70.903133 ], [ -156.014425, 70.898644 ], [ -156.013512, 70.895983 ], [ -155.968559, 70.862931 ], [ -155.969194, 70.827982 ], [ -155.978421, 70.825558 ], [ -155.980975, 70.817355 ], [ -155.978978, 70.808750 ], [ -155.971935, 70.806828 ], [ -155.927958, 70.806010 ], [ -155.906615, 70.809988 ], [ -155.882145, 70.822056 ], [ -155.875096, 70.828895 ], [ -155.731842, 70.831160 ], [ -155.643516, 70.824209 ], [ -155.543031, 70.847175 ], [ -155.504202, 70.860303 ], [ -155.489811, 70.871740 ], [ -155.487980, 70.875299 ], [ -155.485915, 70.885905 ], [ -155.487574, 70.902679 ], [ -155.493044, 70.917371 ], [ -155.475940, 70.943547 ], [ -155.454991, 70.947490 ], [ -155.404225, 70.967477 ], [ -155.382646, 70.978973 ], [ -155.364160, 70.994195 ], [ -155.343871, 71.004449 ], [ -155.260042, 71.015227 ], [ -155.260084, 71.011281 ], [ -155.256177, 71.004762 ], [ -155.211434, 70.978023 ], [ -155.201466, 70.974306 ], [ -155.192246, 70.974056 ], [ -155.182779, 70.978218 ], [ -155.168934, 70.987947 ], [ -155.161735, 70.995715 ], [ -155.159922, 71.002775 ], [ -155.163938, 71.013801 ], [ -155.177000, 71.027450 ], [ -155.273764, 71.064728 ], [ -155.275814, 71.067042 ], [ -155.275989, 71.070464 ], [ -155.262602, 71.079149 ], [ -155.256860, 71.081119 ], [ -155.150524, 71.112050 ], [ -155.146948, 71.110959 ], [ -155.146931, 71.103459 ], [ -155.142858, 71.097254 ], [ -155.125994, 71.077495 ], [ -155.120317, 71.073416 ], [ -155.108509, 71.070475 ], [ -155.075362, 71.072042 ], [ -155.064004, 71.083912 ], [ -155.061428, 71.091999 ], [ -155.064558, 71.108006 ], [ -155.085782, 71.127572 ], [ -155.060764, 71.145422 ], [ -155.031740, 71.146473 ], [ -154.942864, 71.126264 ], [ -154.777335, 71.083231 ], [ -154.616050, 71.026182 ], [ -154.604413, 71.021502 ], [ -154.581129, 71.007321 ], [ -154.567593, 70.989929 ], [ -154.594048, 70.976993 ], [ -154.608294, 70.961716 ], [ -154.654375, 70.903318 ], [ -154.645793, 70.869167 ], [ -154.577386, 70.835335 ], [ -154.519040, 70.822799 ], [ -154.501866, 70.821765 ], [ -154.485700, 70.825304 ], [ -154.430229, 70.831258 ], [ -154.352604, 70.834828 ], [ -154.260799, 70.815164 ], [ -154.228627, 70.802417 ], [ -154.223307, 70.795230 ], [ -154.239166, 70.776866 ], [ -154.181863, 70.768325 ], [ -154.169631, 70.768604 ], [ -154.127487, 70.778133 ], [ -154.069982, 70.793703 ], [ -153.995579, 70.821876 ], [ -153.976014, 70.833925 ], [ -153.951370, 70.854028 ], [ -153.935450, 70.869728 ], [ -153.932949, 70.874201 ], [ -153.934351, 70.876609 ], [ -153.932921, 70.878677 ], [ -153.890480, 70.885719 ], [ -153.774169, 70.894584 ], [ -153.747253, 70.895017 ], [ -153.525976, 70.885500 ], [ -153.485989, 70.885873 ], [ -153.426265, 70.890131 ], [ -153.359112, 70.898292 ], [ -153.326202, 70.904111 ], [ -153.253386, 70.920775 ], [ -153.238480, 70.922467 ], [ -153.137311, 70.925438 ], [ -153.049207, 70.913102 ], [ -153.017038, 70.904004 ], [ -152.774415, 70.885279 ], [ -152.735892, 70.884545 ], [ -152.590148, 70.886933 ], [ -152.456950, 70.871788 ], [ -152.259966, 70.842820 ], [ -152.226464, 70.831043 ], [ -152.187197, 70.801546 ], [ -152.188649, 70.798140 ], [ -152.192460, 70.795294 ], [ -152.239344, 70.793416 ], [ -152.263346, 70.790777 ], [ -152.283763, 70.785600 ], [ -152.370808, 70.730068 ], [ -152.377274, 70.714682 ], [ -152.471531, 70.688840 ], [ -152.473348, 70.683669 ], [ -152.460505, 70.646107 ], [ -152.433781, 70.616926 ], [ -152.420775, 70.608983 ], [ -152.365736, 70.601242 ], [ -152.355679, 70.603794 ], [ -152.341592, 70.612193 ], [ -152.332608, 70.612871 ], [ -152.264049, 70.592655 ], [ -152.200644, 70.586070 ], [ -152.169944, 70.585219 ], [ -152.146165, 70.586754 ], [ -152.060684, 70.574935 ], [ -152.064546, 70.568542 ], [ -152.065748, 70.563074 ], [ -152.026070, 70.559345 ], [ -151.975785, 70.563215 ], [ -151.880141, 70.554869 ], [ -151.816701, 70.545698 ], [ -151.774703, 70.547925 ], [ -151.745047, 70.554041 ], [ -151.718215, 70.555286 ], [ -151.701467, 70.553220 ], [ -151.695162, 70.549675 ], [ -151.697258, 70.547741 ], [ -151.709462, 70.546490 ], [ -151.722711, 70.541608 ], [ -151.751558, 70.524105 ], [ -151.760248, 70.516711 ], [ -151.734287, 70.503492 ], [ -151.728579, 70.495375 ], [ -151.775537, 70.485353 ], [ -151.824111, 70.484011 ], [ -151.919210, 70.472686 ], [ -151.936783, 70.463564 ], [ -151.946384, 70.452523 ], [ -151.900033, 70.434135 ], [ -151.876122, 70.430761 ], [ -151.844375, 70.434959 ], [ -151.785657, 70.436935 ], [ -151.653184, 70.434800 ], [ -151.605581, 70.437332 ], [ -151.554647, 70.435895 ], [ -151.444897, 70.425405 ], [ -151.343202, 70.408877 ], [ -151.297598, 70.400748 ], [ -151.229919, 70.379840 ], [ -151.187394, 70.384775 ], [ -151.188592, 70.401755 ], [ -151.186516, 70.418208 ], [ -151.180436, 70.430401 ], [ -151.123105, 70.439374 ], [ -151.118601, 70.438088 ], [ -151.114352, 70.432886 ], [ -151.116099, 70.422403 ], [ -151.060430, 70.418734 ], [ -151.026337, 70.441455 ], [ -150.957813, 70.452610 ], [ -150.895452, 70.458158 ], [ -150.877322, 70.455182 ], [ -150.834973, 70.460171 ], [ -150.787069, 70.477117 ], [ -150.780029, 70.485986 ], [ -150.762035, 70.497219 ], [ -150.719845, 70.494998 ], [ -150.651175, 70.494928 ], [ -150.614734, 70.498292 ], [ -150.429915, 70.498172 ], [ -150.357384, 70.493738 ], [ -150.354056, 70.492724 ], [ -150.338851, 70.471075 ], [ -150.370283, 70.447858 ], [ -150.350541, 70.435998 ], [ -150.296287, 70.441136 ], [ -150.245325, 70.441658 ], [ -150.185078, 70.435370 ], [ -150.112899, 70.431372 ], [ -150.104388, 70.432091 ], [ -150.074461, 70.439333 ], [ -149.866698, 70.510769 ], [ -149.819740, 70.491428 ], [ -149.810924, 70.490477 ], [ -149.790427, 70.491190 ], [ -149.740188, 70.498151 ], [ -149.728247, 70.502793 ], [ -149.716075, 70.504968 ], [ -149.661165, 70.509203 ], [ -149.656806, 70.508713 ], [ -149.649556, 70.504757 ], [ -149.581348, 70.495891 ], [ -149.565278, 70.496450 ], [ -149.536891, 70.499397 ], [ -149.524235, 70.502128 ], [ -149.509854, 70.508746 ], [ -149.461755, 70.518271 ], [ -149.432083, 70.503750 ], [ -149.418727, 70.492257 ], [ -149.400623, 70.489931 ], [ -149.314473, 70.495325 ], [ -149.179148, 70.485700 ], [ -149.082079, 70.464894 ], [ -148.959443, 70.423944 ], [ -148.928979, 70.426835 ], [ -148.858069, 70.422917 ], [ -148.789577, 70.402746 ], [ -148.728082, 70.413035 ], [ -148.698770, 70.425878 ], [ -148.696768, 70.429160 ], [ -148.667017, 70.430084 ], [ -148.610566, 70.422588 ], [ -148.590007, 70.416956 ], [ -148.580356, 70.412546 ], [ -148.477044, 70.359068 ], [ -148.464543, 70.340159 ], [ -148.477028, 70.320872 ], [ -148.466150, 70.313609 ], [ -148.450639, 70.308437 ], [ -148.411253, 70.302627 ], [ -148.363196, 70.302627 ], [ -148.351437, 70.304453 ], [ -148.269800, 70.329617 ], [ -148.258200, 70.336996 ], [ -148.203477, 70.348188 ], [ -148.152676, 70.347148 ], [ -148.107231, 70.342801 ], [ -148.090580, 70.337432 ], [ -148.089576, 70.335423 ], [ -148.089676, 70.332812 ], [ -148.089174, 70.331005 ], [ -148.076865, 70.327510 ], [ -147.961500, 70.314201 ], [ -147.863719, 70.293317 ], [ -147.817637, 70.276938 ], [ -147.789357, 70.247972 ], [ -147.765104, 70.219806 ], [ -147.681722, 70.199954 ], [ -147.648000, 70.203299 ], [ -147.585678, 70.203398 ], [ -147.505270, 70.200384 ], [ -147.431532, 70.188826 ], [ -147.402283, 70.185273 ], [ -147.385271, 70.185256 ], [ -147.350145, 70.187683 ], [ -147.244119, 70.218963 ], [ -147.233327, 70.207553 ], [ -147.231008, 70.195398 ], [ -147.219210, 70.178826 ], [ -147.182123, 70.160350 ], [ -147.161601, 70.155612 ], [ -146.991109, 70.147610 ], [ -146.973212, 70.151857 ], [ -146.909516, 70.173259 ], [ -146.885771, 70.185917 ], [ -146.734021, 70.175475 ], [ -146.713053, 70.175398 ], [ -146.624761, 70.182398 ], [ -146.508133, 70.186044 ], [ -146.448860, 70.183398 ], [ -146.413197, 70.178250 ], [ -146.335147, 70.176235 ], [ -146.309558, 70.178907 ], [ -146.272965, 70.176944 ], [ -146.172672, 70.165894 ], [ -146.129579, 70.158948 ], [ -146.114124, 70.154956 ], [ -146.096827, 70.145151 ], [ -146.006411, 70.140402 ], [ -145.955164, 70.140199 ], [ -145.917674, 70.142525 ], [ -145.872923, 70.148829 ], [ -145.858297, 70.165996 ], [ -145.842689, 70.164102 ], [ -145.790386, 70.148569 ], [ -145.783327, 70.139454 ], [ -145.767092, 70.128717 ], [ -145.760443, 70.126113 ], [ -145.623306, 70.084375 ], [ -145.579972, 70.076804 ], [ -145.522384, 70.077465 ], [ -145.505682, 70.074528 ], [ -145.469508, 70.059136 ], [ -145.468856, 70.048336 ], [ -145.434830, 70.036994 ], [ -145.408182, 70.031572 ], [ -145.331553, 70.022596 ], [ -145.247167, 70.017891 ], [ -145.218593, 70.007280 ], [ -145.197331, 69.994954 ], [ -145.175073, 69.991707 ], [ -145.011711, 69.981144 ], [ -144.990131, 69.977680 ], [ -144.966761, 69.964362 ], [ -144.953637, 69.959262 ], [ -144.902304, 69.964510 ], [ -144.867623, 69.972266 ], [ -144.863111, 69.973524 ], [ -144.856954, 69.985987 ], [ -144.854539, 69.986364 ], [ -144.792614, 69.979796 ], [ -144.738976, 69.970112 ], [ -144.672305, 69.966876 ], [ -144.618671, 69.969315 ], [ -144.589172, 69.977611 ], [ -144.512258, 70.004478 ], [ -144.463286, 70.025735 ], [ -144.344073, 70.034374 ], [ -144.328391, 70.032555 ], [ -144.231051, 70.035912 ], [ -144.178194, 70.041742 ], [ -144.130283, 70.057951 ], [ -144.122641, 70.059138 ], [ -144.079634, 70.058961 ], [ -144.053709, 70.073182 ], [ -143.911494, 70.129837 ], [ -143.887688, 70.130736 ], [ -143.839879, 70.125827 ], [ -143.782213, 70.124668 ], [ -143.769015, 70.135066 ], [ -143.753065, 70.137242 ], [ -143.662250, 70.142517 ], [ -143.617407, 70.139915 ], [ -143.595181, 70.142521 ], [ -143.597879, 70.147204 ], [ -143.593813, 70.152604 ], [ -143.574986, 70.154598 ], [ -143.543230, 70.149742 ], [ -143.498058, 70.140100 ], [ -143.497982, 70.136875 ], [ -143.511617, 70.125191 ], [ -143.516098, 70.116362 ], [ -143.517248, 70.104293 ], [ -143.510081, 70.096436 ], [ -143.503487, 70.093458 ], [ -143.455354, 70.092934 ], [ -143.357961, 70.094970 ], [ -143.327114, 70.103127 ], [ -143.317900, 70.111145 ], [ -143.265892, 70.119286 ], [ -143.255576, 70.119330 ], [ -143.200147, 70.110323 ], [ -143.159929, 70.099203 ], [ -143.140019, 70.092997 ], [ -143.112951, 70.078271 ], [ -143.051291, 70.078188 ], [ -143.038100, 70.093888 ], [ -142.939555, 70.074380 ], [ -142.746807, 70.042531 ], [ -142.498036, 69.973611 ], [ -142.452927, 69.958125 ], [ -142.409962, 69.933646 ], [ -142.404366, 69.916511 ], [ -142.272156, 69.907044 ], [ -142.239873, 69.896598 ], [ -142.112714, 69.862162 ], [ -142.081696, 69.855498 ], [ -142.075612, 69.853319 ], [ -142.073063, 69.846625 ], [ -142.058734, 69.835330 ], [ -142.009321, 69.800726 ], [ -141.960753, 69.799876 ], [ -141.937176, 69.804805 ], [ -141.919828, 69.811308 ], [ -141.866738, 69.813005 ], [ -141.842843, 69.811927 ], [ -141.713369, 69.789497 ], [ -141.606229, 69.761695 ], [ -141.528197, 69.736025 ], [ -141.430840, 69.695144 ], [ -141.434872, 69.675245 ], [ -141.428856, 69.662658 ], [ -141.394082, 69.640846 ], [ -141.377718, 69.634631 ], [ -141.280849, 69.631025 ], [ -141.258558, 69.632247 ], [ -141.254547, 69.637053 ], [ -141.243946, 69.652482 ], [ -141.210456, 69.684190 ], [ -141.119233, 69.673527 ], [ -141.002672, 69.645609 ], [ -141.002694, 68.498391 ], [ -141.002465, 65.840075 ], [ -141.002465, 65.839421 ], [ -141.002020, 61.901922 ], [ -141.001850, 60.391688 ], [ -141.001840, 60.306105 ], [ -140.535090, 60.224224 ], [ -140.472292, 60.310590 ], [ -139.989142, 60.185240 ], [ -139.698361, 60.340421 ], [ -139.086669, 60.357654 ], [ -139.082246, 60.323825 ], [ -139.200346, 60.090701 ], [ -139.046426, 59.998235 ], [ -138.796083, 59.928701 ], [ -138.702053, 59.910245 ], [ -138.662769, 59.813719 ], [ -138.662972, 59.810225 ], [ -138.620931, 59.770559 ], [ -138.560226, 59.741201 ], [ -138.001128, 59.452164 ], [ -137.604277, 59.243057 ], [ -137.498558, 58.986694 ], [ -137.526424, 58.906834 ], [ -137.525295, 58.906872 ], [ -137.447383, 58.909513 ], [ -137.264752, 59.002352 ], [ -136.863896, 59.138472 ], [ -136.826633, 59.158389 ], [ -136.581521, 59.164909 ], [ -136.486609, 59.261108 ], [ -136.466815, 59.284252 ], [ -136.472941, 59.421683 ], [ -136.365825, 59.448008 ], [ -136.358141, 59.449799 ], [ -136.301846, 59.464128 ], [ -136.234229, 59.524731 ], [ -136.237340, 59.558734 ], [ -136.225748, 59.604573 ], [ -136.190352, 59.639854 ], [ -136.005158, 59.658160 ], [ -135.854166, 59.691846 ], [ -135.722460, 59.729526 ], [ -135.477436, 59.799626 ], [ -135.284921, 59.714893 ], [ -135.166736, 59.632240 ], [ -135.153113, 59.625159 ], [ -135.114588, 59.623415 ], [ -135.027456, 59.563692 ], [ -135.029769, 59.482444 ], [ -135.040037, 59.444792 ], [ -135.029769, 59.407140 ], [ -135.005180, 59.357217 ], [ -134.992117, 59.330695 ], [ -134.961972, 59.280376 ], [ -134.766204, 59.231430 ], [ -134.681924, 59.190843 ], [ -134.566689, 59.128278 ], [ -134.481241, 59.128071 ], [ -134.389798, 59.032673 ], [ -134.383637, 59.001867 ], [ -134.369945, 58.971745 ], [ -134.363773, 58.963891 ], [ -134.328964, 58.919593 ], [ -134.250526, 58.858046 ], [ -133.992081, 58.774581 ], [ -133.840392, 58.727991 ], [ -133.723635, 58.626004 ], [ -133.699835, 58.607290 ], [ -133.559942, 58.522318 ], [ -133.443373, 58.442415 ], [ -133.436075, 58.391324 ], [ -133.437696, 58.358074 ], [ -133.359691, 58.284789 ], [ -133.343725, 58.270915 ], [ -133.222898, 58.186368 ], [ -133.176444, 58.150151 ], [ -133.076421, 57.999762 ], [ -132.869318, 57.842941 ], [ -132.756813, 57.705093 ], [ -132.658124, 57.619486 ], [ -132.559178, 57.503927 ], [ -132.367984, 57.348685 ], [ -132.252187, 57.215655 ], [ -132.214442, 57.108167 ], [ -132.115075, 57.045602 ], [ -132.080112, 56.924153 ], [ -132.005107, 56.842920 ], [ -131.936582, 56.817425 ], [ -131.886500, 56.776083 ], [ -131.818813, 56.664694 ], [ -131.736007, 56.613170 ], [ -131.581221, 56.613275 ], [ -131.428413, 56.537135 ], [ -131.167925, 56.448361 ], [ -131.087433, 56.407420 ], [ -131.085704, 56.406540 ], [ -130.782231, 56.367511 ], [ -130.740619, 56.342953 ], [ -130.622482, 56.267939 ], [ -130.541173, 56.248017 ], [ -130.466874, 56.239789 ], [ -130.425575, 56.140676 ], [ -130.245540, 56.096876 ], [ -130.102761, 56.116696 ], [ -130.031573, 56.036791 ], [ -130.016874, 56.017323 ], [ -130.004260, 55.993379 ], [ -130.013198, 55.916382 ], [ -130.084510, 55.823997 ], [ -130.123720, 55.807040 ], [ -130.128538, 55.802148 ], [ -130.150595, 55.767031 ], [ -130.151509, 55.746029 ], [ -130.150061, 55.727099 ], [ -130.148040, 55.715041 ], [ -130.129518, 55.699806 ], [ -130.111677, 55.682051 ], [ -130.126743, 55.581282 ], [ -130.120132, 55.563919 ], [ -130.085413, 55.491517 ], [ -130.044303, 55.451970 ], [ -130.030182, 55.367696 ], [ -130.023558, 55.338259 ], [ -129.982348, 55.302079 ], [ -129.980487, 55.296334 ], [ -129.980058, 55.284230 ], [ -129.985379, 55.277760 ], [ -130.001735, 55.264557 ], [ -130.030162, 55.246592 ], [ -130.096546, 55.197953 ], [ -130.118919, 55.176074 ], [ -130.144723, 55.146038 ], [ -130.158117, 55.117104 ], [ -130.187541, 55.064665 ], [ -130.221512, 55.025990 ], [ -130.259079, 54.987642 ], [ -130.275560, 54.972930 ], [ -130.339504, 54.921376 ], [ -130.474605, 54.838102 ], [ -130.569366, 54.790869 ], [ -130.636745, 54.778456 ], [ -130.657754, 54.761828 ], [ -130.628070, 54.739341 ], [ -130.644479, 54.736897 ], [ -130.685213, 54.720091 ], [ -130.686192, 54.716910 ], [ -130.695817, 54.719346 ], [ -130.737423, 54.753545 ], [ -130.747227, 54.772600 ], [ -130.733209, 54.779610 ], [ -130.732201, 54.782620 ], [ -130.736295, 54.794798 ], [ -130.742316, 54.801914 ], [ -130.773606, 54.820845 ], [ -130.787444, 54.822905 ], [ -130.788570, 54.794643 ], [ -130.792122, 54.784784 ], [ -130.806815, 54.776862 ], [ -130.836853, 54.765437 ], [ -130.854966, 54.766341 ], [ -130.866866, 54.769068 ], [ -130.901801, 54.780876 ], [ -130.915936, 54.789617 ], [ -130.932454, 54.806938 ], [ -130.947098, 54.826047 ], [ -130.941029, 54.841587 ], [ -130.947338, 54.886733 ], [ -130.959732, 54.918678 ], [ -130.960400, 54.933685 ], [ -130.949104, 54.967846 ], [ -130.953507, 54.972102 ], [ -130.975030, 54.974853 ], [ -131.007787, 54.991300 ], [ -131.012061, 54.996238 ], [ -131.004216, 55.029605 ], [ -130.986802, 55.065222 ], [ -130.983730, 55.068946 ], [ -130.984157, 55.084410 ], [ -131.013215, 55.090069 ], [ -131.029676, 55.099478 ], [ -131.052298, 55.118160 ], [ -131.070692, 55.138143 ], [ -131.076646, 55.146178 ], [ -131.085579, 55.158233 ], [ -131.087497, 55.163036 ], [ -131.093806, 55.191335 ], [ -131.092605, 55.192711 ], [ -130.985304, 55.247286 ], [ -130.952956, 55.273092 ], [ -130.951572, 55.291648 ], [ -130.925069, 55.300713 ], [ -130.909948, 55.299878 ], [ -130.871329, 55.293780 ], [ -130.864918, 55.298367 ], [ -130.864918, 55.309469 ], [ -130.871857, 55.313991 ], [ -130.882146, 55.358831 ], [ -130.920800, 55.428721 ], [ -130.922985, 55.435113 ], [ -130.920295, 55.446085 ], [ -130.910744, 55.459982 ], [ -130.898129, 55.470177 ], [ -130.881297, 55.495582 ], [ -130.870524, 55.533768 ], [ -130.880013, 55.598954 ], [ -130.901872, 55.697380 ], [ -130.939017, 55.754831 ], [ -130.984774, 55.799349 ], [ -131.093956, 55.895675 ], [ -131.171406, 55.942952 ], [ -131.187429, 55.956010 ], [ -131.216475, 55.984342 ], [ -131.229971, 55.984342 ], [ -131.236936, 55.982293 ], [ -131.243491, 55.973689 ], [ -131.245949, 55.965905 ], [ -131.241704, 55.955069 ], [ -131.156834, 55.901147 ], [ -131.070138, 55.828551 ], [ -131.053217, 55.799843 ], [ -131.043527, 55.766997 ], [ -131.040966, 55.762837 ], [ -130.998638, 55.723538 ], [ -130.965994, 55.688974 ], [ -130.946830, 55.650716 ], [ -130.927651, 55.576585 ], [ -130.945177, 55.557731 ], [ -130.978917, 55.550835 ], [ -130.987103, 55.539872 ], [ -130.994376, 55.472396 ], [ -130.969588, 55.393281 ], [ -130.947498, 55.380823 ], [ -130.928172, 55.339426 ], [ -130.933399, 55.331906 ], [ -130.946597, 55.322396 ], [ -130.959772, 55.315892 ], [ -130.968326, 55.316626 ], [ -130.964088, 55.332664 ], [ -131.000594, 55.398012 ], [ -131.008726, 55.404818 ], [ -131.029045, 55.408395 ], [ -131.033054, 55.393118 ], [ -131.034191, 55.379358 ], [ -131.030521, 55.376917 ], [ -131.027301, 55.371392 ], [ -131.019881, 55.347905 ], [ -131.031357, 55.284785 ], [ -131.072348, 55.253822 ], [ -131.160492, 55.197481 ], [ -131.188747, 55.192745 ], [ -131.211230, 55.192379 ], [ -131.235516, 55.197574 ], [ -131.263089, 55.208318 ], [ -131.297162, 55.235046 ], [ -131.302697, 55.250217 ], [ -131.278302, 55.260319 ], [ -131.240190, 55.287156 ], [ -131.230432, 55.297802 ], [ -131.191595, 55.360527 ], [ -131.191933, 55.368334 ], [ -131.197489, 55.391051 ], [ -131.202477, 55.392834 ], [ -131.272447, 55.387774 ], [ -131.292102, 55.383946 ], [ -131.293043, 55.378684 ], [ -131.287016, 55.358260 ], [ -131.264608, 55.345639 ], [ -131.254461, 55.329698 ], [ -131.255107, 55.322104 ], [ -131.284986, 55.286437 ], [ -131.291203, 55.281751 ], [ -131.326989, 55.265911 ], [ -131.402931, 55.238065 ], [ -131.424502, 55.238764 ], [ -131.428234, 55.239416 ], [ -131.437857, 55.248407 ], [ -131.444799, 55.264491 ], [ -131.463532, 55.283389 ], [ -131.475602, 55.303263 ], [ -131.462968, 55.312648 ], [ -131.471976, 55.323386 ], [ -131.494146, 55.332310 ], [ -131.509811, 55.332310 ], [ -131.515257, 55.327938 ], [ -131.528201, 55.295349 ], [ -131.536510, 55.292352 ], [ -131.550044, 55.293389 ], [ -131.566677, 55.306068 ], [ -131.584842, 55.309588 ], [ -131.639031, 55.339481 ], [ -131.698743, 55.354873 ], [ -131.732441, 55.377553 ], [ -131.735939, 55.381905 ], [ -131.736654, 55.392206 ], [ -131.741834, 55.398074 ], [ -131.828446, 55.445214 ], [ -131.844157, 55.456742 ], [ -131.845542, 55.522119 ], [ -131.841683, 55.526748 ], [ -131.793717, 55.541682 ], [ -131.766373, 55.540050 ], [ -131.733052, 55.548559 ], [ -131.664629, 55.581525 ], [ -131.654172, 55.592431 ], [ -131.671471, 55.606573 ], [ -131.682849, 55.610488 ], [ -131.701091, 55.613684 ], [ -131.724359, 55.632559 ], [ -131.726322, 55.635930 ], [ -131.726615, 55.641000 ], [ -131.719546, 55.650282 ], [ -131.712102, 55.665797 ], [ -131.701147, 55.696960 ], [ -131.706744, 55.706435 ], [ -131.726467, 55.720826 ], [ -131.733408, 55.730832 ], [ -131.719308, 55.749099 ], [ -131.704907, 55.755541 ], [ -131.649626, 55.768728 ], [ -131.640294, 55.785274 ], [ -131.640141, 55.789355 ], [ -131.653124, 55.795735 ], [ -131.678213, 55.799837 ], [ -131.691058, 55.797561 ], [ -131.697211, 55.793768 ], [ -131.700951, 55.788977 ], [ -131.705259, 55.789939 ], [ -131.710448, 55.806620 ], [ -131.713742, 55.853263 ], [ -131.701487, 55.860943 ], [ -131.689044, 55.875488 ], [ -131.687317, 55.886772 ], [ -131.689509, 55.890232 ], [ -131.720384, 55.894659 ], [ -131.776737, 55.878784 ], [ -131.828176, 55.877284 ], [ -131.836962, 55.875472 ], [ -131.830547, 55.856616 ], [ -131.816310, 55.837449 ], [ -131.777033, 55.823261 ], [ -131.771248, 55.810028 ], [ -131.779908, 55.791904 ], [ -131.814759, 55.731350 ], [ -131.826160, 55.718580 ], [ -131.831407, 55.681342 ], [ -131.828887, 55.667148 ], [ -131.865395, 55.630680 ], [ -131.897413, 55.603914 ], [ -131.939318, 55.623844 ], [ -131.963121, 55.615263 ], [ -131.962642, 55.608708 ], [ -131.945303, 55.572441 ], [ -131.936689, 55.535151 ], [ -131.971792, 55.498279 ], [ -131.986493, 55.500619 ], [ -132.014613, 55.515238 ], [ -132.043772, 55.535742 ], [ -132.060504, 55.543030 ], [ -132.098521, 55.550015 ], [ -132.114654, 55.550623 ], [ -132.141118, 55.559010 ], [ -132.148383, 55.562481 ], [ -132.183207, 55.588128 ], [ -132.198652, 55.615721 ], [ -132.201500, 55.626376 ], [ -132.197869, 55.633967 ], [ -132.199549, 55.638593 ], [ -132.215409, 55.682270 ], [ -132.224167, 55.701766 ], [ -132.237532, 55.711347 ], [ -132.260119, 55.732293 ], [ -132.283594, 55.761774 ], [ -132.280431, 55.765599 ], [ -132.265071, 55.762174 ], [ -132.251732, 55.756247 ], [ -132.229647, 55.740488 ], [ -132.206951, 55.736987 ], [ -132.190479, 55.742501 ], [ -132.185478, 55.753161 ], [ -132.184982, 55.778776 ], [ -132.187494, 55.785595 ], [ -132.183163, 55.800830 ], [ -132.130413, 55.811419 ], [ -132.113361, 55.812718 ], [ -132.086050, 55.832436 ], [ -132.067412, 55.875078 ], [ -132.041795, 55.958795 ], [ -132.070340, 56.046733 ], [ -132.038364, 56.091297 ], [ -132.033368, 56.095572 ], [ -132.011297, 56.077359 ], [ -131.970294, 56.114042 ], [ -131.935728, 56.177207 ], [ -131.943402, 56.192557 ], [ -131.958838, 56.194762 ], [ -131.993894, 56.193351 ], [ -132.018130, 56.183155 ], [ -132.034849, 56.133432 ], [ -132.060993, 56.129355 ], [ -132.104020, 56.108109 ], [ -132.176955, 56.055706 ], [ -132.129697, 55.957855 ], [ -132.135474, 55.941626 ], [ -132.159064, 55.922560 ], [ -132.170198, 55.919231 ], [ -132.191893, 55.921717 ], [ -132.224241, 55.930421 ], [ -132.279962, 55.924839 ], [ -132.320487, 55.887648 ], [ -132.319799, 55.874347 ], [ -132.309306, 55.865059 ], [ -132.309949, 55.862301 ], [ -132.323242, 55.851878 ], [ -132.372298, 55.850359 ], [ -132.376518, 55.853377 ], [ -132.397304, 55.878867 ], [ -132.398349, 55.884052 ], [ -132.397080, 55.905546 ], [ -132.401192, 55.950467 ], [ -132.446166, 56.018666 ], [ -132.492795, 56.066436 ], [ -132.522076, 56.077035 ], [ -132.573677, 56.070700 ], [ -132.621793, 56.056140 ], [ -132.621492, 56.049174 ], [ -132.629155, 56.037425 ], [ -132.640079, 56.033194 ], [ -132.684620, 56.082323 ], [ -132.708697, 56.112124 ], [ -132.723396, 56.145814 ], [ -132.718342, 56.217704 ], [ -132.689888, 56.238744 ], [ -132.672471, 56.239439 ], [ -132.664212, 56.236332 ], [ -132.644250, 56.232807 ], [ -132.615797, 56.234172 ], [ -132.601495, 56.240065 ], [ -132.582070, 56.278816 ], [ -132.582033, 56.285456 ], [ -132.575023, 56.296468 ], [ -132.543076, 56.332276 ], [ -132.529360, 56.338555 ], [ -132.441839, 56.353983 ], [ -132.431631, 56.352163 ], [ -132.422041, 56.349341 ], [ -132.403678, 56.334811 ], [ -132.381766, 56.310756 ], [ -132.380574, 56.307785 ], [ -132.382793, 56.299203 ], [ -132.363966, 56.287126 ], [ -132.358710, 56.290800 ], [ -132.349149, 56.304456 ], [ -132.340678, 56.341754 ], [ -132.361132, 56.380627 ], [ -132.394268, 56.485579 ], [ -132.389380, 56.491367 ], [ -132.382379, 56.491972 ], [ -132.362556, 56.487904 ], [ -132.253393, 56.449539 ], [ -132.245479, 56.441215 ], [ -132.233927, 56.416736 ], [ -132.242000, 56.413660 ], [ -132.238473, 56.398706 ], [ -132.223136, 56.384017 ], [ -132.204367, 56.372086 ], [ -132.199269, 56.371054 ], [ -132.181158, 56.387128 ], [ -132.179350, 56.390823 ], [ -132.181647, 56.399336 ], [ -132.208568, 56.457125 ], [ -132.239043, 56.476671 ], [ -132.259611, 56.487630 ], [ -132.279753, 56.485881 ], [ -132.290475, 56.487017 ], [ -132.357564, 56.529008 ], [ -132.361293, 56.534232 ], [ -132.367088, 56.574578 ], [ -132.363836, 56.588613 ], [ -132.358410, 56.595266 ], [ -132.319303, 56.607116 ], [ -132.297288, 56.629819 ], [ -132.284216, 56.636699 ], [ -132.280089, 56.651834 ], [ -132.281464, 56.665593 ], [ -132.298664, 56.677977 ], [ -132.313799, 56.676601 ], [ -132.324807, 56.673849 ], [ -132.348886, 56.664217 ], [ -132.371589, 56.672473 ], [ -132.389476, 56.672473 ], [ -132.403923, 56.669721 ], [ -132.452081, 56.672473 ], [ -132.467904, 56.680729 ], [ -132.528446, 56.702056 ], [ -132.522398, 56.716256 ], [ -132.517127, 56.728632 ], [ -132.432385, 56.782385 ], [ -132.371032, 56.816413 ], [ -132.373615, 56.820353 ], [ -132.390129, 56.825837 ], [ -132.404564, 56.825506 ], [ -132.438330, 56.821117 ], [ -132.505513, 56.785485 ], [ -132.519457, 56.775455 ], [ -132.520712, 56.760116 ], [ -132.532002, 56.757141 ], [ -132.556758, 56.757242 ], [ -132.637458, 56.780910 ], [ -132.770404, 56.837486 ], [ -132.792089, 56.856152 ], [ -132.797107, 56.864922 ], [ -132.793601, 56.866364 ], [ -132.792727, 56.871673 ], [ -132.796999, 56.877790 ], [ -132.817890, 56.896901 ], [ -132.829346, 56.903573 ], [ -132.846744, 56.910635 ], [ -132.870340, 56.925682 ], [ -132.911970, 56.966651 ], [ -132.918967, 56.993673 ], [ -132.892388, 56.993016 ], [ -132.853636, 57.005343 ], [ -132.813684, 57.030218 ], [ -132.832220, 57.070408 ], [ -132.853284, 57.080077 ], [ -132.870116, 57.078424 ], [ -132.875197, 57.069577 ], [ -132.916487, 57.040086 ], [ -132.937520, 57.048321 ], [ -132.984307, 57.054845 ], [ -132.993944, 57.032353 ], [ -133.025050, 57.057322 ], [ -133.076481, 57.081733 ], [ -133.125306, 57.088891 ], [ -133.161448, 57.086264 ], [ -133.188074, 57.088973 ], [ -133.208726, 57.109699 ], [ -133.210261, 57.118453 ], [ -133.206655, 57.123834 ], [ -133.224656, 57.136522 ], [ -133.234880, 57.137937 ], [ -133.247414, 57.136802 ], [ -133.322359, 57.112727 ], [ -133.466932, 57.159356 ], [ -133.517194, 57.177775 ], [ -133.517197, 57.177776 ], [ -133.544817, 57.242570 ], [ -133.542565, 57.250682 ], [ -133.522837, 57.278580 ], [ -133.489738, 57.305192 ], [ -133.475890, 57.307982 ], [ -133.455936, 57.303970 ], [ -133.444958, 57.297729 ], [ -133.442436, 57.289978 ], [ -133.425948, 57.285995 ], [ -133.371591, 57.286713 ], [ -133.307565, 57.290052 ], [ -133.287052, 57.302920 ], [ -133.274829, 57.330625 ], [ -133.283510, 57.333119 ], [ -133.342070, 57.336798 ], [ -133.354720, 57.333253 ], [ -133.403868, 57.342685 ], [ -133.442682, 57.352845 ], [ -133.453783, 57.356240 ], [ -133.468267, 57.364217 ], [ -133.472039, 57.368651 ], [ -133.475998, 57.380394 ], [ -133.472454, 57.388446 ], [ -133.461179, 57.394577 ], [ -133.503115, 57.453528 ], [ -133.525140, 57.490344 ], [ -133.525830, 57.501777 ], [ -133.516749, 57.543911 ], [ -133.510806, 57.548139 ], [ -133.496365, 57.548772 ], [ -133.488197, 57.551387 ], [ -133.478086, 57.561730 ], [ -133.481221, 57.571470 ], [ -133.505982, 57.578459 ], [ -133.528313, 57.573944 ], [ -133.531905, 57.569466 ], [ -133.537860, 57.567292 ], [ -133.565478, 57.563095 ], [ -133.578948, 57.565094 ], [ -133.620760, 57.578919 ], [ -133.664390, 57.611707 ], [ -133.676449, 57.625192 ], [ -133.680963, 57.648265 ], [ -133.658550, 57.707924 ], [ -133.654530, 57.713689 ], [ -133.582212, 57.715095 ], [ -133.543928, 57.696454 ], [ -133.530957, 57.686914 ], [ -133.522243, 57.683663 ], [ -133.489677, 57.677141 ], [ -133.441215, 57.672013 ], [ -133.404980, 57.663783 ], [ -133.234598, 57.608749 ], [ -133.188864, 57.589071 ], [ -133.179062, 57.587147 ], [ -133.162464, 57.599796 ], [ -133.174032, 57.610062 ], [ -133.251126, 57.649966 ], [ -133.278209, 57.661859 ], [ -133.291062, 57.665358 ], [ -133.322532, 57.665830 ], [ -133.485403, 57.738677 ], [ -133.545031, 57.767970 ], [ -133.559889, 57.777457 ], [ -133.556097, 57.788830 ], [ -133.569787, 57.859365 ], [ -133.602032, 57.860394 ], [ -133.610178, 57.860654 ], [ -133.631303, 57.846766 ], [ -133.633931, 57.838029 ], [ -133.641996, 57.811215 ], [ -133.638899, 57.803323 ], [ -133.635578, 57.799900 ], [ -133.637054, 57.792203 ], [ -133.639675, 57.790361 ], [ -133.658113, 57.786368 ], [ -133.677433, 57.786593 ], [ -133.696784, 57.795075 ], [ -133.703097, 57.792152 ], [ -133.709141, 57.792739 ], [ -133.814706, 57.832979 ], [ -133.999331, 57.999016 ], [ -134.057521, 58.039471 ], [ -134.071720, 58.054636 ], [ -134.089207, 58.082534 ], [ -134.144813, 58.171242 ], [ -134.587101, 58.205802 ], [ -134.703351, 58.276537 ], [ -134.839307, 58.359261 ], [ -135.074096, 58.502123 ], [ -135.196338, 58.907875 ], [ -135.219128, 58.974972 ], [ -135.175756, 58.973868 ], [ -135.180116, 58.997871 ], [ -135.208585, 59.076824 ], [ -135.238267, 59.130134 ], [ -135.283964, 59.192532 ], [ -135.368331, 59.263275 ], [ -135.430331, 59.327200 ], [ -135.436438, 59.315791 ], [ -135.444526, 59.277689 ], [ -135.429601, 59.242722 ], [ -135.403687, 59.222767 ], [ -135.364060, 59.211403 ], [ -135.342254, 59.177825 ], [ -135.329458, 59.152700 ], [ -135.377826, 59.099262 ], [ -135.382354, 59.060749 ], [ -135.382641, 59.033366 ], [ -135.339375, 59.017667 ], [ -135.326711, 59.011469 ], [ -135.322604, 59.007812 ], [ -135.297293, 58.959860 ], [ -135.298627, 58.919262 ], [ -135.305907, 58.901340 ], [ -135.322622, 58.900661 ], [ -135.339948, 58.888955 ], [ -135.284657, 58.818114 ], [ -135.274203, 58.813122 ], [ -135.248985, 58.790878 ], [ -135.243200, 58.783112 ], [ -135.233878, 58.735487 ], [ -135.142322, 58.616370 ], [ -135.135843, 58.588225 ], [ -135.137516, 58.577835 ], [ -135.142161, 58.577107 ], [ -135.145521, 58.578332 ], [ -135.153827, 58.586626 ], [ -135.159062, 58.595525 ], [ -135.186357, 58.597770 ], [ -135.190544, 58.592417 ], [ -135.189368, 58.576244 ], [ -135.165861, 58.546605 ], [ -135.132273, 58.496536 ], [ -135.088983, 58.423022 ], [ -135.058071, 58.349447 ], [ -135.049062, 58.309295 ], [ -135.053488, 58.290498 ], [ -135.056552, 58.288699 ], [ -135.060452, 58.290338 ], [ -135.069775, 58.302694 ], [ -135.095814, 58.297233 ], [ -135.101210, 58.292607 ], [ -135.107700, 58.265034 ], [ -135.099106, 58.245096 ], [ -135.056227, 58.189884 ], [ -135.073269, 58.190575 ], [ -135.087872, 58.200073 ], [ -135.112868, 58.201553 ], [ -135.159055, 58.210178 ], [ -135.220281, 58.235584 ], [ -135.227736, 58.236900 ], [ -135.246709, 58.236368 ], [ -135.277198, 58.233634 ], [ -135.287700, 58.234933 ], [ -135.306507, 58.242916 ], [ -135.344868, 58.270795 ], [ -135.398260, 58.327689 ], [ -135.408059, 58.342999 ], [ -135.433061, 58.399899 ], [ -135.447381, 58.399891 ] ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US12", "STATE": 27, "name": "Florida", "LSAD": "", "CENSUSAREA": 53624.759000 }, "geometry": { "type": "MultiPolygon", "coordinates": [ [ [ [ -80.250581, 25.341930 ], [ -80.254916, 25.336336 ], [ -80.260137, 25.324641 ], [ -80.268138, 25.320675 ], [ -80.288184, 25.282835 ], [ -80.307584, 25.257561 ], [ -80.351399, 25.190615 ], [ -80.354019, 25.184306 ], [ -80.349855, 25.168825 ], [ -80.358570, 25.154073 ], [ -80.377084, 25.130487 ], [ -80.399767, 25.108536 ], [ -80.428318, 25.095547 ], [ -80.431032, 25.089250 ], [ -80.443375, 25.076084 ], [ -80.462011, 25.069935 ], [ -80.473870, 25.060253 ], [ -80.493881, 25.038502 ], [ -80.489120, 25.031301 ], [ -80.494781, 25.023019 ], [ -80.537995, 24.990244 ], [ -80.565831, 24.958155 ], [ -80.571668, 24.953659 ], [ -80.588272, 24.951153 ], [ -80.596073, 24.948173 ], [ -80.611693, 24.938420 ], [ -80.635571, 24.913003 ], [ -80.659395, 24.897433 ], [ -80.661280, 24.899704 ], [ -80.660198, 24.904980 ], [ -80.650765, 24.908121 ], [ -80.641306, 24.914311 ], [ -80.623866, 24.931236 ], [ -80.622896, 24.935587 ], [ -80.624172, 24.939058 ], [ -80.621658, 24.944265 ], [ -80.597074, 24.958492 ], [ -80.581131, 24.964738 ], [ -80.578185, 24.962811 ], [ -80.570813, 24.962215 ], [ -80.558785, 24.971505 ], [ -80.544110, 24.999916 ], [ -80.543254, 25.007337 ], [ -80.545971, 25.014770 ], [ -80.524498, 25.016945 ], [ -80.509136, 25.028317 ], [ -80.501326, 25.041436 ], [ -80.495569, 25.047497 ], [ -80.488900, 25.050110 ], [ -80.481197, 25.056604 ], [ -80.460652, 25.078904 ], [ -80.465496, 25.086609 ], [ -80.470211, 25.089438 ], [ -80.481763, 25.091905 ], [ -80.494715, 25.102269 ], [ -80.484188, 25.109430 ], [ -80.477480, 25.107407 ], [ -80.476174, 25.099454 ], [ -80.463987, 25.093210 ], [ -80.450399, 25.088751 ], [ -80.444887, 25.092966 ], [ -80.433575, 25.106317 ], [ -80.433499, 25.114665 ], [ -80.447659, 25.147729 ], [ -80.446473, 25.151287 ], [ -80.413260, 25.137053 ], [ -80.403177, 25.141798 ], [ -80.395467, 25.150694 ], [ -80.387164, 25.170859 ], [ -80.388350, 25.182721 ], [ -80.391909, 25.192210 ], [ -80.387164, 25.198141 ], [ -80.369965, 25.206444 ], [ -80.358696, 25.207037 ], [ -80.349800, 25.210595 ], [ -80.337345, 25.231353 ], [ -80.333787, 25.253891 ], [ -80.336159, 25.261601 ], [ -80.342683, 25.268125 ], [ -80.368186, 25.282359 ], [ -80.364034, 25.286510 ], [ -80.339421, 25.290069 ], [ -80.334676, 25.285917 ], [ -80.328746, 25.286510 ], [ -80.315698, 25.294220 ], [ -80.292567, 25.314385 ], [ -80.289602, 25.325061 ], [ -80.275961, 25.344039 ], [ -80.264614, 25.354322 ], [ -80.256982, 25.361239 ], [ -80.254610, 25.380810 ], [ -80.251052, 25.391486 ], [ -80.246307, 25.398603 ], [ -80.226142, 25.406313 ], [ -80.219025, 25.411058 ], [ -80.214280, 25.416988 ], [ -80.206570, 25.434188 ], [ -80.199453, 25.458504 ], [ -80.192336, 25.473331 ], [ -80.189964, 25.485786 ], [ -80.191743, 25.495275 ], [ -80.188778, 25.507730 ], [ -80.179288, 25.518999 ], [ -80.174544, 25.518406 ], [ -80.173951, 25.482821 ], [ -80.184033, 25.468587 ], [ -80.204198, 25.412244 ], [ -80.221991, 25.397417 ], [ -80.238004, 25.361832 ], [ -80.240376, 25.347005 ], [ -80.249865, 25.342853 ], [ -80.250581, 25.341930 ] ] ], [ [ [ -81.582923, 24.658732 ], [ -81.580534, 24.669140 ], [ -81.562917, 24.692912 ], [ -81.557610, 24.692488 ], [ -81.542116, 24.681026 ], [ -81.535323, 24.679540 ], [ -81.518980, 24.687818 ], [ -81.516433, 24.700341 ], [ -81.512400, 24.703737 ], [ -81.490962, 24.710105 ], [ -81.476642, 24.711244 ], [ -81.474186, 24.706332 ], [ -81.469275, 24.704286 ], [ -81.459043, 24.707355 ], [ -81.454132, 24.710834 ], [ -81.451881, 24.714518 ], [ -81.452700, 24.736209 ], [ -81.456588, 24.740097 ], [ -81.451267, 24.747464 ], [ -81.440831, 24.735390 ], [ -81.438580, 24.727000 ], [ -81.435715, 24.723931 ], [ -81.432032, 24.722908 ], [ -81.423028, 24.731911 ], [ -81.421595, 24.737641 ], [ -81.427121, 24.745827 ], [ -81.430599, 24.747259 ], [ -81.431009, 24.751761 ], [ -81.425483, 24.752989 ], [ -81.402769, 24.749101 ], [ -81.392947, 24.743371 ], [ -81.390287, 24.738460 ], [ -81.389468, 24.731298 ], [ -81.385580, 24.726182 ], [ -81.360410, 24.708788 ], [ -81.345881, 24.707560 ], [ -81.319282, 24.701238 ], [ -81.314787, 24.691764 ], [ -81.313933, 24.680707 ], [ -81.309664, 24.665017 ], [ -81.298028, 24.656774 ], [ -81.298369, 24.654326 ], [ -81.303113, 24.651665 ], [ -81.332831, 24.639528 ], [ -81.395096, 24.621062 ], [ -81.401946, 24.623564 ], [ -81.403319, 24.640294 ], [ -81.414187, 24.647167 ], [ -81.432315, 24.645949 ], [ -81.448623, 24.640172 ], [ -81.470411, 24.641985 ], [ -81.480951, 24.645121 ], [ -81.481830, 24.647369 ], [ -81.477915, 24.649893 ], [ -81.476410, 24.653197 ], [ -81.480504, 24.659757 ], [ -81.498580, 24.664980 ], [ -81.502992, 24.660877 ], [ -81.505585, 24.654609 ], [ -81.508740, 24.644210 ], [ -81.509028, 24.631516 ], [ -81.511165, 24.625135 ], [ -81.518595, 24.620304 ], [ -81.546450, 24.614895 ], [ -81.602998, 24.586444 ], [ -81.664209, 24.573143 ], [ -81.674694, 24.564359 ], [ -81.685278, 24.558739 ], [ -81.691575, 24.559886 ], [ -81.732511, 24.556423 ], [ -81.765993, 24.552103 ], [ -81.786157, 24.546580 ], [ -81.810333, 24.544701 ], [ -81.812890, 24.546468 ], [ -81.814446, 24.563580 ], [ -81.811386, 24.569750 ], [ -81.800676, 24.570989 ], [ -81.794057, 24.586000 ], [ -81.773808, 24.584977 ], [ -81.748071, 24.590199 ], [ -81.739241, 24.589973 ], [ -81.734573, 24.584148 ], [ -81.730473, 24.581960 ], [ -81.715944, 24.587956 ], [ -81.715480, 24.592498 ], [ -81.705364, 24.597647 ], [ -81.699349, 24.597647 ], [ -81.694235, 24.591932 ], [ -81.687017, 24.592534 ], [ -81.678595, 24.597647 ], [ -81.668970, 24.607873 ], [ -81.655735, 24.616295 ], [ -81.637087, 24.621408 ], [ -81.614829, 24.642764 ], [ -81.614529, 24.650584 ], [ -81.597685, 24.655397 ], [ -81.587759, 24.655998 ], [ -81.582923, 24.658732 ] ] ], [ [ [ -82.150680, 24.576331 ], [ -82.143075, 24.593395 ], [ -82.135423, 24.596879 ], [ -82.125268, 24.597426 ], [ -82.104187, 24.588256 ], [ -82.101051, 24.584679 ], [ -82.099417, 24.572522 ], [ -82.104429, 24.561167 ], [ -82.116787, 24.549144 ], [ -82.159439, 24.548212 ], [ -82.165206, 24.552159 ], [ -82.164426, 24.563375 ], [ -82.150680, 24.576331 ] ] ], [ [ [ -81.249799, 24.673357 ], [ -81.246095, 24.675832 ], [ -81.243232, 24.673998 ], [ -81.244761, 24.669202 ], [ -81.281778, 24.653750 ], [ -81.278312, 24.660448 ], [ -81.260006, 24.674848 ], [ -81.249799, 24.673357 ] ] ], [ [ [ -80.909954, 24.781154 ], [ -80.906288, 24.769867 ], [ -80.912042, 24.765050 ], [ -80.938543, 24.767535 ], [ -81.015933, 24.719881 ], [ -81.023794, 24.716901 ], [ -81.028616, 24.720618 ], [ -81.032447, 24.727323 ], [ -81.034290, 24.727341 ], [ -81.064554, 24.715453 ], [ -81.071034, 24.711722 ], [ -81.075855, 24.704266 ], [ -81.078716, 24.696557 ], [ -81.078439, 24.692382 ], [ -81.108041, 24.688592 ], [ -81.124094, 24.704873 ], [ -81.125371, 24.708291 ], [ -81.107355, 24.712760 ], [ -81.105287, 24.711280 ], [ -81.099135, 24.711993 ], [ -81.066816, 24.723926 ], [ -81.050570, 24.737581 ], [ -81.041797, 24.742965 ], [ -81.036698, 24.742827 ], [ -81.035192, 24.739982 ], [ -81.022170, 24.733091 ], [ -81.016918, 24.734676 ], [ -80.994426, 24.743991 ], [ -80.986454, 24.752749 ], [ -80.960129, 24.764226 ], [ -80.910431, 24.782324 ], [ -80.909954, 24.781154 ] ] ], [ [ [ -81.317673, 24.757290 ], [ -81.305468, 24.756612 ], [ -81.290801, 24.736862 ], [ -81.288259, 24.720881 ], [ -81.302984, 24.714199 ], [ -81.310744, 24.727068 ], [ -81.318505, 24.729477 ], [ -81.326844, 24.728375 ], [ -81.350162, 24.746524 ], [ -81.357417, 24.756834 ], [ -81.342695, 24.756250 ], [ -81.327555, 24.762315 ], [ -81.324637, 24.767210 ], [ -81.317673, 24.757290 ] ] ], [ [ [ -80.890540, 24.791678 ], [ -80.884572, 24.791561 ], [ -80.884020, 24.790414 ], [ -80.892649, 24.785991 ], [ -80.906874, 24.783744 ], [ -80.890540, 24.791678 ] ] ], [ [ [ -80.788263, 24.824218 ], [ -80.790497, 24.817789 ], [ -80.796053, 24.811940 ], [ -80.822342, 24.812629 ], [ -80.846191, 24.802968 ], [ -80.850338, 24.802600 ], [ -80.850866, 24.803701 ], [ -80.846142, 24.807488 ], [ -80.830158, 24.814280 ], [ -80.814551, 24.827953 ], [ -80.792780, 24.843918 ], [ -80.780564, 24.840520 ], [ -80.788263, 24.824218 ] ] ], [ [ [ -80.729275, 24.865361 ], [ -80.719977, 24.864644 ], [ -80.703028, 24.880873 ], [ -80.691762, 24.885759 ], [ -80.690354, 24.881539 ], [ -80.703176, 24.869495 ], [ -80.711850, 24.863323 ], [ -80.761359, 24.836225 ], [ -80.766966, 24.836158 ], [ -80.745468, 24.850652 ], [ -80.740611, 24.857421 ], [ -80.732343, 24.864810 ], [ -80.729275, 24.865361 ] ] ], [ [ [ -82.255777, 26.703437 ], [ -82.255159, 26.708160 ], [ -82.246535, 26.706435 ], [ -82.242510, 26.694361 ], [ -82.245960, 26.688612 ], [ -82.246535, 26.683437 ], [ -82.237440, 26.661976 ], [ -82.218342, 26.626407 ], [ -82.214337, 26.602944 ], [ -82.196514, 26.559823 ], [ -82.187315, 26.527626 ], [ -82.177541, 26.502328 ], [ -82.166042, 26.489679 ], [ -82.149368, 26.477605 ], [ -82.131545, 26.477030 ], [ -82.120046, 26.473581 ], [ -82.088423, 26.455182 ], [ -82.076924, 26.466106 ], [ -82.062551, 26.470131 ], [ -82.038403, 26.456907 ], [ -82.015607, 26.454858 ], [ -82.013713, 26.454258 ], [ -82.013913, 26.452058 ], [ -82.063114, 26.425459 ], [ -82.075015, 26.422059 ], [ -82.082915, 26.422059 ], [ -82.098115, 26.424959 ], [ -82.126671, 26.436279 ], [ -82.148716, 26.455458 ], [ -82.172917, 26.467658 ], [ -82.177017, 26.471558 ], [ -82.180717, 26.476257 ], [ -82.186441, 26.489221 ], [ -82.201402, 26.556310 ], [ -82.205523, 26.566536 ], [ -82.222131, 26.590402 ], [ -82.238872, 26.636433 ], [ -82.248659, 26.654337 ], [ -82.263008, 26.673388 ], [ -82.268007, 26.682791 ], [ -82.264351, 26.698496 ], [ -82.255777, 26.703437 ] ] ], [ [ [ -84.777208, 29.707398 ], [ -84.729836, 29.738881 ], [ -84.716994, 29.749066 ], [ -84.696726, 29.769930 ], [ -84.694125, 29.764593 ], [ -84.694939, 29.761844 ], [ -84.713747, 29.741390 ], [ -84.765117, 29.699724 ], [ -84.776954, 29.692191 ], [ -84.799129, 29.681565 ], [ -84.853829, 29.664720 ], [ -84.884632, 29.652248 ], [ -84.957779, 29.612635 ], [ -85.036219, 29.588919 ], [ -85.051033, 29.586928 ], [ -85.054624, 29.592084 ], [ -85.069453, 29.605282 ], [ -85.095190, 29.622490 ], [ -85.097082, 29.625215 ], [ -85.094882, 29.627757 ], [ -85.066530, 29.609952 ], [ -85.038497, 29.599552 ], [ -85.023501, 29.597073 ], [ -85.017205, 29.604379 ], [ -84.987775, 29.610307 ], [ -84.968314, 29.617238 ], [ -84.932592, 29.637232 ], [ -84.925842, 29.644949 ], [ -84.920333, 29.648638 ], [ -84.895885, 29.657444 ], [ -84.862099, 29.672572 ], [ -84.813352, 29.687028 ], [ -84.798160, 29.699321 ], [ -84.777208, 29.707398 ] ] ], [ [ [ -85.156415, 29.679628 ], [ -85.137397, 29.684348 ], [ -85.134639, 29.686569 ], [ -85.114268, 29.688658 ], [ -85.093902, 29.684838 ], [ -85.083719, 29.679019 ], [ -85.077237, 29.670862 ], [ -85.091399, 29.648634 ], [ -85.097218, 29.633004 ], [ -85.124913, 29.628433 ], [ -85.142746, 29.635404 ], [ -85.162520, 29.650282 ], [ -85.184530, 29.663987 ], [ -85.204314, 29.672695 ], [ -85.222546, 29.678039 ], [ -85.220324, 29.680138 ], [ -85.208981, 29.681775 ], [ -85.184776, 29.682710 ], [ -85.168625, 29.682409 ], [ -85.156415, 29.679628 ] ] ], [ [ [ -82.821585, 27.964443 ], [ -82.829801, 27.968469 ], [ -82.828625, 28.019795 ], [ -82.823025, 28.030695 ], [ -82.823063, 28.044758 ], [ -82.826282, 28.053450 ], [ -82.831825, 28.062893 ], [ -82.836326, 28.073193 ], [ -82.833225, 28.082193 ], [ -82.830525, 28.085293 ], [ -82.826125, 28.083793 ], [ -82.823063, 28.068258 ], [ -82.818288, 28.057613 ], [ -82.813435, 28.037160 ], [ -82.815168, 28.012547 ], [ -82.821408, 28.008387 ], [ -82.821755, 28.002494 ], [ -82.817248, 27.992094 ], [ -82.815168, 27.973721 ], [ -82.821585, 27.964443 ] ] ], [ [ [ -83.309455, 30.634417 ], [ -83.309250, 30.634405 ], [ -83.309249, 30.634405 ], [ -83.256218, 30.631279 ], [ -83.187391, 30.627223 ], [ -83.174411, 30.626444 ], [ -83.163309, 30.625895 ], [ -83.156170, 30.625504 ], [ -83.136616, 30.624346 ], [ -82.878779, 30.609082 ], [ -82.877259, 30.609024 ], [ -82.698902, 30.598271 ], [ -82.698618, 30.598232 ], [ -82.689539, 30.597734 ], [ -82.689271, 30.597719 ], [ -82.584002, 30.591796 ], [ -82.569237, 30.590965 ], [ -82.565476, 30.590622 ], [ -82.553159, 30.589934 ], [ -82.545055, 30.589361 ], [ -82.536233, 30.588885 ], [ -82.524899, 30.588189 ], [ -82.459792, 30.584287 ], [ -82.459544, 30.584272 ], [ -82.418915, 30.581745 ], [ -82.374844, 30.579004 ], [ -82.287343, 30.573458 ], [ -82.258100, 30.571559 ], [ -82.249841, 30.570863 ], [ -82.214847, 30.567009 ], [ -82.214385, 30.566958 ], [ -82.212330, 30.499558 ], [ -82.206040, 30.455507 ], [ -82.210291, 30.424590 ], [ -82.204151, 30.401330 ], [ -82.189583, 30.376213 ], [ -82.171508, 30.359869 ], [ -82.165192, 30.358035 ], [ -82.124835, 30.366564 ], [ -82.050069, 30.362338 ], [ -82.050031, 30.362490 ], [ -82.016103, 30.497355 ], [ -82.016990, 30.519358 ], [ -82.005477, 30.563495 ], [ -82.013290, 30.595665 ], [ -82.037609, 30.633271 ], [ -82.049401, 30.655296 ], [ -82.050432, 30.676266 ], [ -82.023213, 30.781987 ], [ -81.999836, 30.788348 ], [ -81.906014, 30.822176 ], [ -81.868608, 30.792754 ], [ -81.840375, 30.786384 ], [ -81.827014, 30.788933 ], [ -81.806652, 30.789683 ], [ -81.759338, 30.771377 ], [ -81.741278, 30.762681 ], [ -81.732627, 30.749934 ], [ -81.719927, 30.744634 ], [ -81.637222, 30.733835 ], [ -81.624298, 30.736194 ], [ -81.606221, 30.718135 ], [ -81.544618, 30.712636 ], [ -81.444124, 30.709714 ], [ -81.432725, 30.703017 ], [ -81.427420, 30.698020 ], [ -81.430843, 30.669393 ], [ -81.443099, 30.600938 ], [ -81.442564, 30.555189 ], [ -81.434064, 30.522569 ], [ -81.442784, 30.509920 ], [ -81.447087, 30.503679 ], [ -81.440108, 30.497678 ], [ -81.426010, 30.496739 ], [ -81.410809, 30.482039 ], [ -81.407008, 30.422040 ], [ -81.397422, 30.400626 ], [ -81.396407, 30.340040 ], [ -81.391606, 30.303441 ], [ -81.385505, 30.273841 ], [ -81.379879, 30.252914 ], [ -81.355591, 30.162563 ], [ -81.308978, 29.969440 ], [ -81.295268, 29.928614 ], [ -81.288955, 29.915180 ], [ -81.276540, 29.900460 ], [ -81.270442, 29.883106 ], [ -81.264693, 29.858212 ], [ -81.263396, 29.820663 ], [ -81.256711, 29.784693 ], [ -81.240924, 29.739218 ], [ -81.229015, 29.714693 ], [ -81.212878, 29.670667 ], [ -81.211565, 29.667085 ], [ -81.163581, 29.555290 ], [ -81.123896, 29.474465 ], [ -81.101923, 29.427055 ], [ -81.046678, 29.307856 ], [ -80.995423, 29.206052 ], [ -80.966176, 29.147960 ], [ -80.944376, 29.110861 ], [ -80.907275, 29.064262 ], [ -80.893675, 29.036163 ], [ -80.878275, 29.010563 ], [ -80.787021, 28.875266 ], [ -80.732244, 28.791237 ], [ -80.713183, 28.761997 ], [ -80.713108, 28.761882 ], [ -80.712714, 28.761277 ], [ -80.709725, 28.756692 ], [ -80.708545, 28.755202 ], [ -80.672232, 28.709363 ], [ -80.663183, 28.697940 ], [ -80.647924, 28.678677 ], [ -80.647760, 28.678470 ], [ -80.647288, 28.677875 ], [ -80.645839, 28.675817 ], [ -80.641436, 28.669564 ], [ -80.639019, 28.666131 ], [ -80.631314, 28.655188 ], [ -80.616790, 28.634561 ], [ -80.583884, 28.597705 ], [ -80.574868, 28.585166 ], [ -80.567361, 28.562353 ], [ -80.560973, 28.530736 ], [ -80.536115, 28.478647 ], [ -80.525094, 28.459454 ], [ -80.526732, 28.451705 ], [ -80.562877, 28.437779 ], [ -80.574136, 28.427764 ], [ -80.587813, 28.410856 ], [ -80.596174, 28.390682 ], [ -80.603374, 28.363983 ], [ -80.606874, 28.336484 ], [ -80.608074, 28.311285 ], [ -80.604214, 28.257733 ], [ -80.589975, 28.177990 ], [ -80.566432, 28.095630 ], [ -80.547675, 28.048795 ], [ -80.508871, 27.970477 ], [ -80.446973, 27.861954 ], [ -80.447084, 27.860755 ], [ -80.447179, 27.859731 ], [ -80.383695, 27.740045 ], [ -80.351717, 27.642623 ], [ -80.350553, 27.628361 ], [ -80.344370, 27.616226 ], [ -80.330956, 27.597541 ], [ -80.324699, 27.569178 ], [ -80.321271, 27.557378 ], [ -80.311757, 27.524625 ], [ -80.301170, 27.500314 ], [ -80.293171, 27.500314 ], [ -80.265535, 27.420542 ], [ -80.253665, 27.379790 ], [ -80.233538, 27.341307 ], [ -80.226753, 27.322736 ], [ -80.199288, 27.263022 ], [ -80.193090, 27.249546 ], [ -80.161470, 27.192814 ], [ -80.153375, 27.169308 ], [ -80.159554, 27.163325 ], [ -80.149820, 27.143557 ], [ -80.138605, 27.111517 ], [ -80.116772, 27.072397 ], [ -80.093909, 27.018587 ], [ -80.079531, 26.970500 ], [ -80.066697, 26.927579 ], [ -80.046263, 26.859238 ], [ -80.031362, 26.796339 ], [ -80.032120, 26.771530 ], [ -80.036362, 26.771240 ], [ -80.037462, 26.766340 ], [ -80.032862, 26.715242 ], [ -80.032862, 26.700842 ], [ -80.035763, 26.676043 ], [ -80.035363, 26.612346 ], [ -80.038863, 26.569347 ], [ -80.050363, 26.509549 ], [ -80.060564, 26.444652 ], [ -80.070564, 26.336455 ], [ -80.072264, 26.335356 ], [ -80.074837, 26.321032 ], [ -80.075264, 26.318656 ], [ -80.079865, 26.264358 ], [ -80.085565, 26.249259 ], [ -80.089365, 26.231859 ], [ -80.101366, 26.147762 ], [ -80.105266, 26.096264 ], [ -80.106813, 26.092991 ], [ -80.108995, 26.088372 ], [ -80.109566, 26.087165 ], [ -80.112334, 26.053193 ], [ -80.117778, 25.986369 ], [ -80.117798, 25.975152 ], [ -80.117904, 25.915772 ], [ -80.120870, 25.883152 ], [ -80.119684, 25.841043 ], [ -80.122056, 25.817913 ], [ -80.127394, 25.791224 ], [ -80.127987, 25.772245 ], [ -80.137476, 25.750301 ], [ -80.144000, 25.740812 ], [ -80.152896, 25.702855 ], [ -80.154082, 25.683283 ], [ -80.152303, 25.676759 ], [ -80.154972, 25.665490 ], [ -80.160903, 25.664897 ], [ -80.176916, 25.685062 ], [ -80.170392, 25.710565 ], [ -80.164461, 25.721833 ], [ -80.166241, 25.728950 ], [ -80.172765, 25.737847 ], [ -80.184626, 25.745557 ], [ -80.197674, 25.744370 ], [ -80.229107, 25.732509 ], [ -80.240376, 25.724206 ], [ -80.244528, 25.717089 ], [ -80.250459, 25.688028 ], [ -80.265879, 25.658373 ], [ -80.267065, 25.651849 ], [ -80.277147, 25.637022 ], [ -80.288416, 25.630498 ], [ -80.296719, 25.622195 ], [ -80.301464, 25.613299 ], [ -80.305615, 25.593134 ], [ -80.305615, 25.575342 ], [ -80.302057, 25.567632 ], [ -80.313918, 25.539164 ], [ -80.324594, 25.535605 ], [ -80.328746, 25.532640 ], [ -80.339421, 25.499427 ], [ -80.339421, 25.478669 ], [ -80.337049, 25.465621 ], [ -80.328152, 25.443084 ], [ -80.320442, 25.437153 ], [ -80.326373, 25.422919 ], [ -80.325780, 25.398010 ], [ -80.320442, 25.391486 ], [ -80.310360, 25.389707 ], [ -80.306801, 25.384369 ], [ -80.310360, 25.373100 ], [ -80.335269, 25.338701 ], [ -80.352469, 25.329805 ], [ -80.361662, 25.327433 ], [ -80.374116, 25.317350 ], [ -80.383013, 25.301337 ], [ -80.385978, 25.288289 ], [ -80.419191, 25.263380 ], [ -80.437815, 25.253077 ], [ -80.447066, 25.247960 ], [ -80.462832, 25.236248 ], [ -80.467824, 25.232540 ], [ -80.468366, 25.231977 ], [ -80.469843, 25.230442 ], [ -80.483244, 25.216526 ], [ -80.487591, 25.207829 ], [ -80.488035, 25.206942 ], [ -80.488216, 25.206757 ], [ -80.495341, 25.199463 ], [ -80.496179, 25.199637 ], [ -80.498361, 25.200091 ], [ -80.498644, 25.200150 ], [ -80.502983, 25.203160 ], [ -80.503125, 25.203259 ], [ -80.507780, 25.206488 ], [ -80.508113, 25.206719 ], [ -80.508116, 25.206725 ], [ -80.512928, 25.216719 ], [ -80.514724, 25.217702 ], [ -80.515297, 25.218016 ], [ -80.520359, 25.220788 ], [ -80.523190, 25.220080 ], [ -80.525784, 25.218649 ], [ -80.530207, 25.216207 ], [ -80.540947, 25.218210 ], [ -80.542040, 25.221850 ], [ -80.540947, 25.224945 ], [ -80.540765, 25.229678 ], [ -80.548491, 25.236535 ], [ -80.558223, 25.239012 ], [ -80.570785, 25.239366 ], [ -80.589186, 25.223796 ], [ -80.587593, 25.207695 ], [ -80.584783, 25.200695 ], [ -80.584771, 25.200665 ], [ -80.594338, 25.193437 ], [ -80.601627, 25.187931 ], [ -80.609607, 25.181902 ], [ -80.609609, 25.181901 ], [ -80.618989, 25.177345 ], [ -80.619024, 25.177328 ], [ -80.633992, 25.176829 ], [ -80.639873, 25.176633 ], [ -80.640275, 25.176620 ], [ -80.640823, 25.176364 ], [ -80.642456, 25.175601 ], [ -80.645737, 25.174069 ], [ -80.645822, 25.174029 ], [ -80.646099, 25.173599 ], [ -80.648565, 25.169773 ], [ -80.649251, 25.168708 ], [ -80.656944, 25.168216 ], [ -80.660692, 25.167976 ], [ -80.669950, 25.167384 ], [ -80.674324, 25.167104 ], [ -80.679852, 25.166751 ], [ -80.683909, 25.166491 ], [ -80.688361, 25.164711 ], [ -80.695038, 25.157588 ], [ -80.701270, 25.146683 ], [ -80.703718, 25.139115 ], [ -80.715099, 25.140872 ], [ -80.721886, 25.145101 ], [ -80.728602, 25.144316 ], [ -80.734741, 25.143598 ], [ -80.738330, 25.143178 ], [ -80.742877, 25.142646 ], [ -80.746379, 25.148559 ], [ -80.746264, 25.155303 ], [ -80.751866, 25.163762 ], [ -80.757581, 25.166734 ], [ -80.795456, 25.172337 ], [ -80.796219, 25.172450 ], [ -80.815193, 25.164956 ], [ -80.817116, 25.164196 ], [ -80.823441, 25.161698 ], [ -80.826465, 25.160504 ], [ -80.826530, 25.160478 ], [ -80.826544, 25.160509 ], [ -80.827179, 25.161888 ], [ -80.827489, 25.162562 ], [ -80.828435, 25.164619 ], [ -80.830034, 25.168094 ], [ -80.838227, 25.174791 ], [ -80.843703, 25.176312 ], [ -80.846395, 25.177060 ], [ -80.846400, 25.177060 ], [ -80.858167, 25.176576 ], [ -80.858801, 25.176493 ], [ -80.874323, 25.174469 ], [ -80.874815, 25.174405 ], [ -80.875460, 25.174321 ], [ -80.875731, 25.174185 ], [ -80.878982, 25.172562 ], [ -80.879235, 25.172436 ], [ -80.891681, 25.166221 ], [ -80.899459, 25.162337 ], [ -80.900066, 25.162034 ], [ -80.900124, 25.161726 ], [ -80.901110, 25.156496 ], [ -80.901592, 25.153933 ], [ -80.901617, 25.153803 ], [ -80.900220, 25.150627 ], [ -80.898911, 25.147652 ], [ -80.900559, 25.139755 ], [ -80.900577, 25.139669 ], [ -80.900668, 25.139679 ], [ -80.902311, 25.139853 ], [ -80.906578, 25.140307 ], [ -80.915924, 25.141301 ], [ -80.915965, 25.141291 ], [ -80.931353, 25.137424 ], [ -80.936750, 25.136068 ], [ -80.939272, 25.135434 ], [ -80.940988, 25.135003 ], [ -80.943164, 25.134456 ], [ -80.943216, 25.134443 ], [ -80.954567, 25.135450 ], [ -80.955577, 25.135540 ], [ -80.956150, 25.135591 ], [ -80.957427, 25.135704 ], [ -80.958727, 25.135546 ], [ -80.967465, 25.134482 ], [ -80.967506, 25.134477 ], [ -80.967740, 25.134448 ], [ -80.967832, 25.134437 ], [ -80.970185, 25.134150 ], [ -80.970727, 25.134084 ], [ -80.970797, 25.134076 ], [ -80.971585, 25.133980 ], [ -80.971664, 25.133970 ], [ -80.971765, 25.133958 ], [ -80.973129, 25.133473 ], [ -80.977198, 25.132028 ], [ -80.991949, 25.126789 ], [ -80.994096, 25.126026 ], [ -80.999176, 25.124222 ], [ -80.999772, 25.124290 ], [ -81.009598, 25.125403 ], [ -81.022989, 25.129393 ], [ -81.025154, 25.129305 ], [ -81.033404, 25.128969 ], [ -81.038021, 25.128781 ], [ -81.049308, 25.128322 ], [ -81.049344, 25.128320 ], [ -81.049445, 25.128316 ], [ -81.049896, 25.128298 ], [ -81.050505, 25.128273 ], [ -81.079859, 25.118797 ], [ -81.094524, 25.127054 ], [ -81.111943, 25.145470 ], [ -81.120616, 25.152302 ], [ -81.133567, 25.156295 ], [ -81.141024, 25.163868 ], [ -81.142278, 25.183000 ], [ -81.142471, 25.183440 ], [ -81.142897, 25.184406 ], [ -81.146737, 25.193139 ], [ -81.155252, 25.207706 ], [ -81.155481, 25.208098 ], [ -81.155820, 25.208389 ], [ -81.168046, 25.218854 ], [ -81.171265, 25.221609 ], [ -81.172044, 25.222276 ], [ -81.171978, 25.223648 ], [ -81.171455, 25.234483 ], [ -81.171369, 25.236268 ], [ -81.170953, 25.244898 ], [ -81.170907, 25.245857 ], [ -81.169709, 25.249231 ], [ -81.169509, 25.249795 ], [ -81.169294, 25.250398 ], [ -81.168307, 25.253178 ], [ -81.162070, 25.289833 ], [ -81.159293, 25.298595 ], [ -81.152300, 25.305543 ], [ -81.148915, 25.318067 ], [ -81.151916, 25.324766 ], [ -81.148103, 25.332793 ], [ -81.140099, 25.341117 ], [ -81.133913, 25.342996 ], [ -81.121410, 25.338750 ], [ -81.118208, 25.345220 ], [ -81.117265, 25.354953 ], [ -81.128492, 25.380511 ], [ -81.141395, 25.381358 ], [ -81.150508, 25.387255 ], [ -81.150656, 25.399206 ], [ -81.147144, 25.404297 ], [ -81.146765, 25.407577 ], [ -81.168652, 25.463848 ], [ -81.179406, 25.475427 ], [ -81.191924, 25.484745 ], [ -81.208201, 25.504937 ], [ -81.210149, 25.516888 ], [ -81.203175, 25.534160 ], [ -81.204389, 25.538908 ], [ -81.209321, 25.548611 ], [ -81.225557, 25.558470 ], [ -81.232705, 25.573366 ], [ -81.233051, 25.586587 ], [ -81.240519, 25.599041 ], [ -81.240677, 25.613629 ], [ -81.253951, 25.638181 ], [ -81.268924, 25.656927 ], [ -81.277374, 25.664980 ], [ -81.290328, 25.687506 ], [ -81.328935, 25.717233 ], [ -81.335037, 25.715649 ], [ -81.346078, 25.721473 ], [ -81.345972, 25.736536 ], [ -81.343984, 25.747668 ], [ -81.346767, 25.754029 ], [ -81.355116, 25.760390 ], [ -81.359489, 25.766354 ], [ -81.361875, 25.772715 ], [ -81.344779, 25.782257 ], [ -81.340406, 25.786631 ], [ -81.341598, 25.794582 ], [ -81.344564, 25.803322 ], [ -81.349152, 25.816847 ], [ -81.352731, 25.822015 ], [ -81.362272, 25.824401 ], [ -81.386127, 25.839906 ], [ -81.394476, 25.851834 ], [ -81.417536, 25.864954 ], [ -81.424295, 25.867737 ], [ -81.429066, 25.865351 ], [ -81.441391, 25.863761 ], [ -81.458487, 25.868929 ], [ -81.471607, 25.881652 ], [ -81.473992, 25.888411 ], [ -81.487510, 25.888411 ], [ -81.501027, 25.884037 ], [ -81.508979, 25.884037 ], [ -81.512955, 25.886423 ], [ -81.511762, 25.896760 ], [ -81.515738, 25.899941 ], [ -81.527665, 25.901531 ], [ -81.541183, 25.900338 ], [ -81.577363, 25.889206 ], [ -81.584519, 25.888808 ], [ -81.614735, 25.893977 ], [ -81.623482, 25.897158 ], [ -81.640084, 25.897784 ], [ -81.644553, 25.897953 ], [ -81.654493, 25.893579 ], [ -81.663821, 25.885605 ], [ -81.672633, 25.856654 ], [ -81.678287, 25.845301 ], [ -81.684800, 25.847205 ], [ -81.689540, 25.852710 ], [ -81.713172, 25.897568 ], [ -81.717687, 25.902039 ], [ -81.727086, 25.907207 ], [ -81.731950, 25.931506 ], [ -81.738118, 25.942009 ], [ -81.745579, 25.949643 ], [ -81.749724, 25.960463 ], [ -81.747834, 25.994273 ], [ -81.750668, 25.998425 ], [ -81.757463, 26.000374 ], [ -81.762439, 26.006070 ], [ -81.801663, 26.088227 ], [ -81.808833, 26.152246 ], [ -81.814610, 26.173167 ], [ -81.816810, 26.207166 ], [ -81.820675, 26.236735 ], [ -81.833142, 26.294518 ], [ -81.844555, 26.327712 ], [ -81.845834, 26.330378 ], [ -81.868983, 26.378648 ], [ -81.901910, 26.410859 ], [ -81.902710, 26.416159 ], [ -81.911710, 26.427158 ], [ -81.923611, 26.436658 ], [ -81.938411, 26.445058 ], [ -81.956611, 26.452358 ], [ -81.964212, 26.457957 ], [ -81.967112, 26.462857 ], [ -81.966212, 26.465057 ], [ -81.969509, 26.476505 ], [ -81.980712, 26.480957 ], [ -81.997012, 26.484856 ], [ -82.008961, 26.484052 ], [ -82.013680, 26.490829 ], [ -82.009080, 26.505203 ], [ -82.024604, 26.512677 ], [ -82.043577, 26.519577 ], [ -82.067150, 26.513252 ], [ -82.071750, 26.492554 ], [ -82.094748, 26.483930 ], [ -82.105672, 26.483930 ], [ -82.111996, 26.540850 ], [ -82.118896, 26.560973 ], [ -82.122345, 26.579371 ], [ -82.137869, 26.637441 ], [ -82.149943, 26.654115 ], [ -82.181565, 26.681712 ], [ -82.179840, 26.696661 ], [ -82.173516, 26.701836 ], [ -82.151668, 26.704136 ], [ -82.139019, 26.702986 ], [ -82.125795, 26.699536 ], [ -82.118896, 26.690912 ], [ -82.106247, 26.667339 ], [ -82.099922, 26.662739 ], [ -82.093023, 26.665614 ], [ -82.086698, 26.685162 ], [ -82.084974, 26.702411 ], [ -82.079799, 26.716784 ], [ -82.066575, 26.742657 ], [ -82.062029, 26.770439 ], [ -82.061401, 26.774279 ], [ -82.061401, 26.789228 ], [ -82.055076, 26.802452 ], [ -82.057951, 26.822000 ], [ -82.058526, 26.838674 ], [ -82.056801, 26.858797 ], [ -82.059101, 26.876621 ], [ -82.066575, 26.882370 ], [ -82.090723, 26.888694 ], [ -82.093023, 26.906518 ], [ -82.090148, 26.923191 ], [ -82.083249, 26.927791 ], [ -82.067725, 26.927791 ], [ -82.061976, 26.931241 ], [ -82.061401, 26.938715 ], [ -82.063126, 26.950214 ], [ -82.076349, 26.958263 ], [ -82.107972, 26.957688 ], [ -82.113039, 26.955788 ], [ -82.117171, 26.954239 ], [ -82.124645, 26.945615 ], [ -82.137294, 26.926066 ], [ -82.162017, 26.925491 ], [ -82.169491, 26.923191 ], [ -82.175241, 26.916867 ], [ -82.172941, 26.897319 ], [ -82.156267, 26.851898 ], [ -82.147068, 26.789803 ], [ -82.151093, 26.783479 ], [ -82.172941, 26.778879 ], [ -82.178690, 26.772555 ], [ -82.209329, 26.772146 ], [ -82.221812, 26.771980 ], [ -82.232193, 26.782880 ], [ -82.233311, 26.784054 ], [ -82.234019, 26.783251 ], [ -82.241935, 26.774279 ], [ -82.251134, 26.755881 ], [ -82.259867, 26.717398 ], [ -82.263804, 26.725644 ], [ -82.264682, 26.756836 ], [ -82.269499, 26.784674 ], [ -82.271699, 26.789516 ], [ -82.281552, 26.811203 ], [ -82.289086, 26.827784 ], [ -82.301736, 26.841588 ], [ -82.351649, 26.908384 ], [ -82.375737, 26.946041 ], [ -82.400618, 26.984937 ], [ -82.419218, 27.020736 ], [ -82.445718, 27.060634 ], [ -82.460319, 27.099933 ], [ -82.465319, 27.110732 ], [ -82.468890, 27.113612 ], [ -82.477019, 27.141231 ], [ -82.512319, 27.207528 ], [ -82.539719, 27.254326 ], [ -82.545120, 27.261026 ], [ -82.559020, 27.268826 ], [ -82.569754, 27.279452 ], [ -82.569248, 27.298588 ], [ -82.576020, 27.309324 ], [ -82.597629, 27.335754 ], [ -82.623863, 27.362206 ], [ -82.642821, 27.389720 ], [ -82.642837, 27.389737 ], [ -82.675121, 27.424318 ], [ -82.691821, 27.437218 ], [ -82.691004, 27.444331 ], [ -82.707821, 27.487615 ], [ -82.714521, 27.500415 ], [ -82.724522, 27.513614 ], [ -82.743017, 27.531086 ], [ -82.745748, 27.538834 ], [ -82.742437, 27.539360 ], [ -82.708121, 27.523514 ], [ -82.710621, 27.501715 ], [ -82.706821, 27.498415 ], [ -82.690421, 27.496415 ], [ -82.686421, 27.497215 ], [ -82.686921, 27.508015 ], [ -82.683621, 27.513115 ], [ -82.674621, 27.519614 ], [ -82.662020, 27.522814 ], [ -82.650720, 27.523115 ], [ -82.646014, 27.533540 ], [ -82.632053, 27.551908 ], [ -82.612019, 27.571231 ], [ -82.613003, 27.582837 ], [ -82.612749, 27.583319 ], [ -82.611717, 27.585283 ], [ -82.596488, 27.594045 ], [ -82.584629, 27.596021 ], [ -82.570607, 27.608882 ], [ -82.565667, 27.615713 ], [ -82.558538, 27.638678 ], [ -82.554499, 27.645145 ], [ -82.537146, 27.672933 ], [ -82.514265, 27.705588 ], [ -82.494891, 27.718963 ], [ -82.482449, 27.719886 ], [ -82.477638, 27.723004 ], [ -82.476297, 27.729929 ], [ -82.477129, 27.735216 ], [ -82.482305, 27.742649 ], [ -82.478339, 27.746250 ], [ -82.457543, 27.752571 ], [ -82.434635, 27.764355 ], [ -82.431980, 27.768092 ], [ -82.433981, 27.774087 ], [ -82.419066, 27.793767 ], [ -82.418401, 27.803187 ], [ -82.410837, 27.810868 ], [ -82.402857, 27.812671 ], [ -82.393383, 27.837519 ], [ -82.397463, 27.851631 ], [ -82.402615, 27.882602 ], [ -82.413915, 27.901401 ], [ -82.432316, 27.901301 ], [ -82.451591, 27.907506 ], [ -82.460016, 27.911600 ], [ -82.459616, 27.916900 ], [ -82.462078, 27.920066 ], [ -82.478063, 27.927680 ], [ -82.489817, 27.919600 ], [ -82.491117, 27.914500 ], [ -82.487417, 27.895001 ], [ -82.488057, 27.863566 ], [ -82.480137, 27.853246 ], [ -82.471624, 27.847342 ], [ -82.468840, 27.843295 ], [ -82.472440, 27.822559 ], [ -82.475273, 27.820991 ], [ -82.489849, 27.822607 ], [ -82.511193, 27.828015 ], [ -82.553946, 27.848462 ], [ -82.552918, 27.862702 ], [ -82.538618, 27.864901 ], [ -82.533218, 27.870701 ], [ -82.529918, 27.877501 ], [ -82.539318, 27.885001 ], [ -82.542818, 27.890601 ], [ -82.541747, 27.893706 ], [ -82.535818, 27.898000 ], [ -82.531318, 27.903900 ], [ -82.533718, 27.932999 ], [ -82.541218, 27.948998 ], [ -82.553918, 27.966998 ], [ -82.589419, 27.970898 ], [ -82.619520, 27.969698 ], [ -82.648616, 27.966309 ], [ -82.716522, 27.958398 ], [ -82.720522, 27.955798 ], [ -82.724122, 27.948098 ], [ -82.721975, 27.941819 ], [ -82.721429, 27.940222 ], [ -82.720395, 27.937199 ], [ -82.720122, 27.936399 ], [ -82.710022, 27.928299 ], [ -82.691621, 27.924899 ], [ -82.685121, 27.916299 ], [ -82.671221, 27.913000 ], [ -82.628063, 27.910397 ], [ -82.634220, 27.903700 ], [ -82.632120, 27.891100 ], [ -82.610020, 27.873501 ], [ -82.567919, 27.883701 ], [ -82.567826, 27.881537 ], [ -82.566819, 27.858002 ], [ -82.598443, 27.857582 ], [ -82.594819, 27.843402 ], [ -82.589319, 27.835702 ], [ -82.586519, 27.816703 ], [ -82.607420, 27.798904 ], [ -82.622723, 27.779868 ], [ -82.630520, 27.753905 ], [ -82.625020, 27.732706 ], [ -82.625720, 27.727006 ], [ -82.633620, 27.710607 ], [ -82.639820, 27.703907 ], [ -82.652521, 27.700307 ], [ -82.662921, 27.702307 ], [ -82.663246, 27.702442 ], [ -82.667445, 27.704179 ], [ -82.668772, 27.704728 ], [ -82.670449, 27.705422 ], [ -82.670942, 27.705626 ], [ -82.671549, 27.705877 ], [ -82.671621, 27.705907 ], [ -82.672093, 27.705932 ], [ -82.673061, 27.705983 ], [ -82.674123, 27.706039 ], [ -82.677321, 27.706207 ], [ -82.679019, 27.696054 ], [ -82.679251, 27.694665 ], [ -82.693748, 27.700217 ], [ -82.713629, 27.698661 ], [ -82.718822, 27.692007 ], [ -82.723022, 27.671208 ], [ -82.721622, 27.663908 ], [ -82.716322, 27.651409 ], [ -82.712555, 27.646647 ], [ -82.698091, 27.638858 ], [ -82.705017, 27.625310 ], [ -82.733076, 27.612972 ], [ -82.736552, 27.617326 ], [ -82.737312, 27.623115 ], [ -82.737790, 27.626758 ], [ -82.739122, 27.636909 ], [ -82.738022, 27.706807 ], [ -82.740323, 27.718206 ], [ -82.746223, 27.731306 ], [ -82.753723, 27.736306 ], [ -82.760923, 27.745205 ], [ -82.770023, 27.767904 ], [ -82.783124, 27.783804 ], [ -82.790224, 27.791603 ], [ -82.820433, 27.813742 ], [ -82.828561, 27.822254 ], [ -82.846526, 27.854301 ], [ -82.849126, 27.863200 ], [ -82.851126, 27.886300 ], [ -82.847826, 27.910199 ], [ -82.840882, 27.937162 ], [ -82.831388, 27.962117 ], [ -82.824875, 27.960201 ], [ -82.821975, 27.956868 ], [ -82.830819, 27.930926 ], [ -82.838484, 27.909111 ], [ -82.832155, 27.909242 ], [ -82.820715, 27.927268 ], [ -82.808745, 27.953112 ], [ -82.805462, 27.960201 ], [ -82.797820, 27.990563 ], [ -82.792635, 28.011160 ], [ -82.792635, 28.032307 ], [ -82.782724, 28.055894 ], [ -82.783824, 28.106292 ], [ -82.782181, 28.120287 ], [ -82.781324, 28.127591 ], [ -82.786624, 28.144991 ], [ -82.790724, 28.152490 ], [ -82.799024, 28.151790 ], [ -82.808474, 28.154803 ], [ -82.805097, 28.172181 ], [ -82.797762, 28.187789 ], [ -82.762643, 28.219013 ], [ -82.764460, 28.220069 ], [ -82.764103, 28.244345 ], [ -82.759072, 28.254020 ], [ -82.746188, 28.261192 ], [ -82.732792, 28.291933 ], [ -82.735463, 28.300390 ], [ -82.731460, 28.325075 ], [ -82.715822, 28.345501 ], [ -82.706112, 28.368057 ], [ -82.706322, 28.401325 ], [ -82.697433, 28.420166 ], [ -82.684137, 28.428019 ], [ -82.678743, 28.433456 ], [ -82.677839, 28.434367 ], [ -82.674787, 28.441956 ], [ -82.680396, 28.457194 ], [ -82.672410, 28.464746 ], [ -82.665055, 28.484434 ], [ -82.664470, 28.488788 ], [ -82.666390, 28.497330 ], [ -82.670146, 28.500769 ], [ -82.669416, 28.519879 ], [ -82.668040, 28.528199 ], [ -82.663705, 28.530193 ], [ -82.656694, 28.544814 ], [ -82.661729, 28.549743 ], [ -82.661650, 28.554143 ], [ -82.657050, 28.568028 ], [ -82.654138, 28.590837 ], [ -82.664055, 28.606584 ], [ -82.656649, 28.623727 ], [ -82.658510, 28.636756 ], [ -82.654167, 28.668395 ], [ -82.646411, 28.694434 ], [ -82.645482, 28.697553 ], [ -82.652926, 28.705618 ], [ -82.656028, 28.712443 ], [ -82.652926, 28.719267 ], [ -82.656028, 28.727952 ], [ -82.662232, 28.737258 ], [ -82.651065, 28.747184 ], [ -82.645482, 28.767037 ], [ -82.643000, 28.782546 ], [ -82.643000, 28.789991 ], [ -82.648584, 28.796195 ], [ -82.650445, 28.804880 ], [ -82.652926, 28.830936 ], [ -82.638657, 28.843344 ], [ -82.643000, 28.860094 ], [ -82.639898, 28.876224 ], [ -82.644861, 28.889252 ], [ -82.656028, 28.899179 ], [ -82.673399, 28.900419 ], [ -82.688864, 28.905609 ], [ -82.702618, 28.932955 ], [ -82.708793, 28.935979 ], [ -82.723861, 28.953506 ], [ -82.735754, 28.973709 ], [ -82.737872, 28.995703 ], [ -82.758906, 28.993277 ], [ -82.760551, 28.993087 ], [ -82.764055, 28.999707 ], [ -82.759378, 29.006619 ], [ -82.753513, 29.026496 ], [ -82.759704, 29.054192 ], [ -82.783328, 29.064619 ], [ -82.780558, 29.073580 ], [ -82.816925, 29.076215 ], [ -82.823659, 29.098902 ], [ -82.809483, 29.104620 ], [ -82.801166, 29.105103 ], [ -82.799117, 29.110647 ], [ -82.798876, 29.114504 ], [ -82.805703, 29.129848 ], [ -82.804736, 29.146624 ], [ -82.827073, 29.158425 ], [ -82.858179, 29.162275 ], [ -82.887211, 29.161741 ], [ -82.922613, 29.169769 ], [ -82.932405, 29.167891 ], [ -82.945302, 29.167821 ], [ -82.974676, 29.170910 ], [ -82.979522, 29.171817 ], [ -82.987162, 29.180094 ], [ -82.991653, 29.180664 ], [ -82.996144, 29.178074 ], [ -83.018212, 29.151417 ], [ -83.019071, 29.141324 ], [ -83.030453, 29.134023 ], [ -83.053207, 29.130839 ], [ -83.056867, 29.146263 ], [ -83.068249, 29.153135 ], [ -83.060947, 29.170959 ], [ -83.061162, 29.176113 ], [ -83.065242, 29.184489 ], [ -83.078986, 29.196944 ], [ -83.087839, 29.216420 ], [ -83.074734, 29.247975 ], [ -83.077265, 29.255331 ], [ -83.089013, 29.266502 ], [ -83.107477, 29.268889 ], [ -83.125567, 29.278845 ], [ -83.128027, 29.282733 ], [ -83.146445, 29.289194 ], [ -83.149764, 29.289768 ], [ -83.160730, 29.286611 ], [ -83.166091, 29.288880 ], [ -83.169576, 29.290355 ], [ -83.176736, 29.314220 ], [ -83.178260, 29.327916 ], [ -83.176852, 29.329269 ], [ -83.175518, 29.344690 ], [ -83.189581, 29.363417 ], [ -83.200702, 29.373855 ], [ -83.202446, 29.394422 ], [ -83.218075, 29.420492 ], [ -83.240509, 29.433178 ], [ -83.263965, 29.435806 ], [ -83.272019, 29.432256 ], [ -83.294747, 29.437923 ], [ -83.307094, 29.459651 ], [ -83.307828, 29.468861 ], [ -83.311546, 29.475666 ], [ -83.323214, 29.476789 ], [ -83.331130, 29.475594 ], [ -83.350067, 29.489358 ], [ -83.356722, 29.499901 ], [ -83.370288, 29.499901 ], [ -83.379254, 29.503558 ], [ -83.383973, 29.512995 ], [ -83.400252, 29.517242 ], [ -83.401552, 29.523291 ], [ -83.399830, 29.533042 ], [ -83.405256, 29.578319 ], [ -83.405068, 29.595570 ], [ -83.399480, 29.612956 ], [ -83.404081, 29.640798 ], [ -83.412278, 29.666922 ], [ -83.412768, 29.668485 ], [ -83.414701, 29.670536 ], [ -83.436259, 29.677389 ], [ -83.444635, 29.677155 ], [ -83.448194, 29.675254 ], [ -83.455356, 29.676444 ], [ -83.483143, 29.690478 ], [ -83.483567, 29.698542 ], [ -83.493728, 29.708388 ], [ -83.512716, 29.716480 ], [ -83.537645, 29.723060 ], [ -83.547172, 29.732223 ], [ -83.554993, 29.742600 ], [ -83.566018, 29.761434 ], [ -83.578955, 29.768378 ], [ -83.584716, 29.776080 ], [ -83.586089, 29.784644 ], [ -83.583045, 29.787307 ], [ -83.581903, 29.792063 ], [ -83.585899, 29.811754 ], [ -83.595493, 29.827984 ], [ -83.605244, 29.836387 ], [ -83.618568, 29.842336 ], [ -83.637980, 29.886073 ], [ -83.659951, 29.899524 ], [ -83.679219, 29.918513 ], [ -83.686423, 29.923735 ], [ -83.757249, 29.957943 ], [ -83.788729, 29.976982 ], [ -83.828690, 29.983187 ], [ -83.845427, 29.998068 ], [ -83.931510, 30.039068 ], [ -83.933668, 30.041152 ], [ -83.931879, 30.044175 ], [ -83.933432, 30.046305 ], [ -83.959680, 30.064943 ], [ -83.991607, 30.083920 ], [ -84.000716, 30.096209 ], [ -84.024274, 30.103271 ], [ -84.048715, 30.103208 ], [ -84.062990, 30.101378 ], [ -84.076043, 30.095464 ], [ -84.083057, 30.092286 ], [ -84.087034, 30.092103 ], [ -84.094725, 30.094964 ], [ -84.102730, 30.093611 ], [ -84.113840, 30.085478 ], [ -84.124889, 30.090601 ], [ -84.135683, 30.083018 ], [ -84.157278, 30.072714 ], [ -84.167881, 30.071422 ], [ -84.179149, 30.073187 ], [ -84.198530, 30.087937 ], [ -84.201585, 30.087982 ], [ -84.203349, 30.085875 ], [ -84.208010, 30.084776 ], [ -84.237014, 30.085560 ], [ -84.245668, 30.093021 ], [ -84.247491, 30.101140 ], [ -84.256439, 30.103791 ], [ -84.269363, 30.097660 ], [ -84.272511, 30.092358 ], [ -84.274003, 30.083079 ], [ -84.270368, 30.075469 ], [ -84.270792, 30.068094 ], [ -84.277168, 30.060263 ], [ -84.289727, 30.057197 ], [ -84.297836, 30.057451 ], [ -84.315344, 30.069492 ], [ -84.342022, 30.063858 ], [ -84.358923, 30.058224 ], [ -84.365882, 30.024588 ], [ -84.361962, 29.987739 ], [ -84.359986, 29.984739 ], [ -84.347700, 29.984123 ], [ -84.343041, 29.975100 ], [ -84.341261, 29.960775 ], [ -84.339426, 29.946007 ], [ -84.336511, 29.942508 ], [ -84.333746, 29.923721 ], [ -84.335953, 29.912962 ], [ -84.343389, 29.899539 ], [ -84.349066, 29.896812 ], [ -84.378937, 29.893112 ], [ -84.404958, 29.901229 ], [ -84.423834, 29.902996 ], [ -84.434287, 29.906328 ], [ -84.443652, 29.913785 ], [ -84.451705, 29.929085 ], [ -84.470323, 29.924524 ], [ -84.494562, 29.913957 ], [ -84.511996, 29.916574 ], [ -84.535873, 29.910092 ], [ -84.577440, 29.887828 ], [ -84.603303, 29.876117 ], [ -84.613154, 29.867984 ], [ -84.647958, 29.847104 ], [ -84.656318, 29.837943 ], [ -84.656450, 29.834277 ], [ -84.669728, 29.828910 ], [ -84.683934, 29.831327 ], [ -84.692053, 29.829059 ], [ -84.730327, 29.806900 ], [ -84.755595, 29.788540 ], [ -84.762998, 29.788846 ], [ -84.824197, 29.758288 ], [ -84.837168, 29.755926 ], [ -84.868271, 29.742454 ], [ -84.881777, 29.733882 ], [ -84.888031, 29.722406 ], [ -84.892493, 29.722660 ], [ -84.901781, 29.735723 ], [ -84.890066, 29.755802 ], [ -84.877111, 29.772888 ], [ -84.893992, 29.785176 ], [ -84.904130, 29.786279 ], [ -84.915110, 29.783303 ], [ -84.920917, 29.772901 ], [ -84.938370, 29.750211 ], [ -84.946595, 29.745032 ], [ -84.964007, 29.742422 ], [ -84.968841, 29.727080 ], [ -84.977004, 29.721209 ], [ -84.993264, 29.714961 ], [ -85.037212, 29.711074 ], [ -85.072123, 29.719027 ], [ -85.101682, 29.718748 ], [ -85.121473, 29.715854 ], [ -85.153238, 29.708231 ], [ -85.177284, 29.700193 ], [ -85.217355, 29.694953 ], [ -85.227450, 29.693633 ], [ -85.259719, 29.681296 ], [ -85.290740, 29.684081 ], [ -85.319215, 29.681494 ], [ -85.343619, 29.672004 ], [ -85.347711, 29.667190 ], [ -85.344768, 29.654793 ], [ -85.352615, 29.659787 ], [ -85.369419, 29.681048 ], [ -85.380303, 29.698485 ], [ -85.397871, 29.740498 ], [ -85.413983, 29.799865 ], [ -85.417971, 29.828855 ], [ -85.416548, 29.842628 ], [ -85.413575, 29.852940 ], [ -85.405815, 29.865817 ], [ -85.392469, 29.870914 ], [ -85.398740, 29.859267 ], [ -85.405011, 29.830151 ], [ -85.405907, 29.801930 ], [ -85.395528, 29.762368 ], [ -85.377960, 29.709621 ], [ -85.363800, 29.693526 ], [ -85.353885, 29.684765 ], [ -85.344986, 29.685015 ], [ -85.317661, 29.691286 ], [ -85.311390, 29.697557 ], [ -85.301331, 29.797117 ], [ -85.302591, 29.808094 ], [ -85.304877, 29.811096 ], [ -85.311420, 29.814373 ], [ -85.314547, 29.822279 ], [ -85.314783, 29.830575 ], [ -85.312911, 29.832273 ], [ -85.317464, 29.838894 ], [ -85.325008, 29.844966 ], [ -85.332289, 29.845905 ], [ -85.336654, 29.849295 ], [ -85.347044, 29.871981 ], [ -85.363731, 29.898915 ], [ -85.384730, 29.920949 ], [ -85.388677, 29.924355 ], [ -85.405052, 29.938487 ], [ -85.425956, 29.949888 ], [ -85.460488, 29.959579 ], [ -85.469425, 29.957788 ], [ -85.487764, 29.961227 ], [ -85.509148, 29.971466 ], [ -85.541176, 29.995791 ], [ -85.571907, 30.026440 ], [ -85.581390, 30.037783 ], [ -85.588242, 30.055543 ], [ -85.601178, 30.056342 ], [ -85.618254, 30.065481 ], [ -85.637285, 30.073319 ], [ -85.653251, 30.077839 ], [ -85.696810, 30.096890 ], [ -85.730054, 30.118153 ], [ -85.749930, 30.136537 ], [ -85.775405, 30.156290 ], [ -85.811219, 30.178320 ], [ -85.878138, 30.215619 ], [ -85.922600, 30.238024 ], [ -85.996083, 30.269148 ], [ -85.999937, 30.270780 ], [ -86.089963, 30.303569 ], [ -86.222561, 30.343585 ], [ -86.298700, 30.363049 ], [ -86.364175, 30.374524 ], [ -86.397325, 30.378553 ], [ -86.400403, 30.378927 ], [ -86.412076, 30.380346 ], [ -86.429322, 30.381389 ], [ -86.454731, 30.382925 ], [ -86.456197, 30.383014 ], [ -86.457045, 30.383065 ], [ -86.470849, 30.383900 ], [ -86.473990, 30.383758 ], [ -86.506150, 30.382300 ], [ -86.529067, 30.386896 ], [ -86.632953, 30.396299 ], [ -86.750906, 30.391881 ], [ -86.800283, 30.386477 ], [ -86.850625, 30.380967 ], [ -86.909679, 30.372423 ], [ -86.919292, 30.370675 ], [ -87.155392, 30.327748 ], [ -87.206254, 30.320943 ], [ -87.267827, 30.315480 ], [ -87.282787, 30.318744 ], [ -87.295422, 30.323503 ], [ -87.319518, 30.317814 ], [ -87.350486, 30.313064 ], [ -87.419859, 30.297128 ], [ -87.518324, 30.280435 ], [ -87.452378, 30.300201 ], [ -87.450078, 30.311100 ], [ -87.450962, 30.346262 ], [ -87.451378, 30.367199 ], [ -87.440678, 30.391498 ], [ -87.427478, 30.408398 ], [ -87.419177, 30.410198 ], [ -87.430578, 30.491096 ], [ -87.448332, 30.513063 ], [ -87.449841, 30.514369 ], [ -87.449921, 30.514690 ], [ -87.394479, 30.625192 ], [ -87.394219, 30.641699 ], [ -87.396997, 30.653640 ], [ -87.407118, 30.671796 ], [ -87.449362, 30.698913 ], [ -87.481225, 30.716508 ], [ -87.497515, 30.720123 ], [ -87.502926, 30.722369 ], [ -87.532607, 30.743489 ], [ -87.624137, 30.845713 ], [ -87.634938, 30.865886 ], [ -87.622203, 30.897508 ], [ -87.601355, 30.936294 ], [ -87.594111, 30.976335 ], [ -87.598927, 30.997454 ], [ -87.598928, 30.997457 ], [ -87.571281, 30.997870 ], [ -87.548543, 30.997927 ], [ -87.480243, 30.998202 ], [ -87.479703, 30.998197 ], [ -87.478706, 30.998213 ], [ -87.466879, 30.998178 ], [ -87.466827, 30.998178 ], [ -87.461783, 30.998201 ], [ -87.461638, 30.998202 ], [ -87.458658, 30.998386 ], [ -87.455705, 30.998318 ], [ -87.449811, 30.998272 ], [ -87.432292, 30.998205 ], [ -87.425774, 30.998090 ], [ -87.367842, 30.998292 ], [ -87.364011, 30.998218 ], [ -87.355656, 30.998244 ], [ -87.333973, 30.998272 ], [ -87.312183, 30.998435 ], [ -87.304030, 30.998191 ], [ -87.301567, 30.998434 ], [ -87.290995, 30.998352 ], [ -87.288905, 30.998345 ], [ -87.265564, 30.998267 ], [ -87.260540, 30.998195 ], [ -87.259689, 30.998172 ], [ -87.257960, 30.998263 ], [ -87.257002, 30.998194 ], [ -87.255592, 30.998216 ], [ -87.254980, 30.998285 ], [ -87.163084, 30.999051 ], [ -87.162614, 30.999055 ], [ -87.068633, 30.999143 ], [ -87.064063, 30.999191 ], [ -87.053737, 30.999131 ], [ -87.039989, 30.999594 ], [ -87.036366, 30.999348 ], [ -87.027107, 30.999255 ], [ -86.888135, 30.997577 ], [ -86.872989, 30.997631 ], [ -86.831934, 30.997378 ], [ -86.830497, 30.997401 ], [ -86.785918, 30.996978 ], [ -86.785692, 30.996977 ], [ -86.728392, 30.996739 ], [ -86.727293, 30.996882 ], [ -86.725379, 30.996872 ], [ -86.688294, 30.995029 ], [ -86.678383, 30.994537 ], [ -86.664681, 30.994534 ], [ -86.567586, 30.995109 ], [ -86.563436, 30.995223 ], [ -86.519938, 30.993245 ], [ -86.512834, 30.993700 ], [ -86.458319, 30.993998 ], [ -86.454704, 30.993791 ], [ -86.404912, 30.994049 ], [ -86.391937, 30.994172 ], [ -86.388647, 30.994181 ], [ -86.388646, 30.994181 ], [ -86.374545, 30.994474 ], [ -86.369270, 30.994477 ], [ -86.364907, 30.994455 ], [ -86.304596, 30.994029 ], [ -86.289247, 30.993798 ], [ -86.187246, 30.993992 ], [ -86.180232, 30.994005 ], [ -86.175204, 30.993798 ], [ -86.168979, 30.993706 ], [ -86.162886, 30.993682 ], [ -86.056213, 30.993133 ], [ -86.052462, 30.993247 ], [ -86.035039, 30.993320 ], [ -85.498272, 30.996928 ], [ -85.497992, 30.996931 ], [ -85.488298, 30.997041 ], [ -85.154452, 31.000835 ], [ -85.152218, 31.000834 ], [ -85.152085, 31.000888 ], [ -85.145835, 31.000695 ], [ -85.057534, 31.000585 ], [ -85.054802, 31.000585 ], [ -85.052088, 31.000585 ], [ -85.031155, 31.000647 ], [ -85.030107, 31.000653 ], [ -85.027512, 31.000670 ], [ -85.024108, 31.000681 ], [ -85.002368, 31.000682 ], [ -84.998628, 30.971386 ], [ -84.983527, 30.935486 ], [ -84.959626, 30.910587 ], [ -84.941925, 30.887988 ], [ -84.896122, 30.750591 ], [ -84.864693, 30.711542 ], [ -84.863465, 30.711487 ], [ -84.606386, 30.699865 ], [ -84.606249, 30.699872 ], [ -84.539370, 30.696775 ], [ -84.535042, 30.696523 ], [ -84.380719, 30.689673 ], [ -84.282562, 30.685316 ], [ -84.281210, 30.685256 ], [ -84.083753, 30.675954 ], [ -84.057228, 30.674705 ], [ -84.046605, 30.674200 ], [ -84.041810, 30.673878 ], [ -84.039707, 30.673819 ], [ -84.007454, 30.672100 ], [ -84.007391, 30.672097 ], [ -83.880317, 30.665807 ], [ -83.880220, 30.665832 ], [ -83.855216, 30.664412 ], [ -83.820886, 30.662612 ], [ -83.810536, 30.661880 ], [ -83.743729, 30.658396 ], [ -83.676773, 30.654905 ], [ -83.674058, 30.654747 ], [ -83.611720, 30.651258 ], [ -83.611667, 30.651255 ], [ -83.448895, 30.642410 ], [ -83.440021, 30.642023 ], [ -83.429584, 30.641496 ], [ -83.429477, 30.641519 ], [ -83.390062, 30.639333 ], [ -83.379460, 30.638680 ], [ -83.357703, 30.637359 ], [ -83.341011, 30.636346 ], [ -83.340852, 30.636336 ], [ -83.311647, 30.634577 ], [ -83.309455, 30.634417 ] ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US16", "STATE": 28, "name": "Idaho", "LSAD": "", "CENSUSAREA": 82643.117000 }, "geometry": { "type": "Polygon", "coordinates": [ [ [ -111.048974, 44.474072 ], [ -111.049194, 44.438058 ], [ -111.049216, 44.435811 ], [ -111.048633, 44.062903 ], [ -111.048751, 44.060838 ], [ -111.048751, 44.060403 ], [ -111.048107, 43.983096 ], [ -111.046715, 43.815832 ], [ -111.046340, 43.726957 ], [ -111.046435, 43.726545 ], [ -111.046421, 43.722059 ], [ -111.046110, 43.687848 ], [ -111.046051, 43.685812 ], [ -111.046118, 43.684902 ], [ -111.045880, 43.681033 ], [ -111.045706, 43.659112 ], [ -111.045205, 43.501136 ], [ -111.044617, 43.315720 ], [ -111.044229, 43.195579 ], [ -111.044168, 43.189244 ], [ -111.044232, 43.184440 ], [ -111.044266, 43.177236 ], [ -111.044235, 43.177121 ], [ -111.044143, 43.072364 ], [ -111.044162, 43.068222 ], [ -111.044150, 43.066172 ], [ -111.044117, 43.060309 ], [ -111.044086, 43.054819 ], [ -111.044063, 43.046302 ], [ -111.044058, 43.044640 ], [ -111.043997, 43.041415 ], [ -111.044094, 43.029270 ], [ -111.044033, 43.026411 ], [ -111.044034, 43.024844 ], [ -111.044034, 43.024581 ], [ -111.044206, 43.022614 ], [ -111.044156, 43.020052 ], [ -111.044129, 43.018702 ], [ -111.043924, 42.975063 ], [ -111.043957, 42.969482 ], [ -111.043959, 42.964450 ], [ -111.046249, 42.513116 ], [ -111.047080, 42.349420 ], [ -111.047074, 42.280787 ], [ -111.047097, 42.194773 ], [ -111.047058, 42.182672 ], [ -111.047107, 42.148971 ], [ -111.047109, 42.142497 ], [ -111.046689, 42.001567 ], [ -111.415873, 42.000748 ], [ -111.420898, 42.000793 ], [ -111.425535, 42.000840 ], [ -111.507264, 41.999518 ], [ -111.876491, 41.998528 ], [ -111.915622, 41.998496 ], [ -111.915837, 41.998519 ], [ -112.109528, 41.997105 ], [ -112.163956, 41.996708 ], [ -112.239107, 42.001217 ], [ -112.264936, 42.000991 ], [ -112.386170, 42.001126 ], [ -112.450567, 42.001092 ], [ -112.450814, 42.000953 ], [ -112.648019, 42.000307 ], [ -112.709375, 42.000309 ], [ -112.788542, 41.999681 ], [ -112.833084, 41.999305 ], [ -112.833125, 41.999345 ], [ -112.880619, 41.998921 ], [ -112.882367, 41.998922 ], [ -112.909587, 41.998791 ], [ -112.979218, 41.998263 ], [ -113.000820, 41.998223 ], [ -113.000821, 41.998223 ], [ -113.396497, 41.994250 ], [ -113.402230, 41.994161 ], [ -113.431563, 41.993799 ], [ -113.764530, 41.989459 ], [ -113.796082, 41.989104 ], [ -113.893261, 41.988057 ], [ -114.041723, 41.993720 ], [ -114.048246, 41.993721 ], [ -114.048257, 41.993814 ], [ -114.061774, 41.993797 ], [ -114.061763, 41.993939 ], [ -114.107259, 41.993831 ], [ -114.107428, 41.993965 ], [ -114.281854, 41.994264 ], [ -114.498243, 41.994636 ], [ -114.498259, 41.994599 ], [ -114.598267, 41.994511 ], [ -114.763825, 41.999909 ], [ -114.914187, 41.999909 ], [ -115.031783, 41.996008 ], [ -115.038256, 41.996025 ], [ -115.986880, 41.998534 ], [ -116.012212, 41.998035 ], [ -116.012219, 41.998048 ], [ -116.018945, 41.997722 ], [ -116.018960, 41.997762 ], [ -116.030758, 41.997383 ], [ -116.030754, 41.997399 ], [ -116.038570, 41.997413 ], [ -116.038602, 41.997460 ], [ -116.160833, 41.997508 ], [ -116.163931, 41.997555 ], [ -116.463528, 41.996547 ], [ -116.483094, 41.996885 ], [ -116.485823, 41.996861 ], [ -116.510452, 41.997096 ], [ -116.586937, 41.997370 ], [ -116.626770, 41.997750 ], [ -117.018294, 41.999358 ], [ -117.026222, 42.000252 ], [ -117.026331, 42.807015 ], [ -117.026303, 42.807170 ], [ -117.026253, 42.807447 ], [ -117.026683, 43.024876 ], [ -117.026652, 43.025128 ], [ -117.026746, 43.577526 ], [ -117.026774, 43.578674 ], [ -117.026922, 43.593632 ], [ -117.026889, 43.596033 ], [ -117.026824, 43.600357 ], [ -117.026760, 43.601912 ], [ -117.026789, 43.610669 ], [ -117.026937, 43.617614 ], [ -117.027001, 43.621032 ], [ -117.026905, 43.624880 ], [ -117.026705, 43.631659 ], [ -117.026661, 43.664385 ], [ -117.026717, 43.675523 ], [ -117.026623, 43.680865 ], [ -117.026586, 43.683001 ], [ -117.026825, 43.706193 ], [ -117.026725, 43.714815 ], [ -117.026841, 43.732905 ], [ -117.026651, 43.733935 ], [ -117.026634, 43.808104 ], [ -116.996504, 43.864714 ], [ -116.982482, 43.872799 ], [ -116.979186, 43.879973 ], [ -116.961535, 43.918388 ], [ -116.935301, 43.988616 ], [ -116.931719, 44.102474 ], [ -116.897145, 44.152537 ], [ -116.895931, 44.154295 ], [ -116.894083, 44.160191 ], [ -116.895757, 44.171267 ], [ -116.902752, 44.179467 ], [ -116.975905, 44.242844 ], [ -116.986870, 44.245477 ], [ -117.027558, 44.248881 ], [ -117.033170, 44.248192 ], [ -117.041144, 44.243653 ], [ -117.170342, 44.258890 ], [ -117.190107, 44.273958 ], [ -117.196597, 44.287529 ], [ -117.197777, 44.295789 ], [ -117.197506, 44.297280 ], [ -117.196597, 44.302280 ], [ -117.194827, 44.310540 ], [ -117.191546, 44.329621 ], [ -117.189769, 44.336585 ], [ -117.214889, 44.466901 ], [ -117.208454, 44.485928 ], [ -117.156489, 44.528312 ], [ -117.149242, 44.536151 ], [ -117.144161, 44.545647 ], [ -117.115900, 44.623339 ], [ -117.095868, 44.664737 ], [ -117.062273, 44.727143 ], [ -117.044217, 44.745140 ], [ -117.038270, 44.748179 ], [ -117.016216, 44.755572 ], [ -116.931499, 44.792281 ], [ -116.891463, 44.840531 ], [ -116.852427, 44.887577 ], [ -116.831990, 44.933007 ], [ -116.835702, 44.940633 ], [ -116.844653, 44.949338 ], [ -116.850737, 44.958113 ], [ -116.858277, 44.978008 ], [ -116.845369, 45.017059 ], [ -116.783902, 45.079022 ], [ -116.729607, 45.142091 ], [ -116.709536, 45.203015 ], [ -116.696047, 45.254679 ], [ -116.691197, 45.269245 ], [ -116.673793, 45.321511 ], [ -116.553473, 45.499107 ], [ -116.481208, 45.580597 ], [ -116.463635, 45.602785 ], [ -116.463504, 45.615785 ], [ -116.471504, 45.628467 ], [ -116.489120, 45.651140 ], [ -116.510938, 45.668114 ], [ -116.528272, 45.681473 ], [ -116.535396, 45.691734 ], [ -116.538014, 45.714929 ], [ -116.535698, 45.734231 ], [ -116.548090, 45.752364 ], [ -116.594210, 45.779080 ], [ -116.633377, 45.784681 ], [ -116.789099, 45.847749 ], [ -116.796418, 45.853807 ], [ -116.857254, 45.904159 ], [ -116.866544, 45.916958 ], [ -116.875125, 45.942200 ], [ -116.915989, 45.995413 ], [ -116.943530, 46.062173 ], [ -116.925621, 46.158888 ], [ -116.958801, 46.242320 ], [ -116.985333, 46.294617 ], [ -116.987939, 46.298031 ], [ -117.047469, 46.342884 ], [ -117.061045, 46.367747 ], [ -117.046915, 46.379577 ], [ -117.039813, 46.425425 ], [ -117.039741, 46.462704 ], [ -117.039763, 46.469570 ], [ -117.039771, 46.471779 ], [ -117.039783, 46.541785 ], [ -117.039828, 46.815443 ], [ -117.039657, 46.825798 ], [ -117.039821, 47.127265 ], [ -117.039836, 47.154734 ], [ -117.039871, 47.181858 ], [ -117.039888, 47.203282 ], [ -117.039899, 47.225515 ], [ -117.040019, 47.259272 ], [ -117.039843, 47.347201 ], [ -117.039857, 47.366093 ], [ -117.039882, 47.399085 ], [ -117.039950, 47.412412 ], [ -117.039948, 47.434885 ], [ -117.039971, 47.463309 ], [ -117.039945, 47.477823 ], [ -117.040514, 47.522351 ], [ -117.040545, 47.527562 ], [ -117.040745, 47.532909 ], [ -117.041276, 47.558210 ], [ -117.041174, 47.558530 ], [ -117.041431, 47.678140 ], [ -117.041431, 47.678185 ], [ -117.041431, 47.680000 ], [ -117.041532, 47.683194 ], [ -117.041633, 47.706400 ], [ -117.041678, 47.722710 ], [ -117.042135, 47.744100 ], [ -117.042059, 47.745100 ], [ -117.042657, 47.760857 ], [ -117.042623, 47.761223 ], [ -117.042521, 47.764896 ], [ -117.042485, 47.766525 ], [ -117.041874, 47.977387 ], [ -117.041676, 48.045560 ], [ -117.041401, 48.085500 ], [ -117.039552, 48.173960 ], [ -117.039413, 48.177250 ], [ -117.039618, 48.178142 ], [ -117.039583, 48.180313 ], [ -117.039582, 48.180853 ], [ -117.039582, 48.181124 ], [ -117.039615, 48.184015 ], [ -117.039599, 48.184387 ], [ -117.035178, 48.370878 ], [ -117.035178, 48.371221 ], [ -117.035289, 48.422732 ], [ -117.035254, 48.423144 ], [ -117.035285, 48.429816 ], [ -117.035285, 48.430113 ], [ -117.034499, 48.620769 ], [ -117.034358, 48.628523 ], [ -117.033177, 48.846563 ], [ -117.032351, 48.999188 ], [ -116.757185, 48.999791 ], [ -116.757234, 48.999943 ], [ -116.049193, 49.000912 ], [ -116.049025, 48.958351 ], [ -116.049023, 48.957947 ], [ -116.049226, 48.502058 ], [ -116.049353, 48.215460 ], [ -116.049415, 48.077220 ], [ -116.049398, 48.075395 ], [ -116.049368, 48.072134 ], [ -116.049320, 48.066644 ], [ -116.048424, 47.977126 ], [ -116.048421, 47.976820 ], [ -116.007254, 47.944968 ], [ -115.919291, 47.857406 ], [ -115.729123, 47.703102 ], [ -115.723770, 47.696671 ], [ -115.706284, 47.637864 ], [ -115.718072, 47.592675 ], [ -115.721207, 47.576323 ], [ -115.735755, 47.555346 ], [ -115.739684, 47.537663 ], [ -115.729861, 47.518016 ], [ -115.712178, 47.488546 ], [ -115.725931, 47.466934 ], [ -115.729861, 47.447287 ], [ -115.721084, 47.422350 ], [ -115.690570, 47.415059 ], [ -115.661341, 47.402663 ], [ -115.576836, 47.366825 ], [ -115.561439, 47.351887 ], [ -115.551309, 47.333856 ], [ -115.523690, 47.298919 ], [ -115.479255, 47.282089 ], [ -115.421645, 47.271736 ], [ -115.339201, 47.261623 ], [ -115.320184, 47.255717 ], [ -115.294785, 47.220914 ], [ -115.292110, 47.209861 ], [ -115.266723, 47.181101 ], [ -115.200547, 47.139154 ], [ -115.193221, 47.133026 ], [ -115.099178, 47.048129 ], [ -115.072985, 47.013760 ], [ -114.975789, 46.932865 ], [ -114.936015, 46.899761 ], [ -114.938713, 46.869021 ], [ -114.927837, 46.835990 ], [ -114.920459, 46.827697 ], [ -114.888146, 46.808573 ], [ -114.853279, 46.799794 ], [ -114.825923, 46.781949 ], [ -114.767180, 46.738828 ], [ -114.739253, 46.715167 ], [ -114.717645, 46.713994 ], [ -114.690630, 46.719961 ], [ -114.675505, 46.719516 ], [ -114.667346, 46.719276 ], [ -114.655704, 46.711743 ], [ -114.644747, 46.702155 ], [ -114.642692, 46.694622 ], [ -114.641322, 46.686404 ], [ -114.641745, 46.679286 ], [ -114.642713, 46.673145 ], [ -114.635868, 46.659510 ], [ -114.614423, 46.639188 ], [ -114.594707, 46.633558 ], [ -114.592264, 46.632861 ], [ -114.481943, 46.631993 ], [ -114.461211, 46.639151 ], [ -114.446830, 46.645314 ], [ -114.422176, 46.652163 ], [ -114.370129, 46.654217 ], [ -114.349584, 46.646684 ], [ -114.341336, 46.642803 ], [ -114.337942, 46.641205 ], [ -114.331093, 46.630248 ], [ -114.331093, 46.607649 ], [ -114.346528, 46.535789 ], [ -114.385297, 46.467162 ], [ -114.378000, 46.435371 ], [ -114.426885, 46.289671 ], [ -114.472643, 46.162202 ], [ -114.483120, 46.129147 ], [ -114.476284, 46.112988 ], [ -114.468205, 46.099937 ], [ -114.467583, 46.081914 ], [ -114.476284, 46.062026 ], [ -114.491200, 46.044003 ], [ -114.491200, 46.034059 ], [ -114.490578, 46.022872 ], [ -114.483379, 46.008047 ], [ -114.465376, 45.996077 ], [ -114.429638, 45.986638 ], [ -114.412007, 45.978057 ], [ -114.401552, 45.963195 ], [ -114.393760, 45.894020 ], [ -114.448680, 45.858891 ], [ -114.498809, 45.850676 ], [ -114.509303, 45.845531 ], [ -114.514596, 45.840785 ], [ -114.566172, 45.773864 ], [ -114.547763, 45.743309 ], [ -114.528667, 45.731636 ], [ -114.504869, 45.722176 ], [ -114.497553, 45.710677 ], [ -114.495421, 45.703321 ], [ -114.500925, 45.666715 ], [ -114.515411, 45.652842 ], [ -114.541820, 45.641305 ], [ -114.545574, 45.642928 ], [ -114.550834, 45.642600 ], [ -114.561046, 45.639906 ], [ -114.563652, 45.637412 ], [ -114.561773, 45.565109 ], [ -114.560855, 45.564575 ], [ -114.551286, 45.559007 ], [ -114.514196, 45.564734 ], [ -114.473759, 45.563278 ], [ -114.460542, 45.561283 ], [ -114.366620, 45.491616 ], [ -114.350819, 45.468542 ], [ -114.309613, 45.469432 ], [ -114.247828, 45.545489 ], [ -114.187852, 45.542151 ], [ -114.135249, 45.557465 ], [ -114.034930, 45.647967 ], [ -114.022534, 45.679620 ], [ -114.019315, 45.692937 ], [ -114.015633, 45.696127 ], [ -113.987759, 45.705247 ], [ -113.971565, 45.700636 ], [ -113.942600, 45.686362 ], [ -113.934220, 45.682232 ], [ -113.896681, 45.641451 ], [ -113.835396, 45.612960 ], [ -113.813933, 45.600559 ], [ -113.804871, 45.589112 ], [ -113.802009, 45.579096 ], [ -113.813456, 45.550002 ], [ -113.810117, 45.530924 ], [ -113.786269, 45.521385 ], [ -113.772915, 45.512322 ], [ -113.765760, 45.483228 ], [ -113.774156, 45.465372 ], [ -113.760924, 45.406501 ], [ -113.738729, 45.329741 ], [ -113.674409, 45.249411 ], [ -113.650064, 45.234710 ], [ -113.599506, 45.191114 ], [ -113.565979, 45.149335 ], [ -113.566179, 45.143120 ], [ -113.576360, 45.133771 ], [ -113.576453, 45.130311 ], [ -113.485278, 45.063519 ], [ -113.473770, 45.061700 ], [ -113.463961, 45.063194 ], [ -113.449349, 45.045745 ], [ -113.445751, 45.018351 ], [ -113.445915, 44.979918 ], [ -113.447199, 44.971924 ], [ -113.472715, 44.948123 ], [ -113.480836, 44.950310 ], [ -113.494446, 44.948597 ], [ -113.498745, 44.942314 ], [ -113.475838, 44.894648 ], [ -113.455071, 44.865424 ], [ -113.353631, 44.791395 ], [ -113.341704, 44.784853 ], [ -113.329491, 44.788645 ], [ -113.278382, 44.812706 ], [ -113.247166, 44.822950 ], [ -113.207878, 44.808040 ], [ -113.158206, 44.780847 ], [ -113.134617, 44.763149 ], [ -113.101082, 44.718832 ], [ -113.051504, 44.636950 ], [ -113.049349, 44.629380 ], [ -113.053529, 44.621187 ], [ -113.056770, 44.618657 ], [ -113.027147, 44.495915 ], [ -113.003544, 44.450814 ], [ -112.970300, 44.426933 ], [ -112.875822, 44.374357 ], [ -112.849266, 44.371038 ], [ -112.831340, 44.381660 ], [ -112.829247, 44.385427 ], [ -112.824701, 44.393611 ], [ -112.823373, 44.406225 ], [ -112.822046, 44.420831 ], [ -112.822046, 44.434109 ], [ -112.812087, 44.451370 ], [ -112.781294, 44.484888 ], [ -112.719110, 44.504344 ], [ -112.688160, 44.498850 ], [ -112.544224, 44.483763 ], [ -112.473207, 44.480027 ], [ -112.410345, 44.462968 ], [ -112.387080, 44.460476 ], [ -112.371294, 44.472108 ], [ -112.358926, 44.486280 ], [ -112.356600, 44.493127 ], [ -112.347199, 44.520298 ], [ -112.339721, 44.538577 ], [ -112.299009, 44.559348 ], [ -112.274083, 44.564334 ], [ -112.258297, 44.564334 ], [ -112.246665, 44.561010 ], [ -112.235864, 44.555194 ], [ -112.229477, 44.549494 ], [ -112.221698, 44.543519 ], [ -112.187115, 44.534452 ], [ -112.078471, 44.533551 ], [ -111.947941, 44.556776 ], [ -111.870504, 44.564033 ], [ -111.849293, 44.539837 ], [ -111.843295, 44.528225 ], [ -111.806528, 44.515459 ], [ -111.737191, 44.543060 ], [ -111.704218, 44.560205 ], [ -111.631505, 44.552022 ], [ -111.617502, 44.553035 ], [ -111.601249, 44.554210 ], [ -111.525764, 44.604883 ], [ -111.516588, 44.643707 ], [ -111.489008, 44.705553 ], [ -111.481536, 44.709186 ], [ -111.394815, 44.751351 ], [ -111.377682, 44.751744 ], [ -111.323669, 44.724474 ], [ -111.219236, 44.622616 ], [ -111.139455, 44.517112 ], [ -111.131379, 44.499925 ], [ -111.122654, 44.493659 ], [ -111.106574, 44.486330 ], [ -111.048974, 44.474072 ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US20", "STATE": 29, "name": "Kansas", "LSAD": "", "CENSUSAREA": 81758.717000 }, "geometry": { "type": "Polygon", "coordinates": [ [ [ -99.541116, 36.999573 ], [ -99.558068, 36.999528 ], [ -99.625399, 36.999671 ], [ -99.657658, 37.000197 ], [ -99.774255, 37.000837 ], [ -99.774816, 37.000841 ], [ -99.786016, 37.000931 ], [ -99.995201, 37.001631 ], [ -100.001286, 37.001699 ], [ -100.002563, 37.001706 ], [ -100.005706, 37.001726 ], [ -100.089484, 37.002092 ], [ -100.115722, 37.002206 ], [ -100.187547, 37.002082 ], [ -100.192371, 37.002036 ], [ -100.193754, 37.002133 ], [ -100.201676, 37.002081 ], [ -100.551598, 37.000620 ], [ -100.552683, 37.000735 ], [ -100.591328, 37.000376 ], [ -100.591413, 37.000399 ], [ -100.629770, 37.000025 ], [ -100.633323, 36.999936 ], [ -100.633327, 36.999936 ], [ -100.675552, 36.999688 ], [ -100.756894, 36.999357 ], [ -100.765484, 36.999177 ], [ -100.806116, 36.999091 ], [ -100.814277, 36.999085 ], [ -100.855634, 36.998626 ], [ -100.891660, 36.998604 ], [ -100.904274, 36.998745 ], [ -100.904588, 36.998561 ], [ -100.945469, 36.998153 ], [ -100.945566, 36.998152 ], [ -100.996502, 36.998044 ], [ -101.012641, 36.998176 ], [ -101.053589, 36.997967 ], [ -101.066742, 36.997921 ], [ -101.211486, 36.997124 ], [ -101.212909, 36.997044 ], [ -101.357797, 36.996271 ], [ -101.359674, 36.996232 ], [ -101.378180, 36.996164 ], [ -101.413868, 36.996008 ], [ -101.415005, 36.995966 ], [ -101.485326, 36.995611 ], [ -101.519066, 36.995546 ], [ -101.555239, 36.995414 ], [ -101.555260, 36.995414 ], [ -101.600396, 36.995153 ], [ -101.601593, 36.995095 ], [ -101.902440, 36.993702 ], [ -102.000447, 36.993249 ], [ -102.000447, 36.993272 ], [ -102.028204, 36.993125 ], [ -102.028207, 36.993125 ], [ -102.042240, 36.993083 ], [ -102.041952, 37.024742 ], [ -102.041950, 37.030805 ], [ -102.041921, 37.032178 ], [ -102.041749, 37.034397 ], [ -102.041920, 37.035083 ], [ -102.041983, 37.106551 ], [ -102.041809, 37.111973 ], [ -102.042092, 37.125021 ], [ -102.042135, 37.125021 ], [ -102.042002, 37.141744 ], [ -102.041963, 37.258164 ], [ -102.041664, 37.297650 ], [ -102.041817, 37.309490 ], [ -102.041974, 37.352613 ], [ -102.042089, 37.352819 ], [ -102.041826, 37.389191 ], [ -102.041676, 37.409898 ], [ -102.041669, 37.434740 ], [ -102.041755, 37.434855 ], [ -102.041801, 37.469488 ], [ -102.041786, 37.506066 ], [ -102.042016, 37.535261 ], [ -102.041899, 37.541186 ], [ -102.041894, 37.557977 ], [ -102.041618, 37.607868 ], [ -102.041585, 37.644282 ], [ -102.041582, 37.654495 ], [ -102.041694, 37.665681 ], [ -102.041574, 37.680436 ], [ -102.041876, 37.723875 ], [ -102.041990, 37.738541 ], [ -102.042158, 37.760164 ], [ -102.042668, 37.788758 ], [ -102.042953, 37.803535 ], [ -102.043033, 37.824146 ], [ -102.043219, 37.867929 ], [ -102.043845, 37.926135 ], [ -102.043844, 37.928102 ], [ -102.044398, 38.250015 ], [ -102.044510, 38.262412 ], [ -102.044567, 38.268749 ], [ -102.044568, 38.268819 ], [ -102.044613, 38.312324 ], [ -102.044944, 38.384419 ], [ -102.045263, 38.505395 ], [ -102.045262, 38.505532 ], [ -102.045112, 38.523784 ], [ -102.045223, 38.543797 ], [ -102.045189, 38.558732 ], [ -102.045211, 38.581609 ], [ -102.045288, 38.615168 ], [ -102.045288, 38.615249 ], [ -102.045074, 38.669617 ], [ -102.045102, 38.674946 ], [ -102.045160, 38.675221 ], [ -102.045127, 38.686725 ], [ -102.045156, 38.688555 ], [ -102.045212, 38.697567 ], [ -102.045375, 38.754339 ], [ -102.045287, 38.755528 ], [ -102.045371, 38.770064 ], [ -102.045448, 38.783453 ], [ -102.045334, 38.799463 ], [ -102.045388, 38.813392 ], [ -102.046571, 39.047038 ], [ -102.047134, 39.129701 ], [ -102.047189, 39.133147 ], [ -102.047250, 39.137020 ], [ -102.048449, 39.303138 ], [ -102.048960, 39.373712 ], [ -102.049167, 39.403597 ], [ -102.049370, 39.418210 ], [ -102.049369, 39.423333 ], [ -102.049679, 39.506183 ], [ -102.049673, 39.536691 ], [ -102.049554, 39.538932 ], [ -102.049764, 39.568180 ], [ -102.049806, 39.574058 ], [ -102.049954, 39.592331 ], [ -102.050594, 39.675594 ], [ -102.051254, 39.818992 ], [ -102.051318, 39.833311 ], [ -102.051363, 39.843471 ], [ -102.051569, 39.849805 ], [ -102.051744, 40.003078 ], [ -101.916696, 40.003142 ], [ -101.904176, 40.003162 ], [ -101.841025, 40.002784 ], [ -101.832161, 40.002933 ], [ -101.807687, 40.002798 ], [ -101.804862, 40.002752 ], [ -101.627071, 40.002620 ], [ -101.625809, 40.002711 ], [ -101.542273, 40.002609 ], [ -101.417209, 40.002424 ], [ -101.411043, 40.002365 ], [ -101.409953, 40.002354 ], [ -101.374326, 40.002521 ], [ -101.342859, 40.002580 ], [ -101.325514, 40.002687 ], [ -101.324036, 40.002696 ], [ -101.293991, 40.002559 ], [ -101.286555, 40.002559 ], [ -101.248673, 40.002543 ], [ -101.215033, 40.002555 ], [ -101.192219, 40.002491 ], [ -101.178805, 40.002468 ], [ -101.168704, 40.002547 ], [ -101.130907, 40.002427 ], [ -101.060317, 40.002307 ], [ -101.027686, 40.002256 ], [ -100.937427, 40.002145 ], [ -100.758830, 40.002302 ], [ -100.752183, 40.002128 ], [ -100.738826, 40.002228 ], [ -100.733296, 40.002270 ], [ -100.729904, 40.002111 ], [ -100.721128, 40.002069 ], [ -100.683435, 40.002234 ], [ -100.660230, 40.002162 ], [ -100.645445, 40.001883 ], [ -100.600945, 40.001906 ], [ -100.594757, 40.001977 ], [ -100.567238, 40.001889 ], [ -100.551886, 40.001889 ], [ -100.511065, 40.001840 ], [ -100.487159, 40.001767 ], [ -100.477018, 40.001752 ], [ -100.475854, 40.001768 ], [ -100.468773, 40.001724 ], [ -100.447072, 40.001795 ], [ -100.439081, 40.001774 ], [ -100.390080, 40.001809 ], [ -100.231652, 40.001623 ], [ -100.229479, 40.001693 ], [ -100.215406, 40.001629 ], [ -100.196959, 40.001494 ], [ -100.193597, 40.001573 ], [ -100.193590, 40.001573 ], [ -100.190323, 40.001586 ], [ -100.188181, 40.001541 ], [ -100.177823, 40.001593 ], [ -100.177795, 40.001593 ], [ -99.990926, 40.001503 ], [ -99.986611, 40.001550 ], [ -99.948167, 40.001813 ], [ -99.944417, 40.001584 ], [ -99.930433, 40.001516 ], [ -99.906658, 40.001512 ], [ -99.813401, 40.001400 ], [ -99.775640, 40.001647 ], [ -99.772121, 40.001804 ], [ -99.764214, 40.001551 ], [ -99.756835, 40.001342 ], [ -99.746628, 40.001820 ], [ -99.731959, 40.001827 ], [ -99.719639, 40.001808 ], [ -99.628346, 40.001866 ], [ -99.628255, 40.001866 ], [ -99.625980, 40.001865 ], [ -99.625324, 40.001866 ], [ -99.501792, 40.002026 ], [ -99.498999, 40.001957 ], [ -99.497660, 40.001912 ], [ -99.493465, 40.001937 ], [ -99.480728, 40.001942 ], [ -99.412645, 40.001868 ], [ -99.403389, 40.001969 ], [ -99.290703, 40.001949 ], [ -99.286656, 40.002017 ], [ -99.282967, 40.001879 ], [ -99.254012, 40.002074 ], [ -99.250370, 40.001957 ], [ -99.216376, 40.002016 ], [ -99.197592, 40.002033 ], [ -99.188905, 40.002023 ], [ -99.186962, 40.001977 ], [ -99.179133, 40.001977 ], [ -99.178965, 40.001977 ], [ -99.169816, 40.001925 ], [ -99.123033, 40.002165 ], [ -99.113510, 40.002193 ], [ -99.085597, 40.002133 ], [ -99.067022, 40.002170 ], [ -99.020338, 40.002264 ], [ -99.018701, 40.002333 ], [ -98.992135, 40.002192 ], [ -98.972287, 40.002245 ], [ -98.971721, 40.002268 ], [ -98.961009, 40.002317 ], [ -98.960919, 40.002271 ], [ -98.934792, 40.002205 ], [ -98.834456, 40.002363 ], [ -98.820590, 40.002319 ], [ -98.777203, 40.002359 ], [ -98.774941, 40.002336 ], [ -98.726373, 40.002222 ], [ -98.726295, 40.002222 ], [ -98.710404, 40.002180 ], [ -98.693096, 40.002373 ], [ -98.691443, 40.002505 ], [ -98.690287, 40.002548 ], [ -98.672819, 40.002364 ], [ -98.669724, 40.002410 ], [ -98.653833, 40.002269 ], [ -98.652494, 40.002245 ], [ -98.640710, 40.002493 ], [ -98.613755, 40.002400 ], [ -98.593342, 40.002476 ], [ -98.575219, 40.002480 ], [ -98.560578, 40.002274 ], [ -98.543186, 40.002285 ], [ -98.523053, 40.002336 ], [ -98.504455, 40.002329 ], [ -98.490533, 40.002323 ], [ -98.274017, 40.002516 ], [ -98.274015, 40.002516 ], [ -98.268218, 40.002490 ], [ -98.250008, 40.002307 ], [ -98.193483, 40.002614 ], [ -98.179315, 40.002483 ], [ -98.172269, 40.002438 ], [ -98.142031, 40.002452 ], [ -98.099659, 40.002227 ], [ -98.076034, 40.002301 ], [ -98.068701, 40.002355 ], [ -98.050057, 40.002278 ], [ -98.047469, 40.002186 ], [ -98.014412, 40.002223 ], [ -98.010157, 40.002153 ], [ -97.972186, 40.002114 ], [ -97.931826, 40.002050 ], [ -97.931811, 40.002050 ], [ -97.876261, 40.002102 ], [ -97.857450, 40.002065 ], [ -97.838379, 40.001910 ], [ -97.821598, 40.002004 ], [ -97.821496, 40.002002 ], [ -97.819426, 40.001958 ], [ -97.777155, 40.002167 ], [ -97.770776, 40.001977 ], [ -97.769204, 40.001995 ], [ -97.767746, 40.001994 ], [ -97.515308, 40.001901 ], [ -97.511381, 40.001899 ], [ -97.510264, 40.001835 ], [ -97.463285, 40.002047 ], [ -97.444662, 40.001958 ], [ -97.425443, 40.002048 ], [ -97.417826, 40.002024 ], [ -97.415833, 40.002001 ], [ -97.369199, 40.002060 ], [ -97.369199, 40.002060 ], [ -97.369103, 40.002060 ], [ -97.350896, 40.001930 ], [ -97.350272, 40.001976 ], [ -97.245169, 40.001513 ], [ -97.245080, 40.001467 ], [ -97.202310, 40.001442 ], [ -97.200190, 40.001549 ], [ -97.181775, 40.001550 ], [ -97.142448, 40.001495 ], [ -97.137866, 40.001814 ], [ -97.049663, 40.001323 ], [ -97.030803, 40.001342 ], [ -97.009165, 40.001463 ], [ -96.916407, 40.001506 ], [ -96.916093, 40.001506 ], [ -96.880459, 40.001448 ], [ -96.878253, 40.001466 ], [ -96.875057, 40.001448 ], [ -96.873812, 40.001450 ], [ -96.805768, 40.001371 ], [ -96.622401, 40.001158 ], [ -96.610349, 40.000881 ], [ -96.604884, 40.000891 ], [ -96.580852, 40.000966 ], [ -96.570854, 40.001091 ], [ -96.557863, 40.000968 ], [ -96.538977, 40.000851 ], [ -96.527111, 40.001031 ], [ -96.469945, 40.000966 ], [ -96.467536, 40.001035 ], [ -96.463713, 40.000968 ], [ -96.463640, 40.000967 ], [ -96.304555, 40.000629 ], [ -96.301066, 40.000632 ], [ -96.239208, 40.000691 ], [ -96.239172, 40.000691 ], [ -96.223839, 40.000729 ], [ -96.220171, 40.000720 ], [ -96.154365, 40.000495 ], [ -96.154246, 40.000450 ], [ -96.147167, 40.000479 ], [ -96.125937, 40.000432 ], [ -96.125788, 40.000467 ], [ -96.089781, 40.000519 ], [ -96.081395, 40.000603 ], [ -96.051691, 40.000727 ], [ -96.024090, 40.000719 ], [ -96.010680, 40.000638 ], [ -96.010678, 40.000638 ], [ -95.958139, 40.000521 ], [ -95.882524, 40.000470 ], [ -95.788111, 40.000452 ], [ -95.788024, 40.000452 ], [ -95.784575, 40.000463 ], [ -95.375257, 40.000000 ], [ -95.339896, 39.999999 ], [ -95.308290, 39.999998 ], [ -95.307780, 39.990618 ], [ -95.301549, 39.983603 ], [ -95.181222, 39.899996 ], [ -95.132695, 39.875925 ], [ -95.107745, 39.868579 ], [ -95.085003, 39.861883 ], [ -95.042142, 39.864805 ], [ -95.035047, 39.866807 ], [ -95.027931, 39.871522 ], [ -95.025250, 39.877688 ], [ -95.025240, 39.889700 ], [ -95.016320, 39.898766 ], [ -95.008440, 39.900596 ], [ -94.993348, 39.900747 ], [ -94.954155, 39.901138 ], [ -94.935963, 39.894355 ], [ -94.927897, 39.886112 ], [ -94.908267, 39.812172 ], [ -94.895268, 39.763210 ], [ -94.916932, 39.728186 ], [ -94.937924, 39.725471 ], [ -95.011103, 39.677572 ], [ -95.015310, 39.674262 ], [ -95.069592, 39.615106 ], [ -95.107454, 39.573843 ], [ -95.113077, 39.559133 ], [ -95.113557, 39.553941 ], [ -95.109304, 39.542285 ], [ -95.102888, 39.533347 ], [ -94.969061, 39.418876 ], [ -94.946662, 39.399717 ], [ -94.909954, 39.367459 ], [ -94.908337, 39.355647 ], [ -94.910641, 39.348335 ], [ -94.907569, 39.320623 ], [ -94.901009, 39.301680 ], [ -94.832399, 39.227218 ], [ -94.793948, 39.201276 ], [ -94.752338, 39.173203 ], [ -94.736537, 39.169203 ], [ -94.723637, 39.169003 ], [ -94.714137, 39.170403 ], [ -94.706723, 39.173801 ], [ -94.601733, 39.159603 ], [ -94.596033, 39.157703 ], [ -94.591933, 39.155003 ], [ -94.589933, 39.140403 ], [ -94.607354, 39.113444 ], [ -94.607234, 39.089604 ], [ -94.607334, 39.081704 ], [ -94.607234, 39.065704 ], [ -94.607391, 39.044086 ], [ -94.608134, 38.942006 ], [ -94.608134, 38.940006 ], [ -94.607866, 38.937398 ], [ -94.607978, 38.936870 ], [ -94.608033, 38.883807 ], [ -94.608033, 38.869207 ], [ -94.608033, 38.868107 ], [ -94.607993, 38.867271 ], [ -94.608033, 38.861207 ], [ -94.608033, 38.855007 ], [ -94.608033, 38.847207 ], [ -94.608041, 38.811064 ], [ -94.609039, 38.760611 ], [ -94.609399, 38.742440 ], [ -94.609456, 38.740700 ], [ -94.609509, 38.738102 ], [ -94.611602, 38.635384 ], [ -94.611858, 38.620485 ], [ -94.611908, 38.609272 ], [ -94.611887, 38.580139 ], [ -94.611902, 38.580110 ], [ -94.612176, 38.576546 ], [ -94.612157, 38.549817 ], [ -94.612272, 38.547917 ], [ -94.612644, 38.491644 ], [ -94.612726, 38.484367 ], [ -94.612696, 38.483154 ], [ -94.612865, 38.477602 ], [ -94.612866, 38.477571 ], [ -94.613365, 38.403422 ], [ -94.613265, 38.392426 ], [ -94.613275, 38.388718 ], [ -94.613329, 38.369618 ], [ -94.613312, 38.364407 ], [ -94.613000, 38.335801 ], [ -94.612825, 38.324387 ], [ -94.612788, 38.320142 ], [ -94.612673, 38.314832 ], [ -94.612673, 38.302527 ], [ -94.612844, 38.291423 ], [ -94.612849, 38.289914 ], [ -94.612692, 38.270394 ], [ -94.612614, 38.237766 ], [ -94.612635, 38.226987 ], [ -94.612659, 38.219251 ], [ -94.612658, 38.217649 ], [ -94.612822, 38.203918 ], [ -94.612848, 38.200714 ], [ -94.613073, 38.190552 ], [ -94.613422, 38.167908 ], [ -94.613748, 38.160633 ], [ -94.613856, 38.149769 ], [ -94.614061, 38.067343 ], [ -94.614089, 38.065901 ], [ -94.614055, 38.060088 ], [ -94.614055, 38.060056 ], [ -94.613981, 38.037057 ], [ -94.613981, 38.036949 ], [ -94.614212, 37.992462 ], [ -94.614465, 37.987799 ], [ -94.614557, 37.971037 ], [ -94.614562, 37.951517 ], [ -94.614594, 37.949978 ], [ -94.614612, 37.944362 ], [ -94.614754, 37.940769 ], [ -94.614835, 37.936700 ], [ -94.614778, 37.934200 ], [ -94.615181, 37.915944 ], [ -94.615393, 37.906392 ], [ -94.615469, 37.901775 ], [ -94.615706, 37.886843 ], [ -94.615921, 37.878331 ], [ -94.615834, 37.872510 ], [ -94.616000, 37.863126 ], [ -94.616426, 37.845282 ], [ -94.616450, 37.837560 ], [ -94.616862, 37.819456 ], [ -94.617808, 37.729707 ], [ -94.617975, 37.722176 ], [ -94.617805, 37.690178 ], [ -94.617651, 37.687671 ], [ -94.617687, 37.686653 ], [ -94.617885, 37.682214 ], [ -94.617734, 37.673127 ], [ -94.617734, 37.673105 ], [ -94.617576, 37.653671 ], [ -94.617575, 37.653577 ], [ -94.617477, 37.637170 ], [ -94.617300, 37.610495 ], [ -94.617428, 37.609522 ], [ -94.617283, 37.571896 ], [ -94.617315, 37.571499 ], [ -94.617081, 37.567013 ], [ -94.617160, 37.557308 ], [ -94.617186, 37.553485 ], [ -94.616908, 37.527804 ], [ -94.616789, 37.521510 ], [ -94.617023, 37.483765 ], [ -94.617183, 37.469665 ], [ -94.617180, 37.465203 ], [ -94.617222, 37.460476 ], [ -94.617205, 37.460373 ], [ -94.617201, 37.454788 ], [ -94.617132, 37.439818 ], [ -94.617265, 37.425536 ], [ -94.617511, 37.410909 ], [ -94.617557, 37.396375 ], [ -94.617625, 37.367576 ], [ -94.617626, 37.367445 ], [ -94.617537, 37.364355 ], [ -94.617538, 37.364167 ], [ -94.617636, 37.338417 ], [ -94.617636, 37.338415 ], [ -94.617695, 37.336842 ], [ -94.617648, 37.323589 ], [ -94.618075, 37.240436 ], [ -94.618158, 37.237597 ], [ -94.618123, 37.229334 ], [ -94.618150, 37.228121 ], [ -94.618219, 37.207772 ], [ -94.618305, 37.207337 ], [ -94.618319, 37.188774 ], [ -94.618505, 37.181184 ], [ -94.618473, 37.174782 ], [ -94.618351, 37.160211 ], [ -94.618072, 37.132345 ], [ -94.618075, 37.129755 ], [ -94.618212, 37.113169 ], [ -94.618151, 37.103968 ], [ -94.618059, 37.096676 ], [ -94.618088, 37.093671 ], [ -94.618090, 37.093494 ], [ -94.618082, 37.086432 ], [ -94.618120, 37.085934 ], [ -94.617982, 37.075077 ], [ -94.617875, 37.056798 ], [ -94.617875, 37.056797 ], [ -94.617965, 37.040537 ], [ -94.617995, 37.009016 ], [ -94.618080, 36.998135 ], [ -94.699735, 36.998805 ], [ -94.701797, 36.998814 ], [ -94.712770, 36.998794 ], [ -94.737183, 36.998665 ], [ -94.739324, 36.998687 ], [ -94.777257, 36.998764 ], [ -94.831280, 36.998812 ], [ -94.840926, 36.998833 ], [ -94.849801, 36.998876 ], [ -94.853197, 36.998874 ], [ -94.995293, 36.999529 ], [ -95.007620, 36.999514 ], [ -95.011433, 36.999535 ], [ -95.030324, 36.999517 ], [ -95.037857, 36.999497 ], [ -95.049499, 36.999580 ], [ -95.073504, 36.999509 ], [ -95.073509, 36.999509 ], [ -95.155187, 36.999539 ], [ -95.155372, 36.999540 ], [ -95.177301, 36.999520 ], [ -95.195307, 36.999565 ], [ -95.322565, 36.999358 ], [ -95.328058, 36.999365 ], [ -95.328327, 36.999366 ], [ -95.331210, 36.999380 ], [ -95.407572, 36.999241 ], [ -95.407683, 36.999241 ], [ -95.511578, 36.999235 ], [ -95.522415, 36.999281 ], [ -95.534401, 36.999332 ], [ -95.573598, 36.999310 ], [ -95.612140, 36.999321 ], [ -95.615934, 36.999365 ], [ -95.624350, 36.999360 ], [ -95.630079, 36.999320 ], [ -95.664301, 36.999322 ], [ -95.686452, 36.999349 ], [ -95.696659, 36.999215 ], [ -95.710380, 36.999371 ], [ -95.714887, 36.999279 ], [ -95.718054, 36.999255 ], [ -95.741908, 36.999244 ], [ -95.759905, 36.999271 ], [ -95.768719, 36.999205 ], [ -95.786762, 36.999310 ], [ -95.807980, 36.999124 ], [ -95.866899, 36.999261 ], [ -95.873944, 36.999300 ], [ -95.875257, 36.999302 ], [ -95.877151, 36.999304 ], [ -95.910180, 36.999336 ], [ -95.928122, 36.999245 ], [ -95.936992, 36.999268 ], [ -95.964270, 36.999094 ], [ -96.000810, 36.998860 ], [ -96.141210, 36.998973 ], [ -96.143207, 36.999134 ], [ -96.147143, 36.999022 ], [ -96.149709, 36.999040 ], [ -96.152384, 36.999051 ], [ -96.154017, 36.999161 ], [ -96.184768, 36.999211 ], [ -96.200028, 36.999028 ], [ -96.217571, 36.999070 ], [ -96.276368, 36.999271 ], [ -96.279079, 36.999272 ], [ -96.394272, 36.999221 ], [ -96.415412, 36.999113 ], [ -96.525493, 36.999147 ], [ -96.705431, 36.999203 ], [ -96.710482, 36.999271 ], [ -96.736590, 36.999286 ], [ -96.741270, 36.999239 ], [ -96.749838, 36.998988 ], [ -96.792060, 36.999180 ], [ -96.795199, 36.998860 ], [ -96.822791, 36.999182 ], [ -96.867517, 36.999217 ], [ -96.876290, 36.999233 ], [ -96.902083, 36.999155 ], [ -96.903510, 36.999132 ], [ -96.917093, 36.999182 ], [ -96.921915, 36.999151 ], [ -96.934642, 36.999070 ], [ -96.967371, 36.999067 ], [ -96.975562, 36.999019 ], [ -97.030082, 36.998929 ], [ -97.039784, 36.999000 ], [ -97.100652, 36.998998 ], [ -97.104276, 36.999020 ], [ -97.120285, 36.999014 ], [ -97.122597, 36.999036 ], [ -97.147721, 36.999111 ], [ -97.372421, 36.998861 ], [ -97.384925, 36.998843 ], [ -97.462280, 36.998685 ], [ -97.462346, 36.998685 ], [ -97.472861, 36.998721 ], [ -97.527292, 36.998750 ], [ -97.545900, 36.998709 ], [ -97.546498, 36.998747 ], [ -97.564536, 36.998711 ], [ -97.606549, 36.998682 ], [ -97.637137, 36.999090 ], [ -97.650466, 36.999004 ], [ -97.697104, 36.998826 ], [ -97.768704, 36.998750 ], [ -97.783432, 36.998961 ], [ -97.783489, 36.998847 ], [ -97.802298, 36.998713 ], [ -97.802313, 36.998713 ], [ -98.033955, 36.998366 ], [ -98.039890, 36.998349 ], [ -98.045342, 36.998327 ], [ -98.111985, 36.998133 ], [ -98.147452, 36.998162 ], [ -98.177596, 36.998009 ], [ -98.208218, 36.997997 ], [ -98.219499, 36.997824 ], [ -98.237712, 36.997972 ], [ -98.346188, 36.997962 ], [ -98.347149, 36.997962 ], [ -98.354073, 36.997961 ], [ -98.408991, 36.998513 ], [ -98.418268, 36.998538 ], [ -98.420209, 36.998516 ], [ -98.544660, 36.998996 ], [ -98.544872, 36.998997 ], [ -98.714512, 36.999060 ], [ -98.718465, 36.999180 ], [ -98.761597, 36.999425 ], [ -98.791936, 36.999255 ], [ -98.793711, 36.999227 ], [ -98.797452, 36.999229 ], [ -98.869449, 36.999286 ], [ -98.880009, 36.999263 ], [ -98.880580, 36.999309 ], [ -98.994371, 36.999493 ], [ -99.000303, 36.999510 ], [ -99.029337, 36.999595 ], [ -99.124883, 36.999420 ], [ -99.129449, 36.999422 ], [ -99.248120, 36.999565 ], [ -99.277506, 36.999579 ], [ -99.456203, 36.999471 ], [ -99.484333, 36.999626 ], [ -99.500395, 36.999576 ], [ -99.500395, 36.999637 ], [ -99.502665, 36.999645 ], [ -99.504093, 36.999648 ], [ -99.508574, 36.999658 ], [ -99.541116, 36.999573 ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US24", "STATE": 30, "name": "Maryland", "LSAD": "", "CENSUSAREA": 9707.241000 }, "geometry": { "type": "MultiPolygon", "coordinates": [ [ [ [ -76.048373, 38.120550 ], [ -76.056811, 38.125123 ], [ -76.061000, 38.127002 ], [ -76.061111, 38.126963 ], [ -76.061470, 38.126839 ], [ -76.063661, 38.126078 ], [ -76.064683, 38.125723 ], [ -76.081127, 38.120014 ], [ -76.081587, 38.119854 ], [ -76.085230, 38.118589 ], [ -76.085311, 38.118561 ], [ -76.085542, 38.117869 ], [ -76.085885, 38.116844 ], [ -76.085947, 38.116658 ], [ -76.086224, 38.116534 ], [ -76.089018, 38.115287 ], [ -76.089166, 38.115221 ], [ -76.090872, 38.114460 ], [ -76.095548, 38.125123 ], [ -76.090649, 38.131185 ], [ -76.090640, 38.131240 ], [ -76.090527, 38.131919 ], [ -76.089017, 38.141033 ], [ -76.089918, 38.143837 ], [ -76.090216, 38.144765 ], [ -76.092334, 38.151355 ], [ -76.088639, 38.192649 ], [ -76.071470, 38.203502 ], [ -76.067797, 38.203539 ], [ -76.067100, 38.203546 ], [ -76.066994, 38.203547 ], [ -76.061906, 38.203599 ], [ -76.059731, 38.203621 ], [ -76.059562, 38.203622 ], [ -76.059218, 38.203626 ], [ -76.059158, 38.203626 ], [ -76.059020, 38.203628 ], [ -76.058925, 38.203629 ], [ -76.053753, 38.203681 ], [ -76.052165, 38.203697 ], [ -76.050511, 38.203714 ], [ -76.048945, 38.203729 ], [ -76.048786, 38.203731 ], [ -76.046539, 38.201549 ], [ -76.046273, 38.201290 ], [ -76.042691, 38.197811 ], [ -76.042615, 38.197737 ], [ -76.042385, 38.197515 ], [ -76.042280, 38.197412 ], [ -76.041952, 38.197094 ], [ -76.040718, 38.195896 ], [ -76.038929, 38.194158 ], [ -76.036757, 38.192049 ], [ -76.028580, 38.184107 ], [ -76.028411, 38.183943 ], [ -76.026900, 38.182476 ], [ -76.025899, 38.181504 ], [ -76.022170, 38.177882 ], [ -76.021941, 38.171976 ], [ -76.025892, 38.170946 ], [ -76.032767, 38.169154 ], [ -76.032816, 38.169141 ], [ -76.034038, 38.157902 ], [ -76.033978, 38.157636 ], [ -76.031945, 38.148631 ], [ -76.031868, 38.148288 ], [ -76.031442, 38.147612 ], [ -76.022515, 38.133453 ], [ -76.020982, 38.132776 ], [ -76.020476, 38.132553 ], [ -76.019637, 38.132183 ], [ -76.018574, 38.131713 ], [ -76.017790, 38.131367 ], [ -76.015155, 38.131548 ], [ -76.013903, 38.131634 ], [ -76.012487, 38.131731 ], [ -76.011916, 38.122214 ], [ -76.013363, 38.121342 ], [ -76.014698, 38.120537 ], [ -76.015702, 38.119933 ], [ -76.020496, 38.117044 ], [ -76.021305, 38.108608 ], [ -76.021353, 38.108108 ], [ -76.021370, 38.107934 ], [ -76.020996, 38.107578 ], [ -76.017394, 38.104154 ], [ -76.015477, 38.102332 ], [ -76.008168, 38.095385 ], [ -76.005904, 38.077170 ], [ -76.011544, 38.072312 ], [ -76.012701, 38.072159 ], [ -76.015235, 38.071825 ], [ -76.023300, 38.070760 ], [ -76.036676, 38.076509 ], [ -76.052207, 38.089716 ], [ -76.058310, 38.094906 ], [ -76.059304, 38.095751 ], [ -76.050156, 38.107758 ], [ -76.047291, 38.108505 ], [ -76.046494, 38.108712 ], [ -76.045279, 38.109029 ], [ -76.044482, 38.109237 ], [ -76.042083, 38.109862 ], [ -76.041083, 38.110726 ], [ -76.040874, 38.110906 ], [ -76.039620, 38.111990 ], [ -76.039696, 38.112108 ], [ -76.040665, 38.113606 ], [ -76.043423, 38.117868 ], [ -76.048373, 38.120550 ] ] ], [ [ [ -75.993905, 37.953489 ], [ -75.994739, 37.953501 ], [ -76.005888, 37.953662 ], [ -76.017686, 37.953832 ], [ -76.020796, 37.953877 ], [ -76.020932, 37.953879 ], [ -76.021714, 37.953887 ], [ -76.022325, 37.953878 ], [ -76.029405, 37.953776 ], [ -76.029463, 37.953775 ], [ -76.030122, 37.953655 ], [ -76.038026, 37.953901 ], [ -76.041402, 37.954006 ], [ -76.041691, 37.954000 ], [ -76.045561, 37.953669 ], [ -76.046530, 37.953586 ], [ -76.049608, 37.983628 ], [ -76.049562, 37.985065 ], [ -76.049549, 37.985495 ], [ -76.049527, 37.986184 ], [ -76.049396, 37.990315 ], [ -76.048617, 38.014843 ], [ -76.046213, 38.025533 ], [ -76.041668, 38.032148 ], [ -76.020827, 38.039124 ], [ -76.013128, 38.039762 ], [ -76.008835, 38.038275 ], [ -76.008695, 38.038226 ], [ -76.004592, 38.036805 ], [ -75.991846, 38.025497 ], [ -75.981195, 38.022460 ], [ -75.977246, 38.021334 ], [ -75.975494, 38.020834 ], [ -75.975487, 38.020827 ], [ -75.973432, 38.018841 ], [ -75.972304, 38.017750 ], [ -75.970172, 38.015688 ], [ -75.970168, 38.015685 ], [ -75.970168, 38.015683 ], [ -75.970178, 38.015260 ], [ -75.970345, 38.008222 ], [ -75.970390, 38.006327 ], [ -75.970917, 38.006239 ], [ -75.979879, 38.004738 ], [ -75.980683, 38.004603 ], [ -75.982880, 38.004236 ], [ -75.984251, 38.004006 ], [ -75.984479, 38.003369 ], [ -75.984675, 38.002821 ], [ -75.985020, 38.001855 ], [ -75.985723, 37.999889 ], [ -75.986249, 37.998416 ], [ -75.986571, 37.997516 ], [ -75.988541, 37.992006 ], [ -75.988719, 37.991509 ], [ -75.989101, 37.990440 ], [ -75.992468, 37.981021 ], [ -75.994730, 37.974694 ], [ -75.994730, 37.974693 ], [ -75.992789, 37.969932 ], [ -75.991543, 37.966874 ], [ -75.988879, 37.960337 ], [ -75.993905, 37.953489 ] ] ], [ [ [ -76.438845, 39.052900 ], [ -76.438928, 39.052788 ], [ -76.437044, 39.051698 ], [ -76.422933, 39.043536 ], [ -76.407398, 39.034551 ], [ -76.407213, 39.034444 ], [ -76.407205, 39.034439 ], [ -76.405338, 39.033360 ], [ -76.405081, 39.033211 ], [ -76.405021, 39.033124 ], [ -76.402600, 39.029609 ], [ -76.397780, 39.022611 ], [ -76.397738, 39.022482 ], [ -76.396417, 39.018449 ], [ -76.396395, 39.018380 ], [ -76.395639, 39.016074 ], [ -76.395338, 39.015154 ], [ -76.394699, 39.013200 ], [ -76.394358, 39.012160 ], [ -76.394080, 39.011311 ], [ -76.412326, 38.996832 ], [ -76.414631, 38.995002 ], [ -76.421535, 38.989524 ], [ -76.422181, 38.989011 ], [ -76.427301, 38.987827 ], [ -76.448928, 38.982823 ], [ -76.448981, 38.982811 ], [ -76.449188, 38.982092 ], [ -76.450152, 38.978751 ], [ -76.450481, 38.977612 ], [ -76.451599, 38.976767 ], [ -76.454581, 38.974512 ], [ -76.474198, 38.972647 ], [ -76.474198, 38.972646 ], [ -76.474450, 38.970683 ], [ -76.474882, 38.967312 ], [ -76.474743, 38.966895 ], [ -76.473243, 38.962397 ], [ -76.471281, 38.956512 ], [ -76.463081, 38.948612 ], [ -76.460234, 38.948505 ], [ -76.457781, 38.948412 ], [ -76.457229, 38.947875 ], [ -76.451695, 38.942490 ], [ -76.450280, 38.941113 ], [ -76.450756, 38.940412 ], [ -76.461880, 38.924013 ], [ -76.461747, 38.923674 ], [ -76.460272, 38.919909 ], [ -76.458991, 38.916639 ], [ -76.458759, 38.916045 ], [ -76.458080, 38.914313 ], [ -76.459479, 38.907113 ], [ -76.460253, 38.907152 ], [ -76.460716, 38.907175 ], [ -76.462312, 38.907256 ], [ -76.465280, 38.907406 ], [ -76.469380, 38.907613 ], [ -76.469480, 38.911513 ], [ -76.475761, 38.914469 ], [ -76.493680, 38.910013 ], [ -76.493791, 38.904225 ], [ -76.493798, 38.903865 ], [ -76.493806, 38.903443 ], [ -76.493856, 38.900846 ], [ -76.493880, 38.899614 ], [ -76.492780, 38.895614 ], [ -76.490880, 38.894514 ], [ -76.490403, 38.892254 ], [ -76.490339, 38.891955 ], [ -76.489933, 38.890031 ], [ -76.489713, 38.888991 ], [ -76.489675, 38.888811 ], [ -76.489667, 38.888772 ], [ -76.489380, 38.887414 ], [ -76.490680, 38.884814 ], [ -76.491107, 38.884492 ], [ -76.491442, 38.884239 ], [ -76.494400, 38.882010 ], [ -76.494588, 38.881868 ], [ -76.494858, 38.881665 ], [ -76.498467, 38.878944 ], [ -76.507858, 38.871866 ], [ -76.511135, 38.869396 ], [ -76.519442, 38.863135 ], [ -76.516944, 38.851157 ], [ -76.516582, 38.851026 ], [ -76.509285, 38.848388 ], [ -76.509211, 38.848416 ], [ -76.499158, 38.852156 ], [ -76.497562, 38.852749 ], [ -76.496579, 38.853115 ], [ -76.496474, 38.852953 ], [ -76.493639, 38.848595 ], [ -76.492761, 38.847246 ], [ -76.492017, 38.846102 ], [ -76.491581, 38.845433 ], [ -76.491494, 38.845299 ], [ -76.489919, 38.842878 ], [ -76.489878, 38.842815 ], [ -76.489878, 38.838715 ], [ -76.490107, 38.838176 ], [ -76.491387, 38.835161 ], [ -76.491606, 38.834644 ], [ -76.491684, 38.834462 ], [ -76.491831, 38.834116 ], [ -76.496965, 38.822022 ], [ -76.497692, 38.820309 ], [ -76.498878, 38.817516 ], [ -76.499056, 38.817258 ], [ -76.502910, 38.811648 ], [ -76.506530, 38.806380 ], [ -76.506876, 38.805875 ], [ -76.509314, 38.802328 ], [ -76.510078, 38.801216 ], [ -76.511130, 38.800769 ], [ -76.514296, 38.799425 ], [ -76.515830, 38.798774 ], [ -76.523405, 38.795557 ], [ -76.524679, 38.795016 ], [ -76.524806, 38.794871 ], [ -76.524999, 38.794650 ], [ -76.525039, 38.794605 ], [ -76.525210, 38.794409 ], [ -76.525531, 38.794043 ], [ -76.527455, 38.791844 ], [ -76.527479, 38.791816 ], [ -76.527463, 38.791667 ], [ -76.527372, 38.790788 ], [ -76.527370, 38.790774 ], [ -76.527105, 38.788223 ], [ -76.527045, 38.787645 ], [ -76.526979, 38.787016 ], [ -76.527315, 38.786660 ], [ -76.528136, 38.785790 ], [ -76.532487, 38.781181 ], [ -76.533975, 38.779604 ], [ -76.535207, 38.778298 ], [ -76.535352, 38.778145 ], [ -76.535379, 38.778116 ], [ -76.535426, 38.778095 ], [ -76.535642, 38.778000 ], [ -76.536284, 38.777719 ], [ -76.536819, 38.777484 ], [ -76.536849, 38.777471 ], [ -76.537230, 38.777304 ], [ -76.539088, 38.776488 ], [ -76.542973, 38.774783 ], [ -76.544372, 38.774169 ], [ -76.544413, 38.774151 ], [ -76.554443, 38.769749 ], [ -76.554693, 38.769639 ], [ -76.559697, 38.767443 ], [ -76.559884, 38.767361 ], [ -76.559778, 38.766342 ], [ -76.558933, 38.758177 ], [ -76.557535, 38.744687 ], [ -76.557300, 38.744229 ], [ -76.557091, 38.743823 ], [ -76.556954, 38.743554 ], [ -76.553978, 38.737756 ], [ -76.552743, 38.735350 ], [ -76.551971, 38.734636 ], [ -76.544561, 38.727784 ], [ -76.544475, 38.727705 ], [ -76.543853, 38.727736 ], [ -76.543570, 38.727750 ], [ -76.543435, 38.727757 ], [ -76.542053, 38.727826 ], [ -76.539769, 38.727940 ], [ -76.529868, 38.728435 ], [ -76.529284, 38.728137 ], [ -76.527180, 38.727062 ], [ -76.526655, 38.724430 ], [ -76.529237, 38.713561 ], [ -76.529532, 38.712317 ], [ -76.529721, 38.711523 ], [ -76.530575, 38.707929 ], [ -76.530799, 38.706983 ], [ -76.530824, 38.706881 ], [ -76.532465, 38.699974 ], [ -76.532537, 38.699669 ], [ -76.532527, 38.698207 ], [ -76.532432, 38.683600 ], [ -76.532409, 38.680064 ], [ -76.532398, 38.678363 ], [ -76.532056, 38.676936 ], [ -76.530454, 38.670263 ], [ -76.527850, 38.659416 ], [ -76.527428, 38.657655 ], [ -76.525007, 38.647568 ], [ -76.524620, 38.645956 ], [ -76.524122, 38.645044 ], [ -76.517862, 38.633586 ], [ -76.516988, 38.631985 ], [ -76.515554, 38.629361 ], [ -76.511278, 38.615745 ], [ -76.512452, 38.609827 ], [ -76.512583, 38.609168 ], [ -76.514812, 38.597930 ], [ -76.515741, 38.593248 ], [ -76.515760, 38.593154 ], [ -76.515764, 38.593131 ], [ -76.516340, 38.590229 ], [ -76.515106, 38.555763 ], [ -76.515376, 38.553895 ], [ -76.515409, 38.553667 ], [ -76.515415, 38.553623 ], [ -76.515520, 38.552900 ], [ -76.517506, 38.539149 ], [ -76.515754, 38.529260 ], [ -76.515706, 38.528988 ], [ -76.515350, 38.528093 ], [ -76.507489, 38.508300 ], [ -76.506860, 38.506716 ], [ -76.506023, 38.504610 ], [ -76.499256, 38.493559 ], [ -76.498792, 38.492800 ], [ -76.498222, 38.491869 ], [ -76.492699, 38.482849 ], [ -76.491642, 38.481944 ], [ -76.473372, 38.466290 ], [ -76.471253, 38.464474 ], [ -76.467342, 38.461123 ], [ -76.467194, 38.460996 ], [ -76.467186, 38.460990 ], [ -76.464010, 38.458268 ], [ -76.461078, 38.455756 ], [ -76.455799, 38.451233 ], [ -76.456002, 38.447891 ], [ -76.454140, 38.445880 ], [ -76.450937, 38.442422 ], [ -76.445376, 38.439012 ], [ -76.442441, 38.437212 ], [ -76.442431, 38.437206 ], [ -76.441180, 38.436439 ], [ -76.438919, 38.435053 ], [ -76.436271, 38.433429 ], [ -76.435674, 38.432893 ], [ -76.415384, 38.414682 ], [ -76.402710, 38.396003 ], [ -76.393378, 38.389477 ], [ -76.388348, 38.387781 ], [ -76.388328, 38.387727 ], [ -76.386229, 38.382013 ], [ -76.386243, 38.381631 ], [ -76.386931, 38.363184 ], [ -76.386957, 38.362462 ], [ -76.387002, 38.361267 ], [ -76.387408, 38.360811 ], [ -76.388806, 38.359238 ], [ -76.388915, 38.359115 ], [ -76.398261, 38.348602 ], [ -76.400871, 38.345666 ], [ -76.401532, 38.344923 ], [ -76.402043, 38.344348 ], [ -76.403101, 38.343157 ], [ -76.404940, 38.341089 ], [ -76.409291, 38.325891 ], [ -76.405716, 38.317794 ], [ -76.402894, 38.311402 ], [ -76.382163, 38.303389 ], [ -76.381493, 38.303130 ], [ -76.380120, 38.302343 ], [ -76.375310, 38.299583 ], [ -76.375023, 38.299419 ], [ -76.374517, 38.296556 ], [ -76.374481, 38.296348 ], [ -76.376607, 38.294393 ], [ -76.382051, 38.289384 ], [ -76.394171, 38.278233 ], [ -76.396913, 38.271650 ], [ -76.398852, 38.266997 ], [ -76.399013, 38.264338 ], [ -76.399049, 38.263753 ], [ -76.399078, 38.263275 ], [ -76.399313, 38.259398 ], [ -76.399320, 38.259284 ], [ -76.399078, 38.258569 ], [ -76.392464, 38.239055 ], [ -76.392280, 38.238511 ], [ -76.391659, 38.236680 ], [ -76.391623, 38.236573 ], [ -76.385244, 38.217751 ], [ -76.378104, 38.209897 ], [ -76.377693, 38.209445 ], [ -76.372535, 38.203771 ], [ -76.364135, 38.194532 ], [ -76.361877, 38.192048 ], [ -76.359887, 38.188737 ], [ -76.353799, 38.178606 ], [ -76.353516, 38.178135 ], [ -76.352561, 38.177214 ], [ -76.352395, 38.177054 ], [ -76.347983, 38.172802 ], [ -76.343517, 38.168497 ], [ -76.337611, 38.162805 ], [ -76.336106, 38.161353 ], [ -76.329711, 38.155190 ], [ -76.329705, 38.155184 ], [ -76.329688, 38.155155 ], [ -76.328864, 38.153703 ], [ -76.328805, 38.153600 ], [ -76.328778, 38.153552 ], [ -76.328419, 38.152921 ], [ -76.327124, 38.150641 ], [ -76.320492, 38.138966 ], [ -76.320136, 38.138339 ], [ -76.324108, 38.134266 ], [ -76.330982, 38.127217 ], [ -76.331812, 38.126366 ], [ -76.335243, 38.122848 ], [ -76.335637, 38.122444 ], [ -76.337342, 38.120696 ], [ -76.338161, 38.119856 ], [ -76.338535, 38.119472 ], [ -76.337411, 38.110888 ], [ -76.337402, 38.110820 ], [ -76.331807, 38.101092 ], [ -76.331484, 38.100531 ], [ -76.331240, 38.100106 ], [ -76.330807, 38.099354 ], [ -76.330794, 38.099331 ], [ -76.330787, 38.099201 ], [ -76.329433, 38.073986 ], [ -76.329308, 38.071660 ], [ -76.329165, 38.071247 ], [ -76.325044, 38.059368 ], [ -76.320592, 38.046531 ], [ -76.319476, 38.043315 ], [ -76.321499, 38.038050 ], [ -76.321950, 38.036874 ], [ -76.322093, 38.036503 ], [ -76.326994, 38.045105 ], [ -76.332812, 38.049938 ], [ -76.341172, 38.053596 ], [ -76.341404, 38.053697 ], [ -76.344327, 38.053565 ], [ -76.345697, 38.053502 ], [ -76.350656, 38.053277 ], [ -76.352750, 38.053182 ], [ -76.361237, 38.059542 ], [ -76.361538, 38.060114 ], [ -76.361668, 38.060360 ], [ -76.361779, 38.060570 ], [ -76.369306, 38.074853 ], [ -76.370204, 38.076556 ], [ -76.370845, 38.077771 ], [ -76.371790, 38.079565 ], [ -76.378292, 38.086949 ], [ -76.380991, 38.090014 ], [ -76.381298, 38.090362 ], [ -76.381752, 38.090878 ], [ -76.381842, 38.090981 ], [ -76.383896, 38.093312 ], [ -76.384886, 38.094437 ], [ -76.390917, 38.101286 ], [ -76.391823, 38.102315 ], [ -76.392058, 38.102581 ], [ -76.392335, 38.102896 ], [ -76.393121, 38.103142 ], [ -76.394006, 38.103419 ], [ -76.396478, 38.104192 ], [ -76.397656, 38.104561 ], [ -76.398067, 38.104690 ], [ -76.405368, 38.106974 ], [ -76.405972, 38.106967 ], [ -76.413160, 38.106884 ], [ -76.414475, 38.105943 ], [ -76.414994, 38.105572 ], [ -76.416550, 38.104459 ], [ -76.421066, 38.105989 ], [ -76.421214, 38.106039 ], [ -76.421896, 38.107026 ], [ -76.429384, 38.117875 ], [ -76.429471, 38.118001 ], [ -76.430425, 38.119383 ], [ -76.430412, 38.119488 ], [ -76.430130, 38.121753 ], [ -76.429744, 38.124856 ], [ -76.429581, 38.126165 ], [ -76.437242, 38.135699 ], [ -76.439841, 38.138933 ], [ -76.459236, 38.139471 ], [ -76.459689, 38.139484 ], [ -76.460072, 38.138717 ], [ -76.460673, 38.137515 ], [ -76.465727, 38.127408 ], [ -76.469798, 38.119264 ], [ -76.469795, 38.119061 ], [ -76.469787, 38.118606 ], [ -76.469784, 38.118381 ], [ -76.469760, 38.116874 ], [ -76.469740, 38.115653 ], [ -76.469738, 38.115534 ], [ -76.467333, 38.112546 ], [ -76.466973, 38.112099 ], [ -76.466568, 38.111596 ], [ -76.466404, 38.111392 ], [ -76.466387, 38.111302 ], [ -76.466364, 38.111183 ], [ -76.465892, 38.108738 ], [ -76.465479, 38.106603 ], [ -76.465330, 38.105830 ], [ -76.467879, 38.104932 ], [ -76.473266, 38.103035 ], [ -76.475448, 38.104271 ], [ -76.476222, 38.104709 ], [ -76.478168, 38.109221 ], [ -76.478610, 38.110247 ], [ -76.478797, 38.110680 ], [ -76.478817, 38.110726 ], [ -76.479056, 38.111281 ], [ -76.479799, 38.113005 ], [ -76.481000, 38.115789 ], [ -76.481036, 38.115873 ], [ -76.481050, 38.115889 ], [ -76.481073, 38.115915 ], [ -76.482007, 38.116974 ], [ -76.484030, 38.119266 ], [ -76.485149, 38.120535 ], [ -76.485961, 38.121456 ], [ -76.486274, 38.121810 ], [ -76.486320, 38.121862 ], [ -76.492029, 38.128333 ], [ -76.495040, 38.131746 ], [ -76.497081, 38.134059 ], [ -76.497866, 38.134950 ], [ -76.499018, 38.136255 ], [ -76.499842, 38.137189 ], [ -76.499923, 38.137221 ], [ -76.500332, 38.137381 ], [ -76.501258, 38.137744 ], [ -76.502306, 38.138156 ], [ -76.508825, 38.140713 ], [ -76.514824, 38.141219 ], [ -76.522418, 38.139391 ], [ -76.528990, 38.134708 ], [ -76.529439, 38.134388 ], [ -76.529868, 38.134083 ], [ -76.540380, 38.152991 ], [ -76.545335, 38.165373 ], [ -76.547333, 38.175673 ], [ -76.547455, 38.175923 ], [ -76.547902, 38.176839 ], [ -76.548256, 38.177566 ], [ -76.548946, 38.178982 ], [ -76.552957, 38.187209 ], [ -76.566297, 38.198492 ], [ -76.574440, 38.203751 ], [ -76.588683, 38.212950 ], [ -76.590637, 38.214212 ], [ -76.624387, 38.223429 ], [ -76.625659, 38.223777 ], [ -76.628078, 38.224437 ], [ -76.629703, 38.224881 ], [ -76.629893, 38.224933 ], [ -76.631958, 38.225497 ], [ -76.631997, 38.225508 ], [ -76.632464, 38.225635 ], [ -76.632544, 38.225657 ], [ -76.643929, 38.225080 ], [ -76.643999, 38.225102 ], [ -76.645034, 38.225429 ], [ -76.645166, 38.225470 ], [ -76.659182, 38.229894 ], [ -76.673462, 38.234401 ], [ -76.678687, 38.234259 ], [ -76.687075, 38.234030 ], [ -76.712594, 38.233334 ], [ -76.716139, 38.233237 ], [ -76.716376, 38.233231 ], [ -76.717537, 38.233329 ], [ -76.719602, 38.233503 ], [ -76.740055, 38.235227 ], [ -76.744265, 38.230716 ], [ -76.749384, 38.225231 ], [ -76.752017, 38.222409 ], [ -76.752085, 38.222336 ], [ -76.752286, 38.222121 ], [ -76.769988, 38.226388 ], [ -76.778625, 38.228470 ], [ -76.779865, 38.229026 ], [ -76.791932, 38.234441 ], [ -76.796590, 38.236531 ], [ -76.797452, 38.236918 ], [ -76.811647, 38.250129 ], [ -76.811815, 38.251318 ], [ -76.811927, 38.252115 ], [ -76.809009, 38.252193 ], [ -76.808880, 38.252197 ], [ -76.808411, 38.252209 ], [ -76.805949, 38.252275 ], [ -76.805770, 38.252615 ], [ -76.805224, 38.253648 ], [ -76.802947, 38.275094 ], [ -76.802347, 38.280743 ], [ -76.804922, 38.283300 ], [ -76.805037, 38.283414 ], [ -76.805363, 38.283738 ], [ -76.805470, 38.283844 ], [ -76.806596, 38.284962 ], [ -76.810596, 38.288934 ], [ -76.811182, 38.289516 ], [ -76.815098, 38.293404 ], [ -76.816323, 38.294620 ], [ -76.820799, 38.299064 ], [ -76.821569, 38.299829 ], [ -76.821670, 38.299869 ], [ -76.824834, 38.301130 ], [ -76.824889, 38.301152 ], [ -76.834046, 38.299680 ], [ -76.845846, 38.297783 ], [ -76.846118, 38.297739 ], [ -76.846252, 38.297718 ], [ -76.846221, 38.291960 ], [ -76.846220, 38.291768 ], [ -76.841703, 38.289768 ], [ -76.841241, 38.289564 ], [ -76.840383, 38.289184 ], [ -76.838539, 38.284170 ], [ -76.834908, 38.274299 ], [ -76.834803, 38.274012 ], [ -76.835136, 38.272628 ], [ -76.837697, 38.261990 ], [ -76.837789, 38.261609 ], [ -76.842038, 38.254657 ], [ -76.842139, 38.254491 ], [ -76.843422, 38.254925 ], [ -76.844221, 38.255195 ], [ -76.844885, 38.255420 ], [ -76.846036, 38.255809 ], [ -76.847074, 38.256160 ], [ -76.864292, 38.268945 ], [ -76.866302, 38.269673 ], [ -76.866416, 38.269715 ], [ -76.886535, 38.277004 ], [ -76.908506, 38.288430 ], [ -76.920778, 38.291529 ], [ -76.920932, 38.291568 ], [ -76.922161, 38.311086 ], [ -76.922177, 38.311339 ], [ -76.923629, 38.314932 ], [ -76.924668, 38.316011 ], [ -76.927019, 38.318454 ], [ -76.929554, 38.321088 ], [ -76.942132, 38.329601 ], [ -76.953928, 38.333282 ], [ -76.966349, 38.341372 ], [ -76.975092, 38.347067 ], [ -76.975492, 38.347327 ], [ -76.983582, 38.362999 ], [ -76.986464, 38.382618 ], [ -76.986699, 38.384213 ], [ -76.986996, 38.386237 ], [ -76.987838, 38.391965 ], [ -76.988280, 38.394975 ], [ -76.989271, 38.396352 ], [ -76.989306, 38.396401 ], [ -76.990305, 38.397788 ], [ -76.993839, 38.402699 ], [ -76.996663, 38.406623 ], [ -76.996724, 38.406708 ], [ -76.998585, 38.409294 ], [ -76.998843, 38.410362 ], [ -77.000997, 38.419293 ], [ -77.001541, 38.421548 ], [ -77.001638, 38.421952 ], [ -77.001902, 38.422376 ], [ -77.002570, 38.423447 ], [ -77.006495, 38.429738 ], [ -77.006767, 38.430176 ], [ -77.016371, 38.445572 ], [ -77.016674, 38.445560 ], [ -77.040638, 38.444618 ], [ -77.042046, 38.443983 ], [ -77.042879, 38.443607 ], [ -77.044188, 38.443016 ], [ -77.053187, 38.437753 ], [ -77.053290, 38.437693 ], [ -77.053445, 38.437602 ], [ -77.053663, 38.437475 ], [ -77.053979, 38.437290 ], [ -77.054972, 38.436709 ], [ -77.055162, 38.436598 ], [ -77.055320, 38.436505 ], [ -77.056892, 38.435586 ], [ -77.057277, 38.435361 ], [ -77.057460, 38.435254 ], [ -77.057684, 38.435123 ], [ -77.062607, 38.432244 ], [ -77.074174, 38.425479 ], [ -77.074339, 38.425382 ], [ -77.074703, 38.425170 ], [ -77.075489, 38.424710 ], [ -77.081252, 38.419449 ], [ -77.081418, 38.419297 ], [ -77.086393, 38.414755 ], [ -77.091073, 38.407546 ], [ -77.106571, 38.406237 ], [ -77.106968, 38.406531 ], [ -77.107631, 38.407022 ], [ -77.107881, 38.407207 ], [ -77.109055, 38.408076 ], [ -77.109171, 38.408162 ], [ -77.110586, 38.409210 ], [ -77.110623, 38.409214 ], [ -77.123325, 38.410646 ], [ -77.125933, 38.404845 ], [ -77.127392, 38.401600 ], [ -77.127737, 38.400833 ], [ -77.128377, 38.400190 ], [ -77.128649, 38.399917 ], [ -77.128823, 38.399742 ], [ -77.128872, 38.399692 ], [ -77.129090, 38.399474 ], [ -77.130287, 38.398271 ], [ -77.135224, 38.393311 ], [ -77.136434, 38.392094 ], [ -77.136728, 38.391799 ], [ -77.136947, 38.391684 ], [ -77.139968, 38.390102 ], [ -77.143152, 38.388435 ], [ -77.147541, 38.386136 ], [ -77.163531, 38.377761 ], [ -77.168697, 38.375055 ], [ -77.177000, 38.370706 ], [ -77.179800, 38.369239 ], [ -77.182638, 38.367753 ], [ -77.183268, 38.367423 ], [ -77.184917, 38.366559 ], [ -77.186680, 38.365636 ], [ -77.189412, 38.364872 ], [ -77.205009, 38.360511 ], [ -77.207214, 38.359894 ], [ -77.207312, 38.359867 ], [ -77.207371, 38.359888 ], [ -77.208334, 38.360224 ], [ -77.212189, 38.361572 ], [ -77.216729, 38.363159 ], [ -77.216834, 38.363221 ], [ -77.236231, 38.374601 ], [ -77.250172, 38.382781 ], [ -77.250862, 38.384325 ], [ -77.251220, 38.385127 ], [ -77.253202, 38.389567 ], [ -77.256412, 38.396755 ], [ -77.257177, 38.398470 ], [ -77.261937, 38.409131 ], [ -77.264238, 38.414282 ], [ -77.261290, 38.423670 ], [ -77.259962, 38.427902 ], [ -77.259962, 38.435821 ], [ -77.260760, 38.438394 ], [ -77.263682, 38.447810 ], [ -77.266845, 38.458004 ], [ -77.269474, 38.466476 ], [ -77.274021, 38.481127 ], [ -77.274170, 38.481608 ], [ -77.274220, 38.481770 ], [ -77.274125, 38.482044 ], [ -77.271099, 38.490753 ], [ -77.263599, 38.512344 ], [ -77.257378, 38.521847 ], [ -77.254882, 38.525660 ], [ -77.246089, 38.539093 ], [ -77.242736, 38.544214 ], [ -77.237724, 38.551870 ], [ -77.236728, 38.552071 ], [ -77.226465, 38.554139 ], [ -77.221117, 38.555217 ], [ -77.209905, 38.568870 ], [ -77.205261, 38.574525 ], [ -77.183767, 38.600699 ], [ -77.175969, 38.604113 ], [ -77.169968, 38.606740 ], [ -77.169671, 38.606870 ], [ -77.167523, 38.606740 ], [ -77.163945, 38.606524 ], [ -77.163409, 38.606492 ], [ -77.163160, 38.606477 ], [ -77.162649, 38.606446 ], [ -77.161585, 38.606381 ], [ -77.148651, 38.605600 ], [ -77.146087, 38.606748 ], [ -77.135539, 38.611473 ], [ -77.129213, 38.614306 ], [ -77.129084, 38.614364 ], [ -77.128841, 38.614660 ], [ -77.126340, 38.617700 ], [ -77.125191, 38.619096 ], [ -77.124630, 38.619778 ], [ -77.130200, 38.635017 ], [ -77.135901, 38.649817 ], [ -77.132501, 38.673816 ], [ -77.121101, 38.686616 ], [ -77.105900, 38.696815 ], [ -77.086113, 38.705792 ], [ -77.074599, 38.711015 ], [ -77.059910, 38.734419 ], [ -77.041398, 38.763914 ], [ -77.039239, 38.785200 ], [ -77.038598, 38.791513 ], [ -77.024392, 38.802970 ], [ -77.001397, 38.821513 ], [ -76.953696, 38.858512 ], [ -76.949696, 38.861312 ], [ -76.920195, 38.884412 ], [ -76.919295, 38.885112 ], [ -76.910795, 38.891712 ], [ -76.909395, 38.892812 ], [ -76.941722, 38.918019 ], [ -77.002498, 38.965410 ], [ -77.002636, 38.965521 ], [ -77.008298, 38.970110 ], [ -77.013798, 38.974410 ], [ -77.015598, 38.975910 ], [ -77.036299, 38.991710 ], [ -77.040999, 38.995110 ], [ -77.054299, 38.985110 ], [ -77.100700, 38.948910 ], [ -77.119900, 38.934311 ], [ -77.137701, 38.955310 ], [ -77.148179, 38.965002 ], [ -77.166901, 38.968110 ], [ -77.197502, 38.966810 ], [ -77.221502, 38.971310 ], [ -77.235403, 38.976610 ], [ -77.249803, 38.985909 ], [ -77.255703, 39.002409 ], [ -77.251803, 39.011409 ], [ -77.261403, 39.031009 ], [ -77.291605, 39.045408 ], [ -77.328002, 39.058554 ], [ -77.340287, 39.062991 ], [ -77.375079, 39.061297 ], [ -77.423180, 39.066878 ], [ -77.458202, 39.073723 ], [ -77.519929, 39.120925 ], [ -77.524559, 39.127821 ], [ -77.527282, 39.146236 ], [ -77.516426, 39.170891 ], [ -77.510631, 39.178484 ], [ -77.505162, 39.182050 ], [ -77.485971, 39.185665 ], [ -77.478596, 39.189168 ], [ -77.458884, 39.219826 ], [ -77.458779, 39.220280 ], [ -77.457680, 39.225020 ], [ -77.460210, 39.228359 ], [ -77.484605, 39.245941 ], [ -77.511222, 39.253500 ], [ -77.534461, 39.262361 ], [ -77.543228, 39.266937 ], [ -77.545846, 39.271535 ], [ -77.560854, 39.286152 ], [ -77.592739, 39.301290 ], [ -77.667749, 39.318129 ], [ -77.677505, 39.318699 ], [ -77.719029, 39.321125 ], [ -77.727379, 39.321666 ], [ -77.755789, 39.333899 ], [ -77.760586, 39.338864 ], [ -77.760435, 39.344171 ], [ -77.739204, 39.385730 ], [ -77.765442, 39.428574 ], [ -77.807821, 39.490241 ], [ -77.825411, 39.494036 ], [ -77.845105, 39.498285 ], [ -77.865423, 39.516472 ], [ -77.888945, 39.555950 ], [ -77.886135, 39.560432 ], [ -77.884536, 39.568174 ], [ -77.902649, 39.587796 ], [ -77.946442, 39.584910 ], [ -78.009985, 39.602893 ], [ -78.023427, 39.619860 ], [ -78.035992, 39.635720 ], [ -78.074595, 39.666686 ], [ -78.107834, 39.682137 ], [ -78.143478, 39.690412 ], [ -78.176625, 39.695967 ], [ -78.182759, 39.695110 ], [ -78.191107, 39.690262 ], [ -78.224337, 39.663270 ], [ -78.271122, 39.619642 ], [ -78.283039, 39.620470 ], [ -78.313033, 39.631001 ], [ -78.334044, 39.635770 ], [ -78.355218, 39.640576 ], [ -78.430250, 39.623290 ], [ -78.457187, 39.587379 ], [ -78.458456, 39.581158 ], [ -78.454376, 39.574319 ], [ -78.450207, 39.570889 ], [ -78.432033, 39.561053 ], [ -78.436939, 39.538959 ], [ -78.468639, 39.516789 ], [ -78.565929, 39.519444 ], [ -78.655984, 39.534695 ], [ -78.657324, 39.535087 ], [ -78.676219, 39.540622 ], [ -78.689455, 39.545770 ], [ -78.760196, 39.582154 ], [ -78.767490, 39.587487 ], [ -78.772048, 39.593833 ], [ -78.769029, 39.599871 ], [ -78.760497, 39.609984 ], [ -78.787461, 39.627492 ], [ -78.824788, 39.590233 ], [ -78.874744, 39.522611 ], [ -78.968996, 39.441543 ], [ -79.025681, 39.465539 ], [ -79.042440, 39.479339 ], [ -79.067072, 39.474658 ], [ -79.084450, 39.471356 ], [ -79.201676, 39.379726 ], [ -79.213192, 39.367897 ], [ -79.256880, 39.356077 ], [ -79.280039, 39.340076 ], [ -79.378687, 39.271920 ], [ -79.402911, 39.250106 ], [ -79.486873, 39.205961 ], [ -79.485874, 39.264905 ], [ -79.486179, 39.264970 ], [ -79.486737, 39.278149 ], [ -79.487651, 39.279933 ], [ -79.482648, 39.521364 ], [ -79.482354, 39.524682 ], [ -79.478866, 39.531689 ], [ -79.476662, 39.721078 ], [ -79.392458, 39.721340 ], [ -78.931176, 39.722775 ], [ -78.931175, 39.722775 ], [ -78.808387, 39.722726 ], [ -78.380599, 39.722554 ], [ -78.342834, 39.722539 ], [ -78.342520, 39.722539 ], [ -78.340498, 39.722514 ], [ -78.339539, 39.722552 ], [ -78.337111, 39.722461 ], [ -78.330715, 39.722689 ], [ -78.269020, 39.722613 ], [ -78.268948, 39.722590 ], [ -78.243103, 39.722481 ], [ -78.240334, 39.722498 ], [ -78.204450, 39.722520 ], [ -78.202895, 39.722416 ], [ -78.099140, 39.722322 ], [ -78.075771, 39.722301 ], [ -78.073736, 39.722314 ], [ -77.768534, 39.721358 ], [ -77.743204, 39.721205 ], [ -77.732615, 39.721094 ], [ -77.724115, 39.720894 ], [ -77.674522, 39.720847 ], [ -77.672249, 39.720778 ], [ -77.534758, 39.720134 ], [ -77.533371, 39.720165 ], [ -77.469145, 39.720018 ], [ -77.459427, 39.720017 ], [ -77.243307, 39.719998 ], [ -77.239807, 39.719998 ], [ -77.217024, 39.719998 ], [ -77.216806, 39.719998 ], [ -77.058904, 39.720100 ], [ -77.058204, 39.720200 ], [ -77.047104, 39.720000 ], [ -76.999465, 39.720128 ], [ -76.897566, 39.720401 ], [ -76.890100, 39.720401 ], [ -76.809197, 39.720702 ], [ -76.806397, 39.720602 ], [ -76.787097, 39.720802 ], [ -76.787096, 39.720802 ], [ -76.715594, 39.721103 ], [ -76.711894, 39.721103 ], [ -76.569475, 39.721203 ], [ -76.569389, 39.721203 ], [ -76.517087, 39.721304 ], [ -76.491887, 39.721304 ], [ -76.418784, 39.721204 ], [ -76.418684, 39.721304 ], [ -76.395583, 39.721204 ], [ -76.380583, 39.721304 ], [ -76.380083, 39.721304 ], [ -76.239805, 39.721305 ], [ -76.233277, 39.721305 ], [ -76.233259, 39.721305 ], [ -76.224191, 39.721328 ], [ -76.135584, 39.721556 ], [ -76.027618, 39.721833 ], [ -76.013067, 39.721920 ], [ -75.810068, 39.721906 ], [ -75.799563, 39.721882 ], [ -75.788359, 39.721811 ], [ -75.788395, 39.700287 ], [ -75.788395, 39.700031 ], [ -75.788658, 39.681911 ], [ -75.788616, 39.680742 ], [ -75.787450, 39.637455 ], [ -75.786890, 39.630575 ], [ -75.779383, 39.536522 ], [ -75.779240, 39.534737 ], [ -75.766693, 39.377537 ], [ -75.766667, 39.377216 ], [ -75.760104, 39.296817 ], [ -75.755962, 39.246069 ], [ -75.755953, 39.245958 ], [ -75.747671, 39.143345 ], [ -75.747668, 39.143306 ], [ -75.746121, 39.120318 ], [ -75.745793, 39.114935 ], [ -75.725829, 38.869296 ], [ -75.725565, 38.868152 ], [ -75.724061, 38.847781 ], [ -75.724002, 38.846682 ], [ -75.722882, 38.833156 ], [ -75.722610, 38.830008 ], [ -75.722599, 38.829859 ], [ -75.722028, 38.822078 ], [ -75.707352, 38.635359 ], [ -75.707346, 38.635280 ], [ -75.706585, 38.626125 ], [ -75.706235, 38.621296 ], [ -75.705860, 38.616268 ], [ -75.705774, 38.614740 ], [ -75.703981, 38.592066 ], [ -75.703445, 38.585120 ], [ -75.701565, 38.560736 ], [ -75.701465, 38.559433 ], [ -75.700179, 38.542717 ], [ -75.698777, 38.522001 ], [ -75.696688, 38.496467 ], [ -75.696369, 38.492373 ], [ -75.693521, 38.460128 ], [ -75.665585, 38.458900 ], [ -75.662843, 38.458759 ], [ -75.630457, 38.457904 ], [ -75.598069, 38.456855 ], [ -75.593082, 38.456404 ], [ -75.589307, 38.456286 ], [ -75.583601, 38.456424 ], [ -75.574110, 38.455991 ], [ -75.559934, 38.455579 ], [ -75.559212, 38.455563 ], [ -75.533763, 38.454958 ], [ -75.522730, 38.454657 ], [ -75.521304, 38.454657 ], [ -75.502961, 38.454220 ], [ -75.500142, 38.454144 ], [ -75.479150, 38.453699 ], [ -75.428728, 38.452671 ], [ -75.424831, 38.452610 ], [ -75.410884, 38.452400 ], [ -75.394786, 38.452160 ], [ -75.393563, 38.452114 ], [ -75.371054, 38.452107 ], [ -75.355797, 38.452008 ], [ -75.341250, 38.451970 ], [ -75.341247, 38.451970 ], [ -75.260350, 38.451492 ], [ -75.252723, 38.451397 ], [ -75.185413, 38.451013 ], [ -75.141894, 38.451196 ], [ -75.089649, 38.451254 ], [ -75.088281, 38.451256 ], [ -75.085814, 38.451258 ], [ -75.070356, 38.451276 ], [ -75.069909, 38.451276 ], [ -75.066327, 38.451291 ], [ -75.053483, 38.451274 ], [ -75.052510, 38.451273 ], [ -75.049268, 38.451264 ], [ -75.048939, 38.451263 ], [ -75.049365, 38.448518 ], [ -75.049442, 38.448023 ], [ -75.049582, 38.447117 ], [ -75.051997, 38.431549 ], [ -75.052008, 38.431479 ], [ -75.052167, 38.430457 ], [ -75.052206, 38.430206 ], [ -75.052226, 38.430077 ], [ -75.052368, 38.429159 ], [ -75.052426, 38.428784 ], [ -75.052467, 38.428521 ], [ -75.052471, 38.428493 ], [ -75.052505, 38.428275 ], [ -75.052746, 38.426720 ], [ -75.052804, 38.426349 ], [ -75.052820, 38.426243 ], [ -75.053100, 38.424441 ], [ -75.053137, 38.424201 ], [ -75.053277, 38.423297 ], [ -75.053309, 38.423095 ], [ -75.054591, 38.414830 ], [ -75.055838, 38.410164 ], [ -75.056000, 38.409560 ], [ -75.056182, 38.408876 ], [ -75.057288, 38.404738 ], [ -75.061370, 38.389466 ], [ -75.068111, 38.368716 ], [ -75.068162, 38.368559 ], [ -75.068404, 38.367812 ], [ -75.068548, 38.367370 ], [ -75.068559, 38.367335 ], [ -75.069817, 38.363463 ], [ -75.069845, 38.363376 ], [ -75.071329, 38.358809 ], [ -75.071632, 38.357876 ], [ -75.071687, 38.357707 ], [ -75.071694, 38.357686 ], [ -75.072111, 38.356402 ], [ -75.072476, 38.355278 ], [ -75.073852, 38.352006 ], [ -75.074532, 38.350390 ], [ -75.084149, 38.327526 ], [ -75.085171, 38.325096 ], [ -75.085327, 38.324724 ], [ -75.085468, 38.324389 ], [ -75.085518, 38.324270 ], [ -75.087466, 38.322769 ], [ -75.092142, 38.323252 ], [ -75.093888, 38.323432 ], [ -75.102947, 38.311525 ], [ -75.103757, 38.309349 ], [ -75.116837, 38.274229 ], [ -75.143229, 38.220475 ], [ -75.155351, 38.192572 ], [ -75.158970, 38.184242 ], [ -75.161640, 38.176383 ], [ -75.177394, 38.130014 ], [ -75.178945, 38.126798 ], [ -75.192925, 38.097819 ], [ -75.193796, 38.096013 ], [ -75.195382, 38.093582 ], [ -75.204684, 38.079317 ], [ -75.204911, 38.078970 ], [ -75.206515, 38.076510 ], [ -75.216117, 38.061786 ], [ -75.224340, 38.050912 ], [ -75.227592, 38.046612 ], [ -75.235860, 38.035679 ], [ -75.236065, 38.035409 ], [ -75.237538, 38.033461 ], [ -75.241817, 38.027802 ], [ -75.242266, 38.027209 ], [ -75.242296, 38.027206 ], [ -75.250358, 38.026489 ], [ -75.256076, 38.025980 ], [ -75.260635, 38.025574 ], [ -75.262088, 38.025445 ], [ -75.263779, 38.025295 ], [ -75.377851, 38.015145 ], [ -75.398839, 38.013277 ], [ -75.428810, 38.010854 ], [ -75.435956, 38.010282 ], [ -75.624341, 37.994211 ], [ -75.626129, 37.992500 ], [ -75.630222, 37.988584 ], [ -75.635502, 37.983531 ], [ -75.639786, 37.979432 ], [ -75.644545, 37.974877 ], [ -75.644591, 37.974833 ], [ -75.644665, 37.974763 ], [ -75.645096, 37.974350 ], [ -75.645251, 37.974202 ], [ -75.646289, 37.973209 ], [ -75.646507, 37.973000 ], [ -75.660956, 37.959174 ], [ -75.669711, 37.950796 ], [ -75.665057, 37.956282 ], [ -75.663095, 37.961195 ], [ -75.665020, 37.962401 ], [ -75.669374, 37.965130 ], [ -75.671681, 37.966576 ], [ -75.685995, 37.967607 ], [ -75.686525, 37.967783 ], [ -75.708179, 37.974972 ], [ -75.713150, 37.976623 ], [ -75.722085, 37.973416 ], [ -75.722662, 37.971310 ], [ -75.724692, 37.969754 ], [ -75.725330, 37.969266 ], [ -75.727952, 37.967256 ], [ -75.735125, 37.964592 ], [ -75.737514, 37.963705 ], [ -75.737997, 37.963526 ], [ -75.750244, 37.968873 ], [ -75.759091, 37.970663 ], [ -75.776773, 37.972044 ], [ -75.778975, 37.972216 ], [ -75.783444, 37.972565 ], [ -75.783815, 37.972594 ], [ -75.785007, 37.971714 ], [ -75.785209, 37.971564 ], [ -75.785273, 37.971517 ], [ -75.785487, 37.971359 ], [ -75.788351, 37.969244 ], [ -75.789943, 37.968068 ], [ -75.806147, 37.956100 ], [ -75.806930, 37.955522 ], [ -75.807755, 37.954912 ], [ -75.819088, 37.946542 ], [ -75.820774, 37.945297 ], [ -75.822901, 37.943726 ], [ -75.824242, 37.942736 ], [ -75.824448, 37.942584 ], [ -75.829901, 37.938556 ], [ -75.830154, 37.938028 ], [ -75.831707, 37.934789 ], [ -75.831836, 37.934519 ], [ -75.832414, 37.933313 ], [ -75.832793, 37.933112 ], [ -75.843768, 37.927297 ], [ -75.845992, 37.926118 ], [ -75.846621, 37.925785 ], [ -75.847207, 37.925474 ], [ -75.847473, 37.925333 ], [ -75.847817, 37.925151 ], [ -75.847933, 37.925089 ], [ -75.848133, 37.924983 ], [ -75.849103, 37.924470 ], [ -75.860727, 37.918310 ], [ -75.881913, 37.912563 ], [ -75.883708, 37.912076 ], [ -75.885032, 37.911717 ], [ -75.892686, 37.916848 ], [ -75.895791, 37.921406 ], [ -75.895940, 37.921625 ], [ -75.898316, 37.925114 ], [ -75.894065, 37.930790 ], [ -75.893655, 37.933879 ], [ -75.892810, 37.940239 ], [ -75.890871, 37.954847 ], [ -75.898956, 37.974514 ], [ -75.882768, 38.002995 ], [ -75.875297, 38.011965 ], [ -75.875399, 38.028241 ], [ -75.873190, 38.034375 ], [ -75.869513, 38.035407 ], [ -75.865912, 38.036418 ], [ -75.864648, 38.036773 ], [ -75.858891, 38.038390 ], [ -75.857507, 38.038778 ], [ -75.856854, 38.038583 ], [ -75.855468, 38.038170 ], [ -75.854711, 38.037944 ], [ -75.852655, 38.037331 ], [ -75.850531, 38.036697 ], [ -75.850343, 38.035877 ], [ -75.849980, 38.034294 ], [ -75.847922, 38.034370 ], [ -75.847716, 38.034468 ], [ -75.836018, 38.040007 ], [ -75.834643, 38.040657 ], [ -75.833657, 38.041125 ], [ -75.833418, 38.041238 ], [ -75.830023, 38.042845 ], [ -75.829375, 38.043152 ], [ -75.829276, 38.043247 ], [ -75.826492, 38.045915 ], [ -75.825987, 38.046400 ], [ -75.812913, 38.058932 ], [ -75.813378, 38.059481 ], [ -75.813468, 38.059587 ], [ -75.819415, 38.066606 ], [ -75.819479, 38.066682 ], [ -75.819591, 38.066814 ], [ -75.830017, 38.069120 ], [ -75.831103, 38.069361 ], [ -75.832742, 38.069723 ], [ -75.839935, 38.071314 ], [ -75.841057, 38.071562 ], [ -75.841206, 38.071595 ], [ -75.844265, 38.072272 ], [ -75.847180, 38.071289 ], [ -75.852305, 38.069561 ], [ -75.858944, 38.067323 ], [ -75.859026, 38.067208 ], [ -75.859568, 38.066448 ], [ -75.860072, 38.065743 ], [ -75.859717, 38.064073 ], [ -75.859440, 38.062769 ], [ -75.859281, 38.062018 ], [ -75.859005, 38.060717 ], [ -75.858881, 38.060135 ], [ -75.860629, 38.059960 ], [ -75.860946, 38.059928 ], [ -75.861033, 38.059919 ], [ -75.861530, 38.059870 ], [ -75.866194, 38.059402 ], [ -75.867267, 38.059295 ], [ -75.867511, 38.059270 ], [ -75.868899, 38.059131 ], [ -75.871503, 38.058870 ], [ -75.874189, 38.060288 ], [ -75.880515, 38.075011 ], [ -75.871394, 38.089183 ], [ -75.870282, 38.090911 ], [ -75.865697, 38.098036 ], [ -75.865146, 38.098893 ], [ -75.863810, 38.100968 ], [ -75.842604, 38.113111 ], [ -75.837563, 38.113753 ], [ -75.837204, 38.114468 ], [ -75.837165, 38.114546 ], [ -75.837048, 38.114777 ], [ -75.827993, 38.132803 ], [ -75.827892, 38.133004 ], [ -75.827674, 38.133438 ], [ -75.827712, 38.133464 ], [ -75.843862, 38.144599 ], [ -75.849919, 38.144414 ], [ -75.854507, 38.142567 ], [ -75.858667, 38.140893 ], [ -75.859540, 38.140542 ], [ -75.866000, 38.134886 ], [ -75.868636, 38.134381 ], [ -75.870056, 38.134684 ], [ -75.871037, 38.134893 ], [ -75.880707, 38.136957 ], [ -75.880978, 38.137015 ], [ -75.900355, 38.141150 ], [ -75.901058, 38.140826 ], [ -75.902004, 38.140390 ], [ -75.903442, 38.139726 ], [ -75.905599, 38.138732 ], [ -75.906497, 38.138317 ], [ -75.907264, 38.137964 ], [ -75.923797, 38.130339 ], [ -75.932738, 38.126216 ], [ -75.936773, 38.124355 ], [ -75.937089, 38.124209 ], [ -75.937055, 38.123077 ], [ -75.937015, 38.121749 ], [ -75.936866, 38.116745 ], [ -75.936663, 38.109956 ], [ -75.938484, 38.109976 ], [ -75.945297, 38.113091 ], [ -75.949557, 38.118127 ], [ -75.956428, 38.131115 ], [ -75.956434, 38.131126 ], [ -75.958786, 38.135572 ], [ -75.959496, 38.136915 ], [ -75.959616, 38.137141 ], [ -75.952411, 38.158513 ], [ -75.951425, 38.161436 ], [ -75.951273, 38.161887 ], [ -75.949752, 38.164486 ], [ -75.947534, 38.168274 ], [ -75.947487, 38.168736 ], [ -75.947417, 38.169439 ], [ -75.947280, 38.170792 ], [ -75.948129, 38.171778 ], [ -75.948220, 38.171884 ], [ -75.948566, 38.172285 ], [ -75.948709, 38.172451 ], [ -75.951812, 38.176053 ], [ -75.951972, 38.176239 ], [ -75.951850, 38.176794 ], [ -75.951583, 38.178014 ], [ -75.951566, 38.178093 ], [ -75.949575, 38.180037 ], [ -75.949420, 38.180188 ], [ -75.948891, 38.180704 ], [ -75.948738, 38.180854 ], [ -75.946586, 38.182955 ], [ -75.945419, 38.184094 ], [ -75.942375, 38.187066 ], [ -75.941448, 38.187352 ], [ -75.933932, 38.189670 ], [ -75.888073, 38.203813 ], [ -75.886217, 38.203309 ], [ -75.884940, 38.200493 ], [ -75.884603, 38.199751 ], [ -75.884544, 38.199739 ], [ -75.878293, 38.198407 ], [ -75.877751, 38.198292 ], [ -75.877250, 38.198386 ], [ -75.870975, 38.199566 ], [ -75.868470, 38.200037 ], [ -75.864104, 38.200858 ], [ -75.862444, 38.201759 ], [ -75.856960, 38.204734 ], [ -75.854406, 38.206120 ], [ -75.852258, 38.207286 ], [ -75.848473, 38.209340 ], [ -75.847299, 38.209977 ], [ -75.847032, 38.210122 ], [ -75.846713, 38.210295 ], [ -75.846377, 38.210477 ], [ -75.851396, 38.226432 ], [ -75.851528, 38.226550 ], [ -75.859160, 38.233407 ], [ -75.864628, 38.238320 ], [ -75.870310, 38.243425 ], [ -75.870318, 38.243432 ], [ -75.872464, 38.243968 ], [ -75.874653, 38.244514 ], [ -75.882873, 38.244449 ], [ -75.883435, 38.244445 ], [ -75.885200, 38.243395 ], [ -75.886841, 38.242418 ], [ -75.887409, 38.242080 ], [ -75.888513, 38.241423 ], [ -75.889356, 38.239500 ], [ -75.885676, 38.231006 ], [ -75.885909, 38.230866 ], [ -75.890669, 38.228009 ], [ -75.894583, 38.228439 ], [ -75.895689, 38.228561 ], [ -75.895879, 38.228717 ], [ -75.899781, 38.231921 ], [ -75.900040, 38.232133 ], [ -75.900661, 38.233206 ], [ -75.901381, 38.234448 ], [ -75.905852, 38.242165 ], [ -75.906016, 38.242447 ], [ -75.908450, 38.246648 ], [ -75.908272, 38.252045 ], [ -75.911143, 38.257951 ], [ -75.917297, 38.263126 ], [ -75.919446, 38.264056 ], [ -75.920279, 38.264415 ], [ -75.925492, 38.266670 ], [ -75.938577, 38.272329 ], [ -75.940302, 38.271611 ], [ -75.942462, 38.270711 ], [ -75.942703, 38.270611 ], [ -75.948346, 38.268261 ], [ -75.951360, 38.267006 ], [ -75.951497, 38.266949 ], [ -75.951512, 38.266936 ], [ -75.951563, 38.266892 ], [ -75.951647, 38.266819 ], [ -75.954483, 38.264366 ], [ -75.954568, 38.264293 ], [ -75.954701, 38.264177 ], [ -75.954737, 38.264146 ], [ -75.954824, 38.264071 ], [ -75.954908, 38.263998 ], [ -75.954908, 38.263997 ], [ -75.954810, 38.261016 ], [ -75.954582, 38.254108 ], [ -75.954561, 38.253476 ], [ -75.954542, 38.252894 ], [ -75.950056, 38.249699 ], [ -75.949458, 38.249273 ], [ -75.948796, 38.248802 ], [ -75.947876, 38.248875 ], [ -75.945678, 38.249051 ], [ -75.944500, 38.249145 ], [ -75.943032, 38.248279 ], [ -75.942465, 38.247945 ], [ -75.942263, 38.247826 ], [ -75.940697, 38.246902 ], [ -75.941190, 38.246211 ], [ -75.942804, 38.243949 ], [ -75.946414, 38.238890 ], [ -75.948197, 38.238504 ], [ -75.951156, 38.237862 ], [ -75.955164, 38.236994 ], [ -75.955833, 38.236849 ], [ -75.958338, 38.236306 ], [ -75.958794, 38.236208 ], [ -75.961972, 38.235519 ], [ -75.962111, 38.235489 ], [ -75.962729, 38.235355 ], [ -75.962931, 38.235311 ], [ -75.970514, 38.233668 ], [ -75.971487, 38.233457 ], [ -75.972212, 38.233300 ], [ -75.970400, 38.235043 ], [ -75.970115, 38.235317 ], [ -75.969383, 38.236021 ], [ -75.969326, 38.236076 ], [ -75.964528, 38.240692 ], [ -75.964119, 38.241085 ], [ -75.963969, 38.241598 ], [ -75.962235, 38.247540 ], [ -75.963453, 38.251793 ], [ -75.984274, 38.265155 ], [ -75.985815, 38.276466 ], [ -75.987814, 38.279287 ], [ -75.988731, 38.280581 ], [ -75.990385, 38.282915 ], [ -75.991162, 38.283894 ], [ -75.991687, 38.284555 ], [ -75.992669, 38.285792 ], [ -75.992829, 38.285994 ], [ -75.993391, 38.286702 ], [ -76.000241, 38.295331 ], [ -76.004010, 38.300079 ], [ -76.007118, 38.303994 ], [ -76.007254, 38.304165 ], [ -76.007375, 38.304318 ], [ -76.007478, 38.304351 ], [ -76.011245, 38.305572 ], [ -76.011458, 38.305640 ], [ -76.016291, 38.307206 ], [ -76.016314, 38.307247 ], [ -76.016514, 38.307600 ], [ -76.017308, 38.309007 ], [ -76.017364, 38.309106 ], [ -76.009377, 38.311997 ], [ -76.008647, 38.312261 ], [ -75.991151, 38.314110 ], [ -75.990485, 38.314181 ], [ -75.986025, 38.314652 ], [ -75.984784, 38.314783 ], [ -75.984433, 38.314821 ], [ -75.983186, 38.314952 ], [ -75.983171, 38.314954 ], [ -75.982523, 38.315022 ], [ -75.981345, 38.315147 ], [ -75.969577, 38.320044 ], [ -75.969290, 38.320164 ], [ -75.968880, 38.320498 ], [ -75.964237, 38.324285 ], [ -75.961944, 38.332572 ], [ -75.961945, 38.335830 ], [ -75.961946, 38.336018 ], [ -75.961948, 38.341431 ], [ -75.965366, 38.348429 ], [ -75.966397, 38.350540 ], [ -75.968881, 38.355623 ], [ -75.969161, 38.356197 ], [ -75.970840, 38.359635 ], [ -75.971019, 38.360002 ], [ -75.971541, 38.361069 ], [ -75.971910, 38.361826 ], [ -75.972174, 38.362365 ], [ -75.972281, 38.362584 ], [ -75.973876, 38.365850 ], [ -75.979727, 38.367627 ], [ -75.980180, 38.367765 ], [ -75.980829, 38.367962 ], [ -75.995706, 38.372480 ], [ -76.001839, 38.374343 ], [ -76.002156, 38.374439 ], [ -76.002282, 38.374477 ], [ -76.004946, 38.372045 ], [ -76.006949, 38.370216 ], [ -76.011869, 38.360582 ], [ -76.012149, 38.357077 ], [ -76.011033, 38.354844 ], [ -76.010737, 38.354251 ], [ -76.010255, 38.353287 ], [ -76.010217, 38.353211 ], [ -76.010366, 38.352732 ], [ -76.010437, 38.352504 ], [ -76.016682, 38.332429 ], [ -76.033947, 38.323211 ], [ -76.041431, 38.322163 ], [ -76.041618, 38.322137 ], [ -76.041659, 38.322097 ], [ -76.043180, 38.320610 ], [ -76.043923, 38.319884 ], [ -76.044649, 38.319175 ], [ -76.045057, 38.318776 ], [ -76.045599, 38.318246 ], [ -76.045964, 38.317452 ], [ -76.046367, 38.316576 ], [ -76.047401, 38.314329 ], [ -76.047992, 38.313044 ], [ -76.048637, 38.311643 ], [ -76.048965, 38.310930 ], [ -76.049207, 38.310404 ], [ -76.049523, 38.309718 ], [ -76.049580, 38.309594 ], [ -76.049609, 38.309348 ], [ -76.049647, 38.309017 ], [ -76.050220, 38.304101 ], [ -76.047147, 38.301582 ], [ -76.040019, 38.295738 ], [ -76.030532, 38.287960 ], [ -76.028234, 38.282035 ], [ -76.027557, 38.280288 ], [ -76.027487, 38.280108 ], [ -76.032595, 38.268875 ], [ -76.032664, 38.268722 ], [ -76.032771, 38.268487 ], [ -76.032998, 38.267989 ], [ -76.033610, 38.266644 ], [ -76.033737, 38.266363 ], [ -76.038935, 38.254932 ], [ -76.039738, 38.254093 ], [ -76.043927, 38.249712 ], [ -76.044251, 38.249373 ], [ -76.044141, 38.243447 ], [ -76.044108, 38.241682 ], [ -76.043814, 38.241294 ], [ -76.037960, 38.233551 ], [ -76.037109, 38.232426 ], [ -76.037103, 38.232418 ], [ -76.036102, 38.231094 ], [ -76.035695, 38.230556 ], [ -76.033455, 38.222046 ], [ -76.033338, 38.221599 ], [ -76.032044, 38.216684 ], [ -76.058010, 38.227079 ], [ -76.069502, 38.238455 ], [ -76.070831, 38.241836 ], [ -76.071154, 38.242657 ], [ -76.073493, 38.248609 ], [ -76.073725, 38.249200 ], [ -76.074491, 38.251148 ], [ -76.074515, 38.251208 ], [ -76.074568, 38.251344 ], [ -76.074607, 38.251443 ], [ -76.074726, 38.251745 ], [ -76.074760, 38.251832 ], [ -76.074897, 38.252181 ], [ -76.082268, 38.252616 ], [ -76.082549, 38.252633 ], [ -76.089797, 38.253061 ], [ -76.092417, 38.253216 ], [ -76.092723, 38.253234 ], [ -76.094689, 38.253350 ], [ -76.099720, 38.253647 ], [ -76.107592, 38.262525 ], [ -76.102549, 38.277153 ], [ -76.111296, 38.286946 ], [ -76.126940, 38.283751 ], [ -76.131085, 38.282904 ], [ -76.137238, 38.281648 ], [ -76.137442, 38.281606 ], [ -76.138479, 38.281394 ], [ -76.138524, 38.281385 ], [ -76.138596, 38.281406 ], [ -76.140674, 38.282006 ], [ -76.140947, 38.282085 ], [ -76.143127, 38.282714 ], [ -76.149398, 38.284525 ], [ -76.149876, 38.284663 ], [ -76.160474, 38.290983 ], [ -76.160838, 38.290948 ], [ -76.161348, 38.290898 ], [ -76.166154, 38.290431 ], [ -76.173418, 38.285326 ], [ -76.173555, 38.285230 ], [ -76.173844, 38.284869 ], [ -76.174011, 38.284659 ], [ -76.174104, 38.284543 ], [ -76.174152, 38.284483 ], [ -76.174484, 38.284068 ], [ -76.174598, 38.283924 ], [ -76.174683, 38.283818 ], [ -76.180115, 38.277019 ], [ -76.180165, 38.276956 ], [ -76.180103, 38.276739 ], [ -76.179123, 38.273291 ], [ -76.178282, 38.270336 ], [ -76.175783, 38.261551 ], [ -76.171254, 38.256984 ], [ -76.164388, 38.250061 ], [ -76.163249, 38.248913 ], [ -76.146297, 38.249678 ], [ -76.135169, 38.245872 ], [ -76.134980, 38.245807 ], [ -76.132544, 38.244974 ], [ -76.130952, 38.244430 ], [ -76.126623, 38.242949 ], [ -76.126453, 38.242046 ], [ -76.125856, 38.238880 ], [ -76.125756, 38.238348 ], [ -76.128452, 38.235704 ], [ -76.128898, 38.235267 ], [ -76.131332, 38.232880 ], [ -76.140068, 38.231305 ], [ -76.151035, 38.234215 ], [ -76.173350, 38.247037 ], [ -76.188644, 38.267434 ], [ -76.189627, 38.272487 ], [ -76.189655, 38.272633 ], [ -76.190531, 38.277139 ], [ -76.197155, 38.285220 ], [ -76.197693, 38.285877 ], [ -76.197871, 38.286094 ], [ -76.201591, 38.290633 ], [ -76.201603, 38.290647 ], [ -76.202334, 38.291539 ], [ -76.202628, 38.291898 ], [ -76.202897, 38.292226 ], [ -76.203430, 38.292876 ], [ -76.203909, 38.293461 ], [ -76.211446, 38.302656 ], [ -76.216266, 38.305023 ], [ -76.217616, 38.305686 ], [ -76.218051, 38.305899 ], [ -76.226376, 38.309988 ], [ -76.226408, 38.309989 ], [ -76.243897, 38.310313 ], [ -76.254473, 38.315120 ], [ -76.258189, 38.318373 ], [ -76.266602, 38.339502 ], [ -76.264186, 38.346436 ], [ -76.259286, 38.341619 ], [ -76.259261, 38.341595 ], [ -76.259235, 38.341603 ], [ -76.258383, 38.341865 ], [ -76.257898, 38.342014 ], [ -76.238452, 38.347986 ], [ -76.238478, 38.348355 ], [ -76.238541, 38.349238 ], [ -76.238611, 38.350233 ], [ -76.239010, 38.350738 ], [ -76.239056, 38.350795 ], [ -76.239601, 38.351486 ], [ -76.239902, 38.351866 ], [ -76.240196, 38.352238 ], [ -76.240410, 38.352508 ], [ -76.247350, 38.361285 ], [ -76.248766, 38.363076 ], [ -76.249666, 38.364214 ], [ -76.256788, 38.366712 ], [ -76.257479, 38.366702 ], [ -76.258022, 38.366695 ], [ -76.273003, 38.366483 ], [ -76.278722, 38.382919 ], [ -76.278813, 38.383179 ], [ -76.280749, 38.388743 ], [ -76.281214, 38.390079 ], [ -76.281320, 38.390384 ], [ -76.281396, 38.390604 ], [ -76.281697, 38.391470 ], [ -76.282144, 38.392754 ], [ -76.282271, 38.393118 ], [ -76.280551, 38.403143 ], [ -76.283020, 38.413512 ], [ -76.290681, 38.424404 ], [ -76.300186, 38.437916 ], [ -76.301488, 38.439767 ], [ -76.311600, 38.450266 ], [ -76.311767, 38.450439 ], [ -76.320843, 38.459862 ], [ -76.331383, 38.473323 ], [ -76.331469, 38.473432 ], [ -76.331559, 38.473548 ], [ -76.331758, 38.474324 ], [ -76.331990, 38.475225 ], [ -76.336360, 38.492235 ], [ -76.327257, 38.500121 ], [ -76.318054, 38.498199 ], [ -76.289507, 38.503906 ], [ -76.283595, 38.504157 ], [ -76.281761, 38.502165 ], [ -76.263968, 38.503452 ], [ -76.262133, 38.504874 ], [ -76.260350, 38.506255 ], [ -76.247894, 38.523019 ], [ -76.247300, 38.523818 ], [ -76.244396, 38.536966 ], [ -76.248885, 38.539023 ], [ -76.250265, 38.539131 ], [ -76.251033, 38.539191 ], [ -76.253624, 38.539393 ], [ -76.274057, 38.531207 ], [ -76.278106, 38.532468 ], [ -76.281047, 38.536130 ], [ -76.277461, 38.541851 ], [ -76.275913, 38.548809 ], [ -76.279640, 38.557231 ], [ -76.283189, 38.561300 ], [ -76.283632, 38.561807 ], [ -76.289017, 38.567982 ], [ -76.290043, 38.569158 ], [ -76.290667, 38.569247 ], [ -76.296469, 38.570076 ], [ -76.299301, 38.570480 ], [ -76.308321, 38.571769 ], [ -76.305172, 38.575293 ], [ -76.291998, 38.581988 ], [ -76.290895, 38.582548 ], [ -76.273496, 38.591390 ], [ -76.268633, 38.597753 ], [ -76.272584, 38.601997 ], [ -76.274611, 38.604174 ], [ -76.274888, 38.604471 ], [ -76.275246, 38.604856 ], [ -76.275282, 38.604895 ], [ -76.275658, 38.605298 ], [ -76.279589, 38.609520 ], [ -76.278146, 38.610662 ], [ -76.276734, 38.611779 ], [ -76.271827, 38.615661 ], [ -76.264155, 38.615109 ], [ -76.263577, 38.615475 ], [ -76.262791, 38.615973 ], [ -76.261135, 38.617021 ], [ -76.260317, 38.617539 ], [ -76.253926, 38.621586 ], [ -76.247896, 38.625404 ], [ -76.246510, 38.626282 ], [ -76.236650, 38.628598 ], [ -76.235987, 38.626827 ], [ -76.234929, 38.624002 ], [ -76.231187, 38.614010 ], [ -76.229358, 38.613301 ], [ -76.229159, 38.613224 ], [ -76.228820, 38.613093 ], [ -76.222982, 38.610830 ], [ -76.220701, 38.609945 ], [ -76.212427, 38.606738 ], [ -76.212414, 38.606744 ], [ -76.203065, 38.610741 ], [ -76.202598, 38.613011 ], [ -76.190902, 38.621092 ], [ -76.174969, 38.628791 ], [ -76.170066, 38.629225 ], [ -76.160148, 38.625452 ], [ -76.152885, 38.631819 ], [ -76.147158, 38.636840 ], [ -76.147577, 38.637893 ], [ -76.148202, 38.639463 ], [ -76.148559, 38.640362 ], [ -76.148955, 38.641356 ], [ -76.149353, 38.642356 ], [ -76.152554, 38.650400 ], [ -76.152603, 38.650523 ], [ -76.152622, 38.650572 ], [ -76.152990, 38.651495 ], [ -76.153414, 38.652562 ], [ -76.153769, 38.653455 ], [ -76.154093, 38.654269 ], [ -76.154581, 38.655495 ], [ -76.154604, 38.655553 ], [ -76.154889, 38.656268 ], [ -76.154924, 38.656358 ], [ -76.155611, 38.658083 ], [ -76.160539, 38.661903 ], [ -76.164465, 38.664946 ], [ -76.168824, 38.668325 ], [ -76.174611, 38.672811 ], [ -76.175159, 38.673236 ], [ -76.196716, 38.672860 ], [ -76.199722, 38.671127 ], [ -76.199948, 38.670997 ], [ -76.200334, 38.670774 ], [ -76.212808, 38.681892 ], [ -76.226343, 38.698057 ], [ -76.229242, 38.701519 ], [ -76.231392, 38.704088 ], [ -76.231758, 38.704524 ], [ -76.232127, 38.704964 ], [ -76.232365, 38.705249 ], [ -76.232535, 38.705452 ], [ -76.232814, 38.705785 ], [ -76.232845, 38.705823 ], [ -76.232875, 38.705859 ], [ -76.232893, 38.705880 ], [ -76.234249, 38.707499 ], [ -76.234379, 38.707655 ], [ -76.234392, 38.707670 ], [ -76.234828, 38.708191 ], [ -76.237818, 38.711762 ], [ -76.237916, 38.711879 ], [ -76.238077, 38.712071 ], [ -76.238172, 38.712185 ], [ -76.238306, 38.712344 ], [ -76.238725, 38.712845 ], [ -76.239377, 38.716880 ], [ -76.239427, 38.717191 ], [ -76.239841, 38.719756 ], [ -76.237040, 38.724518 ], [ -76.238685, 38.735434 ], [ -76.255093, 38.736476 ], [ -76.255348, 38.736273 ], [ -76.257335, 38.734691 ], [ -76.257423, 38.734621 ], [ -76.257437, 38.734609 ], [ -76.257851, 38.734280 ], [ -76.258738, 38.733573 ], [ -76.259238, 38.733176 ], [ -76.259665, 38.732836 ], [ -76.259741, 38.732775 ], [ -76.259867, 38.732675 ], [ -76.259876, 38.732667 ], [ -76.260001, 38.732568 ], [ -76.260976, 38.731791 ], [ -76.261863, 38.731085 ], [ -76.268288, 38.725969 ], [ -76.268739, 38.725609 ], [ -76.269370, 38.725107 ], [ -76.269520, 38.724988 ], [ -76.270277, 38.724385 ], [ -76.271243, 38.716209 ], [ -76.271447, 38.714480 ], [ -76.271553, 38.713576 ], [ -76.271596, 38.713216 ], [ -76.275015, 38.712714 ], [ -76.275019, 38.712715 ], [ -76.298499, 38.718005 ], [ -76.299171, 38.719287 ], [ -76.296603, 38.723183 ], [ -76.296537, 38.723283 ], [ -76.295957, 38.724162 ], [ -76.298186, 38.726255 ], [ -76.299350, 38.727347 ], [ -76.299401, 38.727395 ], [ -76.312756, 38.730708 ], [ -76.316146, 38.729586 ], [ -76.321803, 38.723565 ], [ -76.321885, 38.723478 ], [ -76.322019, 38.723335 ], [ -76.322028, 38.723326 ], [ -76.322663, 38.722650 ], [ -76.322705, 38.722605 ], [ -76.322706, 38.722604 ], [ -76.322730, 38.722578 ], [ -76.322807, 38.722496 ], [ -76.322860, 38.722439 ], [ -76.322975, 38.722317 ], [ -76.323214, 38.722063 ], [ -76.323530, 38.721727 ], [ -76.326135, 38.718954 ], [ -76.327162, 38.717861 ], [ -76.328035, 38.716932 ], [ -76.328338, 38.716609 ], [ -76.330149, 38.714682 ], [ -76.331479, 38.713266 ], [ -76.332517, 38.709118 ], [ -76.333066, 38.706927 ], [ -76.333532, 38.705063 ], [ -76.333777, 38.704086 ], [ -76.334017, 38.703127 ], [ -76.333862, 38.702953 ], [ -76.332079, 38.700956 ], [ -76.321865, 38.689512 ], [ -76.321881, 38.689217 ], [ -76.321898, 38.688902 ], [ -76.321905, 38.688768 ], [ -76.321915, 38.688584 ], [ -76.322418, 38.679304 ], [ -76.338610, 38.672023 ], [ -76.340065, 38.671369 ], [ -76.340341, 38.671245 ], [ -76.343220, 38.676880 ], [ -76.343277, 38.676992 ], [ -76.343784, 38.677985 ], [ -76.344199, 38.678798 ], [ -76.347998, 38.686234 ], [ -76.345072, 38.703546 ], [ -76.344597, 38.706352 ], [ -76.340543, 38.730338 ], [ -76.340567, 38.731008 ], [ -76.340608, 38.732179 ], [ -76.340618, 38.732464 ], [ -76.340628, 38.732756 ], [ -76.340632, 38.732857 ], [ -76.340635, 38.732960 ], [ -76.340637, 38.733003 ], [ -76.340641, 38.733123 ], [ -76.340645, 38.733225 ], [ -76.340677, 38.734136 ], [ -76.340715, 38.735215 ], [ -76.340732, 38.735712 ], [ -76.340739, 38.735894 ], [ -76.340740, 38.735932 ], [ -76.341093, 38.745959 ], [ -76.341096, 38.746058 ], [ -76.341100, 38.746148 ], [ -76.341288, 38.751505 ], [ -76.341293, 38.751654 ], [ -76.341297, 38.751756 ], [ -76.341302, 38.751901 ], [ -76.334619, 38.772911 ], [ -76.333752, 38.773420 ], [ -76.329721, 38.775789 ], [ -76.323768, 38.779287 ], [ -76.322700, 38.780657 ], [ -76.312886, 38.793247 ], [ -76.310743, 38.795996 ], [ -76.310664, 38.796098 ], [ -76.310626, 38.796147 ], [ -76.310556, 38.796237 ], [ -76.310081, 38.796846 ], [ -76.308922, 38.813346 ], [ -76.308306, 38.814331 ], [ -76.308294, 38.814349 ], [ -76.308127, 38.814618 ], [ -76.307267, 38.815993 ], [ -76.301886, 38.824595 ], [ -76.300889, 38.826190 ], [ -76.300886, 38.826192 ], [ -76.298956, 38.827519 ], [ -76.297800, 38.828314 ], [ -76.296564, 38.828186 ], [ -76.296471, 38.828176 ], [ -76.296394, 38.828168 ], [ -76.296364, 38.828165 ], [ -76.296329, 38.828162 ], [ -76.296320, 38.828161 ], [ -76.296259, 38.828155 ], [ -76.295992, 38.828127 ], [ -76.295550, 38.828081 ], [ -76.295454, 38.828071 ], [ -76.295436, 38.828069 ], [ -76.293648, 38.827884 ], [ -76.292144, 38.827729 ], [ -76.288455, 38.827347 ], [ -76.284768, 38.828706 ], [ -76.277854, 38.831256 ], [ -76.277748, 38.831295 ], [ -76.277411, 38.831419 ], [ -76.277420, 38.831468 ], [ -76.278151, 38.835494 ], [ -76.278040, 38.835768 ], [ -76.274405, 38.844766 ], [ -76.271575, 38.851771 ], [ -76.267175, 38.851652 ], [ -76.265999, 38.851620 ], [ -76.264221, 38.851572 ], [ -76.265759, 38.847638 ], [ -76.265808, 38.847512 ], [ -76.265678, 38.847326 ], [ -76.262179, 38.842325 ], [ -76.261907, 38.841936 ], [ -76.261627, 38.841536 ], [ -76.257353, 38.835428 ], [ -76.255787, 38.833189 ], [ -76.255343, 38.832554 ], [ -76.255322, 38.832525 ], [ -76.250364, 38.825438 ], [ -76.250296, 38.825389 ], [ -76.245886, 38.822232 ], [ -76.238770, 38.819590 ], [ -76.229199, 38.816036 ], [ -76.228071, 38.815617 ], [ -76.221162, 38.813052 ], [ -76.219328, 38.812371 ], [ -76.198138, 38.814440 ], [ -76.197432, 38.815541 ], [ -76.196488, 38.817015 ], [ -76.196426, 38.817111 ], [ -76.195370, 38.818759 ], [ -76.193430, 38.821787 ], [ -76.193272, 38.822319 ], [ -76.193073, 38.822989 ], [ -76.193020, 38.823165 ], [ -76.192924, 38.823489 ], [ -76.192865, 38.823687 ], [ -76.192765, 38.824024 ], [ -76.192537, 38.824790 ], [ -76.191090, 38.829660 ], [ -76.191172, 38.829834 ], [ -76.192874, 38.833450 ], [ -76.192946, 38.833603 ], [ -76.192973, 38.833661 ], [ -76.197705, 38.843712 ], [ -76.197736, 38.843830 ], [ -76.199544, 38.850817 ], [ -76.200728, 38.855389 ], [ -76.202598, 38.862616 ], [ -76.202314, 38.864906 ], [ -76.200082, 38.882885 ], [ -76.205063, 38.892726 ], [ -76.204544, 38.905715 ], [ -76.204129, 38.916096 ], [ -76.204122, 38.916269 ], [ -76.204091, 38.917058 ], [ -76.203638, 38.928382 ], [ -76.207695, 38.931954 ], [ -76.213731, 38.937269 ], [ -76.213842, 38.937366 ], [ -76.228130, 38.941412 ], [ -76.228405, 38.941489 ], [ -76.232038, 38.942518 ], [ -76.233895, 38.942123 ], [ -76.234681, 38.941956 ], [ -76.250157, 38.938667 ], [ -76.250868, 38.928250 ], [ -76.250838, 38.928204 ], [ -76.249622, 38.926297 ], [ -76.249246, 38.925707 ], [ -76.248896, 38.925159 ], [ -76.248844, 38.925076 ], [ -76.248702, 38.924855 ], [ -76.248574, 38.924655 ], [ -76.248472, 38.924494 ], [ -76.248023, 38.923790 ], [ -76.249163, 38.921800 ], [ -76.249285, 38.921587 ], [ -76.249355, 38.921465 ], [ -76.249674, 38.920907 ], [ -76.249889, 38.920841 ], [ -76.255819, 38.919008 ], [ -76.256190, 38.918893 ], [ -76.256397, 38.918829 ], [ -76.258080, 38.919160 ], [ -76.258206, 38.919185 ], [ -76.262226, 38.919976 ], [ -76.264683, 38.924576 ], [ -76.264692, 38.924764 ], [ -76.264943, 38.930297 ], [ -76.265772, 38.931482 ], [ -76.266260, 38.932179 ], [ -76.269179, 38.936349 ], [ -76.270954, 38.938886 ], [ -76.271625, 38.939844 ], [ -76.273022, 38.941840 ], [ -76.273083, 38.941927 ], [ -76.273258, 38.941826 ], [ -76.276033, 38.940213 ], [ -76.284227, 38.935452 ], [ -76.288813, 38.932787 ], [ -76.291211, 38.931394 ], [ -76.295580, 38.928855 ], [ -76.295911, 38.928663 ], [ -76.298208, 38.922060 ], [ -76.299431, 38.918542 ], [ -76.299406, 38.918505 ], [ -76.298492, 38.917121 ], [ -76.293963, 38.910266 ], [ -76.293867, 38.910121 ], [ -76.293843, 38.909826 ], [ -76.293829, 38.909649 ], [ -76.293794, 38.909222 ], [ -76.293492, 38.905499 ], [ -76.293358, 38.903854 ], [ -76.293341, 38.903635 ], [ -76.293328, 38.903479 ], [ -76.293309, 38.903244 ], [ -76.293255, 38.902582 ], [ -76.293254, 38.902568 ], [ -76.308425, 38.898404 ], [ -76.317947, 38.911312 ], [ -76.317977, 38.911311 ], [ -76.318530, 38.911299 ], [ -76.319272, 38.911282 ], [ -76.322715, 38.911205 ], [ -76.323252, 38.911193 ], [ -76.324097, 38.911174 ], [ -76.324102, 38.911172 ], [ -76.336104, 38.905977 ], [ -76.336116, 38.905907 ], [ -76.336827, 38.901905 ], [ -76.336966, 38.901118 ], [ -76.337097, 38.900380 ], [ -76.337227, 38.899653 ], [ -76.337358, 38.898915 ], [ -76.338047, 38.895034 ], [ -76.338123, 38.894601 ], [ -76.338416, 38.892954 ], [ -76.338501, 38.892474 ], [ -76.337946, 38.891332 ], [ -76.336986, 38.889357 ], [ -76.336560, 38.888481 ], [ -76.336326, 38.888001 ], [ -76.335681, 38.886673 ], [ -76.335364, 38.886021 ], [ -76.335341, 38.885907 ], [ -76.333801, 38.878194 ], [ -76.333258, 38.875478 ], [ -76.333211, 38.875241 ], [ -76.332651, 38.872438 ], [ -76.331103, 38.864686 ], [ -76.331030, 38.864320 ], [ -76.334019, 38.860238 ], [ -76.337901, 38.857579 ], [ -76.338136, 38.857418 ], [ -76.339667, 38.856370 ], [ -76.340587, 38.855740 ], [ -76.348826, 38.857134 ], [ -76.350390, 38.857399 ], [ -76.356361, 38.854396 ], [ -76.359960, 38.852586 ], [ -76.360095, 38.852518 ], [ -76.361141, 38.851992 ], [ -76.361320, 38.851589 ], [ -76.366501, 38.839936 ], [ -76.368164, 38.836194 ], [ -76.368195, 38.836125 ], [ -76.368359, 38.836205 ], [ -76.372719, 38.838324 ], [ -76.373122, 38.838519 ], [ -76.375086, 38.839474 ], [ -76.375138, 38.839981 ], [ -76.375303, 38.841611 ], [ -76.375443, 38.842988 ], [ -76.376031, 38.848777 ], [ -76.376202, 38.850461 ], [ -76.376183, 38.850500 ], [ -76.375874, 38.851126 ], [ -76.372553, 38.857860 ], [ -76.367549, 38.868009 ], [ -76.367344, 38.868424 ], [ -76.364678, 38.873831 ], [ -76.365225, 38.892614 ], [ -76.365388, 38.898219 ], [ -76.365658, 38.907477 ], [ -76.365130, 38.911736 ], [ -76.364780, 38.914553 ], [ -76.364523, 38.916632 ], [ -76.362050, 38.936568 ], [ -76.361727, 38.939175 ], [ -76.359669, 38.943880 ], [ -76.357933, 38.947848 ], [ -76.357752, 38.948262 ], [ -76.354949, 38.954672 ], [ -76.353828, 38.957234 ], [ -76.351637, 38.960214 ], [ -76.343672, 38.971048 ], [ -76.333703, 38.984607 ], [ -76.331290, 38.987890 ], [ -76.323293, 38.998767 ], [ -76.322679, 38.999602 ], [ -76.322346, 39.005488 ], [ -76.322296, 39.006375 ], [ -76.323557, 39.008961 ], [ -76.322590, 39.013100 ], [ -76.320277, 39.022998 ], [ -76.320274, 39.023013 ], [ -76.320269, 39.023020 ], [ -76.311766, 39.035257 ], [ -76.302029, 39.039571 ], [ -76.301847, 39.039651 ], [ -76.301645, 39.037663 ], [ -76.301506, 39.036298 ], [ -76.301054, 39.031862 ], [ -76.301040, 39.031721 ], [ -76.301027, 39.031595 ], [ -76.302846, 39.025828 ], [ -76.302650, 39.025346 ], [ -76.294090, 39.004263 ], [ -76.293962, 39.003948 ], [ -76.291900, 39.001264 ], [ -76.289326, 38.997914 ], [ -76.286484, 38.994215 ], [ -76.284893, 38.992143 ], [ -76.283280, 38.990044 ], [ -76.280355, 38.986236 ], [ -76.278058, 38.983246 ], [ -76.277478, 38.982492 ], [ -76.277457, 38.982493 ], [ -76.275964, 38.982587 ], [ -76.258813, 38.983664 ], [ -76.258724, 38.983646 ], [ -76.246049, 38.981035 ], [ -76.243619, 38.980534 ], [ -76.229993, 38.977728 ], [ -76.229277, 38.977580 ], [ -76.228748, 38.977220 ], [ -76.218929, 38.970538 ], [ -76.218773, 38.970562 ], [ -76.202360, 38.973079 ], [ -76.202081, 38.973272 ], [ -76.187165, 38.983558 ], [ -76.182461, 38.986802 ], [ -76.180663, 38.988042 ], [ -76.168332, 38.996546 ], [ -76.164004, 38.999530 ], [ -76.163988, 38.999541 ], [ -76.163988, 38.999542 ], [ -76.163956, 39.000437 ], [ -76.163898, 39.002096 ], [ -76.163616, 39.010057 ], [ -76.167574, 39.018273 ], [ -76.173393, 39.025550 ], [ -76.174633, 39.027100 ], [ -76.177832, 39.031102 ], [ -76.178115, 39.031456 ], [ -76.178281, 39.031663 ], [ -76.184207, 39.046264 ], [ -76.179456, 39.052941 ], [ -76.177046, 39.056329 ], [ -76.175284, 39.058805 ], [ -76.169060, 39.062787 ], [ -76.158960, 39.065486 ], [ -76.156572, 39.069433 ], [ -76.153465, 39.074568 ], [ -76.150528, 39.079421 ], [ -76.145174, 39.092824 ], [ -76.158090, 39.093998 ], [ -76.167347, 39.094839 ], [ -76.169087, 39.094997 ], [ -76.169414, 39.095027 ], [ -76.169891, 39.095070 ], [ -76.183908, 39.096344 ], [ -76.189907, 39.093042 ], [ -76.194703, 39.090403 ], [ -76.203333, 39.085654 ], [ -76.203383, 39.085626 ], [ -76.203548, 39.085101 ], [ -76.205108, 39.080129 ], [ -76.207604, 39.072176 ], [ -76.210041, 39.064410 ], [ -76.210251, 39.062511 ], [ -76.210876, 39.056874 ], [ -76.211838, 39.048184 ], [ -76.212563, 39.041641 ], [ -76.212602, 39.041288 ], [ -76.212616, 39.041158 ], [ -76.212040, 39.038870 ], [ -76.211589, 39.037080 ], [ -76.210477, 39.032664 ], [ -76.209827, 39.030081 ], [ -76.209517, 39.028848 ], [ -76.208502, 39.024818 ], [ -76.208346, 39.024614 ], [ -76.206852, 39.022649 ], [ -76.206796, 39.022575 ], [ -76.205958, 39.021475 ], [ -76.200666, 39.014520 ], [ -76.201005, 39.014339 ], [ -76.202176, 39.013714 ], [ -76.209114, 39.010010 ], [ -76.209285, 39.010074 ], [ -76.216850, 39.012916 ], [ -76.221148, 39.014530 ], [ -76.223671, 39.015478 ], [ -76.231765, 39.018518 ], [ -76.240226, 39.026581 ], [ -76.241932, 39.028206 ], [ -76.242687, 39.028926 ], [ -76.240905, 39.039798 ], [ -76.239443, 39.041977 ], [ -76.237500, 39.044872 ], [ -76.237065, 39.045521 ], [ -76.231212, 39.060769 ], [ -76.231117, 39.061017 ], [ -76.231427, 39.071714 ], [ -76.231748, 39.082826 ], [ -76.233457, 39.091385 ], [ -76.240603, 39.106856 ], [ -76.245050, 39.116484 ], [ -76.252946, 39.133577 ], [ -76.252968, 39.133626 ], [ -76.260343, 39.142722 ], [ -76.260894, 39.143402 ], [ -76.264417, 39.143874 ], [ -76.266540, 39.144158 ], [ -76.268096, 39.144367 ], [ -76.274907, 39.145279 ], [ -76.276721, 39.145522 ], [ -76.278527, 39.145764 ], [ -76.276807, 39.154484 ], [ -76.275660, 39.160304 ], [ -76.274741, 39.164961 ], [ -76.274637, 39.165490 ], [ -76.274303, 39.166115 ], [ -76.269467, 39.175163 ], [ -76.268631, 39.176727 ], [ -76.266963, 39.179848 ], [ -76.266602, 39.180523 ], [ -76.255831, 39.191595 ], [ -76.251032, 39.199214 ], [ -76.248741, 39.203333 ], [ -76.232612, 39.232333 ], [ -76.232051, 39.233341 ], [ -76.226220, 39.246485 ], [ -76.220475, 39.259433 ], [ -76.219338, 39.261997 ], [ -76.219312, 39.262022 ], [ -76.218339, 39.262963 ], [ -76.217520, 39.263754 ], [ -76.211306, 39.269761 ], [ -76.211253, 39.269812 ], [ -76.211179, 39.269813 ], [ -76.210748, 39.269816 ], [ -76.203031, 39.269871 ], [ -76.202590, 39.270265 ], [ -76.193029, 39.278801 ], [ -76.191285, 39.280358 ], [ -76.189868, 39.281623 ], [ -76.185909, 39.285157 ], [ -76.185674, 39.285367 ], [ -76.181496, 39.291797 ], [ -76.181478, 39.291829 ], [ -76.177712, 39.298686 ], [ -76.177704, 39.298701 ], [ -76.177178, 39.303099 ], [ -76.176804, 39.306229 ], [ -76.176778, 39.306447 ], [ -76.176865, 39.306584 ], [ -76.178983, 39.309926 ], [ -76.179092, 39.310098 ], [ -76.186024, 39.312462 ], [ -76.186637, 39.315426 ], [ -76.186647, 39.315475 ], [ -76.186001, 39.317814 ], [ -76.185581, 39.319334 ], [ -76.185507, 39.319396 ], [ -76.170588, 39.331954 ], [ -76.170541, 39.331994 ], [ -76.170422, 39.332094 ], [ -76.169411, 39.332453 ], [ -76.168365, 39.332824 ], [ -76.159673, 39.335909 ], [ -76.157163, 39.335641 ], [ -76.152722, 39.335167 ], [ -76.145524, 39.334399 ], [ -76.133225, 39.340491 ], [ -76.135105, 39.342460 ], [ -76.136971, 39.344414 ], [ -76.134950, 39.351070 ], [ -76.129983, 39.353702 ], [ -76.116698, 39.360744 ], [ -76.116356, 39.360925 ], [ -76.115935, 39.361744 ], [ -76.113215, 39.367032 ], [ -76.110598, 39.372119 ], [ -76.110527, 39.372257 ], [ -76.108942, 39.372215 ], [ -76.108373, 39.372200 ], [ -76.074992, 39.371312 ], [ -76.065887, 39.371070 ], [ -76.065716, 39.371066 ], [ -76.061504, 39.370954 ], [ -76.059335, 39.370896 ], [ -76.058720, 39.370880 ], [ -76.057876, 39.370857 ], [ -76.054157, 39.370759 ], [ -76.049846, 39.370644 ], [ -76.032923, 39.367414 ], [ -76.031767, 39.366772 ], [ -76.030064, 39.365826 ], [ -76.022990, 39.361896 ], [ -76.019091, 39.362958 ], [ -76.006546, 39.366374 ], [ -76.002408, 39.367501 ], [ -76.002463, 39.376440 ], [ -76.002514, 39.384805 ], [ -76.002515, 39.385024 ], [ -76.006805, 39.385174 ], [ -76.022304, 39.385716 ], [ -76.035464, 39.386176 ], [ -76.035568, 39.386180 ], [ -76.035644, 39.386213 ], [ -76.039279, 39.387796 ], [ -76.039932, 39.388080 ], [ -76.039973, 39.388327 ], [ -76.040854, 39.393594 ], [ -76.040962, 39.394237 ], [ -76.040612, 39.394692 ], [ -76.035298, 39.401609 ], [ -76.035002, 39.401994 ], [ -76.034720, 39.402093 ], [ -76.018726, 39.407696 ], [ -76.018061, 39.407929 ], [ -76.016531, 39.408465 ], [ -76.015763, 39.408947 ], [ -76.012567, 39.410955 ], [ -76.009693, 39.412760 ], [ -76.006880, 39.414527 ], [ -76.002856, 39.421225 ], [ -75.998586, 39.428333 ], [ -75.997396, 39.430314 ], [ -75.996697, 39.430549 ], [ -75.992742, 39.431877 ], [ -75.992425, 39.431983 ], [ -75.988840, 39.433187 ], [ -75.982585, 39.435287 ], [ -75.977751, 39.443020 ], [ -75.976747, 39.444627 ], [ -75.976698, 39.445690 ], [ -75.976601, 39.447808 ], [ -75.990005, 39.458646 ], [ -75.990128, 39.458624 ], [ -75.991779, 39.458332 ], [ -75.994432, 39.457862 ], [ -75.998276, 39.457182 ], [ -76.002497, 39.450231 ], [ -76.002513, 39.450204 ], [ -76.002579, 39.450194 ], [ -76.009071, 39.449256 ], [ -76.009452, 39.449201 ], [ -76.009536, 39.449316 ], [ -76.011880, 39.452524 ], [ -76.012312, 39.453115 ], [ -76.011716, 39.454165 ], [ -76.010009, 39.457170 ], [ -76.002926, 39.469642 ], [ -75.996570, 39.476658 ], [ -75.995289, 39.483014 ], [ -75.994135, 39.488743 ], [ -75.993469, 39.490583 ], [ -75.986298, 39.510398 ], [ -75.985403, 39.512108 ], [ -75.985238, 39.512424 ], [ -75.980279, 39.521900 ], [ -75.976105, 39.529876 ], [ -75.976057, 39.529968 ], [ -75.975313, 39.530678 ], [ -75.973678, 39.532237 ], [ -75.966955, 39.538650 ], [ -75.966959, 39.538839 ], [ -75.967093, 39.544623 ], [ -75.967173, 39.548047 ], [ -75.967186, 39.548627 ], [ -75.967221, 39.550140 ], [ -75.970337, 39.557637 ], [ -75.992633, 39.563098 ], [ -75.999669, 39.560488 ], [ -76.000190, 39.559696 ], [ -76.001244, 39.558096 ], [ -76.002793, 39.555741 ], [ -76.003434, 39.554768 ], [ -76.004207, 39.553594 ], [ -76.006213, 39.550546 ], [ -76.006272, 39.550457 ], [ -76.006341, 39.550352 ], [ -76.030420, 39.548784 ], [ -76.046876, 39.547713 ], [ -76.063379, 39.546638 ], [ -76.063811, 39.546610 ], [ -76.075714, 39.543032 ], [ -76.096072, 39.536912 ], [ -76.102955, 39.523639 ], [ -76.105571, 39.518595 ], [ -76.105678, 39.518388 ], [ -76.106215, 39.517353 ], [ -76.107126, 39.515597 ], [ -76.111583, 39.507001 ], [ -76.116831, 39.496882 ], [ -76.117253, 39.496068 ], [ -76.114610, 39.488619 ], [ -76.113929, 39.486701 ], [ -76.108813, 39.482333 ], [ -76.104665, 39.478792 ], [ -76.100218, 39.476918 ], [ -76.099506, 39.476618 ], [ -76.098315, 39.476116 ], [ -76.083286, 39.477860 ], [ -76.083082, 39.477809 ], [ -76.081590, 39.477438 ], [ -76.073119, 39.475331 ], [ -76.072309, 39.475130 ], [ -76.071975, 39.475047 ], [ -76.071836, 39.474760 ], [ -76.069814, 39.470577 ], [ -76.063874, 39.458295 ], [ -76.062259, 39.454955 ], [ -76.060931, 39.452208 ], [ -76.060944, 39.451174 ], [ -76.060988, 39.447775 ], [ -76.060989, 39.447722 ], [ -76.081176, 39.436712 ], [ -76.081409, 39.436891 ], [ -76.083269, 39.438321 ], [ -76.083405, 39.438302 ], [ -76.093595, 39.436871 ], [ -76.102232, 39.435659 ], [ -76.112761, 39.429852 ], [ -76.115096, 39.428565 ], [ -76.116820, 39.427614 ], [ -76.117172, 39.427170 ], [ -76.120991, 39.422358 ], [ -76.121754, 39.421396 ], [ -76.121889, 39.421226 ], [ -76.132114, 39.414579 ], [ -76.142224, 39.408007 ], [ -76.146373, 39.405310 ], [ -76.147048, 39.405364 ], [ -76.150249, 39.405623 ], [ -76.150516, 39.405644 ], [ -76.150934, 39.405678 ], [ -76.151948, 39.405760 ], [ -76.152059, 39.405769 ], [ -76.152357, 39.405793 ], [ -76.157108, 39.406176 ], [ -76.158592, 39.406295 ], [ -76.158774, 39.406310 ], [ -76.159358, 39.405661 ], [ -76.171134, 39.392588 ], [ -76.171474, 39.392210 ], [ -76.171747, 39.391747 ], [ -76.175121, 39.386019 ], [ -76.175597, 39.385210 ], [ -76.175928, 39.384648 ], [ -76.180057, 39.377638 ], [ -76.180074, 39.377609 ], [ -76.199356, 39.366221 ], [ -76.202346, 39.364455 ], [ -76.226976, 39.349908 ], [ -76.227625, 39.350109 ], [ -76.229614, 39.350723 ], [ -76.233776, 39.352008 ], [ -76.234743, 39.353498 ], [ -76.234765, 39.353532 ], [ -76.235795, 39.355119 ], [ -76.236520, 39.356236 ], [ -76.237943, 39.358429 ], [ -76.239877, 39.361408 ], [ -76.241268, 39.361567 ], [ -76.243377, 39.361808 ], [ -76.244443, 39.361731 ], [ -76.244988, 39.361691 ], [ -76.245273, 39.361671 ], [ -76.250107, 39.361320 ], [ -76.250483, 39.361136 ], [ -76.266365, 39.353352 ], [ -76.265277, 39.350008 ], [ -76.263019, 39.348634 ], [ -76.258377, 39.345808 ], [ -76.258342, 39.345737 ], [ -76.253928, 39.336768 ], [ -76.262008, 39.334708 ], [ -76.262471, 39.334590 ], [ -76.263073, 39.334436 ], [ -76.263577, 39.334308 ], [ -76.263624, 39.334265 ], [ -76.265615, 39.332450 ], [ -76.265777, 39.332302 ], [ -76.266094, 39.332013 ], [ -76.266257, 39.331864 ], [ -76.266407, 39.331727 ], [ -76.272671, 39.326015 ], [ -76.276078, 39.322908 ], [ -76.277813, 39.318738 ], [ -76.277866, 39.318610 ], [ -76.278239, 39.317712 ], [ -76.278351, 39.317444 ], [ -76.278499, 39.317088 ], [ -76.280599, 39.312037 ], [ -76.280778, 39.311608 ], [ -76.281088, 39.307930 ], [ -76.281374, 39.304531 ], [ -76.281429, 39.303872 ], [ -76.281556, 39.302369 ], [ -76.281578, 39.302108 ], [ -76.281700, 39.302110 ], [ -76.296546, 39.302383 ], [ -76.297878, 39.302408 ], [ -76.291078, 39.318108 ], [ -76.298778, 39.329208 ], [ -76.298778, 39.333958 ], [ -76.298778, 39.339278 ], [ -76.298778, 39.340208 ], [ -76.297569, 39.342244 ], [ -76.295558, 39.345631 ], [ -76.294978, 39.346608 ], [ -76.295678, 39.350008 ], [ -76.301770, 39.352216 ], [ -76.310618, 39.355423 ], [ -76.310829, 39.355500 ], [ -76.311360, 39.355693 ], [ -76.311679, 39.355808 ], [ -76.312610, 39.355917 ], [ -76.312864, 39.355946 ], [ -76.314356, 39.356120 ], [ -76.322687, 39.357092 ], [ -76.323679, 39.357208 ], [ -76.330027, 39.356139 ], [ -76.341443, 39.354217 ], [ -76.339942, 39.350169 ], [ -76.335412, 39.337949 ], [ -76.334401, 39.335222 ], [ -76.334021, 39.334197 ], [ -76.333924, 39.333935 ], [ -76.338898, 39.325783 ], [ -76.339570, 39.324681 ], [ -76.333820, 39.319611 ], [ -76.327579, 39.314108 ], [ -76.337858, 39.305799 ], [ -76.339817, 39.304216 ], [ -76.341432, 39.302910 ], [ -76.353205, 39.310650 ], [ -76.354817, 39.311709 ], [ -76.355495, 39.312155 ], [ -76.364390, 39.311840 ], [ -76.365532, 39.310950 ], [ -76.380662, 39.299161 ], [ -76.380734, 39.298765 ], [ -76.383021, 39.286231 ], [ -76.383345, 39.284455 ], [ -76.383891, 39.281465 ], [ -76.384901, 39.275928 ], [ -76.385151, 39.275766 ], [ -76.395136, 39.269293 ], [ -76.395301, 39.269042 ], [ -76.400094, 39.261753 ], [ -76.400187, 39.261612 ], [ -76.401103, 39.260219 ], [ -76.402047, 39.258783 ], [ -76.402355, 39.258315 ], [ -76.401911, 39.258053 ], [ -76.386937, 39.249216 ], [ -76.381380, 39.249508 ], [ -76.382358, 39.247292 ], [ -76.384380, 39.242708 ], [ -76.384699, 39.242242 ], [ -76.389380, 39.235408 ], [ -76.389563, 39.235261 ], [ -76.393626, 39.232012 ], [ -76.394381, 39.231408 ], [ -76.398314, 39.229450 ], [ -76.399122, 39.229048 ], [ -76.417620, 39.219838 ], [ -76.417681, 39.219808 ], [ -76.418290, 39.218677 ], [ -76.419201, 39.216988 ], [ -76.425281, 39.205708 ], [ -76.425413, 39.205629 ], [ -76.441411, 39.196049 ], [ -76.442482, 39.195408 ], [ -76.447621, 39.197977 ], [ -76.461560, 39.204947 ], [ -76.462679, 39.205506 ], [ -76.463483, 39.205908 ], [ -76.471126, 39.205540 ], [ -76.480083, 39.205108 ], [ -76.482153, 39.204426 ], [ -76.485527, 39.203314 ], [ -76.486371, 39.203036 ], [ -76.488883, 39.202208 ], [ -76.489505, 39.202378 ], [ -76.489777, 39.202453 ], [ -76.490770, 39.202724 ], [ -76.497977, 39.204697 ], [ -76.498384, 39.204808 ], [ -76.500086, 39.207798 ], [ -76.500834, 39.209113 ], [ -76.500984, 39.209376 ], [ -76.519804, 39.222946 ], [ -76.520584, 39.223508 ], [ -76.520941, 39.223240 ], [ -76.528587, 39.217492 ], [ -76.529649, 39.216693 ], [ -76.534285, 39.213208 ], [ -76.534960, 39.212280 ], [ -76.535885, 39.211008 ], [ -76.533103, 39.207630 ], [ -76.533085, 39.207608 ], [ -76.533349, 39.207172 ], [ -76.534760, 39.204841 ], [ -76.535385, 39.203808 ], [ -76.534185, 39.190608 ], [ -76.525785, 39.177908 ], [ -76.525454, 39.177746 ], [ -76.525031, 39.177540 ], [ -76.524221, 39.177144 ], [ -76.520270, 39.175214 ], [ -76.519292, 39.174736 ], [ -76.511834, 39.171093 ], [ -76.508384, 39.169408 ], [ -76.500926, 39.161286 ], [ -76.500512, 39.161362 ], [ -76.484023, 39.164407 ], [ -76.483845, 39.164334 ], [ -76.475983, 39.161109 ], [ -76.474807, 39.159436 ], [ -76.473802, 39.158007 ], [ -76.471483, 39.154709 ], [ -76.468898, 39.153161 ], [ -76.459119, 39.147304 ], [ -76.458873, 39.147157 ], [ -76.458649, 39.147023 ], [ -76.458350, 39.146844 ], [ -76.458192, 39.146749 ], [ -76.452782, 39.143509 ], [ -76.440110, 39.137305 ], [ -76.430946, 39.132818 ], [ -76.430130, 39.132419 ], [ -76.428681, 39.131709 ], [ -76.432481, 39.126709 ], [ -76.432702, 39.120752 ], [ -76.432981, 39.113209 ], [ -76.432942, 39.113098 ], [ -76.427196, 39.096685 ], [ -76.427065, 39.096309 ], [ -76.426456, 39.094571 ], [ -76.426283, 39.094076 ], [ -76.426276, 39.094057 ], [ -76.423609, 39.086438 ], [ -76.423321, 39.085615 ], [ -76.423271, 39.085473 ], [ -76.422714, 39.083881 ], [ -76.422212, 39.082448 ], [ -76.422080, 39.082070 ], [ -76.421860, 39.081442 ], [ -76.423081, 39.074210 ], [ -76.432374, 39.061648 ], [ -76.438845, 39.052900 ] ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US34", "STATE": 31, "name": "New Jersey", "LSAD": "", "CENSUSAREA": 7354.220000 }, "geometry": { "type": "Polygon", "coordinates": [ [ [ -74.900236, 40.077149 ], [ -74.838008, 40.100910 ], [ -74.740605, 40.135210 ], [ -74.724304, 40.147010 ], [ -74.724179, 40.147324 ], [ -74.721604, 40.153810 ], [ -74.722304, 40.160609 ], [ -74.758613, 40.201342 ], [ -74.770706, 40.214908 ], [ -74.860492, 40.284584 ], [ -74.937954, 40.340634 ], [ -75.024775, 40.403455 ], [ -75.035548, 40.406309 ], [ -75.058848, 40.418065 ], [ -75.061489, 40.422848 ], [ -75.070568, 40.455165 ], [ -75.065853, 40.519495 ], [ -75.065090, 40.526148 ], [ -75.067344, 40.536428 ], [ -75.068615, 40.542223 ], [ -75.100325, 40.567811 ], [ -75.117292, 40.573211 ], [ -75.135389, 40.575624 ], [ -75.147368, 40.573152 ], [ -75.190161, 40.589321 ], [ -75.190858, 40.591342 ], [ -75.196803, 40.608580 ], [ -75.200708, 40.618356 ], [ -75.203920, 40.691498 ], [ -75.196533, 40.751631 ], [ -75.171587, 40.777745 ], [ -75.163650, 40.778386 ], [ -75.149378, 40.774786 ], [ -75.134400, 40.773765 ], [ -75.108505, 40.791094 ], [ -75.053294, 40.859900 ], [ -75.051029, 40.865662 ], [ -75.052538, 40.872051 ], [ -75.117764, 40.953023 ], [ -75.119893, 40.961646 ], [ -75.120316, 40.962630 ], [ -75.120435, 40.968302 ], [ -75.120564, 40.968313 ], [ -75.131364, 40.969277 ], [ -75.135526, 40.973807 ], [ -75.130575, 40.991093 ], [ -75.109114, 41.004102 ], [ -75.091377, 41.012283 ], [ -75.069277, 41.019348 ], [ -75.051794, 41.027142 ], [ -75.036982, 41.034702 ], [ -75.026003, 41.042687 ], [ -74.980674, 41.078178 ], [ -74.968389, 41.087797 ], [ -74.966759, 41.093425 ], [ -74.967389, 41.094049 ], [ -74.969434, 41.096074 ], [ -74.974338, 41.103912 ], [ -74.923169, 41.138146 ], [ -74.882139, 41.180836 ], [ -74.867287, 41.208754 ], [ -74.864356, 41.224854 ], [ -74.867267, 41.228861 ], [ -74.861678, 41.241575 ], [ -74.838366, 41.277286 ], [ -74.830057, 41.287200 ], [ -74.795847, 41.318951 ], [ -74.761730, 41.336398 ], [ -74.694914, 41.357423 ], [ -74.457584, 41.248225 ], [ -74.392098, 41.215594 ], [ -74.365664, 41.203400 ], [ -74.234473, 41.142883 ], [ -74.213373, 41.133828 ], [ -74.096786, 41.083796 ], [ -74.092486, 41.081896 ], [ -74.041054, 41.059088 ], [ -74.041049, 41.059086 ], [ -73.911880, 41.001297 ], [ -73.902680, 40.997297 ], [ -73.893979, 40.997197 ], [ -73.917905, 40.917577 ], [ -73.919705, 40.913478 ], [ -73.927470, 40.895682 ], [ -73.933406, 40.882078 ], [ -73.933408, 40.882075 ], [ -73.938081, 40.874699 ], [ -73.948281, 40.858399 ], [ -73.986864, 40.798344 ], [ -73.993029, 40.788746 ], [ -74.000905, 40.776488 ], [ -74.009184, 40.763601 ], [ -74.013784, 40.756601 ], [ -74.024543, 40.709436 ], [ -74.038538, 40.710741 ], [ -74.051185, 40.695802 ], [ -74.069885, 40.684502 ], [ -74.082786, 40.673702 ], [ -74.089986, 40.659903 ], [ -74.087397, 40.653607 ], [ -74.094086, 40.649703 ], [ -74.143387, 40.641903 ], [ -74.161397, 40.644092 ], [ -74.181083, 40.646484 ], [ -74.186027, 40.646076 ], [ -74.189106, 40.643832 ], [ -74.202223, 40.631053 ], [ -74.206731, 40.594569 ], [ -74.208988, 40.576304 ], [ -74.214788, 40.560604 ], [ -74.218189, 40.557204 ], [ -74.231589, 40.559204 ], [ -74.248641, 40.549601 ], [ -74.251441, 40.542301 ], [ -74.246237, 40.520963 ], [ -74.268290, 40.499205 ], [ -74.269998, 40.495014 ], [ -74.272690, 40.488405 ], [ -74.267590, 40.471806 ], [ -74.261889, 40.464706 ], [ -74.236689, 40.457806 ], [ -74.225035, 40.453301 ], [ -74.224047, 40.452919 ], [ -74.222959, 40.452499 ], [ -74.209788, 40.447407 ], [ -74.206188, 40.440707 ], [ -74.206419, 40.438789 ], [ -74.208655, 40.437520 ], [ -74.207205, 40.435434 ], [ -74.202128, 40.438940 ], [ -74.193908, 40.440995 ], [ -74.191309, 40.442990 ], [ -74.187787, 40.447407 ], [ -74.174787, 40.455607 ], [ -74.174893, 40.454491 ], [ -74.175074, 40.449144 ], [ -74.176842, 40.447740 ], [ -74.175346, 40.446607 ], [ -74.169977, 40.450640 ], [ -74.167009, 40.448737 ], [ -74.166193, 40.447128 ], [ -74.164029, 40.448312 ], [ -74.163314, 40.448424 ], [ -74.157787, 40.446607 ], [ -74.153611, 40.447647 ], [ -74.152686, 40.447344 ], [ -74.151952, 40.448062 ], [ -74.142886, 40.450407 ], [ -74.139886, 40.453407 ], [ -74.138415, 40.454468 ], [ -74.135823, 40.455196 ], [ -74.133727, 40.454672 ], [ -74.131135, 40.453245 ], [ -74.127466, 40.451061 ], [ -74.124692, 40.449580 ], [ -74.122327, 40.448258 ], [ -74.116863, 40.446069 ], [ -74.088085, 40.438407 ], [ -74.076185, 40.433707 ], [ -74.058984, 40.422708 ], [ -74.047884, 40.418908 ], [ -74.006383, 40.411108 ], [ -73.998505, 40.410911 ], [ -73.995486, 40.419472 ], [ -73.991682, 40.442908 ], [ -74.006077, 40.464625 ], [ -74.017783, 40.472207 ], [ -74.017917, 40.474338 ], [ -74.014031, 40.476471 ], [ -74.007100, 40.475298 ], [ -73.995683, 40.468707 ], [ -73.978282, 40.440208 ], [ -73.976982, 40.408508 ], [ -73.971381, 40.371709 ], [ -73.971381, 40.348010 ], [ -73.977442, 40.299373 ], [ -73.981681, 40.279411 ], [ -73.993292, 40.237669 ], [ -74.016017, 40.166914 ], [ -74.030181, 40.122814 ], [ -74.034080, 40.103115 ], [ -74.031861, 40.101047 ], [ -74.031318, 40.100541 ], [ -74.033546, 40.099518 ], [ -74.039421, 40.081437 ], [ -74.058798, 40.001244 ], [ -74.064135, 39.979157 ], [ -74.077247, 39.910991 ], [ -74.090945, 39.799978 ], [ -74.097071, 39.767847 ], [ -74.096906, 39.763030 ], [ -74.098920, 39.759538 ], [ -74.101443, 39.756173 ], [ -74.113655, 39.740719 ], [ -74.141733, 39.689435 ], [ -74.190974, 39.625118 ], [ -74.240506, 39.554911 ], [ -74.249043, 39.547994 ], [ -74.277370, 39.514064 ], [ -74.291585, 39.507705 ], [ -74.311037, 39.506715 ], [ -74.312451, 39.499869 ], [ -74.313689, 39.493874 ], [ -74.308344, 39.483945 ], [ -74.304778, 39.482945 ], [ -74.302184, 39.478935 ], [ -74.304343, 39.471445 ], [ -74.334804, 39.432001 ], [ -74.366990, 39.402017 ], [ -74.406692, 39.377516 ], [ -74.406792, 39.373916 ], [ -74.408237, 39.365071 ], [ -74.412692, 39.360816 ], [ -74.459894, 39.345016 ], [ -74.521797, 39.313816 ], [ -74.541443, 39.300245 ], [ -74.551151, 39.293539 ], [ -74.553439, 39.286915 ], [ -74.560957, 39.278677 ], [ -74.581008, 39.270819 ], [ -74.597921, 39.258851 ], [ -74.614481, 39.244659 ], [ -74.636306, 39.220834 ], [ -74.646595, 39.212002 ], [ -74.651443, 39.198578 ], [ -74.671430, 39.179802 ], [ -74.714341, 39.119804 ], [ -74.715320, 39.116893 ], [ -74.714135, 39.114631 ], [ -74.704409, 39.107858 ], [ -74.705876, 39.102937 ], [ -74.738316, 39.074727 ], [ -74.778777, 39.023073 ], [ -74.786356, 39.000113 ], [ -74.792723, 38.991991 ], [ -74.807917, 38.985948 ], [ -74.819354, 38.979402 ], [ -74.850748, 38.954538 ], [ -74.864458, 38.940410 ], [ -74.865198, 38.941439 ], [ -74.870497, 38.943543 ], [ -74.882309, 38.941759 ], [ -74.907050, 38.931994 ], [ -74.920414, 38.929136 ], [ -74.933571, 38.928519 ], [ -74.963463, 38.931194 ], [ -74.967274, 38.933413 ], [ -74.971995, 38.940370 ], [ -74.955363, 39.001262 ], [ -74.949470, 39.015637 ], [ -74.938320, 39.035185 ], [ -74.903664, 39.087437 ], [ -74.897784, 39.098811 ], [ -74.892547, 39.113183 ], [ -74.885914, 39.143627 ], [ -74.887167, 39.158825 ], [ -74.905181, 39.174945 ], [ -74.914936, 39.177553 ], [ -74.962382, 39.190238 ], [ -74.976266, 39.192271 ], [ -74.998002, 39.191253 ], [ -75.026179, 39.193621 ], [ -75.028885, 39.194560 ], [ -75.027824, 39.199482 ], [ -75.023586, 39.202594 ], [ -75.023437, 39.204791 ], [ -75.026376, 39.209850 ], [ -75.035672, 39.215415 ], [ -75.041663, 39.215511 ], [ -75.047797, 39.211702 ], [ -75.052326, 39.213609 ], [ -75.062506, 39.213564 ], [ -75.086395, 39.208159 ], [ -75.101019, 39.211657 ], [ -75.107286, 39.211403 ], [ -75.114748, 39.207554 ], [ -75.127070, 39.189766 ], [ -75.136548, 39.179425 ], [ -75.139136, 39.180021 ], [ -75.165979, 39.201842 ], [ -75.164798, 39.216606 ], [ -75.170444, 39.234643 ], [ -75.177506, 39.242746 ], [ -75.205857, 39.262619 ], [ -75.212510, 39.262755 ], [ -75.241639, 39.274097 ], [ -75.244056, 39.277690 ], [ -75.242881, 39.280574 ], [ -75.244357, 39.285700 ], [ -75.251806, 39.299913 ], [ -75.271629, 39.304041 ], [ -75.282620, 39.299055 ], [ -75.285333, 39.292212 ], [ -75.288898, 39.289557 ], [ -75.306010, 39.301712 ], [ -75.315201, 39.310593 ], [ -75.326754, 39.332473 ], [ -75.327463, 39.339270 ], [ -75.333743, 39.345335 ], [ -75.341969, 39.348697 ], [ -75.355558, 39.347823 ], [ -75.365016, 39.341388 ], [ -75.390030, 39.358259 ], [ -75.394331, 39.363753 ], [ -75.395181, 39.371398 ], [ -75.399304, 39.379490 ], [ -75.407294, 39.381954 ], [ -75.422099, 39.386521 ], [ -75.431803, 39.391625 ], [ -75.442393, 39.402291 ], [ -75.465212, 39.438930 ], [ -75.476279, 39.438126 ], [ -75.483572, 39.440824 ], [ -75.505672, 39.452927 ], [ -75.508383, 39.459131 ], [ -75.536431, 39.460559 ], [ -75.542894, 39.470447 ], [ -75.544368, 39.479602 ], [ -75.542693, 39.496568 ], [ -75.528088, 39.498114 ], [ -75.527141, 39.500112 ], [ -75.514756, 39.562612 ], [ -75.511932, 39.567616 ], [ -75.512732, 39.578000 ], [ -75.525677, 39.584048 ], [ -75.531133, 39.587984 ], [ -75.534477, 39.590384 ], [ -75.537213, 39.592944 ], [ -75.539540, 39.594251 ], [ -75.539949, 39.594384 ], [ -75.543965, 39.596000 ], [ -75.545405, 39.596784 ], [ -75.555870, 39.605824 ], [ -75.559446, 39.629812 ], [ -75.526844, 39.655713 ], [ -75.526344, 39.656413 ], [ -75.509342, 39.685313 ], [ -75.509742, 39.686113 ], [ -75.504042, 39.698313 ], [ -75.475384, 39.731057 ], [ -75.474168, 39.735473 ], [ -75.469239, 39.743613 ], [ -75.466263, 39.750737 ], [ -75.466249, 39.750769 ], [ -75.448135, 39.773969 ], [ -75.440623, 39.780926 ], [ -75.437938, 39.783413 ], [ -75.416095, 39.795830 ], [ -75.415041, 39.801786 ], [ -75.390169, 39.816549 ], [ -75.374635, 39.825770 ], [ -75.306500, 39.849812 ], [ -75.271159, 39.849440 ], [ -75.235026, 39.856613 ], [ -75.210972, 39.865706 ], [ -75.210425, 39.865913 ], [ -75.184952, 39.881615 ], [ -75.153925, 39.906144 ], [ -75.133220, 39.922512 ], [ -75.085754, 39.967572 ], [ -75.072017, 39.980612 ], [ -75.056039, 39.991795 ], [ -75.014343, 40.020976 ], [ -74.974713, 40.048711 ], [ -74.974290, 40.048872 ], [ -74.900236, 40.077149 ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US37", "STATE": 32, "name": "North Carolina", "LSAD": "", "CENSUSAREA": 48617.905000 }, "geometry": { "type": "MultiPolygon", "coordinates": [ [ [ [ -75.753765, 35.199612 ], [ -75.745220, 35.203030 ], [ -75.734171, 35.204347 ], [ -75.718015, 35.209377 ], [ -75.708947, 35.213912 ], [ -75.698972, 35.221166 ], [ -75.694437, 35.222980 ], [ -75.687490, 35.231171 ], [ -75.684006, 35.232913 ], [ -75.681916, 35.232913 ], [ -75.675394, 35.228421 ], [ -75.664512, 35.227514 ], [ -75.640934, 35.233862 ], [ -75.630358, 35.238487 ], [ -75.615378, 35.248938 ], [ -75.599005, 35.256253 ], [ -75.598312, 35.261067 ], [ -75.597960, 35.266704 ], [ -75.596915, 35.269491 ], [ -75.585419, 35.266356 ], [ -75.581935, 35.263917 ], [ -75.561033, 35.266008 ], [ -75.535741, 35.272856 ], [ -75.529393, 35.288272 ], [ -75.523952, 35.318198 ], [ -75.518511, 35.336335 ], [ -75.512610, 35.362853 ], [ -75.506722, 35.387118 ], [ -75.500374, 35.424298 ], [ -75.494933, 35.454224 ], [ -75.487678, 35.485056 ], [ -75.488585, 35.497752 ], [ -75.489618, 35.508471 ], [ -75.487528, 35.525889 ], [ -75.482237, 35.538560 ], [ -75.478610, 35.553069 ], [ -75.478610, 35.599318 ], [ -75.481330, 35.622896 ], [ -75.487678, 35.648287 ], [ -75.498675, 35.666281 ], [ -75.507385, 35.680564 ], [ -75.515745, 35.721671 ], [ -75.515397, 35.730380 ], [ -75.533512, 35.773577 ], [ -75.528992, 35.776289 ], [ -75.522232, 35.774178 ], [ -75.502427, 35.742913 ], [ -75.496086, 35.728515 ], [ -75.479128, 35.678634 ], [ -75.458659, 35.596597 ], [ -75.460061, 35.581314 ], [ -75.462491, 35.553556 ], [ -75.471355, 35.479615 ], [ -75.486771, 35.391652 ], [ -75.502188, 35.320012 ], [ -75.525920, 35.233839 ], [ -75.533627, 35.225825 ], [ -75.544809, 35.228421 ], [ -75.560225, 35.232048 ], [ -75.580176, 35.231142 ], [ -75.610101, 35.227514 ], [ -75.635493, 35.220260 ], [ -75.672673, 35.208471 ], [ -75.728897, 35.190334 ], [ -75.749406, 35.185207 ], [ -75.757916, 35.183079 ], [ -75.769705, 35.180359 ], [ -75.789655, 35.172197 ], [ -75.840438, 35.151340 ], [ -75.912985, 35.119600 ], [ -75.944725, 35.105091 ], [ -75.963768, 35.092395 ], [ -75.982812, 35.081513 ], [ -76.001510, 35.067230 ], [ -76.013145, 35.061855 ], [ -76.014954, 35.065349 ], [ -76.013561, 35.068832 ], [ -76.000949, 35.084234 ], [ -75.991880, 35.092395 ], [ -75.989175, 35.100882 ], [ -75.990569, 35.108546 ], [ -75.989175, 35.115165 ], [ -75.983950, 35.120042 ], [ -75.973499, 35.121087 ], [ -75.966489, 35.117787 ], [ -75.954700, 35.119600 ], [ -75.923867, 35.135017 ], [ -75.910265, 35.142271 ], [ -75.893942, 35.150433 ], [ -75.839531, 35.172197 ], [ -75.819172, 35.176826 ], [ -75.812902, 35.178568 ], [ -75.801444, 35.183079 ], [ -75.793283, 35.188520 ], [ -75.785729, 35.194244 ], [ -75.754289, 35.199402 ], [ -75.753765, 35.199612 ] ] ], [ [ [ -75.675245, 35.929024 ], [ -75.659540, 35.919564 ], [ -75.662938, 35.916166 ], [ -75.662019, 35.906522 ], [ -75.653478, 35.904686 ], [ -75.648519, 35.906982 ], [ -75.645120, 35.905788 ], [ -75.627670, 35.883149 ], [ -75.616833, 35.856331 ], [ -75.619772, 35.847606 ], [ -75.614361, 35.815659 ], [ -75.620454, 35.809253 ], [ -75.624235, 35.809387 ], [ -75.638980, 35.818639 ], [ -75.667891, 35.823540 ], [ -75.675054, 35.830204 ], [ -75.660086, 35.838610 ], [ -75.660598, 35.862541 ], [ -75.663356, 35.869835 ], [ -75.672830, 35.882423 ], [ -75.681415, 35.883980 ], [ -75.697672, 35.901639 ], [ -75.696871, 35.909556 ], [ -75.702165, 35.915428 ], [ -75.723782, 35.925569 ], [ -75.727251, 35.933620 ], [ -75.726807, 35.935844 ], [ -75.718266, 35.939714 ], [ -75.705323, 35.939403 ], [ -75.691150, 35.936932 ], [ -75.686358, 35.932973 ], [ -75.675245, 35.929024 ] ] ], [ [ [ -76.491497, 36.550365 ], [ -76.313215, 36.550551 ], [ -76.313196, 36.550551 ], [ -76.122360, 36.550621 ], [ -76.034751, 36.550653 ], [ -76.026750, 36.550553 ], [ -75.957648, 36.550553 ], [ -75.955748, 36.550553 ], [ -75.953447, 36.550553 ], [ -75.952847, 36.550553 ], [ -75.922046, 36.550654 ], [ -75.911446, 36.550654 ], [ -75.909046, 36.550654 ], [ -75.904745, 36.550654 ], [ -75.903445, 36.550654 ], [ -75.894145, 36.550754 ], [ -75.893245, 36.550654 ], [ -75.891945, 36.550754 ], [ -75.886545, 36.550754 ], [ -75.885945, 36.550754 ], [ -75.880644, 36.550754 ], [ -75.879744, 36.550754 ], [ -75.867044, 36.550754 ], [ -75.856901, 36.500155 ], [ -75.834975, 36.422650 ], [ -75.818735, 36.357579 ], [ -75.796410, 36.290351 ], [ -75.773329, 36.231529 ], [ -75.772510, 36.229440 ], [ -75.759637, 36.204705 ], [ -75.738431, 36.154282 ], [ -75.718310, 36.113674 ], [ -75.696742, 36.077497 ], [ -75.658537, 36.020430 ], [ -75.569794, 35.863301 ], [ -75.552299, 35.822173 ], [ -75.538739, 35.797396 ], [ -75.533012, 35.787377 ], [ -75.536428, 35.780118 ], [ -75.543259, 35.779691 ], [ -75.546675, 35.787377 ], [ -75.553934, 35.799332 ], [ -75.566238, 35.813072 ], [ -75.573083, 35.828867 ], [ -75.588878, 35.844926 ], [ -75.601250, 35.867302 ], [ -75.619151, 35.889415 ], [ -75.617045, 35.906000 ], [ -75.617552, 35.914186 ], [ -75.620114, 35.925288 ], [ -75.631215, 35.941512 ], [ -75.648899, 35.965758 ], [ -75.668379, 35.978394 ], [ -75.671801, 35.985238 ], [ -75.678909, 35.993925 ], [ -75.723662, 36.003139 ], [ -75.727084, 36.010510 ], [ -75.726558, 36.021040 ], [ -75.722082, 36.032360 ], [ -75.722609, 36.037362 ], [ -75.726821, 36.040521 ], [ -75.737088, 36.040784 ], [ -75.740510, 36.046839 ], [ -75.741563, 36.055526 ], [ -75.739457, 36.066846 ], [ -75.739720, 36.075270 ], [ -75.750250, 36.121076 ], [ -75.750479, 36.131208 ], [ -75.752226, 36.140817 ], [ -75.755720, 36.153922 ], [ -75.775814, 36.201097 ], [ -75.783676, 36.215949 ], [ -75.793286, 36.226432 ], [ -75.794371, 36.227336 ], [ -75.798528, 36.230800 ], [ -75.803690, 36.235853 ], [ -75.811588, 36.244014 ], [ -75.811851, 36.247699 ], [ -75.808165, 36.259545 ], [ -75.814483, 36.285344 ], [ -75.822907, 36.291662 ], [ -75.833964, 36.292188 ], [ -75.837913, 36.294558 ], [ -75.845284, 36.305614 ], [ -75.841335, 36.328517 ], [ -75.831858, 36.339047 ], [ -75.831595, 36.346418 ], [ -75.836201, 36.363135 ], [ -75.843046, 36.371032 ], [ -75.847258, 36.372085 ], [ -75.851470, 36.379456 ], [ -75.852523, 36.384721 ], [ -75.851470, 36.415785 ], [ -75.864106, 36.430527 ], [ -75.880428, 36.435792 ], [ -75.888325, 36.441583 ], [ -75.891484, 36.460537 ], [ -75.899908, 36.482124 ], [ -75.907279, 36.485809 ], [ -75.913071, 36.486336 ], [ -75.917283, 36.485809 ], [ -75.924127, 36.482124 ], [ -75.927333, 36.482815 ], [ -75.935473, 36.490601 ], [ -75.960069, 36.495025 ], [ -75.972545, 36.494671 ], [ -76.003708, 36.506235 ], [ -76.019261, 36.503506 ], [ -76.023627, 36.500778 ], [ -76.029221, 36.494365 ], [ -76.031949, 36.482496 ], [ -76.020216, 36.458620 ], [ -76.012337, 36.447462 ], [ -76.003912, 36.441864 ], [ -75.989869, 36.436808 ], [ -75.980050, 36.435464 ], [ -75.962285, 36.417240 ], [ -75.940676, 36.418850 ], [ -75.936446, 36.423079 ], [ -75.932694, 36.427627 ], [ -75.928369, 36.428588 ], [ -75.923601, 36.425788 ], [ -75.916409, 36.389010 ], [ -75.916949, 36.383167 ], [ -75.923511, 36.367796 ], [ -75.923331, 36.361863 ], [ -75.917758, 36.353593 ], [ -75.915331, 36.352335 ], [ -75.895285, 36.319615 ], [ -75.888211, 36.293414 ], [ -75.882154, 36.284674 ], [ -75.872721, 36.282770 ], [ -75.864933, 36.284674 ], [ -75.860520, 36.280607 ], [ -75.861818, 36.266415 ], [ -75.867356, 36.252483 ], [ -75.864154, 36.235522 ], [ -75.858703, 36.222628 ], [ -75.848838, 36.216570 ], [ -75.838367, 36.200129 ], [ -75.841222, 36.193812 ], [ -75.839924, 36.177110 ], [ -75.823915, 36.158332 ], [ -75.822531, 36.145957 ], [ -75.813444, 36.136871 ], [ -75.800378, 36.112728 ], [ -75.791637, 36.082267 ], [ -75.793974, 36.071710 ], [ -75.799779, 36.072640 ], [ -75.836084, 36.092616 ], [ -75.847785, 36.101990 ], [ -75.867792, 36.127262 ], [ -75.866323, 36.141410 ], [ -75.867385, 36.151182 ], [ -75.869828, 36.154580 ], [ -75.875033, 36.157448 ], [ -75.887415, 36.160233 ], [ -75.904999, 36.164188 ], [ -75.920028, 36.164853 ], [ -75.924654, 36.163591 ], [ -75.939047, 36.165518 ], [ -75.995191, 36.178072 ], [ -76.016984, 36.186367 ], [ -76.018936, 36.188318 ], [ -76.031784, 36.189131 ], [ -76.047100, 36.183106 ], [ -76.051626, 36.181325 ], [ -76.063498, 36.173518 ], [ -76.065287, 36.170591 ], [ -76.065450, 36.165224 ], [ -76.059920, 36.155140 ], [ -76.059270, 36.149285 ], [ -76.064224, 36.143775 ], [ -76.071672, 36.140183 ], [ -76.092555, 36.135794 ], [ -76.178946, 36.123424 ], [ -76.184133, 36.121562 ], [ -76.190510, 36.116333 ], [ -76.190784, 36.116108 ], [ -76.192380, 36.113448 ], [ -76.191715, 36.107197 ], [ -76.216599, 36.095409 ], [ -76.238712, 36.098568 ], [ -76.265037, 36.104886 ], [ -76.287150, 36.104886 ], [ -76.298733, 36.101200 ], [ -76.303998, 36.092776 ], [ -76.323478, 36.084879 ], [ -76.331902, 36.083826 ], [ -76.337168, 36.086458 ], [ -76.355069, 36.086458 ], [ -76.410878, 36.078034 ], [ -76.411844, 36.075376 ], [ -76.412984, 36.072243 ], [ -76.420881, 36.060660 ], [ -76.442994, 36.042758 ], [ -76.451418, 36.039073 ], [ -76.458789, 36.028016 ], [ -76.459316, 36.024331 ], [ -76.491959, 36.018013 ], [ -76.514335, 36.005640 ], [ -76.547505, 36.009852 ], [ -76.563300, 36.009852 ], [ -76.575936, 36.006167 ], [ -76.580674, 36.007220 ], [ -76.589625, 36.015644 ], [ -76.603840, 36.033018 ], [ -76.615423, 36.037757 ], [ -76.631745, 36.038283 ], [ -76.653332, 36.035124 ], [ -76.668814, 36.020968 ], [ -76.671759, 36.018276 ], [ -76.684922, 36.009852 ], [ -76.683869, 36.000375 ], [ -76.679657, 35.991951 ], [ -76.684922, 35.983001 ], [ -76.695452, 35.973524 ], [ -76.700190, 35.964573 ], [ -76.697558, 35.951937 ], [ -76.692376, 35.945342 ], [ -76.691766, 35.944566 ], [ -76.673865, 35.935089 ], [ -76.667547, 35.933509 ], [ -76.657017, 35.935089 ], [ -76.608052, 35.936668 ], [ -76.603840, 35.939827 ], [ -76.586992, 35.941933 ], [ -76.528551, 35.944039 ], [ -76.507491, 35.949831 ], [ -76.496961, 35.955096 ], [ -76.473795, 35.960888 ], [ -76.460632, 35.970365 ], [ -76.398242, 35.984317 ], [ -76.389818, 35.980105 ], [ -76.381920, 35.971681 ], [ -76.381394, 35.962730 ], [ -76.365210, 35.944697 ], [ -76.362966, 35.942197 ], [ -76.340327, 35.943250 ], [ -76.317687, 35.946935 ], [ -76.272408, 35.972734 ], [ -76.213966, 35.988002 ], [ -76.176585, 35.993267 ], [ -76.093697, 35.993001 ], [ -76.083131, 35.989845 ], [ -76.062071, 35.993004 ], [ -76.024162, 35.970891 ], [ -76.014685, 35.960361 ], [ -76.014159, 35.957202 ], [ -76.019950, 35.934036 ], [ -76.011526, 35.914029 ], [ -76.004682, 35.905078 ], [ -75.999386, 35.903521 ], [ -75.977830, 35.897181 ], [ -75.966247, 35.899287 ], [ -75.962562, 35.901393 ], [ -75.947820, 35.920347 ], [ -75.934131, 35.928244 ], [ -75.929919, 35.928771 ], [ -75.927286, 35.931930 ], [ -75.926760, 35.940354 ], [ -75.937816, 35.950884 ], [ -75.943608, 35.952464 ], [ -75.946767, 35.955623 ], [ -75.947293, 35.959835 ], [ -75.938343, 35.965100 ], [ -75.899382, 35.977209 ], [ -75.879374, 35.978789 ], [ -75.860420, 35.978262 ], [ -75.849890, 35.976156 ], [ -75.809350, 35.959308 ], [ -75.805138, 35.954043 ], [ -75.800926, 35.944566 ], [ -75.782498, 35.935615 ], [ -75.782498, 35.928244 ], [ -75.778813, 35.918241 ], [ -75.768809, 35.901393 ], [ -75.751961, 35.878227 ], [ -75.753014, 35.871382 ], [ -75.748276, 35.852428 ], [ -75.734587, 35.839266 ], [ -75.727216, 35.822703 ], [ -75.726689, 35.811361 ], [ -75.732612, 35.790666 ], [ -75.738233, 35.778301 ], [ -75.739357, 35.770994 ], [ -75.735422, 35.767622 ], [ -75.724743, 35.742892 ], [ -75.719123, 35.714227 ], [ -75.715188, 35.708045 ], [ -75.712940, 35.698490 ], [ -75.713502, 35.693993 ], [ -75.741605, 35.672073 ], [ -75.742167, 35.655212 ], [ -75.737109, 35.638350 ], [ -75.729802, 35.628795 ], [ -75.729802, 35.625985 ], [ -75.747225, 35.610248 ], [ -75.762963, 35.603503 ], [ -75.778138, 35.592262 ], [ -75.775328, 35.579335 ], [ -75.797248, 35.574276 ], [ -75.837154, 35.570904 ], [ -75.851767, 35.578773 ], [ -75.859636, 35.586641 ], [ -75.869869, 35.582743 ], [ -75.895045, 35.573152 ], [ -75.906848, 35.559101 ], [ -75.908534, 35.555166 ], [ -75.908534, 35.546174 ], [ -75.916403, 35.538305 ], [ -75.945630, 35.534370 ], [ -75.950126, 35.530998 ], [ -75.954623, 35.526502 ], [ -75.964178, 35.511326 ], [ -75.964740, 35.504582 ], [ -75.961929, 35.496713 ], [ -75.963053, 35.493903 ], [ -75.987222, 35.484348 ], [ -75.995652, 35.475355 ], [ -75.994528, 35.463552 ], [ -75.997901, 35.453435 ], [ -76.009704, 35.442194 ], [ -76.012514, 35.432639 ], [ -76.011390, 35.423084 ], [ -76.014762, 35.416902 ], [ -76.020945, 35.410719 ], [ -76.025441, 35.408471 ], [ -76.037244, 35.414091 ], [ -76.050171, 35.415778 ], [ -76.059726, 35.410157 ], [ -76.063661, 35.405099 ], [ -76.063661, 35.398354 ], [ -76.060850, 35.392733 ], [ -76.059726, 35.383741 ], [ -76.069281, 35.370813 ], [ -76.092887, 35.361259 ], [ -76.123238, 35.351142 ], [ -76.132793, 35.349455 ], [ -76.142910, 35.338776 ], [ -76.142910, 35.328660 ], [ -76.149655, 35.326411 ], [ -76.165392, 35.328659 ], [ -76.168764, 35.332032 ], [ -76.182254, 35.336528 ], [ -76.205860, 35.336528 ], [ -76.235087, 35.350017 ], [ -76.253072, 35.350017 ], [ -76.257569, 35.344397 ], [ -76.265437, 35.343273 ], [ -76.282299, 35.345521 ], [ -76.304781, 35.355638 ], [ -76.327263, 35.356762 ], [ -76.335132, 35.355638 ], [ -76.340752, 35.346645 ], [ -76.349745, 35.345521 ], [ -76.365483, 35.348893 ], [ -76.374475, 35.355638 ], [ -76.382344, 35.356762 ], [ -76.387965, 35.356762 ], [ -76.399206, 35.348893 ], [ -76.408199, 35.350017 ], [ -76.409323, 35.353390 ], [ -76.420564, 35.359010 ], [ -76.431805, 35.362383 ], [ -76.436301, 35.378120 ], [ -76.448666, 35.383741 ], [ -76.455411, 35.383741 ], [ -76.462156, 35.380368 ], [ -76.472273, 35.371375 ], [ -76.485762, 35.371375 ], [ -76.499251, 35.381492 ], [ -76.521733, 35.391609 ], [ -76.546901, 35.389673 ], [ -76.580187, 35.387113 ], [ -76.606041, 35.387113 ], [ -76.620654, 35.378120 ], [ -76.628125, 35.368515 ], [ -76.628523, 35.368003 ], [ -76.619530, 35.345521 ], [ -76.604962, 35.337751 ], [ -76.602669, 35.336528 ], [ -76.588055, 35.333156 ], [ -76.554332, 35.332032 ], [ -76.548712, 35.328659 ], [ -76.500375, 35.321915 ], [ -76.482389, 35.314046 ], [ -76.472273, 35.294936 ], [ -76.467776, 35.276951 ], [ -76.467776, 35.261213 ], [ -76.477893, 35.243228 ], [ -76.483514, 35.240979 ], [ -76.490258, 35.233111 ], [ -76.491382, 35.220745 ], [ -76.494755, 35.212877 ], [ -76.504872, 35.207256 ], [ -76.521733, 35.192643 ], [ -76.536346, 35.174657 ], [ -76.539719, 35.166788 ], [ -76.536346, 35.149927 ], [ -76.536346, 35.142058 ], [ -76.546463, 35.122948 ], [ -76.557704, 35.116204 ], [ -76.561077, 35.108335 ], [ -76.568945, 35.097094 ], [ -76.575690, 35.092598 ], [ -76.586931, 35.092598 ], [ -76.592552, 35.083605 ], [ -76.593676, 35.075736 ], [ -76.600420, 35.067867 ], [ -76.613910, 35.061123 ], [ -76.622902, 35.061123 ], [ -76.631895, 35.056626 ], [ -76.639764, 35.051006 ], [ -76.646509, 35.042013 ], [ -76.646509, 35.025151 ], [ -76.644562, 35.019799 ], [ -76.642012, 35.012786 ], [ -76.628523, 34.994801 ], [ -76.588055, 34.991428 ], [ -76.566697, 34.998173 ], [ -76.539719, 35.000421 ], [ -76.502623, 35.007166 ], [ -76.495879, 35.011662 ], [ -76.491382, 35.017283 ], [ -76.490258, 35.034144 ], [ -76.480141, 35.052130 ], [ -76.474521, 35.070116 ], [ -76.468796, 35.075345 ], [ -76.463468, 35.076411 ], [ -76.435762, 35.057941 ], [ -76.432565, 35.049061 ], [ -76.431855, 35.030945 ], [ -76.425461, 35.001464 ], [ -76.406281, 34.987256 ], [ -76.398466, 34.976600 ], [ -76.395625, 34.975179 ], [ -76.332044, 34.970917 ], [ -76.326361, 34.976245 ], [ -76.329557, 34.986901 ], [ -76.350159, 35.016737 ], [ -76.360815, 35.025973 ], [ -76.364367, 35.031301 ], [ -76.364367, 35.034853 ], [ -76.352290, 35.033077 ], [ -76.318546, 35.020645 ], [ -76.293682, 35.009633 ], [ -76.288354, 35.005726 ], [ -76.288709, 34.997201 ], [ -76.290930, 34.994285 ], [ -76.293851, 34.991948 ], [ -76.296188, 34.986690 ], [ -76.296524, 34.976245 ], [ -76.290691, 34.969059 ], [ -76.275567, 34.960971 ], [ -76.274856, 34.953867 ], [ -76.277698, 34.940014 ], [ -76.284092, 34.936817 ], [ -76.311442, 34.910177 ], [ -76.319967, 34.897745 ], [ -76.333820, 34.882116 ], [ -76.347673, 34.872171 ], [ -76.368274, 34.872881 ], [ -76.377154, 34.867553 ], [ -76.379641, 34.862580 ], [ -76.395269, 34.855476 ], [ -76.400242, 34.855476 ], [ -76.411609, 34.841268 ], [ -76.415871, 34.825640 ], [ -76.415871, 34.813563 ], [ -76.403108, 34.806153 ], [ -76.390254, 34.805568 ], [ -76.383827, 34.807906 ], [ -76.373247, 34.817115 ], [ -76.362591, 34.824219 ], [ -76.341279, 34.842689 ], [ -76.322808, 34.861160 ], [ -76.273986, 34.897298 ], [ -76.233672, 34.925926 ], [ -76.194936, 34.962747 ], [ -76.160127, 34.991163 ], [ -76.111820, 35.034497 ], [ -76.093349, 35.048705 ], [ -76.069906, 35.075701 ], [ -76.064933, 35.077121 ], [ -76.043621, 35.070017 ], [ -76.038648, 35.065045 ], [ -76.035933, 35.058987 ], [ -76.073000, 35.030509 ], [ -76.137269, 34.987858 ], [ -76.233088, 34.905477 ], [ -76.310210, 34.852309 ], [ -76.386804, 34.784579 ], [ -76.450454, 34.714450 ], [ -76.494068, 34.661970 ], [ -76.524199, 34.615416 ], [ -76.535946, 34.588577 ], [ -76.555196, 34.615993 ], [ -76.553806, 34.628252 ], [ -76.550423, 34.630789 ], [ -76.549343, 34.645585 ], [ -76.579467, 34.660174 ], [ -76.618719, 34.672550 ], [ -76.642939, 34.677618 ], [ -76.662645, 34.685524 ], [ -76.676312, 34.693151 ], [ -76.693751, 34.692509 ], [ -76.726969, 34.696690 ], [ -76.770044, 34.696899 ], [ -76.817453, 34.693722 ], [ -76.906257, 34.682820 ], [ -76.990262, 34.669623 ], [ -77.031105, 34.661184 ], [ -77.112800, 34.639352 ], [ -77.136843, 34.632926 ], [ -77.169701, 34.622023 ], [ -77.209161, 34.605032 ], [ -77.240991, 34.587507 ], [ -77.322524, 34.535574 ], [ -77.462922, 34.471354 ], [ -77.491796, 34.456098 ], [ -77.517960, 34.440483 ], [ -77.556943, 34.417218 ], [ -77.582323, 34.400506 ], [ -77.635034, 34.359555 ], [ -77.661673, 34.341868 ], [ -77.687226, 34.320444 ], [ -77.713322, 34.294879 ], [ -77.715916, 34.292719 ], [ -77.740136, 34.272546 ], [ -77.764022, 34.245641 ], [ -77.829209, 34.162618 ], [ -77.841785, 34.140747 ], [ -77.870327, 34.079221 ], [ -77.874384, 34.075671 ], [ -77.878161, 34.067963 ], [ -77.915536, 33.971723 ], [ -77.927926, 33.945265 ], [ -77.937313, 33.928645 ], [ -77.946568, 33.912261 ], [ -77.956881, 33.877790 ], [ -77.960172, 33.853315 ], [ -77.970606, 33.844517 ], [ -78.006765, 33.858704 ], [ -78.009973, 33.861406 ], [ -78.009426, 33.867823 ], [ -78.018689, 33.888289 ], [ -78.095429, 33.906031 ], [ -78.136952, 33.912178 ], [ -78.177720, 33.914272 ], [ -78.276147, 33.912364 ], [ -78.383964, 33.901946 ], [ -78.509042, 33.865515 ], [ -78.541087, 33.851112 ], [ -78.650500, 33.944035 ], [ -78.710141, 33.994688 ], [ -78.712206, 33.996732 ], [ -79.071169, 34.299240 ], [ -79.143242, 34.359817 ], [ -79.151485, 34.366753 ], [ -79.190739, 34.399751 ], [ -79.192041, 34.401040 ], [ -79.198982, 34.406699 ], [ -79.323249, 34.514634 ], [ -79.324854, 34.516282 ], [ -79.331328, 34.521869 ], [ -79.358317, 34.545358 ], [ -79.450034, 34.621036 ], [ -79.459766, 34.629027 ], [ -79.461318, 34.630126 ], [ -79.461754, 34.630432 ], [ -79.468717, 34.635323 ], [ -79.471599, 34.637200 ], [ -79.479305, 34.644640 ], [ -79.490201, 34.653819 ], [ -79.519043, 34.677321 ], [ -79.520269, 34.678327 ], [ -79.554454, 34.706363 ], [ -79.561691, 34.711996 ], [ -79.631577, 34.768835 ], [ -79.634216, 34.771012 ], [ -79.688088, 34.804897 ], [ -79.690201, 34.804937 ], [ -79.692948, 34.804973 ], [ -79.744116, 34.805651 ], [ -79.744925, 34.805686 ], [ -79.772829, 34.805954 ], [ -79.773607, 34.805931 ], [ -79.927618, 34.806555 ], [ -80.027464, 34.808726 ], [ -80.042764, 34.809097 ], [ -80.072912, 34.809736 ], [ -80.077223, 34.809716 ], [ -80.098022, 34.810147 ], [ -80.098994, 34.810147 ], [ -80.320413, 34.813813 ], [ -80.399871, 34.815128 ], [ -80.417014, 34.815508 ], [ -80.418433, 34.815622 ], [ -80.419586, 34.815581 ], [ -80.425902, 34.815810 ], [ -80.434843, 34.815968 ], [ -80.448766, 34.816332 ], [ -80.451660, 34.816396 ], [ -80.485683, 34.816732 ], [ -80.561657, 34.817481 ], [ -80.561674, 34.817481 ], [ -80.621222, 34.818174 ], [ -80.625993, 34.818239 ], [ -80.626077, 34.818217 ], [ -80.644656, 34.818568 ], [ -80.646601, 34.818592 ], [ -80.771792, 34.819646 ], [ -80.777712, 34.819697 ], [ -80.796750, 34.825281 ], [ -80.782042, 34.935782 ], [ -80.806461, 34.962894 ], [ -80.806784, 34.963249 ], [ -80.840461, 35.001566 ], [ -80.906417, 35.076608 ], [ -80.906553, 35.076763 ], [ -80.934950, 35.107409 ], [ -80.957870, 35.092639 ], [ -81.041489, 35.044703 ], [ -81.057465, 35.061983 ], [ -81.058029, 35.073190 ], [ -81.057236, 35.086129 ], [ -81.052078, 35.096276 ], [ -81.046524, 35.100617 ], [ -81.036163, 35.103205 ], [ -81.032547, 35.109102 ], [ -81.042758, 35.146042 ], [ -81.043407, 35.148390 ], [ -81.090215, 35.152627 ], [ -81.239358, 35.159974 ], [ -81.241686, 35.160081 ], [ -81.269199, 35.161140 ], [ -81.328020, 35.163404 ], [ -81.366599, 35.164889 ], [ -81.366691, 35.164893 ], [ -81.452398, 35.168293 ], [ -81.461408, 35.168657 ], [ -81.493401, 35.169951 ], [ -81.494265, 35.169882 ], [ -81.768073, 35.180132 ], [ -81.857832, 35.183492 ], [ -81.874433, 35.184113 ], [ -81.969325, 35.187215 ], [ -82.167676, 35.193699 ], [ -82.176874, 35.193790 ], [ -82.185513, 35.194355 ], [ -82.195483, 35.194951 ], [ -82.216217, 35.196044 ], [ -82.230517, 35.196764 ], [ -82.230915, 35.196784 ], [ -82.257515, 35.198636 ], [ -82.288453, 35.198605 ], [ -82.352430, 35.206595 ], [ -82.384029, 35.210542 ], [ -82.476136, 35.175486 ], [ -82.516910, 35.163029 ], [ -82.517284, 35.162643 ], [ -82.535804, 35.158699 ], [ -82.536527, 35.159137 ], [ -82.574406, 35.144216 ], [ -82.580127, 35.141963 ], [ -82.582264, 35.142268 ], [ -82.686496, 35.121822 ], [ -82.686738, 35.119790 ], [ -82.764464, 35.068177 ], [ -82.781973, 35.066817 ], [ -82.780546, 35.069043 ], [ -82.779116, 35.073674 ], [ -82.777407, 35.076885 ], [ -82.781062, 35.084492 ], [ -82.781130, 35.084585 ], [ -82.897499, 35.056021 ], [ -83.008447, 35.026974 ], [ -83.108535, 35.000771 ], [ -83.108714, 35.000768 ], [ -83.483064, 34.993737 ], [ -83.549381, 34.992492 ], [ -83.620185, 34.992091 ], [ -83.673621, 34.987111 ], [ -83.936413, 34.987485 ], [ -83.936646, 34.987485 ], [ -84.005457, 34.987440 ], [ -84.021357, 34.987430 ], [ -84.029954, 34.987321 ], [ -84.129455, 34.987504 ], [ -84.129555, 34.987504 ], [ -84.321869, 34.988408 ], [ -84.308576, 35.092761 ], [ -84.308437, 35.093173 ], [ -84.292321, 35.206677 ], [ -84.290240, 35.225572 ], [ -84.227818, 35.267878 ], [ -84.223718, 35.269078 ], [ -84.211818, 35.266078 ], [ -84.202879, 35.255772 ], [ -84.124915, 35.249830 ], [ -84.121150, 35.250644 ], [ -84.115279, 35.250438 ], [ -84.115048, 35.249765 ], [ -84.097508, 35.247382 ], [ -84.055712, 35.268182 ], [ -84.029033, 35.291049 ], [ -84.023510, 35.295783 ], [ -84.021410, 35.301383 ], [ -84.032479, 35.325318 ], [ -84.032450, 35.326530 ], [ -84.038081, 35.348363 ], [ -84.037494, 35.349850 ], [ -84.035343, 35.350833 ], [ -84.024756, 35.353896 ], [ -84.002250, 35.422548 ], [ -83.999906, 35.425201 ], [ -83.961400, 35.459496 ], [ -83.961054, 35.462838 ], [ -83.961056, 35.463738 ], [ -83.961053, 35.464143 ], [ -83.952882, 35.460635 ], [ -83.952676, 35.460763 ], [ -83.933876, 35.472438 ], [ -83.880074, 35.518745 ], [ -83.756917, 35.563604 ], [ -83.676268, 35.570289 ], [ -83.662957, 35.569138 ], [ -83.640498, 35.566075 ], [ -83.498335, 35.562981 ], [ -83.485527, 35.568204 ], [ -83.480617, 35.576633 ], [ -83.478523, 35.579202 ], [ -83.479082, 35.583316 ], [ -83.445802, 35.611803 ], [ -83.366941, 35.638728 ], [ -83.297154, 35.657750 ], [ -83.254231, 35.695807 ], [ -83.250695, 35.709349 ], [ -83.255489, 35.714974 ], [ -83.251247, 35.719916 ], [ -83.240669, 35.726760 ], [ -83.164909, 35.759965 ], [ -83.100233, 35.774745 ], [ -83.100329, 35.774804 ], [ -83.100225, 35.774765 ], [ -82.995803, 35.773128 ], [ -82.983970, 35.778010 ], [ -82.964108, 35.794100 ], [ -82.962842, 35.795126 ], [ -82.918356, 35.845467 ], [ -82.897980, 35.881278 ], [ -82.913338, 35.924113 ], [ -82.898506, 35.945100 ], [ -82.898505, 35.945101 ], [ -82.874159, 35.952698 ], [ -82.852554, 35.949089 ], [ -82.830112, 35.932972 ], [ -82.778625, 35.974792 ], [ -82.754465, 36.004304 ], [ -82.715365, 36.024253 ], [ -82.683565, 36.046104 ], [ -82.637165, 36.065805 ], [ -82.632265, 36.065705 ], [ -82.619205, 36.056556 ], [ -82.602877, 36.039833 ], [ -82.615062, 36.000306 ], [ -82.611262, 35.973155 ], [ -82.596774, 35.964987 ], [ -82.557529, 35.954671 ], [ -82.512598, 35.975664 ], [ -82.507068, 35.977475 ], [ -82.505860, 35.978342 ], [ -82.487451, 35.991557 ], [ -82.487411, 35.991634 ], [ -82.462958, 36.007309 ], [ -82.416857, 36.072885 ], [ -82.409458, 36.083409 ], [ -82.375558, 36.105609 ], [ -82.371383, 36.106388 ], [ -82.366566, 36.107650 ], [ -82.360919, 36.110614 ], [ -82.348422, 36.115929 ], [ -82.329177, 36.117427 ], [ -82.325169, 36.119363 ], [ -82.237737, 36.139189 ], [ -82.236415, 36.139926 ], [ -82.235479, 36.140748 ], [ -82.234807, 36.141720 ], [ -82.222052, 36.156911 ], [ -82.211251, 36.159012 ], [ -82.147948, 36.149516 ], [ -82.136547, 36.128817 ], [ -82.137974, 36.119576 ], [ -82.130646, 36.106417 ], [ -82.127146, 36.104417 ], [ -82.080518, 36.105710 ], [ -82.080143, 36.105720 ], [ -82.026640, 36.130222 ], [ -81.960101, 36.228131 ], [ -81.932994, 36.264881 ], [ -81.918113, 36.287110 ], [ -81.908137, 36.302013 ], [ -81.855005, 36.337259 ], [ -81.800812, 36.358073 ], [ -81.793688, 36.360428 ], [ -81.789712, 36.348324 ], [ -81.764927, 36.338672 ], [ -81.747842, 36.337356 ], [ -81.730976, 36.341187 ], [ -81.725938, 36.340364 ], [ -81.720969, 36.387500 ], [ -81.714277, 36.450978 ], [ -81.715082, 36.453365 ], [ -81.697287, 36.484738 ], [ -81.695907, 36.491580 ], [ -81.696835, 36.493393 ], [ -81.697261, 36.496141 ], [ -81.698265, 36.497221 ], [ -81.699928, 36.498018 ], [ -81.700238, 36.500475 ], [ -81.699923, 36.500865 ], [ -81.697970, 36.504063 ], [ -81.697290, 36.504887 ], [ -81.697829, 36.507544 ], [ -81.697744, 36.508448 ], [ -81.699446, 36.511504 ], [ -81.699601, 36.512883 ], [ -81.700093, 36.514158 ], [ -81.700553, 36.515190 ], [ -81.707963, 36.536209 ], [ -81.699962, 36.539714 ], [ -81.677535, 36.588117 ], [ -81.606970, 36.587094 ], [ -81.521032, 36.580520 ], [ -81.353322, 36.574723 ], [ -81.353169, 36.574724 ], [ -81.307511, 36.575024 ], [ -81.061866, 36.567020 ], [ -81.058844, 36.566976 ], [ -80.945988, 36.563196 ], [ -80.944338, 36.563058 ], [ -80.901836, 36.561754 ], [ -80.901726, 36.561751 ], [ -80.837954, 36.559131 ], [ -80.837641, 36.559118 ], [ -80.837089, 36.559154 ], [ -80.744101, 36.561686 ], [ -80.687539, 36.561411 ], [ -80.612158, 36.558127 ], [ -80.440100, 36.550630 ], [ -80.432628, 36.550302 ], [ -80.431605, 36.550219 ], [ -80.228263, 36.543867 ], [ -80.225408, 36.543748 ], [ -80.171636, 36.543219 ], [ -80.169535, 36.543190 ], [ -80.053455, 36.542623 ], [ -80.027269, 36.542495 ], [ -79.967511, 36.542502 ], [ -79.966979, 36.542475 ], [ -79.920239, 36.542365 ], [ -79.714855, 36.541884 ], [ -79.667309, 36.541772 ], [ -79.666827, 36.541772 ], [ -79.510961, 36.540740 ], [ -79.510647, 36.540738 ], [ -79.470047, 36.541025 ], [ -79.445961, 36.541195 ], [ -79.445687, 36.541218 ], [ -79.342696, 36.541382 ], [ -79.218638, 36.541579 ], [ -79.209480, 36.541594 ], [ -79.208686, 36.541571 ], [ -79.137936, 36.541739 ], [ -79.126078, 36.541533 ], [ -79.124736, 36.541568 ], [ -78.971814, 36.542123 ], [ -78.970577, 36.542154 ], [ -78.942254, 36.542079 ], [ -78.942009, 36.542113 ], [ -78.915420, 36.541974 ], [ -78.914543, 36.541972 ], [ -78.796300, 36.541713 ], [ -78.765430, 36.541727 ], [ -78.758392, 36.541852 ], [ -78.734122, 36.541902 ], [ -78.670051, 36.542035 ], [ -78.663317, 36.542011 ], [ -78.533013, 36.541004 ], [ -78.529722, 36.540981 ], [ -78.471022, 36.542307 ], [ -78.470792, 36.542316 ], [ -78.456970, 36.542474 ], [ -78.441199, 36.542687 ], [ -78.436333, 36.542666 ], [ -78.323912, 36.543809 ], [ -78.246681, 36.544341 ], [ -78.245462, 36.544411 ], [ -78.133323, 36.543847 ], [ -78.132911, 36.543811 ], [ -78.046202, 36.544168 ], [ -78.039420, 36.544196 ], [ -78.038938, 36.544173 ], [ -77.899771, 36.544663 ], [ -77.882357, 36.544737 ], [ -77.875280, 36.544754 ], [ -77.767117, 36.544752 ], [ -77.296875, 36.544746 ], [ -77.249690, 36.544745 ], [ -77.164500, 36.546330 ], [ -76.916048, 36.543815 ], [ -76.916001, 36.543818 ], [ -76.915384, 36.543856 ], [ -76.807078, 36.550606 ], [ -76.781296, 36.550659 ], [ -76.541687, 36.550312 ], [ -76.541391, 36.550312 ], [ -76.491497, 36.550365 ] ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US45", "STATE": 33, "name": "South Carolina", "LSAD": "", "CENSUSAREA": 30060.696000 }, "geometry": { "type": "Polygon", "coordinates": [ [ [ -82.216217, 35.196044 ], [ -82.195483, 35.194951 ], [ -82.185513, 35.194355 ], [ -82.176874, 35.193790 ], [ -82.167676, 35.193699 ], [ -81.969325, 35.187215 ], [ -81.874433, 35.184113 ], [ -81.857832, 35.183492 ], [ -81.768073, 35.180132 ], [ -81.494265, 35.169882 ], [ -81.493401, 35.169951 ], [ -81.461408, 35.168657 ], [ -81.452398, 35.168293 ], [ -81.366691, 35.164893 ], [ -81.366599, 35.164889 ], [ -81.328020, 35.163404 ], [ -81.269199, 35.161140 ], [ -81.241686, 35.160081 ], [ -81.239358, 35.159974 ], [ -81.090215, 35.152627 ], [ -81.043407, 35.148390 ], [ -81.042758, 35.146042 ], [ -81.032547, 35.109102 ], [ -81.036163, 35.103205 ], [ -81.046524, 35.100617 ], [ -81.052078, 35.096276 ], [ -81.057236, 35.086129 ], [ -81.058029, 35.073190 ], [ -81.057465, 35.061983 ], [ -81.041489, 35.044703 ], [ -80.957870, 35.092639 ], [ -80.934950, 35.107409 ], [ -80.906553, 35.076763 ], [ -80.906417, 35.076608 ], [ -80.840461, 35.001566 ], [ -80.806784, 34.963249 ], [ -80.806461, 34.962894 ], [ -80.782042, 34.935782 ], [ -80.796750, 34.825281 ], [ -80.777712, 34.819697 ], [ -80.771792, 34.819646 ], [ -80.646601, 34.818592 ], [ -80.644656, 34.818568 ], [ -80.626077, 34.818217 ], [ -80.625993, 34.818239 ], [ -80.621222, 34.818174 ], [ -80.561674, 34.817481 ], [ -80.561657, 34.817481 ], [ -80.485683, 34.816732 ], [ -80.451660, 34.816396 ], [ -80.448766, 34.816332 ], [ -80.434843, 34.815968 ], [ -80.425902, 34.815810 ], [ -80.419586, 34.815581 ], [ -80.418433, 34.815622 ], [ -80.417014, 34.815508 ], [ -80.399871, 34.815128 ], [ -80.320413, 34.813813 ], [ -80.098994, 34.810147 ], [ -80.098022, 34.810147 ], [ -80.077223, 34.809716 ], [ -80.072912, 34.809736 ], [ -80.042764, 34.809097 ], [ -80.027464, 34.808726 ], [ -79.927618, 34.806555 ], [ -79.773607, 34.805931 ], [ -79.772829, 34.805954 ], [ -79.744925, 34.805686 ], [ -79.744116, 34.805651 ], [ -79.692948, 34.804973 ], [ -79.690201, 34.804937 ], [ -79.688088, 34.804897 ], [ -79.634216, 34.771012 ], [ -79.631577, 34.768835 ], [ -79.561691, 34.711996 ], [ -79.554454, 34.706363 ], [ -79.520269, 34.678327 ], [ -79.519043, 34.677321 ], [ -79.490201, 34.653819 ], [ -79.479305, 34.644640 ], [ -79.471599, 34.637200 ], [ -79.468717, 34.635323 ], [ -79.461754, 34.630432 ], [ -79.461318, 34.630126 ], [ -79.459766, 34.629027 ], [ -79.450034, 34.621036 ], [ -79.358317, 34.545358 ], [ -79.331328, 34.521869 ], [ -79.324854, 34.516282 ], [ -79.323249, 34.514634 ], [ -79.198982, 34.406699 ], [ -79.192041, 34.401040 ], [ -79.190739, 34.399751 ], [ -79.151485, 34.366753 ], [ -79.143242, 34.359817 ], [ -79.071169, 34.299240 ], [ -78.712206, 33.996732 ], [ -78.710141, 33.994688 ], [ -78.650500, 33.944035 ], [ -78.541087, 33.851112 ], [ -78.553944, 33.847831 ], [ -78.584841, 33.844282 ], [ -78.672260, 33.817587 ], [ -78.714116, 33.800138 ], [ -78.772737, 33.768511 ], [ -78.812931, 33.743472 ], [ -78.862931, 33.705654 ], [ -78.938076, 33.639826 ], [ -79.002109, 33.572114 ], [ -79.007356, 33.566565 ], [ -79.028516, 33.533365 ], [ -79.041125, 33.523773 ], [ -79.084588, 33.483669 ], [ -79.101360, 33.461016 ], [ -79.135441, 33.403867 ], [ -79.147496, 33.378243 ], [ -79.152035, 33.350925 ], [ -79.158429, 33.332811 ], [ -79.162332, 33.327246 ], [ -79.180318, 33.254141 ], [ -79.180563, 33.237955 ], [ -79.172394, 33.206577 ], [ -79.187870, 33.173712 ], [ -79.195631, 33.166016 ], [ -79.215453, 33.155569 ], [ -79.238262, 33.137055 ], [ -79.246090, 33.124865 ], [ -79.290754, 33.110051 ], [ -79.291591, 33.109773 ], [ -79.329909, 33.089986 ], [ -79.337169, 33.072302 ], [ -79.335346, 33.065362 ], [ -79.339313, 33.050336 ], [ -79.359961, 33.006672 ], [ -79.403712, 33.003903 ], [ -79.416515, 33.006815 ], [ -79.423447, 33.015085 ], [ -79.461047, 33.007639 ], [ -79.483499, 33.001265 ], [ -79.488727, 33.015832 ], [ -79.506923, 33.032813 ], [ -79.522449, 33.035350 ], [ -79.557560, 33.021269 ], [ -79.580725, 33.006447 ], [ -79.586590, 32.991334 ], [ -79.601020, 32.979282 ], [ -79.606615, 32.972248 ], [ -79.617611, 32.952726 ], [ -79.617715, 32.944870 ], [ -79.612928, 32.934815 ], [ -79.606194, 32.925953 ], [ -79.585897, 32.926461 ], [ -79.581687, 32.931341 ], [ -79.574951, 32.934526 ], [ -79.572614, 32.933885 ], [ -79.569762, 32.926692 ], [ -79.576006, 32.906235 ], [ -79.631149, 32.888606 ], [ -79.655426, 32.872705 ], [ -79.695141, 32.850398 ], [ -79.699482, 32.839997 ], [ -79.702956, 32.835781 ], [ -79.719879, 32.825796 ], [ -79.716761, 32.813627 ], [ -79.726389, 32.805996 ], [ -79.811021, 32.776960 ], [ -79.818237, 32.766352 ], [ -79.840350, 32.756816 ], [ -79.848527, 32.755248 ], [ -79.866742, 32.757422 ], [ -79.872232, 32.752128 ], [ -79.873605, 32.745657 ], [ -79.868352, 32.734849 ], [ -79.870336, 32.727777 ], [ -79.888028, 32.695177 ], [ -79.884961, 32.684402 ], [ -79.915682, 32.664915 ], [ -79.968468, 32.639732 ], [ -79.975248, 32.639537 ], [ -79.986917, 32.626388 ], [ -79.991750, 32.616389 ], [ -79.999374, 32.611851 ], [ -80.010505, 32.608852 ], [ -80.037276, 32.610236 ], [ -80.077039, 32.603319 ], [ -80.121368, 32.590523 ], [ -80.148406, 32.578479 ], [ -80.167286, 32.559885 ], [ -80.171764, 32.546118 ], [ -80.188401, 32.553604 ], [ -80.193676, 32.554213 ], [ -80.205230, 32.555547 ], [ -80.246361, 32.531114 ], [ -80.249566, 32.529584 ], [ -80.277681, 32.516161 ], [ -80.332438, 32.478104 ], [ -80.338354, 32.478730 ], [ -80.343883, 32.490795 ], [ -80.363956, 32.496098 ], [ -80.380716, 32.486359 ], [ -80.386827, 32.478810 ], [ -80.392561, 32.475332 ], [ -80.413487, 32.470672 ], [ -80.415943, 32.472074 ], [ -80.417896, 32.476076 ], [ -80.418502, 32.490894 ], [ -80.423454, 32.497989 ], [ -80.439407, 32.503472 ], [ -80.452078, 32.497286 ], [ -80.465710, 32.495300 ], [ -80.472068, 32.496964 ], [ -80.476910, 32.485390 ], [ -80.480250, 32.477407 ], [ -80.484617, 32.460976 ], [ -80.480156, 32.447048 ], [ -80.467588, 32.425259 ], [ -80.446075, 32.423721 ], [ -80.432960, 32.410659 ], [ -80.429941, 32.401782 ], [ -80.429291, 32.389667 ], [ -80.434303, 32.375193 ], [ -80.445451, 32.350335 ], [ -80.456814, 32.336884 ], [ -80.455192, 32.326458 ], [ -80.466342, 32.319170 ], [ -80.517871, 32.298796 ], [ -80.539429, 32.287024 ], [ -80.545688, 32.282076 ], [ -80.571096, 32.273278 ], [ -80.596394, 32.273549 ], [ -80.618286, 32.260183 ], [ -80.638857, 32.255618 ], [ -80.658634, 32.248638 ], [ -80.669166, 32.216783 ], [ -80.688857, 32.200971 ], [ -80.721463, 32.160427 ], [ -80.749091, 32.140137 ], [ -80.789996, 32.122494 ], [ -80.812503, 32.109746 ], [ -80.821530, 32.108589 ], [ -80.828394, 32.113222 ], [ -80.831531, 32.112709 ], [ -80.844431, 32.109709 ], [ -80.858735, 32.099581 ], [ -80.878111, 32.079792 ], [ -80.905378, 32.051943 ], [ -80.892344, 32.043764 ], [ -80.885517, 32.034600 ], [ -81.004115, 32.072225 ], [ -81.042833, 32.084508 ], [ -81.061850, 32.087935 ], [ -81.113334, 32.113205 ], [ -81.117234, 32.117605 ], [ -81.122034, 32.161803 ], [ -81.125457, 32.227130 ], [ -81.128034, 32.276297 ], [ -81.120333, 32.285796 ], [ -81.122333, 32.305395 ], [ -81.134332, 32.341693 ], [ -81.140932, 32.349393 ], [ -81.168032, 32.368391 ], [ -81.199029, 32.467286 ], [ -81.275415, 32.539457 ], [ -81.286776, 32.544831 ], [ -81.318255, 32.559722 ], [ -81.328753, 32.561228 ], [ -81.348155, 32.569294 ], [ -81.389258, 32.595385 ], [ -81.389338, 32.595436 ], [ -81.411906, 32.618410 ], [ -81.418660, 32.629392 ], [ -81.418431, 32.634704 ], [ -81.414761, 32.637440 ], [ -81.405134, 32.744964 ], [ -81.404949, 32.747027 ], [ -81.423772, 32.810514 ], [ -81.499830, 32.963816 ], [ -81.494736, 32.978998 ], [ -81.491495, 32.998572 ], [ -81.496637, 33.010224 ], [ -81.511690, 33.024506 ], [ -81.541831, 33.045654 ], [ -81.615756, 33.092534 ], [ -81.620287, 33.095408 ], [ -81.696934, 33.116551 ], [ -81.772251, 33.180120 ], [ -81.851975, 33.247408 ], [ -81.852136, 33.247544 ], [ -81.902737, 33.331242 ], [ -81.912572, 33.408811 ], [ -81.957934, 33.468632 ], [ -81.967037, 33.480636 ], [ -82.007138, 33.522835 ], [ -82.007638, 33.523335 ], [ -82.014293, 33.530313 ], [ -82.028238, 33.544934 ], [ -82.046335, 33.563830 ], [ -82.069039, 33.575382 ], [ -82.098816, 33.586358 ], [ -82.116630, 33.589723 ], [ -82.124841, 33.591274 ], [ -82.129080, 33.589925 ], [ -82.135046, 33.591044 ], [ -82.179854, 33.615945 ], [ -82.196583, 33.630582 ], [ -82.218649, 33.686299 ], [ -82.247472, 33.752591 ], [ -82.301457, 33.801864 ], [ -82.324480, 33.820033 ], [ -82.403881, 33.865477 ], [ -82.408354, 33.866320 ], [ -82.422803, 33.863754 ], [ -82.429164, 33.865844 ], [ -82.564483, 33.955744 ], [ -82.564582, 33.955810 ], [ -82.597079, 34.012390 ], [ -82.640701, 34.088341 ], [ -82.641252, 34.088914 ], [ -82.652175, 34.099704 ], [ -82.654019, 34.100346 ], [ -82.658561, 34.103118 ], [ -82.659077, 34.103544 ], [ -82.668113, 34.120160 ], [ -82.677320, 34.131657 ], [ -82.704140, 34.141007 ], [ -82.717507, 34.150504 ], [ -82.731881, 34.178363 ], [ -82.741491, 34.208709 ], [ -82.741920, 34.210063 ], [ -82.744415, 34.224913 ], [ -82.743461, 34.227343 ], [ -82.741980, 34.230196 ], [ -82.755028, 34.276067 ], [ -82.766078, 34.293509 ], [ -82.848651, 34.423844 ], [ -82.874864, 34.468891 ], [ -82.873831, 34.471508 ], [ -82.882864, 34.479003 ], [ -82.902665, 34.485902 ], [ -82.939067, 34.486202 ], [ -82.979568, 34.482702 ], [ -82.992215, 34.479198 ], [ -82.992671, 34.479072 ], [ -82.995284, 34.474549 ], [ -83.006848, 34.474376 ], [ -83.034712, 34.483495 ], [ -83.052161, 34.493062 ], [ -83.072746, 34.504349 ], [ -83.087189, 34.515939 ], [ -83.106874, 34.534053 ], [ -83.170278, 34.592398 ], [ -83.170978, 34.598798 ], [ -83.167523, 34.600424 ], [ -83.240676, 34.624307 ], [ -83.240669, 34.624507 ], [ -83.291683, 34.653396 ], [ -83.337867, 34.687681 ], [ -83.338194, 34.687924 ], [ -83.351293, 34.701703 ], [ -83.350976, 34.713243 ], [ -83.351392, 34.714456 ], [ -83.352485, 34.715993 ], [ -83.352422, 34.716111 ], [ -83.339129, 34.741266 ], [ -83.324060, 34.788691 ], [ -83.283151, 34.821328 ], [ -83.267293, 34.832748 ], [ -83.242962, 34.877749 ], [ -83.143261, 34.924756 ], [ -83.108535, 35.000771 ], [ -83.008447, 35.026974 ], [ -82.897499, 35.056021 ], [ -82.781130, 35.084585 ], [ -82.781062, 35.084492 ], [ -82.777407, 35.076885 ], [ -82.779116, 35.073674 ], [ -82.780546, 35.069043 ], [ -82.781973, 35.066817 ], [ -82.764464, 35.068177 ], [ -82.686738, 35.119790 ], [ -82.686496, 35.121822 ], [ -82.582264, 35.142268 ], [ -82.580127, 35.141963 ], [ -82.574406, 35.144216 ], [ -82.536527, 35.159137 ], [ -82.535804, 35.158699 ], [ -82.517284, 35.162643 ], [ -82.516910, 35.163029 ], [ -82.476136, 35.175486 ], [ -82.384029, 35.210542 ], [ -82.352430, 35.206595 ], [ -82.288453, 35.198605 ], [ -82.257515, 35.198636 ], [ -82.230915, 35.196784 ], [ -82.230517, 35.196764 ], [ -82.216217, 35.196044 ] ] ] } }
					,
					{ "type": "Feature", "properties": { "GEO_ID": "0400000US53", "STATE": 34, "name": "Washington", "LSAD": "", "CENSUSAREA": 66455.521000 }, "geometry": { "type": "MultiPolygon", "coordinates": [ [ [ [ -122.397349, 47.912401 ], [ -122.419274, 47.912125 ], [ -122.431035, 47.914732 ], [ -122.445519, 47.930226 ], [ -122.445759, 47.936190 ], [ -122.440790, 47.946594 ], [ -122.440760, 47.951845 ], [ -122.446682, 47.963155 ], [ -122.472660, 47.988449 ], [ -122.487505, 47.990729 ], [ -122.501257, 47.987089 ], [ -122.514813, 47.981152 ], [ -122.517780, 47.974916 ], [ -122.521219, 47.972997 ], [ -122.546824, 47.967215 ], [ -122.552053, 47.973644 ], [ -122.551032, 47.977346 ], [ -122.543063, 47.985983 ], [ -122.541564, 47.992998 ], [ -122.542924, 47.996404 ], [ -122.560018, 48.006502 ], [ -122.581780, 48.010386 ], [ -122.607342, 48.030992 ], [ -122.596786, 48.038834 ], [ -122.593621, 48.047200 ], [ -122.594922, 48.056318 ], [ -122.614028, 48.072788 ], [ -122.613217, 48.079485 ], [ -122.607291, 48.088034 ], [ -122.598301, 48.110616 ], [ -122.602109, 48.135249 ], [ -122.609568, 48.151860 ], [ -122.617464, 48.159055 ], [ -122.633167, 48.163281 ], [ -122.656020, 48.162513 ], [ -122.671235, 48.157312 ], [ -122.677337, 48.154587 ], [ -122.679556, 48.155113 ], [ -122.686626, 48.174653 ], [ -122.693084, 48.181509 ], [ -122.711508, 48.193573 ], [ -122.735030, 48.199964 ], [ -122.744612, 48.209650 ], [ -122.763042, 48.215342 ], [ -122.770045, 48.224395 ], [ -122.769939, 48.227548 ], [ -122.752563, 48.260061 ], [ -122.732022, 48.279425 ], [ -122.722590, 48.304268 ], [ -122.707077, 48.315286 ], [ -122.673731, 48.354683 ], [ -122.664928, 48.374823 ], [ -122.664659, 48.401508 ], [ -122.644798, 48.405488 ], [ -122.634991, 48.404244 ], [ -122.632643, 48.401068 ], [ -122.634024, 48.398858 ], [ -122.637339, 48.398029 ], [ -122.637892, 48.395681 ], [ -122.635820, 48.395128 ], [ -122.627809, 48.397200 ], [ -122.617174, 48.407145 ], [ -122.609715, 48.411565 ], [ -122.601980, 48.409907 ], [ -122.596732, 48.405626 ], [ -122.595351, 48.397200 ], [ -122.585038, 48.395166 ], [ -122.588891, 48.363005 ], [ -122.585162, 48.353304 ], [ -122.565525, 48.348217 ], [ -122.551334, 48.342138 ], [ -122.515979, 48.320419 ], [ -122.506568, 48.310041 ], [ -122.504729, 48.300373 ], [ -122.505828, 48.297677 ], [ -122.519535, 48.288314 ], [ -122.522756, 48.285504 ], [ -122.530976, 48.282445 ], [ -122.551793, 48.281512 ], [ -122.558332, 48.282061 ], [ -122.574872, 48.294903 ], [ -122.584086, 48.297987 ], [ -122.599532, 48.298303 ], [ -122.618466, 48.294159 ], [ -122.626757, 48.288991 ], [ -122.620748, 48.282961 ], [ -122.623779, 48.269431 ], [ -122.652639, 48.265081 ], [ -122.653430, 48.259340 ], [ -122.669210, 48.240614 ], [ -122.668385, 48.223967 ], [ -122.631260, 48.220686 ], [ -122.628352, 48.222467 ], [ -122.606406, 48.208262 ], [ -122.588138, 48.185940 ], [ -122.585778, 48.182352 ], [ -122.582595, 48.170424 ], [ -122.574905, 48.155593 ], [ -122.567936, 48.148624 ], [ -122.558205, 48.119579 ], [ -122.559911, 48.114186 ], [ -122.571615, 48.105113 ], [ -122.571853, 48.102143 ], [ -122.554559, 48.077392 ], [ -122.545120, 48.052550 ], [ -122.538953, 48.050232 ], [ -122.516314, 48.057181 ], [ -122.513994, 48.059077 ], [ -122.511081, 48.075301 ], [ -122.516906, 48.081085 ], [ -122.525422, 48.096537 ], [ -122.513276, 48.097538 ], [ -122.491104, 48.094242 ], [ -122.461606, 48.068501 ], [ -122.448419, 48.054323 ], [ -122.431266, 48.045001 ], [ -122.400628, 48.036563 ], [ -122.387382, 48.034030 ], [ -122.376259, 48.034457 ], [ -122.373263, 48.000791 ], [ -122.369161, 47.995295 ], [ -122.353611, 47.981433 ], [ -122.350254, 47.969355 ], [ -122.349597, 47.958796 ], [ -122.350741, 47.953235 ], [ -122.358812, 47.937420 ], [ -122.367876, 47.932415 ], [ -122.376837, 47.923703 ], [ -122.375780, 47.910252 ], [ -122.377300, 47.905941 ], [ -122.380497, 47.904023 ], [ -122.390420, 47.905696 ], [ -122.397349, 47.912401 ] ] ], [ [ [ -122.649405, 48.588457 ], [ -122.642597, 48.588339 ], [ -122.629321, 48.572200 ], [ -122.610841, 48.561146 ], [ -122.592901, 48.553635 ], [ -122.583985, 48.551534 ], [ -122.578856, 48.548130 ], [ -122.572967, 48.529028 ], [ -122.583565, 48.532340 ], [ -122.590194, 48.536259 ], [ -122.599948, 48.536904 ], [ -122.619858, 48.529246 ], [ -122.635738, 48.526021 ], [ -122.640414, 48.525860 ], [ -122.649256, 48.528769 ], [ -122.652041, 48.531329 ], [ -122.654342, 48.537956 ], [ -122.653612, 48.548975 ], [ -122.650786, 48.554019 ], [ -122.652385, 48.583432 ], [ -122.649405, 48.588457 ] ] ], [ [ [ -122.714512, 48.608780 ], [ -122.694672, 48.596602 ], [ -122.691745, 48.590612 ], [ -122.670638, 48.568812 ], [ -122.689440, 48.543903 ], [ -122.717278, 48.539739 ], [ -122.722407, 48.540606 ], [ -122.724031, 48.549906 ], [ -122.730480, 48.565602 ], [ -122.736199, 48.569005 ], [ -122.739440, 48.573893 ], [ -122.739898, 48.583949 ], [ -122.724930, 48.603263 ], [ -122.714512, 48.608780 ] ] ], [ [ [ -122.699266, 48.621115 ], [ -122.698060, 48.623080 ], [ -122.674173, 48.629944 ], [ -122.657016, 48.609891 ], [ -122.666149, 48.608088 ], [ -122.676796, 48.610055 ], [ -122.686136, 48.613267 ], [ -122.699266, 48.621115 ] ] ], [ [ [ -122.800217, 48.601690 ], [ -122.804869, 48.595932 ], [ -122.801096, 48.585425 ], [ -122.786586, 48.576666 ], [ -122.771206, 48.562426 ], [ -122.770349, 48.558106 ], [ -122.772384, 48.552143 ], [ -122.782618, 48.545191 ], [ -122.788503, 48.530393 ], [ -122.787347, 48.523012 ], [ -122.777467, 48.517799 ], [ -122.779124, 48.508911 ], [ -122.800414, 48.494467 ], [ -122.816332, 48.487841 ], [ -122.817912, 48.483888 ], [ -122.819730, 48.458843 ], [ -122.813100, 48.452856 ], [ -122.807708, 48.444058 ], [ -122.802509, 48.433098 ], [ -122.803521, 48.428748 ], [ -122.812208, 48.422326 ], [ -122.825803, 48.424131 ], [ -122.874135, 48.418196 ], [ -122.883759, 48.418793 ], [ -122.893646, 48.422655 ], [ -122.889016, 48.435947 ], [ -122.903214, 48.436979 ], [ -122.913888, 48.443231 ], [ -122.917771, 48.439781 ], [ -122.928004, 48.439966 ], [ -122.916460, 48.453263 ], [ -122.920099, 48.458428 ], [ -122.926901, 48.460874 ], [ -122.937881, 48.456221 ], [ -122.962009, 48.451161 ], [ -123.039156, 48.460003 ], [ -123.058154, 48.471522 ], [ -123.067675, 48.479497 ], [ -123.119451, 48.492576 ], [ -123.141478, 48.505291 ], [ -123.151065, 48.513955 ], [ -123.163234, 48.529544 ], [ -123.164057, 48.535622 ], [ -123.161853, 48.539255 ], [ -123.161470, 48.547618 ], [ -123.172412, 48.556486 ], [ -123.176266, 48.562131 ], [ -123.175852, 48.568483 ], [ -123.171958, 48.572255 ], [ -123.173061, 48.579086 ], [ -123.184941, 48.586970 ], [ -123.197754, 48.586216 ], [ -123.202680, 48.590214 ], [ -123.203026, 48.596178 ], [ -123.195725, 48.607055 ], [ -123.178425, 48.622115 ], [ -123.151643, 48.623686 ], [ -123.139705, 48.622786 ], [ -123.135645, 48.620171 ], [ -123.107362, 48.622451 ], [ -123.098462, 48.612834 ], [ -123.098254, 48.610092 ], [ -123.102074, 48.604035 ], [ -123.101552, 48.597820 ], [ -123.074611, 48.591816 ], [ -123.060040, 48.582105 ], [ -123.048403, 48.569216 ], [ -123.033669, 48.563409 ], [ -123.015046, 48.560821 ], [ -122.987296, 48.561895 ], [ -122.986110, 48.569984 ], [ -122.989649, 48.574668 ], [ -122.995026, 48.578162 ], [ -123.004800, 48.580788 ], [ -123.016647, 48.580244 ], [ -123.034101, 48.591767 ], [ -123.024902, 48.594484 ], [ -123.023433, 48.599477 ], [ -123.041189, 48.611947 ], [ -123.046530, 48.611490 ], [ -123.048652, 48.621002 ], [ -123.023495, 48.634001 ], [ -123.015592, 48.642567 ], [ -123.014829, 48.647503 ], [ -123.009924, 48.655064 ], [ -122.988884, 48.667246 ], [ -122.984853, 48.672686 ], [ -122.949116, 48.693398 ], [ -122.941316, 48.702904 ], [ -122.942367, 48.706723 ], [ -122.918252, 48.713505 ], [ -122.894599, 48.715030 ], [ -122.875938, 48.712120 ], [ -122.833124, 48.698173 ], [ -122.802545, 48.682682 ], [ -122.800267, 48.679620 ], [ -122.743049, 48.661991 ], [ -122.742082, 48.660689 ], [ -122.755031, 48.649512 ], [ -122.783875, 48.635419 ], [ -122.792147, 48.633502 ], [ -122.809622, 48.619035 ], [ -122.808864, 48.615310 ], [ -122.799010, 48.604683 ], [ -122.798770, 48.602352 ], [ -122.800217, 48.601690 ] ] ], [ [ [ -123.197953, 48.684660 ], [ -123.186076, 48.684917 ], [ -123.172066, 48.679866 ], [ -123.147990, 48.668001 ], [ -123.130962, 48.656789 ], [ -123.122016, 48.647065 ], [ -123.106165, 48.633473 ], [ -123.119677, 48.632972 ], [ -123.134956, 48.637240 ], [ -123.215917, 48.669352 ], [ -123.237148, 48.683466 ], [ -123.236567, 48.688950 ], [ -123.212892, 48.689713 ], [ -123.197953, 48.684660 ] ] ], [ [ [ -123.025486, 48.717966 ], [ -123.019699, 48.721312 ], [ -123.009787, 48.722291 ], [ -123.007511, 48.718863 ], [ -123.005086, 48.694342 ], [ -123.014449, 48.684978 ], [ -123.021215, 48.681416 ], [ -123.042337, 48.675663 ], [ -123.041645, 48.678633 ], [ -123.035672, 48.685350 ], [ -123.036360, 48.690080 ], [ -123.047058, 48.695772 ], [ -123.070427, 48.699971 ], [ -123.040179, 48.717296 ], [ -123.025486, 48.717966 ] ] ], [ [ [ -122.321721, 48.019977 ], [ -122.303455, 48.005603 ], [ -122.306629, 48.004397 ], [ -122.326115, 48.010295 ], [ -122.334524, 48.018916 ], [ -122.328343, 48.021335 ], [ -122.321721, 48.019977 ] ] ], [ [ [ -123.035393, 49.002154 ], [ -123.021459, 48.977299 ], [ -123.028091, 48.973943 ], [ -123.040967, 48.977305 ], [ -123.060717, 48.975388 ], [ -123.083834, 48.976139 ], [ -123.084498, 48.986535 ], [ -123.090546, 49.001976 ], [ -123.035393, 49.002154 ] ] ], [ [ [ -122.695907, 48.737273 ], [ -122.668947, 48.706644 ], [ -122.663259, 48.697077 ], [ -122.644901, 48.691389 ], [ -122.618225, 48.670721 ], [ -122.609576, 48.645018 ], [ -122.616956, 48.645563 ], [ -122.635299, 48.651846 ], [ -122.673538, 48.680809 ], [ -122.691795, 48.711498 ], [ -122.702223, 48.717004 ], [ -122.718833, 48.716818 ], [ -122.721981, 48.723375 ], [ -122.722262, 48.731624 ], [ -122.715709, 48.748672 ], [ -122.703060, 48.743602 ], [ -122.695907, 48.737273 ] ] ], [ [ [ -122.418268, 47.320614 ], [ -122.364168, 47.335953 ], [ -122.336934, 47.341421 ], [ -122.324833, 47.348521 ], [ -122.325734, 47.391521 ], [ -122.328434, 47.400621 ], [ -122.335234, 47.408421 ], [ -122.348035, 47.415921 ], [ -122.355135, 47.441921 ], [ -122.367036, 47.447621 ], [ -122.383136, 47.450521 ], [ -122.368036, 47.459221 ], [ -122.363062, 47.475702 ], [ -122.361336, 47.481421 ], [ -122.365236, 47.488420 ], [ -122.386637, 47.502220 ], [ -122.396538, 47.515220 ], [ -122.393938, 47.524820 ], [ -122.398338, 47.550120 ], [ -122.409839, 47.568920 ], [ -122.421139, 47.576020 ], [ -122.401839, 47.583920 ], [ -122.387139, 47.595720 ], [ -122.375421, 47.585181 ], [ -122.370167, 47.583087 ], [ -122.358238, 47.584820 ], [ -122.342937, 47.591220 ], [ -122.339513, 47.599113 ], [ -122.344937, 47.609120 ], [ -122.367819, 47.624213 ], [ -122.386039, 47.631720 ], [ -122.393739, 47.631020 ], [ -122.404240, 47.633920 ], [ -122.414645, 47.639766 ], [ -122.429841, 47.658919 ], [ -122.407841, 47.680119 ], [ -122.403841, 47.689419 ], [ -122.393248, 47.701602 ], [ -122.380440, 47.709119 ], [ -122.376440, 47.716519 ], [ -122.375607, 47.719724 ], [ -122.373140, 47.729219 ], [ -122.382641, 47.749119 ], [ -122.380241, 47.758519 ], [ -122.394442, 47.772219 ], [ -122.396422, 47.777927 ], [ -122.397043, 47.779719 ], [ -122.394944, 47.803318 ], [ -122.392044, 47.807718 ], [ -122.353244, 47.840618 ], [ -122.346544, 47.842418 ], [ -122.339944, 47.846718 ], [ -122.335950, 47.852306 ], [ -122.329545, 47.869418 ], [ -122.330145, 47.875318 ], [ -122.333543, 47.880246 ], [ -122.328546, 47.897917 ], [ -122.321847, 47.911817 ], [ -122.311927, 47.923703 ], [ -122.310747, 47.925117 ], [ -122.309747, 47.929117 ], [ -122.311148, 47.936717 ], [ -122.307048, 47.949117 ], [ -122.278047, 47.956517 ], [ -122.249007, 47.959507 ], [ -122.230046, 47.970917 ], [ -122.226346, 47.976417 ], [ -122.232391, 47.987713 ], [ -122.230220, 48.007154 ], [ -122.228767, 48.012468 ], [ -122.224979, 48.016626 ], [ -122.231761, 48.029876 ], [ -122.281087, 48.049793 ], [ -122.305838, 48.073415 ], [ -122.321709, 48.085507 ], [ -122.326119, 48.092877 ], [ -122.343241, 48.097631 ], [ -122.363842, 48.123930 ], [ -122.365078, 48.125822 ], [ -122.363797, 48.142759 ], [ -122.364744, 48.151304 ], [ -122.370253, 48.164809 ], [ -122.363479, 48.174438 ], [ -122.362044, 48.187568 ], [ -122.372492, 48.193022 ], [ -122.382102, 48.207106 ], [ -122.385703, 48.217811 ], [ -122.395499, 48.228551 ], [ -122.396121, 48.229233 ], [ -122.425572, 48.232887 ], [ -122.430578, 48.236237 ], [ -122.433767, 48.236550 ], [ -122.449605, 48.232598 ], [ -122.453710, 48.228859 ], [ -122.453618, 48.226830 ], [ -122.449513, 48.214736 ], [ -122.444508, 48.214522 ], [ -122.441731, 48.211776 ], [ -122.442051, 48.209350 ], [ -122.454930, 48.196639 ], [ -122.461888, 48.193137 ], [ -122.464801, 48.194767 ], [ -122.470250, 48.194007 ], [ -122.478535, 48.188087 ], [ -122.479008, 48.175703 ], [ -122.475803, 48.166792 ], [ -122.442383, 48.130841 ], [ -122.411649, 48.113210 ], [ -122.379481, 48.087384 ], [ -122.360345, 48.061527 ], [ -122.358375, 48.056133 ], [ -122.363107, 48.054546 ], [ -122.377114, 48.057568 ], [ -122.387690, 48.065189 ], [ -122.390787, 48.069477 ], [ -122.393413, 48.078472 ], [ -122.400692, 48.085255 ], [ -122.423703, 48.102941 ], [ -122.449660, 48.114041 ], [ -122.467500, 48.130353 ], [ -122.477983, 48.129048 ], [ -122.486736, 48.120950 ], [ -122.489986, 48.120617 ], [ -122.512031, 48.133931 ], [ -122.522576, 48.161712 ], [ -122.537220, 48.183745 ], [ -122.538916, 48.209683 ], [ -122.534431, 48.223005 ], [ -122.535209, 48.240213 ], [ -122.530996, 48.249821 ], [ -122.503786, 48.257045 ], [ -122.499648, 48.256611 ], [ -122.497727, 48.253389 ], [ -122.493448, 48.252043 ], [ -122.480925, 48.251706 ], [ -122.474494, 48.255227 ], [ -122.466803, 48.269604 ], [ -122.463962, 48.270541 ], [ -122.406516, 48.251830 ], [ -122.405757, 48.252193 ], [ -122.395328, 48.257187 ], [ -122.392058, 48.269628 ], [ -122.371693, 48.287839 ], [ -122.376818, 48.296099 ], [ -122.378210, 48.297590 ], [ -122.384310, 48.304123 ], [ -122.408718, 48.326413 ], [ -122.424102, 48.334346 ], [ -122.442678, 48.337934 ], [ -122.475529, 48.359912 ], [ -122.482423, 48.361737 ], [ -122.497686, 48.361837 ], [ -122.507437, 48.364666 ], [ -122.533452, 48.383409 ], [ -122.539449, 48.397190 ], [ -122.547492, 48.399889 ], [ -122.554536, 48.406040 ], [ -122.558403, 48.426758 ], [ -122.551221, 48.439465 ], [ -122.557298, 48.444438 ], [ -122.568348, 48.444990 ], [ -122.575254, 48.443333 ], [ -122.581607, 48.429244 ], [ -122.614480, 48.414880 ], [ -122.649839, 48.408526 ], [ -122.665338, 48.416453 ], [ -122.674158, 48.424726 ], [ -122.678928, 48.439466 ], [ -122.677072, 48.444059 ], [ -122.674188, 48.443327 ], [ -122.674085, 48.441979 ], [ -122.667249, 48.442503 ], [ -122.654844, 48.454087 ], [ -122.657753, 48.472940 ], [ -122.664623, 48.478128 ], [ -122.689121, 48.476849 ], [ -122.695725, 48.464785 ], [ -122.695587, 48.460558 ], [ -122.700603, 48.457632 ], [ -122.710362, 48.461584 ], [ -122.712322, 48.464143 ], [ -122.712981, 48.478790 ], [ -122.701644, 48.497622 ], [ -122.684521, 48.509123 ], [ -122.679122, 48.507797 ], [ -122.676922, 48.504484 ], [ -122.671386, 48.503980 ], [ -122.615183, 48.521427 ], [ -122.606961, 48.522152 ], [ -122.599951, 48.520946 ], [ -122.598469, 48.512169 ], [ -122.568071, 48.508210 ], [ -122.556834, 48.498812 ], [ -122.537355, 48.466749 ], [ -122.532845, 48.466057 ], [ -122.526943, 48.468004 ], [ -122.515056, 48.465554 ], [ -122.511348, 48.461825 ], [ -122.500721, 48.460887 ], [ -122.471832, 48.470724 ], [ -122.469634, 48.472187 ], [ -122.469670, 48.474975 ], [ -122.473763, 48.479750 ], [ -122.478851, 48.481736 ], [ -122.483501, 48.492430 ], [ -122.484996, 48.509620 ], [ -122.483872, 48.521891 ], [ -122.485288, 48.528106 ], [ -122.498463, 48.556206 ], [ -122.504428, 48.564775 ], [ -122.525370, 48.567344 ], [ -122.531978, 48.568644 ], [ -122.534719, 48.574246 ], [ -122.534787, 48.575960 ], [ -122.512372, 48.578067 ], [ -122.495904, 48.575927 ], [ -122.488421, 48.564665 ], [ -122.482406, 48.559653 ], [ -122.478431, 48.559303 ], [ -122.444560, 48.570115 ], [ -122.433059, 48.581609 ], [ -122.425271, 48.599522 ], [ -122.448702, 48.622624 ], [ -122.464250, 48.625717 ], [ -122.486878, 48.643122 ], [ -122.488754, 48.645358 ], [ -122.493990, 48.651596 ], [ -122.500308, 48.656163 ], [ -122.506718, 48.669692 ], [ -122.519172, 48.713095 ], [ -122.515511, 48.720992 ], [ -122.505684, 48.724524 ], [ -122.495301, 48.737328 ], [ -122.490401, 48.751128 ], [ -122.510902, 48.757728 ], [ -122.528203, 48.768428 ], [ -122.535803, 48.776128 ], [ -122.567498, 48.779185 ], [ -122.596844, 48.771492 ], [ -122.598033, 48.769489 ], [ -122.606787, 48.759143 ], [ -122.627808, 48.744660 ], [ -122.637146, 48.735708 ], [ -122.638082, 48.732486 ], [ -122.626287, 48.720930 ], [ -122.612562, 48.714932 ], [ -122.605733, 48.701066 ], [ -122.606105, 48.698556 ], [ -122.615169, 48.693839 ], [ -122.620338, 48.693651 ], [ -122.630422, 48.696625 ], [ -122.646323, 48.708001 ], [ -122.673472, 48.733082 ], [ -122.666953, 48.748445 ], [ -122.661111, 48.753962 ], [ -122.647443, 48.773998 ], [ -122.645743, 48.781538 ], [ -122.646777, 48.785011 ], [ -122.656528, 48.784969 ], [ -122.659708, 48.786523 ], [ -122.680246, 48.802750 ], [ -122.693683, 48.804475 ], [ -122.697219, 48.802810 ], [ -122.698675, 48.800522 ], [ -122.699507, 48.794906 ], [ -122.699303, 48.789063 ], [ -122.703106, 48.786321 ], [ -122.709815, 48.786205 ], [ -122.711200, 48.791460 ], [ -122.709169, 48.817829 ], [ -122.711805, 48.832408 ], [ -122.717073, 48.847190 ], [ -122.722685, 48.852855 ], [ -122.785659, 48.885066 ], [ -122.793175, 48.892927 ], [ -122.792584, 48.894732 ], [ -122.783747, 48.894639 ], [ -122.751289, 48.911239 ], [ -122.747514, 48.915582 ], [ -122.745371, 48.921227 ], [ -122.746596, 48.930731 ], [ -122.755624, 48.938660 ], [ -122.766096, 48.941955 ], [ -122.770432, 48.942528 ], [ -122.787539, 48.931702 ], [ -122.818232, 48.939062 ], [ -122.821631, 48.941369 ], [ -122.822464, 48.944911 ], [ -122.817226, 48.955970 ], [ -122.796887, 48.975026 ], [ -122.774276, 48.991038 ], [ -122.766307, 48.991672 ], [ -122.756318, 48.996881 ], [ -122.756037, 48.999512 ], [ -122.758020, 49.002357 ], [ -122.407829, 49.002193 ], [ -122.405989, 49.002239 ], [ -122.098357, 49.002146 ], [ -121.751252, 48.997399 ], [ -121.126240, 49.001412 ], [ -120.851202, 49.001191 ], [ -119.702016, 49.000269 ], [ -119.701218, 49.000258 ], [ -119.457700, 49.000261 ], [ -119.428678, 49.000253 ], [ -119.137274, 49.000297 ], [ -119.132102, 49.000262 ], [ -118.836794, 49.000209 ], [ -118.196891, 49.000094 ], [ -117.429539, 48.999957 ], [ -117.268192, 48.999928 ], [ -117.268247, 48.999818 ], [ -117.032351, 48.999188 ], [ -117.033177, 48.846563 ], [ -117.034358, 48.628523 ], [ -117.034499, 48.620769 ], [ -117.035285, 48.430113 ], [ -117.035285, 48.429816 ], [ -117.035254, 48.423144 ], [ -117.035289, 48.422732 ], [ -117.035178, 48.371221 ], [ -117.035178, 48.370878 ], [ -117.039599, 48.184387 ], [ -117.039615, 48.184015 ], [ -117.039582, 48.181124 ], [ -117.039582, 48.180853 ], [ -117.039583, 48.180313 ], [ -117.039618, 48.178142 ], [ -117.039413, 48.177250 ], [ -117.039552, 48.173960 ], [ -117.041401, 48.085500 ], [ -117.041676, 48.045560 ], [ -117.041874, 47.977387 ], [ -117.042485, 47.766525 ], [ -117.042521, 47.764896 ], [ -117.042623, 47.761223 ], [ -117.042657, 47.760857 ], [ -117.042059, 47.745100 ], [ -117.042135, 47.744100 ], [ -117.041678, 47.722710 ], [ -117.041633, 47.706400 ], [ -117.041532, 47.683194 ], [ -117.041431, 47.680000 ], [ -117.041431, 47.678185 ], [ -117.041431, 47.678140 ], [ -117.041174, 47.558530 ], [ -117.041276, 47.558210 ], [ -117.040745, 47.532909 ], [ -117.040545, 47.527562 ], [ -117.040514, 47.522351 ], [ -117.039945, 47.477823 ], [ -117.039971, 47.463309 ], [ -117.039948, 47.434885 ], [ -117.039950, 47.412412 ], [ -117.039882, 47.399085 ], [ -117.039857, 47.366093 ], [ -117.039843, 47.347201 ], [ -117.040019, 47.259272 ], [ -117.039899, 47.225515 ], [ -117.039888, 47.203282 ], [ -117.039871, 47.181858 ], [ -117.039836, 47.154734 ], [ -117.039821, 47.127265 ], [ -117.039657, 46.825798 ], [ -117.039828, 46.815443 ], [ -117.039783, 46.541785 ], [ -117.039771, 46.471779 ], [ -117.039763, 46.469570 ], [ -117.039741, 46.462704 ], [ -117.039813, 46.425425 ], [ -117.046915, 46.379577 ], [ -117.061045, 46.367747 ], [ -117.047469, 46.342884 ], [ -116.987939, 46.298031 ], [ -116.985333, 46.294617 ], [ -116.958801, 46.242320 ], [ -116.925621, 46.158888 ], [ -116.943530, 46.062173 ], [ -116.915989, 45.995413 ], [ -117.212616, 45.998321 ], [ -117.214534, 45.998320 ], [ -117.216731, 45.998356 ], [ -117.475148, 45.997893 ], [ -117.475360, 45.997855 ], [ -117.480103, 45.997870 ], [ -117.480130, 45.997870 ], [ -117.504833, 45.998317 ], [ -117.603163, 45.998887 ], [ -117.977766,