/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2009-2014 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2014 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/

package org.opennms.features.topology.app.internal.support;

import java.util.ArrayList;

import org.junit.Assert;
import org.junit.Test;
import org.opennms.features.topology.api.topo.DefaultVertexRef;
import org.opennms.features.topology.api.topo.VertexRef;

import com.google.common.collect.Lists;

public class LayoutManagerTest {
    
    @Test
    public void testHash() {
        ArrayList<VertexRef> defaultVertexRefs = Lists.newArrayList(
                new DefaultVertexRef("namespace1", "id1", "Label 1"),
                new DefaultVertexRef("namespace2", "id2", "Label 2"),
                new DefaultVertexRef("namespace3", "id3", "Label 3"));

        String hash1 = LayoutManager.calculateHash(defaultVertexRefs);
        String hash2 = LayoutManager.calculateHash(defaultVertexRefs);
        Assert.assertEquals(hash1, hash2);
    }

}