/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2017-2017 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2017 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/
package org.opennms.netmgt.telemetry.adapters.jti.proto;

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: lsp_stats.proto

public final class LspStatsOuterClass {
  private LspStatsOuterClass() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registry.add(LspStatsOuterClass.jnprLspStatisticsExt);
  }
  public interface LspStatsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:LspStats)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
     *
     * <pre>
     * List of LSP statistics records
     * </pre>
     */
    java.util.List<LspStatsOuterClass.LspStatsRecord> 
        getLspStatsRecordsList();
    /**
     * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
     *
     * <pre>
     * List of LSP statistics records
     * </pre>
     */
    LspStatsOuterClass.LspStatsRecord getLspStatsRecords(int index);
    /**
     * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
     *
     * <pre>
     * List of LSP statistics records
     * </pre>
     */
    int getLspStatsRecordsCount();
    /**
     * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
     *
     * <pre>
     * List of LSP statistics records
     * </pre>
     */
    java.util.List<? extends LspStatsOuterClass.LspStatsRecordOrBuilder> 
        getLspStatsRecordsOrBuilderList();
    /**
     * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
     *
     * <pre>
     * List of LSP statistics records
     * </pre>
     */
    LspStatsOuterClass.LspStatsRecordOrBuilder getLspStatsRecordsOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code LspStats}
   *
   * <pre>
   * Top-level message
   * </pre>
   */
  public static final class LspStats extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:LspStats)
      LspStatsOrBuilder {
    // Use LspStats.newBuilder() to construct.
    private LspStats(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private LspStats(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final LspStats defaultInstance;
    public static LspStats getDefaultInstance() {
      return defaultInstance;
    }

    public LspStats getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private LspStats(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                lspStatsRecords_ = new java.util.ArrayList<LspStatsOuterClass.LspStatsRecord>();
                mutable_bitField0_ |= 0x00000001;
              }
              lspStatsRecords_.add(input.readMessage(LspStatsOuterClass.LspStatsRecord.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          lspStatsRecords_ = java.util.Collections.unmodifiableList(lspStatsRecords_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return LspStatsOuterClass.internal_static_LspStats_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return LspStatsOuterClass.internal_static_LspStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              LspStatsOuterClass.LspStats.class, LspStatsOuterClass.LspStats.Builder.class);
    }

    public static com.google.protobuf.Parser<LspStats> PARSER =
        new com.google.protobuf.AbstractParser<LspStats>() {
      public LspStats parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new LspStats(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<LspStats> getParserForType() {
      return PARSER;
    }

    public static final int LSP_STATS_RECORDS_FIELD_NUMBER = 1;
    private java.util.List<LspStatsOuterClass.LspStatsRecord> lspStatsRecords_;
    /**
     * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
     *
     * <pre>
     * List of LSP statistics records
     * </pre>
     */
    public java.util.List<LspStatsOuterClass.LspStatsRecord> getLspStatsRecordsList() {
      return lspStatsRecords_;
    }
    /**
     * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
     *
     * <pre>
     * List of LSP statistics records
     * </pre>
     */
    public java.util.List<? extends LspStatsOuterClass.LspStatsRecordOrBuilder> 
        getLspStatsRecordsOrBuilderList() {
      return lspStatsRecords_;
    }
    /**
     * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
     *
     * <pre>
     * List of LSP statistics records
     * </pre>
     */
    public int getLspStatsRecordsCount() {
      return lspStatsRecords_.size();
    }
    /**
     * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
     *
     * <pre>
     * List of LSP statistics records
     * </pre>
     */
    public LspStatsOuterClass.LspStatsRecord getLspStatsRecords(int index) {
      return lspStatsRecords_.get(index);
    }
    /**
     * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
     *
     * <pre>
     * List of LSP statistics records
     * </pre>
     */
    public LspStatsOuterClass.LspStatsRecordOrBuilder getLspStatsRecordsOrBuilder(
        int index) {
      return lspStatsRecords_.get(index);
    }

    private void initFields() {
      lspStatsRecords_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getLspStatsRecordsCount(); i++) {
        if (!getLspStatsRecords(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      for (int i = 0; i < lspStatsRecords_.size(); i++) {
        output.writeMessage(1, lspStatsRecords_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < lspStatsRecords_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, lspStatsRecords_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static LspStatsOuterClass.LspStats parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LspStatsOuterClass.LspStats parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LspStatsOuterClass.LspStats parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LspStatsOuterClass.LspStats parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LspStatsOuterClass.LspStats parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LspStatsOuterClass.LspStats parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static LspStatsOuterClass.LspStats parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static LspStatsOuterClass.LspStats parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static LspStatsOuterClass.LspStats parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LspStatsOuterClass.LspStats parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(LspStatsOuterClass.LspStats prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code LspStats}
     *
     * <pre>
     * Top-level message
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:LspStats)
        LspStatsOuterClass.LspStatsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return LspStatsOuterClass.internal_static_LspStats_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return LspStatsOuterClass.internal_static_LspStats_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                LspStatsOuterClass.LspStats.class, LspStatsOuterClass.LspStats.Builder.class);
      }

      // Construct using LspStatsOuterClass.LspStats.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getLspStatsRecordsFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (lspStatsRecordsBuilder_ == null) {
          lspStatsRecords_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          lspStatsRecordsBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return LspStatsOuterClass.internal_static_LspStats_descriptor;
      }

      public LspStatsOuterClass.LspStats getDefaultInstanceForType() {
        return LspStatsOuterClass.LspStats.getDefaultInstance();
      }

      public LspStatsOuterClass.LspStats build() {
        LspStatsOuterClass.LspStats result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public LspStatsOuterClass.LspStats buildPartial() {
        LspStatsOuterClass.LspStats result = new LspStatsOuterClass.LspStats(this);
        int from_bitField0_ = bitField0_;
        if (lspStatsRecordsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            lspStatsRecords_ = java.util.Collections.unmodifiableList(lspStatsRecords_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.lspStatsRecords_ = lspStatsRecords_;
        } else {
          result.lspStatsRecords_ = lspStatsRecordsBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof LspStatsOuterClass.LspStats) {
          return mergeFrom((LspStatsOuterClass.LspStats)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(LspStatsOuterClass.LspStats other) {
        if (other == LspStatsOuterClass.LspStats.getDefaultInstance()) return this;
        if (lspStatsRecordsBuilder_ == null) {
          if (!other.lspStatsRecords_.isEmpty()) {
            if (lspStatsRecords_.isEmpty()) {
              lspStatsRecords_ = other.lspStatsRecords_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureLspStatsRecordsIsMutable();
              lspStatsRecords_.addAll(other.lspStatsRecords_);
            }
            onChanged();
          }
        } else {
          if (!other.lspStatsRecords_.isEmpty()) {
            if (lspStatsRecordsBuilder_.isEmpty()) {
              lspStatsRecordsBuilder_.dispose();
              lspStatsRecordsBuilder_ = null;
              lspStatsRecords_ = other.lspStatsRecords_;
              bitField0_ = (bitField0_ & ~0x00000001);
              lspStatsRecordsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getLspStatsRecordsFieldBuilder() : null;
            } else {
              lspStatsRecordsBuilder_.addAllMessages(other.lspStatsRecords_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        for (int i = 0; i < getLspStatsRecordsCount(); i++) {
          if (!getLspStatsRecords(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        LspStatsOuterClass.LspStats parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (LspStatsOuterClass.LspStats) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<LspStatsOuterClass.LspStatsRecord> lspStatsRecords_ =
        java.util.Collections.emptyList();
      private void ensureLspStatsRecordsIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          lspStatsRecords_ = new java.util.ArrayList<LspStatsOuterClass.LspStatsRecord>(lspStatsRecords_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          LspStatsOuterClass.LspStatsRecord, LspStatsOuterClass.LspStatsRecord.Builder, LspStatsOuterClass.LspStatsRecordOrBuilder> lspStatsRecordsBuilder_;

      /**
       * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
       *
       * <pre>
       * List of LSP statistics records
       * </pre>
       */
      public java.util.List<LspStatsOuterClass.LspStatsRecord> getLspStatsRecordsList() {
        if (lspStatsRecordsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(lspStatsRecords_);
        } else {
          return lspStatsRecordsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
       *
       * <pre>
       * List of LSP statistics records
       * </pre>
       */
      public int getLspStatsRecordsCount() {
        if (lspStatsRecordsBuilder_ == null) {
          return lspStatsRecords_.size();
        } else {
          return lspStatsRecordsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
       *
       * <pre>
       * List of LSP statistics records
       * </pre>
       */
      public LspStatsOuterClass.LspStatsRecord getLspStatsRecords(int index) {
        if (lspStatsRecordsBuilder_ == null) {
          return lspStatsRecords_.get(index);
        } else {
          return lspStatsRecordsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
       *
       * <pre>
       * List of LSP statistics records
       * </pre>
       */
      public Builder setLspStatsRecords(
          int index, LspStatsOuterClass.LspStatsRecord value) {
        if (lspStatsRecordsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLspStatsRecordsIsMutable();
          lspStatsRecords_.set(index, value);
          onChanged();
        } else {
          lspStatsRecordsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
       *
       * <pre>
       * List of LSP statistics records
       * </pre>
       */
      public Builder setLspStatsRecords(
          int index, LspStatsOuterClass.LspStatsRecord.Builder builderForValue) {
        if (lspStatsRecordsBuilder_ == null) {
          ensureLspStatsRecordsIsMutable();
          lspStatsRecords_.set(index, builderForValue.build());
          onChanged();
        } else {
          lspStatsRecordsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
       *
       * <pre>
       * List of LSP statistics records
       * </pre>
       */
      public Builder addLspStatsRecords(LspStatsOuterClass.LspStatsRecord value) {
        if (lspStatsRecordsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLspStatsRecordsIsMutable();
          lspStatsRecords_.add(value);
          onChanged();
        } else {
          lspStatsRecordsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
       *
       * <pre>
       * List of LSP statistics records
       * </pre>
       */
      public Builder addLspStatsRecords(
          int index, LspStatsOuterClass.LspStatsRecord value) {
        if (lspStatsRecordsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLspStatsRecordsIsMutable();
          lspStatsRecords_.add(index, value);
          onChanged();
        } else {
          lspStatsRecordsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
       *
       * <pre>
       * List of LSP statistics records
       * </pre>
       */
      public Builder addLspStatsRecords(
          LspStatsOuterClass.LspStatsRecord.Builder builderForValue) {
        if (lspStatsRecordsBuilder_ == null) {
          ensureLspStatsRecordsIsMutable();
          lspStatsRecords_.add(builderForValue.build());
          onChanged();
        } else {
          lspStatsRecordsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
       *
       * <pre>
       * List of LSP statistics records
       * </pre>
       */
      public Builder addLspStatsRecords(
          int index, LspStatsOuterClass.LspStatsRecord.Builder builderForValue) {
        if (lspStatsRecordsBuilder_ == null) {
          ensureLspStatsRecordsIsMutable();
          lspStatsRecords_.add(index, builderForValue.build());
          onChanged();
        } else {
          lspStatsRecordsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
       *
       * <pre>
       * List of LSP statistics records
       * </pre>
       */
      public Builder addAllLspStatsRecords(
          java.lang.Iterable<? extends LspStatsOuterClass.LspStatsRecord> values) {
        if (lspStatsRecordsBuilder_ == null) {
          ensureLspStatsRecordsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, lspStatsRecords_);
          onChanged();
        } else {
          lspStatsRecordsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
       *
       * <pre>
       * List of LSP statistics records
       * </pre>
       */
      public Builder clearLspStatsRecords() {
        if (lspStatsRecordsBuilder_ == null) {
          lspStatsRecords_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          lspStatsRecordsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
       *
       * <pre>
       * List of LSP statistics records
       * </pre>
       */
      public Builder removeLspStatsRecords(int index) {
        if (lspStatsRecordsBuilder_ == null) {
          ensureLspStatsRecordsIsMutable();
          lspStatsRecords_.remove(index);
          onChanged();
        } else {
          lspStatsRecordsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
       *
       * <pre>
       * List of LSP statistics records
       * </pre>
       */
      public LspStatsOuterClass.LspStatsRecord.Builder getLspStatsRecordsBuilder(
          int index) {
        return getLspStatsRecordsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
       *
       * <pre>
       * List of LSP statistics records
       * </pre>
       */
      public LspStatsOuterClass.LspStatsRecordOrBuilder getLspStatsRecordsOrBuilder(
          int index) {
        if (lspStatsRecordsBuilder_ == null) {
          return lspStatsRecords_.get(index);  } else {
          return lspStatsRecordsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
       *
       * <pre>
       * List of LSP statistics records
       * </pre>
       */
      public java.util.List<? extends LspStatsOuterClass.LspStatsRecordOrBuilder> 
           getLspStatsRecordsOrBuilderList() {
        if (lspStatsRecordsBuilder_ != null) {
          return lspStatsRecordsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(lspStatsRecords_);
        }
      }
      /**
       * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
       *
       * <pre>
       * List of LSP statistics records
       * </pre>
       */
      public LspStatsOuterClass.LspStatsRecord.Builder addLspStatsRecordsBuilder() {
        return getLspStatsRecordsFieldBuilder().addBuilder(
            LspStatsOuterClass.LspStatsRecord.getDefaultInstance());
      }
      /**
       * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
       *
       * <pre>
       * List of LSP statistics records
       * </pre>
       */
      public LspStatsOuterClass.LspStatsRecord.Builder addLspStatsRecordsBuilder(
          int index) {
        return getLspStatsRecordsFieldBuilder().addBuilder(
            index, LspStatsOuterClass.LspStatsRecord.getDefaultInstance());
      }
      /**
       * <code>repeated .LspStatsRecord lsp_stats_records = 1;</code>
       *
       * <pre>
       * List of LSP statistics records
       * </pre>
       */
      public java.util.List<LspStatsOuterClass.LspStatsRecord.Builder> 
           getLspStatsRecordsBuilderList() {
        return getLspStatsRecordsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          LspStatsOuterClass.LspStatsRecord, LspStatsOuterClass.LspStatsRecord.Builder, LspStatsOuterClass.LspStatsRecordOrBuilder> 
          getLspStatsRecordsFieldBuilder() {
        if (lspStatsRecordsBuilder_ == null) {
          lspStatsRecordsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              LspStatsOuterClass.LspStatsRecord, LspStatsOuterClass.LspStatsRecord.Builder, LspStatsOuterClass.LspStatsRecordOrBuilder>(
                  lspStatsRecords_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          lspStatsRecords_ = null;
        }
        return lspStatsRecordsBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:LspStats)
    }

    static {
      defaultInstance = new LspStats(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:LspStats)
  }

  public interface LspStatsRecordOrBuilder extends
      // @@protoc_insertion_point(interface_extends:LspStatsRecord)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * Name of the LSP
     * </pre>
     */
    boolean hasName();
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * Name of the LSP
     * </pre>
     */
    java.lang.String getName();
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * Name of the LSP
     * </pre>
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <code>required uint32 instance_identifier = 2;</code>
     *
     * <pre>
     * Instance Identifier for cases when RPD creates multiple instances
     * </pre>
     */
    boolean hasInstanceIdentifier();
    /**
     * <code>required uint32 instance_identifier = 2;</code>
     *
     * <pre>
     * Instance Identifier for cases when RPD creates multiple instances
     * </pre>
     */
    int getInstanceIdentifier();

    /**
     * <code>required string counter_name = 3;</code>
     *
     * <pre>
     * Name of the counter. This is useful when an LSP has multiple counters.
     * When an LSP is resignalled, it is possible that a new counter is
     * created in the hardware.
     * </pre>
     */
    boolean hasCounterName();
    /**
     * <code>required string counter_name = 3;</code>
     *
     * <pre>
     * Name of the counter. This is useful when an LSP has multiple counters.
     * When an LSP is resignalled, it is possible that a new counter is
     * created in the hardware.
     * </pre>
     */
    java.lang.String getCounterName();
    /**
     * <code>required string counter_name = 3;</code>
     *
     * <pre>
     * Name of the counter. This is useful when an LSP has multiple counters.
     * When an LSP is resignalled, it is possible that a new counter is
     * created in the hardware.
     * </pre>
     */
    com.google.protobuf.ByteString
        getCounterNameBytes();

    /**
     * <code>optional uint64 packets = 4;</code>
     *
     * <pre>
     * The total number of packets
     * </pre>
     */
    boolean hasPackets();
    /**
     * <code>optional uint64 packets = 4;</code>
     *
     * <pre>
     * The total number of packets
     * </pre>
     */
    long getPackets();

    /**
     * <code>optional uint64 bytes = 5;</code>
     *
     * <pre>
     * The total number of bytes
     * </pre>
     */
    boolean hasBytes();
    /**
     * <code>optional uint64 bytes = 5;</code>
     *
     * <pre>
     * The total number of bytes
     * </pre>
     */
    long getBytes();

    /**
     * <code>optional uint64 packet_rate = 6;</code>
     *
     * <pre>
     * Packet rate computed over the most recent 3 second interval
     * </pre>
     */
    boolean hasPacketRate();
    /**
     * <code>optional uint64 packet_rate = 6;</code>
     *
     * <pre>
     * Packet rate computed over the most recent 3 second interval
     * </pre>
     */
    long getPacketRate();

    /**
     * <code>optional uint64 byte_rate = 7;</code>
     *
     * <pre>
     * Byte rate computed over the most recent 3 second interval
     * </pre>
     */
    boolean hasByteRate();
    /**
     * <code>optional uint64 byte_rate = 7;</code>
     *
     * <pre>
     * Byte rate computed over the most recent 3 second interval
     * </pre>
     */
    long getByteRate();
  }
  /**
   * Protobuf type {@code LspStatsRecord}
   *
   * <pre>
   * LSP statistics record
   * </pre>
   */
  public static final class LspStatsRecord extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:LspStatsRecord)
      LspStatsRecordOrBuilder {
    // Use LspStatsRecord.newBuilder() to construct.
    private LspStatsRecord(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private LspStatsRecord(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final LspStatsRecord defaultInstance;
    public static LspStatsRecord getDefaultInstance() {
      return defaultInstance;
    }

    public LspStatsRecord getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private LspStatsRecord(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              name_ = bs;
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              instanceIdentifier_ = input.readUInt32();
              break;
            }
            case 26: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000004;
              counterName_ = bs;
              break;
            }
            case 32: {
              bitField0_ |= 0x00000008;
              packets_ = input.readUInt64();
              break;
            }
            case 40: {
              bitField0_ |= 0x00000010;
              bytes_ = input.readUInt64();
              break;
            }
            case 48: {
              bitField0_ |= 0x00000020;
              packetRate_ = input.readUInt64();
              break;
            }
            case 56: {
              bitField0_ |= 0x00000040;
              byteRate_ = input.readUInt64();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return LspStatsOuterClass.internal_static_LspStatsRecord_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return LspStatsOuterClass.internal_static_LspStatsRecord_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              LspStatsOuterClass.LspStatsRecord.class, LspStatsOuterClass.LspStatsRecord.Builder.class);
    }

    public static com.google.protobuf.Parser<LspStatsRecord> PARSER =
        new com.google.protobuf.AbstractParser<LspStatsRecord>() {
      public LspStatsRecord parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new LspStatsRecord(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<LspStatsRecord> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private java.lang.Object name_;
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * Name of the LSP
     * </pre>
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * Name of the LSP
     * </pre>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string name = 1;</code>
     *
     * <pre>
     * Name of the LSP
     * </pre>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INSTANCE_IDENTIFIER_FIELD_NUMBER = 2;
    private int instanceIdentifier_;
    /**
     * <code>required uint32 instance_identifier = 2;</code>
     *
     * <pre>
     * Instance Identifier for cases when RPD creates multiple instances
     * </pre>
     */
    public boolean hasInstanceIdentifier() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>required uint32 instance_identifier = 2;</code>
     *
     * <pre>
     * Instance Identifier for cases when RPD creates multiple instances
     * </pre>
     */
    public int getInstanceIdentifier() {
      return instanceIdentifier_;
    }

    public static final int COUNTER_NAME_FIELD_NUMBER = 3;
    private java.lang.Object counterName_;
    /**
     * <code>required string counter_name = 3;</code>
     *
     * <pre>
     * Name of the counter. This is useful when an LSP has multiple counters.
     * When an LSP is resignalled, it is possible that a new counter is
     * created in the hardware.
     * </pre>
     */
    public boolean hasCounterName() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>required string counter_name = 3;</code>
     *
     * <pre>
     * Name of the counter. This is useful when an LSP has multiple counters.
     * When an LSP is resignalled, it is possible that a new counter is
     * created in the hardware.
     * </pre>
     */
    public java.lang.String getCounterName() {
      java.lang.Object ref = counterName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          counterName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string counter_name = 3;</code>
     *
     * <pre>
     * Name of the counter. This is useful when an LSP has multiple counters.
     * When an LSP is resignalled, it is possible that a new counter is
     * created in the hardware.
     * </pre>
     */
    public com.google.protobuf.ByteString
        getCounterNameBytes() {
      java.lang.Object ref = counterName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        counterName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PACKETS_FIELD_NUMBER = 4;
    private long packets_;
    /**
     * <code>optional uint64 packets = 4;</code>
     *
     * <pre>
     * The total number of packets
     * </pre>
     */
    public boolean hasPackets() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional uint64 packets = 4;</code>
     *
     * <pre>
     * The total number of packets
     * </pre>
     */
    public long getPackets() {
      return packets_;
    }

    public static final int BYTES_FIELD_NUMBER = 5;
    private long bytes_;
    /**
     * <code>optional uint64 bytes = 5;</code>
     *
     * <pre>
     * The total number of bytes
     * </pre>
     */
    public boolean hasBytes() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional uint64 bytes = 5;</code>
     *
     * <pre>
     * The total number of bytes
     * </pre>
     */
    public long getBytes() {
      return bytes_;
    }

    public static final int PACKET_RATE_FIELD_NUMBER = 6;
    private long packetRate_;
    /**
     * <code>optional uint64 packet_rate = 6;</code>
     *
     * <pre>
     * Packet rate computed over the most recent 3 second interval
     * </pre>
     */
    public boolean hasPacketRate() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional uint64 packet_rate = 6;</code>
     *
     * <pre>
     * Packet rate computed over the most recent 3 second interval
     * </pre>
     */
    public long getPacketRate() {
      return packetRate_;
    }

    public static final int BYTE_RATE_FIELD_NUMBER = 7;
    private long byteRate_;
    /**
     * <code>optional uint64 byte_rate = 7;</code>
     *
     * <pre>
     * Byte rate computed over the most recent 3 second interval
     * </pre>
     */
    public boolean hasByteRate() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     * <code>optional uint64 byte_rate = 7;</code>
     *
     * <pre>
     * Byte rate computed over the most recent 3 second interval
     * </pre>
     */
    public long getByteRate() {
      return byteRate_;
    }

    private void initFields() {
      name_ = "";
      instanceIdentifier_ = 0;
      counterName_ = "";
      packets_ = 0L;
      bytes_ = 0L;
      packetRate_ = 0L;
      byteRate_ = 0L;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasName()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasInstanceIdentifier()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasCounterName()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeUInt32(2, instanceIdentifier_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeBytes(3, getCounterNameBytes());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeUInt64(4, packets_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeUInt64(5, bytes_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeUInt64(6, packetRate_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeUInt64(7, byteRate_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(2, instanceIdentifier_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(3, getCounterNameBytes());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(4, packets_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(5, bytes_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(6, packetRate_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(7, byteRate_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static LspStatsOuterClass.LspStatsRecord parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LspStatsOuterClass.LspStatsRecord parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LspStatsOuterClass.LspStatsRecord parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static LspStatsOuterClass.LspStatsRecord parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static LspStatsOuterClass.LspStatsRecord parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LspStatsOuterClass.LspStatsRecord parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static LspStatsOuterClass.LspStatsRecord parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static LspStatsOuterClass.LspStatsRecord parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static LspStatsOuterClass.LspStatsRecord parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static LspStatsOuterClass.LspStatsRecord parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(LspStatsOuterClass.LspStatsRecord prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code LspStatsRecord}
     *
     * <pre>
     * LSP statistics record
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:LspStatsRecord)
        LspStatsOuterClass.LspStatsRecordOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return LspStatsOuterClass.internal_static_LspStatsRecord_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return LspStatsOuterClass.internal_static_LspStatsRecord_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                LspStatsOuterClass.LspStatsRecord.class, LspStatsOuterClass.LspStatsRecord.Builder.class);
      }

      // Construct using LspStatsOuterClass.LspStatsRecord.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        name_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        instanceIdentifier_ = 0;
        bitField0_ = (bitField0_ & ~0x00000002);
        counterName_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        packets_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000008);
        bytes_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000010);
        packetRate_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000020);
        byteRate_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000040);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return LspStatsOuterClass.internal_static_LspStatsRecord_descriptor;
      }

      public LspStatsOuterClass.LspStatsRecord getDefaultInstanceForType() {
        return LspStatsOuterClass.LspStatsRecord.getDefaultInstance();
      }

      public LspStatsOuterClass.LspStatsRecord build() {
        LspStatsOuterClass.LspStatsRecord result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public LspStatsOuterClass.LspStatsRecord buildPartial() {
        LspStatsOuterClass.LspStatsRecord result = new LspStatsOuterClass.LspStatsRecord(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.name_ = name_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.instanceIdentifier_ = instanceIdentifier_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.counterName_ = counterName_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.packets_ = packets_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.bytes_ = bytes_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        result.packetRate_ = packetRate_;
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000040;
        }
        result.byteRate_ = byteRate_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof LspStatsOuterClass.LspStatsRecord) {
          return mergeFrom((LspStatsOuterClass.LspStatsRecord)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(LspStatsOuterClass.LspStatsRecord other) {
        if (other == LspStatsOuterClass.LspStatsRecord.getDefaultInstance()) return this;
        if (other.hasName()) {
          bitField0_ |= 0x00000001;
          name_ = other.name_;
          onChanged();
        }
        if (other.hasInstanceIdentifier()) {
          setInstanceIdentifier(other.getInstanceIdentifier());
        }
        if (other.hasCounterName()) {
          bitField0_ |= 0x00000004;
          counterName_ = other.counterName_;
          onChanged();
        }
        if (other.hasPackets()) {
          setPackets(other.getPackets());
        }
        if (other.hasBytes()) {
          setBytes(other.getBytes());
        }
        if (other.hasPacketRate()) {
          setPacketRate(other.getPacketRate());
        }
        if (other.hasByteRate()) {
          setByteRate(other.getByteRate());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasName()) {
          
          return false;
        }
        if (!hasInstanceIdentifier()) {
          
          return false;
        }
        if (!hasCounterName()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        LspStatsOuterClass.LspStatsRecord parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (LspStatsOuterClass.LspStatsRecord) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * Name of the LSP
       * </pre>
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * Name of the LSP
       * </pre>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            name_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * Name of the LSP
       * </pre>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * Name of the LSP
       * </pre>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * Name of the LSP
       * </pre>
       */
      public Builder clearName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <code>required string name = 1;</code>
       *
       * <pre>
       * Name of the LSP
       * </pre>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }

      private int instanceIdentifier_ ;
      /**
       * <code>required uint32 instance_identifier = 2;</code>
       *
       * <pre>
       * Instance Identifier for cases when RPD creates multiple instances
       * </pre>
       */
      public boolean hasInstanceIdentifier() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>required uint32 instance_identifier = 2;</code>
       *
       * <pre>
       * Instance Identifier for cases when RPD creates multiple instances
       * </pre>
       */
      public int getInstanceIdentifier() {
        return instanceIdentifier_;
      }
      /**
       * <code>required uint32 instance_identifier = 2;</code>
       *
       * <pre>
       * Instance Identifier for cases when RPD creates multiple instances
       * </pre>
       */
      public Builder setInstanceIdentifier(int value) {
        bitField0_ |= 0x00000002;
        instanceIdentifier_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint32 instance_identifier = 2;</code>
       *
       * <pre>
       * Instance Identifier for cases when RPD creates multiple instances
       * </pre>
       */
      public Builder clearInstanceIdentifier() {
        bitField0_ = (bitField0_ & ~0x00000002);
        instanceIdentifier_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object counterName_ = "";
      /**
       * <code>required string counter_name = 3;</code>
       *
       * <pre>
       * Name of the counter. This is useful when an LSP has multiple counters.
       * When an LSP is resignalled, it is possible that a new counter is
       * created in the hardware.
       * </pre>
       */
      public boolean hasCounterName() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>required string counter_name = 3;</code>
       *
       * <pre>
       * Name of the counter. This is useful when an LSP has multiple counters.
       * When an LSP is resignalled, it is possible that a new counter is
       * created in the hardware.
       * </pre>
       */
      public java.lang.String getCounterName() {
        java.lang.Object ref = counterName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            counterName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string counter_name = 3;</code>
       *
       * <pre>
       * Name of the counter. This is useful when an LSP has multiple counters.
       * When an LSP is resignalled, it is possible that a new counter is
       * created in the hardware.
       * </pre>
       */
      public com.google.protobuf.ByteString
          getCounterNameBytes() {
        java.lang.Object ref = counterName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          counterName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string counter_name = 3;</code>
       *
       * <pre>
       * Name of the counter. This is useful when an LSP has multiple counters.
       * When an LSP is resignalled, it is possible that a new counter is
       * created in the hardware.
       * </pre>
       */
      public Builder setCounterName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        counterName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string counter_name = 3;</code>
       *
       * <pre>
       * Name of the counter. This is useful when an LSP has multiple counters.
       * When an LSP is resignalled, it is possible that a new counter is
       * created in the hardware.
       * </pre>
       */
      public Builder clearCounterName() {
        bitField0_ = (bitField0_ & ~0x00000004);
        counterName_ = getDefaultInstance().getCounterName();
        onChanged();
        return this;
      }
      /**
       * <code>required string counter_name = 3;</code>
       *
       * <pre>
       * Name of the counter. This is useful when an LSP has multiple counters.
       * When an LSP is resignalled, it is possible that a new counter is
       * created in the hardware.
       * </pre>
       */
      public Builder setCounterNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        counterName_ = value;
        onChanged();
        return this;
      }

      private long packets_ ;
      /**
       * <code>optional uint64 packets = 4;</code>
       *
       * <pre>
       * The total number of packets
       * </pre>
       */
      public boolean hasPackets() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional uint64 packets = 4;</code>
       *
       * <pre>
       * The total number of packets
       * </pre>
       */
      public long getPackets() {
        return packets_;
      }
      /**
       * <code>optional uint64 packets = 4;</code>
       *
       * <pre>
       * The total number of packets
       * </pre>
       */
      public Builder setPackets(long value) {
        bitField0_ |= 0x00000008;
        packets_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 packets = 4;</code>
       *
       * <pre>
       * The total number of packets
       * </pre>
       */
      public Builder clearPackets() {
        bitField0_ = (bitField0_ & ~0x00000008);
        packets_ = 0L;
        onChanged();
        return this;
      }

      private long bytes_ ;
      /**
       * <code>optional uint64 bytes = 5;</code>
       *
       * <pre>
       * The total number of bytes
       * </pre>
       */
      public boolean hasBytes() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional uint64 bytes = 5;</code>
       *
       * <pre>
       * The total number of bytes
       * </pre>
       */
      public long getBytes() {
        return bytes_;
      }
      /**
       * <code>optional uint64 bytes = 5;</code>
       *
       * <pre>
       * The total number of bytes
       * </pre>
       */
      public Builder setBytes(long value) {
        bitField0_ |= 0x00000010;
        bytes_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 bytes = 5;</code>
       *
       * <pre>
       * The total number of bytes
       * </pre>
       */
      public Builder clearBytes() {
        bitField0_ = (bitField0_ & ~0x00000010);
        bytes_ = 0L;
        onChanged();
        return this;
      }

      private long packetRate_ ;
      /**
       * <code>optional uint64 packet_rate = 6;</code>
       *
       * <pre>
       * Packet rate computed over the most recent 3 second interval
       * </pre>
       */
      public boolean hasPacketRate() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <code>optional uint64 packet_rate = 6;</code>
       *
       * <pre>
       * Packet rate computed over the most recent 3 second interval
       * </pre>
       */
      public long getPacketRate() {
        return packetRate_;
      }
      /**
       * <code>optional uint64 packet_rate = 6;</code>
       *
       * <pre>
       * Packet rate computed over the most recent 3 second interval
       * </pre>
       */
      public Builder setPacketRate(long value) {
        bitField0_ |= 0x00000020;
        packetRate_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 packet_rate = 6;</code>
       *
       * <pre>
       * Packet rate computed over the most recent 3 second interval
       * </pre>
       */
      public Builder clearPacketRate() {
        bitField0_ = (bitField0_ & ~0x00000020);
        packetRate_ = 0L;
        onChanged();
        return this;
      }

      private long byteRate_ ;
      /**
       * <code>optional uint64 byte_rate = 7;</code>
       *
       * <pre>
       * Byte rate computed over the most recent 3 second interval
       * </pre>
       */
      public boolean hasByteRate() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       * <code>optional uint64 byte_rate = 7;</code>
       *
       * <pre>
       * Byte rate computed over the most recent 3 second interval
       * </pre>
       */
      public long getByteRate() {
        return byteRate_;
      }
      /**
       * <code>optional uint64 byte_rate = 7;</code>
       *
       * <pre>
       * Byte rate computed over the most recent 3 second interval
       * </pre>
       */
      public Builder setByteRate(long value) {
        bitField0_ |= 0x00000040;
        byteRate_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 byte_rate = 7;</code>
       *
       * <pre>
       * Byte rate computed over the most recent 3 second interval
       * </pre>
       */
      public Builder clearByteRate() {
        bitField0_ = (bitField0_ & ~0x00000040);
        byteRate_ = 0L;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:LspStatsRecord)
    }

    static {
      defaultInstance = new LspStatsRecord(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:LspStatsRecord)
  }

  public static final int JNPR_LSP_STATISTICS_EXT_FIELD_NUMBER = 5;
  /**
   * <code>extend .JuniperNetworksSensors { ... }</code>
   */
  public static final
    com.google.protobuf.GeneratedMessage.GeneratedExtension<
      TelemetryTop.JuniperNetworksSensors,
      LspStatsOuterClass.LspStats> jnprLspStatisticsExt = com.google.protobuf.GeneratedMessage
          .newFileScopedGeneratedExtension(
        LspStatsOuterClass.LspStats.class,
        LspStatsOuterClass.LspStats.getDefaultInstance());
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_LspStats_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_LspStats_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_LspStatsRecord_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_LspStatsRecord_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\017lsp_stats.proto\032\023telemetry_top.proto\"6" +
      "\n\010LspStats\022*\n\021lsp_stats_records\030\001 \003(\0132\017." +
      "LspStatsRecord\"\274\001\n\016LspStatsRecord\022\023\n\004nam" +
      "e\030\001 \002(\tB\005\202@\002\010\001\022\"\n\023instance_identifier\030\002 " +
      "\002(\rB\005\202@\002\010\001\022\033\n\014counter_name\030\003 \002(\tB\005\202@\002\010\001\022" +
      "\026\n\007packets\030\004 \001(\004B\005\202@\002\030\001\022\024\n\005bytes\030\005 \001(\004B\005" +
      "\202@\002\030\001\022\023\n\013packet_rate\030\006 \001(\004\022\021\n\tbyte_rate\030" +
      "\007 \001(\004:C\n\027jnpr_lsp_statistics_ext\022\027.Junip" +
      "erNetworksSensors\030\005 \001(\0132\t.LspStats"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          TelemetryTop.getDescriptor(),
        }, assigner);
    internal_static_LspStats_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_LspStats_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_LspStats_descriptor,
        new java.lang.String[] { "LspStatsRecords", });
    internal_static_LspStatsRecord_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_LspStatsRecord_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_LspStatsRecord_descriptor,
        new java.lang.String[] { "Name", "InstanceIdentifier", "CounterName", "Packets", "Bytes", "PacketRate", "ByteRate", });
    jnprLspStatisticsExt.internalInit(descriptor.getExtensions().get(0));
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    registry.add(TelemetryTop.telemetryOptions);
    com.google.protobuf.Descriptors.FileDescriptor
        .internalUpdateFileDescriptor(descriptor, registry);
    TelemetryTop.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
