/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2014 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2014 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/

package org.opennms.netmgt.jmx;

import org.opennms.netmgt.config.collectd.jmx.JmxCollection;
import org.opennms.netmgt.jmx.connection.JmxConnectors;

import java.util.Map;

public class JmxCollectorConfig {

    private JmxConnectors connectionName;

    private String agentAddress;

    private int retries;

    private Map<String, String> serviceProperties;

    private JmxCollection jmxCollection;

    public String getAgentAddress() {
        return agentAddress;
    }

    public void setAgentAddress(String agentAddress) {
        this.agentAddress = agentAddress;
    }

    public Map<String, String> getServiceProperties() {
        return serviceProperties;
    }

    public int getRetries() {
        return retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public JmxConnectors getConnectionName() {
        return connectionName;
    }

    public void setConnectionName(JmxConnectors connectionName) {
        this.connectionName = connectionName;
    }

    public void setServiceProperties(Map<String, String> serviceProperties) {
        this.serviceProperties = serviceProperties;
    }

    public void setJmxCollection(JmxCollection jmxCollection) {
        this.jmxCollection = jmxCollection;
    }

    public JmxCollection getJmxCollection() {
        return jmxCollection;
    }
}
