/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Comparator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import org.apache.mina.util.Base64;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KarafPublickeyAuthenticator
implements PublickeyAuthenticator {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(KarafPublickeyAuthenticator.class);
    private String authorizedKeys;
    private boolean active;
    private Timer parseAuthorizedKeysTimer;
    private AuthorizedKeysProvider authorizedKeysProvider;

    private static final int getInt(byte[] b, int pos) {
        return ((b[pos] & 0xFF) << 24) + ((b[pos + 1] & 0xFF) << 16) + ((b[pos + 2] & 0xFF) << 8) + (b[pos + 3] & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Map<PublicKey, AuthorizedKey> parseAuthorizedKeys(InputStream is) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        try {
            String line;
            Base64 decoder = new Base64();
            KeyFactory rsaKeyGen = KeyFactory.getInstance("RSA");
            KeyFactory dsaKeyGen = KeyFactory.getInstance("DSA");
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(is, "UTF-8"));
            TreeMap<PublicKey, AuthorizedKey> ret = new TreeMap<PublicKey, AuthorizedKey>(new PublicKeyComparator());
            while ((line = reader.readLine()) != null) {
                PublicKey pk;
                int n;
                int pos;
                String[] tokens = line.split("[ \\t]+", 3);
                if (tokens.length != 3) {
                    throw new IOException("Authorized keys file line " + reader.getLineNumber() + " does not contain 3 tokens.");
                }
                byte[] rawKey = decoder.decode(tokens[1].getBytes("UTF-8"));
                if (KarafPublickeyAuthenticator.getInt(rawKey, 0) != 7 || !new String(rawKey, 4, 7, "UTF-8").equals(tokens[0])) {
                    throw new IOException("Authorized keys file line " + reader.getLineNumber() + " contains a key with a format that does not match the first token.");
                }
                if (tokens[0].equals("ssh-dss")) {
                    pos = 11;
                    n = KarafPublickeyAuthenticator.getInt(rawKey, pos);
                    BigInteger p = new BigInteger(1, KarafPublickeyAuthenticator.arraysCopyOfRange(rawKey, pos += 4, pos + n));
                    pos += n;
                    n = KarafPublickeyAuthenticator.getInt(rawKey, pos);
                    BigInteger q = new BigInteger(1, KarafPublickeyAuthenticator.arraysCopyOfRange(rawKey, pos += 4, pos + n));
                    pos += n;
                    n = KarafPublickeyAuthenticator.getInt(rawKey, pos);
                    BigInteger g = new BigInteger(1, KarafPublickeyAuthenticator.arraysCopyOfRange(rawKey, pos += 4, pos + n));
                    pos += n;
                    n = KarafPublickeyAuthenticator.getInt(rawKey, pos);
                    BigInteger y = new BigInteger(1, KarafPublickeyAuthenticator.arraysCopyOfRange(rawKey, pos += 4, pos + n));
                    if ((pos += n) != rawKey.length) {
                        throw new IOException("Authorized keys file line " + reader.getLineNumber() + " contains a DSA key with extra garbage.");
                    }
                    DSAPublicKeySpec ps = new DSAPublicKeySpec(y, p, q, g);
                    pk = dsaKeyGen.generatePublic(ps);
                } else if (tokens[0].equals("ssh-rsa")) {
                    pos = 11;
                    n = KarafPublickeyAuthenticator.getInt(rawKey, pos);
                    BigInteger e = new BigInteger(1, KarafPublickeyAuthenticator.arraysCopyOfRange(rawKey, pos += 4, pos + n));
                    pos += n;
                    n = KarafPublickeyAuthenticator.getInt(rawKey, pos);
                    BigInteger modulus = new BigInteger(1, KarafPublickeyAuthenticator.arraysCopyOfRange(rawKey, pos += 4, pos + n));
                    if ((pos += n) != rawKey.length) {
                        throw new IOException("Authorized keys file line " + reader.getLineNumber() + " contains a RSA key with extra garbage.");
                    }
                    RSAPublicKeySpec ps = new RSAPublicKeySpec(modulus, e);
                    pk = rsaKeyGen.generatePublic(ps);
                } else {
                    throw new IOException("Authorized keys file line " + reader.getLineNumber() + " does not start with ssh-dss or ssh-rsa.");
                }
                ret.put(pk, new AuthorizedKey(tokens[2], tokens[0], pk));
            }
            TreeMap<PublicKey, AuthorizedKey> treeMap = ret;
            return treeMap;
        }
        finally {
            is.close();
        }
    }

    public boolean authenticate(String username, PublicKey publicKey, ServerSession session) {
        AuthorizedKey ak = this.authorizedKeysProvider.getKey(publicKey);
        if (ak == null) {
            LOGGER.error("Failed authenticate of user {} from {} with unknown public key.", (Object)username, (Object)session.getIoSession().getRemoteAddress());
            return false;
        }
        LOGGER.debug("Successful authentication of user {} from {} with public key {}.", new Object[]{username, session.getIoSession().getRemoteAddress(), ak.getAlias()});
        return true;
    }

    public void setAuthorizedKeys(String path) {
        this.authorizedKeys = path;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void startTimer() {
        if (this.active) {
            this.parseAuthorizedKeysTimer = new Timer();
            this.authorizedKeysProvider = new AuthorizedKeysProvider();
            this.parseAuthorizedKeysTimer.schedule((TimerTask)this.authorizedKeysProvider, 10L, 60000L);
        }
    }

    public void stopTimer() {
        if (this.parseAuthorizedKeysTimer != null) {
            this.parseAuthorizedKeysTimer.cancel();
            this.parseAuthorizedKeysTimer = null;
        }
    }

    private static byte[] arraysCopyOfRange(byte[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        byte[] copy = new byte[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AuthorizedKeysProvider
    extends TimerTask {
        private Map<PublicKey, AuthorizedKey> keys;
        private Long lastModificationDate;
        private Boolean fileAvailable;

        private AuthorizedKeysProvider() {
        }

        @Override
        public void run() {
            try {
                File af = new File(KarafPublickeyAuthenticator.this.authorizedKeys);
                if (af.exists()) {
                    Long newModificationDate = af.lastModified();
                    if (this.fileAvailable != null && !this.fileAvailable.booleanValue() || !newModificationDate.equals(this.lastModificationDate)) {
                        LOGGER.debug("Parsing authorized keys file {}...", (Object)KarafPublickeyAuthenticator.this.authorizedKeys);
                        this.fileAvailable = Boolean.TRUE;
                        this.lastModificationDate = newModificationDate;
                        Map<PublicKey, AuthorizedKey> newKeys = KarafPublickeyAuthenticator.parseAuthorizedKeys(new FileInputStream(af));
                        this.setKeys(newKeys);
                        LOGGER.debug("Successfully parsed {} keys from file {}", (Object)newKeys.size(), (Object)KarafPublickeyAuthenticator.this.authorizedKeys);
                    }
                } else {
                    if (this.fileAvailable != null && this.fileAvailable.booleanValue()) {
                        LOGGER.debug("Authorized keys file {} disappeared, will recheck every minute", (Object)KarafPublickeyAuthenticator.this.authorizedKeys);
                    } else if (this.fileAvailable == null) {
                        LOGGER.debug("Authorized keys file {} does not exist, will recheck every minute", (Object)KarafPublickeyAuthenticator.this.authorizedKeys);
                    }
                    this.fileAvailable = Boolean.FALSE;
                    this.lastModificationDate = null;
                    this.setKeys(null);
                }
            }
            catch (Throwable e) {
                LOGGER.error("Error parsing authorized keys file {}", (Object)KarafPublickeyAuthenticator.this.authorizedKeys, (Object)e);
                this.fileAvailable = Boolean.FALSE;
                this.lastModificationDate = null;
                this.setKeys(null);
            }
        }

        private synchronized void setKeys(Map<PublicKey, AuthorizedKey> keys) {
            this.keys = keys;
        }

        public synchronized AuthorizedKey getKey(PublicKey publicKey) {
            if (this.keys == null) {
                return null;
            }
            return this.keys.get(publicKey);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PublicKeyComparator
    implements Comparator<PublicKey> {
        private PublicKeyComparator() {
        }

        @Override
        public int compare(PublicKey a, PublicKey b) {
            if (a instanceof DSAPublicKey) {
                if (b instanceof DSAPublicKey) {
                    DSAPublicKey da = (DSAPublicKey)a;
                    DSAPublicKey db = (DSAPublicKey)b;
                    int r = da.getParams().getG().compareTo(db.getParams().getG());
                    if (r != 0) {
                        return r;
                    }
                    r = da.getParams().getP().compareTo(db.getParams().getP());
                    if (r != 0) {
                        return r;
                    }
                    r = da.getParams().getQ().compareTo(db.getParams().getQ());
                    if (r != 0) {
                        return r;
                    }
                    return da.getY().compareTo(db.getY());
                }
                return -1;
            }
            if (a instanceof RSAPublicKey) {
                if (b instanceof RSAPublicKey) {
                    RSAPublicKey da = (RSAPublicKey)a;
                    RSAPublicKey db = (RSAPublicKey)b;
                    int r = da.getPublicExponent().compareTo(db.getPublicExponent());
                    if (r != 0) {
                        return r;
                    }
                    return da.getModulus().compareTo(db.getModulus());
                }
                return -1;
            }
            throw new IllegalArgumentException("Only RSA and DAS keys are supported.");
        }
    }

    public static final class AuthorizedKey {
        private final String alias;
        private final String format;
        private final PublicKey publicKey;

        public AuthorizedKey(String alias, String format, PublicKey publicKey) {
            this.alias = alias;
            this.format = format;
            this.publicKey = publicKey;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getFormat() {
            return this.format;
        }

        public PublicKey getPublicKey() {
            return this.publicKey;
        }
    }
}

