/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.config.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.karaf.jaas.config.JaasRealm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiConfiguration
extends Configuration {
    private final List<JaasRealm> realms = new CopyOnWriteArrayList<JaasRealm>();

    public void init() {
        Configuration.setConfiguration(this);
    }

    public void close() {
        this.realms.clear();
        Configuration.setConfiguration(null);
    }

    public void register(JaasRealm realm, Map<String, ?> properties) {
        this.realms.add(realm);
    }

    public void unregister(JaasRealm realm, Map<String, ?> properties) {
        this.realms.remove(realm);
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        JaasRealm realm = null;
        for (JaasRealm r : this.realms) {
            if (!r.getName().equals(name) || realm != null && r.getRank() <= realm.getRank()) continue;
            realm = r;
        }
        if (realm != null) {
            return realm.getEntries();
        }
        return null;
    }

    @Override
    public void refresh() {
    }
}

