#!/usr/bin/env node

/* jshint esversion: 6 */

var fs = require('fs-extra');
var os = require('os');
var path = require('path');
var spawn = require('child_process').spawnSync;
var copy = require('recursive-copy');
var rimraf = require('rimraf');
var which = require('which');
var program = require('commander');

var pkginfo = require('./package.json');

try {
  which.sync('dpkg-buildpackage');
} catch (err) {
  console.log('dpkg-buildpackage executable not found');
  process.exit(1);
}

var version = pkginfo.version;
var release = 1;

if (version.indexOf('-SNAPSHOT')) {
  version = version.replace('-SNAPSHOT', '');
  release = 0;
}

 program
   .version(pkginfo.version)
   .option('-r --release <release>', 'Specify release number of package')
   .parse(process.argv);

 if (program.release === undefined) {
   program.release = release;
 }

 pkginfo.version = version;
 pkginfo.release = release;
 release = program.release;

var date = new Date().toUTCString().replace(/ [^ ]+$/, ' +0000');
var changelog = `${pkginfo.name} (${version}-${release}) unstable; urgency=low

  * Autogenerated package.

 -- Benjamin Reed <ranger@opennms.org>  ${date}
`;

var pkgname = pkginfo.name;
var workdir = path.join(process.cwd(), 'dist', 'packages', pkgname);

rimraf.sync(workdir);
fs.mkdirsSync(workdir);
return copy(process.cwd(), workdir, {
  dot: true,
  junk: false,
  filter: [
    '**/*',
    '!.git',
    '!.git/**',
    '!**/*.changes',
    '!**/*.deb',
    '!**/*.dsc',
    '!**/*.tar.gz',
    '!node_modules',
    '!node_modules/**',
    '!dist/packages',
    '!dist/packages/**',
    '!dist/spec',
    '!dist/spec/**',
    '!dist/test',
    '!dist/test/**',
  ]
}).then((results) => {
  console.log(results.length + ' files copied to ' + workdir);

  var debian = path.join(workdir, 'debian');
  fs.mkdirsSync(debian);

  return copy(path.join(process.cwd(), 'src', 'debian'), debian).then((results) => {
    console.log('debian/ directory copied');

    console.log('* writing changelog');
    var fh = fs.openSync(path.join(debian, 'changelog'), 'w+');
    fs.writeSync(fh, changelog);
    fs.closeSync(fh);

    console.log('* running dpkg-buildpackage');
    var ret = spawn('dpkg-buildpackage', [], {
      cwd: workdir,
      stdio: ['inherit', 'inherit', 'inherit'],
    });
    if (ret.error) {
      console.log('dpkg-buildpackage failed');
      process.exit(1);
    }

    rimraf.sync(workdir);

    process.exit(0);
  });
}).catch((error) => {
  console.log('Copy failed: ' + error);
  process.exit(1);
});
