'use strict';

System.register(['lodash'], function (_export, _context) {
  "use strict";

  var _, _createClass, SelectionMgr;

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  return {
    setters: [function (_lodash) {
      _ = _lodash.default;
    }],
    execute: function () {
      _createClass = function () {
        function defineProperties(target, props) {
          for (var i = 0; i < props.length; i++) {
            var descriptor = props[i];
            descriptor.enumerable = descriptor.enumerable || false;
            descriptor.configurable = true;
            if ("value" in descriptor) descriptor.writable = true;
            Object.defineProperty(target, descriptor.key, descriptor);
          }
        }

        return function (Constructor, protoProps, staticProps) {
          if (protoProps) defineProperties(Constructor.prototype, protoProps);
          if (staticProps) defineProperties(Constructor, staticProps);
          return Constructor;
        };
      }();

      _export('SelectionMgr', SelectionMgr = function () {
        function SelectionMgr(getRowsInRange, onSelectionChangeCallback) {
          _classCallCheck(this, SelectionMgr);

          this.clearSelectedRows();
          this.getRowsInRange = getRowsInRange;
          this.onSelectionChangeCallback = onSelectionChangeCallback;
        }

        _createClass(SelectionMgr, [{
          key: 'clearSelectedRows',
          value: function clearSelectedRows() {
            this._selectedRows = new Set();
            this._lastSelectedRow = undefined;
          }
        }, {
          key: 'handleRowClick',
          value: function handleRowClick(row, exclusiveModifier, rangeModifier) {
            var selectedRows = void 0;
            if (!rangeModifier || this._lastSelectedRow === undefined) {
              // No other row was previously selected, use the row that was clicked on
              selectedRows = [row];
            } else {
              // Build the list of rows between the last row that was clicked
              // and the current row
              selectedRows = this.getRowsInRange(this._lastSelectedRow, row);
            }
            this.handleSelection(selectedRows, exclusiveModifier);
          }
        }, {
          key: 'isRowSelected',
          value: function isRowSelected(row) {
            var _iteratorNormalCompletion = true;
            var _didIteratorError = false;
            var _iteratorError = undefined;

            try {
              for (var _iterator = this._selectedRows[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                var selectedRow = _step.value;

                if (_.isEqual(selectedRow, row)) {
                  return true;
                }
              }
            } catch (err) {
              _didIteratorError = true;
              _iteratorError = err;
            } finally {
              try {
                if (!_iteratorNormalCompletion && _iterator.return) {
                  _iterator.return();
                }
              } finally {
                if (_didIteratorError) {
                  throw _iteratorError;
                }
              }
            }

            return false;
          }
        }, {
          key: 'getSelectedRows',
          value: function getSelectedRows() {
            return Array.from(this._selectedRows);
          }
        }, {
          key: 'addRowToSelection',
          value: function addRowToSelection(row) {
            this._selectedRows.add(row);
            this._lastSelectedRow = row;
          }
        }, {
          key: 'handleSelection',
          value: function handleSelection(selectionRows, exclusiveModifier) {
            var _this = this;

            var didSelectionChange = false;
            if (!exclusiveModifier) {
              // Determine the rows we need to add to the selection
              var rowsToAddToSelection = _.filter(selectionRows, function (selectionRow) {
                return !_this.isRowSelected(selectionRow);
              });

              // Determine the rows we need to remove from the selection
              var rowsToRemoveFromSelection = _.filter(this.getSelectedRows(), function (selectedRow) {
                return _.findIndex(selectionRows, function (selectionRow) {
                  return _.isEqual(selectedRow, selectionRow);
                }) < 0;
              });

              if (rowsToRemoveFromSelection.length > 0) {
                // Clear everything and add all the selected rows
                this.clearSelectedRows();
                _.each(selectionRows, function (selectionRow) {
                  return _this.addRowToSelection(selectionRow);
                });
                didSelectionChange = true;
              } else if (rowsToAddToSelection.length > 0) {
                // Add the selected rows
                _.each(rowsToAddToSelection, function (rowToAddToSelection) {
                  return _this.addRowToSelection(rowToAddToSelection);
                });
                didSelectionChange = true;
              }
            } else {
              // Add the rows to the current selection
              _.each(selectionRows, function (selectionRow) {
                if (!_this.isRowSelected(selectionRow)) {
                  _this.addRowToSelection(selectionRow);
                  didSelectionChange = true;
                }
              });
            }

            if (didSelectionChange && this.onSelectionChangeCallback) {
              this.onSelectionChangeCallback();
            }
          }
        }]);

        return SelectionMgr;
      }());

      _export('SelectionMgr', SelectionMgr);
    }
  };
});
//# sourceMappingURL=selection_mgr.js.map
