'use strict';

System.register(['app/plugins/sdk', './css/query-editor.css!', 'lodash', '../../opennms', './Mapping', './UI', './query-directive', './FilterCloner'], function (_export, _context) {
  "use strict";

  var QueryCtrl, _, API, Mapping, UI, FilterCloner, _createClass, OpenNMSFMDatasourceQueryCtrl;

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _possibleConstructorReturn(self, call) {
    if (!self) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }

    return call && (typeof call === "object" || typeof call === "function") ? call : self;
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
    if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
  }

  return {
    setters: [function (_appPluginsSdk) {
      QueryCtrl = _appPluginsSdk.QueryCtrl;
    }, function (_cssQueryEditorCss) {}, function (_lodash) {
      _ = _lodash.default;
    }, function (_opennms) {
      API = _opennms.API;
    }, function (_Mapping) {
      Mapping = _Mapping.Mapping;
    }, function (_UI) {
      UI = _UI.UI;
    }, function (_queryDirective) {}, function (_FilterCloner) {
      FilterCloner = _FilterCloner.FilterCloner;
    }],
    execute: function () {
      _createClass = function () {
        function defineProperties(target, props) {
          for (var i = 0; i < props.length; i++) {
            var descriptor = props[i];
            descriptor.enumerable = descriptor.enumerable || false;
            descriptor.configurable = true;
            if ("value" in descriptor) descriptor.writable = true;
            Object.defineProperty(target, descriptor.key, descriptor);
          }
        }

        return function (Constructor, protoProps, staticProps) {
          if (protoProps) defineProperties(Constructor.prototype, protoProps);
          if (staticProps) defineProperties(Constructor, staticProps);
          return Constructor;
        };
      }();

      _export('OpenNMSFMDatasourceQueryCtrl', OpenNMSFMDatasourceQueryCtrl = function (_QueryCtrl) {
        _inherits(OpenNMSFMDatasourceQueryCtrl, _QueryCtrl);

        function OpenNMSFMDatasourceQueryCtrl($scope, $injector, $q, uiSegmentSrv) {
          _classCallCheck(this, OpenNMSFMDatasourceQueryCtrl);

          var _this = _possibleConstructorReturn(this, (OpenNMSFMDatasourceQueryCtrl.__proto__ || Object.getPrototypeOf(OpenNMSFMDatasourceQueryCtrl)).call(this, $scope, $injector));

          _this.$q = $q;
          _this.$scope = $scope;
          _this.uiSegmentSrv = uiSegmentSrv;
          _this.featuredAttributes = true; // limits the selection to the featured attributes
          _this.filterMapping = new Mapping.FilterMapping(_this.uiSegmentSrv);

          // The target filter may be de-serialized from persistence.
          // In order to re-initialize it properly, the filter is cloned.
          if (_this.target.filter) {
            _this.target.filter = new FilterCloner().cloneFilter(_this.target.filter);
          } else {
            _this.target.filter = new API.Filter();
          }
          _this.uiFilter = _this.filterMapping.getUiFilter(_this.target.filter);
          return _this;
        }

        _createClass(OpenNMSFMDatasourceQueryCtrl, [{
          key: 'toggleEditorMode',
          value: function toggleEditorMode() {
            this.target.rawQuery = !this.target.rawQuery;
          }
        }, {
          key: 'onChangeInternal',
          value: function onChangeInternal() {
            this.panelCtrl.refresh(); // Asks the panel to refresh data.
          }
        }, {
          key: 'showClearRestrictions',
          value: function showClearRestrictions() {
            var query = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.uiFilter.query;

            var self = this;
            var booleanList = _.map(query.clauses, function (clause) {
              if (clause.restriction instanceof UI.Query) {
                return self.showClearRestrictions(clause.restriction);
              }
              return new UI.Controls.RemoveControl().filter(query, clause);
            });

            return _.reduce(booleanList, function (overall, current) {
              return overall || current;
            }, false);
          }
        }, {
          key: 'clearRestrictions',
          value: function clearRestrictions() {
            this.uiFilter.clear();
            this.uiFilter.updateControls();
            this.updateTargetFilter();
          }
        }, {
          key: 'updateTargetFilter',
          value: function updateTargetFilter() {
            this.target.filter = this.filterMapping.getApiFilter(this.uiFilter);
            this.panelCtrl.refresh();
          }
        }, {
          key: 'getCollapsedText',
          value: function getCollapsedText() {
            var collapsedText = this.uiFilter.getQueryString();
            return collapsedText;
          }
        }, {
          key: 'handleQueryError',
          value: function handleQueryError(err) {
            this.error = err.message || 'Failed to issue metric query';
            return [];
          }
        }]);

        return OpenNMSFMDatasourceQueryCtrl;
      }(QueryCtrl));

      _export('OpenNMSFMDatasourceQueryCtrl', OpenNMSFMDatasourceQueryCtrl);

      OpenNMSFMDatasourceQueryCtrl.templateUrl = 'datasources/fault-ds/partials/query.editor.html';
    }
  };
});
//# sourceMappingURL=query_ctrl.js.map
