/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2011-2014 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2014 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/

package org.opennms.web.rest.v1;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import javax.ws.rs.core.MediaType;

import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.rest.AbstractSpringJerseyRestTestCase;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.web.WebAppConfiguration;

@RunWith(OpenNMSJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration(locations={
        "classpath:/META-INF/opennms/applicationContext-soa.xml",
        "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml",
        "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml",
        "classpath:/META-INF/opennms/applicationContext-dao.xml",
        "classpath*:/META-INF/opennms/component-service.xml",
        "classpath*:/META-INF/opennms/component-dao.xml",
        "classpath:/META-INF/opennms/mockEventIpcManager.xml",
        "file:src/main/webapp/WEB-INF/applicationContext-svclayer.xml",
        "file:src/main/webapp/WEB-INF/applicationContext-cxf-common.xml",
        "classpath:/applicationContext-rest-test.xml"
})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class WebAssetsRestServiceIT extends AbstractSpringJerseyRestTestCase {
    protected void beforeServletStart() throws Exception {
        MockLogAppender.setupLogging();
    }

    @Test
    public void testListAllAssets() throws Exception {
        final MockHttpServletRequest request = createRequest(GET, "/web-assets");
        request.addHeader("Accept", MediaType.APPLICATION_JSON);
        final String json = sendRequest(request, 200);

        final JSONArray obj = new JSONArray(json);
        assertEquals(1, obj.length());
        assertEquals("test-asset", obj.getString(0));
    }

    @Test
    public void testGetAssetResources() throws Exception {
        final MockHttpServletRequest request = createRequest(GET, "/web-assets/test-asset");
        request.addHeader("Accept", MediaType.APPLICATION_JSON);
        final String json = sendRequest(request, 200);

        final JSONArray obj = new JSONArray(json);
        assertEquals(1, obj.length());
        final JSONObject o = obj.getJSONObject(0);
        assertEquals("js", o.getString("type"));
        assertEquals("assets/test.js", o.getString("path"));
    }

    @Test
    public void testGetAssetJsResource() throws Exception {
        final MockHttpServletRequest request = createRequest(GET, "/web-assets/test-asset.js");
        final String js = sendRequest(request, 200);
        assertTrue(js.contains("console.log"));
    }
}
