/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2004-2014 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2014 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/

/* Generated By:JJTree&JavaCC: Do not edit this line. ParseMib.java */
import java.util.Vector;

class ParseMib/*@bgen(jjtree)*/implements ParseMibTreeConstants, ParseMibConstants {/*@bgen(jjtree)*/
  protected static JJTParseMibState jjtree = new JJTParseMibState();
  protected static Token lastObjectIdentifierToken = null;

  public static void main(String[] args) {

    try {
      if (args.length == 0) {
          System.out.println("usage: ParseMib [-debug] files");
          System.out.println("version: " + Version.versionString);
          System.exit(0);
      }

      boolean setDebug = false;
      Vector argsList = new Vector();
      String arg = null;

      for (int i = 0; i < args.length; i++) {
           arg = args[i];
           // System.out.println("arg=#" + args[i] + "#");
           if (arg.equalsIgnoreCase("-debug"))
               setDebug = true;
           else if (arg.equalsIgnoreCase("")) {
               // artifact from shell, ant or error, ignore
           }
           else
               argsList.addElement(arg);
      }

      SimpleNode.setDebug(setDebug);

      SimpleNode n = null;

      boolean firstFile = true;
      ParseMib parser = null;
      for (int i = 0; i < argsList.size(); i++) {
           arg = (String)argsList.elementAt(i);
           if (setDebug) System.out.println("JavaCC Parser:  Reading from file " + arg + " . . .");

           try {
            if (firstFile)
                parser = new ParseMib(new java.io.FileInputStream(arg));
            else
                parser.ReInit(new java.io.FileInputStream(arg));
           } catch (java.io.FileNotFoundException fnf) {
                System.err.println("ERROR: the file '" + arg +
                   "' was not found or is mis-spelled");
                System.exit(Errors.FILE_NOT_FOUND);
           }

           n = parser.Start();
           if (setDebug)
               n.dump("");
           firstFile = false;

           // must be called in this order because the ast is
           // decorated on each walk
           // 1) collectTableInfo
           // 2) collectTableIndexInfo
           // 3) collectSequenceInfo
           // 4) collectOids
           // 5) collectTextualConventionsInfo
           if (setDebug) System.out.println("collect table information");
           n.markNotVisited(); // mark the abstract syntax tree as not visited
           n.collectTableInfo();

           if (setDebug) System.out.println("collect table index information");
           n.markNotVisited(); // mark the abstract syntax tree as not visited
           n.collectTableIndexInfo();

           if (setDebug) System.out.println("collect sequence info information");
           n.markNotVisited(); // mark the abstract syntax tree as not visited
           n.collectSequenceInfo();

           if (setDebug) System.out.println("collect oids");
           n.markNotVisited(); // mark the abstract syntax tree as not visited
           n.collectOids();

           if (setDebug) System.out.println("collect type information");
           n.markNotVisited(); // mark the abstract syntax tree as not visited
           n.collectTextualConventionsInfo();

           // System.out.println("Dumping SymbolTables");
           // n.dumpSymbolTables();

           n.writeOids();
      }

      if (setDebug) System.out.println("Thank you.");
    } catch (Throwable e) {
      System.err.println("Oops.");
      System.err.println(e.getMessage());
      e.printStackTrace();
      System.exit(Errors.UNKNOWN_FATAL);
    }
  }

  static final public SimpleNode Start() throws ParseException {
                      /*@bgen(jjtree) Start */
  SimpleNode jjtn000 = new SimpleNode(JJTSTART);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      MibBegin();
      label_1:
      while (true) {
        if (jj_2_1(3)) {
          ;
        } else {
          break label_1;
        }
        Imports();
      }
      label_2:
      while (true) {
        if (jj_2_2(3)) {
          ;
        } else {
          break label_2;
        }
        if (jj_2_3(3)) {
          Declaration();
        } else if (jj_2_4(3)) {
          SequenceOfVarsOrTextConvention();
        } else if (jj_2_5(3)) {
          Events();
        } else if (jj_2_6(3)) {
          TrapType();
        } else if (jj_2_7(3)) {
          Assignment();
        } else if (jj_2_8(3)) {
          ModuleIdentity();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      End();
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
    throw new Error("Missing return statement in function");
  }

  static final public void MibBegin() throws ParseException {
                   /*@bgen(jjtree) MibBegin */
  SimpleNode jjtn000 = new SimpleNode(JJTMIBBEGIN);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      Expression();
      jj_consume_token(IDENTIFIER);
      jj_consume_token(ASSIGN);
      jj_consume_token(BEGIN);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  static final public void Imports() throws ParseException {
                  /*@bgen(jjtree) Imports */
  SimpleNode jjtn000 = new SimpleNode(JJTIMPORTS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(IMPORTS);
      label_3:
      while (true) {
        label_4:
        while (true) {
          if (jj_2_9(3)) {
            jj_consume_token(IDENTIFIER);
          } else if (jj_2_10(3)) {
            jj_consume_token(OBJECT_TYPE);
          } else if (jj_2_11(3)) {
            jj_consume_token(NOTIFICATION_TYPE_TOKEN);
          } else if (jj_2_12(3)) {
            jj_consume_token(MODULE_IDENTITY_TOKEN);
          } else if (jj_2_13(3)) {
            jj_consume_token(MODULE_COMPLIANCE_TOKEN);
          } else if (jj_2_14(3)) {
            jj_consume_token(OBJECT_GROUP_TOKEN);
          } else if (jj_2_15(3)) {
            jj_consume_token(NOTIFICATION_GROUP_TOKEN);
          } else if (jj_2_16(3)) {
            jj_consume_token(TRAP_TYPE_TOKEN);
          } else if (jj_2_17(3)) {
            jj_consume_token(TEXTUAL_CONVENTION_TOKEN);
          } else if (jj_2_18(3)) {
            jj_consume_token(OBJECT_IDENTITY);
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
          label_5:
          while (true) {
            if (jj_2_19(3)) {
              ;
            } else {
              break label_5;
            }
            jj_consume_token(COMMA);
          }
          if (jj_2_20(3)) {
            ;
          } else {
            break label_4;
          }
        }
        jj_consume_token(FROM);
        jj_consume_token(IDENTIFIER);
        if (jj_2_21(3)) {
          ;
        } else {
          break label_3;
        }
      }
      jj_consume_token(SEMICOLON);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  static final public void ModuleIdentity() throws ParseException {
                         /*@bgen(jjtree) ModuleIdentity */
  SimpleNode jjtn000 = new SimpleNode(JJTMODULEIDENTITY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      ObjectIdentifier();
      jj_consume_token(MODULE_IDENTITY_TOKEN);
      label_6:
      while (true) {
        if (jj_2_22(3)) {
          jj_consume_token(LAST_UPDATED_TOKEN);
          jj_consume_token(DESCRIPTOR_LITERAL);
        } else if (jj_2_23(3)) {
          jj_consume_token(ORGANIZATION_TOKEN);
          jj_consume_token(DESCRIPTOR_LITERAL);
        } else if (jj_2_24(3)) {
          jj_consume_token(DESCRIPTION);
          jj_consume_token(DESCRIPTOR_LITERAL);
        } else if (jj_2_25(3)) {
          jj_consume_token(CONTACT_INFO_TOKEN);
          jj_consume_token(DESCRIPTOR_LITERAL);
        } else if (jj_2_26(3)) {
          jj_consume_token(REVISION_TOKEN);
          jj_consume_token(DESCRIPTOR_LITERAL);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        if (jj_2_27(3)) {
          ;
        } else {
          break label_6;
        }
      }
      jj_consume_token(ASSIGN);
      jj_consume_token(LBRACE);
      ParentObjectIdentifier();
      IntegerOID();
      jj_consume_token(RBRACE);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  static final public void Declaration() throws ParseException {
                               /*@bgen(jjtree) DeclOID */
  SimpleNode jjtn000 = new SimpleNode(JJTDECLOID);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      ObjectIdentifier();
      if (jj_2_75(3)) {
        if (jj_2_28(3)) {
          jj_consume_token(OBJECT_IDENTITY);
        } else if (jj_2_29(3)) {
          jj_consume_token(OBJECT_TYPE);
        } else if (jj_2_30(3)) {
          jj_consume_token(MODULE_COMPLIANCE_TOKEN);
        } else if (jj_2_31(3)) {
          jj_consume_token(OBJECT_GROUP_TOKEN);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_7:
        while (true) {
          if (jj_2_32(3)) {
            ;
          } else {
            break label_7;
          }
          if (jj_2_61(3)) {
            jj_consume_token(STATUS);
            jj_consume_token(IDENTIFIER);
          } else if (jj_2_62(3)) {
            if (jj_2_33(3)) {
              jj_consume_token(DESCRIPTION);
            } else if (jj_2_34(3)) {
              jj_consume_token(REFERENCE_TOKEN);
            } else if (jj_2_35(3)) {
              jj_consume_token(UNITS_TOKEN);
            } else {
              jj_consume_token(-1);
              throw new ParseException();
            }
            jj_consume_token(DESCRIPTOR_LITERAL);
          } else if (jj_2_63(3)) {
            jj_consume_token(DEFVAL_TOKEN);
            if (jj_2_41(3)) {
              jj_consume_token(DESCRIPTOR_LITERAL);
            } else if (jj_2_42(3)) {
              jj_consume_token(LBRACE);
              if (jj_2_36(3)) {
                jj_consume_token(LBRACE);
              } else {
                ;
              }
              label_8:
              while (true) {
                if (jj_2_37(3)) {
                  jj_consume_token(IDENTIFIER);
                } else if (jj_2_38(3)) {
                  jj_consume_token(INTEGER_LITERAL);
                } else {
                  jj_consume_token(-1);
                  throw new ParseException();
                }
                if (jj_2_39(3)) {
                  ;
                } else {
                  break label_8;
                }
              }
              jj_consume_token(RBRACE);
              if (jj_2_40(3)) {
                jj_consume_token(RBRACE);
              } else {
                ;
              }
            } else if (jj_2_43(3)) {
              jj_consume_token(INTEGER_LITERAL);
            } else {
              jj_consume_token(-1);
              throw new ParseException();
            }
          } else if (jj_2_64(3)) {
            jj_consume_token(MODULE_TOKEN);
            jj_consume_token(MANDATORY_GROUPS_TOKEN);
            jj_consume_token(LBRACE);
            label_9:
            while (true) {
              jj_consume_token(IDENTIFIER);
              if (jj_2_44(3)) {
                jj_consume_token(COMMA);
              } else {
                ;
              }
              if (jj_2_45(3)) {
                ;
              } else {
                break label_9;
              }
            }
            jj_consume_token(RBRACE);
          } else if (jj_2_65(3)) {
            jj_consume_token(GROUP_TOKEN);
            jj_consume_token(IDENTIFIER);
          } else if (jj_2_66(3)) {
            jj_consume_token(AUGMENTS_TOKEN);
            jj_consume_token(LBRACE);
            jj_consume_token(IDENTIFIER);
            jj_consume_token(RBRACE);
          } else if (jj_2_67(3)) {
            jj_consume_token(OBJECT_TOKEN);
            jj_consume_token(IDENTIFIER);
          } else if (jj_2_68(3)) {
            jj_consume_token(OBJECTS_TOKEN);
            jj_consume_token(LBRACE);
            label_10:
            while (true) {
              jj_consume_token(IDENTIFIER);
              if (jj_2_46(3)) {
                jj_consume_token(COMMA);
              } else {
                ;
              }
              if (jj_2_47(3)) {
                ;
              } else {
                break label_10;
              }
            }
            jj_consume_token(RBRACE);
          } else if (jj_2_69(3)) {
            jj_consume_token(SYNTAX_TOKEN);
            if (jj_2_54(3)) {
              jj_consume_token(OBJECT_TOKEN);
              jj_consume_token(IDENTIFIER_TOKEN);
            } else if (jj_2_55(3)) {
              jj_consume_token(OCTET_TOKEN);
              jj_consume_token(STRING_TOKEN);
              if (jj_2_48(3)) {
                SizeDeclaration();
              } else {
                ;
              }
            } else if (jj_2_56(3)) {
              TableSequenceOf();
            } else if (jj_2_57(3)) {
              GetTypeIdentifier();
              label_11:
              while (true) {
                if (jj_2_49(3)) {
                  ;
                } else {
                  break label_11;
                }
                if (jj_2_52(3)) {
                  SizeDeclaration();
                } else if (jj_2_53(3)) {
                  jj_consume_token(LBRACE);
                  label_12:
                  while (true) {
                    jj_consume_token(IDENTIFIER);
                    jj_consume_token(LPAREN);
                    jj_consume_token(INTEGER_LITERAL);
                    jj_consume_token(RPAREN);
                    if (jj_2_50(3)) {
                      jj_consume_token(COMMA);
                    } else {
                      ;
                    }
                    if (jj_2_51(3)) {
                      ;
                    } else {
                      break label_12;
                    }
                  }
                  jj_consume_token(RBRACE);
                } else {
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
            } else {
              jj_consume_token(-1);
              throw new ParseException();
            }
          } else if (jj_2_70(3)) {
            if (jj_2_58(3)) {
              jj_consume_token(ACCESS_TOKEN);
            } else if (jj_2_59(3)) {
              jj_consume_token(MAX_ACCESS_TOKEN);
            } else if (jj_2_60(3)) {
              jj_consume_token(MIN_ACCESS_TOKEN);
            } else {
              jj_consume_token(-1);
              throw new ParseException();
            }
            GetAccessIdentifier();
          } else if (jj_2_71(3)) {
            IndexOfTable();
          } else if (jj_2_72(3)) {
            jj_consume_token(ASSIGN);
            jj_consume_token(LBRACE);
            ParentObjectIdentifier();
            IntegerOID();
            jj_consume_token(RBRACE);
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      } else if (jj_2_76(3)) {
        IndexOfTable();
      } else if (jj_2_77(3)) {
        jj_consume_token(OBJECT_TOKEN);
        jj_consume_token(IDENTIFIER_TOKEN);
        jj_consume_token(ASSIGN);
        jj_consume_token(LBRACE);
        ParentObjectIdentifier();
        label_13:
        while (true) {
          if (jj_2_73(3)) {
            ;
          } else {
            break label_13;
          }
          MultipleOids();
        }
        if (jj_2_74(3)) {
          IntegerOID();
        } else {
          ;
        }
        jj_consume_token(RBRACE);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

// handle NOTIFICATION-TPYE
// at this time it just mostly skips the info here
// it would be easy to walk the trees later and output xml
// for the traps
  static final public void Events() throws ParseException {
                 /*@bgen(jjtree) Events */
  SimpleNode jjtn000 = new SimpleNode(JJTEVENTS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(IDENTIFIER);
      if (jj_2_78(3)) {
        jj_consume_token(NOTIFICATION_TYPE_TOKEN);
      } else if (jj_2_79(3)) {
        jj_consume_token(NOTIFICATION_GROUP_TOKEN);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_14:
      while (true) {
        if (jj_2_80(3)) {
          ;
        } else {
          break label_14;
        }
        if (jj_2_85(3)) {
          jj_consume_token(STATUS);
          jj_consume_token(IDENTIFIER);
        } else if (jj_2_86(3)) {
          jj_consume_token(DESCRIPTION);
          jj_consume_token(DESCRIPTOR_LITERAL);
        } else if (jj_2_87(3)) {
          jj_consume_token(OBJECTS_TOKEN);
          jj_consume_token(LBRACE);
          label_15:
          while (true) {
            jj_consume_token(IDENTIFIER);
            if (jj_2_81(3)) {
              jj_consume_token(COMMA);
            } else {
              ;
            }
            if (jj_2_82(3)) {
              ;
            } else {
              break label_15;
            }
          }
          jj_consume_token(RBRACE);
        } else if (jj_2_88(3)) {
          jj_consume_token(NOTIFICATIONS_TOKEN);
          jj_consume_token(LBRACE);
          label_16:
          while (true) {
            jj_consume_token(IDENTIFIER);
            if (jj_2_83(3)) {
              jj_consume_token(COMMA);
            } else {
              ;
            }
            if (jj_2_84(3)) {
              ;
            } else {
              break label_16;
            }
          }
          jj_consume_token(RBRACE);
        } else if (jj_2_89(3)) {
          jj_consume_token(ASSIGN);
          jj_consume_token(LBRACE);
          jj_consume_token(IDENTIFIER);
          jj_consume_token(INTEGER_LITERAL);
          jj_consume_token(RBRACE);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

// handle the TRAP-TYPE, this is just different enough from
// NOTIFICATION-TYPE that I wanted to keep them separate
  static final public void TrapType() throws ParseException {
                   /*@bgen(jjtree) TrapType */
  SimpleNode jjtn000 = new SimpleNode(JJTTRAPTYPE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(IDENTIFIER);
      jj_consume_token(TRAP_TYPE_TOKEN);
      label_17:
      while (true) {
        if (jj_2_90(3)) {
          ;
        } else {
          break label_17;
        }
        if (jj_2_95(3)) {
          jj_consume_token(STATUS);
          jj_consume_token(IDENTIFIER);
        } else if (jj_2_96(3)) {
          jj_consume_token(DESCRIPTION);
          jj_consume_token(DESCRIPTOR_LITERAL);
        } else if (jj_2_97(3)) {
          jj_consume_token(ENTERPRISE_TOKEN);
          jj_consume_token(IDENTIFIER);
        } else if (jj_2_98(3)) {
          jj_consume_token(VARIABLES_TOKEN);
          jj_consume_token(LBRACE);
          label_18:
          while (true) {
            jj_consume_token(IDENTIFIER);
            if (jj_2_91(3)) {
              jj_consume_token(COMMA);
            } else {
              ;
            }
            if (jj_2_92(3)) {
              ;
            } else {
              break label_18;
            }
          }
          jj_consume_token(RBRACE);
        } else if (jj_2_99(3)) {
          jj_consume_token(ASSIGN);
          if (jj_2_93(3)) {
            jj_consume_token(LBRACE);
            jj_consume_token(IDENTIFIER);
          } else {
            ;
          }
          jj_consume_token(INTEGER_LITERAL);
          if (jj_2_94(3)) {
            jj_consume_token(RBRACE);
          } else {
            ;
          }
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  static final public void TableSequenceOf() throws ParseException {
 /*@bgen(jjtree) TableSequenceOf */
    SimpleNode jjtn000 = new SimpleNode(JJTTABLESEQUENCEOF);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token t;
    try {
      jj_consume_token(SEQUENCE_TOKEN);
      jj_consume_token(OF_TOKEN);
      t = jj_consume_token(IDENTIFIER);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setName(t.image);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  static final public void IndexOfTable() throws ParseException {
 /*@bgen(jjtree) IndexOfTable */
    SimpleNode jjtn000 = new SimpleNode(JJTINDEXOFTABLE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token t;
    try {
      jj_consume_token(INDEX_TOKEN);
      jj_consume_token(LBRACE);
      t = jj_consume_token(IDENTIFIER);
      label_19:
      while (true) {
        if (jj_2_100(3)) {
          ;
        } else {
          break label_19;
        }
        jj_consume_token(COMMA);
        jj_consume_token(IDENTIFIER);
      }
      jj_consume_token(RBRACE);
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

// handle identifier :== identifier
  static final public void Assignment() throws ParseException {
 /*@bgen(jjtree) Assignment */
    SimpleNode jjtn000 = new SimpleNode(JJTASSIGNMENT);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token t;
    try {
      // quite a few different kinds of identifiers
          //    RouterID ::= IpAddress
          //    AutonomousType    ::= OBJECT IDENTIFIER
          //    Metric    ::= INTEGER (1..'FFFF'h)
          //    TruthValue ::= INTEGER { true (1), false (2) }
          //    Status ::= INTEGER { enabled (1), disabled (2) }
        t = jj_consume_token(IDENTIFIER);
      jj_consume_token(ASSIGN);
      if (jj_2_101(3)) {
        GetTypeIdentifier();
      } else if (jj_2_102(3)) {
        jj_consume_token(OBJECT_TOKEN);
        jj_consume_token(IDENTIFIER_TOKEN);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_107(3)) {
        if (jj_2_105(3)) {
          jj_consume_token(LPAREN);
          jj_consume_token(INTEGER_LITERAL);
          jj_consume_token(68);
          jj_consume_token(68);
          jj_consume_token(INTEGER_LITERAL);
          jj_consume_token(RPAREN);
        } else if (jj_2_106(3)) {
          jj_consume_token(LBRACE);
          label_20:
          while (true) {
            jj_consume_token(IDENTIFIER);
            jj_consume_token(LPAREN);
            jj_consume_token(INTEGER_LITERAL);
            jj_consume_token(RPAREN);
            if (jj_2_103(3)) {
              jj_consume_token(COMMA);
            } else {
              ;
            }
            if (jj_2_104(3)) {
              ;
            } else {
              break label_20;
            }
          }
          jj_consume_token(RBRACE);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setName(t.image);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  static final public void SequenceOfVarsOrTextConvention() throws ParseException {
                                         /*@bgen(jjtree) SequenceOfVarsOrTextConvention */
  SimpleNode jjtn000 = new SimpleNode(JJTSEQUENCEOFVARSORTEXTCONVENTION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      ObjectIdentifier();
      jj_consume_token(ASSIGN);
      if (jj_2_108(3)) {
        SequenceOfVars();
      } else if (jj_2_109(3)) {
        TextConvention();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  static final public void SequenceOfVars() throws ParseException {
                                       /*@bgen(jjtree) TableOidVars */
  SimpleNode jjtn000 = new SimpleNode(JJTTABLEOIDVARS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(SEQUENCE_TOKEN);
      jj_consume_token(LBRACE);
      label_21:
      while (true) {
        IdentifierInSequenceOfVars();
        if (jj_2_114(3)) {
          jj_consume_token(IDENTIFIER);
          label_22:
          while (true) {
            if (jj_2_110(3)) {
              ;
            } else {
              break label_22;
            }
            if (jj_2_111(3)) {
              SizeDeclaration();
            } else if (jj_2_112(3)) {
              jj_consume_token(LPAREN);
              jj_consume_token(INTEGER_LITERAL);
              jj_consume_token(68);
              jj_consume_token(68);
              jj_consume_token(INTEGER_LITERAL);
              jj_consume_token(RPAREN);
            } else {
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        } else if (jj_2_115(3)) {
          jj_consume_token(OBJECT_IDENTITY);
        } else if (jj_2_116(3)) {
          jj_consume_token(OBJECT_TYPE);
        } else if (jj_2_117(3)) {
          jj_consume_token(OBJECT_TOKEN);
          jj_consume_token(IDENTIFIER_TOKEN);
        } else if (jj_2_118(3)) {
          jj_consume_token(OCTET_TOKEN);
          jj_consume_token(STRING_TOKEN);
          if (jj_2_113(3)) {
            SizeDeclaration();
          } else {
            ;
          }
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_23:
        while (true) {
          if (jj_2_119(3)) {
            ;
          } else {
            break label_23;
          }
          jj_consume_token(COMMA);
        }
        if (jj_2_120(3)) {
          ;
        } else {
          break label_21;
        }
      }
      jj_consume_token(RBRACE);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setName(lastObjectIdentifierToken.image);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  static final public void TextConvention() throws ParseException {
                         /*@bgen(jjtree) TextConvention */
  SimpleNode jjtn000 = new SimpleNode(JJTTEXTCONVENTION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      if (jj_2_145(3)) {
        jj_consume_token(TEXTUAL_CONVENTION_TOKEN);
        label_24:
        while (true) {
          if (jj_2_134(3)) {
            jj_consume_token(STATUS);
            jj_consume_token(IDENTIFIER);
          } else if (jj_2_135(3)) {
            if (jj_2_121(3)) {
              jj_consume_token(DESCRIPTION);
            } else if (jj_2_122(3)) {
              jj_consume_token(REFERENCE_TOKEN);
            } else {
              jj_consume_token(-1);
              throw new ParseException();
            }
            jj_consume_token(DESCRIPTOR_LITERAL);
          } else if (jj_2_136(3)) {
            jj_consume_token(DISPLAY_HINT_TOKEN);
            jj_consume_token(DESCRIPTOR_LITERAL);
          } else if (jj_2_137(3)) {
            jj_consume_token(OBJECTS_TOKEN);
            jj_consume_token(LBRACE);
            label_25:
            while (true) {
              jj_consume_token(IDENTIFIER);
              if (jj_2_123(3)) {
                jj_consume_token(COMMA);
              } else {
                ;
              }
              if (jj_2_124(3)) {
                ;
              } else {
                break label_25;
              }
            }
            jj_consume_token(RBRACE);
          } else if (jj_2_138(3)) {
            jj_consume_token(SYNTAX_TOKEN);
            if (jj_2_131(3)) {
              jj_consume_token(OBJECT_TOKEN);
              jj_consume_token(IDENTIFIER_TOKEN);
            } else if (jj_2_132(3)) {
              jj_consume_token(OCTET_TOKEN);
              jj_consume_token(STRING_TOKEN);
              if (jj_2_125(3)) {
                SizeDeclaration();
              } else {
                ;
              }
            } else if (jj_2_133(3)) {
              GetTypeIdentifier();
              if (jj_2_130(3)) {
                if (jj_2_128(3)) {
                  SizeDeclaration();
                } else if (jj_2_129(3)) {
                  jj_consume_token(LBRACE);
                  label_26:
                  while (true) {
                    jj_consume_token(IDENTIFIER);
                    jj_consume_token(LPAREN);
                    jj_consume_token(INTEGER_LITERAL);
                    jj_consume_token(RPAREN);
                    if (jj_2_126(3)) {
                      jj_consume_token(COMMA);
                    } else {
                      ;
                    }
                    if (jj_2_127(3)) {
                      ;
                    } else {
                      break label_26;
                    }
                  }
                  jj_consume_token(RBRACE);
                } else {
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              } else {
                ;
              }
            } else {
              jj_consume_token(-1);
              throw new ParseException();
            }
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
          if (jj_2_139(3)) {
            ;
          } else {
            break label_24;
          }
        }
      } else if (jj_2_146(3)) {
        jj_consume_token(OCTET_TOKEN);
        jj_consume_token(STRING_TOKEN);
        if (jj_2_144(3)) {
          if (jj_2_142(3)) {
            SizeDeclaration();
          } else if (jj_2_143(3)) {
            jj_consume_token(LBRACE);
            label_27:
            while (true) {
              jj_consume_token(IDENTIFIER);
              jj_consume_token(LPAREN);
              jj_consume_token(INTEGER_LITERAL);
              jj_consume_token(RPAREN);
              if (jj_2_140(3)) {
                jj_consume_token(COMMA);
              } else {
                ;
              }
              if (jj_2_141(3)) {
                ;
              } else {
                break label_27;
              }
            }
            jj_consume_token(RBRACE);
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        } else {
          ;
        }
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
     jjtn000.setName(lastObjectIdentifierToken.image);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  static final public void IdentifierInSequenceOfVars() throws ParseException {
 /*@bgen(jjtree) IdentifierInSequenceOfVars */
    SimpleNode jjtn000 = new SimpleNode(JJTIDENTIFIERINSEQUENCEOFVARS);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Token t;
    try {
      // called from SequenceOfVars()
          // mark each ast node in the sequence
          t = jj_consume_token(IDENTIFIER);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000.setName(t.image);
        jjtn000.setIsOidInTable(true);
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  static final public void End() throws ParseException {
              /*@bgen(jjtree) End */
  SimpleNode jjtn000 = new SimpleNode(JJTEND);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(END);
    } finally {
     if (jjtc000) {
       jjtree.closeNodeScope(jjtn000, true);
     }
    }
  }

  static final public void Expression() throws ParseException {
                     /*@bgen(jjtree) Expression */
  SimpleNode jjtn000 = new SimpleNode(JJTEXPRESSION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      Identifier();
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  static final public void Identifier() throws ParseException {
 /*@bgen(jjtree) Identifier */
  SimpleNode jjtn000 = new SimpleNode(JJTIDENTIFIER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(IDENTIFIER);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setName(t.image);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  static final public void ObjectIdentifier() throws ParseException {
 /*@bgen(jjtree) ObjectIdentifier */
  SimpleNode jjtn000 = new SimpleNode(JJTOBJECTIDENTIFIER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(IDENTIFIER);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setName(t.image);
    lastObjectIdentifierToken = t;
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  static final public void ParentObjectIdentifier() throws ParseException {
 /*@bgen(jjtree) Parent */
  SimpleNode jjtn000 = new SimpleNode(JJTPARENT);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(IDENTIFIER);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setParentName(t.image);
    jjtn000.setName(lastObjectIdentifierToken.image);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  static final public void ChildTextIdentifier() throws ParseException {
 /*@bgen(jjtree) ChildTextIdentifier */
  SimpleNode jjtn000 = new SimpleNode(JJTCHILDTEXTIDENTIFIER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(IDENTIFIER);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setName(t.image);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  static final public void ChildNumericIdentifier() throws ParseException {
 /*@bgen(jjtree) ChildNumericIdentifier */
  SimpleNode jjtn000 = new SimpleNode(JJTCHILDNUMERICIDENTIFIER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(INTEGER_LITERAL);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setName(t.image);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

// handle the oids after "iso"
// mgmt OBJECT IDENTIFIER ::= { iso org(3) dod(6) internet(1) mgmt(2) }
  static final public void MultipleOids() throws ParseException {
                       /*@bgen(jjtree) MultipleOids */
  SimpleNode jjtn000 = new SimpleNode(JJTMULTIPLEOIDS);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      ChildTextIdentifier();
      jj_consume_token(LPAREN);
      ChildNumericIdentifier();
      jj_consume_token(RPAREN);
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

// handle
// (SIZE (0..255))
// (SIZE (0 | 8 | 11))
// (SIZE (6))
// (SIZE (1 | 4..85))
// (1)
  static final public void SizeDeclaration() throws ParseException {
                          /*@bgen(jjtree) SizeDeclaration */
  SimpleNode jjtn000 = new SimpleNode(JJTSIZEDECLARATION);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(LPAREN);
      if (jj_2_153(3)) {
        jj_consume_token(SIZE_TOKEN);
        jj_consume_token(LPAREN);
        label_28:
        while (true) {
          jj_consume_token(INTEGER_LITERAL);
          if (jj_2_147(3)) {
            jj_consume_token(68);
            jj_consume_token(68);
            jj_consume_token(INTEGER_LITERAL);
          } else {
            ;
          }
          if (jj_2_148(3)) {
            jj_consume_token(69);
          } else {
            ;
          }
          if (jj_2_149(3)) {
            ;
          } else {
            break label_28;
          }
        }
        jj_consume_token(RPAREN);
      } else if (jj_2_154(3)) {
        label_29:
        while (true) {
          jj_consume_token(INTEGER_LITERAL);
          if (jj_2_150(3)) {
            jj_consume_token(68);
            jj_consume_token(68);
            jj_consume_token(INTEGER_LITERAL);
          } else {
            ;
          }
          if (jj_2_151(3)) {
            jj_consume_token(69);
          } else {
            ;
          }
          if (jj_2_152(3)) {
            ;
          } else {
            break label_29;
          }
        }
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(RPAREN);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  static final public void Integer() throws ParseException {
                  /*@bgen(jjtree) Integer */
  SimpleNode jjtn000 = new SimpleNode(JJTINTEGER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(INTEGER_LITERAL);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  static final public void IntegerOID() throws ParseException {
 /*@bgen(jjtree) PartialOID */
  SimpleNode jjtn000 = new SimpleNode(JJTPARTIALOID);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(INTEGER_LITERAL);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setName(t.image);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

// usually called after SYNTAX, e.g. SYNTAX Counter32
// also for TextConvention and Assignment to get the child
// node in the right place.
  static final public void GetTypeIdentifier() throws ParseException {
 /*@bgen(jjtree) GetTypeIdentifier */
  SimpleNode jjtn000 = new SimpleNode(JJTGETTYPEIDENTIFIER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(IDENTIFIER);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setName(t.image);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

// usually called after ACCESS, e.g. ACCESS read-write
  static final public void GetAccessIdentifier() throws ParseException {
 /*@bgen(jjtree) GetAccessIdentifier */
  SimpleNode jjtn000 = new SimpleNode(JJTGETACCESSIDENTIFIER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token t;
    try {
      t = jj_consume_token(IDENTIFIER);
    jjtree.closeNodeScope(jjtn000, true);
    jjtc000 = false;
    jjtn000.setName(t.image);
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  static final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  static final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  static final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  static final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  static final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  static final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  static final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  static final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  static final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  static final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  static final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  static final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  static final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  static final private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  static final private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  static final private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  static final private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  static final private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  static final private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  static final private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  static final private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  static final private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  static final private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  static final private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  static final private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  static final private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  static final private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  static final private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  static final private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  static final private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  static final private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  static final private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  static final private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  static final private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  static final private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  static final private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  static final private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  static final private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  static final private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  static final private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  static final private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  static final private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  static final private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  static final private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  static final private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  static final private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  static final private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_47(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  static final private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_48(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  static final private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_49(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  static final private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_50(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  static final private boolean jj_2_51(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_51(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  static final private boolean jj_2_52(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_52(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  static final private boolean jj_2_53(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_53(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  static final private boolean jj_2_54(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_54(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  static final private boolean jj_2_55(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_55(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  static final private boolean jj_2_56(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_56(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  static final private boolean jj_2_57(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_57(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  static final private boolean jj_2_58(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_58(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  static final private boolean jj_2_59(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_59(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  static final private boolean jj_2_60(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_60(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  static final private boolean jj_2_61(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_61(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  static final private boolean jj_2_62(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_62(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  static final private boolean jj_2_63(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_63(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  static final private boolean jj_2_64(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_64(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  static final private boolean jj_2_65(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_65(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  static final private boolean jj_2_66(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_66(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  static final private boolean jj_2_67(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_67(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  static final private boolean jj_2_68(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_68(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  static final private boolean jj_2_69(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_69(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  static final private boolean jj_2_70(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_70(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  static final private boolean jj_2_71(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_71(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  static final private boolean jj_2_72(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_72(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  static final private boolean jj_2_73(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_73(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(72, xla); }
  }

  static final private boolean jj_2_74(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_74(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(73, xla); }
  }

  static final private boolean jj_2_75(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_75(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(74, xla); }
  }

  static final private boolean jj_2_76(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_76(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(75, xla); }
  }

  static final private boolean jj_2_77(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_77(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(76, xla); }
  }

  static final private boolean jj_2_78(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_78(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(77, xla); }
  }

  static final private boolean jj_2_79(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_79(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(78, xla); }
  }

  static final private boolean jj_2_80(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_80(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(79, xla); }
  }

  static final private boolean jj_2_81(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_81(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(80, xla); }
  }

  static final private boolean jj_2_82(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_82(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(81, xla); }
  }

  static final private boolean jj_2_83(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_83(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(82, xla); }
  }

  static final private boolean jj_2_84(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_84(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(83, xla); }
  }

  static final private boolean jj_2_85(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_85(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(84, xla); }
  }

  static final private boolean jj_2_86(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_86(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(85, xla); }
  }

  static final private boolean jj_2_87(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_87(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(86, xla); }
  }

  static final private boolean jj_2_88(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_88(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(87, xla); }
  }

  static final private boolean jj_2_89(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_89(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(88, xla); }
  }

  static final private boolean jj_2_90(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_90(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(89, xla); }
  }

  static final private boolean jj_2_91(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_91(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(90, xla); }
  }

  static final private boolean jj_2_92(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_92(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(91, xla); }
  }

  static final private boolean jj_2_93(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_93(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(92, xla); }
  }

  static final private boolean jj_2_94(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_94(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(93, xla); }
  }

  static final private boolean jj_2_95(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_95(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(94, xla); }
  }

  static final private boolean jj_2_96(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_96(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(95, xla); }
  }

  static final private boolean jj_2_97(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_97(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(96, xla); }
  }

  static final private boolean jj_2_98(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_98(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(97, xla); }
  }

  static final private boolean jj_2_99(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_99(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(98, xla); }
  }

  static final private boolean jj_2_100(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_100(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(99, xla); }
  }

  static final private boolean jj_2_101(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_101(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(100, xla); }
  }

  static final private boolean jj_2_102(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_102(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(101, xla); }
  }

  static final private boolean jj_2_103(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_103(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(102, xla); }
  }

  static final private boolean jj_2_104(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_104(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(103, xla); }
  }

  static final private boolean jj_2_105(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_105(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(104, xla); }
  }

  static final private boolean jj_2_106(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_106(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(105, xla); }
  }

  static final private boolean jj_2_107(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_107(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(106, xla); }
  }

  static final private boolean jj_2_108(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_108(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(107, xla); }
  }

  static final private boolean jj_2_109(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_109(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(108, xla); }
  }

  static final private boolean jj_2_110(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_110(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(109, xla); }
  }

  static final private boolean jj_2_111(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_111(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(110, xla); }
  }

  static final private boolean jj_2_112(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_112(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(111, xla); }
  }

  static final private boolean jj_2_113(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_113(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(112, xla); }
  }

  static final private boolean jj_2_114(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_114(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(113, xla); }
  }

  static final private boolean jj_2_115(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_115(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(114, xla); }
  }

  static final private boolean jj_2_116(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_116(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(115, xla); }
  }

  static final private boolean jj_2_117(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_117(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(116, xla); }
  }

  static final private boolean jj_2_118(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_118(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(117, xla); }
  }

  static final private boolean jj_2_119(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_119(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(118, xla); }
  }

  static final private boolean jj_2_120(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_120(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(119, xla); }
  }

  static final private boolean jj_2_121(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_121(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(120, xla); }
  }

  static final private boolean jj_2_122(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_122(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(121, xla); }
  }

  static final private boolean jj_2_123(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_123(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(122, xla); }
  }

  static final private boolean jj_2_124(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_124(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(123, xla); }
  }

  static final private boolean jj_2_125(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_125(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(124, xla); }
  }

  static final private boolean jj_2_126(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_126(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(125, xla); }
  }

  static final private boolean jj_2_127(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_127(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(126, xla); }
  }

  static final private boolean jj_2_128(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_128(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(127, xla); }
  }

  static final private boolean jj_2_129(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_129(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(128, xla); }
  }

  static final private boolean jj_2_130(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_130(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(129, xla); }
  }

  static final private boolean jj_2_131(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_131(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(130, xla); }
  }

  static final private boolean jj_2_132(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_132(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(131, xla); }
  }

  static final private boolean jj_2_133(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_133(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(132, xla); }
  }

  static final private boolean jj_2_134(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_134(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(133, xla); }
  }

  static final private boolean jj_2_135(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_135(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(134, xla); }
  }

  static final private boolean jj_2_136(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_136(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(135, xla); }
  }

  static final private boolean jj_2_137(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_137(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(136, xla); }
  }

  static final private boolean jj_2_138(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_138(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(137, xla); }
  }

  static final private boolean jj_2_139(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_139(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(138, xla); }
  }

  static final private boolean jj_2_140(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_140(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(139, xla); }
  }

  static final private boolean jj_2_141(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_141(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(140, xla); }
  }

  static final private boolean jj_2_142(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_142(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(141, xla); }
  }

  static final private boolean jj_2_143(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_143(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(142, xla); }
  }

  static final private boolean jj_2_144(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_144(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(143, xla); }
  }

  static final private boolean jj_2_145(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_145(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(144, xla); }
  }

  static final private boolean jj_2_146(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_146(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(145, xla); }
  }

  static final private boolean jj_2_147(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_147(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(146, xla); }
  }

  static final private boolean jj_2_148(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_148(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(147, xla); }
  }

  static final private boolean jj_2_149(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_149(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(148, xla); }
  }

  static final private boolean jj_2_150(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_150(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(149, xla); }
  }

  static final private boolean jj_2_151(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_151(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(150, xla); }
  }

  static final private boolean jj_2_152(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_152(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(151, xla); }
  }

  static final private boolean jj_2_153(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_153(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(152, xla); }
  }

  static final private boolean jj_2_154(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_154(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(153, xla); }
  }

  static final private boolean jj_3_30() {
    if (jj_scan_token(MODULE_COMPLIANCE_TOKEN)) return true;
    return false;
  }

  static final private boolean jj_3_89() {
    if (jj_scan_token(ASSIGN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static final private boolean jj_3_88() {
    if (jj_scan_token(NOTIFICATIONS_TOKEN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    if (jj_3_84()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_84()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static final private boolean jj_3_87() {
    if (jj_scan_token(OBJECTS_TOKEN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    if (jj_3_82()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_82()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static final private boolean jj_3_80() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_85()) {
    jj_scanpos = xsp;
    if (jj_3_86()) {
    jj_scanpos = xsp;
    if (jj_3_87()) {
    jj_scanpos = xsp;
    if (jj_3_88()) {
    jj_scanpos = xsp;
    if (jj_3_89()) return true;
    }
    }
    }
    }
    return false;
  }

  static final private boolean jj_3_85() {
    if (jj_scan_token(STATUS)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static final private boolean jj_3_66() {
    if (jj_scan_token(AUGMENTS_TOKEN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static final private boolean jj_3_52() {
    if (jj_3R_37()) return true;
    return false;
  }

  static final private boolean jj_3_49() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_52()) {
    jj_scanpos = xsp;
    if (jj_3_53()) return true;
    }
    return false;
  }

  static final private boolean jj_3_47() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_46()) jj_scanpos = xsp;
    return false;
  }

  static final private boolean jj_3_59() {
    if (jj_scan_token(MAX_ACCESS_TOKEN)) return true;
    return false;
  }

  static final private boolean jj_3_33() {
    if (jj_scan_token(DESCRIPTION)) return true;
    return false;
  }

  static final private boolean jj_3_62() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_33()) {
    jj_scanpos = xsp;
    if (jj_3_34()) {
    jj_scanpos = xsp;
    if (jj_3_35()) return true;
    }
    }
    if (jj_scan_token(DESCRIPTOR_LITERAL)) return true;
    return false;
  }

  static final private boolean jj_3_54() {
    if (jj_scan_token(OBJECT_TOKEN)) return true;
    if (jj_scan_token(IDENTIFIER_TOKEN)) return true;
    return false;
  }

  static final private boolean jj_3_51() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  static final private boolean jj_3_29() {
    if (jj_scan_token(OBJECT_TYPE)) return true;
    return false;
  }

  static final private boolean jj_3R_33() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_78()) {
    jj_scanpos = xsp;
    if (jj_3_79()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_80()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static final private boolean jj_3_41() {
    if (jj_scan_token(DESCRIPTOR_LITERAL)) return true;
    return false;
  }

  static final private boolean jj_3_76() {
    if (jj_3R_41()) return true;
    return false;
  }

  static final private boolean jj_3_77() {
    if (jj_scan_token(OBJECT_TOKEN)) return true;
    if (jj_scan_token(IDENTIFIER_TOKEN)) return true;
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  static final private boolean jj_3_71() {
    if (jj_3R_41()) return true;
    return false;
  }

  static final private boolean jj_3_58() {
    if (jj_scan_token(ACCESS_TOKEN)) return true;
    return false;
  }

  static final private boolean jj_3_53() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    if (jj_3_51()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_51()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static final private boolean jj_3_72() {
    if (jj_scan_token(ASSIGN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_42()) return true;
    return false;
  }

  static final private boolean jj_3_70() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_58()) {
    jj_scanpos = xsp;
    if (jj_3_59()) {
    jj_scanpos = xsp;
    if (jj_3_60()) return true;
    }
    }
    if (jj_3R_40()) return true;
    return false;
  }

  static final private boolean jj_3_57() {
    if (jj_3R_39()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_49()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static final private boolean jj_3_56() {
    if (jj_3R_38()) return true;
    return false;
  }

  static final private boolean jj_3_69() {
    if (jj_scan_token(SYNTAX_TOKEN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_54()) {
    jj_scanpos = xsp;
    if (jj_3_55()) {
    jj_scanpos = xsp;
    if (jj_3_56()) {
    jj_scanpos = xsp;
    if (jj_3_57()) return true;
    }
    }
    }
    return false;
  }

  static final private boolean jj_3_68() {
    if (jj_scan_token(OBJECTS_TOKEN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    if (jj_3_47()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_47()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static final private boolean jj_3_67() {
    if (jj_scan_token(OBJECT_TOKEN)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static final private boolean jj_3_65() {
    if (jj_scan_token(GROUP_TOKEN)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static final private boolean jj_3_64() {
    if (jj_scan_token(MODULE_TOKEN)) return true;
    if (jj_scan_token(MANDATORY_GROUPS_TOKEN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  static final private boolean jj_3_63() {
    if (jj_scan_token(DEFVAL_TOKEN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_41()) {
    jj_scanpos = xsp;
    if (jj_3_42()) {
    jj_scanpos = xsp;
    if (jj_3_43()) return true;
    }
    }
    return false;
  }

  static final private boolean jj_3_28() {
    if (jj_scan_token(OBJECT_IDENTITY)) return true;
    return false;
  }

  static final private boolean jj_3_61() {
    if (jj_scan_token(STATUS)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static final private boolean jj_3_32() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_61()) {
    jj_scanpos = xsp;
    if (jj_3_62()) {
    jj_scanpos = xsp;
    if (jj_3_63()) {
    jj_scanpos = xsp;
    if (jj_3_64()) {
    jj_scanpos = xsp;
    if (jj_3_65()) {
    jj_scanpos = xsp;
    if (jj_3_66()) {
    jj_scanpos = xsp;
    if (jj_3_67()) {
    jj_scanpos = xsp;
    if (jj_3_68()) {
    jj_scanpos = xsp;
    if (jj_3_69()) {
    jj_scanpos = xsp;
    if (jj_3_70()) {
    jj_scanpos = xsp;
    if (jj_3_71()) {
    jj_scanpos = xsp;
    if (jj_3_72()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  static final private boolean jj_3_75() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_28()) {
    jj_scanpos = xsp;
    if (jj_3_29()) {
    jj_scanpos = xsp;
    if (jj_3_30()) {
    jj_scanpos = xsp;
    if (jj_3_31()) return true;
    }
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_32()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static final private boolean jj_3_148() {
    if (jj_scan_token(69)) return true;
    return false;
  }

  static final private boolean jj_3_12() {
    if (jj_scan_token(MODULE_IDENTITY_TOKEN)) return true;
    return false;
  }

  static final private boolean jj_3_151() {
    if (jj_scan_token(69)) return true;
    return false;
  }

  static final private boolean jj_3_15() {
    if (jj_scan_token(NOTIFICATION_GROUP_TOKEN)) return true;
    return false;
  }

  static final private boolean jj_3_18() {
    if (jj_scan_token(OBJECT_IDENTITY)) return true;
    return false;
  }

  static final private boolean jj_3R_40() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static final private boolean jj_3R_31() {
    if (jj_3R_48()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_75()) {
    jj_scanpos = xsp;
    if (jj_3_76()) {
    jj_scanpos = xsp;
    if (jj_3_77()) return true;
    }
    }
    return false;
  }

  static final private boolean jj_3_26() {
    if (jj_scan_token(REVISION_TOKEN)) return true;
    if (jj_scan_token(DESCRIPTOR_LITERAL)) return true;
    return false;
  }

  static final private boolean jj_3R_39() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static final private boolean jj_3_25() {
    if (jj_scan_token(CONTACT_INFO_TOKEN)) return true;
    if (jj_scan_token(DESCRIPTOR_LITERAL)) return true;
    return false;
  }

  static final private boolean jj_3_24() {
    if (jj_scan_token(DESCRIPTION)) return true;
    if (jj_scan_token(DESCRIPTOR_LITERAL)) return true;
    return false;
  }

  static final private boolean jj_3_22() {
    if (jj_scan_token(LAST_UPDATED_TOKEN)) return true;
    if (jj_scan_token(DESCRIPTOR_LITERAL)) return true;
    return false;
  }

  static final private boolean jj_3_23() {
    if (jj_scan_token(ORGANIZATION_TOKEN)) return true;
    if (jj_scan_token(DESCRIPTOR_LITERAL)) return true;
    return false;
  }

  static final private boolean jj_3_27() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_22()) {
    jj_scanpos = xsp;
    if (jj_3_23()) {
    jj_scanpos = xsp;
    if (jj_3_24()) {
    jj_scanpos = xsp;
    if (jj_3_25()) {
    jj_scanpos = xsp;
    if (jj_3_26()) return true;
    }
    }
    }
    }
    return false;
  }

  static final private boolean jj_3_147() {
    if (jj_scan_token(68)) return true;
    if (jj_scan_token(68)) return true;
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  static final private boolean jj_3_11() {
    if (jj_scan_token(NOTIFICATION_TYPE_TOKEN)) return true;
    return false;
  }

  static final private boolean jj_3_5() {
    if (jj_3R_33()) return true;
    return false;
  }

  static final private boolean jj_3_150() {
    if (jj_scan_token(68)) return true;
    if (jj_scan_token(68)) return true;
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  static final private boolean jj_3_14() {
    if (jj_scan_token(OBJECT_GROUP_TOKEN)) return true;
    return false;
  }

  static final private boolean jj_3_17() {
    if (jj_scan_token(TEXTUAL_CONVENTION_TOKEN)) return true;
    return false;
  }

  static final private boolean jj_3R_44() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  static final private boolean jj_3_10() {
    if (jj_scan_token(OBJECT_TYPE)) return true;
    return false;
  }

  static final private boolean jj_3_149() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_147()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_148()) jj_scanpos = xsp;
    return false;
  }

  static final private boolean jj_3_152() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_150()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_151()) jj_scanpos = xsp;
    return false;
  }

  static final private boolean jj_3_8() {
    if (jj_3R_36()) return true;
    return false;
  }

  static final private boolean jj_3_140() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  static final private boolean jj_3_154() {
    Token xsp;
    if (jj_3_152()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_152()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static final private boolean jj_3_153() {
    if (jj_scan_token(SIZE_TOKEN)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    if (jj_3_149()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_149()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static final private boolean jj_3_21() {
    Token xsp;
    if (jj_3_20()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_20()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(FROM)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static final private boolean jj_3R_36() {
    if (jj_3R_48()) return true;
    if (jj_scan_token(MODULE_IDENTITY_TOKEN)) return true;
    Token xsp;
    if (jj_3_27()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_27()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static final private boolean jj_3_16() {
    if (jj_scan_token(TRAP_TYPE_TOKEN)) return true;
    return false;
  }

  static final private boolean jj_3_19() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  static final private boolean jj_3R_37() {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_153()) {
    jj_scanpos = xsp;
    if (jj_3_154()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  static final private boolean jj_3_13() {
    if (jj_scan_token(MODULE_COMPLIANCE_TOKEN)) return true;
    return false;
  }

  static final private boolean jj_3_9() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static final private boolean jj_3_20() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_9()) {
    jj_scanpos = xsp;
    if (jj_3_10()) {
    jj_scanpos = xsp;
    if (jj_3_11()) {
    jj_scanpos = xsp;
    if (jj_3_12()) {
    jj_scanpos = xsp;
    if (jj_3_13()) {
    jj_scanpos = xsp;
    if (jj_3_14()) {
    jj_scanpos = xsp;
    if (jj_3_15()) {
    jj_scanpos = xsp;
    if (jj_3_16()) {
    jj_scanpos = xsp;
    if (jj_3_17()) {
    jj_scanpos = xsp;
    if (jj_3_18()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_19()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static final private boolean jj_3_4() {
    if (jj_3R_32()) return true;
    return false;
  }

  static final private boolean jj_3_7() {
    if (jj_3R_35()) return true;
    return false;
  }

  static final private boolean jj_3R_30() {
    if (jj_scan_token(IMPORTS)) return true;
    Token xsp;
    if (jj_3_21()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_21()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static final private boolean jj_3R_43() {
    if (jj_3R_49()) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_50()) return true;
    return false;
  }

  static final private boolean jj_3_6() {
    if (jj_3R_34()) return true;
    return false;
  }

  static final private boolean jj_3R_50() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  static final private boolean jj_3_2() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3_6()) {
    jj_scanpos = xsp;
    if (jj_3_7()) {
    jj_scanpos = xsp;
    if (jj_3_8()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  static final private boolean jj_3_3() {
    if (jj_3R_31()) return true;
    return false;
  }

  static final private boolean jj_3_125() {
    if (jj_3R_37()) return true;
    return false;
  }

  static final private boolean jj_3_1() {
    if (jj_3R_30()) return true;
    return false;
  }

  static final private boolean jj_3R_49() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static final private boolean jj_3_141() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  static final private boolean jj_3_126() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  static final private boolean jj_3R_42() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static final private boolean jj_3_143() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    if (jj_3_141()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_141()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static final private boolean jj_3_132() {
    if (jj_scan_token(OCTET_TOKEN)) return true;
    if (jj_scan_token(STRING_TOKEN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_125()) jj_scanpos = xsp;
    return false;
  }

  static final private boolean jj_3R_48() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static final private boolean jj_3_123() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  static final private boolean jj_3_113() {
    if (jj_3R_37()) return true;
    return false;
  }

  static final private boolean jj_3_144() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_142()) {
    jj_scanpos = xsp;
    if (jj_3_143()) return true;
    }
    return false;
  }

  static final private boolean jj_3_142() {
    if (jj_3R_37()) return true;
    return false;
  }

  static final private boolean jj_3_128() {
    if (jj_3R_37()) return true;
    return false;
  }

  static final private boolean jj_3_124() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_123()) jj_scanpos = xsp;
    return false;
  }

  static final private boolean jj_3_130() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_128()) {
    jj_scanpos = xsp;
    if (jj_3_129()) return true;
    }
    return false;
  }

  static final private boolean jj_3_131() {
    if (jj_scan_token(OBJECT_TOKEN)) return true;
    if (jj_scan_token(IDENTIFIER_TOKEN)) return true;
    return false;
  }

  static final private boolean jj_3R_47() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static final private boolean jj_3_122() {
    if (jj_scan_token(REFERENCE_TOKEN)) return true;
    return false;
  }

  static final private boolean jj_3_127() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  static final private boolean jj_3_118() {
    if (jj_scan_token(OCTET_TOKEN)) return true;
    if (jj_scan_token(STRING_TOKEN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_113()) jj_scanpos = xsp;
    return false;
  }

  static final private boolean jj_3_112() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    if (jj_scan_token(68)) return true;
    return false;
  }

  static final private boolean jj_3_133() {
    if (jj_3R_39()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_130()) jj_scanpos = xsp;
    return false;
  }

  static final private boolean jj_3_146() {
    if (jj_scan_token(OCTET_TOKEN)) return true;
    if (jj_scan_token(STRING_TOKEN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_144()) jj_scanpos = xsp;
    return false;
  }

  static final private boolean jj_3_129() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    if (jj_3_127()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_127()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static final private boolean jj_3_138() {
    if (jj_scan_token(SYNTAX_TOKEN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_131()) {
    jj_scanpos = xsp;
    if (jj_3_132()) {
    jj_scanpos = xsp;
    if (jj_3_133()) return true;
    }
    }
    return false;
  }

  static final private boolean jj_3_109() {
    if (jj_3R_46()) return true;
    return false;
  }

  static final private boolean jj_3_137() {
    if (jj_scan_token(OBJECTS_TOKEN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    if (jj_3_124()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_124()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static final private boolean jj_3_121() {
    if (jj_scan_token(DESCRIPTION)) return true;
    return false;
  }

  static final private boolean jj_3_136() {
    if (jj_scan_token(DISPLAY_HINT_TOKEN)) return true;
    if (jj_scan_token(DESCRIPTOR_LITERAL)) return true;
    return false;
  }

  static final private boolean jj_3_135() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_121()) {
    jj_scanpos = xsp;
    if (jj_3_122()) return true;
    }
    if (jj_scan_token(DESCRIPTOR_LITERAL)) return true;
    return false;
  }

  static final private boolean jj_3_134() {
    if (jj_scan_token(STATUS)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static final private boolean jj_3_139() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_134()) {
    jj_scanpos = xsp;
    if (jj_3_135()) {
    jj_scanpos = xsp;
    if (jj_3_136()) {
    jj_scanpos = xsp;
    if (jj_3_137()) {
    jj_scanpos = xsp;
    if (jj_3_138()) return true;
    }
    }
    }
    }
    return false;
  }

  static final private boolean jj_3_103() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  static final private boolean jj_3_145() {
    if (jj_scan_token(TEXTUAL_CONVENTION_TOKEN)) return true;
    Token xsp;
    if (jj_3_139()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_139()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static final private boolean jj_3_116() {
    if (jj_scan_token(OBJECT_TYPE)) return true;
    return false;
  }

  static final private boolean jj_3_110() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_111()) {
    jj_scanpos = xsp;
    if (jj_3_112()) return true;
    }
    return false;
  }

  static final private boolean jj_3_111() {
    if (jj_3R_37()) return true;
    return false;
  }

  static final private boolean jj_3_108() {
    if (jj_3R_45()) return true;
    return false;
  }

  static final private boolean jj_3_102() {
    if (jj_scan_token(OBJECT_TOKEN)) return true;
    if (jj_scan_token(IDENTIFIER_TOKEN)) return true;
    return false;
  }

  static final private boolean jj_3R_46() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_145()) {
    jj_scanpos = xsp;
    if (jj_3_146()) return true;
    }
    return false;
  }

  static final private boolean jj_3_119() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  static final private boolean jj_3_114() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_110()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static final private boolean jj_3_117() {
    if (jj_scan_token(OBJECT_TOKEN)) return true;
    if (jj_scan_token(IDENTIFIER_TOKEN)) return true;
    return false;
  }

  static final private boolean jj_3_115() {
    if (jj_scan_token(OBJECT_IDENTITY)) return true;
    return false;
  }

  static final private boolean jj_3_120() {
    if (jj_3R_47()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_114()) {
    jj_scanpos = xsp;
    if (jj_3_115()) {
    jj_scanpos = xsp;
    if (jj_3_116()) {
    jj_scanpos = xsp;
    if (jj_3_117()) {
    jj_scanpos = xsp;
    if (jj_3_118()) return true;
    }
    }
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_119()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static final private boolean jj_3R_45() {
    if (jj_scan_token(SEQUENCE_TOKEN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    if (jj_3_120()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_120()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static final private boolean jj_3_100() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static final private boolean jj_3_101() {
    if (jj_3R_39()) return true;
    return false;
  }

  static final private boolean jj_3R_32() {
    if (jj_3R_48()) return true;
    if (jj_scan_token(ASSIGN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_108()) {
    jj_scanpos = xsp;
    if (jj_3_109()) return true;
    }
    return false;
  }

  static final private boolean jj_3_104() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  static final private boolean jj_3_105() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    if (jj_scan_token(68)) return true;
    return false;
  }

  static final private boolean jj_3_106() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    if (jj_3_104()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_104()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static final private boolean jj_3_107() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_105()) {
    jj_scanpos = xsp;
    if (jj_3_106()) return true;
    }
    return false;
  }

  static final private boolean jj_3R_35() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(ASSIGN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_101()) {
    jj_scanpos = xsp;
    if (jj_3_102()) return true;
    }
    return false;
  }

  static final private boolean jj_3_43() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  static final private boolean jj_3R_41() {
    if (jj_scan_token(INDEX_TOKEN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static final private boolean jj_3_94() {
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  static final private boolean jj_3_40() {
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  static final private boolean jj_3_91() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  static final private boolean jj_3_48() {
    if (jj_3R_37()) return true;
    return false;
  }

  static final private boolean jj_3_92() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_91()) jj_scanpos = xsp;
    return false;
  }

  static final private boolean jj_3_83() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  static final private boolean jj_3_96() {
    if (jj_scan_token(DESCRIPTION)) return true;
    if (jj_scan_token(DESCRIPTOR_LITERAL)) return true;
    return false;
  }

  static final private boolean jj_3_38() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  static final private boolean jj_3_74() {
    if (jj_3R_44()) return true;
    return false;
  }

  static final private boolean jj_3_81() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  static final private boolean jj_3_79() {
    if (jj_scan_token(NOTIFICATION_GROUP_TOKEN)) return true;
    return false;
  }

  static final private boolean jj_3_50() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  static final private boolean jj_3_84() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_83()) jj_scanpos = xsp;
    return false;
  }

  static final private boolean jj_3_93() {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static final private boolean jj_3_44() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  static final private boolean jj_3_31() {
    if (jj_scan_token(OBJECT_GROUP_TOKEN)) return true;
    return false;
  }

  static final private boolean jj_3R_38() {
    if (jj_scan_token(SEQUENCE_TOKEN)) return true;
    if (jj_scan_token(OF_TOKEN)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static final private boolean jj_3_39() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_37()) {
    jj_scanpos = xsp;
    if (jj_3_38()) return true;
    }
    return false;
  }

  static final private boolean jj_3_37() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static final private boolean jj_3_35() {
    if (jj_scan_token(UNITS_TOKEN)) return true;
    return false;
  }

  static final private boolean jj_3_82() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_81()) jj_scanpos = xsp;
    return false;
  }

  static final private boolean jj_3_55() {
    if (jj_scan_token(OCTET_TOKEN)) return true;
    if (jj_scan_token(STRING_TOKEN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_48()) jj_scanpos = xsp;
    return false;
  }

  static final private boolean jj_3_99() {
    if (jj_scan_token(ASSIGN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_93()) jj_scanpos = xsp;
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    xsp = jj_scanpos;
    if (jj_3_94()) jj_scanpos = xsp;
    return false;
  }

  static final private boolean jj_3_73() {
    if (jj_3R_43()) return true;
    return false;
  }

  static final private boolean jj_3_86() {
    if (jj_scan_token(DESCRIPTION)) return true;
    if (jj_scan_token(DESCRIPTOR_LITERAL)) return true;
    return false;
  }

  static final private boolean jj_3_98() {
    if (jj_scan_token(VARIABLES_TOKEN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    if (jj_3_92()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_92()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static final private boolean jj_3_97() {
    if (jj_scan_token(ENTERPRISE_TOKEN)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static final private boolean jj_3_90() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_95()) {
    jj_scanpos = xsp;
    if (jj_3_96()) {
    jj_scanpos = xsp;
    if (jj_3_97()) {
    jj_scanpos = xsp;
    if (jj_3_98()) {
    jj_scanpos = xsp;
    if (jj_3_99()) return true;
    }
    }
    }
    }
    return false;
  }

  static final private boolean jj_3_95() {
    if (jj_scan_token(STATUS)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  static final private boolean jj_3_45() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_44()) jj_scanpos = xsp;
    return false;
  }

  static final private boolean jj_3_36() {
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  static final private boolean jj_3_60() {
    if (jj_scan_token(MIN_ACCESS_TOKEN)) return true;
    return false;
  }

  static final private boolean jj_3_46() {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  static final private boolean jj_3_78() {
    if (jj_scan_token(NOTIFICATION_TYPE_TOKEN)) return true;
    return false;
  }

  static final private boolean jj_3R_34() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(TRAP_TYPE_TOKEN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_90()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  static final private boolean jj_3_42() {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_36()) jj_scanpos = xsp;
    if (jj_3_39()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_39()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  static final private boolean jj_3_34() {
    if (jj_scan_token(REFERENCE_TOKEN)) return true;
    return false;
  }

  static private boolean jj_initialized_once = false;
  static public ParseMibTokenManager token_source;
  static SimpleCharStream jj_input_stream;
  static public Token token, jj_nt;
  static private int jj_ntk;
  static private Token jj_scanpos, jj_lastpos;
  static private int jj_la;
  static public boolean lookingAhead = false;
  static private boolean jj_semLA;
  static private int jj_gen;
  static final private int[] jj_la1 = new int[0];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {};
   }
  static final private JJCalls[] jj_2_rtns = new JJCalls[154];
  static private boolean jj_rescan = false;
  static private int jj_gc = 0;

  public ParseMib(java.io.InputStream stream) {
    if (jj_initialized_once) {
      System.out.println("ERROR: Second call to constructor of static parser.  You must");
      System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
      System.out.println("       during parser generation.");
      throw new Error();
    }
    jj_initialized_once = true;
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new ParseMibTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  static public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public ParseMib(java.io.Reader stream) {
    if (jj_initialized_once) {
      System.out.println("ERROR: Second call to constructor of static parser.  You must");
      System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
      System.out.println("       during parser generation.");
      throw new Error();
    }
    jj_initialized_once = true;
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new ParseMibTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  static public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public ParseMib(ParseMibTokenManager tm) {
    if (jj_initialized_once) {
      System.out.println("ERROR: Second call to constructor of static parser.  You must");
      System.out.println("       either use ReInit() or set the JavaCC option STATIC to false");
      System.out.println("       during parser generation.");
      throw new Error();
    }
    jj_initialized_once = true;
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(ParseMibTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  static final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  static final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  static final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  static final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  static final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  static final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  static private java.util.Vector jj_expentries = new java.util.Vector();
  static private int[] jj_expentry;
  static private int jj_kind = -1;
  static private int[] jj_lasttokens = new int[100];
  static private int jj_endpos;

  static private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  static public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[70];
    for (int i = 0; i < 70; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 0; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 70; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  static final public void enable_tracing() {
  }

  static final public void disable_tracing() {
  }

  static final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 154; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
            case 47: jj_3_48(); break;
            case 48: jj_3_49(); break;
            case 49: jj_3_50(); break;
            case 50: jj_3_51(); break;
            case 51: jj_3_52(); break;
            case 52: jj_3_53(); break;
            case 53: jj_3_54(); break;
            case 54: jj_3_55(); break;
            case 55: jj_3_56(); break;
            case 56: jj_3_57(); break;
            case 57: jj_3_58(); break;
            case 58: jj_3_59(); break;
            case 59: jj_3_60(); break;
            case 60: jj_3_61(); break;
            case 61: jj_3_62(); break;
            case 62: jj_3_63(); break;
            case 63: jj_3_64(); break;
            case 64: jj_3_65(); break;
            case 65: jj_3_66(); break;
            case 66: jj_3_67(); break;
            case 67: jj_3_68(); break;
            case 68: jj_3_69(); break;
            case 69: jj_3_70(); break;
            case 70: jj_3_71(); break;
            case 71: jj_3_72(); break;
            case 72: jj_3_73(); break;
            case 73: jj_3_74(); break;
            case 74: jj_3_75(); break;
            case 75: jj_3_76(); break;
            case 76: jj_3_77(); break;
            case 77: jj_3_78(); break;
            case 78: jj_3_79(); break;
            case 79: jj_3_80(); break;
            case 80: jj_3_81(); break;
            case 81: jj_3_82(); break;
            case 82: jj_3_83(); break;
            case 83: jj_3_84(); break;
            case 84: jj_3_85(); break;
            case 85: jj_3_86(); break;
            case 86: jj_3_87(); break;
            case 87: jj_3_88(); break;
            case 88: jj_3_89(); break;
            case 89: jj_3_90(); break;
            case 90: jj_3_91(); break;
            case 91: jj_3_92(); break;
            case 92: jj_3_93(); break;
            case 93: jj_3_94(); break;
            case 94: jj_3_95(); break;
            case 95: jj_3_96(); break;
            case 96: jj_3_97(); break;
            case 97: jj_3_98(); break;
            case 98: jj_3_99(); break;
            case 99: jj_3_100(); break;
            case 100: jj_3_101(); break;
            case 101: jj_3_102(); break;
            case 102: jj_3_103(); break;
            case 103: jj_3_104(); break;
            case 104: jj_3_105(); break;
            case 105: jj_3_106(); break;
            case 106: jj_3_107(); break;
            case 107: jj_3_108(); break;
            case 108: jj_3_109(); break;
            case 109: jj_3_110(); break;
            case 110: jj_3_111(); break;
            case 111: jj_3_112(); break;
            case 112: jj_3_113(); break;
            case 113: jj_3_114(); break;
            case 114: jj_3_115(); break;
            case 115: jj_3_116(); break;
            case 116: jj_3_117(); break;
            case 117: jj_3_118(); break;
            case 118: jj_3_119(); break;
            case 119: jj_3_120(); break;
            case 120: jj_3_121(); break;
            case 121: jj_3_122(); break;
            case 122: jj_3_123(); break;
            case 123: jj_3_124(); break;
            case 124: jj_3_125(); break;
            case 125: jj_3_126(); break;
            case 126: jj_3_127(); break;
            case 127: jj_3_128(); break;
            case 128: jj_3_129(); break;
            case 129: jj_3_130(); break;
            case 130: jj_3_131(); break;
            case 131: jj_3_132(); break;
            case 132: jj_3_133(); break;
            case 133: jj_3_134(); break;
            case 134: jj_3_135(); break;
            case 135: jj_3_136(); break;
            case 136: jj_3_137(); break;
            case 137: jj_3_138(); break;
            case 138: jj_3_139(); break;
            case 139: jj_3_140(); break;
            case 140: jj_3_141(); break;
            case 141: jj_3_142(); break;
            case 142: jj_3_143(); break;
            case 143: jj_3_144(); break;
            case 144: jj_3_145(); break;
            case 145: jj_3_146(); break;
            case 146: jj_3_147(); break;
            case 147: jj_3_148(); break;
            case 148: jj_3_149(); break;
            case 149: jj_3_150(); break;
            case 150: jj_3_151(); break;
            case 151: jj_3_152(); break;
            case 152: jj_3_153(); break;
            case 153: jj_3_154(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  static final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
