/*******************************************************************************
 * This file is part of OpenNMS(R).
 *
 * Copyright (C) 2018 The OpenNMS Group, Inc.
 * OpenNMS(R) is Copyright (C) 1999-2018 The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
 *
 * OpenNMS(R) is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * OpenNMS(R) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OpenNMS(R).  If not, see:
 *      http://www.gnu.org/licenses/
 *
 * For more information contact:
 *     OpenNMS(R) Licensing <license@opennms.org>
 *     http://www.opennms.org/
 *     http://www.opennms.com/
 *******************************************************************************/

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: opennms-kafka-producer.proto

package org.opennms.features.kafka.producer.model;

public final class OpennmsModelProtos {
  private OpennmsModelProtos() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * The values differ from the standard codes in OpenNMS
   * since proto3 enforces us to start at 0
   * </pre>
   *
   * Protobuf enum {@code Severity}
   */
  public enum Severity
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>INDETERMINATE = 0;</code>
     */
    INDETERMINATE(0),
    /**
     * <code>CLEARED = 1;</code>
     */
    CLEARED(1),
    /**
     * <code>NORMAL = 2;</code>
     */
    NORMAL(2),
    /**
     * <code>WARNING = 3;</code>
     */
    WARNING(3),
    /**
     * <code>MINOR = 4;</code>
     */
    MINOR(4),
    /**
     * <code>MAJOR = 5;</code>
     */
    MAJOR(5),
    /**
     * <code>CRITICAL = 6;</code>
     */
    CRITICAL(6),
    UNRECOGNIZED(-1),
    ;

    /**
     * <code>INDETERMINATE = 0;</code>
     */
    public static final int INDETERMINATE_VALUE = 0;
    /**
     * <code>CLEARED = 1;</code>
     */
    public static final int CLEARED_VALUE = 1;
    /**
     * <code>NORMAL = 2;</code>
     */
    public static final int NORMAL_VALUE = 2;
    /**
     * <code>WARNING = 3;</code>
     */
    public static final int WARNING_VALUE = 3;
    /**
     * <code>MINOR = 4;</code>
     */
    public static final int MINOR_VALUE = 4;
    /**
     * <code>MAJOR = 5;</code>
     */
    public static final int MAJOR_VALUE = 5;
    /**
     * <code>CRITICAL = 6;</code>
     */
    public static final int CRITICAL_VALUE = 6;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Severity valueOf(int value) {
      return forNumber(value);
    }

    public static Severity forNumber(int value) {
      switch (value) {
        case 0: return INDETERMINATE;
        case 1: return CLEARED;
        case 2: return NORMAL;
        case 3: return WARNING;
        case 4: return MINOR;
        case 5: return MAJOR;
        case 6: return CRITICAL;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Severity>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        Severity> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Severity>() {
            public Severity findValueByNumber(int number) {
              return Severity.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.opennms.features.kafka.producer.model.OpennmsModelProtos.getDescriptor().getEnumTypes().get(0);
    }

    private static final Severity[] VALUES = values();

    public static Severity valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Severity(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:Severity)
  }

  public interface NodeCriteriaOrBuilder extends
      // @@protoc_insertion_point(interface_extends:NodeCriteria)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>uint64 id = 1;</code>
     */
    long getId();

    /**
     * <code>string foreign_source = 2;</code>
     */
    java.lang.String getForeignSource();
    /**
     * <code>string foreign_source = 2;</code>
     */
    com.google.protobuf.ByteString
        getForeignSourceBytes();

    /**
     * <code>string foreign_id = 3;</code>
     */
    java.lang.String getForeignId();
    /**
     * <code>string foreign_id = 3;</code>
     */
    com.google.protobuf.ByteString
        getForeignIdBytes();
  }
  /**
   * Protobuf type {@code NodeCriteria}
   */
  public  static final class NodeCriteria extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:NodeCriteria)
      NodeCriteriaOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use NodeCriteria.newBuilder() to construct.
    private NodeCriteria(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private NodeCriteria() {
      id_ = 0L;
      foreignSource_ = "";
      foreignId_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private NodeCriteria(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {

              id_ = input.readUInt64();
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              foreignSource_ = s;
              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();

              foreignId_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_NodeCriteria_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_NodeCriteria_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.class, org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.Builder.class);
    }

    public static final int ID_FIELD_NUMBER = 1;
    private long id_;
    /**
     * <code>uint64 id = 1;</code>
     */
    public long getId() {
      return id_;
    }

    public static final int FOREIGN_SOURCE_FIELD_NUMBER = 2;
    private volatile java.lang.Object foreignSource_;
    /**
     * <code>string foreign_source = 2;</code>
     */
    public java.lang.String getForeignSource() {
      java.lang.Object ref = foreignSource_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        foreignSource_ = s;
        return s;
      }
    }
    /**
     * <code>string foreign_source = 2;</code>
     */
    public com.google.protobuf.ByteString
        getForeignSourceBytes() {
      java.lang.Object ref = foreignSource_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        foreignSource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FOREIGN_ID_FIELD_NUMBER = 3;
    private volatile java.lang.Object foreignId_;
    /**
     * <code>string foreign_id = 3;</code>
     */
    public java.lang.String getForeignId() {
      java.lang.Object ref = foreignId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        foreignId_ = s;
        return s;
      }
    }
    /**
     * <code>string foreign_id = 3;</code>
     */
    public com.google.protobuf.ByteString
        getForeignIdBytes() {
      java.lang.Object ref = foreignId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        foreignId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (id_ != 0L) {
        output.writeUInt64(1, id_);
      }
      if (!getForeignSourceBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, foreignSource_);
      }
      if (!getForeignIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, foreignId_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (id_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(1, id_);
      }
      if (!getForeignSourceBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, foreignSource_);
      }
      if (!getForeignIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, foreignId_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria)) {
        return super.equals(obj);
      }
      org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria other = (org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria) obj;

      boolean result = true;
      result = result && (getId()
          == other.getId());
      result = result && getForeignSource()
          .equals(other.getForeignSource());
      result = result && getForeignId()
          .equals(other.getForeignId());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getId());
      hash = (37 * hash) + FOREIGN_SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getForeignSource().hashCode();
      hash = (37 * hash) + FOREIGN_ID_FIELD_NUMBER;
      hash = (53 * hash) + getForeignId().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code NodeCriteria}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:NodeCriteria)
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteriaOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_NodeCriteria_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_NodeCriteria_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.class, org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.Builder.class);
      }

      // Construct using org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        id_ = 0L;

        foreignSource_ = "";

        foreignId_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_NodeCriteria_descriptor;
      }

      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria getDefaultInstanceForType() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.getDefaultInstance();
      }

      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria build() {
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria buildPartial() {
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria result = new org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria(this);
        result.id_ = id_;
        result.foreignSource_ = foreignSource_;
        result.foreignId_ = foreignId_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria) {
          return mergeFrom((org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria other) {
        if (other == org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.getDefaultInstance()) return this;
        if (other.getId() != 0L) {
          setId(other.getId());
        }
        if (!other.getForeignSource().isEmpty()) {
          foreignSource_ = other.foreignSource_;
          onChanged();
        }
        if (!other.getForeignId().isEmpty()) {
          foreignId_ = other.foreignId_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private long id_ ;
      /**
       * <code>uint64 id = 1;</code>
       */
      public long getId() {
        return id_;
      }
      /**
       * <code>uint64 id = 1;</code>
       */
      public Builder setId(long value) {
        
        id_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>uint64 id = 1;</code>
       */
      public Builder clearId() {
        
        id_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object foreignSource_ = "";
      /**
       * <code>string foreign_source = 2;</code>
       */
      public java.lang.String getForeignSource() {
        java.lang.Object ref = foreignSource_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          foreignSource_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string foreign_source = 2;</code>
       */
      public com.google.protobuf.ByteString
          getForeignSourceBytes() {
        java.lang.Object ref = foreignSource_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          foreignSource_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string foreign_source = 2;</code>
       */
      public Builder setForeignSource(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        foreignSource_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string foreign_source = 2;</code>
       */
      public Builder clearForeignSource() {
        
        foreignSource_ = getDefaultInstance().getForeignSource();
        onChanged();
        return this;
      }
      /**
       * <code>string foreign_source = 2;</code>
       */
      public Builder setForeignSourceBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        foreignSource_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object foreignId_ = "";
      /**
       * <code>string foreign_id = 3;</code>
       */
      public java.lang.String getForeignId() {
        java.lang.Object ref = foreignId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          foreignId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string foreign_id = 3;</code>
       */
      public com.google.protobuf.ByteString
          getForeignIdBytes() {
        java.lang.Object ref = foreignId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          foreignId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string foreign_id = 3;</code>
       */
      public Builder setForeignId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        foreignId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string foreign_id = 3;</code>
       */
      public Builder clearForeignId() {
        
        foreignId_ = getDefaultInstance().getForeignId();
        onChanged();
        return this;
      }
      /**
       * <code>string foreign_id = 3;</code>
       */
      public Builder setForeignIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        foreignId_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:NodeCriteria)
    }

    // @@protoc_insertion_point(class_scope:NodeCriteria)
    private static final org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria();
    }

    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<NodeCriteria>
        PARSER = new com.google.protobuf.AbstractParser<NodeCriteria>() {
      public NodeCriteria parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new NodeCriteria(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<NodeCriteria> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<NodeCriteria> getParserForType() {
      return PARSER;
    }

    public org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface EventParameterOrBuilder extends
      // @@protoc_insertion_point(interface_extends:EventParameter)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>string name = 1;</code>
     */
    java.lang.String getName();
    /**
     * <code>string name = 1;</code>
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <code>string value = 2;</code>
     */
    java.lang.String getValue();
    /**
     * <code>string value = 2;</code>
     */
    com.google.protobuf.ByteString
        getValueBytes();

    /**
     * <code>string type = 3;</code>
     */
    java.lang.String getType();
    /**
     * <code>string type = 3;</code>
     */
    com.google.protobuf.ByteString
        getTypeBytes();
  }
  /**
   * Protobuf type {@code EventParameter}
   */
  public  static final class EventParameter extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:EventParameter)
      EventParameterOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use EventParameter.newBuilder() to construct.
    private EventParameter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private EventParameter() {
      name_ = "";
      value_ = "";
      type_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private EventParameter(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              value_ = s;
              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();

              type_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_EventParameter_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_EventParameter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter.class, org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object name_;
    /**
     * <code>string name = 1;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     * <code>string name = 1;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALUE_FIELD_NUMBER = 2;
    private volatile java.lang.Object value_;
    /**
     * <code>string value = 2;</code>
     */
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        value_ = s;
        return s;
      }
    }
    /**
     * <code>string value = 2;</code>
     */
    public com.google.protobuf.ByteString
        getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TYPE_FIELD_NUMBER = 3;
    private volatile java.lang.Object type_;
    /**
     * <code>string type = 3;</code>
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      }
    }
    /**
     * <code>string type = 3;</code>
     */
    public com.google.protobuf.ByteString
        getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (!getValueBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, value_);
      }
      if (!getTypeBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, type_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (!getValueBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, value_);
      }
      if (!getTypeBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, type_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter)) {
        return super.equals(obj);
      }
      org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter other = (org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter) obj;

      boolean result = true;
      result = result && getName()
          .equals(other.getName());
      result = result && getValue()
          .equals(other.getValue());
      result = result && getType()
          .equals(other.getType());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getValue().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getType().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code EventParameter}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:EventParameter)
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_EventParameter_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_EventParameter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter.class, org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter.Builder.class);
      }

      // Construct using org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        name_ = "";

        value_ = "";

        type_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_EventParameter_descriptor;
      }

      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter getDefaultInstanceForType() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter.getDefaultInstance();
      }

      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter build() {
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter buildPartial() {
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter result = new org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter(this);
        result.name_ = name_;
        result.value_ = value_;
        result.type_ = type_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter) {
          return mergeFrom((org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter other) {
        if (other == org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter.getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        if (!other.getValue().isEmpty()) {
          value_ = other.value_;
          onChanged();
        }
        if (!other.getType().isEmpty()) {
          type_ = other.type_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       * <code>string name = 1;</code>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string name = 1;</code>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string name = 1;</code>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string name = 1;</code>
       */
      public Builder clearName() {
        
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <code>string name = 1;</code>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        name_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object value_ = "";
      /**
       * <code>string value = 2;</code>
       */
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          value_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string value = 2;</code>
       */
      public com.google.protobuf.ByteString
          getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string value = 2;</code>
       */
      public Builder setValue(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        value_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string value = 2;</code>
       */
      public Builder clearValue() {
        
        value_ = getDefaultInstance().getValue();
        onChanged();
        return this;
      }
      /**
       * <code>string value = 2;</code>
       */
      public Builder setValueBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        value_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object type_ = "";
      /**
       * <code>string type = 3;</code>
       */
      public java.lang.String getType() {
        java.lang.Object ref = type_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          type_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string type = 3;</code>
       */
      public com.google.protobuf.ByteString
          getTypeBytes() {
        java.lang.Object ref = type_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          type_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string type = 3;</code>
       */
      public Builder setType(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string type = 3;</code>
       */
      public Builder clearType() {
        
        type_ = getDefaultInstance().getType();
        onChanged();
        return this;
      }
      /**
       * <code>string type = 3;</code>
       */
      public Builder setTypeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        type_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:EventParameter)
    }

    // @@protoc_insertion_point(class_scope:EventParameter)
    private static final org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter();
    }

    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<EventParameter>
        PARSER = new com.google.protobuf.AbstractParser<EventParameter>() {
      public EventParameter parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new EventParameter(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<EventParameter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<EventParameter> getParserForType() {
      return PARSER;
    }

    public org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface EventOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Event)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>uint64 id = 1;</code>
     */
    long getId();

    /**
     * <code>string uei = 2;</code>
     */
    java.lang.String getUei();
    /**
     * <code>string uei = 2;</code>
     */
    com.google.protobuf.ByteString
        getUeiBytes();

    /**
     * <code>string label = 3;</code>
     */
    java.lang.String getLabel();
    /**
     * <code>string label = 3;</code>
     */
    com.google.protobuf.ByteString
        getLabelBytes();

    /**
     * <code>uint64 time = 4;</code>
     */
    long getTime();

    /**
     * <code>string source = 5;</code>
     */
    java.lang.String getSource();
    /**
     * <code>string source = 5;</code>
     */
    com.google.protobuf.ByteString
        getSourceBytes();

    /**
     * <code>repeated .EventParameter parameter = 6;</code>
     */
    java.util.List<org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter> 
        getParameterList();
    /**
     * <code>repeated .EventParameter parameter = 6;</code>
     */
    org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter getParameter(int index);
    /**
     * <code>repeated .EventParameter parameter = 6;</code>
     */
    int getParameterCount();
    /**
     * <code>repeated .EventParameter parameter = 6;</code>
     */
    java.util.List<? extends org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameterOrBuilder> 
        getParameterOrBuilderList();
    /**
     * <code>repeated .EventParameter parameter = 6;</code>
     */
    org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameterOrBuilder getParameterOrBuilder(
        int index);

    /**
     * <code>uint64 create_time = 7;</code>
     */
    long getCreateTime();

    /**
     * <code>string description = 8;</code>
     */
    java.lang.String getDescription();
    /**
     * <code>string description = 8;</code>
     */
    com.google.protobuf.ByteString
        getDescriptionBytes();

    /**
     * <code>string log_message = 9;</code>
     */
    java.lang.String getLogMessage();
    /**
     * <code>string log_message = 9;</code>
     */
    com.google.protobuf.ByteString
        getLogMessageBytes();

    /**
     * <code>.Severity severity = 10;</code>
     */
    int getSeverityValue();
    /**
     * <code>.Severity severity = 10;</code>
     */
    org.opennms.features.kafka.producer.model.OpennmsModelProtos.Severity getSeverity();

    /**
     * <code>bool log = 11;</code>
     */
    boolean getLog();

    /**
     * <code>bool display = 12;</code>
     */
    boolean getDisplay();

    /**
     * <code>.NodeCriteria node_criteria = 13;</code>
     */
    boolean hasNodeCriteria();
    /**
     * <code>.NodeCriteria node_criteria = 13;</code>
     */
    org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria getNodeCriteria();
    /**
     * <code>.NodeCriteria node_criteria = 13;</code>
     */
    org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteriaOrBuilder getNodeCriteriaOrBuilder();

    /**
     * <code>string ip_address = 14;</code>
     */
    java.lang.String getIpAddress();
    /**
     * <code>string ip_address = 14;</code>
     */
    com.google.protobuf.ByteString
        getIpAddressBytes();
  }
  /**
   * Protobuf type {@code Event}
   */
  public  static final class Event extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:Event)
      EventOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Event.newBuilder() to construct.
    private Event(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Event() {
      id_ = 0L;
      uei_ = "";
      label_ = "";
      time_ = 0L;
      source_ = "";
      parameter_ = java.util.Collections.emptyList();
      createTime_ = 0L;
      description_ = "";
      logMessage_ = "";
      severity_ = 0;
      log_ = false;
      display_ = false;
      ipAddress_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Event(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {

              id_ = input.readUInt64();
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              uei_ = s;
              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();

              label_ = s;
              break;
            }
            case 32: {

              time_ = input.readUInt64();
              break;
            }
            case 42: {
              java.lang.String s = input.readStringRequireUtf8();

              source_ = s;
              break;
            }
            case 50: {
              if (!((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
                parameter_ = new java.util.ArrayList<org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter>();
                mutable_bitField0_ |= 0x00000020;
              }
              parameter_.add(
                  input.readMessage(org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter.parser(), extensionRegistry));
              break;
            }
            case 56: {

              createTime_ = input.readUInt64();
              break;
            }
            case 66: {
              java.lang.String s = input.readStringRequireUtf8();

              description_ = s;
              break;
            }
            case 74: {
              java.lang.String s = input.readStringRequireUtf8();

              logMessage_ = s;
              break;
            }
            case 80: {
              int rawValue = input.readEnum();

              severity_ = rawValue;
              break;
            }
            case 88: {

              log_ = input.readBool();
              break;
            }
            case 96: {

              display_ = input.readBool();
              break;
            }
            case 106: {
              org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.Builder subBuilder = null;
              if (nodeCriteria_ != null) {
                subBuilder = nodeCriteria_.toBuilder();
              }
              nodeCriteria_ = input.readMessage(org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(nodeCriteria_);
                nodeCriteria_ = subBuilder.buildPartial();
              }

              break;
            }
            case 114: {
              java.lang.String s = input.readStringRequireUtf8();

              ipAddress_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
          parameter_ = java.util.Collections.unmodifiableList(parameter_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_Event_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_Event_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event.class, org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event.Builder.class);
    }

    private int bitField0_;
    public static final int ID_FIELD_NUMBER = 1;
    private long id_;
    /**
     * <code>uint64 id = 1;</code>
     */
    public long getId() {
      return id_;
    }

    public static final int UEI_FIELD_NUMBER = 2;
    private volatile java.lang.Object uei_;
    /**
     * <code>string uei = 2;</code>
     */
    public java.lang.String getUei() {
      java.lang.Object ref = uei_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uei_ = s;
        return s;
      }
    }
    /**
     * <code>string uei = 2;</code>
     */
    public com.google.protobuf.ByteString
        getUeiBytes() {
      java.lang.Object ref = uei_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        uei_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LABEL_FIELD_NUMBER = 3;
    private volatile java.lang.Object label_;
    /**
     * <code>string label = 3;</code>
     */
    public java.lang.String getLabel() {
      java.lang.Object ref = label_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        label_ = s;
        return s;
      }
    }
    /**
     * <code>string label = 3;</code>
     */
    public com.google.protobuf.ByteString
        getLabelBytes() {
      java.lang.Object ref = label_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        label_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TIME_FIELD_NUMBER = 4;
    private long time_;
    /**
     * <code>uint64 time = 4;</code>
     */
    public long getTime() {
      return time_;
    }

    public static final int SOURCE_FIELD_NUMBER = 5;
    private volatile java.lang.Object source_;
    /**
     * <code>string source = 5;</code>
     */
    public java.lang.String getSource() {
      java.lang.Object ref = source_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        source_ = s;
        return s;
      }
    }
    /**
     * <code>string source = 5;</code>
     */
    public com.google.protobuf.ByteString
        getSourceBytes() {
      java.lang.Object ref = source_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        source_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PARAMETER_FIELD_NUMBER = 6;
    private java.util.List<org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter> parameter_;
    /**
     * <code>repeated .EventParameter parameter = 6;</code>
     */
    public java.util.List<org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter> getParameterList() {
      return parameter_;
    }
    /**
     * <code>repeated .EventParameter parameter = 6;</code>
     */
    public java.util.List<? extends org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameterOrBuilder> 
        getParameterOrBuilderList() {
      return parameter_;
    }
    /**
     * <code>repeated .EventParameter parameter = 6;</code>
     */
    public int getParameterCount() {
      return parameter_.size();
    }
    /**
     * <code>repeated .EventParameter parameter = 6;</code>
     */
    public org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter getParameter(int index) {
      return parameter_.get(index);
    }
    /**
     * <code>repeated .EventParameter parameter = 6;</code>
     */
    public org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameterOrBuilder getParameterOrBuilder(
        int index) {
      return parameter_.get(index);
    }

    public static final int CREATE_TIME_FIELD_NUMBER = 7;
    private long createTime_;
    /**
     * <code>uint64 create_time = 7;</code>
     */
    public long getCreateTime() {
      return createTime_;
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 8;
    private volatile java.lang.Object description_;
    /**
     * <code>string description = 8;</code>
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     * <code>string description = 8;</code>
     */
    public com.google.protobuf.ByteString
        getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LOG_MESSAGE_FIELD_NUMBER = 9;
    private volatile java.lang.Object logMessage_;
    /**
     * <code>string log_message = 9;</code>
     */
    public java.lang.String getLogMessage() {
      java.lang.Object ref = logMessage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        logMessage_ = s;
        return s;
      }
    }
    /**
     * <code>string log_message = 9;</code>
     */
    public com.google.protobuf.ByteString
        getLogMessageBytes() {
      java.lang.Object ref = logMessage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        logMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SEVERITY_FIELD_NUMBER = 10;
    private int severity_;
    /**
     * <code>.Severity severity = 10;</code>
     */
    public int getSeverityValue() {
      return severity_;
    }
    /**
     * <code>.Severity severity = 10;</code>
     */
    public org.opennms.features.kafka.producer.model.OpennmsModelProtos.Severity getSeverity() {
      org.opennms.features.kafka.producer.model.OpennmsModelProtos.Severity result = org.opennms.features.kafka.producer.model.OpennmsModelProtos.Severity.valueOf(severity_);
      return result == null ? org.opennms.features.kafka.producer.model.OpennmsModelProtos.Severity.UNRECOGNIZED : result;
    }

    public static final int LOG_FIELD_NUMBER = 11;
    private boolean log_;
    /**
     * <code>bool log = 11;</code>
     */
    public boolean getLog() {
      return log_;
    }

    public static final int DISPLAY_FIELD_NUMBER = 12;
    private boolean display_;
    /**
     * <code>bool display = 12;</code>
     */
    public boolean getDisplay() {
      return display_;
    }

    public static final int NODE_CRITERIA_FIELD_NUMBER = 13;
    private org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria nodeCriteria_;
    /**
     * <code>.NodeCriteria node_criteria = 13;</code>
     */
    public boolean hasNodeCriteria() {
      return nodeCriteria_ != null;
    }
    /**
     * <code>.NodeCriteria node_criteria = 13;</code>
     */
    public org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria getNodeCriteria() {
      return nodeCriteria_ == null ? org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.getDefaultInstance() : nodeCriteria_;
    }
    /**
     * <code>.NodeCriteria node_criteria = 13;</code>
     */
    public org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteriaOrBuilder getNodeCriteriaOrBuilder() {
      return getNodeCriteria();
    }

    public static final int IP_ADDRESS_FIELD_NUMBER = 14;
    private volatile java.lang.Object ipAddress_;
    /**
     * <code>string ip_address = 14;</code>
     */
    public java.lang.String getIpAddress() {
      java.lang.Object ref = ipAddress_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipAddress_ = s;
        return s;
      }
    }
    /**
     * <code>string ip_address = 14;</code>
     */
    public com.google.protobuf.ByteString
        getIpAddressBytes() {
      java.lang.Object ref = ipAddress_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        ipAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (id_ != 0L) {
        output.writeUInt64(1, id_);
      }
      if (!getUeiBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uei_);
      }
      if (!getLabelBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, label_);
      }
      if (time_ != 0L) {
        output.writeUInt64(4, time_);
      }
      if (!getSourceBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, source_);
      }
      for (int i = 0; i < parameter_.size(); i++) {
        output.writeMessage(6, parameter_.get(i));
      }
      if (createTime_ != 0L) {
        output.writeUInt64(7, createTime_);
      }
      if (!getDescriptionBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 8, description_);
      }
      if (!getLogMessageBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 9, logMessage_);
      }
      if (severity_ != org.opennms.features.kafka.producer.model.OpennmsModelProtos.Severity.INDETERMINATE.getNumber()) {
        output.writeEnum(10, severity_);
      }
      if (log_ != false) {
        output.writeBool(11, log_);
      }
      if (display_ != false) {
        output.writeBool(12, display_);
      }
      if (nodeCriteria_ != null) {
        output.writeMessage(13, getNodeCriteria());
      }
      if (!getIpAddressBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 14, ipAddress_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (id_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(1, id_);
      }
      if (!getUeiBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uei_);
      }
      if (!getLabelBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, label_);
      }
      if (time_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(4, time_);
      }
      if (!getSourceBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, source_);
      }
      for (int i = 0; i < parameter_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, parameter_.get(i));
      }
      if (createTime_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(7, createTime_);
      }
      if (!getDescriptionBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, description_);
      }
      if (!getLogMessageBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, logMessage_);
      }
      if (severity_ != org.opennms.features.kafka.producer.model.OpennmsModelProtos.Severity.INDETERMINATE.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(10, severity_);
      }
      if (log_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(11, log_);
      }
      if (display_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(12, display_);
      }
      if (nodeCriteria_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(13, getNodeCriteria());
      }
      if (!getIpAddressBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, ipAddress_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event)) {
        return super.equals(obj);
      }
      org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event other = (org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event) obj;

      boolean result = true;
      result = result && (getId()
          == other.getId());
      result = result && getUei()
          .equals(other.getUei());
      result = result && getLabel()
          .equals(other.getLabel());
      result = result && (getTime()
          == other.getTime());
      result = result && getSource()
          .equals(other.getSource());
      result = result && getParameterList()
          .equals(other.getParameterList());
      result = result && (getCreateTime()
          == other.getCreateTime());
      result = result && getDescription()
          .equals(other.getDescription());
      result = result && getLogMessage()
          .equals(other.getLogMessage());
      result = result && severity_ == other.severity_;
      result = result && (getLog()
          == other.getLog());
      result = result && (getDisplay()
          == other.getDisplay());
      result = result && (hasNodeCriteria() == other.hasNodeCriteria());
      if (hasNodeCriteria()) {
        result = result && getNodeCriteria()
            .equals(other.getNodeCriteria());
      }
      result = result && getIpAddress()
          .equals(other.getIpAddress());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getId());
      hash = (37 * hash) + UEI_FIELD_NUMBER;
      hash = (53 * hash) + getUei().hashCode();
      hash = (37 * hash) + LABEL_FIELD_NUMBER;
      hash = (53 * hash) + getLabel().hashCode();
      hash = (37 * hash) + TIME_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getTime());
      hash = (37 * hash) + SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getSource().hashCode();
      if (getParameterCount() > 0) {
        hash = (37 * hash) + PARAMETER_FIELD_NUMBER;
        hash = (53 * hash) + getParameterList().hashCode();
      }
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getCreateTime());
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      hash = (37 * hash) + LOG_MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getLogMessage().hashCode();
      hash = (37 * hash) + SEVERITY_FIELD_NUMBER;
      hash = (53 * hash) + severity_;
      hash = (37 * hash) + LOG_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getLog());
      hash = (37 * hash) + DISPLAY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getDisplay());
      if (hasNodeCriteria()) {
        hash = (37 * hash) + NODE_CRITERIA_FIELD_NUMBER;
        hash = (53 * hash) + getNodeCriteria().hashCode();
      }
      hash = (37 * hash) + IP_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getIpAddress().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Event}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Event)
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_Event_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_Event_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event.class, org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event.Builder.class);
      }

      // Construct using org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getParameterFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        id_ = 0L;

        uei_ = "";

        label_ = "";

        time_ = 0L;

        source_ = "";

        if (parameterBuilder_ == null) {
          parameter_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000020);
        } else {
          parameterBuilder_.clear();
        }
        createTime_ = 0L;

        description_ = "";

        logMessage_ = "";

        severity_ = 0;

        log_ = false;

        display_ = false;

        if (nodeCriteriaBuilder_ == null) {
          nodeCriteria_ = null;
        } else {
          nodeCriteria_ = null;
          nodeCriteriaBuilder_ = null;
        }
        ipAddress_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_Event_descriptor;
      }

      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event getDefaultInstanceForType() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event.getDefaultInstance();
      }

      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event build() {
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event buildPartial() {
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event result = new org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        result.id_ = id_;
        result.uei_ = uei_;
        result.label_ = label_;
        result.time_ = time_;
        result.source_ = source_;
        if (parameterBuilder_ == null) {
          if (((bitField0_ & 0x00000020) == 0x00000020)) {
            parameter_ = java.util.Collections.unmodifiableList(parameter_);
            bitField0_ = (bitField0_ & ~0x00000020);
          }
          result.parameter_ = parameter_;
        } else {
          result.parameter_ = parameterBuilder_.build();
        }
        result.createTime_ = createTime_;
        result.description_ = description_;
        result.logMessage_ = logMessage_;
        result.severity_ = severity_;
        result.log_ = log_;
        result.display_ = display_;
        if (nodeCriteriaBuilder_ == null) {
          result.nodeCriteria_ = nodeCriteria_;
        } else {
          result.nodeCriteria_ = nodeCriteriaBuilder_.build();
        }
        result.ipAddress_ = ipAddress_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event) {
          return mergeFrom((org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event other) {
        if (other == org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event.getDefaultInstance()) return this;
        if (other.getId() != 0L) {
          setId(other.getId());
        }
        if (!other.getUei().isEmpty()) {
          uei_ = other.uei_;
          onChanged();
        }
        if (!other.getLabel().isEmpty()) {
          label_ = other.label_;
          onChanged();
        }
        if (other.getTime() != 0L) {
          setTime(other.getTime());
        }
        if (!other.getSource().isEmpty()) {
          source_ = other.source_;
          onChanged();
        }
        if (parameterBuilder_ == null) {
          if (!other.parameter_.isEmpty()) {
            if (parameter_.isEmpty()) {
              parameter_ = other.parameter_;
              bitField0_ = (bitField0_ & ~0x00000020);
            } else {
              ensureParameterIsMutable();
              parameter_.addAll(other.parameter_);
            }
            onChanged();
          }
        } else {
          if (!other.parameter_.isEmpty()) {
            if (parameterBuilder_.isEmpty()) {
              parameterBuilder_.dispose();
              parameterBuilder_ = null;
              parameter_ = other.parameter_;
              bitField0_ = (bitField0_ & ~0x00000020);
              parameterBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getParameterFieldBuilder() : null;
            } else {
              parameterBuilder_.addAllMessages(other.parameter_);
            }
          }
        }
        if (other.getCreateTime() != 0L) {
          setCreateTime(other.getCreateTime());
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          onChanged();
        }
        if (!other.getLogMessage().isEmpty()) {
          logMessage_ = other.logMessage_;
          onChanged();
        }
        if (other.severity_ != 0) {
          setSeverityValue(other.getSeverityValue());
        }
        if (other.getLog() != false) {
          setLog(other.getLog());
        }
        if (other.getDisplay() != false) {
          setDisplay(other.getDisplay());
        }
        if (other.hasNodeCriteria()) {
          mergeNodeCriteria(other.getNodeCriteria());
        }
        if (!other.getIpAddress().isEmpty()) {
          ipAddress_ = other.ipAddress_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private long id_ ;
      /**
       * <code>uint64 id = 1;</code>
       */
      public long getId() {
        return id_;
      }
      /**
       * <code>uint64 id = 1;</code>
       */
      public Builder setId(long value) {
        
        id_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>uint64 id = 1;</code>
       */
      public Builder clearId() {
        
        id_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object uei_ = "";
      /**
       * <code>string uei = 2;</code>
       */
      public java.lang.String getUei() {
        java.lang.Object ref = uei_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uei_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string uei = 2;</code>
       */
      public com.google.protobuf.ByteString
          getUeiBytes() {
        java.lang.Object ref = uei_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          uei_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string uei = 2;</code>
       */
      public Builder setUei(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        uei_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string uei = 2;</code>
       */
      public Builder clearUei() {
        
        uei_ = getDefaultInstance().getUei();
        onChanged();
        return this;
      }
      /**
       * <code>string uei = 2;</code>
       */
      public Builder setUeiBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        uei_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object label_ = "";
      /**
       * <code>string label = 3;</code>
       */
      public java.lang.String getLabel() {
        java.lang.Object ref = label_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          label_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string label = 3;</code>
       */
      public com.google.protobuf.ByteString
          getLabelBytes() {
        java.lang.Object ref = label_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          label_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string label = 3;</code>
       */
      public Builder setLabel(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        label_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string label = 3;</code>
       */
      public Builder clearLabel() {
        
        label_ = getDefaultInstance().getLabel();
        onChanged();
        return this;
      }
      /**
       * <code>string label = 3;</code>
       */
      public Builder setLabelBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        label_ = value;
        onChanged();
        return this;
      }

      private long time_ ;
      /**
       * <code>uint64 time = 4;</code>
       */
      public long getTime() {
        return time_;
      }
      /**
       * <code>uint64 time = 4;</code>
       */
      public Builder setTime(long value) {
        
        time_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>uint64 time = 4;</code>
       */
      public Builder clearTime() {
        
        time_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object source_ = "";
      /**
       * <code>string source = 5;</code>
       */
      public java.lang.String getSource() {
        java.lang.Object ref = source_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          source_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string source = 5;</code>
       */
      public com.google.protobuf.ByteString
          getSourceBytes() {
        java.lang.Object ref = source_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          source_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string source = 5;</code>
       */
      public Builder setSource(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        source_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string source = 5;</code>
       */
      public Builder clearSource() {
        
        source_ = getDefaultInstance().getSource();
        onChanged();
        return this;
      }
      /**
       * <code>string source = 5;</code>
       */
      public Builder setSourceBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        source_ = value;
        onChanged();
        return this;
      }

      private java.util.List<org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter> parameter_ =
        java.util.Collections.emptyList();
      private void ensureParameterIsMutable() {
        if (!((bitField0_ & 0x00000020) == 0x00000020)) {
          parameter_ = new java.util.ArrayList<org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter>(parameter_);
          bitField0_ |= 0x00000020;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter, org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter.Builder, org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameterOrBuilder> parameterBuilder_;

      /**
       * <code>repeated .EventParameter parameter = 6;</code>
       */
      public java.util.List<org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter> getParameterList() {
        if (parameterBuilder_ == null) {
          return java.util.Collections.unmodifiableList(parameter_);
        } else {
          return parameterBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .EventParameter parameter = 6;</code>
       */
      public int getParameterCount() {
        if (parameterBuilder_ == null) {
          return parameter_.size();
        } else {
          return parameterBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .EventParameter parameter = 6;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter getParameter(int index) {
        if (parameterBuilder_ == null) {
          return parameter_.get(index);
        } else {
          return parameterBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .EventParameter parameter = 6;</code>
       */
      public Builder setParameter(
          int index, org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter value) {
        if (parameterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParameterIsMutable();
          parameter_.set(index, value);
          onChanged();
        } else {
          parameterBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .EventParameter parameter = 6;</code>
       */
      public Builder setParameter(
          int index, org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter.Builder builderForValue) {
        if (parameterBuilder_ == null) {
          ensureParameterIsMutable();
          parameter_.set(index, builderForValue.build());
          onChanged();
        } else {
          parameterBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .EventParameter parameter = 6;</code>
       */
      public Builder addParameter(org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter value) {
        if (parameterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParameterIsMutable();
          parameter_.add(value);
          onChanged();
        } else {
          parameterBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .EventParameter parameter = 6;</code>
       */
      public Builder addParameter(
          int index, org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter value) {
        if (parameterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParameterIsMutable();
          parameter_.add(index, value);
          onChanged();
        } else {
          parameterBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .EventParameter parameter = 6;</code>
       */
      public Builder addParameter(
          org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter.Builder builderForValue) {
        if (parameterBuilder_ == null) {
          ensureParameterIsMutable();
          parameter_.add(builderForValue.build());
          onChanged();
        } else {
          parameterBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .EventParameter parameter = 6;</code>
       */
      public Builder addParameter(
          int index, org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter.Builder builderForValue) {
        if (parameterBuilder_ == null) {
          ensureParameterIsMutable();
          parameter_.add(index, builderForValue.build());
          onChanged();
        } else {
          parameterBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .EventParameter parameter = 6;</code>
       */
      public Builder addAllParameter(
          java.lang.Iterable<? extends org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter> values) {
        if (parameterBuilder_ == null) {
          ensureParameterIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, parameter_);
          onChanged();
        } else {
          parameterBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .EventParameter parameter = 6;</code>
       */
      public Builder clearParameter() {
        if (parameterBuilder_ == null) {
          parameter_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000020);
          onChanged();
        } else {
          parameterBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .EventParameter parameter = 6;</code>
       */
      public Builder removeParameter(int index) {
        if (parameterBuilder_ == null) {
          ensureParameterIsMutable();
          parameter_.remove(index);
          onChanged();
        } else {
          parameterBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .EventParameter parameter = 6;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter.Builder getParameterBuilder(
          int index) {
        return getParameterFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .EventParameter parameter = 6;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameterOrBuilder getParameterOrBuilder(
          int index) {
        if (parameterBuilder_ == null) {
          return parameter_.get(index);  } else {
          return parameterBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .EventParameter parameter = 6;</code>
       */
      public java.util.List<? extends org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameterOrBuilder> 
           getParameterOrBuilderList() {
        if (parameterBuilder_ != null) {
          return parameterBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(parameter_);
        }
      }
      /**
       * <code>repeated .EventParameter parameter = 6;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter.Builder addParameterBuilder() {
        return getParameterFieldBuilder().addBuilder(
            org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter.getDefaultInstance());
      }
      /**
       * <code>repeated .EventParameter parameter = 6;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter.Builder addParameterBuilder(
          int index) {
        return getParameterFieldBuilder().addBuilder(
            index, org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter.getDefaultInstance());
      }
      /**
       * <code>repeated .EventParameter parameter = 6;</code>
       */
      public java.util.List<org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter.Builder> 
           getParameterBuilderList() {
        return getParameterFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter, org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter.Builder, org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameterOrBuilder> 
          getParameterFieldBuilder() {
        if (parameterBuilder_ == null) {
          parameterBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter, org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameter.Builder, org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventParameterOrBuilder>(
                  parameter_,
                  ((bitField0_ & 0x00000020) == 0x00000020),
                  getParentForChildren(),
                  isClean());
          parameter_ = null;
        }
        return parameterBuilder_;
      }

      private long createTime_ ;
      /**
       * <code>uint64 create_time = 7;</code>
       */
      public long getCreateTime() {
        return createTime_;
      }
      /**
       * <code>uint64 create_time = 7;</code>
       */
      public Builder setCreateTime(long value) {
        
        createTime_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>uint64 create_time = 7;</code>
       */
      public Builder clearCreateTime() {
        
        createTime_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";
      /**
       * <code>string description = 8;</code>
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string description = 8;</code>
       */
      public com.google.protobuf.ByteString
          getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string description = 8;</code>
       */
      public Builder setDescription(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        description_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string description = 8;</code>
       */
      public Builder clearDescription() {
        
        description_ = getDefaultInstance().getDescription();
        onChanged();
        return this;
      }
      /**
       * <code>string description = 8;</code>
       */
      public Builder setDescriptionBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        description_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object logMessage_ = "";
      /**
       * <code>string log_message = 9;</code>
       */
      public java.lang.String getLogMessage() {
        java.lang.Object ref = logMessage_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          logMessage_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string log_message = 9;</code>
       */
      public com.google.protobuf.ByteString
          getLogMessageBytes() {
        java.lang.Object ref = logMessage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          logMessage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string log_message = 9;</code>
       */
      public Builder setLogMessage(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        logMessage_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string log_message = 9;</code>
       */
      public Builder clearLogMessage() {
        
        logMessage_ = getDefaultInstance().getLogMessage();
        onChanged();
        return this;
      }
      /**
       * <code>string log_message = 9;</code>
       */
      public Builder setLogMessageBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        logMessage_ = value;
        onChanged();
        return this;
      }

      private int severity_ = 0;
      /**
       * <code>.Severity severity = 10;</code>
       */
      public int getSeverityValue() {
        return severity_;
      }
      /**
       * <code>.Severity severity = 10;</code>
       */
      public Builder setSeverityValue(int value) {
        severity_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>.Severity severity = 10;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.Severity getSeverity() {
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.Severity result = org.opennms.features.kafka.producer.model.OpennmsModelProtos.Severity.valueOf(severity_);
        return result == null ? org.opennms.features.kafka.producer.model.OpennmsModelProtos.Severity.UNRECOGNIZED : result;
      }
      /**
       * <code>.Severity severity = 10;</code>
       */
      public Builder setSeverity(org.opennms.features.kafka.producer.model.OpennmsModelProtos.Severity value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        severity_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>.Severity severity = 10;</code>
       */
      public Builder clearSeverity() {
        
        severity_ = 0;
        onChanged();
        return this;
      }

      private boolean log_ ;
      /**
       * <code>bool log = 11;</code>
       */
      public boolean getLog() {
        return log_;
      }
      /**
       * <code>bool log = 11;</code>
       */
      public Builder setLog(boolean value) {
        
        log_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>bool log = 11;</code>
       */
      public Builder clearLog() {
        
        log_ = false;
        onChanged();
        return this;
      }

      private boolean display_ ;
      /**
       * <code>bool display = 12;</code>
       */
      public boolean getDisplay() {
        return display_;
      }
      /**
       * <code>bool display = 12;</code>
       */
      public Builder setDisplay(boolean value) {
        
        display_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>bool display = 12;</code>
       */
      public Builder clearDisplay() {
        
        display_ = false;
        onChanged();
        return this;
      }

      private org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria nodeCriteria_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria, org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.Builder, org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteriaOrBuilder> nodeCriteriaBuilder_;
      /**
       * <code>.NodeCriteria node_criteria = 13;</code>
       */
      public boolean hasNodeCriteria() {
        return nodeCriteriaBuilder_ != null || nodeCriteria_ != null;
      }
      /**
       * <code>.NodeCriteria node_criteria = 13;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria getNodeCriteria() {
        if (nodeCriteriaBuilder_ == null) {
          return nodeCriteria_ == null ? org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.getDefaultInstance() : nodeCriteria_;
        } else {
          return nodeCriteriaBuilder_.getMessage();
        }
      }
      /**
       * <code>.NodeCriteria node_criteria = 13;</code>
       */
      public Builder setNodeCriteria(org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria value) {
        if (nodeCriteriaBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          nodeCriteria_ = value;
          onChanged();
        } else {
          nodeCriteriaBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <code>.NodeCriteria node_criteria = 13;</code>
       */
      public Builder setNodeCriteria(
          org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.Builder builderForValue) {
        if (nodeCriteriaBuilder_ == null) {
          nodeCriteria_ = builderForValue.build();
          onChanged();
        } else {
          nodeCriteriaBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <code>.NodeCriteria node_criteria = 13;</code>
       */
      public Builder mergeNodeCriteria(org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria value) {
        if (nodeCriteriaBuilder_ == null) {
          if (nodeCriteria_ != null) {
            nodeCriteria_ =
              org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.newBuilder(nodeCriteria_).mergeFrom(value).buildPartial();
          } else {
            nodeCriteria_ = value;
          }
          onChanged();
        } else {
          nodeCriteriaBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <code>.NodeCriteria node_criteria = 13;</code>
       */
      public Builder clearNodeCriteria() {
        if (nodeCriteriaBuilder_ == null) {
          nodeCriteria_ = null;
          onChanged();
        } else {
          nodeCriteria_ = null;
          nodeCriteriaBuilder_ = null;
        }

        return this;
      }
      /**
       * <code>.NodeCriteria node_criteria = 13;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.Builder getNodeCriteriaBuilder() {
        
        onChanged();
        return getNodeCriteriaFieldBuilder().getBuilder();
      }
      /**
       * <code>.NodeCriteria node_criteria = 13;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteriaOrBuilder getNodeCriteriaOrBuilder() {
        if (nodeCriteriaBuilder_ != null) {
          return nodeCriteriaBuilder_.getMessageOrBuilder();
        } else {
          return nodeCriteria_ == null ?
              org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.getDefaultInstance() : nodeCriteria_;
        }
      }
      /**
       * <code>.NodeCriteria node_criteria = 13;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria, org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.Builder, org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteriaOrBuilder> 
          getNodeCriteriaFieldBuilder() {
        if (nodeCriteriaBuilder_ == null) {
          nodeCriteriaBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria, org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.Builder, org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteriaOrBuilder>(
                  getNodeCriteria(),
                  getParentForChildren(),
                  isClean());
          nodeCriteria_ = null;
        }
        return nodeCriteriaBuilder_;
      }

      private java.lang.Object ipAddress_ = "";
      /**
       * <code>string ip_address = 14;</code>
       */
      public java.lang.String getIpAddress() {
        java.lang.Object ref = ipAddress_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          ipAddress_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string ip_address = 14;</code>
       */
      public com.google.protobuf.ByteString
          getIpAddressBytes() {
        java.lang.Object ref = ipAddress_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          ipAddress_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string ip_address = 14;</code>
       */
      public Builder setIpAddress(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        ipAddress_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string ip_address = 14;</code>
       */
      public Builder clearIpAddress() {
        
        ipAddress_ = getDefaultInstance().getIpAddress();
        onChanged();
        return this;
      }
      /**
       * <code>string ip_address = 14;</code>
       */
      public Builder setIpAddressBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        ipAddress_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:Event)
    }

    // @@protoc_insertion_point(class_scope:Event)
    private static final org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event();
    }

    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Event>
        PARSER = new com.google.protobuf.AbstractParser<Event>() {
      public Event parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Event(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Event> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Event> getParserForType() {
      return PARSER;
    }

    public org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface AlarmOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Alarm)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>uint64 id = 1;</code>
     */
    long getId();

    /**
     * <code>string uei = 2;</code>
     */
    java.lang.String getUei();
    /**
     * <code>string uei = 2;</code>
     */
    com.google.protobuf.ByteString
        getUeiBytes();

    /**
     * <code>.NodeCriteria node_criteria = 3;</code>
     */
    boolean hasNodeCriteria();
    /**
     * <code>.NodeCriteria node_criteria = 3;</code>
     */
    org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria getNodeCriteria();
    /**
     * <code>.NodeCriteria node_criteria = 3;</code>
     */
    org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteriaOrBuilder getNodeCriteriaOrBuilder();

    /**
     * <code>string ip_address = 4;</code>
     */
    java.lang.String getIpAddress();
    /**
     * <code>string ip_address = 4;</code>
     */
    com.google.protobuf.ByteString
        getIpAddressBytes();

    /**
     * <code>string service_name = 5;</code>
     */
    java.lang.String getServiceName();
    /**
     * <code>string service_name = 5;</code>
     */
    com.google.protobuf.ByteString
        getServiceNameBytes();

    /**
     * <code>string reduction_key = 6;</code>
     */
    java.lang.String getReductionKey();
    /**
     * <code>string reduction_key = 6;</code>
     */
    com.google.protobuf.ByteString
        getReductionKeyBytes();

    /**
     * <code>.Alarm.Type type = 7;</code>
     */
    int getTypeValue();
    /**
     * <code>.Alarm.Type type = 7;</code>
     */
    org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm.Type getType();

    /**
     * <code>uint64 count = 8;</code>
     */
    long getCount();

    /**
     * <code>.Severity severity = 9;</code>
     */
    int getSeverityValue();
    /**
     * <code>.Severity severity = 9;</code>
     */
    org.opennms.features.kafka.producer.model.OpennmsModelProtos.Severity getSeverity();

    /**
     * <code>uint64 first_event_time = 10;</code>
     */
    long getFirstEventTime();

    /**
     * <code>string description = 11;</code>
     */
    java.lang.String getDescription();
    /**
     * <code>string description = 11;</code>
     */
    com.google.protobuf.ByteString
        getDescriptionBytes();

    /**
     * <code>string log_message = 12;</code>
     */
    java.lang.String getLogMessage();
    /**
     * <code>string log_message = 12;</code>
     */
    com.google.protobuf.ByteString
        getLogMessageBytes();

    /**
     * <code>string ack_user = 13;</code>
     */
    java.lang.String getAckUser();
    /**
     * <code>string ack_user = 13;</code>
     */
    com.google.protobuf.ByteString
        getAckUserBytes();

    /**
     * <code>uint64 ack_time = 14;</code>
     */
    long getAckTime();

    /**
     * <code>.Event last_event = 15;</code>
     */
    boolean hasLastEvent();
    /**
     * <code>.Event last_event = 15;</code>
     */
    org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event getLastEvent();
    /**
     * <code>.Event last_event = 15;</code>
     */
    org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventOrBuilder getLastEventOrBuilder();

    /**
     * <code>uint64 last_event_time = 16;</code>
     */
    long getLastEventTime();

    /**
     * <code>uint32 if_index = 17;</code>
     */
    int getIfIndex();

    /**
     * <code>string operator_instructions = 18;</code>
     */
    java.lang.String getOperatorInstructions();
    /**
     * <code>string operator_instructions = 18;</code>
     */
    com.google.protobuf.ByteString
        getOperatorInstructionsBytes();

    /**
     * <code>string clear_key = 19;</code>
     */
    java.lang.String getClearKey();
    /**
     * <code>string clear_key = 19;</code>
     */
    com.google.protobuf.ByteString
        getClearKeyBytes();

    /**
     * <code>string managed_object_instance = 20;</code>
     */
    java.lang.String getManagedObjectInstance();
    /**
     * <code>string managed_object_instance = 20;</code>
     */
    com.google.protobuf.ByteString
        getManagedObjectInstanceBytes();

    /**
     * <code>string managed_object_type = 21;</code>
     */
    java.lang.String getManagedObjectType();
    /**
     * <code>string managed_object_type = 21;</code>
     */
    com.google.protobuf.ByteString
        getManagedObjectTypeBytes();
  }
  /**
   * Protobuf type {@code Alarm}
   */
  public  static final class Alarm extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:Alarm)
      AlarmOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Alarm.newBuilder() to construct.
    private Alarm(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Alarm() {
      id_ = 0L;
      uei_ = "";
      ipAddress_ = "";
      serviceName_ = "";
      reductionKey_ = "";
      type_ = 0;
      count_ = 0L;
      severity_ = 0;
      firstEventTime_ = 0L;
      description_ = "";
      logMessage_ = "";
      ackUser_ = "";
      ackTime_ = 0L;
      lastEventTime_ = 0L;
      ifIndex_ = 0;
      operatorInstructions_ = "";
      clearKey_ = "";
      managedObjectInstance_ = "";
      managedObjectType_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Alarm(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {

              id_ = input.readUInt64();
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              uei_ = s;
              break;
            }
            case 26: {
              org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.Builder subBuilder = null;
              if (nodeCriteria_ != null) {
                subBuilder = nodeCriteria_.toBuilder();
              }
              nodeCriteria_ = input.readMessage(org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(nodeCriteria_);
                nodeCriteria_ = subBuilder.buildPartial();
              }

              break;
            }
            case 34: {
              java.lang.String s = input.readStringRequireUtf8();

              ipAddress_ = s;
              break;
            }
            case 42: {
              java.lang.String s = input.readStringRequireUtf8();

              serviceName_ = s;
              break;
            }
            case 50: {
              java.lang.String s = input.readStringRequireUtf8();

              reductionKey_ = s;
              break;
            }
            case 56: {
              int rawValue = input.readEnum();

              type_ = rawValue;
              break;
            }
            case 64: {

              count_ = input.readUInt64();
              break;
            }
            case 72: {
              int rawValue = input.readEnum();

              severity_ = rawValue;
              break;
            }
            case 80: {

              firstEventTime_ = input.readUInt64();
              break;
            }
            case 90: {
              java.lang.String s = input.readStringRequireUtf8();

              description_ = s;
              break;
            }
            case 98: {
              java.lang.String s = input.readStringRequireUtf8();

              logMessage_ = s;
              break;
            }
            case 106: {
              java.lang.String s = input.readStringRequireUtf8();

              ackUser_ = s;
              break;
            }
            case 112: {

              ackTime_ = input.readUInt64();
              break;
            }
            case 122: {
              org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event.Builder subBuilder = null;
              if (lastEvent_ != null) {
                subBuilder = lastEvent_.toBuilder();
              }
              lastEvent_ = input.readMessage(org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(lastEvent_);
                lastEvent_ = subBuilder.buildPartial();
              }

              break;
            }
            case 128: {

              lastEventTime_ = input.readUInt64();
              break;
            }
            case 136: {

              ifIndex_ = input.readUInt32();
              break;
            }
            case 146: {
              java.lang.String s = input.readStringRequireUtf8();

              operatorInstructions_ = s;
              break;
            }
            case 154: {
              java.lang.String s = input.readStringRequireUtf8();

              clearKey_ = s;
              break;
            }
            case 162: {
              java.lang.String s = input.readStringRequireUtf8();

              managedObjectInstance_ = s;
              break;
            }
            case 170: {
              java.lang.String s = input.readStringRequireUtf8();

              managedObjectType_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_Alarm_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_Alarm_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm.class, org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm.Builder.class);
    }

    /**
     * Protobuf enum {@code Alarm.Type}
     */
    public enum Type
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>PROBLEM_WITH_CLEAR = 0;</code>
       */
      PROBLEM_WITH_CLEAR(0),
      /**
       * <code>CLEAR = 1;</code>
       */
      CLEAR(1),
      /**
       * <code>PROBLEM_WITHOUT_CLEAR = 2;</code>
       */
      PROBLEM_WITHOUT_CLEAR(2),
      UNRECOGNIZED(-1),
      ;

      /**
       * <code>PROBLEM_WITH_CLEAR = 0;</code>
       */
      public static final int PROBLEM_WITH_CLEAR_VALUE = 0;
      /**
       * <code>CLEAR = 1;</code>
       */
      public static final int CLEAR_VALUE = 1;
      /**
       * <code>PROBLEM_WITHOUT_CLEAR = 2;</code>
       */
      public static final int PROBLEM_WITHOUT_CLEAR_VALUE = 2;


      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Type valueOf(int value) {
        return forNumber(value);
      }

      public static Type forNumber(int value) {
        switch (value) {
          case 0: return PROBLEM_WITH_CLEAR;
          case 1: return CLEAR;
          case 2: return PROBLEM_WITHOUT_CLEAR;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Type>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          Type> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Type>() {
              public Type findValueByNumber(int number) {
                return Type.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm.getDescriptor().getEnumTypes().get(0);
      }

      private static final Type[] VALUES = values();

      public static Type valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Type(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Alarm.Type)
    }

    public static final int ID_FIELD_NUMBER = 1;
    private long id_;
    /**
     * <code>uint64 id = 1;</code>
     */
    public long getId() {
      return id_;
    }

    public static final int UEI_FIELD_NUMBER = 2;
    private volatile java.lang.Object uei_;
    /**
     * <code>string uei = 2;</code>
     */
    public java.lang.String getUei() {
      java.lang.Object ref = uei_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uei_ = s;
        return s;
      }
    }
    /**
     * <code>string uei = 2;</code>
     */
    public com.google.protobuf.ByteString
        getUeiBytes() {
      java.lang.Object ref = uei_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        uei_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NODE_CRITERIA_FIELD_NUMBER = 3;
    private org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria nodeCriteria_;
    /**
     * <code>.NodeCriteria node_criteria = 3;</code>
     */
    public boolean hasNodeCriteria() {
      return nodeCriteria_ != null;
    }
    /**
     * <code>.NodeCriteria node_criteria = 3;</code>
     */
    public org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria getNodeCriteria() {
      return nodeCriteria_ == null ? org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.getDefaultInstance() : nodeCriteria_;
    }
    /**
     * <code>.NodeCriteria node_criteria = 3;</code>
     */
    public org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteriaOrBuilder getNodeCriteriaOrBuilder() {
      return getNodeCriteria();
    }

    public static final int IP_ADDRESS_FIELD_NUMBER = 4;
    private volatile java.lang.Object ipAddress_;
    /**
     * <code>string ip_address = 4;</code>
     */
    public java.lang.String getIpAddress() {
      java.lang.Object ref = ipAddress_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipAddress_ = s;
        return s;
      }
    }
    /**
     * <code>string ip_address = 4;</code>
     */
    public com.google.protobuf.ByteString
        getIpAddressBytes() {
      java.lang.Object ref = ipAddress_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        ipAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SERVICE_NAME_FIELD_NUMBER = 5;
    private volatile java.lang.Object serviceName_;
    /**
     * <code>string service_name = 5;</code>
     */
    public java.lang.String getServiceName() {
      java.lang.Object ref = serviceName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceName_ = s;
        return s;
      }
    }
    /**
     * <code>string service_name = 5;</code>
     */
    public com.google.protobuf.ByteString
        getServiceNameBytes() {
      java.lang.Object ref = serviceName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        serviceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int REDUCTION_KEY_FIELD_NUMBER = 6;
    private volatile java.lang.Object reductionKey_;
    /**
     * <code>string reduction_key = 6;</code>
     */
    public java.lang.String getReductionKey() {
      java.lang.Object ref = reductionKey_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        reductionKey_ = s;
        return s;
      }
    }
    /**
     * <code>string reduction_key = 6;</code>
     */
    public com.google.protobuf.ByteString
        getReductionKeyBytes() {
      java.lang.Object ref = reductionKey_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        reductionKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TYPE_FIELD_NUMBER = 7;
    private int type_;
    /**
     * <code>.Alarm.Type type = 7;</code>
     */
    public int getTypeValue() {
      return type_;
    }
    /**
     * <code>.Alarm.Type type = 7;</code>
     */
    public org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm.Type getType() {
      org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm.Type result = org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm.Type.valueOf(type_);
      return result == null ? org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm.Type.UNRECOGNIZED : result;
    }

    public static final int COUNT_FIELD_NUMBER = 8;
    private long count_;
    /**
     * <code>uint64 count = 8;</code>
     */
    public long getCount() {
      return count_;
    }

    public static final int SEVERITY_FIELD_NUMBER = 9;
    private int severity_;
    /**
     * <code>.Severity severity = 9;</code>
     */
    public int getSeverityValue() {
      return severity_;
    }
    /**
     * <code>.Severity severity = 9;</code>
     */
    public org.opennms.features.kafka.producer.model.OpennmsModelProtos.Severity getSeverity() {
      org.opennms.features.kafka.producer.model.OpennmsModelProtos.Severity result = org.opennms.features.kafka.producer.model.OpennmsModelProtos.Severity.valueOf(severity_);
      return result == null ? org.opennms.features.kafka.producer.model.OpennmsModelProtos.Severity.UNRECOGNIZED : result;
    }

    public static final int FIRST_EVENT_TIME_FIELD_NUMBER = 10;
    private long firstEventTime_;
    /**
     * <code>uint64 first_event_time = 10;</code>
     */
    public long getFirstEventTime() {
      return firstEventTime_;
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 11;
    private volatile java.lang.Object description_;
    /**
     * <code>string description = 11;</code>
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     * <code>string description = 11;</code>
     */
    public com.google.protobuf.ByteString
        getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LOG_MESSAGE_FIELD_NUMBER = 12;
    private volatile java.lang.Object logMessage_;
    /**
     * <code>string log_message = 12;</code>
     */
    public java.lang.String getLogMessage() {
      java.lang.Object ref = logMessage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        logMessage_ = s;
        return s;
      }
    }
    /**
     * <code>string log_message = 12;</code>
     */
    public com.google.protobuf.ByteString
        getLogMessageBytes() {
      java.lang.Object ref = logMessage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        logMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ACK_USER_FIELD_NUMBER = 13;
    private volatile java.lang.Object ackUser_;
    /**
     * <code>string ack_user = 13;</code>
     */
    public java.lang.String getAckUser() {
      java.lang.Object ref = ackUser_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ackUser_ = s;
        return s;
      }
    }
    /**
     * <code>string ack_user = 13;</code>
     */
    public com.google.protobuf.ByteString
        getAckUserBytes() {
      java.lang.Object ref = ackUser_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        ackUser_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ACK_TIME_FIELD_NUMBER = 14;
    private long ackTime_;
    /**
     * <code>uint64 ack_time = 14;</code>
     */
    public long getAckTime() {
      return ackTime_;
    }

    public static final int LAST_EVENT_FIELD_NUMBER = 15;
    private org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event lastEvent_;
    /**
     * <code>.Event last_event = 15;</code>
     */
    public boolean hasLastEvent() {
      return lastEvent_ != null;
    }
    /**
     * <code>.Event last_event = 15;</code>
     */
    public org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event getLastEvent() {
      return lastEvent_ == null ? org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event.getDefaultInstance() : lastEvent_;
    }
    /**
     * <code>.Event last_event = 15;</code>
     */
    public org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventOrBuilder getLastEventOrBuilder() {
      return getLastEvent();
    }

    public static final int LAST_EVENT_TIME_FIELD_NUMBER = 16;
    private long lastEventTime_;
    /**
     * <code>uint64 last_event_time = 16;</code>
     */
    public long getLastEventTime() {
      return lastEventTime_;
    }

    public static final int IF_INDEX_FIELD_NUMBER = 17;
    private int ifIndex_;
    /**
     * <code>uint32 if_index = 17;</code>
     */
    public int getIfIndex() {
      return ifIndex_;
    }

    public static final int OPERATOR_INSTRUCTIONS_FIELD_NUMBER = 18;
    private volatile java.lang.Object operatorInstructions_;
    /**
     * <code>string operator_instructions = 18;</code>
     */
    public java.lang.String getOperatorInstructions() {
      java.lang.Object ref = operatorInstructions_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        operatorInstructions_ = s;
        return s;
      }
    }
    /**
     * <code>string operator_instructions = 18;</code>
     */
    public com.google.protobuf.ByteString
        getOperatorInstructionsBytes() {
      java.lang.Object ref = operatorInstructions_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        operatorInstructions_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CLEAR_KEY_FIELD_NUMBER = 19;
    private volatile java.lang.Object clearKey_;
    /**
     * <code>string clear_key = 19;</code>
     */
    public java.lang.String getClearKey() {
      java.lang.Object ref = clearKey_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clearKey_ = s;
        return s;
      }
    }
    /**
     * <code>string clear_key = 19;</code>
     */
    public com.google.protobuf.ByteString
        getClearKeyBytes() {
      java.lang.Object ref = clearKey_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        clearKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MANAGED_OBJECT_INSTANCE_FIELD_NUMBER = 20;
    private volatile java.lang.Object managedObjectInstance_;
    /**
     * <code>string managed_object_instance = 20;</code>
     */
    public java.lang.String getManagedObjectInstance() {
      java.lang.Object ref = managedObjectInstance_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        managedObjectInstance_ = s;
        return s;
      }
    }
    /**
     * <code>string managed_object_instance = 20;</code>
     */
    public com.google.protobuf.ByteString
        getManagedObjectInstanceBytes() {
      java.lang.Object ref = managedObjectInstance_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        managedObjectInstance_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MANAGED_OBJECT_TYPE_FIELD_NUMBER = 21;
    private volatile java.lang.Object managedObjectType_;
    /**
     * <code>string managed_object_type = 21;</code>
     */
    public java.lang.String getManagedObjectType() {
      java.lang.Object ref = managedObjectType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        managedObjectType_ = s;
        return s;
      }
    }
    /**
     * <code>string managed_object_type = 21;</code>
     */
    public com.google.protobuf.ByteString
        getManagedObjectTypeBytes() {
      java.lang.Object ref = managedObjectType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        managedObjectType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (id_ != 0L) {
        output.writeUInt64(1, id_);
      }
      if (!getUeiBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uei_);
      }
      if (nodeCriteria_ != null) {
        output.writeMessage(3, getNodeCriteria());
      }
      if (!getIpAddressBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, ipAddress_);
      }
      if (!getServiceNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, serviceName_);
      }
      if (!getReductionKeyBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, reductionKey_);
      }
      if (type_ != org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm.Type.PROBLEM_WITH_CLEAR.getNumber()) {
        output.writeEnum(7, type_);
      }
      if (count_ != 0L) {
        output.writeUInt64(8, count_);
      }
      if (severity_ != org.opennms.features.kafka.producer.model.OpennmsModelProtos.Severity.INDETERMINATE.getNumber()) {
        output.writeEnum(9, severity_);
      }
      if (firstEventTime_ != 0L) {
        output.writeUInt64(10, firstEventTime_);
      }
      if (!getDescriptionBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 11, description_);
      }
      if (!getLogMessageBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 12, logMessage_);
      }
      if (!getAckUserBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 13, ackUser_);
      }
      if (ackTime_ != 0L) {
        output.writeUInt64(14, ackTime_);
      }
      if (lastEvent_ != null) {
        output.writeMessage(15, getLastEvent());
      }
      if (lastEventTime_ != 0L) {
        output.writeUInt64(16, lastEventTime_);
      }
      if (ifIndex_ != 0) {
        output.writeUInt32(17, ifIndex_);
      }
      if (!getOperatorInstructionsBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 18, operatorInstructions_);
      }
      if (!getClearKeyBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 19, clearKey_);
      }
      if (!getManagedObjectInstanceBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 20, managedObjectInstance_);
      }
      if (!getManagedObjectTypeBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 21, managedObjectType_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (id_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(1, id_);
      }
      if (!getUeiBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uei_);
      }
      if (nodeCriteria_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getNodeCriteria());
      }
      if (!getIpAddressBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, ipAddress_);
      }
      if (!getServiceNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, serviceName_);
      }
      if (!getReductionKeyBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, reductionKey_);
      }
      if (type_ != org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm.Type.PROBLEM_WITH_CLEAR.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(7, type_);
      }
      if (count_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(8, count_);
      }
      if (severity_ != org.opennms.features.kafka.producer.model.OpennmsModelProtos.Severity.INDETERMINATE.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(9, severity_);
      }
      if (firstEventTime_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(10, firstEventTime_);
      }
      if (!getDescriptionBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, description_);
      }
      if (!getLogMessageBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, logMessage_);
      }
      if (!getAckUserBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, ackUser_);
      }
      if (ackTime_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(14, ackTime_);
      }
      if (lastEvent_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(15, getLastEvent());
      }
      if (lastEventTime_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(16, lastEventTime_);
      }
      if (ifIndex_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(17, ifIndex_);
      }
      if (!getOperatorInstructionsBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, operatorInstructions_);
      }
      if (!getClearKeyBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(19, clearKey_);
      }
      if (!getManagedObjectInstanceBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(20, managedObjectInstance_);
      }
      if (!getManagedObjectTypeBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(21, managedObjectType_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm)) {
        return super.equals(obj);
      }
      org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm other = (org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm) obj;

      boolean result = true;
      result = result && (getId()
          == other.getId());
      result = result && getUei()
          .equals(other.getUei());
      result = result && (hasNodeCriteria() == other.hasNodeCriteria());
      if (hasNodeCriteria()) {
        result = result && getNodeCriteria()
            .equals(other.getNodeCriteria());
      }
      result = result && getIpAddress()
          .equals(other.getIpAddress());
      result = result && getServiceName()
          .equals(other.getServiceName());
      result = result && getReductionKey()
          .equals(other.getReductionKey());
      result = result && type_ == other.type_;
      result = result && (getCount()
          == other.getCount());
      result = result && severity_ == other.severity_;
      result = result && (getFirstEventTime()
          == other.getFirstEventTime());
      result = result && getDescription()
          .equals(other.getDescription());
      result = result && getLogMessage()
          .equals(other.getLogMessage());
      result = result && getAckUser()
          .equals(other.getAckUser());
      result = result && (getAckTime()
          == other.getAckTime());
      result = result && (hasLastEvent() == other.hasLastEvent());
      if (hasLastEvent()) {
        result = result && getLastEvent()
            .equals(other.getLastEvent());
      }
      result = result && (getLastEventTime()
          == other.getLastEventTime());
      result = result && (getIfIndex()
          == other.getIfIndex());
      result = result && getOperatorInstructions()
          .equals(other.getOperatorInstructions());
      result = result && getClearKey()
          .equals(other.getClearKey());
      result = result && getManagedObjectInstance()
          .equals(other.getManagedObjectInstance());
      result = result && getManagedObjectType()
          .equals(other.getManagedObjectType());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getId());
      hash = (37 * hash) + UEI_FIELD_NUMBER;
      hash = (53 * hash) + getUei().hashCode();
      if (hasNodeCriteria()) {
        hash = (37 * hash) + NODE_CRITERIA_FIELD_NUMBER;
        hash = (53 * hash) + getNodeCriteria().hashCode();
      }
      hash = (37 * hash) + IP_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getIpAddress().hashCode();
      hash = (37 * hash) + SERVICE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getServiceName().hashCode();
      hash = (37 * hash) + REDUCTION_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getReductionKey().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      hash = (37 * hash) + COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getCount());
      hash = (37 * hash) + SEVERITY_FIELD_NUMBER;
      hash = (53 * hash) + severity_;
      hash = (37 * hash) + FIRST_EVENT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getFirstEventTime());
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      hash = (37 * hash) + LOG_MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getLogMessage().hashCode();
      hash = (37 * hash) + ACK_USER_FIELD_NUMBER;
      hash = (53 * hash) + getAckUser().hashCode();
      hash = (37 * hash) + ACK_TIME_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getAckTime());
      if (hasLastEvent()) {
        hash = (37 * hash) + LAST_EVENT_FIELD_NUMBER;
        hash = (53 * hash) + getLastEvent().hashCode();
      }
      hash = (37 * hash) + LAST_EVENT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getLastEventTime());
      hash = (37 * hash) + IF_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getIfIndex();
      hash = (37 * hash) + OPERATOR_INSTRUCTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getOperatorInstructions().hashCode();
      hash = (37 * hash) + CLEAR_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getClearKey().hashCode();
      hash = (37 * hash) + MANAGED_OBJECT_INSTANCE_FIELD_NUMBER;
      hash = (53 * hash) + getManagedObjectInstance().hashCode();
      hash = (37 * hash) + MANAGED_OBJECT_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getManagedObjectType().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Alarm}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Alarm)
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.AlarmOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_Alarm_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_Alarm_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm.class, org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm.Builder.class);
      }

      // Construct using org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        id_ = 0L;

        uei_ = "";

        if (nodeCriteriaBuilder_ == null) {
          nodeCriteria_ = null;
        } else {
          nodeCriteria_ = null;
          nodeCriteriaBuilder_ = null;
        }
        ipAddress_ = "";

        serviceName_ = "";

        reductionKey_ = "";

        type_ = 0;

        count_ = 0L;

        severity_ = 0;

        firstEventTime_ = 0L;

        description_ = "";

        logMessage_ = "";

        ackUser_ = "";

        ackTime_ = 0L;

        if (lastEventBuilder_ == null) {
          lastEvent_ = null;
        } else {
          lastEvent_ = null;
          lastEventBuilder_ = null;
        }
        lastEventTime_ = 0L;

        ifIndex_ = 0;

        operatorInstructions_ = "";

        clearKey_ = "";

        managedObjectInstance_ = "";

        managedObjectType_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_Alarm_descriptor;
      }

      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm getDefaultInstanceForType() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm.getDefaultInstance();
      }

      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm build() {
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm buildPartial() {
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm result = new org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm(this);
        result.id_ = id_;
        result.uei_ = uei_;
        if (nodeCriteriaBuilder_ == null) {
          result.nodeCriteria_ = nodeCriteria_;
        } else {
          result.nodeCriteria_ = nodeCriteriaBuilder_.build();
        }
        result.ipAddress_ = ipAddress_;
        result.serviceName_ = serviceName_;
        result.reductionKey_ = reductionKey_;
        result.type_ = type_;
        result.count_ = count_;
        result.severity_ = severity_;
        result.firstEventTime_ = firstEventTime_;
        result.description_ = description_;
        result.logMessage_ = logMessage_;
        result.ackUser_ = ackUser_;
        result.ackTime_ = ackTime_;
        if (lastEventBuilder_ == null) {
          result.lastEvent_ = lastEvent_;
        } else {
          result.lastEvent_ = lastEventBuilder_.build();
        }
        result.lastEventTime_ = lastEventTime_;
        result.ifIndex_ = ifIndex_;
        result.operatorInstructions_ = operatorInstructions_;
        result.clearKey_ = clearKey_;
        result.managedObjectInstance_ = managedObjectInstance_;
        result.managedObjectType_ = managedObjectType_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm) {
          return mergeFrom((org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm other) {
        if (other == org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm.getDefaultInstance()) return this;
        if (other.getId() != 0L) {
          setId(other.getId());
        }
        if (!other.getUei().isEmpty()) {
          uei_ = other.uei_;
          onChanged();
        }
        if (other.hasNodeCriteria()) {
          mergeNodeCriteria(other.getNodeCriteria());
        }
        if (!other.getIpAddress().isEmpty()) {
          ipAddress_ = other.ipAddress_;
          onChanged();
        }
        if (!other.getServiceName().isEmpty()) {
          serviceName_ = other.serviceName_;
          onChanged();
        }
        if (!other.getReductionKey().isEmpty()) {
          reductionKey_ = other.reductionKey_;
          onChanged();
        }
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (other.getCount() != 0L) {
          setCount(other.getCount());
        }
        if (other.severity_ != 0) {
          setSeverityValue(other.getSeverityValue());
        }
        if (other.getFirstEventTime() != 0L) {
          setFirstEventTime(other.getFirstEventTime());
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          onChanged();
        }
        if (!other.getLogMessage().isEmpty()) {
          logMessage_ = other.logMessage_;
          onChanged();
        }
        if (!other.getAckUser().isEmpty()) {
          ackUser_ = other.ackUser_;
          onChanged();
        }
        if (other.getAckTime() != 0L) {
          setAckTime(other.getAckTime());
        }
        if (other.hasLastEvent()) {
          mergeLastEvent(other.getLastEvent());
        }
        if (other.getLastEventTime() != 0L) {
          setLastEventTime(other.getLastEventTime());
        }
        if (other.getIfIndex() != 0) {
          setIfIndex(other.getIfIndex());
        }
        if (!other.getOperatorInstructions().isEmpty()) {
          operatorInstructions_ = other.operatorInstructions_;
          onChanged();
        }
        if (!other.getClearKey().isEmpty()) {
          clearKey_ = other.clearKey_;
          onChanged();
        }
        if (!other.getManagedObjectInstance().isEmpty()) {
          managedObjectInstance_ = other.managedObjectInstance_;
          onChanged();
        }
        if (!other.getManagedObjectType().isEmpty()) {
          managedObjectType_ = other.managedObjectType_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private long id_ ;
      /**
       * <code>uint64 id = 1;</code>
       */
      public long getId() {
        return id_;
      }
      /**
       * <code>uint64 id = 1;</code>
       */
      public Builder setId(long value) {
        
        id_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>uint64 id = 1;</code>
       */
      public Builder clearId() {
        
        id_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object uei_ = "";
      /**
       * <code>string uei = 2;</code>
       */
      public java.lang.String getUei() {
        java.lang.Object ref = uei_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uei_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string uei = 2;</code>
       */
      public com.google.protobuf.ByteString
          getUeiBytes() {
        java.lang.Object ref = uei_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          uei_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string uei = 2;</code>
       */
      public Builder setUei(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        uei_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string uei = 2;</code>
       */
      public Builder clearUei() {
        
        uei_ = getDefaultInstance().getUei();
        onChanged();
        return this;
      }
      /**
       * <code>string uei = 2;</code>
       */
      public Builder setUeiBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        uei_ = value;
        onChanged();
        return this;
      }

      private org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria nodeCriteria_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria, org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.Builder, org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteriaOrBuilder> nodeCriteriaBuilder_;
      /**
       * <code>.NodeCriteria node_criteria = 3;</code>
       */
      public boolean hasNodeCriteria() {
        return nodeCriteriaBuilder_ != null || nodeCriteria_ != null;
      }
      /**
       * <code>.NodeCriteria node_criteria = 3;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria getNodeCriteria() {
        if (nodeCriteriaBuilder_ == null) {
          return nodeCriteria_ == null ? org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.getDefaultInstance() : nodeCriteria_;
        } else {
          return nodeCriteriaBuilder_.getMessage();
        }
      }
      /**
       * <code>.NodeCriteria node_criteria = 3;</code>
       */
      public Builder setNodeCriteria(org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria value) {
        if (nodeCriteriaBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          nodeCriteria_ = value;
          onChanged();
        } else {
          nodeCriteriaBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <code>.NodeCriteria node_criteria = 3;</code>
       */
      public Builder setNodeCriteria(
          org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.Builder builderForValue) {
        if (nodeCriteriaBuilder_ == null) {
          nodeCriteria_ = builderForValue.build();
          onChanged();
        } else {
          nodeCriteriaBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <code>.NodeCriteria node_criteria = 3;</code>
       */
      public Builder mergeNodeCriteria(org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria value) {
        if (nodeCriteriaBuilder_ == null) {
          if (nodeCriteria_ != null) {
            nodeCriteria_ =
              org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.newBuilder(nodeCriteria_).mergeFrom(value).buildPartial();
          } else {
            nodeCriteria_ = value;
          }
          onChanged();
        } else {
          nodeCriteriaBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <code>.NodeCriteria node_criteria = 3;</code>
       */
      public Builder clearNodeCriteria() {
        if (nodeCriteriaBuilder_ == null) {
          nodeCriteria_ = null;
          onChanged();
        } else {
          nodeCriteria_ = null;
          nodeCriteriaBuilder_ = null;
        }

        return this;
      }
      /**
       * <code>.NodeCriteria node_criteria = 3;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.Builder getNodeCriteriaBuilder() {
        
        onChanged();
        return getNodeCriteriaFieldBuilder().getBuilder();
      }
      /**
       * <code>.NodeCriteria node_criteria = 3;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteriaOrBuilder getNodeCriteriaOrBuilder() {
        if (nodeCriteriaBuilder_ != null) {
          return nodeCriteriaBuilder_.getMessageOrBuilder();
        } else {
          return nodeCriteria_ == null ?
              org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.getDefaultInstance() : nodeCriteria_;
        }
      }
      /**
       * <code>.NodeCriteria node_criteria = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria, org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.Builder, org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteriaOrBuilder> 
          getNodeCriteriaFieldBuilder() {
        if (nodeCriteriaBuilder_ == null) {
          nodeCriteriaBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria, org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteria.Builder, org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeCriteriaOrBuilder>(
                  getNodeCriteria(),
                  getParentForChildren(),
                  isClean());
          nodeCriteria_ = null;
        }
        return nodeCriteriaBuilder_;
      }

      private java.lang.Object ipAddress_ = "";
      /**
       * <code>string ip_address = 4;</code>
       */
      public java.lang.String getIpAddress() {
        java.lang.Object ref = ipAddress_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          ipAddress_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string ip_address = 4;</code>
       */
      public com.google.protobuf.ByteString
          getIpAddressBytes() {
        java.lang.Object ref = ipAddress_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          ipAddress_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string ip_address = 4;</code>
       */
      public Builder setIpAddress(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        ipAddress_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string ip_address = 4;</code>
       */
      public Builder clearIpAddress() {
        
        ipAddress_ = getDefaultInstance().getIpAddress();
        onChanged();
        return this;
      }
      /**
       * <code>string ip_address = 4;</code>
       */
      public Builder setIpAddressBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        ipAddress_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object serviceName_ = "";
      /**
       * <code>string service_name = 5;</code>
       */
      public java.lang.String getServiceName() {
        java.lang.Object ref = serviceName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          serviceName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string service_name = 5;</code>
       */
      public com.google.protobuf.ByteString
          getServiceNameBytes() {
        java.lang.Object ref = serviceName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          serviceName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string service_name = 5;</code>
       */
      public Builder setServiceName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        serviceName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string service_name = 5;</code>
       */
      public Builder clearServiceName() {
        
        serviceName_ = getDefaultInstance().getServiceName();
        onChanged();
        return this;
      }
      /**
       * <code>string service_name = 5;</code>
       */
      public Builder setServiceNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        serviceName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object reductionKey_ = "";
      /**
       * <code>string reduction_key = 6;</code>
       */
      public java.lang.String getReductionKey() {
        java.lang.Object ref = reductionKey_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          reductionKey_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string reduction_key = 6;</code>
       */
      public com.google.protobuf.ByteString
          getReductionKeyBytes() {
        java.lang.Object ref = reductionKey_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          reductionKey_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string reduction_key = 6;</code>
       */
      public Builder setReductionKey(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        reductionKey_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string reduction_key = 6;</code>
       */
      public Builder clearReductionKey() {
        
        reductionKey_ = getDefaultInstance().getReductionKey();
        onChanged();
        return this;
      }
      /**
       * <code>string reduction_key = 6;</code>
       */
      public Builder setReductionKeyBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        reductionKey_ = value;
        onChanged();
        return this;
      }

      private int type_ = 0;
      /**
       * <code>.Alarm.Type type = 7;</code>
       */
      public int getTypeValue() {
        return type_;
      }
      /**
       * <code>.Alarm.Type type = 7;</code>
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>.Alarm.Type type = 7;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm.Type getType() {
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm.Type result = org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm.Type.valueOf(type_);
        return result == null ? org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm.Type.UNRECOGNIZED : result;
      }
      /**
       * <code>.Alarm.Type type = 7;</code>
       */
      public Builder setType(org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm.Type value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>.Alarm.Type type = 7;</code>
       */
      public Builder clearType() {
        
        type_ = 0;
        onChanged();
        return this;
      }

      private long count_ ;
      /**
       * <code>uint64 count = 8;</code>
       */
      public long getCount() {
        return count_;
      }
      /**
       * <code>uint64 count = 8;</code>
       */
      public Builder setCount(long value) {
        
        count_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>uint64 count = 8;</code>
       */
      public Builder clearCount() {
        
        count_ = 0L;
        onChanged();
        return this;
      }

      private int severity_ = 0;
      /**
       * <code>.Severity severity = 9;</code>
       */
      public int getSeverityValue() {
        return severity_;
      }
      /**
       * <code>.Severity severity = 9;</code>
       */
      public Builder setSeverityValue(int value) {
        severity_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>.Severity severity = 9;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.Severity getSeverity() {
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.Severity result = org.opennms.features.kafka.producer.model.OpennmsModelProtos.Severity.valueOf(severity_);
        return result == null ? org.opennms.features.kafka.producer.model.OpennmsModelProtos.Severity.UNRECOGNIZED : result;
      }
      /**
       * <code>.Severity severity = 9;</code>
       */
      public Builder setSeverity(org.opennms.features.kafka.producer.model.OpennmsModelProtos.Severity value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        severity_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>.Severity severity = 9;</code>
       */
      public Builder clearSeverity() {
        
        severity_ = 0;
        onChanged();
        return this;
      }

      private long firstEventTime_ ;
      /**
       * <code>uint64 first_event_time = 10;</code>
       */
      public long getFirstEventTime() {
        return firstEventTime_;
      }
      /**
       * <code>uint64 first_event_time = 10;</code>
       */
      public Builder setFirstEventTime(long value) {
        
        firstEventTime_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>uint64 first_event_time = 10;</code>
       */
      public Builder clearFirstEventTime() {
        
        firstEventTime_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";
      /**
       * <code>string description = 11;</code>
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string description = 11;</code>
       */
      public com.google.protobuf.ByteString
          getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string description = 11;</code>
       */
      public Builder setDescription(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        description_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string description = 11;</code>
       */
      public Builder clearDescription() {
        
        description_ = getDefaultInstance().getDescription();
        onChanged();
        return this;
      }
      /**
       * <code>string description = 11;</code>
       */
      public Builder setDescriptionBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        description_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object logMessage_ = "";
      /**
       * <code>string log_message = 12;</code>
       */
      public java.lang.String getLogMessage() {
        java.lang.Object ref = logMessage_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          logMessage_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string log_message = 12;</code>
       */
      public com.google.protobuf.ByteString
          getLogMessageBytes() {
        java.lang.Object ref = logMessage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          logMessage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string log_message = 12;</code>
       */
      public Builder setLogMessage(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        logMessage_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string log_message = 12;</code>
       */
      public Builder clearLogMessage() {
        
        logMessage_ = getDefaultInstance().getLogMessage();
        onChanged();
        return this;
      }
      /**
       * <code>string log_message = 12;</code>
       */
      public Builder setLogMessageBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        logMessage_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object ackUser_ = "";
      /**
       * <code>string ack_user = 13;</code>
       */
      public java.lang.String getAckUser() {
        java.lang.Object ref = ackUser_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          ackUser_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string ack_user = 13;</code>
       */
      public com.google.protobuf.ByteString
          getAckUserBytes() {
        java.lang.Object ref = ackUser_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          ackUser_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string ack_user = 13;</code>
       */
      public Builder setAckUser(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        ackUser_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string ack_user = 13;</code>
       */
      public Builder clearAckUser() {
        
        ackUser_ = getDefaultInstance().getAckUser();
        onChanged();
        return this;
      }
      /**
       * <code>string ack_user = 13;</code>
       */
      public Builder setAckUserBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        ackUser_ = value;
        onChanged();
        return this;
      }

      private long ackTime_ ;
      /**
       * <code>uint64 ack_time = 14;</code>
       */
      public long getAckTime() {
        return ackTime_;
      }
      /**
       * <code>uint64 ack_time = 14;</code>
       */
      public Builder setAckTime(long value) {
        
        ackTime_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>uint64 ack_time = 14;</code>
       */
      public Builder clearAckTime() {
        
        ackTime_ = 0L;
        onChanged();
        return this;
      }

      private org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event lastEvent_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event, org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event.Builder, org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventOrBuilder> lastEventBuilder_;
      /**
       * <code>.Event last_event = 15;</code>
       */
      public boolean hasLastEvent() {
        return lastEventBuilder_ != null || lastEvent_ != null;
      }
      /**
       * <code>.Event last_event = 15;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event getLastEvent() {
        if (lastEventBuilder_ == null) {
          return lastEvent_ == null ? org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event.getDefaultInstance() : lastEvent_;
        } else {
          return lastEventBuilder_.getMessage();
        }
      }
      /**
       * <code>.Event last_event = 15;</code>
       */
      public Builder setLastEvent(org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event value) {
        if (lastEventBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          lastEvent_ = value;
          onChanged();
        } else {
          lastEventBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <code>.Event last_event = 15;</code>
       */
      public Builder setLastEvent(
          org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event.Builder builderForValue) {
        if (lastEventBuilder_ == null) {
          lastEvent_ = builderForValue.build();
          onChanged();
        } else {
          lastEventBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <code>.Event last_event = 15;</code>
       */
      public Builder mergeLastEvent(org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event value) {
        if (lastEventBuilder_ == null) {
          if (lastEvent_ != null) {
            lastEvent_ =
              org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event.newBuilder(lastEvent_).mergeFrom(value).buildPartial();
          } else {
            lastEvent_ = value;
          }
          onChanged();
        } else {
          lastEventBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <code>.Event last_event = 15;</code>
       */
      public Builder clearLastEvent() {
        if (lastEventBuilder_ == null) {
          lastEvent_ = null;
          onChanged();
        } else {
          lastEvent_ = null;
          lastEventBuilder_ = null;
        }

        return this;
      }
      /**
       * <code>.Event last_event = 15;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event.Builder getLastEventBuilder() {
        
        onChanged();
        return getLastEventFieldBuilder().getBuilder();
      }
      /**
       * <code>.Event last_event = 15;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventOrBuilder getLastEventOrBuilder() {
        if (lastEventBuilder_ != null) {
          return lastEventBuilder_.getMessageOrBuilder();
        } else {
          return lastEvent_ == null ?
              org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event.getDefaultInstance() : lastEvent_;
        }
      }
      /**
       * <code>.Event last_event = 15;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event, org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event.Builder, org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventOrBuilder> 
          getLastEventFieldBuilder() {
        if (lastEventBuilder_ == null) {
          lastEventBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event, org.opennms.features.kafka.producer.model.OpennmsModelProtos.Event.Builder, org.opennms.features.kafka.producer.model.OpennmsModelProtos.EventOrBuilder>(
                  getLastEvent(),
                  getParentForChildren(),
                  isClean());
          lastEvent_ = null;
        }
        return lastEventBuilder_;
      }

      private long lastEventTime_ ;
      /**
       * <code>uint64 last_event_time = 16;</code>
       */
      public long getLastEventTime() {
        return lastEventTime_;
      }
      /**
       * <code>uint64 last_event_time = 16;</code>
       */
      public Builder setLastEventTime(long value) {
        
        lastEventTime_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>uint64 last_event_time = 16;</code>
       */
      public Builder clearLastEventTime() {
        
        lastEventTime_ = 0L;
        onChanged();
        return this;
      }

      private int ifIndex_ ;
      /**
       * <code>uint32 if_index = 17;</code>
       */
      public int getIfIndex() {
        return ifIndex_;
      }
      /**
       * <code>uint32 if_index = 17;</code>
       */
      public Builder setIfIndex(int value) {
        
        ifIndex_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>uint32 if_index = 17;</code>
       */
      public Builder clearIfIndex() {
        
        ifIndex_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object operatorInstructions_ = "";
      /**
       * <code>string operator_instructions = 18;</code>
       */
      public java.lang.String getOperatorInstructions() {
        java.lang.Object ref = operatorInstructions_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          operatorInstructions_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string operator_instructions = 18;</code>
       */
      public com.google.protobuf.ByteString
          getOperatorInstructionsBytes() {
        java.lang.Object ref = operatorInstructions_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          operatorInstructions_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string operator_instructions = 18;</code>
       */
      public Builder setOperatorInstructions(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        operatorInstructions_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string operator_instructions = 18;</code>
       */
      public Builder clearOperatorInstructions() {
        
        operatorInstructions_ = getDefaultInstance().getOperatorInstructions();
        onChanged();
        return this;
      }
      /**
       * <code>string operator_instructions = 18;</code>
       */
      public Builder setOperatorInstructionsBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        operatorInstructions_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object clearKey_ = "";
      /**
       * <code>string clear_key = 19;</code>
       */
      public java.lang.String getClearKey() {
        java.lang.Object ref = clearKey_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          clearKey_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string clear_key = 19;</code>
       */
      public com.google.protobuf.ByteString
          getClearKeyBytes() {
        java.lang.Object ref = clearKey_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          clearKey_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string clear_key = 19;</code>
       */
      public Builder setClearKey(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        clearKey_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string clear_key = 19;</code>
       */
      public Builder clearClearKey() {
        
        clearKey_ = getDefaultInstance().getClearKey();
        onChanged();
        return this;
      }
      /**
       * <code>string clear_key = 19;</code>
       */
      public Builder setClearKeyBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        clearKey_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object managedObjectInstance_ = "";
      /**
       * <code>string managed_object_instance = 20;</code>
       */
      public java.lang.String getManagedObjectInstance() {
        java.lang.Object ref = managedObjectInstance_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          managedObjectInstance_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string managed_object_instance = 20;</code>
       */
      public com.google.protobuf.ByteString
          getManagedObjectInstanceBytes() {
        java.lang.Object ref = managedObjectInstance_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          managedObjectInstance_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string managed_object_instance = 20;</code>
       */
      public Builder setManagedObjectInstance(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        managedObjectInstance_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string managed_object_instance = 20;</code>
       */
      public Builder clearManagedObjectInstance() {
        
        managedObjectInstance_ = getDefaultInstance().getManagedObjectInstance();
        onChanged();
        return this;
      }
      /**
       * <code>string managed_object_instance = 20;</code>
       */
      public Builder setManagedObjectInstanceBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        managedObjectInstance_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object managedObjectType_ = "";
      /**
       * <code>string managed_object_type = 21;</code>
       */
      public java.lang.String getManagedObjectType() {
        java.lang.Object ref = managedObjectType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          managedObjectType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string managed_object_type = 21;</code>
       */
      public com.google.protobuf.ByteString
          getManagedObjectTypeBytes() {
        java.lang.Object ref = managedObjectType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          managedObjectType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string managed_object_type = 21;</code>
       */
      public Builder setManagedObjectType(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        managedObjectType_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string managed_object_type = 21;</code>
       */
      public Builder clearManagedObjectType() {
        
        managedObjectType_ = getDefaultInstance().getManagedObjectType();
        onChanged();
        return this;
      }
      /**
       * <code>string managed_object_type = 21;</code>
       */
      public Builder setManagedObjectTypeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        managedObjectType_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:Alarm)
    }

    // @@protoc_insertion_point(class_scope:Alarm)
    private static final org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm();
    }

    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Alarm>
        PARSER = new com.google.protobuf.AbstractParser<Alarm>() {
      public Alarm parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Alarm(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Alarm> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Alarm> getParserForType() {
      return PARSER;
    }

    public org.opennms.features.kafka.producer.model.OpennmsModelProtos.Alarm getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface IpInterfaceOrBuilder extends
      // @@protoc_insertion_point(interface_extends:IpInterface)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>uint64 id = 1;</code>
     */
    long getId();

    /**
     * <code>string ip_address = 2;</code>
     */
    java.lang.String getIpAddress();
    /**
     * <code>string ip_address = 2;</code>
     */
    com.google.protobuf.ByteString
        getIpAddressBytes();

    /**
     * <code>uint32 if_index = 3;</code>
     */
    int getIfIndex();

    /**
     * <code>.IpInterface.PrimaryType primary_type = 4;</code>
     */
    int getPrimaryTypeValue();
    /**
     * <code>.IpInterface.PrimaryType primary_type = 4;</code>
     */
    org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.PrimaryType getPrimaryType();

    /**
     * <code>repeated string service = 5;</code>
     */
    java.util.List<java.lang.String>
        getServiceList();
    /**
     * <code>repeated string service = 5;</code>
     */
    int getServiceCount();
    /**
     * <code>repeated string service = 5;</code>
     */
    java.lang.String getService(int index);
    /**
     * <code>repeated string service = 5;</code>
     */
    com.google.protobuf.ByteString
        getServiceBytes(int index);
  }
  /**
   * Protobuf type {@code IpInterface}
   */
  public  static final class IpInterface extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:IpInterface)
      IpInterfaceOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use IpInterface.newBuilder() to construct.
    private IpInterface(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private IpInterface() {
      id_ = 0L;
      ipAddress_ = "";
      ifIndex_ = 0;
      primaryType_ = 0;
      service_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private IpInterface(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {

              id_ = input.readUInt64();
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              ipAddress_ = s;
              break;
            }
            case 24: {

              ifIndex_ = input.readUInt32();
              break;
            }
            case 32: {
              int rawValue = input.readEnum();

              primaryType_ = rawValue;
              break;
            }
            case 42: {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
                service_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000010;
              }
              service_.add(s);
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
          service_ = service_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_IpInterface_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_IpInterface_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.class, org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.Builder.class);
    }

    /**
     * Protobuf enum {@code IpInterface.PrimaryType}
     */
    public enum PrimaryType
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>PRIMARY = 0;</code>
       */
      PRIMARY(0),
      /**
       * <code>SECONDARY = 1;</code>
       */
      SECONDARY(1),
      /**
       * <code>NOT_ELIGIBLE = 2;</code>
       */
      NOT_ELIGIBLE(2),
      UNRECOGNIZED(-1),
      ;

      /**
       * <code>PRIMARY = 0;</code>
       */
      public static final int PRIMARY_VALUE = 0;
      /**
       * <code>SECONDARY = 1;</code>
       */
      public static final int SECONDARY_VALUE = 1;
      /**
       * <code>NOT_ELIGIBLE = 2;</code>
       */
      public static final int NOT_ELIGIBLE_VALUE = 2;


      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static PrimaryType valueOf(int value) {
        return forNumber(value);
      }

      public static PrimaryType forNumber(int value) {
        switch (value) {
          case 0: return PRIMARY;
          case 1: return SECONDARY;
          case 2: return NOT_ELIGIBLE;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<PrimaryType>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          PrimaryType> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<PrimaryType>() {
              public PrimaryType findValueByNumber(int number) {
                return PrimaryType.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.getDescriptor().getEnumTypes().get(0);
      }

      private static final PrimaryType[] VALUES = values();

      public static PrimaryType valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private PrimaryType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:IpInterface.PrimaryType)
    }

    private int bitField0_;
    public static final int ID_FIELD_NUMBER = 1;
    private long id_;
    /**
     * <code>uint64 id = 1;</code>
     */
    public long getId() {
      return id_;
    }

    public static final int IP_ADDRESS_FIELD_NUMBER = 2;
    private volatile java.lang.Object ipAddress_;
    /**
     * <code>string ip_address = 2;</code>
     */
    public java.lang.String getIpAddress() {
      java.lang.Object ref = ipAddress_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipAddress_ = s;
        return s;
      }
    }
    /**
     * <code>string ip_address = 2;</code>
     */
    public com.google.protobuf.ByteString
        getIpAddressBytes() {
      java.lang.Object ref = ipAddress_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        ipAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int IF_INDEX_FIELD_NUMBER = 3;
    private int ifIndex_;
    /**
     * <code>uint32 if_index = 3;</code>
     */
    public int getIfIndex() {
      return ifIndex_;
    }

    public static final int PRIMARY_TYPE_FIELD_NUMBER = 4;
    private int primaryType_;
    /**
     * <code>.IpInterface.PrimaryType primary_type = 4;</code>
     */
    public int getPrimaryTypeValue() {
      return primaryType_;
    }
    /**
     * <code>.IpInterface.PrimaryType primary_type = 4;</code>
     */
    public org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.PrimaryType getPrimaryType() {
      org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.PrimaryType result = org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.PrimaryType.valueOf(primaryType_);
      return result == null ? org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.PrimaryType.UNRECOGNIZED : result;
    }

    public static final int SERVICE_FIELD_NUMBER = 5;
    private com.google.protobuf.LazyStringList service_;
    /**
     * <code>repeated string service = 5;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getServiceList() {
      return service_;
    }
    /**
     * <code>repeated string service = 5;</code>
     */
    public int getServiceCount() {
      return service_.size();
    }
    /**
     * <code>repeated string service = 5;</code>
     */
    public java.lang.String getService(int index) {
      return service_.get(index);
    }
    /**
     * <code>repeated string service = 5;</code>
     */
    public com.google.protobuf.ByteString
        getServiceBytes(int index) {
      return service_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (id_ != 0L) {
        output.writeUInt64(1, id_);
      }
      if (!getIpAddressBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, ipAddress_);
      }
      if (ifIndex_ != 0) {
        output.writeUInt32(3, ifIndex_);
      }
      if (primaryType_ != org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.PrimaryType.PRIMARY.getNumber()) {
        output.writeEnum(4, primaryType_);
      }
      for (int i = 0; i < service_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, service_.getRaw(i));
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (id_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(1, id_);
      }
      if (!getIpAddressBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, ipAddress_);
      }
      if (ifIndex_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(3, ifIndex_);
      }
      if (primaryType_ != org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.PrimaryType.PRIMARY.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(4, primaryType_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < service_.size(); i++) {
          dataSize += computeStringSizeNoTag(service_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getServiceList().size();
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface)) {
        return super.equals(obj);
      }
      org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface other = (org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface) obj;

      boolean result = true;
      result = result && (getId()
          == other.getId());
      result = result && getIpAddress()
          .equals(other.getIpAddress());
      result = result && (getIfIndex()
          == other.getIfIndex());
      result = result && primaryType_ == other.primaryType_;
      result = result && getServiceList()
          .equals(other.getServiceList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getId());
      hash = (37 * hash) + IP_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getIpAddress().hashCode();
      hash = (37 * hash) + IF_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getIfIndex();
      hash = (37 * hash) + PRIMARY_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + primaryType_;
      if (getServiceCount() > 0) {
        hash = (37 * hash) + SERVICE_FIELD_NUMBER;
        hash = (53 * hash) + getServiceList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code IpInterface}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:IpInterface)
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterfaceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_IpInterface_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_IpInterface_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.class, org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.Builder.class);
      }

      // Construct using org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        id_ = 0L;

        ipAddress_ = "";

        ifIndex_ = 0;

        primaryType_ = 0;

        service_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_IpInterface_descriptor;
      }

      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface getDefaultInstanceForType() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.getDefaultInstance();
      }

      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface build() {
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface buildPartial() {
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface result = new org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        result.id_ = id_;
        result.ipAddress_ = ipAddress_;
        result.ifIndex_ = ifIndex_;
        result.primaryType_ = primaryType_;
        if (((bitField0_ & 0x00000010) == 0x00000010)) {
          service_ = service_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.service_ = service_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface) {
          return mergeFrom((org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface other) {
        if (other == org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.getDefaultInstance()) return this;
        if (other.getId() != 0L) {
          setId(other.getId());
        }
        if (!other.getIpAddress().isEmpty()) {
          ipAddress_ = other.ipAddress_;
          onChanged();
        }
        if (other.getIfIndex() != 0) {
          setIfIndex(other.getIfIndex());
        }
        if (other.primaryType_ != 0) {
          setPrimaryTypeValue(other.getPrimaryTypeValue());
        }
        if (!other.service_.isEmpty()) {
          if (service_.isEmpty()) {
            service_ = other.service_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureServiceIsMutable();
            service_.addAll(other.service_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private long id_ ;
      /**
       * <code>uint64 id = 1;</code>
       */
      public long getId() {
        return id_;
      }
      /**
       * <code>uint64 id = 1;</code>
       */
      public Builder setId(long value) {
        
        id_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>uint64 id = 1;</code>
       */
      public Builder clearId() {
        
        id_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object ipAddress_ = "";
      /**
       * <code>string ip_address = 2;</code>
       */
      public java.lang.String getIpAddress() {
        java.lang.Object ref = ipAddress_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          ipAddress_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string ip_address = 2;</code>
       */
      public com.google.protobuf.ByteString
          getIpAddressBytes() {
        java.lang.Object ref = ipAddress_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          ipAddress_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string ip_address = 2;</code>
       */
      public Builder setIpAddress(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        ipAddress_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string ip_address = 2;</code>
       */
      public Builder clearIpAddress() {
        
        ipAddress_ = getDefaultInstance().getIpAddress();
        onChanged();
        return this;
      }
      /**
       * <code>string ip_address = 2;</code>
       */
      public Builder setIpAddressBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        ipAddress_ = value;
        onChanged();
        return this;
      }

      private int ifIndex_ ;
      /**
       * <code>uint32 if_index = 3;</code>
       */
      public int getIfIndex() {
        return ifIndex_;
      }
      /**
       * <code>uint32 if_index = 3;</code>
       */
      public Builder setIfIndex(int value) {
        
        ifIndex_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>uint32 if_index = 3;</code>
       */
      public Builder clearIfIndex() {
        
        ifIndex_ = 0;
        onChanged();
        return this;
      }

      private int primaryType_ = 0;
      /**
       * <code>.IpInterface.PrimaryType primary_type = 4;</code>
       */
      public int getPrimaryTypeValue() {
        return primaryType_;
      }
      /**
       * <code>.IpInterface.PrimaryType primary_type = 4;</code>
       */
      public Builder setPrimaryTypeValue(int value) {
        primaryType_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>.IpInterface.PrimaryType primary_type = 4;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.PrimaryType getPrimaryType() {
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.PrimaryType result = org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.PrimaryType.valueOf(primaryType_);
        return result == null ? org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.PrimaryType.UNRECOGNIZED : result;
      }
      /**
       * <code>.IpInterface.PrimaryType primary_type = 4;</code>
       */
      public Builder setPrimaryType(org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.PrimaryType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        primaryType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>.IpInterface.PrimaryType primary_type = 4;</code>
       */
      public Builder clearPrimaryType() {
        
        primaryType_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList service_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureServiceIsMutable() {
        if (!((bitField0_ & 0x00000010) == 0x00000010)) {
          service_ = new com.google.protobuf.LazyStringArrayList(service_);
          bitField0_ |= 0x00000010;
         }
      }
      /**
       * <code>repeated string service = 5;</code>
       */
      public com.google.protobuf.ProtocolStringList
          getServiceList() {
        return service_.getUnmodifiableView();
      }
      /**
       * <code>repeated string service = 5;</code>
       */
      public int getServiceCount() {
        return service_.size();
      }
      /**
       * <code>repeated string service = 5;</code>
       */
      public java.lang.String getService(int index) {
        return service_.get(index);
      }
      /**
       * <code>repeated string service = 5;</code>
       */
      public com.google.protobuf.ByteString
          getServiceBytes(int index) {
        return service_.getByteString(index);
      }
      /**
       * <code>repeated string service = 5;</code>
       */
      public Builder setService(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureServiceIsMutable();
        service_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string service = 5;</code>
       */
      public Builder addService(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureServiceIsMutable();
        service_.add(value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string service = 5;</code>
       */
      public Builder addAllService(
          java.lang.Iterable<java.lang.String> values) {
        ensureServiceIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, service_);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string service = 5;</code>
       */
      public Builder clearService() {
        service_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string service = 5;</code>
       */
      public Builder addServiceBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        ensureServiceIsMutable();
        service_.add(value);
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:IpInterface)
    }

    // @@protoc_insertion_point(class_scope:IpInterface)
    private static final org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface();
    }

    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<IpInterface>
        PARSER = new com.google.protobuf.AbstractParser<IpInterface>() {
      public IpInterface parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new IpInterface(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<IpInterface> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IpInterface> getParserForType() {
      return PARSER;
    }

    public org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface SnmpInterfaceOrBuilder extends
      // @@protoc_insertion_point(interface_extends:SnmpInterface)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>uint64 id = 1;</code>
     */
    long getId();

    /**
     * <code>uint32 if_index = 2;</code>
     */
    int getIfIndex();

    /**
     * <code>string if_descr = 3;</code>
     */
    java.lang.String getIfDescr();
    /**
     * <code>string if_descr = 3;</code>
     */
    com.google.protobuf.ByteString
        getIfDescrBytes();

    /**
     * <code>uint32 if_type = 4;</code>
     */
    int getIfType();

    /**
     * <code>string if_name = 5;</code>
     */
    java.lang.String getIfName();
    /**
     * <code>string if_name = 5;</code>
     */
    com.google.protobuf.ByteString
        getIfNameBytes();

    /**
     * <code>uint64 if_speed = 6;</code>
     */
    long getIfSpeed();

    /**
     * <code>string if_phys_address = 7;</code>
     */
    java.lang.String getIfPhysAddress();
    /**
     * <code>string if_phys_address = 7;</code>
     */
    com.google.protobuf.ByteString
        getIfPhysAddressBytes();

    /**
     * <code>uint32 if_admin_status = 8;</code>
     */
    int getIfAdminStatus();

    /**
     * <code>uint32 if_oper_status = 9;</code>
     */
    int getIfOperStatus();

    /**
     * <code>string if_alias = 10;</code>
     */
    java.lang.String getIfAlias();
    /**
     * <code>string if_alias = 10;</code>
     */
    com.google.protobuf.ByteString
        getIfAliasBytes();
  }
  /**
   * Protobuf type {@code SnmpInterface}
   */
  public  static final class SnmpInterface extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:SnmpInterface)
      SnmpInterfaceOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use SnmpInterface.newBuilder() to construct.
    private SnmpInterface(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private SnmpInterface() {
      id_ = 0L;
      ifIndex_ = 0;
      ifDescr_ = "";
      ifType_ = 0;
      ifName_ = "";
      ifSpeed_ = 0L;
      ifPhysAddress_ = "";
      ifAdminStatus_ = 0;
      ifOperStatus_ = 0;
      ifAlias_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private SnmpInterface(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {

              id_ = input.readUInt64();
              break;
            }
            case 16: {

              ifIndex_ = input.readUInt32();
              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();

              ifDescr_ = s;
              break;
            }
            case 32: {

              ifType_ = input.readUInt32();
              break;
            }
            case 42: {
              java.lang.String s = input.readStringRequireUtf8();

              ifName_ = s;
              break;
            }
            case 48: {

              ifSpeed_ = input.readUInt64();
              break;
            }
            case 58: {
              java.lang.String s = input.readStringRequireUtf8();

              ifPhysAddress_ = s;
              break;
            }
            case 64: {

              ifAdminStatus_ = input.readUInt32();
              break;
            }
            case 72: {

              ifOperStatus_ = input.readUInt32();
              break;
            }
            case 82: {
              java.lang.String s = input.readStringRequireUtf8();

              ifAlias_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_SnmpInterface_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_SnmpInterface_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface.class, org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface.Builder.class);
    }

    public static final int ID_FIELD_NUMBER = 1;
    private long id_;
    /**
     * <code>uint64 id = 1;</code>
     */
    public long getId() {
      return id_;
    }

    public static final int IF_INDEX_FIELD_NUMBER = 2;
    private int ifIndex_;
    /**
     * <code>uint32 if_index = 2;</code>
     */
    public int getIfIndex() {
      return ifIndex_;
    }

    public static final int IF_DESCR_FIELD_NUMBER = 3;
    private volatile java.lang.Object ifDescr_;
    /**
     * <code>string if_descr = 3;</code>
     */
    public java.lang.String getIfDescr() {
      java.lang.Object ref = ifDescr_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ifDescr_ = s;
        return s;
      }
    }
    /**
     * <code>string if_descr = 3;</code>
     */
    public com.google.protobuf.ByteString
        getIfDescrBytes() {
      java.lang.Object ref = ifDescr_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        ifDescr_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int IF_TYPE_FIELD_NUMBER = 4;
    private int ifType_;
    /**
     * <code>uint32 if_type = 4;</code>
     */
    public int getIfType() {
      return ifType_;
    }

    public static final int IF_NAME_FIELD_NUMBER = 5;
    private volatile java.lang.Object ifName_;
    /**
     * <code>string if_name = 5;</code>
     */
    public java.lang.String getIfName() {
      java.lang.Object ref = ifName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ifName_ = s;
        return s;
      }
    }
    /**
     * <code>string if_name = 5;</code>
     */
    public com.google.protobuf.ByteString
        getIfNameBytes() {
      java.lang.Object ref = ifName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        ifName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int IF_SPEED_FIELD_NUMBER = 6;
    private long ifSpeed_;
    /**
     * <code>uint64 if_speed = 6;</code>
     */
    public long getIfSpeed() {
      return ifSpeed_;
    }

    public static final int IF_PHYS_ADDRESS_FIELD_NUMBER = 7;
    private volatile java.lang.Object ifPhysAddress_;
    /**
     * <code>string if_phys_address = 7;</code>
     */
    public java.lang.String getIfPhysAddress() {
      java.lang.Object ref = ifPhysAddress_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ifPhysAddress_ = s;
        return s;
      }
    }
    /**
     * <code>string if_phys_address = 7;</code>
     */
    public com.google.protobuf.ByteString
        getIfPhysAddressBytes() {
      java.lang.Object ref = ifPhysAddress_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        ifPhysAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int IF_ADMIN_STATUS_FIELD_NUMBER = 8;
    private int ifAdminStatus_;
    /**
     * <code>uint32 if_admin_status = 8;</code>
     */
    public int getIfAdminStatus() {
      return ifAdminStatus_;
    }

    public static final int IF_OPER_STATUS_FIELD_NUMBER = 9;
    private int ifOperStatus_;
    /**
     * <code>uint32 if_oper_status = 9;</code>
     */
    public int getIfOperStatus() {
      return ifOperStatus_;
    }

    public static final int IF_ALIAS_FIELD_NUMBER = 10;
    private volatile java.lang.Object ifAlias_;
    /**
     * <code>string if_alias = 10;</code>
     */
    public java.lang.String getIfAlias() {
      java.lang.Object ref = ifAlias_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ifAlias_ = s;
        return s;
      }
    }
    /**
     * <code>string if_alias = 10;</code>
     */
    public com.google.protobuf.ByteString
        getIfAliasBytes() {
      java.lang.Object ref = ifAlias_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        ifAlias_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (id_ != 0L) {
        output.writeUInt64(1, id_);
      }
      if (ifIndex_ != 0) {
        output.writeUInt32(2, ifIndex_);
      }
      if (!getIfDescrBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, ifDescr_);
      }
      if (ifType_ != 0) {
        output.writeUInt32(4, ifType_);
      }
      if (!getIfNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, ifName_);
      }
      if (ifSpeed_ != 0L) {
        output.writeUInt64(6, ifSpeed_);
      }
      if (!getIfPhysAddressBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, ifPhysAddress_);
      }
      if (ifAdminStatus_ != 0) {
        output.writeUInt32(8, ifAdminStatus_);
      }
      if (ifOperStatus_ != 0) {
        output.writeUInt32(9, ifOperStatus_);
      }
      if (!getIfAliasBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 10, ifAlias_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (id_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(1, id_);
      }
      if (ifIndex_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(2, ifIndex_);
      }
      if (!getIfDescrBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, ifDescr_);
      }
      if (ifType_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(4, ifType_);
      }
      if (!getIfNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, ifName_);
      }
      if (ifSpeed_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(6, ifSpeed_);
      }
      if (!getIfPhysAddressBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, ifPhysAddress_);
      }
      if (ifAdminStatus_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(8, ifAdminStatus_);
      }
      if (ifOperStatus_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(9, ifOperStatus_);
      }
      if (!getIfAliasBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, ifAlias_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface)) {
        return super.equals(obj);
      }
      org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface other = (org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface) obj;

      boolean result = true;
      result = result && (getId()
          == other.getId());
      result = result && (getIfIndex()
          == other.getIfIndex());
      result = result && getIfDescr()
          .equals(other.getIfDescr());
      result = result && (getIfType()
          == other.getIfType());
      result = result && getIfName()
          .equals(other.getIfName());
      result = result && (getIfSpeed()
          == other.getIfSpeed());
      result = result && getIfPhysAddress()
          .equals(other.getIfPhysAddress());
      result = result && (getIfAdminStatus()
          == other.getIfAdminStatus());
      result = result && (getIfOperStatus()
          == other.getIfOperStatus());
      result = result && getIfAlias()
          .equals(other.getIfAlias());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getId());
      hash = (37 * hash) + IF_INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getIfIndex();
      hash = (37 * hash) + IF_DESCR_FIELD_NUMBER;
      hash = (53 * hash) + getIfDescr().hashCode();
      hash = (37 * hash) + IF_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getIfType();
      hash = (37 * hash) + IF_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getIfName().hashCode();
      hash = (37 * hash) + IF_SPEED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getIfSpeed());
      hash = (37 * hash) + IF_PHYS_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getIfPhysAddress().hashCode();
      hash = (37 * hash) + IF_ADMIN_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getIfAdminStatus();
      hash = (37 * hash) + IF_OPER_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getIfOperStatus();
      hash = (37 * hash) + IF_ALIAS_FIELD_NUMBER;
      hash = (53 * hash) + getIfAlias().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code SnmpInterface}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:SnmpInterface)
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterfaceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_SnmpInterface_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_SnmpInterface_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface.class, org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface.Builder.class);
      }

      // Construct using org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        id_ = 0L;

        ifIndex_ = 0;

        ifDescr_ = "";

        ifType_ = 0;

        ifName_ = "";

        ifSpeed_ = 0L;

        ifPhysAddress_ = "";

        ifAdminStatus_ = 0;

        ifOperStatus_ = 0;

        ifAlias_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_SnmpInterface_descriptor;
      }

      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface getDefaultInstanceForType() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface.getDefaultInstance();
      }

      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface build() {
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface buildPartial() {
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface result = new org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface(this);
        result.id_ = id_;
        result.ifIndex_ = ifIndex_;
        result.ifDescr_ = ifDescr_;
        result.ifType_ = ifType_;
        result.ifName_ = ifName_;
        result.ifSpeed_ = ifSpeed_;
        result.ifPhysAddress_ = ifPhysAddress_;
        result.ifAdminStatus_ = ifAdminStatus_;
        result.ifOperStatus_ = ifOperStatus_;
        result.ifAlias_ = ifAlias_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface) {
          return mergeFrom((org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface other) {
        if (other == org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface.getDefaultInstance()) return this;
        if (other.getId() != 0L) {
          setId(other.getId());
        }
        if (other.getIfIndex() != 0) {
          setIfIndex(other.getIfIndex());
        }
        if (!other.getIfDescr().isEmpty()) {
          ifDescr_ = other.ifDescr_;
          onChanged();
        }
        if (other.getIfType() != 0) {
          setIfType(other.getIfType());
        }
        if (!other.getIfName().isEmpty()) {
          ifName_ = other.ifName_;
          onChanged();
        }
        if (other.getIfSpeed() != 0L) {
          setIfSpeed(other.getIfSpeed());
        }
        if (!other.getIfPhysAddress().isEmpty()) {
          ifPhysAddress_ = other.ifPhysAddress_;
          onChanged();
        }
        if (other.getIfAdminStatus() != 0) {
          setIfAdminStatus(other.getIfAdminStatus());
        }
        if (other.getIfOperStatus() != 0) {
          setIfOperStatus(other.getIfOperStatus());
        }
        if (!other.getIfAlias().isEmpty()) {
          ifAlias_ = other.ifAlias_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private long id_ ;
      /**
       * <code>uint64 id = 1;</code>
       */
      public long getId() {
        return id_;
      }
      /**
       * <code>uint64 id = 1;</code>
       */
      public Builder setId(long value) {
        
        id_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>uint64 id = 1;</code>
       */
      public Builder clearId() {
        
        id_ = 0L;
        onChanged();
        return this;
      }

      private int ifIndex_ ;
      /**
       * <code>uint32 if_index = 2;</code>
       */
      public int getIfIndex() {
        return ifIndex_;
      }
      /**
       * <code>uint32 if_index = 2;</code>
       */
      public Builder setIfIndex(int value) {
        
        ifIndex_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>uint32 if_index = 2;</code>
       */
      public Builder clearIfIndex() {
        
        ifIndex_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object ifDescr_ = "";
      /**
       * <code>string if_descr = 3;</code>
       */
      public java.lang.String getIfDescr() {
        java.lang.Object ref = ifDescr_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          ifDescr_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string if_descr = 3;</code>
       */
      public com.google.protobuf.ByteString
          getIfDescrBytes() {
        java.lang.Object ref = ifDescr_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          ifDescr_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string if_descr = 3;</code>
       */
      public Builder setIfDescr(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        ifDescr_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string if_descr = 3;</code>
       */
      public Builder clearIfDescr() {
        
        ifDescr_ = getDefaultInstance().getIfDescr();
        onChanged();
        return this;
      }
      /**
       * <code>string if_descr = 3;</code>
       */
      public Builder setIfDescrBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        ifDescr_ = value;
        onChanged();
        return this;
      }

      private int ifType_ ;
      /**
       * <code>uint32 if_type = 4;</code>
       */
      public int getIfType() {
        return ifType_;
      }
      /**
       * <code>uint32 if_type = 4;</code>
       */
      public Builder setIfType(int value) {
        
        ifType_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>uint32 if_type = 4;</code>
       */
      public Builder clearIfType() {
        
        ifType_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object ifName_ = "";
      /**
       * <code>string if_name = 5;</code>
       */
      public java.lang.String getIfName() {
        java.lang.Object ref = ifName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          ifName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string if_name = 5;</code>
       */
      public com.google.protobuf.ByteString
          getIfNameBytes() {
        java.lang.Object ref = ifName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          ifName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string if_name = 5;</code>
       */
      public Builder setIfName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        ifName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string if_name = 5;</code>
       */
      public Builder clearIfName() {
        
        ifName_ = getDefaultInstance().getIfName();
        onChanged();
        return this;
      }
      /**
       * <code>string if_name = 5;</code>
       */
      public Builder setIfNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        ifName_ = value;
        onChanged();
        return this;
      }

      private long ifSpeed_ ;
      /**
       * <code>uint64 if_speed = 6;</code>
       */
      public long getIfSpeed() {
        return ifSpeed_;
      }
      /**
       * <code>uint64 if_speed = 6;</code>
       */
      public Builder setIfSpeed(long value) {
        
        ifSpeed_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>uint64 if_speed = 6;</code>
       */
      public Builder clearIfSpeed() {
        
        ifSpeed_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object ifPhysAddress_ = "";
      /**
       * <code>string if_phys_address = 7;</code>
       */
      public java.lang.String getIfPhysAddress() {
        java.lang.Object ref = ifPhysAddress_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          ifPhysAddress_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string if_phys_address = 7;</code>
       */
      public com.google.protobuf.ByteString
          getIfPhysAddressBytes() {
        java.lang.Object ref = ifPhysAddress_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          ifPhysAddress_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string if_phys_address = 7;</code>
       */
      public Builder setIfPhysAddress(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        ifPhysAddress_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string if_phys_address = 7;</code>
       */
      public Builder clearIfPhysAddress() {
        
        ifPhysAddress_ = getDefaultInstance().getIfPhysAddress();
        onChanged();
        return this;
      }
      /**
       * <code>string if_phys_address = 7;</code>
       */
      public Builder setIfPhysAddressBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        ifPhysAddress_ = value;
        onChanged();
        return this;
      }

      private int ifAdminStatus_ ;
      /**
       * <code>uint32 if_admin_status = 8;</code>
       */
      public int getIfAdminStatus() {
        return ifAdminStatus_;
      }
      /**
       * <code>uint32 if_admin_status = 8;</code>
       */
      public Builder setIfAdminStatus(int value) {
        
        ifAdminStatus_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>uint32 if_admin_status = 8;</code>
       */
      public Builder clearIfAdminStatus() {
        
        ifAdminStatus_ = 0;
        onChanged();
        return this;
      }

      private int ifOperStatus_ ;
      /**
       * <code>uint32 if_oper_status = 9;</code>
       */
      public int getIfOperStatus() {
        return ifOperStatus_;
      }
      /**
       * <code>uint32 if_oper_status = 9;</code>
       */
      public Builder setIfOperStatus(int value) {
        
        ifOperStatus_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>uint32 if_oper_status = 9;</code>
       */
      public Builder clearIfOperStatus() {
        
        ifOperStatus_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object ifAlias_ = "";
      /**
       * <code>string if_alias = 10;</code>
       */
      public java.lang.String getIfAlias() {
        java.lang.Object ref = ifAlias_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          ifAlias_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string if_alias = 10;</code>
       */
      public com.google.protobuf.ByteString
          getIfAliasBytes() {
        java.lang.Object ref = ifAlias_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          ifAlias_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string if_alias = 10;</code>
       */
      public Builder setIfAlias(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        ifAlias_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string if_alias = 10;</code>
       */
      public Builder clearIfAlias() {
        
        ifAlias_ = getDefaultInstance().getIfAlias();
        onChanged();
        return this;
      }
      /**
       * <code>string if_alias = 10;</code>
       */
      public Builder setIfAliasBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        ifAlias_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:SnmpInterface)
    }

    // @@protoc_insertion_point(class_scope:SnmpInterface)
    private static final org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface();
    }

    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SnmpInterface>
        PARSER = new com.google.protobuf.AbstractParser<SnmpInterface>() {
      public SnmpInterface parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new SnmpInterface(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<SnmpInterface> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SnmpInterface> getParserForType() {
      return PARSER;
    }

    public org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface NodeOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Node)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>uint64 id = 1;</code>
     */
    long getId();

    /**
     * <code>string foreign_source = 2;</code>
     */
    java.lang.String getForeignSource();
    /**
     * <code>string foreign_source = 2;</code>
     */
    com.google.protobuf.ByteString
        getForeignSourceBytes();

    /**
     * <code>string foreign_id = 3;</code>
     */
    java.lang.String getForeignId();
    /**
     * <code>string foreign_id = 3;</code>
     */
    com.google.protobuf.ByteString
        getForeignIdBytes();

    /**
     * <code>string location = 4;</code>
     */
    java.lang.String getLocation();
    /**
     * <code>string location = 4;</code>
     */
    com.google.protobuf.ByteString
        getLocationBytes();

    /**
     * <code>repeated string category = 5;</code>
     */
    java.util.List<java.lang.String>
        getCategoryList();
    /**
     * <code>repeated string category = 5;</code>
     */
    int getCategoryCount();
    /**
     * <code>repeated string category = 5;</code>
     */
    java.lang.String getCategory(int index);
    /**
     * <code>repeated string category = 5;</code>
     */
    com.google.protobuf.ByteString
        getCategoryBytes(int index);

    /**
     * <code>string label = 6;</code>
     */
    java.lang.String getLabel();
    /**
     * <code>string label = 6;</code>
     */
    com.google.protobuf.ByteString
        getLabelBytes();

    /**
     * <code>uint64 create_time = 7;</code>
     */
    long getCreateTime();

    /**
     * <code>string sys_contact = 8;</code>
     */
    java.lang.String getSysContact();
    /**
     * <code>string sys_contact = 8;</code>
     */
    com.google.protobuf.ByteString
        getSysContactBytes();

    /**
     * <code>string sys_description = 9;</code>
     */
    java.lang.String getSysDescription();
    /**
     * <code>string sys_description = 9;</code>
     */
    com.google.protobuf.ByteString
        getSysDescriptionBytes();

    /**
     * <code>string sys_object_id = 10;</code>
     */
    java.lang.String getSysObjectId();
    /**
     * <code>string sys_object_id = 10;</code>
     */
    com.google.protobuf.ByteString
        getSysObjectIdBytes();

    /**
     * <code>repeated .IpInterface ip_interface = 11;</code>
     */
    java.util.List<org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface> 
        getIpInterfaceList();
    /**
     * <code>repeated .IpInterface ip_interface = 11;</code>
     */
    org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface getIpInterface(int index);
    /**
     * <code>repeated .IpInterface ip_interface = 11;</code>
     */
    int getIpInterfaceCount();
    /**
     * <code>repeated .IpInterface ip_interface = 11;</code>
     */
    java.util.List<? extends org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterfaceOrBuilder> 
        getIpInterfaceOrBuilderList();
    /**
     * <code>repeated .IpInterface ip_interface = 11;</code>
     */
    org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterfaceOrBuilder getIpInterfaceOrBuilder(
        int index);

    /**
     * <code>repeated .SnmpInterface snmp_interface = 12;</code>
     */
    java.util.List<org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface> 
        getSnmpInterfaceList();
    /**
     * <code>repeated .SnmpInterface snmp_interface = 12;</code>
     */
    org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface getSnmpInterface(int index);
    /**
     * <code>repeated .SnmpInterface snmp_interface = 12;</code>
     */
    int getSnmpInterfaceCount();
    /**
     * <code>repeated .SnmpInterface snmp_interface = 12;</code>
     */
    java.util.List<? extends org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterfaceOrBuilder> 
        getSnmpInterfaceOrBuilderList();
    /**
     * <code>repeated .SnmpInterface snmp_interface = 12;</code>
     */
    org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterfaceOrBuilder getSnmpInterfaceOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code Node}
   */
  public  static final class Node extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:Node)
      NodeOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Node.newBuilder() to construct.
    private Node(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Node() {
      id_ = 0L;
      foreignSource_ = "";
      foreignId_ = "";
      location_ = "";
      category_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      label_ = "";
      createTime_ = 0L;
      sysContact_ = "";
      sysDescription_ = "";
      sysObjectId_ = "";
      ipInterface_ = java.util.Collections.emptyList();
      snmpInterface_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Node(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {

              id_ = input.readUInt64();
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              foreignSource_ = s;
              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();

              foreignId_ = s;
              break;
            }
            case 34: {
              java.lang.String s = input.readStringRequireUtf8();

              location_ = s;
              break;
            }
            case 42: {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
                category_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000010;
              }
              category_.add(s);
              break;
            }
            case 50: {
              java.lang.String s = input.readStringRequireUtf8();

              label_ = s;
              break;
            }
            case 56: {

              createTime_ = input.readUInt64();
              break;
            }
            case 66: {
              java.lang.String s = input.readStringRequireUtf8();

              sysContact_ = s;
              break;
            }
            case 74: {
              java.lang.String s = input.readStringRequireUtf8();

              sysDescription_ = s;
              break;
            }
            case 82: {
              java.lang.String s = input.readStringRequireUtf8();

              sysObjectId_ = s;
              break;
            }
            case 90: {
              if (!((mutable_bitField0_ & 0x00000400) == 0x00000400)) {
                ipInterface_ = new java.util.ArrayList<org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface>();
                mutable_bitField0_ |= 0x00000400;
              }
              ipInterface_.add(
                  input.readMessage(org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.parser(), extensionRegistry));
              break;
            }
            case 98: {
              if (!((mutable_bitField0_ & 0x00000800) == 0x00000800)) {
                snmpInterface_ = new java.util.ArrayList<org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface>();
                mutable_bitField0_ |= 0x00000800;
              }
              snmpInterface_.add(
                  input.readMessage(org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface.parser(), extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
          category_ = category_.getUnmodifiableView();
        }
        if (((mutable_bitField0_ & 0x00000400) == 0x00000400)) {
          ipInterface_ = java.util.Collections.unmodifiableList(ipInterface_);
        }
        if (((mutable_bitField0_ & 0x00000800) == 0x00000800)) {
          snmpInterface_ = java.util.Collections.unmodifiableList(snmpInterface_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_Node_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_Node_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node.class, org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node.Builder.class);
    }

    private int bitField0_;
    public static final int ID_FIELD_NUMBER = 1;
    private long id_;
    /**
     * <code>uint64 id = 1;</code>
     */
    public long getId() {
      return id_;
    }

    public static final int FOREIGN_SOURCE_FIELD_NUMBER = 2;
    private volatile java.lang.Object foreignSource_;
    /**
     * <code>string foreign_source = 2;</code>
     */
    public java.lang.String getForeignSource() {
      java.lang.Object ref = foreignSource_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        foreignSource_ = s;
        return s;
      }
    }
    /**
     * <code>string foreign_source = 2;</code>
     */
    public com.google.protobuf.ByteString
        getForeignSourceBytes() {
      java.lang.Object ref = foreignSource_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        foreignSource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FOREIGN_ID_FIELD_NUMBER = 3;
    private volatile java.lang.Object foreignId_;
    /**
     * <code>string foreign_id = 3;</code>
     */
    public java.lang.String getForeignId() {
      java.lang.Object ref = foreignId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        foreignId_ = s;
        return s;
      }
    }
    /**
     * <code>string foreign_id = 3;</code>
     */
    public com.google.protobuf.ByteString
        getForeignIdBytes() {
      java.lang.Object ref = foreignId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        foreignId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LOCATION_FIELD_NUMBER = 4;
    private volatile java.lang.Object location_;
    /**
     * <code>string location = 4;</code>
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      }
    }
    /**
     * <code>string location = 4;</code>
     */
    public com.google.protobuf.ByteString
        getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CATEGORY_FIELD_NUMBER = 5;
    private com.google.protobuf.LazyStringList category_;
    /**
     * <code>repeated string category = 5;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getCategoryList() {
      return category_;
    }
    /**
     * <code>repeated string category = 5;</code>
     */
    public int getCategoryCount() {
      return category_.size();
    }
    /**
     * <code>repeated string category = 5;</code>
     */
    public java.lang.String getCategory(int index) {
      return category_.get(index);
    }
    /**
     * <code>repeated string category = 5;</code>
     */
    public com.google.protobuf.ByteString
        getCategoryBytes(int index) {
      return category_.getByteString(index);
    }

    public static final int LABEL_FIELD_NUMBER = 6;
    private volatile java.lang.Object label_;
    /**
     * <code>string label = 6;</code>
     */
    public java.lang.String getLabel() {
      java.lang.Object ref = label_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        label_ = s;
        return s;
      }
    }
    /**
     * <code>string label = 6;</code>
     */
    public com.google.protobuf.ByteString
        getLabelBytes() {
      java.lang.Object ref = label_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        label_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CREATE_TIME_FIELD_NUMBER = 7;
    private long createTime_;
    /**
     * <code>uint64 create_time = 7;</code>
     */
    public long getCreateTime() {
      return createTime_;
    }

    public static final int SYS_CONTACT_FIELD_NUMBER = 8;
    private volatile java.lang.Object sysContact_;
    /**
     * <code>string sys_contact = 8;</code>
     */
    public java.lang.String getSysContact() {
      java.lang.Object ref = sysContact_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sysContact_ = s;
        return s;
      }
    }
    /**
     * <code>string sys_contact = 8;</code>
     */
    public com.google.protobuf.ByteString
        getSysContactBytes() {
      java.lang.Object ref = sysContact_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        sysContact_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SYS_DESCRIPTION_FIELD_NUMBER = 9;
    private volatile java.lang.Object sysDescription_;
    /**
     * <code>string sys_description = 9;</code>
     */
    public java.lang.String getSysDescription() {
      java.lang.Object ref = sysDescription_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sysDescription_ = s;
        return s;
      }
    }
    /**
     * <code>string sys_description = 9;</code>
     */
    public com.google.protobuf.ByteString
        getSysDescriptionBytes() {
      java.lang.Object ref = sysDescription_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        sysDescription_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SYS_OBJECT_ID_FIELD_NUMBER = 10;
    private volatile java.lang.Object sysObjectId_;
    /**
     * <code>string sys_object_id = 10;</code>
     */
    public java.lang.String getSysObjectId() {
      java.lang.Object ref = sysObjectId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sysObjectId_ = s;
        return s;
      }
    }
    /**
     * <code>string sys_object_id = 10;</code>
     */
    public com.google.protobuf.ByteString
        getSysObjectIdBytes() {
      java.lang.Object ref = sysObjectId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        sysObjectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int IP_INTERFACE_FIELD_NUMBER = 11;
    private java.util.List<org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface> ipInterface_;
    /**
     * <code>repeated .IpInterface ip_interface = 11;</code>
     */
    public java.util.List<org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface> getIpInterfaceList() {
      return ipInterface_;
    }
    /**
     * <code>repeated .IpInterface ip_interface = 11;</code>
     */
    public java.util.List<? extends org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterfaceOrBuilder> 
        getIpInterfaceOrBuilderList() {
      return ipInterface_;
    }
    /**
     * <code>repeated .IpInterface ip_interface = 11;</code>
     */
    public int getIpInterfaceCount() {
      return ipInterface_.size();
    }
    /**
     * <code>repeated .IpInterface ip_interface = 11;</code>
     */
    public org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface getIpInterface(int index) {
      return ipInterface_.get(index);
    }
    /**
     * <code>repeated .IpInterface ip_interface = 11;</code>
     */
    public org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterfaceOrBuilder getIpInterfaceOrBuilder(
        int index) {
      return ipInterface_.get(index);
    }

    public static final int SNMP_INTERFACE_FIELD_NUMBER = 12;
    private java.util.List<org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface> snmpInterface_;
    /**
     * <code>repeated .SnmpInterface snmp_interface = 12;</code>
     */
    public java.util.List<org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface> getSnmpInterfaceList() {
      return snmpInterface_;
    }
    /**
     * <code>repeated .SnmpInterface snmp_interface = 12;</code>
     */
    public java.util.List<? extends org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterfaceOrBuilder> 
        getSnmpInterfaceOrBuilderList() {
      return snmpInterface_;
    }
    /**
     * <code>repeated .SnmpInterface snmp_interface = 12;</code>
     */
    public int getSnmpInterfaceCount() {
      return snmpInterface_.size();
    }
    /**
     * <code>repeated .SnmpInterface snmp_interface = 12;</code>
     */
    public org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface getSnmpInterface(int index) {
      return snmpInterface_.get(index);
    }
    /**
     * <code>repeated .SnmpInterface snmp_interface = 12;</code>
     */
    public org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterfaceOrBuilder getSnmpInterfaceOrBuilder(
        int index) {
      return snmpInterface_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (id_ != 0L) {
        output.writeUInt64(1, id_);
      }
      if (!getForeignSourceBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, foreignSource_);
      }
      if (!getForeignIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, foreignId_);
      }
      if (!getLocationBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, location_);
      }
      for (int i = 0; i < category_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, category_.getRaw(i));
      }
      if (!getLabelBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, label_);
      }
      if (createTime_ != 0L) {
        output.writeUInt64(7, createTime_);
      }
      if (!getSysContactBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 8, sysContact_);
      }
      if (!getSysDescriptionBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 9, sysDescription_);
      }
      if (!getSysObjectIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 10, sysObjectId_);
      }
      for (int i = 0; i < ipInterface_.size(); i++) {
        output.writeMessage(11, ipInterface_.get(i));
      }
      for (int i = 0; i < snmpInterface_.size(); i++) {
        output.writeMessage(12, snmpInterface_.get(i));
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (id_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(1, id_);
      }
      if (!getForeignSourceBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, foreignSource_);
      }
      if (!getForeignIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, foreignId_);
      }
      if (!getLocationBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, location_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < category_.size(); i++) {
          dataSize += computeStringSizeNoTag(category_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getCategoryList().size();
      }
      if (!getLabelBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, label_);
      }
      if (createTime_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(7, createTime_);
      }
      if (!getSysContactBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, sysContact_);
      }
      if (!getSysDescriptionBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, sysDescription_);
      }
      if (!getSysObjectIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, sysObjectId_);
      }
      for (int i = 0; i < ipInterface_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(11, ipInterface_.get(i));
      }
      for (int i = 0; i < snmpInterface_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(12, snmpInterface_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node)) {
        return super.equals(obj);
      }
      org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node other = (org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node) obj;

      boolean result = true;
      result = result && (getId()
          == other.getId());
      result = result && getForeignSource()
          .equals(other.getForeignSource());
      result = result && getForeignId()
          .equals(other.getForeignId());
      result = result && getLocation()
          .equals(other.getLocation());
      result = result && getCategoryList()
          .equals(other.getCategoryList());
      result = result && getLabel()
          .equals(other.getLabel());
      result = result && (getCreateTime()
          == other.getCreateTime());
      result = result && getSysContact()
          .equals(other.getSysContact());
      result = result && getSysDescription()
          .equals(other.getSysDescription());
      result = result && getSysObjectId()
          .equals(other.getSysObjectId());
      result = result && getIpInterfaceList()
          .equals(other.getIpInterfaceList());
      result = result && getSnmpInterfaceList()
          .equals(other.getSnmpInterfaceList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getId());
      hash = (37 * hash) + FOREIGN_SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getForeignSource().hashCode();
      hash = (37 * hash) + FOREIGN_ID_FIELD_NUMBER;
      hash = (53 * hash) + getForeignId().hashCode();
      hash = (37 * hash) + LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getLocation().hashCode();
      if (getCategoryCount() > 0) {
        hash = (37 * hash) + CATEGORY_FIELD_NUMBER;
        hash = (53 * hash) + getCategoryList().hashCode();
      }
      hash = (37 * hash) + LABEL_FIELD_NUMBER;
      hash = (53 * hash) + getLabel().hashCode();
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getCreateTime());
      hash = (37 * hash) + SYS_CONTACT_FIELD_NUMBER;
      hash = (53 * hash) + getSysContact().hashCode();
      hash = (37 * hash) + SYS_DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getSysDescription().hashCode();
      hash = (37 * hash) + SYS_OBJECT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getSysObjectId().hashCode();
      if (getIpInterfaceCount() > 0) {
        hash = (37 * hash) + IP_INTERFACE_FIELD_NUMBER;
        hash = (53 * hash) + getIpInterfaceList().hashCode();
      }
      if (getSnmpInterfaceCount() > 0) {
        hash = (37 * hash) + SNMP_INTERFACE_FIELD_NUMBER;
        hash = (53 * hash) + getSnmpInterfaceList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Node}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Node)
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.NodeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_Node_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_Node_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node.class, org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node.Builder.class);
      }

      // Construct using org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getIpInterfaceFieldBuilder();
          getSnmpInterfaceFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        id_ = 0L;

        foreignSource_ = "";

        foreignId_ = "";

        location_ = "";

        category_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000010);
        label_ = "";

        createTime_ = 0L;

        sysContact_ = "";

        sysDescription_ = "";

        sysObjectId_ = "";

        if (ipInterfaceBuilder_ == null) {
          ipInterface_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000400);
        } else {
          ipInterfaceBuilder_.clear();
        }
        if (snmpInterfaceBuilder_ == null) {
          snmpInterface_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000800);
        } else {
          snmpInterfaceBuilder_.clear();
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.internal_static_Node_descriptor;
      }

      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node getDefaultInstanceForType() {
        return org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node.getDefaultInstance();
      }

      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node build() {
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node buildPartial() {
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node result = new org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        result.id_ = id_;
        result.foreignSource_ = foreignSource_;
        result.foreignId_ = foreignId_;
        result.location_ = location_;
        if (((bitField0_ & 0x00000010) == 0x00000010)) {
          category_ = category_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.category_ = category_;
        result.label_ = label_;
        result.createTime_ = createTime_;
        result.sysContact_ = sysContact_;
        result.sysDescription_ = sysDescription_;
        result.sysObjectId_ = sysObjectId_;
        if (ipInterfaceBuilder_ == null) {
          if (((bitField0_ & 0x00000400) == 0x00000400)) {
            ipInterface_ = java.util.Collections.unmodifiableList(ipInterface_);
            bitField0_ = (bitField0_ & ~0x00000400);
          }
          result.ipInterface_ = ipInterface_;
        } else {
          result.ipInterface_ = ipInterfaceBuilder_.build();
        }
        if (snmpInterfaceBuilder_ == null) {
          if (((bitField0_ & 0x00000800) == 0x00000800)) {
            snmpInterface_ = java.util.Collections.unmodifiableList(snmpInterface_);
            bitField0_ = (bitField0_ & ~0x00000800);
          }
          result.snmpInterface_ = snmpInterface_;
        } else {
          result.snmpInterface_ = snmpInterfaceBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node) {
          return mergeFrom((org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node other) {
        if (other == org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node.getDefaultInstance()) return this;
        if (other.getId() != 0L) {
          setId(other.getId());
        }
        if (!other.getForeignSource().isEmpty()) {
          foreignSource_ = other.foreignSource_;
          onChanged();
        }
        if (!other.getForeignId().isEmpty()) {
          foreignId_ = other.foreignId_;
          onChanged();
        }
        if (!other.getLocation().isEmpty()) {
          location_ = other.location_;
          onChanged();
        }
        if (!other.category_.isEmpty()) {
          if (category_.isEmpty()) {
            category_ = other.category_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureCategoryIsMutable();
            category_.addAll(other.category_);
          }
          onChanged();
        }
        if (!other.getLabel().isEmpty()) {
          label_ = other.label_;
          onChanged();
        }
        if (other.getCreateTime() != 0L) {
          setCreateTime(other.getCreateTime());
        }
        if (!other.getSysContact().isEmpty()) {
          sysContact_ = other.sysContact_;
          onChanged();
        }
        if (!other.getSysDescription().isEmpty()) {
          sysDescription_ = other.sysDescription_;
          onChanged();
        }
        if (!other.getSysObjectId().isEmpty()) {
          sysObjectId_ = other.sysObjectId_;
          onChanged();
        }
        if (ipInterfaceBuilder_ == null) {
          if (!other.ipInterface_.isEmpty()) {
            if (ipInterface_.isEmpty()) {
              ipInterface_ = other.ipInterface_;
              bitField0_ = (bitField0_ & ~0x00000400);
            } else {
              ensureIpInterfaceIsMutable();
              ipInterface_.addAll(other.ipInterface_);
            }
            onChanged();
          }
        } else {
          if (!other.ipInterface_.isEmpty()) {
            if (ipInterfaceBuilder_.isEmpty()) {
              ipInterfaceBuilder_.dispose();
              ipInterfaceBuilder_ = null;
              ipInterface_ = other.ipInterface_;
              bitField0_ = (bitField0_ & ~0x00000400);
              ipInterfaceBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getIpInterfaceFieldBuilder() : null;
            } else {
              ipInterfaceBuilder_.addAllMessages(other.ipInterface_);
            }
          }
        }
        if (snmpInterfaceBuilder_ == null) {
          if (!other.snmpInterface_.isEmpty()) {
            if (snmpInterface_.isEmpty()) {
              snmpInterface_ = other.snmpInterface_;
              bitField0_ = (bitField0_ & ~0x00000800);
            } else {
              ensureSnmpInterfaceIsMutable();
              snmpInterface_.addAll(other.snmpInterface_);
            }
            onChanged();
          }
        } else {
          if (!other.snmpInterface_.isEmpty()) {
            if (snmpInterfaceBuilder_.isEmpty()) {
              snmpInterfaceBuilder_.dispose();
              snmpInterfaceBuilder_ = null;
              snmpInterface_ = other.snmpInterface_;
              bitField0_ = (bitField0_ & ~0x00000800);
              snmpInterfaceBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getSnmpInterfaceFieldBuilder() : null;
            } else {
              snmpInterfaceBuilder_.addAllMessages(other.snmpInterface_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private long id_ ;
      /**
       * <code>uint64 id = 1;</code>
       */
      public long getId() {
        return id_;
      }
      /**
       * <code>uint64 id = 1;</code>
       */
      public Builder setId(long value) {
        
        id_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>uint64 id = 1;</code>
       */
      public Builder clearId() {
        
        id_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object foreignSource_ = "";
      /**
       * <code>string foreign_source = 2;</code>
       */
      public java.lang.String getForeignSource() {
        java.lang.Object ref = foreignSource_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          foreignSource_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string foreign_source = 2;</code>
       */
      public com.google.protobuf.ByteString
          getForeignSourceBytes() {
        java.lang.Object ref = foreignSource_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          foreignSource_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string foreign_source = 2;</code>
       */
      public Builder setForeignSource(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        foreignSource_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string foreign_source = 2;</code>
       */
      public Builder clearForeignSource() {
        
        foreignSource_ = getDefaultInstance().getForeignSource();
        onChanged();
        return this;
      }
      /**
       * <code>string foreign_source = 2;</code>
       */
      public Builder setForeignSourceBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        foreignSource_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object foreignId_ = "";
      /**
       * <code>string foreign_id = 3;</code>
       */
      public java.lang.String getForeignId() {
        java.lang.Object ref = foreignId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          foreignId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string foreign_id = 3;</code>
       */
      public com.google.protobuf.ByteString
          getForeignIdBytes() {
        java.lang.Object ref = foreignId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          foreignId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string foreign_id = 3;</code>
       */
      public Builder setForeignId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        foreignId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string foreign_id = 3;</code>
       */
      public Builder clearForeignId() {
        
        foreignId_ = getDefaultInstance().getForeignId();
        onChanged();
        return this;
      }
      /**
       * <code>string foreign_id = 3;</code>
       */
      public Builder setForeignIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        foreignId_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object location_ = "";
      /**
       * <code>string location = 4;</code>
       */
      public java.lang.String getLocation() {
        java.lang.Object ref = location_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          location_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string location = 4;</code>
       */
      public com.google.protobuf.ByteString
          getLocationBytes() {
        java.lang.Object ref = location_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          location_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string location = 4;</code>
       */
      public Builder setLocation(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        location_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string location = 4;</code>
       */
      public Builder clearLocation() {
        
        location_ = getDefaultInstance().getLocation();
        onChanged();
        return this;
      }
      /**
       * <code>string location = 4;</code>
       */
      public Builder setLocationBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        location_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList category_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureCategoryIsMutable() {
        if (!((bitField0_ & 0x00000010) == 0x00000010)) {
          category_ = new com.google.protobuf.LazyStringArrayList(category_);
          bitField0_ |= 0x00000010;
         }
      }
      /**
       * <code>repeated string category = 5;</code>
       */
      public com.google.protobuf.ProtocolStringList
          getCategoryList() {
        return category_.getUnmodifiableView();
      }
      /**
       * <code>repeated string category = 5;</code>
       */
      public int getCategoryCount() {
        return category_.size();
      }
      /**
       * <code>repeated string category = 5;</code>
       */
      public java.lang.String getCategory(int index) {
        return category_.get(index);
      }
      /**
       * <code>repeated string category = 5;</code>
       */
      public com.google.protobuf.ByteString
          getCategoryBytes(int index) {
        return category_.getByteString(index);
      }
      /**
       * <code>repeated string category = 5;</code>
       */
      public Builder setCategory(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureCategoryIsMutable();
        category_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string category = 5;</code>
       */
      public Builder addCategory(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureCategoryIsMutable();
        category_.add(value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string category = 5;</code>
       */
      public Builder addAllCategory(
          java.lang.Iterable<java.lang.String> values) {
        ensureCategoryIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, category_);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string category = 5;</code>
       */
      public Builder clearCategory() {
        category_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string category = 5;</code>
       */
      public Builder addCategoryBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        ensureCategoryIsMutable();
        category_.add(value);
        onChanged();
        return this;
      }

      private java.lang.Object label_ = "";
      /**
       * <code>string label = 6;</code>
       */
      public java.lang.String getLabel() {
        java.lang.Object ref = label_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          label_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string label = 6;</code>
       */
      public com.google.protobuf.ByteString
          getLabelBytes() {
        java.lang.Object ref = label_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          label_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string label = 6;</code>
       */
      public Builder setLabel(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        label_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string label = 6;</code>
       */
      public Builder clearLabel() {
        
        label_ = getDefaultInstance().getLabel();
        onChanged();
        return this;
      }
      /**
       * <code>string label = 6;</code>
       */
      public Builder setLabelBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        label_ = value;
        onChanged();
        return this;
      }

      private long createTime_ ;
      /**
       * <code>uint64 create_time = 7;</code>
       */
      public long getCreateTime() {
        return createTime_;
      }
      /**
       * <code>uint64 create_time = 7;</code>
       */
      public Builder setCreateTime(long value) {
        
        createTime_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>uint64 create_time = 7;</code>
       */
      public Builder clearCreateTime() {
        
        createTime_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object sysContact_ = "";
      /**
       * <code>string sys_contact = 8;</code>
       */
      public java.lang.String getSysContact() {
        java.lang.Object ref = sysContact_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sysContact_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string sys_contact = 8;</code>
       */
      public com.google.protobuf.ByteString
          getSysContactBytes() {
        java.lang.Object ref = sysContact_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          sysContact_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string sys_contact = 8;</code>
       */
      public Builder setSysContact(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        sysContact_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string sys_contact = 8;</code>
       */
      public Builder clearSysContact() {
        
        sysContact_ = getDefaultInstance().getSysContact();
        onChanged();
        return this;
      }
      /**
       * <code>string sys_contact = 8;</code>
       */
      public Builder setSysContactBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        sysContact_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object sysDescription_ = "";
      /**
       * <code>string sys_description = 9;</code>
       */
      public java.lang.String getSysDescription() {
        java.lang.Object ref = sysDescription_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sysDescription_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string sys_description = 9;</code>
       */
      public com.google.protobuf.ByteString
          getSysDescriptionBytes() {
        java.lang.Object ref = sysDescription_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          sysDescription_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string sys_description = 9;</code>
       */
      public Builder setSysDescription(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        sysDescription_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string sys_description = 9;</code>
       */
      public Builder clearSysDescription() {
        
        sysDescription_ = getDefaultInstance().getSysDescription();
        onChanged();
        return this;
      }
      /**
       * <code>string sys_description = 9;</code>
       */
      public Builder setSysDescriptionBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        sysDescription_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object sysObjectId_ = "";
      /**
       * <code>string sys_object_id = 10;</code>
       */
      public java.lang.String getSysObjectId() {
        java.lang.Object ref = sysObjectId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sysObjectId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>string sys_object_id = 10;</code>
       */
      public com.google.protobuf.ByteString
          getSysObjectIdBytes() {
        java.lang.Object ref = sysObjectId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          sysObjectId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>string sys_object_id = 10;</code>
       */
      public Builder setSysObjectId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        sysObjectId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>string sys_object_id = 10;</code>
       */
      public Builder clearSysObjectId() {
        
        sysObjectId_ = getDefaultInstance().getSysObjectId();
        onChanged();
        return this;
      }
      /**
       * <code>string sys_object_id = 10;</code>
       */
      public Builder setSysObjectIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        sysObjectId_ = value;
        onChanged();
        return this;
      }

      private java.util.List<org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface> ipInterface_ =
        java.util.Collections.emptyList();
      private void ensureIpInterfaceIsMutable() {
        if (!((bitField0_ & 0x00000400) == 0x00000400)) {
          ipInterface_ = new java.util.ArrayList<org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface>(ipInterface_);
          bitField0_ |= 0x00000400;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface, org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.Builder, org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterfaceOrBuilder> ipInterfaceBuilder_;

      /**
       * <code>repeated .IpInterface ip_interface = 11;</code>
       */
      public java.util.List<org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface> getIpInterfaceList() {
        if (ipInterfaceBuilder_ == null) {
          return java.util.Collections.unmodifiableList(ipInterface_);
        } else {
          return ipInterfaceBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .IpInterface ip_interface = 11;</code>
       */
      public int getIpInterfaceCount() {
        if (ipInterfaceBuilder_ == null) {
          return ipInterface_.size();
        } else {
          return ipInterfaceBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .IpInterface ip_interface = 11;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface getIpInterface(int index) {
        if (ipInterfaceBuilder_ == null) {
          return ipInterface_.get(index);
        } else {
          return ipInterfaceBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .IpInterface ip_interface = 11;</code>
       */
      public Builder setIpInterface(
          int index, org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface value) {
        if (ipInterfaceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIpInterfaceIsMutable();
          ipInterface_.set(index, value);
          onChanged();
        } else {
          ipInterfaceBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .IpInterface ip_interface = 11;</code>
       */
      public Builder setIpInterface(
          int index, org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.Builder builderForValue) {
        if (ipInterfaceBuilder_ == null) {
          ensureIpInterfaceIsMutable();
          ipInterface_.set(index, builderForValue.build());
          onChanged();
        } else {
          ipInterfaceBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .IpInterface ip_interface = 11;</code>
       */
      public Builder addIpInterface(org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface value) {
        if (ipInterfaceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIpInterfaceIsMutable();
          ipInterface_.add(value);
          onChanged();
        } else {
          ipInterfaceBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .IpInterface ip_interface = 11;</code>
       */
      public Builder addIpInterface(
          int index, org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface value) {
        if (ipInterfaceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureIpInterfaceIsMutable();
          ipInterface_.add(index, value);
          onChanged();
        } else {
          ipInterfaceBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .IpInterface ip_interface = 11;</code>
       */
      public Builder addIpInterface(
          org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.Builder builderForValue) {
        if (ipInterfaceBuilder_ == null) {
          ensureIpInterfaceIsMutable();
          ipInterface_.add(builderForValue.build());
          onChanged();
        } else {
          ipInterfaceBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .IpInterface ip_interface = 11;</code>
       */
      public Builder addIpInterface(
          int index, org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.Builder builderForValue) {
        if (ipInterfaceBuilder_ == null) {
          ensureIpInterfaceIsMutable();
          ipInterface_.add(index, builderForValue.build());
          onChanged();
        } else {
          ipInterfaceBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .IpInterface ip_interface = 11;</code>
       */
      public Builder addAllIpInterface(
          java.lang.Iterable<? extends org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface> values) {
        if (ipInterfaceBuilder_ == null) {
          ensureIpInterfaceIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, ipInterface_);
          onChanged();
        } else {
          ipInterfaceBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .IpInterface ip_interface = 11;</code>
       */
      public Builder clearIpInterface() {
        if (ipInterfaceBuilder_ == null) {
          ipInterface_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000400);
          onChanged();
        } else {
          ipInterfaceBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .IpInterface ip_interface = 11;</code>
       */
      public Builder removeIpInterface(int index) {
        if (ipInterfaceBuilder_ == null) {
          ensureIpInterfaceIsMutable();
          ipInterface_.remove(index);
          onChanged();
        } else {
          ipInterfaceBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .IpInterface ip_interface = 11;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.Builder getIpInterfaceBuilder(
          int index) {
        return getIpInterfaceFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .IpInterface ip_interface = 11;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterfaceOrBuilder getIpInterfaceOrBuilder(
          int index) {
        if (ipInterfaceBuilder_ == null) {
          return ipInterface_.get(index);  } else {
          return ipInterfaceBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .IpInterface ip_interface = 11;</code>
       */
      public java.util.List<? extends org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterfaceOrBuilder> 
           getIpInterfaceOrBuilderList() {
        if (ipInterfaceBuilder_ != null) {
          return ipInterfaceBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(ipInterface_);
        }
      }
      /**
       * <code>repeated .IpInterface ip_interface = 11;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.Builder addIpInterfaceBuilder() {
        return getIpInterfaceFieldBuilder().addBuilder(
            org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.getDefaultInstance());
      }
      /**
       * <code>repeated .IpInterface ip_interface = 11;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.Builder addIpInterfaceBuilder(
          int index) {
        return getIpInterfaceFieldBuilder().addBuilder(
            index, org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.getDefaultInstance());
      }
      /**
       * <code>repeated .IpInterface ip_interface = 11;</code>
       */
      public java.util.List<org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.Builder> 
           getIpInterfaceBuilderList() {
        return getIpInterfaceFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface, org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.Builder, org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterfaceOrBuilder> 
          getIpInterfaceFieldBuilder() {
        if (ipInterfaceBuilder_ == null) {
          ipInterfaceBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface, org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterface.Builder, org.opennms.features.kafka.producer.model.OpennmsModelProtos.IpInterfaceOrBuilder>(
                  ipInterface_,
                  ((bitField0_ & 0x00000400) == 0x00000400),
                  getParentForChildren(),
                  isClean());
          ipInterface_ = null;
        }
        return ipInterfaceBuilder_;
      }

      private java.util.List<org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface> snmpInterface_ =
        java.util.Collections.emptyList();
      private void ensureSnmpInterfaceIsMutable() {
        if (!((bitField0_ & 0x00000800) == 0x00000800)) {
          snmpInterface_ = new java.util.ArrayList<org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface>(snmpInterface_);
          bitField0_ |= 0x00000800;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface, org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface.Builder, org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterfaceOrBuilder> snmpInterfaceBuilder_;

      /**
       * <code>repeated .SnmpInterface snmp_interface = 12;</code>
       */
      public java.util.List<org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface> getSnmpInterfaceList() {
        if (snmpInterfaceBuilder_ == null) {
          return java.util.Collections.unmodifiableList(snmpInterface_);
        } else {
          return snmpInterfaceBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .SnmpInterface snmp_interface = 12;</code>
       */
      public int getSnmpInterfaceCount() {
        if (snmpInterfaceBuilder_ == null) {
          return snmpInterface_.size();
        } else {
          return snmpInterfaceBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .SnmpInterface snmp_interface = 12;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface getSnmpInterface(int index) {
        if (snmpInterfaceBuilder_ == null) {
          return snmpInterface_.get(index);
        } else {
          return snmpInterfaceBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .SnmpInterface snmp_interface = 12;</code>
       */
      public Builder setSnmpInterface(
          int index, org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface value) {
        if (snmpInterfaceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSnmpInterfaceIsMutable();
          snmpInterface_.set(index, value);
          onChanged();
        } else {
          snmpInterfaceBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .SnmpInterface snmp_interface = 12;</code>
       */
      public Builder setSnmpInterface(
          int index, org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface.Builder builderForValue) {
        if (snmpInterfaceBuilder_ == null) {
          ensureSnmpInterfaceIsMutable();
          snmpInterface_.set(index, builderForValue.build());
          onChanged();
        } else {
          snmpInterfaceBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .SnmpInterface snmp_interface = 12;</code>
       */
      public Builder addSnmpInterface(org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface value) {
        if (snmpInterfaceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSnmpInterfaceIsMutable();
          snmpInterface_.add(value);
          onChanged();
        } else {
          snmpInterfaceBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .SnmpInterface snmp_interface = 12;</code>
       */
      public Builder addSnmpInterface(
          int index, org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface value) {
        if (snmpInterfaceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSnmpInterfaceIsMutable();
          snmpInterface_.add(index, value);
          onChanged();
        } else {
          snmpInterfaceBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .SnmpInterface snmp_interface = 12;</code>
       */
      public Builder addSnmpInterface(
          org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface.Builder builderForValue) {
        if (snmpInterfaceBuilder_ == null) {
          ensureSnmpInterfaceIsMutable();
          snmpInterface_.add(builderForValue.build());
          onChanged();
        } else {
          snmpInterfaceBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .SnmpInterface snmp_interface = 12;</code>
       */
      public Builder addSnmpInterface(
          int index, org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface.Builder builderForValue) {
        if (snmpInterfaceBuilder_ == null) {
          ensureSnmpInterfaceIsMutable();
          snmpInterface_.add(index, builderForValue.build());
          onChanged();
        } else {
          snmpInterfaceBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .SnmpInterface snmp_interface = 12;</code>
       */
      public Builder addAllSnmpInterface(
          java.lang.Iterable<? extends org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface> values) {
        if (snmpInterfaceBuilder_ == null) {
          ensureSnmpInterfaceIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, snmpInterface_);
          onChanged();
        } else {
          snmpInterfaceBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .SnmpInterface snmp_interface = 12;</code>
       */
      public Builder clearSnmpInterface() {
        if (snmpInterfaceBuilder_ == null) {
          snmpInterface_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000800);
          onChanged();
        } else {
          snmpInterfaceBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .SnmpInterface snmp_interface = 12;</code>
       */
      public Builder removeSnmpInterface(int index) {
        if (snmpInterfaceBuilder_ == null) {
          ensureSnmpInterfaceIsMutable();
          snmpInterface_.remove(index);
          onChanged();
        } else {
          snmpInterfaceBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .SnmpInterface snmp_interface = 12;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface.Builder getSnmpInterfaceBuilder(
          int index) {
        return getSnmpInterfaceFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .SnmpInterface snmp_interface = 12;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterfaceOrBuilder getSnmpInterfaceOrBuilder(
          int index) {
        if (snmpInterfaceBuilder_ == null) {
          return snmpInterface_.get(index);  } else {
          return snmpInterfaceBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .SnmpInterface snmp_interface = 12;</code>
       */
      public java.util.List<? extends org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterfaceOrBuilder> 
           getSnmpInterfaceOrBuilderList() {
        if (snmpInterfaceBuilder_ != null) {
          return snmpInterfaceBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(snmpInterface_);
        }
      }
      /**
       * <code>repeated .SnmpInterface snmp_interface = 12;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface.Builder addSnmpInterfaceBuilder() {
        return getSnmpInterfaceFieldBuilder().addBuilder(
            org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface.getDefaultInstance());
      }
      /**
       * <code>repeated .SnmpInterface snmp_interface = 12;</code>
       */
      public org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface.Builder addSnmpInterfaceBuilder(
          int index) {
        return getSnmpInterfaceFieldBuilder().addBuilder(
            index, org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface.getDefaultInstance());
      }
      /**
       * <code>repeated .SnmpInterface snmp_interface = 12;</code>
       */
      public java.util.List<org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface.Builder> 
           getSnmpInterfaceBuilderList() {
        return getSnmpInterfaceFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface, org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface.Builder, org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterfaceOrBuilder> 
          getSnmpInterfaceFieldBuilder() {
        if (snmpInterfaceBuilder_ == null) {
          snmpInterfaceBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface, org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterface.Builder, org.opennms.features.kafka.producer.model.OpennmsModelProtos.SnmpInterfaceOrBuilder>(
                  snmpInterface_,
                  ((bitField0_ & 0x00000800) == 0x00000800),
                  getParentForChildren(),
                  isClean());
          snmpInterface_ = null;
        }
        return snmpInterfaceBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:Node)
    }

    // @@protoc_insertion_point(class_scope:Node)
    private static final org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node();
    }

    public static org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Node>
        PARSER = new com.google.protobuf.AbstractParser<Node>() {
      public Node parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Node(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Node> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Node> getParserForType() {
      return PARSER;
    }

    public org.opennms.features.kafka.producer.model.OpennmsModelProtos.Node getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_NodeCriteria_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_NodeCriteria_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_EventParameter_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_EventParameter_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Event_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_Event_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Alarm_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_Alarm_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_IpInterface_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_IpInterface_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_SnmpInterface_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_SnmpInterface_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Node_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_Node_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\034opennms-kafka-producer.proto\"F\n\014NodeCr" +
      "iteria\022\n\n\002id\030\001 \001(\004\022\026\n\016foreign_source\030\002 \001" +
      "(\t\022\022\n\nforeign_id\030\003 \001(\t\";\n\016EventParameter" +
      "\022\014\n\004name\030\001 \001(\t\022\r\n\005value\030\002 \001(\t\022\014\n\004type\030\003 " +
      "\001(\t\"\245\002\n\005Event\022\n\n\002id\030\001 \001(\004\022\013\n\003uei\030\002 \001(\t\022\r" +
      "\n\005label\030\003 \001(\t\022\014\n\004time\030\004 \001(\004\022\016\n\006source\030\005 " +
      "\001(\t\022\"\n\tparameter\030\006 \003(\0132\017.EventParameter\022" +
      "\023\n\013create_time\030\007 \001(\004\022\023\n\013description\030\010 \001(" +
      "\t\022\023\n\013log_message\030\t \001(\t\022\033\n\010severity\030\n \001(\016" +
      "2\t.Severity\022\013\n\003log\030\013 \001(\010\022\017\n\007display\030\014 \001(" +
      "\010\022$\n\rnode_criteria\030\r \001(\0132\r.NodeCriteria\022" +
      "\022\n\nip_address\030\016 \001(\t\"\263\004\n\005Alarm\022\n\n\002id\030\001 \001(" +
      "\004\022\013\n\003uei\030\002 \001(\t\022$\n\rnode_criteria\030\003 \001(\0132\r." +
      "NodeCriteria\022\022\n\nip_address\030\004 \001(\t\022\024\n\014serv" +
      "ice_name\030\005 \001(\t\022\025\n\rreduction_key\030\006 \001(\t\022\031\n" +
      "\004type\030\007 \001(\0162\013.Alarm.Type\022\r\n\005count\030\010 \001(\004\022" +
      "\033\n\010severity\030\t \001(\0162\t.Severity\022\030\n\020first_ev" +
      "ent_time\030\n \001(\004\022\023\n\013description\030\013 \001(\t\022\023\n\013l" +
      "og_message\030\014 \001(\t\022\020\n\010ack_user\030\r \001(\t\022\020\n\010ac" +
      "k_time\030\016 \001(\004\022\032\n\nlast_event\030\017 \001(\0132\006.Event" +
      "\022\027\n\017last_event_time\030\020 \001(\004\022\020\n\010if_index\030\021 " +
      "\001(\r\022\035\n\025operator_instructions\030\022 \001(\t\022\021\n\tcl" +
      "ear_key\030\023 \001(\t\022\037\n\027managed_object_instance" +
      "\030\024 \001(\t\022\033\n\023managed_object_type\030\025 \001(\t\"D\n\004T" +
      "ype\022\026\n\022PROBLEM_WITH_CLEAR\020\000\022\t\n\005CLEAR\020\001\022\031" +
      "\n\025PROBLEM_WITHOUT_CLEAR\020\002\"\275\001\n\013IpInterfac" +
      "e\022\n\n\002id\030\001 \001(\004\022\022\n\nip_address\030\002 \001(\t\022\020\n\010if_" +
      "index\030\003 \001(\r\022.\n\014primary_type\030\004 \001(\0162\030.IpIn" +
      "terface.PrimaryType\022\017\n\007service\030\005 \003(\t\";\n\013" +
      "PrimaryType\022\013\n\007PRIMARY\020\000\022\r\n\tSECONDARY\020\001\022" +
      "\020\n\014NOT_ELIGIBLE\020\002\"\317\001\n\rSnmpInterface\022\n\n\002i" +
      "d\030\001 \001(\004\022\020\n\010if_index\030\002 \001(\r\022\020\n\010if_descr\030\003 " +
      "\001(\t\022\017\n\007if_type\030\004 \001(\r\022\017\n\007if_name\030\005 \001(\t\022\020\n" +
      "\010if_speed\030\006 \001(\004\022\027\n\017if_phys_address\030\007 \001(\t" +
      "\022\027\n\017if_admin_status\030\010 \001(\r\022\026\n\016if_oper_sta" +
      "tus\030\t \001(\r\022\020\n\010if_alias\030\n \001(\t\"\227\002\n\004Node\022\n\n\002" +
      "id\030\001 \001(\004\022\026\n\016foreign_source\030\002 \001(\t\022\022\n\nfore" +
      "ign_id\030\003 \001(\t\022\020\n\010location\030\004 \001(\t\022\020\n\010catego" +
      "ry\030\005 \003(\t\022\r\n\005label\030\006 \001(\t\022\023\n\013create_time\030\007" +
      " \001(\004\022\023\n\013sys_contact\030\010 \001(\t\022\027\n\017sys_descrip" +
      "tion\030\t \001(\t\022\025\n\rsys_object_id\030\n \001(\t\022\"\n\014ip_" +
      "interface\030\013 \003(\0132\014.IpInterface\022&\n\016snmp_in" +
      "terface\030\014 \003(\0132\016.SnmpInterface*g\n\010Severit" +
      "y\022\021\n\rINDETERMINATE\020\000\022\013\n\007CLEARED\020\001\022\n\n\006NOR" +
      "MAL\020\002\022\013\n\007WARNING\020\003\022\t\n\005MINOR\020\004\022\t\n\005MAJOR\020\005" +
      "\022\014\n\010CRITICAL\020\006B?\n)org.opennms.features.k" +
      "afka.producer.modelB\022OpennmsModelProtosb" +
      "\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
        }, assigner);
    internal_static_NodeCriteria_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_NodeCriteria_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_NodeCriteria_descriptor,
        new java.lang.String[] { "Id", "ForeignSource", "ForeignId", });
    internal_static_EventParameter_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_EventParameter_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_EventParameter_descriptor,
        new java.lang.String[] { "Name", "Value", "Type", });
    internal_static_Event_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_Event_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_Event_descriptor,
        new java.lang.String[] { "Id", "Uei", "Label", "Time", "Source", "Parameter", "CreateTime", "Description", "LogMessage", "Severity", "Log", "Display", "NodeCriteria", "IpAddress", });
    internal_static_Alarm_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_Alarm_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_Alarm_descriptor,
        new java.lang.String[] { "Id", "Uei", "NodeCriteria", "IpAddress", "ServiceName", "ReductionKey", "Type", "Count", "Severity", "FirstEventTime", "Description", "LogMessage", "AckUser", "AckTime", "LastEvent", "LastEventTime", "IfIndex", "OperatorInstructions", "ClearKey", "ManagedObjectInstance", "ManagedObjectType", });
    internal_static_IpInterface_descriptor =
      getDescriptor().getMessageTypes().get(4);
    internal_static_IpInterface_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_IpInterface_descriptor,
        new java.lang.String[] { "Id", "IpAddress", "IfIndex", "PrimaryType", "Service", });
    internal_static_SnmpInterface_descriptor =
      getDescriptor().getMessageTypes().get(5);
    internal_static_SnmpInterface_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_SnmpInterface_descriptor,
        new java.lang.String[] { "Id", "IfIndex", "IfDescr", "IfType", "IfName", "IfSpeed", "IfPhysAddress", "IfAdminStatus", "IfOperStatus", "IfAlias", });
    internal_static_Node_descriptor =
      getDescriptor().getMessageTypes().get(6);
    internal_static_Node_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_Node_descriptor,
        new java.lang.String[] { "Id", "ForeignSource", "ForeignId", "Location", "Category", "Label", "CreateTime", "SysContact", "SysDescription", "SysObjectId", "IpInterface", "SnmpInterface", });
  }

  // @@protoc_insertion_point(outer_class_scope)
}
