/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.net.URI;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.command.FeaturesCommandSupport;

@Command(scope="features", name="addUrl", description="Adds a list of repository URLs to the features service.")
public class AddUrlCommand
extends FeaturesCommandSupport {
    @Argument(index=0, name="urls", description="One or more repository URLs separated by whitespaces", required=true, multiValued=true)
    List<String> urls;

    protected void doExecute(FeaturesService admin) throws Exception {
        for (String url : this.urls) {
            try {
                admin.addRepository(new URI(url));
            }
            catch (Exception e) {
                System.out.println("Could not add Feature Repository:\n" + e);
                System.out.println("Please verify that the feature repository URL is correct and that your network connection works fine.");
            }
        }
    }
}

